package org.weixvn.wae.manager;

import org.apache.http.HttpHost;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.params.ConnRouteParams;
import org.weixvn.wae.util.Utils;
import org.weixvn.wae.webpage.net.proxy.SelectProxyWebPage;
import org.weixvn.wae.webpage.net.proxy.SelectProxyWebPage.ProxyStatus;
import org.weixvn.wae.webpage.net.proxy.UpdataProxyUntil;
import org.weixvn.wae.webpage.net.proxy.UpdataUntil;

/**
 * 代理管理类
 * 
 * @author weixvn
 */
public class ProxyManager {
	/**
	 * 从网络获取代理
	 */
	public void getProxysData() {

		UpdataProxyUntil updataproxyuntil = new UpdataProxyUntil(EngineManager
				.getInstance().getContext());
		updataproxyuntil.updatamethod();

		UpdataUntil updatauntil = new UpdataUntil(EngineManager.getInstance()
				.getContext());
		updatauntil.updatamethod("startcheckversion");
	}

	/**
	 * 选择并设置代理 返回:true,代理选择成功或无需使用代理；false,代理选择失败
	 * 
	 * @return boolean 返回true:代理设置成功，false：代理设置失败，无代理可用
	 */
	public boolean setProxy() {
		boolean isProxyOk = true;

		// 检测是否可以不用代理而直接访问教务处(tmp == 0,则不须设置代理)
		int tmp = Utils.pingHost("jwc.swust.edu.cn");
		if (tmp != 0) {
			// 随机选择代理并测试代理是否可用
			while (true) {
				EngineManager.getInstance().getWebPageMannger()
						.updateWebPage(SelectProxyWebPage.class, false);

				ProxyStatus statusTmp = ((SelectProxyWebPage) EngineManager
						.getInstance().getWebPageMannger()
						.getWebPage(SelectProxyWebPage.class)).proxyStatus;
				if (statusTmp == ProxyStatus.OK // 选择代理成功
						|| statusTmp == ProxyStatus.NONE) {
					if (statusTmp == ProxyStatus.NONE) // 所有代理服务器皆不可使用
						isProxyOk = false;
					break;
				}
			}
		}
		return isProxyOk;
	}

	/**
	 * 设置代理
	 * 
	 * @param domain
	 *            代理域名
	 * @param port
	 *            代理端口
	 */
	public void setProxy(String domain, int port) {

		HttpHost proxy = new HttpHost(domain, port);
		((HttpClient) EngineManager.getInstance().getWebPageMannger()
				.getHttpClient().getHttpClient()).getParams().setParameter(
				ConnRouteParams.DEFAULT_PROXY, proxy);
	}
}
