package org.weixvn.wae.webpage.net;

import java.io.IOException;
import java.io.InputStream;

import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpResponseException;

import android.os.Message;

import com.loopj.android.http.AsyncHttpResponseHandler;

/**
 * 处理WebPage页面的接口
 * 
 * @author weixvn
 */
public class WebPageHandler extends AsyncHttpResponseHandler {

	// Pre-processing of messages (executes in background threadpool thread)
	final protected void sendSuccessMessage(int statusCode, String responseBody) {
		onSuccess(responseBody);
	}

	final protected void sendSuccessMessage(String responseBody) {
		onSuccess(responseBody);
	}

	final protected void handleSuccessMessage(String responseBody) {
		onSuccess(responseBody);
	}

	final protected void sendFailureMessage(Throwable e, String responseBody) {
		onFailure(e, responseBody);
	}

	final protected void sendFailureMessage(Throwable e, byte[] responseBody) {
		onFailure(e, responseBody.toString());
	}

	final protected void sendStartMessage() {

	}

	final protected void sendFinishMessage() {
		onFinish();
	}

	@Override
	final protected void handleFailureMessage(Throwable arg0, String arg1) {

	}

	@Override
	final protected void handleMessage(Message arg0) {

	}

	@Override
	final protected Message obtainMessage(int arg0, Object arg1) {
		return super.obtainMessage(arg0, arg1);
	}

	@Override
	final protected void sendMessage(Message arg0) {

	}

	@Override
	final public void onFailure(Throwable arg0, String arg1) {

	}

	@Override
	final public void onSuccess(String responseBody) {

	}

	@Override
	public void onFailure(Throwable arg0) {

	}

	@Override
	public void onFinish() {

	}

	@Override
	public void onStart() {

	}

	/**
	 * 网页请求失败
	 * 
	 * @param arg0
	 *            抛出的异常
	 * @param in
	 *            返回的html数据
	 */
	public void onFailure(Throwable arg0, InputStream in) {

	}

	/**
	 * 网页请求成功
	 * 
	 * @param in
	 *            返回的Html网页{@link InputStream}
	 */
	public void onSuccess(InputStream in) {

	}

	// Interface to AsyncHttpRequest
	protected void sendResponseMessage(HttpResponse response) {
		StatusLine status = response.getStatusLine();
		InputStream responseBody = null;
		try {
			responseBody = response.getEntity().getContent();
		} catch (IOException e) {
			sendFailureMessage(e, (String) null);
		}

		if (status.getStatusCode() >= 300) {
			onFailure(
					new HttpResponseException(status.getStatusCode(),
							status.getReasonPhrase()), responseBody);
		} else {
			onSuccess(responseBody);
		}

		try {
			responseBody.close();
		} catch (IOException e) {
			e.printStackTrace();
		}

	}
}
