package org.weixvn.wae.webpage.net.proxy;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import android.annotation.SuppressLint;
import android.app.AlertDialog;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.DialogInterface.OnClickListener;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Environment;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import android.widget.Button;
import android.widget.Toast;

public class UpdataUntil {

	String checkflag = "";
	static HttpURLConnection conn;
	public String dowmloadurl = "";
	public static final int GET_UNDATAINFO_ERROR = 0;
	public static final int UPDATA_CLIENT = 1;

	/** Called when the activity is first created. */

	long lastUpdateTime;
	public static final int DOWN_ERROR = 2;
	public static final int DOTO_UPDATE = 3;

	public static String TAG = "update";
	private static InputStream is;
	private static FileOutputStream fos;
	private static BufferedInputStream bis;

	String currentversion = "";

	public UpdataInfo info;

	public Button button;

	Context context;

	ProgressDialog progressDialog;

	public UpdataUntil(Context context) {
		this.context = context;
		progressDialog = new ProgressDialog(context);
		progressDialog.setTitle("正在检测版本信息");
		progressDialog.setProgressStyle(ProgressDialog.STYLE_SPINNER);
	}

	public void updatamethod(String str) {

		this.checkflag = str;

		try {

			currentversion = getVersionName();

		} catch (Exception e) {

			// TODO Auto-generated catch block

			e.printStackTrace();

		}

		if (!checkflag.equals("startcheckversion")) {
			progressDialog.show();
		}

		Thread thread = new Thread(new CheckVersionTask());
		thread.start();

	}

	/*
	 * 获取当前程序的版本号
	 */
	private String getVersionName() throws Exception {

		// 获取packagemanager的实例
		PackageManager packageManager = context.getPackageManager();
		// getPackageName()是你当前类的包名，0代表是获取版本信息
		PackageInfo packInfo = packageManager.getPackageInfo(
				context.getPackageName(), 0);
		return packInfo.versionName;

	}

	// 获取服务器端的版本号：
	/*
	 * 用pull解析器解析服务器返回的xml文件 (xml封装了版本号)
	 */
	public static UpdataInfo getUpdataInfo(InputStream is) throws Exception {

		// 实体
		UpdataInfo info = new UpdataInfo();
		// 创建DocumentBuilderFactory，该对象将创建DocumentBuilder。
		DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
		// 创建DocumentBuilder，DocumentBuilder将实际进行解析以创建Document对象
		DocumentBuilder builder = factory.newDocumentBuilder();
		// 解析该文件以创建Document对象
		Document document = builder.parse(is);
		// 获取XML文件根节点
		Element root = document.getDocumentElement();

		// 获得所有子节点
		NodeList childNodes = root.getChildNodes();
		for (int i = 0; i < childNodes.getLength(); i++) {
			Node childNode = (Node) childNodes.item(i);
			if (childNode.getNodeType() == Node.ELEMENT_NODE) {
				Element childElement = (Element) childNode;
				// 版本号
				if ("version".equals(childElement.getNodeName())) {
					info.setVersion(childElement.getFirstChild().getNodeValue());
					Log.e("version", childElement.getFirstChild()
							.getNodeValue());
					// 软件名称
				} else if ("name".equals(childElement.getNodeName())) {

					info.setName(childElement.getFirstChild().getNodeValue());
					Log.e("name", childElement.getFirstChild().getNodeValue());

					// 下载地址
				} else if ("url".equals(childElement.getNodeName())) {

					info.setDownloadurl(childElement.getFirstChild()
							.getNodeValue());

					Log.e("url", childElement.getFirstChild().getNodeValue());
				}

			}
		}

		return info;
	}

	// 从服务器下载apk:
	public static File getFileFromServer(String path, ProgressDialog pd)
			throws Exception {

		// 如果相等的话表示当前的sdcard挂载在手机上并且是可用的

		if (Environment.getExternalStorageState().equals(
				Environment.MEDIA_MOUNTED)) {

			URL url = new URL(path);

			conn = (HttpURLConnection) url.openConnection();

			conn.setConnectTimeout(5000);
			// 获取到文件的大小
			pd.setMax(conn.getContentLength());
			is = conn.getInputStream();

			File file = new File(Environment.getExternalStorageDirectory()
					+ "/Aide/校务助手.apk");

			fos = new FileOutputStream(file);
			bis = new BufferedInputStream(is);
			byte[] buffer = new byte[1024];
			int len;
			int total = 0;
			while ((len = bis.read(buffer)) != -1) {
				fos.write(buffer, 0, len);
				total += len;
				// 获取当前下载量
				pd.setProgress(total);
			}
			fos.close();
			bis.close();
			is.close();
			return file;
		} else {
			return null;
		}
	}

	// 取消下載
	public static void cancelDownload() {

		try {
			fos.close();
			bis.close();
			is.close();
			File file = new File(Environment.getExternalStorageDirectory()
					+ "/Aide/校务助手.apk");
			file.delete();

		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

	}

	@SuppressLint("HandlerLeak")
	Handler handler = new Handler() {
		@Override
		public void handleMessage(Message msg) {
			// TODO Auto-generated method stub
			super.handleMessage(msg);
			switch (msg.what) {
			case DOTO_UPDATE:
				if (!checkflag.equals("startcheckversion")) {
					Toast.makeText(context.getApplicationContext(),
							"已经是最新版本，不需要更新", Toast.LENGTH_LONG).show();
				}
				break;
			case UPDATA_CLIENT:
				// 对话框通知用户升级程序
				showUpdataDialog();
				break;
			case GET_UNDATAINFO_ERROR:

				if (!checkflag.equals("startcheckversion")) {
					// 服务器超时
					Toast.makeText(context.getApplicationContext(),
							"获取服务器更新信息失败", Toast.LENGTH_LONG).show();
				}
				break;
			case DOWN_ERROR:
				// 下载apk失败
				Toast.makeText(context.getApplicationContext(), "下载新版本失败",
						Toast.LENGTH_LONG).show();
				break;
			}
		}
	};

	/*
	 * 
	 * 弹出对话框通知用户更新程序
	 * 
	 * 弹出对话框的步骤： 1.创建alertDialog的builder. 2.要给builder设置属性, 对话框的内容,样式,按钮
	 * 3.通过builder 创建一个对话框 4.对话框show()出来
	 */
	protected void showUpdataDialog() {

		AlertDialog dialog = new AlertDialog.Builder(context).setTitle("版本升级")
				.setMessage("  升级到 " + info.getVersion() + " 版本？")
				.setPositiveButton("是", new DialogInterface.OnClickListener() {
					// 当点确定按钮时从服务器上下载 新的ape 然后安装
					@Override
					public void onClick(DialogInterface dialog, int which) {
						// TODO Auto-generated method stub
						Log.e(TAG, "下载apk,更新");
						downLoadApk();

					}

				})

				.setNegativeButton("否", new DialogInterface.OnClickListener() {
					// 当点取消按钮时进行登录
					@Override
					public void onClick(DialogInterface dialog, int which) {
						// TODO Auto-generated method stub
						// LoginMain();

					}
				}).create();

		dialog.show();

	}

	/*
	 * 从服务器中下载APK
	 */

	@SuppressWarnings("deprecation")
	protected void downLoadApk() {
		final ProgressDialog pd; // 进度条对话框

		pd = new ProgressDialog(context);

		pd.setProgressStyle(ProgressDialog.STYLE_HORIZONTAL);

		pd.setMessage("正在下载更新");

		pd.setButton("取消", new OnClickListener() {

			@Override
			public void onClick(DialogInterface dialog, int which) {
				// TODO Auto-generated method stub
				UpdataUntil.cancelDownload();
				Toast.makeText(context, "下载取消！", Toast.LENGTH_SHORT).show();

				Log.e("progressDialog", "点击取消");

			}
		});

		pd.show();

		new Thread() {

			@Override
			public void run() {
				InputStream in = null;
				try {

					File file = UpdataUntil.getFileFromServer(
							info.getDownloadurl(), pd);

					installApk(file);

					pd.dismiss(); // 结束掉进度条对话框

				} catch (Exception e) {

					Message msg = new Message();
					msg.what = DOWN_ERROR;
					handler.sendMessage(msg);
					e.printStackTrace();
				} finally {
					if (in != null) {
						try {
							in.close();
						} catch (IOException e) {
							// TODO Auto-generated catch block
							e.printStackTrace();
						}
					}
				}

			}
		}.start();

	}

	// 安装apk
	protected void installApk(File file) {
		Intent intent = new Intent();
		// 执行动作
		intent.setAction(Intent.ACTION_VIEW);

		// 执行的数据类型
		intent.setDataAndType(Uri.fromFile(file),
				"application/vnd.android.package-archive");// 编者按：此处Android应为android，否则造成安装不了

		context.startActivity(intent);

	}

	/*
	 * 从服务器获取xml解析并进行比对版本号
	 */

	public class CheckVersionTask implements Runnable {

		@Override
		public void run() {
			try {

				String path = "http://aide.googlecode.com/svn/trunk/document/update.xml";

				// 包装成url的对象

				File file = Decryp.decryption(path,
						Environment.getExternalStorageDirectory() + "/Aide",
						"/update.xml");
				info = getUpdataInfo(new FileInputStream(file));

				// file.delete();

				progressDialog.dismiss();

				String version = info.getVersion();

				// //System.out.println(version);

				if (version.equals(currentversion)) {

					Log.e(TAG, "版本号相同无需升级");
					Message msg = new Message();
					msg.what = DOTO_UPDATE;
					handler.sendMessage(msg);

				} else {

					Log.e(TAG, "版本号不同 ,提示用户升级 ");
					Message msg = new Message();
					msg.what = UPDATA_CLIENT;
					handler.sendMessage(msg);
				}

			} catch (Exception e) {
				progressDialog.dismiss();
				// 待处理
				Message msg = new Message();
				msg.what = GET_UNDATAINFO_ERROR;
				handler.sendMessage(msg);
				e.printStackTrace();
			}

		}

	}
}
