package org.weixvn.wae.webpage.net.proxy;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

import org.apache.http.HttpHost;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.params.ConnRouteParams;
import org.jsoup.nodes.Document;
import org.weixvn.wae.manager.EngineManager;
import org.weixvn.wae.webpage.WebPage;

import android.content.pm.PackageManager.NameNotFoundException;

/**
 * SelectProxyWebPage页面用于随机选择代理并测试代理是否可用(通过测试教务处欢迎界面实现)
 * <p>
 * 若代理不可用,则本类中只有onStart(),onFinish()被调用
 * 
 * @author root
 * 
 */
public class SelectProxyWebPage extends WebPage {

	public enum ProxyStatus {
		OK, // 代理选择成功
		FAILED, // 当前代理失败
		ERROR, // 网络错误
		NONE // 没有可用代理
	};

	public ProxyStatus proxyStatus = ProxyStatus.NONE;
	List<String> listProxys = null;
	int proxyno = -1;

	/*
	 * (non-Javadoc)
	 * 
	 * @see edu.swust.aide.model.WebPage#onStart()
	 */
	@Override
	public void onStart() {
		this.uri = "http://202.115.175.175/StuExpbook/";
		this.type = RequestType.GET;
		if (listProxys == null || listProxys.size() == 0) {

			List<String> proxyinfo = null;
			try { // 从主程序查找代理
				proxyinfo = EngineManager.getInstance().getWaeSupport()
						.getProxy();
			} catch (NameNotFoundException e) {
				e.printStackTrace();
			}
			if (proxyinfo != null) {
				listProxys = proxyinfo;
			} else { // 从google svn添加黙认代理
				listProxys = new ArrayList<String>();
				listProxys.add("liconglei.oicp.net:11265");
			}
		}

		// 随机设置代理
		Random rnd = new Random();
		proxyno = Math.abs(rnd.nextInt()) % listProxys.size();
		String[] tmpProxy = listProxys.get(proxyno).split(":");
		HttpHost proxy = new HttpHost(tmpProxy[0],
				Integer.parseInt(tmpProxy[1]));
		((HttpClient) EngineManager.getInstance().getWebPageMannger()
				.getHttpClient().getHttpClient()).getParams().setParameter(
				ConnRouteParams.DEFAULT_PROXY, proxy);
		proxyStatus = ProxyStatus.NONE;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see edu.swust.aide.model.WebPage#onSuccess(java.io.InputStream)
	 */
	@Override
	public void onSuccess(InputStream html) {
		proxyStatus = ProxyStatus.OK;
	}

	@Override
	public void onFailure(Throwable arg0) {
		proxyStatus = ProxyStatus.ERROR;
		super.onFailure(arg0);
	}

	@Override
	public void onFinish() {
		if (proxyStatus != ProxyStatus.OK && proxyStatus != ProxyStatus.ERROR) { // 本次选择的代理不可用
			if (proxyno != -1)
				listProxys.remove(proxyno); // 将本次选择的代理从List中移除
			if (listProxys.size() == 0) {
				proxyStatus = ProxyStatus.NONE; // 经测试所有代理皆不可用
			} else {
				proxyStatus = ProxyStatus.FAILED; // 访问网络失败,与代理无关
			}
		}
		super.onFinish();
	}

	@Override
	public void onFailure(Throwable arg0, InputStream in) {
		proxyStatus = ProxyStatus.ERROR;
		super.onFailure(arg0, in);
	}

	@Override
	public void onSuccess(Document html) {

	}

}
