package org.weixvn.wae.support.catchbug;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteDatabase.CursorFactory;
import android.database.sqlite.SQLiteOpenHelper;

public class FrameDatabaseHelper extends SQLiteOpenHelper {

	private static int VERSION = 1;

	public FrameDatabaseHelper(Context context, String name,
			CursorFactory factory, int version) {
		super(context, name, factory, version);
	}

	public FrameDatabaseHelper(Context context, String name, int version) {
		super(context, name, null, version);
	}

	@Override
	public void onCreate(SQLiteDatabase db) {

		// 学校表
		String CreateTable_School_info = "create table School_info(School_id  int primary key,"
				+ "School_chinesename varchar(50));";
		// 代理列表
		String CreateTable_Proxy_info = "create table Proxy_info(Proxy_id int primary key,"
				+ "Proxy_system_id int,Proxy_domain varchar(50),Proxy_port int,Proxy_username varchar(20),"
				+ "Proxy_password varchar(20));";
		// 用户信息表
		String CreateTable_User_info = "create table User_info(User_id int primary key,"
				+ "School_id int,User_nickname varchar(20),User_password varchar(20),"
				+ "User_email varchar(30),User_picture varchar(200),User_QQnumber varchar(20),"
				+ "User_name varchar(20),User_sex tinyint,User_specialty varchar(30),User_class varchar(20),"
				+ "User_address varchar(100),User_tel varchar(20), User_birthday dateTime,"
				+ "User_hometown varchar(100), User_registrationtime dateTime);";
		// 用户插件列表信息表
		String CreateTable_UserPlugin = "create table UserPlugin(User_id int,Plugin_id int,"
				+ "UserPlugin_version int,primary key(User_id,Plugin_id));";
		// 用户定制信息列表
		String CreateTable_UserCustomize = "create table UserCustomize(UserCustomize_id int primary key,"
				+ "User_id int,InformationType _id int);";
		// 用户系统信息表
		String CreateTable_UserSystem = "create table UserSystem(User_id int,System_id int,"
				+ "UserSystem_username varchar(20),UserSystem_userpassword varchar(20),"
				+ "UserSystem_mark varchar(20),primary key(User_id,System_id));";

		db.execSQL(CreateTable_School_info);
		db.execSQL(CreateTable_Proxy_info);
		db.execSQL(CreateTable_User_info);
		db.execSQL(CreateTable_UserPlugin);
		db.execSQL(CreateTable_UserCustomize);
		db.execSQL(CreateTable_UserSystem);
	}

	@Override
	public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {

	}

}
