package org.weixvn.wae.support;

import java.util.Map;

/**
 * 获取到登陆信息的(用户名、密码、验证码)监听器.
 * 
 * <pre>
 * <br>开发者要创建一个类，并实现该接口。复写{@link #onReceiveLoginInfo}方法，
 * 该方法由WAE SDK自动调用，用来向开发者返回主框架的登陆界面用户输入的登陆信息。
 * @author weixvn
 * 
 */
public interface OnReceiveLoginInfoListenter {

	/**
	 * 此方法用于接收用户输入的登陆信息。 <br>
	 * 由WAE SDK自动调用此方法,并向开发者返回主框架登陆界面用户输入的登陆信息。 <br>
	 * 
	 * <pre>
	 * 使用方法：<br>
	 * String id = info.get("id");	// 获取用户校园系统帐号，一般为学号(id)
	 * String passw = info.get("password"); // 获取用户校园系统密码(passw)
	 * String veriCode = info.get("veriCode");	// 获取用户输入的验证码(veriCode)
	 * 
	 * <pre>
	 * @param info	主框架返回的用户输入的登陆信息，如帐号、密码、验证码
	 */
	public void onReceiveLoginInfo(Map<String, String> info);
}
