package org.weixvn.wae.support;

import java.io.InputStream;

import org.jsoup.nodes.Document;
import org.weixvn.wae.manager.EngineManager;
import org.weixvn.wae.webpage.WebPage;

import android.graphics.drawable.Drawable;

/**
 * 此类仅为WAE SDK使用，用于获取验证码。开发者无需关心。
 * 
 * @author weixvn
 * 
 */
public class GetVerificationCode extends WebPage {

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.weixvn.wae.webpage.WebPage#onStart()
	 */
	@Override
	public void onStart() {

		this.uri = this.getHtmlValue("veriCodeUri");
		this.type = RequestType.GET;
		this.params = getParams();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.weixvn.wae.webpage.WebPage#onSuccess(org.jsoup.nodes.Document)
	 */
	@Override
	public void onSuccess(Document html) {

	}

	@Override
	public void onSuccess(InputStream html) {
		// 获取验证码图片
		Drawable veriCode = Drawable.createFromStream(html, "bdlogo.gif");
		// 把验证码图片传给WAESupport类
		EngineManager.getInstance().getWaeSupport()
				.setVerificationCode(veriCode);
	}

	@Override
	public void onFailure(Throwable arg0) {
		super.onFailure(arg0);
	}

	@Override
	public void onFinish() {
		super.onFinish();
	}

	@Override
	public void onFailure(Throwable arg0, InputStream in) {
		super.onFailure(arg0, in);
	}

}
