package org.weixvn.wae.manager;

import org.weixvn.wae.storage.DatabaseHelper;
import org.weixvn.wae.support.WAESupport;
import org.weixvn.wae.support.catchbug.CrashHandler;
import org.weixvn.wae.webpage.WebPageMannger;

import android.content.Context;
import android.util.Log;

/**
 * WAE的引擎管理类，管理所有程序中可支配的管理器。
 * 
 * @author weixvn
 */
public class EngineManager {
	private Context context;
	private WebPageMannger wfMgr;
	private DatabaseHelper db;
	private ProxyManager pm;
	private WAESupport waeSupport;

	private static EngineManager instance = null;

	private EngineManager() {
		this.wfMgr = null;
		this.pm = null;
		this.waeSupport = null;
	}

	/**
	 * 获取引擎管理器实例
	 * 
	 * @return 引擎管理器EngineManager的实例
	 */
	public static EngineManager getInstance() {
		if (instance == null) {
			instance = new EngineManager();
		}
		return instance;
	}

	/**
	 * 传入插件程序的主Context（通过Activity的getApplicationContext()获得） <br>
	 * 调用完此方法后，才能调用setDB()方法，否则数据库无法使用.
	 * 
	 * @param context
	 * @return {@link EngineManager}
	 */
	public EngineManager setContext(Context context) {
		this.context = context;
		// 抓取未获取的bug
		CrashHandler crashHandler = CrashHandler.getInstance();
		// crashHandler.init(context);
		return instance;
	}

	/**
	 * 获取应用程序通过setContext(Context context)传入的上下文件环境
	 * 
	 * @return Context 应用程序上下文件环境
	 */
	public Context getContext() {
		return this.context;
	}

	/**
	 * 取得数据库实例
	 * 
	 * @return {@link DatabaseHelper}
	 */
	public DatabaseHelper getDB() {
		if (this.db == null) {
			Log.e(EngineManager.class.getName(),
					"The DatabaseHelper hasn't been instantiated!");
		}
		return this.db;
	}

	/**
	 * 传入已实现的DatabaseHelper的子类
	 * 
	 * @param db
	 *            DatabaseHelper
	 * @return {@link EngineManager}
	 */
	public EngineManager setDB(DatabaseHelper db) {
		this.db = db;
		return instance;
	}

	/**
	 * 得到网页管理器
	 * 
	 * @return {@link WebPageMannger}
	 */
	public WebPageMannger getWebPageMannger() {
		if (this.wfMgr == null)
			this.wfMgr = new WebPageMannger();
		return this.wfMgr;
	}

	/**
	 * 得到代理器管理器
	 * 
	 * @return ProxyManager
	 */
	public ProxyManager getProxyManager() {
		if (this.pm == null) {
			this.pm = new ProxyManager();
		}
		return this.pm;
	}

	/**
	 * 得到WAE支持服务
	 * 
	 * @return WAESupport WAE提供的支持服务{@link WAESupport}
	 */
	public WAESupport getWaeSupport() {
		if (this.waeSupport == null) {
			this.waeSupport = new WAESupport();
		}
		return this.waeSupport;
	}
}
