package com.szu.accountsoft.dao;

import java.util.ArrayList;
import java.util.List;

import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;

import com.szu.accountsoft.model.*;

public class OutaccountDAO {
	private DBOpenHelper helper;// DBOpenHelper
	private SQLiteDatabase db;// SQLiteDatabase

	public OutaccountDAO(Context context)// 幹캯
	{
		helper = new DBOpenHelper(context);// ʼDBOpenHelper
	}

	/**
	 * ֧Ϣ
	 * 
	 * @param tb_outaccount
	 */
	public void add(Tb_outaccount tb_outaccount) {
		db = helper.getWritableDatabase();// ʼSQLiteDatabase
		// ִ֧Ϣ
		db.execSQL(
				"insert into tb_outaccount (money, amount, time, type, address, mark) values (?,?,?,?,?,?)",
				new Object[] { 
						tb_outaccount.getMoney(),
						tb_outaccount.getAmount(),
						tb_outaccount.getTime(), 
						tb_outaccount.getType(),
						tb_outaccount.getAddress(), 
						tb_outaccount.getMark() 
						});
		
		System.out.println("ݿDAO\n"+tb_outaccount.getMoney()+"\n"+
				""+tb_outaccount.getAmount()+"\n"+
				"ʱ䣺"+tb_outaccount.getTime()+"\n"+
				"ͣ"+tb_outaccount.getType()+"\n"+
				"ַ"+tb_outaccount.getAddress()+"\n"+
				"ע"+tb_outaccount.getMark() );
	}

	/**
	 * ֧Ϣ
	 * 
	 * @param tb_outaccount
	 */
	public void update(Tb_outaccount tb_outaccount) {
		db = helper.getWritableDatabase();// ʼSQLiteDatabase
		// ִ޸֧Ϣ
		db.execSQL(
				"update tb_outaccount set money = ?,amount = ?, time = ?,type = ?,address = ?,mark = ? where _id = ?",
				
				new Object[] { 
						tb_outaccount.getMoney(),
						tb_outaccount.getAmount(),
						tb_outaccount.getTime(), 
						tb_outaccount.getType(),
						tb_outaccount.getAddress(), 
						tb_outaccount.getMark(),
						tb_outaccount.getid() });
	}
	

	/**
	 * ֧Ϣ
	 * 
	 * @param id
	 * @return
	 */
	public Tb_outaccount find(int id) {
		db = helper.getWritableDatabase();// ʼSQLiteDatabase
		Cursor cursor = db
				.rawQuery(
						"select _id,money,amount,time,type,address,mark from tb_outaccount where _id = ?",
						
						new String[] { String.valueOf(id) });// ݱŲ֧Ϣ洢Cursor
		if (cursor.moveToNext())// ҵ֧Ϣ
		{
			// ֧Ϣ洢Tb_outaccount
			return new Tb_outaccount(
					cursor.getDouble(cursor.getColumnIndex("money")),
					cursor.getInt(cursor.getColumnIndex("amount")),
					cursor.getString(cursor.getColumnIndex("time")),
					cursor.getString(cursor.getColumnIndex("type")),
					cursor.getString(cursor.getColumnIndex("address")),
					cursor.getString(cursor.getColumnIndex("mark")));
		}
		return null;// ûϢ򷵻null
	}

	/**
	 * h֧Ϣ
	 * 
	 * @param ids
	 */
	public void detele(Integer... ids) {
		if (ids.length > 0)// жǷҪɾid
		{
			StringBuffer sb = new StringBuffer();// StringBuffer
			for (int i = 0; i < ids.length; i++)// Ҫɾid
			{
				sb.append('?').append(',');// ɾӵStringBuffer
			}
			sb.deleteCharAt(sb.length() - 1);// ȥһ,ַ
			db = helper.getWritableDatabase();// ʼSQLiteDatabase
			// ִɾ֧Ϣ
			db.execSQL("delete from tb_outaccount where _id in (" + sb + ")",
					(Object[]) ids);
		}
	}

	/**
	 * ȡ֧Ϣ
	 * 
	 * @param start
	 *            ʼλ
	 * @param count
	 *            ÿҳʾ
	 * @return
	 */
	public List<Tb_outaccount> getScrollData(int start, int count) {
		List<Tb_outaccount> tb_outaccount = new ArrayList<Tb_outaccount>();// ϶
		db = helper.getWritableDatabase();// ʼSQLiteDatabase
		// ȡ֧Ϣ
		Cursor cursor = db.rawQuery("select * from tb_outaccount limit ?,?",
				new String[] { String.valueOf(start), String.valueOf(count) });
		while (cursor.moveToNext())// е֧Ϣ
		{
			// ֧Ϣӵ
			tb_outaccount.add(new Tb_outaccount(
					cursor.getDouble(cursor.getColumnIndex("money")), 
					cursor.getInt(cursor.getColumnIndex("amount")), 
					cursor.getString(cursor.getColumnIndex("time")), 
					cursor.getString(cursor.getColumnIndex("type")), 
					cursor.getString(cursor.getColumnIndex("address")), 
					cursor.getString(cursor.getColumnIndex("mark"))));
		}
		return tb_outaccount;// ؼ
	}

	/**
	 * ȡܼ¼
	 * 
	 * @return
	 */
	public long getCount() {
		db = helper.getWritableDatabase();// ʼSQLiteDatabase
		Cursor cursor = db.rawQuery("select count(_id) from tb_outaccount",
				null);// ȡ֧Ϣļ¼
		if (cursor.moveToNext())// жCursorǷ
		{
			return cursor.getLong(0);// ܼ¼
		}
		return 0;// ûݣ򷵻0
	}

	/**
	 * ȡ֧
	 * 
	 * @return
	 */
	public int getMaxId() {
		db = helper.getWritableDatabase();// ʼSQLiteDatabase
		Cursor cursor = db.rawQuery("select max(_id) from tb_outaccount", null);// ȡ֧Ϣе
		while (cursor.moveToLast()) {// Cursorеһ
			return cursor.getInt(0);// ȡʵݣ
		}
		return 0;// ûݣ򷵻0
	}
}
