package com.szu.accountsoft.dao;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import com.szu.accountsoft.model.*;

public class InaccountDAO {
	private DBOpenHelper helper;// DBOpenHelper
	private SQLiteDatabase db;// SQLiteDatabase

	public InaccountDAO(Context context)// 幹캯
	{
		helper = new DBOpenHelper(context);// ʼDBOpenHelper
	}

	/**
	 * Ϣ
	 * 
	 * @param tb_inaccount
	 */
	public void add(Tb_inaccount tb_inaccount) {
		db = helper.getWritableDatabase();// ʼSQLiteDatabase
		// ִϢ
		db.execSQL(
				"insert into tb_inaccount (" +
				"money, " +
				"time, " +
				"type, " +
				"handler, " +
				"mark) " +
				"values " +
				"(?,?,?,?,?)",
				new Object[] { 
						tb_inaccount.getMoney(),
						tb_inaccount.getTime(), tb_inaccount.getType(),
						tb_inaccount.getHandler(), tb_inaccount.getMark()});
	}
	
	

	/**
	 * Ϣ
	 * 
	 * @param tb_inaccount
	 */
	public void update(Tb_inaccount tb_inaccount) {
		db = helper.getWritableDatabase();// ʼSQLiteDatabase
		// ִ޸Ϣ
		db.execSQL(
				"update tb_inaccount set money = ?,time = ?,type = ?,handler = ?,mark = ? where _id = ?",
				new Object[] { tb_inaccount.getMoney(), tb_inaccount.getTime(),
						tb_inaccount.getType(), tb_inaccount.getHandler(),
						tb_inaccount.getMark(), tb_inaccount.getid() });
	}

	/**
	 * Ϣ
	 * 
	 * @param id
	 * @return
	 */
	public Tb_inaccount find(int id) {
		db = helper.getWritableDatabase();// ʼSQLiteDatabase
		Cursor cursor = db
				.rawQuery(
						"select _id,money,time,type,handler,mark from tb_inaccount where _id = ?",
						new String[] { String.valueOf(id) });// ݱŲϢ洢Cursor
		if (cursor.moveToNext())// ҵϢ
		{
			// Ϣ洢Tb_inaccount
			return new Tb_inaccount(
					cursor.getDouble(cursor.getColumnIndex("money")),
					cursor.getString(cursor.getColumnIndex("time")),
					cursor.getString(cursor.getColumnIndex("type")),
					cursor.getString(cursor.getColumnIndex("handler")),
					cursor.getString(cursor.getColumnIndex("mark")));
		}
		return null;// ûϢ򷵻null
	}

	/**
	 * hϢ
	 * 
	 * @param ids
	 */
	public void detele(Integer... ids) {
		if (ids.length > 0)// жǷҪɾid
		{
			StringBuffer sb = new StringBuffer();// StringBuffer
			for (int i = 0; i < ids.length; i++)// Ҫɾid
			{
				sb.append('?').append(',');// ɾӵStringBuffer
			}
			sb.deleteCharAt(sb.length() - 1);// ȥһ,ַ
			db = helper.getWritableDatabase();// ʼSQLiteDatabase
			// ִɾϢ
			db.execSQL("delete from tb_inaccount where _id in (" + sb + ")",
					(Object[]) ids);
		}
	}

	/**
	 * ȡϢ
	 * 
	 * @param start
	 *            ʼλ
	 * @param count
	 *            ÿҳʾ
	 * @return
	 */
	public List<Tb_inaccount> getScrollData(int start, int count) {
		List<Tb_inaccount> tb_inaccount = new ArrayList<Tb_inaccount>();// ϶
		db = helper.getWritableDatabase();// ʼSQLiteDatabase
		// ȡϢ
		Cursor cursor = db.rawQuery("select * from tb_inaccount limit ?,?;",
				new String[] { String.valueOf(start), String.valueOf(count) });
		
		while (cursor.moveToNext())// еϢ
		{
			// Ϣӵ
			tb_inaccount.add(new Tb_inaccount(
					cursor.getDouble(cursor.getColumnIndex("money")), 
					cursor.getString(cursor.getColumnIndex("time")), 
					cursor.getString(cursor.getColumnIndex("type")),
					cursor.getString(cursor.getColumnIndex("handler")), 
					cursor.getString(cursor.getColumnIndex("mark"))));
		}
		return tb_inaccount;// ؼ
		

	}

	/**
	 * ȡܼ¼
	 * 
	 * @return
	 */
	public long getCount() {
		db = helper.getWritableDatabase();// ʼSQLiteDatabase
		Cursor cursor = db
				.rawQuery("select count(_id) from tb_inaccount", null);// ȡϢļ¼
		if (cursor.moveToNext())// жCursorǷ
		{
			return cursor.getLong(0);// ܼ¼
		}
		return 0;// ûݣ򷵻0
	}

	/**
	 * ȡ
	 * 
	 * @return
	 */
	public int getMaxId() {
		db = helper.getWritableDatabase();// ʼSQLiteDatabase
		Cursor cursor = db.rawQuery("select max(_id) from tb_inaccount", null);// ȡϢе
		while (cursor.moveToLast()) {// Cursorеһ
			return cursor.getInt(0);// ȡʵݣ
		}
		return 0;// ûݣ򷵻0
	}
}
