package com.szu.accountsoft.dao;

import java.util.ArrayList;
import java.util.List;

import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import com.szu.accountsoft.model.*;

public class FlagDAO {
	private DBOpenHelper helper;// DBOpenHelper
	private SQLiteDatabase db;// SQLiteDatabase

	public FlagDAO(Context context)// 幹캯
	{
		helper = new DBOpenHelper(context);// ʼDBOpenHelper
	}

	/**
	 * ӱǩϢ
	 * 
	 * @param tb_flag
	 */
	public void add(Tb_flag tb_flag) {
		db = helper.getWritableDatabase();// ʼSQLiteDatabase
		db.execSQL("insert into tb_flag (time, address ,flag) values (?,?, ?)", 
				new Object[] {
				tb_flag.getTime(),
				tb_flag.getLocation(), 
				tb_flag.getFlag() });// ִӱǩϢ
		
		
		System.out.println(tb_flag.getTime()+
				tb_flag.getLocation()+
				tb_flag.getFlag());
	}

	/**
	 * ±ǩϢ
	 * 
	 * @param tb_flag
	 */
	public void update(Tb_flag tb_flag) {
		db = helper.getWritableDatabase();// ʼSQLiteDatabase
		db.execSQL("update tb_flag set flag = ? where _id = ?", new Object[] {
				tb_flag.getFlag(), tb_flag.getid() });// ִ޸ıǩϢ
	}

//	/**
//	 * ұǩϢ
//	 * 
//	 * @param id
//	 * @return
//	 */
//	public Tb_flag find(int id) {
//		db = helper.getWritableDatabase();// ʼSQLiteDatabase
//		Cursor cursor = db.rawQuery(
//				"select _id,flag from tb_flag where _id = ?",
//				new String[] { String.valueOf(id) });// ݱŲұǩϢ洢Cursor
//		if (cursor.moveToNext())// ҵıǩϢ
//		{
//			// ıǩϢ洢Tb_flag
//			return new Tb_flag(
//					cursor.getString(cursor.getColumnIndex("time"));
//					cursor.getString(cursor.getColumnIndex("location"));
//					cursor.getString(cursor.getColumnIndex("flag")));
//		}
//		return null;// ûϢ򷵻null
//	}

	/**
	 * hǩϢ
	 * 
	 * @param ids
	 */
	public void detele(Integer... ids) {
		if (ids.length > 0)// жǷҪɾid
		{
			StringBuffer sb = new StringBuffer();// StringBuffer
			for (int i = 0; i < ids.length; i++)// Ҫɾid
			{
				sb.append('?').append(',');// ɾӵStringBuffer
			}
			sb.deleteCharAt(sb.length() - 1);// ȥһ,ַ
			db = helper.getWritableDatabase();// SQLiteDatabase
			// ִɾǩϢ
			db.execSQL("delete from tb_flag where _id in (" + sb + ")",
					(Object[]) ids);
		}
	}

	/**
	 * ȡǩϢ
	 * 
	 * @param start
	 *            ʼλ
	 * @param count
	 *            ÿҳʾ
	 * @return
	 */
	public List<Tb_flag> getScrollData(int start, int count) {
		List<Tb_flag> lisTb_flags = new ArrayList<Tb_flag>();// ϶
		db = helper.getWritableDatabase();// ʼSQLiteDatabase
		// ȡбǩϢ
		Cursor cursor = db.rawQuery("select * from tb_flag limit ?,?",
				new String[] { String.valueOf(start), String.valueOf(count) });
		while (cursor.moveToNext())// еıǩϢ
		{
			// ıǩϢӵ
			lisTb_flags.add(new Tb_flag(
//					cursor.getString(cursor.getColumnIndex("flag")))
					));
					
		}
		return lisTb_flags;// ؼ
	}

	/**
	 * ȡܼ¼
	 * 
	 * @return
	 */
	public long getCount() {
		db = helper.getWritableDatabase();// ʼSQLiteDatabase
		Cursor cursor = db.rawQuery("select count(_id) from tb_flag", null);// ȡǩϢļ¼
		if (cursor.moveToNext())// жCursorǷ
		{
			return cursor.getLong(0);// ܼ¼
		}
		return 0;// ûݣ򷵻0
	}

	/**
	 * ȡǩ
	 * 
	 * @return
	 */
	public int getMaxId() {
		db = helper.getWritableDatabase();// ʼSQLiteDatabase
		Cursor cursor = db.rawQuery("select max(_id) from tb_flag", null);// ȡǩϢе
		while (cursor.moveToLast()) {// Cursorеһ
			return cursor.getInt(0);// ȡʵݣ
		}
		return 0;// ûݣ򷵻0
	}
}
