package com.szu;
import java.util.Calendar;

import com.szu.accountsoft.dao.DBOpenHelper;
import com.szu.accountsoft.dao.InaccountDAO;
import com.szu.accountsoft.dao.OutaccountDAO;
import com.szu.accountsoft.model.Tb_inaccount;
import com.szu.accountsoft.model.Tb_outaccount;

import android.app.Activity;
import android.app.DatePickerDialog;
import android.app.Dialog;
import android.content.Intent;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.os.Bundle;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.DatePicker;
import android.widget.EditText;
import android.widget.Spinner;
import android.widget.TextView;
import android.widget.Toast;


public class OutfoManage extends Activity {
	DBOpenHelper helper;
	protected static final int DATE_DIALOG_ID = 0;// ڶԻ
	TextView tvtitle, textView;// TextView
	EditText txtMoney, txtTime, txtAddress, txtMark, txtType, txtAmount;// 4EditText
	Spinner spType;// Spinner
	Button btnEdit, btnDel;// Button
	String[] strInfos;// ַ
	String strid, strType;// ֱַ¼Ϣź͹

	private int mYear;// 
	private int mMonth;// 
	private int mDay;// 

	OutaccountDAO outaccountDAO = new OutaccountDAO(OutfoManage.this);// OutaccountDAO
	InaccountDAO inaccountDAO = new InaccountDAO(OutfoManage.this);// InaccountDAO
	@Override
	protected void onCreate(Bundle savedInstanceState) {
		// TODO Auto-generated method stub
		super.onCreate(savedInstanceState);
		setContentView(R.layout.outfomanage);
		
		findView();

		
		setTitle("޸Ϣ");
		Intent intent = getIntent();// Intent
		final String id = intent.getStringExtra("id");
		
		displayData(id);
		
		btnDel.setEnabled(false);
		txtAddress.setEnabled(false);
		txtMoney.setEnabled(false);
		txtTime.setEnabled(false);
		txtMark.setEnabled(false);
		txtAmount.setEnabled(false);
		txtType.setEnabled(false);
		
		txtTime.setOnClickListener(new OnClickListener() {// Ϊʱıõ¼
			@Override
			public void onClick(View arg0) {
				// TODO Auto-generated method stub
				showDialog(DATE_DIALOG_ID);// ʾѡԻ
			}
		});
		
		btnEdit.setOnClickListener(new OnClickListener() {// Ϊ޸İťü¼
			@Override
			public void onClick(View arg0) {
				// TODO Auto-generated method stub
				
				// Ϣʾ
				
				
				txtAddress.setEnabled(true);
				txtMark.setEnabled(true);
				txtMoney.setEnabled(true);
				txtType.setEnabled(true);
				txtTime.setEnabled(true);
				btnDel.setEnabled(true);
				btnEdit.setEnabled(false);
				txtAmount.setEnabled(true);
				Toast.makeText(OutfoManage.this, "ɽ޸ģ", Toast.LENGTH_SHORT).show();
			}
		});
		
		btnDel.setOnClickListener(new OnClickListener() {// Ϊɾťü¼
			@Override
			public void onClick(View arg0) {
				// TODO Auto-generated method stub
				
				Tb_outaccount tb_outaccount = new Tb_outaccount();// Tb_inaccount
				
				tb_outaccount.setid(Integer.parseInt(id));// ñ
				tb_outaccount.setMoney((Double.parseDouble(txtMoney.getText().toString())));// ý
				tb_outaccount.setAmount(Integer.parseInt(txtAmount.getText().toString().trim()));
				tb_outaccount.setTime(txtTime.getText().toString().trim());// ʱ
				tb_outaccount.setType(txtType.getText().toString().trim());// 
				tb_outaccount.setAddress(txtAddress.getText().toString().trim());
				tb_outaccount.setMark(txtMark.getText().toString().trim());// ñע
				
				
				outaccountDAO.update(tb_outaccount);// Ϣ
				
				Toast.makeText(OutfoManage.this, "޸ĳɹ", Toast.LENGTH_SHORT).show();
				
				btnDel.setEnabled(false);
				btnEdit.setEnabled(true);
				txtAddress.setEnabled(false);
				txtMoney.setEnabled(false);
				txtTime.setEnabled(false);
				txtMark.setEnabled(false);
				txtAmount.setEnabled(false);
				txtType.setEnabled(false);
			}
		});

		final Calendar c = Calendar.getInstance();// ȡǰϵͳ
		mYear = c.get(Calendar.YEAR);// ȡ
		mMonth = c.get(Calendar.MONTH);// ȡ·
		mDay = c.get(Calendar.DAY_OF_MONTH);// ȡ
	}
		
	
	private void displayData(String id) {
		// TODO Auto-generated method stub
		helper = new DBOpenHelper(this);
		SQLiteDatabase db = helper.getReadableDatabase();
		String sql = "select * from tb_outaccount where _id = ? ;";
		Cursor cursor = db.rawQuery(sql, new String[]{id});
		cursor.moveToFirst();
		
		
		String money = cursor.getString(cursor.getColumnIndex("money"));
		String amount = cursor.getString(cursor.getColumnIndex("amount"));
		String time = cursor.getString(cursor.getColumnIndex("time"));
		String type = cursor.getString(cursor.getColumnIndex("type"));
		
		String address = cursor.getString(cursor.getColumnIndex("address"));
		String mark = cursor.getString(cursor.getColumnIndex("mark"));
		
		
		txtMoney.setText(money);
		txtAmount.setText(amount);
		txtTime.setText(time);
		txtType.setText(type);
		txtAddress.setText(address);
		txtMark.setText(mark);
	}
	private void findView() {
		// TODO Auto-generated method stub
		
		txtMoney = (EditText) findViewById(R.id.txtMoney);
		txtTime = (EditText) findViewById(R.id.txtTime);
		txtTime.setFocusableInTouchMode(false);
		txtAddress = (EditText) findViewById(R.id.txtAddress);
		txtMark = (EditText) findViewById(R.id.txtMark);
		txtType = (EditText) findViewById(R.id.spType);
		txtAmount = (EditText) findViewById(R.id.editNum);
		
		btnDel = (Button) findViewById(R.id.btnCancel);
		btnEdit = (Button) findViewById(R.id.btnSave);
		
	}
	
	@Override
	protected Dialog onCreateDialog(int id)// дonCreateDialog
	{
		switch (id) {
		case DATE_DIALOG_ID:// ѡԻ
			return new DatePickerDialog(this, mDateSetListener, mYear, mMonth,
					mDay);
		}
		return null;
	}
	private DatePickerDialog.OnDateSetListener mDateSetListener = new DatePickerDialog.OnDateSetListener() {
		public void onDateSet(DatePicker view, int year, int monthOfYear,
				int dayOfMonth) {
			mYear = year;// Ϊݸֵ
			mMonth = monthOfYear;// Ϊ·ݸֵ
			mDay = dayOfMonth;// Ϊ츳ֵ
			updateDisplay();// ʾõ
		}
	};
	private void updateDisplay() {
		// ʾõʱ
		txtTime.setText(new StringBuilder().append(mYear).append("-")
				.append(mMonth + 1).append("-").append(mDay));
	}

}
