package com.szu;

import java.util.ArrayList;
import java.util.List;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.AdapterView.OnItemClickListener;
import android.widget.BaseAdapter;
import android.widget.GridView;
import android.widget.ImageView;
import android.widget.TextView;

public class MainActivity extends Activity {
	GridView gvInfo;
	
	String[] titles = new String[] { "֧", "", "ҵ֧", "ҵ", "ҵı¼",
			"޸", "¼", "˳" };

	int[] images = new int[] { R.drawable.addoutaccount,
			R.drawable.addinaccount, R.drawable.outaccountinfo,
			R.drawable.inaccountinfo, R.drawable.showinfo, R.drawable.sysset,
			R.drawable.accountflag, R.drawable.exit };

	/** Called when the activity is first created. */
	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.main);
		
		setTitle("ѡ");
		gvInfo = (GridView) findViewById(R.id.gvInfo);
		pictureAdapter adapter = new pictureAdapter(titles, images, this);
		
		
		
		gvInfo.setAdapter(adapter);
		gvInfo.setOnItemClickListener(new OnItemClickListener() 
		{
			@Override
			public void onItemClick(AdapterView<?> arg0, View arg1, int arg2,long arg3) 
			{
				Intent intent = null;
				switch (arg2) {
				case 0:
					intent = new Intent(MainActivity.this, AddOutaccount.class);
					startActivity(intent);
					break;
				case 1:
					intent = new Intent(MainActivity.this, AddInaccount.class);
					startActivity(intent);
					break;
				case 2:
					intent = new Intent(MainActivity.this, Outaccountinfo.class);
					startActivity(intent);
					break;
				case 3:
					intent = new Intent(MainActivity.this, Inaccountinfo.class);
					startActivity(intent);
					break;
				case 4:
					intent = new Intent(MainActivity.this, Showinfo.class);
					startActivity(intent);
					break;
				case 5:
					intent = new Intent(MainActivity.this, Sysset.class);
					startActivity(intent);
					break;
				case 6:
					intent = new Intent(MainActivity.this, Accountflag.class);
					startActivity(intent);
					break;
				case 7:
					finish();
				}
			}
		});
	}
}

class pictureAdapter extends BaseAdapter
{
	private LayoutInflater inflater;
	private List<Picture> pictures;

	// Ϊഴ캯
	public pictureAdapter(String[] titles, int[] images, Context context) {
		super();
		pictures = new ArrayList<Picture>();// ʼͼ϶
		inflater = LayoutInflater.from(context);// ʼLayoutInflater
		for (int i = 0; i < images.length; i++)// ͼ
		{
			Picture picture = new Picture(titles[i], images[i]);// ʹñͼPicture
			pictures.add(picture);// Pictureӵͼ
		}
	}

	@Override
	public int getCount() {// ȡͼϵĳ
		if (null != pictures) {// ͼϲΪ
			return pictures.size();// طͳ
		} else {
			return 0;// 0
		}
	}

	@Override
	public Object getItem(int arg0) {
		return pictures.get(arg0);// ȡͼָ
	}

	@Override
	public long getItemId(int arg0) {
		return arg0;// طͼϵ
	}

	@Override
	public View getView(int arg0, View arg1, ViewGroup arg2) {
		ViewHolder viewHolder;// ViewHolder
		if (arg1 == null)// жͼʶǷΪ
		{
			arg1 = inflater.inflate(R.layout.gvitem, null);// ͼʶ
			viewHolder = new ViewHolder();// ʼViewHolder
			viewHolder.title = (TextView) arg1.findViewById(R.id.ItemTitle);// ͼ
			viewHolder.image = (ImageView) arg1.findViewById(R.id.ItemImage);// ͼĶֵ
			arg1.setTag(viewHolder);// ʾ
		} else {
			viewHolder = (ViewHolder) arg1.getTag();// ʾ
		}
		viewHolder.title.setText(pictures.get(arg0).getTitle());// ͼ
		viewHolder.image.setImageResource(pictures.get(arg0).getImageId());// ͼĶֵ
		return arg1;// ͼʶ
	}
}

class ViewHolder// ViewHolder
{
	public TextView title;// TextView
	public ImageView image;// ImageView
}

class Picture// Picture
{
	private String title;// ַʾͼ
	private int imageId;// intʾͼĶֵ

	public Picture()// ĬϹ캯
	{
		super();
	}

	public Picture(String title, int imageId)// вι캯
	{
		super();
		this.title = title;// Ϊͼ⸳ֵ
		this.imageId = imageId;// ΪͼĶֵֵ
	}

	public String getTitle() {// ͼĿɶ
		return title;
	}

	public void setTitle(String title) {// ͼĿд
		this.title = title;
	}

	public int getImageId() {// ͼֵĿɶ
		return imageId;
	}

	public void setimageId(int imageId) {// ͼֵĿд
		this.imageId = imageId;
	}
}