package com.szu;

import java.util.ArrayList;
import java.util.List;


import android.R.layout;
import android.accounts.Account;
import android.app.Activity;
import android.app.AlertDialog;
import android.app.Dialog;
import android.app.PendingIntent;
import android.content.ContentResolver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.database.Cursor;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.location.Location;
import android.net.Uri;
import android.os.Bundle;
import android.preference.PreferenceManager.OnActivityResultListener;
import android.provider.ContactsContract;
import android.text.Editable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.EditText;
import android.widget.SimpleAdapter.ViewBinder;
import android.widget.Button;
import android.widget.TextView;
import android.widget.Toast;

import com.baidu.mapapi.BMapManager;
import com.baidu.mapapi.GeoPoint;
import com.baidu.mapapi.ItemizedOverlay;
import com.baidu.mapapi.LocationListener;
import com.baidu.mapapi.MKAddrInfo;
import com.baidu.mapapi.MKBusLineResult;
import com.baidu.mapapi.MKDrivingRouteResult;
import com.baidu.mapapi.MKGeneralListener;
import com.baidu.mapapi.MKPoiResult;
import com.baidu.mapapi.MKSearch;
import com.baidu.mapapi.MKSearchListener;
import com.baidu.mapapi.MKSuggestionResult;
import com.baidu.mapapi.MKTransitRouteResult;
import com.baidu.mapapi.MKWalkingRouteResult;
import com.baidu.mapapi.MapActivity;
import com.baidu.mapapi.MapController;
import com.baidu.mapapi.MapView;
import com.baidu.mapapi.MyLocationOverlay;
import com.baidu.mapapi.OverlayItem;

public class MyLocation extends MapActivity {//Ӱٶȵͼؿؼ
	
	private MapView mapView;
	private BMapManager bMapManager;	//صͼ
	//ٶȵͼkey
	private String keyString = "A09ED96432C83046F02AD523211ABAB829D5751D";
	//ڰٶȵͼһЩؼǷŴСؼ
	private MapController mapController;
	
	MyLocationOverlay myLocationOverlay = null; 
	LocationListener locationListener = null; 
	
	private MKSearch mMKSearch;
	private TextView address;
	

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		// TODO Auto-generated method stub
		super.onCreate(savedInstanceState);
		setContentView(R.layout.mylocation_activity);
		address = (TextView) findViewById(R.id.address);
		
		mapView = (MapView) findViewById(R.id.bmapView_laoluo);
		bMapManager = new BMapManager(MyLocation.this);
		
		
		setTitle("λã");
		address.getPaint().setFlags(Paint.UNDERLINE_TEXT_FLAG);
		bMapManager.init(keyString, new MKGeneralListener() {
			
			@Override
			public void onGetPermissionState(int arg0) {
				// TODO Auto-generated method stub
				if(arg0 == 300)
				{
					Toast.makeText(MyLocation.this, "keyдʵ", Toast.LENGTH_LONG).show();
				}
			}
			
			@Override
			public void onGetNetworkState(int arg0) {
				// TODO Auto-generated method stub
				
			}
		});
		
		mMKSearch = new MKSearch();
		mMKSearch.init(bMapManager, new MySearchListener());
		
		
		this.initMapActivity(bMapManager);
		mapView.setBuiltInZoomControls(true);		//ʾֻŹ
		mapController = mapView.getController();
		//Ҫһγ22.537422
		GeoPoint geoPoint = new GeoPoint((int)(22.537422*1e6), (int) (113.942741*1e6));
		
		mapController.setCenter(geoPoint);//һĵ
		mapController.setZoom(12);
		
		//ͼ
		myLocationOverlay = new MyLocationOverlay(this, mapView);
		mapView.getOverlays().add(myLocationOverlay);
		
		locationListener = new LocationListener() {
			
			@Override
			public void onLocationChanged(Location location) {
				// TODO Auto-generated method stub
				if(location != null)
				{
					GeoPoint point = new GeoPoint((int)(location.getLatitude()*1e6)
							, (int)(location.getLongitude()*1e6));
					mapView.getController().animateTo(point);
					
					int longitude = (int) (location.getLongitude()*1e6);
					int latitude = (int) (location.getLatitude()*1e6);
					
					
					mMKSearch.reverseGeocode(new GeoPoint(latitude, longitude));
					
					System.out.println((int)(location.getLatitude()*1e6));
					System.out.println((int)(location.getLongitude()*1e6));
				}
				
			}
			
		};
		
		
		address.setOnLongClickListener(new AddressListener());
		
	}

	
	
	public class AddressListener implements View.OnLongClickListener
	{
		
		

		@Override
		public boolean onLongClick(View arg0) {
			// TODO Auto-generated method stub
			String content = address.getText().toString();
			
			Intent intent = new Intent();
			Bundle bundle = new Bundle();
			bundle.putString("address", content);
			intent.putExtras(bundle);
			setResult(1, intent);
			finish();
			return false;
		}
		
	}
	
	
	public class MySearchListener implements MKSearchListener
	{

		@Override
		public void onGetAddrResult(MKAddrInfo result, int error) {
			// TODO Auto-generated method stub
			
			
			System.out.println(result);
			if(result == null)
			{
				return ;
				
			}
			
			
			StringBuffer sb = new StringBuffer();
			sb.append(result.strAddr);
				
			
			
			address.setText(sb.toString());
		}

		@Override
		public void onGetBusDetailResult(MKBusLineResult arg0, int arg1) {
			// TODO Auto-generated method stub
			
		}

		@Override
		public void onGetDrivingRouteResult(MKDrivingRouteResult arg0, int arg1) {
			// TODO Auto-generated method stub
			
		}

		@Override
		public void onGetPoiDetailSearchResult(int arg0, int arg1) {
			// TODO Auto-generated method stub
			
		}

		@Override
		public void onGetPoiResult(MKPoiResult arg0, int arg1, int arg2) {
			// TODO Auto-generated method stub
			
		}

		@Override
		public void onGetRGCShareUrlResult(String arg0, int arg1) {
			// TODO Auto-generated method stub
			
		}

		@Override
		public void onGetSuggestionResult(MKSuggestionResult arg0, int arg1) {
			// TODO Auto-generated method stub
			
		}

		@Override
		public void onGetTransitRouteResult(MKTransitRouteResult arg0, int arg1) {
			// TODO Auto-generated method stub
			
		}

		@Override
		public void onGetWalkingRouteResult(MKWalkingRouteResult arg0, int arg1) {
			// TODO Auto-generated method stub
			
		}
		
	}
	
	
	public class MyOverLayItem extends ItemizedOverlay<OverlayItem>
	{
		 private ArrayList<OverlayItem> overlayItemList = new ArrayList<OverlayItem>();  
		  private Context context;  


		public MyOverLayItem(Drawable arg0) {
			super(arg0);
			// TODO Auto-generated constructor stub
		}

		@Override
		protected OverlayItem createItem(int arg0) {
			// TODO Auto-generated method stub
			return null;
		}

		@Override
		public int size() {
			// TODO Auto-generated method stub
			return 0;
		}
		@Override
		public boolean onTap(GeoPoint arg0, MapView arg1) {
			// TODO Auto-generated method stub
			Toast.makeText(MyLocation.this, "", Toast.LENGTH_LONG).show();
			
			return super.onTap(arg0, arg1);
		}
	}
	
	@Override
	protected void onResume() {
		// TODO Auto-generated method stub
		
		bMapManager.getLocationManager().requestLocationUpdates(locationListener);
		myLocationOverlay.enableCompass();
		myLocationOverlay.enableMyLocation();
		
		if(bMapManager != null)
		{
			bMapManager.start();
		}
		super.onResume();
	}
	@Override
	protected void onDestroy() {
		// TODO Auto-generated method stub
		if(bMapManager != null)
		{
			bMapManager.destroy();
			bMapManager = null;
		}
		super.onDestroy();
	}
	@Override
	protected void onPause() {
		// TODO Auto-generated method stub
		
		bMapManager.getLocationManager().removeUpdates(locationListener);
		myLocationOverlay.disableCompass();
		myLocationOverlay.disableMyLocation();
		
		if(bMapManager != null)
		{
			bMapManager.stop();
		}
		super.onPause();
	}
	
	
	@Override
	protected boolean isRouteDisplayed() {
		// TODO Auto-generated method stub
		return false;
	}
}
