package com.szu;

import java.util.Calendar;

import com.szu.accountsoft.dao.DBOpenHelper;
import com.szu.accountsoft.dao.InaccountDAO;
import com.szu.accountsoft.dao.OutaccountDAO;
import com.szu.accountsoft.model.Tb_inaccount;

import android.app.Activity;
import android.app.DatePickerDialog;
import android.app.Dialog;
import android.content.Intent;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.os.Bundle;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.DatePicker;
import android.widget.EditText;
import android.widget.Spinner;
import android.widget.TextView;
import android.widget.Toast;

public class InfoManage extends Activity {
	
	DBOpenHelper helper;
	protected static final int DATE_DIALOG_ID = 0;// ڶԻ
	TextView tvtitle, textView;// TextView
	EditText txtMoney, txtTime, txtHA, txtMark;// 4EditText
	Spinner spType;// Spinner
	Button btnEdit, btnDel;// Button
	String[] strInfos;// ַ
	String strid, strType;// ֱַ¼Ϣź͹

	private int mYear;// 
	private int mMonth;// 
	private int mDay;// 

	OutaccountDAO outaccountDAO = new OutaccountDAO(InfoManage.this);// OutaccountDAO
	InaccountDAO inaccountDAO = new InaccountDAO(InfoManage.this);// InaccountDAO

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		// TODO Auto-generated method stub
		super.onCreate(savedInstanceState);
		setContentView(R.layout.infomanage);// òļ
		
		findView();

		
		setTitle("޸Ϣ");
		Intent intent = getIntent();// Intent
		final String id = intent.getStringExtra("id");
		
		displayData(id);
		
		btnDel.setEnabled(false);
		txtHA.setEnabled(false);
		txtMoney.setEnabled(false);
		txtTime.setEnabled(false);
		txtMark.setEnabled(false);
		

		txtTime.setOnClickListener(new OnClickListener() {// Ϊʱıõ¼
			@Override
			public void onClick(View arg0) {
				// TODO Auto-generated method stub
				showDialog(DATE_DIALOG_ID);// ʾѡԻ
			}
		});

		btnEdit.setOnClickListener(new OnClickListener() {// Ϊ޸İťü¼
			@Override
			public void onClick(View arg0) {
				// TODO Auto-generated method stub
				
				// Ϣʾ
				
				
				txtHA.setEnabled(true);
				txtMark.setEnabled(true);
				txtMoney.setEnabled(true);
				txtTime.setEnabled(true);
				btnDel.setEnabled(true);
				btnEdit.setEnabled(false);
				Toast.makeText(InfoManage.this, "ɽ޸ģ", Toast.LENGTH_SHORT)
						.show();
			}
		});

		btnDel.setOnClickListener(new OnClickListener() {// Ϊɾťü¼
			@Override
			public void onClick(View arg0) {
				// TODO Auto-generated method stub
				
				Tb_inaccount tb_inaccount = new Tb_inaccount();// Tb_inaccount
				tb_inaccount.setid(Integer.parseInt(id));// ñ
				tb_inaccount.setMoney(Double.parseDouble(txtMoney.getText()
						.toString()));// ý
				tb_inaccount.setTime(txtTime.getText().toString());// ʱ
				tb_inaccount.setType(spType.getSelectedItem().toString());// 
				tb_inaccount.setHandler(txtHA.getText().toString());// ø
				tb_inaccount.setMark(txtMark.getText().toString());// ñע
				inaccountDAO.update(tb_inaccount);// Ϣ
				
				Toast.makeText(InfoManage.this, "޸ĳɹ", Toast.LENGTH_SHORT).show();
				
				btnDel.setEnabled(false);
				btnEdit.setEnabled(true);
				txtHA.setEnabled(false);
				txtMoney.setEnabled(false);
				txtTime.setEnabled(false);
				txtMark.setEnabled(false);
			}
		});

		final Calendar c = Calendar.getInstance();// ȡǰϵͳ
		mYear = c.get(Calendar.YEAR);// ȡ
		mMonth = c.get(Calendar.MONTH);// ȡ·
		mDay = c.get(Calendar.DAY_OF_MONTH);// ȡ
	}

	private void displayData(String id) {
		// TODO Auto-generated method stub
		helper = new DBOpenHelper(this);
		SQLiteDatabase db = helper.getReadableDatabase();
		String sql = "select * from tb_inaccount where _id = ? ;";
		Cursor cursor = db.rawQuery(sql, new String[]{id});
		cursor.moveToFirst();
		
		
		String money = cursor.getString(cursor.getColumnIndex("money"));
		String time = cursor.getString(cursor.getColumnIndex("time"));
		String type = cursor.getString(cursor.getColumnIndex("type"));
		String handle = cursor.getString(cursor.getColumnIndex("handler"));
		String mark = cursor.getString(cursor.getColumnIndex("mark"));
		
		
		txtMoney.setText(money);
		txtTime.setText(time);
		spType.setPrompt("㵱ǰѡǣ"+type);
		txtHA.setText(handle);
		txtMark.setText(mark);
		
	}

	private void findView() {
		// TODO Auto-generated method stub
		tvtitle = (TextView) findViewById(R.id.inouttitle);// ȡǩ
		textView = (TextView) findViewById(R.id.tvInOut);// ȡص/ǩ
		txtMoney = (EditText) findViewById(R.id.txtInOutMoney);// ȡı
		txtTime = (EditText) findViewById(R.id.txtInOutTime);// ȡʱı
		txtTime.setFocusableInTouchMode(false);
		spType = (Spinner) findViewById(R.id.spInOutType);// ȡб
		txtHA = (EditText) findViewById(R.id.txtInOut);// ȡص/ı
		txtMark = (EditText) findViewById(R.id.txtInOutMark);// ȡעı
		btnEdit = (Button) findViewById(R.id.btnInOutEdit);// ȡ޸İť
		btnDel = (Button) findViewById(R.id.btnInOutDelete);// ȡɾť
	}

	@Override
	protected Dialog onCreateDialog(int id)// дonCreateDialog
	{
		switch (id) {
		case DATE_DIALOG_ID:// ѡԻ
			return new DatePickerDialog(this, mDateSetListener, mYear, mMonth,
					mDay);
		}
		return null;
	}

	private DatePickerDialog.OnDateSetListener mDateSetListener = new DatePickerDialog.OnDateSetListener() {
		public void onDateSet(DatePicker view, int year, int monthOfYear,
				int dayOfMonth) {
			mYear = year;// Ϊݸֵ
			mMonth = monthOfYear;// Ϊ·ݸֵ
			mDay = dayOfMonth;// Ϊ츳ֵ
			updateDisplay();// ʾõ
		}
	};

	private void updateDisplay() {
		// ʾõʱ
		txtTime.setText(new StringBuilder().append(mYear).append("-")
				.append(mMonth + 1).append("-").append(mDay));
	}
}
