/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.mapapi;

import android.content.Context;
import android.content.res.AssetManager;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Point;
import android.graphics.Rect;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.location.Location;
import android.os.Bundle;
import com.baidu.mapapi.CoordinateConvert;
import com.baidu.mapapi.GeoPoint;
import com.baidu.mapapi.LocationListener;
import com.baidu.mapapi.MapView;
import com.baidu.mapapi.Mj;
import com.baidu.mapapi.Overlay;
import java.io.InputStream;

public class MyLocationOverlay
extends Overlay
implements SensorEventListener,
LocationListener,
Overlay.Snappable {
    private Location a = null;
    private GeoPoint b = null;
    private GeoPoint c = null;
    private Runnable d = null;
    private MapView e = null;
    private Bitmap f = null;
    private Bitmap g = null;
    private Bitmap h = null;
    private boolean i = false;
    private boolean j = false;
    private float k = 0.0f;
    private Paint l = null;

    protected GeoPoint GetBaidu09Point(GeoPoint geoPoint, int n2) {
        if (geoPoint == null) {
            return null;
        }
        GeoPoint geoPoint2 = null;
        switch (n2) {
            case 0: {
                Bundle bundle = CoordinateConvert.fromWgs84ToBaidu(geoPoint);
                geoPoint2 = CoordinateConvert.bundleDecode(bundle);
                break;
            }
            case 1: {
                Bundle bundle = CoordinateConvert.fromGcjToBaidu(geoPoint);
                geoPoint2 = CoordinateConvert.bundleDecode(bundle);
                break;
            }
            default: {
                geoPoint2 = geoPoint;
            }
        }
        return geoPoint2;
    }

    public void onLocationChanged(Location location) {
        this.a = location;
        if (this.a == null) {
            this.b = null;
            this.c = null;
            this.e.invalidate();
            return;
        }
        this.b = new GeoPoint(location.getLatitude(), location.getLongitude());
        this.c = this.GetBaidu09Point(this.b, Mj.c);
        this.e.invalidate();
        if (this.d != null) {
            this.d.run();
            this.d = null;
        }
    }

    public MyLocationOverlay(Context context, MapView mapView) {
        if (mapView == null) {
            throw new IllegalArgumentException("mapView is null");
        }
        this.e = mapView;
        this.l = new Paint();
        this.l.setARGB(35, 0, 0, 128);
        this.l.setStyle(Paint.Style.FILL_AND_STROKE);
        this.l.setAntiAlias(true);
        try {
            AssetManager assetManager = context.getAssets();
            String string = "icon_my.png";
            InputStream inputStream = assetManager.open(string);
            this.f = BitmapFactory.decodeStream((InputStream)inputStream);
            inputStream.close();
            string = "compass_bg.png";
            inputStream = assetManager.open(string);
            this.g = BitmapFactory.decodeStream((InputStream)inputStream);
            inputStream.close();
            string = "compass_pointer.png";
            inputStream = assetManager.open(string);
            this.h = BitmapFactory.decodeStream((InputStream)inputStream);
            inputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean enableCompass() {
        this.j = Mj.b.a(this);
        return this.j;
    }

    public void disableCompass() {
        this.j = false;
        Mj.b.b(this);
        this.e.b.b = 0;
        this.e.invalidate();
    }

    public boolean isCompassEnabled() {
        return this.j;
    }

    public boolean enableMyLocation() {
        Mj.b.requestLocationUpdates(this);
        this.a = Mj.b.getLocationInfo();
        if (this.a != null) {
            this.b = new GeoPoint(this.a.getLatitude(), this.a.getLongitude());
            this.c = this.GetBaidu09Point(this.b, Mj.c);
        }
        this.i = true;
        this.e.invalidate();
        return true;
    }

    public void disableMyLocation() {
        this.i = false;
        this.a = null;
        this.b = null;
        this.c = null;
        Mj.b.removeUpdates(this);
        this.e.invalidate();
    }

    public boolean isMyLocationEnabled() {
        return this.i;
    }

    public boolean onSnapToItem(int n2, int n3, Point point, MapView mapView) {
        return false;
    }

    public boolean onTap(GeoPoint geoPoint, MapView mapView) {
        GeoPoint geoPoint2 = this.getMyLocation();
        if (geoPoint2 != null) {
            Point point = this.e.getProjection().toPixels(geoPoint2, null);
            if (this.f == null) {
                return false;
            }
            int n2 = this.f.getWidth() / 2;
            int n3 = this.f.getHeight() / 2;
            Rect rect = new Rect(point.x - n2, point.y - n3, point.x + n2, point.y + n3);
            Point point2 = this.e.getProjection().toPixels(geoPoint, null);
            if (rect.contains(point2.x, point2.y)) {
                return this.dispatchTap();
            }
        }
        return false;
    }

    protected boolean dispatchTap() {
        return false;
    }

    public boolean draw(Canvas canvas, MapView mapView, boolean bl, long l2) {
        if (bl) {
            return false;
        }
        if (this.a != null && this.b != null && this.c != null) {
            this.drawMyLocation(canvas, mapView, this.a, this.c, l2);
        }
        if (this.j) {
            this.drawCompass(canvas, this.k);
        }
        return true;
    }

    protected void drawMyLocation(Canvas canvas, MapView mapView, Location location, GeoPoint geoPoint, long l2) {
        if (geoPoint == null) {
            return;
        }
        Point point = mapView.getProjection().toPixels(geoPoint, null);
        int n2 = point.x - this.f.getWidth() / 2;
        int n3 = point.y - this.f.getHeight() / 2;
        canvas.drawBitmap(this.f, (float)n2, (float)n3, null);
        if (location.hasAccuracy()) {
            float f2 = location.getAccuracy();
            float f3 = mapView.getProjection().metersToEquatorPixels(f2);
            canvas.drawCircle((float)point.x, (float)point.y, f3, this.l);
        }
    }

    protected void drawCompass(Canvas canvas, float f2) {
        if (f2 > 360.0f || f2 < -360.0f) {
            return;
        }
        int n2 = 10;
        int n3 = 10;
        canvas.drawBitmap(this.g, (float)n2, (float)n3, null);
        int n4 = n2 + this.h.getWidth() / 2;
        int n5 = n3 + this.h.getHeight() / 2;
        Matrix matrix = new Matrix();
        matrix.postTranslate((float)n2, (float)n3);
        matrix.postRotate(-f2, (float)n4, (float)n5);
        Paint paint = new Paint();
        paint.setAntiAlias(true);
        canvas.drawBitmap(this.h, matrix, paint);
    }

    public GeoPoint getMyLocation() {
        return this.b;
    }

    public Location getLastFix() {
        return this.a;
    }

    public float getOrientation() {
        return this.k;
    }

    public boolean runOnFirstFix(Runnable runnable) {
        if (this.a != null) {
            runnable.run();
            return true;
        }
        this.d = runnable;
        return false;
    }

    public void onAccuracyChanged(Sensor sensor, int n2) {
    }

    public void onProviderDisabled(String string) {
        this.i = false;
    }

    public void onProviderEnabled(String string) {
        this.i = true;
    }

    public void onSensorChanged(SensorEvent sensorEvent) {
        if (sensorEvent.sensor.getType() == 3) {
            int n2 = (int)sensorEvent.values[0];
            Configuration configuration = this.e.getResources().getConfiguration();
            if (configuration.orientation == 2) {
                n2 = (n2 + 90) % 360;
            }
            if (Math.abs((float)n2 - this.k) >= 10.0f) {
                this.k = n2;
                if (this.e.b == null) {
                    return;
                }
                this.e.b.b = n2;
                this.e.invalidate();
            }
        }
    }
}

