/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.mapapi;

import android.graphics.Point;
import android.os.Message;
import android.view.KeyEvent;
import android.view.View;
import com.baidu.mapapi.GeoPoint;
import com.baidu.mapapi.MapView;

public class MapController
implements View.OnKeyListener {
    private MapView a = null;

    MapController(MapView mapView) {
        this.a = mapView;
        mapView.b.setOnKeyListener(this);
    }

    public void animateTo(GeoPoint geoPoint) {
        this.a.a(geoPoint, null, null);
    }

    public void animateTo(GeoPoint geoPoint, Message message) {
        this.a.a(geoPoint, message, null);
    }

    public void animateTo(GeoPoint geoPoint, Runnable runnable) {
        this.a.a(geoPoint, null, runnable);
    }

    public boolean onKey(View view, int n2, KeyEvent keyEvent) {
        if (this.a.b == view) {
            if (keyEvent.getAction() != 0) {
                return false;
            }
            switch (n2) {
                case 21: {
                    this.scrollBy(-50, 0);
                    break;
                }
                case 22: {
                    this.scrollBy(50, 0);
                    break;
                }
                case 19: {
                    this.scrollBy(0, -50);
                    break;
                }
                case 20: {
                    this.scrollBy(0, 50);
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public void scrollBy(int n2, int n3) {
        if (n2 == 0 && n3 == 0) {
            return;
        }
        this.a.b(n2, n3);
    }

    public void setCenter(GeoPoint geoPoint) {
        this.a.a(geoPoint);
    }

    public int setZoom(int n2) {
        this.a.c(n2);
        return this.a.getZoomLevel();
    }

    public void setMaxZoomLevel(int n2) {
        this.a.a(n2);
    }

    public void setMinZoomLevel(int n2) {
        this.a.b(n2);
    }

    public void stopAnimation(boolean bl) {
        this.a.a(bl);
    }

    public void stopPanning() {
        GeoPoint geoPoint = this.a.getMapCenter();
        this.setCenter(geoPoint);
    }

    public boolean zoomIn() {
        return this.a.f();
    }

    public boolean zoomInFixing(int n2, int n3) {
        GeoPoint geoPoint = this.a.getProjection().fromPixels(n2, n3);
        boolean bl = this.zoomIn();
        if (bl) {
            Point point = new Point();
            this.a.getProjection().toPixels(geoPoint, point);
            this.scrollBy(point.x - n2, point.y - n3);
        }
        return bl;
    }

    public boolean zoomOut() {
        return this.a.g();
    }

    public boolean zoomOutFixing(int n2, int n3) {
        GeoPoint geoPoint = this.a.getProjection().fromPixels(n2, n3);
        boolean bl = this.zoomOut();
        if (bl) {
            Point point = new Point();
            this.a.getProjection().toPixels(geoPoint, point);
            this.scrollBy(point.x - n2, point.y - n3);
        }
        return bl;
    }

    public void zoomToSpan(int n2, int n3) {
        this.a.a(n2, n3);
    }
}

