/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.mapapi;

import android.os.Bundle;
import android.util.Log;
import com.baidu.mapapi.BMapManager;
import com.baidu.mapapi.GeoPoint;
import com.baidu.mapapi.MKPlanNode;
import com.baidu.mapapi.MKSearchListener;
import com.baidu.mapapi.Mj;
import java.io.UnsupportedEncodingException;

public class MKSearch {
    public static final int ECAR_TIME_FIRST = 0;
    public static final int ECAR_DIS_FIRST = 1;
    public static final int ECAR_FEE_FIRST = 2;
    public static final int EBUS_TIME_FIRST = 3;
    public static final int EBUS_TRANSFER_FIRST = 4;
    public static final int EBUS_WALK_FIRST = 5;
    public static final int EBUS_NO_SUBWAY = 6;
    public static final int TYPE_CITY_LIST = 7;
    public static final int TYPE_POI_LIST = 11;
    public static final int TYPE_AREA_POI_LIST = 21;
    public static final int TYPE_AREA_MULTI_POI_LIST = 45;
    public static final int POI_DETAIL_SEARCH = 52;
    private Bundle a = null;
    private static int b = 10;
    private int c = 3;
    private int d = 0;

    public boolean init(BMapManager bMapManager, MKSearchListener mKSearchListener) {
        if (bMapManager == null) {
            return false;
        }
        if (mKSearchListener != null) {
            bMapManager.a.a(mKSearchListener);
        }
        return Mj.initSearchCC() == 1;
    }

    public int suggestionSearch(String string) {
        if (string == null) {
            return -1;
        }
        String string2 = string.trim();
        if (string2.length() == 0 || string2.length() > 99) {
            return -1;
        }
        if (this.a == null) {
            this.a = new Bundle();
        } else {
            this.a.clear();
        }
        this.a.putInt("act", 11020301);
        this.a.putInt("opt", 11010107);
        this.a.putString("key", string2);
        int n2 = Mj.sendBundle(this.a);
        if (n2 == 0) {
            return -1;
        }
        return 0;
    }

    public int rGCShareUrlSearch(GeoPoint geoPoint, String string, String string2) {
        if (string == null || string2 == null || geoPoint == null) {
            return -1;
        }
        String string3 = string.trim();
        String string4 = string2.trim();
        if (string3.length() > 99) {
            return -1;
        }
        if (string4.length() > 99) {
            return -1;
        }
        if (this.a == null) {
            this.a = new Bundle();
        } else {
            this.a.clear();
        }
        this.a.putInt("act", 11010203);
        this.a.putInt("opt", 11010110);
        this.a.putString("key", "");
        this.a.putInt("cnt", b);
        this.a.putInt("page_num", 0);
        this.a.putInt("x", geoPoint.getLongitudeE6());
        this.a.putInt("y", geoPoint.getLatitudeE6());
        this.a.putString("name", string3);
        this.a.putString("addr", string4);
        int n2 = Mj.sendBundle(this.a);
        if (n2 == 0) {
            return -1;
        }
        return 0;
    }

    public int poiDetailSearch(String string) {
        if (string == null) {
            return -1;
        }
        if (this.a == null) {
            this.a = new Bundle();
        } else {
            this.a.clear();
        }
        this.a.putInt("act", 11010203);
        this.a.putInt("opt", 11010113);
        this.a.putString("uid", string);
        this.a.putString("key", null);
        this.a.putString("d_data_type", "cater");
        this.a.putInt("page_num", 0);
        this.a.putInt("cnt", b);
        int n2 = Mj.sendBundle(this.a);
        if (n2 == 0) {
            return -1;
        }
        return 0;
    }

    public int poiSearchInCity(String string, String string2) {
        if (string2 == null) {
            return -1;
        }
        if (string == null) {
            string = "";
        }
        String string3 = string.trim();
        String string4 = string2.trim();
        if (string3.length() > 16) {
            return -1;
        }
        if (string4.length() == 0 || string4.length() > 99) {
            return -1;
        }
        if (this.a == null) {
            this.a = new Bundle();
        } else {
            this.a.clear();
        }
        this.a.putInt("act", 11010203);
        this.a.putInt("opt", 11010101);
        try {
            this.a.putByteArray("city", string3.getBytes("gb2312"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Log.d((String)"MKSearch poiSearchInCity:", (String)"translate city error!!");
            Log.d((String)"MKSearch poiSearchInCity:", (String)unsupportedEncodingException.getMessage());
        }
        this.a.putString("key", string4);
        this.a.putInt("page_num", 0);
        this.a.putInt("cnt", b);
        int n2 = Mj.sendBundle(this.a);
        if (n2 == 0) {
            return -1;
        }
        return 0;
    }

    public int poiSearchInbounds(String string, GeoPoint geoPoint, GeoPoint geoPoint2) {
        if (string == null || geoPoint == null || geoPoint2 == null) {
            return -1;
        }
        String string2 = string.trim();
        if (string2.length() == 0 || string2.length() > 99) {
            return -1;
        }
        if (this.a == null) {
            this.a = new Bundle();
        } else {
            this.a.clear();
        }
        this.a.putInt("act", 11010203);
        this.a.putInt("opt", 11010104);
        this.a.putString("key", string2);
        this.a.putInt("page_num", 0);
        this.a.putInt("cnt", b);
        this.a.putInt("start_x", geoPoint.getLongitudeE6());
        this.a.putInt("start_y", geoPoint.getLatitudeE6());
        this.a.putInt("end_x", geoPoint2.getLongitudeE6());
        this.a.putInt("end_y", geoPoint2.getLatitudeE6());
        int n2 = Mj.sendBundle(this.a);
        if (n2 == 0) {
            return -1;
        }
        return 0;
    }

    public int poiMultiSearchInbounds(String[] stringArray, GeoPoint geoPoint, GeoPoint geoPoint2) {
        int n2;
        if (stringArray == null || geoPoint == null || geoPoint2 == null) {
            return -1;
        }
        if (stringArray.length < 2 || stringArray.length > 10) {
            return -1;
        }
        if (this.a == null) {
            this.a = new Bundle();
        } else {
            this.a.clear();
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            if (stringArray[n2] == null) {
                return -1;
            }
            String string = stringArray[n2].trim();
            if (string.length() == 0 || string.length() > 99 || string.contains("$$")) {
                return -1;
            }
            stringBuilder.append(string);
            if (n2 == stringArray.length - 1) continue;
            stringBuilder.append("$$");
        }
        if (stringBuilder.toString().length() > 99) {
            return -1;
        }
        this.a.putInt("act", 11010203);
        this.a.putInt("opt", 11010111);
        this.a.putString("key", stringBuilder.toString());
        this.a.putInt("page_num", 0);
        this.a.putInt("cnt", b);
        this.a.putInt("start_x", geoPoint.getLongitudeE6());
        this.a.putInt("start_y", geoPoint.getLatitudeE6());
        this.a.putInt("end_x", geoPoint2.getLongitudeE6());
        this.a.putInt("end_y", geoPoint2.getLatitudeE6());
        this.a.putInt("key_num", stringArray.length);
        n2 = Mj.sendBundle(this.a);
        if (n2 == 0) {
            return -1;
        }
        return 0;
    }

    public int poiSearchNearBy(String string, GeoPoint geoPoint, int n2) {
        if (geoPoint == null || string == null) {
            return -1;
        }
        if (n2 <= 0) {
            return -1;
        }
        String string2 = string.trim();
        if (string2.length() == 0 || string2.length() > 99) {
            return -1;
        }
        if (this.a == null) {
            this.a = new Bundle();
        } else {
            this.a.clear();
        }
        this.a.putInt("act", 11010203);
        this.a.putInt("opt", 11010104);
        this.a.putString("key", string2);
        this.a.putInt("start_x", geoPoint.getLongitudeE6());
        this.a.putInt("start_y", geoPoint.getLatitudeE6());
        this.a.putInt("radius", n2);
        this.a.putInt("page_num", 0);
        this.a.putInt("cnt", b);
        int n3 = Mj.sendBundle(this.a);
        if (n3 == 0) {
            return -1;
        }
        return 0;
    }

    public int poiMultiSearchNearBy(String[] stringArray, GeoPoint geoPoint, int n2) {
        int n3;
        if (geoPoint == null || stringArray == null) {
            return -1;
        }
        if (n2 <= 0) {
            return -1;
        }
        if (stringArray.length < 2 || stringArray.length > 10) {
            return -1;
        }
        if (this.a == null) {
            this.a = new Bundle();
        } else {
            this.a.clear();
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (n3 = 0; n3 < stringArray.length; ++n3) {
            if (stringArray[n3] == null) {
                return -1;
            }
            String string = stringArray[n3].trim();
            if (string.length() == 0 || string.length() > 99 || stringArray[n3].contains("$$")) {
                return -1;
            }
            stringBuilder.append(string);
            if (n3 == stringArray.length - 1) continue;
            stringBuilder.append("$$");
        }
        if (stringBuilder.toString().length() > 99) {
            return -1;
        }
        this.a.putInt("act", 11010203);
        this.a.putInt("opt", 11010111);
        this.a.putString("key", stringBuilder.toString());
        this.a.putInt("start_x", geoPoint.getLongitudeE6());
        this.a.putInt("start_y", geoPoint.getLatitudeE6());
        this.a.putInt("radius", n2);
        this.a.putInt("page_num", 0);
        this.a.putInt("cnt", b);
        this.a.putInt("key_num", stringArray.length);
        n3 = Mj.sendBundle(this.a);
        if (n3 == 0) {
            return -1;
        }
        return 0;
    }

    public int reverseGeocode(GeoPoint geoPoint) {
        if (geoPoint == null) {
            return -1;
        }
        if (this.a == null) {
            this.a = new Bundle();
        } else {
            this.a.clear();
        }
        this.a.putInt("act", 11010203);
        this.a.putInt("opt", 11010109);
        this.a.putInt("x", geoPoint.getLongitudeE6());
        this.a.putInt("y", geoPoint.getLatitudeE6());
        int n2 = Mj.sendBundle(this.a);
        if (n2 == 0) {
            return -1;
        }
        return 0;
    }

    public int geocode(String string, String string2) {
        int n2;
        if (string == null || string.length() == 0 || string.length() > 99) {
            return -1;
        }
        if (this.a == null) {
            this.a = new Bundle();
        } else {
            this.a.clear();
        }
        this.a.putInt("act", 11010203);
        this.a.putInt("opt", 11010112);
        this.a.putString("addr", string);
        if (string2 != null && string2.length() <= 16) {
            try {
                this.a.putByteArray("city", string2.getBytes("gb2312"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
            }
        }
        if ((n2 = Mj.sendBundle(this.a)) == 0) {
            return -1;
        }
        return 0;
    }

    public int goToPoiPage(int n2) {
        if (this.a == null || !this.a.containsKey("page_num")) {
            return -1;
        }
        this.a.putInt("cnt", b);
        this.a.putInt("page_num", n2);
        int n3 = Mj.sendBundle(this.a);
        if (n3 == 0) {
            return -1;
        }
        return 0;
    }

    public static void setPoiPageCapacity(int n2) {
        if (n2 > 0 && n2 <= 50) {
            b = n2;
        }
    }

    public static int getPoiPageCapacity() {
        return b;
    }

    public int setTransitPolicy(int n2) {
        if (n2 > 6 || n2 < 3) {
            return -1;
        }
        this.c = n2;
        return 0;
    }

    public int setDrivingPolicy(int n2) {
        if (n2 > 2 || n2 < 0) {
            return -1;
        }
        this.d = n2;
        return 0;
    }

    public int busLineSearch(String string, String string2) {
        if (null == string || string.length() <= 0 || null == string2 || string2.length() <= 0) {
            return -1;
        }
        if (string.length() > 31) {
            return -1;
        }
        if (this.a == null) {
            this.a = new Bundle();
        } else {
            this.a.clear();
        }
        this.a.putInt("act", 11010203);
        this.a.putInt("opt", 11010105);
        try {
            this.a.putByteArray("city", string.getBytes("gb2312"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Log.d((String)"MKSearch busLineSearch:", (String)"busLine city error!!");
            Log.d((String)"MKSearch busLineSearch:", (String)unsupportedEncodingException.getMessage());
        }
        try {
            this.a.putByteArray("busid", string2.getBytes("gb2312"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Log.d((String)"MKSearch busLineSearch:", (String)"busLine name error!!");
            Log.d((String)"MKSearch busLineSearch:", (String)unsupportedEncodingException.getMessage());
        }
        if (0 == Mj.sendBundle(this.a)) {
            return -1;
        }
        return 0;
    }

    public int transitSearch(String string, MKPlanNode mKPlanNode, MKPlanNode mKPlanNode2) {
        if (string == null || mKPlanNode == null || mKPlanNode2 == null) {
            return -1;
        }
        if (string.length() > 31) {
            return -1;
        }
        if (this.a == null) {
            this.a = new Bundle();
        } else {
            this.a.clear();
        }
        this.a.putInt("act", 11020203);
        this.a.putInt("opt", 11020101);
        try {
            this.a.putByteArray("city", string.getBytes("gb2312"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Log.d((String)"MKSearch transitSearch:", (String)"translate city error!!");
            Log.d((String)"MKSearch transitSearch:", (String)unsupportedEncodingException.getMessage());
        }
        int n2 = 0;
        if (mKPlanNode.pt != null) {
            this.a.putInt("start_x", mKPlanNode.pt.getLongitudeE6());
            this.a.putInt("start_y", mKPlanNode.pt.getLatitudeE6());
            n2 = 1;
        }
        if (mKPlanNode.name != null && mKPlanNode.name.length() <= 99) {
            try {
                this.a.putByteArray("start_name", mKPlanNode.name.getBytes("gb2312"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                Log.d((String)"MKSearch transitSearch:", (String)"translate start name error!!");
                Log.d((String)"MKSearch transitSearch:", (String)unsupportedEncodingException.getMessage());
            }
            n2 = 1;
        }
        if (n2 == 0) {
            return -1;
        }
        n2 = 0;
        if (mKPlanNode2.pt != null) {
            this.a.putInt("end_x", mKPlanNode2.pt.getLongitudeE6());
            this.a.putInt("end_y", mKPlanNode2.pt.getLatitudeE6());
            n2 = 1;
        }
        if (mKPlanNode2.name != null && mKPlanNode2.name.length() <= 99) {
            try {
                this.a.putByteArray("end_name", mKPlanNode2.name.getBytes("gb2312"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                Log.d((String)"MKSearch transitSearch:", (String)"translate end name error!!");
                Log.d((String)"MKSearch transitSearch:", (String)unsupportedEncodingException.getMessage());
            }
            n2 = 1;
        }
        if (n2 == 0) {
            return -1;
        }
        this.a.putInt("policy", this.c);
        n2 = Mj.sendBundle(this.a);
        if (n2 == 0) {
            return -1;
        }
        return 0;
    }

    public int drivingSearch(String string, MKPlanNode mKPlanNode, String string2, MKPlanNode mKPlanNode2) {
        if (mKPlanNode == null || mKPlanNode2 == null) {
            return -1;
        }
        if (this.a == null) {
            this.a = new Bundle();
        } else {
            this.a.clear();
        }
        this.a.putInt("act", 11020203);
        this.a.putInt("opt", 11020102);
        int n2 = 0;
        if (mKPlanNode.pt != null) {
            this.a.putInt("start_x", mKPlanNode.pt.getLongitudeE6());
            this.a.putInt("start_y", mKPlanNode.pt.getLatitudeE6());
            n2 = 1;
        }
        if (mKPlanNode.name != null && mKPlanNode.name.length() <= 99) {
            try {
                this.a.putByteArray("start_name", mKPlanNode.name.getBytes("gb2312"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                Log.d((String)"MKSearch drivingSearch:", (String)"translate start name error!!");
                Log.d((String)"MKSearch drivingSearch:", (String)unsupportedEncodingException.getMessage());
            }
            if (string != null && string.length() <= 31) {
                try {
                    this.a.putByteArray("start_city", string.getBytes("gb2312"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    Log.d((String)"MKSearch drivingSearch:", (String)"translate start city error!!");
                    Log.d((String)"MKSearch drivingSearch:", (String)unsupportedEncodingException.getMessage());
                }
            } else {
                return -1;
            }
            n2 = 1;
        }
        if (n2 == 0) {
            return -1;
        }
        n2 = 0;
        if (mKPlanNode2.pt != null) {
            this.a.putInt("end_x", mKPlanNode2.pt.getLongitudeE6());
            this.a.putInt("end_y", mKPlanNode2.pt.getLatitudeE6());
            n2 = 1;
        }
        if (mKPlanNode2.name != null && mKPlanNode2.name.length() <= 99) {
            try {
                this.a.putByteArray("end_name", mKPlanNode2.name.getBytes("gb2312"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                Log.d((String)"MKSearch drivingSearch:", (String)"translate end name error!!");
                Log.d((String)"MKSearch drivingSearch:", (String)unsupportedEncodingException.getMessage());
            }
            if (string2 != null && string2.length() <= 31) {
                try {
                    this.a.putByteArray("end_city", string2.getBytes("gb2312"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    Log.d((String)"MKSearch drivingSearch:", (String)"translate end city error!!");
                    Log.d((String)"MKSearch drivingSearch:", (String)unsupportedEncodingException.getMessage());
                }
            } else {
                return -1;
            }
            n2 = 1;
        }
        if (n2 == 0) {
            return -1;
        }
        this.a.putInt("policy", this.d);
        n2 = Mj.sendBundle(this.a);
        if (n2 == 0) {
            return -1;
        }
        return 0;
    }

    public int walkingSearch(String string, MKPlanNode mKPlanNode, String string2, MKPlanNode mKPlanNode2) {
        if (mKPlanNode == null || mKPlanNode2 == null) {
            return -1;
        }
        if (this.a == null) {
            this.a = new Bundle();
        } else {
            this.a.clear();
        }
        this.a.putInt("act", 11020203);
        this.a.putInt("opt", 11020103);
        int n2 = 0;
        if (mKPlanNode.pt != null) {
            this.a.putInt("start_x", mKPlanNode.pt.getLongitudeE6());
            this.a.putInt("start_y", mKPlanNode.pt.getLatitudeE6());
            n2 = 1;
        }
        if (mKPlanNode.name != null && mKPlanNode.name.length() <= 99) {
            try {
                this.a.putByteArray("start_name", mKPlanNode.name.getBytes("gb2312"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                Log.d((String)"MKSearch walkingSearch:", (String)"translate start name error!!");
                Log.d((String)"MKSearch walkingSearch:", (String)unsupportedEncodingException.getMessage());
            }
            if (string != null && string.length() <= 31) {
                try {
                    this.a.putByteArray("start_city", string.getBytes("gb2312"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    Log.d((String)"MKSearch walkingSearch:", (String)"translate start city error!!");
                    Log.d((String)"MKSearch walkingSearch:", (String)unsupportedEncodingException.getMessage());
                }
            } else {
                return -1;
            }
            n2 = 1;
        }
        if (n2 == 0) {
            return -1;
        }
        n2 = 0;
        if (mKPlanNode2.pt != null) {
            this.a.putInt("end_x", mKPlanNode2.pt.getLongitudeE6());
            this.a.putInt("end_y", mKPlanNode2.pt.getLatitudeE6());
            n2 = 1;
        }
        if (mKPlanNode2.name != null && mKPlanNode2.name.length() <= 99) {
            try {
                this.a.putByteArray("end_name", mKPlanNode2.name.getBytes("gb2312"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                Log.d((String)"MKSearch walkingSearch:", (String)"translate end name error!!");
                Log.d((String)"MKSearch walkingSearch:", (String)unsupportedEncodingException.getMessage());
            }
            if (string2 != null && string2.length() <= 31) {
                try {
                    this.a.putByteArray("end_city", string2.getBytes("gb2312"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    Log.d((String)"MKSearch walkingSearch:", (String)"translate end city error!!");
                    Log.d((String)"MKSearch walkingSearch:", (String)unsupportedEncodingException.getMessage());
                }
            } else {
                return -1;
            }
            n2 = 1;
        }
        if (n2 == 0) {
            return -1;
        }
        n2 = Mj.sendBundle(this.a);
        if (n2 == 0) {
            return -1;
        }
        return 0;
    }

    public int offlineSearch(int n2) {
        if (this.a == null) {
            this.a = new Bundle();
        } else {
            this.a.clear();
        }
        this.a.putInt("act", 11010203);
        this.a.putInt("opt", 11010108);
        this.a.putInt("cityid", n2);
        if (Mj.i <= 180) {
            this.a.putInt("uid", 0);
        } else {
            this.a.putInt("uid", 1);
        }
        int n3 = Mj.sendBundle(this.a);
        if (n3 == 0) {
            return -1;
        }
        return 0;
    }
}

