DROP TABLE IF EXISTS yowao_admin_user;
CREATE TABLE yowao_admin_user (
  `name` varchar(32) NOT NULL default '',
  `password` varchar(32) NOT NULL default '',
  `level` int(1) NOT NULL default '0',
  adminright text,
  lastvisit int(11) NOT NULL default '0',
  lastip varchar(15) NOT NULL default '',
  UNIQUE KEY `name` (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk COLLATE=gbk_chinese_ci;

DROP TABLE IF EXISTS yowao_advert;
CREATE TABLE yowao_advert (
  id int(10) unsigned NOT NULL auto_increment,
  targets varchar(50) NOT NULL default '',
  varname varchar(20) NOT NULL default '',
  state tinyint(1) NOT NULL default '0',
  vieworder tinyint(4) default '0',
  title varchar(255) NOT NULL default '',
  config mediumtext NOT NULL,
  `day` int(11) NOT NULL,
  `week` int(11) NOT NULL,
  `month` int(11) NOT NULL,
  total int(11) NOT NULL,
  PRIMARY KEY  (id),
  KEY vieworder (vieworder),
  KEY state (state)
) ENGINE=MyISAM AUTO_INCREMENT=267 DEFAULT CHARSET=gbk COLLATE=gbk_chinese_ci;

DROP TABLE IF EXISTS yowao_city_cityclass;
CREATE TABLE yowao_city_cityclass (
  id int(15) NOT NULL auto_increment,
  `name` char(20) default NULL,
  keywords varchar(200) NOT NULL,
  description varchar(200) NOT NULL,
  displayorder int(11) NOT NULL default '100',
  sitenum int(11) NOT NULL default '0',
  path varchar(255) NOT NULL,
  template varchar(50) NOT NULL,
  PRIMARY KEY  (id)
) ENGINE=MyISAM AUTO_INCREMENT=11 DEFAULT CHARSET=gbk COLLATE=gbk_chinese_ci;

DROP TABLE IF EXISTS yowao_city_coolclass;
CREATE TABLE yowao_city_coolclass (
  id int(15) NOT NULL auto_increment,
  `name` char(20) default NULL,
  keywords varchar(200) NOT NULL,
  description varchar(200) NOT NULL,
  displayorder int(11) NOT NULL default '100',
  sitenum int(11) NOT NULL default '0',
  path varchar(255) NOT NULL,
  template varchar(50) NOT NULL,
  PRIMARY KEY  (id)
) ENGINE=MyISAM AUTO_INCREMENT=17 DEFAULT CHARSET=gbk COLLATE=gbk_chinese_ci;

DROP TABLE IF EXISTS yowao_city_coolsite;
CREATE TABLE yowao_city_coolsite (
  id int(11) NOT NULL auto_increment,
  `name` char(255) NOT NULL default '',
  url text NOT NULL,
  cityclass_id int(11) NOT NULL default '0',
  coolclass_id int(11) NOT NULL,
  displayorder int(11) NOT NULL default '100',
  starttime int(10) NOT NULL,
  endtime int(10) NOT NULL,
  namecolor char(7) NOT NULL,
  remark text NOT NULL,
  PRIMARY KEY  (id),
  KEY class (cityclass_id)
) ENGINE=MyISAM AUTO_INCREMENT=267 DEFAULT CHARSET=gbk COLLATE=gbk_chinese_ci;

DROP TABLE IF EXISTS yowao_city_id_name;
CREATE TABLE yowao_city_id_name (
  id int(11) NOT NULL auto_increment,
  city_id int(10) NOT NULL,
  city_name varchar(50) NOT NULL,
  PRIMARY KEY  (id)
) ENGINE=MyISAM AUTO_INCREMENT=2513 DEFAULT CHARSET=gbk COLLATE=gbk_chinese_ci;

DROP TABLE IF EXISTS yowao_city_mingzhan;
CREATE TABLE yowao_city_mingzhan (
  id int(11) NOT NULL auto_increment,
  `name` char(255) NOT NULL default '',
  url text NOT NULL,
  cityclass_id int(11) NOT NULL default '0',
  displayorder int(11) NOT NULL default '100',
  starttime int(10) NOT NULL,
  endtime int(10) NOT NULL,
  namecolor char(7) NOT NULL,
  inindex tinyint(1) NOT NULL default '1',
  remark text NOT NULL,
  PRIMARY KEY  (id),
  KEY class (cityclass_id)
) ENGINE=MyISAM AUTO_INCREMENT=107 DEFAULT CHARSET=gbk COLLATE=gbk_chinese_ci;

DROP TABLE IF EXISTS yowao_cknum;
CREATE TABLE yowao_cknum (
  sid varchar(8) NOT NULL default '',
  nmsg varchar(4) NOT NULL default '',
  `time` int(10) NOT NULL default '0',
  PRIMARY KEY  (sid)
) ENGINE=MyISAM DEFAULT CHARSET=gbk COLLATE=gbk_chinese_ci;

DROP TABLE IF EXISTS yowao_class;
CREATE TABLE yowao_class (
  classid int(15) NOT NULL auto_increment,
  parentid int(15) NOT NULL default '0',
  classname char(20) default NULL,
  displayorder int(11) NOT NULL default '100',
  sitenum int(11) NOT NULL default '0',
  path varchar(255) NOT NULL,
  keywords varchar(100) NOT NULL,
  description text NOT NULL,
  template varchar(50) NOT NULL,
  PRIMARY KEY  (classid)
) ENGINE=MyISAM AUTO_INCREMENT=2389 DEFAULT CHARSET=gbk COLLATE=gbk_chinese_ci;

DROP TABLE IF EXISTS yowao_config;
CREATE TABLE yowao_config (
  yl_name varchar(30) NOT NULL default '',
  yl_value text NOT NULL,
  PRIMARY KEY  (yl_name)
) ENGINE=MyISAM DEFAULT CHARSET=gbk COLLATE=gbk_chinese_ci;

DROP TABLE IF EXISTS yowao_coolclass;
CREATE TABLE yowao_coolclass (
  classid int(15) NOT NULL auto_increment,
  classname char(20) default NULL,
  displayorder int(11) NOT NULL default '100',
  sitenum int(11) NOT NULL default '0',
  path varchar(255) NOT NULL,
  PRIMARY KEY  (classid)
) ENGINE=MyISAM AUTO_INCREMENT=34 DEFAULT CHARSET=gbk COLLATE=gbk_chinese_ci;

DROP TABLE IF EXISTS yowao_coolsite;
CREATE TABLE yowao_coolsite (
  id int(11) NOT NULL auto_increment,
  `name` char(255) NOT NULL default '',
  url char(255) NOT NULL default '',
  class int(11) NOT NULL default '0',
  displayorder int(11) NOT NULL default '100',
  good tinyint(1) NOT NULL default '0',
  `day` int(11) NOT NULL,
  `week` int(11) NOT NULL,
  `month` int(11) NOT NULL,
  total int(11) NOT NULL,
  namecolor char(7) NOT NULL,
  yesterday int(11) NOT NULL default '0',
  byesterday int(11) NOT NULL default '0',
  starttime int(11) NOT NULL default '0',
  endtime int(11) NOT NULL default '0',
  remark text NOT NULL,
  `end` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (id),
  KEY url (url),
  KEY starttime (starttime),
  KEY endtime (endtime)
) ENGINE=MyISAM AUTO_INCREMENT=227 DEFAULT CHARSET=gbk COLLATE=gbk_chinese_ci;

DROP TABLE IF EXISTS yowao_feedback;
CREATE TABLE yowao_feedback (
  fid int(10) unsigned NOT NULL auto_increment,
  username varchar(20) NOT NULL default '',
  email varchar(30) NOT NULL default '',
  content text NOT NULL,
  add_time int(11) unsigned NOT NULL default '0',
  PRIMARY KEY  (fid)
) ENGINE=MyISAM DEFAULT CHARSET=gbk COLLATE=gbk_chinese_ci;

DROP TABLE IF EXISTS yowao_index_tool;
CREATE TABLE yowao_index_tool (
  id int(11) unsigned NOT NULL auto_increment,
  `name` varchar(50) NOT NULL,
  url varchar(255) NOT NULL,
  `order` int(3) NOT NULL,
  color varchar(10) NOT NULL,
  PRIMARY KEY  (id)
) ENGINE=MyISAM AUTO_INCREMENT=19 DEFAULT CHARSET=gbk COLLATE=gbk_chinese_ci;

DROP TABLE IF EXISTS yowao_ipstates;
CREATE TABLE yowao_ipstates (
  `day` char(10) NOT NULL default '',
  `month` char(7) NOT NULL default '',
  nums int(10) NOT NULL default '0',
  isp_dx int(11) NOT NULL default '0',
  isp_wt int(11) NOT NULL default '0',
  qvod int(11) NOT NULL default '0',
  PRIMARY KEY  (`day`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk COLLATE=gbk_chinese_ci;

DROP TABLE IF EXISTS yowao_keyword;
CREATE TABLE yowao_keyword (
  id int(11) NOT NULL auto_increment,
  class int(11) default '0',
  `name` varchar(10) NOT NULL default '',
  url char(255) NOT NULL default '',
  namecolor char(7) default NULL,
  displayorder int(11) NOT NULL default '0',
  `day` int(11) default '0',
  `week` int(11) default '0',
  `month` int(11) default '0',
  total int(11) default '0',
  yesterday int(11) NOT NULL default '0',
  byesterday int(11) NOT NULL default '0',
  PRIMARY KEY  (id),
  KEY classid (class)
) ENGINE=MyISAM DEFAULT CHARSET=gbk COLLATE=gbk_chinese_ci;

DROP TABLE IF EXISTS yowao_links;
CREATE TABLE yowao_links (
  id int(4) unsigned NOT NULL auto_increment,
  is_show smallint(1) NOT NULL default '1',
  sort int(4) NOT NULL,
  site_name varchar(50) NOT NULL,
  site_url text NOT NULL,
  add_time int(10) NOT NULL,
  remarks varchar(200) NOT NULL,
  PRIMARY KEY  (id)
) ENGINE=MyISAM AUTO_INCREMENT=25 DEFAULT CHARSET=gbk COLLATE=gbk_chinese_ci;

DROP TABLE IF EXISTS yowao_mingzhan;
CREATE TABLE yowao_mingzhan (
  id int(11) NOT NULL auto_increment,
  `name` varchar(50) NOT NULL COMMENT '',
  url varchar(255) NOT NULL COMMENT 'urlַ',
  namecolor char(7) NOT NULL COMMENT 'ɫ',
  displayorder mediumint(8) NOT NULL COMMENT '',
  starttime int(10) NOT NULL default '0' COMMENT 'ʼʱ',
  endtime int(10) NOT NULL default '0' COMMENT 'ʱ',
  remark text NOT NULL COMMENT 'ע',
  `day` int(11) NOT NULL default '0',
  yesterday int(11) NOT NULL default '0',
  byesterday int(11) NOT NULL default '0',
  `week` int(11) NOT NULL default '0',
  `month` int(11) NOT NULL default '0',
  total int(11) NOT NULL default '0',
  `end` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (id),
  KEY `name` (`name`),
  KEY starttime (starttime),
  KEY endtime (endtime)
) ENGINE=MyISAM AUTO_INCREMENT=97 DEFAULT CHARSET=gbk COLLATE=gbk_chinese_ci;

DROP TABLE IF EXISTS yowao_plan;
CREATE TABLE yowao_plan (
  id smallint(6) unsigned NOT NULL auto_increment,
  `subject` varchar(80) NOT NULL default '',
  `month` char(2) NOT NULL default '',
  `week` char(1) NOT NULL default '',
  `day` char(2) NOT NULL default '',
  `hour` varchar(80) NOT NULL default '',
  usetime int(10) NOT NULL default '0',
  nexttime int(10) NOT NULL default '0',
  ifsave tinyint(1) NOT NULL default '0',
  ifopen tinyint(1) NOT NULL default '0',
  filename varchar(80) NOT NULL default '',
  config text NOT NULL,
  PRIMARY KEY  (id)
) ENGINE=MyISAM DEFAULT CHARSET=gbk COLLATE=gbk_chinese_ci;

DROP TABLE IF EXISTS yowao_recycler;
CREATE TABLE yowao_recycler (
  id int(11) NOT NULL auto_increment,
  table_name enum('dh_site','dh_indexsite') NOT NULL,
  sitename varchar(100) NOT NULL default '',
  siteurl varchar(250) NOT NULL default '',
  oldclass int(11) NOT NULL default '0',
  namecolor char(7) default NULL,
  adduser varchar(25) default NULL,
  displayorder int(11) NOT NULL default '100',
  good tinyint(1) NOT NULL default '0',
  gooddisplayorder int(11) NOT NULL default '0',
  good2 tinyint(1) NOT NULL default '0',
  remark text NOT NULL,
  PRIMARY KEY  (id)
) ENGINE=MyISAM AUTO_INCREMENT=2016 DEFAULT CHARSET=gbk COLLATE=gbk_chinese_ci;

DROP TABLE IF EXISTS yowao_search;
CREATE TABLE yowao_search (
  id int(11) NOT NULL auto_increment,
  class int(11) NOT NULL,
  search_select char(20) default NULL,
  `action` text,
  `name` char(50) default NULL,
  btn char(50) default NULL,
  img_text varchar(50) default NULL,
  img_url text,
  url text,
  params text,
  sort int(11) NOT NULL default '100',
  is_show int(1) NOT NULL default '1',
  is_default int(1) NOT NULL default '0',
  PRIMARY KEY  (id)
) ENGINE=MyISAM AUTO_INCREMENT=40 DEFAULT CHARSET=gbk COLLATE=gbk_chinese_ci;

DROP TABLE IF EXISTS yowao_search_keyword;
CREATE TABLE yowao_search_keyword (
  id int(11) NOT NULL auto_increment,
  class int(11) default '0',
  `name` varchar(10) NOT NULL default '',
  url text NOT NULL,
  namecolor char(7) default NULL,
  sort int(11) NOT NULL default '0',
  `day` int(11) default '0',
  `week` int(11) default '0',
  `month` int(11) default '0',
  total int(11) default '0',
  starttime int(11) NOT NULL default '0',
  endtime int(11) NOT NULL default '0',
  remarks text NOT NULL,
  PRIMARY KEY  (id),
  KEY classid (class)
) ENGINE=MyISAM AUTO_INCREMENT=42 DEFAULT CHARSET=gbk COLLATE=gbk_chinese_ci;

DROP TABLE IF EXISTS yowao_searchclass;
CREATE TABLE yowao_searchclass (
  classid int(15) NOT NULL auto_increment,
  classname char(20) default NULL,
  sort int(11) NOT NULL default '100',
  is_default int(1) NOT NULL default '0',
  PRIMARY KEY  (classid)
) ENGINE=MyISAM AUTO_INCREMENT=15 DEFAULT CHARSET=gbk COLLATE=gbk_chinese_ci;

DROP TABLE IF EXISTS yowao_site;
CREATE TABLE yowao_site (
  id int(11) NOT NULL auto_increment,
  `name` char(255) NOT NULL default '',
  url char(255) NOT NULL default '',
  class int(11) NOT NULL default '0',
  displayorder int(11) NOT NULL default '100',
  good tinyint(1) NOT NULL default '0',
  good2 tinyint(1) NOT NULL default '0',
  `day` int(11) default '0',
  `week` int(11) default '0',
  `month` int(11) default '0',
  total int(11) default '0',
  gooddisplayorder mediumint(8) NOT NULL default '0',
  namecolor char(7) NOT NULL,
  adduser varchar(25) NOT NULL,
  yesterday int(11) NOT NULL default '0',
  byesterday int(11) NOT NULL default '0',
  starttime int(11) NOT NULL default '0',
  endtime int(11) NOT NULL default '0',
  remark text NOT NULL,
  `end` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (id),
  KEY class (class),
  KEY starttime (starttime),
  KEY endtime (endtime)
) ENGINE=MyISAM AUTO_INCREMENT=47321 DEFAULT CHARSET=gbk COLLATE=gbk_chinese_ci;

DROP TABLE IF EXISTS yowao_site_search;
CREATE TABLE yowao_site_search (
  id int(11) NOT NULL,
  displayorder int(11) NOT NULL,
  pinyin varchar(255) NOT NULL,
  `name` varchar(255) NOT NULL,
  url text NOT NULL,
  PRIMARY KEY  (id),
  KEY displayorder (displayorder)
) ENGINE=MyISAM DEFAULT CHARSET=gbk COLLATE=gbk_chinese_ci;

DROP TABLE IF EXISTS yowao_tool;
CREATE TABLE yowao_tool (
  id int(11) NOT NULL auto_increment,
  class int(11) NOT NULL default '0',
  `name` varchar(255) NOT NULL default '',
  url varchar(255) default NULL,
  displayorder int(11) NOT NULL default '100',
  inindex tinyint(1) NOT NULL default '0',
  `day` int(11) default '0',
  `week` int(11) default '0',
  `month` int(11) default '0',
  total int(11) default '0',
  indexdisplayorder mediumint(8) NOT NULL default '0',
  yesterday int(11) NOT NULL default '0',
  byesterday int(11) NOT NULL default '0',
  starttime int(11) NOT NULL default '0',
  endtime int(11) NOT NULL default '0',
  remark text NOT NULL,
  `end` tinyint(1) NOT NULL default '0',
  namecolor char(7) NOT NULL,
  PRIMARY KEY  (id),
  KEY starttime (starttime),
  KEY endtime (endtime)
) ENGINE=MyISAM AUTO_INCREMENT=2899 DEFAULT CHARSET=gbk COLLATE=gbk_chinese_ci;

DROP TABLE IF EXISTS yowao_toolclass;
CREATE TABLE yowao_toolclass (
  id int(11) NOT NULL auto_increment,
  `name` varchar(255) NOT NULL default '',
  displayorder int(11) NOT NULL default '100',
  `type` varchar(50) NOT NULL default '',
  inindex tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (id)
) ENGINE=MyISAM AUTO_INCREMENT=21 DEFAULT CHARSET=gbk COLLATE=gbk_chinese_ci;

DROP TABLE IF EXISTS yowao_urladd;
CREATE TABLE yowao_urladd (
  id int(11) NOT NULL auto_increment,
  domain varchar(250) default '',
  info text,
  addtime int(11) default NULL,
  `type` tinyint(2) default '0',
  shenhe text NOT NULL,
  PRIMARY KEY  (id),
  KEY domain (domain)
) ENGINE=MyISAM DEFAULT CHARSET=gbk COLLATE=gbk_chinese_ci;

DROP TABLE IF EXISTS yowao_zhuanti;
CREATE TABLE yowao_zhuanti (
  id int(11) NOT NULL auto_increment,
  `name` varchar(255) NOT NULL default '',
  displayorder int(11) NOT NULL default '100',
  inindex tinyint(1) NOT NULL default '1',
  path varchar(255) NOT NULL,
  template varchar(50) NOT NULL,
  PRIMARY KEY  (id)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=gbk COLLATE=gbk_chinese_ci;

DROP TABLE IF EXISTS yowao_zhuanticlass;
CREATE TABLE yowao_zhuanticlass (
  id int(11) NOT NULL auto_increment,
  zhuanti int(11) NOT NULL,
  `name` varchar(255) NOT NULL default '',
  displayorder int(11) NOT NULL default '100',
  inindex tinyint(1) NOT NULL default '0',
  url varchar(255) NOT NULL default '',
  PRIMARY KEY  (id)
) ENGINE=MyISAM AUTO_INCREMENT=125 DEFAULT CHARSET=gbk COLLATE=gbk_chinese_ci;

DROP TABLE IF EXISTS yowao_zhuantisite;
CREATE TABLE yowao_zhuantisite (
  id int(11) NOT NULL auto_increment,
  class int(11) NOT NULL default '0',
  `name` varchar(255) NOT NULL default '',
  url text,
  displayorder int(11) NOT NULL default '100',
  inindex tinyint(1) NOT NULL default '0',
  `day` int(11) default '0',
  `week` int(11) default '0',
  `month` int(11) default '0',
  total int(11) default '0',
  indexdisplayorder mediumint(8) NOT NULL default '0',
  yesterday int(11) NOT NULL default '0',
  byesterday int(11) NOT NULL default '0',
  starttime int(11) NOT NULL default '0',
  endtime int(11) NOT NULL default '0',
  remark text NOT NULL,
  `end` tinyint(1) NOT NULL default '0',
  namecolor char(7) NOT NULL,
  PRIMARY KEY  (id),
  KEY starttime (starttime),
  KEY endtime (endtime)
) ENGINE=MyISAM AUTO_INCREMENT=2893 DEFAULT CHARSET=gbk COLLATE=gbk_chinese_ci;


INSERT INTO yowao_advert VALUES('225','','notice','1','3','Ů ɫ','a:6:{s:9:\"starttime\";s:0:\"\";s:7:\"endtime\";s:0:\"\";s:5:\"style\";s:3:\"txt\";s:5:\"title\";s:17:\"Ů ɫ\";s:4:\"link\";s:75:\"http://zhuti.huoban.taobao.com/event.php?pid=mm_16140449_0_0&eventid=101305\";s:5:\"color\";s:0:\"\";}','0','0','0','0');
INSERT INTO yowao_advert VALUES('226','','notice','1','4',' ɹҸ','a:6:{s:9:\"starttime\";s:0:\"\";s:7:\"endtime\";s:0:\"\";s:5:\"style\";s:3:\"txt\";s:5:\"title\";s:13:\" ɹҸ\";s:4:\"link\";s:80:\"http://haibao.huoban.taobao.com/tms/topic.php?pid=mm_16140449_0_0&eventid=101134\";s:5:\"color\";s:0:\"\";}','0','0','0','0');
INSERT INTO yowao_advert VALUES('220','','footer','1','11','','a:6:{s:9:\"starttime\";s:0:\"\";s:7:\"endtime\";s:0:\"\";s:5:\"style\";s:3:\"txt\";s:5:\"title\";s:4:\"\";s:4:\"link\";s:86:\"http://pindao.huoban.taobao.com/tms/channel/man.htm?pid=mm_16140449_0_0&eventid=101330\";s:5:\"color\";s:0:\"\";}','0','0','0','0');
INSERT INTO yowao_advert VALUES('243','','footer','1','12','Ź','a:6:{s:9:\"starttime\";s:0:\"\";s:7:\"endtime\";s:0:\"\";s:5:\"style\";s:3:\"txt\";s:5:\"title\";s:4:\"Ź\";s:4:\"link\";s:21:\"http://tuan.yowao.com\";s:5:\"color\";s:0:\"\";}','0','0','0','0');
INSERT INTO yowao_advert VALUES('244','','footer','1','1','Ʊ','a:6:{s:9:\"starttime\";s:0:\"\";s:7:\"endtime\";s:0:\"\";s:5:\"style\";s:3:\"txt\";s:5:\"title\";s:4:\"Ʊ\";s:4:\"link\";s:53:\"http://union.500wan.com/114la.php?coopid=1415&adid=37\";s:5:\"color\";s:0:\"\";}','0','0','0','0');
INSERT INTO yowao_advert VALUES('245','','footer','1','13','۾','a:6:{s:9:\"starttime\";s:0:\"\";s:7:\"endtime\";s:0:\"\";s:5:\"style\";s:3:\"txt\";s:5:\"title\";s:4:\"۾\";s:4:\"link\";s:100:\"http://click.linktech.cn/?m=sigo&a=A100095510&l=99999&l_cd1=0&l_cd2=1&tu=http%3A%2F%2Fwww.sigo.cn%2F\";s:5:\"color\";s:0:\"\";}','0','0','0','0');
INSERT INTO yowao_advert VALUES('246','','footer','1','14','׬','a:6:{s:9:\"starttime\";s:0:\"\";s:7:\"endtime\";s:0:\"\";s:5:\"style\";s:3:\"txt\";s:5:\"title\";s:4:\"׬\";s:4:\"link\";s:35:\"http://www.9lianmeng.com/?uid=46198\";s:5:\"color\";s:0:\"\";}','0','0','0','0');
INSERT INTO yowao_advert VALUES('247','','footer','1','2','','a:6:{s:9:\"starttime\";s:0:\"\";s:7:\"endtime\";s:0:\"\";s:5:\"style\";s:3:\"txt\";s:5:\"title\";s:4:\"\";s:4:\"link\";s:89:\"http://pindao.huoban.taobao.com/tms/channel/beauty.htm?pid=mm_16140449_0_0&eventid=101328\";s:5:\"color\";s:0:\"\";}','0','0','0','0');
INSERT INTO yowao_advert VALUES('248','','footer','1','3','ȹ','a:6:{s:9:\"starttime\";s:0:\"\";s:7:\"endtime\";s:0:\"\";s:5:\"style\";s:3:\"txt\";s:5:\"title\";s:6:\"ȹ\";s:4:\"link\";s:110:\"http://search8.taobao.com/browse/search_auction.htm?q=%C1%AC%D2%C2%C8%B9&cat=0&pid=mm_16140449_0_0&viewIndex=7\";s:5:\"color\";s:0:\"\";}','0','0','0','0');
INSERT INTO yowao_advert VALUES('249','','footer','1','4','','a:6:{s:9:\"starttime\";s:0:\"\";s:7:\"endtime\";s:0:\"\";s:5:\"style\";s:3:\"txt\";s:5:\"title\";s:4:\"\";s:4:\"link\";s:104:\"http://search8.taobao.com/browse/search_auction.htm?q=%C1%BD%D0%D4&cat=0&pid=mm_16140449_0_0&viewIndex=7\";s:5:\"color\";s:0:\"\";}','0','0','0','0');
INSERT INTO yowao_advert VALUES('250','','footer','1','5','Ь','a:6:{s:9:\"starttime\";s:0:\"\";s:7:\"endtime\";s:0:\"\";s:5:\"style\";s:3:\"txt\";s:5:\"title\";s:2:\"Ь\";s:4:\"link\";s:34:\"http://www.letao.com/?source=kuku8\";s:5:\"color\";s:0:\"\";}','0','0','0','0');
INSERT INTO yowao_advert VALUES('251','','footer','1','6','ֱ','a:6:{s:9:\"starttime\";s:0:\"\";s:7:\"endtime\";s:0:\"\";s:5:\"style\";s:3:\"txt\";s:5:\"title\";s:4:\"\";s:4:\"link\";s:89:\"http://p.yiqifa.com/c?s=d59277fc&w=215569&c=6019&i=18344&l=0&e=kuku8&t=http://www.net.cn/\";s:5:\"color\";s:0:\"\";}','0','0','0','0');
INSERT INTO yowao_advert VALUES('252','','footer','1','7','ʵ','a:6:{s:9:\"starttime\";s:0:\"\";s:7:\"endtime\";s:0:\"\";s:5:\"style\";s:3:\"txt\";s:5:\"title\";s:6:\"ʵ\";s:4:\"link\";s:91:\"http://www.taobao.com/go/chn/tbk_channel/channelcode.php?pid=mm_16140449_0_0&eventid=101329\";s:5:\"color\";s:0:\"\";}','0','0','0','0');
INSERT INTO yowao_advert VALUES('253','','footer','1','8','ʼǱ','a:6:{s:9:\"starttime\";s:0:\"\";s:7:\"endtime\";s:0:\"\";s:5:\"style\";s:3:\"txt\";s:5:\"title\";s:6:\"ʼǱ\";s:4:\"link\";s:110:\"http://search8.taobao.com/browse/search_auction.htm?q=%B1%CA%BC%C7%B1%BE&cat=0&pid=mm_16140449_0_0&viewIndex=7\";s:5:\"color\";s:0:\"\";}','0','0','0','0');
INSERT INTO yowao_advert VALUES('254','','footer','1','9','麣Ź','a:6:{s:9:\"starttime\";s:0:\"\";s:7:\"endtime\";s:0:\"\";s:5:\"style\";s:3:\"txt\";s:5:\"title\";s:8:\"麣Ź\";s:4:\"link\";s:20:\"http://www.zh-sc.com\";s:5:\"color\";s:0:\"\";}','0','0','0','0');
INSERT INTO yowao_advert VALUES('255','','footer','1','10','Ů','a:6:{s:9:\"starttime\";s:0:\"\";s:7:\"endtime\";s:0:\"\";s:5:\"style\";s:3:\"txt\";s:5:\"title\";s:4:\"Ů\";s:4:\"link\";s:87:\"http://pindao.huoban.taobao.com/tms/channel/lady.htm?pid=mm_16140449_0_0&eventid=101345\";s:5:\"color\";s:0:\"\";}','0','0','0','0');
INSERT INTO yowao_advert VALUES('256','','notice','1','0','ȫ̳Ǵ','a:6:{s:9:\"starttime\";s:0:\"\";s:7:\"endtime\";s:0:\"\";s:5:\"style\";s:3:\"txt\";s:5:\"title\";s:22:\"ȫ̳Ǵ\";s:4:\"link\";s:90:\"http://pindao.huoban.taobao.com/tms/channel/digital.htm?pid=mm_16140449_0_0&eventid=101332\";s:5:\"color\";s:0:\"\";}','0','0','0','0');
INSERT INTO yowao_advert VALUES('257','','notice','1','1','زٷ̳','a:6:{s:9:\"starttime\";s:0:\"\";s:7:\"endtime\";s:0:\"\";s:5:\"style\";s:3:\"txt\";s:5:\"title\";s:12:\"زٷ̳\";s:4:\"link\";s:94:\"http://p.yiqifa.com/c?s=33c766fe&w=215569&c=6153&i=18162&l=0&e=kuku8&t=http://www.xtep.com.cn/\";s:5:\"color\";s:0:\"\";}','0','0','0','0');
INSERT INTO yowao_advert VALUES('258','','notice','1','2','','a:6:{s:9:\"starttime\";s:0:\"\";s:7:\"endtime\";s:0:\"\";s:5:\"style\";s:3:\"txt\";s:5:\"title\";s:12:\"\";s:4:\"link\";s:82:\"http://s.click.taobao.com/t_8?e=7HZ5x%2BOzdZ1aoNrm3lLPFWlzhQM%3D&p=mm_16140449_0_0\";s:5:\"color\";s:0:\"\";}','0','0','0','0');
INSERT INTO yowao_advert VALUES('259','','notice','1','5','MMؼ','a:6:{s:9:\"starttime\";s:0:\"\";s:7:\"endtime\";s:0:\"\";s:5:\"style\";s:3:\"txt\";s:5:\"title\";s:10:\"MMؼ\";s:4:\"link\";s:80:\"http://haibao.huoban.taobao.com/tms/topic.php?pid=mm_16140449_0_0&eventid=101055\";s:5:\"color\";s:0:\"\";}','0','0','0','0');
INSERT INTO yowao_advert VALUES('260','','footer','1','15','','a:6:{s:9:\"starttime\";s:0:\"\";s:7:\"endtime\";s:0:\"\";s:5:\"style\";s:3:\"txt\";s:5:\"title\";s:4:\"\";s:4:\"link\";s:80:\"http://haibao.huoban.taobao.com/tms/topic.php?pid=mm_16140449_0_0&eventid=101729\";s:5:\"color\";s:0:\"\";}','0','0','0','0');
INSERT INTO yowao_advert VALUES('261','','footer','1','16','Ƭ','a:6:{s:9:\"starttime\";s:0:\"\";s:7:\"endtime\";s:0:\"\";s:5:\"style\";s:3:\"txt\";s:5:\"title\";s:6:\"Ƭ\";s:4:\"link\";s:86:\"http://s.click.taobao.com/t_8?e=7HZ5x%2BOzdZVqN3oRCtPKSIa%2Blg%3D%3D&p=mm_16140449_0_0\";s:5:\"color\";s:0:\"\";}','0','0','0','0');
INSERT INTO yowao_advert VALUES('262','','footer','1','17','ؼ','a:6:{s:9:\"starttime\";s:0:\"\";s:7:\"endtime\";s:0:\"\";s:5:\"style\";s:3:\"txt\";s:5:\"title\";s:4:\"ؼ\";s:4:\"link\";s:105:\"http://shopping.moonbasa.com/rd/rd.aspx?a_id=mbs&other=kuku8&url=http://www.moonbasa.com/0901-1-20-0.html\";s:5:\"color\";s:0:\"\";}','0','0','0','0');
INSERT INTO yowao_advert VALUES('263','','footer','1','18','','a:6:{s:9:\"starttime\";s:0:\"\";s:7:\"endtime\";s:0:\"\";s:5:\"style\";s:3:\"txt\";s:5:\"title\";s:4:\"\";s:4:\"link\";s:93:\"http://p.yiqifa.com/c?s=0de0fa7e&w=215569&c=5402&i=11642&l=0&e=kuku8&t=http://bj.meituan.com/\";s:5:\"color\";s:0:\"\";}','0','0','0','0');
INSERT INTO yowao_advert VALUES('264','','footer','1','19','NALA̳','a:6:{s:9:\"starttime\";s:0:\"\";s:7:\"endtime\";s:0:\"\";s:5:\"style\";s:3:\"txt\";s:5:\"title\";s:8:\"NALA̳\";s:4:\"link\";s:89:\"http://p.yiqifa.com/c?s=d4e79e73&w=215569&c=5724&i=15402&l=0&e=&t=http://www.nala.com.cn/\";s:5:\"color\";s:0:\"\";}','0','0','0','0');
INSERT INTO yowao_advert VALUES('265','','footer','1','20','ο','a:6:{s:9:\"starttime\";s:0:\"\";s:7:\"endtime\";s:0:\"\";s:5:\"style\";s:3:\"txt\";s:5:\"title\";s:10:\"ο\";s:4:\"link\";s:32:\" http://www.jacketman.cn/?u=1344\";s:5:\"color\";s:0:\"\";}','0','0','0','0');
INSERT INTO yowao_advert VALUES('266','','footer','1','2','Ʊ','a:6:{s:9:\"starttime\";s:0:\"\";s:7:\"endtime\";s:0:\"\";s:5:\"style\";s:3:\"txt\";s:5:\"title\";s:4:\"Ʊ\";s:4:\"link\";s:89:\"http://pindao.huoban.taobao.com/tms/channel/jipiao.htm?pid=mm_16140449_0_0&eventid=101829\";s:5:\"color\";s:0:\"\";}','0','0','0','0');

INSERT INTO yowao_city_cityclass VALUES('1','Ϻ','','','2','0','shanghai','');
INSERT INTO yowao_city_cityclass VALUES('3','','','','3','0','guagnzhou','');
INSERT INTO yowao_city_cityclass VALUES('5','','','','4','0','shenzhen','');
INSERT INTO yowao_city_cityclass VALUES('10','','','','1','0','beijing','');

INSERT INTO yowao_city_coolclass VALUES('1','','','','1','0','','');
INSERT INTO yowao_city_coolclass VALUES('2','̳','','','2','0','','');
INSERT INTO yowao_city_coolclass VALUES('3','','','','3','0','','');
INSERT INTO yowao_city_coolclass VALUES('4','ʳ','','','4','0','','');
INSERT INTO yowao_city_coolclass VALUES('6','','','','5','0','','');
INSERT INTO yowao_city_coolclass VALUES('10','','','','7','0','','');
INSERT INTO yowao_city_coolclass VALUES('9','ҽԺ','','','6','0','','');
INSERT INTO yowao_city_coolclass VALUES('11','','','','13','0','','');
INSERT INTO yowao_city_coolclass VALUES('12','','','','8','0','','');
INSERT INTO yowao_city_coolclass VALUES('13','ѧУ','','','9','0','','');
INSERT INTO yowao_city_coolclass VALUES('14','ͨ','','','10','0','','');
INSERT INTO yowao_city_coolclass VALUES('15','','','','11','0','','');
INSERT INTO yowao_city_coolclass VALUES('16','','','','12','0','','');

INSERT INTO yowao_city_coolsite VALUES('8','','http://sh.eastday.com/','1','1','3','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('6','Ϻ','http://www.sh.chinanews.com.cn/','1','1','1','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('7','Ű칫','http://www.shio.gov.cn/','1','1','2','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('9','Ϻ','http://sh.sina.com.cn/news/','1','1','4','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('10','»Ϻ','http://www.sh.xinhuanet.com/','1','1','5','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('11','Ϻ̳','http://bbs.online.sh.cn/','1','2','1','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('12','ɽ','http://club.pchome.net/forum_1_15.html','1','2','2','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('13','ᰮϺ̳','http://bbs.kooaoo.com/','1','2','3','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('14','ϻ̳','http://bbs.52life.cc/','1','2','4','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('15','׳','http://www.sj.net.cn/','1','2','5','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('16','Ϻ̨','http://www.smg.cn/','1','3','1','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('17','ʿ','http://www.dragontv.cn/','1','3','2','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('18','Ϻ̨','http://www.bbtv.cn/','1','3','3','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('19','̨','http://www.setv.sh.cn/','1','3','4','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('20','Sitv','http://www.sitv.com.cn/','1','3','5','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('21','ڱ','http://shanghai.koubei.com/cate','1','4','1','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('22','ʳ','http://shanghaimeishi.abang.com/','1','4','2','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('23','ͳ','http://shanghai.fantong.com/','1','4','3','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('24','ڵ','http://www.dianping.com/shanghai/food','1','4','4','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('25','POCOϺʳ','http://sh.food.poco.cn/','1','4','5','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('26','һŵ','http://p.yiqifa.com/c?s=9786eaf0&w=148326&c=139&i=802&l=0&e=d&t=http://www.yihaodian.com/product/index.do','1','6','1','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('27','CJ','http://www.ocj.com.cn/','1','6','2','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('28','','http://www.lashou.com/guangzhou','1','6','3','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('29','̳','http://p.yiqifa.com/c?s=dc1c5515&w=148281&c=4509&i=5862&l=0&e=mz&t=http://www.360buy.com','1','6','4','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('30','','http://www.womai.com/','1','6','5','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('31','ҽԺ','http://www.hqhospital.cn/','1','9','1','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('32','ɽҽԺ','http://www.huashan.org.cn/','1','9','2','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('33','ʼҽԺ','http://www.renji.com/','1','9','3','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('34','ϺжͯҽԺ','http://www.shchildren.com.cn/','1','9','4','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('35','ϺɽҽԺ','http://www.zs-hospital.sh.cn/','1','9','5','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('36','Ϻ','http://www.bankofshanghai.com/','1','10','1','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('37','Ϻַ','http://www.spdb.com.cn/','1','10','2','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('38','Ϻũ','http://www.srcb.com/','1','10','3','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('39','','http://www.ccb.com/','1','10','4','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('40','','http://www.cmbchina.com/','1','10','5','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('41','Ϻ','http://www.shanghai.gov.cn/','1','11','1','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('42','й','http://www.police.sh.cn/','1','11','2','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('43','Э','http://shszx.eastday.com/','1','11','3','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('44','','http://mzj.sh.gov.cn/','1','11','4','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('45','в','http://www.csj.sh.gov.cn/gb/csj/index.html','1','11','5','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('46','Ϻ','http://www.shanghaitour.net/','1','15','1','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('47','','http://www.expo.cn/','1','15','2','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('48','Ϻ','http://www.shanghaimuseum.net/','1','15','3','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('49','Ϻ','http://www.ssc.sh.cn/','1','15','4','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('50','ϺƼ','http://www.sstm.org.cn/','1','15','5','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('51','Ϻ','http://www.shmetro.com/','1','14','1','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('52','Ϻ','http://www.shanghaibus.net/','1','14','2','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('53','Ϻ','http://www.shanghaiairport.com/','1','14','3','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('54','Ϻվ','http://www.shhcz.com.cn/','1','14','4','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('55',';վ','http://www.ctnz.net/','1','14','5','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('56','ѧ','http://www.fudan.edu.cn/','1','13','1','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('57','ͬôѧ','http://www.tongji.edu.cn/','1','13','2','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('58','Ϻͨѧ','http://www.sjtu.edu.cn/','1','13','3','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('59','ѧ','http://www.ecust.edu.cn/','1','13','4','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('60','Ϻƾѧ','http://www.shufe.edu.cn/','1','13','5','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('61','Ϻ˲','http://www.dshrc.com/','1','12','1','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('62','Ϻ˲','http://www.shanghairc.com/','1','12','2','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('63','ϺƸ','http://www.shjob.cn/','1','12','3','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('64','','http://www.sc.sh.cn/','1','12','4','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('65','Ϻҵ','http://www.sh91.com/','1','12','5','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('66','¬','http://www.luwan.sh.cn/','1','16','1','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('67','','http://www.shhp.gov.cn/shhp_1/Chinese/','1','16','2','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('68','','http://www.jingan.gov.cn/','1','16','3','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('69','','http://www.xh.sh.cn/','1','16','4','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('70','','http://hkq.sh.gov.cn/','1','16','5','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('71','','http://news.gd.sina.com.cn/guangzhou/','3','1','3','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('72','','http://www.gznews.gov.cn/','3','1','1','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('73','ձ','http://news.dayoo.com/guangzhou/','3','1','2','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('74','Ϸ','http://www.southcn.com/news/dishi/guangzhou/','3','1','4','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('75','Ӵ','http://news.gznet.com/','3','1','5','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('76','̳','http://www.kugz.net/','3','2','1','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('77','خ','http://www.py168.com/','3','2','2','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('78','̳','http://www.hdbbs.net/','3','2','3','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('79','','http://club.gznet.com/','3','2','4','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('80','̳','http://www.mytianhe.com/','3','2','5','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('81','','http://www.gztv.com/','3','3','1','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('82','齭Ƶ','http://www.gdtv.com.cn/newpage/dabenying/zjpd2/index.asp','3','3','2','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('83','㶫̨','http://www.gdtv.com.cn/','3','3','3','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('84','','http://www.goofm.com/','3','3','4','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('85','Ϸ̨','http://www.tvscn.com/','3','3','5','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('86','һҽԺ','http://www.81ts.com/CRMWeb/','3','9','1','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('87','ϷҽԺ','http://www.nfyy.com/','3','9','2','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('88','ڶҽԺ','http://www.gd2h.com/','3','9','3','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('89','дһԺ','http://www.gzsums.net/','3','9','4','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('90','ʡҽԺ','http://www.e5413.com/','3','9','5','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('91','Ӵʳ','http://food.gznet.com/','3','4','1','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('92','ʳڹ','http://www.gzmeal.com/','3','4','2','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('93','ͳ','http://guangzhou.fantong.com/','3','4','3','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('94','ڵ','http://www.dianping.com/guangzhou/food','3','4','4','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('95','ʳ','http://www.chi020.com/','3','4','5','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('96','Ա','http://www.taobao.com/','3','6','1','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('97','','http://www.meituan.com/guangzhou','3','6','2','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('98','','http://www.lashou.com/guangzhou','3','6','3','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('99','̳','http://p.yiqifa.com/c?s=dc1c5515&w=148281&c=4509&i=5862&l=0&e=mz&t=http://www.360buy.com','3','6','4','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('100','','http://www.womai.com/','3','6','5','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('101','','http://www.gzcb.com.cn/','3','10','1','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('102','ũҵ','http://www.961111.cn/','3','10','2','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('103','','http://www.icbc.com.cn/','3','10','3','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('104','㶫չ','http://www.gdb.com.cn/','3','10','4','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('105','','http://www.cmbchina.com/','3','10','5','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('106','ݹ','http://www.gz-bus.com/','3','14','1','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('107','ӿվ','http://www.tianhebus.com/','3','14','2','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('108','ɽѧ','http://www.zsu.edu.cn/','3','13','1','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('109','ѧ','http://www.scut.edu.cn/','3','13','2','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('110','һ','http://www.gzsyz.com/','3','13','3','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('111','ݶ','http://www.gdgzez.com.cn/','3','13','4','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('112','ƼְҵѧԺ','http://www.gzkjxy.net/','3','13','5','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('113','վվ','http://www.gzdzcz.com/','3','14','3','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('114','Խվ','http://www.yxnz.com.cn/','3','14','4','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('115','վ','http://hzstation.gzzc.com.cn/','3','14','5','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('116','㽭԰','http://www.xjzoo.com.cn/','3','15','1','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('117','¡','http://www.chimelongparadise.com/','3','15','2','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('118','','http://www.visitgz.com/','3','15','3','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('119','¡ȼ','http://www.chimelong.com/','3','15','4','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('120','ɽ','http://www.baiyunshan.com.cn/','3','15','5','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('121','','http://www.gz.gov.cn/','3','16','1','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('122','','http://www.thnet.gov.cn/','3','16','2','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('123','Խ','http://www.yuexiu.gov.cn/yxxxw/index/','3','16','3','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('124','','http://www.lw.gov.cn/','3','16','4','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('125','خ','http://www.panyu.gov.cn/jsp/','3','16','5','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('126','й̾','http://www.gzaic.gov.cn/','3','11','1','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('127','й','http://www.gzjd.gov.cn/','3','11','2','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('128','н','http://www.gzedu.gov.cn/','3','11','3','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('129','ݺ','http://guangzhou.customs.gov.cn/','3','11','4','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('130','','http://www.gzfb.gov.cn/','3','11','5','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('131','','http://www.gzpi.gov.cn/gzpi07/index.html','3','12','1','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('132','˲','http://www.020job.com/','3','12','2','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('133','Ͷ','http://www.gzlss.gov.cn/','3','12','3','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('134','Ƹ','http://www.hr020.cn/','3','12','4','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('135','齭˲','http://gz.zhujiangrc.com/','3','12','5','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('136','','http://www.sznews.com/','5','1','1','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('137','һ','http://news.oeeee.com/','5','1','2','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('138','Ϸĩ','http://www.infzm.com/','5','1','3','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('139','Ϸ','http://news.southcn.com/dishi/sz/','5','1','4','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('140','¿챨','http://epaper.xkb.com.cn/','5','1','5','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('202','й','http://www.chinanews.com.cn/','10','1','1','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('142','','http://www.pengyouwo.com/','5','2','2','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('143','','http://club.sz.net.cn/','5','2','3','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('144','ְҵ̳','http://www.szbbs.cn/','5','2','4','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('145','','http://www.pengchengwan.com/','5','2','5','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('146','ڵ̨','http://www.sztv.com.cn/','5','3','1','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('147','ڵ̨','http://www.szr.com.cn/','5','3','2','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('148','Ѷ','http://www.topway.com.cn/','5','3','3','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('149','㶫̨','http://www.gdtv.com.cn/','5','3','4','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('150','Ϸ̨','http://www.tvscn.com/','5','3','5','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('151','ҽԺ','http://www.szhospital.com/','5','9','1','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('152','ڱҽԺ','http://www.pkuszh.com/','5','9','2','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('153','ҽԺ','http://www.91group.com/','5','9','3','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('154','ڶҽԺ','http://www.szrch.com/','5','9','4','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('155','ҽԺ','http://www.boai.com/','5','9','5','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('156','˲','http://www.szhr.com.cn/','5','12','1','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('157','˲Ƹ','http://www.0755rc.com/','5','12','2','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('158','Ƹ','http://www.hr0755.com/','5','12','3','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('159','й˲','http://www.cjol.com/shenzhen/','5','12','4','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('160','Ƹ','http://www.szsh.com/','5','12','5','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('161','ڴѧ','http://www.szu.edu.cn/szu2007/','5','13','1','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('162','㲥Ӵѧ','http://www.szrtvu.com.cn/','5','13','2','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('163','ְҵѧԺ','http://www.szpt.edu.cn/','5','13','3','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('164','߼ʦѧУ','http://www.ssti.net.cn/','5','13','4','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('165','ǿְУ','http://www.szhqzx.net/','5','13','5','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('166','','http://www.shenzhentour.com/','5','15','1','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('167','֮','http://www.szwwco.com/','5','15','2','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('168','Ұ԰','http://www.szzoo.net/','5','15','3','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('169','','http://www.evergreen-cn.com/','5','15','4','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('170','С÷ɳ','http://www.szxms.com.cn/','5','15','5','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('171','ڱ','http://shenzhen.koubei.com/cate','5','4','1','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('172','ʳ','http://www.szeat.net/','5','4','2','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('173','ͳ','http://shenzhen.fantong.com/','5','4','3','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('174','ڵ','http://www.dianping.com/shenzhen/food','5','4','4','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('175','ζͨ','http://eat.sz.net.cn/','5','4','5','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('176','Ա','http://pindao.huoban.taobao.com/tms/channel/onsale.htm?pid=mm_11836333_2239687_8764474&eventid=&unid=148281','5','6','1','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('177','̳','http://p.yiqifa.com/c?s=dc1c5515&w=148281&c=4509&i=5862&l=0&e=mz&t=http://www.360buy.com','5','6','2','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('178','','http://www.lashou.com/shenzhen','5','6','3','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('179','','http://www.womai.com/','5','6','5','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('180','','http://www.meituan.com/','5','6','4','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('181','ڷչ','http://www.sdb.com.cn/website/page','5','10','1','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('182','㷢','http://www.gdb.com.cn/','5','10','2','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('183','ũ','http://www.961200.net/','5','10','3','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('184','','http://www.ccb.com/','5','10','4','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('185','','http://www.cmbchina.com/','5','10','5','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('186','ڵ','http://www.szmc.net/','5','14','1','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('187','ڹ','http://www.szbus.com.cn/','5','14','2','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('188','ʻ','http://www.szairport.com/','5','14','3','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('189','ڻվ','http://hcp.sz.bendibao.com/szstation/','5','14','4','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('190','վһ','http://jt.sz.bendibao.com/keche/','5','14','5','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('191','޺','http://www.szlh.gov.cn/main/','5','16','1','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('192','','http://www.szft.gov.cn/zf/','5','16','2','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('193','','http://www.lg.gov.cn/','5','16','3','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('194','ɽ','http://www.szns.gov.cn/','5','16','4','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('195','','http://www.baoan.gov.cn/main/','5','16','5','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('196','ڼί','http://www.szmj.gov.cn/','5','11','1','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('197','й','http://www.szga.gov.cn/','5','11','2','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('198','ط˰','http://www.szds.gov.cn/','5','11','3','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('199','˴','http://www.szrd.gov.cn/','5','11','4','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('200','Ͷ','http://www.szhrss.gov.cn/','5','11','5','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('201','̳','http://szbbs.sznews.com/','5','2','1','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('203','»','http://www.bj.xinhuanet.com/','10','1','2','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('204','','http://www.morningpost.com.cn/','10','1','3','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('205','¾','http://www.bjnews.com.cn/','10','1','4','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('206','','http://www.bjd.com.cn/','10','1','5','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('207','','http://www.wangjing.cn/','10','2','1','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('208','','http://www.hlgnet.com/','10','2','2','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('209','ͨ','http://www.bato.cn/','10','2','3','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('210','̳','http://www.hupub.com/','10','2','4','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('211','ׯ','http://www.yz010.com/','10','2','5','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('212','̨','http://www.btv.com.cn/','10','3','1','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('213','CCTV','http://www.cntv.cn/','10','3','2','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('214','㲥','http://listen.rbc.cn/','10','3','3','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('215','ͨ㲥','http://fm1039.rbc.cn/wszb/','10','3','4','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('216','CCTV','http://bugu.cntv.cn/news/china/xinwenlianbo/videopage/index.shtml','10','3','5','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('217','ҽԺ','http://www.bjhmoh.cn/','10','9','1','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('218','301ҽԺ','http://www.301hospital.com.cn/','10','9','2','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('219','ЭҽԺ','http://www.pumch.cn/','10','9','3','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('220','ͬҽԺ','http://www.trhos.com/','10','9','4','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('221','ҽԺ','http://www.ljzy.com.cn/','10','9','5','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('222','˲','http://www.bjrc.com/','10','12','1','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('223','׶˲','http://www.shoudurc.com/','10','12','2','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('224','˲','http://www.beijingrc.com/','10','12','3','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('225','лӢűվ','http://beijing.chinahr.com/','10','12','4','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('226','˲Ϣ','http://www.bjp.gov.cn/renshiju/','10','12','5','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('227','廪ѧ','http://www.tsinghua.edu.cn/','10','13','1','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('228','ѧ','http://www.pku.edu.cn/','10','13','2','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('229','ʦѧ','http://www.bnu.edu.cn/','10','13','3','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('230','ͨѧ','http://www.njtu.edu.cn/','10','13','4','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('231','׶ʦѧ','http://www.cnu.edu.cn/','10','13','5','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('232','Ϣ','http://www.bjta.gov.cn/','10','15','1','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('233','ʹԺ','http://www.dpm.org.cn/','10','15','2','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('234','Ҳ','http://www.chnmuseum.cn/','10','15','3','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('235','繫԰','http://www.beijingworldpark.com.cn/','10','15','4','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('236','Բ԰','http://www.yuanmingyuanpark.com/','10','15','5','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('237','ڱ','http://beijing.koubei.com/cate','10','4','1','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('238','ʳ','http://beijingmeishi.abang.com/','10','4','2','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('239','ͳ','http://beijing.fantong.com/','10','4','3','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('240','ڵ','http://www.dianping.com/beijing/food','10','4','4','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('241','POCOʳ','http://bj.food.poco.cn/','10','6','5','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('242','Ա','http://www.taobao.com/','10','6','1','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('243','','http://www.meituan.com/beijing','10','6','2','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('244','','http://www.lashou.com/beijing','10','6','3','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('245','̳','http://p.yiqifa.com/c?s=dc1c5515&w=148281&c=4509&i=5862&l=0&e=mz&t=http://www.360buy.com','10','6','4','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('246','','http://www.womai.com/','10','4','5','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('247','','http://www.bankofbeijing.com.cn/','10','10','1','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('248','ũҵ','http://www.bjrcb.com/','10','10','2','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('249','','http://www.pbc.gov.cn/','10','10','3','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('250','','http://www.ccb.com/','10','10','4','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('251','','http://www.cmbchina.com/','10','10','5','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('252','','http://www.bjsubway.com/','10','14','1','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('253','','http://www.bjbus.com/','10','14','2','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('254','׶','http://www.bcia.com.cn/','10','14','3','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('255','վ','http://www.bjhcz.net/','10','14','4','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('256','ؿվ','http://www.bjalsa.com.cn/','10','14','5','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('257','׶֮','http://www.beijing.gov.cn/','10','16','1','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('258','','http://www.bjchy.gov.cn/','10','16','2','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('259','','http://www.bjhd.gov.cn/','10','16','3','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('260','','http://www.bjdch.gov.cn/','10','16','4','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('261','','http://www.bjxch.gov.cn/','10','16','5','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('262','˴ί','http://www.bjrd.gov.cn/','10','11','1','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('263','в','http://www.bjcz.gov.cn/','10','11','2','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('264','Э','http://www.bjzx.gov.cn/','10','11','3','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('265','й','http://www.bjgaj.gov.cn/','10','11','4','0','0','','');
INSERT INTO yowao_city_coolsite VALUES('266','','http://www.bjhb.gov.cn/','10','11','5','0','0','','');

INSERT INTO yowao_city_id_name VALUES('1','101010100','');
INSERT INTO yowao_city_id_name VALUES('2','101010200','');
INSERT INTO yowao_city_id_name VALUES('3','101010300','');
INSERT INTO yowao_city_id_name VALUES('4','101010400','˳');
INSERT INTO yowao_city_id_name VALUES('5','101010500','');
INSERT INTO yowao_city_id_name VALUES('6','101010600','ͨ');
INSERT INTO yowao_city_id_name VALUES('7','101010700','ƽ');
INSERT INTO yowao_city_id_name VALUES('8','101010800','');
INSERT INTO yowao_city_id_name VALUES('9','101010900','̨');
INSERT INTO yowao_city_id_name VALUES('10','101011000','ʯɽ');
INSERT INTO yowao_city_id_name VALUES('11','101011100','');
INSERT INTO yowao_city_id_name VALUES('12','101011200','ɽ');
INSERT INTO yowao_city_id_name VALUES('13','101011300','');
INSERT INTO yowao_city_id_name VALUES('14','101011400','ͷ');
INSERT INTO yowao_city_id_name VALUES('15','101011500','ƽ');
INSERT INTO yowao_city_id_name VALUES('16','101011600','˴');
INSERT INTO yowao_city_id_name VALUES('17','101011700','ү');
INSERT INTO yowao_city_id_name VALUES('18','101011800','ӿ');
INSERT INTO yowao_city_id_name VALUES('19','101011900','ϵ');
INSERT INTO yowao_city_id_name VALUES('20','101012000','ի');
INSERT INTO yowao_city_id_name VALUES('21','101012100','ϼ');
INSERT INTO yowao_city_id_name VALUES('22','101020100','Ϻ');
INSERT INTO yowao_city_id_name VALUES('23','101020200','');
INSERT INTO yowao_city_id_name VALUES('24','101020300','ɽ');
INSERT INTO yowao_city_id_name VALUES('25','101020400','ɳ');
INSERT INTO yowao_city_id_name VALUES('26','101020500','ζ');
INSERT INTO yowao_city_id_name VALUES('27','101020600','ϻ');
INSERT INTO yowao_city_id_name VALUES('28','101020700','ɽ');
INSERT INTO yowao_city_id_name VALUES('29','101020800','');
INSERT INTO yowao_city_id_name VALUES('30','101020900','ɽ');
INSERT INTO yowao_city_id_name VALUES('31','101021000','');
INSERT INTO yowao_city_id_name VALUES('32','101021100','');
INSERT INTO yowao_city_id_name VALUES('33','101021101','¼');
INSERT INTO yowao_city_id_name VALUES('34','101021102','ˮ');
INSERT INTO yowao_city_id_name VALUES('35','101030100','');
INSERT INTO yowao_city_id_name VALUES('36','101030200','');
INSERT INTO yowao_city_id_name VALUES('37','101030300','');
INSERT INTO yowao_city_id_name VALUES('38','101030400','');
INSERT INTO yowao_city_id_name VALUES('39','101030500','');
INSERT INTO yowao_city_id_name VALUES('40','101030600','');
INSERT INTO yowao_city_id_name VALUES('41','101030700','');
INSERT INTO yowao_city_id_name VALUES('42','101030800','');
INSERT INTO yowao_city_id_name VALUES('43','101030900','');
INSERT INTO yowao_city_id_name VALUES('44','101031000','');
INSERT INTO yowao_city_id_name VALUES('45','101031100','');
INSERT INTO yowao_city_id_name VALUES('46','101031200','');
INSERT INTO yowao_city_id_name VALUES('47','101031300','ƽ̨');
INSERT INTO yowao_city_id_name VALUES('48','101031400','');
INSERT INTO yowao_city_id_name VALUES('49','101040100','');
INSERT INTO yowao_city_id_name VALUES('50','101040200','');
INSERT INTO yowao_city_id_name VALUES('51','101040300','ϴ');
INSERT INTO yowao_city_id_name VALUES('52','101040400','ϴ');
INSERT INTO yowao_city_id_name VALUES('53','101040500','');
INSERT INTO yowao_city_id_name VALUES('54','101040600','ʢ');
INSERT INTO yowao_city_id_name VALUES('55','101040700','山');
INSERT INTO yowao_city_id_name VALUES('56','101040800','');
INSERT INTO yowao_city_id_name VALUES('57','101040900','');
INSERT INTO yowao_city_id_name VALUES('58','101041000','');
INSERT INTO yowao_city_id_name VALUES('59','101041100','ǭ');
INSERT INTO yowao_city_id_name VALUES('60','101041200','');
INSERT INTO yowao_city_id_name VALUES('61','101041300','');
INSERT INTO yowao_city_id_name VALUES('62','101041400','');
INSERT INTO yowao_city_id_name VALUES('63','101041500','');
INSERT INTO yowao_city_id_name VALUES('64','101041600','ǿ');
INSERT INTO yowao_city_id_name VALUES('65','101041700','');
INSERT INTO yowao_city_id_name VALUES('66','101041800','Ϫ');
INSERT INTO yowao_city_id_name VALUES('67','101041900','');
INSERT INTO yowao_city_id_name VALUES('68','101042000','ɽ');
INSERT INTO yowao_city_id_name VALUES('69','101042100','');
INSERT INTO yowao_city_id_name VALUES('70','101042200','潭');
INSERT INTO yowao_city_id_name VALUES('71','101042300','ƽ');
INSERT INTO yowao_city_id_name VALUES('72','101042400','');
INSERT INTO yowao_city_id_name VALUES('73','101042500','ʯ');
INSERT INTO yowao_city_id_name VALUES('74','101042600','');
INSERT INTO yowao_city_id_name VALUES('75','101042700','ٲ');
INSERT INTO yowao_city_id_name VALUES('76','101042800','ͭ');
INSERT INTO yowao_city_id_name VALUES('77','101042900','ɽ');
INSERT INTO yowao_city_id_name VALUES('78','101043000','ᶼ');
INSERT INTO yowao_city_id_name VALUES('79','101043100','¡');
INSERT INTO yowao_city_id_name VALUES('80','101043200','ˮ');
INSERT INTO yowao_city_id_name VALUES('81','101043300','뽭');
INSERT INTO yowao_city_id_name VALUES('82','101043400','');
INSERT INTO yowao_city_id_name VALUES('83','101043500','ɽ');
INSERT INTO yowao_city_id_name VALUES('84','101043600','ɽ');
INSERT INTO yowao_city_id_name VALUES('85','101050101','');
INSERT INTO yowao_city_id_name VALUES('86','101050102','˫');
INSERT INTO yowao_city_id_name VALUES('87','101050103','');
INSERT INTO yowao_city_id_name VALUES('88','101050104','');
INSERT INTO yowao_city_id_name VALUES('89','101050105','');
INSERT INTO yowao_city_id_name VALUES('90','101050106','');
INSERT INTO yowao_city_id_name VALUES('91','101050107','');
INSERT INTO yowao_city_id_name VALUES('92','101050108','ͨ');
INSERT INTO yowao_city_id_name VALUES('93','101050109','');
INSERT INTO yowao_city_id_name VALUES('94','101050110','');
INSERT INTO yowao_city_id_name VALUES('95','101050111','־');
INSERT INTO yowao_city_id_name VALUES('96','101050112','峣');
INSERT INTO yowao_city_id_name VALUES('97','101050113','ľ');
INSERT INTO yowao_city_id_name VALUES('98','101050201','');
INSERT INTO yowao_city_id_name VALUES('99','101050202','ګ');
INSERT INTO yowao_city_id_name VALUES('100','101050203','');
INSERT INTO yowao_city_id_name VALUES('101','101050204','');
INSERT INTO yowao_city_id_name VALUES('102','101050205','ԣ');
INSERT INTO yowao_city_id_name VALUES('103','101050206','');
INSERT INTO yowao_city_id_name VALUES('104','101050207','Ȫ');
INSERT INTO yowao_city_id_name VALUES('105','101050208','ɽ');
INSERT INTO yowao_city_id_name VALUES('106','101050209','˶');
INSERT INTO yowao_city_id_name VALUES('107','101050210','̩');
INSERT INTO yowao_city_id_name VALUES('108','101050301','ĵ');
INSERT INTO yowao_city_id_name VALUES('109','101050302','');
INSERT INTO yowao_city_id_name VALUES('110','101050303','');
INSERT INTO yowao_city_id_name VALUES('111','101050304','ֿ');
INSERT INTO yowao_city_id_name VALUES('112','101050305','Һ');
INSERT INTO yowao_city_id_name VALUES('113','101050306','');
INSERT INTO yowao_city_id_name VALUES('114','101050307','');
INSERT INTO yowao_city_id_name VALUES('115','101050401','ľ˹');
INSERT INTO yowao_city_id_name VALUES('116','101050402','ԭ');
INSERT INTO yowao_city_id_name VALUES('117','101050403','Զ');
INSERT INTO yowao_city_id_name VALUES('118','101050404','봨');
INSERT INTO yowao_city_id_name VALUES('119','101050405','');
INSERT INTO yowao_city_id_name VALUES('120','101050406','ͬ');
INSERT INTO yowao_city_id_name VALUES('121','101050407','');
INSERT INTO yowao_city_id_name VALUES('122','101050501','绯');
INSERT INTO yowao_city_id_name VALUES('123','101050502','ض');
INSERT INTO yowao_city_id_name VALUES('124','101050503','');
INSERT INTO yowao_city_id_name VALUES('125','101050504','');
INSERT INTO yowao_city_id_name VALUES('126','101050505','ˮ');
INSERT INTO yowao_city_id_name VALUES('127','101050506','');
INSERT INTO yowao_city_id_name VALUES('128','101050507','');
INSERT INTO yowao_city_id_name VALUES('129','101050508','');
INSERT INTO yowao_city_id_name VALUES('130','101050509','찲');
INSERT INTO yowao_city_id_name VALUES('131','101050510','');
INSERT INTO yowao_city_id_name VALUES('132','101050601','ں');
INSERT INTO yowao_city_id_name VALUES('133','101050602','۽');
INSERT INTO yowao_city_id_name VALUES('134','101050603','');
INSERT INTO yowao_city_id_name VALUES('135','101050604','ѷ');
INSERT INTO yowao_city_id_name VALUES('136','101050605','');
INSERT INTO yowao_city_id_name VALUES('137','101050606','');
INSERT INTO yowao_city_id_name VALUES('138','101050701','˰');
INSERT INTO yowao_city_id_name VALUES('139','101050702','');
INSERT INTO yowao_city_id_name VALUES('140','101050703','Į');
INSERT INTO yowao_city_id_name VALUES('141','101050704','');
INSERT INTO yowao_city_id_name VALUES('142','101050705','');
INSERT INTO yowao_city_id_name VALUES('143','101050706','');
INSERT INTO yowao_city_id_name VALUES('144','101050707','ľ');
INSERT INTO yowao_city_id_name VALUES('145','101050801','');
INSERT INTO yowao_city_id_name VALUES('146','101050802','');
INSERT INTO yowao_city_id_name VALUES('147','101050803','Ӫ');
INSERT INTO yowao_city_id_name VALUES('148','101050804','');
INSERT INTO yowao_city_id_name VALUES('149','101050805','');
INSERT INTO yowao_city_id_name VALUES('150','101050901','');
INSERT INTO yowao_city_id_name VALUES('151','101050902','ֵ');
INSERT INTO yowao_city_id_name VALUES('152','101050903','');
INSERT INTO yowao_city_id_name VALUES('153','101050904','Դ');
INSERT INTO yowao_city_id_name VALUES('154','101051002','');
INSERT INTO yowao_city_id_name VALUES('155','101051101','');
INSERT INTO yowao_city_id_name VALUES('156','101051102','');
INSERT INTO yowao_city_id_name VALUES('157','101051103','ɽ');
INSERT INTO yowao_city_id_name VALUES('158','101051104','');
INSERT INTO yowao_city_id_name VALUES('159','101051201','׸');
INSERT INTO yowao_city_id_name VALUES('160','101051202','');
INSERT INTO yowao_city_id_name VALUES('161','101051203','ܱ');
INSERT INTO yowao_city_id_name VALUES('162','101051301','˫Ѽɽ');
INSERT INTO yowao_city_id_name VALUES('163','101051302','');
INSERT INTO yowao_city_id_name VALUES('164','101051303','');
INSERT INTO yowao_city_id_name VALUES('165','101051304','ĺ');
INSERT INTO yowao_city_id_name VALUES('166','101060101','');
INSERT INTO yowao_city_id_name VALUES('167','101060102','ũ');
INSERT INTO yowao_city_id_name VALUES('168','101060103','»');
INSERT INTO yowao_city_id_name VALUES('169','101060104','̨');
INSERT INTO yowao_city_id_name VALUES('170','101060105','');
INSERT INTO yowao_city_id_name VALUES('171','101060106','˫');
INSERT INTO yowao_city_id_name VALUES('172','101060201','');
INSERT INTO yowao_city_id_name VALUES('173','101060202','');
INSERT INTO yowao_city_id_name VALUES('174','101060203','');
INSERT INTO yowao_city_id_name VALUES('175','101060204','Ժ');
INSERT INTO yowao_city_id_name VALUES('176','101060205','ʯ');
INSERT INTO yowao_city_id_name VALUES('177','101060206','');
INSERT INTO yowao_city_id_name VALUES('178','101060207','Ͳɽ');
INSERT INTO yowao_city_id_name VALUES('179','101060301','Ӽ');
INSERT INTO yowao_city_id_name VALUES('180','101060302','ػ');
INSERT INTO yowao_city_id_name VALUES('181','101060303','ͼ');
INSERT INTO yowao_city_id_name VALUES('182','101060304','');
INSERT INTO yowao_city_id_name VALUES('183','101060305','');
INSERT INTO yowao_city_id_name VALUES('184','101060306','');
INSERT INTO yowao_city_id_name VALUES('185','101060307','');
INSERT INTO yowao_city_id_name VALUES('186','101060308','');
INSERT INTO yowao_city_id_name VALUES('187','101060309','ͼ');
INSERT INTO yowao_city_id_name VALUES('188','101060310','ɽ');
INSERT INTO yowao_city_id_name VALUES('189','101060311','ӹ');
INSERT INTO yowao_city_id_name VALUES('190','101060401','ƽ');
INSERT INTO yowao_city_id_name VALUES('191','101060402','˫');
INSERT INTO yowao_city_id_name VALUES('192','101060403','');
INSERT INTO yowao_city_id_name VALUES('193','101060404','');
INSERT INTO yowao_city_id_name VALUES('194','101060405','ͨ');
INSERT INTO yowao_city_id_name VALUES('195','101060406','¼');
INSERT INTO yowao_city_id_name VALUES('196','101060501','ͨ');
INSERT INTO yowao_city_id_name VALUES('197','101060502','÷ӿ');
INSERT INTO yowao_city_id_name VALUES('198','101060503','');
INSERT INTO yowao_city_id_name VALUES('199','101060504','');
INSERT INTO yowao_city_id_name VALUES('200','101060505','');
INSERT INTO yowao_city_id_name VALUES('201','101060506','ͨ');
INSERT INTO yowao_city_id_name VALUES('202','101060601','׳');
INSERT INTO yowao_city_id_name VALUES('203','101060602','');
INSERT INTO yowao_city_id_name VALUES('204','101060603','');
INSERT INTO yowao_city_id_name VALUES('205','101060604','');
INSERT INTO yowao_city_id_name VALUES('206','101060605','ͨ');
INSERT INTO yowao_city_id_name VALUES('207','101060701','Դ');
INSERT INTO yowao_city_id_name VALUES('208','101060702','');
INSERT INTO yowao_city_id_name VALUES('209','101060801','ԭ');
INSERT INTO yowao_city_id_name VALUES('210','101060802','Ǭ');
INSERT INTO yowao_city_id_name VALUES('211','101060803','ǰ');
INSERT INTO yowao_city_id_name VALUES('212','101060804','');
INSERT INTO yowao_city_id_name VALUES('213','101060805','');
INSERT INTO yowao_city_id_name VALUES('214','101060901','ɽ');
INSERT INTO yowao_city_id_name VALUES('215','101060902','');
INSERT INTO yowao_city_id_name VALUES('216','101060903','ٽ');
INSERT INTO yowao_city_id_name VALUES('217','101060904','');
INSERT INTO yowao_city_id_name VALUES('218','101060905','');
INSERT INTO yowao_city_id_name VALUES('219','101070101','');
INSERT INTO yowao_city_id_name VALUES('220','101070102','ռ');
INSERT INTO yowao_city_id_name VALUES('221','101070103','');
INSERT INTO yowao_city_id_name VALUES('222','101070104','ƽ');
INSERT INTO yowao_city_id_name VALUES('223','101070105','');
INSERT INTO yowao_city_id_name VALUES('224','101070106','');
INSERT INTO yowao_city_id_name VALUES('225','101070107','ں');
INSERT INTO yowao_city_id_name VALUES('226','101070108','³');
INSERT INTO yowao_city_id_name VALUES('227','101070201','');
INSERT INTO yowao_city_id_name VALUES('228','101070202','߷');
INSERT INTO yowao_city_id_name VALUES('229','101070203','');
INSERT INTO yowao_city_id_name VALUES('230','101070204','');
INSERT INTO yowao_city_id_name VALUES('231','101070205','˳');
INSERT INTO yowao_city_id_name VALUES('232','101070206','');
INSERT INTO yowao_city_id_name VALUES('233','101070207','ׯ');
INSERT INTO yowao_city_id_name VALUES('234','101070208','Ƥ');
INSERT INTO yowao_city_id_name VALUES('235','101070209','');
INSERT INTO yowao_city_id_name VALUES('236','101070301','ɽ');
INSERT INTO yowao_city_id_name VALUES('237','101070302','̨');
INSERT INTO yowao_city_id_name VALUES('238','101070303','');
INSERT INTO yowao_city_id_name VALUES('239','101070304','');
INSERT INTO yowao_city_id_name VALUES('240','101070401','˳');
INSERT INTO yowao_city_id_name VALUES('241','101070403','ԭ');
INSERT INTO yowao_city_id_name VALUES('242','101070404','µ');
INSERT INTO yowao_city_id_name VALUES('243','101070501','Ϫ');
INSERT INTO yowao_city_id_name VALUES('244','101070502','Ϫ');
INSERT INTO yowao_city_id_name VALUES('245','101070503','ݺӿ');
INSERT INTO yowao_city_id_name VALUES('246','101070504','');
INSERT INTO yowao_city_id_name VALUES('247','101070601','');
INSERT INTO yowao_city_id_name VALUES('248','101070602','');
INSERT INTO yowao_city_id_name VALUES('249','101070603','');
INSERT INTO yowao_city_id_name VALUES('250','101070604','');
INSERT INTO yowao_city_id_name VALUES('251','101070701','');
INSERT INTO yowao_city_id_name VALUES('252','101070702','躣');
INSERT INTO yowao_city_id_name VALUES('253','101070703','');
INSERT INTO yowao_city_id_name VALUES('254','101070704','');
INSERT INTO yowao_city_id_name VALUES('255','101070705','ɽ');
INSERT INTO yowao_city_id_name VALUES('256','101070801','Ӫ');
INSERT INTO yowao_city_id_name VALUES('257','101070802','ʯ');
INSERT INTO yowao_city_id_name VALUES('258','101070803','');
INSERT INTO yowao_city_id_name VALUES('259','101071804','');
INSERT INTO yowao_city_id_name VALUES('260','101070901','');
INSERT INTO yowao_city_id_name VALUES('261','101070902','');
INSERT INTO yowao_city_id_name VALUES('262','101071001','');
INSERT INTO yowao_city_id_name VALUES('263','101071002','');
INSERT INTO yowao_city_id_name VALUES('264','101071003','');
INSERT INTO yowao_city_id_name VALUES('265','101071101','');
INSERT INTO yowao_city_id_name VALUES('266','101071102','ԭ');
INSERT INTO yowao_city_id_name VALUES('267','101071103','ͼ');
INSERT INTO yowao_city_id_name VALUES('268','101071104','');
INSERT INTO yowao_city_id_name VALUES('269','101071201','');
INSERT INTO yowao_city_id_name VALUES('270','101071202','ƽ');
INSERT INTO yowao_city_id_name VALUES('271','101071203','Դ');
INSERT INTO yowao_city_id_name VALUES('272','101071204','');
INSERT INTO yowao_city_id_name VALUES('273','101071205','Ʊ');
INSERT INTO yowao_city_id_name VALUES('274','101071206','ɽ');
INSERT INTO yowao_city_id_name VALUES('275','101071207','ƽ');
INSERT INTO yowao_city_id_name VALUES('276','101071301','̽');
INSERT INTO yowao_city_id_name VALUES('277','101071302','');
INSERT INTO yowao_city_id_name VALUES('278','101071303','ɽ');
INSERT INTO yowao_city_id_name VALUES('279','101071401','«');
INSERT INTO yowao_city_id_name VALUES('280','101071402','');
INSERT INTO yowao_city_id_name VALUES('281','101071403','');
INSERT INTO yowao_city_id_name VALUES('282','101071404','˳');
INSERT INTO yowao_city_id_name VALUES('283','101080101','ͺ');
INSERT INTO yowao_city_id_name VALUES('284','101080102','Ĭ');
INSERT INTO yowao_city_id_name VALUES('285','101080103','п');
INSERT INTO yowao_city_id_name VALUES('286','101080104','ָ');
INSERT INTO yowao_city_id_name VALUES('287','101080105','ˮ');
INSERT INTO yowao_city_id_name VALUES('288','101080106','ͺн');
INSERT INTO yowao_city_id_name VALUES('289','101080107','䴨');
INSERT INTO yowao_city_id_name VALUES('290','101080201','ͷ');
INSERT INTO yowao_city_id_name VALUES('291','101080202','ƶ');
INSERT INTO yowao_city_id_name VALUES('292','101080203','');
INSERT INTO yowao_city_id_name VALUES('293','101080204','Ĭ');
INSERT INTO yowao_city_id_name VALUES('294','101080205','');
INSERT INTO yowao_city_id_name VALUES('295','101080206','ï');
INSERT INTO yowao_city_id_name VALUES('296','101080207','ʯ');
INSERT INTO yowao_city_id_name VALUES('297','101080301','ں');
INSERT INTO yowao_city_id_name VALUES('298','101080401','');
INSERT INTO yowao_city_id_name VALUES('299','101080402','׿');
INSERT INTO yowao_city_id_name VALUES('300','101080403','');
INSERT INTO yowao_city_id_name VALUES('301','101080404','̶');
INSERT INTO yowao_city_id_name VALUES('302','101080405','ϣ');
INSERT INTO yowao_city_id_name VALUES('303','101080406','˺');
INSERT INTO yowao_city_id_name VALUES('304','101080407','');
INSERT INTO yowao_city_id_name VALUES('305','101080408','ǰ');
INSERT INTO yowao_city_id_name VALUES('306','101080409','');
INSERT INTO yowao_city_id_name VALUES('307','101080410','');
INSERT INTO yowao_city_id_name VALUES('308','101080411','');
INSERT INTO yowao_city_id_name VALUES('309','101080412','');
INSERT INTO yowao_city_id_name VALUES('310','101080501','ͨ');
INSERT INTO yowao_city_id_name VALUES('311','101080502','Ხ');
INSERT INTO yowao_city_id_name VALUES('312','101080503','ƶ');
INSERT INTO yowao_city_id_name VALUES('313','101080504','ƶ');
INSERT INTO yowao_city_id_name VALUES('314','101080505','ɽ');
INSERT INTO yowao_city_id_name VALUES('315','101080506','³');
INSERT INTO yowao_city_id_name VALUES('316','101080507','');
INSERT INTO yowao_city_id_name VALUES('317','101080508','');
INSERT INTO yowao_city_id_name VALUES('318','101080509','³');
INSERT INTO yowao_city_id_name VALUES('319','101080510','');
INSERT INTO yowao_city_id_name VALUES('320','101080511','Ŷº˶');
INSERT INTO yowao_city_id_name VALUES('321','101080512','ͨǮҵ');
INSERT INTO yowao_city_id_name VALUES('322','101080601','');
INSERT INTO yowao_city_id_name VALUES('323','101080602','彼վ');
INSERT INTO yowao_city_id_name VALUES('324','101080603','³ƶ');
INSERT INTO yowao_city_id_name VALUES('325','101080604','ƶ');
INSERT INTO yowao_city_id_name VALUES('326','101080605','');
INSERT INTO yowao_city_id_name VALUES('327','101080606','');
INSERT INTO yowao_city_id_name VALUES('328','101080607','');
INSERT INTO yowao_city_id_name VALUES('329','101080608','ʲ');
INSERT INTO yowao_city_id_name VALUES('330','101080609','ţ');
INSERT INTO yowao_city_id_name VALUES('331','101080610','');
INSERT INTO yowao_city_id_name VALUES('332','101080611','');
INSERT INTO yowao_city_id_name VALUES('333','101080612','ﺱ');
INSERT INTO yowao_city_id_name VALUES('334','101080613','');
INSERT INTO yowao_city_id_name VALUES('335','101080614','');
INSERT INTO yowao_city_id_name VALUES('336','101080615','ͼ');
INSERT INTO yowao_city_id_name VALUES('337','101080701','˹');
INSERT INTO yowao_city_id_name VALUES('338','101080703','');
INSERT INTO yowao_city_id_name VALUES('339','101080704','׼');
INSERT INTO yowao_city_id_name VALUES('340','101080705','пǰ');
INSERT INTO yowao_city_id_name VALUES('341','101080706','');
INSERT INTO yowao_city_id_name VALUES('342','101080707','');
INSERT INTO yowao_city_id_name VALUES('343','101080708','п');
INSERT INTO yowao_city_id_name VALUES('344','101080709','');
INSERT INTO yowao_city_id_name VALUES('345','101080710','');
INSERT INTO yowao_city_id_name VALUES('346','101080711','');
INSERT INTO yowao_city_id_name VALUES('347','101080712','');
INSERT INTO yowao_city_id_name VALUES('348','101080801','ٺ');
INSERT INTO yowao_city_id_name VALUES('349','101080802','ԭ');
INSERT INTO yowao_city_id_name VALUES('350','101080803','');
INSERT INTO yowao_city_id_name VALUES('351','101080804','ǰ');
INSERT INTO yowao_city_id_name VALUES('352','101080805','̫');
INSERT INTO yowao_city_id_name VALUES('353','101080806','');
INSERT INTO yowao_city_id_name VALUES('354','101080807','غ');
INSERT INTO yowao_city_id_name VALUES('355','101080808','');
INSERT INTO yowao_city_id_name VALUES('356','101080809','ʱ');
INSERT INTO yowao_city_id_name VALUES('357','101080810','');
INSERT INTO yowao_city_id_name VALUES('358','101080811','ũվ');
INSERT INTO yowao_city_id_name VALUES('359','101080901','ֺ');
INSERT INTO yowao_city_id_name VALUES('360','101080902','');
INSERT INTO yowao_city_id_name VALUES('361','101080903','');
INSERT INTO yowao_city_id_name VALUES('362','101080904','͸');
INSERT INTO yowao_city_id_name VALUES('363','101080905','͹');
INSERT INTO yowao_city_id_name VALUES('364','101080906','');
INSERT INTO yowao_city_id_name VALUES('365','101080907','');
INSERT INTO yowao_city_id_name VALUES('366','101080908','պ');
INSERT INTO yowao_city_id_name VALUES('367','101080909','');
INSERT INTO yowao_city_id_name VALUES('368','101080910','');
INSERT INTO yowao_city_id_name VALUES('369','101080911','̫');
INSERT INTO yowao_city_id_name VALUES('370','101080912','');
INSERT INTO yowao_city_id_name VALUES('371','101080913','');
INSERT INTO yowao_city_id_name VALUES('372','101080914','');
INSERT INTO yowao_city_id_name VALUES('373','101080915','');
INSERT INTO yowao_city_id_name VALUES('374','101080916','ͼ');
INSERT INTO yowao_city_id_name VALUES('375','101080917','');
INSERT INTO yowao_city_id_name VALUES('376','101080918','');
INSERT INTO yowao_city_id_name VALUES('377','101080919','ͼ');
INSERT INTO yowao_city_id_name VALUES('378','101081001','');
INSERT INTO yowao_city_id_name VALUES('379','101081002','С');
INSERT INTO yowao_city_id_name VALUES('380','101081003','');
INSERT INTO yowao_city_id_name VALUES('381','101081004','Ī');
INSERT INTO yowao_city_id_name VALUES('382','101081005','״');
INSERT INTO yowao_city_id_name VALUES('383','101081006','¿');
INSERT INTO yowao_city_id_name VALUES('384','101081007','°Ͷ');
INSERT INTO yowao_city_id_name VALUES('385','101081008','°Ͷ');
INSERT INTO yowao_city_id_name VALUES('386','101081009','°Ͷ');
INSERT INTO yowao_city_id_name VALUES('387','101081010','');
INSERT INTO yowao_city_id_name VALUES('388','101081011','ʯ');
INSERT INTO yowao_city_id_name VALUES('389','101081012','');
INSERT INTO yowao_city_id_name VALUES('390','101081014','');
INSERT INTO yowao_city_id_name VALUES('391','101081015','');
INSERT INTO yowao_city_id_name VALUES('392','101081016','ͼ');
INSERT INTO yowao_city_id_name VALUES('393','101081101','');
INSERT INTO yowao_city_id_name VALUES('394','101081102','ɽ');
INSERT INTO yowao_city_id_name VALUES('395','101081103','ƶ');
INSERT INTO yowao_city_id_name VALUES('396','101081104','');
INSERT INTO yowao_city_id_name VALUES('397','101081105','');
INSERT INTO yowao_city_id_name VALUES('398','101081106','');
INSERT INTO yowao_city_id_name VALUES('399','101081107','ͻȪ');
INSERT INTO yowao_city_id_name VALUES('400','101081201','');
INSERT INTO yowao_city_id_name VALUES('401','101081202','');
INSERT INTO yowao_city_id_name VALUES('402','101081203','');
INSERT INTO yowao_city_id_name VALUES('403','101081204','Ӻ');
INSERT INTO yowao_city_id_name VALUES('404','101081205','̫');
INSERT INTO yowao_city_id_name VALUES('405','101081206','ָ');
INSERT INTO yowao_city_id_name VALUES('406','101081207','ͷ');
INSERT INTO yowao_city_id_name VALUES('407','101081208','Ȫ');
INSERT INTO yowao_city_id_name VALUES('408','101081209','ŵ');
INSERT INTO yowao_city_id_name VALUES('409','101090101','ʯׯ');
INSERT INTO yowao_city_id_name VALUES('410','101090102','');
INSERT INTO yowao_city_id_name VALUES('411','101090103','');
INSERT INTO yowao_city_id_name VALUES('412','101090104','');
INSERT INTO yowao_city_id_name VALUES('413','101090105','');
INSERT INTO yowao_city_id_name VALUES('414','101090106','');
INSERT INTO yowao_city_id_name VALUES('415','101090107','');
INSERT INTO yowao_city_id_name VALUES('416','101090108','');
INSERT INTO yowao_city_id_name VALUES('417','101090109','޻');
INSERT INTO yowao_city_id_name VALUES('418','101090110','޼');
INSERT INTO yowao_city_id_name VALUES('419','101090111','ƽɽ');
INSERT INTO yowao_city_id_name VALUES('420','101090112','Ԫ');
INSERT INTO yowao_city_id_name VALUES('421','101090113','');
INSERT INTO yowao_city_id_name VALUES('422','101090114','');
INSERT INTO yowao_city_id_name VALUES('423','101090115','޻');
INSERT INTO yowao_city_id_name VALUES('424','101090116','');
INSERT INTO yowao_city_id_name VALUES('425','101090117','');
INSERT INTO yowao_city_id_name VALUES('426','101090201','');
INSERT INTO yowao_city_id_name VALUES('427','101090202','');
INSERT INTO yowao_city_id_name VALUES('428','101090203','ƽ');
INSERT INTO yowao_city_id_name VALUES('429','101090204','ˮ');
INSERT INTO yowao_city_id_name VALUES('430','101090205','');
INSERT INTO yowao_city_id_name VALUES('431','101090206','');
INSERT INTO yowao_city_id_name VALUES('432','101090207','ݳ');
INSERT INTO yowao_city_id_name VALUES('433','101090208','Ͼ');
INSERT INTO yowao_city_id_name VALUES('434','101090209','Դ');
INSERT INTO yowao_city_id_name VALUES('435','101090210','');
INSERT INTO yowao_city_id_name VALUES('436','101090211','');
INSERT INTO yowao_city_id_name VALUES('437','101090212','');
INSERT INTO yowao_city_id_name VALUES('438','101090213','ˮ');
INSERT INTO yowao_city_id_name VALUES('439','101090214','');
INSERT INTO yowao_city_id_name VALUES('440','101090215','');
INSERT INTO yowao_city_id_name VALUES('441','101090216','˳ƽ');
INSERT INTO yowao_city_id_name VALUES('442','101090217','');
INSERT INTO yowao_city_id_name VALUES('443','101090218','');
INSERT INTO yowao_city_id_name VALUES('444','101090219','');
INSERT INTO yowao_city_id_name VALUES('445','101090220','');
INSERT INTO yowao_city_id_name VALUES('446','101090221','߱');
INSERT INTO yowao_city_id_name VALUES('447','101090301','żҿ');
INSERT INTO yowao_city_id_name VALUES('448','101090302','');
INSERT INTO yowao_city_id_name VALUES('449','101090303','ű');
INSERT INTO yowao_city_id_name VALUES('450','101090304','');
INSERT INTO yowao_city_id_name VALUES('451','101090305','Դ');
INSERT INTO yowao_city_id_name VALUES('452','101090306','');
INSERT INTO yowao_city_id_name VALUES('453','101090307','ε');
INSERT INTO yowao_city_id_name VALUES('454','101090308','ԭ');
INSERT INTO yowao_city_id_name VALUES('455','101090309','');
INSERT INTO yowao_city_id_name VALUES('456','101090310','ȫ');
INSERT INTO yowao_city_id_name VALUES('457','101090311','');
INSERT INTO yowao_city_id_name VALUES('458','101090312','¹');
INSERT INTO yowao_city_id_name VALUES('459','101090313','');
INSERT INTO yowao_city_id_name VALUES('460','101090314','');
INSERT INTO yowao_city_id_name VALUES('461','101090401','е');
INSERT INTO yowao_city_id_name VALUES('462','101090402','е');
INSERT INTO yowao_city_id_name VALUES('463','101090403','е');
INSERT INTO yowao_city_id_name VALUES('464','101090404','¡');
INSERT INTO yowao_city_id_name VALUES('465','101090405','ƽȪ');
INSERT INTO yowao_city_id_name VALUES('466','101090406','ƽ');
INSERT INTO yowao_city_id_name VALUES('467','101090407','¡');
INSERT INTO yowao_city_id_name VALUES('468','101090408','');
INSERT INTO yowao_city_id_name VALUES('469','101090409','');
INSERT INTO yowao_city_id_name VALUES('470','101090410','Χ');
INSERT INTO yowao_city_id_name VALUES('471','101090411','');
INSERT INTO yowao_city_id_name VALUES('472','101090501','ɽ');
INSERT INTO yowao_city_id_name VALUES('473','101090502','');
INSERT INTO yowao_city_id_name VALUES('474','101090503','');
INSERT INTO yowao_city_id_name VALUES('475','101090504','');
INSERT INTO yowao_city_id_name VALUES('476','101090505','');
INSERT INTO yowao_city_id_name VALUES('477','101090506','ͤ');
INSERT INTO yowao_city_id_name VALUES('478','101090507','Ǩ');
INSERT INTO yowao_city_id_name VALUES('479','101090508','');
INSERT INTO yowao_city_id_name VALUES('480','101090509','ƺ');
INSERT INTO yowao_city_id_name VALUES('481','101090510','');
INSERT INTO yowao_city_id_name VALUES('482','101090511','Ǩ');
INSERT INTO yowao_city_id_name VALUES('483','101090601','ȷ');
INSERT INTO yowao_city_id_name VALUES('484','101090602','̰');
INSERT INTO yowao_city_id_name VALUES('485','101090603','');
INSERT INTO yowao_city_id_name VALUES('486','101090604','');
INSERT INTO yowao_city_id_name VALUES('487','101090605','');
INSERT INTO yowao_city_id_name VALUES('488','101090606','İ');
INSERT INTO yowao_city_id_name VALUES('489','101090607','');
INSERT INTO yowao_city_id_name VALUES('490','101090608','');
INSERT INTO yowao_city_id_name VALUES('491','101090609','');
INSERT INTO yowao_city_id_name VALUES('492','101090701','');
INSERT INTO yowao_city_id_name VALUES('493','101090702','');
INSERT INTO yowao_city_id_name VALUES('494','101090703','');
INSERT INTO yowao_city_id_name VALUES('495','101090704','');
INSERT INTO yowao_city_id_name VALUES('496','101090705','ɽ');
INSERT INTO yowao_city_id_name VALUES('497','101090706','');
INSERT INTO yowao_city_id_name VALUES('498','101090707','Ƥ');
INSERT INTO yowao_city_id_name VALUES('499','101090708','');
INSERT INTO yowao_city_id_name VALUES('500','101090709','');
INSERT INTO yowao_city_id_name VALUES('501','101090710','ϴ');
INSERT INTO yowao_city_id_name VALUES('502','101090711','ͷ');
INSERT INTO yowao_city_id_name VALUES('503','101090712','');
INSERT INTO yowao_city_id_name VALUES('504','101090713','');
INSERT INTO yowao_city_id_name VALUES('505','101090714','Ӽ');
INSERT INTO yowao_city_id_name VALUES('506','101090801','ˮ');
INSERT INTO yowao_city_id_name VALUES('507','101090802','ǿ');
INSERT INTO yowao_city_id_name VALUES('508','101090803','');
INSERT INTO yowao_city_id_name VALUES('509','101090804','ǿ');
INSERT INTO yowao_city_id_name VALUES('510','101090805','');
INSERT INTO yowao_city_id_name VALUES('511','101090806','ƽ');
INSERT INTO yowao_city_id_name VALUES('512','101090807','ʳ');
INSERT INTO yowao_city_id_name VALUES('513','101090808','');
INSERT INTO yowao_city_id_name VALUES('514','101090809','');
INSERT INTO yowao_city_id_name VALUES('515','101090810','');
INSERT INTO yowao_city_id_name VALUES('516','101090811','');
INSERT INTO yowao_city_id_name VALUES('517','101090901','̨');
INSERT INTO yowao_city_id_name VALUES('518','101090902','ٳ');
INSERT INTO yowao_city_id_name VALUES('519','101090903','̨ؽˮ');
INSERT INTO yowao_city_id_name VALUES('520','101090904','');
INSERT INTO yowao_city_id_name VALUES('521','101090905','');
INSERT INTO yowao_city_id_name VALUES('522','101090906','¡Ң');
INSERT INTO yowao_city_id_name VALUES('523','101090907','Ϻ');
INSERT INTO yowao_city_id_name VALUES('524','101090908','');
INSERT INTO yowao_city_id_name VALUES('525','101090909','¹');
INSERT INTO yowao_city_id_name VALUES('526','101090910','º');
INSERT INTO yowao_city_id_name VALUES('527','101090911','');
INSERT INTO yowao_city_id_name VALUES('528','101090912','ƽ');
INSERT INTO yowao_city_id_name VALUES('529','101090913','');
INSERT INTO yowao_city_id_name VALUES('530','101090914','');
INSERT INTO yowao_city_id_name VALUES('531','101090915','');
INSERT INTO yowao_city_id_name VALUES('532','101090916','Ϲ');
INSERT INTO yowao_city_id_name VALUES('533','101090917','ɳ');
INSERT INTO yowao_city_id_name VALUES('534','101090918','');
INSERT INTO yowao_city_id_name VALUES('535','101091001','');
INSERT INTO yowao_city_id_name VALUES('536','101091002','');
INSERT INTO yowao_city_id_name VALUES('537','101091003','');
INSERT INTO yowao_city_id_name VALUES('538','101091004','ɰ');
INSERT INTO yowao_city_id_name VALUES('539','101091005','');
INSERT INTO yowao_city_id_name VALUES('540','101091006','');
INSERT INTO yowao_city_id_name VALUES('541','101091007','');
INSERT INTO yowao_city_id_name VALUES('542','101091008','');
INSERT INTO yowao_city_id_name VALUES('543','101091009','');
INSERT INTO yowao_city_id_name VALUES('544','101091010','');
INSERT INTO yowao_city_id_name VALUES('545','101091011','');
INSERT INTO yowao_city_id_name VALUES('546','101091012','ƽ');
INSERT INTO yowao_city_id_name VALUES('547','101091013','');
INSERT INTO yowao_city_id_name VALUES('548','101091014','κ');
INSERT INTO yowao_city_id_name VALUES('549','101091015','');
INSERT INTO yowao_city_id_name VALUES('550','101091016','䰲');
INSERT INTO yowao_city_id_name VALUES('551','101091101','ػʵ');
INSERT INTO yowao_city_id_name VALUES('552','101091102','');
INSERT INTO yowao_city_id_name VALUES('553','101091103','');
INSERT INTO yowao_city_id_name VALUES('554','101091104','');
INSERT INTO yowao_city_id_name VALUES('555','101091105','¬');
INSERT INTO yowao_city_id_name VALUES('556','101100101','̫ԭ');
INSERT INTO yowao_city_id_name VALUES('557','101100102','');
INSERT INTO yowao_city_id_name VALUES('558','101100103','');
INSERT INTO yowao_city_id_name VALUES('559','101100104','¦');
INSERT INTO yowao_city_id_name VALUES('560','101100105','̫ԭŽ');
INSERT INTO yowao_city_id_name VALUES('561','101100106','̫ԭ');
INSERT INTO yowao_city_id_name VALUES('562','101100107','̫ԭϽ');
INSERT INTO yowao_city_id_name VALUES('563','101100201','ͬ');
INSERT INTO yowao_city_id_name VALUES('564','101100202','');
INSERT INTO yowao_city_id_name VALUES('565','101100203','ͬ');
INSERT INTO yowao_city_id_name VALUES('566','101100204','');
INSERT INTO yowao_city_id_name VALUES('567','101100205','');
INSERT INTO yowao_city_id_name VALUES('568','101100206','');
INSERT INTO yowao_city_id_name VALUES('569','101100207','Դ');
INSERT INTO yowao_city_id_name VALUES('570','101100208','');
INSERT INTO yowao_city_id_name VALUES('571','101100301','Ȫ');
INSERT INTO yowao_city_id_name VALUES('572','101100302','');
INSERT INTO yowao_city_id_name VALUES('573','101100303','ƽ');
INSERT INTO yowao_city_id_name VALUES('574','101100401','');
INSERT INTO yowao_city_id_name VALUES('575','101100402','ܴ');
INSERT INTO yowao_city_id_name VALUES('576','101100403','');
INSERT INTO yowao_city_id_name VALUES('577','101100404','Ȩ');
INSERT INTO yowao_city_id_name VALUES('578','101100405','˳');
INSERT INTO yowao_city_id_name VALUES('579','101100406','');
INSERT INTO yowao_city_id_name VALUES('580','101100407','');
INSERT INTO yowao_city_id_name VALUES('581','101100408','̫');
INSERT INTO yowao_city_id_name VALUES('582','101100409','');
INSERT INTO yowao_city_id_name VALUES('583','101100411','ʯ');
INSERT INTO yowao_city_id_name VALUES('584','101100412','');
INSERT INTO yowao_city_id_name VALUES('585','101100501','');
INSERT INTO yowao_city_id_name VALUES('586','101100502','');
INSERT INTO yowao_city_id_name VALUES('587','101100503','');
INSERT INTO yowao_city_id_name VALUES('588','101100504','º');
INSERT INTO yowao_city_id_name VALUES('589','101100505','ԫ');
INSERT INTO yowao_city_id_name VALUES('590','101100506','ƽ˳');
INSERT INTO yowao_city_id_name VALUES('591','101100507','');
INSERT INTO yowao_city_id_name VALUES('592','101100508','');
INSERT INTO yowao_city_id_name VALUES('593','101100509','');
INSERT INTO yowao_city_id_name VALUES('594','101100510','Դ');
INSERT INTO yowao_city_id_name VALUES('595','101100511','');
INSERT INTO yowao_city_id_name VALUES('596','101100601','');
INSERT INTO yowao_city_id_name VALUES('597','101100602','ˮ');
INSERT INTO yowao_city_id_name VALUES('598','101100603','');
INSERT INTO yowao_city_id_name VALUES('599','101100604','괨');
INSERT INTO yowao_city_id_name VALUES('600','101100605','ƽ');
INSERT INTO yowao_city_id_name VALUES('601','101100701','ٷ');
INSERT INTO yowao_city_id_name VALUES('602','101100702','');
INSERT INTO yowao_city_id_name VALUES('603','101100703','');
INSERT INTO yowao_city_id_name VALUES('604','101100704','');
INSERT INTO yowao_city_id_name VALUES('605','101100705','');
INSERT INTO yowao_city_id_name VALUES('606','101100706','');
INSERT INTO yowao_city_id_name VALUES('607','101100707','');
INSERT INTO yowao_city_id_name VALUES('608','101100708','');
INSERT INTO yowao_city_id_name VALUES('609','101100709','');
INSERT INTO yowao_city_id_name VALUES('610','101100710','鶴');
INSERT INTO yowao_city_id_name VALUES('611','101100711','');
INSERT INTO yowao_city_id_name VALUES('612','101100712','');
INSERT INTO yowao_city_id_name VALUES('613','101100713','');
INSERT INTO yowao_city_id_name VALUES('614','101100714','');
INSERT INTO yowao_city_id_name VALUES('615','101100715','ɽ');
INSERT INTO yowao_city_id_name VALUES('616','101100716','');
INSERT INTO yowao_city_id_name VALUES('617','101100717','');
INSERT INTO yowao_city_id_name VALUES('618','101100801','˳');
INSERT INTO yowao_city_id_name VALUES('619','101100802','');
INSERT INTO yowao_city_id_name VALUES('620','101100803','ɽ');
INSERT INTO yowao_city_id_name VALUES('621','101100804','');
INSERT INTO yowao_city_id_name VALUES('622','101100805','ӽ');
INSERT INTO yowao_city_id_name VALUES('623','101100806','');
INSERT INTO yowao_city_id_name VALUES('624','101100807','');
INSERT INTO yowao_city_id_name VALUES('625','101100808','ϲ');
INSERT INTO yowao_city_id_name VALUES('626','101100809','ԫ');
INSERT INTO yowao_city_id_name VALUES('627','101100810','');
INSERT INTO yowao_city_id_name VALUES('628','101100811','ǳ');
INSERT INTO yowao_city_id_name VALUES('629','101100812','');
INSERT INTO yowao_city_id_name VALUES('630','101100813','ƽ½');
INSERT INTO yowao_city_id_name VALUES('631','101100901','˷');
INSERT INTO yowao_city_id_name VALUES('632','101100902','ƽ³');
INSERT INTO yowao_city_id_name VALUES('633','101100903','ɽ');
INSERT INTO yowao_city_id_name VALUES('634','101100904','');
INSERT INTO yowao_city_id_name VALUES('635','101100905','Ӧ');
INSERT INTO yowao_city_id_name VALUES('636','101100906','');
INSERT INTO yowao_city_id_name VALUES('637','101101001','');
INSERT INTO yowao_city_id_name VALUES('638','101101002','');
INSERT INTO yowao_city_id_name VALUES('639','101101003','̨ض');
INSERT INTO yowao_city_id_name VALUES('640','101101004','');
INSERT INTO yowao_city_id_name VALUES('641','101101005','ƫ');
INSERT INTO yowao_city_id_name VALUES('642','101101006','');
INSERT INTO yowao_city_id_name VALUES('643','101101007','');
INSERT INTO yowao_city_id_name VALUES('644','101101008','');
INSERT INTO yowao_city_id_name VALUES('645','101101009','');
INSERT INTO yowao_city_id_name VALUES('646','101101010','̨ɽ');
INSERT INTO yowao_city_id_name VALUES('647','101101011','');
INSERT INTO yowao_city_id_name VALUES('648','101101012','');
INSERT INTO yowao_city_id_name VALUES('649','101101013','');
INSERT INTO yowao_city_id_name VALUES('650','101101014','կ');
INSERT INTO yowao_city_id_name VALUES('651','101101015','ԭƽ');
INSERT INTO yowao_city_id_name VALUES('652','101101101','ʯ');
INSERT INTO yowao_city_id_name VALUES('653','101101102','');
INSERT INTO yowao_city_id_name VALUES('654','101101103','');
INSERT INTO yowao_city_id_name VALUES('655','101101104','');
INSERT INTO yowao_city_id_name VALUES('656','101101105','');
INSERT INTO yowao_city_id_name VALUES('657','101101106','ʯ¥');
INSERT INTO yowao_city_id_name VALUES('658','101101107','ɽ');
INSERT INTO yowao_city_id_name VALUES('659','101101108','');
INSERT INTO yowao_city_id_name VALUES('660','101101109','');
INSERT INTO yowao_city_id_name VALUES('661','101101110','Т');
INSERT INTO yowao_city_id_name VALUES('662','101101111','');
INSERT INTO yowao_city_id_name VALUES('663','101101112','ˮ');
INSERT INTO yowao_city_id_name VALUES('664','101101113','');
INSERT INTO yowao_city_id_name VALUES('665','101110101','');
INSERT INTO yowao_city_id_name VALUES('666','101110102','');
INSERT INTO yowao_city_id_name VALUES('667','101110103','');
INSERT INTO yowao_city_id_name VALUES('668','101110104','');
INSERT INTO yowao_city_id_name VALUES('669','101110105','');
INSERT INTO yowao_city_id_name VALUES('670','101110106','');
INSERT INTO yowao_city_id_name VALUES('671','101110107','');
INSERT INTO yowao_city_id_name VALUES('672','101110200','');
INSERT INTO yowao_city_id_name VALUES('673','101110201','ԭ');
INSERT INTO yowao_city_id_name VALUES('674','101110202','Ȫ');
INSERT INTO yowao_city_id_name VALUES('675','101110203','');
INSERT INTO yowao_city_id_name VALUES('676','101110204','');
INSERT INTO yowao_city_id_name VALUES('677','101110205','');
INSERT INTO yowao_city_id_name VALUES('678','101110206','书');
INSERT INTO yowao_city_id_name VALUES('679','101110207','Ǭ');
INSERT INTO yowao_city_id_name VALUES('680','101110208','');
INSERT INTO yowao_city_id_name VALUES('681','101110209','');
INSERT INTO yowao_city_id_name VALUES('682','101110210','Ѯ');
INSERT INTO yowao_city_id_name VALUES('683','101110211','ƽ');
INSERT INTO yowao_city_id_name VALUES('684','101110300','Ӱ');
INSERT INTO yowao_city_id_name VALUES('685','101110302','Ӵ');
INSERT INTO yowao_city_id_name VALUES('686','101110303','ӳ');
INSERT INTO yowao_city_id_name VALUES('687','101110301','ӳ');
INSERT INTO yowao_city_id_name VALUES('688','101110304','˴');
INSERT INTO yowao_city_id_name VALUES('689','101110305','');
INSERT INTO yowao_city_id_name VALUES('690','101110306','־');
INSERT INTO yowao_city_id_name VALUES('691','101110307','');
INSERT INTO yowao_city_id_name VALUES('692','101110308','Ȫ');
INSERT INTO yowao_city_id_name VALUES('693','101110309','崨');
INSERT INTO yowao_city_id_name VALUES('694','101110310','');
INSERT INTO yowao_city_id_name VALUES('695','101110311','');
INSERT INTO yowao_city_id_name VALUES('696','101110312','');
INSERT INTO yowao_city_id_name VALUES('697','101110401','');
INSERT INTO yowao_city_id_name VALUES('698','101110402','');
INSERT INTO yowao_city_id_name VALUES('699','101110403','ľ');
INSERT INTO yowao_city_id_name VALUES('700','101110404','');
INSERT INTO yowao_city_id_name VALUES('701','101110405','');
INSERT INTO yowao_city_id_name VALUES('702','101110406','');
INSERT INTO yowao_city_id_name VALUES('703','101110407','ɽ');
INSERT INTO yowao_city_id_name VALUES('704','101110408','֬');
INSERT INTO yowao_city_id_name VALUES('705','101110409','');
INSERT INTO yowao_city_id_name VALUES('706','101110410','');
INSERT INTO yowao_city_id_name VALUES('707','101110411','Ɽ');
INSERT INTO yowao_city_id_name VALUES('708','101110412','彧');
INSERT INTO yowao_city_id_name VALUES('709','101110501','μ');
INSERT INTO yowao_city_id_name VALUES('710','101110502','');
INSERT INTO yowao_city_id_name VALUES('711','101110503','');
INSERT INTO yowao_city_id_name VALUES('712','101110504','');
INSERT INTO yowao_city_id_name VALUES('713','101110505','ˮ');
INSERT INTO yowao_city_id_name VALUES('714','101110506','ƽ');
INSERT INTO yowao_city_id_name VALUES('715','101110507','ѳ');
INSERT INTO yowao_city_id_name VALUES('716','101110508','γ');
INSERT INTO yowao_city_id_name VALUES('717','101110509','');
INSERT INTO yowao_city_id_name VALUES('718','101110510','');
INSERT INTO yowao_city_id_name VALUES('719','101110511','');
INSERT INTO yowao_city_id_name VALUES('720','101110512','ɽ');
INSERT INTO yowao_city_id_name VALUES('721','101110601','');
INSERT INTO yowao_city_id_name VALUES('722','101110602','');
INSERT INTO yowao_city_id_name VALUES('723','101110603','ˮ');
INSERT INTO yowao_city_id_name VALUES('724','101110605','');
INSERT INTO yowao_city_id_name VALUES('725','101110606','');
INSERT INTO yowao_city_id_name VALUES('726','101110607','');
INSERT INTO yowao_city_id_name VALUES('727','101110608','ɽ');
INSERT INTO yowao_city_id_name VALUES('728','101110701','');
INSERT INTO yowao_city_id_name VALUES('729','101110702','');
INSERT INTO yowao_city_id_name VALUES('730','101110703','ʯȪ');
INSERT INTO yowao_city_id_name VALUES('731','101110704','');
INSERT INTO yowao_city_id_name VALUES('732','101110705','Ѯ');
INSERT INTO yowao_city_id_name VALUES('733','101110706','᰸');
INSERT INTO yowao_city_id_name VALUES('734','101110707','ƽ');
INSERT INTO yowao_city_id_name VALUES('735','101110708','׺');
INSERT INTO yowao_city_id_name VALUES('736','101110709','ƺ');
INSERT INTO yowao_city_id_name VALUES('737','101110710','');
INSERT INTO yowao_city_id_name VALUES('738','101110801','');
INSERT INTO yowao_city_id_name VALUES('739','101110802','');
INSERT INTO yowao_city_id_name VALUES('740','101110803','');
INSERT INTO yowao_city_id_name VALUES('741','101110804','');
INSERT INTO yowao_city_id_name VALUES('742','101110805','');
INSERT INTO yowao_city_id_name VALUES('743','101110806','ǹ');
INSERT INTO yowao_city_id_name VALUES('744','101110807','');
INSERT INTO yowao_city_id_name VALUES('745','101110808','ƺ');
INSERT INTO yowao_city_id_name VALUES('746','101110809','ǿ');
INSERT INTO yowao_city_id_name VALUES('747','101110810','֣');
INSERT INTO yowao_city_id_name VALUES('748','101110811','');
INSERT INTO yowao_city_id_name VALUES('749','101110901','');
INSERT INTO yowao_city_id_name VALUES('750','101110902','');
INSERT INTO yowao_city_id_name VALUES('751','101110903','ǧ');
INSERT INTO yowao_city_id_name VALUES('752','101110904','');
INSERT INTO yowao_city_id_name VALUES('753','101110905','ɽ');
INSERT INTO yowao_city_id_name VALUES('754','101110906','');
INSERT INTO yowao_city_id_name VALUES('755','101110907','');
INSERT INTO yowao_city_id_name VALUES('756','101110908','ü');
INSERT INTO yowao_city_id_name VALUES('757','101110909','̫');
INSERT INTO yowao_city_id_name VALUES('758','101110910','');
INSERT INTO yowao_city_id_name VALUES('759','101110911','¤');
INSERT INTO yowao_city_id_name VALUES('760','101111001','ͭ');
INSERT INTO yowao_city_id_name VALUES('761','101111002','ҫ');
INSERT INTO yowao_city_id_name VALUES('762','101111003','˾');
INSERT INTO yowao_city_id_name VALUES('763','101120101','');
INSERT INTO yowao_city_id_name VALUES('764','101120102','');
INSERT INTO yowao_city_id_name VALUES('765','101120103','̺');
INSERT INTO yowao_city_id_name VALUES('766','101120104','');
INSERT INTO yowao_city_id_name VALUES('767','101120105','ƽ');
INSERT INTO yowao_city_id_name VALUES('768','101120106','');
INSERT INTO yowao_city_id_name VALUES('769','101120201','ൺ');
INSERT INTO yowao_city_id_name VALUES('770','101120202','ɽ');
INSERT INTO yowao_city_id_name VALUES('771','101120203','');
INSERT INTO yowao_city_id_name VALUES('772','101120204','ī');
INSERT INTO yowao_city_id_name VALUES('773','101120205','');
INSERT INTO yowao_city_id_name VALUES('774','101120206','');
INSERT INTO yowao_city_id_name VALUES('775','101120207','');
INSERT INTO yowao_city_id_name VALUES('776','101120208','ƽ');
INSERT INTO yowao_city_id_name VALUES('777','101120301','Ͳ');
INSERT INTO yowao_city_id_name VALUES('778','101120302','ʹ');
INSERT INTO yowao_city_id_name VALUES('779','101120303','ɽ');
INSERT INTO yowao_city_id_name VALUES('780','101120304','');
INSERT INTO yowao_city_id_name VALUES('781','101120305','ܴ');
INSERT INTO yowao_city_id_name VALUES('782','101120306','Դ');
INSERT INTO yowao_city_id_name VALUES('783','101120307','̨');
INSERT INTO yowao_city_id_name VALUES('784','101120308','');
INSERT INTO yowao_city_id_name VALUES('785','101120401','');
INSERT INTO yowao_city_id_name VALUES('786','101120402','');
INSERT INTO yowao_city_id_name VALUES('787','101120403','');
INSERT INTO yowao_city_id_name VALUES('788','101120404','');
INSERT INTO yowao_city_id_name VALUES('789','101120405','');
INSERT INTO yowao_city_id_name VALUES('790','101120406','');
INSERT INTO yowao_city_id_name VALUES('791','101120407','');
INSERT INTO yowao_city_id_name VALUES('792','101120408','ƽԭ');
INSERT INTO yowao_city_id_name VALUES('793','101120409','');
INSERT INTO yowao_city_id_name VALUES('794','101120410','Ľ');
INSERT INTO yowao_city_id_name VALUES('795','101120411','');
INSERT INTO yowao_city_id_name VALUES('796','101120501','̨');
INSERT INTO yowao_city_id_name VALUES('797','101120502','');
INSERT INTO yowao_city_id_name VALUES('798','101120503','');
INSERT INTO yowao_city_id_name VALUES('799','101120504','');
INSERT INTO yowao_city_id_name VALUES('800','101120505','');
INSERT INTO yowao_city_id_name VALUES('801','101120506','Զ');
INSERT INTO yowao_city_id_name VALUES('802','101120507','ϼ');
INSERT INTO yowao_city_id_name VALUES('803','101120508','ɽ');
INSERT INTO yowao_city_id_name VALUES('804','101120509','Ĳƽ');
INSERT INTO yowao_city_id_name VALUES('805','101120510','');
INSERT INTO yowao_city_id_name VALUES('806','101120511','');
INSERT INTO yowao_city_id_name VALUES('807','101120512','ǧ');
INSERT INTO yowao_city_id_name VALUES('808','101120601','Ϋ');
INSERT INTO yowao_city_id_name VALUES('809','101120602','');
INSERT INTO yowao_city_id_name VALUES('810','101120603','ٹ');
INSERT INTO yowao_city_id_name VALUES('811','101120604','');
INSERT INTO yowao_city_id_name VALUES('812','101120605','');
INSERT INTO yowao_city_id_name VALUES('813','101120606','');
INSERT INTO yowao_city_id_name VALUES('814','101120607','');
INSERT INTO yowao_city_id_name VALUES('815','101120608','');
INSERT INTO yowao_city_id_name VALUES('816','101120609','');
INSERT INTO yowao_city_id_name VALUES('817','101120701','');
INSERT INTO yowao_city_id_name VALUES('818','101120702','');
INSERT INTO yowao_city_id_name VALUES('819','101120703','΢ɽ');
INSERT INTO yowao_city_id_name VALUES('820','101120704','̨');
INSERT INTO yowao_city_id_name VALUES('821','101120705','');
INSERT INTO yowao_city_id_name VALUES('822','101120706','');
INSERT INTO yowao_city_id_name VALUES('823','101120707','');
INSERT INTO yowao_city_id_name VALUES('824','101120708','ˮ');
INSERT INTO yowao_city_id_name VALUES('825','101120709','ɽ');
INSERT INTO yowao_city_id_name VALUES('826','101120710','');
INSERT INTO yowao_city_id_name VALUES('827','101120711','޳');
INSERT INTO yowao_city_id_name VALUES('828','101120801','̩');
INSERT INTO yowao_city_id_name VALUES('829','101120802','̩');
INSERT INTO yowao_city_id_name VALUES('830','101120803','̩ɽ');
INSERT INTO yowao_city_id_name VALUES('831','101120804','ʳ');
INSERT INTO yowao_city_id_name VALUES('832','101120805','ƽ');
INSERT INTO yowao_city_id_name VALUES('833','101120806','');
INSERT INTO yowao_city_id_name VALUES('834','101120901','');
INSERT INTO yowao_city_id_name VALUES('835','101120902','');
INSERT INTO yowao_city_id_name VALUES('836','101120903','');
INSERT INTO yowao_city_id_name VALUES('837','101120904','ɽ');
INSERT INTO yowao_city_id_name VALUES('838','101120905','');
INSERT INTO yowao_city_id_name VALUES('839','101120906','۰');
INSERT INTO yowao_city_id_name VALUES('840','101120907','');
INSERT INTO yowao_city_id_name VALUES('841','101120908','ƽ');
INSERT INTO yowao_city_id_name VALUES('842','101120909','');
INSERT INTO yowao_city_id_name VALUES('843','101120910','ˮ');
INSERT INTO yowao_city_id_name VALUES('844','101120911','վ');
INSERT INTO yowao_city_id_name VALUES('845','101121001','');
INSERT INTO yowao_city_id_name VALUES('846','101121002','۲');
INSERT INTO yowao_city_id_name VALUES('847','101121003','۩');
INSERT INTO yowao_city_id_name VALUES('848','101121004','');
INSERT INTO yowao_city_id_name VALUES('849','101121005','');
INSERT INTO yowao_city_id_name VALUES('850','101121006','Ұ');
INSERT INTO yowao_city_id_name VALUES('851','101121007','');
INSERT INTO yowao_city_id_name VALUES('852','101121008','');
INSERT INTO yowao_city_id_name VALUES('853','101121009','');
INSERT INTO yowao_city_id_name VALUES('854','101121101','');
INSERT INTO yowao_city_id_name VALUES('855','101121102','');
INSERT INTO yowao_city_id_name VALUES('856','101121103','');
INSERT INTO yowao_city_id_name VALUES('857','101121104','');
INSERT INTO yowao_city_id_name VALUES('858','101121105','');
INSERT INTO yowao_city_id_name VALUES('859','101121106','մ');
INSERT INTO yowao_city_id_name VALUES('860','101121107','ƽ');
INSERT INTO yowao_city_id_name VALUES('861','101121201','Ӫ');
INSERT INTO yowao_city_id_name VALUES('862','101121202','ӿ');
INSERT INTO yowao_city_id_name VALUES('863','101121203','');
INSERT INTO yowao_city_id_name VALUES('864','101121204','');
INSERT INTO yowao_city_id_name VALUES('865','101121205','');
INSERT INTO yowao_city_id_name VALUES('866','101121301','');
INSERT INTO yowao_city_id_name VALUES('867','101121302','ĵ');
INSERT INTO yowao_city_id_name VALUES('868','101121303','ٳ');
INSERT INTO yowao_city_id_name VALUES('869','101121304','ɽ');
INSERT INTO yowao_city_id_name VALUES('870','101121305','ɽͷ');
INSERT INTO yowao_city_id_name VALUES('871','101121306','ʯ');
INSERT INTO yowao_city_id_name VALUES('872','101121401','ׯ');
INSERT INTO yowao_city_id_name VALUES('873','101121402','Ѧ');
INSERT INTO yowao_city_id_name VALUES('874','101121403','ỳ');
INSERT INTO yowao_city_id_name VALUES('875','101121404','̨ׯ');
INSERT INTO yowao_city_id_name VALUES('876','101121405','');
INSERT INTO yowao_city_id_name VALUES('877','101121501','');
INSERT INTO yowao_city_id_name VALUES('878','101121502','');
INSERT INTO yowao_city_id_name VALUES('879','101121503','');
INSERT INTO yowao_city_id_name VALUES('880','101121601','');
INSERT INTO yowao_city_id_name VALUES('881','101121701','ĳ');
INSERT INTO yowao_city_id_name VALUES('882','101121702','');
INSERT INTO yowao_city_id_name VALUES('883','101121703','');
INSERT INTO yowao_city_id_name VALUES('884','101121704','');
INSERT INTO yowao_city_id_name VALUES('885','101121705','ƽ');
INSERT INTO yowao_city_id_name VALUES('886','101121706','');
INSERT INTO yowao_city_id_name VALUES('887','101121707','');
INSERT INTO yowao_city_id_name VALUES('888','101121708','');
INSERT INTO yowao_city_id_name VALUES('889','101130101','³ľ');
INSERT INTO yowao_city_id_name VALUES('890','101130102','̼Һ');
INSERT INTO yowao_city_id_name VALUES('891','101130103','С');
INSERT INTO yowao_city_id_name VALUES('892','101130104','̨');
INSERT INTO yowao_city_id_name VALUES('893','101130105','');
INSERT INTO yowao_city_id_name VALUES('894','101130106','ʮ䷿վ');
INSERT INTO yowao_city_id_name VALUES('895','101130107','ɽ');
INSERT INTO yowao_city_id_name VALUES('896','101130108','³ľվ');
INSERT INTO yowao_city_id_name VALUES('897','101130109','');
INSERT INTO yowao_city_id_name VALUES('898','101130201','');
INSERT INTO yowao_city_id_name VALUES('899','101130301','ʯ');
INSERT INTO yowao_city_id_name VALUES('900','101130302','̨');
INSERT INTO yowao_city_id_name VALUES('901','101130303','Ī');
INSERT INTO yowao_city_id_name VALUES('902','101130304','');
INSERT INTO yowao_city_id_name VALUES('903','101130401','');
INSERT INTO yowao_city_id_name VALUES('904','101130402','ͼ');
INSERT INTO yowao_city_id_name VALUES('905','101130403','Ȫ');
INSERT INTO yowao_city_id_name VALUES('906','101130404','');
INSERT INTO yowao_city_id_name VALUES('907','101130405','ľ');
INSERT INTO yowao_city_id_name VALUES('908','101130406','̨');
INSERT INTO yowao_city_id_name VALUES('909','101130407','˹');
INSERT INTO yowao_city_id_name VALUES('910','101130408','ľ');
INSERT INTO yowao_city_id_name VALUES('911','101130409','ɽ');
INSERT INTO yowao_city_id_name VALUES('912','101130501','³');
INSERT INTO yowao_city_id_name VALUES('913','101130502','пѷ');
INSERT INTO yowao_city_id_name VALUES('914','101130503','³');
INSERT INTO yowao_city_id_name VALUES('915','101130504','۷');
INSERT INTO yowao_city_id_name VALUES('916','101130505','');
INSERT INTO yowao_city_id_name VALUES('917','101130601','');
INSERT INTO yowao_city_id_name VALUES('918','101130602','̨');
INSERT INTO yowao_city_id_name VALUES('919','101130603','ξ');
INSERT INTO yowao_city_id_name VALUES('920','101130604','Ǽ');
INSERT INTO yowao_city_id_name VALUES('921','101130605','ĩ');
INSERT INTO yowao_city_id_name VALUES('922','101130606',';');
INSERT INTO yowao_city_id_name VALUES('923','101130607','');
INSERT INTO yowao_city_id_name VALUES('924','101130608','˶');
INSERT INTO yowao_city_id_name VALUES('925','101130609','ʲ');
INSERT INTO yowao_city_id_name VALUES('926','101130610','³');
INSERT INTO yowao_city_id_name VALUES('927','101130611','');
INSERT INTO yowao_city_id_name VALUES('928','101130701','');
INSERT INTO yowao_city_id_name VALUES('929','101130801','');
INSERT INTO yowao_city_id_name VALUES('930','101130802','ʲ');
INSERT INTO yowao_city_id_name VALUES('931','101130803','');
INSERT INTO yowao_city_id_name VALUES('932','101130804','ݳ');
INSERT INTO yowao_city_id_name VALUES('933','101130805','º');
INSERT INTO yowao_city_id_name VALUES('934','101130806','ɳ');
INSERT INTO yowao_city_id_name VALUES('935','101130807','⳵');
INSERT INTO yowao_city_id_name VALUES('936','101130808','ƺ');
INSERT INTO yowao_city_id_name VALUES('937','101130809','');
INSERT INTO yowao_city_id_name VALUES('938','101130901','ʲ');
INSERT INTO yowao_city_id_name VALUES('939','101130902','Ӣɳ');
INSERT INTO yowao_city_id_name VALUES('940','101130903','ʲ');
INSERT INTO yowao_city_id_name VALUES('941','101130904','');
INSERT INTO yowao_city_id_name VALUES('942','101130905','ɯ');
INSERT INTO yowao_city_id_name VALUES('943','101130906','Ҷ');
INSERT INTO yowao_city_id_name VALUES('944','101130907','');
INSERT INTO yowao_city_id_name VALUES('945','101130908','ͳ');
INSERT INTO yowao_city_id_name VALUES('946','101130909','պ');
INSERT INTO yowao_city_id_name VALUES('947','101130910','٤ʦ');
INSERT INTO yowao_city_id_name VALUES('948','101131001','');
INSERT INTO yowao_city_id_name VALUES('949','101131002','첼');
INSERT INTO yowao_city_id_name VALUES('950','101131003','տ');
INSERT INTO yowao_city_id_name VALUES('951','101131004','');
INSERT INTO yowao_city_id_name VALUES('952','101131005','');
INSERT INTO yowao_city_id_name VALUES('953','101131006','Դ');
INSERT INTO yowao_city_id_name VALUES('954','101131007','');
INSERT INTO yowao_city_id_name VALUES('955','101131008','ؿ˹');
INSERT INTO yowao_city_id_name VALUES('956','101131009','');
INSERT INTO yowao_city_id_name VALUES('957','101131010','˹');
INSERT INTO yowao_city_id_name VALUES('958','101131101','');
INSERT INTO yowao_city_id_name VALUES('959','101131102','ԣ');
INSERT INTO yowao_city_id_name VALUES('960','101131103','');
INSERT INTO yowao_city_id_name VALUES('961','101131104','Ͳ');
INSERT INTO yowao_city_id_name VALUES('962','101131105','');
INSERT INTO yowao_city_id_name VALUES('963','101131106','');
INSERT INTO yowao_city_id_name VALUES('964','101131107','ɳ');
INSERT INTO yowao_city_id_name VALUES('965','101131201','');
INSERT INTO yowao_city_id_name VALUES('966','101131202','߳');
INSERT INTO yowao_city_id_name VALUES('967','101131203','');
INSERT INTO yowao_city_id_name VALUES('968','101131204','');
INSERT INTO yowao_city_id_name VALUES('969','101131205','ë');
INSERT INTO yowao_city_id_name VALUES('970','101131301','');
INSERT INTO yowao_city_id_name VALUES('971','101131302','Ƥɽ');
INSERT INTO yowao_city_id_name VALUES('972','101131303','');
INSERT INTO yowao_city_id_name VALUES('973','101131304','ī');
INSERT INTO yowao_city_id_name VALUES('974','101131305','');
INSERT INTO yowao_city_id_name VALUES('975','101131306','');
INSERT INTO yowao_city_id_name VALUES('976','101131307','');
INSERT INTO yowao_city_id_name VALUES('977','101131401','̩');
INSERT INTO yowao_city_id_name VALUES('978','101131402','ͺ');
INSERT INTO yowao_city_id_name VALUES('979','101131403','һ');
INSERT INTO yowao_city_id_name VALUES('980','101131404','ɽͷ');
INSERT INTO yowao_city_id_name VALUES('981','101131405','ľ');
INSERT INTO yowao_city_id_name VALUES('982','101131406','');
INSERT INTO yowao_city_id_name VALUES('983','101131407','');
INSERT INTO yowao_city_id_name VALUES('984','101131408','');
INSERT INTO yowao_city_id_name VALUES('985','101131409','');
INSERT INTO yowao_city_id_name VALUES('986','101131410','º');
INSERT INTO yowao_city_id_name VALUES('987','101131501','ͼʲ');
INSERT INTO yowao_city_id_name VALUES('988','101131502','ǡ');
INSERT INTO yowao_city_id_name VALUES('989','101131503','');
INSERT INTO yowao_city_id_name VALUES('990','101131504','');
INSERT INTO yowao_city_id_name VALUES('991','101131505','¶');
INSERT INTO yowao_city_id_name VALUES('992','101131601','');
INSERT INTO yowao_city_id_name VALUES('993','101131602','Ȫ');
INSERT INTO yowao_city_id_name VALUES('994','101131603','');
INSERT INTO yowao_city_id_name VALUES('995','101131606','ɽ');
INSERT INTO yowao_city_id_name VALUES('996','101140101','');
INSERT INTO yowao_city_id_name VALUES('997','101140102','');
INSERT INTO yowao_city_id_name VALUES('998','101140103','ľ');
INSERT INTO yowao_city_id_name VALUES('999','101140104','ī񹱿');
INSERT INTO yowao_city_id_name VALUES('1000','101140201','տ');
INSERT INTO yowao_city_id_name VALUES('1001','101140202','');
INSERT INTO yowao_city_id_name VALUES('1002','101140203','ľ');
INSERT INTO yowao_city_id_name VALUES('1003','101140204','ľ');
INSERT INTO yowao_city_id_name VALUES('1004','101140205','');
INSERT INTO yowao_city_id_name VALUES('1005','101140206','');
INSERT INTO yowao_city_id_name VALUES('1006','101140207','');
INSERT INTO yowao_city_id_name VALUES('1007','101140301','ɽ');
INSERT INTO yowao_city_id_name VALUES('1008','101140302','');
INSERT INTO yowao_city_id_name VALUES('1009','101140303','');
INSERT INTO yowao_city_id_name VALUES('1010','101140304','Ӳ');
INSERT INTO yowao_city_id_name VALUES('1011','101140305','˿');
INSERT INTO yowao_city_id_name VALUES('1012','101140306','');
INSERT INTO yowao_city_id_name VALUES('1013','101140307','¡');
INSERT INTO yowao_city_id_name VALUES('1014','101140401','֥');
INSERT INTO yowao_city_id_name VALUES('1015','101140402','');
INSERT INTO yowao_city_id_name VALUES('1016','101140403','');
INSERT INTO yowao_city_id_name VALUES('1017','101140404','');
INSERT INTO yowao_city_id_name VALUES('1018','101140501','');
INSERT INTO yowao_city_id_name VALUES('1019','101140502','');
INSERT INTO yowao_city_id_name VALUES('1020','101140503','');
INSERT INTO yowao_city_id_name VALUES('1021','101140504','¡');
INSERT INTO yowao_city_id_name VALUES('1022','101140505','');
INSERT INTO yowao_city_id_name VALUES('1023','101140506','â');
INSERT INTO yowao_city_id_name VALUES('1024','101140507','');
INSERT INTO yowao_city_id_name VALUES('1025','101140601','');
INSERT INTO yowao_city_id_name VALUES('1026','101140603','');
INSERT INTO yowao_city_id_name VALUES('1027','101140604','');
INSERT INTO yowao_city_id_name VALUES('1028','101140605','');
INSERT INTO yowao_city_id_name VALUES('1029','101140606','');
INSERT INTO yowao_city_id_name VALUES('1030','101140607','');
INSERT INTO yowao_city_id_name VALUES('1031','101140701','');
INSERT INTO yowao_city_id_name VALUES('1032','101140702','');
INSERT INTO yowao_city_id_name VALUES('1033','101140703','');
INSERT INTO yowao_city_id_name VALUES('1034','101140704','ʨȪ');
INSERT INTO yowao_city_id_name VALUES('1035','101150101','');
INSERT INTO yowao_city_id_name VALUES('1036','101150102','ͨ');
INSERT INTO yowao_city_id_name VALUES('1037','101150103','Դ');
INSERT INTO yowao_city_id_name VALUES('1038','101150104','');
INSERT INTO yowao_city_id_name VALUES('1039','101150105','');
INSERT INTO yowao_city_id_name VALUES('1040','101150106','');
INSERT INTO yowao_city_id_name VALUES('1041','101150107','վ');
INSERT INTO yowao_city_id_name VALUES('1042','101150201','');
INSERT INTO yowao_city_id_name VALUES('1043','101150202','ֶ');
INSERT INTO yowao_city_id_name VALUES('1044','101150203','');
INSERT INTO yowao_city_id_name VALUES('1045','101150204','');
INSERT INTO yowao_city_id_name VALUES('1046','101150205','¡');
INSERT INTO yowao_city_id_name VALUES('1047','101150206','ѭ');
INSERT INTO yowao_city_id_name VALUES('1048','101150207','');
INSERT INTO yowao_city_id_name VALUES('1049','101150301','');
INSERT INTO yowao_city_id_name VALUES('1050','101150302','');
INSERT INTO yowao_city_id_name VALUES('1051','101150303','');
INSERT INTO yowao_city_id_name VALUES('1052','101150401','');
INSERT INTO yowao_city_id_name VALUES('1053','101150402','');
INSERT INTO yowao_city_id_name VALUES('1054','101150404','');
INSERT INTO yowao_city_id_name VALUES('1055','101150405','ӿ');
INSERT INTO yowao_city_id_name VALUES('1056','101150406','˺');
INSERT INTO yowao_city_id_name VALUES('1057','101150407','');
INSERT INTO yowao_city_id_name VALUES('1058','101150408','ͬ');
INSERT INTO yowao_city_id_name VALUES('1059','101150501','');
INSERT INTO yowao_city_id_name VALUES('1060','101150502','');
INSERT INTO yowao_city_id_name VALUES('1061','101150503','ʵ');
INSERT INTO yowao_city_id_name VALUES('1062','101150504','');
INSERT INTO yowao_city_id_name VALUES('1063','101150505','');
INSERT INTO yowao_city_id_name VALUES('1064','101150506','');
INSERT INTO yowao_city_id_name VALUES('1065','101150507','ˮ');
INSERT INTO yowao_city_id_name VALUES('1066','101150601','');
INSERT INTO yowao_city_id_name VALUES('1067','101150602','к');
INSERT INTO yowao_city_id_name VALUES('1068','101150603','ζ');
INSERT INTO yowao_city_id_name VALUES('1069','101150604','Ӷ');
INSERT INTO yowao_city_id_name VALUES('1070','101150605','ǫ');
INSERT INTO yowao_city_id_name VALUES('1071','101150606','');
INSERT INTO yowao_city_id_name VALUES('1072','101150701','');
INSERT INTO yowao_city_id_name VALUES('1073','101150702','ľ');
INSERT INTO yowao_city_id_name VALUES('1074','101150703','');
INSERT INTO yowao_city_id_name VALUES('1075','101150704','Ұţ');
INSERT INTO yowao_city_id_name VALUES('1076','101150705','');
INSERT INTO yowao_city_id_name VALUES('1077','101150706','С');
INSERT INTO yowao_city_id_name VALUES('1078','101150708','');
INSERT INTO yowao_city_id_name VALUES('1079','101150709','');
INSERT INTO yowao_city_id_name VALUES('1080','101150710','');
INSERT INTO yowao_city_id_name VALUES('1081','101150711','ŵľ');
INSERT INTO yowao_city_id_name VALUES('1082','101150712','ã');
INSERT INTO yowao_city_id_name VALUES('1083','101150713','');
INSERT INTO yowao_city_id_name VALUES('1084','101150714','迨');
INSERT INTO yowao_city_id_name VALUES('1085','101150715','յ');
INSERT INTO yowao_city_id_name VALUES('1086','101150801','');
INSERT INTO yowao_city_id_name VALUES('1087','101150802','Դ');
INSERT INTO yowao_city_id_name VALUES('1088','101150803','');
INSERT INTO yowao_city_id_name VALUES('1089','101150804','');
INSERT INTO yowao_city_id_name VALUES('1090','101150805','');
INSERT INTO yowao_city_id_name VALUES('1091','101160101','');
INSERT INTO yowao_city_id_name VALUES('1092','101160102','');
INSERT INTO yowao_city_id_name VALUES('1093','101160103','');
INSERT INTO yowao_city_id_name VALUES('1094','101160104','');
INSERT INTO yowao_city_id_name VALUES('1095','101160201','');
INSERT INTO yowao_city_id_name VALUES('1096','101160202','ͨμ');
INSERT INTO yowao_city_id_name VALUES('1097','101160203','¤');
INSERT INTO yowao_city_id_name VALUES('1098','101160204','μԴ');
INSERT INTO yowao_city_id_name VALUES('1099','101160205','');
INSERT INTO yowao_city_id_name VALUES('1100','101160206','');
INSERT INTO yowao_city_id_name VALUES('1101','101160207','');
INSERT INTO yowao_city_id_name VALUES('1102','101160301','ƽ');
INSERT INTO yowao_city_id_name VALUES('1103','101160302','');
INSERT INTO yowao_city_id_name VALUES('1104','101160303','̨');
INSERT INTO yowao_city_id_name VALUES('1105','101160304','');
INSERT INTO yowao_city_id_name VALUES('1106','101160305','ͤ');
INSERT INTO yowao_city_id_name VALUES('1107','101160306','ׯ');
INSERT INTO yowao_city_id_name VALUES('1108','101160307','');
INSERT INTO yowao_city_id_name VALUES('1109','101160401','');
INSERT INTO yowao_city_id_name VALUES('1110','101160402','');
INSERT INTO yowao_city_id_name VALUES('1111','101160403','');
INSERT INTO yowao_city_id_name VALUES('1112','101160404','');
INSERT INTO yowao_city_id_name VALUES('1113','101160405','ˮ');
INSERT INTO yowao_city_id_name VALUES('1114','101160406','');
INSERT INTO yowao_city_id_name VALUES('1115','101160407','');
INSERT INTO yowao_city_id_name VALUES('1116','101160408','ԭ');
INSERT INTO yowao_city_id_name VALUES('1117','101160501','');
INSERT INTO yowao_city_id_name VALUES('1118','101160502','');
INSERT INTO yowao_city_id_name VALUES('1119','101160503','');
INSERT INTO yowao_city_id_name VALUES('1120','101160504','');
INSERT INTO yowao_city_id_name VALUES('1121','101160601','');
INSERT INTO yowao_city_id_name VALUES('1122','101160602','');
INSERT INTO yowao_city_id_name VALUES('1123','101160701','Ҵ');
INSERT INTO yowao_city_id_name VALUES('1124','101160702','');
INSERT INTO yowao_city_id_name VALUES('1125','101160703','');
INSERT INTO yowao_city_id_name VALUES('1126','101160704','');
INSERT INTO yowao_city_id_name VALUES('1127','101160705','̨');
INSERT INTO yowao_city_id_name VALUES('1128','101160706','ɽ');
INSERT INTO yowao_city_id_name VALUES('1129','101160801','Ȫ');
INSERT INTO yowao_city_id_name VALUES('1130','101160802','');
INSERT INTO yowao_city_id_name VALUES('1131','101160803','');
INSERT INTO yowao_city_id_name VALUES('1132','101160804','ɽ');
INSERT INTO yowao_city_id_name VALUES('1133','101160805','');
INSERT INTO yowao_city_id_name VALUES('1134','101160806','౱');
INSERT INTO yowao_city_id_name VALUES('1135','101160807','');
INSERT INTO yowao_city_id_name VALUES('1136','101160808','ػ');
INSERT INTO yowao_city_id_name VALUES('1137','101160901','ˮ');
INSERT INTO yowao_city_id_name VALUES('1138','101160902','');
INSERT INTO yowao_city_id_name VALUES('1139','101160903','ˮ');
INSERT INTO yowao_city_id_name VALUES('1140','101160904','ذ');
INSERT INTO yowao_city_id_name VALUES('1141','101160905','ʹ');
INSERT INTO yowao_city_id_name VALUES('1142','101160906','ɽ');
INSERT INTO yowao_city_id_name VALUES('1143','101160907','żҴ');
INSERT INTO yowao_city_id_name VALUES('1144','101161001','䶼');
INSERT INTO yowao_city_id_name VALUES('1145','101161002','');
INSERT INTO yowao_city_id_name VALUES('1146','101161003','');
INSERT INTO yowao_city_id_name VALUES('1147','101161004','崲');
INSERT INTO yowao_city_id_name VALUES('1148','101161005','');
INSERT INTO yowao_city_id_name VALUES('1149','101161006','');
INSERT INTO yowao_city_id_name VALUES('1150','101161007','');
INSERT INTO yowao_city_id_name VALUES('1151','101161008','');
INSERT INTO yowao_city_id_name VALUES('1152','101161009','');
INSERT INTO yowao_city_id_name VALUES('1153','101161101','');
INSERT INTO yowao_city_id_name VALUES('1154','101161102','');
INSERT INTO yowao_city_id_name VALUES('1155','101161103','');
INSERT INTO yowao_city_id_name VALUES('1156','101161104','');
INSERT INTO yowao_city_id_name VALUES('1157','101161105','');
INSERT INTO yowao_city_id_name VALUES('1158','101161106','');
INSERT INTO yowao_city_id_name VALUES('1159','101161201','');
INSERT INTO yowao_city_id_name VALUES('1160','101161202','̶');
INSERT INTO yowao_city_id_name VALUES('1161','101161203','׿');
INSERT INTO yowao_city_id_name VALUES('1162','101161204','');
INSERT INTO yowao_city_id_name VALUES('1163','101161205','');
INSERT INTO yowao_city_id_name VALUES('1164','101161206','');
INSERT INTO yowao_city_id_name VALUES('1165','101161207','µ');
INSERT INTO yowao_city_id_name VALUES('1166','101161208','ĺ');
INSERT INTO yowao_city_id_name VALUES('1167','101161301','');
INSERT INTO yowao_city_id_name VALUES('1168','101161302','Զ');
INSERT INTO yowao_city_id_name VALUES('1169','101161303','');
INSERT INTO yowao_city_id_name VALUES('1170','101161304','');
INSERT INTO yowao_city_id_name VALUES('1171','101161305','̩');
INSERT INTO yowao_city_id_name VALUES('1172','101170101','');
INSERT INTO yowao_city_id_name VALUES('1173','101170102','');
INSERT INTO yowao_city_id_name VALUES('1174','101170103','');
INSERT INTO yowao_city_id_name VALUES('1175','101170104','');
INSERT INTO yowao_city_id_name VALUES('1176','101170201','ʯɽ');
INSERT INTO yowao_city_id_name VALUES('1177','101170202','ũ');
INSERT INTO yowao_city_id_name VALUES('1178','101170203','ƽ');
INSERT INTO yowao_city_id_name VALUES('1179','101170204','');
INSERT INTO yowao_city_id_name VALUES('1180','101170205','ʯ̿');
INSERT INTO yowao_city_id_name VALUES('1181','101170301','');
INSERT INTO yowao_city_id_name VALUES('1182','101170302','ͬ');
INSERT INTO yowao_city_id_name VALUES('1183','101170303','γ');
INSERT INTO yowao_city_id_name VALUES('1184','101170304','Τ');
INSERT INTO yowao_city_id_name VALUES('1185','101170305','ɽ');
INSERT INTO yowao_city_id_name VALUES('1186','101170306','ͭϿ');
INSERT INTO yowao_city_id_name VALUES('1187','101170401','ԭ');
INSERT INTO yowao_city_id_name VALUES('1188','101170402','');
INSERT INTO yowao_city_id_name VALUES('1189','101170403','¡');
INSERT INTO yowao_city_id_name VALUES('1190','101170404','Դ');
INSERT INTO yowao_city_id_name VALUES('1191','101170405','ɽ');
INSERT INTO yowao_city_id_name VALUES('1192','101170501','');
INSERT INTO yowao_city_id_name VALUES('1193','101170502','');
INSERT INTO yowao_city_id_name VALUES('1194','101170503','ʱ');
INSERT INTO yowao_city_id_name VALUES('1195','101170504','ԭ');
INSERT INTO yowao_city_id_name VALUES('1196','101180101','֣');
INSERT INTO yowao_city_id_name VALUES('1197','101180102','');
INSERT INTO yowao_city_id_name VALUES('1198','101180103','');
INSERT INTO yowao_city_id_name VALUES('1199','101180104','Ƿ');
INSERT INTO yowao_city_id_name VALUES('1200','101180105','');
INSERT INTO yowao_city_id_name VALUES('1201','101180106','֣');
INSERT INTO yowao_city_id_name VALUES('1202','101180107','Ĳ');
INSERT INTO yowao_city_id_name VALUES('1203','101180108','֣ũվ');
INSERT INTO yowao_city_id_name VALUES('1204','101180201','');
INSERT INTO yowao_city_id_name VALUES('1205','101180202','');
INSERT INTO yowao_city_id_name VALUES('1206','101180203','');
INSERT INTO yowao_city_id_name VALUES('1207','101180204','ڻ');
INSERT INTO yowao_city_id_name VALUES('1208','101180205','');
INSERT INTO yowao_city_id_name VALUES('1209','101180301','');
INSERT INTO yowao_city_id_name VALUES('1210','101180302','');
INSERT INTO yowao_city_id_name VALUES('1211','101180303','ԭ');
INSERT INTO yowao_city_id_name VALUES('1212','101180304','');
INSERT INTO yowao_city_id_name VALUES('1213','101180305','');
INSERT INTO yowao_city_id_name VALUES('1214','101180306','ӽ');
INSERT INTO yowao_city_id_name VALUES('1215','101180307','');
INSERT INTO yowao_city_id_name VALUES('1216','101180308','ԫ');
INSERT INTO yowao_city_id_name VALUES('1217','101180401','');
INSERT INTO yowao_city_id_name VALUES('1218','101180402','۳');
INSERT INTO yowao_city_id_name VALUES('1219','101180403','');
INSERT INTO yowao_city_id_name VALUES('1220','101180404','');
INSERT INTO yowao_city_id_name VALUES('1221','101180405','');
INSERT INTO yowao_city_id_name VALUES('1222','101180501','ƽɽ');
INSERT INTO yowao_city_id_name VALUES('1223','101180502','ۣ');
INSERT INTO yowao_city_id_name VALUES('1224','101180503','');
INSERT INTO yowao_city_id_name VALUES('1225','101180504','');
INSERT INTO yowao_city_id_name VALUES('1226','101180505','Ҷ');
INSERT INTO yowao_city_id_name VALUES('1227','101180506','');
INSERT INTO yowao_city_id_name VALUES('1228','101180507','³ɽ');
INSERT INTO yowao_city_id_name VALUES('1229','101180601','');
INSERT INTO yowao_city_id_name VALUES('1230','101180602','Ϣ');
INSERT INTO yowao_city_id_name VALUES('1231','101180603','ɽ');
INSERT INTO yowao_city_id_name VALUES('1232','101180604','ɽ');
INSERT INTO yowao_city_id_name VALUES('1233','101180605','');
INSERT INTO yowao_city_id_name VALUES('1234','101180606','');
INSERT INTO yowao_city_id_name VALUES('1235','101180607','괨');
INSERT INTO yowao_city_id_name VALUES('1236','101180608','ʼ');
INSERT INTO yowao_city_id_name VALUES('1237','101180609','̳');
INSERT INTO yowao_city_id_name VALUES('1238','101180610','ɽ');
INSERT INTO yowao_city_id_name VALUES('1239','101180611','ũվ');
INSERT INTO yowao_city_id_name VALUES('1240','101180701','');
INSERT INTO yowao_city_id_name VALUES('1241','101180702','');
INSERT INTO yowao_city_id_name VALUES('1242','101180703','');
INSERT INTO yowao_city_id_name VALUES('1243','101180704','');
INSERT INTO yowao_city_id_name VALUES('1244','101180705','Ͽ');
INSERT INTO yowao_city_id_name VALUES('1245','101180706','');
INSERT INTO yowao_city_id_name VALUES('1246','101180707','ƽ');
INSERT INTO yowao_city_id_name VALUES('1247','101180708','');
INSERT INTO yowao_city_id_name VALUES('1248','101180709','Ұ');
INSERT INTO yowao_city_id_name VALUES('1249','101180710','ƺ');
INSERT INTO yowao_city_id_name VALUES('1250','101180711','');
INSERT INTO yowao_city_id_name VALUES('1251','101180712','ͩ');
INSERT INTO yowao_city_id_name VALUES('1252','101180801','');
INSERT INTO yowao_city_id_name VALUES('1253','101180802','');
INSERT INTO yowao_city_id_name VALUES('1254','101180803','ξ');
INSERT INTO yowao_city_id_name VALUES('1255','101180804','ͨ');
INSERT INTO yowao_city_id_name VALUES('1256','101180805','');
INSERT INTO yowao_city_id_name VALUES('1257','101180901','');
INSERT INTO yowao_city_id_name VALUES('1258','101180902','°');
INSERT INTO yowao_city_id_name VALUES('1259','101180903','Ͻ');
INSERT INTO yowao_city_id_name VALUES('1260','101180904','');
INSERT INTO yowao_city_id_name VALUES('1261','101180905','');
INSERT INTO yowao_city_id_name VALUES('1262','101180906','');
INSERT INTO yowao_city_id_name VALUES('1263','101180907','');
INSERT INTO yowao_city_id_name VALUES('1264','101180908','ʦ');
INSERT INTO yowao_city_id_name VALUES('1265','101180909','ﴨ');
INSERT INTO yowao_city_id_name VALUES('1266','101180910','');
INSERT INTO yowao_city_id_name VALUES('1267','101181001','');
INSERT INTO yowao_city_id_name VALUES('1268','101181002','');
INSERT INTO yowao_city_id_name VALUES('1269','101181003','');
INSERT INTO yowao_city_id_name VALUES('1270','101181004','Ȩ');
INSERT INTO yowao_city_id_name VALUES('1271','101181005','ݳ');
INSERT INTO yowao_city_id_name VALUES('1272','101181006','ϳ');
INSERT INTO yowao_city_id_name VALUES('1273','101181007','');
INSERT INTO yowao_city_id_name VALUES('1274','101181008','');
INSERT INTO yowao_city_id_name VALUES('1275','101181009','');
INSERT INTO yowao_city_id_name VALUES('1276','101181101','');
INSERT INTO yowao_city_id_name VALUES('1277','101181102','');
INSERT INTO yowao_city_id_name VALUES('1278','101181103','');
INSERT INTO yowao_city_id_name VALUES('1279','101181104','');
INSERT INTO yowao_city_id_name VALUES('1280','101181106','');
INSERT INTO yowao_city_id_name VALUES('1281','101181107','');
INSERT INTO yowao_city_id_name VALUES('1282','101181108','');
INSERT INTO yowao_city_id_name VALUES('1283','101181201','ױ');
INSERT INTO yowao_city_id_name VALUES('1284','101181202','');
INSERT INTO yowao_city_id_name VALUES('1285','101181203','');
INSERT INTO yowao_city_id_name VALUES('1286','101181301','');
INSERT INTO yowao_city_id_name VALUES('1287','101181302','̨ǰ');
INSERT INTO yowao_city_id_name VALUES('1288','101181303','');
INSERT INTO yowao_city_id_name VALUES('1289','101181304','');
INSERT INTO yowao_city_id_name VALUES('1290','101181305','');
INSERT INTO yowao_city_id_name VALUES('1291','101181401','ܿ');
INSERT INTO yowao_city_id_name VALUES('1292','101181402','');
INSERT INTO yowao_city_id_name VALUES('1293','101181403','̫');
INSERT INTO yowao_city_id_name VALUES('1294','101181404','');
INSERT INTO yowao_city_id_name VALUES('1295','101181405','');
INSERT INTO yowao_city_id_name VALUES('1296','101181406','ˮ');
INSERT INTO yowao_city_id_name VALUES('1297','101181407','');
INSERT INTO yowao_city_id_name VALUES('1298','101181408','');
INSERT INTO yowao_city_id_name VALUES('1299','101181409','¹');
INSERT INTO yowao_city_id_name VALUES('1300','101181410','');
INSERT INTO yowao_city_id_name VALUES('1301','101181411','Ʒ');
INSERT INTO yowao_city_id_name VALUES('1302','101181501','');
INSERT INTO yowao_city_id_name VALUES('1303','101181502','');
INSERT INTO yowao_city_id_name VALUES('1304','101181503','');
INSERT INTO yowao_city_id_name VALUES('1305','101181601','פ');
INSERT INTO yowao_city_id_name VALUES('1306','101181602','ƽ');
INSERT INTO yowao_city_id_name VALUES('1307','101181603','ƽ');
INSERT INTO yowao_city_id_name VALUES('1308','101181604','ϲ');
INSERT INTO yowao_city_id_name VALUES('1309','101181605','');
INSERT INTO yowao_city_id_name VALUES('1310','101181606','');
INSERT INTO yowao_city_id_name VALUES('1311','101181607','ƽ');
INSERT INTO yowao_city_id_name VALUES('1312','101181608','²');
INSERT INTO yowao_city_id_name VALUES('1313','101181609','ȷɽ');
INSERT INTO yowao_city_id_name VALUES('1314','101181610','');
INSERT INTO yowao_city_id_name VALUES('1315','101181701','Ͽ');
INSERT INTO yowao_city_id_name VALUES('1316','101181702','鱦');
INSERT INTO yowao_city_id_name VALUES('1317','101181703','ų');
INSERT INTO yowao_city_id_name VALUES('1318','101181704','¬');
INSERT INTO yowao_city_id_name VALUES('1319','101181801','Դ');
INSERT INTO yowao_city_id_name VALUES('1320','101190101','Ͼ');
INSERT INTO yowao_city_id_name VALUES('1321','101190102','ˮ');
INSERT INTO yowao_city_id_name VALUES('1322','101190103','ߴ');
INSERT INTO yowao_city_id_name VALUES('1323','101190104','');
INSERT INTO yowao_city_id_name VALUES('1324','101190105','');
INSERT INTO yowao_city_id_name VALUES('1325','101190106','');
INSERT INTO yowao_city_id_name VALUES('1326','101190201','');
INSERT INTO yowao_city_id_name VALUES('1327','101190202','');
INSERT INTO yowao_city_id_name VALUES('1328','101190203','');
INSERT INTO yowao_city_id_name VALUES('1329','101190301','');
INSERT INTO yowao_city_id_name VALUES('1330','101190302','');
INSERT INTO yowao_city_id_name VALUES('1331','101190303','');
INSERT INTO yowao_city_id_name VALUES('1332','101190304','');
INSERT INTO yowao_city_id_name VALUES('1333','101190305','ͽ');
INSERT INTO yowao_city_id_name VALUES('1334','101190401','');
INSERT INTO yowao_city_id_name VALUES('1335','101190402','');
INSERT INTO yowao_city_id_name VALUES('1336','101190403','żҸ');
INSERT INTO yowao_city_id_name VALUES('1337','101190404','ɽ');
INSERT INTO yowao_city_id_name VALUES('1338','101190405','ضɽ');
INSERT INTO yowao_city_id_name VALUES('1339','101190406','');
INSERT INTO yowao_city_id_name VALUES('1340','101190407','⽭');
INSERT INTO yowao_city_id_name VALUES('1341','101190408','̫');
INSERT INTO yowao_city_id_name VALUES('1342','101190501','ͨ');
INSERT INTO yowao_city_id_name VALUES('1343','101190502','');
INSERT INTO yowao_city_id_name VALUES('1344','101190503','');
INSERT INTO yowao_city_id_name VALUES('1345','101190504','綫');
INSERT INTO yowao_city_id_name VALUES('1346','101190505','');
INSERT INTO yowao_city_id_name VALUES('1347','101190506','泡');
INSERT INTO yowao_city_id_name VALUES('1348','101190507','');
INSERT INTO yowao_city_id_name VALUES('1349','101190508','');
INSERT INTO yowao_city_id_name VALUES('1350','101190601','');
INSERT INTO yowao_city_id_name VALUES('1351','101190602','Ӧ');
INSERT INTO yowao_city_id_name VALUES('1352','101190603','');
INSERT INTO yowao_city_id_name VALUES('1353','101190604','');
INSERT INTO yowao_city_id_name VALUES('1354','101190605','');
INSERT INTO yowao_city_id_name VALUES('1355','101190606','');
INSERT INTO yowao_city_id_name VALUES('1356','101190701','γ');
INSERT INTO yowao_city_id_name VALUES('1357','101190702','ˮ');
INSERT INTO yowao_city_id_name VALUES('1358','101190703','');
INSERT INTO yowao_city_id_name VALUES('1359','101190704','');
INSERT INTO yowao_city_id_name VALUES('1360','101190705','');
INSERT INTO yowao_city_id_name VALUES('1361','101190706','');
INSERT INTO yowao_city_id_name VALUES('1362','101190707','̨');
INSERT INTO yowao_city_id_name VALUES('1363','101190708','');
INSERT INTO yowao_city_id_name VALUES('1364','101190709','ζ');
INSERT INTO yowao_city_id_name VALUES('1365','101190801','');
INSERT INTO yowao_city_id_name VALUES('1366','101190802','ũվ');
INSERT INTO yowao_city_id_name VALUES('1367','101190803','');
INSERT INTO yowao_city_id_name VALUES('1368','101190804','');
INSERT INTO yowao_city_id_name VALUES('1369','101190805','');
INSERT INTO yowao_city_id_name VALUES('1370','101190806','');
INSERT INTO yowao_city_id_name VALUES('1371','101190807','');
INSERT INTO yowao_city_id_name VALUES('1372','101190901','');
INSERT INTO yowao_city_id_name VALUES('1373','101190902','');
INSERT INTO yowao_city_id_name VALUES('1374','101190903','');
INSERT INTO yowao_city_id_name VALUES('1375','101190904','');
INSERT INTO yowao_city_id_name VALUES('1376','101190905','ˮ');
INSERT INTO yowao_city_id_name VALUES('1377','101190906','');
INSERT INTO yowao_city_id_name VALUES('1378','101190907','');
INSERT INTO yowao_city_id_name VALUES('1379','101191001','Ƹ');
INSERT INTO yowao_city_id_name VALUES('1380','101191002','');
INSERT INTO yowao_city_id_name VALUES('1381','101191003','');
INSERT INTO yowao_city_id_name VALUES('1382','101191004','');
INSERT INTO yowao_city_id_name VALUES('1383','101191005','');
INSERT INTO yowao_city_id_name VALUES('1384','101191006','');
INSERT INTO yowao_city_id_name VALUES('1385','101191007','β');
INSERT INTO yowao_city_id_name VALUES('1386','101191101','');
INSERT INTO yowao_city_id_name VALUES('1387','101191102','');
INSERT INTO yowao_city_id_name VALUES('1388','101191103','̳');
INSERT INTO yowao_city_id_name VALUES('1389','101191201','̩');
INSERT INTO yowao_city_id_name VALUES('1390','101191202','˻');
INSERT INTO yowao_city_id_name VALUES('1391','101191203','̩');
INSERT INTO yowao_city_id_name VALUES('1392','101191204','');
INSERT INTO yowao_city_id_name VALUES('1393','101191205','');
INSERT INTO yowao_city_id_name VALUES('1394','101191301','Ǩ');
INSERT INTO yowao_city_id_name VALUES('1395','101191302','');
INSERT INTO yowao_city_id_name VALUES('1396','101191303','');
INSERT INTO yowao_city_id_name VALUES('1397','101191304','');
INSERT INTO yowao_city_id_name VALUES('1398','101200101','人');
INSERT INTO yowao_city_id_name VALUES('1399','101200102','̵');
INSERT INTO yowao_city_id_name VALUES('1400','101200103','');
INSERT INTO yowao_city_id_name VALUES('1401','101200104','');
INSERT INTO yowao_city_id_name VALUES('1402','101200105','');
INSERT INTO yowao_city_id_name VALUES('1403','101200201','差');
INSERT INTO yowao_city_id_name VALUES('1404','101200202','');
INSERT INTO yowao_city_id_name VALUES('1405','101200203','');
INSERT INTO yowao_city_id_name VALUES('1406','101200204','');
INSERT INTO yowao_city_id_name VALUES('1407','101200205','˳');
INSERT INTO yowao_city_id_name VALUES('1408','101200206','Ϻӿ');
INSERT INTO yowao_city_id_name VALUES('1409','101200207','ȳ');
INSERT INTO yowao_city_id_name VALUES('1410','101200208','');
INSERT INTO yowao_city_id_name VALUES('1411','101200301','');
INSERT INTO yowao_city_id_name VALUES('1412','101200401','Т');
INSERT INTO yowao_city_id_name VALUES('1413','101200402','½');
INSERT INTO yowao_city_id_name VALUES('1414','101200403','');
INSERT INTO yowao_city_id_name VALUES('1415','101200404','');
INSERT INTO yowao_city_id_name VALUES('1416','101200405','Ӧ');
INSERT INTO yowao_city_id_name VALUES('1417','101200406','');
INSERT INTO yowao_city_id_name VALUES('1418','101200501','Ƹ');
INSERT INTO yowao_city_id_name VALUES('1419','101200502','찲');
INSERT INTO yowao_city_id_name VALUES('1420','101200503','');
INSERT INTO yowao_city_id_name VALUES('1421','101200504','');
INSERT INTO yowao_city_id_name VALUES('1422','101200505','Ӣɽ');
INSERT INTO yowao_city_id_name VALUES('1423','101200506','ˮ');
INSERT INTO yowao_city_id_name VALUES('1424','101200507','ޭ');
INSERT INTO yowao_city_id_name VALUES('1425','101200508','÷');
INSERT INTO yowao_city_id_name VALUES('1426','101200509','Ѩ');
INSERT INTO yowao_city_id_name VALUES('1427','101200601','ʯ');
INSERT INTO yowao_city_id_name VALUES('1428','101200602','ұ');
INSERT INTO yowao_city_id_name VALUES('1429','101200603','');
INSERT INTO yowao_city_id_name VALUES('1430','101200701','');
INSERT INTO yowao_city_id_name VALUES('1431','101200702','');
INSERT INTO yowao_city_id_name VALUES('1432','101200703','');
INSERT INTO yowao_city_id_name VALUES('1433','101200704','');
INSERT INTO yowao_city_id_name VALUES('1434','101200705','ͨ');
INSERT INTO yowao_city_id_name VALUES('1435','101200706','ͨɽ');
INSERT INTO yowao_city_id_name VALUES('1436','101200801','');
INSERT INTO yowao_city_id_name VALUES('1437','101200802','');
INSERT INTO yowao_city_id_name VALUES('1438','101200803','');
INSERT INTO yowao_city_id_name VALUES('1439','101200804','ʯ');
INSERT INTO yowao_city_id_name VALUES('1440','101200805','');
INSERT INTO yowao_city_id_name VALUES('1441','101200806','');
INSERT INTO yowao_city_id_name VALUES('1442','101200807','');
INSERT INTO yowao_city_id_name VALUES('1443','101200901','˲');
INSERT INTO yowao_city_id_name VALUES('1444','101200902','Զ');
INSERT INTO yowao_city_id_name VALUES('1445','101200903','');
INSERT INTO yowao_city_id_name VALUES('1446','101200904','ɽ');
INSERT INTO yowao_city_id_name VALUES('1447','101200905','˲');
INSERT INTO yowao_city_id_name VALUES('1448','101200906','');
INSERT INTO yowao_city_id_name VALUES('1449','101200907','');
INSERT INTO yowao_city_id_name VALUES('1450','101200908','');
INSERT INTO yowao_city_id_name VALUES('1451','101200909','˶');
INSERT INTO yowao_city_id_name VALUES('1452','101200910','֦');
INSERT INTO yowao_city_id_name VALUES('1453','101200911','Ͽ');
INSERT INTO yowao_city_id_name VALUES('1454','101201001','ʩ');
INSERT INTO yowao_city_id_name VALUES('1455','101201002','');
INSERT INTO yowao_city_id_name VALUES('1456','101201003','ʼ');
INSERT INTO yowao_city_id_name VALUES('1457','101201004','̷');
INSERT INTO yowao_city_id_name VALUES('1458','101201005','');
INSERT INTO yowao_city_id_name VALUES('1459','101201006','׷');
INSERT INTO yowao_city_id_name VALUES('1460','101201007','');
INSERT INTO yowao_city_id_name VALUES('1461','101201008','Ͷ');
INSERT INTO yowao_city_id_name VALUES('1462','101201009','̴');
INSERT INTO yowao_city_id_name VALUES('1463','101201101','ʮ');
INSERT INTO yowao_city_id_name VALUES('1464','101201102','Ϫ');
INSERT INTO yowao_city_id_name VALUES('1465','101201103','');
INSERT INTO yowao_city_id_name VALUES('1466','101201104','');
INSERT INTO yowao_city_id_name VALUES('1467','101201105','ɽ');
INSERT INTO yowao_city_id_name VALUES('1468','101201106','');
INSERT INTO yowao_city_id_name VALUES('1469','101201107','');
INSERT INTO yowao_city_id_name VALUES('1470','101201201','ũ');
INSERT INTO yowao_city_id_name VALUES('1471','101201301','');
INSERT INTO yowao_city_id_name VALUES('1472','101201302','ˮ');
INSERT INTO yowao_city_id_name VALUES('1473','101201401','');
INSERT INTO yowao_city_id_name VALUES('1474','101201402','');
INSERT INTO yowao_city_id_name VALUES('1475','101201403','ɽ');
INSERT INTO yowao_city_id_name VALUES('1476','101201501','');
INSERT INTO yowao_city_id_name VALUES('1477','101201601','');
INSERT INTO yowao_city_id_name VALUES('1478','101201701','Ǳ');
INSERT INTO yowao_city_id_name VALUES('1479','101210101','');
INSERT INTO yowao_city_id_name VALUES('1480','101210102','ɽ');
INSERT INTO yowao_city_id_name VALUES('1481','101210103','ͩ®');
INSERT INTO yowao_city_id_name VALUES('1482','101210104','');
INSERT INTO yowao_city_id_name VALUES('1483','101210105','');
INSERT INTO yowao_city_id_name VALUES('1484','101210106','');
INSERT INTO yowao_city_id_name VALUES('1485','101210107','ٰ');
INSERT INTO yowao_city_id_name VALUES('1486','101210108','');
INSERT INTO yowao_city_id_name VALUES('1487','101210201','');
INSERT INTO yowao_city_id_name VALUES('1488','101210202','');
INSERT INTO yowao_city_id_name VALUES('1489','101210203','');
INSERT INTO yowao_city_id_name VALUES('1490','101210204','');
INSERT INTO yowao_city_id_name VALUES('1491','101210301','');
INSERT INTO yowao_city_id_name VALUES('1492','101210302','');
INSERT INTO yowao_city_id_name VALUES('1493','101210303','');
INSERT INTO yowao_city_id_name VALUES('1494','101210304','ͩ');
INSERT INTO yowao_city_id_name VALUES('1495','101210305','ƽ');
INSERT INTO yowao_city_id_name VALUES('1496','101210306','');
INSERT INTO yowao_city_id_name VALUES('1497','101210401','');
INSERT INTO yowao_city_id_name VALUES('1498','101210403','Ϫ');
INSERT INTO yowao_city_id_name VALUES('1499','101210404','Ҧ');
INSERT INTO yowao_city_id_name VALUES('1500','101210405','');
INSERT INTO yowao_city_id_name VALUES('1501','101210406','ɽ');
INSERT INTO yowao_city_id_name VALUES('1502','101210407','ʯ');
INSERT INTO yowao_city_id_name VALUES('1503','101210408','');
INSERT INTO yowao_city_id_name VALUES('1504','101210409','۴');
INSERT INTO yowao_city_id_name VALUES('1505','101210501','');
INSERT INTO yowao_city_id_name VALUES('1506','101210502','');
INSERT INTO yowao_city_id_name VALUES('1507','101210503','');
INSERT INTO yowao_city_id_name VALUES('1508','101210504','²');
INSERT INTO yowao_city_id_name VALUES('1509','101210505','');
INSERT INTO yowao_city_id_name VALUES('1510','101210601','̨');
INSERT INTO yowao_city_id_name VALUES('1511','101210602','ɽ');
INSERT INTO yowao_city_id_name VALUES('1512','101210603','');
INSERT INTO yowao_city_id_name VALUES('1513','101210604','');
INSERT INTO yowao_city_id_name VALUES('1514','101210605','̨');
INSERT INTO yowao_city_id_name VALUES('1515','101210606','ɾ');
INSERT INTO yowao_city_id_name VALUES('1516','101210607','');
INSERT INTO yowao_city_id_name VALUES('1517','101210608','');
INSERT INTO yowao_city_id_name VALUES('1518','101210609','');
INSERT INTO yowao_city_id_name VALUES('1519','101210701','');
INSERT INTO yowao_city_id_name VALUES('1520','101210702','̩˳');
INSERT INTO yowao_city_id_name VALUES('1521','101210703','ĳ');
INSERT INTO yowao_city_id_name VALUES('1522','101210704','ƽ');
INSERT INTO yowao_city_id_name VALUES('1523','101210705','');
INSERT INTO yowao_city_id_name VALUES('1524','101210706','ͷ');
INSERT INTO yowao_city_id_name VALUES('1525','101210707','');
INSERT INTO yowao_city_id_name VALUES('1526','101210708','');
INSERT INTO yowao_city_id_name VALUES('1527','101210709','');
INSERT INTO yowao_city_id_name VALUES('1528','101210801','ˮ');
INSERT INTO yowao_city_id_name VALUES('1529','101210802','');
INSERT INTO yowao_city_id_name VALUES('1530','101210803','Ȫ');
INSERT INTO yowao_city_id_name VALUES('1531','101210804','');
INSERT INTO yowao_city_id_name VALUES('1532','101210805','');
INSERT INTO yowao_city_id_name VALUES('1533','101210806','ƺ');
INSERT INTO yowao_city_id_name VALUES('1534','101210807','Ԫ');
INSERT INTO yowao_city_id_name VALUES('1535','101210901','');
INSERT INTO yowao_city_id_name VALUES('1536','101210902','ֽ');
INSERT INTO yowao_city_id_name VALUES('1537','101210903','Ϫ');
INSERT INTO yowao_city_id_name VALUES('1538','101210904','');
INSERT INTO yowao_city_id_name VALUES('1539','101210905','');
INSERT INTO yowao_city_id_name VALUES('1540','101210906','');
INSERT INTO yowao_city_id_name VALUES('1541','101210907','');
INSERT INTO yowao_city_id_name VALUES('1542','101211001','');
INSERT INTO yowao_city_id_name VALUES('1543','101211002','ɽ');
INSERT INTO yowao_city_id_name VALUES('1544','101211003','');
INSERT INTO yowao_city_id_name VALUES('1545','101211004','');
INSERT INTO yowao_city_id_name VALUES('1546','101211005','ɽ');
INSERT INTO yowao_city_id_name VALUES('1547','101211101','ɽ');
INSERT INTO yowao_city_id_name VALUES('1548','101211102','');
INSERT INTO yowao_city_id_name VALUES('1549','101211103','ɽ');
INSERT INTO yowao_city_id_name VALUES('1550','101211104','ɽ');
INSERT INTO yowao_city_id_name VALUES('1551','101211105','');
INSERT INTO yowao_city_id_name VALUES('1552','101220101','Ϸ');
INSERT INTO yowao_city_id_name VALUES('1553','101220102','');
INSERT INTO yowao_city_id_name VALUES('1554','101220103','ʶ');
INSERT INTO yowao_city_id_name VALUES('1555','101220104','');
INSERT INTO yowao_city_id_name VALUES('1556','101220201','');
INSERT INTO yowao_city_id_name VALUES('1557','101220202','Զ');
INSERT INTO yowao_city_id_name VALUES('1558','101220203','');
INSERT INTO yowao_city_id_name VALUES('1559','101220204','');
INSERT INTO yowao_city_id_name VALUES('1560','101220301','ߺ');
INSERT INTO yowao_city_id_name VALUES('1561','101220302','');
INSERT INTO yowao_city_id_name VALUES('1562','101220303','ߺ');
INSERT INTO yowao_city_id_name VALUES('1563','101220304','');
INSERT INTO yowao_city_id_name VALUES('1564','101220401','');
INSERT INTO yowao_city_id_name VALUES('1565','101220402','̨');
INSERT INTO yowao_city_id_name VALUES('1566','101220501','ɽ');
INSERT INTO yowao_city_id_name VALUES('1567','101220502','Ϳ');
INSERT INTO yowao_city_id_name VALUES('1568','101220601','');
INSERT INTO yowao_city_id_name VALUES('1569','101220602','');
INSERT INTO yowao_city_id_name VALUES('1570','101220603','̫');
INSERT INTO yowao_city_id_name VALUES('1571','101220604','Ǳɽ');
INSERT INTO yowao_city_id_name VALUES('1572','101220605','');
INSERT INTO yowao_city_id_name VALUES('1573','101220606','');
INSERT INTO yowao_city_id_name VALUES('1574','101220607','');
INSERT INTO yowao_city_id_name VALUES('1575','101220608','');
INSERT INTO yowao_city_id_name VALUES('1576','101220609','ͩ');
INSERT INTO yowao_city_id_name VALUES('1577','101220701','');
INSERT INTO yowao_city_id_name VALUES('1578','101220702','ɽ');
INSERT INTO yowao_city_id_name VALUES('1579','101220703','');
INSERT INTO yowao_city_id_name VALUES('1580','101220704','');
INSERT INTO yowao_city_id_name VALUES('1581','101220705','');
INSERT INTO yowao_city_id_name VALUES('1582','101220801','');
INSERT INTO yowao_city_id_name VALUES('1583','101220802','');
INSERT INTO yowao_city_id_name VALUES('1584','101220803','ӱ');
INSERT INTO yowao_city_id_name VALUES('1585','101220804','Ȫ');
INSERT INTO yowao_city_id_name VALUES('1586','101220805','');
INSERT INTO yowao_city_id_name VALUES('1587','101220806','̫');
INSERT INTO yowao_city_id_name VALUES('1588','101220901','');
INSERT INTO yowao_city_id_name VALUES('1589','101220902','');
INSERT INTO yowao_city_id_name VALUES('1590','101220903','');
INSERT INTO yowao_city_id_name VALUES('1591','101220904','ɳ');
INSERT INTO yowao_city_id_name VALUES('1592','101221001','ɽվ');
INSERT INTO yowao_city_id_name VALUES('1593','101221002','ɽ');
INSERT INTO yowao_city_id_name VALUES('1594','101221003','Ϫ');
INSERT INTO yowao_city_id_name VALUES('1595','101221004','');
INSERT INTO yowao_city_id_name VALUES('1596','101221005','');
INSERT INTO yowao_city_id_name VALUES('1597','101221006','');
INSERT INTO yowao_city_id_name VALUES('1598','101221007','');
INSERT INTO yowao_city_id_name VALUES('1599','101221101','');
INSERT INTO yowao_city_id_name VALUES('1600','101221102','');
INSERT INTO yowao_city_id_name VALUES('1601','101221103','');
INSERT INTO yowao_city_id_name VALUES('1602','101221104','Զ');
INSERT INTO yowao_city_id_name VALUES('1603','101221105','ȫ');
INSERT INTO yowao_city_id_name VALUES('1604','101221106','');
INSERT INTO yowao_city_id_name VALUES('1605','101221107','쳤');
INSERT INTO yowao_city_id_name VALUES('1606','101221201','');
INSERT INTO yowao_city_id_name VALUES('1607','101221202','Ϫ');
INSERT INTO yowao_city_id_name VALUES('1608','101221301','ͭ');
INSERT INTO yowao_city_id_name VALUES('1609','101221401','');
INSERT INTO yowao_city_id_name VALUES('1610','101221402','');
INSERT INTO yowao_city_id_name VALUES('1611','101221403','캵');
INSERT INTO yowao_city_id_name VALUES('1612','101221404','');
INSERT INTO yowao_city_id_name VALUES('1613','101221405','Ϫ');
INSERT INTO yowao_city_id_name VALUES('1614','101221406','');
INSERT INTO yowao_city_id_name VALUES('1615','101221407','Ϫ');
INSERT INTO yowao_city_id_name VALUES('1616','101221501','');
INSERT INTO yowao_city_id_name VALUES('1617','101221502','');
INSERT INTO yowao_city_id_name VALUES('1618','101221503','');
INSERT INTO yowao_city_id_name VALUES('1619','101221504','Ϫ');
INSERT INTO yowao_city_id_name VALUES('1620','101221505','կ');
INSERT INTO yowao_city_id_name VALUES('1621','101221506','ɽ');
INSERT INTO yowao_city_id_name VALUES('1622','101221507','');
INSERT INTO yowao_city_id_name VALUES('1623','101221601','');
INSERT INTO yowao_city_id_name VALUES('1624','101221602','®');
INSERT INTO yowao_city_id_name VALUES('1625','101221603','Ϊ');
INSERT INTO yowao_city_id_name VALUES('1626','101221604','ɽ');
INSERT INTO yowao_city_id_name VALUES('1627','101221605','');
INSERT INTO yowao_city_id_name VALUES('1628','101221701','');
INSERT INTO yowao_city_id_name VALUES('1629','101221702','');
INSERT INTO yowao_city_id_name VALUES('1630','101221703','');
INSERT INTO yowao_city_id_name VALUES('1631','101221704','Żɽ');
INSERT INTO yowao_city_id_name VALUES('1632','101221705','ʯ̨');
INSERT INTO yowao_city_id_name VALUES('1633','101230101','');
INSERT INTO yowao_city_id_name VALUES('1634','101230102','');
INSERT INTO yowao_city_id_name VALUES('1635','101230103','');
INSERT INTO yowao_city_id_name VALUES('1636','101230104','Դ');
INSERT INTO yowao_city_id_name VALUES('1637','101230105','');
INSERT INTO yowao_city_id_name VALUES('1638','101230106','');
INSERT INTO yowao_city_id_name VALUES('1639','101230107','̩');
INSERT INTO yowao_city_id_name VALUES('1640','101230108','ƽ̶');
INSERT INTO yowao_city_id_name VALUES('1641','101230109','ݽ');
INSERT INTO yowao_city_id_name VALUES('1642','101230110','');
INSERT INTO yowao_city_id_name VALUES('1643','101230111','');
INSERT INTO yowao_city_id_name VALUES('1644','101230112','ƽ̶Ͽ');
INSERT INTO yowao_city_id_name VALUES('1645','101230201','');
INSERT INTO yowao_city_id_name VALUES('1646','101230202','ͬ');
INSERT INTO yowao_city_id_name VALUES('1647','101230301','');
INSERT INTO yowao_city_id_name VALUES('1648','101230302','');
INSERT INTO yowao_city_id_name VALUES('1649','101230303','ϼ');
INSERT INTO yowao_city_id_name VALUES('1650','101230304','');
INSERT INTO yowao_city_id_name VALUES('1651','101230305','');
INSERT INTO yowao_city_id_name VALUES('1652','101230306','');
INSERT INTO yowao_city_id_name VALUES('1653','101230307','');
INSERT INTO yowao_city_id_name VALUES('1654','101230308','');
INSERT INTO yowao_city_id_name VALUES('1655','101230309','');
INSERT INTO yowao_city_id_name VALUES('1656','101230401','');
INSERT INTO yowao_city_id_name VALUES('1657','101230402','');
INSERT INTO yowao_city_id_name VALUES('1658','101230403','');
INSERT INTO yowao_city_id_name VALUES('1659','101230501','Ȫ');
INSERT INTO yowao_city_id_name VALUES('1660','101230502','Ϫ');
INSERT INTO yowao_city_id_name VALUES('1661','101230503','ɽ');
INSERT INTO yowao_city_id_name VALUES('1662','101230504','');
INSERT INTO yowao_city_id_name VALUES('1663','101230505','»');
INSERT INTO yowao_city_id_name VALUES('1664','101230506','ϰ');
INSERT INTO yowao_city_id_name VALUES('1665','101230507','');
INSERT INTO yowao_city_id_name VALUES('1666','101230508','ɽ');
INSERT INTO yowao_city_id_name VALUES('1667','101230601','');
INSERT INTO yowao_city_id_name VALUES('1668','101230602','̩');
INSERT INTO yowao_city_id_name VALUES('1669','101230603','Ͼ');
INSERT INTO yowao_city_id_name VALUES('1670','101230604','ƽ');
INSERT INTO yowao_city_id_name VALUES('1671','101230605','');
INSERT INTO yowao_city_id_name VALUES('1672','101230606','');
INSERT INTO yowao_city_id_name VALUES('1673','101230607','گ');
INSERT INTO yowao_city_id_name VALUES('1674','101230608','ɽ');
INSERT INTO yowao_city_id_name VALUES('1675','101230609','');
INSERT INTO yowao_city_id_name VALUES('1676','101230610','');
INSERT INTO yowao_city_id_name VALUES('1677','101230701','');
INSERT INTO yowao_city_id_name VALUES('1678','101230702','͡');
INSERT INTO yowao_city_id_name VALUES('1679','101230703','');
INSERT INTO yowao_city_id_name VALUES('1680','101230704','ƽ');
INSERT INTO yowao_city_id_name VALUES('1681','101230705','Ϻ');
INSERT INTO yowao_city_id_name VALUES('1682','101230706','');
INSERT INTO yowao_city_id_name VALUES('1683','101230707','ƽ');
INSERT INTO yowao_city_id_name VALUES('1684','101230801','');
INSERT INTO yowao_city_id_name VALUES('1685','101230802','');
INSERT INTO yowao_city_id_name VALUES('1686','101230803','');
INSERT INTO yowao_city_id_name VALUES('1687','101230804','̩');
INSERT INTO yowao_city_id_name VALUES('1688','101230805','');
INSERT INTO yowao_city_id_name VALUES('1689','101230806','');
INSERT INTO yowao_city_id_name VALUES('1690','101230807','Ϫ');
INSERT INTO yowao_city_id_name VALUES('1691','101230808','ɳ');
INSERT INTO yowao_city_id_name VALUES('1692','101230809','Ϫ');
INSERT INTO yowao_city_id_name VALUES('1693','101230810','');
INSERT INTO yowao_city_id_name VALUES('1694','101230811','');
INSERT INTO yowao_city_id_name VALUES('1695','101230901','ƽ');
INSERT INTO yowao_city_id_name VALUES('1696','101230902','˳');
INSERT INTO yowao_city_id_name VALUES('1697','101230903','');
INSERT INTO yowao_city_id_name VALUES('1698','101230904','');
INSERT INTO yowao_city_id_name VALUES('1699','101230905','ɽ');
INSERT INTO yowao_city_id_name VALUES('1700','101230906','ֳ');
INSERT INTO yowao_city_id_name VALUES('1701','101230907','');
INSERT INTO yowao_city_id_name VALUES('1702','101230908','Ϫ');
INSERT INTO yowao_city_id_name VALUES('1703','101230909','');
INSERT INTO yowao_city_id_name VALUES('1704','101230910','');
INSERT INTO yowao_city_id_name VALUES('1705','101240101','ϲ');
INSERT INTO yowao_city_id_name VALUES('1706','101240102','½');
INSERT INTO yowao_city_id_name VALUES('1707','101240103','ϲ');
INSERT INTO yowao_city_id_name VALUES('1708','101240104','');
INSERT INTO yowao_city_id_name VALUES('1709','101240105','');
INSERT INTO yowao_city_id_name VALUES('1710','101240201','Ž');
INSERT INTO yowao_city_id_name VALUES('1711','101240202','');
INSERT INTO yowao_city_id_name VALUES('1712','101240203','®ɽ');
INSERT INTO yowao_city_id_name VALUES('1713','101240204','');
INSERT INTO yowao_city_id_name VALUES('1714','101240205','°');
INSERT INTO yowao_city_id_name VALUES('1715','101240206','');
INSERT INTO yowao_city_id_name VALUES('1716','101240207','');
INSERT INTO yowao_city_id_name VALUES('1717','101240208','');
INSERT INTO yowao_city_id_name VALUES('1718','101240209','');
INSERT INTO yowao_city_id_name VALUES('1719','101240210','');
INSERT INTO yowao_city_id_name VALUES('1720','101240211','');
INSERT INTO yowao_city_id_name VALUES('1721','101240212','ˮ');
INSERT INTO yowao_city_id_name VALUES('1722','101240301','');
INSERT INTO yowao_city_id_name VALUES('1723','101240302','');
INSERT INTO yowao_city_id_name VALUES('1724','101240303','Դ');
INSERT INTO yowao_city_id_name VALUES('1725','101240304','ɽ');
INSERT INTO yowao_city_id_name VALUES('1726','101240305','');
INSERT INTO yowao_city_id_name VALUES('1727','101240306','');
INSERT INTO yowao_city_id_name VALUES('1728','101240307','');
INSERT INTO yowao_city_id_name VALUES('1729','101240308','');
INSERT INTO yowao_city_id_name VALUES('1730','101240309','߮');
INSERT INTO yowao_city_id_name VALUES('1731','101240310','');
INSERT INTO yowao_city_id_name VALUES('1732','101240311','Ǧɽ');
INSERT INTO yowao_city_id_name VALUES('1733','101240312','ɽ');
INSERT INTO yowao_city_id_name VALUES('1734','101240313','');
INSERT INTO yowao_city_id_name VALUES('1735','101240401','');
INSERT INTO yowao_city_id_name VALUES('1736','101240402','');
INSERT INTO yowao_city_id_name VALUES('1737','101240403','ְ');
INSERT INTO yowao_city_id_name VALUES('1738','101240404','');
INSERT INTO yowao_city_id_name VALUES('1739','101240405','Ϫ');
INSERT INTO yowao_city_id_name VALUES('1740','101240406','Ϫ');
INSERT INTO yowao_city_id_name VALUES('1741','101240407','˻');
INSERT INTO yowao_city_id_name VALUES('1742','101240408','ϳ');
INSERT INTO yowao_city_id_name VALUES('1743','101240409','Ϸ');
INSERT INTO yowao_city_id_name VALUES('1744','101240410','质');
INSERT INTO yowao_city_id_name VALUES('1745','101240411','');
INSERT INTO yowao_city_id_name VALUES('1746','101240501','˴');
INSERT INTO yowao_city_id_name VALUES('1747','101240502','ͭ');
INSERT INTO yowao_city_id_name VALUES('1748','101240503','˷');
INSERT INTO yowao_city_id_name VALUES('1749','101240504','');
INSERT INTO yowao_city_id_name VALUES('1750','101240505','ϸ');
INSERT INTO yowao_city_id_name VALUES('1751','101240506','');
INSERT INTO yowao_city_id_name VALUES('1752','101240507','');
INSERT INTO yowao_city_id_name VALUES('1753','101240508','߰');
INSERT INTO yowao_city_id_name VALUES('1754','101240509','');
INSERT INTO yowao_city_id_name VALUES('1755','101240510','');
INSERT INTO yowao_city_id_name VALUES('1756','101240601','');
INSERT INTO yowao_city_id_name VALUES('1757','101240602','');
INSERT INTO yowao_city_id_name VALUES('1758','101240603','ˮ');
INSERT INTO yowao_city_id_name VALUES('1759','101240604','¸');
INSERT INTO yowao_city_id_name VALUES('1760','101240605','Ͽ');
INSERT INTO yowao_city_id_name VALUES('1761','101240606','');
INSERT INTO yowao_city_id_name VALUES('1762','101240607','');
INSERT INTO yowao_city_id_name VALUES('1763','101240608','ɽ');
INSERT INTO yowao_city_id_name VALUES('1764','101240609','');
INSERT INTO yowao_city_id_name VALUES('1765','101240610','촨');
INSERT INTO yowao_city_id_name VALUES('1766','101240611','̩');
INSERT INTO yowao_city_id_name VALUES('1767','101240612','');
INSERT INTO yowao_city_id_name VALUES('1768','101240613','');
INSERT INTO yowao_city_id_name VALUES('1769','101240701','');
INSERT INTO yowao_city_id_name VALUES('1770','101240702','');
INSERT INTO yowao_city_id_name VALUES('1771','101240703','');
INSERT INTO yowao_city_id_name VALUES('1772','101240704','Ͽ');
INSERT INTO yowao_city_id_name VALUES('1773','101240705','');
INSERT INTO yowao_city_id_name VALUES('1774','101240706','ŷ');
INSERT INTO yowao_city_id_name VALUES('1775','101240707','');
INSERT INTO yowao_city_id_name VALUES('1776','101240708','ʯ');
INSERT INTO yowao_city_id_name VALUES('1777','101240709','');
INSERT INTO yowao_city_id_name VALUES('1778','101240710','ڶ');
INSERT INTO yowao_city_id_name VALUES('1779','101240711','');
INSERT INTO yowao_city_id_name VALUES('1780','101240712','Զ');
INSERT INTO yowao_city_id_name VALUES('1781','101240713','ȫ');
INSERT INTO yowao_city_id_name VALUES('1782','101240714','');
INSERT INTO yowao_city_id_name VALUES('1783','101240715','');
INSERT INTO yowao_city_id_name VALUES('1784','101240716','Ѱ');
INSERT INTO yowao_city_id_name VALUES('1785','101240801','');
INSERT INTO yowao_city_id_name VALUES('1786','101240802','ƽ');
INSERT INTO yowao_city_id_name VALUES('1787','101240901','Ƽ');
INSERT INTO yowao_city_id_name VALUES('1788','101240902','');
INSERT INTO yowao_city_id_name VALUES('1789','101241001','');
INSERT INTO yowao_city_id_name VALUES('1790','101241002','');
INSERT INTO yowao_city_id_name VALUES('1791','101241101','ӥ̶');
INSERT INTO yowao_city_id_name VALUES('1792','101241102','཭');
INSERT INTO yowao_city_id_name VALUES('1793','101241103','Ϫ');
INSERT INTO yowao_city_id_name VALUES('1794','101250101','ɳ');
INSERT INTO yowao_city_id_name VALUES('1795','101250102','');
INSERT INTO yowao_city_id_name VALUES('1796','101250103','');
INSERT INTO yowao_city_id_name VALUES('1797','101250104','');
INSERT INTO yowao_city_id_name VALUES('1798','101250201','̶');
INSERT INTO yowao_city_id_name VALUES('1799','101250202','ɽ');
INSERT INTO yowao_city_id_name VALUES('1800','101250203','');
INSERT INTO yowao_city_id_name VALUES('1801','101250301','');
INSERT INTO yowao_city_id_name VALUES('1802','101250302','');
INSERT INTO yowao_city_id_name VALUES('1803','101250303','');
INSERT INTO yowao_city_id_name VALUES('1804','101250304','');
INSERT INTO yowao_city_id_name VALUES('1805','101250305','');
INSERT INTO yowao_city_id_name VALUES('1806','101250306','');
INSERT INTO yowao_city_id_name VALUES('1807','101250401','');
INSERT INTO yowao_city_id_name VALUES('1808','101250402','ɽ');
INSERT INTO yowao_city_id_name VALUES('1809','101250403','ⶫ');
INSERT INTO yowao_city_id_name VALUES('1810','101250404','');
INSERT INTO yowao_city_id_name VALUES('1811','101250405','');
INSERT INTO yowao_city_id_name VALUES('1812','101250406','');
INSERT INTO yowao_city_id_name VALUES('1813','101250407','');
INSERT INTO yowao_city_id_name VALUES('1814','101250408','');
INSERT INTO yowao_city_id_name VALUES('1815','101250409','');
INSERT INTO yowao_city_id_name VALUES('1816','101250501','');
INSERT INTO yowao_city_id_name VALUES('1817','101250502','');
INSERT INTO yowao_city_id_name VALUES('1818','101250503','κ');
INSERT INTO yowao_city_id_name VALUES('1819','101250504','');
INSERT INTO yowao_city_id_name VALUES('1820','101250505','');
INSERT INTO yowao_city_id_name VALUES('1821','101250506','ſ');
INSERT INTO yowao_city_id_name VALUES('1822','101250507','');
INSERT INTO yowao_city_id_name VALUES('1823','101250508','');
INSERT INTO yowao_city_id_name VALUES('1824','101250509','');
INSERT INTO yowao_city_id_name VALUES('1825','101250510','');
INSERT INTO yowao_city_id_name VALUES('1826','101250511','');
INSERT INTO yowao_city_id_name VALUES('1827','101250601','');
INSERT INTO yowao_city_id_name VALUES('1828','101250602','');
INSERT INTO yowao_city_id_name VALUES('1829','101250603','Դ');
INSERT INTO yowao_city_id_name VALUES('1830','101250604','');
INSERT INTO yowao_city_id_name VALUES('1831','101250605','');
INSERT INTO yowao_city_id_name VALUES('1832','101250606','');
INSERT INTO yowao_city_id_name VALUES('1833','101250607','ʯ');
INSERT INTO yowao_city_id_name VALUES('1834','101250701','ɽ');
INSERT INTO yowao_city_id_name VALUES('1835','101250702','');
INSERT INTO yowao_city_id_name VALUES('1836','101250703','ҽ');
INSERT INTO yowao_city_id_name VALUES('1837','101250704','');
INSERT INTO yowao_city_id_name VALUES('1838','101250705','佭');
INSERT INTO yowao_city_id_name VALUES('1839','101250801','¦');
INSERT INTO yowao_city_id_name VALUES('1840','101250802','˫');
INSERT INTO yowao_city_id_name VALUES('1841','101250803','ˮ');
INSERT INTO yowao_city_id_name VALUES('1842','101250804','ˮ̲');
INSERT INTO yowao_city_id_name VALUES('1843','101250805','»');
INSERT INTO yowao_city_id_name VALUES('1844','101250806','Դ');
INSERT INTO yowao_city_id_name VALUES('1845','101250901','');
INSERT INTO yowao_city_id_name VALUES('1846','101250902','¡');
INSERT INTO yowao_city_id_name VALUES('1847','101250903','');
INSERT INTO yowao_city_id_name VALUES('1848','101250904','');
INSERT INTO yowao_city_id_name VALUES('1849','101250905','۶');
INSERT INTO yowao_city_id_name VALUES('1850','101250906','');
INSERT INTO yowao_city_id_name VALUES('1851','101250907','');
INSERT INTO yowao_city_id_name VALUES('1852','101250908','');
INSERT INTO yowao_city_id_name VALUES('1853','101250909','ǲ');
INSERT INTO yowao_city_id_name VALUES('1854','101250910','');
INSERT INTO yowao_city_id_name VALUES('1855','101251001','');
INSERT INTO yowao_city_id_name VALUES('1856','101251002','');
INSERT INTO yowao_city_id_name VALUES('1857','101251003','');
INSERT INTO yowao_city_id_name VALUES('1858','101251004','');
INSERT INTO yowao_city_id_name VALUES('1859','101251005','ƽ');
INSERT INTO yowao_city_id_name VALUES('1860','101251006','');
INSERT INTO yowao_city_id_name VALUES('1861','101251101','żҽ');
INSERT INTO yowao_city_id_name VALUES('1862','101251102','ɣֲ');
INSERT INTO yowao_city_id_name VALUES('1863','101251103','');
INSERT INTO yowao_city_id_name VALUES('1864','101251201','');
INSERT INTO yowao_city_id_name VALUES('1865','101251202','׳');
INSERT INTO yowao_city_id_name VALUES('1866','101251203','');
INSERT INTO yowao_city_id_name VALUES('1867','101251204','Ϫ');
INSERT INTO yowao_city_id_name VALUES('1868','101251205','');
INSERT INTO yowao_city_id_name VALUES('1869','101251206','ͬ');
INSERT INTO yowao_city_id_name VALUES('1870','101251207','ͨ');
INSERT INTO yowao_city_id_name VALUES('1871','101251208','');
INSERT INTO yowao_city_id_name VALUES('1872','101251209','»');
INSERT INTO yowao_city_id_name VALUES('1873','101251210','ƽ');
INSERT INTO yowao_city_id_name VALUES('1874','101251211','');
INSERT INTO yowao_city_id_name VALUES('1875','101251301','ǭ');
INSERT INTO yowao_city_id_name VALUES('1876','101251401','');
INSERT INTO yowao_city_id_name VALUES('1877','101251402','');
INSERT INTO yowao_city_id_name VALUES('1878','101251403','');
INSERT INTO yowao_city_id_name VALUES('1879','101251404','˫');
INSERT INTO yowao_city_id_name VALUES('1880','101251405','');
INSERT INTO yowao_city_id_name VALUES('1881','101251406','Զ');
INSERT INTO yowao_city_id_name VALUES('1882','101251407','');
INSERT INTO yowao_city_id_name VALUES('1883','101251408','ɽ');
INSERT INTO yowao_city_id_name VALUES('1884','101251409','');
INSERT INTO yowao_city_id_name VALUES('1885','101251410','');
INSERT INTO yowao_city_id_name VALUES('1886','101251501','');
INSERT INTO yowao_city_id_name VALUES('1887','101251502','');
INSERT INTO yowao_city_id_name VALUES('1888','101251503','˳');
INSERT INTO yowao_city_id_name VALUES('1889','101251504','');
INSERT INTO yowao_city_id_name VALUES('1890','101251505','');
INSERT INTO yowao_city_id_name VALUES('1891','101251506','Ϫ');
INSERT INTO yowao_city_id_name VALUES('1892','101251507','ɽ');
INSERT INTO yowao_city_id_name VALUES('1893','101251508','ԫ');
INSERT INTO yowao_city_id_name VALUES('1894','101260101','');
INSERT INTO yowao_city_id_name VALUES('1895','101260102','');
INSERT INTO yowao_city_id_name VALUES('1896','101260103','Ϫ');
INSERT INTO yowao_city_id_name VALUES('1897','101260104','ڵ');
INSERT INTO yowao_city_id_name VALUES('1898','101260105','Ϣ');
INSERT INTO yowao_city_id_name VALUES('1899','101260106','');
INSERT INTO yowao_city_id_name VALUES('1900','101260107','');
INSERT INTO yowao_city_id_name VALUES('1901','101260108','');
INSERT INTO yowao_city_id_name VALUES('1902','101260201','');
INSERT INTO yowao_city_id_name VALUES('1903','101260202','');
INSERT INTO yowao_city_id_name VALUES('1904','101260203','ʻ');
INSERT INTO yowao_city_id_name VALUES('1905','101260204','');
INSERT INTO yowao_city_id_name VALUES('1906','101260205','̶');
INSERT INTO yowao_city_id_name VALUES('1907','101260206','');
INSERT INTO yowao_city_id_name VALUES('1908','101260207','ͩ');
INSERT INTO yowao_city_id_name VALUES('1909','101260208','ˮ');
INSERT INTO yowao_city_id_name VALUES('1910','101260209','ϰˮ');
INSERT INTO yowao_city_id_name VALUES('1911','101260210','');
INSERT INTO yowao_city_id_name VALUES('1912','101260211','');
INSERT INTO yowao_city_id_name VALUES('1913','101260212','');
INSERT INTO yowao_city_id_name VALUES('1914','101260213','');
INSERT INTO yowao_city_id_name VALUES('1915','101260301','˳');
INSERT INTO yowao_city_id_name VALUES('1916','101260302','ն');
INSERT INTO yowao_city_id_name VALUES('1917','101260303','');
INSERT INTO yowao_city_id_name VALUES('1918','101260304','ƽ');
INSERT INTO yowao_city_id_name VALUES('1919','101260305','');
INSERT INTO yowao_city_id_name VALUES('1920','101260306','');
INSERT INTO yowao_city_id_name VALUES('1921','101260401','');
INSERT INTO yowao_city_id_name VALUES('1922','101260402','');
INSERT INTO yowao_city_id_name VALUES('1923','101260403','Ͱ');
INSERT INTO yowao_city_id_name VALUES('1924','101260404','˳');
INSERT INTO yowao_city_id_name VALUES('1925','101260405','Ȫ');
INSERT INTO yowao_city_id_name VALUES('1926','101260406','ˮ');
INSERT INTO yowao_city_id_name VALUES('1927','101260407','');
INSERT INTO yowao_city_id_name VALUES('1928','101260408','޵');
INSERT INTO yowao_city_id_name VALUES('1929','101260409','ƽ');
INSERT INTO yowao_city_id_name VALUES('1930','101260410','ɽ');
INSERT INTO yowao_city_id_name VALUES('1931','101260411','');
INSERT INTO yowao_city_id_name VALUES('1932','101260412','');
INSERT INTO yowao_city_id_name VALUES('1933','101260501','');
INSERT INTO yowao_city_id_name VALUES('1934','101260502','᯹');
INSERT INTO yowao_city_id_name VALUES('1935','101260503','ʩ');
INSERT INTO yowao_city_id_name VALUES('1936','101260504','Զ');
INSERT INTO yowao_city_id_name VALUES('1937','101260505','ƽ');
INSERT INTO yowao_city_id_name VALUES('1938','101260506','ƽ');
INSERT INTO yowao_city_id_name VALUES('1939','101260507','齭');
INSERT INTO yowao_city_id_name VALUES('1940','101260508','կ');
INSERT INTO yowao_city_id_name VALUES('1941','101260509','');
INSERT INTO yowao_city_id_name VALUES('1942','101260510','̨');
INSERT INTO yowao_city_id_name VALUES('1943','101260511','');
INSERT INTO yowao_city_id_name VALUES('1944','101260512','ɽ');
INSERT INTO yowao_city_id_name VALUES('1945','101260513','ƽ');
INSERT INTO yowao_city_id_name VALUES('1946','101260514','');
INSERT INTO yowao_city_id_name VALUES('1947','101260515','');
INSERT INTO yowao_city_id_name VALUES('1948','101260516','Ž');
INSERT INTO yowao_city_id_name VALUES('1949','101260517','ӽ');
INSERT INTO yowao_city_id_name VALUES('1950','101260518','¯ɽ');
INSERT INTO yowao_city_id_name VALUES('1951','101260601','ͭ');
INSERT INTO yowao_city_id_name VALUES('1952','101260602','');
INSERT INTO yowao_city_id_name VALUES('1953','101260603','');
INSERT INTO yowao_city_id_name VALUES('1954','101260604','ɽ');
INSERT INTO yowao_city_id_name VALUES('1955','101260605','˼');
INSERT INTO yowao_city_id_name VALUES('1956','101260606','ͷ');
INSERT INTO yowao_city_id_name VALUES('1957','101260607','ӡ');
INSERT INTO yowao_city_id_name VALUES('1958','101260608','ʯ');
INSERT INTO yowao_city_id_name VALUES('1959','101260609','غ');
INSERT INTO yowao_city_id_name VALUES('1960','101260610','½');
INSERT INTO yowao_city_id_name VALUES('1961','101260611','');
INSERT INTO yowao_city_id_name VALUES('1962','101260701','Ͻ');
INSERT INTO yowao_city_id_name VALUES('1963','101260702','');
INSERT INTO yowao_city_id_name VALUES('1964','101260703','ɳ');
INSERT INTO yowao_city_id_name VALUES('1965','101260704','');
INSERT INTO yowao_city_id_name VALUES('1966','101260705','');
INSERT INTO yowao_city_id_name VALUES('1967','101260706','Ӻ');
INSERT INTO yowao_city_id_name VALUES('1968','101260707','֯');
INSERT INTO yowao_city_id_name VALUES('1969','101260801','ˮ');
INSERT INTO yowao_city_id_name VALUES('1970','101260802','֦');
INSERT INTO yowao_city_id_name VALUES('1971','101260804','');
INSERT INTO yowao_city_id_name VALUES('1972','101260901','ǭ');
INSERT INTO yowao_city_id_name VALUES('1973','101260902','¡');
INSERT INTO yowao_city_id_name VALUES('1974','101260903','');
INSERT INTO yowao_city_id_name VALUES('1975','101260904','');
INSERT INTO yowao_city_id_name VALUES('1976','101260905','');
INSERT INTO yowao_city_id_name VALUES('1977','101260906','');
INSERT INTO yowao_city_id_name VALUES('1978','101260907','');
INSERT INTO yowao_city_id_name VALUES('1979','101260908','');
INSERT INTO yowao_city_id_name VALUES('1980','101260909','հ');
INSERT INTO yowao_city_id_name VALUES('1981','101270101','ɶ');
INSERT INTO yowao_city_id_name VALUES('1982','101270102','Ȫ');
INSERT INTO yowao_city_id_name VALUES('1983','101270103','¶');
INSERT INTO yowao_city_id_name VALUES('1984','101270104','½');
INSERT INTO yowao_city_id_name VALUES('1985','101270105','');
INSERT INTO yowao_city_id_name VALUES('1986','101270106','˫');
INSERT INTO yowao_city_id_name VALUES('1987','101270107','ۯ');
INSERT INTO yowao_city_id_name VALUES('1988','101270108','');
INSERT INTO yowao_city_id_name VALUES('1989','101270109','ѽ');
INSERT INTO yowao_city_id_name VALUES('1990','101270110','½');
INSERT INTO yowao_city_id_name VALUES('1991','101270111','');
INSERT INTO yowao_city_id_name VALUES('1992','101270112','');
INSERT INTO yowao_city_id_name VALUES('1993','101270113','');
INSERT INTO yowao_city_id_name VALUES('1994','101270114','');
INSERT INTO yowao_city_id_name VALUES('1995','101270201','֦');
INSERT INTO yowao_city_id_name VALUES('1996','101270202','ʺ');
INSERT INTO yowao_city_id_name VALUES('1997','101270203','');
INSERT INTO yowao_city_id_name VALUES('1998','101270204','α');
INSERT INTO yowao_city_id_name VALUES('1999','101270301','Թ');
INSERT INTO yowao_city_id_name VALUES('2000','101270302','˳');
INSERT INTO yowao_city_id_name VALUES('2001','101270303','');
INSERT INTO yowao_city_id_name VALUES('2002','101270401','');
INSERT INTO yowao_city_id_name VALUES('2003','101270402','̨');
INSERT INTO yowao_city_id_name VALUES('2004','101270403','ͤ');
INSERT INTO yowao_city_id_name VALUES('2005','101270404','');
INSERT INTO yowao_city_id_name VALUES('2006','101270405','');
INSERT INTO yowao_city_id_name VALUES('2007','101270406','');
INSERT INTO yowao_city_id_name VALUES('2008','101270407','ƽ');
INSERT INTO yowao_city_id_name VALUES('2009','101270408','');
INSERT INTO yowao_city_id_name VALUES('2010','101270501','ϳ');
INSERT INTO yowao_city_id_name VALUES('2011','101270502','ϲ');
INSERT INTO yowao_city_id_name VALUES('2012','101270503','Ӫɽ');
INSERT INTO yowao_city_id_name VALUES('2013','101270504','');
INSERT INTO yowao_city_id_name VALUES('2014','101270505','¤');
INSERT INTO yowao_city_id_name VALUES('2015','101270506','');
INSERT INTO yowao_city_id_name VALUES('2016','101270507','');
INSERT INTO yowao_city_id_name VALUES('2017','101270601','');
INSERT INTO yowao_city_id_name VALUES('2018','101270602','');
INSERT INTO yowao_city_id_name VALUES('2019','101270603','');
INSERT INTO yowao_city_id_name VALUES('2020','101270604','');
INSERT INTO yowao_city_id_name VALUES('2021','101270605','');
INSERT INTO yowao_city_id_name VALUES('2022','101270606','Դ');
INSERT INTO yowao_city_id_name VALUES('2023','101270701','');
INSERT INTO yowao_city_id_name VALUES('2024','101270702','Ϫ');
INSERT INTO yowao_city_id_name VALUES('2025','101270703','');
INSERT INTO yowao_city_id_name VALUES('2026','101270801','㰲');
INSERT INTO yowao_city_id_name VALUES('2027','101270802','');
INSERT INTO yowao_city_id_name VALUES('2028','101270803','ʤ');
INSERT INTO yowao_city_id_name VALUES('2029','101270804','ˮ');
INSERT INTO yowao_city_id_name VALUES('2030','101270901','');
INSERT INTO yowao_city_id_name VALUES('2031','101270902','ͨ');
INSERT INTO yowao_city_id_name VALUES('2032','101270903','Ͻ');
INSERT INTO yowao_city_id_name VALUES('2033','101270904','ƽ');
INSERT INTO yowao_city_id_name VALUES('2034','101271001','');
INSERT INTO yowao_city_id_name VALUES('2035','101271003','');
INSERT INTO yowao_city_id_name VALUES('2036','101271004','Ͻ');
INSERT INTO yowao_city_id_name VALUES('2037','101271005','');
INSERT INTO yowao_city_id_name VALUES('2038','101271006','');
INSERT INTO yowao_city_id_name VALUES('2039','101271101','˱');
INSERT INTO yowao_city_id_name VALUES('2040','101271102','˱ũվ');
INSERT INTO yowao_city_id_name VALUES('2041','101271103','˱');
INSERT INTO yowao_city_id_name VALUES('2042','101271104','Ϫ');
INSERT INTO yowao_city_id_name VALUES('2043','101271105','');
INSERT INTO yowao_city_id_name VALUES('2044','101271106','');
INSERT INTO yowao_city_id_name VALUES('2045','101271107','');
INSERT INTO yowao_city_id_name VALUES('2046','101271108','');
INSERT INTO yowao_city_id_name VALUES('2047','101271109','');
INSERT INTO yowao_city_id_name VALUES('2048','101271110','');
INSERT INTO yowao_city_id_name VALUES('2049','101271111','ɽ');
INSERT INTO yowao_city_id_name VALUES('2050','101271201','ڽ');
INSERT INTO yowao_city_id_name VALUES('2051','101271202','');
INSERT INTO yowao_city_id_name VALUES('2052','101271203','Զ');
INSERT INTO yowao_city_id_name VALUES('2053','101271204','');
INSERT INTO yowao_city_id_name VALUES('2054','101271205','¡');
INSERT INTO yowao_city_id_name VALUES('2055','101271301','');
INSERT INTO yowao_city_id_name VALUES('2056','101271302','');
INSERT INTO yowao_city_id_name VALUES('2057','101271303','');
INSERT INTO yowao_city_id_name VALUES('2058','101271304','');
INSERT INTO yowao_city_id_name VALUES('2059','101271401','ɽ');
INSERT INTO yowao_city_id_name VALUES('2060','101271402','Ϊ');
INSERT INTO yowao_city_id_name VALUES('2061','101271403','');
INSERT INTO yowao_city_id_name VALUES('2062','101271404','н');
INSERT INTO yowao_city_id_name VALUES('2063','101271405','崨');
INSERT INTO yowao_city_id_name VALUES('2064','101271406','');
INSERT INTO yowao_city_id_name VALUES('2065','101271407','');
INSERT INTO yowao_city_id_name VALUES('2066','101271408','ü');
INSERT INTO yowao_city_id_name VALUES('2067','101271409','üɽ');
INSERT INTO yowao_city_id_name VALUES('2068','101271501','üɽ');
INSERT INTO yowao_city_id_name VALUES('2069','101271502','');
INSERT INTO yowao_city_id_name VALUES('2070','101271503','ɽ');
INSERT INTO yowao_city_id_name VALUES('2071','101271504','');
INSERT INTO yowao_city_id_name VALUES('2072','101271505','');
INSERT INTO yowao_city_id_name VALUES('2073','101271506','');
INSERT INTO yowao_city_id_name VALUES('2074','101271601','ɽ');
INSERT INTO yowao_city_id_name VALUES('2075','101271603','ľ');
INSERT INTO yowao_city_id_name VALUES('2076','101271604','Դ');
INSERT INTO yowao_city_id_name VALUES('2077','101271605','²');
INSERT INTO yowao_city_id_name VALUES('2078','101271606','');
INSERT INTO yowao_city_id_name VALUES('2079','101271607','ᶫ');
INSERT INTO yowao_city_id_name VALUES('2080','101271608','');
INSERT INTO yowao_city_id_name VALUES('2081','101271609','ո');
INSERT INTO yowao_city_id_name VALUES('2082','101271611','');
INSERT INTO yowao_city_id_name VALUES('2083','101271612','Ѿ');
INSERT INTO yowao_city_id_name VALUES('2084','101271613','ϲ');
INSERT INTO yowao_city_id_name VALUES('2085','101271614','');
INSERT INTO yowao_city_id_name VALUES('2086','101271615','Խ');
INSERT INTO yowao_city_id_name VALUES('2087','101271616','');
INSERT INTO yowao_city_id_name VALUES('2088','101271617','ײ');
INSERT INTO yowao_city_id_name VALUES('2089','101271618','');
INSERT INTO yowao_city_id_name VALUES('2090','101271701','Ű');
INSERT INTO yowao_city_id_name VALUES('2091','101271702','ɽ');
INSERT INTO yowao_city_id_name VALUES('2092','101271703','پ');
INSERT INTO yowao_city_id_name VALUES('2093','101271704','Դ');
INSERT INTO yowao_city_id_name VALUES('2094','101271705','ʯ');
INSERT INTO yowao_city_id_name VALUES('2095','101271706','ȫ');
INSERT INTO yowao_city_id_name VALUES('2096','101271707','«ɽ');
INSERT INTO yowao_city_id_name VALUES('2097','101271708','');
INSERT INTO yowao_city_id_name VALUES('2098','101271801','');
INSERT INTO yowao_city_id_name VALUES('2099','101271802','');
INSERT INTO yowao_city_id_name VALUES('2100','101271803','');
INSERT INTO yowao_city_id_name VALUES('2101','101271804','');
INSERT INTO yowao_city_id_name VALUES('2102','101271805','');
INSERT INTO yowao_city_id_name VALUES('2103','101271806','Ž');
INSERT INTO yowao_city_id_name VALUES('2104','101271807','');
INSERT INTO yowao_city_id_name VALUES('2105','101271808','¯');
INSERT INTO yowao_city_id_name VALUES('2106','101271809','');
INSERT INTO yowao_city_id_name VALUES('2107','101271810','¸');
INSERT INTO yowao_city_id_name VALUES('2108','101271811','');
INSERT INTO yowao_city_id_name VALUES('2109','101271812','ʯ');
INSERT INTO yowao_city_id_name VALUES('2110','101271813','ɫ');
INSERT INTO yowao_city_id_name VALUES('2111','101271814','');
INSERT INTO yowao_city_id_name VALUES('2112','101271815','');
INSERT INTO yowao_city_id_name VALUES('2113','101271816','');
INSERT INTO yowao_city_id_name VALUES('2114','101271817','');
INSERT INTO yowao_city_id_name VALUES('2115','101271818','');
INSERT INTO yowao_city_id_name VALUES('2116','101271901','');
INSERT INTO yowao_city_id_name VALUES('2117','101271902','봨');
INSERT INTO yowao_city_id_name VALUES('2118','101271903','');
INSERT INTO yowao_city_id_name VALUES('2119','101271904','ï');
INSERT INTO yowao_city_id_name VALUES('2120','101271905','');
INSERT INTO yowao_city_id_name VALUES('2121','101271906','կ');
INSERT INTO yowao_city_id_name VALUES('2122','101271907','');
INSERT INTO yowao_city_id_name VALUES('2123','101271908','С');
INSERT INTO yowao_city_id_name VALUES('2124','101271909','ˮ');
INSERT INTO yowao_city_id_name VALUES('2125','101271910','');
INSERT INTO yowao_city_id_name VALUES('2126','101271911','');
INSERT INTO yowao_city_id_name VALUES('2127','101271912','');
INSERT INTO yowao_city_id_name VALUES('2128','101271913','ԭ');
INSERT INTO yowao_city_id_name VALUES('2129','101272001','');
INSERT INTO yowao_city_id_name VALUES('2130','101272002','н');
INSERT INTO yowao_city_id_name VALUES('2131','101272003','㺺');
INSERT INTO yowao_city_id_name VALUES('2132','101272004','ʲ');
INSERT INTO yowao_city_id_name VALUES('2133','101272005','');
INSERT INTO yowao_city_id_name VALUES('2134','101272101','Ԫ');
INSERT INTO yowao_city_id_name VALUES('2135','101272102','');
INSERT INTO yowao_city_id_name VALUES('2136','101272103','ന');
INSERT INTO yowao_city_id_name VALUES('2137','101272104','');
INSERT INTO yowao_city_id_name VALUES('2138','101272105','Ϫ');
INSERT INTO yowao_city_id_name VALUES('2139','101280101','');
INSERT INTO yowao_city_id_name VALUES('2140','101280102','خ');
INSERT INTO yowao_city_id_name VALUES('2141','101280103','ӻ');
INSERT INTO yowao_city_id_name VALUES('2142','101280104','');
INSERT INTO yowao_city_id_name VALUES('2143','101280105','');
INSERT INTO yowao_city_id_name VALUES('2144','101280106','');
INSERT INTO yowao_city_id_name VALUES('2145','101280201','ع');
INSERT INTO yowao_city_id_name VALUES('2146','101280202','Դ');
INSERT INTO yowao_city_id_name VALUES('2147','101280203','ʼ');
INSERT INTO yowao_city_id_name VALUES('2148','101280204','Դ');
INSERT INTO yowao_city_id_name VALUES('2149','101280205','ֲ');
INSERT INTO yowao_city_id_name VALUES('2150','101280206','ʻ');
INSERT INTO yowao_city_id_name VALUES('2151','101280207','');
INSERT INTO yowao_city_id_name VALUES('2152','101280208','·');
INSERT INTO yowao_city_id_name VALUES('2153','101280301','');
INSERT INTO yowao_city_id_name VALUES('2154','101280302','');
INSERT INTO yowao_city_id_name VALUES('2155','101280304','ݶ');
INSERT INTO yowao_city_id_name VALUES('2156','101280305','');
INSERT INTO yowao_city_id_name VALUES('2157','101280401','÷');
INSERT INTO yowao_city_id_name VALUES('2158','101280402','');
INSERT INTO yowao_city_id_name VALUES('2159','101280403','');
INSERT INTO yowao_city_id_name VALUES('2160','101280404','');
INSERT INTO yowao_city_id_name VALUES('2161','101280406','˳');
INSERT INTO yowao_city_id_name VALUES('2162','101280407','ƽԶ');
INSERT INTO yowao_city_id_name VALUES('2163','101280408','廪');
INSERT INTO yowao_city_id_name VALUES('2164','101280501','ͷ');
INSERT INTO yowao_city_id_name VALUES('2165','101280502','');
INSERT INTO yowao_city_id_name VALUES('2166','101280503','κ');
INSERT INTO yowao_city_id_name VALUES('2167','101280504','ϰ');
INSERT INTO yowao_city_id_name VALUES('2168','101280505','ư');
INSERT INTO yowao_city_id_name VALUES('2169','101280506','쵺');
INSERT INTO yowao_city_id_name VALUES('2170','101280601','');
INSERT INTO yowao_city_id_name VALUES('2171','101280701','麣');
INSERT INTO yowao_city_id_name VALUES('2172','101280702','');
INSERT INTO yowao_city_id_name VALUES('2173','101280703','é');
INSERT INTO yowao_city_id_name VALUES('2174','101280800','ɽ');
INSERT INTO yowao_city_id_name VALUES('2175','101280801','˳');
INSERT INTO yowao_city_id_name VALUES('2176','101280802','ˮ');
INSERT INTO yowao_city_id_name VALUES('2177','101280803','Ϻ');
INSERT INTO yowao_city_id_name VALUES('2178','101280901','');
INSERT INTO yowao_city_id_name VALUES('2179','101280902','');
INSERT INTO yowao_city_id_name VALUES('2180','101280903','Ļ');
INSERT INTO yowao_city_id_name VALUES('2181','101280905','');
INSERT INTO yowao_city_id_name VALUES('2182','101280906','');
INSERT INTO yowao_city_id_name VALUES('2183','101280907','⿪');
INSERT INTO yowao_city_id_name VALUES('2184','101281001','տ');
INSERT INTO yowao_city_id_name VALUES('2185','101281002','⴨');
INSERT INTO yowao_city_id_name VALUES('2186','101281003','');
INSERT INTO yowao_city_id_name VALUES('2187','101281004','');
INSERT INTO yowao_city_id_name VALUES('2188','101281005','');
INSERT INTO yowao_city_id_name VALUES('2189','101281006','');
INSERT INTO yowao_city_id_name VALUES('2190','101281007','Ϫ');
INSERT INTO yowao_city_id_name VALUES('2191','101281101','');
INSERT INTO yowao_city_id_name VALUES('2192','101281103','ƽ');
INSERT INTO yowao_city_id_name VALUES('2193','101281104','»');
INSERT INTO yowao_city_id_name VALUES('2194','101281105','ƽ');
INSERT INTO yowao_city_id_name VALUES('2195','101281106','̨ɽ');
INSERT INTO yowao_city_id_name VALUES('2196','101281107','ϴ');
INSERT INTO yowao_city_id_name VALUES('2197','101281201','Դ');
INSERT INTO yowao_city_id_name VALUES('2198','101281202','Ͻ');
INSERT INTO yowao_city_id_name VALUES('2199','101281203','ƽ');
INSERT INTO yowao_city_id_name VALUES('2200','101281204','ƽ');
INSERT INTO yowao_city_id_name VALUES('2201','101281205','');
INSERT INTO yowao_city_id_name VALUES('2202','101281301','Զ');
INSERT INTO yowao_city_id_name VALUES('2203','101281302','');
INSERT INTO yowao_city_id_name VALUES('2204','101281303','');
INSERT INTO yowao_city_id_name VALUES('2205','101281304','ɽ');
INSERT INTO yowao_city_id_name VALUES('2206','101281305','ɽ');
INSERT INTO yowao_city_id_name VALUES('2207','101281306','');
INSERT INTO yowao_city_id_name VALUES('2208','101281307','Ӣ');
INSERT INTO yowao_city_id_name VALUES('2209','101281401','Ƹ');
INSERT INTO yowao_city_id_name VALUES('2210','101281402','޶');
INSERT INTO yowao_city_id_name VALUES('2211','101281403','');
INSERT INTO yowao_city_id_name VALUES('2212','101281404','');
INSERT INTO yowao_city_id_name VALUES('2213','101281501','');
INSERT INTO yowao_city_id_name VALUES('2214','101281502','ƽ');
INSERT INTO yowao_city_id_name VALUES('2215','101281601','ݸ');
INSERT INTO yowao_city_id_name VALUES('2216','101281701','ɽ');
INSERT INTO yowao_city_id_name VALUES('2217','101281801','');
INSERT INTO yowao_city_id_name VALUES('2218','101281802','');
INSERT INTO yowao_city_id_name VALUES('2219','101281901','');
INSERT INTO yowao_city_id_name VALUES('2220','101281902','');
INSERT INTO yowao_city_id_name VALUES('2221','101281903','');
INSERT INTO yowao_city_id_name VALUES('2222','101281904','');
INSERT INTO yowao_city_id_name VALUES('2223','101282001','ï');
INSERT INTO yowao_city_id_name VALUES('2224','101282002','');
INSERT INTO yowao_city_id_name VALUES('2225','101282003','');
INSERT INTO yowao_city_id_name VALUES('2226','101282004','');
INSERT INTO yowao_city_id_name VALUES('2227','101282005','');
INSERT INTO yowao_city_id_name VALUES('2228','101282101','β');
INSERT INTO yowao_city_id_name VALUES('2229','101282102','');
INSERT INTO yowao_city_id_name VALUES('2230','101282103','½');
INSERT INTO yowao_city_id_name VALUES('2231','101282104','');
INSERT INTO yowao_city_id_name VALUES('2232','101282105','ɳ');
INSERT INTO yowao_city_id_name VALUES('2233','101290101','');
INSERT INTO yowao_city_id_name VALUES('2234','101290102','ũվ');
INSERT INTO yowao_city_id_name VALUES('2235','101290103','');
INSERT INTO yowao_city_id_name VALUES('2236','101290104','Ѱ');
INSERT INTO yowao_city_id_name VALUES('2237','101290105','');
INSERT INTO yowao_city_id_name VALUES('2238','101290106','');
INSERT INTO yowao_city_id_name VALUES('2239','101290107','ʯ');
INSERT INTO yowao_city_id_name VALUES('2240','101290108','ʹ');
INSERT INTO yowao_city_id_name VALUES('2241','101290109','');
INSERT INTO yowao_city_id_name VALUES('2242','101290110','');
INSERT INTO yowao_city_id_name VALUES('2243','101290111','»Ȱ');
INSERT INTO yowao_city_id_name VALUES('2244','101290112','');
INSERT INTO yowao_city_id_name VALUES('2245','101290113','̫ɽ');
INSERT INTO yowao_city_id_name VALUES('2246','101290114','ӿ');
INSERT INTO yowao_city_id_name VALUES('2247','101290201','');
INSERT INTO yowao_city_id_name VALUES('2248','101290202','');
INSERT INTO yowao_city_id_name VALUES('2249','101290203','');
INSERT INTO yowao_city_id_name VALUES('2250','101290204','ƽ');
INSERT INTO yowao_city_id_name VALUES('2251','101290205','');
INSERT INTO yowao_city_id_name VALUES('2252','101290206','ֶ');
INSERT INTO yowao_city_id_name VALUES('2253','101290207','');
INSERT INTO yowao_city_id_name VALUES('2254','101290208','κɽ');
INSERT INTO yowao_city_id_name VALUES('2255','101290209','');
INSERT INTO yowao_city_id_name VALUES('2256','101290210','Դ');
INSERT INTO yowao_city_id_name VALUES('2257','101290211','');
INSERT INTO yowao_city_id_name VALUES('2258','101290212','Ͻ');
INSERT INTO yowao_city_id_name VALUES('2259','101290301','');
INSERT INTO yowao_city_id_name VALUES('2260','101290302','ʯ');
INSERT INTO yowao_city_id_name VALUES('2261','101290303','ˮ');
INSERT INTO yowao_city_id_name VALUES('2262','101290304','');
INSERT INTO yowao_city_id_name VALUES('2263','101290305','Ԫ');
INSERT INTO yowao_city_id_name VALUES('2264','101290306','̴');
INSERT INTO yowao_city_id_name VALUES('2265','101290307','Զ');
INSERT INTO yowao_city_id_name VALUES('2266','101290308','');
INSERT INTO yowao_city_id_name VALUES('2267','101290309','');
INSERT INTO yowao_city_id_name VALUES('2268','101290310','');
INSERT INTO yowao_city_id_name VALUES('2269','101290311','');
INSERT INTO yowao_city_id_name VALUES('2270','101290312','ƽ');
INSERT INTO yowao_city_id_name VALUES('2271','101290401','');
INSERT INTO yowao_city_id_name VALUES('2272','101290402','մ');
INSERT INTO yowao_city_id_name VALUES('2273','101290403','½');
INSERT INTO yowao_city_id_name VALUES('2274','101290404','Դ');
INSERT INTO yowao_city_id_name VALUES('2275','101290405','');
INSERT INTO yowao_city_id_name VALUES('2276','101290406','ʦ');
INSERT INTO yowao_city_id_name VALUES('2277','101290407','ƽ');
INSERT INTO yowao_city_id_name VALUES('2278','101290408','');
INSERT INTO yowao_city_id_name VALUES('2279','101290409','');
INSERT INTO yowao_city_id_name VALUES('2280','101290501','ɽ');
INSERT INTO yowao_city_id_name VALUES('2281','101290502','');
INSERT INTO yowao_city_id_name VALUES('2282','101290503','');
INSERT INTO yowao_city_id_name VALUES('2283','101290504','ʩ');
INSERT INTO yowao_city_id_name VALUES('2284','101290505','');
INSERT INTO yowao_city_id_name VALUES('2285','101290506','ڳ');
INSERT INTO yowao_city_id_name VALUES('2286','101290601','ɽ');
INSERT INTO yowao_city_id_name VALUES('2287','101290602','');
INSERT INTO yowao_city_id_name VALUES('2288','101290603','');
INSERT INTO yowao_city_id_name VALUES('2289','101290604','');
INSERT INTO yowao_city_id_name VALUES('2290','101290605','ɽ');
INSERT INTO yowao_city_id_name VALUES('2291','101290606','');
INSERT INTO yowao_city_id_name VALUES('2292','101290607','');
INSERT INTO yowao_city_id_name VALUES('2293','101290701','Ϫ');
INSERT INTO yowao_city_id_name VALUES('2294','101290702','ν');
INSERT INTO yowao_city_id_name VALUES('2295','101290703','');
INSERT INTO yowao_city_id_name VALUES('2296','101290704','ͨ');
INSERT INTO yowao_city_id_name VALUES('2297','101290705','');
INSERT INTO yowao_city_id_name VALUES('2298','101290706','ƽ');
INSERT INTO yowao_city_id_name VALUES('2299','101290707','');
INSERT INTO yowao_city_id_name VALUES('2300','101290708','ɽ');
INSERT INTO yowao_city_id_name VALUES('2301','101290709','Ԫ');
INSERT INTO yowao_city_id_name VALUES('2302','101290801','');
INSERT INTO yowao_city_id_name VALUES('2303','101290802','Ҧ');
INSERT INTO yowao_city_id_name VALUES('2304','101290803','Ԫı');
INSERT INTO yowao_city_id_name VALUES('2305','101290804','Ҧ');
INSERT INTO yowao_city_id_name VALUES('2306','101290805','Ĳ');
INSERT INTO yowao_city_id_name VALUES('2307','101290806','ϻ');
INSERT INTO yowao_city_id_name VALUES('2308','101290807','䶨');
INSERT INTO yowao_city_id_name VALUES('2309','101290808','»');
INSERT INTO yowao_city_id_name VALUES('2310','101290809','˫');
INSERT INTO yowao_city_id_name VALUES('2311','101290810','');
INSERT INTO yowao_city_id_name VALUES('2312','101290901','˼é');
INSERT INTO yowao_city_id_name VALUES('2313','101290902','');
INSERT INTO yowao_city_id_name VALUES('2314','101290903','');
INSERT INTO yowao_city_id_name VALUES('2315','101290904','');
INSERT INTO yowao_city_id_name VALUES('2316','101290905','ն');
INSERT INTO yowao_city_id_name VALUES('2317','101290906','ī');
INSERT INTO yowao_city_id_name VALUES('2318','101290907','');
INSERT INTO yowao_city_id_name VALUES('2319','101290908','');
INSERT INTO yowao_city_id_name VALUES('2320','101290909','');
INSERT INTO yowao_city_id_name VALUES('2321','101290910','Դ');
INSERT INTO yowao_city_id_name VALUES('2322','101291001','ͨ');
INSERT INTO yowao_city_id_name VALUES('2323','101291002','³');
INSERT INTO yowao_city_id_name VALUES('2324','101291003','');
INSERT INTO yowao_city_id_name VALUES('2325','101291004','');
INSERT INTO yowao_city_id_name VALUES('2326','101291005','');
INSERT INTO yowao_city_id_name VALUES('2327','101291006','ɼ');
INSERT INTO yowao_city_id_name VALUES('2328','101291007','罭');
INSERT INTO yowao_city_id_name VALUES('2329','101291008','');
INSERT INTO yowao_city_id_name VALUES('2330','101291009','ν');
INSERT INTO yowao_city_id_name VALUES('2331','101291010','');
INSERT INTO yowao_city_id_name VALUES('2332','101291101','ٲ');
INSERT INTO yowao_city_id_name VALUES('2333','101291102','Դ');
INSERT INTO yowao_city_id_name VALUES('2334','101291103','');
INSERT INTO yowao_city_id_name VALUES('2335','101291104','˫');
INSERT INTO yowao_city_id_name VALUES('2336','101291105','');
INSERT INTO yowao_city_id_name VALUES('2337','101291106','');
INSERT INTO yowao_city_id_name VALUES('2338','101291107','');
INSERT INTO yowao_city_id_name VALUES('2339','101291108','');
INSERT INTO yowao_city_id_name VALUES('2340','101291201','ŭ');
INSERT INTO yowao_city_id_name VALUES('2341','101291203','');
INSERT INTO yowao_city_id_name VALUES('2342','101291204','ƺ');
INSERT INTO yowao_city_id_name VALUES('2343','101291205','ˮ');
INSERT INTO yowao_city_id_name VALUES('2344','101291206','');
INSERT INTO yowao_city_id_name VALUES('2345','101291301','');
INSERT INTO yowao_city_id_name VALUES('2346','101291302','');
INSERT INTO yowao_city_id_name VALUES('2347','101291303','ά');
INSERT INTO yowao_city_id_name VALUES('2348','101291401','');
INSERT INTO yowao_city_id_name VALUES('2349','101291402','ʤ');
INSERT INTO yowao_city_id_name VALUES('2350','101291403','ƺ');
INSERT INTO yowao_city_id_name VALUES('2351','101291404','');
INSERT INTO yowao_city_id_name VALUES('2352','101291501','º');
INSERT INTO yowao_city_id_name VALUES('2353','101291502','º');
INSERT INTO yowao_city_id_name VALUES('2354','101291503','¤');
INSERT INTO yowao_city_id_name VALUES('2355','101291504','ӯ');
INSERT INTO yowao_city_id_name VALUES('2356','101291505','');
INSERT INTO yowao_city_id_name VALUES('2357','101291506','');
INSERT INTO yowao_city_id_name VALUES('2358','101291507','');
INSERT INTO yowao_city_id_name VALUES('2359','101291601','');
INSERT INTO yowao_city_id_name VALUES('2360','101291602','');
INSERT INTO yowao_city_id_name VALUES('2361','101291603','º');
INSERT INTO yowao_city_id_name VALUES('2362','101291604','վ');
INSERT INTO yowao_city_id_name VALUES('2363','101291605','');
INSERT INTO yowao_city_id_name VALUES('2364','101300101','');
INSERT INTO yowao_city_id_name VALUES('2365','101300103','');
INSERT INTO yowao_city_id_name VALUES('2366','101300104','');
INSERT INTO yowao_city_id_name VALUES('2367','101300105','¡');
INSERT INTO yowao_city_id_name VALUES('2368','101300106','ɽ');
INSERT INTO yowao_city_id_name VALUES('2369','101300107','');
INSERT INTO yowao_city_id_name VALUES('2370','101300108','');
INSERT INTO yowao_city_id_name VALUES('2371','101300109','');
INSERT INTO yowao_city_id_name VALUES('2372','101300110','˶');
INSERT INTO yowao_city_id_name VALUES('2373','101300201','');
INSERT INTO yowao_city_id_name VALUES('2374','101300202','');
INSERT INTO yowao_city_id_name VALUES('2375','101300203','');
INSERT INTO yowao_city_id_name VALUES('2376','101300204','ƾ');
INSERT INTO yowao_city_id_name VALUES('2377','101300205','');
INSERT INTO yowao_city_id_name VALUES('2378','101300206','');
INSERT INTO yowao_city_id_name VALUES('2379','101300207','');
INSERT INTO yowao_city_id_name VALUES('2380','101300208','Ԩ');
INSERT INTO yowao_city_id_name VALUES('2381','101300301','');
INSERT INTO yowao_city_id_name VALUES('2382','101300302','');
INSERT INTO yowao_city_id_name VALUES('2383','101300303','ɳ');
INSERT INTO yowao_city_id_name VALUES('2384','101300304','¹կ');
INSERT INTO yowao_city_id_name VALUES('2385','101300305','');
INSERT INTO yowao_city_id_name VALUES('2386','101300306','ڰ');
INSERT INTO yowao_city_id_name VALUES('2387','101300307','ˮ');
INSERT INTO yowao_city_id_name VALUES('2388','101300308','');
INSERT INTO yowao_city_id_name VALUES('2389','101300401','');
INSERT INTO yowao_city_id_name VALUES('2390','101300402','ó');
INSERT INTO yowao_city_id_name VALUES('2391','101300403','');
INSERT INTO yowao_city_id_name VALUES('2392','101300404','');
INSERT INTO yowao_city_id_name VALUES('2393','101300405','');
INSERT INTO yowao_city_id_name VALUES('2394','101300501','');
INSERT INTO yowao_city_id_name VALUES('2395','101300502','ũվ');
INSERT INTO yowao_city_id_name VALUES('2396','101300503','ʤ');
INSERT INTO yowao_city_id_name VALUES('2397','101300504','');
INSERT INTO yowao_city_id_name VALUES('2398','101300505','ٹ');
INSERT INTO yowao_city_id_name VALUES('2399','101300506','˰');
INSERT INTO yowao_city_id_name VALUES('2400','101300507','鴨');
INSERT INTO yowao_city_id_name VALUES('2401','101300508','ȫ');
INSERT INTO yowao_city_id_name VALUES('2402','101300509','');
INSERT INTO yowao_city_id_name VALUES('2403','101300510','˷');
INSERT INTO yowao_city_id_name VALUES('2404','101300511','');
INSERT INTO yowao_city_id_name VALUES('2405','101300512','ƽ');
INSERT INTO yowao_city_id_name VALUES('2406','101300513','');
INSERT INTO yowao_city_id_name VALUES('2407','101300514','Դ');
INSERT INTO yowao_city_id_name VALUES('2408','101300601','');
INSERT INTO yowao_city_id_name VALUES('2409','101300602','');
INSERT INTO yowao_city_id_name VALUES('2410','101300603','̫ƽ');
INSERT INTO yowao_city_id_name VALUES('2411','101300604','');
INSERT INTO yowao_city_id_name VALUES('2412','101300605','ɽ');
INSERT INTO yowao_city_id_name VALUES('2413','101300606','Ϫ');
INSERT INTO yowao_city_id_name VALUES('2414','101300701','');
INSERT INTO yowao_city_id_name VALUES('2415','101300702','ƽ');
INSERT INTO yowao_city_id_name VALUES('2416','101300703','');
INSERT INTO yowao_city_id_name VALUES('2417','101300704','ɽ');
INSERT INTO yowao_city_id_name VALUES('2418','101300705','Ŷ');
INSERT INTO yowao_city_id_name VALUES('2419','101300801','');
INSERT INTO yowao_city_id_name VALUES('2420','101300802','ƽ');
INSERT INTO yowao_city_id_name VALUES('2421','101300803','ƽ');
INSERT INTO yowao_city_id_name VALUES('2422','101300901','');
INSERT INTO yowao_city_id_name VALUES('2423','101300902','');
INSERT INTO yowao_city_id_name VALUES('2424','101300903','');
INSERT INTO yowao_city_id_name VALUES('2425','101300904','');
INSERT INTO yowao_city_id_name VALUES('2426','101300905','½');
INSERT INTO yowao_city_id_name VALUES('2427','101301001','ɫ');
INSERT INTO yowao_city_id_name VALUES('2428','101301002','');
INSERT INTO yowao_city_id_name VALUES('2429','101301003','');
INSERT INTO yowao_city_id_name VALUES('2430','101301004','±');
INSERT INTO yowao_city_id_name VALUES('2431','101301005','');
INSERT INTO yowao_city_id_name VALUES('2432','101301006','ﶫ');
INSERT INTO yowao_city_id_name VALUES('2433','101301007','ƽ');
INSERT INTO yowao_city_id_name VALUES('2434','101301008','¡');
INSERT INTO yowao_city_id_name VALUES('2435','101301009','');
INSERT INTO yowao_city_id_name VALUES('2436','101301010','ҵ');
INSERT INTO yowao_city_id_name VALUES('2437','101301011','');
INSERT INTO yowao_city_id_name VALUES('2438','101301012','');
INSERT INTO yowao_city_id_name VALUES('2439','101301101','');
INSERT INTO yowao_city_id_name VALUES('2440','101301102','ֱ');
INSERT INTO yowao_city_id_name VALUES('2441','101301103','ɽ');
INSERT INTO yowao_city_id_name VALUES('2442','101301201','ӳ');
INSERT INTO yowao_city_id_name VALUES('2443','101301202','');
INSERT INTO yowao_city_id_name VALUES('2444','101301203','');
INSERT INTO yowao_city_id_name VALUES('2445','101301204','');
INSERT INTO yowao_city_id_name VALUES('2446','101301205','');
INSERT INTO yowao_city_id_name VALUES('2447','101301206','޳');
INSERT INTO yowao_city_id_name VALUES('2448','101301207','');
INSERT INTO yowao_city_id_name VALUES('2449','101301208','ɽ');
INSERT INTO yowao_city_id_name VALUES('2450','101301209','ϵ');
INSERT INTO yowao_city_id_name VALUES('2451','101301210','');
INSERT INTO yowao_city_id_name VALUES('2452','101301301','');
INSERT INTO yowao_city_id_name VALUES('2453','101301302','');
INSERT INTO yowao_city_id_name VALUES('2454','101301303','޵');
INSERT INTO yowao_city_id_name VALUES('2455','101301401','Ǹ');
INSERT INTO yowao_city_id_name VALUES('2456','101301402','˼');
INSERT INTO yowao_city_id_name VALUES('2457','101301403','');
INSERT INTO yowao_city_id_name VALUES('2458','101301404','');
INSERT INTO yowao_city_id_name VALUES('2459','101301405','');
INSERT INTO yowao_city_id_name VALUES('2460','101310101','');
INSERT INTO yowao_city_id_name VALUES('2461','101310102','ɽ');
INSERT INTO yowao_city_id_name VALUES('2462','101310201','');
INSERT INTO yowao_city_id_name VALUES('2463','101310202','');
INSERT INTO yowao_city_id_name VALUES('2464','101310203','ٸ');
INSERT INTO yowao_city_id_name VALUES('2465','101310204','');
INSERT INTO yowao_city_id_name VALUES('2466','101310205','');
INSERT INTO yowao_city_id_name VALUES('2467','101310206','');
INSERT INTO yowao_city_id_name VALUES('2468','101310207','ɳ');
INSERT INTO yowao_city_id_name VALUES('2469','101310208','');
INSERT INTO yowao_city_id_name VALUES('2470','101310209','');
INSERT INTO yowao_city_id_name VALUES('2471','101310210','Ͳ');
INSERT INTO yowao_city_id_name VALUES('2472','101310211','');
INSERT INTO yowao_city_id_name VALUES('2473','101310212','Ĳ');
INSERT INTO yowao_city_id_name VALUES('2474','101310213','');
INSERT INTO yowao_city_id_name VALUES('2475','101310214','ͤ');
INSERT INTO yowao_city_id_name VALUES('2476','101310215','');
INSERT INTO yowao_city_id_name VALUES('2477','101310216','ˮ');
INSERT INTO yowao_city_id_name VALUES('2478','101310217','ɳ');
INSERT INTO yowao_city_id_name VALUES('2479','101310218','ɺ');
INSERT INTO yowao_city_id_name VALUES('2480','101310219','');
INSERT INTO yowao_city_id_name VALUES('2481','101310220','ɳ');
INSERT INTO yowao_city_id_name VALUES('2482','101310221','ֶ');
INSERT INTO yowao_city_id_name VALUES('2483','101310222','ͨʲ');
INSERT INTO yowao_city_id_name VALUES('2484','101320101','');
INSERT INTO yowao_city_id_name VALUES('2485','101320102','');
INSERT INTO yowao_city_id_name VALUES('2486','101320103','½');
INSERT INTO yowao_city_id_name VALUES('2487','101320104','л');
INSERT INTO yowao_city_id_name VALUES('2488','101320105','ͭ');
INSERT INTO yowao_city_id_name VALUES('2489','101330101','');
INSERT INTO yowao_city_id_name VALUES('2490','101340101','̨');
INSERT INTO yowao_city_id_name VALUES('2491','101340102','̨');
INSERT INTO yowao_city_id_name VALUES('2492','101340201','');
INSERT INTO yowao_city_id_name VALUES('2493','101340202','');
INSERT INTO yowao_city_id_name VALUES('2494','101340203','');
INSERT INTO yowao_city_id_name VALUES('2495','101340204','㴺');
INSERT INTO yowao_city_id_name VALUES('2496','101340205','');
INSERT INTO yowao_city_id_name VALUES('2497','101340301','̨');
INSERT INTO yowao_city_id_name VALUES('2498','101340401','̨');
INSERT INTO yowao_city_id_name VALUES('2499','101340501','԰');
INSERT INTO yowao_city_id_name VALUES('2500','101340601','');
INSERT INTO yowao_city_id_name VALUES('2501','101340602','');
INSERT INTO yowao_city_id_name VALUES('2502','101340603','');
INSERT INTO yowao_city_id_name VALUES('2503','101340701','');
INSERT INTO yowao_city_id_name VALUES('2504','101340801','');
INSERT INTO yowao_city_id_name VALUES('2505','101340802','');
INSERT INTO yowao_city_id_name VALUES('2506','101340901','');
INSERT INTO yowao_city_id_name VALUES('2507','101340902','ɽ');
INSERT INTO yowao_city_id_name VALUES('2508','101340903','ɽ');
INSERT INTO yowao_city_id_name VALUES('2509','101340904','¸');
INSERT INTO yowao_city_id_name VALUES('2510','101341001','');
INSERT INTO yowao_city_id_name VALUES('2511','101341101','̨');
INSERT INTO yowao_city_id_name VALUES('2512','101341201','');

INSERT INTO yowao_city_mingzhan VALUES('9','Ϻ','http://www.online.sh.cn/','1','1','0','0','','1','');
INSERT INTO yowao_city_mingzhan VALUES('10','Ϻ','http://www.expo2010.cn/','1','2','0','0','','1','');
INSERT INTO yowao_city_mingzhan VALUES('11','','http://www.eastday.com/','1','3','0','0','','1','');
INSERT INTO yowao_city_mingzhan VALUES('12','ɽ','http://www.kdslife.com/','1','4','0','0','','1','');
INSERT INTO yowao_city_mingzhan VALUES('13','','http://www.xinmin.cn/','1','5','0','0','','1','');
INSERT INTO yowao_city_mingzhan VALUES('14','ţ','http://www.jfdaily.com/','1','6','0','0','','0','');
INSERT INTO yowao_city_mingzhan VALUES('15','Ϻ㲥̨','http://www.smg.cn/','1','7','0','0','','0','');
INSERT INTO yowao_city_mingzhan VALUES('16','ʿ','http://www.dragontv.cn/','1','8','0','0','','0','');
INSERT INTO yowao_city_mingzhan VALUES('17','','http://www.ddmap.com/','1','9','0','0','','0','');
INSERT INTO yowao_city_mingzhan VALUES('18','Ϻ','http://www.why.com.cn/','1','10','0','0','','0','');
INSERT INTO yowao_city_mingzhan VALUES('19','Ϻڱ','http://www.shfinancialnews.com/','1','11','0','0','','0','');
INSERT INTO yowao_city_mingzhan VALUES('20','','http://www.liba.com/1','1','12','0','0','','0','');
INSERT INTO yowao_city_mingzhan VALUES('21','籨','http://www.dfdaily.com/','1','13','0','0','','0','');
INSERT INTO yowao_city_mingzhan VALUES('22','ɽ','http://www.spc365.com/','1','14','0','0','','0','');
INSERT INTO yowao_city_mingzhan VALUES('23','Ƶ','http://www.smgbb.cn/','1','15','0','0','','0','');
INSERT INTO yowao_city_mingzhan VALUES('24','58ͬ','http://sh.58.com/','1','16','0','0','','0','');
INSERT INTO yowao_city_mingzhan VALUES('25','Ϻ','http://www.shanghaitour.net/','1','17','0','0','','0','');
INSERT INTO yowao_city_mingzhan VALUES('26','Ϻξ','http://lyw.sh.gov.cn/','1','18','0','0','','0','');
INSERT INTO yowao_city_mingzhan VALUES('27','Ϻ˲','http://www.dshrc.com/','1','19','0','0','','0','');
INSERT INTO yowao_city_mingzhan VALUES('28','Ϻ','http://www.shmetro.com/','1','20','0','0','','0','');
INSERT INTO yowao_city_mingzhan VALUES('60','֮','http://www.sz.net.cn/','5','2','0','0','','1','');
INSERT INTO yowao_city_mingzhan VALUES('30','Ϻͼ','http://map.baidu.com/?newmap=1&s=s%26wd%3D%E4%B8%8A%E6%B5%B7%E5%B8%82%26c%3D289&fr=alab0','1','21','0','0','','1','');
INSERT INTO yowao_city_mingzhan VALUES('31','ƶ','http://www.sh.10086.cn/','1','22','0','0','','1','');
INSERT INTO yowao_city_mingzhan VALUES('32','ͨ','http://www.sh.chinaunicom.com/','1','23','0','0','','1','');
INSERT INTO yowao_city_mingzhan VALUES('33','','http://sh.ct10000.com/','1','24','0','0','','1','');
INSERT INTO yowao_city_mingzhan VALUES('34','Ӵ','http://www.gznet.com/','3','1','0','0','','1','');
INSERT INTO yowao_city_mingzhan VALUES('35','  ','http://www.dayoo.com/','3','2','0','0','','1','');
INSERT INTO yowao_city_mingzhan VALUES('36','˻','http://www.gz2010.cn/','3','3','0','0','','1','');
INSERT INTO yowao_city_mingzhan VALUES('37','ձ','http://gzdaily.dayoo.com/','3','4','0','0','','1','');
INSERT INTO yowao_city_mingzhan VALUES('38','','http://www.ycwb.com/ePaper/ycwb/','3','5','0','0','','1','');
INSERT INTO yowao_city_mingzhan VALUES('39','Ϸ','http://www.nfdaily.cn/','3','6','0','0','','1','');
INSERT INTO yowao_city_mingzhan VALUES('40','  ','http://www.southcn.com/','3','7','0','0','','0','');
INSERT INTO yowao_city_mingzhan VALUES('41','  ','http://www.ycwb.com/','3','8','0','0','','0','');
INSERT INTO yowao_city_mingzhan VALUES('42','  ','http://www.020.com/','3','9','0','0','','0','');
INSERT INTO yowao_city_mingzhan VALUES('43','  ','http://www.gztv.com/','3','10','0','0','','0','');
INSERT INTO yowao_city_mingzhan VALUES('44','  ','http://www.goofm.com/','3','11','0','0','','0','');
INSERT INTO yowao_city_mingzhan VALUES('45','','http://www.gz.gov.cn/','3','12','0','0','','0','');
INSERT INTO yowao_city_mingzhan VALUES('46','й','http://www.gzjd.gov.cn/','3','13','0','0','','0','');
INSERT INTO yowao_city_mingzhan VALUES('47','㶫̨','http://www.gdtv.com.cn/','3','14','0','0','','0','');
INSERT INTO yowao_city_mingzhan VALUES('48','Ϸ̨','http://www.tvscn.com/','3','15','0','0','','0','');
INSERT INTO yowao_city_mingzhan VALUES('49','','http://www.gzcb.com.cn/','3','16','0','0','','0','');
INSERT INTO yowao_city_mingzhan VALUES('50','','http://www.visitgz.com/','3','17','0','0','','0','');
INSERT INTO yowao_city_mingzhan VALUES('51','˲','http://www.020job.com/','3','18','0','0','','0','');
INSERT INTO yowao_city_mingzhan VALUES('52','й','http://www.gov.cn/','3','19','0','0','','0','');
INSERT INTO yowao_city_mingzhan VALUES('53','ݵ','http://www.gzmtr.com/','3','20','0','0','','0','');
INSERT INTO yowao_city_mingzhan VALUES('54','ݵͼ','http://map.baidu.com/?newmap=1&s=s%26wd%3D%E5%B9%BF%E5%B7%9E%E5%B8%82%26c%3D257&fr=alab0','3','21','0','0','','0','');
INSERT INTO yowao_city_mingzhan VALUES('55','ƶ','http://gd.10086.cn/guangzhou/','3','22','0','0','','0','');
INSERT INTO yowao_city_mingzhan VALUES('56','ͨ','http://info.10010.com/lt/plugin/portal/arealevel/queryCityInfo.do?arno=000100040001','3','23','0','0','','0','');
INSERT INTO yowao_city_mingzhan VALUES('57','','http://gd.ct10000.com/gz/','3','24','0','0','','0','');
INSERT INTO yowao_city_mingzhan VALUES('58','','http://www.gznews.gov.cn/','3','20','0','0','','0','');
INSERT INTO yowao_city_mingzhan VALUES('59','','http://www.sznews.com/','5','1','0','0','','1','');
INSERT INTO yowao_city_mingzhan VALUES('61','','http://www.sz.gov.cn/cn/','5','3','0','0','','1','');
INSERT INTO yowao_city_mingzhan VALUES('62','','http://www.szonline.net/','5','4','0','0','','1','');
INSERT INTO yowao_city_mingzhan VALUES('63','','http://www.szhk.com/','5','5','0','0','','1','');
INSERT INTO yowao_city_mingzhan VALUES('64','Ϣ','http://www.szinfo.com/','5','6','0','0','','1','');
INSERT INTO yowao_city_mingzhan VALUES('65','','http://www.szol.net/','5','7','0','0','','1','');
INSERT INTO yowao_city_mingzhan VALUES('66','ڵ̨','http://www.sztv.com.cn/','5','8','0','0','','0','');
INSERT INTO yowao_city_mingzhan VALUES('67','һ','http://www.oeeee.com/','5','9','0','0','','0','');
INSERT INTO yowao_city_mingzhan VALUES('68','ĥ','http://www.doyouhike.net/','5','10','0','0','','0','');
INSERT INTO yowao_city_mingzhan VALUES('69','ڷز','http://www.szhome.com/','5','11','0','0','','0','');
INSERT INTO yowao_city_mingzhan VALUES('70','ڹ','http://www.szga.gov.cn/','5','12','0','0','','0','');
INSERT INTO yowao_city_mingzhan VALUES('71','ڹ㲥','http://www.szr.com.cn/','5','13','0','0','','0','');
INSERT INTO yowao_city_mingzhan VALUES('72','','http://www.szlgnews.com/','5','14','0','0','','0','');
INSERT INTO yowao_city_mingzhan VALUES('73','','http://www.shenzhentour.com/','5','15','0','0','','0','');
INSERT INTO yowao_city_mingzhan VALUES('74','58ͬ','http://sz.58.com/','5','16','0','0','','0','');
INSERT INTO yowao_city_mingzhan VALUES('75','ڱر','http://sz.bendibao.com/','5','17','0','0','','0','');
INSERT INTO yowao_city_mingzhan VALUES('76','IT','http://www.szit.com.cn/','5','18','0','0','','0','');
INSERT INTO yowao_city_mingzhan VALUES('77','˲','http://www.szhr.com.cn/','5','19','0','0','','0','');
INSERT INTO yowao_city_mingzhan VALUES('78','ڵ','http://www.szmc.net/','5','20','0','0','','0','');
INSERT INTO yowao_city_mingzhan VALUES('79','ڵͼ','http://map.baidu.com/?newmap=1&s=s%26wd%3D%E6%B7%B1%E5%9C%B3%E5%B8%82%26c%3D340&fr=alab0','5','21','0','0','','0','');
INSERT INTO yowao_city_mingzhan VALUES('80','ƶ','http://gd.10086.cn/shenzhen/','5','22','0','0','','0','');
INSERT INTO yowao_city_mingzhan VALUES('81','ͨ','http://info2.10010.com/lt/plugin/portal/arealevel/queryCityInfo.do?id=1677&arno=000100040002','5','23','0','0','','0','');
INSERT INTO yowao_city_mingzhan VALUES('82','','http://gd.ct10000.com/sz/','5','24','0','0','','0','');
INSERT INTO yowao_city_mingzhan VALUES('83','׶֮','http://www.beijing.gov.cn/','10','1','0','0','','1','');
INSERT INTO yowao_city_mingzhan VALUES('84','','http://www.beijing.cn/','10','2','0','0','','1','');
INSERT INTO yowao_city_mingzhan VALUES('85','ǧ','http://www.qianlong.com/','10','3','0','0','','1','');
INSERT INTO yowao_city_mingzhan VALUES('86','CNTV','http://www.cntv.cn/','10','4','0','0','','1','');
INSERT INTO yowao_city_mingzhan VALUES('87','','http://www.bbn.com.cn/','10','5','0','0','','1','');
INSERT INTO yowao_city_mingzhan VALUES('88','','http://www.bjd.com.cn/','10','6','0','0','','1','');
INSERT INTO yowao_city_mingzhan VALUES('89','»','http://www.bj.xinhuanet.com/','10','7','0','0','','1','');
INSERT INTO yowao_city_mingzhan VALUES('90','','http://bj.people.com.cn/GB/index.html','10','8','0','0','','1','');
INSERT INTO yowao_city_mingzhan VALUES('91','㲥','http://www.rbc.cn/','10','9','0','0','','1','');
INSERT INTO yowao_city_mingzhan VALUES('92','̨','http://www.btv.com.cn/','10','10','0','0','','1','');
INSERT INTO yowao_city_mingzhan VALUES('93','¾','http://www.bjnews.com.cn/','10','11','0','0','','1','');
INSERT INTO yowao_city_mingzhan VALUES('94','','http://www.morningpost.com.cn/','10','12','0','0','','1','');
INSERT INTO yowao_city_mingzhan VALUES('95','','http://www.ynet.com/','10','13','0','0','','1','');
INSERT INTO yowao_city_mingzhan VALUES('96','ܱ','http://www.beijingreview.com.cn/','10','14','0','0','','1','');
INSERT INTO yowao_city_mingzhan VALUES('97','','http://www.gmw.cn/','10','15','0','0','','1','');
INSERT INTO yowao_city_mingzhan VALUES('98','','http://www.jinghua.cn/','10','16','0','0','','1','');
INSERT INTO yowao_city_mingzhan VALUES('99','58ͬ','http://bj.58.com/','10','17','0','0','','1','');
INSERT INTO yowao_city_mingzhan VALUES('100','','http://www.bjta.gov.cn/','10','18','0','0','','1','');
INSERT INTO yowao_city_mingzhan VALUES('101','˲','http://www.bjrc.com/','10','19','0','0','','1','');
INSERT INTO yowao_city_mingzhan VALUES('102','','http://www.bjsubway.com/','10','20','0','0','','1','');
INSERT INTO yowao_city_mingzhan VALUES('103','ͼ','http://map.baidu.com/?newmap=1&s=s%26wd%3D%E5%8C%97%E4%BA%AC%E5%B8%82%26c%3D131&fr=alab0','10','21','0','0','','1','');
INSERT INTO yowao_city_mingzhan VALUES('104','ƶ','http://www.bj.10086.cn/','10','22','0','0','','1','');
INSERT INTO yowao_city_mingzhan VALUES('105','ͨ','http://www.bj.chinaunicom.com/','10','23','0','0','','1','');
INSERT INTO yowao_city_mingzhan VALUES('106','','http://www.bjtelecom.net/','10','24','0','0','','1','');


INSERT INTO yowao_class VALUES('1','0','','1','0','','','','');
INSERT INTO yowao_class VALUES('2','0','','2','0','','','','');
INSERT INTO yowao_class VALUES('3','0','Ļ','4','0','','','','');
INSERT INTO yowao_class VALUES('4','0','','3','0','','','','');
INSERT INTO yowao_class VALUES('644','1','С˵','106','0','xiaoshuo','','','');
INSERT INTO yowao_class VALUES('645','644','С˵Ķ','1','32','','','','');
INSERT INTO yowao_class VALUES('647','2209','С˵̳','4','6','','','','');
INSERT INTO yowao_class VALUES('648','644','Ļѧ','3','11','','','','');
INSERT INTO yowao_class VALUES('649','644','','2','4','','','','');
INSERT INTO yowao_class VALUES('2289','2217','Ʒ','3','7','','','','');
INSERT INTO yowao_class VALUES('652','1','Ӱ','117','0','sheying','','','');
INSERT INTO yowao_class VALUES('653','2199','','3','9','','','','');
INSERT INTO yowao_class VALUES('1923','2172','ǺԮ','5','27','','','','');
INSERT INTO yowao_class VALUES('1603','755','̨','1','5','','','','');
INSERT INTO yowao_class VALUES('2156','1036','ѧƿμ̰','4','0','','','','');
INSERT INTO yowao_class VALUES('658','2','','123','0','yule','','','');
INSERT INTO yowao_class VALUES('659','658','ۺ','1','17','','','','');
INSERT INTO yowao_class VALUES('1973','731','ЦƵ','2','12','','','','');
INSERT INTO yowao_class VALUES('1924','2172','','6','16','','','','');
INSERT INTO yowao_class VALUES('662','2','','115','0','sex','','','');
INSERT INTO yowao_class VALUES('663','662','Խ','1','4','','','','');
INSERT INTO yowao_class VALUES('664','2218','Ů','1','23','','','','');
INSERT INTO yowao_class VALUES('665','2218','ݼ','4','15','','','','');
INSERT INTO yowao_class VALUES('1978','921','Żȯ','4','5','','','','');
INSERT INTO yowao_class VALUES('2028','1596','Ϸ','6','9','','','','');
INSERT INTO yowao_class VALUES('668','4','','108','0','blog','','','');
INSERT INTO yowao_class VALUES('669','668','','1','18','','','','');
INSERT INTO yowao_class VALUES('670','668','ܱ','2','7','','','','');
INSERT INTO yowao_class VALUES('1931','2209','̳','22','8','','','','');
INSERT INTO yowao_class VALUES('673','668','ժ/ǩ','3','9','','','','');
INSERT INTO yowao_class VALUES('674','1','','114','0','bbs','','','');
INSERT INTO yowao_class VALUES('675','674','ۺ̳','1','29','','','','');
INSERT INTO yowao_class VALUES('1937','1936','̳','1','6','','','','');
INSERT INTO yowao_class VALUES('678','2209','̳','6','23','','','','');
INSERT INTO yowao_class VALUES('1933','2209','̳','20','9','','','','');
INSERT INTO yowao_class VALUES('680','2209','ȫ̳','7','4','','','','');
INSERT INTO yowao_class VALUES('681','2209','Ӳ̳','5','10','','','','');
INSERT INTO yowao_class VALUES('2160','974','֪ʶ','2','5','','','','');
INSERT INTO yowao_class VALUES('684','2209','ͼ̳','14','6','','','','');
INSERT INTO yowao_class VALUES('685','2209','Ц̳','15','8','','','','');
INSERT INTO yowao_class VALUES('686','2209','̳','3','12','','','','');
INSERT INTO yowao_class VALUES('689','2209','̳','8','5','','','','');
INSERT INTO yowao_class VALUES('690','2209','ֻ̳','9','10','','','','');
INSERT INTO yowao_class VALUES('691','2209','̳','10','5','','','','');
INSERT INTO yowao_class VALUES('1936','674','ط̳','3','0','','','','');
INSERT INTO yowao_class VALUES('693','2209','̳','11','9','','','','');
INSERT INTO yowao_class VALUES('1932','2209','̳','17','6','','','','');
INSERT INTO yowao_class VALUES('2077','2209','̳','13','9','','','','');
INSERT INTO yowao_class VALUES('697','2209','̳','12','7','','','','');
INSERT INTO yowao_class VALUES('698','1','Ϸ','103','0','games','','','');
INSERT INTO yowao_class VALUES('699','698','Ϸۺ','1','21','','','','');
INSERT INTO yowao_class VALUES('701','2215','СϷ','2','11','','','','');
INSERT INTO yowao_class VALUES('703','2209','Ϸ̳','16','9','','','','');
INSERT INTO yowao_class VALUES('704','698','Ϸ','6','8','','','','');
INSERT INTO yowao_class VALUES('706','698','','8','18','','','','');
INSERT INTO yowao_class VALUES('2145','795','Ӱ','100','5','','','','');
INSERT INTO yowao_class VALUES('708','1','ͼ','110','0','bizhi','','','');
INSERT INTO yowao_class VALUES('709','708','ۺͼ','1','23','','','','');
INSERT INTO yowao_class VALUES('710','708','Ů','3','8','','','','');
INSERT INTO yowao_class VALUES('711','2219','ֽ','1','14','','','','');
INSERT INTO yowao_class VALUES('712','2219','','4','6','','','','');
INSERT INTO yowao_class VALUES('715','1','','101','0','music','','','');
INSERT INTO yowao_class VALUES('716','715','','1','17','','','','');
INSERT INTO yowao_class VALUES('717','715','ܱ','4','14','','','','');
INSERT INTO yowao_class VALUES('719','2223','ַ/ԭ','6','6','','','','');
INSERT INTO yowao_class VALUES('720','715','DJ','2','9','','','','');
INSERT INTO yowao_class VALUES('725','1','','118','0','junshi','','','');
INSERT INTO yowao_class VALUES('726','725','Ѷ','1','23','','','','');
INSERT INTO yowao_class VALUES('727','725','̳','2','12','','','','');
INSERT INTO yowao_class VALUES('728','2168','¿','3','14','','','','');
INSERT INTO yowao_class VALUES('729','2168','ʷ','4','30','','','','');
INSERT INTO yowao_class VALUES('2285','2216','','0','9','','','','');
INSERT INTO yowao_class VALUES('731','1','Ц','113','0','fun','','','');
INSERT INTO yowao_class VALUES('732','731','ĬЦ','1','15','','','','');
INSERT INTO yowao_class VALUES('733','731','Ц΢','3','5','','','','');
INSERT INTO yowao_class VALUES('734','2','ʱ','118','0','fashion','','','');
INSERT INTO yowao_class VALUES('735','734','ʱѶ','1','9','','','','');
INSERT INTO yowao_class VALUES('736','2218','ʱװʱ','2','26','','','','');
INSERT INTO yowao_class VALUES('737','2188','ױƷ','4','20','','','','');
INSERT INTO yowao_class VALUES('738','734','ʱ־','4','13','','','','');
INSERT INTO yowao_class VALUES('739','921','ʳۺ','1','14','','','','');
INSERT INTO yowao_class VALUES('2197','921','״ȫ','2','3','','','','');
INSERT INTO yowao_class VALUES('741','4','','109','0','liaotian_qq','','','');
INSERT INTO yowao_class VALUES('742','741','','2','9','','','','');
INSERT INTO yowao_class VALUES('2146','1711','ϵ','100','5','','','','');
INSERT INTO yowao_class VALUES('744','741','칤','1','20','','','','');
INSERT INTO yowao_class VALUES('1930','2209','ɫ̳','2','22','','','','');
INSERT INTO yowao_class VALUES('748','2226','','106','0','dianshi','','','');
INSERT INTO yowao_class VALUES('749','2167','Ȳ̨','2','24','','','','');
INSERT INTO yowao_class VALUES('2051','2050','ξ','1','12','','','','');
INSERT INTO yowao_class VALUES('751','748','ط̨','4','0','','','','');
INSERT INTO yowao_class VALUES('752','748','Ѷ/ĿԤ','1','9','','','','');
INSERT INTO yowao_class VALUES('2031','891','ξ','5','7','','','','');
INSERT INTO yowao_class VALUES('754','2167','Ź㲥̨','5','27','','','','');
INSERT INTO yowao_class VALUES('755','748','ط̨','5','0','','','','');
INSERT INTO yowao_class VALUES('756','748','̨','2','8','','','','');
INSERT INTO yowao_class VALUES('757','4','Flash','126','0','flash','','','');
INSERT INTO yowao_class VALUES('758','757','Flash','1','8','','','','');
INSERT INTO yowao_class VALUES('759','757','СϷ','2','10','','','','');
INSERT INTO yowao_class VALUES('760','757','Flash̳','4','5','','','','');
INSERT INTO yowao_class VALUES('762','757','Flash','5','2','','','','');
INSERT INTO yowao_class VALUES('765','2','ֻ','110','0','shouji','','','');
INSERT INTO yowao_class VALUES('766','765','ֻۺ','1','19','','','','');
INSERT INTO yowao_class VALUES('767','765','ֻ','4','5','','','','');
INSERT INTO yowao_class VALUES('768','765','ֻ̳','7','21','','','','');
INSERT INTO yowao_class VALUES('770','765','ƻiphone','2','1','','','','');
INSERT INTO yowao_class VALUES('1975','803','','10','8','','','','');
INSERT INTO yowao_class VALUES('774','2091','ͨѶ','1','10','','','','');
INSERT INTO yowao_class VALUES('775','2091','Ӫ','0','4','','','','');
INSERT INTO yowao_class VALUES('776','1','','112','0','dongman','','','');
INSERT INTO yowao_class VALUES('777','776','Ƶ','1','11','','','','');
INSERT INTO yowao_class VALUES('2287','2216','','0','6','','','','');
INSERT INTO yowao_class VALUES('779','776','','8','4','','','','');
INSERT INTO yowao_class VALUES('783','1','','111','0','xingzuo','','','');
INSERT INTO yowao_class VALUES('784','783','','1','10','','','','');
INSERT INTO yowao_class VALUES('785','783','ռ/Ȥζ','2','20','','','','');
INSERT INTO yowao_class VALUES('2290','2217','ͨ','2','14','','','','');
INSERT INTO yowao_class VALUES('787','783','̳','5','16','','','','');
INSERT INTO yowao_class VALUES('2027','1596','ҵƾ','7','9','','','','');
INSERT INTO yowao_class VALUES('789','1','','115','0','love','','','');
INSERT INTO yowao_class VALUES('790','789','','1','15','','','','');
INSERT INTO yowao_class VALUES('791','789','','3','8','','','','');
INSERT INTO yowao_class VALUES('792','789','','2','22','','','','');
INSERT INTO yowao_class VALUES('795','4','','121','0','shuma','','','');
INSERT INTO yowao_class VALUES('796','795','ۺ','1','13','','','','');
INSERT INTO yowao_class VALUES('799','1711','MP3/MD','7','9','','','','');
INSERT INTO yowao_class VALUES('800','795','̳','2','6','','','','');
INSERT INTO yowao_class VALUES('801','1711','ͷ','3','25','','','','');
INSERT INTO yowao_class VALUES('1713','1076','ɫ','6','17','','','','');
INSERT INTO yowao_class VALUES('803','1','Ƶ','102','0','vedio','','','');
INSERT INTO yowao_class VALUES('2288','2217','ճ','1','21','','','','');
INSERT INTO yowao_class VALUES('805','2212','ߵӰ','2','14','','','','');
INSERT INTO yowao_class VALUES('2068','698','Ϸܱ','9','19','','','','');
INSERT INTO yowao_class VALUES('813','2','Ʊ','109','0','caipiao','','','');
INSERT INTO yowao_class VALUES('814','813','ƱŻ','1','6','','','','');
INSERT INTO yowao_class VALUES('815','813','Ʊ','3','26','','','','');
INSERT INTO yowao_class VALUES('816','813','Ʊ','4','32','','','','');
INSERT INTO yowao_class VALUES('817','813','Ʊ','5','5','','','','');
INSERT INTO yowao_class VALUES('2059','2193','ط','7','10','','','','');
INSERT INTO yowao_class VALUES('820','2','','116','0','pet','','','');
INSERT INTO yowao_class VALUES('821','820','ۺ','1','9','','','','');
INSERT INTO yowao_class VALUES('822','820','ݻ','9','7','','','','');
INSERT INTO yowao_class VALUES('824','1','','116','0','star','','','');
INSERT INTO yowao_class VALUES('825','824','վ','1','10','','','','');
INSERT INTO yowao_class VALUES('827','2172','½','1','20','','','','');
INSERT INTO yowao_class VALUES('828','2172','̨','2','26','','','','');
INSERT INTO yowao_class VALUES('829','2172','','3','37','','','','');
INSERT INTO yowao_class VALUES('2155','2034','','100','0','','','','');
INSERT INTO yowao_class VALUES('831','1','','104','0','news','','','');
INSERT INTO yowao_class VALUES('832','831','ۺ','1','20','','','','');
INSERT INTO yowao_class VALUES('835','668','','5','3','','','','');
INSERT INTO yowao_class VALUES('837','831','֪','2','25','','','','');
INSERT INTO yowao_class VALUES('838','831','ط','5','0','','','','');
INSERT INTO yowao_class VALUES('842','2','Ʊ','103','0','gupiao','','','');
INSERT INTO yowao_class VALUES('843','842','ƾѶ','1','17','','','','');
INSERT INTO yowao_class VALUES('847','842','ƾ','4','13','','','','');
INSERT INTO yowao_class VALUES('848','842','֤ȯ/˾','3','55','','','','');
INSERT INTO yowao_class VALUES('851','2','','105','0','gouwu','','','');
INSERT INTO yowao_class VALUES('852','851','Ϲ','1','23','','','','');
INSERT INTO yowao_class VALUES('853','851','ͼ/','8','4','','','','');
INSERT INTO yowao_class VALUES('2134','662','Ʒ','2','4','','','','');
INSERT INTO yowao_class VALUES('1717','924','Ʒ','5','17','','','','');
INSERT INTO yowao_class VALUES('856','2','','106','28','bank','','','');
INSERT INTO yowao_class VALUES('1688','2204','','5','20','','','','');
INSERT INTO yowao_class VALUES('858','856','ڵ','1','19','','','','');
INSERT INTO yowao_class VALUES('860','856','Ѷ','3','12','','','','');
INSERT INTO yowao_class VALUES('1721','871','ҽԺ','1','35','','','','');
INSERT INTO yowao_class VALUES('863','2','','111','0','health','','','');
INSERT INTO yowao_class VALUES('864','863','ҽ','1','19','','','','');
INSERT INTO yowao_class VALUES('2207','2205','طԮ','100','7','','','','');
INSERT INTO yowao_class VALUES('2206','2205','طʦ','100','22','','','','');
INSERT INTO yowao_class VALUES('871','863','ҽԺ','5','0','','','','');
INSERT INTO yowao_class VALUES('873','2226','','101','0','zhaoshang','','','');
INSERT INTO yowao_class VALUES('2133','2219','ϵͳ̳','5','5','','','','');
INSERT INTO yowao_class VALUES('2291','2217','ѯ','4','8','','','','');
INSERT INTO yowao_class VALUES('878','2','','108','0','house','','','');
INSERT INTO yowao_class VALUES('879','878','װ','2','22','','','','');
INSERT INTO yowao_class VALUES('881','878','ⷿ','1','23','','','','');
INSERT INTO yowao_class VALUES('883','2','','113','0','qinzi','','','');
INSERT INTO yowao_class VALUES('884','883','','1','11','','','','');
INSERT INTO yowao_class VALUES('2167','748','ŵӵ̨','3','0','','','','');
INSERT INTO yowao_class VALUES('886','883','ͯ','2','8','','','','');
INSERT INTO yowao_class VALUES('888','883','̳','5','12','','','','');
INSERT INTO yowao_class VALUES('889','883','Ϸͯҥ','6','6','','','','');
INSERT INTO yowao_class VALUES('890','883','ʽ','3','5','','','','');
INSERT INTO yowao_class VALUES('891','2','','117','0','travel','','','');
INSERT INTO yowao_class VALUES('892','891','Ѷ','1','12','','','','');
INSERT INTO yowao_class VALUES('893','891','','7','0','','','','');
INSERT INTO yowao_class VALUES('2050','891','ξ','8','0','','','','');
INSERT INTO yowao_class VALUES('895','891','/Ƶ/Ʊ','2','11','','','','');
INSERT INTO yowao_class VALUES('2024','2229','','3','15','','','','');
INSERT INTO yowao_class VALUES('2039','715','ֲ','10','5','','','','');
INSERT INTO yowao_class VALUES('899','2226','','103','0','zhengfu','','','');
INSERT INTO yowao_class VALUES('902','899','ط','3','0','','','','');
INSERT INTO yowao_class VALUES('903','2179','Ϣ','2','23','','','','');
INSERT INTO yowao_class VALUES('904','2186','֯','5','52','','','','');
INSERT INTO yowao_class VALUES('905','899','','5','0','','','','');
INSERT INTO yowao_class VALUES('907','2','','122','0','life','','','');
INSERT INTO yowao_class VALUES('908','907','ʱ','1','13','','','','');
INSERT INTO yowao_class VALUES('912','2','','112','0','law','','','');
INSERT INTO yowao_class VALUES('913','912','ɼ','1','10','','','','');
INSERT INTO yowao_class VALUES('914','2205','طԺ','7','29','','','','');
INSERT INTO yowao_class VALUES('915','912','˾','3','9','','','','');
INSERT INTO yowao_class VALUES('2284','2226','ط','102','49','html/difang','','','');
INSERT INTO yowao_class VALUES('921','2','ʳ','119','0','foods','','','');
INSERT INTO yowao_class VALUES('2080','921','ʳ','3','4','','','','');
INSERT INTO yowao_class VALUES('1919','831','֪ý','4','11','','','','');
INSERT INTO yowao_class VALUES('925','924','Ʒ','1','10','','','','');
INSERT INTO yowao_class VALUES('926','924','','3','9','','','','');
INSERT INTO yowao_class VALUES('927','1','','107','0','tiyu','','','');
INSERT INTO yowao_class VALUES('928','927','ۺ','1','25','','','','');
INSERT INTO yowao_class VALUES('929','927','̳','6','5','','','','');
INSERT INTO yowao_class VALUES('930','2034','NBAר','1','12','','','','');
INSERT INTO yowao_class VALUES('931','2150','˶','13','21','','','','');
INSERT INTO yowao_class VALUES('934','2150','ë','17','10','','','','');
INSERT INTO yowao_class VALUES('935','2150','ƹ','18','24','','','','');
INSERT INTO yowao_class VALUES('937','2150','','9','19','','','','');
INSERT INTO yowao_class VALUES('2081','2186','פʹ/¹','101','27','','','','');
INSERT INTO yowao_class VALUES('940','2150','߶','16','13','','','','');
INSERT INTO yowao_class VALUES('941','2150','','25','14','','','','');
INSERT INTO yowao_class VALUES('944','2150','','14','14','','','','');
INSERT INTO yowao_class VALUES('946','3','ѧ','7','0','gaoxiao','','','');
INSERT INTO yowao_class VALUES('947','2246','ͬѧ¼','2','5','','','','');
INSERT INTO yowao_class VALUES('2078','2149','УBBS̳','6','55','','','','');
INSERT INTO yowao_class VALUES('2055','2050','ξ','5','4','','','','');
INSERT INTO yowao_class VALUES('950','946','طУ','9','0','','','','');
INSERT INTO yowao_class VALUES('951','2149','У','4','20','','','','');
INSERT INTO yowao_class VALUES('2023','2239','ͨͼ','3','8','','','','');
INSERT INTO yowao_class VALUES('2158','974','ѧ','4','0','','','','');
INSERT INTO yowao_class VALUES('955','2149','ѧͼ','5','77','','','','');
INSERT INTO yowao_class VALUES('2054','2050','ξ','4','6','','','','');
INSERT INTO yowao_class VALUES('957','2','Ƹ','121','0','rencai','','','');
INSERT INTO yowao_class VALUES('958','957','˲Ƹ','1','13','','','','');
INSERT INTO yowao_class VALUES('959','957','ط˲','6','0','','','','');
INSERT INTO yowao_class VALUES('960','957','д','3','6','','','','');
INSERT INTO yowao_class VALUES('961','3','','1','0','jiaoyu','','','');
INSERT INTO yowao_class VALUES('962','961','ۺ','1','19','','','','');
INSERT INTO yowao_class VALUES('964','961','׶','2','7','','','','');
INSERT INTO yowao_class VALUES('2283','873','̼','0','2','','','','');
INSERT INTO yowao_class VALUES('966','961','','3','8','','','','');
INSERT INTO yowao_class VALUES('967','961','ְҵ','6','4','','','','');
INSERT INTO yowao_class VALUES('969','961','˽','5','5','','','','');
INSERT INTO yowao_class VALUES('970','961','','8','5','','','','');
INSERT INTO yowao_class VALUES('2061','2173','طƷ','2','20','','','','');
INSERT INTO yowao_class VALUES('2088','961','ߵȽ','4','4','','','','');
INSERT INTO yowao_class VALUES('974','3','Ƽ','2','0','kexue_jishu','','','');
INSERT INTO yowao_class VALUES('975','974','Ƽۺ','1','14','','','','');
INSERT INTO yowao_class VALUES('976','2158','ѧ','5','15','','','','');
INSERT INTO yowao_class VALUES('977','2158','ѧ','8','14','','','','');
INSERT INTO yowao_class VALUES('978','2158','ѧ','6','15','','','','');
INSERT INTO yowao_class VALUES('979','2158','ѧ','13','12','','','','');
INSERT INTO yowao_class VALUES('980','2158','ѧ','12','15','','','','');
INSERT INTO yowao_class VALUES('981','2158','ѧ','11','19','','','','');
INSERT INTO yowao_class VALUES('983','2158','ʷѧ','9','21','','','','');
INSERT INTO yowao_class VALUES('984','2158','ѧ','3','25','','','','');
INSERT INTO yowao_class VALUES('985','2158','ѧ','7','11','','','','');
INSERT INTO yowao_class VALUES('986','2158','ѧ','1','9','','','','');
INSERT INTO yowao_class VALUES('987','2158','ѧ','2','14','','','','');
INSERT INTO yowao_class VALUES('989','2159','صʵ','17','20','','','','');
INSERT INTO yowao_class VALUES('2265','2264','̳','100','6','','','','');
INSERT INTO yowao_class VALUES('991','2161','','0','19','','','','');
INSERT INTO yowao_class VALUES('992','2161','ѧ','7','10','','','','');
INSERT INTO yowao_class VALUES('993','2264','ۺ','2','14','','','','');
INSERT INTO yowao_class VALUES('994','2161','˾','11','14','','','','');
INSERT INTO yowao_class VALUES('995','2161','ƻῼ','11','15','','','','');
INSERT INTO yowao_class VALUES('996','2161','Ա','1','9','','','','');
INSERT INTO yowao_class VALUES('998','2161','','10','8','','','','');
INSERT INTO yowao_class VALUES('999','2161','MBAѵ','9','7','','','','');
INSERT INTO yowao_class VALUES('2087','1011','','9','2','','','','');
INSERT INTO yowao_class VALUES('1001','2263','߿Ѷ','3','15','','','','');
INSERT INTO yowao_class VALUES('1003','3','','11','0','shehui_wenhua','','','');
INSERT INTO yowao_class VALUES('1004','1003','Ļ','1','20','','','','');
INSERT INTO yowao_class VALUES('2164','2224','ַ','2','4','','','','');
INSERT INTO yowao_class VALUES('1006','2225','վ','6','12','','','','');
INSERT INTO yowao_class VALUES('2163','2224','ַ','1','15','','','','');
INSERT INTO yowao_class VALUES('2162','1003','ʷ','100','4','','','','');
INSERT INTO yowao_class VALUES('1009','1003','ʷ','2','5','','','','');
INSERT INTO yowao_class VALUES('2239','2','ͼ','124','0','map','','','');
INSERT INTO yowao_class VALUES('1011','3','','13','0','yishu_aihao','','','');
INSERT INTO yowao_class VALUES('1012','1011','','0','15','','','','');
INSERT INTO yowao_class VALUES('1015','1011','鷨','3','10','','','','');
INSERT INTO yowao_class VALUES('2149','946','йѧ','4','0','','','','');
INSERT INTO yowao_class VALUES('1017','1011','滭','2','8','','','','');
INSERT INTO yowao_class VALUES('1018','2223','СƷ','1','10','','','','');
INSERT INTO yowao_class VALUES('1019','1011','ղ','1','19','','','','');
INSERT INTO yowao_class VALUES('1020','1','','108','0','football','','','');
INSERT INTO yowao_class VALUES('1021','1020','ۺ','1','9','','','','');
INSERT INTO yowao_class VALUES('1036','3','','8','0','kejian_lunwen','','','');
INSERT INTO yowao_class VALUES('1037','1036','μԴ','2','10','','','','');
INSERT INTO yowao_class VALUES('1038','2156','ѧμ̰','4','4','','','','');
INSERT INTO yowao_class VALUES('1039','2156','Ӣμ̰','5','9','','','','');
INSERT INTO yowao_class VALUES('1040','2156','Ŀμ̰','6','9','','','','');
INSERT INTO yowao_class VALUES('1699','1682','','2','36','','','','');
INSERT INTO yowao_class VALUES('1698','1682','ܼ','3','26','','','','');
INSERT INTO yowao_class VALUES('1043','1036','','1','13','','','','');
INSERT INTO yowao_class VALUES('1044','3','','3','0','waiyu_xuexi','','','');
INSERT INTO yowao_class VALUES('1045','1044','Ӣѧϰ','1','25','','','','');
INSERT INTO yowao_class VALUES('2150','927','˶Ŀ','100','0','','','','');
INSERT INTO yowao_class VALUES('1047','1044','߷','2','11','','','','');
INSERT INTO yowao_class VALUES('2270','1131','ҳ','100','15','','','','');
INSERT INTO yowao_class VALUES('2165','2224','վ','3','4','','','','');
INSERT INTO yowao_class VALUES('1050','1044','ѧϰ','5','13','','','','');
INSERT INTO yowao_class VALUES('1051','3','ѧ','12','0','chuguo_liuxue','','','');
INSERT INTO yowao_class VALUES('1052','1051','ѧ','1','15','','','','');
INSERT INTO yowao_class VALUES('1053','1051','ѧ','3','9','','','','');
INSERT INTO yowao_class VALUES('1054','1051','','2','5','','','','');
INSERT INTO yowao_class VALUES('1696','957','ҵ˲','5','32','','','','');
INSERT INTO yowao_class VALUES('1695','957','ַ','4','5','','','','');
INSERT INTO yowao_class VALUES('2034','1','NBA','109','0','nba','','','');
INSERT INTO yowao_class VALUES('1068','2199','','1','19','','','','');
INSERT INTO yowao_class VALUES('1689','1711','MP4','3','9','','','','');
INSERT INTO yowao_class VALUES('1076','4','','122','0','Sousuo','','','');
INSERT INTO yowao_class VALUES('1077','1076','','1','9','','','','');
INSERT INTO yowao_class VALUES('2159','974','ѧо','5','0','','','','');
INSERT INTO yowao_class VALUES('1686','1711','MP3/MP4Ʒ','2','15','','','','');
INSERT INTO yowao_class VALUES('1082','2226','','105','0','guowai','','','');
INSERT INTO yowao_class VALUES('1084','1082','ۺŻ','2','42','','','','');
INSERT INTO yowao_class VALUES('1085','1082','','14','32','','','','');
INSERT INTO yowao_class VALUES('1086','1082','־','11','91','','','','');
INSERT INTO yowao_class VALUES('1087','1082','','9','10','','','','');
INSERT INTO yowao_class VALUES('1088','1082','⻪','3','30','','','','');
INSERT INTO yowao_class VALUES('1089','1082','','1','13','','','','');
INSERT INTO yowao_class VALUES('1090','1082','Ӳ','15','31','','','','');
INSERT INTO yowao_class VALUES('1091','1082','ַ','4','25','','','','');
INSERT INTO yowao_class VALUES('1092','1082','ַ','5','20','','','','');
INSERT INTO yowao_class VALUES('1093','1082','Ӱ','9','37','','','','');
INSERT INTO yowao_class VALUES('1094','1082','ʱ','8','24','','','','');
INSERT INTO yowao_class VALUES('1095','4','Ӳ','120','0','Yingjian','','','');
INSERT INTO yowao_class VALUES('1096','1095','ӲѶ','1','29','','','','');
INSERT INTO yowao_class VALUES('1097','2147','ӲƷ','1','86','','','','');
INSERT INTO yowao_class VALUES('1711','795','','100','0','','','','');
INSERT INTO yowao_class VALUES('1099','2147','ʼǱ','3','15','','','','');
INSERT INTO yowao_class VALUES('1101','1095','Ӳ','2','9','','','','');
INSERT INTO yowao_class VALUES('1102','1095','','4','5','','','','');
INSERT INTO yowao_class VALUES('1103','1095','Ӳ̳','3','8','','','','');
INSERT INTO yowao_class VALUES('1104','2147','Ѷ','4','15','','','','');
INSERT INTO yowao_class VALUES('1105','4','','103','0','soft','','','');
INSERT INTO yowao_class VALUES('1106','1105','','1','21','','','','');
INSERT INTO yowao_class VALUES('1107','1105','̳','5','6','','','','');
INSERT INTO yowao_class VALUES('1109','1105','װ','3','4','','','','');
INSERT INTO yowao_class VALUES('1285','803','ƵƬ','1','21','','','','');
INSERT INTO yowao_class VALUES('1113','2120','BT','2','14','','','','');
INSERT INTO yowao_class VALUES('1114','2120','P2P','8','10','','','','');
INSERT INTO yowao_class VALUES('1284','2120','P2P','9','4','','','','');
INSERT INTO yowao_class VALUES('1117','1082','','6','18','','','','');
INSERT INTO yowao_class VALUES('1118','1105','','2','7','','','','');
INSERT INTO yowao_class VALUES('1119','2212','ӰѶ','4','9','','','','');
INSERT INTO yowao_class VALUES('1121','4','IT','101','0','it','','','');
INSERT INTO yowao_class VALUES('1122','1121','ITѶ','0','35','','','','');
INSERT INTO yowao_class VALUES('1123','2147','Թ˾','2','20','','','','');
INSERT INTO yowao_class VALUES('1124','2198','Խ̳','3','9','','','','');
INSERT INTO yowao_class VALUES('1126','2198','Ա','4','13','','','','');
INSERT INTO yowao_class VALUES('1709','1131','վѶ','2','10','','','','');
INSERT INTO yowao_class VALUES('2107','1588','վ','1','24','','','','');
INSERT INTO yowao_class VALUES('1131','4','վ','125','0','Jianzhan','','','');
INSERT INTO yowao_class VALUES('1132','1131','ҳ','1','12','','','','');
INSERT INTO yowao_class VALUES('1133','2220','','1','14','','','','');
INSERT INTO yowao_class VALUES('2047','2204','ڵط','3','30','','','','');
INSERT INTO yowao_class VALUES('1138','4','ڿ','105','0','Heike','','','');
INSERT INTO yowao_class VALUES('1139','1138','ڿ/ȫվ','1','11','','','','');
INSERT INTO yowao_class VALUES('1358','1138','ڿ̳','4','7','','','','');
INSERT INTO yowao_class VALUES('2212','1','Ӱ','105','0','movie','','','');
INSERT INTO yowao_class VALUES('1142','2229','ȫ̳','5','6','','','','');
INSERT INTO yowao_class VALUES('1143','2226','Դ','109','0','free','','','');
INSERT INTO yowao_class VALUES('1704','2186','֯','7','13','','','','');
INSERT INTO yowao_class VALUES('2142','1143','Ϣ','2','3','','','','');
INSERT INTO yowao_class VALUES('1147','1143','','4','4','','','','');
INSERT INTO yowao_class VALUES('1705','1082','ר','6','15','','','','');
INSERT INTO yowao_class VALUES('2113','1131','̳ CMS','4','10','','','','');
INSERT INTO yowao_class VALUES('1151','1143','̳','5','4','','','','');
INSERT INTO yowao_class VALUES('1152','4','','124','0','Chengxu','','','');
INSERT INTO yowao_class VALUES('1153','1152','̿','1','13','','','','');
INSERT INTO yowao_class VALUES('1155','2169','ASP','4','17','','','','');
INSERT INTO yowao_class VALUES('1156','2169','Java','12','17','','','','');
INSERT INTO yowao_class VALUES('1157','2169','Linux','13','17','','','','');
INSERT INTO yowao_class VALUES('1158','2169','Delphi','11','8','','','','');
INSERT INTO yowao_class VALUES('1159','2169','C/C++/C#','10','8','','','','');
INSERT INTO yowao_class VALUES('1160','2169','PHP','5','15','','','','');
INSERT INTO yowao_class VALUES('1161','2169','Wap','7','5','','','','');
INSERT INTO yowao_class VALUES('1162','2169','VB','9','10','','','','');
INSERT INTO yowao_class VALUES('1163','2169','JSP','6','8','','','','');
INSERT INTO yowao_class VALUES('2063','2173','طƷ','6','8','','','','');
INSERT INTO yowao_class VALUES('1165','2169','Power Builder','14','7','','','','');
INSERT INTO yowao_class VALUES('1166','2169','ݿ','0','8','','','','');
INSERT INTO yowao_class VALUES('1167','2169','CGI','8','6','','','','');
INSERT INTO yowao_class VALUES('1168','2','','107','0','car','','','');
INSERT INTO yowao_class VALUES('1169','1168','Ѷ','1','37','','','','');
INSERT INTO yowao_class VALUES('1171','1168','̳/ѻ','5','12','','','','');
INSERT INTO yowao_class VALUES('2382','765','ֻ','0','8','','','','');
INSERT INTO yowao_class VALUES('2208','2205','ط֪ʶȨ','100','28','','','','');
INSERT INTO yowao_class VALUES('2200','1121','IT','100','9','','','','');
INSERT INTO yowao_class VALUES('2188','907','Ʒƻ','5','0','','','','');
INSERT INTO yowao_class VALUES('2189','907','ʳס','1','17','','','','');
INSERT INTO yowao_class VALUES('2202','863','','2','3','','','','');
INSERT INTO yowao_class VALUES('2193','820','','100','0','','','','');
INSERT INTO yowao_class VALUES('1251','2','','104','0','jijin','','','');
INSERT INTO yowao_class VALUES('1253','873','ҵҳ','4','10','','','','');
INSERT INTO yowao_class VALUES('2209','674','̳','2','0','','','','');
INSERT INTO yowao_class VALUES('2058','2155','վ','5','18','','','','');
INSERT INTO yowao_class VALUES('1270','2220','վƹ','4','13','','','','');
INSERT INTO yowao_class VALUES('1926','873','','3','18','','','','');
INSERT INTO yowao_class VALUES('2057','2034','йЭCBA','3','9','','','','');
INSERT INTO yowao_class VALUES('1289','950','У','-3','68','','','','');
INSERT INTO yowao_class VALUES('1290','950','У','-1','24','','','','');
INSERT INTO yowao_class VALUES('1291','950','ϺУ','-2','40','','','','');
INSERT INTO yowao_class VALUES('1292','950','ոУ','2','39','','','','');
INSERT INTO yowao_class VALUES('1293','950','㽭У','4','35','','','','');
INSERT INTO yowao_class VALUES('1294','950','У','9','34','','','','');
INSERT INTO yowao_class VALUES('1295','950','㶫У','1','62','','','','');
INSERT INTO yowao_class VALUES('1296','950','У','18','34','','','','');
INSERT INTO yowao_class VALUES('1297','950','ĴУ','8','40','','','','');
INSERT INTO yowao_class VALUES('1298','950','У','0','13','','','','');
INSERT INTO yowao_class VALUES('1299','950','У','7','43','','','','');
INSERT INTO yowao_class VALUES('1300','950','У','12','26','','','','');
INSERT INTO yowao_class VALUES('1301','950','ϸУ','11','31','','','','');
INSERT INTO yowao_class VALUES('1302','950','ɽУ','3','35','','','','');
INSERT INTO yowao_class VALUES('1303','950','ոУ','13','32','','','','');
INSERT INTO yowao_class VALUES('1304','950','ɽУ','19','15','','','','');
INSERT INTO yowao_class VALUES('1305','950','ָУ','16','27','','','','');
INSERT INTO yowao_class VALUES('1306','950','У','10','24','','','','');
INSERT INTO yowao_class VALUES('1307','950','ϸУ','5','32','','','','');
INSERT INTO yowao_class VALUES('1308','950','ӱУ','6','35','','','','');
INSERT INTO yowao_class VALUES('1309','950','ɹŸУ','20','21','','','','');
INSERT INTO yowao_class VALUES('1310','950','У','14','27','','','','');
INSERT INTO yowao_class VALUES('1311','950','У','15','24','','','','');
INSERT INTO yowao_class VALUES('1312','950','ϸУ','24','10','','','','');
INSERT INTO yowao_class VALUES('1313','950','ݸУ','22','16','','','','');
INSERT INTO yowao_class VALUES('1314','950','ϸУ','17','17','','','','');
INSERT INTO yowao_class VALUES('1315','950','ظУ','27','3','','','','');
INSERT INTO yowao_class VALUES('1316','950','У','23','21','','','','');
INSERT INTO yowao_class VALUES('1317','950','ຣУ','25','9','','','','');
INSERT INTO yowao_class VALUES('1318','950','ĸУ','26','10','','','','');
INSERT INTO yowao_class VALUES('1319','950','½У','21','16','','','','');
INSERT INTO yowao_class VALUES('1320','950','۸У','531','15','','','','');
INSERT INTO yowao_class VALUES('1321','2149','211̸У','2','108','','','','');
INSERT INTO yowao_class VALUES('1322','946','ѧ/У','10','0','','','','');
INSERT INTO yowao_class VALUES('1323','950','ŸУ','532','10','','','','');
INSERT INTO yowao_class VALUES('1324','950','̨ʡУ','533','25','','','','');
INSERT INTO yowao_class VALUES('1325','1322','У','1','20','','','','');
INSERT INTO yowao_class VALUES('1326','1322','ӢУ','2','8','','','','');
INSERT INTO yowao_class VALUES('1327','1322','ôУ','3','6','','','','');
INSERT INTO yowao_class VALUES('1328','1322','ձУ','5','16','','','','');
INSERT INTO yowao_class VALUES('1329','1322','¼¸У','4','2','','','','');
INSERT INTO yowao_class VALUES('1330','1322','У','6','10','','','','');
INSERT INTO yowao_class VALUES('1331','1322','ĴǸУ','7','8','','','','');
INSERT INTO yowao_class VALUES('1332','1322','У','8','4','','','','');
INSERT INTO yowao_class VALUES('1342','1322','У','11','8','','','','');
INSERT INTO yowao_class VALUES('1341','1322','¹У','10','12','','','','');
INSERT INTO yowao_class VALUES('1335','1322','ʱУ','12','4','','','','');
INSERT INTO yowao_class VALUES('1336','1322','ʿУ','13','6','','','','');
INSERT INTO yowao_class VALUES('1337','1322','У','14','2','','','','');
INSERT INTO yowao_class VALUES('1338','1322','У','15','2','','','','');
INSERT INTO yowao_class VALUES('1339','1322','У','16','2','','','','');
INSERT INTO yowao_class VALUES('1340','1322','µУ','17','3','','','','');
INSERT INTO yowao_class VALUES('1343','1322','У','9','12','','','','');
INSERT INTO yowao_class VALUES('1345','820','ˮ','4','13','','','','');
INSERT INTO yowao_class VALUES('1346','820','ﱣ','8','8','','','','');
INSERT INTO yowao_class VALUES('1347','820','èè','3','14','','','','');
INSERT INTO yowao_class VALUES('2062','2173','ط','4','9','','','','');
INSERT INTO yowao_class VALUES('2199','4','','102','0','mail','','','');
INSERT INTO yowao_class VALUES('1350','2193','طҽԺ','7','12','','','','');
INSERT INTO yowao_class VALUES('1351','820','','5','3','','','','');
INSERT INTO yowao_class VALUES('2135','776','','2','42','','','','');
INSERT INTO yowao_class VALUES('1359','1138','߹','2','5','','','','');
INSERT INTO yowao_class VALUES('1361','751','̨','10','7','','','','');
INSERT INTO yowao_class VALUES('1362','751','̨','-3','3','','','','');
INSERT INTO yowao_class VALUES('1363','751','Ϻ̨','-2','3','','','','');
INSERT INTO yowao_class VALUES('1364','751','̨','-1','1','','','','');
INSERT INTO yowao_class VALUES('1365','751','ӱ̨','6','5','','','','');
INSERT INTO yowao_class VALUES('1366','751','ɽ̨','3','9','','','','');
INSERT INTO yowao_class VALUES('1367','751','ɽ̨','19','3','','','','');
INSERT INTO yowao_class VALUES('1368','751','ɹŵ̨','20','1','','','','');
INSERT INTO yowao_class VALUES('1369','751','յ̨','2','8','','','','');
INSERT INTO yowao_class VALUES('1370','751','㽭̨','4','8','','','','');
INSERT INTO yowao_class VALUES('1371','751','յ̨','13','4','','','','');
INSERT INTO yowao_class VALUES('1372','751','㶫̨','1','18','','','','');
INSERT INTO yowao_class VALUES('1373','751','̨','15','2','','','','');
INSERT INTO yowao_class VALUES('1374','751','ϵ̨','24','2','','','','');
INSERT INTO yowao_class VALUES('1375','751','ϵ̨','5','9','','','','');
INSERT INTO yowao_class VALUES('1376','751','̨','9','6','','','','');
INSERT INTO yowao_class VALUES('1377','751','ϵ̨','11','3','','','','');
INSERT INTO yowao_class VALUES('1378','751','̨','14','4','','','','');
INSERT INTO yowao_class VALUES('1379','751','̨','7','6','','','','');
INSERT INTO yowao_class VALUES('1380','751','ֵ̨','16','2','','','','');
INSERT INTO yowao_class VALUES('1381','751','̨','12','3','','','','');
INSERT INTO yowao_class VALUES('1382','751','̨','18','4','','','','');
INSERT INTO yowao_class VALUES('1383','751','ĵ̨','26','1','','','','');
INSERT INTO yowao_class VALUES('1384','751','̨','23','3','','','','');
INSERT INTO yowao_class VALUES('1385','751','ຣ̨','25','2','','','','');
INSERT INTO yowao_class VALUES('1386','751','½̨','21','2','','','','');
INSERT INTO yowao_class VALUES('1387','751','̨','0','2','','','','');
INSERT INTO yowao_class VALUES('1388','751','Ĵ̨','8','9','','','','');
INSERT INTO yowao_class VALUES('1389','751','ݵ̨','22','6','','','','');
INSERT INTO yowao_class VALUES('1390','751','ϵ̨','17','10','','','','');
INSERT INTO yowao_class VALUES('1391','751','ص̨','27','1','','','','');
INSERT INTO yowao_class VALUES('1392','751','̨̨','28','7','','','','');
INSERT INTO yowao_class VALUES('1393','751','۵̨','29','6','','','','');
INSERT INTO yowao_class VALUES('1394','751','ŵ̨','30','2','','','','');
INSERT INTO yowao_class VALUES('1518','959','㶫˲','1','19','','','','');
INSERT INTO yowao_class VALUES('1925','1082','','13','6','','','','');
INSERT INTO yowao_class VALUES('1519','959','˲','-3','22','','','','');
INSERT INTO yowao_class VALUES('1520','959','Ĵ˲','8','12','','','','');
INSERT INTO yowao_class VALUES('1521','959','ຣ˲','25','10','','','','');
INSERT INTO yowao_class VALUES('1522','959','½˲','21','11','','','','');
INSERT INTO yowao_class VALUES('1523','959','˲','17','14','','','','');
INSERT INTO yowao_class VALUES('1524','959','˲','23','11','','','','');
INSERT INTO yowao_class VALUES('1525','959','˲','12','10','','','','');
INSERT INTO yowao_class VALUES('1526','959','ɽ˲','3','13','','','','');
INSERT INTO yowao_class VALUES('1527','959','˲','2','27','','','','');
INSERT INTO yowao_class VALUES('1528','959','㽭˲','4','21','','','','');
INSERT INTO yowao_class VALUES('1529','959','Ϻ˲','-2','17','','','','');
INSERT INTO yowao_class VALUES('1530','959','˲','14','7','','','','');
INSERT INTO yowao_class VALUES('1531','959','˲','10','13','','','','');
INSERT INTO yowao_class VALUES('1532','959','ɹ˲','20','16','','','','');
INSERT INTO yowao_class VALUES('1533','959','˲','27','7','','','','');
INSERT INTO yowao_class VALUES('1534','959','ӱ˲','6','9','','','','');
INSERT INTO yowao_class VALUES('1535','959','˲','5','7','','','','');
INSERT INTO yowao_class VALUES('1536','959','˲','26','13','','','','');
INSERT INTO yowao_class VALUES('1537','959','˲','18','14','','','','');
INSERT INTO yowao_class VALUES('1538','959','˲','0','9','','','','');
INSERT INTO yowao_class VALUES('1539','959','˲','24','11','','','','');
INSERT INTO yowao_class VALUES('1540','959','˲','22','14','','','','');
INSERT INTO yowao_class VALUES('1541','959','˲','7','11','','','','');
INSERT INTO yowao_class VALUES('1542','959','˲','16','14','','','','');
INSERT INTO yowao_class VALUES('1543','959','˲','13','11','','','','');
INSERT INTO yowao_class VALUES('1544','959','˲','11','12','','','','');
INSERT INTO yowao_class VALUES('1545','959','˲','9','9','','','','');
INSERT INTO yowao_class VALUES('1546','959','ɽ˲','19','11','','','','');
INSERT INTO yowao_class VALUES('1547','959','˲','-1','11','','','','');
INSERT INTO yowao_class VALUES('1554','838','Ϻ','-2','38','','','','');
INSERT INTO yowao_class VALUES('1553','838','','-3','17','','','','');
INSERT INTO yowao_class VALUES('1555','838','򱨿','-1','4','','','','');
INSERT INTO yowao_class VALUES('1551','959','˲','15','15','','','','');
INSERT INTO yowao_class VALUES('1552','959','۰̨˲','28','15','','','','');
INSERT INTO yowao_class VALUES('1556','838','챨','0','7','','','','');
INSERT INTO yowao_class VALUES('1557','838','㶫','1','49','','','','');
INSERT INTO yowao_class VALUES('1558','838','ձ','2','11','','','','');
INSERT INTO yowao_class VALUES('1559','838','ɽ','3','28','','','','');
INSERT INTO yowao_class VALUES('1560','838','㽭','4','30','','','','');
INSERT INTO yowao_class VALUES('1561','838','ϱ','5','18','','','','');
INSERT INTO yowao_class VALUES('1562','838','ӱ','6','9','','','','');
INSERT INTO yowao_class VALUES('1563','838','','7','19','','','','');
INSERT INTO yowao_class VALUES('1564','838','Ĵ','8','23','','','','');
INSERT INTO yowao_class VALUES('1565','838','','9','18','','','','');
INSERT INTO yowao_class VALUES('1566','838','','10','25','','','','');
INSERT INTO yowao_class VALUES('1567','838','ϱ','11','19','','','','');
INSERT INTO yowao_class VALUES('1568','838','','12','5','','','','');
INSERT INTO yowao_class VALUES('1569','838','ձ','13','13','','','','');
INSERT INTO yowao_class VALUES('1570','838','','14','8','','','','');
INSERT INTO yowao_class VALUES('1571','838','','15','15','','','','');
INSERT INTO yowao_class VALUES('1572','838','ֱ','16','9','','','','');
INSERT INTO yowao_class VALUES('1573','838','ϱ','17','10','','','','');
INSERT INTO yowao_class VALUES('1574','838','','18','9','','','','');
INSERT INTO yowao_class VALUES('1575','838','ɽ','19','14','','','','');
INSERT INTO yowao_class VALUES('1576','838','ɹű','20','4','','','','');
INSERT INTO yowao_class VALUES('1577','838','½','21','0','','','','');
INSERT INTO yowao_class VALUES('1578','838','ݱ','22','6','','','','');
INSERT INTO yowao_class VALUES('1579','838','౨','23','3','','','','');
INSERT INTO yowao_class VALUES('1580','838','ϱ','24','8','','','','');
INSERT INTO yowao_class VALUES('1581','838','ຣ','25','1','','','','');
INSERT INTO yowao_class VALUES('1582','838','ı','26','3','','','','');
INSERT INTO yowao_class VALUES('1583','838','ر','27','1','','','','');
INSERT INTO yowao_class VALUES('1584','838','۱','28','7','','','','');
INSERT INTO yowao_class VALUES('1585','838','ű','29','5','','','','');
INSERT INTO yowao_class VALUES('1586','838','̨屨','30','6','','','','');
INSERT INTO yowao_class VALUES('1938','1936','̳','3','5','','','','');
INSERT INTO yowao_class VALUES('1588','4','','123','0','design','','','');
INSERT INTO yowao_class VALUES('1597','1596','WAP','1','5','','','','');
INSERT INTO yowao_class VALUES('1598','1596','ۺŻ','2','25','','','','');
INSERT INTO yowao_class VALUES('1599','1596','̳','5','18','','','','');
INSERT INTO yowao_class VALUES('1600','1596','ͼ','3','13','','','','');
INSERT INTO yowao_class VALUES('1601','1596','ƶ','4','18','','','','');
INSERT INTO yowao_class VALUES('1604','755','Ϻ̨','3','6','','','','');
INSERT INTO yowao_class VALUES('1605','755','̨','2','7','','','','');
INSERT INTO yowao_class VALUES('1606','755','ӱ̨','100','5','','','','');
INSERT INTO yowao_class VALUES('1607','755','ɽ̨','100','11','','','','');
INSERT INTO yowao_class VALUES('1608','755','ɽ̨','100','4','','','','');
INSERT INTO yowao_class VALUES('1609','755','ɹŵ̨','104','3','','','','');
INSERT INTO yowao_class VALUES('1610','755','յ̨','100','9','','','','');
INSERT INTO yowao_class VALUES('1611','755','㽭̨','100','8','','','','');
INSERT INTO yowao_class VALUES('1612','755','յ̨','100','1','','','','');
INSERT INTO yowao_class VALUES('1613','755','̨','100','9','','','','');
INSERT INTO yowao_class VALUES('1614','755','㶫̨','100','12','','','','');
INSERT INTO yowao_class VALUES('1615','755','̨','100','2','','','','');
INSERT INTO yowao_class VALUES('1616','755','ϵ̨','100','7','','','','');
INSERT INTO yowao_class VALUES('1617','755','̨','100','7','','','','');
INSERT INTO yowao_class VALUES('1618','755','ϵ̨','100','4','','','','');
INSERT INTO yowao_class VALUES('1619','755','̨','100','5','','','','');
INSERT INTO yowao_class VALUES('1620','755','̨','100','6','','','','');
INSERT INTO yowao_class VALUES('1621','755','ֵ̨','100','2','','','','');
INSERT INTO yowao_class VALUES('1622','755','̨','100','2','','','','');
INSERT INTO yowao_class VALUES('1623','755','̨','100','4','','','','');
INSERT INTO yowao_class VALUES('1624','755','ĵ̨','100','1','','','','');
INSERT INTO yowao_class VALUES('1625','755','̨','100','1','','','','');
INSERT INTO yowao_class VALUES('1626','755','ຣ̨','101','1','','','','');
INSERT INTO yowao_class VALUES('1627','755','½̨','102','3','','','','');
INSERT INTO yowao_class VALUES('1628','755','̨','100','0','','','','');
INSERT INTO yowao_class VALUES('1629','755','Ĵ̨','100','3','','','','');
INSERT INTO yowao_class VALUES('1630','755','ݵ̨','100','2','','','','');
INSERT INTO yowao_class VALUES('1631','755','ϵ̨','100','2','','','','');
INSERT INTO yowao_class VALUES('1632','755','ص̨','103','0','','','','');
INSERT INTO yowao_class VALUES('1633','755','̨̨','100','0','','','','');
INSERT INTO yowao_class VALUES('1634','755','۵̨','100','1','','','','');
INSERT INTO yowao_class VALUES('1635','755','ŵ̨','105','1','','','','');
INSERT INTO yowao_class VALUES('1645','1251','','1','11','','','','');
INSERT INTO yowao_class VALUES('2381','765','ֻͼ','0','1','','','','');
INSERT INTO yowao_class VALUES('2380','765','ֻԴ','0','21','','','','');
INSERT INTO yowao_class VALUES('2379','878','ҵ','0','9','','','','');
INSERT INTO yowao_class VALUES('1649','1251','˾','3','39','','','','');
INSERT INTO yowao_class VALUES('1687','2204','۰̨','4','20','','','','');
INSERT INTO yowao_class VALUES('1662','1168','۽','2','5','','','','');
INSERT INTO yowao_class VALUES('1664','1168','ط','3','12','','','','');
INSERT INTO yowao_class VALUES('1666','1168','ų','6','68','','','','');
INSERT INTO yowao_class VALUES('1670','2150','','12','14','','','','');
INSERT INTO yowao_class VALUES('1671','2150','','11','21','','','','');
INSERT INTO yowao_class VALUES('1672','2223','赸','2','6','','','','');
INSERT INTO yowao_class VALUES('1673','2150','','10','12','','','','');
INSERT INTO yowao_class VALUES('1675','2150','ˮ˶','23','8','','','','');
INSERT INTO yowao_class VALUES('1676','2150','ѩ˶','22','4','','','','');
INSERT INTO yowao_class VALUES('1677','2150','','21','7','','','','');
INSERT INTO yowao_class VALUES('1678','927','','20','4','','','','');
INSERT INTO yowao_class VALUES('2152','1020','Ʊ','2','2','','','','');
INSERT INTO yowao_class VALUES('1680','2223','','3','15','','','','');
INSERT INTO yowao_class VALUES('2168','725','','100','0','','','','');
INSERT INTO yowao_class VALUES('1682','1682','ɼ','6','0','Wangba_Lianmeng','','','');
INSERT INTO yowao_class VALUES('2092','2091','йͨ','100','30','','','','');
INSERT INTO yowao_class VALUES('1690','946','йѧа','3','5','','','','');
INSERT INTO yowao_class VALUES('1691','2246','У԰ۺ','1','12','','','','');
INSERT INTO yowao_class VALUES('1700','1682','ۺ','1','30','','','','');
INSERT INTO yowao_class VALUES('1701','1143','߷','3','13','','','','');
INSERT INTO yowao_class VALUES('1702','2199','Ӳ','2','8','','','','');
INSERT INTO yowao_class VALUES('1706','1082','֯','7','29','','','','');
INSERT INTO yowao_class VALUES('1707','1082','˾','12','34','','','','');
INSERT INTO yowao_class VALUES('1714','1076','MP3','2','5','','','','');
INSERT INTO yowao_class VALUES('1715','1076','ѵ½','4','2','','','','');
INSERT INTO yowao_class VALUES('1716','1152','Դ','2','14','','','','');
INSERT INTO yowao_class VALUES('2138','851','','10','9','','','','');
INSERT INTO yowao_class VALUES('2053','2050','ξ','3','2','','','','');
INSERT INTO yowao_class VALUES('1720','851','֧','9','10','pay_tools','','','');
INSERT INTO yowao_class VALUES('1722','871','ҽԺ','2','11','','','','');
INSERT INTO yowao_class VALUES('1723','871','ӱҽԺ','100','12','','','','');
INSERT INTO yowao_class VALUES('1724','871','ɽҽԺ','100','6','','','','');
INSERT INTO yowao_class VALUES('1725','871','ɹҽԺ','100','3','','','','');
INSERT INTO yowao_class VALUES('1726','871','ҽԺ','100','12','','','','');
INSERT INTO yowao_class VALUES('1727','871','ҽԺ','100','9','','','','');
INSERT INTO yowao_class VALUES('1728','871','ҽԺ','100','12','','','','');
INSERT INTO yowao_class VALUES('1729','871','ϺҽԺ','3','32','','','','');
INSERT INTO yowao_class VALUES('1730','871','ҽԺ','100','24','','','','');
INSERT INTO yowao_class VALUES('1731','871','㽭ҽԺ','100','14','','','','');
INSERT INTO yowao_class VALUES('1732','871','ҽԺ','100','7','','','','');
INSERT INTO yowao_class VALUES('1733','871','ҽԺ','100','21','','','','');
INSERT INTO yowao_class VALUES('1734','871','ҽԺ','100','11','','','','');
INSERT INTO yowao_class VALUES('1735','871','ɽҽԺ','100','10','','','','');
INSERT INTO yowao_class VALUES('1736','871','ҽԺ','100','10','','','','');
INSERT INTO yowao_class VALUES('1737','871','ҽԺ','100','10','','','','');
INSERT INTO yowao_class VALUES('1738','871','ҽԺ','100','7','','','','');
INSERT INTO yowao_class VALUES('1739','871','㶫ҽԺ','100','30','','','','');
INSERT INTO yowao_class VALUES('1740','871','ҽԺ','100','8','','','','');
INSERT INTO yowao_class VALUES('1741','871','ҽԺ','100','5','','','','');
INSERT INTO yowao_class VALUES('1742','871','ҽԺ','100','5','','','','');
INSERT INTO yowao_class VALUES('1743','871','ĴҽԺ','100','2','','','','');
INSERT INTO yowao_class VALUES('1744','871','ҽԺ','100','6','','','','');
INSERT INTO yowao_class VALUES('1745','871','ҽԺ','100','6','','','','');
INSERT INTO yowao_class VALUES('1746','871','ҽԺ','100','1','','','','');
INSERT INTO yowao_class VALUES('1747','871','ҽԺ','100','4','','','','');
INSERT INTO yowao_class VALUES('1748','871','ҽԺ','100','3','','','','');
INSERT INTO yowao_class VALUES('1749','871','ҽԺ','100','4','','','','');
INSERT INTO yowao_class VALUES('1750','871','½ҽԺ','100','2','','','','');
INSERT INTO yowao_class VALUES('1751','871','ҽԺ','101','3','','','','');
INSERT INTO yowao_class VALUES('1752','871','ҽԺ','102','4','','','','');
INSERT INTO yowao_class VALUES('1753','871','̨ҽԺ','103','6','','','','');
INSERT INTO yowao_class VALUES('1754','871','ຣҽԺ','100','2','','','','');
INSERT INTO yowao_class VALUES('2201','734','ݳƷ','3','5','','','','');
INSERT INTO yowao_class VALUES('1756','2159','о','16','26','','','','');
INSERT INTO yowao_class VALUES('1757','2159','Ƽվ','18','28','','','','');
INSERT INTO yowao_class VALUES('1758','2159','ѧо','15','18','','','','');
INSERT INTO yowao_class VALUES('2056','2155','NBA','4','29','','','','');
INSERT INTO yowao_class VALUES('1762','1761','','1','8','','','','');
INSERT INTO yowao_class VALUES('1763','1761','򷿲','2','3','','','','');
INSERT INTO yowao_class VALUES('1764','1761','ӱ','99','2','','','','');
INSERT INTO yowao_class VALUES('1765','1761','ɽ','100','1','','','','');
INSERT INTO yowao_class VALUES('1766','1761','ɹŷ','104','1','','','','');
INSERT INTO yowao_class VALUES('1767','1761','','99','7','','','','');
INSERT INTO yowao_class VALUES('1768','1761','ַ','100','1','','','','');
INSERT INTO yowao_class VALUES('1769','1761','','100','2','','','','');
INSERT INTO yowao_class VALUES('1770','1761','Ϻ','3','13','','','','');
INSERT INTO yowao_class VALUES('1771','1761','շ','99','8','','','','');
INSERT INTO yowao_class VALUES('1772','1761','㽭','99','7','','','','');
INSERT INTO yowao_class VALUES('1773','1761','շ','100','3','','','','');
INSERT INTO yowao_class VALUES('1774','1761','','99','12','','','','');
INSERT INTO yowao_class VALUES('1775','1761','','99','5','','','','');
INSERT INTO yowao_class VALUES('1776','1761','ɽ','99','10','','','','');
INSERT INTO yowao_class VALUES('1777','1761','Ϸ','99','4','','','','');
INSERT INTO yowao_class VALUES('1778','1761','','99','4','','','','');
INSERT INTO yowao_class VALUES('1779','1761','Ϸ','99','1','','','','');
INSERT INTO yowao_class VALUES('1780','1761','㶫','99','12','','','','');
INSERT INTO yowao_class VALUES('1781','1761','','99','6','','','','');
INSERT INTO yowao_class VALUES('1782','1761','Ϸ','100','2','','','','');
INSERT INTO yowao_class VALUES('1783','1761','췿','100','2','','','','');
INSERT INTO yowao_class VALUES('1784','1761','Ĵ','100','4','','','','');
INSERT INTO yowao_class VALUES('1785','1761','ݷ','100','1','','','','');
INSERT INTO yowao_class VALUES('1786','1761','Ϸ','100','2','','','','');
INSERT INTO yowao_class VALUES('1787','1761','ط','100','1','','','','');
INSERT INTO yowao_class VALUES('1788','1761','','99','3','','','','');
INSERT INTO yowao_class VALUES('1789','1761','෿','100','2','','','','');
INSERT INTO yowao_class VALUES('1790','1761','ຣ','101','2','','','','');
INSERT INTO yowao_class VALUES('1791','1761','ķ','100','1','','','','');
INSERT INTO yowao_class VALUES('1792','1761','½','102','1','','','','');
INSERT INTO yowao_class VALUES('1793','1761','۷','105','0','','','','');
INSERT INTO yowao_class VALUES('1794','1761','̨巿','106','0','','','','');
INSERT INTO yowao_class VALUES('1797','893','','1','23','','','','');
INSERT INTO yowao_class VALUES('1798','893','','2','10','','','','');
INSERT INTO yowao_class VALUES('1799','893','ӱ','100','5','','','','');
INSERT INTO yowao_class VALUES('1800','893','ɽ','100','8','','','','');
INSERT INTO yowao_class VALUES('1801','893','ɹ','100','5','','','','');
INSERT INTO yowao_class VALUES('1802','893','','100','17','','','','');
INSERT INTO yowao_class VALUES('1803','893','','100','8','','','','');
INSERT INTO yowao_class VALUES('1804','893','','100','15','','','','');
INSERT INTO yowao_class VALUES('1805','893','Ϻ','3','10','','','','');
INSERT INTO yowao_class VALUES('1806','893','','100','29','','','','');
INSERT INTO yowao_class VALUES('1807','893','㽭','100','20','','','','');
INSERT INTO yowao_class VALUES('1808','893','','100','15','','','','');
INSERT INTO yowao_class VALUES('1809','893','','100','19','','','','');
INSERT INTO yowao_class VALUES('1810','893','','100','15','','','','');
INSERT INTO yowao_class VALUES('1811','893','ɽ','100','12','','','','');
INSERT INTO yowao_class VALUES('1812','893','','100','18','','','','');
INSERT INTO yowao_class VALUES('1813','893','','100','14','','','','');
INSERT INTO yowao_class VALUES('1814','893','','100','22','','','','');
INSERT INTO yowao_class VALUES('1815','893','㶫','100','18','','','','');
INSERT INTO yowao_class VALUES('1816','893','','100','21','','','','');
INSERT INTO yowao_class VALUES('1817','893','','100','18','','','','');
INSERT INTO yowao_class VALUES('1818','893','','100','12','','','','');
INSERT INTO yowao_class VALUES('1819','893','Ĵ','100','31','','','','');
INSERT INTO yowao_class VALUES('1820','893','','100','14','','','','');
INSERT INTO yowao_class VALUES('1821','893','','100','15','','','','');
INSERT INTO yowao_class VALUES('1822','893','','100','11','','','','');
INSERT INTO yowao_class VALUES('1823','893','','100','12','','','','');
INSERT INTO yowao_class VALUES('1824','893','','100','10','','','','');
INSERT INTO yowao_class VALUES('1825','893','ຣ','100','8','','','','');
INSERT INTO yowao_class VALUES('1826','893','','100','9','','','','');
INSERT INTO yowao_class VALUES('1827','893','½','100','12','','','','');
INSERT INTO yowao_class VALUES('1828','893','','101','11','','','','');
INSERT INTO yowao_class VALUES('1829','893','','102','5','','','','');
INSERT INTO yowao_class VALUES('1830','893','̨','103','10','','','','');
INSERT INTO yowao_class VALUES('1832','905','޵','100','20','','','','');
INSERT INTO yowao_class VALUES('1833','905','ŷ޵','100','46','','','','');
INSERT INTO yowao_class VALUES('1834','905','','100','11','','','','');
INSERT INTO yowao_class VALUES('1835','905','','100','4','','','','');
INSERT INTO yowao_class VALUES('1836','905','޵','100','3','','','','');
INSERT INTO yowao_class VALUES('1837','905','','100','3','','','','');
INSERT INTO yowao_class VALUES('1838','902','','1','19','','','','');
INSERT INTO yowao_class VALUES('1839','902','','2','11','','','','');
INSERT INTO yowao_class VALUES('1840','902','ӱ','100','12','','','','');
INSERT INTO yowao_class VALUES('1841','902','ɽ','100','11','','','','');
INSERT INTO yowao_class VALUES('1842','902','ɹ','103','15','','','','');
INSERT INTO yowao_class VALUES('1843','902','','100','12','','','','');
INSERT INTO yowao_class VALUES('1844','902','','100','9','','','','');
INSERT INTO yowao_class VALUES('1845','902','','100','12','','','','');
INSERT INTO yowao_class VALUES('1846','902','Ϻ','3','18','','','','');
INSERT INTO yowao_class VALUES('1847','902','','100','14','','','','');
INSERT INTO yowao_class VALUES('1848','902','㽭','100','11','','','','');
INSERT INTO yowao_class VALUES('1849','902','','100','18','','','','');
INSERT INTO yowao_class VALUES('1850','902','','100','10','','','','');
INSERT INTO yowao_class VALUES('1851','902','','100','11','','','','');
INSERT INTO yowao_class VALUES('1852','902','ɽ','100','17','','','','');
INSERT INTO yowao_class VALUES('1853','902','','100','18','','','','');
INSERT INTO yowao_class VALUES('1854','902','','100','16','','','','');
INSERT INTO yowao_class VALUES('1855','902','','100','9','','','','');
INSERT INTO yowao_class VALUES('1856','902','㶫','100','20','','','','');
INSERT INTO yowao_class VALUES('1857','902','','100','10','','','','');
INSERT INTO yowao_class VALUES('1858','902','','100','7','','','','');
INSERT INTO yowao_class VALUES('1859','902','','100','16','','','','');
INSERT INTO yowao_class VALUES('1860','902','Ĵ','100','19','','','','');
INSERT INTO yowao_class VALUES('1861','902','','100','16','','','','');
INSERT INTO yowao_class VALUES('1862','902','','100','16','','','','');
INSERT INTO yowao_class VALUES('1863','902','','100','3','','','','');
INSERT INTO yowao_class VALUES('1864','902','','100','20','','','','');
INSERT INTO yowao_class VALUES('1865','902','','100','13','','','','');
INSERT INTO yowao_class VALUES('1866','902','ຣ','101','4','','','','');
INSERT INTO yowao_class VALUES('1867','902','','100','5','','','','');
INSERT INTO yowao_class VALUES('1868','902','½','102','0','','','','');
INSERT INTO yowao_class VALUES('1869','902','','104','11','','','','');
INSERT INTO yowao_class VALUES('1870','902','','105','12','','','','');
INSERT INTO yowao_class VALUES('1871','2188','Ʒ','5','58','','','','');
INSERT INTO yowao_class VALUES('1872','2188','ʳƷ','2','37','','','','');
INSERT INTO yowao_class VALUES('1873','2188','','3','20','','','','');
INSERT INTO yowao_class VALUES('1874','2188','Ʒ','7','18','','','','');
INSERT INTO yowao_class VALUES('1875','2188','ҵƷ','8','44','','','','');
INSERT INTO yowao_class VALUES('1876','2188','ƷƵ','9','18','','','','');
INSERT INTO yowao_class VALUES('1877','2188','ֻƷ','6','14','','','','');
INSERT INTO yowao_class VALUES('1878','912','վ','2','25','','','','');
INSERT INTO yowao_class VALUES('1880','2205','̱귨','6','17','','','','');
INSERT INTO yowao_class VALUES('1884','2225','','6','5','','','','');
INSERT INTO yowao_class VALUES('2198','4','','104','0','computer','','','');
INSERT INTO yowao_class VALUES('1921','2168','ԺУ','6','9','','','','');
INSERT INTO yowao_class VALUES('1934','2209','Ů̳','18','8','','','','');
INSERT INTO yowao_class VALUES('1935','2209','̳','19','8','','','','');
INSERT INTO yowao_class VALUES('1939','1936','ӱ̳','14','8','','','','');
INSERT INTO yowao_class VALUES('1940','1936','ɽ̳','13','8','','','','');
INSERT INTO yowao_class VALUES('1941','1936','ɹ̳','31','4','','','','');
INSERT INTO yowao_class VALUES('1942','1936','̳','25','7','','','','');
INSERT INTO yowao_class VALUES('1943','1936','̳','16','3','','','','');
INSERT INTO yowao_class VALUES('1944','1936','̳','5','4','','','','');
INSERT INTO yowao_class VALUES('1945','1936','Ϻ̳','2','10','','','','');
INSERT INTO yowao_class VALUES('1946','1936','̳','17','15','','','','');
INSERT INTO yowao_class VALUES('1947','1936','㽭̳','18','17','','','','');
INSERT INTO yowao_class VALUES('1948','1936','̳','19','12','','','','');
INSERT INTO yowao_class VALUES('1949','1936','̳','20','17','','','','');
INSERT INTO yowao_class VALUES('1950','1936','̳','21','4','','','','');
INSERT INTO yowao_class VALUES('1951','1936','ɽ̳','22','17','','','','');
INSERT INTO yowao_class VALUES('1952','1936','̳','23','9','','','','');
INSERT INTO yowao_class VALUES('1953','1936','̳','24','12','','','','');
INSERT INTO yowao_class VALUES('1954','1936','̳','27','7','','','','');
INSERT INTO yowao_class VALUES('1955','1936','㶫̳','8','18','','','','');
INSERT INTO yowao_class VALUES('1956','1936','̳','26','7','','','','');
INSERT INTO yowao_class VALUES('1957','1936','̳','15','5','','','','');
INSERT INTO yowao_class VALUES('1958','1936','̳','4','6','','','','');
INSERT INTO yowao_class VALUES('1959','1936','Ĵ̳','6','6','','','','');
INSERT INTO yowao_class VALUES('1960','1936','̳','7','4','','','','');
INSERT INTO yowao_class VALUES('1961','1936','̳','28','3','','','','');
INSERT INTO yowao_class VALUES('1962','1936','̳','30','2','','','','');
INSERT INTO yowao_class VALUES('1963','1936','̳','8','5','','','','');
INSERT INTO yowao_class VALUES('1964','1936','̳','9','5','','','','');
INSERT INTO yowao_class VALUES('1965','1936','ຣ̳','10','2','','','','');
INSERT INTO yowao_class VALUES('1966','1936','̳','11','6','','','','');
INSERT INTO yowao_class VALUES('1967','1936','½̳','29','5','','','','');
INSERT INTO yowao_class VALUES('1968','1936','̳','101','4','','','','');
INSERT INTO yowao_class VALUES('1969','1936','̳','102','3','','','','');
INSERT INTO yowao_class VALUES('1970','1936','̨̳','103','1','','','','');
INSERT INTO yowao_class VALUES('1979','2209','̳','21','19','','','','');
INSERT INTO yowao_class VALUES('1980','2212','Ӱ','5','3','','','','');
INSERT INTO yowao_class VALUES('2272','2034','NBAֱ','0','3','','','','');
INSERT INTO yowao_class VALUES('1984','1076','߼','6','5','','','','');
INSERT INTO yowao_class VALUES('1985','2091','йƶ','6','34','','','','');
INSERT INTO yowao_class VALUES('1986','2091','йͨ','7','28','','','','');
INSERT INTO yowao_class VALUES('2169','1152','ѧϰ','3','0','','','','');
INSERT INTO yowao_class VALUES('1988','2091','йص','5','29','','','','');
INSERT INTO yowao_class VALUES('2276','831','ʱ̳','3','5','','','','');
INSERT INTO yowao_class VALUES('1990','851','Ʒ','2','24','','','','');
INSERT INTO yowao_class VALUES('1991','851','/ҵ','3','4','','','','');
INSERT INTO yowao_class VALUES('1992','851','Ů/ĸӤ','5','9','','','','');
INSERT INTO yowao_class VALUES('2052','2050','ŷξ','2','13','','','','');
INSERT INTO yowao_class VALUES('1995','856','չ˾','4','10','','','','');
INSERT INTO yowao_class VALUES('1997','1251','ƽ','4','8','','','','');
INSERT INTO yowao_class VALUES('2204','856','','6','0','','','','');
INSERT INTO yowao_class VALUES('2000','1044','Ӣѧϰ̳','3','4','','','','');
INSERT INTO yowao_class VALUES('2263','3','߿','5','0','gaokao','','','');
INSERT INTO yowao_class VALUES('2003','2161','רҵ࿼','12','20','','','','');
INSERT INTO yowao_class VALUES('2004','1082','ͨѶ','10','22','','','','');
INSERT INTO yowao_class VALUES('2030','1596','Ӱ','8','10','','','','');
INSERT INTO yowao_class VALUES('2044','741','츨','3','14','','','','');
INSERT INTO yowao_class VALUES('2148','842','/̳/','100','13','','','','');
INSERT INTO yowao_class VALUES('2147','1095','Ӳ','100','0','','','','');
INSERT INTO yowao_class VALUES('2091','2','ͨ','120','0','tongxin','','','');
INSERT INTO yowao_class VALUES('2094','2149','йԺ','8','14','','','','');
INSERT INTO yowao_class VALUES('2114','2220','ͳ','3','9','','','','');
INSERT INTO yowao_class VALUES('2099','2212','','9','6','','','','');
INSERT INTO yowao_class VALUES('2106','1588','ز','0','16','','','','');
INSERT INTO yowao_class VALUES('2109','2220','վ','2','9','','','','');
INSERT INTO yowao_class VALUES('2115','2155','Э','6','14','','','','');
INSERT INTO yowao_class VALUES('2116','2034','','2','9','','','','');
INSERT INTO yowao_class VALUES('2121','652','Ӱۺ','1','12','','','','');
INSERT INTO yowao_class VALUES('2122','652','Ӱ̳','3','7','','','','');
INSERT INTO yowao_class VALUES('2144','1711','Ʒ','1','39','','','','');
INSERT INTO yowao_class VALUES('2139','856','ÿѶ','5','4','','','','');
INSERT INTO yowao_class VALUES('2286','2216','Ԥ','0','35','','','','');
INSERT INTO yowao_class VALUES('2141','698','ҳϷ','3','24','','','','');
INSERT INTO yowao_class VALUES('2161','3','','4','0','kaoshi','','','');
INSERT INTO yowao_class VALUES('2166','2224','˹ַ','4','4','','','','');
INSERT INTO yowao_class VALUES('2171','2169','Ajax','100','2','','','','');
INSERT INTO yowao_class VALUES('2172','824','ȫӴ','3','0','','','','');
INSERT INTO yowao_class VALUES('2173','924','طƷ/Ʒ','100','0','','','','');
INSERT INTO yowao_class VALUES('2174','924','ʻ','2','5','','','','');
INSERT INTO yowao_class VALUES('2177','1168','','6','16','','','','');
INSERT INTO yowao_class VALUES('2178','899','һ','0','4','','','','');
INSERT INTO yowao_class VALUES('2179','899','й','2','0','','','','');
INSERT INTO yowao_class VALUES('2180','899','Ժɲ','1','23','','','','');
INSERT INTO yowao_class VALUES('2182','2179','Ժֱ','100','20','','','','');
INSERT INTO yowao_class VALUES('2183','2179','Ժ»','100','4','','','','');
INSERT INTO yowao_class VALUES('2184','2179','Ժҵλ','100','27','','','','');
INSERT INTO yowao_class VALUES('2185','2179','ԺίҾ','100','10','','','','');
INSERT INTO yowao_class VALUES('2186','899','/֯','4','0','','','','');
INSERT INTO yowao_class VALUES('2215','1','СϷ','121','0','xiaoyouxi','','','');
INSERT INTO yowao_class VALUES('2216','2','','101','0','weather','','','');
INSERT INTO yowao_class VALUES('2217','2','ѯ','102','0','tool','','','');
INSERT INTO yowao_class VALUES('2218','2','Ů','114','0','lady','','','');
INSERT INTO yowao_class VALUES('2219','4','','107','0','desktop','','','');
INSERT INTO yowao_class VALUES('2240','2239','ͨ','100','8','','','','');
INSERT INTO yowao_class VALUES('2223','3','','10','0','quyi','','','');
INSERT INTO yowao_class VALUES('2224','3','ڽ','14','0','zongjiao','','','');
INSERT INTO yowao_class VALUES('2225','3','','15','0','gongyi','','','');
INSERT INTO yowao_class VALUES('2226','0','','5','0','','','','');
INSERT INTO yowao_class VALUES('2241','2239','','100','10','','','','');
INSERT INTO yowao_class VALUES('2228','2226','ҵ','104','0','hangye','','','');
INSERT INTO yowao_class VALUES('2229','2226','ɱ','108','0','shadu','','','');
INSERT INTO yowao_class VALUES('2234','2218','ʿ','100','7','','','','');
INSERT INTO yowao_class VALUES('2235','662','̳','3','3','','','','');
INSERT INTO yowao_class VALUES('2236','662','ʿŮ','4','10','','','','');
INSERT INTO yowao_class VALUES('2237','2223','ħӼ','4','5','','','','');
INSERT INTO yowao_class VALUES('2238','2223','طϷ','5','11','','','','');
INSERT INTO yowao_class VALUES('2292','2217','ѯ','5','9','','','','');
INSERT INTO yowao_class VALUES('2246','3','У԰','9','0','xiaoyuan','','','');
INSERT INTO yowao_class VALUES('2253','698','СϷ','2','9','','','','');
INSERT INTO yowao_class VALUES('2255','2215','רƼ','100','46','','','','');
INSERT INTO yowao_class VALUES('2256','2215','Flash','100','8','','','','');
INSERT INTO yowao_class VALUES('2261','2226','վ','119','0','cool','','','');
INSERT INTO yowao_class VALUES('2262','2261','Ȥ̽','100','19','','','','');
INSERT INTO yowao_class VALUES('2264','3','','6','0','kaoyan','','','');
INSERT INTO yowao_class VALUES('2268','2229','ľ/ɱ','100','11','','','','');
INSERT INTO yowao_class VALUES('2295','2294','2121','0','0','2312','','','');
INSERT INTO yowao_class VALUES('2296','2228','ҵó','0','54','','','','');
INSERT INTO yowao_class VALUES('2297','2228','ũ','0','69','','','','');
INSERT INTO yowao_class VALUES('2298','2228','װЬñ','0','41','','','','');
INSERT INTO yowao_class VALUES('2299','2228','ӵ繤','0','33','','','','');
INSERT INTO yowao_class VALUES('2300','2228','','0','52','','','','');
INSERT INTO yowao_class VALUES('2301','2228','ʳƷ','0','62','','','','');
INSERT INTO yowao_class VALUES('2302','2228','Դ','0','49','','','','');
INSERT INTO yowao_class VALUES('2303','2228','ҵ','0','13','','','','');
INSERT INTO yowao_class VALUES('2304','2228','ͨ','0','45','','','','');
INSERT INTO yowao_class VALUES('2305','2228','еǱ','0','26','','','','');
INSERT INTO yowao_class VALUES('2306','2228','ѧҵ','0','36','','','','');
INSERT INTO yowao_class VALUES('2307','2228','ұ','0','52','','','','');
INSERT INTO yowao_class VALUES('2308','2228','Ӫ','0','19','','','','');
INSERT INTO yowao_class VALUES('2309','2228','ڹ','0','44','','','','');
INSERT INTO yowao_class VALUES('2310','2228','ͨŷ','0','126','','','','');
INSERT INTO yowao_class VALUES('2311','2228','Ƶ','0','37','','','','');
INSERT INTO yowao_class VALUES('2312','2228','װ','0','41','','','','');
INSERT INTO yowao_class VALUES('2313','2228','Ʒ','0','40','','','','');
INSERT INTO yowao_class VALUES('2314','2228','װӡˢ','0','19','','','','');
INSERT INTO yowao_class VALUES('2315','2228','֯Ƥ','0','114','','','','');
INSERT INTO yowao_class VALUES('2316','2228','ҽе','0','13','','','','');
INSERT INTO yowao_class VALUES('2317','2228','','0','74','','','','');
INSERT INTO yowao_class VALUES('2318','2228','ģ','0','25','','','','');
INSERT INTO yowao_class VALUES('2319','2228','̻','0','34','','','','');
INSERT INTO yowao_class VALUES('2320','2228','  ','0','36','','','','');
INSERT INTO yowao_class VALUES('2321','2284','','0','46','beijin','','','');
INSERT INTO yowao_class VALUES('2322','2284','','0','49','tianjin','','','');
INSERT INTO yowao_class VALUES('2323','2284','Ϻ','0','46','shanghai','','','');
INSERT INTO yowao_class VALUES('2324','2284','','0','43','helan','','','');
INSERT INTO yowao_class VALUES('2325','2284','','0','41','hubei','','','');
INSERT INTO yowao_class VALUES('2326','2284','','0','86','hulan','','','');
INSERT INTO yowao_class VALUES('2327','2284','㶫','0','49','guangdong','','','');
INSERT INTO yowao_class VALUES('2328','2284','','0','41','guangxi','','','');
INSERT INTO yowao_class VALUES('2329','2284','','0','43','hailan','','','');
INSERT INTO yowao_class VALUES('2330','2284','Ĵ','0','42','shichuan','','','');
INSERT INTO yowao_class VALUES('2331','2284','','0','18','guizou','','','');
INSERT INTO yowao_class VALUES('2332','2284','','0','35','yunlan','','','');
INSERT INTO yowao_class VALUES('2333','2284','','0','46','shanxi','','','');
INSERT INTO yowao_class VALUES('2334','2284','','0','44','gansu','','','');
INSERT INTO yowao_class VALUES('2335','2284','','0','41','linxia','','','');
INSERT INTO yowao_class VALUES('2336','2284','ɽ','0','48','shandong','','','');
INSERT INTO yowao_class VALUES('2337','2284','','0','47','jiangxi','','','');
INSERT INTO yowao_class VALUES('2338','2284','','0','48','congqin','','','');
INSERT INTO yowao_class VALUES('2339','2284','ӱ','0','51','hebei','','','');
INSERT INTO yowao_class VALUES('2340','2284','ɽ','0','42','shanxi','','','');
INSERT INTO yowao_class VALUES('2341','2284','','0','51','liaol','','','');
INSERT INTO yowao_class VALUES('2342','2284','','0','34','jilin','','','');
INSERT INTO yowao_class VALUES('2343','2284','','0','41','helj','','','');
INSERT INTO yowao_class VALUES('2344','2284','','0','55','jiangs','','','');
INSERT INTO yowao_class VALUES('2345','2284','㽭','0','32','zhejiang','','','');
INSERT INTO yowao_class VALUES('2346','2284','','0','35','anhui','','','');
INSERT INTO yowao_class VALUES('2347','2284','','0','43','fujian','','','');
INSERT INTO yowao_class VALUES('2348','2284','','0','27','leimen','','','');
INSERT INTO yowao_class VALUES('2349','2284','ຣ','0','37','qinhai','','','');
INSERT INTO yowao_class VALUES('2350','2284','','0','9','xizang','','','');
INSERT INTO yowao_class VALUES('2351','2284','½','0','4','xinjiang','','','');
INSERT INTO yowao_class VALUES('2352','2284','','0','27','xiangg','','','');
INSERT INTO yowao_class VALUES('2353','2284','','0','23','aomen','','','');
INSERT INTO yowao_class VALUES('2354','2284','̨','0','26','taiwan','','','');
INSERT INTO yowao_class VALUES('2355','2226','ƾ','0','0','caijinggushi','','','');
INSERT INTO yowao_class VALUES('2356','2355','ƾѶ','0','34','','','','');
INSERT INTO yowao_class VALUES('2357','2355','','0','8','','','','');
INSERT INTO yowao_class VALUES('2358','2355','֤ȯ/˾','0','55','','','','');
INSERT INTO yowao_class VALUES('2359','2355','ܱ','0','23','','','','');
INSERT INTO yowao_class VALUES('2360','856','֧','2','5','','','','');
INSERT INTO yowao_class VALUES('2361','1','QQ','119','0','QQ','','','');
INSERT INTO yowao_class VALUES('2362','2361','QQۺ','1','10','','','','');
INSERT INTO yowao_class VALUES('2363','2361','QQͷ','2','5','','','','');
INSERT INTO yowao_class VALUES('2364','2361','QQռ','3','4','','','','');
INSERT INTO yowao_class VALUES('2365','2361','QQ','4','7','','','','');
INSERT INTO yowao_class VALUES('2366','2361','QQǩ','5','5','','','','');
INSERT INTO yowao_class VALUES('2367','2361','QQϷ','6','18','','','','');
INSERT INTO yowao_class VALUES('2368','824','ۺ','0','24','','','','');
INSERT INTO yowao_class VALUES('2369','824','սĿ','0','12','','','','');
INSERT INTO yowao_class VALUES('2370','1','','0','0','feizhuliu','','','');
INSERT INTO yowao_class VALUES('2371','2370','','0','15','','','','');
INSERT INTO yowao_class VALUES('2372','2370','','0','6','','','','');
INSERT INTO yowao_class VALUES('2373','2370','','0','11','','','','');
INSERT INTO yowao_class VALUES('2374','1','վ','0','0','kuzhan','','','');
INSERT INTO yowao_class VALUES('2375','2374','2009һ','0','12','','','','');
INSERT INTO yowao_class VALUES('2376','2374','2009ڶ','0','10','','','','');
INSERT INTO yowao_class VALUES('2377','2374','2009','0','3','','','','');
INSERT INTO yowao_class VALUES('2378','644','ѧ̳','0','7','','','','');
INSERT INTO yowao_class VALUES('2383','765','ֻƷ','0','10','','','','');
INSERT INTO yowao_class VALUES('2384','863','','3','8','','','','');
INSERT INTO yowao_class VALUES('2385','863','ҩ','4','6','','','','');
INSERT INTO yowao_class VALUES('2386','863','ҽѧҵ','6','23','','','','');
INSERT INTO yowao_class VALUES('2387','2','Ź','125','0','tuan','Ź,ҪŹ,Źȫ','','');
INSERT INTO yowao_class VALUES('2388','2387','Ź','0','70','','','','');

INSERT INTO yowao_config VALUES('yl_admingd','0');
INSERT INTO yowao_config VALUES('yl_cc','1');
INSERT INTO yowao_config VALUES('yl_ceoconnect','http://www.yowao.com/');
INSERT INTO yowao_config VALUES('yl_ceoemail','896887122@qq.com');
INSERT INTO yowao_config VALUES('yl_ckpath','/');
INSERT INTO yowao_config VALUES('yl_clickcount','1');
INSERT INTO yowao_config VALUES('yl_cvtime','0');
INSERT INTO yowao_config VALUES('yl_datefm','Y-m-j H:i');
INSERT INTO yowao_config VALUES('yl_debug','0');
INSERT INTO yowao_config VALUES('yl_footertime','1');
INSERT INTO yowao_config VALUES('yl_hash','djfdosp^%&^21313ffsdfsd');
INSERT INTO yowao_config VALUES('yl_icp','');
INSERT INTO yowao_config VALUES('yl_icpurl','http://www.miibeian.gov.cn');
INSERT INTO yowao_config VALUES('yl_ifjump','1');
INSERT INTO yowao_config VALUES('yl_ipban','');
INSERT INTO yowao_config VALUES('yl_ipstat','<script src=\"http://s90.cnzz.com/stat.php?id=2026540&web_id=2026540\" language=\"JavaScript\"></script>');
INSERT INTO yowao_config VALUES('yl_ipstates','1');
INSERT INTO yowao_config VALUES('yl_loadavg','2');
INSERT INTO yowao_config VALUES('yl_lp','1');
INSERT INTO yowao_config VALUES('yl_metadescrip','yowaoҪ۵㼯ʱ桢ʱеվƵ֡Ϸ͵ŷࡣṩ˶ڡʵòѯԤԶƵʵùܣṩ򵥱ݵϵ');
INSERT INTO yowao_config VALUES('yl_metakeyword','yowao,Ҫ,,,,ַ,,,ͼƬ,,,,,');
INSERT INTO yowao_config VALUES('yl_obstart','1');
INSERT INTO yowao_config VALUES('yl_proxy','1');
INSERT INTO yowao_config VALUES('yl_refreshtime','0');
INSERT INTO yowao_config VALUES('yl_sysname','Ҫ۵[www.yowao.com]- ,￪ʼ!');
INSERT INTO yowao_config VALUES('yl_sysopen','1');
INSERT INTO yowao_config VALUES('yl_sysurl','http://www.yowao.com/');
INSERT INTO yowao_config VALUES('yl_timedf','8');
INSERT INTO yowao_config VALUES('yl_isp','1');
INSERT INTO yowao_config VALUES('yl_mulindex','');
INSERT INTO yowao_config VALUES('yl_enmemcache','0');
INSERT INTO yowao_config VALUES('yl_memcacheserver','192.168.1.233');
INSERT INTO yowao_config VALUES('yl_memcacheport','11211');
INSERT INTO yowao_config VALUES('yl_sendemail','0');
INSERT INTO yowao_config VALUES('yl_sendemailtype','0');
INSERT INTO yowao_config VALUES('yl_fromemail','');
INSERT INTO yowao_config VALUES('yl_smtpserver','');
INSERT INTO yowao_config VALUES('yl_smtpport','25');
INSERT INTO yowao_config VALUES('yl_smtpssl','0');
INSERT INTO yowao_config VALUES('yl_smtpauth','0');
INSERT INTO yowao_config VALUES('yl_smtpid','');
INSERT INTO yowao_config VALUES('yl_smtppass','');
INSERT INTO yowao_config VALUES('yl_display_update_info','0');
INSERT INTO yowao_config VALUES('yl_ckdomain','');
INSERT INTO yowao_config VALUES('yl_path_html','/html');
INSERT INTO yowao_config VALUES('yl_verify_code','0');
INSERT INTO yowao_config VALUES('yl_make_html_realtime','0');
INSERT INTO yowao_config VALUES('yl_dirtplmain','default');

INSERT INTO yowao_coolclass VALUES('1','ѧ','7','7','xiaoshuo/');
INSERT INTO yowao_coolclass VALUES('3','','9','6','blog/');
INSERT INTO yowao_coolclass VALUES('4','','10','6','star/');
INSERT INTO yowao_coolclass VALUES('8','','2','6','music/');
INSERT INTO yowao_coolclass VALUES('9','','13','6','junshi/');
INSERT INTO yowao_coolclass VALUES('11','ֻ','18','6','shouji/');
INSERT INTO yowao_coolclass VALUES('12','','12','6','love/');
INSERT INTO yowao_coolclass VALUES('15','ƾ','5','7','caijinggushi/');
INSERT INTO yowao_coolclass VALUES('16','','8','7','gouwu/');
INSERT INTO yowao_coolclass VALUES('17','','6','7','bank/');
INSERT INTO yowao_coolclass VALUES('18','','19','8','travel/');
INSERT INTO yowao_coolclass VALUES('19','','14','7','tiyu/');
INSERT INTO yowao_coolclass VALUES('20','˲','15','6','rencai/');
INSERT INTO yowao_coolclass VALUES('21','','4','7','mail/');
INSERT INTO yowao_coolclass VALUES('22','','16','6','soft/');
INSERT INTO yowao_coolclass VALUES('23','Ƶ','3','7','vedio/');
INSERT INTO yowao_coolclass VALUES('24','','17','6','car/');
INSERT INTO yowao_coolclass VALUES('25','Ա','1','6','gouwu/');
INSERT INTO yowao_coolclass VALUES('26','Ů','11','0','lady/');
INSERT INTO yowao_coolclass VALUES('27','Ӳ','20','0','yingjian/');
INSERT INTO yowao_coolclass VALUES('28','','21','0','dongman/');
INSERT INTO yowao_coolclass VALUES('29','Ź','0','0','tuan/');
INSERT INTO yowao_coolclass VALUES('30','','22','0','life/');
INSERT INTO yowao_coolclass VALUES('33','','24','0','bbs/');
INSERT INTO yowao_coolclass VALUES('32','','23','0','xingzuo/');

INSERT INTO yowao_coolsite VALUES('1','С˵Ķ','http://book.yowao.com/','1','2','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('3','С˵','http://www.zhulang.com/','1','4','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('4','','http://www.qidian.com','1','1','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('5','','http://www.hongxiu.com/','1','3','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('6','Ժ','http://www.xxsy.net/','1','5','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('7','','http://p.yiqifa.com/c?s=b37f4a1e&w=215569&c=5010&i=10282&l=0&e=&t=http://www.bookuu.com','1','6','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('9','39԰','http://sex.39.net/','2','1','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('10','','http://www.rayli.com.cn/sex/','2','4','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('11','ɫƷ','http://shop8.x.com.cn/index5.php?id=dh&xcom=11','2','3','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('12','','http://www.27.cn/nxjk/index.html','2','5','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('13','Ը԰','http://www.7120.com/html/liangxing/','2','6','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('14','˲','http://blog.sina.com.cn/u/1221885000','3','1','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('15','Q-ZONE','http://896887122.qzone.qq.com/','3','6','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('16','˲','http://blog.ifeng.com/','3','5','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('17','Ѻ','http://blog.sohu.com/','3','2','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('18','ٶȿռ','http://hi.baidu.com/','3','4','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('19','51ռ','http://www.51.com/','3','3','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('20','Ѷ','http://ent.qq.com/','4','1','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('21','','http://ent.sina.com.cn/','4','3','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('22','','http://ent.163.com/','4','5','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('23','Ż','http://ent.cn.yahoo.com/','4','6','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('24','һ','http://www.oneyule.com/','4','2','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('25','ٶ','http://yule.baidu.com/','4','4','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('26','Ϸ','http://games.sina.com.cn/','5','3','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('27','4399Ϸ','http://www.4399.net','5','1','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('28','̫ƽϷ','http://www.pcgames.com.cn/','5','4','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('29','17173','http://www.17173.com/','5','2','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('171',' ̫ƽ','http://www.pb89.com/?u=272060','26','7','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('31','ѶϷ','http://games.qq.com/','5','5','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('32','7K7KϷ','http://www.7k7k.com/','5','6','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('33','4399СϷ','http://www.4399.com/','6','1','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('34','Ӣ','http://p.yiqifa.com/c?s=cdfca29e&w=2451&c=3640&i=2605&l=0&e=&t=http://home.3gm.com.cn/do.php?ac=wlyx','6','5','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('35','91wanϷ','http://www.91wan.com/','6','2','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('36','Ѫ','http://www.91wan.com/rxsg','6','4','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('37','','http://www.91wan.com/ftxy/index.htm','6','3','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('38','ʱ','http://web.4399.com/mcsd/','6','6','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('39','ѶͼƬ','http://ent.qq.com/picture.shtml','7','1','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('40','ͼ','http://www.oneyule.com/tupian','7','3','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('41','ͼƬ','http://news.sina.com.cn/photo/','7','4','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('42','д','http://ent.huanqiu.com/pic/','7','2','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('43','ͼƬ','http://news.163.com/photo','7','5','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('44','վز','http://www.zcool.com.cn/','7','6','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('45','QQ163','http://www.qq163.com/','8','2','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('46','QQ','http://music.qq.com/','8','5','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('47','һ','http://www.1ting.com/','8','1','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('48','','http://www.aiting.com/','8','4','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('49','ٶMP3','http://mp3.baidu.com/','8','6','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('50','','http://mp3.gougou.com/','8','3','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('51','Ѫ','http://www.tiexue.net/','9','2','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('52','','http://news.ifeng.com/mil/','9','5','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('53','л','http://military.china.com/','9','1','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('54','˾','http://mil.news.sina.com.cn/','9','4','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('55','','http://mil.huanqiu.com/','9','3','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('56','й','http://www.chinamil.com.cn/','9','6','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('58','','http://health.27.cn/','10','1','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('59','','http://women.sohu.com/liangrongmeifa.shtml','10','3','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('60','ݽ','http://www.yoka.com/beauty/','10','2','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('61','ʳ','http://www.shiliao.com.cn/','10','5','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('62','','http://lady.qq.com/diet/diet.htm','10','4','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('63','','http://lady.tom.com/beauty/','10','6','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('64','ֻ֮','http://www.imobile.com.cn/','11','3','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('65','̫ƽֻ','http://mobile.pconline.com.cn/','11','0','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('66','йشֻ','http://mobile.zol.com.cn/','11','2','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('67','ֻ','http://www.yowao.com/go.php?url=www.bjxsk58.com','11','5','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('68','ֻ','http://mobile.pcpop.com/','11','7','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('69','ֻй','http://www.cnmo.com/','11','4','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('70','ٺ','http://www.baihe.com','12','5','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('72','','http://bai.sohu.com/','12','1','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('73','','http://www.myspace.cn','12','3','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('74','100','http://spcode.baidu.com/spcode/spClick?tn=yowao_sp&ctn=0&styleid=3959&tourl=http://www.juedui100.com/jueduiJumpResource/8959?prodid=90','12','2','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('75','䰮','http://www.zhenai.com','12','4','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('76','Ѻ','http://digi.it.sohu.com/','13','4','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('77','','http://tech.sina.com.cn/digi','13','5','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('78','̫ƽ','http://digital.pconline.com.cn/','13','1','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('79','йش','http://digi.zol.com.cn/','13','2','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('80','ܱ','http://h1.untang.com/jump.vip?zi=5005726','13','7','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('81','Ѷ','http://digi.qq.com/','13','7','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('82','Ѻ','http://news.sohu.com/','14','3','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('84','','http://news.sina.com.cn/','14','1','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('85','','http://news.163.com/','14','6','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('86','Ż','http://news.cn.yahoo.com/','14','2','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('87','','http://world.huanqiu.com/','14','5','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('89','Ѷ','http://news.ifeng.com/','14','4','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('90','ƽͶ','http://www.361.cm/','15','6','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('91','Ƹ','http://www.eastmoney.com/','15','1','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('92','֤ȯ֮','http://www.stockstar.com/','15','4','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('93','˲ƾ','http://finance.sina.com.cn/','15','3','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('94','ڽ','http://www.jrj.com.cn/','15','5','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('95','Ѷƾ','http://www.hexun.com/','15','2','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('97','Ь','http://www.letao.com/?source=kuku8','16','4','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('99','','http://union.dangdang.com/transfer/transfer.aspx?from=P-278870&backurl=http://www.dangdang.com/','16','1','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('100','̳','http://click.union.360buy.com/JdClick/?unionId=1914&t=1&to=http://www.360buy.com','16','6','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('101','Ա̳','http://pindao.huoban.taobao.com/tms/channel/channelmall.htm?pid=mm_16140449_0_0&eventid=101334','16','3','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('102','׿Խ','http://www.amazon.cn/?source=yowao-23','16','2','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('103','캢̳','http://www.redbaby.com.cn/Union/Redirect.aspx?Source=58332&Url=http://www.redbaby.com.cn/','16','5','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('104','й','http://www.boc.cn/','17','4','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('105','','http://www.cmbchina.com/','17','1','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('106','','http://www.ccb.com/','17','3','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('107','ũҵ','http://www.abchina.com/','17','5','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('108','㷢','http://www.gdb.com.cn/','17','6','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('109','','http://www.icbc.com.cn/','17','2','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('170','','http://auto.sina.com.cn','24','2','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('111','Я','http://www.ctrip.com','18','1','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('112','e','http://www.elong.com','18','4','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('169','ͼԵ','http://reg.jiayuan.com/st/?id=4110&url=http://reg.jiayuan.com','12','6','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('114','ͬ','http://jipiao.17u.cn/index-4647857.html','18','2','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('115',';','http://www.lotour.com/','18','5','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('117','Ʊ','http://p.yiqifa.com/c?s=bd589363&w=215569&c=5426&i=12022&l=0&e=kuku8&t=http://www.dingpiaoke.com','18','3','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('118','','http://p.yiqifa.com/c?s=d50374aa&w=215569&c=5253&i=10542&l=0&e=&t=http://t.soulv.com/','18','6','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('119','','http://sports.sina.com.cn/','19','1','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('120','Ѻ','http://sports.sohu.com/','19','2','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('121','','http://sports.163.com/','19','3','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('122','̳','http://sports.tom.com/','19','4','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('123','NBA','http://china.nba.com/','19','5','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('125','Ѷ','http://sports.qq.com/','19','7','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('126','лӢ','http://www.chinahr.com','20','3','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('127','й˲','http://www.cjol.com/','20','4','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('128','Ƹ','http://www.zhaopin.com/','20','2','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('129','˽','http://www.zhubajie.com/','20','6','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('130','ǰ','http://www.51job.com','20','1','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('131','ҹԱ','http://www.chinagwy.org','20','5','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('132','163','http://mail.163.com/','21','1','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('133','','http://mail.sina.com.cn/','21','4','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('134','126','http://www.126.com/','21','2','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('135','Ż','http://mail.cn.yahoo.com/','21','3','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('136','Ѻʼ','http://mail.sohu.com/','21','5','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('137','Hotmail','http://www.hotmail.com','21','6','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('139','','http://www.onlinedown.net/','22','2','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('140','վ','http://www.skycn.com','22','1','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('141','','http://download.pcpop.com/','22','4','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('142','֮','http://www.mydrivers.com/','22','5','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('143','','http://www.crsky.com/','22','3','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('144','̫ƽ','http://dl.pconline.com.cn/','22','6','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('145','  ','http://www.youku.com/','23','1','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('146','Ƶ','http://video.sina.com.cn/','23','4','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('147','TV6Ƶ','http://u.pomoho.com/tv6','23','6','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('148','ţ','http://u.pomoho.com/nhoho','23','5','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('149','  ','http://www.tudou.com/','23','2','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('151','6Ƶ','http://www.ku6.com/','23','3','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('152','Ѻ','http://auto.sohu.com/','24','4','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('153','̫ƽ','http://www.pcauto.com.cn','24','1','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('154','','http://auto.163.com/','24','5','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('155','֮','http://www.autohome.com.cn/','24','3','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('156','һ⳵','http://p.yiqifa.com/c?s=4ab23c8e&w=215569&c=5118&i=10042&l=0&e=&t=http://maintain.1hai.cn/demo/index.aspx','24','6','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('158','Ա','http://pindao.huoban.taobao.com/tms/channel/man.htm?pid=mm_16140449_0_0&eventid=101330','25','3','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('159','Ƶ','http://pindao.huoban.taobao.com/tms/channel/beauty.htm?pid=mm_16140449_0_0&eventid=101328','25','5','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('160','ܱ','http://pindao.huoban.taobao.com/tms/channel/digital.htm?pid=mm_16140449_0_0&eventid=101332','25','6','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('161','Ҫ۹','http://shop35265445.taobao.com/','25','2','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('162','Աʹڵ','http://pindao.huoban.taobao.com/channel/huangguan.htm?pid=mm_16140449_0_0','25','1','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('163','ԱŮ','http://pindao.huoban.taobao.com/tms/channel/lady.htm?pid=mm_16140449_0_0&eventid=101345','25','4','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('164','Ů','http://www.ruiliren.com','26','1','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('165','̫ƽŮ','http://www.pclady.com.cn','26','2','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('166','YOKAʱ','http://www.yoka.com','26','3','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('167','TOM','http://lady.tom.com/','26','5','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('168','Ů','http://lady.sina.com.cn/','26','6','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('172','  ','http://www.tuan27.com/?utm_source=22029','29','1','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('173','  ','http://p.yiqifa.com/c?s=efe078d4&w=215569&c=5318&i=13922&l=0&e=kuku8&t=http://55tuan.com/?from=lianmeng-yiqifa','29','2','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('174','  ','http://p.yiqifa.com/c?s=50bfe397&w=215569&c=5434&i=16622&l=0&e=kuku8&t=http://www.gaopeng.com/?CID=CN_AFF_138_8_1_1','29','3','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('175','  ','http://p.yiqifa.com/c?s=0de0fa7e&w=215569&c=5402&i=11642&l=0&e=kuku8&t=http://bj.meituan.com/','29','4','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('176','Ʒ','http://p.yiqifa.com/c?s=cd16675f&w=215569&c=5227&i=10462&l=0&e=kuku8&t=http://www.jumei.com/','29','5','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('177','  ','http://p.yiqifa.com/c?s=b77ded11&w=215569&c=5473&i=12262&l=0&e=kuku8&t=http://www.fentuan.com/','29','6','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('178','̫ƽ','http://www.pconline.com.cn/','27','1','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('179','йش','http://www.zol.com.cn/','27','2','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('180','','http://www.pcpop.com/','27','3','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('181','IT168','http://www.it168.com/','27','4','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('182','Դ','http://www.yowao.com/go.php?url=www.hiinem.com','27','5','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('183','֮','http://www.mydrivers.com/','27','6','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('184','Ѷ','http://comic.qq.com/','28','1','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('185','6','http://www.ku6.com/comic/','28','2','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('186','˼','http://www.52tian.net/','28','3','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('187','Ѹ׶','http://anime.xunlei.com/','28','4','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('188','ѩ','http://www.fxdm.net/','28','5','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('189','Ѻ','http://comic.chinaren.com/','28','6','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('190','58ͬ','http://www.58.com/','30','1','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('191','ϼ','http://www.ganji.com/','30','2','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('192','55BBS','http://www.55bbs.com/','30','3','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('193','ڵ','http://www.dianping.com/','30','4','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('194','','http://www.baixing.com/','30','5','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('195','ڱ','http://www.koubei.com/','30','6','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('196','','http://ent.sina.com.cn/','31','1','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('197','Ѷ','http://ent.qq.com/','31','2','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('198','˿','http://www.ifensi.com/','31','3','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('199','д','http://ent.qq.com/star/','31','4','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('200','ǲ','http://blog.sina.com.cn/lm/search/ent/index.html','31','5','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('201','ְ','http://cache.tianya.cn/pub/list/0/funinfo.shtml','31','6','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('209','Ѷ','http://astro.lady.qq.com/','32','1','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('210','','http://astro.sina.com.cn/','32','2','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('213','ܹ','http://www.51jiemeng.com/','32','5','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('212','TOM','http://astro.tom.com/','32','4','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('211','','http://lady.163.com/special/00261PJK/constellation.html','32','3','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('214','Ƶղѯ','http://www.hdjr.org/','32','6','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('215','','http://www.tianya.cn/','33','1','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('216','ٶ','http://tieba.baidu.com/','33','2','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('217','è','http://dzh.mop.com/','33','3','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('218','Ѻ΢','http://t.sohu.com/u/200107826','33','4','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('219','΢','http://weibo.com/yowao','33','5','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('220','̳','http://bbs.cctv.com/','33','6','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('221','','http://www.hers.com.cn/','34','1','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('222','һһ','http://www.tudou.com/home/1r1j','34','2','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('223','־','http://www.zcom.com/','34','3','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('224','','http://www.lansin.com/index.html','34','4','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('225','װ','http://www.biaobaiba.com/','34','5','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO yowao_coolsite VALUES('226','·','http://www.cncn.com/','34','6','0','0','0','0','0','','0','0','0','0','','0');


INSERT INTO yowao_index_tool VALUES('1','ٲ','http://tool.yowao.com/speed/','1','');
INSERT INTO yowao_index_tool VALUES('2','ɣеַ','http://tool.yowao.com/ip/','2','');
INSERT INTO yowao_index_tool VALUES('3','߷','http://tool.yowao.com/fanyi/','3','');
INSERT INTO yowao_index_tool VALUES('4','ֻ','http://tool.yowao.com/shouji/','4','');
INSERT INTO yowao_index_tool VALUES('5','õ绰','http://tool.yowao.com/tel/','5','');
INSERT INTO yowao_index_tool VALUES('6','ʲѯ','http://www.zhcw.com/','6','');
INSERT INTO yowao_index_tool VALUES('7','ʲѯ','http://www.lottery.gov.cn/','7','');
INSERT INTO yowao_index_tool VALUES('8','ҽԺѯ','http://tool.yowao.com/yiyuan/','8','');
INSERT INTO yowao_index_tool VALUES('9','ʱ','http://tool.yowao.com/time/','9','');
INSERT INTO yowao_index_tool VALUES('10','ݲѯ','http://tool.yowao.com/kuaidi/','10','');
INSERT INTO yowao_index_tool VALUES('11',';','http://www.keyunzhan.com/','11','');
INSERT INTO yowao_index_tool VALUES('12','Υ²ѯ','http://www.ip138.com/weizhang.htm','12','');
INSERT INTO yowao_index_tool VALUES('13','ѯ','http://www.8684.cn/','13','');
INSERT INTO yowao_index_tool VALUES('14','  ֤','http://qq.ip138.com/idsearch/','14','');
INSERT INTO yowao_index_tool VALUES('15','ʱ','http://www.tongpiao.com/','15','');
INSERT INTO yowao_index_tool VALUES('16','Ůڲ','http://tool.yowao.com/aqq/','16','');
INSERT INTO yowao_index_tool VALUES('17','Ʊ','http://www.bestgo.com/','17','');
INSERT INTO yowao_index_tool VALUES('18','ʱѯ','http://tool.yowao.com/youbian/','18','');

INSERT INTO yowao_ipstates VALUES('2009-6-26','2009-6','8','8','0','8');


INSERT INTO yowao_links VALUES('24','1','1','Ҫ۵','http://www.yowao.com','1291003117','Ҫ۵');

INSERT INTO yowao_mingzhan VALUES('2','&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;','http://www.google.com.hk/','','2','0','0','','0','0','0','0','0','0','0');
INSERT INTO yowao_mingzhan VALUES('5','йƶ','http://www.chinamobile.com/','','12','0','0','','0','0','0','0','0','0','0');
INSERT INTO yowao_mingzhan VALUES('7','Դ','http://www.yowao.com/go.php?url=www.hiinem.com','','8','0','0','','0','0','0','0','0','0','0');
INSERT INTO yowao_mingzhan VALUES('9','Ա','http://pindao.huoban.taobao.com/channel/onSale.htm?pid=mm_16140449_0_0','','9','0','0','','0','0','0','0','0','0','0');
INSERT INTO yowao_mingzhan VALUES('10','  ','http://www.tuan27.com/?utm_source=22029','','10','0','0','','0','0','0','0','0','0','0');
INSERT INTO yowao_mingzhan VALUES('11','  ','http://www.kaixin001.com/','','15','0','0','','0','0','0','0','0','0','0');
INSERT INTO yowao_mingzhan VALUES('12','ס','http://www.zhuna.cn/rdirect.asp?uid=628206','','34','0','0','','0','0','0','0','0','0','0');
INSERT INTO yowao_mingzhan VALUES('13',' Ƶ ','http://u.pomoho.com/nhoho','','18','0','0','','0','0','0','0','0','0','0');
INSERT INTO yowao_mingzhan VALUES('14','Ƹ','http://www.eastmoney.com/','','19','0','0','','0','0','0','0','0','0','0');
INSERT INTO yowao_mingzhan VALUES('15','й','http://www.gov.cn/','','42','0','0','','0','0','0','0','0','0','0');
INSERT INTO yowao_mingzhan VALUES('69','500Ʊ','http://union.500wan.com/pages/interfacehezuo.php?coopid=1415&adid=16','','22','0','0','','0','0','0','0','0','0','0');
INSERT INTO yowao_mingzhan VALUES('70','','http://www.tianya.cn/bbs/index.shtml','','35','0','0','','0','0','0','0','0','0','0');
INSERT INTO yowao_mingzhan VALUES('19',';ţ','http://market.tuniu.com/Partner_redirect.php?p=1367&cmpid=mkt_07001701&cid=22029&url=http://www.tuniu.com/','','24','0','0','','0','0','0','0','0','0','0');
INSERT INTO yowao_mingzhan VALUES('21','  ','http://p.yiqifa.com/c?s=6206b5cf&w=215569&c=6204&i=18302&l=0&e=kuku8&t=http://tuan.ganji.com/','','25','0','0','','0','0','0','0','0','0','0');
INSERT INTO yowao_mingzhan VALUES('22','֮','http://www.autohome.com.cn/','','27','0','0','','0','0','0','0','0','0','0');
INSERT INTO yowao_mingzhan VALUES('68','С˵Ķ','http://book.yowao.com/','','33','0','0','','0','0','0','0','0','0','0');
INSERT INTO yowao_mingzhan VALUES('29','־ӷ','http://house.sina.com.cn/','','28','0','0','','0','0','0','0','0','0','0');
INSERT INTO yowao_mingzhan VALUES('30','  ','http://www.bitauto.com/','','29','0','0','','0','0','0','0','0','0','0');
INSERT INTO yowao_mingzhan VALUES('31','ӿͷ','http://www.anjuke.com/','','30','0','0','','0','0','0','0','0','0','0');
INSERT INTO yowao_mingzhan VALUES('33','  ','http://www.51seer.com/','','23','0','0','','0','0','0','0','0','0','0');
INSERT INTO yowao_mingzhan VALUES('34','  ','http://www.xinhuanet.com/','','16','0','0','','0','0','0','0','0','0','0');
INSERT INTO yowao_mingzhan VALUES('35','  ','http://p.yiqifa.com/c?s=0de0fa7e&w=215569&c=5402&i=11642&l=0&e=kuku8&t=http://bj.meituan.com/','','17','0','0','','0','0','0','0','0','0','0');
INSERT INTO yowao_mingzhan VALUES('38','ٶа','http://youa.baidu.com/','','26','0','0','','0','0','0','0','0','0','0');
INSERT INTO yowao_mingzhan VALUES('46','лӢ','http://www.chinahr.com/','','20','0','0','','0','0','0','0','0','0','0');
INSERT INTO yowao_mingzhan VALUES('73','','http://www.icbc.com.cn/','','31','0','0','','0','0','0','0','0','0','0');
INSERT INTO yowao_mingzhan VALUES('66','  ','http://union.dangdang.com/transfer/transfer.aspx?from=P-278870&backurl=http://www.dangdang.com/','','32','0','0','','0','0','0','0','0','0','0');
INSERT INTO yowao_mingzhan VALUES('67','麣̳','http://www.zh-sc.com/','','7','0','0','','0','0','0','0','0','0','0');
INSERT INTO yowao_mingzhan VALUES('54','39','http://www.39.net/','','21','0','0','','0','0','0','0','0','0','0');
INSERT INTO yowao_mingzhan VALUES('72','Ա̳','http://pindao.huoban.taobao.com/tms/channel/channelmall.htm?pid=mm_16140449_0_0&eventid=101334','','11','0','0','','0','0','0','0','0','0','0');
INSERT INTO yowao_mingzhan VALUES('86','58  ','http://p.yiqifa.com/c?s=aace14b9&w=215569&c=5486&i=13022&l=0&e=kuku8&t=http://t.58.com','','38','0','0','','0','0','0','0','0','0','0');
INSERT INTO yowao_mingzhan VALUES('74','&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;','http://www.baidu.com/','','1','0','0','','0','0','0','0','0','0','0');
INSERT INTO yowao_mingzhan VALUES('75','&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;','http://www.sina.com.cn/','','3','0','0','','0','0','0','0','0','0','0');
INSERT INTO yowao_mingzhan VALUES('76','&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;','http://www.sohu.com/','','5','0','0','','0','0','0','0','0','0','0');
INSERT INTO yowao_mingzhan VALUES('77','&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;','http://www.163.com/','','6','0','0','','0','0','0','0','0','0','0');
INSERT INTO yowao_mingzhan VALUES('78','&nbsp;&nbsp;&nbsp;&nbsp;Ѷ&nbsp;&nbsp;','http://www.qq.com/','','4','0','0','','0','0','0','0','0','0','0');
INSERT INTO yowao_mingzhan VALUES('79','  ','http://www.renren.com/','','14','0','0','','0','0','0','0','0','0','0');
INSERT INTO yowao_mingzhan VALUES('85','  ','http://p.yiqifa.com/c?s=ba92bca2&w=215569&c=4238&i=4386&l=0&e=kuku8&t=http://www.guguwang.com','','37','0','0','','0','0','0','0','0','0','0');
INSERT INTO yowao_mingzhan VALUES('84','̫ƽ','http://www.pconline.com.cn/','','36','0','0','','0','0','0','0','0','0','0');
INSERT INTO yowao_mingzhan VALUES('87','è  ','http://www.mop.com/','','39','0','0','','0','0','0','0','0','0','0');
INSERT INTO yowao_mingzhan VALUES('88','Ь','http://www.letao.com/?source=kuku8','','40','0','0','','0','0','0','0','0','0','0');
INSERT INTO yowao_mingzhan VALUES('89','ͼԵ','http://reg.jiayuan.com/st/?id=4110&url=http://reg.jiayuan.com','','41','0','0','','0','0','0','0','0','0','0');
INSERT INTO yowao_mingzhan VALUES('90','  ','http://www.taobao.com/','','13','0','0','','0','0','0','0','0','0','0');
INSERT INTO yowao_mingzhan VALUES('91','ΰɯ','http://shopping.moonbasa.com/rd/rd.aspx?a_id=mbs&other=kuku8&url=http://www.moonbasa.com/','','43','0','0','','0','0','0','0','0','0','0');
INSERT INTO yowao_mingzhan VALUES('92','ͳƷ','http://www.vancl.com/?source=kuku8','','44','0','0','','0','0','0','0','0','0','0');
INSERT INTO yowao_mingzhan VALUES('93','̳','http://click.union.360buy.com/JdClick/?unionId=1914&t=1&to=http://www.360buy.com','','45','0','0','','0','0','0','0','0','0','0');
INSERT INTO yowao_mingzhan VALUES('94','׿ԽϹ','http://www.amazon.cn/?source=yowao-23','','46','0','0','','0','0','0','0','0','0','0');
INSERT INTO yowao_mingzhan VALUES('95','캢̳','http://www.redbaby.com.cn/Union/Redirect.aspx?Source=58332&Url=http://www.redbaby.com.cn/','','47','0','0','','0','0','0','0','0','0','0');
INSERT INTO yowao_mingzhan VALUES('96','99','http://www.99read.com/union/transfer.aspx?unionid=yowao&adid=a2445','','48','0','0','','0','0','0','0','0','0','0');


INSERT INTO yowao_recycler VALUES('44','','ħй̳','http://bbs.wowar.com/','699','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('43','','ħͻ˹ٷ','http://www.wowchina.com/download/game/game.htm','699','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('42','','ħٷվ','http://www.wowchina.com/','699','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('41','','Ʒսƽ̨','http://www.cga.com.cn','699','','yowao','7','0','0','0','');
INSERT INTO yowao_recycler VALUES('40','','','http://www.ourgame.com','699','','yowao','6','0','0','0','');
INSERT INTO yowao_recycler VALUES('39','','ѶϷ','http://games.qq.com/','699','','yowao','5','0','0','0','');
INSERT INTO yowao_recycler VALUES('38','','17173','http://www.17173.com/','699','','yowao','1','0','0','0','');
INSERT INTO yowao_recycler VALUES('37','','52PKϷ','http://www.52pk.com/','699','','yowao','9','0','0','0','');
INSERT INTO yowao_recycler VALUES('36','','Ϸ','http://www.duowan.com/','699','','yowao','4','0','0','0','');
INSERT INTO yowao_recycler VALUES('35','','ξ','http://www.uuu9.com/','699','','yowao','10','0','0','0','');
INSERT INTO yowao_recycler VALUES('34','','','http://www.9you.com','699','','yowao','8','0','0','0','');
INSERT INTO yowao_recycler VALUES('33','','̫ƽϷ','http://www.pcgames.com.cn','699','','yowao','3','0','0','0','');
INSERT INTO yowao_recycler VALUES('32','','Ϸ','http://games.sina.com.cn','699','','yowao','2','0','0','0','');
INSERT INTO yowao_recycler VALUES('31','','Ӿа','http://tv.hao123.com/','1285','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('30','','ṷ','http://www.kugou.com/','716','','yowao','3','1','0','0','');
INSERT INTO yowao_recycler VALUES('29','','ǧǧ','http://www.qianqian.com/','716','','yowao','7','0','0','0','');
INSERT INTO yowao_recycler VALUES('28','','Ҫdj','http://www.111ttt.com/','720','','yowao','10','0','0','0','');
INSERT INTO yowao_recycler VALUES('27','dh_site','й','http://www.sinotoys.net/','926','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('45','','ħ-˹ҵ','http://ngacn.cc/','699','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('46','','17173-ħ','http://wow.17173.com/','699','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('47','','̫ƽϷħ','http://www.pcgames.com.cn/netgames/zhuanti/wow/','699','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('48','','Ϸ-ħ','http://games.sina.com.cn/z/wow/indexpage.shtml','699','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('49','','21CN-ħר','http://game.21cn.com/zhuanqu/wow','699','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('50','','TOMϷ-ħ','http://games.tom.com/zhuanti/wow/','699','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('51','','ȶ-ħ','http://wow.enet.com.cn/','699','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('52','','ѶϷ-ħ','http://games.qq.com/z/wow/','699','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('53','','-ħ','http://games.cnool.net/wow/','699','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('54','','ħй','http://www.wowar.com/','699','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('55','','ħ޾','http://www.wowshell.com/','699','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('56','','ħ޵ͼ','http://bbs.wow8.org/','699','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('57','','˲ͻ','http://tl.sohu.com/download/client.shtml','699','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('58','','˲','http://tl.sohu.com/download/client.shtml','699','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('59','','˲ٷ̳','http://bbs.tl.sohu.com/','699','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('60','','˲ٷվ','http://tl.sohu.com/?rcc_id=5bd6447fe484590312d8c140a246475b%20','699','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('61','','eNet˲ר','http://bbs.tl.sohu.com/','699','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('62','','17173˲ר','http://tl.17173.com/','699','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('63','','˲','http://post.baidu.com/f?ct=318898176&amp;amp;tn=baiduKeywordSearch&amp;amp;sc=4504&amp;amp;pn=0&amp;amp;rn=50&amp;amp;lm=4&amp;amp;rs3=0&amp;amp;word=%CC%EC%C1%FA%B0%CB%B2%BF','699','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('64','','Ѷ˲ר','http://games.qq.com/z/tl/','699','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('65','','ȫɲֲ','http://tl.17173.com/zhuanti/xinshou.html','699','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('66','','³ʿ','http://dnf.qq.com/index.shtml','699','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('67','','ͻ','http://dnf.qq.com/','699','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('68','','ٷ̳','http://gamebbs.qq.com/bbs/dnfhtm/197.htm','699','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('69','','17173-³ʿ','http://dnf.17173.com/','699','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('70','','-³ʿ','http://df.duowan.com/','699','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('71','','λιٷվ','http://xyq.163.com/','699','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('72','','λοͻ','http://xyq.163.com/download/khd.html','699','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('73','','17173λר','http://xyq.17173.com/','699','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('74','','λר','http://games.sina.com.cn/z/xyq/indexpage.shtml','699','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('75','','ٶλΰ','http://post.baidu.com/f?kw=%C3%CE%BB%C3%CE%F7%D3%CE','699','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('76','','λ','http://xyq.youwo.com/','699','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('77','','λΡٷϷ̳','http://xyq.netease.com/','699','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('78','','λר-Ҷ','http://www.yezizhu.com/xyq/','699','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('79','','ɹٷվ','http://zhuxian.wanmei.com/main.htm','699','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('80','','ɹٷͻ','http://zhuxian.wanmei.com/','699','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('81','','17173-','http://newgame.17173.com/content/2007-03-07/20070307111853953.shtml','699','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('82','','̫ƽ-','http://www.pcgames.com.cn/netgames/zhuanti/zhuxian/','699','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('83','','-','http://games.sina.com.cn/o/z/zx/','699','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('84','','TOMϷ-','http://games.tom.com/zt/zhuxian/','699','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('85','','⴫','http://mirs.sdo.com/web2/home/index.asp','699','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('86','','⴫ͻ','http://mirs.sdo.com/web1/index/index.html','699','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('87','','Ϸ-⴫','http://games.sina.com.cn/o/c/2008-09-09/6355.shtml','699','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('88','','ѶϷ-⴫','http://games.qq.com/z/cqwz/','699','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('89','','ʵ','http://www.asktao.com/','699','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('90','','ʵͻ','http://www.asktao.com/download/index.htm','699','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('91','','ʵϷ̳','http://bbs.asktao.com/','699','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('92','','ʵٷֲ','http://wd.gyyx.cn/guide.htm','699','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('93','','ʵ17173ר','http://asktao.17173.com/','699','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('94','','Ϸʵ','http://games.sina.com.cn/o/z/askdao/','699','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('95','','Ѷ-ʵר','http://gamezone.qq.com/z/asktao/','699','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('96','','Խ߹ٷվ','http://cf.qq.com/index.shtml','699','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('97','','Խ߿ͻ','http://cf.qq.com/','699','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('98','','Խ̳','http://gamebbs.qq.com/bbs/cfhtm/196.htm','699','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('99','','52pk-Խר','http://games.52pk.com/cf/','699','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('100','','17173-Խר','http://cf.17173.com/','699','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('101','','ƽϷ-Խ','http://wangyou.pcgames.com.cn/zhuanti/qqcf/','699','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('102','','766-Խ','http://cf.766.com/','699','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('103','','ѪĹٷվ','http://rxjh.17game.com/index.htm','699','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('104','','Ѫͻ','http://rxjh.17game.com/','699','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('105','','Ѫٷ̳','http://bbs.rxjh.china.com/index.asp','699','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('106','','17173-Ѫר','http://rxjh.17173.com/','699','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('107','','Ϸ-Ѫ','http://games.sina.com.cn/z/rxjh/','699','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('108','','Źٷվ','http://au.9you.com/index.html','699','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('109','','ſͻ','http://au.9you.com/','699','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('110','','Ϸ-','http://games.sina.com.cn/z/jwt/','699','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('111','','Źٷ̳','http://bbs2.9you.com/viewForum.jsp?id=688','699','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('112','','17173-','http://ddr.17173.com/','699','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('113','','52PK-ר','http://au.52pk.com/','699','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('114','','ٶȾŰ','http://post.baidu.com/f?kw=','699','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('115','','','http://jwt.youwo.com/','699','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('116','','ܿٷվ','http://popkart.tiancity.com/','699','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('117','','ܿٷ̳','http://bbspopkart.tiancity.com/','699','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('118','','ܿͻ','http://popkart.tiancity.com/homepage/download/download_game.html','699','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('119','','','http://popkart.tiancity.com/homepage/download/drivers.html','699','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('120','','17173-ܿ','http://popkart.17173.com/','699','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('121','','ȶ-ܿ','http://games.enet.com.cn/zhuanti/popkart/index.shtml','699','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('122','','52PK-ܿ','http://games.52pk.net/popkart/','699','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('123','','̫ƽϷ-ܿ','http://www.pcgames.com.cn/netgames/zhuanti/popkart/','699','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('124','','TOMϷ-ܿ','http://games.tom.com/zhuanti/popkart/','699','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('125','','Ϸ-ܿ','http://games.sina.com.cn/o/z/pop/','699','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('126','','ѶϷ-ܿ','http://gamezone.qq.com/z/popkart/','699','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('127','','֮','http://aion.sdo.com/','699','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('128','','֮ͻ','http://aion.sdo.com/web1/guide/index.html','699','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('129','','֮-17173','http://aion.17173.com/','699','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('130','','֮-ר','http://games.sina.com.cn/aion/','699','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('131','','-Aion֮','http://aion.duowan.com/','699','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('132','','̫ƽϷ-CSר','http://www.pcgames.com.cn/fight/cs/','699','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('133','','TOMϷ-־Ӣ','http://games.tom.com/zhuanti/cs/','699','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('134','','CSٷҳ[Ӣ]','http://storefront.steampowered.com/v2/index.php?area=game&amp;amp;AppId=240','699','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('135','','־Ӣ_ѶϷƵ','http://gamezone.qq.com/z/cs/','699','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('136','','Ϸ-־Ӣ','http://games.sina.com.cn/z/css/indexpage.shtml','699','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('137','','йִ','http://www.okgogogo.com/','699','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('138','','־Ӣ-21CN.COM','http://game.21cn.com/zhuanqu/cs/','699','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('139','','Ʒսϵͳ','http://cs.cga.com.cn/','699','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('140','','[=Nice=] ս','http://www.niceplayer.com/','699','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('141','',':: CS ս ::','http://www.csteams.net/','699','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('142','','CS','http://bbs.cqzg.cn/forumdisplay.php?fid=163','699','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('143','','net.Fire|CSս','http://www.netfire.com.cn/','699','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('144','','CS Demoؼ','http://www.pcgames.com.cn/fight/fightdemo/csdemo/','699','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('145','','ùٷվ','http://home.bnb.sdo.com/web2006','699','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('146','','17173-','http://bnb.17173.com/','699','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('147','','52pkר','http://games.52pk.net/bnb/','699','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('148','','-21CNϷƵ','http://game.21cn.com/zhuanqu/bnb/','699','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('149','','-TOMϷ','http://games.tom.com/zhuanti/ppt/default.html','699','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('150','','-QQϷƵ','http://gamezone.qq.com/z/paopt/index.htm','699','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('151','','','http://bnb.17173.com/caozuo/caozuo_01.htm','699','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('152','','̳-17173','http://bbs.17173.com/list.php?id=439&amp;amp;sid=440','699','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('153','','ٶð','http://post.baidu.com/f?kw=','699','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('154','','õȯֵ','http://bnb.poptang.com/newbnb/bnb05/pay/index.htm','699','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('155','','ͷٷվ','http://www.fsjoy.com/','699','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('156','','ͷͻ','http://www.fsjoy.com/download/game_download.htm','699','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('157','','17173-ͷ','http://fs.17173.com/','699','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('158','','ͷ-ȶרվ','http://games.enet.com.cn/zhuanti/fsjoy/index.shtml','699','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('159','','ͷ-̫ƽϷ','http://www.pcgames.com.cn/netgames/zhuanti/fs/','699','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('160','','Ϸ-ͷ','http://games.sina.com.cn/zt/netgames/fs0829/','699','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('161','','ͷ-5617Ϸ','http://jietou.5617.com/','699','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('162','','ٶ_ͷ','http://post.baidu.com/f?kw=%BD%D6%CD%B7%C0%BA%C7%F2','699','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('163','','QQٷҳ','http://fo.qq.com/','699','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('164','','ѶϷ-QQ','http://gamezone.qq.com/tencent/qqfo/','699','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('165','','QQٷ̳','http://bbs.qq.com/cgi-bin/bbs/user/user_enter_bbs?g=f&amp;amp;url=/lanmu/149.shtml','699','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('166','','QQͻ','http://fo.qq.com/download/client.htm','699','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('167','','QQ-17173ר','http://fo.17173.com/','699','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('168','','QQ-Ϸ','http://games.sina.com.cn/o/z/qqhx/','699','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('169','','1t1t-QQ','http://www.1t1t.com/fo/','699','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('170','','QQ-TOMϷ','http://games.tom.com/zt/qqhx/','699','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('171','','Ѫٷվ','http://sg.wangye173.com/','699','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('172','','','http://www.ali213.net','706','','yowao','8','0','0','0','');
INSERT INTO yowao_recycler VALUES('173','','PSP','http://www.psper.net/','706','','yowao','9','0','0','0','');
INSERT INTO yowao_recycler VALUES('174','','','http://www.cngba.com/','706','','yowao','1','0','0','0','');
INSERT INTO yowao_recycler VALUES('175','','ֻй','http://www.mamecn.com/','706','','yowao','5','0','0','0','');
INSERT INTO yowao_recycler VALUES('176','','','http://www.nwbbs.com/','706','','yowao','7','0','0','0','');
INSERT INTO yowao_recycler VALUES('177','','PSP','http://www.uoaoo.com','706','','yowao','10','0','0','0','');
INSERT INTO yowao_recycler VALUES('178','','۹ʱ','http://www.yowao.com/html/catalog/game1.htm#54','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('179','',' \r\n  FIFA','http://www.yowao.com/html/catalog/game1.htm#52','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('180','','Ʒɳ','http://www.yowao.com/html/catalog/game1.htm#48','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('181','','ɽ','http://www.yowao.com/html/catalog/game1.htm#59','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('182','','ɳ','http://www.yowao.com/html/catalog/game1.htm#50','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('183','','PSPƻ','http://www.yowao.com/html/catalog/game1.htm#47','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('184','','','http://www.yowao.com/html/catalog/game1.htm#41','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('185','','','http://www.yowao.com/html/catalog/game1.htm#53','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('186','','/','http://www.yowao.com/html/catalog/game1.htm#51','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('187','','Ϸ','http://www.yowao.com/html/catalog/game1.htm#46','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('188','','ױϷ','http://www.yowao.com/html/catalog/game1.htm#45','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('189','','СϷ','http://www.yowao.com/html/catalog/game1.htm#44','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('190','','','http://www.yowao.com/html/catalog/game1.htm#60','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('191','','Ϸ','http://www.yowao.com/html/catalog/game1.htm#62','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('192','','ħ3-','http://www.xiazaiba.com/html/845.html','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('193','','Ʒսƽ̨ħר','http://war3.cga.com.cn/','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('194','','TOMϷƵ_ħ3','http://games.tom.com/zhuanti/war3/','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('195','','̫ƽϷ_ħ3','http://www.pcgames.com.cn/fight/warcraft/','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('196','','ٶħ','http://post.baidu.com/f?kw=%C4%A7%CA%DE%D5%F9%B0%D4','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('197','','ħ̳_Ѻ','http://club.it.sohu.com/itmain.php?b=warcraft','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('198','','ħ3̳_','http://games.sina.com.cn/forum/mszb3.shtml','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('199','','ȶ_ħ3','http://games.enet.com.cn/zhuanti/war3/','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('200','','ħ3Ѷվ','http://www.aomeisoft.com/war3/wc3/','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('201','','21CNϷ_ħ3','http://game.21cn.com/zhuanqu/war3/','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('202','','ħԵͼ_̫ƽ','http://www.pcgames.com.cn/fight/warcraft/msdtxz/','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('203','','ħ޲_ȶ','http://games.enet.com.cn/download/gmd_index.php?key%5B%5D=war3tools','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('204','','ħ','http://down.52pk.com/xiazai/80.shtml','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('205','','_','http://games.sina.com.cn/z/war3/2/qtxz/index.shtml','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('206','','U9ħRPG','http://www.uuu9.com/','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('207','','ħͼƬ','http://image.baidu.com/i?tn=baiduimage&amp;amp;lm=-1&amp;amp;ct=201326592&amp;amp;cl=2&amp;amp;word=%C4%A7%CA%DE%D5%F9%B0%D4','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('208','','dotaĹٷվ','http://dota.uuu9.com/','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('209','','ؽ-֮','http://tdj.uuu9.com/','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('210','','ȭ 97','http://fengyun2.uuu9.com/','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('211','','֮ҹ','http://tstd.uuu9.com/','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('212','','κ 3C','http://tstd.uuu9.com/','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('213','','Hokage Ninja','http://wmx.uuu9.com/','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('214','','½ӹȺ','http://cljshenjian.uuu9.com/','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('215','','ʥս','http://caocao.uuu9.com/','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('216','','Ӣ۴','http://kchs.uuu9.com/','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('217','','DOTA','http://dota.uuu9.com/','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('218','','֮·','http://xiangpi.uuu9.com/','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('219','','','http://dixietomi.uuu9.com/','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('220','','ETN ¥δ˵','http://etn.uuu9.com/','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('221','','ɲ','http://bbs.uuu9.com/forumdisplay.php?fid=362','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('222','','ط','http://bbs.uuu9.com/forumdisplay.php?fid=310','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('223','','Ҷ','http://dongyou.uuu9.com/','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('224','','ľҶ⴫','http://muye.uuu9.com/','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('225','','ħflash','http://www.game.com.cn/games/0/9/moshouflash.html','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('226','','Ʒɫ̳','http://bbs.cga.com.cn/cboard/cboard_52.asp','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('227','','ɫ','http://post.baidu.com/f?kw=%BA%EC%C9%AB%BE%AF%BD%E4','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('228','','쾯','http://post.baidu.com/f?kw=%BA%EC%BE%AF','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('229','','ȶ_ɫר','http://games.enet.com.cn/zhuanti/red2gb/Red2gb.htm','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('230','','ɫ2ٷվӢģ','http://www.ea.com/official/cc/firstdecade/us/index.jsp','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('231','','ɫ2壩','http://www.xiazaiba.com/html/720.html','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('232','','ɫ2-Ϸ','http://www.xiazaiba.com/html/862.html','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('233','','쾯2֮й','http://www.xiazaiba.com/html/739.html','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('234','','ɫ2ĸ','http://www.xiazaiba.com/html/734.html','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('235','','ɫͼƬ','http://image.baidu.com/i?tn=baiduimage&amp;amp;ct=201326592&amp;amp;lm=-1&amp;amp;cl=2&amp;amp;word=%BA%EC%C9%AB%BE%AF%BD%E4','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('236','','ɫIII޸','http://www.xiazaiba.com/downinfo/1070.html','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('237','','ɫflash','http://www.game.com.cn/games/7/8/redalter.html','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('238','','ƻ','http://www.gougou.com/search?search=%E6%9A%97%E9%BB%91%E7%A0%B4%E5%9D%8F%E7%A5%9E&amp;amp;restype=-1&amp;amp;id=100002','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('239','','֮Ӳ̰','http://www.gougou.com/search?search=%E6%9A%97%E9%BB%91%E7%A0%B4%E5%9D%8F%E7%A5%9E%E6%AF%81%E7%81%AD%E4%B9%8B%E7%8E%8B&amp;amp;restype=-1&amp;amp;id=100002','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('240','','ƻƵ','http://video.baidu.com/v?word=%B0%B5%BA%DA%C6%C6%BB%B5%C9%F1&amp;amp;ct=301989888&amp;amp;rn=20&amp;amp;pn=0&amp;amp;db=0&amp;amp;s=0','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('241','','ƻ','http://post.baidu.com/f?ct=318898176&amp;amp;tn=baiduKeywordSearch&amp;amp;sc=3311&amp;amp;pn=0&amp;amp;rn=50&amp;amp;lm=4&amp;amp;rs3=0&amp;amp;word=%B0%B5%BA%DA%C6%C6%BB%B5%C9%F1','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('242','','u9ƻ2רվ','http://d2.uuu9.com/','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('243','','2_Ϸ','http://games.sina.com.cn/z/d2x/indexpage.shtml','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('244','','ƻflash','http://www.game.com.cn//games/2/0/mahphs.html','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('245','','impkս̳','http://www.impk.net/','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('246','','Ѫٷս(Ӣ)','http://www.battle.net/','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('247','','й','http://chinabn.xiyou.net/','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('248','','۹ʱӲ̰','http://down.52pk.net/sort/49_1.htm','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('249','','۹ʱϷƵ','http://video.baidu.com/v?word=%B5%DB%B9%FA%CA%B1%B4%FA&amp;amp;ct=301989888&amp;amp;rn=20&amp;amp;pn=0&amp;amp;db=0&amp;amp;s=0','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('250','','۹ʱ3-ר','http://games.sina.com.cn/zt/pcgames/AOE3/','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('251','','۹ʱ','http://post.baidu.com/f?ct=318898176&amp;amp;tn=baiduKeywordSearch&amp;amp;sc=13638&amp;amp;pn=0&amp;amp;rn=50&amp;amp;lm=4&amp;amp;rs3=0&amp;amp;word=%B5%DB%B9%FA%CA%B1%B4%FA','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('252','','۹ʱ-ZOLϷ','http://youxi.zol.com.cn/pc/index3738.html','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('253','','۹ʱ۷(Ӣ)','http://www.microsoft.com/games/aoeexpansion/','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('254','','۹ʱ֮2','http://www.game.com.cn/games/8/2/zhenlizhijian2.html','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('255','','FIFAϷ','http://game.gougou.com/search?search=FIFA2007&amp;amp;restype=1&amp;amp;id=1000000','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('256','','FIFAϵ(52pk)','http://down.52pk.com/sort/209_1.htm','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('257','','FIFAϷƵ','http://video.baidu.com/v?word=FIFA&amp;amp;ct=301989888&amp;amp;rn=20&amp;amp;pn=0&amp;amp;db=0&amp;amp;s=0','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('258','','ʵ','http://down.52pk.com/sort/42_1.htm','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('259','','ʵƵ','http://video.baidu.com/v?word=%CA%B5%BF%F6%D7%E3%C7%F2&amp;amp;ct=301989888&amp;amp;rn=20&amp;amp;pn=0&amp;amp;db=0&amp;amp;s=0','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('260','','ϵ','http://game.gougou.com/search?search=%E8%B6%B3%E7%90%83%E7%BB%8F%E7%90%86&amp;amp;restype=1&amp;amp;id=1','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('261','','Ƶ','http://video.baidu.com/v?word=%D7%E3%C7%F2+%BE%AD%C0%ED&amp;amp;ct=301989888&amp;amp;rn=20&amp;amp;pn=0&amp;amp;db=0&amp;amp;s=0&amp;amp;fbl=1024','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('262','','Ƿ','http://www.playfifa.com/','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('263','','Fifa','http://post.baidu.com/f?ct=&amp;amp;tn=&amp;amp;rn=&amp;amp;pn=&amp;amp;lm=&amp;amp;sc=&amp;amp;kw=fifa&amp;amp;rs2=0&amp;amp;myselectvalue=1&amp;amp;word=fifa&amp;amp;tb=on','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('264','','Fifa̫ƽվ','http://www.pcgames.com.cn/fight/fifa/','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('265','','FIFA̳','http://bbs.fifachina.net/','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('266','','ȫʵ̳','http://bbs.winning11cn.com/','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('267','','̳ʵר','http://game.ali213.net/forum-255-1.html','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('268','','WSI','http://bbs.weshareit.net/','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('269','','ھ֮','http://www.ourcm.net/bbs/','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('270','','ֲ̳','http://www.fmclub.com.cn/bbs/','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('271','','̳ר','http://game.ali213.net/forum-271-1.html','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('272','','FMFans-ֲ','http://fmfans.cpgl.net/','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('273','','','http://www.ballpure.com/','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('274','','ʵflash','http://www.game.com.cn/games/1/1/champions%20field.html','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('275','','Ʒɳٷվ(Ӣ)','http://www.eagames.com/redesign/home.jsp','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('276','','Ʒɳ','http://post.baidu.com/f?ct=&amp;amp;tn=&amp;amp;rn=&amp;amp;pn=&amp;amp;lm=&amp;amp;sc=&amp;amp;kw=%BC%AB%C6%B7%B7%C9%B3%B5&amp;amp;rs2=0&amp;amp;myselectvalue=1&amp;amp;word=%BC%AB%C6%B7%B7%C9%B3%B5&amp;amp;tb=on','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('277','','FIFAϵ(52pk)','http://down.52pk.com/sort/209_1.htm','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('278','','˼Ʒɳ','http://games.sina.com.cn/z/nfs/indexpage.shtml','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('279','','enetƷɳ','http://games.enet.com.cn/zhuanti/nfs7ug2/','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('280','','52PKƷɳ','http://down.52pk.net/sort/194_1.htm','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('281','','21CNƷɳ','http://game.21cn.com/zhuanti/needforspeed8/','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('282','','QQƷɳ','http://gamezone.qq.com/z/nfs7/','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('283','','Ʒɳflash','http://www.game.com.cn/games/3/5/jpfc.html','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('284','','ɽĲ','http://blog.sina.com.cn/pal4','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('285','','йɽ','http://www.palunion.net/bbs/','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('286','','ٶɽ','http://post.baidu.com/f?kw=%CF%C9%BD%A3%C6%E6%CF%C0%B4%AB','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('287','','ɽֽ','http://image.baidu.com/i?tn=baiduimage&amp;amp;ct=201326592&amp;amp;cl=2&amp;amp;lm=-1&amp;amp;rn=16&amp;amp;word=%CF%C9%BD%A3%C6%E6%CF%C0%B4%AB%20%D3%CE%CF%B7&amp;amp;z=5','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('288','','ɽ4-TOMϷ','http://games.tom.com/zt/pal4/','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('289','','ɽ4̨ٷ','http://pal.joypark.com.tw/PAL4/index.asp','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('290','','ɽ4浵޸','http://dl.it.21cn.com/list.php?id=64661','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('291','','ɽ4ٷվ','http://www.softstar.sh.cn/pal4/pal4/index.htm','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('292','','ɽFlash','http://www.game.com.cn/games/7/2/mxjqxz.html','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('293','','СӲ̰','http://www.xiazaiba.com/html/864.html','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('294','','ʥ˹Ӳ̰','http://www.gougou.com/search?search=%E4%BE%A0%E7%9B%97%E7%8C%8E%E8%BD%A6%E6%89%8B%E5%9C%A3%E5%AE%89%E5%9C%B0%E5%88%97%E6%96%AF&amp;amp;restype=-1&amp;amp;id=100002','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('295','','','http://www.xiadaocn.com/','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('296','','Գ','http://post.baidu.com/f?kw=Գ','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('297','','Сȫ','http://games.sina.com.cn/handbook/2003/08/05144.shtml','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('298','','ʥ˹ȫ','http://gta.uuu9.com/2007/200704/79.shtml','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('299','','Сؼ','http://games.sina.com.cn/j/h/2005-01-04/1700.shtml','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('300','','ʥ˹ȫܼ','http://www.southcn.com/it/itgame/tvgames/miji/200501190082.htm','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('301','','ʥ˹21cnר','http://game.21cn.com/zhuanti/gta4/','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('302','','ɳͼƬ','http://image.baidu.com/i?tn=baiduimage&amp;amp;word=%CF%C0%B5%C1%B7%C9%B3%B5&amp;amp;z=0&amp;amp;lm=-1&amp;amp;ct=201326592&amp;amp;cl=2','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('303','','С','http://gta.uuu9.com/2007/200704/291.shtml','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('304','','ʥ˹','http://gta.uuu9.com/2007/200704/288.shtml','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('305','','sinaϿ','http://games.sina.com.cn/j/c/2005-04-30/2119.shtml','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('306','','ƻش','http://psp.chinagba.com/','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('307','','̫ƽϷPSP','http://www.pcgames.com.cn/tvgames/topic/psp/','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('308','','TOM PSP','http://games.tom.com/zt/psp/','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('309','','CnGba-PSP̳','http://www.cngba.com/forum-122-1.html','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('310','','21CN PSP','http://game.21cn.com/console/psp/','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('311','','SINA - \r\n  PSPר','http://games.sina.com.cn/t/PSP.shtml','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('312','','PSPձٷվ','http://www.playstation.jp/','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('313','','','http://www.pspper.com/','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('314','','PSPй','http://bbs.pspchina.net/','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('315','','PSPԴBT','http://bt.cngba.com/','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('316','','pspù','http://down.cngba.com/psp/pspsoft/tools/','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('317','','PSP','http://www.hao123.com/zhidao/zhidao_psp.htm','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('318','','PSPϷ֮','http://psp.gamehome.tv/','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('319','','WIIٷվ','http://us.wii.com/','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('320','','NDSٷվ','http://touch-ds.jp/','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('321','','PS3ٷվ','http://www.playbeyond.jp/main.html','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('322','','XBOXٷվ','http://www.xbox.com/en-US/','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('323','','CnGba - \r\n  Xbox360ȫλ','http://www.cngba.com/forum-122-1.html','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('324','','xbox-sky','http://www.xbox-sky.com/','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('325','','̫ƽϷ','http://www.pcgames.com.cn/tvgames/','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('326','','','http://www.nwbbs.com/','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('327','','QQϷ','http://gamezone.qq.com/tvgame/tvgame.shtml','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('328','','pchomeϷվ','http://game.pchome.net/tvg/','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('329','','SINAϷ','http://games.sina.com.cn/t','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('330','','enetϷ','http://games.enet.com.cn/console.shtml','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('331','','WII','http://www.cngba.com/forum-191-1.html','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('332','','21CNϷ','http://game.21cn.com/console/','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('333','','levelup','http://www.levelup.cn/','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('334','','ITϷ','http://it.com.cn/games/tv/','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('335','','TOMϷ','http://games.tom.com/tvgame/','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('336','','齫','http://www.game.com.cn/games/0/5/animal%20link.html','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('337','','','http://www.game.com.cn/games/2/0/MahjongBurger.html','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('338','','ħ','http://www.game.com.cn/games/8/5/wowconnect.html','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('339','','','http://www.game.com.cn/games/8/1/pet%20connect.html','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('340','','ﱦ','http://www.game.com.cn/games/1/5/cwbbllk.html','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('341','','Ů','http://www.game.com.cn/games/1/7/chaonvllk.html','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('342','','2.5','http://www.game.com.cn/games/4/0/chongwullk.html','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('343','','-й','http://www.game.com.cn/games/7/2/jdzgl.html','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('344','','캢','http://www.game.com.cn/games/8/0/hherllk.html','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('345','','С','http://www.game.com.cn/games/7/1/xlllk.html','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('346','','','http://www.game.com.cn/games/2/5/feixiullk.html','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('347','','ħ','http://www.game.com.cn/games/6/2/molillk.html','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('348','','Ǽ','http://www.game.com.cn/games/1/2/starllk.html','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('349','','','http://www.game.com.cn/games/5/3/cfllk.html','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('350','','','http://www.game.com.cn/games/1/7/hzhllkan.html','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('351','','2.6','http://www.game.com.cn/games/3/1/cwllkan.html','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('352','','','http://www.game.com.cn/games/2/6/guoshulianliankan.html','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('353','','twins','http://www.game.com.cn/games/3/5/twinslianliankan.html','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('354','','Сƺ','http://www.game.com.cn/games/5/5/xphllk.html','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('355','','Ŵ','http://www.game.com.cn/games/1/2/mnmzllk.html','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('356','','ȫ','http://www.game.com.cn/games/6/2/qxinllk.html','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('357','','Ƕ','http://www.game.com.cn/games/3/2/mydllk.html','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('358','','ӷ','http://www.game.com.cn/games/5/2/mjfllk.html','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('359','','־','http://www.game.com.cn/games/0/3/mbzllk.html','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('360','','ӹȺ','http://www.game.com.cn/games/4/3/mjyqxzllk.html','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('361','','齫','http://www.game.com.cn/games/7/3/mzlmjk.html','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('362','','3.0','http://www.game.com.cn/games/8/5/majiangllk.html','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('363','','װ齫','http://www.game.com.cn/games/8/5/majiangllk.html','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('364','','ʹ֮','http://www.game.com.cn/games/6/8/tszl.html','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('365','','QQ','http://www.game.com.cn/games/1/4/mxslk.html','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('366','','','http://www.game.com.cn/games/6/6/yyllk.html','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('367','','°','http://www.game.com.cn/games/7/3/xinbanxxk.html','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('368','','ƴͼ','http://www.xiaoyouxi.com/down/soft/680/23780.htm','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('369','','ɰ','http://www.game.com.cn/games/4/4/mkacwk.html','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('370','','','http://www.game.com.cn/games/1/5/cjllkan.html','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('371','','QQ','http://www.game.com.cn/games/7/2/qqllk231.html','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('372','','','http://www.game.com.cn/games/9/2/dwllk.html','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('373','','','http://www.game.com.cn/games/1/3/jizixiaoxiaokan.html','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('374','','','http://www.game.com.cn/games/4/5/bingtangxiaoxiaokan.html','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('375','','3D齫','http://www.4399.com/flash/4467.htm','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('376','','齫','http://www.4399.com/flash/10237.htm','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('377','','޵','http://www.4399.com/flash/7828.htm','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('378','','','http://www.4399.com/flash/7771.htm','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('379','','ͨ','http://www.4399.com/flash/4416.htm','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('380','','ɿ','http://www.4399.com/flash/8956.htm','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('381','','','http://games.tom.com/download/mini/20031017/cjml2.html','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('382','','³','http://games.qq.com/a/20031112/000240.htm','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('383','','䳬','http://www.nen.com.cn/72929506758754304/20041124/1551212.shtml','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('384','','֮·׸','http://www.456.net/games/608.htm','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('385','','','http://www.gameyes.com/swf/_4954.htm','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('386','','а','http://www.gameyes.com/swf/9014.htm','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('387','','ȹ','http://www.gameyes.com/swf/7994.htm','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('388','','СϷ','http://www.game.com.cn/games/3/1/mariominids.html','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('389','','','http://www.game.com.cn/games/7/2/mariomask.html','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('390','','','http://www.game.com.cn/games/7/2/mariomask.html','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('391','','½','http://www.4399.com/flash/9149.htm','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('392','','ֵ3','http://www.4399.com/flash/9499.htm','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('393','','С','http://www.4399.com/flash/8920.htm','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('394','','С','http://www.4399.com/flash/8764.htm','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('395','','','http://www.4399.com/flash/8762.htm','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('396','','','http://www.4399.com/flash/1651.htm','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('397','','֮ʱȡˮ','http://www.4399.com/flash/4794.htm','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('398','','','http://www.4399.com/flash/9739.htm','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('399','','','http://www.4399.com/flash/3822.htm','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('400','','ĸ','http://www.xiazaiba.com/html/245.html','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('401','','è','http://comic.sina.com.cn/f/2005-04-12/201050286.shtml','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('402','','','http://www.456.net/games/1046.htm','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('403','','flash','http://www.chinaren.com/20050407/n225075682.shtml','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('404','','','http://www.xiazaiba.com/html/638.html','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('405','','ű','http://cnc.gameyes.com/swf/_8053.htm','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('406','','','http://www.4399.com/flash/1352.htm','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('407','','޵','http://www.4399.net/flash/6741.htm','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('408','','ս','http://www.4399.net/flash/1937.htm','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('409','','ˮ','http://www.456.net/games/3479.htm','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('410','','˾','http://www.456.net/games/3273.htm','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('411','','','http://www.4399.net/flash/6567.htm','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('412','','ϼ','http://www.game.com.cn/searchcache/zuma.html','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('413','','ܱ','http://www.game.com.cn/games/3/7/xbbzuma.html','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('414','','̫½','http://www.4399.com/flash/2087.htm','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('415','','','http://www.4399.com/flash/9144.htm','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('416','','','http://www.4399.com/flash/8833.htm','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('417','','','http://www.xiazaiba.com/html/844.html','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('418','','Ϸ','http://www.4399.com/flash/8063.htm','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('419','','','http://www.4399.com/flash/7089.htm','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('420','','','http://www.4399.com/flash/3791.htm','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('421','','PP','http://www.4399.com/flash/1937.htm','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('422','','ʯ','http://www.4399.com/flash/2966.htm','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('423','','ٺ','http://www.4399.com/flash/8260.htm','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('424','','ͷ','http://www.4399.com/flash/5029.htm','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('425','','ŮIII','http://www.game.com.cn/games/9/9/MMdiningroomIII.html','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('426','','ʦpanny','http://www.game.com.cn/games/2/0/masterpanny.html','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('427','','СMMʦ','http://www.game.com.cn/games/4/0/MMcake.html','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('428','','ü','http://www.game.com.cn/games/8/0/MMdumpling.html','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('429','','MMѧ','http://www.xiaoyouxi.com/down/soft/1005/23711.htm','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('430','','ͷ','http://www.xiaoyouxi.com/down/soft/1005/23712.htm','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('431','','ͷúʦ','http://www.xiaoyouxi.com/down/soft/1005/23715.htm','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('432','','ٵơư','http://www.xiazaiba.com/html/670.html','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('433','','ܵʦ','http://www.xiaoyouxi.com/down/soft/1005/23719.htm','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('434','','弦','http://www.game.com.cn/games/7/4/jianjidan.html','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('435','','й','http://www.xiaoyouxi.com/down/soft/1005/23720.htm','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('436','','īʳ','http://www.xiaoyouxi.com/down/soft/1005/23721.htm','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('437','','','http://www.xiaoyouxi.com/down/soft/1005/23732.htm','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('438','','ʹ','http://www.xiaoyouxi.com/down/soft/1005/21752.htm','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('439','','տ','http://www.game.com.cn/games/0/2/haibianshaokao.html','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('440','','Ϳ','http://www.game.com.cn/games/3/0/kuaicanting.html','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('441','','ʳӹ','http://www.game.com.cn/games/6/4/lsjgc.html','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('442','','ʦŶ','http://www.xiazaiba.com/html/693.html','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('443','','λõ','http://www.game.com.cn/games/9/0/dangaowu.html','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('444','','','http://www.game.com.cn/games/2/1/huolizaocan.html','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('445','','MM','http://www.game.com.cn/youxi/7/3/mmhanbaodian.html','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('446','','ҿ','http://www.game.com.cn/youxi/4/3/zuofan.html','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('447','','⴮','http://www.game.com.cn/youxi/8/8/kebabvan.html','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('448','','弦','http://www.game.com.cn/youxi/7/4/jianjidan.html','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('449','','ʦտ','http://www.game.com.cn/youxi/5/0/shaokaodian.html','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('450','','Ŵ','http://www.game.com.cn/youxi/1/7/jipai.html','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('451','','͵','http://www.game.com.cn/youxi/5/1/kcdfws.html','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('452','','','http://www.4399.com/flash/6354.htm','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('453','','Ӫŵ','http://www.4399.com/flash/3605.htm','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('454','','','http://www.4399.com/flash/5870.htm','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('455','','Ҳ','http://www.4399.com/flash/1639.htm','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('456','','ձ˾','http://www.4399.com/flash/9128.htm','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('457','','ѧ','http://www.4399.com/flash/8980.htm','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('458','','','http://www.4399.com/flash/9137.htm','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('459','','տ','http://www.4399.com/flash/9136.htm','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('460','','ζ˾','http://www.4399.com/flash/8984.htm','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('461','','ʳС','http://www.4399.com/flash/8522.htm','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('462','','SUE','http://www.4399.com/flash/9712.htm','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('463','','սζտ','http://www.4399.com/flash/4573.htm','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('464','','Panny','http://www.4399.com/flash/5881.htm','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('465','','Ů','http://www.game.com.cn/games/2/3/chaojinvsheng.html','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('466','','Ҫ޸','http://www.game.com.cn/games/3/3/mingtianwoyaojiageini.html','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('467','','ħŮ','http://www.game.com.cn/games/6/3/mndtj.html','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('468','','Ů','http://www.game.com.cn/games/8/3/dbnl.html','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('469','','Ů9','http://www.game.com.cn/games/9/3/meinvshiyi9.html','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('470','','Ůͦ','http://www.game.com.cn/games/2/4/znrth.html','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('471','','ü','http://www.game.com.cn/games/5/4/jinglmm0206.html','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('472','','üȥԼ','http://www.game.com.cn/games/7/4/mmqyh.html','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('473','','Ů','http://www.game.com.cn/games/8/4/nwwans.html','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('474','','','http://www.game.com.cn/games/3/7/bianxingmeimei.html','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('475','','','http://www.game.com.cn/games/2/2/ghljt.html','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('476','','С','http://www.game.com.cn/games/4/2/falangxiaojie.html','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('477','','Ů֮','http://www.game.com.cn/games/2/1/gssjwt.html','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('478','','Ůսʿ','http://www.game.com.cn/games/8/2/msnzs.html','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('479','','Ĺ','http://www.game.com.cn/games/2/7/gzhuhuanyi.html','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('480','','ü','http://www.game.com.cn/games/1/3/mmzzj.html','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('481','','Ů19','http://www.game.com.cn/games/0/4/mngy19.html','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('482','','Ů20','http://www.game.com.cn/games/3/4/meinvgengyi20.html','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('483','','','http://www.game.com.cn/games/2/7/gzhuhuanyi.html','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('484','','ʱװ3','http://www.xiazaiba.com/html/694.html','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('485','','ħŮ','http://www.game.com.cn/games/6/3/mndtj.html','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('486','','Ůװ14','http://www.game.com.cn/games/9/4/meinvhuanzhuang14.html','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('487','','ԸСҰè','http://www.game.com.cn/games/0/5/xgxym.html','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('488','','MMױʦ','http://www.game.com.cn/games/0/1/mmhuazhuangshi.html','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('489','','ű޻ױ','http://www.game.com.cn/games/5/5/babiwawahuazhuang.html','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('490','','3','http://www.xiaoyouxi.com/down/soft/862/24067.htm','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('491','','Ů³','http://www.game.com.cn/youxi/2/8/girlfashion.html','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('492','','ܽػװ','http://www.game.com.cn/youxi/2/7/furonghuanzhuang.html','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('493','','üѧױ','http://www.game.com.cn/games/4/4/mmxhuaz.html','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('494','','ҹ','http://www.game.com.cn/games/0/5/huiguniang.html','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('495','','ӪСè','http://www.game.com.cn/games/2/9/jjxmm.html','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('496','','˯Ůװ','http://www.game.com.cn/youxi/7/0/shuiyimm.html','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('497','','ŮѤ','http://www.game.com.cn/games/6/4/girlnail.html','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('498','','黻װ','http://www.game.com.cn/youxi/2/2/spiritcloth.html','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('499','','췢Ů','http://www.game.com.cn/youxi/1/9/refhair.html','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('500','','Ư','http://www.game.com.cn/youxi/8/8/prettydoll.html','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('501','','ڼŮ','http://www.game.com.cn/youxi/8/8/beauty.html','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('502','','','http://www.game.com.cn/youxi/6/5/lilicloth.html','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('503','','','http://www.game.com.cn/games/8/4/dongriliange.html','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('504','','＾','http://www.game.com.cn/games/6/4/qiujifushi.html','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('505','','üĻױ','http://www.game.com.cn/games/7/4/mmhuazhuang.html','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('506','','','http://www.4399.com/flash/10166.htm','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('507','','ɰ','http://www.4399.com/flash/3958.htm','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('508','','','http://www.4399.com/flash/9509.htm','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('509','','鶨󷹵','http://www.4399.com/flash/4258.htm','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('510','','Ů','http://www.4399.com/flash/9677.htm','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('511','','Ҹ','http://www.4399.com/flash/9656.htm','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('512','','ɫ','http://www.4399.com/flash/7941.htm','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('513','','＾ʱװ','http://www.4399.com/flash/8090.htm','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('514','','ѧУС','http://www.4399.com/flash/10168.htm','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('515','','ͷӮ','http://www.4399.com/flash/10028.htm','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('516','','Ůװ','http://www.4399.com/flash/9996.htm','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('517','','SUEȥԼ','http://www.4399.com/flash/9688.htm','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('518','','崿ѧ','http://www.4399.com/flash/9482.htm','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('519','','DIYʼ׷','http://www.4399.com/flash/9195.htm','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('520','','ʹ֮','http://www.4399.com/flash/9034.htm','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('521','','','http://www.4399.com/flash/8646.htm','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('522','','ҹ','http://www.4399.com/flash/8650.htm','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('523','','7k7kСϷ','http://www.7k7k.com/','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('524','','4399СϷ','http://www.4399.com/','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('525','','СϷ','http://www.game.com.cn/','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('526','','СϷ007','http://www.yx007.com/','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('527','','456СϷ','http://www.456.net/','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('528','','QQϷƵ','http://games.qq.com/mini/mini.shtml','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('529','','21CN СϷ','http://game.21cn.com/mini/','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('530','','ţţϷ','http://www.niu-niu.com/','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('531','','Gameyes СϷ','http://www.gameyes.com/','706','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('532','','̳','http://bbs.ifeng.com/','2276','','yowao','3','0','0','0','');
INSERT INTO yowao_recycler VALUES('533','','»̳','http://forum.xinhuanet.com/','2276','','yowao','2','0','0','0','');
INSERT INTO yowao_recycler VALUES('534','','','http://www.tianya.cn/','2276','','yowao','5','0','0','0','');
INSERT INTO yowao_recycler VALUES('535','','Ѫ','http://bbs.tiexue.net/','2276','','yowao','4','0','0','0','');
INSERT INTO yowao_recycler VALUES('536','','Ѻ','http://news.sohu.com','832','','yowao','7','0','0','0','');
INSERT INTO yowao_recycler VALUES('537','','Ѷ','http://news.qq.com','832','','yowao','3','0','0','0','');
INSERT INTO yowao_recycler VALUES('538','','','http://news.sina.com.cn','832','','yowao','1','0','0','0','');
INSERT INTO yowao_recycler VALUES('539','','','http://news.163.com','832','','yowao','4','0','0','0','');
INSERT INTO yowao_recycler VALUES('540','','TOM','http://news.tom.com','832','','yowao','17','0','0','0','');
INSERT INTO yowao_recycler VALUES('541','','','http://www.ifeng.com/','832','','yowao','11','0','0','0','');
INSERT INTO yowao_recycler VALUES('542','','','http://www.chinanews.com.cn','832','','yowao','5','0','8','1','');
INSERT INTO yowao_recycler VALUES('543','','21CN','http://news.21cn.com','832','','yowao','18','0','0','0','');
INSERT INTO yowao_recycler VALUES('544','','','http://www.people.com.cn','832','','yowao','8','0','10','1','');
INSERT INTO yowao_recycler VALUES('545','','һ','http://www.oneyule.com','832','','yowao','12','0','0','0','');
INSERT INTO yowao_recycler VALUES('546','','','http://www.gmw.cn','832','','yowao','19','0','0','0','');
INSERT INTO yowao_recycler VALUES('547','','ǧ','http://www.qianlong.com','832','','yowao','14','0','0','0','');
INSERT INTO yowao_recycler VALUES('548','','CCTV','http://news.cctv.com/','832','','yowao','10','0','0','0','');
INSERT INTO yowao_recycler VALUES('549','','','http://www.eastday.com','832','','yowao','15','0','0','0','');
INSERT INTO yowao_recycler VALUES('550','','','http://www.dayoo.com','832','','yowao','13','0','0','0','');
INSERT INTO yowao_recycler VALUES('551','','Ϸ','http://www.southcn.com/','832','','yowao','20','0','0','0','');
INSERT INTO yowao_recycler VALUES('552','','CRI','http://gb.cri.cn/','832','','yowao','16','0','0','0','');
INSERT INTO yowao_recycler VALUES('553','','йŻ','http://cn.yahoo.com/','832','','yowao','6','0','1','1','');
INSERT INTO yowao_recycler VALUES('554','','л','http://news.china.com/','832','','yowao','9','0','0','0','');
INSERT INTO yowao_recycler VALUES('555','','»','http://www.xinhuanet.com/','832','','yowao','2','0','0','0','');
INSERT INTO yowao_recycler VALUES('556','','籨','http://www.zaobao.com','832','','yowao','27','0','39','1','');
INSERT INTO yowao_recycler VALUES('557','','й','http://www.ce.cn/','832','','yowao','21','0','0','0','');
INSERT INTO yowao_recycler VALUES('558','','й̨','http://www.chinataiwan.org/','832','','yowao','23','0','0','0','');
INSERT INTO yowao_recycler VALUES('559','','','http://www.rednet.cn/','832','','yowao','28','0','0','0','');
INSERT INTO yowao_recycler VALUES('560','','й','http://www.pladaily.com.cn/','832','','yowao','22','0','0','0','');
INSERT INTO yowao_recycler VALUES('561','','ʱ','http://www.huanqiu.com/','832','','yowao','26','0','6','1','');
INSERT INTO yowao_recycler VALUES('562','','йϿ','http://www.haixiachina.com','832','','yowao','24','0','0','0','');
INSERT INTO yowao_recycler VALUES('563','','ÿվ','http://www.nbd.com.cn/','832','','yowao','30','0','0','0','');
INSERT INTO yowao_recycler VALUES('564','','ӢBBC','http://www.bbc.co.uk/china/','1919','','yowao','1','0','0','0','');
INSERT INTO yowao_recycler VALUES('565','','ձ','http://chinese.joins.com/','1919','','yowao','9','0','0','0','');
INSERT INTO yowao_recycler VALUES('566','','Ӣ·͸','http://www.reuters.com/','1919','','yowao','10','0','0','0','');
INSERT INTO yowao_recycler VALUES('567','','ŦԼÿ','http://www.nydailynews.com/','1919','','yowao','11','0','0','0','');
INSERT INTO yowao_recycler VALUES('568','','CNN','http://www.cnn.com/','1919','','yowao','3','0','0','0','');
INSERT INTO yowao_recycler VALUES('569','','ʢű','http://www.newsday.com/','1919','','yowao','12','0','0','0','');
INSERT INTO yowao_recycler VALUES('570','','ܿ','http://www.newsweek.com/','1919','','yowao','13','0','0','0','');
INSERT INTO yowao_recycler VALUES('571','','ŦԼʱ','http://www.nytimes.com/','1919','','yowao','2','0','0','0','');
INSERT INTO yowao_recycler VALUES('572','','ձ()','http://chn.chosun.com/','1919','','yowao','15','0','0','0','');
INSERT INTO yowao_recycler VALUES('573','','ʱܿ','http://www.time.com/','1919','','yowao','4','0','0','0','');
INSERT INTO yowao_recycler VALUES('574','','˹֮','http://www.ruvr.ru/index.php?lng=pek','1919','','yowao','6','0','0','0','');
INSERT INTO yowao_recycler VALUES('575','','ʱӢİ','http://www.globaltimes.cn/','1919','','yowao','7','0','0','0','');
INSERT INTO yowao_recycler VALUES('576','','ձ','http://www.chinese.wsj.com/','1919','','yowao','8','0','0','0','');
INSERT INTO yowao_recycler VALUES('577','','Ӣ̩ʿ','http://www.timesonline.co.uk/','1919','','yowao','14','0','0','0','');
INSERT INTO yowao_recycler VALUES('578','','AB-߶','http://www.abbao.cn/','837','','yowao','1','0','0','0','');
INSERT INTO yowao_recycler VALUES('579','','Ϸ細','http://www.nfcmag.com/','837','','yowao','2','0','0','0','');
INSERT INTO yowao_recycler VALUES('580','','Ϸĩ','http://www.infzm.com/','837','','yowao','3','0','0','0','');
INSERT INTO yowao_recycler VALUES('581','','̱','http://hsb.hsw.cn/','837','','yowao','4','0','0','0','');
INSERT INTO yowao_recycler VALUES('582','','ӱ','http://www.dahe.cn/','837','','yowao','5','0','0','0','');
INSERT INTO yowao_recycler VALUES('583','','Ļ㱨','http://www.wenweipo.com/','837','','yowao','6','0','0','0','');
INSERT INTO yowao_recycler VALUES('584','','󹫱','http://www.takungpao.com/','837','','yowao','7','0','0','0','');
INSERT INTO yowao_recycler VALUES('585','','йձ','http://www.chinadaily.com.cn/','837','','yowao','9','0','0','0','');
INSERT INTO yowao_recycler VALUES('586','','','http://www.gxnews.com.cn/','837','','yowao','10','0','0','0','');
INSERT INTO yowao_recycler VALUES('587','','걨','http://bjyouth.ynet.com/','837','','yowao','11','0','0','0','');
INSERT INTO yowao_recycler VALUES('588','','ɽ','http://www.daynews.com.cn/','837','','yowao','12','0','0','0','');
INSERT INTO yowao_recycler VALUES('589','','','http://www.dbw.cn/','837','','yowao','13','0','0','0','');
INSERT INTO yowao_recycler VALUES('590','','','http://www.fjsen.com/','837','','yowao','14','0','0','0','');
INSERT INTO yowao_recycler VALUES('591','','¾','http://www.thebeijingnews.com/','837','','yowao','15','0','0','0','');
INSERT INTO yowao_recycler VALUES('592','','Ϸб','http://www.nddaily.com/','837','','yowao','16','0','0','0','');
INSERT INTO yowao_recycler VALUES('593','','Զб','http://yzdsb.hebnews.cn/','837','','yowao','17','0','0','0','');
INSERT INTO yowao_recycler VALUES('594','','򱱷','http://www.enorth.com.cn/','837','','yowao','18','0','0','0','');
INSERT INTO yowao_recycler VALUES('595','','','http://www.ycwb.com/','837','','yowao','19','0','0','0','');
INSERT INTO yowao_recycler VALUES('596','','','http://www.yangtse.com/','837','','yowao','20','0','0','0','');
INSERT INTO yowao_recycler VALUES('597','','ɽ','http://www.dzwww.com/','837','','yowao','21','0','0','0','');
INSERT INTO yowao_recycler VALUES('598','','ZCOM־','http://www.zcom.com/','837','','yowao','22','0','0','0','');
INSERT INTO yowao_recycler VALUES('599','','춼б','http://ctdsb.cnhubei.com/','837','','yowao','23','0','0','0','');
INSERT INTO yowao_recycler VALUES('600','','ضб','http://www.sanqindaily.com/','837','','yowao','24','0','0','0','');
INSERT INTO yowao_recycler VALUES('601','','컪','http://www.cqnews.net/','837','','yowao','25','0','0','0','');
INSERT INTO yowao_recycler VALUES('602','','','http://www.lnd.com.cn/','837','','yowao','26','0','0','0','');
INSERT INTO yowao_recycler VALUES('603','','','http://bbs.people.com.cn/','2276','','yowao','1','0','0','0','');
INSERT INTO yowao_recycler VALUES('604','','»̳','http://forum.xinhuanet.com/','2276','','yowao','4','0','0','0','');
INSERT INTO yowao_recycler VALUES('605','','̳','http://bbs.ifeng.com/','2276','','yowao','5','0','0','0','');
INSERT INTO yowao_recycler VALUES('606','','Ĺʹ۲','http://www.tianya.cn/Publicforum/ArticlesList/0/worldlook.shtml','2276','','yowao','6','0','0','0','');
INSERT INTO yowao_recycler VALUES('607','','Ѫ','http://bbs.tiexue.net/','2276','','yowao','3','0','0','0','');
INSERT INTO yowao_recycler VALUES('608','','ǿ','http://bbs.people.com.cn/','2276','','yowao','2','0','0','0','');
INSERT INTO yowao_recycler VALUES('609','','ſӰ','http://movie.youku.com','805','','yowao','1','0','0','0','');
INSERT INTO yowao_recycler VALUES('610','','Ӱ','http://movie.tudou.com/','805','','yowao','2','0','0','0','');
INSERT INTO yowao_recycler VALUES('611','','˴Ƭ','http://video.sina.com.cn/movie/','805','','yowao','3','0','0','0','');
INSERT INTO yowao_recycler VALUES('612','','Ӱ','http://movie.gougou.com/','805','','yowao','4','0','0','0','');
INSERT INTO yowao_recycler VALUES('613','','Ѹ׿','http://www.xunlei.com/','805','','yowao','5','0','0','0','');
INSERT INTO yowao_recycler VALUES('614','','ku6Ӱ','http://movie.ku6.com/','805','','yowao','8','0','0','0','');
INSERT INTO yowao_recycler VALUES('615','','ѺӰ','http://tv.sohu.com/hdtv/','805','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('616','','PPlive','http://www.pptv.com/','805','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('617','','Ӱ','http://movie.joy.cn/','805','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('618','','QQlive','http://live.qq.com','805','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('619','','Ӱ','http://www.gougou.com/','1119','','yowao','7','0','0','0','');
INSERT INTO yowao_recycler VALUES('620','','VeryCD','http://www.verycd.com/','1119','','yowao','2','0','0','0','');
INSERT INTO yowao_recycler VALUES('621','','˵ӰƵ','http://ent.sina.com.cn/film','1980','','yowao','2','0','0','0','');
INSERT INTO yowao_recycler VALUES('622','','ŻӰƵ','http://ent.cn.yahoo.com/movies/','1980','','yowao','5','0','0','0','');
INSERT INTO yowao_recycler VALUES('623','','һӰ','http://www.oneyule.com/movie/','1980','','yowao','3','0','0','0','');
INSERT INTO yowao_recycler VALUES('624','','ѶӰƵ','http://ent.qq.com/movie/','1980','','yowao','1','0','0','0','');
INSERT INTO yowao_recycler VALUES('625','','׵ӰƵ','http://ent.163.com/movie/','1980','','yowao','4','0','0','0','');
INSERT INTO yowao_recycler VALUES('626','','Ӱ','http://ent.ifeng.com/movie/','1980','','yowao','6','0','0','0','');
INSERT INTO yowao_recycler VALUES('627','','йӰ','http://www.chinafilm.com/','1980','','yowao','7','0','0','0','');
INSERT INTO yowao_recycler VALUES('628','','Mtimeʱ','http://www.mtime.com/','1980','','yowao','8','0','0','0','');
INSERT INTO yowao_recycler VALUES('629','','','http://www.shooter.com.cn/','2099','','yowao','1','0','0','0','');
INSERT INTO yowao_recycler VALUES('630','','С˵','http://www.xxsy.net/','645','','yowao','10','0','0','0','');
INSERT INTO yowao_recycler VALUES('631','','С˵Ķ','http://www.readnovel.com','645','','yowao','2','0','0','0','');
INSERT INTO yowao_recycler VALUES('632','','ѧ','http://www.zhulang.com','645','','yowao','11','0','0','0','');
INSERT INTO yowao_recycler VALUES('633','','ý','http://html.hjsm.tom.com/','645','','yowao','6','0','0','0','');
INSERT INTO yowao_recycler VALUES('634','','С˵','http://www.qukanshu.com/','645','','yowao','12','0','0','0','');
INSERT INTO yowao_recycler VALUES('635','','','http://www.qidian.com/','645','','yowao','1','0','0','0','');
INSERT INTO yowao_recycler VALUES('636','','17Kѧ','http://www.17k.com/','645','','yowao','9','0','0','0','');
INSERT INTO yowao_recycler VALUES('637','','','http://www.hongxiu.com','645','','yowao','3','0','0','0','');
INSERT INTO yowao_recycler VALUES('638','','С˵','http://www.xstxw.com','645','','yowao','18','0','0','0','');
INSERT INTO yowao_recycler VALUES('639','','С˵','http://www.laishu.com/','645','','yowao','5','0','0','0','');
INSERT INTO yowao_recycler VALUES('640','','ԭС˵','http://www.yuanwen.com/','645','','yowao','4','0','0','0','');
INSERT INTO yowao_recycler VALUES('641','','С˵','http://www.fmx.cn/','645','','yowao','16','0','0','0','');
INSERT INTO yowao_recycler VALUES('642','','ԭѧ','http://www.goodmood.cn','645','','yowao','20','0','0','0','');
INSERT INTO yowao_recycler VALUES('643','','-','http://www.douban.com/book','649','','yowao','5','0','0','0','');
INSERT INTO yowao_recycler VALUES('644','','˶','http://book.sina.com.cn/','649','','yowao','3','0','0','0','');
INSERT INTO yowao_recycler VALUES('645','','','http://www.rongshuxia.com/','649','','yowao','9','0','0','0','');
INSERT INTO yowao_recycler VALUES('646','','Ѷ','http://book.qq.com/','649','','yowao','1','0','0','0','');
INSERT INTO yowao_recycler VALUES('647','','Ѻ','http://book.sohu.com/','649','','yowao','2','0','0','0','');
INSERT INTO yowao_recycler VALUES('648','','','http://www.du8.com/','649','','yowao','7','0','0','0','');
INSERT INTO yowao_recycler VALUES('649','','Զ-¼','http://www.yandui.com/','649','','yowao','8','0','0','0','');
INSERT INTO yowao_recycler VALUES('650','','ߡ','http://www.duzhe.com/','649','','yowao','10','0','0','0','');
INSERT INTO yowao_recycler VALUES('651','','лʫ','http://www.zhsc.net/','649','','yowao','11','0','0','0','');
INSERT INTO yowao_recycler VALUES('652','','ͼ','http://www.nlc.gov.cn/','649','','yowao','13','0','0','0','');
INSERT INTO yowao_recycler VALUES('653','','Ѷ','http://book.hexun.com','649','','yowao','6','0','0','0','');
INSERT INTO yowao_recycler VALUES('654','','С','http://www.xiaogushi.com','649','','yowao','15','0','0','0','');
INSERT INTO yowao_recycler VALUES('655','','','http://www.qiuyuonline.com','648','','yowao','3','0','0','0','');
INSERT INTO yowao_recycler VALUES('656','','ŰƷļ','http://www.frostar.com/wenji.htm','648','','yowao','2','0','0','0','');
INSERT INTO yowao_recycler VALUES('657','','Ʒ','http://www.xiaoshuo.com/jsp/volumeview.jsp?vlmid=100:90003713','648','','yowao','19','0','0','0','');
INSERT INTO yowao_recycler VALUES('658','','СС˵','http://www.xxszj.com/','648','','yowao','8','0','0','0','');
INSERT INTO yowao_recycler VALUES('659','','ϯ','http://www.xijuan.com/','648','','yowao','1','0','0','0','');
INSERT INTO yowao_recycler VALUES('660','','ѧĶ','http://www.renyu.net/','648','','yowao','7','0','0','0','');
INSERT INTO yowao_recycler VALUES('661','','Ʒ','http://www.gjmcn.com/html/book','648','','yowao','6','0','0','0','');
INSERT INTO yowao_recycler VALUES('662','','Ʒļ','http://www.hongxiu.com/wenji/list/','648','','yowao','5','0','0','0','');
INSERT INTO yowao_recycler VALUES('663','','й','http://www.chinawriter.com.cn/','648','','yowao','9','0','0','0','');
INSERT INTO yowao_recycler VALUES('664','','³ѸƷȫ','http://www.lib.hstc.edu.cn/resource/luxun/index.htm','648','','yowao','10','0','0','0','');
INSERT INTO yowao_recycler VALUES('665','','Ʒ','http://www.40zw.cn/LiLiang.html','648','','yowao','23','0','0','0','');
INSERT INTO yowao_recycler VALUES('666','','Ʒ','http://www.40zw.cn/GuLing.html','648','','yowao','25','0','0','0','');
INSERT INTO yowao_recycler VALUES('667','','߿Ʒ','http://40zw.cn/NiKuang.html','648','','yowao','24','0','0','0','');
INSERT INTO yowao_recycler VALUES('668','','Ʒ','http://40zw.cn/LiangYuSheng.html','648','','yowao','21','0','0','0','');
INSERT INTO yowao_recycler VALUES('669','','Ʒ','http://www.40zw.cn/WoLongSheng.html','648','','yowao','20','0','0','0','');
INSERT INTO yowao_recycler VALUES('670','','ӹƷ','http://www.40zw.cn/JinYong.html','648','','yowao','16','0','0','0','');
INSERT INTO yowao_recycler VALUES('671','','Ʒ','http://www.40zw.cn/LiuCanYang.html','648','','yowao','22','0','0','0','');
INSERT INTO yowao_recycler VALUES('672','','Ʒ','http://www.40zw.cn/GuLong.html','648','','yowao','17','0','0','0','');
INSERT INTO yowao_recycler VALUES('673','','Ʒ','http://www.40zw.cn/HuangYi.html','648','','yowao','18','0','0','0','');
INSERT INTO yowao_recycler VALUES('674','','Ʒ','http://www.40zw.cn/LiLiang.html','648','','yowao','23','0','0','0','');
INSERT INTO yowao_recycler VALUES('675','','ϯƷ','http://www.xijuan.com/xijuan/index.htm','648','','yowao','28','0','0','0','');
INSERT INTO yowao_recycler VALUES('676','','Ʒ','http://www.40zw.cn/YiShu.html','648','','yowao','27','0','0','0','');
INSERT INTO yowao_recycler VALUES('677','','ѩƷ','http://www.40zw.cn/ShanFeiXue.html','648','','yowao','35','0','0','0','');
INSERT INTO yowao_recycler VALUES('678','','Ʒ','http://40zw.cn/ChiungYao.html','648','','yowao','26','0','0','0','');
INSERT INTO yowao_recycler VALUES('679','','Ʒ','http://40zw.cn/AnQi.html','648','','yowao','29','0','0','0','');
INSERT INTO yowao_recycler VALUES('680','','Ʒ','http://www.40zw.cn/ZuoQingWen.html','648','','yowao','30','0','0','0','');
INSERT INTO yowao_recycler VALUES('681','','Ʒ','http://www.40zw.cn/JiQiu.html','648','','yowao','31','0','0','0','');
INSERT INTO yowao_recycler VALUES('682','','Ʒ','http://www.40zw.cn/JinXuan.html','648','','yowao','32','0','0','0','');
INSERT INTO yowao_recycler VALUES('683','','Ʒ','http://www.40zw.cn/DianXin.html','648','','yowao','33','0','0','0','');
INSERT INTO yowao_recycler VALUES('684','','Ʒ','http://40zw.cn/YuQing.html','648','','yowao','34','0','0','0','');
INSERT INTO yowao_recycler VALUES('685','','Ѻ','http://sports.sohu.com','928','','yowao','2','0','0','0','');
INSERT INTO yowao_recycler VALUES('686','','Ѷ','http://sports.qq.com','928','','yowao','8','0','0','0','');
INSERT INTO yowao_recycler VALUES('687','','̳','http://sports.tom.com','928','','yowao','3','0','0','0','');
INSERT INTO yowao_recycler VALUES('688','','','http://sports.163.com','928','','yowao','5','0','0','0','');
INSERT INTO yowao_recycler VALUES('689','','','http://www.sportscn.com','928','','yowao','4','0','0','0','');
INSERT INTO yowao_recycler VALUES('690','','21CN','http://sports.21cn.com','928','','yowao','14','0','0','0','');
INSERT INTO yowao_recycler VALUES('691','','ESPNSTAR','http://www.espnstar.com.cn','928','','yowao','9','0','0','0','');
INSERT INTO yowao_recycler VALUES('692','','ܾ','http://www.sport.gov.cn','928','','yowao','15','0','0','0','');
INSERT INTO yowao_recycler VALUES('693','','ǿ','http://www.sports.cn','928','','yowao','12','0','0','0','');
INSERT INTO yowao_recycler VALUES('694','','»','http://www.xinhuanet.com/sports/','928','','yowao','13','0','0','0','');
INSERT INTO yowao_recycler VALUES('695','','','http://sports.people.com.cn/','928','','yowao','11','0','0','0','');
INSERT INTO yowao_recycler VALUES('696','','Ż','http://sports.cn.yahoo.com/','928','','yowao','6','0','0','0','');
INSERT INTO yowao_recycler VALUES('697','','','http://sports.sina.com.cn/','928','','yowao','1','0','0','0','');
INSERT INTO yowao_recycler VALUES('698','','CCTVƵ','http://sports.cctv.com/','928','','yowao','10','0','0','0','');
INSERT INTO yowao_recycler VALUES('699','','һ','http://www.oneyule.com/sports/','928','','yowao','7','0','0','0','');
INSERT INTO yowao_recycler VALUES('700','','sohu̳','http://club.sports.sohu.com/','929','','yowao','1','0','0','0','');
INSERT INTO yowao_recycler VALUES('701','','̳','http://bbs1.people.com.cn/boardList.do?action=postList&boardId=30','929','','yowao','7','0','0','0','');
INSERT INTO yowao_recycler VALUES('702','','TOM̳','http://bbs.sports.tom.com/','929','','yowao','6','0','0','0','');
INSERT INTO yowao_recycler VALUES('703','','»','http://forum.xinhuanet.com/listtopic.jsp?bid=50&sno=1&catid=5','929','','yowao','8','0','0','0','');
INSERT INTO yowao_recycler VALUES('704','','̳','http://sports.163.com/','929','','yowao','4','0','0','0','');
INSERT INTO yowao_recycler VALUES('705','','-۽','http://cache.tianya.cn/new/publicforum/articleslist.asp?stritem=sport&idwriter=0&key=0&part=','929','','yowao','2','0','0','0','');
INSERT INTO yowao_recycler VALUES('706','','ɳ','http://bbs.sports.sina.com.cn/','929','','yowao','3','0','0','0','');
INSERT INTO yowao_recycler VALUES('707','','CCTV','http://sports.bbs.cctv.com/','929','','yowao','5','0','0','0','');
INSERT INTO yowao_recycler VALUES('708','','Ѷй','http://sports.qq.com/csocce/','1021','','yowao','10','0','0','0','');
INSERT INTO yowao_recycler VALUES('709','','CCTV','http://www.cctv.com/program/totalsoccer/','1021','','yowao','14','0','0','0','');
INSERT INTO yowao_recycler VALUES('710','','Ѻй','http://sports.sohu.com/guoneizuqiu.shtml','1021','','yowao','7','0','0','0','');
INSERT INTO yowao_recycler VALUES('711','','й','http://sports.163.com/special/p/page01.html','1021','','yowao','8','0','0','0','');
INSERT INTO yowao_recycler VALUES('712','','Żй','http://cn.sports.yahoo.com/foot/cn/','1021','','yowao','9','0','0','0','');
INSERT INTO yowao_recycler VALUES('713','','˹̳','http://sports.sina.com.cn/china/','1021','','yowao','6','0','0','0','');
INSERT INTO yowao_recycler VALUES('714','','´NBAƵ','http://sports.nubb.com/nba/','2272','','yowao','2','0','0','0','');
INSERT INTO yowao_recycler VALUES('715','','NBA','http://nba.tom.com/','930','','yowao','1','0','34','1','');
INSERT INTO yowao_recycler VALUES('716','','»NBA','http://www.xinhuanet.com/sports/nba.htm','930','','yowao','6','0','0','0','');
INSERT INTO yowao_recycler VALUES('717','','NBA','http://sports.sina.com.cn/nba/','930','','yowao','2','0','0','0','');
INSERT INTO yowao_recycler VALUES('718','','ѺNBA','http://sports.sohu.com/nba.shtml','930','','yowao','3','0','0','0','');
INSERT INTO yowao_recycler VALUES('719','','NBA','http://sports.163.com/nba/','930','','yowao','4','0','0','0','');
INSERT INTO yowao_recycler VALUES('720','','WNBAٷվ','http://www.wnba.com/','930','','yowao','9','0','0','0','');
INSERT INTO yowao_recycler VALUES('721','','ѶNBA','http://sports.qq.com/nba/','930','','yowao','5','0','0','0','');
INSERT INTO yowao_recycler VALUES('722','','ֱ','http://www.zhibo8.com/','930','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('723','','','http://sports.sina.com.cn/basketball/','2116','','yowao','1','0','0','0','');
INSERT INTO yowao_recycler VALUES('724','','Ѻ','http://sports.sohu.com/lanqiu.shtml','2116','','yowao','2','0','0','0','');
INSERT INTO yowao_recycler VALUES('725','','ESPNSTAR-','http://www.espnstar.com.cn/new/basketball/','2116','','yowao','3','0','0','0','');
INSERT INTO yowao_recycler VALUES('726','','ϻ','http://www.fiba.com/','2116','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('727','','ͼ','http://pic.daqi.com','709','','yowao','1','0','0','0','');
INSERT INTO yowao_recycler VALUES('728','','йѧͼƬ','http://www.6to23.com/pic/','709','','yowao','10','0','0','0','');
INSERT INTO yowao_recycler VALUES('729','','ChinaRenͼ','http://pic.chinaren.com','709','','yowao','11','0','0','0','');
INSERT INTO yowao_recycler VALUES('730','','TIMEʱͼƬ','http://www.phototime.cn/','709','','yowao','6','0','0','0','');
INSERT INTO yowao_recycler VALUES('731','','ŻͼƬ','http://image.cn.yahoo.com/','709','','yowao','2','0','0','0','');
INSERT INTO yowao_recycler VALUES('732','','һͼ','http://www.oneyule.com/tupian','709','','yowao','8','0','0','0','');
INSERT INTO yowao_recycler VALUES('733','','ͼ','http://news.sina.com.cn/photo/','709','','yowao','7','0','0','0','');
INSERT INTO yowao_recycler VALUES('734','','̫ƽʱͼ','http://www.pclady.com.cn/photo/','709','','yowao','9','0','0','0','');
INSERT INTO yowao_recycler VALUES('735','','Ѷͼ','http://ent.qq.com/picture.shtml','709','','yowao','3','0','0','0','');
INSERT INTO yowao_recycler VALUES('736','','-ͼƬ','http://news.163.com/photo/','709','','yowao','12','0','0','0','');
INSERT INTO yowao_recycler VALUES('737','','»ͼƬ','http://www.xinhuanet.com/photo/','709','','yowao','5','0','0','0','');
INSERT INTO yowao_recycler VALUES('738','','ٶͼƬ','http://list.image.baidu.com/t/image_category/image_recommend.html','709','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('739','','̫ƽͼ','http://www.pclady.com.cn/photo/','710','','yowao','5','0','0','0','');
INSERT INTO yowao_recycler VALUES('740','','Ů','http://www.nvsheng.com/','710','','yowao','3','0','0','0','');
INSERT INTO yowao_recycler VALUES('741','','Ѷд','http://ent.qq.com/picture.shtml','710','','yowao','1','0','0','0','');
INSERT INTO yowao_recycler VALUES('742','','ģд-','http://www.shelive.net/ChModel/','710','','yowao','6','0','0','0','');
INSERT INTO yowao_recycler VALUES('743','','ɨͼش','http://www.youzi4.com/','710','','yowao','2','0','0','0','');
INSERT INTO yowao_recycler VALUES('744','','ٶŮ','http://list.image.baidu.com/t/image_category/image_women_stars1.html','710','','yowao','8','0','0','0','');
INSERT INTO yowao_recycler VALUES('745','','ٶ˧','http://list.image.baidu.com/t/image_category/image_men_stars1.html','710','','yowao','9','0','0','0','');
INSERT INTO yowao_recycler VALUES('746','','Ů','http://www.moko.cc/','710','','yowao','4','0','0','0','');
INSERT INTO yowao_recycler VALUES('747','','д','http://www.oneyule.com/tupian','710','','yowao','7','0','0','0','');
INSERT INTO yowao_recycler VALUES('748','','ͼƬַ','http://www.hao123.com/daquan/01tupian.htm','710','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('749','','Ѷ','http://astro.lady.qq.com','784','','yowao','6','0','0','0','');
INSERT INTO yowao_recycler VALUES('750','','','http://astro.sina.com.cn','784','','yowao','1','0','0','0','');
INSERT INTO yowao_recycler VALUES('751','','Ż','http://cn.astrology.yahoo.com','784','','yowao','4','0','0','0','');
INSERT INTO yowao_recycler VALUES('752','','21CN','http://life.21cn.com/horoscope/horoscope/','784','','yowao','10','0','0','0','');
INSERT INTO yowao_recycler VALUES('753','','','http://lady.163.com/special/00261PJK/constellation.html','784','','yowao','2','0','0','0','');
INSERT INTO yowao_recycler VALUES('754','','Ѻ','http://astro.women.sohu.com/','784','','yowao','5','0','0','0','');
INSERT INTO yowao_recycler VALUES('755','','TOM','http://astro.tom.com/','784','','yowao','3','0','0','0','');
INSERT INTO yowao_recycler VALUES('756','','MSN','http://astro.msn.com.cn/','784','','yowao','11','0','0','0','');
INSERT INTO yowao_recycler VALUES('757','','ռ-Ѷ','http://astro.lady.qq.com/tarot/','785','','yowao','3','0','0','0','');
INSERT INTO yowao_recycler VALUES('758','','ɶȡ','http://www.xingming.net/','785','','yowao','1','0','0','0','');
INSERT INTO yowao_recycler VALUES('759','','δȫ','http://life.httpcn.com/sm/','785','','yowao','8','0','0','0','');
INSERT INTO yowao_recycler VALUES('760','','Ƶղѯ','http://www.hdjr.org/','785','','yowao','2','0','0','0','');
INSERT INTO yowao_recycler VALUES('761','','','http://51.aqioo.com/','785','','yowao','4','0','0','0','');
INSERT INTO yowao_recycler VALUES('762','','ũ','http://www.nongli.com/','785','','yowao','7','0','0','0','');
INSERT INTO yowao_recycler VALUES('763','','','http://www.sheup.com','785','','yowao','6','0','0','0','');
INSERT INTO yowao_recycler VALUES('764','','ܹ','http://www.51jiemeng.com/','785','','yowao','4','0','0','0','');
INSERT INTO yowao_recycler VALUES('765','','','http://astro.sina.com.cn/test','787','','yowao','1','0','0','0','');
INSERT INTO yowao_recycler VALUES('766','','-39','http://xl.39.net/xlcs/','787','','yowao','2','0','0','0','');
INSERT INTO yowao_recycler VALUES('767','','Sohu','http://astro.women.sohu.com/ceshi.shtml','787','','yowao','4','0','0','0','');
INSERT INTO yowao_recycler VALUES('768','','Ѷ_','http://astro.lady.qq.com/augury/augu_test.shtml','787','','yowao','5','0','0','0','');
INSERT INTO yowao_recycler VALUES('769','','ѶƵ','http://comic.qq.com','777','','yowao','1','0','0','0','');
INSERT INTO yowao_recycler VALUES('770','','ѺƵ','http://comic.chinaren.com','777','','yowao','2','0','0','0','');
INSERT INTO yowao_recycler VALUES('771','','й','http://www.zhongman.com/','777','','yowao','3','0','0','0','');
INSERT INTO yowao_recycler VALUES('772','','˿ͨ','http://comic.book.sina.com.cn/','777','','yowao','4','0','0','0','');
INSERT INTO yowao_recycler VALUES('773','','Ѹ׶','http://anime.xunlei.com/','777','','yowao','9','0','0','0','');
INSERT INTO yowao_recycler VALUES('774','','Ӷ','http://comic.boxuu.com/','777','','yowao','6','0','0','0','');
INSERT INTO yowao_recycler VALUES('775','','ɿɶ','http://www.cococomic.com/','777','','yowao','8','0','0','0','');
INSERT INTO yowao_recycler VALUES('776','','۶','http://www.iieye.cc/','777','','yowao','5','0','0','0','');
INSERT INTO yowao_recycler VALUES('777','','','http://www.imanhua.com/','777','','yowao','7','0','0','0','');
INSERT INTO yowao_recycler VALUES('778','','Ƶ','http://cartoon.tudou.com/','2135','','yowao','1','0','0','0','');
INSERT INTO yowao_recycler VALUES('779','','56Ƶ','http://dm.56.com/','2135','','yowao','3','0','0','0','');
INSERT INTO yowao_recycler VALUES('780','','ku6Ƶ','http://www.ku6.com/comic/','2135','','yowao','4','0','0','0','');
INSERT INTO yowao_recycler VALUES('781','','','http://op.52pk.com/','779','','yowao','2','0','0','0','');
INSERT INTO yowao_recycler VALUES('782','','','http://comic.chinaren.com/s2006/wqwz/','779','','yowao','10','0','0','0','');
INSERT INTO yowao_recycler VALUES('783','','','http://comic.chinaren.com/s2006/dargonball/','779','','yowao','7','0','0','0','');
INSERT INTO yowao_recycler VALUES('784','','Ȯҹ','http://comic.qq.com/z/quanyecha/','779','','yowao','9','0','0','0','');
INSERT INTO yowao_recycler VALUES('785','','ߴ','http://comic.qq.com/z/gseedd','779','','yowao','4','0','0','0','');
INSERT INTO yowao_recycler VALUES('786','','֮ʦ','http://game.21cn.com/zhuanti/comic/hagaren/','779','','yowao','6','0','0','0','');
INSERT INTO yowao_recycler VALUES('787','','̽','http://comic.qq.com/z/conan/','779','','yowao','5','0','0','0','');
INSERT INTO yowao_recycler VALUES('788','','ӰNaruto','http://narutocn.52pk.com/','779','','yowao','1','0','0','0','');
INSERT INTO yowao_recycler VALUES('789','','','http://sishen.52pk.com/','779','','yowao','3','0','0','0','');
INSERT INTO yowao_recycler VALUES('790','','ν','http://comic.qq.com/z/tfmv','779','','yowao','8','0','0','0','');
INSERT INTO yowao_recycler VALUES('791','','Ŷ','http://static.tieba.baidu.com/tb/cms/hao123/cartoon.html','2135','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('792','','ѶЦ','http://joke.qq.com','732','','yowao','2','0','0','0','');
INSERT INTO yowao_recycler VALUES('793','','','http://www.xxhh.net','732','','yowao','1','0','0','0','');
INSERT INTO yowao_recycler VALUES('794','','TOMЦ','http://happy.tom.com/','732','','yowao','3','0','0','0','');
INSERT INTO yowao_recycler VALUES('795','','21cnĬ','http://life.21cn.com/humour/','732','','yowao','4','0','0','0','');
INSERT INTO yowao_recycler VALUES('796','','Ŀ','http://www.haha168.com/','732','','yowao','6','0','0','0','');
INSERT INTO yowao_recycler VALUES('797','','Ĭ','http://www.haha365.com','732','','yowao','7','0','0','0','');
INSERT INTO yowao_recycler VALUES('798','','ZOLЦ','http://xiaohua.zol.com.cn/','732','','yowao','5','0','0','0','');
INSERT INTO yowao_recycler VALUES('799','','ſЦƵ','http://www.youku.com/v_showlist/t2d1c94.html','1973','','yowao','1','0','0','0','');
INSERT INTO yowao_recycler VALUES('800','','ЦƵ','http://fun.tudou.com/','1973','','yowao','3','0','0','0','');
INSERT INTO yowao_recycler VALUES('801','','QQЦƵ','http://joke.qq.com/jokevideo/video.shtml','1973','','yowao','4','0','0','0','');
INSERT INTO yowao_recycler VALUES('802','','6ЦƵ','http://www.ku6.com/gaoxiao','1973','','yowao','2','0','0','0','');
INSERT INTO yowao_recycler VALUES('803','','','http://www.leitie.com','733','','yowao','2','0','0','0','');
INSERT INTO yowao_recycler VALUES('804','','','http://jionger.com/','733','','yowao','3','0','0','0','');
INSERT INTO yowao_recycler VALUES('805','','ɽկ','http://www.shanzhaiba.com/','733','','yowao','6','0','0','0','');
INSERT INTO yowao_recycler VALUES('806','','','http://www.chinabug.net/','733','','yowao','7','0','0','0','');
INSERT INTO yowao_recycler VALUES('807','','ǰЦ','http://lengxiaohua.net/','733','','yowao','4','0','0','0','');
INSERT INTO yowao_recycler VALUES('808','','׵','http://www.beileidaole.com/','733','','yowao','1','0','0','0','');
INSERT INTO yowao_recycler VALUES('809','','滢','http://www.qihoo.com','675','','yowao','12','0','0','0','');
INSERT INTO yowao_recycler VALUES('810','','ݾֲ','http://pop.pcpop.com','675','','yowao','19','0','0','0','');
INSERT INTO yowao_recycler VALUES('811','','QQ̳','http://bbs.qq.com','675','','yowao','5','0','0','0','');
INSERT INTO yowao_recycler VALUES('812','','ͬ','http://www.xici.net','675','','yowao','8','0','0','0','');
INSERT INTO yowao_recycler VALUES('813','','̳','http://bbs.phoenixtv.com','675','','yowao','16','0','0','0','');
INSERT INTO yowao_recycler VALUES('814','','Ѻ','http://club.sohu.com','675','','yowao','4','0','0','0','');
INSERT INTO yowao_recycler VALUES('815','','̳','http://bbs.163.com','675','','yowao','6','0','0','0','');
INSERT INTO yowao_recycler VALUES('816','','̳','http://www.bbs020.com/','675','','yowao','10','0','0','0','');
INSERT INTO yowao_recycler VALUES('817','','̳','http://bbs.sina.com.cn/','675','','yowao','3','0','0','0','');
INSERT INTO yowao_recycler VALUES('818','','л̳','http://bbs.china.com','675','','yowao','15','0','0','0','');
INSERT INTO yowao_recycler VALUES('819','','','http://www.tianya.cn/','675','','yowao','1','0','31','1','');
INSERT INTO yowao_recycler VALUES('820','','̳','http://bbs.hnol.net/','675','','yowao','7','0','0','0','');
INSERT INTO yowao_recycler VALUES('821','','»̳','http://forum.xinhuanet.com/','675','','yowao','11','0','0','0','');
INSERT INTO yowao_recycler VALUES('822','','','http://club.cat898.com/','675','','yowao','17','0','0','0','');
INSERT INTO yowao_recycler VALUES('823','','̳','http://club.dayoo.com/','675','','yowao','20','0','0','0','');
INSERT INTO yowao_recycler VALUES('824','','½','http://www.xilu.com/','675','','yowao','18','0','0','0','');
INSERT INTO yowao_recycler VALUES('825','','è˴ӻ','http://dzh.mop.com/','675','','yowao','9','0','0','0','');
INSERT INTO yowao_recycler VALUES('826','','̳','http://bbs.cctv.com/','675','','yowao','14','0','0','0','');
INSERT INTO yowao_recycler VALUES('827','','è','http://tt.mop.com/','675','','yowao','2','0','0','0','');
INSERT INTO yowao_recycler VALUES('828','','Chinaren','http://club.chinaren.com/','675','','yowao','13','0','0','0','');
INSERT INTO yowao_recycler VALUES('829','','ǿ','http://bbs.people.com.cn','675','','yowao','30','0','0','0','');
INSERT INTO yowao_recycler VALUES('830','','Tom','http://club.tom.com','675','','yowao','29','0','0','0','');
INSERT INTO yowao_recycler VALUES('831','','̳','http://bbs.ynet.com','675','','yowao','45','0','0','0','');
INSERT INTO yowao_recycler VALUES('832','','Ϸ','http://bbs.southcn.com','675','','yowao','43','0','0','0','');
INSERT INTO yowao_recycler VALUES('833','','Ĵ','http://bbs.newssc.org/','675','','yowao','23','0','0','0','');
INSERT INTO yowao_recycler VALUES('834','','̳','http://bbs.cri.cn/','675','','yowao','26','0','0','0','');
INSERT INTO yowao_recycler VALUES('835','','Ϻ߻','http://bbs.online.sh.cn/','675','','yowao','37','0','0','0','');
INSERT INTO yowao_recycler VALUES('836','','̳','http://bbs.qianlong.com/','675','','yowao','21','0','0','0','');
INSERT INTO yowao_recycler VALUES('837','','19¥̳','http://www.19lou.com/','675','','yowao','31','0','0','0','');
INSERT INTO yowao_recycler VALUES('838','','ൺ','http://club.qingdaonews.com/','675','','yowao','38','0','0','0','');
INSERT INTO yowao_recycler VALUES('839','','̳','http://bbs.hangzhou.com.cn/','675','','yowao','39','0','0','0','');
INSERT INTO yowao_recycler VALUES('840','','ڱŻ','http://www.daqi.com','675','','yowao','47','0','0','0','');
INSERT INTO yowao_recycler VALUES('841','','ʱ̳','http://bbs.huanqiu.com','675','','yowao','48','0','0','0','');
INSERT INTO yowao_recycler VALUES('842','','ٺ','http://www.baihe.com','790','','yowao','2','0','0','0','');
INSERT INTO yowao_recycler VALUES('843','','׼Լ','http://idate.163.com/','790','','yowao','14','0','0','0','');
INSERT INTO yowao_recycler VALUES('844','','ѽ','http://www.yeeyoo.com','790','','yowao','15','0','0','0','');
INSERT INTO yowao_recycler VALUES('845','','QQ','http://jiaoyou.qq.com/','790','','yowao','4','0','0','0','');
INSERT INTO yowao_recycler VALUES('846','','','http://www.loveinhere.com','790','','yowao','17','0','0','0','');
INSERT INTO yowao_recycler VALUES('847','','鹫Ԣ','http://www.ipart.cn','790','','yowao','3','0','0','0','');
INSERT INTO yowao_recycler VALUES('848','','','http://www.wangyou.com/','790','','yowao','18','0','0','0','');
INSERT INTO yowao_recycler VALUES('849','','MySpace','http://www.myspace.cn/','790','','yowao','11','0','45','1','');
INSERT INTO yowao_recycler VALUES('850','','','http://www.wealink.com/','790','','yowao','12','0','0','0','');
INSERT INTO yowao_recycler VALUES('851','','51ѿռ','http://www.51.com/','790','','yowao','8','0','0','0','');
INSERT INTO yowao_recycler VALUES('852','','֪','http://www.zhiji.com/','790','','yowao','10','0','0','0','');
INSERT INTO yowao_recycler VALUES('853','','','http://www.5lin.com','790','','yowao','12','0','0','0','');
INSERT INTO yowao_recycler VALUES('854','','360Ȧ','http://www.360quan.com','790','','yowao','7','0','0','0','');
INSERT INTO yowao_recycler VALUES('855','','èHi','http://hi.mop.com/','790','','yowao','5','0','0','0','');
INSERT INTO yowao_recycler VALUES('856','','֪','http://www.zhiyin.com.cn/','792','','yowao','1','0','0','0','');
INSERT INTO yowao_recycler VALUES('857','','-ѺŮ','http://women.sohu.com/hunyinjiating.shtml','792','','yowao','8','0','0','0','');
INSERT INTO yowao_recycler VALUES('858','','','http://eladies.sina.com.cn/feel/index.shtml','792','','yowao','4','0','0','0','');
INSERT INTO yowao_recycler VALUES('859','','','http://www.ruiliren.com/qinggan/','792','','yowao','3','0','0','0','');
INSERT INTO yowao_recycler VALUES('860','','Ů֪','http://www.nvzhiyin.com','792','','yowao','2','0','0','0','');
INSERT INTO yowao_recycler VALUES('861','','Ҹ','http://www.xfwed.com/','792','','yowao','14','0','0','0','');
INSERT INTO yowao_recycler VALUES('862','','QQǽ','http://lovewall.qq.com/','792','','yowao','15','0','0','0','');
INSERT INTO yowao_recycler VALUES('863','','ͼԵ','http://www.love21cn.com','791','','yowao','5','0','0','0','');
INSERT INTO yowao_recycler VALUES('864','','','http://www.marry5.com/','791','','yowao','12','0','0','0','');
INSERT INTO yowao_recycler VALUES('865','','Ҹ','http://www.xfwed.com/','791','','yowao','6','0','0','0','');
INSERT INTO yowao_recycler VALUES('866','','߻','http://gb.cri.cn/fashion/brides.htm','791','','yowao','4','0','0','0','');
INSERT INTO yowao_recycler VALUES('867','','ǳ','http://verywed.com/','791','','yowao','7','0','0','0','');
INSERT INTO yowao_recycler VALUES('868','','ѺƵ','http://women.sohu.com/womenmarry/','791','','yowao','6','0','0','0','');
INSERT INTO yowao_recycler VALUES('869','','й','http://www.1wed.cn/','791','','yowao','1','0','0','0','');
INSERT INTO yowao_recycler VALUES('870','','þû','http://www.99wed.com/','791','','yowao','11','0','0','0','');
INSERT INTO yowao_recycler VALUES('871','','й','http://www.chinajiehun.com/','791','','yowao','2','0','0','0','');
INSERT INTO yowao_recycler VALUES('872','','Ը','http://www.idoido.com.cn/','791','','yowao','10','0','0','0','');
INSERT INTO yowao_recycler VALUES('873','','й','http://www.wedcn.cn/','791','','yowao','8','0','0','0','');
INSERT INTO yowao_recycler VALUES('874','','','http://www.helloziyi.com/','2368','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('875','','ܽ','http://www.jaycn.com/','2368','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('876','','','http://tieba.baidu.com/f?kw=%C0%EE%D3%EE%B4%BA','2368','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('877','','쾲ٵĲ','http://blog.sina.com.cn/xujinglei','2368','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('878','','Ĳ','http://blog.sina.com.cn/JackieChan','2368','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('879','','','http://tieba.baidu.com/f?kw=%B6%AB%B7%BD%C9%F1%C6%F0','2368','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('880','','S.H.E½Ԯ','http://www.sheshow.net/','2368','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('881','','ܹ','http://www.jetli.com/','2368','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('882','','ݹ','http://www.britneyspears.com/','2368','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('883','','к','http://blog.backstreetboys.com/','2368','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('884','','Ŀ','http://www.hunantv.com/lanmu1.htm','2369','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('885','','','http://ent.joy.cn/','2369','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('886','','ִӪ','http://www.baidu.com/s?wd=%BF%EC%C0%D6%B4%F3%B1%BE%D3%AA','2369','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('887','','','http://www.baidu.com/s?wd=%BF%B5%CE%F5%C0%B4%C1%CB','2369','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('888','','ҲҲҲ²²','http://www.baidu.com/s?wd=%CE%D2%B2%C2%CE%D2%B2%C2%CE%D2%B2%C2%B2%C2%B2%C2','2369','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('889','','趯漣','http://www.baidu.com/s?wd=%CE%E8%B6%AF%C6%E6%BC%A3','2369','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('890','','ͬһ׸','http://www.baidu.com/s?wd=%CD%AC%D2%BB%CA%D7%B8%E8','2369','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('891','','һ','http://www.oneyule.com','825','','yowao','3','0','0','0','');
INSERT INTO yowao_recycler VALUES('892','','Ż','http://ent.cn.yahoo.com/','825','','yowao','5','0','0','0','');
INSERT INTO yowao_recycler VALUES('893','','','http://ent.sina.com.cn/','825','','yowao','4','0','0','0','');
INSERT INTO yowao_recycler VALUES('894','','TOM','http://ent.tom.com','825','','yowao','2','0','0','0','');
INSERT INTO yowao_recycler VALUES('895','','','http://ent.163.com/','825','','yowao','1','0','0','0','');
INSERT INTO yowao_recycler VALUES('896','','Ѷ','http://ent.qq.com/','825','','yowao','6','0','0','0','');
INSERT INTO yowao_recycler VALUES('897','','','http://ent.daqi.com/','825','','yowao','7','0','0','0','');
INSERT INTO yowao_recycler VALUES('898','','','http://ent.ifeng.com','825','','yowao','9','0','0','0','');
INSERT INTO yowao_recycler VALUES('899','','QQ','http://www.qqok.net','825','','yowao','8','0','0','0','');
INSERT INTO yowao_recycler VALUES('900','','ͼƬ','http://xiuxiu.meitu.com/','2371','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('901','','OLͼƬ','http://www.fzlol.com/','2371','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('902','','','http://www.feizl.com','2371','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('903','','ͼ','http://web.meitu.com/','2371','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('904','','ת','http://www.wzfzl.cn/','2371','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('905','','138ͼƬ','http://www.fzl138.com/','2371','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('906','','','http://id.igogo8.com/','2371','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('907','','','http://www.skmn.cn/','2371','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('908','','ռģ','http://www.fzl138.com/feizhuliu/kongjian/','2371','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('909','','QQJAYռվ','http://www.qqjay.com/','2371','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('910','','','http://www.fzlfx.com/','2371','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('911','','ͼƬ','http://www.fzlgo.com/','2371','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('912','','ͼ','http://xiuxiu.meitu.com/','2372','','yowao','1','0','0','0','');
INSERT INTO yowao_recycler VALUES('913','','ͼز','http://bbs.meitu.com/?gid=4','2372','','yowao','2','0','0','0','');
INSERT INTO yowao_recycler VALUES('914','','ͼ̳','http://bbs.meitu.com/forum-22-1.html','2372','','yowao','3','0','0','0','');
INSERT INTO yowao_recycler VALUES('915','','ͼ','http://kankan.meitu.com/','2372','','yowao','4','0','0','0','');
INSERT INTO yowao_recycler VALUES('916','','Picasa','http://picasa.google.com/intl/zh-CN/','2372','','yowao','5','0','0','0','');
INSERT INTO yowao_recycler VALUES('917','','Ӱħ','http://www.neoimaging.cn/','2372','','yowao','6','0','0','0','');
INSERT INTO yowao_recycler VALUES('918','','뷨','http://www.52hxw.com/','2373','','yowao','1','0','0','0','');
INSERT INTO yowao_recycler VALUES('919','','ǩ','http://www.huoxingyu.com/qqfantiqianming.php','2373','','yowao','2','0','0','0','');
INSERT INTO yowao_recycler VALUES('920','','','http://www.huoxingyu.com/qqfantinetname.php','2373','','yowao','3','0','0','0','');
INSERT INTO yowao_recycler VALUES('921','','ת','http://www.huoxingyu.com/#1','2373','','yowao','4','0','0','0','');
INSERT INTO yowao_recycler VALUES('922','','뷨','http://www.52fanti.com/','2373','','yowao','5','0','0','0','');
INSERT INTO yowao_recycler VALUES('923','','','http://www.huoxingwen.com/','2373','','yowao','6','0','0','0','');
INSERT INTO yowao_recycler VALUES('924','','Ĺ','http://www.hxwgj.com/','2373','','yowao','7','0','0','0','');
INSERT INTO yowao_recycler VALUES('925','','','http://www.huoxingyu.com/','2373','','yowao','8','0','0','0','');
INSERT INTO yowao_recycler VALUES('926','','ת','http://www.52fanti.com/default.aspx#LinkTrf','2373','','yowao','9','0','0','0','');
INSERT INTO yowao_recycler VALUES('927','','-ٶȰٿ','http://baike.baidu.com/view/32668.htm','2373','','yowao','10','0','0','0','');
INSERT INTO yowao_recycler VALUES('928','','뷨-ٿ','http://baike.baidu.com/view/1190383.htm','2373','','yowao','11','0','0','0','');
INSERT INTO yowao_recycler VALUES('929','','Ѻ','http://mil.news.sohu.com','726','','yowao','9','0','0','0','');
INSERT INTO yowao_recycler VALUES('930','','˾','http://mil.news.sina.com.cn/','726','','yowao','4','0','0','0','');
INSERT INTO yowao_recycler VALUES('931','','ǧ','http://mil.qianlong.com','726','','yowao','7','0','0','0','');
INSERT INTO yowao_recycler VALUES('932','','Ѫ','http://www.tiexue.net','726','','yowao','2','0','0','0','');
INSERT INTO yowao_recycler VALUES('933','','й','http://www.chinamil.com.cn','726','','yowao','14','0','0','0','');
INSERT INTO yowao_recycler VALUES('934','','Ѷ-','http://news.qq.com/militery.shtml','726','','yowao','6','0','0','0','');
INSERT INTO yowao_recycler VALUES('935','','-','http://military.people.com.cn/','726','','yowao','8','0','0','0','');
INSERT INTO yowao_recycler VALUES('936','','»-','http://www.xinhua.org/mil/','726','','yowao','3','0','0','0','');
INSERT INTO yowao_recycler VALUES('937','','½','http://junshi.xilu.com/','726','','yowao','10','0','0','0','');
INSERT INTO yowao_recycler VALUES('938','','й','http://www.mod.gov.cn/','726','','yowao','16','0','0','0','');
INSERT INTO yowao_recycler VALUES('939','','л','http://military.china.com/','726','','yowao','1','0','0','0','');
INSERT INTO yowao_recycler VALUES('940','','׶','http://www.junshijia.com/','726','','yowao','12','0','0','0','');
INSERT INTO yowao_recycler VALUES('941','','й','http://www.junren.net/','726','','yowao','15','0','0','0','');
INSERT INTO yowao_recycler VALUES('942','','','http://news.ifeng.com/mil/','726','','yowao','5','0','0','0','');
INSERT INTO yowao_recycler VALUES('943','','йս','http://www.chinaiiss.org','726','','yowao','11','0','0','0','');
INSERT INTO yowao_recycler VALUES('944','','л̳','http://bbs.military.china.com','727','','yowao','2','0','0','0','');
INSERT INTO yowao_recycler VALUES('945','','Ѫ̳','http://bbs.tiexue.net','727','','yowao','3','0','0','0','');
INSERT INTO yowao_recycler VALUES('946','','»̳','http://forum.xinhuanet.com/listtopic.jsp?bid=92','727','','yowao','1','0','0','0','');
INSERT INTO yowao_recycler VALUES('947','','й','http://www.chinamil.com.cn/site1/gwgfsq/index.htm','727','','yowao','12','0','0','0','');
INSERT INTO yowao_recycler VALUES('948','','̳','http://junshi.daqi.com/','727','','yowao','5','0','0','0','');
INSERT INTO yowao_recycler VALUES('949','','˾̳','http://bbs.news.sina.com.cn/g_forum/00/04/00/','727','','yowao','6','0','0','0','');
INSERT INTO yowao_recycler VALUES('950','','̳','http://bbs.huanqiu.com/huanqiujunshi/forum-7-1.html','727','','yowao','7','0','0','0','');
INSERT INTO yowao_recycler VALUES('951','','½̳','http://club.xilu.com/mainpagelist.php?typeid=2','727','','yowao','10','0','0','0','');
INSERT INTO yowao_recycler VALUES('952','','̳','http://bbs.junren.net/','727','','yowao','13','0','0','0','');
INSERT INTO yowao_recycler VALUES('953','','QQ','http://im.qq.com/qq/all.shtml','2362','','yowao','1','0','0','0','');
INSERT INTO yowao_recycler VALUES('954','','QQƤ','http://im.qq.com/cgi-bin/skin/skin','2362','','yowao','2','0','0','0','');
INSERT INTO yowao_recycler VALUES('955','','QQ','http://freeqqm.qq.com/','2362','','yowao','3','0','0','0','');
INSERT INTO yowao_recycler VALUES('956','','QQ','http://photo.qq.com/','2362','','yowao','4','0','0','0','');
INSERT INTO yowao_recycler VALUES('957','','QQУ','http://xiaoyou.qq.com/','2362','','yowao','5','0','0','0','');
INSERT INTO yowao_recycler VALUES('958','','ҳQQ','http://im.qq.com/webqq/','2362','','yowao','6','0','0','0','');
INSERT INTO yowao_recycler VALUES('959','','ҵQQ','http://my.qq.com/','2362','','yowao','7','0','0','0','');
INSERT INTO yowao_recycler VALUES('960','','QQ԰','http://www.qqjia.com/','2362','','yowao','8','0','0','0','');
INSERT INTO yowao_recycler VALUES('961','','ͷȫ','http://www.touxiang.cn','2363','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('962','','QQͷ','http://www.fzl138.com/feizhuliu/touxiang/','2363','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('963','','QQͷר','http://www.qqtouxiangzq.com/','2363','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('964','','ϺQQͷ','http://www.xiaake.cn/','2363','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('965','','QQͷ','http://www.qqkt.cn/','2363','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('966','','QQռ','http://qzone.qq.com/','2364','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('967','','QQռվ','http://www.qzone.cc/','2364','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('968','','QQУ','http://www.qqxn.com/','2364','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('969','','QQǿռվ','http://www.qqwen.com/','2364','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('970','','Ϸ','http://www.wanyouxi.com/','701','','yowao','5','0','0','0','');
INSERT INTO yowao_recycler VALUES('971','','52PKСϷ','http://flash.52pk.com/','701','','yowao','13','0','0','0','');
INSERT INTO yowao_recycler VALUES('972','','4399Ϸ','http://www.4399.com/','701','','yowao','1','0','40','0','');
INSERT INTO yowao_recycler VALUES('973','','СϷ','http://www.xiaoyouxi.com/','701','','yowao','8','0','0','0','');
INSERT INTO yowao_recycler VALUES('974','','007СϷ','http://www.yx007.com/','701','','yowao','9','0','0','0','');
INSERT INTO yowao_recycler VALUES('975','','7k7kСϷ','http://www.7k7k.com/','701','','yowao','6','0','0','0','');
INSERT INTO yowao_recycler VALUES('976','','СϷ','http://www.game.com.cn/','701','','yowao','2','0','0','0','');
INSERT INTO yowao_recycler VALUES('977','','VSӰV0.9','http://www.4399.com/flash/9254.htm','2255','','yowao','1','0','0','0','');
INSERT INTO yowao_recycler VALUES('978','','Ӱ֮ľҶս','http://www.4399.com/flash/9489.htm','2255','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('979','','鶯','http://www.4399.com/flash/8150.htm','2255','','yowao','2','0','0','0','');
INSERT INTO yowao_recycler VALUES('980','','ӰԾ','http://www.4399.com/flash/9690.htm','2255','','yowao','2','0','0','0','');
INSERT INTO yowao_recycler VALUES('981','','Ӱ2','http://www.4399.com/flash/8286.htm','2255','','yowao','3','0','0','0','');
INSERT INTO yowao_recycler VALUES('982','','Ӱ','http://www.4399.com/flash/1696.htm','2255','','yowao','4','0','0','0','');
INSERT INTO yowao_recycler VALUES('983','','ǴҶ','http://www.4399.com/flash/9606.htm','2255','','yowao','5','0','0','0','');
INSERT INTO yowao_recycler VALUES('984','','ӰҲ','http://www.4399.com/flash/9675.htm','2255','','yowao','6','0','0','0','');
INSERT INTO yowao_recycler VALUES('985','','ȭwing1.2ȫ','http://www.4399.com/flash/9209.htm','2256','','yowao','1','0','0','0','');
INSERT INTO yowao_recycler VALUES('986','','Ϳ','http://www.4399.com/flash/1438.htm','2256','','yowao','2','0','0','0','');
INSERT INTO yowao_recycler VALUES('987','','նɱ','http://www.4399.com/flash/2301.htm','2256','','yowao','3','0','0','0','');
INSERT INTO yowao_recycler VALUES('988','','鶯̽','http://www.4399.com/flash/1546.htm','2256','','yowao','4','0','0','0','');
INSERT INTO yowao_recycler VALUES('989','','ѪУ꼤','http://www.4399.com/flash/2740.htm','2256','','yowao','5','0','0','0','');
INSERT INTO yowao_recycler VALUES('990','','ȭ2000','http://www.4399.com/flash/9.htm','2256','','yowao','6','0','0','0','');
INSERT INTO yowao_recycler VALUES('991','','ѧУս','http://www.4399.com/flash/1254.htm','2256','','yowao','7','0','0','0','');
INSERT INTO yowao_recycler VALUES('992','','˿','http://www.4399.com/flash/1378.htm','2256','','yowao','7','0','0','0','');
INSERT INTO yowao_recycler VALUES('993','','й','http://www.weather.com.cn/','2285','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('994','','','http://www.t7online.com/','2285','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('995','','Ԥ-','http://weather.news.sina.com.cn/','2285','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('996','','̨','http://www.nmc.gov.cn/','2285','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('997','','Ԥ','http://www.worldweather.cn/','2285','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('998','','й','http://www.cma.gov.cn/','2285','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('999','','й̨','http://www.csndmc.ac.cn/','2285','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1000','','й','http://www.cea.gov.cn/','2285','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1001','','й̨','http://www.typhoon.gov.cn/','2285','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1002','','Ԥ','http://www.weather.com.cn/html/weather/101010100.shtml','2286','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1003','','ϺԤ','http://www.weather.com.cn/html/weather/101020100.shtml','2286','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1004','','Ԥ','http://www.weather.com.cn/html/weather/101210101.shtml','2286','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1005','','Ԥ','http://www.weather.com.cn/html/weather/101230101.shtml','2286','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1006','','Ԥ','http://www.weather.com.cn/html/weather/101300101.shtml','2286','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1007','','Ԥ','http://www.weather.com.cn/html/weather/101290101.shtml','2286','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1008','','̨Ԥ','http://www.weather.com.cn/html/weather/101340101.shtml','2286','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1009','','Ԥ','http://www.weather.com.cn/html/weather/101150101.shtml','2286','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1010','','Ԥ','http://www.weather.com.cn/html/weather/101160101.shtml','2286','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1011','','Ԥ','http://www.weather.com.cn/html/weather/101110101.shtml','2286','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1012','','人Ԥ','http://www.weather.com.cn/html/weather/101200101.shtml','2286','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1013','','֣Ԥ','http://www.weather.com.cn/html/weather/101180101.shtml','2286','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1014','','ϷԤ','http://www.weather.com.cn/html/weather/101220101.shtml','2286','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1015','','Ԥ','http://www.weather.com.cn/html/weather/101040100.shtml','2286','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1016','','ɶԤ','http://www.weather.com.cn/html/weather/101270101.shtml','2286','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1017','','Ԥ','http://www.weather.com.cn/html/weather/101140101.shtml','2286','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1018','','Ԥ','http://www.weather.com.cn/html/weather/101260101.shtml','2286','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1019','','ɳԤ','http://www.weather.com.cn/html/weather/101250101.shtml','2286','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1020','','Ԥ','http://www.weather.com.cn/html/weather/101030100.shtml','2286','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1021','','ʯׯԤ','http://www.weather.com.cn/html/weather/101090101.shtml','2286','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1022','','Ԥ','http://www.weather.com.cn/html/weather/101280101.shtml','2286','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1023','','Ԥ','http://www.weather.com.cn/html/weather/101310101.shtml','2286','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1024','','Ԥ','http://www.weather.com.cn/html/weather/101330101.shtml','2286','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1025','','Ԥ','http://www.weather.com.cn/html/weather/101320101.shtml','2286','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1026','','Ԥ','http://www.weather.com.cn/html/weather/101120101.shtml','2286','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1027','','ϾԤ','http://www.weather.com.cn/html/weather/101190101.shtml','2286','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1028','','ϲԤ','http://www.weather.com.cn/html/weather/101240101.shtml','2286','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1029','','ͺԤ','http://www.weather.com.cn/html/weather/101080101.shtml','2286','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1030','','̫ԭԤ','http://www.weather.com.cn/html/weather/101100101.shtml','2286','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1031','','Ԥ','http://www.weather.com.cn/html/weather/101170101.shtml','2286','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1032','','³ľԤ','http://www.weather.com.cn/html/weather/101130101.shtml','2286','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1033','','Ԥ','http://www.weather.com.cn/html/weather/101050101.shtml','2286','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1034','','Ԥ','http://www.weather.com.cn/html/weather/101060101.shtml','2286','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1035','','Ԥ','http://www.weather.com.cn/html/weather/101070101.shtml','2286','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1036','','Ԥ','http://www.weather.com.cn/html/weather/101050101.shtml','2286','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1037','','޸Ҫ','http://www.weather.com.cn/html/continent/asia.shtml','2287','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1038','','ŷ޸Ҫ','http://www.weather.com.cn/html/continent/europe.shtml','2287','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1039','','޸Ҫ','http://www.weather.com.cn/html/continent/northamerica.shtml','2287','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1040','','޸Ҫ','http://www.weather.com.cn/html/continent/southamerica.shtml','2287','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1041','','޸Ҫ','http://www.weather.com.cn/html/continent/oceania.shtml','2287','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1042','','޸Ҫ','http://www.weather.com.cn/html/continent/africa.shtml','2287','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1043','','֤ѯ','http://www.id5.cn/desktop/','2288','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1044','','ƶѲѯ','http://www.chinamobile.com/service/billservice/','2288','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1045','','Ԥ','http://www.chatianqi.com/','2288','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1046','','ʱУ','http://www.time.ac.cn/','2288','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1047','','ѧѯ','http://www.chsi.com.cn/xlcx/','2288','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1048','','ƺѯ','http://www.jsyks.com/Tools/cphmcx/','2288','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1049','','IPַѯ','http://www.ip138.com/','2288','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1050','','ֵʵ','http://www.zdic.net/','2288','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1051','','ӽĿԤ','http://www.tvsou.com/','2288','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1052','','ݲѯ','http://www.ip138.com/ems/','2288','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1053','','֧','http://www.alipay.com/','2288','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1054','','ҽ','http://ask.qe.cn/','2288','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1055','','ֵ','http://fund.sohu.com/','2290','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1056','','Ʊ','http://www.bestgo.com/','2290','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1057','','ʲѯ','http://www.zhcw.com/','2290','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1058','','ʲѯ','http://www.lottery.gov.cn/','2290','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1059','','Ƽ','http://www.icbc.com.cn/other/quotation.jsp','2290','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1060','','Ҷһ','http://qq.ip138.com/hl.asp','2290','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1061','','˰','http://card.money.sohu.com/tools/html/CalcTax.htm','2290','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1062','','Ҵ/','http://www.ccb.com/portal/cn/interest/rmbdeposit.jsp','2290','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1063','','Ʊѯ','http://www.huoche.com/','2289','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1064','','Googleͼ','http://ditu.google.cn/','2289','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1065','','8684ѯ','http://www.8684.cn/','2289','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1066','','ʵʱѯ','http://flights.ctrip.com/Domestic/SearchFlights.aspx','2289','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1067','','ȫ·ѯ','http://www.chinahighway.gov.cn/','2289','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1068','','ݾƵԤ','http://hotels.ctrip.com/Domestic/SearchHotel.aspx','2289','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1069','','Ů԰ȫ','http://www.hao123.com/haoserver/womansafe.htm','2291','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1070','','׼ؼ','http://www.hao123.com/haoserver/standard.htm','2291','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1071','','ѯ','http://jbk.39.net/','2291','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1072','','ҽԺѯ','http://yyk.39.net/','2291','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1073','','ʳƷҩƷѯ','http://app1.sfda.gov.cn/datasearch/face3/dir.html','2291','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1074','','Ӫʳ','http://keko.chihe.sohu.com/','2291','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1075','','Ӫɷֲѯ','http://www.fh21.com.cn/ying/new/chengfen.htm','2291','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1076','','','http://car.autohome.com.cn/','2292','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1077','','ֻ','http://tech.sina.com.cn/mobile/select/index.html','2292','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1078','','Լ۸','http://detail.zol.com.cn/','2292','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1079','','ʷϵĽ','http://www.todayonhistory.com/','2292','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1080','','˹¼ȫ','http://guinnessworldrecords.bokee.com/','2292','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1081','','QQ','http://id.qq.com/','2292','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1082','','ת','http://www.huoxingyu.com/','2292','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1083','','ڽ','http://fund.jrj.com.cn/','1645','','yowao','3','0','0','0','');
INSERT INTO yowao_recycler VALUES('1084','','Ѷ','http://funds.money.hexun.com/','1645','','yowao','4','0','0','0','');
INSERT INTO yowao_recycler VALUES('1085','','','http://www.1234567.com.cn/','1645','','yowao','1','0','21','1','');
INSERT INTO yowao_recycler VALUES('1086','','ȫ-','http://www.p5w.net/fund/','1645','','yowao','13','0','0','0','');
INSERT INTO yowao_recycler VALUES('1087','','й','http://www.cnfund.cn/','1645','','yowao','5','0','0','0','');
INSERT INTO yowao_recycler VALUES('1088','','֤ȯ֮-','http://fund.stockstar.com/','1645','','yowao','8','0','0','0','');
INSERT INTO yowao_recycler VALUES('1089','','˻','http://finance.sina.com.cn/fund/index.shtml','1645','','yowao','2','0','0','0','');
INSERT INTO yowao_recycler VALUES('1090','','Ѻ','http://money.business.sohu.com/fund/','1645','','yowao','6','0','0','0','');
INSERT INTO yowao_recycler VALUES('1091','','н߻','http://fund.cnfol.com/','1645','','yowao','12','0','0','0','');
INSERT INTO yowao_recycler VALUES('1092','','','http://www.tttz.com/','1645','','yowao','7','0','0','0','');
INSERT INTO yowao_recycler VALUES('1093','','Ѷծȯ','http://bond.hexun.com/','1649','','yowao','8','0','0','0','');
INSERT INTO yowao_recycler VALUES('1094','','н-ծȯ','http://bond.cnfol.com/','1649','','yowao','9','0','0','0','');
INSERT INTO yowao_recycler VALUES('1095','','й֤ȯ','http://www.cs.com.cn/','1649','','yowao','5','0','0','0','');
INSERT INTO yowao_recycler VALUES('1096','','ڽ-ծȯ','http://bond.jrj.com.cn/','1649','','yowao','10','0','0','0','');
INSERT INTO yowao_recycler VALUES('1097','','ծȯй','http://bond.zgjrw.com/','1649','','yowao','4','0','0','0','');
INSERT INTO yowao_recycler VALUES('1098','','Ƹ-ծȯ','http://bond.eastmoney.com/','1649','','yowao','6','0','0','0','');
INSERT INTO yowao_recycler VALUES('1099','','ȫ-֤ȯʱ','http://www.p5w.net/','1649','','yowao','2','0','0','0','');
INSERT INTO yowao_recycler VALUES('1100','','¡֤ȯ','http://www.wlstock.com/','1649','','yowao','3','0','0','0','');
INSERT INTO yowao_recycler VALUES('1101','','й֤ȯ','http://www.cnstock.com/','1649','','yowao','1','0','0','0','');
INSERT INTO yowao_recycler VALUES('1102','','֤ȯͨ','http://www.cnsec.com','1649','','yowao','11','0','0','0','');
INSERT INTO yowao_recycler VALUES('1103','','ѯ','http://fund.jrj.com.cn/fund/fundinfoall.asp','1997','','yowao','2','0','0','0','');
INSERT INTO yowao_recycler VALUES('1104','','ѯ','http://funds.money.hexun.com/fundsdata/','1997','','yowao','5','0','0','0','');
INSERT INTO yowao_recycler VALUES('1105','','ǻа','http://cn.morningstar.com/','1997','','yowao','6','0','0','0','');
INSERT INTO yowao_recycler VALUES('1106','','','http://www.ourku.com/','1997','','yowao','8','0','0','0','');
INSERT INTO yowao_recycler VALUES('1107','','깺״̬','http://fund.eastmoney.com/Fund_sgzt_bzdm.html','1997','','yowao','9','0','0','0','');
INSERT INTO yowao_recycler VALUES('1108','','֪ʶ','http://fund2.eastmoney.com/JJxx,jijin.html','1997','','yowao','10','0','0','0','');
INSERT INTO yowao_recycler VALUES('1109','','()ü','http://fund.eastmoney.com/Fund_Calculator01.html','1997','','yowao','7','0','0','0','');
INSERT INTO yowao_recycler VALUES('1110','','','http://info.cmbchina.com/cmb2005stock/investaspxbin/Calculator/Calculator.aspx?c_id=2','1997','','yowao','11','0','0','0','');
INSERT INTO yowao_recycler VALUES('1111','','ƸƵ','http://data.eastmoney.com/','1997','','yowao','3','0','0','0','');
INSERT INTO yowao_recycler VALUES('1112','','ʽÿվֵ','http://fund.eastmoney.com/fund.html','1997','','yowao','1','0','0','0','');
INSERT INTO yowao_recycler VALUES('1113','','','http://auto.sina.com.cn','1169','','yowao','1','0','0','0','');
INSERT INTO yowao_recycler VALUES('1114','','Ѻ','http://auto.sohu.com','1169','','yowao','3','0','0','0','');
INSERT INTO yowao_recycler VALUES('1115','','̫ƽ','http://www.pcauto.com.cn/','1169','','yowao','12','0','42','1','');
INSERT INTO yowao_recycler VALUES('1116','','','http://auto.163.com','1169','','yowao','8','0','0','0','');
INSERT INTO yowao_recycler VALUES('1117','','TOM','http://auto.tom.com','1169','','yowao','7','0','0','0','');
INSERT INTO yowao_recycler VALUES('1118','','ϳ','http://www.cheshi.com.cn','1169','','yowao','5','0','0','0','');
INSERT INTO yowao_recycler VALUES('1119','','֮','http://www.autohome.com.cn','1169','','yowao','2','0','0','0','');
INSERT INTO yowao_recycler VALUES('1120','','Ż','http://cn.autos.yahoo.com','1169','','yowao','4','0','0','0','');
INSERT INTO yowao_recycler VALUES('1121','','׳','http://www.bitauto.com','1169','','yowao','9','0','0','0','');
INSERT INTO yowao_recycler VALUES('1122','','21CNƵ','http://auto.21cn.com/','1169','','yowao','11','0','0','0','');
INSERT INTO yowao_recycler VALUES('1123','','èƵ','http://auto.mop.com/','1169','','yowao','23','0','0','0','');
INSERT INTO yowao_recycler VALUES('1124','','Ѷ','http://auto.qq.com/','1169','','yowao','6','0','0','0','');
INSERT INTO yowao_recycler VALUES('1125','','֮','http://www.autofan.com.cn','1169','','yowao','24','0','0','0','');
INSERT INTO yowao_recycler VALUES('1126','','','http://www.ieche.com','1169','','yowao','26','0','0','0','');
INSERT INTO yowao_recycler VALUES('1127','','','http://auto.huanqiu.com/','1169','','yowao','10','0','0','0','');
INSERT INTO yowao_recycler VALUES('1128','','Ұ','http://www.52che.com/','1169','','yowao','24','0','0','0','');
INSERT INTO yowao_recycler VALUES('1129','','Ƶ','http://auto.ifeng.com/','1169','','yowao','12','0','0','0','');
INSERT INTO yowao_recycler VALUES('1130','','й','http://www.auto18.com/','1662','','yowao','6','0','0','0','');
INSERT INTO yowao_recycler VALUES('1131','','й','http://www.315che.com','1662','','yowao','7','0','0','0','');
INSERT INTO yowao_recycler VALUES('1132','','̫ƽ','http://price.pcauto.com.cn/','1662','','yowao','1','0','0','0','');
INSERT INTO yowao_recycler VALUES('1133','','֮ұ','http://car.autohome.com.cn/','1662','','yowao','5','0','0','0','');
INSERT INTO yowao_recycler VALUES('1134','','Ѻ','http://price.auto.sohu.com/','1662','','yowao','2','0','0','0','');
INSERT INTO yowao_recycler VALUES('1135','','׳','http://price.bitauto.com/','1662','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1136','','֮','http://club.autohome.com.cn/','1664','','yowao','3','0','0','0','');
INSERT INTO yowao_recycler VALUES('1137','','','http://auto.sina.com.cn/shequ/','1664','','yowao','1','0','0','0','');
INSERT INTO yowao_recycler VALUES('1138','','̫ƽ̳','http://autobbs.pconline.com.cn/','1664','','yowao','4','0','0','0','');
INSERT INTO yowao_recycler VALUES('1139','','̳','http://bbs.chetx.com/','1664','','yowao','7','0','0','0','');
INSERT INTO yowao_recycler VALUES('1140','','ϳ','http://bbs.cheshi.com.cn/','1664','','yowao','6','0','0','0','');
INSERT INTO yowao_recycler VALUES('1141','','Tom̳','http://club.auto.tom.com/','1664','','yowao','2','0','0','0','');
INSERT INTO yowao_recycler VALUES('1142','','ҳֲ','http://www.5qiche.com/','1664','','yowao','5','0','0','0','');
INSERT INTO yowao_recycler VALUES('1143','','йƷ','http://www.car2100.com','1171','','yowao','2','0','0','0','');
INSERT INTO yowao_recycler VALUES('1144','','йƷ','http://www.autosup.com','1171','','yowao','7','0','0','0','');
INSERT INTO yowao_recycler VALUES('1145','','й','http://www.qpcity.com.cn','1171','','yowao','13','0','0','0','');
INSERT INTO yowao_recycler VALUES('1146','','۴ҵ','http://www.auto-p.hc360.com','1171','','yowao','4','0','0','0','');
INSERT INTO yowao_recycler VALUES('1147','','Ƴ','http://www.pochezu.com/','1171','','yowao','10','0','0','0','');
INSERT INTO yowao_recycler VALUES('1148','','й','http://www.qipei.com/','1171','','yowao','15','0','0','0','');
INSERT INTO yowao_recycler VALUES('1149','','ȫ','http://www.all2car.com/','1171','','yowao','17','0','0','0','');
INSERT INTO yowao_recycler VALUES('1150','','йƷ','http://www.zgqp.com.cn/','1171','','yowao','20','0','0','0','');
INSERT INTO yowao_recycler VALUES('1151','','й佻','http://www.86qp.net/','1171','','yowao','21','0','0','0','');
INSERT INTO yowao_recycler VALUES('1152','','йó','http://www.qp168.net/','1171','','yowao','22','0','0','0','');
INSERT INTO yowao_recycler VALUES('1153','','','http://www.qp138.com/','1171','','yowao','23','0','0','0','');
INSERT INTO yowao_recycler VALUES('1154','','۴','http://www.qipei.hc360.com','1171','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1155','','۴άޱ','http://www.auto-m.hc360.com','1171','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1156','','۴Ħг','http://www.motor.hc360.com','1171','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1157','','۴Ʒ','http://www.auto-a.hc360.com/','1171','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1158','','ִ޹˾','http://www.beijing-hyundai.com.cn/','1666','','yowao','16','0','0','0','');
INSERT INTO yowao_recycler VALUES('1159','','Ϻ','http://www.csvw.com/','1666','','yowao','4','0','0','0','');
INSERT INTO yowao_recycler VALUES('1160','','Ͼ','http://www.fiat.com.cn/','1666','','yowao','6','0','0','0','');
INSERT INTO yowao_recycler VALUES('1161','','','http://www.ford.com.cn/','1666','','yowao','3','0','0','0','');
INSERT INTO yowao_recycler VALUES('1162','','γ','http://www.geely.com/','1666','','yowao','19','0','0','0','');
INSERT INTO yowao_recycler VALUES('1163','','ͨй','http://www.gmchina.com/','1666','','yowao','2','0','0','0','');
INSERT INTO yowao_recycler VALUES('1164','','ݱ','http://www.guangzhouhonda.com.cn/','1666','','yowao','15','0','0','0','');
INSERT INTO yowao_recycler VALUES('1165','','Ϻͨ','http://www.shanghaigm.com/','1666','','yowao','13','0','0','0','');
INSERT INTO yowao_recycler VALUES('1166','','һ','http://www.tjfaw.com/','1666','','yowao','20','0','0','0','');
INSERT INTO yowao_recycler VALUES('1167','','','http://www.toyota.com.cn/','1666','','yowao','1','0','0','0','');
INSERT INTO yowao_recycler VALUES('1168','','-ѩ','http://www.dcad.com.cn/','1666','','yowao','5','0','0','0','');
INSERT INTO yowao_recycler VALUES('1169','','ղ-ŵ','http://www.renault.com.cn/','1666','','yowao','7','0','0','0','');
INSERT INTO yowao_recycler VALUES('1170','','ķ-˹','http://www.daimlerchrysler.com.cn/','1666','','yowao','9','0','0','0','');
INSERT INTO yowao_recycler VALUES('1171','','ִ-','http://www.kia-motor.com.cn/','1666','','yowao','10','0','0','0','');
INSERT INTO yowao_recycler VALUES('1172','','','http://www.bmw.com.cn/','1666','','yowao','8','0','0','0','');
INSERT INTO yowao_recycler VALUES('1173','','й','http://www.honda.com.cn/','1666','','yowao','11','0','0','0','');
INSERT INTO yowao_recycler VALUES('1174','','','http://www.mercedes-benz.com.cn/','1666','','yowao','12','0','0','0','');
INSERT INTO yowao_recycler VALUES('1175','','µ','http://www.audi.cn/audi/cn/zh2.html','1666','','yowao','14','0','0','0','');
INSERT INTO yowao_recycler VALUES('1176','','','http://www.dpca.com.cn/','1666','','yowao','17','0','0','0','');
INSERT INTO yowao_recycler VALUES('1177','','','http://www.chery.cn/','1666','','yowao','18','0','0','0','');
INSERT INTO yowao_recycler VALUES('1178','','Уһͨ','http://www.jxedt.com/','2177','','yowao','27','0','0','0','');
INSERT INTO yowao_recycler VALUES('1179','','ȫУ','http://www.51xueche.com/','2177','','yowao','28','0','0','0','');
INSERT INTO yowao_recycler VALUES('1180','','ѧ','http://www.xueche.net/','2177','','yowao','25','0','0','0','');
INSERT INTO yowao_recycler VALUES('1181','','ʻԱ','http://www.jsyst.cn','2177','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1182','','Ѻ','http://house.sohu.com','881','','yowao','4','0','0','0','');
INSERT INTO yowao_recycler VALUES('1183','','˷','http://house.sina.com.cn','881','','yowao','3','0','0','0','');
INSERT INTO yowao_recycler VALUES('1184','','Żز','http://cn.realestate.yahoo.com','881','','yowao','8','0','0','0','');
INSERT INTO yowao_recycler VALUES('1185','','ڱ','http://fang.koubei.com','881','','yowao','5','0','0','0','');
INSERT INTO yowao_recycler VALUES('1186','','ѷ','http://www.soufun.com/','881','','yowao','1','0','19','1','');
INSERT INTO yowao_recycler VALUES('1187','','','http://house.people.com.cn/','881','','yowao','15','0','0','0','');
INSERT INTO yowao_recycler VALUES('1188','','Ѷ','http://fang.kuxun.cn/','881','','yowao','10','0','0','0','');
INSERT INTO yowao_recycler VALUES('1189','','Ѷ','http://house.hexun.com/','881','','yowao','9','0','0','0','');
INSERT INTO yowao_recycler VALUES('1190','','㷿ز','http://house.focus.cn/','881','','yowao','2','0','44','1','');
INSERT INTO yowao_recycler VALUES('1191','','21CN','http://house.21cn.com/','881','','yowao','16','0','0','0','');
INSERT INTO yowao_recycler VALUES('1192','','ӿַⷿ','http://www.anjuke.com/','881','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1193','','װ޼Ҿ','http://home.focus.cn','879','','yowao','3','0','0','0','');
INSERT INTO yowao_recycler VALUES('1194','','й','http://www.ciid.com.cn','879','','yowao','11','0','0','0','');
INSERT INTO yowao_recycler VALUES('1195','','װͼ','http://www.tumanduo.com','879','','yowao','1','0','0','0','');
INSERT INTO yowao_recycler VALUES('1196','','йװ','http://www.cool-de.com/','879','','yowao','13','0','0','0','');
INSERT INTO yowao_recycler VALUES('1197','','ѷװ޼Ҿ','http://home.soufun.com/','879','','yowao','2','0','0','0','');
INSERT INTO yowao_recycler VALUES('1198','','ϲüҾ','http://www.joyju.com/','879','','yowao','18','0','0','0','');
INSERT INTO yowao_recycler VALUES('1199','','װ޼Ҿ','http://house.sina.com.cn/decor/','879','','yowao','6','0','0','0','');
INSERT INTO yowao_recycler VALUES('1200','','װ','http://www.roomage.com','879','','yowao','16','0','0','0','');
INSERT INTO yowao_recycler VALUES('1201','','װ','http://www.zsuan.com/','879','','yowao','17','0','0','0','');
INSERT INTO yowao_recycler VALUES('1202','','ֻƵ','http://mobile.163.com','766','','yowao','9','0','0','0','');
INSERT INTO yowao_recycler VALUES('1203','','ֻ֮','http://www.imobile.com.cn','766','','yowao','1','0','0','0','');
INSERT INTO yowao_recycler VALUES('1204','','̫ƽֻƵ','http://mobile.pconline.com.cn/','766','','yowao','2','0','0','0','');
INSERT INTO yowao_recycler VALUES('1205','','3533ֻ','http://www.3533.com/','766','','yowao','10','0','0','0','');
INSERT INTO yowao_recycler VALUES('1206','','IT168ֻ','http://mobile.it168.com','766','','yowao','6','0','0','0','');
INSERT INTO yowao_recycler VALUES('1207','','ֻ','http://mobile.pcpop.com/','766','','yowao','7','0','0','0','');
INSERT INTO yowao_recycler VALUES('1208','','йشֻƵ','http://mobile.zol.com.cn/','766','','yowao','14','0','0','0','');
INSERT INTO yowao_recycler VALUES('1209','','ѶֻƵ','http://digi.tech.qq.com/mobile/','766','','yowao','8','0','0','0','');
INSERT INTO yowao_recycler VALUES('1210','','ITֻ','http://www.it.com.cn/mobile/','766','','yowao','15','0','0','0','');
INSERT INTO yowao_recycler VALUES('1211','','ֻƵ','http://tech.sina.com.cn/mobile/','766','','yowao','4','0','0','0','');
INSERT INTO yowao_recycler VALUES('1212','','ֻ԰','http://www.shouji.com.cn/','766','','yowao','5','0','0','0','');
INSERT INTO yowao_recycler VALUES('1213','','ֻ','http://product.pcpop.com/Mobile/00000_1.html','770','','yowao','3','0','0','0','');
INSERT INTO yowao_recycler VALUES('1214','','йشֻ','http://mobile.zol.com.cn/more/2_427.shtml','770','','yowao','5','0','0','0','');
INSERT INTO yowao_recycler VALUES('1215','','̫ƽֻ','http://product.pconline.com.cn/mobile/','770','','yowao','1','0','0','0','');
INSERT INTO yowao_recycler VALUES('1216','','켫ֻ','http://mobile.yesky.com/','770','','yowao','2','0','0','0','');
INSERT INTO yowao_recycler VALUES('1217','','3533ֻ','http://www.3533.com/price/','770','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1218','','ֻ̳֮','http://bbs.imobile.com.cn','767','','yowao','1','0','0','0','');
INSERT INTO yowao_recycler VALUES('1219','','ֻ̳','http://bbs.dospy.com/','767','','yowao','5','0','0','0','');
INSERT INTO yowao_recycler VALUES('1220','','Ħֻ̳','http://www.motobbs.com','767','','yowao','8','0','0','0','');
INSERT INTO yowao_recycler VALUES('1221','','WDAֻ̳','http://bbs.wda.com.cn/','767','','yowao','14','0','0','0','');
INSERT INTO yowao_recycler VALUES('1222','','TomPDAֻ̳','http://bbs.tompda.com/','767','','yowao','4','0','0','0','');
INSERT INTO yowao_recycler VALUES('1223','','մֻ̳','http://www.dpdbbs.com/','767','','yowao','13','0','0','0','');
INSERT INTO yowao_recycler VALUES('1224','','IT168רҵ̳','http://sebbs.it168.com/','767','','yowao','7','0','0','0','');
INSERT INTO yowao_recycler VALUES('1225','','','http://www.weiphone.com','767','','yowao','11','0','0','0','');
INSERT INTO yowao_recycler VALUES('1226','','ŵ','http://www.nokia.com.cn','768','','yowao','1','0','0','0','');
INSERT INTO yowao_recycler VALUES('1227','','Ħ','http://www.motorola.com.cn','768','','yowao','3','0','0','0','');
INSERT INTO yowao_recycler VALUES('1228','','ᰮ','http://www.sonyericsson.com','768','','yowao','4','0','0','0','');
INSERT INTO yowao_recycler VALUES('1229','','','http://www.samsung.com.cn','768','','yowao','2','0','0','0','');
INSERT INTO yowao_recycler VALUES('1230','','','http://www.siemens.com','768','','yowao','4','0','0','0','');
INSERT INTO yowao_recycler VALUES('1231','','iPhoneֻ','http://www.iphone.com.cn/','768','','yowao','12','0','0','0','');
INSERT INTO yowao_recycler VALUES('1232','','','http://www.amobile.com.cn/','768','','yowao','10','0','0','0','');
INSERT INTO yowao_recycler VALUES('1233','','ֻ','http://www.lenovomobile.com/','768','','yowao','9','0','0','0','');
INSERT INTO yowao_recycler VALUES('1234','','մ','http://www.dopod.com/','768','','yowao','11','0','0','0','');
INSERT INTO yowao_recycler VALUES('1235','','LG','http://www.lg.com.cn/','768','','yowao','8','0','0','0','');
INSERT INTO yowao_recycler VALUES('1236','','й','http://www.BenQ.com.cn','768','','yowao','13','0','0','0','');
INSERT INTO yowao_recycler VALUES('1237','','','http://www.philips.com.cn/','768','','yowao','6','0','0','0','');
INSERT INTO yowao_recycler VALUES('1238','','Ѻ','http://health.sohu.com','864','','yowao','2','0','0','0','');
INSERT INTO yowao_recycler VALUES('1239','','ǧ','http://health.qianlong.com','864','','yowao','12','0','0','0','');
INSERT INTO yowao_recycler VALUES('1240','','','http://health.people.com.cn/','864','','yowao','9','0','0','0','');
INSERT INTO yowao_recycler VALUES('1241','','ʱ','http://www.jksb.com.cn','864','','yowao','15','0','0','0','');
INSERT INTO yowao_recycler VALUES('1242','','˽','http://news.sina.com.cn/health/','864','','yowao','10','0','0','0','');
INSERT INTO yowao_recycler VALUES('1243','','»','http://www.xinhuanet.com/health/','864','','yowao','7','0','0','0','');
INSERT INTO yowao_recycler VALUES('1244','','ɻ','http://www.fh21.com.cn/','864','','yowao','4','0','0','0','');
INSERT INTO yowao_recycler VALUES('1245','','л','http://health.china.com/','864','','yowao','8','0','0','0','');
INSERT INTO yowao_recycler VALUES('1246','','39','http://www.39.net','864','','yowao','1','0','0','0','');
INSERT INTO yowao_recycler VALUES('1247','','Ů˽','http://www.ruiliren.com/jiankang','864','','yowao','3','0','0','0','');
INSERT INTO yowao_recycler VALUES('1248','','ʱش','http://www.120ask.com/','2202','','yowao','2','0','0','0','');
INSERT INTO yowao_recycler VALUES('1249','','ҽԷ','http://www.fx120.net/','2202','','yowao','6','0','0','0','');
INSERT INTO yowao_recycler VALUES('1250','','ҽ','http://www.91.cn/','2202','','yowao','5','0','0','0','');
INSERT INTO yowao_recycler VALUES('1251','','ͥҽ','http://www.familydoctor.com.cn/','2202','','yowao','4','0','0','0','');
INSERT INTO yowao_recycler VALUES('1252','','ҽ','http://www.qe.cn','2202','','yowao','1','0','0','0','');
INSERT INTO yowao_recycler VALUES('1253','','ҷ','http://www.findlaw.cn','913','','yowao','14','0','0','0','');
INSERT INTO yowao_recycler VALUES('1254','','йշ','http://www.legalinfo.gov.cn','913','','yowao','1','0','0','0','');
INSERT INTO yowao_recycler VALUES('1255','','з','http://www.1488.com/','913','','yowao','2','0','0','0','');
INSERT INTO yowao_recycler VALUES('1256','','ɿ쳵','http://www.lawtime.cn/','913','','yowao','4','0','0','0','');
INSERT INTO yowao_recycler VALUES('1257','','йԺ','http://www.chinacourt.org/','913','','yowao','5','0','0','0','');
INSERT INTO yowao_recycler VALUES('1258','','','http://www.legaldaily.com.cn/','913','','yowao','6','0','0','0','');
INSERT INTO yowao_recycler VALUES('1259','','й̷','http://www.civillaw.com.cn/','913','','yowao','20','0','0','0','');
INSERT INTO yowao_recycler VALUES('1260','','֪ʶȨ','http://www.sipo.gov.cn/sipo/','913','','yowao','21','0','0','0','');
INSERT INTO yowao_recycler VALUES('1261','','̳','http://bbs.chinacourt.org/','913','','yowao','19','0','0','0','');
INSERT INTO yowao_recycler VALUES('1262','','йȨ','http://www.humanrights-china.org/','913','','yowao','23','0','0','0','');
INSERT INTO yowao_recycler VALUES('1263','','ķ̳','http://cache.tianya.cn/publicforum/ArticlesList/0/law.shtml','913','','yowao','28','0','0','0','');
INSERT INTO yowao_recycler VALUES('1264','','','http://www.laweach.com/','913','','yowao','15','0','0','0','');
INSERT INTO yowao_recycler VALUES('1265','','','http://www.148com.com/','913','','yowao','3','0','0','0','');
INSERT INTO yowao_recycler VALUES('1266','','й','http://www.9ask.cn','913','','yowao','18','0','0','0','');
INSERT INTO yowao_recycler VALUES('1267','','ж','http://www.98148.com.cn','913','','yowao','24','0','0','0','');
INSERT INTO yowao_recycler VALUES('1268','','ɿ쳵','http://www.lawtime.cn','913','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1269','','ͼ','http://www.law-lib.com/','1878','','yowao','5','0','0','0','');
INSERT INTO yowao_recycler VALUES('1270','','йԴ','http://www.lawbase.com.cn/','1878','','yowao','18','0','0','0','');
INSERT INTO yowao_recycler VALUES('1271','','йѧ','http://www.iolaw.org.cn/','1878','','yowao','6','0','0','0','');
INSERT INTO yowao_recycler VALUES('1272','','ٶȷ','http://law.baidu.com/','1878','','yowao','1','0','0','0','');
INSERT INTO yowao_recycler VALUES('1273','','˼','http://www.law-thinker.com/','1878','','yowao','7','0','0','0','');
INSERT INTO yowao_recycler VALUES('1274','','й̷','http://www.civillaw.com.cn/','1878','','yowao','10','0','0','0','');
INSERT INTO yowao_recycler VALUES('1275','','йͶʷ','http://www.chinainvestlaw.com/scn/','1878','','yowao','12','0','0','0','');
INSERT INTO yowao_recycler VALUES('1276','','йɷѶ','http://www.86148.com/chinafa/','1878','','yowao','13','0','0','0','');
INSERT INTO yowao_recycler VALUES('1277','','й','http://www.chinaeclaw.com/','1878','','yowao','14','0','0','0','');
INSERT INTO yowao_recycler VALUES('1278','','زɷ','http://www.law110.com/','1878','','yowao','15','0','0','0','');
INSERT INTO yowao_recycler VALUES('1279','','йշ','http://www.aviationlaw.com.cn/','1878','','yowao','17','0','0','0','');
INSERT INTO yowao_recycler VALUES('1280','','йɴȫ','http://www.jincao.com/t1.htm','1878','','yowao','6','0','0','0','');
INSERT INTO yowao_recycler VALUES('1281','','Ͷͬ','http://www.xinhuanet.com/legal/ldhtf/','1878','','yowao','3','0','0','0','');
INSERT INTO yowao_recycler VALUES('1282','','йɷ','http://www.gov.cn/flfg/index.htm','1878','','yowao','4','0','0','0','');
INSERT INTO yowao_recycler VALUES('1283','','֮-ѯ','http://www.law-star.com/html/lawsearch.htm','1878','','yowao','2','0','0','0','');
INSERT INTO yowao_recycler VALUES('1284','','ʦ365','http://www.64365.com','915','','yowao','12','0','0','0','');
INSERT INTO yowao_recycler VALUES('1285','','йʦ','http://www.chineselawyer.com.cn','915','','yowao','1','0','0','0','');
INSERT INTO yowao_recycler VALUES('1286','','ʦ','http://www.lawyers.net.cn','915','','yowao','8','0','0','0','');
INSERT INTO yowao_recycler VALUES('1287','','й','http://www.cnlaw.net/','915','','yowao','5','0','0','0','');
INSERT INTO yowao_recycler VALUES('1288','','ʦ','http://www.lawyers.com.cn/','915','','yowao','9','0','0','0','');
INSERT INTO yowao_recycler VALUES('1289','','Ϸʦ','http://www.southlawyer.net/','915','','yowao','10','0','0','0','');
INSERT INTO yowao_recycler VALUES('1290','','йʦ','http://www.007cn.cn/','915','','yowao','4','0','0','0','');
INSERT INTO yowao_recycler VALUES('1291','','˵ʱ-ʦѯ','http://www.sfsk.net/','915','','yowao','11','0','0','0','');
INSERT INTO yowao_recycler VALUES('1292','','лʦƽ̨','http://www.dls.com.cn/','915','','yowao','2','0','0','0','');
INSERT INTO yowao_recycler VALUES('1293','','ú','http://www.goodbaby.com/','884','','yowao','7','0','0','0','');
INSERT INTO yowao_recycler VALUES('1294','','','http://baby.sina.com.cn/','884','','yowao','1','0','0','0','');
INSERT INTO yowao_recycler VALUES('1295','','̫ƽ','http://www.pckids.com.cn/','884','','yowao','3','0','0','0','');
INSERT INTO yowao_recycler VALUES('1296','','9ye԰','http://www.9ye.com/','884','','yowao','11','0','0','0','');
INSERT INTO yowao_recycler VALUES('1297','','','http://www.ci123.com/','884','','yowao','4','0','0','0','');
INSERT INTO yowao_recycler VALUES('1298','','ѾѾ','http://www.iyaya.com/','884','','yowao','12','0','0','0','');
INSERT INTO yowao_recycler VALUES('1299','','CCTVٶƵ','http://edu.cctv.com/01/index.shtml','884','','yowao','2','0','0','0','');
INSERT INTO yowao_recycler VALUES('1300','','ҡ','http://www.yaolan.com/','884','','yowao','9','0','0','0','');
INSERT INTO yowao_recycler VALUES('1301','','','http://www.seedit.com/','884','','yowao','15','0','0','0','');
INSERT INTO yowao_recycler VALUES('1302','','й','http://www.zaojiao.com/','884','','yowao','18','0','0','0','');
INSERT INTO yowao_recycler VALUES('1303','','йĸ','http://www.muqin.com.cn/','884','','yowao','5','0','0','0','');
INSERT INTO yowao_recycler VALUES('1304','','Ѷͯ','http://kid.qq.com/','884','','yowao','6','0','0','0','');
INSERT INTO yowao_recycler VALUES('1305','','䱦','http://www.mumbaby.cn/','884','','yowao','22','0','0','0','');
INSERT INTO yowao_recycler VALUES('1306','','','http://www.babydao.com/','884','','yowao','23','0','0','0','');
INSERT INTO yowao_recycler VALUES('1307','','й׽','http://www.xugu.net','886','','yowao','2','0','0','0','');
INSERT INTO yowao_recycler VALUES('1308','','йɳ','http://www.sino78.com/','886','','yowao','3','0','0','0','');
INSERT INTO yowao_recycler VALUES('1309','','йͯԴ','http://www.tom61.com/','886','','yowao','5','0','0','0','');
INSERT INTO yowao_recycler VALUES('1310','','йѧǰ','http://www.preschool.net.cn/','886','','yowao','1','0','0','0','');
INSERT INTO yowao_recycler VALUES('1311','','Сѧ','http://www.zuowen.com/','886','','yowao','8','0','0','0','');
INSERT INTO yowao_recycler VALUES('1312','','ѾѾ','http://bbs.iyaya.com','888','','yowao','5','0','0','0','');
INSERT INTO yowao_recycler VALUES('1313','','г','http://www.jiahexie.com/','888','','yowao','2','0','0','0','');
INSERT INTO yowao_recycler VALUES('1314','','̳','http://bbs.baby.sina.com.cn/group.php?tree=0&gid=18','888','','yowao','1','0','0','0','');
INSERT INTO yowao_recycler VALUES('1315','','ѺĸӤ','http://club.baby.sohu.com/','888','','yowao','4','0','0','0','');
INSERT INTO yowao_recycler VALUES('1316','','-̳','http://www.babytree.com/forum/','888','','yowao','3','0','0','0','');
INSERT INTO yowao_recycler VALUES('1317','','ҡ̳','http://bbs.yaolan.com/','888','','yowao','8','0','0','0','');
INSERT INTO yowao_recycler VALUES('1318','','ͯ','http://www.61gu.com/','889','','yowao','7','0','0','0','');
INSERT INTO yowao_recycler VALUES('1319','','Ů','http://eladies.sina.com.cn','664','','yowao','1','0','0','0','');
INSERT INTO yowao_recycler VALUES('1320','','Ů','http://www.ruiliren.com','664','','yowao','3','0','0','0','');
INSERT INTO yowao_recycler VALUES('1321','','ѶŮ','http://lady.qq.com','664','','yowao','2','0','0','0','');
INSERT INTO yowao_recycler VALUES('1322','','Ů','http://lady.163.com','664','','yowao','6','0','0','0','');
INSERT INTO yowao_recycler VALUES('1323','','̫ƽʱŮ','http://www.pclady.com.cn','664','','yowao','5','0','0','0','');
INSERT INTO yowao_recycler VALUES('1324','','TOMŮ','http://lady.tom.com','664','','yowao','8','0','0','0','');
INSERT INTO yowao_recycler VALUES('1325','','Ůʱ','http://www.nvrenss.com','664','','yowao','7','0','0','0','');
INSERT INTO yowao_recycler VALUES('1326','','ѺŮ','http://women.sohu.com','664','','yowao','4','0','0','0','');
INSERT INTO yowao_recycler VALUES('1327','','21CNŮ˰','http://she.21cn.com','664','','yowao','11','0','0','0','');
INSERT INTO yowao_recycler VALUES('1328','','39Ů','http://woman.39.net','664','','yowao','10','0','0','0','');
INSERT INTO yowao_recycler VALUES('1329','','ս','http://www.kongjie.com','664','','yowao','9','0','0','0','');
INSERT INTO yowao_recycler VALUES('1330','','Ůʱ','http://www.nvyou.com','664','','yowao','14','0','0','0','');
INSERT INTO yowao_recycler VALUES('1331','','0nlyladyŮ־','http://www.onlylady.com','664','','yowao','13','0','0','0','');
INSERT INTO yowao_recycler VALUES('1332','','','http://www.liguiren.com','664','','yowao','12','0','0','0','');
INSERT INTO yowao_recycler VALUES('1333','','Ƶ','http://www.rayli.com.cn/beauty/','736','','yowao','1','0','0','0','');
INSERT INTO yowao_recycler VALUES('1334','','','http://eladies.sina.com.cn/beauty/index.shtml','736','','yowao','2','0','0','0','');
INSERT INTO yowao_recycler VALUES('1335','','','http://lady.163.com/beauty/','736','','yowao','5','0','0','0','');
INSERT INTO yowao_recycler VALUES('1336','','TOM','http://lady.tom.com/beauty/index.html','736','','yowao','6','0','0','0','');
INSERT INTO yowao_recycler VALUES('1337','','̫ƽŮ-','http://www.pclady.com.cn/beauty/','736','','yowao','8','0','0','0','');
INSERT INTO yowao_recycler VALUES('1338','','','http://beauty.daqi.com/','736','','yowao','13','0','0','0','');
INSERT INTO yowao_recycler VALUES('1339','','Ů','http://www.ruiliren.com/meirong','736','','yowao','11','0','0','0','');
INSERT INTO yowao_recycler VALUES('1340','','й','http://www.prccn.com/','736','','yowao','12','0','0','0','');
INSERT INTO yowao_recycler VALUES('1341','','YOKAʱ-ݽ','http://www.yoka.com/beauty/','736','','yowao','9','0','0','0','');
INSERT INTO yowao_recycler VALUES('1342','','Ƥ','http://www.guopi.com/','736','','yowao','18','0','0','0','');
INSERT INTO yowao_recycler VALUES('1343','','-Ƶ','http://eladies.sina.com.cn/man/','665','','yowao','1','0','0','0','');
INSERT INTO yowao_recycler VALUES('1344','','TomԲ','http://lady.tom.com/man','665','','yowao','3','0','0','0','');
INSERT INTO yowao_recycler VALUES('1345','','ʿ','http://www.menslive.com/','665','','yowao','6','0','0','0','');
INSERT INTO yowao_recycler VALUES('1346','','39-','http://man.39.net/','665','','yowao','4','0','0','0','');
INSERT INTO yowao_recycler VALUES('1347','','˰','http://www.vmans.com/','665','','yowao','2','0','0','0','');
INSERT INTO yowao_recycler VALUES('1348','','Ƶ-YOKA','http://www.yoka.com/men/','665','','yowao','7','0','0','0','');
INSERT INTO yowao_recycler VALUES('1349','','39-','http://fitness.39.net/','2234','','yowao','1','0','0','0','');
INSERT INTO yowao_recycler VALUES('1350','','Ѻ','http://women.sohu.com/meitishusheng.shtml','2234','','yowao','2','0','0','0','');
INSERT INTO yowao_recycler VALUES('1351','','Ů˼','http://www.ruiliren.com/meiti/','2234','','yowao','3','0','0','0','');
INSERT INTO yowao_recycler VALUES('1352','','Ů','http://www.ssnn.net/','2234','','yowao','7','0','0','0','');
INSERT INTO yowao_recycler VALUES('1353','','̫ƽŮ-','http://fitness.pclady.com.cn/','2234','','yowao','9','0','0','0','');
INSERT INTO yowao_recycler VALUES('1354','','sohuɳ','http://club.women.sohu.com/womenmain.php?c=4&b=fitness','2234','','yowao','10','0','0','0','');
INSERT INTO yowao_recycler VALUES('1355','','й','http://www.chinapet.net','821','','yowao','8','0','0','0','');
INSERT INTO yowao_recycler VALUES('1356','','й','http://www.chinapet.com/','821','','yowao','2','0','0','0','');
INSERT INTO yowao_recycler VALUES('1357','','˳','http://pet.sina.com.cn/','821','','yowao','5','0','0','0','');
INSERT INTO yowao_recycler VALUES('1358','','й','http://www.chinapet.net/','821','','yowao','1','0','0','0','');
INSERT INTO yowao_recycler VALUES('1359','','','http://www.hainet.cn/','821','','yowao','4','0','0','0','');
INSERT INTO yowao_recycler VALUES('1360','','','http://www.petking.cn/','821','','yowao','7','0','0','0','');
INSERT INTO yowao_recycler VALUES('1361','','֮','http://www.mypethome.com/','821','','yowao','6','0','0','0','');
INSERT INTO yowao_recycler VALUES('1362','','POCO','http://pet.poco.cn/','821','','yowao','10','0','0','0','');
INSERT INTO yowao_recycler VALUES('1363','','','http://www.goumin.com/','1347','','yowao','3','0','0','0','');
INSERT INTO yowao_recycler VALUES('1364','','л','http://c.cnhhcw.com/','1347','','yowao','7','0','0','0','');
INSERT INTO yowao_recycler VALUES('1365','','','http://www.aigou.com/','1347','','yowao','4','0','0','0','');
INSERT INTO yowao_recycler VALUES('1366','','йȮ','http://www.cndog.net/','1347','','yowao','1','0','0','0','');
INSERT INTO yowao_recycler VALUES('1367','','йȮ','http://www.policedog.com.cn/','1347','','yowao','8','0','0','0','');
INSERT INTO yowao_recycler VALUES('1368','','Ȯֲ','http://www.bandog.cn/','1347','','yowao','10','0','0','0','');
INSERT INTO yowao_recycler VALUES('1369','','Ϣ̳','http://bbs.zangao123.com','1347','','yowao','7','0','0','0','');
INSERT INTO yowao_recycler VALUES('1370','','йֲ','http://bbs.koiclub.net/','1345','','yowao','5','0','0','0','');
INSERT INTO yowao_recycler VALUES('1371','','Ҽˮ岿','http://www.afish.cn/','1345','','yowao','35','0','0','0','');
INSERT INTO yowao_recycler VALUES('1372','','޺','http://bbs.myluohan.com/','1345','','yowao','17','0','0','0','');
INSERT INTO yowao_recycler VALUES('1373','','-ˮ֮','http://fish.hainet.cn/','1345','','yowao','2','0','0','0','');
INSERT INTO yowao_recycler VALUES('1374','','֮','http://bbs.cnfish.com/','1345','','yowao','19','0','0','0','');
INSERT INTO yowao_recycler VALUES('1375','','֮','http://www.arowanahome.com/','1345','','yowao','23','0','0','0','');
INSERT INTO yowao_recycler VALUES('1376','','йˮҵ','http://cn.chinapets.com/','1345','','yowao','3','0','0','0','');
INSERT INTO yowao_recycler VALUES('1377','','йƵ','http://www.chinafishtv.com/index.asp','1345','','yowao','6','0','0','0','');
INSERT INTO yowao_recycler VALUES('1378','','֮','http://www.cngui.com/','1345','','yowao','26','0','0','0','');
INSERT INTO yowao_recycler VALUES('1379','','԰','http://www.bxgly.com','1345','','yowao','36','0','0','0','');
INSERT INTO yowao_recycler VALUES('1380','','̫ƽ','http://www.pconline.com.cn/','1122','','yowao','13','0','25','1','');
INSERT INTO yowao_recycler VALUES('1381','','ѶƼ','http://tech.qq.com/','1122','','yowao','5','0','0','0','');
INSERT INTO yowao_recycler VALUES('1382','','IT168.com','http://www.it168.com/','1122','','yowao','17','0','0','0','');
INSERT INTO yowao_recycler VALUES('1383','','TechWeb','http://www.techweb.com.cn/','1122','','yowao','4','0','0','0','');
INSERT INTO yowao_recycler VALUES('1384','','йش','http://www.zol.com.cn/','1122','','yowao','11','0','0','0','');
INSERT INTO yowao_recycler VALUES('1385','','֮','http://www.pchome.net/','1122','','yowao','12','0','24','1','');
INSERT INTO yowao_recycler VALUES('1386','','','http://www.cbinews.com/','1122','','yowao','15','0','0','0','');
INSERT INTO yowao_recycler VALUES('1387','','켫','http://www.yesky.com/','1122','','yowao','14','0','0','0','');
INSERT INTO yowao_recycler VALUES('1388','','','http://www.ccidnet.com/','1122','','yowao','7','0','0','0','');
INSERT INTO yowao_recycler VALUES('1389','','Donews','http://www.donews.com/','1122','','yowao','6','0','0','0','');
INSERT INTO yowao_recycler VALUES('1390','','','http://www.ccw.com.cn/','1122','','yowao','20','0','0','0','');
INSERT INTO yowao_recycler VALUES('1391','','cnBetaҵѶ','http://www.cnbeta.com/','1122','','yowao','9','0','0','0','');
INSERT INTO yowao_recycler VALUES('1392','','CSDN','http://www.csdn.net/','1122','','yowao','10','0','0','0','');
INSERT INTO yowao_recycler VALUES('1393','','','http://www.chinabyte.com/','1122','','yowao','8','0','0','0','');
INSERT INTO yowao_recycler VALUES('1394','','','http://www.pcpop.com/','1122','','yowao','16','0','0','0','');
INSERT INTO yowao_recycler VALUES('1395','','IT','http://www.it.com.cn/','1122','','yowao','18','0','0','0','');
INSERT INTO yowao_recycler VALUES('1396','','˿Ƽ','http://tech.sina.com.cn/','1122','','yowao','1','0','0','0','');
INSERT INTO yowao_recycler VALUES('1397','','eNetȶ','http://www.enet.com.cn/','1122','','yowao','19','0','0','0','');
INSERT INTO yowao_recycler VALUES('1398','','׿Ƽ','http://tech.163.com/','1122','','yowao','2','0','0','0','');
INSERT INTO yowao_recycler VALUES('1399','','ѺIT','http://it.sohu.com/','1122','','yowao','3','0','0','0','');
INSERT INTO yowao_recycler VALUES('1400','','йITʵ','http://www.chinaitlab.com/','1122','','yowao','23','0','0','0','');
INSERT INTO yowao_recycler VALUES('1401','','ʵ','http://www.chinalabs.com/','1122','','yowao','22','0','0','0','');
INSERT INTO yowao_recycler VALUES('1402','','Ա','http://www.shudoo.com/','1122','','yowao','24','0','0','0','');
INSERT INTO yowao_recycler VALUES('1403','','IT˼԰','http://blog.ccidnet.com/','2200','','yowao','9','0','0','0','');
INSERT INTO yowao_recycler VALUES('1404','','IT','http://blog.sina.com.cn/lm/tech/','2200','','yowao','1','0','0','0','');
INSERT INTO yowao_recycler VALUES('1405','','DoNews Blog','http://blog.donews.com/default.html','2200','','yowao','3','0','0','0','');
INSERT INTO yowao_recycler VALUES('1406','','ѺITȺ','http://blog.sohu.com/it/','2200','','yowao','2','0','0','0','');
INSERT INTO yowao_recycler VALUES('1407','','TechWeb IT','http://blog.techweb.com.cn/','2200','','yowao','6','0','0','0','');
INSERT INTO yowao_recycler VALUES('1408','','CSDN','http://blog.csdn.net/default.html','2200','','yowao','7','0','0','0','');
INSERT INTO yowao_recycler VALUES('1409','','Yeah.net','http://www.yeah.net/','1068','','yowao','1','1','0','0','');
INSERT INTO yowao_recycler VALUES('1410','','Ѻʼ','http://login.mail.sohu.com','1068','','yowao','4','0','0','0','');
INSERT INTO yowao_recycler VALUES('1411','','21CN','http://mail.21cn.com/','1068','','yowao','11','0','0','0','');
INSERT INTO yowao_recycler VALUES('1412','','163','http://mail.163.com','1068','','yowao','2','0','0','0','');
INSERT INTO yowao_recycler VALUES('1413','','','http://mail.sina.com.cn','1068','','yowao','5','0','0','0','');
INSERT INTO yowao_recycler VALUES('1414','','126','http://www.126.com','1068','','yowao','3','0','0','0','');
INSERT INTO yowao_recycler VALUES('1415','','TOM','http://mail.tom.com','1068','','yowao','7','0','0','0','');
INSERT INTO yowao_recycler VALUES('1416','','MSN','http://login.live.com/','1068','','yowao','9','0','0','0','');
INSERT INTO yowao_recycler VALUES('1417','','йƶ139','http://mail.139.com/','1068','','yowao','12','0','0','0','');
INSERT INTO yowao_recycler VALUES('1418','','G-Mail','http://www.gmail.com','1068','','yowao','8','0','0','0','');
INSERT INTO yowao_recycler VALUES('1419','','QQ','http://mail.qq.com','1068','','yowao','10','0','0','0','');
INSERT INTO yowao_recycler VALUES('1420','','Ż','http://cn.mail.yahoo.com/','1068','','yowao','6','1','0','0','');
INSERT INTO yowao_recycler VALUES('1421','','ӥȫ','http://www.3800hk.com/','1139','','yowao','3','0','0','0','');
INSERT INTO yowao_recycler VALUES('1422','','ȫ̳','http://www.hackeroo.com/','1358','','yowao','24','0','0','0','');
INSERT INTO yowao_recycler VALUES('1423','','йڿ̳','http://www.cnhacker.com/bbs/','1358','','yowao','25','0','0','0','');
INSERT INTO yowao_recycler VALUES('1424','','ڿͷ߼̳','http://www.hacker.com.cn/forum/','1358','','yowao','30','0','0','0','');
INSERT INTO yowao_recycler VALUES('1425','','web-hack','http://www.web-hack.ru/','1360','','yowao','2','0','0','0','');
INSERT INTO yowao_recycler VALUES('1426','','켫','http://desktop.yesky.com/','711','','yowao','2','0','0','0','');
INSERT INTO yowao_recycler VALUES('1427','','Ѷ-ֽվ','http://comic.qq.com/wp/','711','','yowao','11','0','0','0','');
INSERT INTO yowao_recycler VALUES('1428','','èèֽ','http://www.wallcoo.com/','711','','yowao','4','0','0','0','');
INSERT INTO yowao_recycler VALUES('1429','','','http://www.deskcity.com/','711','','yowao','1','0','0','0','');
INSERT INTO yowao_recycler VALUES('1430','','ֽ','http://www.kpbz.net/','711','','yowao','12','0','0','0','');
INSERT INTO yowao_recycler VALUES('1431','','Żֽ','http://image.cn.yahoo.com/imglist.html?bid=3&f=D15_u','711','','yowao','15','0','0','0','');
INSERT INTO yowao_recycler VALUES('1432','','TOM-Ϸֽ','http://games.tom.com/pic/','711','','yowao','14','0','0','0','');
INSERT INTO yowao_recycler VALUES('1433','','йվվ-ֽ','http://desk.chinaz.com','711','','yowao','3','0','0','0','');
INSERT INTO yowao_recycler VALUES('1434','','','http://kuoo8.com','711','','yowao','24','0','0','0','');
INSERT INTO yowao_recycler VALUES('1435','','ֽ','http://www.zhuoku.com/','711','','yowao','13','0','0','0','');
INSERT INTO yowao_recycler VALUES('1436','','ֽվ','http://www.seedesk.cn/','711','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1437','','ֽǧѰ','http://www.cndesk.com','711','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1438','','DoNews Blog','http://blog.donews.com/default.html','669','','yowao','35','0','0','0','');
INSERT INTO yowao_recycler VALUES('1439','','','http://popo.163.com','744','','yowao','7','0','0','0','');
INSERT INTO yowao_recycler VALUES('1440','','UC','http://uc.sina.com.cn/','744','','yowao','4','0','0','0','');
INSERT INTO yowao_recycler VALUES('1441','','MSN','http://im.live.cn/','744','','yowao','2','0','4','1','');
INSERT INTO yowao_recycler VALUES('1442','','ѶQQ','http://im.qq.com/','744','','yowao','1','0','2','1','');
INSERT INTO yowao_recycler VALUES('1443','','Google Talk','http://www.google.com/talk/','744','','yowao','12','0','0','0','');
INSERT INTO yowao_recycler VALUES('1444','','','http://www.fetion.com.cn/','744','','yowao','5','0','0','0','');
INSERT INTO yowao_recycler VALUES('1445','','','http://alitalk.alibaba.com.cn/','744','','yowao','8','0','0','0','');
INSERT INTO yowao_recycler VALUES('1446','','Уͨ','http://xiaonei.com/pages/im.jsp','744','','yowao','10','0','0','0','');
INSERT INTO yowao_recycler VALUES('1447','','ֻMSN','http://mobile.msn.com.cn/','744','','yowao','18','0','0','0','');
INSERT INTO yowao_recycler VALUES('1448','','UUCall绰','http://www.uucall.com/','744','','yowao','15','0','0','0','');
INSERT INTO yowao_recycler VALUES('1449','','Żͨ','http://cn.messenger.yahoo.com/','744','','yowao','6','0','0','0','');
INSERT INTO yowao_recycler VALUES('1450','','ֻQQ','http://mobile.qq.com/','744','','yowao','17','0','0','0','');
INSERT INTO yowao_recycler VALUES('1451','','Сi','http://spcode.baidu.com/spcode/spClick?tn=dh_sp&ctn=0&styleid=1268&tourl=http://www.xiaoi.com/bd/xa.jsp?','744','','yowao','14','0','0','0','');
INSERT INTO yowao_recycler VALUES('1452','','TS-Teamspeak','http://ts.youxia.com/','744','','yowao','13','0','0','0','');
INSERT INTO yowao_recycler VALUES('1453','','ٶHI','http://im.baidu.com/','744','','yowao','9','0','0','0','');
INSERT INTO yowao_recycler VALUES('1454','','','http://www.liaoliao.com','742','','yowao','5','0','0','0','');
INSERT INTO yowao_recycler VALUES('1455','','UCƵ','http://chat.sina.com.cn/homepage/chat_index.shtml','742','','yowao','2','0','0','0','');
INSERT INTO yowao_recycler VALUES('1456','','Ƶ','http://www.loveliao.com/','742','','yowao','1','0','0','0','');
INSERT INTO yowao_recycler VALUES('1457','','԰','http://bliao.com/','742','','yowao','3','0','0','0','');
INSERT INTO yowao_recycler VALUES('1458','','QQ','http://chat.qq.com/','742','','yowao','4','0','0','0','');
INSERT INTO yowao_recycler VALUES('1459','','','http://www.7liao.com/','742','','yowao','17','0','0','0','');
INSERT INTO yowao_recycler VALUES('1460','','','http://www.netliao.com/','742','','yowao','21','0','0','0','');
INSERT INTO yowao_recycler VALUES('1461','','-','http://chat.inhe.net/','742','','yowao','13','0','0','0','');
INSERT INTO yowao_recycler VALUES('1462','','QQ','http://www.qqfzl.com','2044','','yowao','5','0','0','0','');
INSERT INTO yowao_recycler VALUES('1463','','QQ','http://www.qzoner.com/','2044','','yowao','1','0','0','0','');
INSERT INTO yowao_recycler VALUES('1464','','QQռվ-跻','http://www.qqywf.com/','2044','','yowao','7','0','0','0','');
INSERT INTO yowao_recycler VALUES('1465','','ʫQQվ','http://www.klss.cn/','2044','','yowao','2','0','0','0','');
INSERT INTO yowao_recycler VALUES('1466','','QQJAYռվ','http://www.qqjay.com/','2044','','yowao','4','0','0','0','');
INSERT INTO yowao_recycler VALUES('1467','','ʱQռվ','http://www.lm5588.com','2044','','yowao','10','0','0','0','');
INSERT INTO yowao_recycler VALUES('1468','','QQռװ','http://www.mimi456.com/','2044','','yowao','9','0','0','0','');
INSERT INTO yowao_recycler VALUES('1469','','QQֿռ','http://www.qqok.net/index.html','2044','','yowao','6','0','0','0','');
INSERT INTO yowao_recycler VALUES('1470','','QQУ','http://www.qqxn.com','2044','','yowao','8','0','0','0','');
INSERT INTO yowao_recycler VALUES('1471','','QQռվ','http://www.qqpk.cn/','2044','','yowao','11','0','0','0','');
INSERT INTO yowao_recycler VALUES('1472','','̫ƽ','http://www.pconline.com.cn','1096','','yowao','1','0','0','0','');
INSERT INTO yowao_recycler VALUES('1473','','IT168','http://www.it168.com','1096','','yowao','5','0','0','0','');
INSERT INTO yowao_recycler VALUES('1474','','','http://www.dnsz.com.cn','1096','','yowao','6','0','0','0','');
INSERT INTO yowao_recycler VALUES('1475','','ý','http://www.thethirdmedia.com','1096','','yowao','17','0','0','0','');
INSERT INTO yowao_recycler VALUES('1476','','','http://www.cbinews.com/','1096','','yowao','9','0','0','0','');
INSERT INTO yowao_recycler VALUES('1477','','֮-Ӳ','http://hardware.pchome.net','1096','','yowao','13','0','0','0','');
INSERT INTO yowao_recycler VALUES('1478','','켫','http://www.yesky.com/','1096','','yowao','4','0','0','0','');
INSERT INTO yowao_recycler VALUES('1479','','йش','http://product.zol.com.cn','1096','','yowao','2','0','0','0','');
INSERT INTO yowao_recycler VALUES('1480','','IT','http://www.it.com.cn/','1096','','yowao','3','0','0','0','');
INSERT INTO yowao_recycler VALUES('1481','','֮','http://www.mydrivers.com/default.shtml','1096','','yowao','10','0','0','0','');
INSERT INTO yowao_recycler VALUES('1482','','۴ITг','http://it.hc360.com/','1096','','yowao','16','0','0','0','');
INSERT INTO yowao_recycler VALUES('1483','','-Ӳ','http://tech.sina.com.cn/hardware/','1096','','yowao','12','0','0','0','');
INSERT INTO yowao_recycler VALUES('1484','','','http://www.pcpop.com/','1096','','yowao','7','0','0','0','');
INSERT INTO yowao_recycler VALUES('1485','','eNet-ӲDIY','http://www.enet.com.cn/hardwares/','1096','','yowao','11','0','0','0','');
INSERT INTO yowao_recycler VALUES('1486','','й','http://www.52design.com','2106','','yowao','7','0','0','0','');
INSERT INTO yowao_recycler VALUES('1487','','й','http://www.arting365.com/','2106','','yowao','2','0','0','0','');
INSERT INTO yowao_recycler VALUES('1488','','й','http://www.chinaddu.com/','2106','','yowao','6','0','0','0','');
INSERT INTO yowao_recycler VALUES('1489','','','http://www.chda.net/','2106','','yowao','18','0','0','0','');
INSERT INTO yowao_recycler VALUES('1490','','','http://www.gjart.cn/','2106','','yowao','4','0','0','0','');
INSERT INTO yowao_recycler VALUES('1491','','','http://www.dolcn.com/','2106','','yowao','5','0','0','0','');
INSERT INTO yowao_recycler VALUES('1492','','','http://www.cndu.cn/','2106','','yowao','12','0','0','0','');
INSERT INTO yowao_recycler VALUES('1493','','','http://design.icxo.com/','2106','','yowao','15','0','0','0','');
INSERT INTO yowao_recycler VALUES('1494','','Ӿ','http://www.okvi.com/','2106','','yowao','13','0','0','0','');
INSERT INTO yowao_recycler VALUES('1495','','춯й','http://bbs.redocn.com/','2106','','yowao','9','0','0','0','');
INSERT INTO yowao_recycler VALUES('1496','','Ӿ','http://www.ionly.com.cn/','2106','','yowao','8','0','0','0','');
INSERT INTO yowao_recycler VALUES('1497','','','http://www.wmgdesign.com/','2106','','yowao','10','0','0','0','');
INSERT INTO yowao_recycler VALUES('1498','','й֮','http://www.333cn.com/','2106','','yowao','11','0','0','0','');
INSERT INTO yowao_recycler VALUES('1499','','','http://www.fansart.com/','2106','','yowao','20','0','0','0','');
INSERT INTO yowao_recycler VALUES('1500','','Ʒ','http://www.shejifang.com','2106','','yowao','14','0','0','0','');
INSERT INTO yowao_recycler VALUES('1501','','֮','http://www.sj33.cn','2106','','yowao','21','0','0','0','');
INSERT INTO yowao_recycler VALUES('1502','','˼Ե̳','http://www.missyuan.com','2106','','yowao','22','0','0','0','');
INSERT INTO yowao_recycler VALUES('1503','','Ӿй','http://www.chinavisual.com/','2106','','yowao','3','0','0','0','');
INSERT INTO yowao_recycler VALUES('1504','','Ӿͬ','http://www.visionunion.com/','2106','','yowao','1','0','0','0','');
INSERT INTO yowao_recycler VALUES('1505','','ɫ','http://www.blueidea.com/','2106','','yowao','17','0','0','0','');
INSERT INTO yowao_recycler VALUES('1506','','վ','http://www.zcool.com.cn/','2106','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1507','','ز','http://www.sucaitianxia.com/','2106','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1508','','ͼ','http://www.aiimg.com/','2106','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1509','','ز','http://www.coolsc.net/','2106','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1510','','ͼ','http://www.ooopic.com/','2106','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1511','','ͼ','http://xiuxiu.meitu.com/','2106','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1512','','ͼ','http://www.gaitu.com/','2106','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1513','','ͼ','http://www.tucoo.com/','2106','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1514','','ز','http://www.coolsc.net/','2106','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1515','','ͼ','http://www.ooopic.com/','2106','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1516','','ͼ','http://xiuxiu.meitu.com/','2106','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1517','','ͼ','http://www.lanrentuku.com/','2106','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1518','','ͼ','http://www.nipic.com/','2106','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1519','','زй','http://www.sccnn.com/','2106','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1520','','3lianز','http://www.3lian.com/','2106','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1521','','ͼ','http://www.lanrentuku.com/','2106','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1522','','֮','http://www.sj33.cn/','2106','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1523','','','http://www.penshow.cn/','2106','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1524','','ģ','http://www.mobanwang.com/','2106','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1525','','Ӿй°','http://down.chinavisual.com/','2106','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1526','','ͼ','http://www.nipic.com/','2106','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1527','','زй','http://www.sccnn.com/','2106','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1528','','վ','http://www.zcool.com.cn/','2106','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1529','','ز','http://www.sucaitianxia.com/','2106','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1530','','ͼ','http://www.aiimg.com/','2106','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1531','','ͼ','http://www.gaitu.com/','2106','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1532','','ͼ','http://www.tucoo.com/','2106','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1533','','3lianز','http://www.3lian.com/','2106','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1534','','֮','http://www.sj33.cn/','2106','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1535','','','http://www.penshow.cn/','2106','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1536','','ģ','http://www.mobanwang.com/','2106','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1537','','Ӿй°','http://down.chinavisual.com/','2106','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1538','','ͼ','http://www.tucoo.com','2107','','yowao','4','0','0','0','');
INSERT INTO yowao_recycler VALUES('1539','','ģ','http://www.mbsky.com','2107','','yowao','14','0','0','0','');
INSERT INTO yowao_recycler VALUES('1540','','ģ','http://bestmoban.com/','2107','','yowao','15','0','0','0','');
INSERT INTO yowao_recycler VALUES('1541','','زй','http://www.sc-cn.net/','2107','','yowao','1','0','0','0','');
INSERT INTO yowao_recycler VALUES('1542','','վ','http://www.zcool.com.cn/','2107','','yowao','2','0','0','0','');
INSERT INTO yowao_recycler VALUES('1543','','52designزĿ','http://sc.52design.com/','2107','','yowao','7','0','0','0','');
INSERT INTO yowao_recycler VALUES('1544','','վز','http://sc.chinaz.com/','2107','','yowao','3','0','0','0','');
INSERT INTO yowao_recycler VALUES('1545','','ز!','http://www.haosc.cn/','2107','','yowao','8','0','0','0','');
INSERT INTO yowao_recycler VALUES('1546','','زĻҳ','http://www.114sucai.com','2107','','yowao','9','0','0','0','');
INSERT INTO yowao_recycler VALUES('1547','','3lianز','http://www.3lian.com/','2107','','yowao','5','0','0','0','');
INSERT INTO yowao_recycler VALUES('1548','','ͼ','http://www.lanrentuku.com/','2107','','yowao','11','0','0','0','');
INSERT INTO yowao_recycler VALUES('1549','','ģ','http://www.mb5u.com','2107','','yowao','27','0','0','0','');
INSERT INTO yowao_recycler VALUES('1550','','','http://www.jianjie8.com','2107','','yowao','6','0','0','0','');
INSERT INTO yowao_recycler VALUES('1551','','ͼ','http://www.ooopic.com/','2107','','yowao','10','0','0','0','');
INSERT INTO yowao_recycler VALUES('1552','','й','http://www.bc-cn.net/','1153','','yowao','3','0','0','0','');
INSERT INTO yowao_recycler VALUES('1553','','Ѷ-Ա','http://developer.weaseek.com/','1153','','yowao','10','0','0','0','');
INSERT INTO yowao_recycler VALUES('1554','','Flash','http://www.f130.net/','758','','yowao','4','0','0','0','');
INSERT INTO yowao_recycler VALUES('1555','','TT67Flash','http://www.tt67.com/','758','','yowao','5','0','0','0','');
INSERT INTO yowao_recycler VALUES('1556','','51flash','http://www.51flash.com/','758','','yowao','9','0','0','0','');
INSERT INTO yowao_recycler VALUES('1557','',';ֲ','http://www.flasherclub.com/','758','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1558','','йFlash','http://www.flashtc.com/','760','','yowao','10','0','0','0','');
INSERT INTO yowao_recycler VALUES('1559','','͵۹-ѧ','http://www.flashempire.com/school/index.php','760','','yowao','1','0','0','0','');
INSERT INTO yowao_recycler VALUES('1560','','͵۹̳','http://www.flashempire.net/','762','','yowao','1','0','0','0','');
INSERT INTO yowao_recycler VALUES('1561','','йFLASH','http://bbs.flashtc.com/','762','','yowao','3','0','0','0','');
INSERT INTO yowao_recycler VALUES('1562','','ɽʰѰ','http://www.xiazaiba.com/downinfo/4419.html','1047','#178517','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1563','','й','http://www.neea.edu.cn','991','','yowao','13','0','0','0','');
INSERT INTO yowao_recycler VALUES('1564','','й','http://www.neea.edu.cn/','991','','yowao','16','0','0','0','');
INSERT INTO yowao_recycler VALUES('1565','','ҵ','http://www.mymishu.com/','1043','','yowao','13','0','0','0','');
INSERT INTO yowao_recycler VALUES('1566','','123μվ','http://www.123xz.net/','1037','','yowao','5','0','0','0','');
INSERT INTO yowao_recycler VALUES('1567','','','http://www.tingxs.com/','1018','','yowao','1','0','0','0','');
INSERT INTO yowao_recycler VALUES('1568','','շ','http://www.skyfc.com/','719','','yowao','11','0','0','0','');
INSERT INTO yowao_recycler VALUES('1569','','ӵĻ','http://www.laozi123.com/','2162','','yowao','3','0','0','0','');
INSERT INTO yowao_recycler VALUES('1570','','TOMͬ','http://arts.tom.com','1017','','yowao','5','0','0','0','');
INSERT INTO yowao_recycler VALUES('1571','','Ž','http://www.gujinyishu.com','1019','','yowao','11','0','0','0','');
INSERT INTO yowao_recycler VALUES('1572','','鼮','http://www.zangmige.cn','2163','','yowao','11','0','0','0','');
INSERT INTO yowao_recycler VALUES('1573','','йվ','http://www.chineseprotestantchurch.org','2165','','yowao','1','0','0','0','');
INSERT INTO yowao_recycler VALUES('1574','','','http://www.musicsky.org/','2165','','yowao','13','0','0','0','');
INSERT INTO yowao_recycler VALUES('1575','','51','http://www.51zhaoren.com','1884','','yowao','6','0','0','0','');
INSERT INTO yowao_recycler VALUES('1576','','ɫ֮','http://www.lvsezhixing.com','1006','','yowao','12','0','0','0','');
INSERT INTO yowao_recycler VALUES('1577','','588̼','http://www.dian588.cn','2283','','yowao','3','0','0','0','');
INSERT INTO yowao_recycler VALUES('1578','','ҵҳ','http://yp.sina.net','1253','','yowao','14','0','0','0','');
INSERT INTO yowao_recycler VALUES('1579','','ȫҳ','http://www.21page.net','1253','','yowao','1','0','0','0','');
INSERT INTO yowao_recycler VALUES('1580','','йŻҳ','http://www.locoso.com/','1253','','yowao','8','0','0','0','');
INSERT INTO yowao_recycler VALUES('1581','','йҵҳ','http://www.page.net.cn','1253','','yowao','4','0','0','0','');
INSERT INTO yowao_recycler VALUES('1582','','58ͬ','http://www.58.com/','1253','','yowao','11','0','0','0','');
INSERT INTO yowao_recycler VALUES('1583','','ҵҳ','http://www.3653h.com/','1253','','yowao','12','0','0','0','');
INSERT INTO yowao_recycler VALUES('1584','','ȫҵ','http://www.qychina.com/','1253','','yowao','10','0','0','0','');
INSERT INTO yowao_recycler VALUES('1585','','йҳȫ','http://www.ypall.com/','1253','','yowao','2','0','0','0','');
INSERT INTO yowao_recycler VALUES('1586','','ҵ','http://www.public.net.cn/','1253','','yowao','20','0','0','0','');
INSERT INTO yowao_recycler VALUES('1587','','ٶȻҳ','http://yp.baidu.com/','1253','','yowao','7','0','0','0','');
INSERT INTO yowao_recycler VALUES('1588','','Ͱ͹˾','http://page.china.alibaba.com/cp/cp1.html','1253','','yowao','5','0','0','0','');
INSERT INTO yowao_recycler VALUES('1589','','й','http://www.99114.com/','1253','','yowao','3','0','0','0','');
INSERT INTO yowao_recycler VALUES('1590','','й','http://www.mofcom.gov.cn','2296','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1591','','','http://www.linkshop.com.cn','2296','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1592','','۴','http://www.hc360.com','2296','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1593','','Ͱ','http://china.alibaba.com','2296','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1594','','վ','http://china.tootoo.com','2296','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1595','','Ȧ','http://www.bbspace.cn','2296','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1596','','','http://www.sooe.cn','2296','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1597','','йб','http://www.bidchance.com','2296','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1598','','','http://www.mymai.com','2296','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1599','','ҵ','http://china.busytrade.com','2296','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1600','','йͶָ','http://www.fdi.gov.cn','2296','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1601','','йбϢ','http://www.cnbidding.com','2296','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1602','','йó','http://www.cnexpnet.com','2296','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1603','','','http://win.mofcom.gov.cn','2296','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1604','','ó','http://www.herostart.com.cn','2296','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1605','','۴-ָ','http://www.biz.hc360.com','2296','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1606','','йƷ','http://www.chinapp.com','2296','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1607','','Ʒ첥','http://www.npicp.com','2296','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1608','','ʽó','http://www.vooec.com','2296','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1609','','','http://www.zs91.com','2296','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1610','','й','http://www.changshang.com','2296','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1611','','л','http://www.i18.cn','2296','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1612','','йֱרҵ','http://www.cdsp.com.cn','2296','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1613','','ָ','http://www.pfzn.com','2296','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1614','','йó׽','http://www.sinotf.com','2296','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1615','','FTAó','http://www.ecfta.com','2296','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1616','','ȫó','http://www.global-trade-center.com','2296','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1617','','й鱨','http://www.chinasqbg.com','2296','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1618','','л','http://www.ccmnet.com','2296','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1619','','йҵо','http://www.chinahyyj.com','2296','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1620','','ٶо','http://data.baidu.com','2296','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1621','','Ѷ','http://www.gxbaogao.com','2296','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1622','','й','http://www.chinabgao.com','2296','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1623','','Ѷ','http://www.365report.com','2296','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1624','','ֱͨ','http://www.reportbus.com','2296','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1625','','йҵ','http://www.china3608.com/index.html','2296','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1626','','51ҵ','http://www.51baogao.cn','2296','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1627','','','http://www.ceocio.com.cn','2296','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1628','','Ƹ-FORTUNE','http://www.fortunechina.com','2296','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1629','','ƾ','http://www.caijing.com.cn','2296','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1630','','ҵʱ','http://www.ectime.com.cn','2296','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1631','','ҵܿ','http://www.businessweekchina.com','2296','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1632','','ձ','http://chinese.wsj.com','2296','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1633','','йӪ','http://www.cb.com.cn','2296','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1634','','йչ','http://www.expo-china.com','2296','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1635','','йչ','http://www.51wzst.com','2296','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1636','','йչ','http://www.cce.net.cn','2296','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1637','','չ','http://fair.mofcom.gov.cn','2296','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1638','','Ͱ-չ','http://expo.china.alibaba.com','2296','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1639','','','http://www.expo2010china.com','2296','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1640','','չ','http://www.ciec.com.cn','2296','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1641','','ɻչ','http://fair.cbiq.com','2296','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1642','','йũҵϢ','http://www.agri.gov.cn','2297','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1643','','ũ','http://www.xinnong.com','2297','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1644','','Ͱ-ũҵ','http://china.alibaba.com/buy/trade/1.html','2297','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1645','','ũ','http://www.aweb.com.cn','2297','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1646','','ũϢ','http://www.12582.com','2297','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1647','','ũ','http://www.nocn.com.cn','2297','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1648','','йũҵ','http://www.zgny.com.cn','2297','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1649','','ũ','http://www.jinnong.cn','2297','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1650','','йʳϢ','http://www.grain.gov.cn','2297','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1651','','ɼũ','http://www.99sj.com','2297','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1652','','ũ','http://www.ap88.com','2297','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1653','','ũ','http://www.nong365.com','2297','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1654','','йũ','http://www.cnan.gov.cn','2297','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1655','','йũ彨','http://www.xyjj.org.cn','2297','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1656','','ũƼ','http://3n.gxsti.net','2297','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1657','','й۸Ϣ','http://www.chinaprice.gov.cn','2297','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1658','','йʳ','http://www.oil86.com','2297','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1659','','Խũ','http://www.cv-nz.com/index.html?currently=home','2297','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1660','','йũ','http://www.nm18.com','2297','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1661','','йֳ','http://www.chinabreed.com','2297','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1662','','йҵϢ','http://www.caaa.cn','2297','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1663','','йֳ','http://www.yangzhi.com','2297','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1664','','лҵϢ','http://www.cnxmy.com','2297','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1665','','ǺѶ','http://www.boyar.cn','2297','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1666','','йҵ','http://www.china-ah.com','2297','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1667','','ֳ','http://www.yangzhi.net','2297','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1668','','йҽ','http://www.cnaho.com','2297','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1669','','','http://www.xbxmw.com','2297','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1670','','л','http://www.zhuw365.com','2297','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1671','','йݲ','http://www.qinbing.cn','2297','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1672','','йţ','http://www.niuyang.cc','2297','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1673','','¸','http://www.zbxgx.com','2297','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1674','','ɫֳ','http://www.70ee.com','2297','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1675','','ԭ','http://www.hnfeed.com','2297','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1676','','йľ','http://www.cnhm.net','2297','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1677','','ҵ','http://www.forestry.gov.cn','2297','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1678','','йҵϢ','http://www.lknet.ac.cn','2297','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1679','','йľ̻','http://www.yxmm.com','2297','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1680','','йľ۸','http://www.cqtree.net','2297','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1681','','ũˮ','http://fishery.aweb.com.cn','2297','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1682','','йҵ','http://www.yyew.com','2297','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1683','','йˮŻ','http://www.bbwfish.com','2297','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1684','','йˮֳ','http://www.shuichan.cc','2297','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1685','','лز','http://www.myttc.cn','2297','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1686','','л','http://www.cngrain.com','2297','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1687','','й޻Ϣ','http://www.cottonchina.org','2297','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1688','','й','http://www.cnpeanut.com','2297','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1689','','й','http://www.zao.com.cn','2297','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1690','','й','http://www.dadou.cn','2297','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1691','','йˮϢ','http://www.chinariceinfo.com','2297','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1692','','йг','http://www.ex-starch.com','2297','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1693','','й޻','http://www.cncotton.com','2297','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1694','','й','http://www.114665.cn','2297','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1695','','йũ','http://www.ampcn.com','2297','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1696','','й','http://www.zhongzi.net','2297','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1697','','۴ũ','http://www.nong-zi.com','2297','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1698','','йϢ','http://www.china-fertinfo.com.cn','2297','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1699','','й','http://www.ferinfo.com','2297','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1700','','йũҩϢ','http://www.chinapesticide.gov.cn','2297','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1701','','йũҩ','http://www.agrichem.cn','2297','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1702','','ũҵ','http://seed.aweb.com.cn','2297','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1703','','йҵϢ','http://www.feedtrade.com.cn','2297','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1704','','й','http://www.chinafeedonline.com/china/index.jsp','2297','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1705','','йϼ','http://www.feedtech.com.cn','2297','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1706','','йϹҵϢ','http://www.chinafeed.org.cn','2297','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1707','','йѯ','http://www.chinajci.com/default.asp','2297','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1708','','ũ','http://www.efeedlink.com.cn','2297','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1709','','ӼϢ','http://www.chinafeedadditive.com','2297','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1710','','ϷϢ','http://www.sfe.net.cn','2297','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1711','','йũҵе','http://www.nyjx.cn','2297','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1712','','йũ','http://www.nongjiwang.com','2297','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1713','','йũҵеѧ','http://www.agro-csam.org','2297','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1714','','йũҵеϢ','http://www.amic.agri.gov.cn','2297','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1715','','йװ','http://www.t100.cn','2298','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1716','','йװЭ','http://www.cnga.org.cn','2298','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1717','','лװ','http://www.51fashion.com.cn','2298','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1718','','йƷƷװ','http://www.china-ef.com','2298','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1719','','йŮװ','http://www.nz86.com','2298','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1720','','йţзװ','http://www.511340.com','2298','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1721','','۴Ϸװ','http://www.cloth.hc360.com','2298','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1722','','·','http://www.yifu.com','2298','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1723','','йװ','http://www.f168z.com','2298','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1724','','й֯','http://www.wears.com.cn','2298','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1725','','й֯װ','http://www.bcnq.com','2298','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1726','','й֯','http://www.texnet.com.cn','2298','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1727','','ʱװ','http://fashion.icxo.com','2298','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1728','','ʱзװ','http://www.cnwear.com','2298','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1729','','й豸','http://www.sewworld.com','2298','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1730','','Ů-Ƶ','http://www.rayli.com.cn/fashion','2298','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1731','','ELLEʱг','http://www.ellechina.com','2298','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1732','','ȫװ','http://www.qqfzbj.com','2298','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1733','','лͯװ','http://www.e-ccdc.com','2298','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1734','','йͯװ','http://www.51kids.com','2298','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1735','','й','http://www.zgkz.cn','2298','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1736','','ƷƷλ','http://www.114la.com/shenghuopinpai/2188.htm#1871','2298','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1737','','йͯװƷ','http://www.61kids.com.cn','2298','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1738','','йװʽ','http://www.yfu.cn','2298','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1739','','廨','http://www.linkgd.com','2298','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1740','','йװЬñ','http://www.fzxm.com','2298','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1741','','װЬñ','http://www.sjfzxm.com','2298','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1742','','йЬҵ','http://www.cn-shoes.net','2298','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1743','','йЬҵ','http://www.chinashoes.com','2298','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1744','','йЬ','http://www.cnshoes.com','2298','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1745','','йЬcnxz.cn','http://www.cnxz.cn','2298','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1746','','ѲЬ','http://www.soxu.cn','2298','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1747','','඼','http://www.worldsocks.com','2298','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1748','','йЬҵ','http://www.shoeol.com','2298','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1749','','۴Ь','http://www.shoes.hc360.com','2298','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1750','','л','http://www.ne365.com','2298','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1751','','йƷ','http://www.ne360.net','2298','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1752','','','http://a.oadz.com/link/C/773/439/HKwvAP0iFpWS7FXlOfydt0iVgoQ_/a/67?www.vaakav.com','2298','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1753','','й','http://china.bagsnet.com','2298','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1754','','л','http://www.chinabag.com.cn','2298','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1755','','eBags','http://www.ebags.com','2298','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1756','','й','http://bbs.bag.org.cn','2298','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1757','','й','http://www.mofcom.gov.cn/','2296','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1758','','Ͱ','http://china.alibaba.com/','2296','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1759','','й','http://www.customs.gov.cn/','2296','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1760','','й','http://www.customs.gov.cn/','2296','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1761','','۴','http://www.hc360.com/','2296','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1762','','йӿڰ','http://www.chinaport.gov.cn/','2296','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1763','','','http://www.linkshop.com.cn/','2296','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1764','','Ȧ','http://www.bbspace.cn/','2296','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1765','','ҵо','/shangwumaoyi/#658','2296','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1766','','йũҵϢ','http://www.agri.gov.cn','2297','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1767','','йũҵ','http://www.zgny.com.cn/','2297','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1768','','йֳ','http://www.chinabreed.com/','2297','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1769','','ũ','http://www.xinnong.com/','2297','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1770','','','http://www.jinnong.cn/','2297','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1771','','Ҷ','http://www.chaye.com/','2297','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1772','','ũ','http://www.nocn.com.cn/','2297','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1773','','ũ·ũҵ','http://www.funonglu.com/','2297','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1774','','йװ','http://www.efu.com.cn/','2298','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1775','','лװ','http://www.51fashion.com.cn/','2298','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1776','','й','http://www.zgkz.cn/','2298','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1777','','йװʱ','http://www.ef360.com/','2298','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1778','','йЬ','http://www.cnxz.cn/','2298','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1779','','ʱװ','http://fashion.icxo.com/','2298','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1780','','йӼ׼','http://www.cesi.ac.cn','2299','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1781','','йӹҵ','http://www.dianzinet.com','2299','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1782','','е','http://www.chinaecnet.com','2299','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1783','','Դ','http://www.dianyuan.com','2299','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1784','','ǿ','http://www.hqew.com','2299','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1785','','йά','http://www.weixiuwang.com','2299','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1786','','йʦ','http://www.dq.shejis.com','2299','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1787','','йҵ','http://www.cnelc.com','2299','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1788','','лҺ','http://cn.fpdisplay.com','2299','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1789','','й','http://www.gongkong.com','2299','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1790','','','http://www.alighting.cn','2299','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1791','','ѵ','http://www.twicechina.com','2299','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1792','','л繤','http://www.chinaccm.com/38','2299','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1793','','й','http://www.chinanics.com','2299','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1794','','Դ','http://www.oemresource.com','2299','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1795','','ʵ','http://www.ebnchina.com','2299','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1796','','ӷ','http://www.elecfans.com','2299','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1797','','й豸','http://www.fengj.com','2299','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1798','','21ICй','http://www.21ic.com','2299','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1799','','йٻϢ','http://www.jiansuji001.com','2299','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1800','','Ӳѯ','http://www.b2bic.com','2299','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1801','','LED','http://www.ledgb.com','2299','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1802','','豸','http://www.shebei114.cn','2299','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1803','','Ƶ֮','http://www.52video.net','2299','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1804','','ʰ','http://www.isecu.cn','2299','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1805','','йȫ','http://www.safety.com.cn','2299','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1806','','й','http://www.c-ps.net','2299','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1807','','а','http://www.cps.com.cn','2299','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1808','','ȫ','http://www.szsafety.com','2299','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1809','','Ұȫල','http://www.chinasafety.gov.cn','2299','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1810','','йȫҵ','http://www.21csp.com.cn','2299','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1811','','ȫĻ','http://www.anquan.com.cn','2299','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1812','','׼','http://www.lightning.com.cn','2299','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1813','','۴','http://www.fire.hc360.com','2299','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1814','','۴ϰ','http://www.secu.hc360.com','2299','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1815','','л񹲺͹貿','http://www.cin.gov.cn','2299','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1816','','йб','http://www.zhaobiao.gov.cn','2299','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1817','','Ͱ-','http://china.alibaba.com/buy/trade/13.html','2299','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1818','','','http://www.buildbook.com.cn/index.asp','2299','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1819','','й','http://www.landscapecn.com','2299','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1820','','칤','http://www.tgnet.cn','2299','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1821','','йװ','http://www.ccd.com.cn','2299','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1822','','','http://www.zhulong.com','2299','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1823','','йѶ','http://www.chinabei.com','2299','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1824','','йʦ','http://www.china-designer.com','2299','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1825','','Ӣ','http://www.buildhr.com','2299','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1826','','йѵ','http://www.atrain.cn','2299','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1827','','й','http://www.jzlw.net.cn','2299','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1828','','쳽','http://www.buildnet.cn','2299','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1829','','й','http://www.bmlink.com','2299','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1830','','йļ۸','http://www.jc.net.cn','2299','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1831','','۴Ͻ','http://bm.hc360.com','2299','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1832','','йĵһ','http://www.jc001.cn','2299','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1833','','ҽ','http://www.chinabmnet.com/china','2299','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1834','','й','http://www.c-bm.com','2299','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1835','','罨','http://www.wbmbw.com','2299','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1836','','罨','http://www.cnworld.net','2299','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1837','','','http://www.xnjcw.com','2299','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1838','','ɫ','http://www.greenjc.com','2299','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1839','','йϢ','http://www.bm.cei.gov.cn','2299','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1840','','Ž','http://www.jian-cai.com','2299','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1841','','йĽ','http://www.8c8c.com.cn','2299','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1842','','Ļе豸','http://www.it68.net','2299','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1843','','йľ','http://www.chinatimber.org','2299','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1844','','йľҵ','http://www.chinawood.org','2299','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1845','','йľҵԴ','http://www.ewood.cn','2299','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1846','','йľҵ','http://www.wood365.cn','2299','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1847','','ľ','http://www.yuzhuwood.com','2299','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1848','','йʯĵһ','http://www.1stone.com.cn','2299','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1849','','йˮ','http://www.chinacements.com','2299','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1850','','йʯƵ','http://www.shicai.com','2299','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1851','','йʯӦ','http://www.stoneyy.com','2299','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1852','','ˮ','http://www.snsqw.com','2299','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1853','','۴ϵ','http://www.lamp.hc360.com','2299','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1854','','йմ','http://www.taoci365.com','2299','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1855','','йմϢԴ','http://www.ccisn.com.cn','2299','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1856','','۴Ͻմ','http://www.ceramic.hc360.com','2299','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1857','','йմɲɹ','http://www.cerambuy.com','2299','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1858','','»մ-ó','http://www.porcelain-trade.com','2299','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1859','','մ','http://www.chinachina.net','2299','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1860','','ճǱ','http://www.fstcb.com','2299','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1861','','й','http://www.junci2008.com','2299','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1862','','йĿ','http://www.gcxm.com.cn','2299','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1863','','йԤ','http://www.yusuan.com','2299','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1864','','̽','http://www.hnecc.net','2299','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1865','','йй滮оԺ','http://www.caupd.com.cn','2299','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1866','','ˮ','http://www.shuigong.com','2299','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1867','','йнϢ','http://www.csjs.gov.cn','2299','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1868','','л񹲺͹貿','http://www.cin.gov.cn','2300','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1869','','йб','http://www.zhaobiao.gov.cn','2300','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1870','','Ͱ-','http://china.alibaba.com/buy/trade/13.html','2300','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1871','','','http://www.buildbook.com.cn/index.asp','2300','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1872','','й','http://www.landscapecn.com','2300','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1873','','칤','http://www.tgnet.cn','2300','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1874','','йװ','http://www.ccd.com.cn','2300','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1875','','','http://www.zhulong.com','2300','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1876','','йѶ','http://www.chinabei.com','2300','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1877','','йʦ','http://www.china-designer.com','2300','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1878','','Ӣ','http://www.buildhr.com','2300','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1879','','йѵ','http://www.atrain.cn','2300','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1880','','й','http://www.jzlw.net.cn','2300','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1881','','쳽','http://www.buildnet.cn','2300','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1882','','й','http://www.bmlink.com','2300','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1883','','йļ۸','http://www.jc.net.cn','2300','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1884','','۴Ͻ','http://bm.hc360.com','2300','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1885','','йĵһ','http://www.jc001.cn','2300','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1886','','ҽ','http://www.chinabmnet.com/china','2300','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1887','','й','http://www.c-bm.com','2300','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1888','','罨','http://www.wbmbw.com','2300','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1889','','罨','http://www.cnworld.net','2300','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1890','','','http://www.xnjcw.com','2300','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1891','','ɫ','http://www.greenjc.com','2300','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1892','','йϢ','http://www.bm.cei.gov.cn','2300','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1893','','Ž','http://www.jian-cai.com','2300','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1894','','йĽ','http://www.8c8c.com.cn','2300','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1895','','Ļе豸','http://www.it68.net','2300','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1896','','йľ','http://www.chinatimber.org','2300','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1897','','йľҵ','http://www.chinawood.org','2300','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1898','','йľҵԴ','http://www.ewood.cn','2300','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1899','','йľҵ','http://www.wood365.cn','2300','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1900','','ľ','http://www.yuzhuwood.com','2300','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1901','','йʯĵһ','http://www.1stone.com.cn','2300','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1902','','йˮ','http://www.chinacements.com','2300','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1903','','йʯƵ','http://www.shicai.com','2300','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1904','','йʯӦ','http://www.stoneyy.com','2300','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1905','','ˮ','http://www.snsqw.com','2300','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1906','','۴ϵ','http://www.lamp.hc360.com','2300','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1907','','йմ','http://www.taoci365.com','2300','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1908','','йմϢԴ','http://www.ccisn.com.cn','2300','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1909','','۴Ͻմ','http://www.ceramic.hc360.com','2300','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1910','','йմɲɹ','http://www.cerambuy.com','2300','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1911','','»մ-ó','http://www.porcelain-trade.com','2300','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1912','','մ','http://www.chinachina.net','2300','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1913','','ճǱ','http://www.fstcb.com','2300','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1914','','й','http://www.junci2008.com','2300','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1915','','йĿ','http://www.gcxm.com.cn','2300','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1916','','йԤ','http://www.yusuan.com','2300','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1917','','̽','http://www.hnecc.net','2300','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1918','','йй滮оԺ','http://www.caupd.com.cn','2300','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1919','','ˮ','http://www.shuigong.com','2300','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1920','','йнϢ','http://www.csjs.gov.cn','2300','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1921','','۴-ʳƷҵ','http://www.pack.hc360.com','2301','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1922','','йʳƷƼ','http://www.tech-food.com','2301','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1923','','йʳƷҵ','http://www.cfiin.com','2301','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1924','','йʳƷ','http://www.cfqn.com.cn','2301','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1925','','йʳƷչ','http://www.foodexpo.cn','2301','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1926','','йʳƷ','http://www.cn-food.net','2301','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1927','','йɫʳƷ','http://www.greenfood.org.cn','2301','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1928','','һʳƷó','http://www.foods1.com','2301','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1929','','йʳƷƼ','http://www.cifst.org.cn','2301','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1930','','йʳƷϢ','http://www.chinafoods.cn','2301','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1931','','ʳƷ','http://www.foodmate.net','2301','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1932','','ʳƷҩƷܾ','http://www.sda.gov.cn','2301','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1933','','йʳƷƸ','http://www.food36.com','2301','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1934','','йʳƷ','http://www.foodszs.com','2301','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1935','','ʳƷ','http://www.foodol.org','2301','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1936','','йʳƷչ','http://www.foodce.com','2301','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1937','','л','http://www.cngrain.com','2301','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1938','','йʳϢ','http://www.grain.gov.cn','2301','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1939','','й','http://www.fao.com.cn','2301','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1940','','йʳƷϢ','http://www.cof.net.cn','2301','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1941','','йʳ','http://www.cereal.com.cn','2301','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1942','','л','http://www.chinaccm.com/02','2301','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1943','','йϢ','http://www.chinagrain.cn','2301','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1944','','ʳ','http://www.chinagrain.gov.cn','2301','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1945','','йг','http://www.ex-starch.com','2301','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1946','','й','http://www.dadou.cn','2301','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1947','','й','http://www.maize.com.cn','2301','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1948','','йʳϢ','http://www.oilcn.com','2301','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1949','','Ѷ','http://www.oil-114.com','2301','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1950','','г','http://www.grainnews.com.cn','2301','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1951','','','http://www.fzgrain.com','2301','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1952','','','http://www.cndnce.com','2301','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1953','','й̲','http://www.tobaccochina.com','2301','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1954','','̲й','http://www.16888.com.cn','2301','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1955','','̲','http://www.eastobacco.com','2301','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1956','','й̲Ѷ','http://www.echinatobacco.com','2301','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1957','','й̲ݿƽ','http://www.tobaccoinfo.com.cn','2301','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1958','','й̲ݽ','http://www.tobt.com.cn','2301','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1959','','̲ר','http://www.tobacco.gov.cn','2301','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1960','','ǾƿѶ','http://www.tjkx.com','2301','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1961','','йʳ','http://www.gsec.com.cn','2301','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1962','','й','http://www.chinadrinks.net','2301','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1963','','й','http://tea.zjol.com.cn','2301','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1964','','вĻ','http://www.teaw.com','2301','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1965','','й','http://www.alltea.cn','2301','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1966','','в','http://www.teanet.com.cn','2301','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1967','','','http://www.fjteaw.cn','2301','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1968','','й׷²Ҷ','http://www.aa59.com','2301','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1969','','йϹҵ','http://cbi.clii.com.cn','2301','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1970','','йϹҵЭ','http://www.chinabeverage.org','2301','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1971','','йҵϢ','http://www.chinadairy.net','2301','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1972','','о','http://www.chinabgao.com/09/report/drink.asp','2301','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1973','','йҵ','http://www.chinadairyindustry.org.cn','2301','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1974','','йˮ','http://www.cnfruit.com','2301','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1975','','йƷ','http://www.china-fruit.com.cn','2301','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1976','','л','http://www.chinadsh.com','2301','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1977','','йˮӦ','http://www.cn-fruits.cn','2301','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1978','','лˮ','http://www.onfruit.com','2301','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1979','','ˮ','http://www.fruit8.com','2301','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1980','','ƵؼԤ','http://www.ctrip.com/','2311','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1981','','7Ƶ','http://www.7daysinn.cn/marketact/active/com_reg/reg.php?sid=6267&amp;rid=dh_sp&amp;crid=0','2311','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1982','','','http://www.meadin.com','2311','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1983','','e-ƵԤ','http://hotel.elong.com','2311','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1984','','ҾƵ','http://www.homeinns.com','2311','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1985','','Qunarۿ۾Ƶ','http://cdn.deals.qunar.com/ad/activity/Qunar_DM/flights_dj_mkt31.html?flightDM=mkt31Fday1&amp;hotelDM=mkt31Hday1&amp;ticketDM=mkt31Day1','2311','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1986','','۴-Ƶҵ','http://www.hotel.hc360.com','2311','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('1987','','','http://www.aaahaatv.com/','752','','yowao','3','0','0','0','');
INSERT INTO yowao_recycler VALUES('1988','','ɽר','http://www.xiazaiba.com/html/219.html','2268','','yowao','2','0','0','0','');
INSERT INTO yowao_recycler VALUES('1989','','360ȫʿ','http://www.xiazaiba.com/html/91.html','2268','','yowao','5','0','0','0','');
INSERT INTO yowao_recycler VALUES('1990','','ǿȫ','http://www.xiazaiba.com/html/30.html','2268','','yowao','4','0','0','0','');
INSERT INTO yowao_recycler VALUES('1991','','','http://www.xiazaiba.com/html/21.html','2268','','yowao','6','0','0','0','');
INSERT INTO yowao_recycler VALUES('1992','','Ѳ','http://www.xiazaiba.com/html/223.html','2268','','yowao','7','0','0','0','');
INSERT INTO yowao_recycler VALUES('1993','','','http://www.xiazaiba.com/html/26.html','2268','','yowao','8','0','0','0','');
INSERT INTO yowao_recycler VALUES('1994','','΢','http://www.xiazaiba.com/html/46.html','2268','','yowao','9','0','0','0','');
INSERT INTO yowao_recycler VALUES('1995','','U̲רɱ','http://www.xiazaiba.com/html/433.html','2268','','yowao','10','0','0','0','');
INSERT INTO yowao_recycler VALUES('1996','','ɽ','http://www.xiazaiba.com/html/440.html','2268','','yowao','1','0','0','0','');
INSERT INTO yowao_recycler VALUES('1997','','ҳ޸ר','http://www.xiazaiba.com/html/439.html','2268','','yowao','3','0','0','0','');
INSERT INTO yowao_recycler VALUES('1998','','һ','http://1dns.cn/','1147','','yowao','4','0','0','0','');
INSERT INTO yowao_recycler VALUES('1999','','Ⱥ̳','http://www.lunqun.com/','1151','','yowao','6','0','0','0','');
INSERT INTO yowao_recycler VALUES('2000','','洴','http://www.playidea.cn/','2262','','yowao','10','0','0','0','');
INSERT INTO yowao_recycler VALUES('2001','','ɿ','http://www.feedcool.cn','2262','','yowao','16','0','0','0','');
INSERT INTO yowao_recycler VALUES('2002','','','http://www.fabao.com.cn','2262','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('2003','','ҩ','http://click.linktech.cn/?m=jxdyf&a=A100095510&l=00382&l_cd1=0&l_cd2=0&u_id=','2385','','yowao','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('2004','','  ','http://www.tuan27.com/?utm_source=22029','2387','','admin','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('2005','','  ','http://p.yiqifa.com/c?s=efe078d4&amp;w=215569&amp;c=5318&amp;i=13922&amp;l=0&amp;e=kuku8&amp;t=http://55tuan.com/?from=lianmeng-yiqifa','2387','','admin','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('2006','','  ','http://p.yiqifa.com/c?s=50bfe397&amp;w=215569&amp;c=5434&amp;i=16622&amp;l=0&amp;e=kuku8&amp;t=http://www.gaopeng.com/?CID=CN_AFF_138_8_1_1','2387','','admin','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('2007','','  ','http://p.yiqifa.com/c?s=0de0fa7e&amp;w=215569&amp;c=5402&amp;i=11642&amp;l=0&amp;e=kuku8&amp;t=http://bj.meituan.com/','2387','','admin','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('2008','','Ʒ','http://p.yiqifa.com/c?s=cd16675f&amp;w=215569&amp;c=5227&amp;i=10462&amp;l=0&amp;e=kuku8&amp;t=http://www.jumei.com/','2387','','admin','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('2009','','  ','http://p.yiqifa.com/c?s=b77ded11&amp;w=215569&amp;c=5473&amp;i=12262&amp;l=0&amp;e=kuku8&amp;t=http://www.fentuan.com/','2387','','admin','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('2010','','  ','http://www.tuan27.com/?utm_source=22029','2387','','admin','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('2011','','  ','http://p.yiqifa.com/c?s=efe078d4&amp;w=215569&amp;c=5318&amp;i=13922&amp;l=0&amp;e=kuku8&amp;t=http://55tuan.com/?from=lianmeng-yiqifa','2387','','admin','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('2012','','  ','http://p.yiqifa.com/c?s=50bfe397&amp;w=215569&amp;c=5434&amp;i=16622&amp;l=0&amp;e=kuku8&amp;t=http://www.gaopeng.com/?CID=CN_AFF_138_8_1_1','2387','','admin','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('2013','','  ','http://p.yiqifa.com/c?s=0de0fa7e&amp;w=215569&amp;c=5402&amp;i=11642&amp;l=0&amp;e=kuku8&amp;t=http://bj.meituan.com/','2387','','admin','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('2014','','Ʒ','http://p.yiqifa.com/c?s=cd16675f&amp;w=215569&amp;c=5227&amp;i=10462&amp;l=0&amp;e=kuku8&amp;t=http://www.jumei.com/','2387','','admin','100','0','0','0','');
INSERT INTO yowao_recycler VALUES('2015','','  ','http://p.yiqifa.com/c?s=b77ded11&amp;w=215569&amp;c=5473&amp;i=12262&amp;l=0&amp;e=kuku8&amp;t=http://www.fentuan.com/','2387','','admin','100','0','0','0','');

INSERT INTO yowao_search VALUES('14','8','ѹ','http://news.sogou.com/news','query','ѹ','ѹ','static/images/s/sogou.gif','http://news.sogou.com/?pid=sogou-site-cdf1035c34ec3802','sort:\'0\',\r\ntime:\'0\',\r\nw:\'03009900\',\r\n_asf:\'news.sogou.com\',\r\n_ast:\'\',\r\nmode:\'1\'','3','1','0');
INSERT INTO yowao_search VALUES('4','2','ٶ','http://www.baidu.com/s','wd','ٶһ','ٶ','static/images/s/baidu.gif','http://www.114la.com/jingjian.html','','3','1','0');
INSERT INTO yowao_search VALUES('13','2','ȸ','http://www.google.com.hk/search','q','ȸ','ȸ','static/images/s/google.gif','http://www.google.com.hk/webhp?prog=aff&client=pub-0194889602661524&channel=3192690043','client:\\\'pub-0194889602661524\\\',\r\nchannel :\\\'3192690043\\\',\r\nforid :\\\'1\\\',\r\nprog :\\\'aff\\\',\r\nhl :\\\'zh-CN\\\',\r\nsource :\\\"sdo_sb_html\\\",\r\nie:\\\'gb2312\\\'','2','1','0');
INSERT INTO yowao_search VALUES('15','2','115','http://115.com/s','q','115','115','static/images/s/115.gif','http://115.com','ie:\\\"gbk\\\"','1','1','1');
INSERT INTO yowao_search VALUES('16','9','ٶ','http://mp3.baidu.com/m','word',' ','ٶmp3','static/images/s/mp3.gif','http://mp3.baidu.com/m?ie=utf-8&ct=134217728&word=','f: \"ms\",\r\nct: \"134217728\"','1','1','1');
INSERT INTO yowao_search VALUES('17','10','ٶ','http://video.baidu.com/v','word','ٶƵ','ٶƵ','static/images/s/video.gif','http://video.baidu.com/','ct:\'301989888\',\r\nrn:\'20\',\r\npn:\'0\',\r\ndb:\'0\',\r\ns:\'0\',\r\nfbl:\'800\'','2','1','0');
INSERT INTO yowao_search VALUES('18','11','ٶ','http://image.baidu.com/i','word',' ','ٶͼƬ','static/images/s/pic.gif','http://image.baidu.com/','ct: \"201326592\",\r\ncl: \"2\",\r\npv: \"\",\r\nlm: \"-1\"','1','1','1');
INSERT INTO yowao_search VALUES('19','13','ѹ','http://wenda.sogou.com/search','query',' ','ѹ','static/images/s/sogou.gif','http://wenda.sogou.com/?pid=AQDJZ','','2','1','0');
INSERT INTO yowao_search VALUES('20','14','Ա','http://search8.taobao.com/browse/search_auction.htm','q','Ա','Ա','static/images/s/taobao.gif','http://www.taobao.com/go/chn/tbk_channel/onsale.php?pid=mm_16140449_0_0','pid: \"mm_16140449_0_0\",\r\ncommend: \"all\",\r\nsearch_type: \"action\"','1','1','1');
INSERT INTO yowao_search VALUES('36','2','ѹ','http://www.sogou.com/sogou','query','ѹ','ѹ','static/images/s/sogou.gif','http://www.sogou.com/index.php?pid=sogou-site-cdf1035c34ec3802','pid:\'sogou-site-cdf1035c34ec3802\'','5','1','0');
INSERT INTO yowao_search VALUES('21','12','ȸ','http://ditu.google.cn/maps','q',' ','ȸͼ','static/images/s/google.gif','http://ditu.google.cn/','','2','1','0');
INSERT INTO yowao_search VALUES('22','2','SOSO','http://www.soso.com/q','w',' ','SOSO','static/images/s/soso.gif','http://www.soso.com/?unc=s200000_7&cid=union.s.wh','unc: \"s200000_7\",\r\ncid: \"union.s.wh\",\r\nie:\'gb2312\'','5','1','0');
INSERT INTO yowao_search VALUES('23','9','SOSO','http://cgi.music.soso.com/fcgi-bin/m.q','w',' ','mp3','static/images/s/soso.gif','http://music.soso.com/?unc=s200000_7&cid=union.s.wh','unc: \"s200000_7\",\r\ncid: \"union.s.wh\"','3','1','0');
INSERT INTO yowao_search VALUES('24','9','ȸ','http://www.google.cn/music/search','q',' ','ȸ','static/images/s/google.gif','http://www.google.cn/music/homepage','aq: \"f\",\r\nie: \"gb2312\",\r\noe: \"utf8\",\r\nhl: \"zh-CN\"','2','1','0');
INSERT INTO yowao_search VALUES('25','10','ȸ','http://www.google.com.hk/search','q',' ','ȸ','static/images/s/google.gif','http://www.google.com.hk/videohp','tbo: \"p\",\r\ntbs: \"vid:1\",\r\nsource: \"vgc\",\r\nie:\'gb2312\'','3','1','0');
INSERT INTO yowao_search VALUES('26','11','ȸ','http://images.google.com.hk/images','q',' ','ȸ','static/images/s/google.gif','http://images.google.com.hk/imgcat/imghp?hl=zh-CN','gbv: \"2\",\r\nsource: \"hp\",\r\nhl: \"zh-CN\"','2','1','0');
INSERT INTO yowao_search VALUES('27','8','SOSO','http://news.soso.com/n.q','w',' ','','static/images/s/soso.gif','http://news.soso.com/?cid=union.s.wh','cid: \"union.s.wh\",\r\nie:\'gb2312\'','4','1','0');
INSERT INTO yowao_search VALUES('28','10','115','http://v.115.com/','q',' ','115Ӱ','static/images/s/115.gif','http://v.115.com','ie:\\\'gbk\\\'','1','1','1');
INSERT INTO yowao_search VALUES('29','8','ٶ','http://news.baidu.com/ns','word',' ','ٶ','static/images/s/news.gif','http://news.baidu.com/','','1','1','1');
INSERT INTO yowao_search VALUES('30','14','','http://search.360buy.com/Search','keyword','','','static/images/s/360buy.gif','http://www.360buy.com/','','4','1','0');
INSERT INTO yowao_search VALUES('31','13','ٶ','http://zhidao.baidu.com/q','word','ٶһ','ٶһ','static/images/s/zhidao.gif','http://zhidao.baidu.com/q?pt=yowao_ik','tn: \"ikaslist\",\r\nct: \"17\",\r\npt: \"yowao_ik\"','1','1','1');
INSERT INTO yowao_search VALUES('32','12','ٶ','http://map.baidu.com/m','word','ٶһ','ٶȵͼ','static/images/s/baidu.gif','http://map.baidu.com/','','1','1','1');
INSERT INTO yowao_search VALUES('33','8','ȸ','http://news.google.com.hk/news/search','q',' ','ȸ','static/images/s/google.gif','http://news.google.com.hk/','ie:\'gb2312\'','2','1','0');
INSERT INTO yowao_search VALUES('34','14','׿Խ','http://www.amazon.cn/search/search.asp','searchWord',' ','׿Խ','static/images/s/joyo.gif','http://www.amazon.cn/','','3','1','0');
INSERT INTO yowao_search VALUES('35','14','','http://search.dangdang.com/search.aspx','key',' ','','static/images/s/dangdang.gif','http://www.dangdang.com/','','5','1','0');
INSERT INTO yowao_search VALUES('37','11','ѹ','http://pic.sogou.com/pics','query','ѹͼƬ','ѹͼƬ','static/images/s/sogou.gif','http://pic.sogou.com/?pid=sogou-site-b2531e7bb29bf22e','pid:\'sogou-site-b2531e7bb29bf22e\'','3','1','0');
INSERT INTO yowao_search VALUES('38','8','fff','http://www.kukaka.org','fff','fdsfds','fdsfd','fdsfd','fsdfd','','100','1','0');
INSERT INTO yowao_search VALUES('39','8','fafa','http://www.kukaka.org','q','fdsfds','f','f','fsdfd','fsfds','3','0','0');

INSERT INTO yowao_search_keyword VALUES('33','8','ӹȥ','http://www.baidu.com/s?wd=%BD%F0%D3%B9%C8%A5%CA%C0&tn=yowao_4_pg&ch=4','','1','0','0','0','0','0','0','');
INSERT INTO yowao_search_keyword VALUES('13','2','ʱ','http://s8.taobao.com/search?q=%CD%E2%CC%D7&pid=mm_16140449_0_0&commend=all','','2','0','0','0','0','0','0','');
INSERT INTO yowao_search_keyword VALUES('11','2','Աʹڵ','http://pindao.huoban.taobao.com/channel/huangguan.htm?pid=mm_16140449_0_0','','3','0','0','0','0','0','0','');
INSERT INTO yowao_search_keyword VALUES('14','2','ﶬ¿ѥ','http://s8.taobao.com/search?q=%D1%A5%D7%D3&pid=mm_16140449_0_0&commend=all','','1','0','0','0','0','0','0','');
INSERT INTO yowao_search_keyword VALUES('10','2','ش','http://s8.taobao.com/search?q=%C4%D8%B4%F3%D2%C2&pid=mm_16140449_0_0&commend=all','','4','0','0','0','0','0','0','');
INSERT INTO yowao_search_keyword VALUES('15','9','ûи','http://mp3.baidu.com/m?word=%C7%E9%B8%E8%C3%BB%D3%D0%B8%E6%CB%DF%C4%E3+%C1%BA.&tn=yowao_4_pg&ch=4&f=ms&ct=134217728','','1','0','0','0','0','0','0','');
INSERT INTO yowao_search_keyword VALUES('16','9','ǵ','http://mp3.baidu.com/m?word=%BC%C7%B5%C3+%C1%D6%BF%A1%BD%DC&tn=yowao_4_pg&ch=4&f=ms&ct=134217728','','2','0','0','0','0','0','0','');
INSERT INTO yowao_search_keyword VALUES('17','9','Զ','http://mp3.baidu.com/m?word=%D3%C0%D4%B6%B0%AE%B2%BB%CD%EA+%B9%F9%B8%BB%B3%C7&tn=yowao_4_pg&ch=4&f=ms&ct=134217728','','3','0','0','0','0','0','0','');
INSERT INTO yowao_search_keyword VALUES('18','9','','http://mp3.baidu.com/m?word=%B4%BA%CC%EC%C0%EF+%CD%F4%B7%E5&tn=yowao_4_pg&ch=4&f=ms&ct=134217728','','4','0','0','0','0','0','0','');
INSERT INTO yowao_search_keyword VALUES('19','10','ӵ','http://115.com/?q=%E8%AE%A9%E5%AD%90%E5%BC%B9%E9%A3%9E','','1','0','0','0','0','0','0','');
INSERT INTO yowao_search_keyword VALUES('20','10','Ϲ¶','http://115.com/?q=%E8%B5%B5%E6%B0%8F%E5%AD%A4%E5%84%BF','','2','0','0','0','0','0','0','');
INSERT INTO yowao_search_keyword VALUES('21','10','Ц','http://115.com/?q=%E5%A4%A7%E7%AC%91%E6%B1%9F%E6%B9%96','','3','0','0','0','0','0','0','');
INSERT INTO yowao_search_keyword VALUES('22','10','̾2010','http://115.com/?q=%E5%88%91%E8%AD%A62010','','4','0','0','0','0','0','0','');
INSERT INTO yowao_search_keyword VALUES('23','11','justin bie','http://image.baidu.com/i?tn=baiduimage&ct=201326592&cl=2&pv=&lm=-1&word=justin bieber','','1','0','0','0','0','0','0','');
INSERT INTO yowao_search_keyword VALUES('24','11','ܽ','http://image.baidu.com/i?tn=baiduimage&ct=201326592&cl=2&pv=&lm=-1&word=ܽ','','2','0','0','0','0','0','0','');
INSERT INTO yowao_search_keyword VALUES('25','11','','http://image.baidu.com/i?tn=baiduimage&ct=201326592&cl=2&pv=&lm=-1&word=','','3','0','0','0','0','0','0','');
INSERT INTO yowao_search_keyword VALUES('26','11','ܰ','http://image.baidu.com/i?tn=baiduimage&ct=201326592&cl=2&pv=&lm=-1&word=ܰ','','4','0','0','0','0','0','0','');
INSERT INTO yowao_search_keyword VALUES('27','13','ô?','http://zhidao.baidu.com/q?word=%D3%F6%B5%BD%BB%F0%D4%D6%D4%F5%C3%B4%B0%EC&tn=ikaslist&ct=17&pt=yowao_ik','','1','0','0','0','0','0','0','');
INSERT INTO yowao_search_keyword VALUES('28','13','źض','http://zhidao.baidu.com/q?word=%D5%C5%BA%E2%B5%D8%B6%AF%D2%C7%D5%E6%B5%C4%D3%D0%D3%C3%C2%F0&tn=ikaslist&ct=17&pt=yowao_ik','','2','0','0','0','0','0','0','');
INSERT INTO yowao_search_keyword VALUES('29','14','װ','http://pindao.huoban.taobao.com/channel/man.htm?pid=mm_16140449_0_0','','1','0','0','0','0','0','0','');
INSERT INTO yowao_search_keyword VALUES('30','14','ʱŮװ','http://pindao.huoban.taobao.com/channel/lady.htm?pid=mm_16140449_0_0','','2','0','0','0','0','0','0','');
INSERT INTO yowao_search_keyword VALUES('31','14','ݻ','http://pindao.huoban.taobao.com/channel/beauty.htm?pid=mm_16140449_0_0','','3','0','0','0','0','0','0','');
INSERT INTO yowao_search_keyword VALUES('32','14','ƷЬ','http://pindao.huoban.taobao.com/channel/jewelry.htm?pid=mm_16140449_0_0','','4','0','0','0','0','0','0','');
INSERT INTO yowao_search_keyword VALUES('34','8','','http://www.baidu.com/s?wd=%C0%EE%C4%EE%B6%A9%BB%E9&tn=yowao_4_pg&ch=4','','2','0','0','0','0','0','0','');
INSERT INTO yowao_search_keyword VALUES('35','8','ӦƸ','http://www.baidu.com/s?wd=%B7%EF%BD%E3+%D3%A6%C6%B8&tn=yowao_4_pg&ch=4','','3','0','0','0','0','0','0','');
INSERT INTO yowao_search_keyword VALUES('36','8','վ','http://www.baidu.com/s?wd=%C3%C0%C8%D5%BE%FC%D1%DD&tn=yowao_4_pg&ch=4','','4','0','0','0','0','0','0','');
INSERT INTO yowao_search_keyword VALUES('37','11','Ž','http://image.baidu.com/i?tn=baiduimage&ct=201326592&cl=2&pv=&lm=-1&word=Ž','','5','0','0','0','0','0','0','');
INSERT INTO yowao_search_keyword VALUES('38','12','ݸ','http://ditu.google.cn/maps?q=%B6%AB%DD%B8&search_select=engine_21','','1','0','0','0','0','0','0','');
INSERT INTO yowao_search_keyword VALUES('39','12','','http://ditu.google.cn/maps?q=%B1%B1%BE%A9%CA%D0&search_select=engine_21','','2','0','0','0','0','0','0','');
INSERT INTO yowao_search_keyword VALUES('40','12','Ϻ','http://ditu.google.cn/maps?q=%C9%CF%BA%A3%CA%D0&search_select=engine_21','','3','0','0','0','0','0','0','');
INSERT INTO yowao_search_keyword VALUES('41','12','','http://ditu.google.cn/maps?q=%B9%E3%D6%DD%CA%D0&search_select=engine_21','','4','0','0','0','0','0','0','');

INSERT INTO yowao_searchclass VALUES('2','ҳ','2','1');
INSERT INTO yowao_searchclass VALUES('8','','1','0');
INSERT INTO yowao_searchclass VALUES('9','MP3','3','0');
INSERT INTO yowao_searchclass VALUES('10','Ƶ','4','0');
INSERT INTO yowao_searchclass VALUES('11','ͼƬ','5','0');
INSERT INTO yowao_searchclass VALUES('12','ͼ','6','0');
INSERT INTO yowao_searchclass VALUES('13','ʴ','7','0');
INSERT INTO yowao_searchclass VALUES('14','','8','0');

INSERT INTO yowao_site VALUES('44221','й','http://www.chem17.com','2306','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44222','еóг','http://www.chemjx.cn','2306','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44223','ҵĸ','http://www.mysteel.com','2307','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44224','йϸ','http://www.custeel.com','2307','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44225','й','http://www.chinasteel.com.cn','2307','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44226','й','http://www.bxg86.com','2307','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44227','֮','http://www.steelhome.cn','2307','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44228','й','http://www.yesteel.com','2307','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44229','йֲ¯Ϣ','http://www.gangtie114.com','2307','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44230','йֲó','http://www.gcmyw.com','2307','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44231','ֲĴ','http://www.gcdcs.com','2307','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44232','йұϢ','http://www.metalinfo.com.cn','2307','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44233','йұ𾭼Ϣ','http://www.chinaesteel.com.cn','2307','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44234','ұ۸Ϣ','http://www.metalprice.net','2307','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44235','ɫԴ','http://www.cnncmrc.com','2307','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44236','ұó','http://www.mc-ccpit.com','2307','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44237','йʿҵ','http://www.china-mining.org','2307','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44238','ұг','http://china.alibaba.com/buy/trade/9.html','2307','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44239','йǽϢ','http://www.chinanmm.com','2307','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44240','лĩұ','http://www.fenmoyejin.com','2307','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44241','ұٽ','http://www.mippc.net.cn','2307','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44242','','http://www.dfjinshu.com','2307','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44243','ȫ','http://www.ometal.com','2307','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44244','й','http://www.ldmetals.com','2307','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44245','ұ۸Ϣ','http://www.metalprice.net','2307','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44246','й','http://www.coke-iron.com','2307','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44247','Ϣ','http://www.world-metal.com','2307','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44248','Ҫ','http://www.51bxg.com','2307','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44249','.й','http://www.bxg.cn','2307','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44250','йϽ','http://www.cn-fe.com','2307','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44251','йұ𾭼Ϣ','http://www.chinaesteel.com.cn','2307','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44252','йɫ','http://www.cnmn.com.cn','2307','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44253','йɫӹ','http://www.ysjg.cn','2307','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44254','ɫоԺ','http://www.c-nin.com','2307','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44255','йҵ','http://www.mn-cn.com','2307','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44256','йþҵ','http://www.chinamagnesium.org/index.php','2307','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44257','йϽ','http://www.cn-fe.com','2307','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44258','й','http://www.chinascrap.com','2307','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44259','йͲ','http://www.capm.net','2307','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44260','Ϣ','http://www.alum-info.com','2307','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44261','й','http://www.foundry.com.cn','2307','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44262','й','http://cn.made-in-china.com','2307','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44263','','http://www.3mb.cn','2307','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44264','ȫ','http://www.zhuzaowang.org.cn','2307','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44265','й','http://www.btzzw.com','2307','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44266','л','http://www.zz17.com','2307','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44267','й','http://www.cnpcnet.cn','2307','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44268','еѧ','http://www.foundrynations.com','2307','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44269','־','http://www.foundryworld.com','2307','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44270','й׸ּ','http://www.shougang.com.cn','2307','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44271','ּ','http://www.baosteel.com','2307','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44272','ɽ','http://www.magang.com.cn','2307','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44273','ɽ','http://www.ansteel.com.cn','2307','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44274','ʸּ','http://www.pzhsteel.com.cn','2307','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44275','йվ','http://www.chinaadren.com','2308','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44276','йý','http://www.ad163.com','2308','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44277','лý','http://www.mediachina.net','2308','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44278','й','http://www.cnad.com','2308','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44279','л','http://www.a.com.cn','2308','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44280','ֻý','http://www.wowa.cn','2308','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44281','ҵͶ','http://www.28.com','2308','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44282','йŻ','http://www.yxad.com','2308','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44283','ýƵ','http://media.people.com.cn/GB/index.html','2308','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44284','ӡˢó','http://www.adp365.com','2308','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44285','ýԴ','http://www.allchina.cn','2308','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44286','һӪ','http://www.cmmo.com.cn','2308','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44287','йӪ','http://www.emkt.com.cn','2308','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44288','Ӫֲ','http://www.tomx.com','2308','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44289','¾','http://www.jingzhengli.cn','2308','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44290','Ӫ¹۲','http://www.marketingman.net','2308','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44291','ͰҵѶ','http://info.china.alibaba.com/news/community/c14.html','2308','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44292','','http://www.mie168.com','2308','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44293','г','http://www.shichangbu.com','2308','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44294','Ƹ','http://www.eastmoney.com','2309','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44295','˲ƾ','http://finance.sina.com.cn','2309','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44296','Ѻƾ','http://business.sohu.com','2309','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44297','й','http://www.ce.cn','2309','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44298','֤ȯ֮','http://www.stockstar.com','2309','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44299','н','http://www.cnfol.com','2309','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44300','йƾϢ','http://www.cfi.cn','2309','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44301','ٶȲƾ','http://finance.baidu.com','2309','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44302','ײƾ','http://money.163.com','2309','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44303','˲ƾ','http://finance.ifeng.com','2309','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44304','»ƾ','http://www.xinhuanet.com/fortune/index.htm','2309','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44305','ڽ','http://www.jrj.com.cn/default.htm','2309','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44306','Ѷƾ','http://finance.qq.com','2309','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44307','21CNƾ','http://finance.21cn.com','2309','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44308','ƾ','http://www.caijing.com.cn','2309','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44309','Ѷƾ','http://www.hexun.com','2309','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44310','йƾ','http://www.fec.com.cn','2309','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44311','','http://www.gutx.com','2309','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44312','FT','http://www.ftchinese.com/users/goto?ccode=2G091070&amp;pageurl=http%3A%2F%2Fwww.ftchinese.com%2F','2309','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44313','ڽ-','http://invest.jrj.com.cn/invest','2309','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44314','Ƹ-','http://quote.eastmoney.com','2309','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44315','Ѷ-ƾ','http://finance.qq.com/tianxiaping/index.htm','2309','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44316','-','http://biz.finance.sina.com.cn/hq','2309','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44317','Ѷ','http://opinion.hexun.com','2309','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44318','ȫ-','http://www.p5w.net/stock/hydx','2309','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44319','֤ȯ֮-','http://quote.stockstar.com/stock','2309','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44320','ɰ','http://guba.eastmoney.com','2309','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44321','Ʊ̳','http://bbs.gupiao8.com','2309','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44322','ڽƱ̳','http://bbs.jrj.com.cn','2309','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44323','ǮׯƱ̳','http://www.laoqianzhuang.com','2309','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44324','Ѻ̳','http://business.sohu.com/upload/clubnew.htm','2309','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44325','MACDм̳','http://bbs.macd.cn','2309','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44326','òƾ̳','http://www.chcj.net/bbs.php','2309','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44327','ݹƱ̳','http://www.Gupiao-bbs.com','2309','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44328','ڰ̳','http://bbs.jinrong8.com','2309','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44329','˲ƾ̳','http://finance.sina.com.cn/bbs/index.shtml','2309','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44330','н𲩿','http://blog.cnfol.com','2309','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44331','ѶƱ','http://blog.hexun.com/class20.htm','2309','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44332','й֤ȯ','http://blog.cnstock.com','2309','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44333','˲ƾ','http://blog.sina.com.cn/lm/finance/index.html','2309','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44334','Ƹƾ','http://blog.eastmoney.com','2309','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44335','Ѻƾ','http://blog.sohu.com/business','2309','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44336','Ͷ̳','http://bbs.dingdi.com','2309','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44337','ղƾ̳','http://www.caijing.name','2309','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44338','й','http://www.chinatelecom.com.cn','2310','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44339','йƶ','http://www.chinamobile.com','2310','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44340','йͨ','http://www.chinaunicom.com','2310','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44341','йͨ','http://www.chinatietong.com','2310','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44342','ͨ','http://comm.ccidnet.com','2310','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44343','ͨŲҵ','http://www.ccidcom.com','2310','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44344','-ͨ','http://telecom.chinabyte.com','2310','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44345','йͨ','http://www.c114.net','2310','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44346','йͨ','http://www.cnii.com.cn','2310','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44347','йϢҵ','http://www.cnii.com.cn','2310','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44348','ͨѶ','http://tech.sina.com.cn/tech','2310','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44349','ƶͨ','http://www.mscbsc.com','2310','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44350','CCTIME','http://www.cctime.com','2310','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44351','̩-ͨҵ','http://www.catr.cn','2310','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44352','','http://www.bjtelecom.net','2310','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44353','','http://tj.ct10000.com','2310','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44354','Ϻ','http://sh.ct10000.com','2310','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44355','ӱ','http://www.hbtele.com','2310','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44356','','http://www.fjtelecom.com','2310','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44357','','http://www.hbtelecom.com.cn','2310','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44358','ϵ','http://hi.ct10000.com','2310','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44359','ϵ','http://yn.ct10000.com','2310','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44360','ɽ','http://www.shanxitele.com','2310','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44361','','http://www.hljtele.com','2310','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44362','յ','http://www.telecomjs.com','2310','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44363','','http://jx.ct10000.com','2310','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44364','ϵ','http://hn.ct10000.com','2310','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44365','յ','http://www.telecomjs.com','2310','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44366','㽭','http://zj.ct10000.com','2310','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44367','ɽ','http://www.sdtele.com','2310','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44368','㶫','http://gd.ct10000.com','2310','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44369','Ĵ','http://www.sctel.com.cn','2310','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44370','','http://www.xaonline.com','2310','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44371','','http://www.cqtelecom.com.cn','2310','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44372','','http://www.lntele.com','2310','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44373','յ','http://www.ahtelecom.com.cn','2310','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44374','ϵ','http://ha.ct10000.com','2310','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44375','','http://gx.ct10000.com','2310','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44376','ݵ','http://www.gzdx.com.cn','2310','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44377','ຣ','http://www.qhtelecom.com.cn','2310','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44378','½','http://www.xjtelecom.com.cn','2310','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44379','ɹŵ','http://nm.ct10000.com','2310','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44380','ƶ','http://www.bjmcc.net','2310','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44381','ƶ','http://www.tj.chinamobile.com','2310','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44382','Ϻƶ','http://www.sh.chinamobile.com','2310','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44383','ƶ','http://www.xz.chinamobile.com','2310','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44384','ƶ','http://www.hl.chinamobile.com','2310','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44385','ƶ','http://www.ln.chinamobile.com','2310','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44386','ӱƶ','http://www.he.chinamobile.com','2310','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44387','ɽƶ','http://www.sd.chinamobile.com','2310','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44388','ɽƶ','http://www.sx.chinamobile.com','2310','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44389','ƶ','http://www.js.chinamobile.com','2310','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44390','ƶ','http://www.ha.chinamobile.com','2310','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44391','ƶ','http://www.ah.chinamobile.com','2310','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44392','㽭ƶ','http://www.zj.chinamobile.com','2310','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44393','ƶ','http://www.ha.chinamobile.com','2310','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44394','ƶ','http://www.nx.chinamobile.com','2310','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44395','ƶ','http://www.sn.chinamobile.com','2310','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44396','ƶ','http://www.hb.chinamobile.com/index.jsp?tump=0','2310','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44397','ƶ','http://www.jx.chinamobile.com','2310','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44398','ƶ','http://www.fj.chinamobile.com','2310','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44399','ƶ','http://www.nx.chinamobile.com','2310','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44400','ƶ','http://www.gs.chinamobile.com','2310','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44401','Ĵƶ','http://www.sc.chinamobile.com','2310','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44402','ƶ','http://www.cq.chinamobile.com','2310','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44403','ƶ','http://www.hn.chinamobile.com','2310','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44404','㶫ƶ','http://www.gd.chinamobile.com','2310','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44405','ƶ','http://www.chinamobileltd.com','2310','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44406','ƶ','http://www.cq.chinamobile.com','2310','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44407','ƶ','http://www.gx.chinamobile.com/www','2310','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44408','ƶ','http://www.yn.chinamobile.com','2310','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44409','ƶ','http://www.hi.chinamobile.com','2310','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44410','ɹƶ','http://www.nm.chinamobile.com','2310','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44411','ຣƶ','http://www.qh.chinamobile.com','2310','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44412','ͨ','http://www.bj.chinaunicom.com','2310','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44413','Ϻͨ','http://www.sh.chinaunicom.com','2310','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44414','ӱͨ','http://www.he.chinaunicom.com','2310','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44415','ͨ','http://www.jl165.com','2310','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44416','ͨ','http://info2.10010.com/lt/plugin/portal/arealevel/queryCityInfo.do?arno=00010024&amp;id=1349','2310','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44417','ͨ','http://www.hi165.com','2310','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44418','ͨ','http://info.10010.com/lt/plugin/portal/arealevel/queryCityInfo.do?arno=00010026&amp;id=4154','2310','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44419','ɽͨ','http://www.sx.chinaunicom.com','2310','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44420','ͨ','http://www.hl.chinaunicom.com','2310','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44421','ͨ','http://www.js.chinaunicom.com','2310','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44422','ͨ','http://www.jx.chinaunicom.com','2310','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44423','ͨ','http://www.hn.chinaunicom.com','2310','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44424','ͨ','http://www.js.chinaunicom.com','2310','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44425','㽭ͨ','http://www.zj.chinaunicom.com','2310','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44426','ɽͨ','http://info.10010.com/lt/plugin/portal/arealevel/queryCityInfo.do?arno=00010016&amp;id=2651','2310','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44427','㶫ͨ','http://info2.10010.com/lt/plugin/portal/arealevel/queryCityInfo.do?arno=00010004&amp;id=1677','2310','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44428','Ĵͨ','http://info2.10010.com/lt/plugin/portal/arealevel/queryCityInfo.do?arno=00010009&amp;id=3368','2310','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44429','ͨ','http://info2.10010.com/lt/plugin/portal/arealevel/queryCityInfo.do?arno=00010015&amp;id=2533','2310','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44430','ͨ','http://www.on165.com/index.aspx','2310','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44431','ͨ','http://www.ln.cnc.cn','2310','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44432','ͨ','http://www.ah.chinaunicom.com','2310','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44433','ͨ','http://www.ha.chinaunicom.com','2310','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44434','ͨ','http://info.10010.com/lt/plugin/portal/arealevel/queryCityInfo.do?arno=00010014&amp;id=2409','2310','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44435','ຣͨ','http://www.qh.chinaunicom.com','2310','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44436','ɹͨ','http://www.nm.chinaunicom.com','2310','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44437','ͨ','http://www.cttbj.com','2310','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44438','ͨ','http://www.ctttj.com','2310','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44439','Ϻͨ','http://www.cttsh.com','2310','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44440','ͨ','http://www.ctthlj.com','2310','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44441','ͨ','http://www.cttnx.com','2310','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44442','ͨ','http://www.cttjl.com','2310','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44443','ӱͨ','http://www.ctthe.com','2310','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44444','ͨ','http://www.cttsn.com','2310','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44445','ɽͨ','http://www.cttsx.com','2310','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44446','ͨ','http://www.ctthb.com','2310','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44447','ͨ','http://www.cttha.com','2310','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44448','ɽͨ','http://www.cttsd.com','2310','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44449','㽭ͨ','http://www.cttzj.com','2310','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44450','ͨ','http://www.cttah.com','2310','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44451','ͨ','http://www.cttjs.com','2310','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44452','ͨ','http://www.cttcq.com','2310','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44453','Ĵͨ','http://www.cttsc.com','2310','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44454','ͨ','http://www.cttyn.com','2310','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44455','ͨ','http://www.cttfj.com','2310','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44456','ͨ','http://www.cttjx.com','2310','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44457','㶫ͨ','http://www.cttgd.com','2310','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44458','ͨ','http://www.ctthn.com','2310','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44459','ͨ','http://kf.cttgx.com/index.asp','2310','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44460','ͨ','http://www.cttgs.com','2310','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44461','ͨ','http://www.ctthi.com','2310','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44462','ຣͨ','http://www.cttqh.com','2310','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44463','ɹͨ','http://www.cttnm.com','2310','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('47150','ѺƵ','http://travel.sohu.com/','2311','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('47151','POCO','http://travel.poco.cn/','2311','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('47149','','http://www.go2eu.com/','2311','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('47148','йͨ','http://www.51766.com/','2311','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('47147','ͬ','http://www.17u.com/','2311','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('47144','Я','http://www.ctrip.com/','2311','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('47145','â','http://www.mangocity.com/','2311','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('47146','','http://www.elong.com/','2311','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('47143','й','http://www.cncn.com','2311','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44471','ѷ','http://www.soufun.com','2312','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44472','㷿ز','http://house.focus.cn','2312','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44473','˷','http://house.sina.com.cn','2312','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44474','Ѻ','http://house.sohu.com','2312','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44475','ڱ','http://fang.koubei.com','2312','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44476','»Ƶ','http://www.xinhuanet.com/house','2312','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44477','Żز','http://cn.realestate.yahoo.com','2312','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44478','ϼַⷿ','http://bj.ganji.com/?ad-index=1','2312','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44479','Ѷ','http://house.hexun.com','2312','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44480','Ѷ','http://fang.kuxun.cn','2312','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44481','ϴ','http://www.foloda.com','2312','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44482','ȫ','http://www.allfang.com','2312','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44483','лز','http://re.icxo.com','2312','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44484','׾','http://www.eeju.com','2312','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44485','','http://house.people.com.cn','2312','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44486','21CN','http://house.21cn.com','2312','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44487','','http://www.ihouseking.com','2312','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44488','','http://www.wolai.com','2312','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44489','','http://www.fundon.cn','2312','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44490','ҺƵ','http://www.homhow.com','2312','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44491','','http://www.yaoee.com','2312','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44492','','http://www.fccs.com','2312','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44493',';','http://www.fangtoo.com','2312','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44494','-¥','http://shanghai.aifang.com/','2312','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44495','װͼ','http://www.tumanduo.com','2312','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44496','ѷװ޼Ҿ','http://home.soufun.com','2312','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44497','װ޼Ҿ','http://home.focus.cn','2312','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44498','ͼ','http://www.51hejia.com','2312','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44499','װ޼Ҿ','http://house.sina.com.cn/decor','2312','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44500','üҼҾ','http://www.e-jjj.com','2312','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44501','ҰҼ','http://www.525j.com.cn','2312','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44502','йܼҾ','http://www.smarthomecn.com','2312','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44503','й','http://www.ciid.com.cn','2312','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44504','йذϢ','http://www.flooring.org.cn','2312','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44505','йװ','http://www.cool-de.com','2312','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44506','Ҿ','http://sunbala.cn/ehome','2312','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44507','Ҽ','http://www.5s5j.com','2312','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44508','װ','http://www.roomage.com','2312','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44509','װ','http://www.zsuan.com','2312','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44510','ϲüҾ','http://www.joyju.com','2312','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44511','װʴ','http://www.zxask.cn','2312','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44512','۴ƷƷ','http://www.gift.hc360.com','2313','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44513','Ʒ','http://www.xylp.com.cn','2313','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44514','Ʒ','http://www.wg365.com/lipin.htm','2313','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44515','йƷ','http://www.18a8.com','2313','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44516','','http://www.gift12345.com','2313','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44517','йƷɹ','http://www.china-gift.cc','2313','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44518','йƷ֮','http://www.lpc8.com','2313','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44519','˰۰ݰٻ̳','http://www.800buy.com.cn','2313','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44520','йƷ','http://www.enwise.net','2313','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44521','Ʒ','http://www.sinogift.com.cn','2313','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44522','йʻٵ','http://www.cnefs.com','2313','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44523','йʻƷ','http://www.flowercn.com','2313','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44524','ɯʻ','http://www.salala.com.cn','2313','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44525','߲ʻ','http://www.7caihua.com','2313','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44526','ٻʻ','http://www.baihua999.com','2313','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44527','۴','http://www.toys.hc360.com','2313','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44528','й','http://www.wanju.cn','2313','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44529','߰Ͱ','http://www.toybaba.com','2313','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44530','л','http://www.chinatoynet.com','2313','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44531','Ͱ߹','http://search.china.alibaba.com/offer/%E7%8E%A9%E5%85%B7%E7%BD%91.html','2313','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44532','й߽','http://www.toystrade.cn','2313','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44533','й߹Ϣ','http://www.toys-gd.com','2313','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44534','','http://www.world-toy.com','2313','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44535','й','http://www.cgy.cn','2313','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44536','л','http://www.jades.cn','2313','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44537','йƷϢ','http://www.craftschina.net','2313','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44538','۴-ƷƷ','http://www.gift.hc360.com','2313','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44539','ȫƷ','http://www.52sp.com','2313','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44540','йƷ','http://www.sp.jmw.com.cn','2313','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44541','廨','http://www.linkgd.com','2313','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44542','21鱦','http://www.21gem.net','2313','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44543','Ʒ','http://www.1925.cn','2313','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44544','','http://www.zsgy.com','2313','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44545','йӱ','http://www.chinawatchnet.com','2313','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44546','й۾','http://www.glasses.com.cn','2313','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44547','йٷ','http://www.51wig.com','2313','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44548','йˮ','http://www.chinashuijing.com','2313','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44549','й','http://www.feicui001.com','2313','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44550','йɡ','http://www.3to3.com','2313','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44551','ֽ','http://www.zhidiy.com','2313','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44552','йװ','http://www.pack.net.cn','2314','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44553','лӡˢװ','http://www.cpp114.com','2314','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44554','йֽҵ','http://www.chinapaper.net','2314','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44555','йֽ','http://www.paper.com.cn','2314','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44556','۴ֽҵ','http://www.paper.hc360.com','2314','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44557','йװ','http://www.chndesign.com','2314','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44558','йװ','http://www.cpackage.com','2314','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44559','ӡˢװ','http://www.adprint.com.cn','2314','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44560','ӡװ','http://www.a1pak.com','2314','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44561','йͼ','http://www.bkpcn.com','2314','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44562','йӡˢŻ','http://www.bisenet.com','2314','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44563','й','http://www.chuban.cc','2314','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44564','йų','http://www.chinaxwcb.com/index/index.htm','2314','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44565','й','http://www.china-pub.com','2314','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44566','۴ӡˢ','http://www.printing.hc360.com','2314','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44567','»','http://click.linktech.cn/?m=xhbooks&a=A100095510&l=99999&l_cd1=0&l_cd2=1&tu=http%3A%2F%2Fwww.xinhuabookstore.com%2F','2314','100','0','0','0','0','0','0','0','#008000','yowao','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44568','ͼ齻','http://www.bookb2b.com','2314','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44569','Էѳ','http://www.chushu168.com','2314','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44570','ӡ','http://www.ccedpw.com','2314','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44571','л֯','http://www.cntexnet.com','2315','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44572','й֯','http://www.texnet.com.cn','2315','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44573','ѯ','http://www.ccf.com.cn','2315','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44574','й֯','http://www.eck.com.cn','2315','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44575','й˾Ϣ','http://www.ccfei.com','2315','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44576','й֯Ϣ','http://cn.cntextile.com','2315','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44577','з֯Ʒ̻','http://www.ccct.org.cn','2315','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44578','йҷϢ','http://www.hometextiles.cn','2315','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44579','й֯ѧоԺ','http://www.cta.com.cn','2315','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44580','йɴ','http://www.zgsxw.com','2315','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44581','лҷ','http://www.hometex114.com','2315','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44582','ĳ','http://www.qfc.cn','2315','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44583','йҷ','http://www.hometexnet.com','2315','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44584','ȫ֯','http://www.tnc.com.cn','2315','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44585','֯','http://textile.icxo.com','2315','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44586','ŷ֯','http://www.sinotex.net','2315','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44587','۴Ϸ֯','http://www.textile.hc360.com','2315','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44588','й޻','http://www.cncotton.com','2315','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44589','й޻Ϣ','http://www.cottonchina.org','2315','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44590','й޻ҵ','http://www.cncew.com','2315','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44591','й޷֯Ϣ','http://www.tteb.com','2315','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44592','й޻','http://www.socotton.com','2315','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44593','й޻Э','http://www.china-cotton.org','2315','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44594','й','http://www.silkcapital.com','2315','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44595','й˿г','http://www.esilk.net','2315','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44596','й˿','http://www.china-4.com','2315','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44597','й˿Ϣ','http://www.cnsilk.cn','2315','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44598','й֯','http://www.texnet.com.cn','2315','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44599','й˿Ϣ','http://www.silk-e.org','2315','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44600','˿Źɷ','http://www.shsilktech.com','2315','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44601','۴˿ӡӡ','http://www.screen.hc360.com','2315','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44602','й˿ڹ˾','http://www.chinasilk.com','2315','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44603','й˿','http://www.chinasilkmuseum.com','2315','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44604','й廨','http://www.emb163.com','2315','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44605','廨','http://www.linkgd.com','2315','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44606','ƴ','http://www.linkemb.com','2315','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44607','йƤ','http://www.piju.com.cn','2315','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44608','۴Ƥ','http://www.leather.hc360.com','2315','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44609','йƤ﹤ҵ','http://leather.clii.com.cn','2315','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44610','Ƥ','http://www.world-leather.net','2315','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44611','йƤｻ','http://www.sinoleather.com','2315','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44612','йƤѶ','http://www.china-leather.com','2315','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44613','йϳƤ','http://www.synthleather.com','2315','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44614','лװ-Ƥװ','http://www.51fashion.com.cn/51AreaLeather','2315','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44615','йӡȾ','http://www.china-dyeing.com','2315','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44616','йӡȾѶ','http://www.sinodf.com','2315','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44617','йӡȾҵЭ','http://www.cdpa.org.cn','2315','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44618','ӡȾ','http://www.cndye.net','2315','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44619','йӡȾ','http://www.chinayinran.com','2315','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44620','йӡȾ','http://www.cnyrw.com','2315','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44621','йӡȾѧƷ','http://www.printingadd.com','2315','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44622','лӡȾ','http://www.yrzx.net','2315','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44623','й֯е','http://www.cttm.net','2315','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44624','й֯ег','http://www.ctmm.net','2315','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44625','йĻ','http://www.chinatex.info','2315','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44626','йĻ','http://www.ttmn.com','2315','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44627','лĻ','http://www.ctma.net','2315','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44628','л֯','http://www.cntexnet.com','2315','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44629','й֯','http://www.texnet.com.cn','2315','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44630','ѯ','http://www.ccf.com.cn','2315','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44631','й֯','http://www.eck.com.cn','2315','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44632','й˾Ϣ','http://www.ccfei.com','2315','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44633','й֯Ϣ','http://cn.cntextile.com','2315','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44634','з֯Ʒ̻','http://www.ccct.org.cn','2315','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44635','йҷϢ','http://www.hometextiles.cn','2315','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44636','й֯ѧоԺ','http://www.cta.com.cn','2315','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44637','йɴ','http://www.zgsxw.com','2315','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44638','лҷ','http://www.hometex114.com','2315','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44639','ĳ','http://www.qfc.cn','2315','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44640','йҷ','http://www.hometexnet.com','2315','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44641','ȫ֯','http://www.tnc.com.cn','2315','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44642','֯','http://textile.icxo.com','2315','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44643','ŷ֯','http://www.sinotex.net','2315','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44644','۴Ϸ֯','http://www.textile.hc360.com','2315','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44645','й޻','http://www.cncotton.com','2315','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44646','й޻Ϣ','http://www.cottonchina.org','2315','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44647','й޻ҵ','http://www.cncew.com','2315','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44648','й޷֯Ϣ','http://www.tteb.com','2315','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44649','й޻','http://www.socotton.com','2315','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44650','й޻Э','http://www.china-cotton.org','2315','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44651','й','http://www.silkcapital.com','2315','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44652','й˿г','http://www.esilk.net','2315','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44653','й˿','http://www.china-4.com','2315','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44654','й˿Ϣ','http://www.cnsilk.cn','2315','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44655','й֯','http://www.texnet.com.cn','2315','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44656','й˿Ϣ','http://www.silk-e.org','2315','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44657','˿Źɷ','http://www.shsilktech.com','2315','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44658','۴˿ӡӡ','http://www.screen.hc360.com','2315','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44659','й˿ڹ˾','http://www.chinasilk.com','2315','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44660','й˿','http://www.chinasilkmuseum.com','2315','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44661','й廨','http://www.emb163.com','2315','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44662','廨','http://www.linkgd.com','2315','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44663','ƴ','http://www.linkemb.com','2315','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44664','йƤ','http://www.piju.com.cn','2315','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44665','۴Ƥ','http://www.leather.hc360.com','2315','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44666','йƤ﹤ҵ','http://leather.clii.com.cn','2315','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44667','Ƥ','http://www.world-leather.net','2315','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44668','йƤｻ','http://www.sinoleather.com','2315','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44669','йƤѶ','http://www.china-leather.com','2315','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44670','йϳƤ','http://www.synthleather.com','2315','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44671','лװ-Ƥװ','http://www.51fashion.com.cn/51AreaLeather','2315','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44672','йӡȾ','http://www.china-dyeing.com','2315','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44673','йӡȾѶ','http://www.sinodf.com','2315','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44674','йӡȾҵЭ','http://www.cdpa.org.cn','2315','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44675','ӡȾ','http://www.cndye.net','2315','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44676','йӡȾ','http://www.chinayinran.com','2315','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44677','йӡȾ','http://www.cnyrw.com','2315','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44678','йӡȾѧƷ','http://www.printingadd.com','2315','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44679','лӡȾ','http://www.yrzx.net','2315','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44680','й֯е','http://www.cttm.net','2315','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44681','й֯ег','http://www.ctmm.net','2315','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44682','йĻ','http://www.chinatex.info','2315','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44683','йĻ','http://www.ttmn.com','2315','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44684','лĻ','http://www.ctma.net','2315','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44685','л񹲺͹','http://www.moh.gov.cn','2316','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44686','йҽҩ','http://www.pharmnet.com.cn','2316','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44687','йҽеҵЭ','http://www.camdi.org','2316','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44688','ҽ豸չ','http://www.chinamed.net.cn','2316','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44689','ҽеϢ','http://www.mednet.cn','2316','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44690','йҽеϢ','http://www.cmdi.gov.cn','2316','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44691','ҩ','http://www.satcm.gov.cn','2316','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44692','ʳƷҩƷල','http://www.sda.gov.cn','2316','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44693','йҩҵ123','http://www.chinayaoye123.com','2316','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44694','ҩƷֱί','http://www.zybh.gov.cn','2316','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44695','ҩ','http://hlyyao.com.cn','2316','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44696','۴ϣҩҵ','http://www.pharmacy.hc360.com','2316','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44697','ҽҩ','http://www.cnm21.com','2316','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44929','Ŵѧ','http://www.cup.cam.ac.uk','2320','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44928','ֶ湫˾','http://www.gowerpub.com','2320','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44927','湫˾','http://www.mcp.com','2320','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44705','̫ƽ','http://www.pcauto.com.cn/?ad=575','2317','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44926','ܳ','http://www.jdcbs.com.cn','2320','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44707','','http://www.xcar.com.cn','2317','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44925','','http://www.daxiang.cn','2320','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44709','','http://auto.sina.com.cn','2317','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44924','ʵ','http://www.ptpress.com.cn','2320','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44711','й','http://www.chinacars.com','2317','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44923','ɳ','http://www.lawpress.com.cn','2320','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44713','֮','http://www.autohome.com.cn','2317','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44922','ߵȽ','http://www.hep.edu.cn','2320','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44715','ϳ','http://www.cheshi.com.cn','2317','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44921','ѧо','http://www.fltrp.com','2320','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44717','Ѻ','http://auto.sohu.com','2317','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44920','ĳ','http://www.flp.com.cn','2320','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44719','Ż','http://cn.autos.yahoo.com','2317','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44919','ѧ','http://www.fudanpress.com','2320','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44721','Ѷ','http://auto.qq.com','2317','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44918','廪ѧ','http://www.tup.tsinghua.edu.cn','2320','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44723','TOM','http://auto.tom.com','2317','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44917','ѧ','http://www.sciencep.com','2320','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44725','','http://auto.163.com','2317','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44916','ҳ','http://www.zuojiachubanshe.com','2320','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44727','лƵ','http://auto.china.com/zh_cn','2317','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44915','Ϻĳ','http://www.stph.com.cn','2320','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44729','','http://www.chelink.com','2317','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44914','ֳ','http://www.yilin.com','2320','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44731','','http://www.chetx.com','2317','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44913','ӡ','http://www.cp.com.cn','2320','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44733','׳','http://www.bitauto.com','2317','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44912','','http://www.pep.com.cn','2320','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44735','','http://auto.huanqiu.com','2317','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44911','۴ˮҵ','http://www.water.hc360.com','2319','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44737','','http://www.cars.com.cn','2317','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44910','ˮϢ','http://www.hwcc.com.cn','2319','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44739','21CNƵ','http://auto.21cn.com','2317','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44909','йˮѧ','http://www.ches.org.cn','2319','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44741','','http://www.webcars.com.cn','2317','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44863','Դ','http://www.asia-hardware.com','2318','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44743','CHE168','http://www.che168.com','2317','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44908','йˮ','http://www.waterinfo.com.cn','2319','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44745','Ѷ','http://www.yescar.cn','2317','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44907','йˮҵ','http://www.c-water.com.cn','2319','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44747','èƵ','http://auto.mop.com','2317','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44906','йˮ','http://www.chinawater.com.cn','2319','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44749','֮','http://www.autofan.com.cn','2317','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44905','йˮ','http://www.h2o-china.com','2319','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44751','Ұ','http://www.52che.com','2317','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44904','԰ѧϰ','http://www.ylstudy.com','2319','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44753','','http://www.ieche.com','2317','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44903','й԰','http://www.18yl.com','2319','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44755','Ƶ','http://auto.ifeng.com','2317','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44902','԰й','http://www.cnlai.com','2319','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44757','','http://www.car136.com','2317','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44901','л԰','http://www.yuanlin365.com','2319','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44759','³','http://www.xincheping.com','2317','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44900','й԰','http://www.yuanlin.com','2319','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44761','XGO','http://www.xgo.com.cn','2317','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44899','й̻ľ','http://www.hnmmw.com','2319','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44763','װ','http://www.t139.com','2317','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44862','ȫ','http://www.wjw.cn','2318','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44765','̫ƽ','http://price.pcauto.com.cn','2317','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44861','йҵ','http://www.chinaglassnet.com','2318','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44767','Ѻ','http://price.auto.sohu.com','2317','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44860','йú̿ҵ','http://www.chinacoal.gov.cn','2318','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44769','','http://newcar.xcar.com.cn/price_index.htm','2317','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44859','йĤ','http://www.mem-china.com','2318','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44771','й','http://price.carschina.com','2317','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44858','йú̿ҵ','http://www.chinacoal.gov.cn','2318','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44773','֮ұ','http://car.autohome.com.cn','2317','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44898','ҵ','http://www.forestry.gov.cn','2319','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44775','й','http://www.auto18.com','2317','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44897','԰','http://www.lvhua.com','2319','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44777','й','http://www.315che.com','2317','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44896','й̻','http://www.chinagreen.net.cn','2319','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44779','','http://www.gocar.cn','2317','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44895','̬й','http://eco.gov.cn','2319','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44781','̫ƽ̳','http://autobbs.pconline.com.cn','2317','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44894','й豸','http://www.epun.cn','2319','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44783','','http://auto.sina.com.cn/shequ','2317','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44893','۴ϻ','http://www.ep.hc360.com','2319','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44785','Tom̳','http://club.auto.tom.com','2317','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44892','йƵ','http://www.zghbpd.com','2319','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44787','','http://www.xche.com.cn','2317','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44891','й','http://www.chinaenvironment.com','2319','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44789','ҳֲ','http://www.5qiche.com','2317','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44890','пԺ̬о','http://www.rcees.ac.cn','2319','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44791','ϳ','http://bbs.cheshi.com.cn','2317','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44889','й豸','http://www.goepe.com','2319','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44793','֮','http://club.autohome.com.cn','2317','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44888','й','http://www.ep168.com','2319','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44795','̳','http://bbs.chetx.com','2317','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44887','й','http://www.cenews.com.cn','2319','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44797','ԽҰ','http://bbs.fblife.com','2317','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44886','л','http://www.cepf.org.cn','2319','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44799','йֳ','http://www.zg2sc.cn','2317','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44885','й','http://www.cnemc.cn','2319','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44801','58ֳ','http://www.58.com/ershouche','2317','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44884','йӰ','http://www.china-eia.com','2319','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44803','273','http://www.273.cn','2317','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44857','йˮҵ','http://www.c-water.com.cn','2318','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44805','51','http://www.51auto.com','2317','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44856','ϼӹҵЭ','http://www.cppia.com.cn','2318','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44807','ȳ','http://www.2dunet.com','2317','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44883','йԴ','http://www.ce65.com','2319','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44809','йֳ','http://www.cn2che.com','2317','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44882','йѧѧ','http://www.chinacses.org','2319','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44811','ſֳ','http://www.ucar.cn','2317','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44881','й','http://www.epnet.cn','2319','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44813','йƷ','http://www.car2100.com','2317','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44880','л','http://www.chinaep.net','2319','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44815','۴ҵ','http://www.auto-p.hc360.com','2317','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44879','й̬','http://www.eedu.org.cn','2319','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44817','йƷ','http://www.autosup.com','2317','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44878','һܾ','http://www.zhb.gov.cn','2319','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44819','Ƴ','http://www.pochezu.com','2317','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44877','ģ','http://www.2mould.com','2318','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44821','й','http://www.qpcity.com.cn','2317','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44876','йģ','http://cn.plasticmould.net','2318','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44823','й','http://www.qipei.com','2317','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44875','ģ','http://www.molds.cn','2318','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44825','ȫ','http://www.all2car.com','2317','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44874','йģ˲','http://www.mouldjob.com','2318','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44827','ȫɹ','http://www.qp365.net','2317','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44873','йеģ','http://www.mymould.net.cn','2318','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44829','йƷ','http://www.zgqp.com.cn','2317','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44872','йģ','http://www.mould.net.cn','2318','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44831','й佻','http://www.86qp.net','2317','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44871','ģ','http://www.2mould.com','2318','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44833','йó','http://www.qp168.net','2317','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44870','','http://www.chinammr.com','2318','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44835','','http://www.qp138.com','2317','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44869','й⹤ҵ','http://www.cnsaw.com','2318','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44837','۴Ʒ','http://www.auto-a.hc360.com','2317','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44855','бҵŹ˾','http://www.cngc.com.cn','2318','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44839','۴άޱ','http://www.auto-m.hc360.com','2317','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44854','йṤҵ','http://www.clii.com.cn','2318','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44841','۴Ħг','http://www.motor.hc360.com','2317','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44853','йҵվ','http://www.ic1000.net','2318','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44843','۴','http://www.qipei.hc360.com','2317','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44868','','http://www.pifa7.cn','2318','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44845','ѧ','http://www.xueche.net','2317','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44867','ó','http://www.hardwareinfo.cn','2318','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44847','Уһͨ','http://www.jxedt.com','2317','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44866','','http://www.hnwj.net','2318','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44849','ȫУ','http://www.51xueche.com','2317','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44865','۴','http://www.wujin.hc360.com','2318','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44851','ʻԱ','http://www.jsyst.cn','2317','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44864','й','http://china.globalhardwares.com','2318','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44930','ţѧ','http://www.oup.co.uk','2320','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44931','Ƥɭ','http://www.pearson.com','2320','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44932','Τ˹-Ĺ˾','http://www.awl.com','2320','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44933','Adobe','http://www.adobe.com','2320','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44934','','http://www.ets.org','2320','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44935','˹ع˾','http://www.hearst.com','2320','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44936','ѧ','http://www.scholastic.com','2320','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44937','','http://www.randomhouse.com','2320','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44938','Ǵ','http://www.kadokawa.co.jp','2320','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44939','IDG˾','http://www.idg.com','2320','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44940','ķɭ˾','http://www.thomson.com','2320','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44941','ѷ湫˾','http://www.hwwilson.com','2320','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44942','漯','http://www.penguin.com','2320','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44943','-ϣ˾','http://www.mcgraw-hill.com','2320','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44944','١׷ֳ湫˾','http://www.hmco.com','2320','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44945','ꡤ˹漯','http://www.harpercollins.com','2320','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44946','Լøӹ˾','http://www.wiley.com','2320','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44947','س湫˾','http://www.langenscheidt.de','2320','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44948','Ƹ','http://www.eastmoney.com/','2356','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44949','˲ƾ','http://finance.sina.com.cn/','2356','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44950','֤ȯ֮','http://www.stockstar.com/home.htm','2356','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44951','Ѷƾ','http://www.hexun.com/','2356','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44952','','http://fund.eastmoney.com/','2356','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44953','Ѻƾ','http://business.sohu.com/','2356','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44954','ǻ','http://www.gw.com.cn/','2356','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44955','ͬ˳','http://www.10jqka.com.cn/','2356','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44956','ڽ','http://www.jrj.com/','2356','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44957','н','http://www.cnfol.com/','2356','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44958','ײƾ','http://money.163.com/','2356','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44959','й֤ȯ','http://www.cnstock.com/','2356','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44960','в','http://www.cfi.net.cn/','2356','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44961','й֤ȯ','http://www.cs.com.cn/','2356','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44962','ȫ','http://www.p5w.net/','2356','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44963','Ѷƾ','http://finance.qq.com/','2356','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44964','й˾Ѷ','http://www.cnlist.com/','2356','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44965','Ѷƾ','http://www.591hx.com/','2356','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44966','ɰ','http://guba.eastmoney.com/','2356','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44967','','http://fund2.eastmoney.com/','2356','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44968','ٶȲƾ','http://stock.baidu.com/','2356','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44969','˲ƾ','http://finance.ifeng.com/','2356','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44970','','http://fund2.eastmoney.com/JJxx,jijin.html','2356','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44971','Ʊ','http://stock.eastmoney.com/gpxuexiao.html','2356','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44972','һƾ','http://www.china-cbn.com/','2356','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44973','ù۲','http://www.eeo.com.cn/','2356','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44974','й','http://www.ce.cn/','2356','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44975','ֽƽ','http://www.zhihuangjin.com/','2356','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44976','Ҳ','http://www.tsts168.com/','2356','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44977','24k99','http://www.24k99.com/','2356','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44978','ʱ','http://www.financialnews.com.cn/','2356','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44979','й֤ȯҵЭ','http://www.sac.net.cn/','2356','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44980','ɳ','http://www.stockcity.cn/','2356','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44981','5678Ʊй','http://www.5678.cn/','2356','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44982','˹','http://finance.sina.com.cn/realstock/index.shtml','2357','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44983','Ƹ','http://quote.eastmoney.com/quote1_1.html','2357','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44984','¹깺/ǩѯ','http://data.eastmoney.com/xg/xg/default.html','2357','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44985','깺״̬','http://fund.eastmoney.com/Fund_sgzt_bzdm.html','2357','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44986','ʽÿվֵ','http://fund.eastmoney.com/fund.html','2357','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44987','ʽ','http://quote.eastmoney.com/jijingbaojia.html','2357','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44988','Ƽ','http://www.boc.cn/cn/common/whpj.html','2357','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44989','л','http://baidu.hexun.com/fund/nf.php','2357','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44990','Ϻ֤ȯ','http://www.sse.com.cn/','2358','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44991','֤ȯ','http://www.szse.cn/','2358','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44992','֤ȯ','http://www.gjzq.com.cn/','2358','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44993','й֤','http://www.csrc.gov.cn/','2358','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44994','̩','http://www.gtja.com/','2358','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44995','֤ȯ','http://www.dxzq.net/','2358','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44996','㷢֤ȯ','http://www.gf.com.cn/','2358','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44997','֤ȯ','http://www.westsecu.com/','2358','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44998','֤ȯ','http://www.newone.com.cn/','2358','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44999','֤ȯ','http://www.chinastock.com.cn/','2358','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45000','̩֤ȯ','http://www.htsc.com.cn/','2358','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45001','','http://www.sw2000.com.cn/','2358','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45002','֤ͨȯ','http://www.htsec.com/','2358','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45003','֤ȯ','http://www.cs.ecitic.com/','2358','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45004','Ϻƽ','http://www.sge.sh/','2358','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45005','֤ȯ','http://www.guosen.com.cn/','2358','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45006','֤ȯ','http://www.ebscn.com/','2358','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45007','֤ȯ','http://www.hazq.com/','2358','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45008','֤ȯ','http://www.ghzq.com.cn/','2358','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45009','֤ȯ','http://www.95579.com/','2358','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45010','','http://www.bocichina.com/','2358','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45011','֤ȯ','http://www.guodu.com/guodu/index.html','2358','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45012','ɽ֤ȯ','http://www.i618.com.cn/','2358','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45013','֤ȯ','http://www.hx168.com.cn/','2358','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45014','Ͷ֤ȯ','http://www.cjis.cn/','2358','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45015','Դ֤ȯ','http://www.ehongyuan.com/','2358','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45016','ҵ֤ȯ','http://www.xyzq.com.cn/','2358','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45017','֤ȯ','http://www.nesc.cn/','2358','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45018','֤ȯ','http://www.essence.com.cn/','2358','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45019','Ԫ֤ȯ','http://www.gyzq.com.cn/','2358','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45020','֤ȯ','http://www.lhzq.com/','2358','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45021','֤ͬȯ','http://www.dtsbc.com.cn/','2358','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45022','֤ȯ','http://www.dfzq.com.cn/','2358','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45023','֤ȯ','http://www.dwjq.com.cn/','2358','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45024','ԭ֤ȯ','http://www.ccnew.com/','2358','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45025','֤ȯ','http://www.stocke.com/','2358','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45026','Ͼ֤ȯ','http://www.njzq.com.cn/','2358','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45027','Ϻ֤ȯ','http://www.962518.com/','2358','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45028','֤ȯ','http://www.foundersc.com/','2358','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45029','ʢ֤ȯ','http://www.gsstock.com/','2358','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45030','֤ȯ','http://www.longone.com.cn/','2358','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45031','ݸ֤ȯ','http://www.dgzq.com.cn/','2358','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45032','֤ͨȯ','http://www.zxwt.com.cn/','2358','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45033','֤ȯ','http://www.glsc.com.cn/','2358','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45034','Ƹ֤ȯ','http://www.cfzq.com/','2358','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45035','֤ȯ','http://www.swsc.com.cn/','2358','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45036','֤ȯ','http://www.mszq.com/','2358','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45037','³֤ȯ','http://www.qlzq.com.cn/','2358','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45038','֤ȯ','http://www.xcsc.com/','2358','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45039','֤ȯ','http://www.cc168.com.cn/','2358','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45040','֤ȯ','http://www.scstock.com/','2358','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45041','ŽͶ','http://www.csc108.com/','2358','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45042','֤ȯ','http://www.ewww.com.cn/','2358','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45043','֤ȯ','http://www.e5618.com/','2358','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45044','֤ͨȯ','http://www.ctsec.com/','2358','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45045','н𲩿','http://blog.cnfol.com/','2359','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45046','˲ƾ','http://blog.sina.com.cn/lm/finance/index.html','2359','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45047','Ƹ','http://blog.eastmoney.com/','2359','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45048','Ѻƾ','http://blog.sohu.com/business/','2359','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45049','Ѷƾ','http://fblog.hexun.com/','2359','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45050','й֤ȯ','http://blog.cnstock.com/','2359','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45051','ɳ','http://blog.sina.com.cn/shaminnong','2359','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45052','С','http://blog.sina.com.cn/xuxiaoming8','2359','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45053','Ҷ벩','http://blog.sina.com.cn/yehong','2359','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45054','','http://bbs.gutx.com/','2359','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45055','̳','http://www.55188.com/index.php','2359','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45056','CCTVƾƵ','http://finance.cctv.com/','2359','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45057','·͸ƾ','http://cn.reuters.com/','2359','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45058','ձ','http://chinese.wsj.com/','2359','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45059','FT','http://www.ftchinese.com/','2359','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45060','йӪ','http://www.cb.com.cn/','2359','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45061','21;ñ','http://www.21cbh.com/','2359','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45062','Ѻ̳','http://business.sohu.com/upload/clubnew.htm','2359','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45063','˲ƾ̳','http://finance.sina.com.cn/bbs/index.shtml','2359','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45064','ڽƱ̳','http://bbs.jrj.com.cn/','2359','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45065','ǻ','http://www.hao123.com/soft/dzh/default.htm','2359','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45066','ͬ˳Ʊ','http://down1.tech.sina.com.cn/download/downContent/2005-02-04/13004.shtml','2359','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45067','չƱ','http://www.skycn.com/sort/sort2070100_indate_DESC_1.html','2359','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46192','BMWй','http://www.bmw.com.cn/','2177','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46191','','http://www.geely.com/','2177','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46190','','http://www.gaig.com.cn/','2177','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46189','ɼ','http://www.hafeiauto.com.cn/','2177','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46188','','http://www.chery.cn/','2177','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46187','','http://www.baw.com.cn/','2177','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46182','','http://auto.sina.com.cn/salon/CHERY/CHERY/sub_brand/qrruhsv.html','1666','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46181',';ʤ','http://www.autohome.com.cn/358/','1666','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46180','CRV','http://www.dongfeng-honda.com/','1666','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46179','HQ3','http://www.faw-hongqi.com.cn/','1666','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46178','µQ7','http://www.audi.cn/audi/cn/zh2/new_cars/q7.html','1666','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46177','µA6L','http://www.audi.cn/audi/cn/zh2/new_cars/a6l.html','1666','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46176','ŵ','http://www.autohome.com.cn/521','1666','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46175','','http://www.bmw.com.cn/','1666','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46174','300c','http://www.mercedes-benz.com.cn/','1666','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46173','˿Խ','http://www.buick.com.cn/excelle/index.aspx','1666','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46172','ʹ','http://www.toyota.com.cn/vehicles/crown/index.html','1666','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46171','ɵŷ','http://www.autohome.com.cn/117/','1666','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46170','','http://www.toyota.com.cn/vehicles/camry/index.html','1666','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46169','750','http://www.roewe.com.cn/','1666','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46168','Դ6','http://www.mazda6.com.cn/','1666','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46167','Ԧ','http://www.csvw.com/csvw/cpjs/passat/index.shtml','1666','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46166','Ÿ','http://www.guangzhouhonda.com.cn/accord07/','1666','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46165','','http://www.faw-vw.com/model/mod_magotan.htm','1666','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46164','','http://www.dongfeng-nissan.com.cn/car/teana/','1666','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46163','ͼ','http://www.dyk-cerato.com.cn/','1666','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46162','Դ3','http://www.mazda3.com.cn/','1666','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46160','','http://www.autohome.com.cn/51/','1666','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46161','307','http://www.peugeot.com.cn/web/307/index.html','1666','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46132','','http://www.029car.cn/','1664','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46131','ֳ','http://www.db2car.com/','1664','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46130','ֳ','http://www.2sche.cn/','1664','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46129','273ֳ','http://www.273.cn/','1664','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46115','ϳ','http://www.cheshi.com.cn/','1169','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46114','йʯͿ','http://www.saclub.com.cn/','1169','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46113','','http://www.webcars.com.cn/','1169','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46112','','http://www.autoday.com.cn/','1169','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46111','֮','http://www.autofan.com.cn/','1169','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46110','21ͷ','http://www.21rv.com/','1169','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46109','92װ','http://www.92gzc.com/','1169','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46108','','http://auto.ifeng.com/','1169','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46107','','http://auto.163.com/','1169','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46106','CHE168','http://www.che168.com/','1169','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46105','л','http://www.auto1688.com.cn/','1169','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46104','İװ','http://www.gaibar.com/','1169','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46103','йƷ','http://www.at160.com/','1169','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46102','̽','http://www.feelcars.com/','1169','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46101','ؽͨΥ²ѯ','http://www.ip138.com/weizhang.htm','1169','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46100','ٶ֪-','http://zhidao.baidu.com/browse/155','1169','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46099','ͺļ㹤','http://www.skycn.com/soft/41661.html','1169','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46098','ʵòѯ','http://cha.chelink.com/','1169','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46096','ʻԱ','http://www.jsyks.com/','1169','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46097','Уһͨ','http://www.jxedt.com/','1169','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46095','Ķֳ','http://www.hx2car.com/','1169','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46069','йд','http://www.icbc.com.cn/icbc/%e7%bd%91%e4%b8%8a%e5%9f%ba%e9%87%91','1649','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46079','캢̳','http://www.redbaby.com.cn/Union/Redirect.aspx?Source=58332&Url=http://www.redbaby.com.cn/','852','13','0','0','0','0','0','0','0','','yowao','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46067','ͨ','http://www.hftfund.com/~hft/','1649','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46068','','http://www.scfund.com.cn/','1649','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46019','Ҫʵòѯ','http://tool.yowao.com/','2292','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46016','QQ','http://id.qq.com/','2292','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46017','ת','http://www.huoxingyu.com/','2292','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46018','Pͼ','http://web.meitu.com/','2292','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46010','ʳѯ','http://www.yacou.net/yy/2-cjsp/2.htm','2291','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46009','Ӫɷֲѯ','http://www.fh21.com.cn/ying/new/chengfen.htm','2291','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46002','Ҵ/','http://www.ccb.com/cn/personal/interest/calculator.html','2289','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46001','˰','http://card.money.sohu.com/tools/html/CalcTax.htm','2289','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45994','ȫ·','http://www.cncn.com/ditie/','2290','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45995','񹤾','http://tool.yowao.com/','2290','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45993','ʱ̱','http://dongche.cncn.com/','2290','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45991','ȫ·ѯ','http://www.chinahighway.gov.cn/','2290','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45992','ݾƵԤ','http://hotels.ctrip.com/Domestic/SearchHotel.aspx','2290','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45990','ξѯ','http://www.cncn.com/jingdian/','2290','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45989','ȫسƲѯ','http://www.cncn.com/gongju/chepai.html','2290','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45981','е','http://www.youdao.com/','2288','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45979','ҽ','http://ask.qe.cn/','2288','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45980','ũƷ۸','http://www.xinnong.com/hangqing/','2288','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45978','֧','http://www.alipay.com/','2288','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45976','','http://www.icbc.com.cn/','2288','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45977','','/wangshangyinhang/','2288','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45975','ʱࡢ绰','http://www.ip138.com/post/','2288','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45973','','http://site.baidu.com/list/wannianli.htm','2288','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45974','ݲѯ','http://www.ip138.com/ems/','2288','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45971','','http://www.jctrans.com/tool/jsq.htm','2288','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45972','ӽĿԤ','http://www.tvsou.com/','2288','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45970','ֵʵ','http://www.zdic.net/','2288','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45920','й̨','http://www.typhoon.gov.cn/','2285','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45955','Ԥ','http://www.weather.com.cn/html/weather/101050101.shtml','2286','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45919','й','http://www.cea.gov.cn/','2285','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45903','ϲ̫','http://www.4399.com/special/97.htm','2255','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45902','A','http://www.4399.com/special/24.htm','2255','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45901','ͷ','http://www.4399.com/special/25.htm','2255','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45900','','http://www.4399.com/special/44.htm','2255','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45899','','http://www.4399.com/special/45.htm','2255','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45898','','http://www.4399.com/special/35.htm','2255','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45897','','http://www.4399.com/special/38.htm','2255','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45896','','http://www.4399.com/special/52.htm','2255','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45895','','http://www.4399.com/special/53.htm','2255','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45894','ð','http://www.4399.com/special/57.htm','2255','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45891','','http://www.4399.com/special/43.htm','2255','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45892','Թ','http://www.4399.com/special/63.htm','2255','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45893','','http://www.4399.com/special/62.htm','2255','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45890','','http://www.4399.com/special/7.htm','2255','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45889','Զ','http://www.4399.com/special/15.htm','2255','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45888','̨','http://www.4399.com/special/31.htm','2255','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45887','ð','http://www.4399.com/special/56.htm','2255','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45886','̰','http://www.4399.com/special/61.htm','2255','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45885','Ҳ','http://www.4399.com/special/60.htm','2255','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45884','Ϳ','http://www.4399.com/special/67.htm','2255','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45883','ս','http://www.4399.com/special/16.htm','2255','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45882','','http://www.4399.com/special/66.htm','2255','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45879','౦','http://www.4399.com/special/17.htm','2255','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45880','','http://www.4399.com/special/13.htm','2255','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45881','è','http://www.4399.com/special/22.htm','2255','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45878','','http://www.4399.com/special/2.htm','2255','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45877','','http://www.4399.com/special/14.htm','2255','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45876','Ӱ','http://www.4399.com/special/21.htm','2255','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45875','ȭ','http://www.4399.com/special/26.htm','2255','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45874','CS','http://www.4399.com/special/10.htm','2255','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45873','MMϵ','http://www.4399.com/special/4.htm','2255','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45855','ذСϷ','http://www.teaiwan.com/','701','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45856','99СϷ','http://www.99xyx.com/','701','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45857','ñСϷ','http://www.tutubao.com/','701','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45854','88СϷ','http://www.88yx.com/','701','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45846','QQǿռվ','http://www.qqwen.com/','2364','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45853','СϷ','http://www.mx007.com/','701','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45842','QQͷ','http://www.qqkt.cn/','2363','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45841','ϺQQͷ','http://www.xiaake.cn/','2363','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45837','QQ԰','http://www.qqjia.com/','2362','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45836','ҵQQ','http://my.qq.com/','2362','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45828','','http://www.fyjs.cn/bbs/','727','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45834','QQ','http://chat.qq.com/','2362','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45835','ҳQQ','http://im.qq.com/webqq/','2362','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45827','ת̳','http://www.junzhuan.com/','727','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45826','Ӫ','http://lt.cjdby.net/','727','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45816','˾Ƶ','http://v.ifeng.com/mil/','726','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45815','½','http://junshi.xilu.com/','726','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45814','ǿ','http://www.chnqiang.com/','726','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45813','۲','http://video.baidu.com/v?ct=301989888&amp;rn=20&amp;pn=0&amp;db=0&amp;s=8&amp;word=%BE%FC%C7%E9%B9%DB%B2%EC%CA%D2&amp;fr=ala0','726','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45812','ͼƬ','http://www.baidu.com/search/image_military.html','726','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45811','QQͼƬ','http://news.qq.com/photon/junshi.shtml','726','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45810','й','http://www.chinamil.com.cn/','726','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45809','','http://www.mod.gov.cn/','726','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45808','chinaiissս','http://www.chinaiiss.com/','726','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45807','Ƶ-','http://v.sina.com.cn/v/junshi.html','726','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45793','뷨-ٿ','http://baike.baidu.com/view/1190383.htm','2373','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45792','-ٶȰٿ','http://baike.baidu.com/view/32668.htm','2373','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45782','Ӱħ','http://www.neoimaging.cn/','2372','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45776','ǩ','http://fzl.meitu.com/','2371','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45775','ͷ','http://www.91feizhuliu.com/','2371','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45774','ͼƬ','http://www.fzlgo.com/','2371','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45773','ջ','http://www.52hxw.com/','2371','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45772','','http://www.fzlfx.com/','2371','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45751','','http://bt.hliang.com/','2369','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45750','Ҫϴ','http://ent.cntv.cn/chunwan/','2369','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45749','ٿȫ˵','http://www.qiyi.com/zongyi/bkqs.html','2369','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45748','й','http://www.qiyi.com/zongyi/zgdrx2010.html','2369','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45747','ְٷְ','http://www.youku.com/show_page/id_z7e25495200f311df97c0.html','2369','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45746','ֳ','http://www.qiyi.com/zongyi/ylxc.html','2369','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45745','æ','http://video.baidu.com/v?word=%B9%FA%B9%E2%B0%EF%B0%EF%C3%A6&amp;ct=301989888&amp;rn=20&amp;pn=0&amp;db=0&amp;s=0&amp;fbl=800','2369','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45744','','http://video.baidu.com/v?word=%BF%B5%CE%F5%C0%B4%C1%CB&amp;ct=301989888&amp;rn=20&amp;pn=0&amp;db=0&amp;s=0&amp;fbl=800','2369','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45739','а','http://top.baidu.com/buzz/nmingxing.html','2368','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45738','Ůа','http://top.baidu.com/buzz/ymingxing.html','2368','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45737','Ʊͨ','http://www.piaowutong.com/','2368','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45736','-','http://ent.joy.cn/','2368','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45735','鴫ý','http://www.eemedia.cn/','2368','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45734','','http://www.chinabug.net/','2368','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45733','TVB','http://www.tvb.com/','2368','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45732','ǲ','http://blog.sina.com.cn/lm/search/ent/index.html','2368','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45731','ٶ-Ǵȫ','http://tieba.baidu.com/f?ct=536870912&amp;rn=200&amp;pn=0&amp;cm=1101&amp;tn=simpleCategory&amp;sn=%C3%F7%D0%C7%C8%CB%CE%EF','2368','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45730','E','http://www.ewang.com/','2368','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45729','˿','http://www.ifensi.com/','2368','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45728','TOM','http://ent.tom.com/','2368','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45727','Ż','http://ent.cn.yahoo.com/','2368','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45726','ȫӴ-','http://ent.sina.com.cn/star/','2368','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45707','badoo','http://badoo.com/','792','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45706','QQɴ','http://8.qq.com/','792','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45705','ſռ','http://feike.fetion.com.cn/','792','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45704','','http://www.wealink.com/','792','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45703','âȦ','http://home.hunantv.com/','792','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45702','Խ','http://jianghu.taobao.com/','792','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45701','ξ԰','http://www.1001m.com/','792','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45700','ھ','http://www.yeejee.com/','792','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45699','ְ','http://www.zhinei.com/','792','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45698','˺','http://www.renhe.cn/','792','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45697','','http://www.17xing.com/','792','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45696','','http://bai.sohu.com/','792','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45637','','http://video.baidu.com/v?ct=301989888&amp;rn=20&amp;pn=0&amp;db=0&amp;s=8&amp;word=%B9%FA%CD%E2%B6%F1%D7%F7%BE%E7&amp;fr=ala0','1973','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45636','ĸЦƵ','http://video.baidu.com/childchannal/amuse/amuse.html','1973','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45635','һһ','http://www.tudou.com/home/1r1j/','1973','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45634','СƷƵ','http://video.baidu.com/childchannal/xiaopin/xiaopin.html','1973','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45633','վ','http://ent.cntv.cn/enttv/kuaileyizhan/videopage/','1973','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45632','ԱɽƷȫ','http://tv.sohu.com/s2009/zhaobenshan/','1973','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45631','¸ȫ','http://v.sina.com.cn/v/guodegang.html','1973','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45630','Ƭ','http://video.ofeva.com/','1973','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45625','Ĭ','http://www.haha365.com/','732','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45624','з','http://hxyl.net/','732','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45607','78ģ','http://www.78dm.net/','2135','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45606','','http://bbs.zymk.cn/','2135','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45605','','http://blog.sina.com.cn/u/1212870750','2135','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45604','֮','http://www.fzdm.com/','2135','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45603','bilibili','http://bilibili.us/','2135','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45602','Ļ','http://www.jumpcn.com/','2135','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45601','ٱ','http://www.bbddm.com/','2135','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45600','οѧ԰','http://bbs.sumisora.org/','2135','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45599','ջ','http://comic.zymk.cn/','2135','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45598','sosg̳','http://www.sosg.net/','2135','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45597','綯','http://qingkong.net/','2135','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45596','ѩ','http://www.sc-ol.com/','2135','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45595','èSDҴ','http://www.sdgundam.cn/','2135','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45594','','http://www.u17.com/','2135','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45593','Ϳѻ','http://www.poobbs.com/','2135','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45592','','http://bbs.comicdd.com/','2135','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45591','','http://www.bengou.com/','2135','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45590','淨½','http://www.78land.com/','2135','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45589','۶','http://www.iieye.cc/','2135','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45588','ͨ-ٶͼƬ','http://www.baidu.com/search/image_cartoon.html','2135','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45587','Ӷ','http://comic.boxuu.com/','2135','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45586','ɿɶ','http://www.cococomic.com/','2135','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45585','acfun','http://www.acfun.cn/','2135','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45584','178','http://donghua.178.com/','2135','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45583','','http://comic.xxbh.net/','2135','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45582','֪','http://www.zymk.cn/','2135','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45581','sf','http://comic.sky-fire.com/','2135','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45580','ᶯ','http://comic.kukudm.com/','2135','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45579','ǳ','http://comic.veryim.com/','2135','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45578','˶','http://dm.idler-et.com/','2135','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45577','fans','http://www.dm123.cn/','2135','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45619','Ŀ԰','http://www.tianya.cn/techforum/articleslist/0/14.shtml','732','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45575','','http://www.9lala.com/','2135','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45574','99770','http://mh.99770.cc/','2135','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45573','ħ','http://www.emland.net/','2135','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45572','֮','http://dmzj.178.com/','2135','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45571','˼䶯','http://www.52tian.net/','2135','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45570','ѩ','http://www.fxdm.net/','2135','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45569','ҵ','http://www.dm5.com/','2135','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45568','Ѷ','http://comic.qq.com/','2135','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45564','6','http://comic.ku6.com/','777','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45563','pptv','http://cartoon.pptv.com/','777','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45553','˫','http://tieba.baidu.com/f?kw=%CB%AB%D3%E3%D7%F9','787','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45552','ˮƿ','http://tieba.baidu.com/f?kw=%CB%AE%C6%BF%D7%F9','787','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45551','ħ','http://tieba.baidu.com/f?kw=%C4%A7%F4%C9%D7%F9','787','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45550','','http://tieba.baidu.com/f?kw=%C9%E4%CA%D6%D7%F9','787','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45549','Ы','http://tieba.baidu.com/f?kw=%CC%EC%D0%AB%D7%F9','787','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45548','','http://tieba.baidu.com/f?kw=%CC%EC%B3%D3%D7%F9','787','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45547','Ů','http://tieba.baidu.com/f?kw=%B4%A6%C5%AE%D7%F9','787','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45546','ʨ','http://tieba.baidu.com/f?kw=%CA%A8%D7%D3%D7%F9','787','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45545','з','http://tieba.baidu.com/f?kw=%BE%DE%D0%B7%D7%F9','787','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45544','˫','http://tieba.baidu.com/f?kw=%CB%AB%D7%D3%D7%F9','787','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45543','ţ','http://tieba.baidu.com/f?kw=%BD%F0%C5%A3%D7%F9','787','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45542','','http://tieba.baidu.com/f?kw=%B0%D7%D1%F2%D7%F9','787','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45562','pps','http://kan.pps.tv/anime_index.html','777','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45537','','http://www.lansin.com/','785','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45536','2011','http://astro.women.sohu.com/20101210/n301005391.shtml','785','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45535','201112Ф','http://astro.women.sohu.com/20101210/n300989565.shtml','785','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45534','2011Ԥ','http://astro.lady.qq.com/zt2010/2011yszt/index.htm','785','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45533','ֻż','http://mobile.9om.com/','785','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45532','','http://life.httpcn.com/sm.asp','785','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45531','1518','http://www.1518.com/','785','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45530','Ȥ','http://www.uqude.com/','785','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45529','Ѫ','http://comic.qq.com/z/xx/','785','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45528','','http://www.meimingteng.com/','785','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45527','-','http://www4.skycn.com/sort/sort2080200_indate_DESC_1.html','785','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45526','Ԫ','http://bbs.china95.net/','785','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45517','','http://astro.sina.com.cn/feeling/','784','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45507','21CNͼƬ','http://et.21cn.com/picture/','710','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45516','Ů׵','http://nownow.blogbus.com/','784','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45498','3lianز','http://www.3lian.com/','709','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45497','ţӰ','http://yx.keniu.com/','709','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45496','ͼ','http://www.ooopic.com/','709','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45495','ͼ','http://xiuxiu.meitu.com/','709','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45494','','http://www.funnywow.cn/','709','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45493','picasa','http://picasa.google.com/','709','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45492','ͼ','http://www.aiimg.com/','709','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45491','','http://www.deskcity.com/','709','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45490','èèֽ','http://www.wallcoo.com/','709','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45489','ز','http://www.sucaitianxia.com/','709','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45488','ͼ','http://www.nipic.com/','709','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45402','С˵','http://www.xhxsw.com/','645','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45401','С˵','http://www.zzzyq.com/','645','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45400','С˵','http://www.dddbbb.net','645','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45399','С˵','http://www.inbook.net/','645','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45398','¥','http://www.shulou.com/','645','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45397','С˵а','http://top.baidu.com/buzz/book.html','645','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45396','С˵һ','http://www.duyidu.com/','645','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45395','','http://www.junzitang.com/','645','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45394','ѧ','http://www.2100book.com/','645','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45393','ĶС˵','http://www.xdyqw.com/','645','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45392','MSNС˵Ƶ','http://msn.hongxiu.com/','645','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45391','С˵','http://book.qukanshu.com/','645','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45390','','http://www.rongshuxia.com/','645','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45389','ɷ','http://www.wansong.net/','645','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45388','˶','http://book.sina.com.cn/','645','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45387','','http://www.xhsd.net/','645','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45386','΢','http://www.cuiweiju.com/','645','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45385','ۿ','http://www.booksky.org/','645','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45361','йӰ','http://www.chinafilm.com/','1119','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45360','Ӱ','http://www.douban.com/movie/','1119','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45359','Ӱ','http://www.tianya.cn/Publicforum/ArticlesList/0/filmTV.shtml','1119','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45358','Ѷ-Ӱ','http://ent.qq.com/movie/','1119','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45357','Mtimeʱ','http://www.mtime.com/','1119','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45356','ӰѶ','http://www.mtime.com/showtime/','1119','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45355','Ӱ','http://ent.phoenixtv.com/movie/','1119','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45354','M1905','http://www.m1905.com/','1119','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45352','','http://www.funshion.com/','805','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45351','QQlive','http://live.qq.com/','805','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45350','PPTV','http://www.pptv.com/','805','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45334','»̳','http://forum.xinhuanet.com/','2276','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45335','̳','http://bbs.ifeng.com/','2276','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45272','Ϸ','http://www.aipai.com/','2068','100','0','0','0','0','0','0','0','','yowao','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45271','u9','http://bbs.uuu9.com/','2068','100','0','0','0','0','0','0','0','','yowao','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45270','ﵺ','http://bbs.houdao.com/','2068','100','0','0','0','0','0','0','0','','yowao','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45269','ٶϷ','http://yx.baidu.com/','2068','100','0','0','0','0','0','0','0','','yowao','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45268','plu','http://bbs.plu.cn/','2068','100','0','0','0','0','0','0','0','','yowao','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45267','','http://www.92wy.com/','2068','100','0','0','0','0','0','0','0','','yowao','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45266','ͳһ','http://www.tyjsq.com/','2068','100','0','0','0','0','0','0','0','','yowao','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45265','ʢ','http://www.sdo.com/','2068','100','0','0','0','0','0','0','0','','yowao','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45264','','http://www.jcard.cn/','2068','100','0','0','0','0','0','0','0','','yowao','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('41767','־ӢCS','http://www.yowao.com/html/topic/webgame/game.htm#25','706','1','0','0','0','0','0','0','0','','yowao','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('41768','ħ','http://www.yowao.com/html/topic/webgame/game.htm#11','706','2','0','0','0','0','0','0','0','','yowao','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('41769','˲','http://www.yowao.com/html/topic/webgame/game.htm#39','706','3','0','0','0','0','0','0','0','','yowao','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('41770','³ʿ','http://www.yowao.com/html/topic/webgame/game.htm#78','706','4','0','0','0','0','0','0','0','','yowao','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('41771','λ','http://www.yowao.com/html/topic/webgame/game.htm#15','706','5','0','0','0','0','0','0','0','','yowao','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('41772','ɡ','http://www.yowao.com/html/topic/webgame/game.htm#42','706','6','0','0','0','0','0','0','0','','yowao','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('41773','⴫','http://www.yowao.com/html/topic/webgame/game.htm#83','706','7','0','0','0','0','0','0','0','','yowao','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('41774','ʵ','http://www.yowao.com/html/topic/webgame/game.htm#27','706','8','0','0','0','0','0','0','0','','yowao','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('41775','Խ','http://www.yowao.com/html/topic/webgame/game.htm#81','706','9','0','0','0','0','0','0','0','','yowao','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('41776','Ѫ','http://www.yowao.com/html/topic/webgame/game.htm#20','706','10','0','0','0','0','0','0','0','','yowao','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('41777','','http://www.yowao.com/html/topic/webgame/game.htm#18','706','11','0','0','0','0','0','0','0','','yowao','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('41778','ܿ','http://www.yowao.com/html/topic/webgame/game.htm#16','706','12','0','0','0','0','0','0','0','','yowao','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('41779','Aion֮','http://www.yowao.com/html/topic/webgame/game.htm#101','706','13','0','0','0','0','0','0','0','','yowao','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('41780','','http://www.yowao.com/html/topic/webgame/game.htm#13','706','14','0','0','0','0','0','0','0','','yowao','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('41781','ͷ','http://www.yowao.com/html/topic/webgame/game.htm#14','706','15','0','0','0','0','0','0','0','','yowao','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('41782','QQ','http://www.yowao.com/html/topic/webgame/game.htm#19','706','16','0','0','0','0','0','0','0','','yowao','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46351','»','http://www.xinhuanet.com/health/','864','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46350','','http://health.people.com.cn/','864','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46349','лҽ','http://www.zhzyw.org/','864','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46348','114','http://www.jianshen114.com/','864','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46347','ҽҩ','http://www.zhong-yao.net/','864','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46346','','http://www.jkb.com.cn/','864','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46339','CECT','http://www.cectelecom.com/','2383','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46338','','http://www.amoi.com.cn/','2383','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46337','','http://www.lenovomobile.com/','2383','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46336','OPPO','http://www.oppo.com/','2383','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46335','iPhone','http://www.apple.com/iphone/','2383','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46334','LG','http://www.lg.com.cn/','2383','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46333','Ħ','http://www.motorola.com.cn/','2383','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46332','','http://cn.samsungmobile.com/','2383','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46331','ᰮ','http://www.sonyericsson.com.cn/','2383','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46330','ŵ','http://www.nokia.com.cn/','2383','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46328','ͨ','http://www.blovestorm.com/','2382','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46329','Űʿ','http://www.msafe.com.cn/','2382','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46327','ŵPC׼','http://www.nokia.com.cn/A4582044','2382','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46324','UCWEB','http://www.ucweb.com/','2382','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46325','춯','http://www.ttpod.com/','2382','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46326','','http://www.fetion.com.cn/','2382','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46323','ֻMSN','http://mobile.msn.com.cn/','2382','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46322','ֻQQ','http://mobile.qq.com/','2382','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46321','й','http://www.12530.com/','2381','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46320','ֻϷ','http://zhidao.baidu.com/q?word=%C8%E7%BA%CE%CF%C2%D4%D8%CA%D6%BB%FA%D3%CE%CF%B7&amp;ct=17&amp;pn=0&amp;tn=ikaslist&amp;rn=10&amp;lm=0&amp;fr=search','2380','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46319','Ҳ֪̳','http://bbs.wbzd.net/','2380','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46318','','http://www.uutxt.com/','2380','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46317','µ','http://www.txdzs.com/','2380','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46316','ֻ','http://www.cczz.com/','2380','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46315','MP4̳','http://bbs.v15i.com/','2380','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46314','±','http://www.sisdown.com/','2380','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46313','','http://www.gamezero.cn/','2380','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46312','','http://book.sooyuu.com/','2380','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46310','','http://book.hqdoor.com/','2380','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46311','TXT','http://www.txtku.cn/','2380','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46309','','http://www.downjoy.com/','2380','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46308','ֻϷ','http://www.game1313.com/','2380','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46307','Ұ','http://www.52eshu.com/','2380','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46306','Ħ','http://www.51momo.com/','2380','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46305','ֻ','http://www.qisuu.com/','2380','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46304','׽','http://www.joyes.com/','2380','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46303','ֻ԰','http://www.shouji.com.cn/','2380','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46302','ħֻ','http://www.moxiu.com/','2380','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46301','ɿ','http://www.feiku.com/','2380','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46300','3533ֻϷ','http://game.3533.com/game/','2380','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46299','ݮֻ̳','http://www.52blackberry.com/','768','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46298','GPS̳','http://bbs.gpsuu.com/','768','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46297','592PPC̳','http://www.592ppc.com/','768','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46296','ֻʿ','http://www.sjbus.com','768','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46295','մ̳','http://www.52dopod.net/','768','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46294','IT168ŵ̳','http://nokia.it168.com/','768','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46293','ڴ̳','http://bbs.pdafans.com/','768','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46272','915ֻ','http://www.915.com/','766','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46271','ֻ','http://mobile.pcpop.com/','766','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46270','ɽկ','http://www.shanzhaiji.cn/','766','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46269','139ֻ','http://mail.139.com','766','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46268','йشֻƵ','http://mobile.zol.com.cn','766','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46267','ֻ','http://www.139shop.com','766','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46266','ֻй','http://www.cnmo.com/','766','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46265','','http://www.ownskin.com/','766','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46264','3533ֻ','http://www.3533.com/','766','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46253','500Ʊ','http://union.500wan.com/pages/interfacehezuo.php?coopid=1415&adid=16','814','4','1','0','0','0','0','0','0','','yowao','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46252','й','http://www.chinajjr.cn/','2379','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46251','E','http://www.justeasy.cn/','2379','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46250','','http://www.snren.com/','2379','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46249','','http://www.fdc100.com/','2379','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46248','ľ','http://www.co188.com/','2379','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46247','йʦ','http://www.coc.gov.cn/','2379','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46246','칤','http://www.tgnet.cn/','2379','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46245','','http://www.zhulong.com/','2379','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46243','3dģͿ','http://www.3dxia.com/','879','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46244','ABBS̳','http://www.abbs.com.cn/','2379','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46242','Ҿ','http://deco.rayli.com.cn/','879','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46241','ٰ','http://www.bnq.com.cn/','879','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46240','','http://www.jiatx.com/','879','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46239','ȫѼ˽','http://www.quanyou.com.cn/','879','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46238','ִҾ','http://www.qumei.com/','879','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46237','ҼҾװ','http://www.tg.com.cn/','879','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46236','ˡ','http://www.markorhome.com/','879','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46235','ӽ','http://light.ju51.com/','879','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46234','˼','http://www.ikea.com/cn/zh/','879','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46233','̫ƽҾ','http://www.pchouse.com.cn/','879','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46232','Ȼ֮','http://www.juran.com.cn/','879','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46231','','http://www.chinaredstar.com/','879','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46230','й','http://www.bmlink.com/','879','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46221','','http://www.haozu.com/','881','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46229','װ','http://www.to8to.com/','879','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46220','Ѷ','http://www.fangqq.com/','881','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46219','סѯ','http://www.hao123.com/haoserver/gjjcx.htm','881','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46218','žŷ','http://www.99fang.com/','881','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46217','','http://www.souwoo.com/','881','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46216','׷','http://house.163.com/','881','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46215','ͷ','http://www.zt3.cn/','881','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46214','ѷ','http://agent.soufun.com/','881','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46213','','http://www.bankrate.com.cn/cms/product_mortgage_index.php','881','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46212','21Ͳ','http://www.century21cn.com/','881','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46211','','http://www.mysupa.com/','881','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46210','Է','http://www.taofw.cn/','881','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46198','','http://www.ford.com.cn/','2177','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46197','ѩ','http://www.chevrolet.com.cn/','2177','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46196','Jeep','http://www.jeep.com.cn/','2177','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45263','','http://cluclick.leshu.com/pre.php?r=1543_43_0','2141','8','0','0','0','0','0','0','0','','admin','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45262','Ѫ','http://cluclick.leshu.com/pre.php?r=1543_30_0','2141','9','0','0','0','0','0','0','0','','admin','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45261','99СϷ','http://www.99xyx.com/','2253','8','0','0','0','0','0','0','0','','yowao','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45260','ٶϷ','http://youxi.baidu.com/','699','18','1','0','0','0','0','0','0','','yowao','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45259','Ϸ','http://game.163.com/','699','14','0','0','0','0','0','0','0','','yowao','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45258','52pkϷ','http://www.52pk.com/','699','15','0','0','0','0','0','0','0','','yowao','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45257','Ϸ','http://www.gamespot.com.cn/','699','16','0','0','0','0','0','0','0','','yowao','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45256','ǿ','http://www.gamersky.com/','699','17','0','0','0','0','0','0','0','','yowao','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45254','ξ','http://www.uuu9.com/','699','13','0','0','0','0','0','0','0','','yowao','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45255','ѶϷ','http://game.qq.com/index.shtml','699','19','0','0','0','0','0','0','0','','yowao','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45253','IS','http://www.ipark.cn/','699','20','0','0','0','0','0','0','0','','yowao','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45252','YY','http://yy.duowan.com/','699','11','0','0','0','0','0','0','0','','yowao','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45251','VSϷƽ̨','http://www.vsa.com.cn/','699','21','0','0','0','0','0','0','0','','yowao','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45250','','http://www.ourgame.com/','699','12','0','0','0','0','0','0','0','','yowao','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('41913','17173','http://www.17173.com/','699','1','1','0','0','0','0','0','0','','yowao','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('41914','4399Ϸ','http://www.4399.com/','699','2','0','0','0','0','0','0','0','','yowao','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('41915','Ϸ','http://games.sina.com.cn/','699','3','0','0','0','0','0','0','0','','yowao','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('41916','Ϸ','http://www.duowan.com/','699','4','0','0','0','0','0','0','0','','yowao','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('41917','̫ƽϷ','http://www.pcgames.com.cn/','699','5','0','0','0','0','0','0','0','','yowao','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('41918','5173','http://www.5173.com/','699','6','0','0','0','0','0','0','0','','yowao','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('41919','QQϷ','http://qqgame.qq.com/','699','7','0','0','0','0','0','0','0','','yowao','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('41920','','http://patch.ali213.net/','699','8','0','0','0','0','0','0','0','','yowao','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('41921','Ϸ','http://game.gougou.com/','699','9','0','0','0','0','0','0','0','','yowao','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('41922','Ʒսƽ̨','http://www.cga.com.cn/','699','10','0','0','0','0','0','0','0','','yowao','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42340','Υ²ѯ','http://www.bjjtgl.gov.cn','2321','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42339','˳ָ','http://www.bjsubway.com/cczn/dtxlt.asp','2321','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42338','Ԥ','http://php.weather.sina.com.cn/search.php?city=','2321','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42337','','http://www.bjbus.com','2321','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42336','¾','http://www.thebeijingnews.com','2321','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42335','','http://www.bjnews.com.cn','2321','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42334','ǧ','http://www.qianlong.com','2321','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42332','׶֮','http://www.beijing.gov.cn','2321','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42333','»','http://www.bj.xinhuanet.com','2321','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42358','ξϢ','http://www.bjta.gov.cn','2321','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42357','׶֮','http://www.beijing.gov.cn/ggfw/lyz/default.htm','2321','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42356','ʵͼ','http://maps.google.com/maps?f=q&amp;hl=zh-CN&amp;q=beijing&amp;ie=UTF8&amp;t=h&amp;om=1&amp;ll=39.906955,116.390727&amp;spn=0.01116,0.026586','2321','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42355','Я','http://destinations.ctrip.com/Destinations/DistrictIntroduction.asp?District=1','2321','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42353','׹','http://www.bjfdc.gov.cn','2321','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42354','˷','http://bj.house.sina.com.cn','2321','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42351','ϼ','http://bj.ganji.com','2321','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42352','ס','http://www.bjgjj.gov.cn','2321','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42350','ڱ','http://www.koubei.com','2321','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42349','365','http://www.bj365.com','2321','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42348','263','http://beijing.263.com','2321','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42347','վ̨','http://www.zhantai.com','2321','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42341','ƶ','http://www.bj.chinamobile.com','2321','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42342','ͨ','http://www.bj.chinaunicom.com','2321','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42343','','http://www.bjtelecom.net','2321','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42344','ͨ','http://www.cttbj.com','2321','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42345','','http://www.bbn.com.cn','2321','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42346','㷿','http://house.focus.cn','2321','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42375','Ʊ','http://www.ticketnet.cn','2321','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42374','йƱ','http://www.piao.com.cn','2321','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42373','ҡ','http://www.rockbj.com','2321','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42372','ӰѶ','http://ent.sina.com.cn/movie/dianying','2321','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42371','¿','http://www.bjpta.gov.cn','2321','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42370','¶','http://www.neworiental.org','2321','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42368','׶ͼ','http://www.clcn.net.cn','2321','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42369','нίԱ','http://www.bjedu.gov.cn','2321','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42416','','http://www.tj.gov.cn','2322','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42415','Ʊ','http://tiyucaipiao.net/tianjin','2322','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42414','Ʊ','http://www.fulicaipiao.cn/tianjin','2322','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42413','ѧ','http://www.tju.edu.cn','2322','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42410','ҽԺ','http://www.tjmuch.com','2322','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42411','пϢ','http://www.zhaokao.net','2322','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42412','Ͽѧ','http://www.nankai.edu.cn','2322','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42409','гҽԺ','http://26170.hos.999120.net','2322','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42408','ҽԺ','http://www.umc.net.cn','2322','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42407','֮','http://health.enorth.com.cn','2322','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42406','','http://www.tj2shou.com','2322','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42405','»ʳ','http://www.tj.xinhua.org/shkj/sqsm.htm','2322','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42402','','http://travel.enorth.com.cn/tjyw','2322','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42403','ۺ','http://www.tjtour.cn','2322','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42404','򹷲','http://www.chinagoubuli.com','2322','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42431','´ý','http://whb.news365.com.cn','2323','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42430','ϺƱ','http://www.swlc.sh.cn','2323','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42429','','http://www.eastday.com','2323','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42428','йϺ','http://www.shanghai.gov.cn','2323','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42427','Ϻ','http://www.online.sh.cn','2323','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42426','Ѱζ-Żȯ','http://www.xoovoo.com','2322','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42425','','http://www.kutj.com','2322','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42424','ͼ','http://www.tjl.tj.cn','2322','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42423','','http://www.tj-pigeon.com','2322','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42422','','http://www.ptacn.com','2322','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42421','򵵰','http://www.tjdag.gov.cn','2322','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42420','Ժ','http://tjfy.chinacourt.org','2322','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42419','й̾','http://www.tjhd.net','2322','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42417','зչĸίԱ','http://www.tjdpc.gov.cn','2322','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42418','оίԱ','http://www.tjec.gov.cn','2322','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42446','лӢϺվ','http://shanghai.chinahr.com','2323','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42445','ǰϺվ','http://www.51job.com/default-area.php?area=0200','2323','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42444','Ϻͨ','http://www.cttsh.com','2323','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42443','Ϻ','http://sh.ct10000.com','2323','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42442','Ϻͨ','http://www.133sh.com','2323','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42441','Ϻƶ','http://www.sh.chinamobile.com','2323','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42440','չ˾','http://www.shanghaiairport.com','2323','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42439','Ϻ','http://www.shmetro.com','2323','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42438','Ϻнͨ','http://www.jt.sh.cn','2323','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42437','ϺԤ','http://www.smb.gov.cn','2323','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42436','ܿ','http://xmzk.xinminweekly.com.cn','2323','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42435','Ϻ̨','http://www.dragontv.cn','2323','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42432','ѺϺƵ','http://sh.sohu.com','2323','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42433','»ϺƵ','http://www.sh.xinhua.org','2323','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42434','ϺƵ','http://sh.sina.com.cn','2323','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42464','̫ƽٻ','http://www.pacific-shanghai.com.cn','2323','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42463','','http://bbs.sh.liba.com','2323','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42462','ڱϺ','http://2076.koubei.com','2323','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42461','Ϻ-ʳ','http://eat.online.sh.cn','2323','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42460','Ϻ','http://www.shanghaimuseum.net','2323','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42459','ЯϺ','http://destinations.ctrip.com/Destinations/DistrictIntroduction.asp?district=2','2323','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42458','Ϻ','http://www.shanghaidz.com','2323','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42457','Ϻ','http://www.shanghaitour.net','2323','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42456','Ϻ-','http://tttrip.online.sh.cn','2323','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42455','Ϻⷿ','http://www.okfang.com','2323','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42454','Ϻ','http://www.shome.cn','2323','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42447','Ϻ˲','http://www.shanghairc.com','2323','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42448','ϺͶ','http://www.12333sh.gov.cn/index.shtml','2323','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42449','Ϻ˲г','http://www.hr.net.cn','2323','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42450','Ϻ','http://www.efesco.com','2323','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42451','ϺְҵԺ','http://www.spta.gov.cn','2323','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42452','Ϻ¾','http://rsj.sh.gov.cn','2323','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42453','׾','http://www.021fang.com','2323','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42480','ٶȵͼ֣','http://map.baidu.com/#word=֣&amp;ct=10','2324','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42479','˺','http://henan.sina.com.cn','2324','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42478','','http://www.hnzyqx.ha.cn','2324','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42477','й','http://www.henannews.com.cn','2324','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42476','Ӵ','http://www.hnsc.com.cn','2324','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42475','»Ƶ','http://www.ha.xinhuanet.com','2324','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42474','','http://www.dahe.cn','2324','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42473','̶','http://www.zz.ha.cn','2324','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42472','ѾѾ-Ϻվ','http://sh.iyaya.com','2323','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42465','ϺҽƱ','http://www.shyb.gov.cn','2323','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42466','Ϻҽѧ','http://www.91985.com','2323','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42467','ɽҽԺ','http://www.zshospital.com','2323','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42468','ϺжͯҽԺ','http://www.shchildren.com.cn','2323','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42469','Ϻز','http://sh.soufun.com','2323','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42470','Ϻ','http://sh.iyun.com','2323','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42471','ϺС','http://www.fg114.com','2323','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42489','ʡ','http://www.hnrs.gov.cn','2324','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42488','Ҳ','http://www.zzrc.com.cn','2324','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42487','˲','http://www.tjinfo.com','2324','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42486','ͨ','http://www.cttha.com','2324','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42485','ϵ','http://ha.ct10000.com','2324','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42484','ͨ','http://www.ha.chinaunicom.com','2324','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42483','ƶ','http://www.ha.chinamobile.com','2324','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42482','ٶȵͼ','http://map.baidu.com/#word=%BF%AA%B7%E2&amp;ct=10','2324','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42481','ٶȵͼ','http://map.baidu.com/#word=%C2%E5%D1%F4&amp;ct=10','2324','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42504','Ѻ','http://club.travel.sohu.com/list_art_sub.new.php?b=henan','2324','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42503','̳','http://vcom.dahe.cn/dhbbs','2324','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42502','̶BBS','http://bbs.shangdu.com','2324','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42501','ϴѧ','http://www.henu.edu.cn','2324','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42500','ʡ½','http://www.hnrsks.com','2324','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42499','ԭ','http://www.henanedu.com','2324','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42498','ʡ','http://www.hadoe.gov.cn','2324','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42497','Ļ','http://www.hawh.cn','2324','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42496','Ϻ԰','http://www.qingmings.com','2324','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42495','ʡξ','http://www.hnly.com','2324','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42494','̶','http://travel.shangdu.com','2324','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42493','֣ݿƼг','http://www.kjsc.com.cn','2324','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42490','̶','http://house.shangdu.com','2324','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42491','֣ѷ','http://zz.soufun.com','2324','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42492','Ͻҵ','http://www.jianye.com.cn','2324','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42521','ƶ','http://www.hb.chinamobile.com','2325','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42522','ͨ','http://info2.10010.com/lt/plugin/portal/arealevel/queryCityInfo.do?arno=00010024&amp;id=1349','2325','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42520','йϿý','http://www.cn3x.com.cn','2325','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42519','','http://www.hb.chinanews.com.cn','2325','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42518','ձ','http://hbrb.cnhubei.com','2325','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42517','»Ƶ','http://www.hb.xinhuanet.com','2325','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42516','','http://cnhubei.com','2325','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42515','ԥŮ','http://www.37138.cn','2324','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42514','֣̳','http://www.zz1.com.cn','2324','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42513','','http://www.hnmeme.com','2324','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42512','֣','http://www.bszzw.com','2324','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42511','ȫල','http://www.hnsafety.gov.cn','2324','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42510','','http://www.hncom.gov.cn','2324','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42509','ʡί','http://www.hndrc.gov.cn','2324','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42505','ϻ','http://bbs.hnhw.com','2324','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42506','bbs','http://bbs.ly.ha.cn','2324','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42507','ϷԺ','http://hngy.chinacourt.org','2324','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42508','Ϲ','http://www.haaic.gov.cn','2324','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42533','ʳ','http://www.1797.com.cn','2325','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42532','Ƶ','http://www.cnhan.com/gb/node/node_1185.htm','2325','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42531','Ƶ','http://travel.cnhubei.com','2325','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42530','ָ','http://www.hubeitour.com','2325','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42529','ξ','http://www.hubeitour.gov.cn','2325','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42528','ѷ-人','http://wuhan.soufun.com','2325','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42527','סլ뷿Ϣ','http://www.hbfdc.com.cn','2325','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42526','人߷','http://fdc.wuhan.net.cn','2325','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42525','ڷ','http://www.fdc.com.cn','2325','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42524','ͨ','http://www.ctthb.com','2325','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42523','','http://www.hbtelecom.com.cn','2325','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42547','人̳','http://www.dawuhan.com','2325','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42546','','http://cache.tianya.cn/new/TianyaCity/ArticlesList_Culture.asp?idWriter=0&amp;Key=0&amp;iditem=46','2325','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42545','̳','http://bbs.cnhan.com','2325','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42544','','http://club.wuhan.net.cn','2325','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42543','Կ','http://www.hbzkw.com','2325','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42542','人ѧ','http://www.whu.edu.cn','2325','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42541','ʡ','http://www.hbe.gov.cn','2325','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42540','ʡԺ','http://www.hbea.edu.cn','2325','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42539','Ϣ','http://www.e21.edu.cn','2325','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42538','ʡ»ҽԺ','http://www.xinhuahospital.com','2325','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42537','ʡ','http://www.hbws.gov.cn','2325','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42536','Ƶ','http://www.cnhan.com/gb/special/node_5.htm','2325','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42534','ʡҽԺ','http://www.rmhospital.com','2325','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42535','','http://health.cnhubei.com','2325','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42563','ʡ','http://www.hnsq.cn','2326','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42562','Ͼñ','http://www.jjbhn.com','2326','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42561','ӥ','http://www.hifly.tv','2326','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42560','ǳ','http://www.csonline.com.cn','2326','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42559','Ϻ','http://rednet.cn','2326','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42557','','http://www.hnol.net','2326','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42558','»Ƶ','http://www.hn.xinhuanet.com','2326','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42556','','http://www.edu-hb.com','2325','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42555','̳','http://bbs.jz135.com','2325','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42554','人','http://www.whw.cc','2325','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42553','ʡĻ','http://www.hbwh.gov.cn','2325','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42552','ʡ̾','http://www.egs.gov.cn','2325','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42551','۾','http://www.hbpic.gov.cn','2325','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42550','ʡί','http://www.hbjw.gov.cn','2325','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42549','ʡ','http://www.hubei.gov.cn','2325','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42548','','http://www.jmbbs.com','2325','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42188','Ӵ','http://www.gznet.com','2284','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42189','Ϸ','http://www.southcn.com','2284','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42190','֮','http://www.sz.net.cn','2284','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42191','','http://www.ycwb.com','2284','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42192','','http://www.dayoo.com','2284','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42193','','http://www.szol.net','2284','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42194','˹㶫վ','http://gd.sina.com.cn','2284','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42195','㶫ʡ','http://www.gd.gov.cn','2284','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42196','»㶫Ƶ','http://www.gd.xinhuanet.com','2284','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42197','Ϸҵ','http://www.nanfangdaily.com.cn/default.asp','2284','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42198','Ԥ','http://php.weather.sina.com.cn/search.php?city=','2284','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42199','ݹѯ','http://www.gz-bus.com/chaxun','2284','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42200','ݰƻ','http://www.baiyunairport.com','2284','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42201','άͼ','http://gz.o.cn','2284','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42202','㶫ƶ','http://www.gd.chinamobile.com','2284','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42203','㶫ͨ','http://info2.10010.com/lt/plugin/portal/arealevel/queryCityInfo.do?arno=00010004&amp;id=1677','2284','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42204','㶫','http://gd.ct10000.com','2284','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42205','㶫ͨ','http://www.crcgd.com','2284','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42206','㶫˲','http://www.gdrc.com','2284','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42207','ݸ','http://www.dg.gd.cn','2284','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42208','ϷӢ','http://www.job168.com','2284','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42209','лӢ㶫վ','http://guangzhou.chinahr.com','2284','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42210','ѷ-','http://gz.soufun.com','2284','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42211','˹㶫','http://gz.house.sina.com.cn','2284','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42212','21CN-','http://house.21cn.com','2284','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42213','˲','http://www.dgchr.com','2284','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42214','Ӵ-סڹ','http://house.gznet.com','2284','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42215','','http://www.visitgz.com','2284','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42216','ʳ','http://www.szeat.net','2284','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42217','ϷҽԺ','http://www.nfyy.com','2284','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42218','ʡչĸί','http://www.gddpc.gov.cn','2284','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42219','ʡóί','http://www.gdet.gov.cn/index.jsp','2284','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42220','ʡͶ','http://www.gd.lss.gov.cn','2284','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42221','ʡͨ','http://www.gdcd.gov.cn','2284','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42222','ʡ̾','http://www.gdgs.gov.cn','2284','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42223','麣Ϣ','http://www.zhuhai0756.com','2284','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42224','','http://www.514200.cn','2284','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42225','ƽ֮','http://www.rp1314.cn','2284','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42226','ݲżҽ','http://www.boya2004.com','2284','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42227','Ǯ-Żȯ','http://www.checkoo.com','2284','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42228','÷','http://www.mzw.com.cn','2284','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42229','۳-ۻƽ̨','http://www.juooo.com','2284','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42230','','http://www.szshequ.com','2284','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42231','п','http://www.nankesg.com','2284','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42232','ݸѯ','http://www.dg84.com','2284','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42233','꼯-ۿϢ','http://www.huliji.com','2284','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42234','ݹ԰վ','http://www.gykyz.com','2284','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42235','ݸŹ','http://www.dgtg.net','2284','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42236','Ĺ㶫','http://gd.tianya.cn','2284','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42599','','http://www.zhuzhouwang.com','2326','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42598','ǳǵ-ɳ','http://www.xcdaogou.com','2326','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42597','ɳУҽ','http://csmxjj.cn','2326','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42596','ɳϢ','http://www.changshaxx.com','2326','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42595','ɳϢ','http://www.csnis.com','2326','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42594','ϼ۸','http://www.priceonline.gov.cn','2326','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42593','ʡ','http://gov.hnedu.cn/cn/gov/index.jsp','2326','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42592','ϷԺ','http://hunanfy.chinacourt.org','2326','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42591','ʡ','http://www.hunan.gov.cn','2326','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42590','','http://www.lyxxc.cn','2326','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42589','--','http://www.tianya.cn/new/TianyaCity/ArticlesList_Culture.asp?idWriter=0&amp;Key=0&amp;idItem=56','2326','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42588','Ѻ--','http://club.travel.sohu.com/list_art_sub.php?b=hunan','2326','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42587','̳','http://bbs.hnol.net','2326','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42586','Ϻ̳','http://bbs.rednet.cn','2326','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42585','ϿƼѧ','http://www.hnust.edu.cn','2326','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42584','ʡԺ','http://www.hneao.edu.cn','2326','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42583','ϴѧ','http://www.hnu.cn','2326','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42582','ϴѧ','http://www.csu.edu.cn','2326','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42581','Ͻ','http://www.hnedu.cn','2326','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42580','','http://dzwsb.hnol.net','2326','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42579','潡','http://www.sxjk.com','2326','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42578','ɳʳ','http://eat.csonline.com.cn','2326','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42577','','http://www.gotohn.com','2326','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42576','ξ֣','http://www.hnt.gov.cn','2326','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42575','÷','http://www.haofz.com','2326','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42574','ѷ--ɳ','http://changsha.soufun.com','2326','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42573','51jobɳվ','http://www.51job.com/default-area.php?area=1902','2326','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42572','쵼˲','http://www.hnleader.gov.cn','2326','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42571','ɳ¾','http://www.crxx.com','2326','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42570','˲','http://www.hnrcsc.com','2326','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42569','ɳ˲','http://www.cshr.com.cn','2326','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42568','ϵ','http://hn.ct10000.com','2326','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42567','ͨ','http://www.hn.chinaunicom.com','2326','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42566','ƶ','http://www.hn.chinamobile.com','2326','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42565','º','http://www.hnxw.cn','2326','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42564','','http://www.hnetv.com','2326','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42367','ѧ','http://www.pku.edu.cn','2321','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42366','ҩƷල','http://www.bjda.gov.cn','2321','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42359','','http://www.bjlx.com','2321','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42360','Ҫ-ר','http://bbs.55bbs.com','2321','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42361','ҳ114','http://www.ziye114.com','2321','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42362','ЭҽԺ','http://www.pumch.ac.cn','2321','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42363','ͬҽԺ','http://www.trhos.com','2321','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42364','侯ҽԺ','http://www.wj-hospital.com','2321','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42365','ҩƷѯ','http://www.beijing.gov.cn/ggfw/jm/yljk/default.htm','2321','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42393','','http://tj.ct10000.com','2322','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42392','Ϻ','http://www.shmetro.com','2322','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42391','Ϻ','http://www.shanghaiairport.com','2322','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42390','Ϻнͨ','http://www.jt.sh.cn','2322','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42389','ͨ','http://www.tj.chinaunicom.com','2322','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42388','ƶ','http://www.tj.chinamobile.com','2322','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42387','򹫽','http://www.tjbus.com','2322','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42376','','http://www.yanwoo.cn','2321','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42377','','http://www.haott.com','2321','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42378','','http://www.online.tj.cn','2322','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42379','ձ','http://www.tianjindaily.com.cn','2322','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42380','֮','http://www.tianjin.gov.cn','2322','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42381','','http://www.jwb.com.cn','2322','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42382','Ӵ','http://tj.people.com.cn','2322','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42383','»Ƶ','http://www.tj.xinhuanet.com','2322','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42384','Ԥ','http://weather.tq121.com.cn/detail.php?city=%CC%EC%BD%F2','2322','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42385','ٶȵͼ','http://map.baidu.com/m?word=%CC%EC%BD%F2&amp;ct=10','2322','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42386','ǵͼ','http://maps.google.com/maps?f=q&amp;hl=zh-CN&amp;q=tianjin&amp;ie=UTF8&amp;ll=39.130001,117.199996&amp;spn=0.011918,0.026264&amp;t=h&amp;om=1','2322','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42401','зܾ','http://www.tjfdc.gov.cn','2322','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42400','߷','http://soufun.online.tj.cn','2322','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42399','ѷ','http://tj.soufun.com','2322','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42398','Ͷ','http://www.tj.lss.gov.cn','2322','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42397','˲','http://www.tjzhaopin.cn','2322','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42396','лӢվ','http://www.chinahr.com/tianjin','2322','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42394','˲','http://www.tjrc.com.cn','2322','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42395','Ƹ','http://job.enorth.com.cn','2322','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42600','Ӵ','http://www.gznet.com','2327','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42601','Ϸ','http://www.southcn.com','2327','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42602','֮','http://www.sz.net.cn','2327','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42603','','http://www.ycwb.com','2327','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42604','','http://www.dayoo.com','2327','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42605','','http://www.szol.net','2327','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42606','˹㶫վ','http://gd.sina.com.cn','2327','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42607','㶫ʡ','http://www.gd.gov.cn','2327','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42608','»㶫Ƶ','http://www.gd.xinhuanet.com','2327','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42609','Ϸҵ','http://www.nanfangdaily.com.cn/default.asp','2327','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42610','Ԥ','http://php.weather.sina.com.cn/search.php?city=','2327','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42611','ݹѯ','http://www.gz-bus.com/chaxun','2327','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42612','ݰƻ','http://www.baiyunairport.com','2327','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42613','άͼ','http://gz.o.cn','2327','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42614','㶫ƶ','http://www.gd.chinamobile.com','2327','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42615','㶫ͨ','http://info2.10010.com/lt/plugin/portal/arealevel/queryCityInfo.do?arno=00010004&amp;id=1677','2327','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42616','㶫','http://gd.ct10000.com','2327','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42617','㶫ͨ','http://www.crcgd.com','2327','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42618','㶫˲','http://www.gdrc.com','2327','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42619','ݸ','http://www.dg.gd.cn','2327','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42620','ϷӢ','http://www.job168.com','2327','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42621','лӢ㶫վ','http://guangzhou.chinahr.com','2327','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42622','ѷ-','http://gz.soufun.com','2327','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42623','˹㶫','http://gz.house.sina.com.cn','2327','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42624','21CN-','http://house.21cn.com','2327','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42625','˲','http://www.dgchr.com','2327','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42626','Ӵ-סڹ','http://house.gznet.com','2327','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42627','','http://www.visitgz.com','2327','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42628','ʳ','http://www.szeat.net','2327','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42629','ϷҽԺ','http://www.nfyy.com','2327','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42630','ʡչĸί','http://www.gddpc.gov.cn','2327','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42631','ʡóί','http://www.gdet.gov.cn/index.jsp','2327','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42632','ʡͶ','http://www.gd.lss.gov.cn','2327','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42633','ʡͨ','http://www.gdcd.gov.cn','2327','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42634','ʡ̾','http://www.gdgs.gov.cn','2327','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42635','麣Ϣ','http://www.zhuhai0756.com','2327','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42636','','http://www.514200.cn','2327','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42637','ƽ֮','http://www.rp1314.cn','2327','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42638','ݲżҽ','http://www.boya2004.com','2327','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42639','Ǯ-Żȯ','http://www.checkoo.com','2327','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42640','÷','http://www.mzw.com.cn','2327','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42641','۳-ۻƽ̨','http://www.juooo.com','2327','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42642','','http://www.szshequ.com','2327','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42643','п','http://www.nankesg.com','2327','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42644','ݸѯ','http://www.dg84.com','2327','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42645','꼯-ۿϢ','http://www.huliji.com','2327','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42646','ݹ԰վ','http://www.gykyz.com','2327','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42647','ݸŹ','http://www.dgtg.net','2327','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42648','Ĺ㶫','http://gd.tianya.cn','2327','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42649','','http://www.newgx.com.cn','2328','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42650','Ϲ籨','http://ngzb.gxnews.com.cn','2328','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42651','','http://www.gxi.gov.cn','2328','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42652','»Ƶ','http://www.gx.xinhuanet.com','2328','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42653','̨','http://www.gxtv.cn','2328','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42654','Ϣ','http://www.gx.cei.gov.cn','2328','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42655','','http://www.gx121.com','2328','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42656','','http://www.post.gx.cn','2328','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42657','ƶ','http://www.gx.chinamobile.com','2328','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42658','ͨ','http://info.10010.com/lt/plugin/portal/arealevel/queryCityInfo.do?arno=00010014&amp;id=2409','2328','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42659','','http://gx.ct10000.com','2328','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42660','ͨ','http://kf.cttgx.com/index.asp','2328','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42661','˲','http://www.gxrc.com','2328','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42662','','http://www.gxhouse.com','2328','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42663','Ϣ','http://www.gxfdc.com.cn','2328','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42664','','http://www.gxta.gov.cn','2328','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42665','¹Ƶ','http://travel.gxnews.com.cn','2328','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42666','','http://health.gxnews.com.cn','2328','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42667','ҽԺ','http://www.gxhospital.com','2328','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42668','ҽԺ','http://www.gxmzyy.com','2328','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42669','ѧ','http://www.gxu.edu.cn','2328','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42670','ѧ','http://www.gxun.edu.cn','2328','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42671','','http://www.gxem.cn','2328','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42672','','http://www.gxedu.gov.cn','2328','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42673','Ժ','http://www.gxeea.cn','2328','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42674','춹','http://hongdou.gxnews.com.cn','2328','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42675','','http://post.baidu.com/f?kw=%B9%E3%CE%F7','2328','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42676','ʱ̳','http://bbs.nnsky.com','2328','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42677','̳','http://bbs.guilinlife.com','2328','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42678','','http://post.baidu.com/f?kw=%C4%CF%C4%FE','2328','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42679','Ʊ','http://www.gxcaipiao.com.cn','2328','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42680','','http://tiyucaipiao.net/guangxi','2328','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42681','֤ȯڻг','http://www.sagx.org','2328','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42682','׳','http://www.gxzf.gov.cn','2328','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42683','չĸίԱ','http://www.gxdrc.gov.cn','2328','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42684','ƽ','http://www.gp136.com','2328','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42685','ɫַ','http://www.07760.cn','2328','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42686','','http://www.zuojiang.com','2328','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42687','','http://www.yulindayday.com','2328','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42688','ֶ','http://www.0775.cc','2328','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42689','','http://www.ylyl.net','2328','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42690','','http://www.hainan.net','2326','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42691','Ϻ','http://www.hinews.cn','2326','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42692','','http://www.tianya.net','2326','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42693','»Ƶ','http://www.hq.xinhuanet.com','2326','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42694','','http://www.tianya.cn','2326','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42695','','http://www.hnwtv.com','2326','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42696','ǳ','http://www.sycb.com.cn','2326','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42697','','http://www.hntqb.com','2326','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42698','Ӵ','http://hi.people.com.cn','2326','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42699','Ϲб','http://ngdsb.hinews.cn','2326','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42700','','http://mb.hainan.gov.cn','2326','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42701','Ϻչ˾','http://www.hnair.com','2326','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42702','ϵͼ','http://www.hnemap.com','2326','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42703','Ͻͨ','http://www.jt.hi.cn','2326','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42704','ٶȵͼ','http://map.baidu.com/#word=&amp;ct=10','2326','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42705','ٶȵͼ','http://map.baidu.com/#word=&amp;ct=10','2326','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42706','ƶ','http://www.hi.chinamobile.com','2326','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42707','ͨ','http://www.hi165.com','2326','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42708','ϵ','http://hi.ct10000.com','2326','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42709','ͨ','http://www.ctthi.com','2326','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42710','˲','http://job.hainan.net','2326','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42711','˲','http://www.0898job.com','2326','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42712','˲','http://www.sanyajob.com','2326','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42713','Ϻ˲Ƶ','http://job.hinews.cn','2326','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42714','߷Ƶ','http://house.hainan.net','2326','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42715','סլ뷿Ϣ','http://www.hkrealestate.gov.cn','2326','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42716','ǷزϢ','http://www.esanya.net','2326','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42717','ס','http://www.hngjj.net','2326','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42718','װƵ','http://home.hainan.net','2326','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42719','','http://www.hiholiday.com','2326','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42720','ϵȼ','http://www.tohainan.com','2326','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42721','','http://www.sanyatour.com','2326','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42722','ȵ','http://www.ww10000.com','2326','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42723','','http://city.hainan.net','2326','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42724','ϺʳƵ','http://food.hinews.cn','2326','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42725','߽','http://health.hainan.net','2326','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42726','Ϻҽҩ','http://120.hinews.cn','2326','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42727','ʡѪҺ','http://www.blood.org.cn','2326','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42728','ʡҽԺ','http://www.hizyy.com','2326','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42729','߽ѵ','http://edu.hainan.net','2326','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42730','ʡ','http://edu.hainan.gov.cn','2326','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42731','ϴѧ','http://www.hainu.edu.cn','2326','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42732','ְҵѧԺ','http://www.hcvt.cn','2326','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42733','Ĵ','http://www.scol.com.cn','2330','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42734','츮','http://www.tfol.com','2330','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42735','»ĴƵ','http://www.sc.xinhuanet.com','2330','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42736','Ĵ','http://www.newssc.org','2330','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42737','컢','http://www.tyfo.com','2330','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42738','йĴ','http://www.scsti.ac.cn','2330','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42739','Ĵƶ','http://www.sc.chinamobile.com','2330','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42740','Ĵ̨','http://www.sctv.com','2330','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42741','Ĵͨ','http://info2.10010.com/lt/plugin/portal/arealevel/queryCityInfo.do?arno=00010009&amp;id=3368','2330','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42742','ĴƵ','http://www.sc.chinanews.com.cn','2330','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42743','Ĵ','http://www.sctel.com.cn','2330','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42744','Ĵʡ','http://www.sc.gov.cn','2330','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42745','Ĵ','http://sc.sina.com.cn','2330','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42746','Ĵͨ','http://www.cttsc.com','2330','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42747','Ĵ˲','http://www.scrc168.com','2330','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42748','ĴϢ','http://www.scrs.gov.cn','2330','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42749','ɶ˲','http://www.rc114.com','2330','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42750','лӢ--ɶ','http://www.chinahr.com/chengdu','2330','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42751','Ĵ¿','http://www.scpta.gov.cn','2330','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42752','Ĵ߷','http://house.scol.com.cn','2330','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42753','ѷɶվ','http://cd.soufun.com','2330','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42754','Ĵز','http://www.scfdc.cn','2330','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42755','ɶܾ','http://www.cdfgj.gov.cn','2330','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42756','ɶס','http://www.cdzfgjj.gov.cn','2330','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42757','ĴϢ','http://www.scta.gov.cn','2330','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42758','Ĵ̳','http://www.travelbbs.com','2330','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42759','Ĵʳ','http://cdcd.scol.com.cn','2330','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42760','»Ĵʳ','http://www.sc.xinhuanet.com/service/food','2330','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42761','ɶԺ','http://www.hxfoods.com','2330','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42762','ĴѧҽԺ','http://www.cd120.com','2330','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42763','ĴʡҽԺ','http://www.samsph.com','2330','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42764','Ĵ','http://www.scedu.net','2330','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42765','Ĵѧ','http://www.scu.edu.cn','2330','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42766','Ĵʦѧ','http://www.sicnu.edu.cn','2330','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42767','Ĵ̳','http://bbs.scol.com.cn','2330','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42768','ػ','http://bbs.zg163.net','2330','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42769','','http://bbs.newssc.org','2330','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42770','ѳɶ-Ԥҵİ뾶','http://www.028114.com','2330','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42771','ɶҽ','http://www.cdjj.com','2330','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42772','γ','http://www.beiww.com','2330','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42773','','http://www.buyzhe.cn','2330','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42774','ѧ˽-ɽ̼ҽ','http://www.xuegle.com','2330','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42775','Ϣ','http://www.gz163.cn','2331','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42776','ݵ̨','http://www.gzstv.com','2331','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42777','й','http://www.chinaguizhou.gov.cn','2331','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42778','ʡ','http://www.gzgov.gov.cn','2331','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42779','','http://www.gzqx.gov.cn','2331','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42780','','http://www.gz-travel.net','2331','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42781','˲Ϣ','http://www.gzrc.gov.cn','2331','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42782','ѷվ','http://gy.soufun.com','2331','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42783','','http://webar.silversand.net/list.php?Province2=','2331','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42784','Ϣ','http://www.gz163.cn','2331','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42785','ݵ̨','http://www.gzstv.com','2331','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42786','й','http://www.chinaguizhou.gov.cn','2331','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42787','ʡ','http://www.gzgov.gov.cn','2331','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42788','','http://www.gzqx.gov.cn','2331','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42789','','http://www.gz-travel.net','2331','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42790','˲Ϣ','http://www.gzrc.gov.cn','2331','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42791','ѷվ','http://gy.soufun.com','2331','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42792','','http://webar.silversand.net/list.php?Province2=','2331','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42793','','http://www.yunnan.cn','2332','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42794','ϵ','http://www.yntv.cn','2332','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42795','ձ','http://www.yndaily.com','2332','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42796','㲥̨','http://www.ynrmgbdt.cn','2332','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42797','Ϣ','http://www.ynxxb.com','2332','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42798','','http://www.yn.chinanews.com.cn','2332','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42799','','http://www.chntt.com','2332','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42800','ϻ','http://www.ynairport.com','2332','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42801','˲г','http://www.ynhr.com','2332','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42802','Ƹ','http://www.ynzp.cn','2332','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42803','˲','http://www.yunnanrc.com','2332','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42804','Ͷ','http://www.ynl.gov.cn','2332','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42805','˲','http://www.ynrs.gov.cn','2332','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42806','Ϣ۷','http://house.yninfo.com','2332','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42807','','http://www.traveloyunnan.com.cn','2332','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42808','Ļ','http://www.ynmw.org','2332','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42809','Ƶ','http://tour.yunnan.cn','2332','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42810','ձƵ','http://www.yndaily.com/ihtml/yndaily/TXTP_LY.html','2332','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42811','ʳ','http://www.yncate.com','2332','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42812','ҽƱ','http://www.ynyb.org.cn','2332','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42813','ʡҽԺ','http://www.yn-tcm-hospital.com','2332','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42814','ƴҽԺ','http://www.ydyy.cn','2332','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42815','ʡ','http://www.ynjy.cn','2332','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42816','ʡпƵ','http://www.ynzs.cn','2332','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42817','Կ','http://www.ynzk.com','2332','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42818','ѧ','http://www.ynni.edu.cn','2332','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42819','ϴѧ','http://www.ynu.edu.cn','2332','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42820','ϲƱ','http://www.xinancaipiao.com','2332','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42821','','http://www.ynticai.cn','2332','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42822','֮','http://club.yninfo.com','2332','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42823','Ϣ۽','http://love.yninfo.com','2332','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42824','ʡ','http://www.yn.gov.cn','2332','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42825','Ϸί','http://www.yndpc.yn.gov.cn','2332','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42826','ʡԺ','http://www.gy.yn.gov.cn','2332','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42827','˫','http://www.12bn.net','2332','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42828','ų','http://www.xaonline.com','2333','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42829','߷羰','http://www.sncrc.com','2333','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42830','Ӵ','http://unn.people.com.cn/GB/14793/index.html','2333','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42831','»Ƶ','http://www.sn.xinhuanet.com','2333','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42832','','http://www.c029.com','2333','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42833','Ϣ','http://www.sxmb.gov.cn','2333','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42834','ѯ','http://www1.xbus.cn','2333','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42835','ͼ','http://www.shaanxi.cn/sx_into/sxmap/index.htm','2333','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42836','Ʊ','http://www.xian-airport.com','2333','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42837','ƶ','http://www.sn.chinamobile.com','2333','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42838','ͨ','http://info2.10010.com/lt/plugin/portal/arealevel/queryCityInfo.do?arno=00010015&amp;id=2533','2333','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42839','','http://sn.ct10000.com','2333','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42840','ͨ','http://www.cttsn.com','2333','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42841','˲','http://www.sxrcw.net','2333','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42842','й˲','http://www.xajob.com','2333','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42843','ط','http://www.3qhouse.com','2333','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42844','վ̨(ⷿ)','http://xa.zhantai.com','2333','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42845','زϢ','http://www.800j.com.cn','2333','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42846','','http://www.xafgj.gov.cn','2333','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42847','ѷ','http://xian.soufun.com','2333','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42848','','http://www.sxtour.com','2333','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42849','ʷ','http://www.sxhm.com','2333','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42850','ʼʱٸ','http://www.bmy.com.cn','2333','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42851','','http://www.hqc.cn','2333','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42852','ξ','http://www.xian-tourism.com','2333','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42853','','http://www.sxtour.com','2333','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42854','۸Ϣ','http://www.spic.gov.cn','2333','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42855','','http://www.sxhealth.gov.cn','2333','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42856','ʡҽԺ','http://www.spph-sx.com','2333','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42857','114Ź','http://www.114tgw.com','2333','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42858','','http://www.snedu.com.cn','2333','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42859','Ϣ','http://www.snedu.gov.cn','2333','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42860','Ϣ','http://www.sneac.com','2333','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42861','ųǲ','http://forum.xaonline.com','2333','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42862','Ѷ̳','http://xian.qq.com/bbs/bbs.htm','2333','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42863','Ѻ̳','http://club.city.travel.sohu.com/l-shan_xi-0-0-0-0.html','2333','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42864','','http://bbs.city.tianya.cn/new/TianyaCity/ArticlesList_Culture.asp?idWriter=0&amp;Key=0&amp;idItem=60','2333','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42865','߿ռ̳','http://bbs.longcity.net','2333','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42866','ɸƱ','http://www.sxfc.gov.cn','2333','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42867','','http://www.sxtc.com.cn','2333','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42868','֤ȯ','http://www.sei.gov.cn/ShowClass32008.ASP?ClassID=27','2333','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42869','Դ֤ȯ','http://www.sxkyzq.com','2333','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42870','ʡ','http://www.shaanxi.gov.cn','2333','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42871','','http://www.xa.gov.cn','2333','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42872','й','http://www.xianyang.gov.cn','2333','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42873','-','http://www.xianwo.com','2333','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42874','ÿո','http://www.gansudaily.com.cn','2334','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42875','ʱ','http://www.westcn.com','2334','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42876','»Ƶ','http://www.gs.xinhua.org','2334','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42877','Ӵ','http://gs.people.com.cn','2334','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42878','','http://www.gansunet.com','2334','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42879','̱','http://www.xbsb.com.cn','2334','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42880','ʡ','http://www.gsma.gov.cn','2334','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42881','ݹ','http://www.lzbus.com','2334','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42882','ٶȵͼ','http://map.baidu.com/#word=&amp;ct=10','2334','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42883','гʱ̲ѯ','http://huoche.kuxun.cn/','2334','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42884','ƶ','http://www.gs.chinamobile.com','2334','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42885','ͨ','http://www.gs.chinaunicom.com','2334','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42886','','http://www.gansutelecom.com','2334','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42887','ʡ','http://www.gansu.gov.cn','2334','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42888','˲','http://www.xbrc.gov.cn','2334','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42889','Ȫ˲','http://www.jqrc.net','2334','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42890','','http://www.rst.gansu.gov.cn','2334','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42891','ʷ','http://www.gshouse.com.cn','2334','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42892','ÿո෿Ƶ','http://house.gansudaily.com.cn','2334','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42893','ס','http://www.lzgjj.com','2334','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42894','ݷز','http://www.bona.net.cn','2334','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42895','װ','http://www.gsjzw.cn','2334','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42896','ÿոʳ','http://eat.gansudaily.com.cn','2334','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42897','ÿոƵ','http://tour.gansudaily.com.cn','2334','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42898','Ȫ','http://www.jqta.com','2334','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42899','ػ','http://www.dunhuangtour.com','2334','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42900','ξ','http://www.huanghetour.com/default.asp','2334','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42901','ʡ','http://www.gsws.gov.cn','2334','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42902','ҽƷ','http://www.gsylfw.com','2334','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42903','ҽԺַ绰','http://www.jklife.cn/c124.shtml','2334','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42904','ʡҽԺ','http://www.gsyy.cn','2334','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42905','ѯ','http://www.gssedu.cn','2334','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42906','ʡ칫','http://www.gszs.edu.cn','2334','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42907','ʡͼ','http://www.gslib.com.cn','2334','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42908','ݴѧ','http://www.lzu.edu.cn','2334','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42909','ʦѧ','http://www.nwnu.edu.cn','2334','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42910','ÿո̳','http://bbs.gansudaily.com.cn','2334','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42911','ร','http://www.fulicaipiao.cn/gansu','2334','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42912','','http://tiyucaipiao.net/gansu','2334','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42913','๤','http://www.gsaic.gov.cn','2334','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42914','ʡί','http://www.gspc.gov.cn','2334','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42915','315άȨ','http://www.gs315.org.cn','2334','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42916','ͨμ˼','http://www.tongweirenjia.com','2334','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42917','ξӴ','http://www.0937.net','2334','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42918','Ϣ','http://www.nx.cninfo.net','2335','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42919','','http://www.nxnews.net','2335','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42920','ձ','http://www.nxnet.net','2335','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42921','»Ƶ','http://www.nx.xinhuanet.com','2335','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42922','Ӵ','http://nx.people.com.cn','2335','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42923','Ϣ','http://www.qx121.com.cn','2335','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42924','ٶȵͼ','http://map.baidu.com/#word=&amp;ct=10','2335','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42925','Ĺ','http://www.ngsh.gov.cn','2335','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42926','ѯ','http://www.nxnews.net/fuwu/hangban.htm','2335','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42927','Ļǿ','http://nx.vnet.cn','2335','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42928','ƶ','http://www.nx.chinamobile.com','2335','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42929','ͨ','http://info.10010.com/lt/plugin/portal/arealevel/queryCityInfo.do?arno=00010028&amp;id=2382','2335','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42930','ĵ','http://www.nxtelecom.com.cn','2335','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42931','ͨ','http://www.cttnx.com','2335','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42932','˲','http://www.nxrc.com.cn','2335','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42933','ıҵҵϢ','http://www.nxbys.com','2335','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42934','Ӣ','http://www.0951job.com','2335','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42935','ķѶ','http://www.nxf.cn','2335','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42936','','http://www.ychfc.com','2335','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42937','з','http://www.ycre.gov.cn','2335','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42938','ס','http://www.ycgjj.com.cn','2335','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42939','Ƶ','http://www.nxnews.net/travel','2335','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42940','ķ','http://tour.yc.nx.cn','2335','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42941','','http://www.nxta.gov.cn','2335','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42942','','http://www.nxta.gov.cn','2335','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42943','Ϣʳ','http://soofan.yc.nx.cn','2335','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42944','ʳ','http://www.nxeat.com','2335','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42945','ʳ','http://www.0951cate.com','2335','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42946','Ƶ','http://www.nxnews.net/health','2335','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42947','','http://www.nxws.gov.cn','2335','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42948','ҽѧԺҽԺ','http://nyfy.com.cn','2335','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42949','Ľ','http://www.nxycedu.com','2335','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42950','¿','http://www.nxpta.gov.cn','2335','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42951','ĽԺ','http://www.nxks.nx.edu.cn','2335','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42952','̳','http://bbs.nxnet.cn','2335','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42953','','http://bbs.nxnews.net/forum','2335','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42954','ĸƱ','http://www.nxflcp.com','2335','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42955','','http://lottery.yc.nx.cn','2335','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42956','ְԤ','http://www.nx.yfw.com.cn','2335','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42957','Ļ','http://www.nx.gov.cn','2335','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42958','','http://www.yinchuan.gov.cn/yczw','2335','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42959','³','http://www.sd.cninfo.net','2336','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42960','ɽ','http://www.sdnews.com.cn','2336','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42961','ɽʡʡϿ','http://www.infobase.gov.cn','2336','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42962','»ɽƵ','http://www.sd.xinhuanet.com','2336','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42963','-ɽӴ','http://sd.people.com.cn','2336','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42964','ɽ','http://www.sdqx.gov.cn','2336','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42965','Ϲ','http://www.jnbus.com.cn','2336','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42966','гʱ̲ѯ','http://huoche.kuxun.cn/','2336','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42967','ɽռ','http://www.shandongair.com.cn','2336','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42968','Ͻ','http://www.jnjj.com','2336','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42969','ɽƶ','http://www.sd.chinamobile.com','2336','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42970','ɽͨ','http://info.10010.com/lt/plugin/portal/arealevel/queryCityInfo.do?arno=00010016&amp;id=2651','2336','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42971','ɽ','http://www.sdtele.com','2336','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42972','ɽͨ','http://www.cttsd.com','2336','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42973','ɽ˲','http://www.sdrc.com.cn','2336','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42974','ɽϢ','http://www.sdrs.gov.cn','2336','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42975','лӢ-','http://www.chinahr.com/jinan','2336','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42976','51jobվ','http://www.51job.com/default-area.php?area=1202','2336','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42977','ɽ','http://www.sdpost.com.cn','2336','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42978','³߷','http://sdfdc.sdinfo.net','2336','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42979','Ϸ','http://www.jnhouse.com','2336','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42980','ൺ','http://www.house.sd.cn','2336','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('42981','ס','http://www.gjj.gov.cn','2336','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45383','17kС˵','http://www.17k.com/','645','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45382','ԭ','http://www.4yt.net/','645','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45381','ý','http://html.hjsm.tom.com/','645','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45380','¸С˵','http://www.mingyuege.com/','645','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45375','С˵','http://www.xs8.cn/','645','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45376','С˵Ķ','http://www.readnovel.com/','645','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('44','ԭӢС˵','http://www.en8848.com','1045','22','0','0','0','0','0','5423','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('35443','ຣ˲','http://www.qhrc.com.cn/qh/','1521','10','0','0','0','0','0','376','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('71','Ѻ','http://club.book.sohu.com','647','7','0','0','0','0','1','943','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('74','˶̳','http://bbs.book.sina.com.cn/group.php?tree=0&gid=2','647','8','0','0','0','0','0','917','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('75','̳','http://bbs.hongxiu.com/','647','9','0','0','0','0','0','0','0','','admin','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('38275','˲г','http://www.0577rc.com','1528','51','0','0','0','0','0','1198','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('82','ٶС˵','http://post.baidu.com/f?kw=С˵','647','11','0','0','0','1','9','1448','0','','','1','0','0','0','','0');
INSERT INTO yowao_site VALUES('45421','̳','http://bbs.hongxiu.com/','2378','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45422','Ҳ֪̳','http://bbs.wbzd.net/','2378','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45436','ESPNSTAR','http://www.espnstar.com.cn/new/default.htm','928','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45420','-Ūī','http://cache.tianya.cn/publicforum/articleslist/0/culture.shtml','2378','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45416','˶̳','http://book.sina.com.cn/bbs/','2378','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45417','-Ѻ','http://club.book.sohu.com/','2378','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45418','-','http://www.douban.com/book/','2378','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45419','С˵Ķ̳','http://bbs.readnovel.com/','2378','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46995','й','http://bbs.bag.org.cn','2298','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46994','eBags','http://www.ebags.com','2298','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46993','л','http://www.chinabag.com.cn','2298','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46226','','http://www.xiuhome.com/','879','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('15347','ɽ˲г','http://www.sxjobs.cn/','1546','3','0','0','0','0','0','1210','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('15345','Ȫ˲','http://www.yqrsj.gov.cn/','1546','11','0','0','0','0','0','48','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('15344','ͬ˲','http://www.dtrcsc.com/','1546','13','0','0','0','0','0','266','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('15343','̫ԭƸϢ','http://www.tyzhaopin.cn/','1546','5','0','0','0','0','0','870','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('15342','̫ԭְҵܷ','http://www.tylm.com.cn/','1546','6','0','0','0','0','0','460','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('15341','̫ԭ˲Ϣ','http://www.tyrsj.gov.cn/','1546','4','0','0','0','0','0','724','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('15340','̫ԭ˲','http://www.ctpjob.com/','1546','8','0','0','0','0','0','468','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('15337','ɽ˲','http://www.sxsrs.gov.cn/','1546','1','0','0','0','0','0','534','0','','yowao','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('15336','ʯɽͶҵ','http://www.nxsjy.com.cn/','1536','13','0','0','0','0','0','75','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('15335','ʯɽ˲','http://www.szsrsrc.com/','1536','12','0','0','0','0','0','178','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('144','','http://photo.163.com','653','1','0','0','1','2','11','63471','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('145','QQ','http://photo.qq.com','653','3','0','0','0','1','6','9665','0','','','1','0','0','0','','0');
INSERT INTO yowao_site VALUES('38903','Ƭ','http://www.photops.com/','2121','12','0','0','0','0','3','40658','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45941','ɶԤ','http://www.weather.com.cn/html/weather/101270101.shtml','2286','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('38907','Ӱ','http://www.photofans.cn/forum.php','2122','1','0','0','0','0','0','12755','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45755','쾲ٵĲ','http://blog.sina.com.cn/xujinglei','825','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('15607','','http://www.btv.org/','1362','100','0','0','0','0','0','62','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45487','GettyImages','http://www.gettyimages.cn/','709','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('15587','Google Reader','http://www.google.com/reader/view/','670','1','0','0','0','0','0','192','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('15574','Ѷ','http://blog.hexun.com/','669','21','0','0','0','0','0','4949','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('15568','ٶȿռ','http://hi.baidu.com/','669','4','0','0','11','62','511','34588','0','','','14','12','0','0','','0');
INSERT INTO yowao_site VALUES('36683','ຣҽְҵѧԺ','http://www.qhxmzy.com.cn/','1317','9','0','0','0','0','0','37','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45480','ͼ','http://pic.daqi.com/','709','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45481','ͼ̳','http://bbs.voc.com.cn/forumdisplay.php?fid=4','709','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45482','̫ƽӰ','http://digital.pconline.com.cn/photo/','709','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46646','ٶȱֽ','http://www.baidu.com/search/image_wallpaper.html','711','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45663','','http://www.renren.com/','675','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('35069','ڿͶ','http://www.hack58.com/','1139','1','0','0','0','0','0','7906','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('247','Ѻ','http://yule.sohu.com','659','5','0','0','0','2','8','131097','0','','','0','2','0','0','','0');
INSERT INTO yowao_site VALUES('248','','http://ent.163.com','659','7','0','0','0','1','4','74931','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('249','TOM','http://ent.tom.com','659','2','0','0','1','8','41','138638','0','','','3','3','0','0','','0');
INSERT INTO yowao_site VALUES('251','21CN','http://et.21cn.com','659','13','0','0','0','0','0','45446','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('258','Ϸ','http://www.southcn.com/ent','659','14','0','0','0','1','1','20945','0','','','1','0','0','0','','0');
INSERT INTO yowao_site VALUES('41354','','http://www.qqok.net','659','12','0','0','0','0','0','0','0','','.','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('275','Ӱ','http://ent.sina.com.cn','659','1','0','0','2','10','58','368607','0','','admin','2','3','0','0','','0');
INSERT INTO yowao_site VALUES('45918','й̨','http://www.csndmc.ac.cn/','2285','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('28168','Acosta','http://blog.sina.com.cn/u/1456252804','1924','1','0','0','0','0','0','818','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('28167','ٱСֵBLOG','http://blog.sina.com.cn/m/xiaopangblog','1924','2','0','0','0','0','0','1996','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('28166','ֺ','http://blog.sina.com.cn/m/housheboy','1924','3','0','0','0','0','0','2507','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('28165','ͷ','http://blog.sina.com.cn/m/huge','1924','4','0','0','0','0','0','806','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('28164','õBLOG','http://blog.sina.com.cn/m/gjmm','1924','16','0','0','0','0','1','4573','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('28163','BLOG','http://blog.sina.com.cn/m/dingbeili','1924','15','0','0','0','0','0','813','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('28162','⴫','http://blog.sina.com.cn/m/ningcaishen','1924','12','0','0','0','0','0','1396','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('28161','ֻƽ','http://blog.sina.com.cn/huangjianxiang','1924','5','0','0','0','0','0','1644','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('28160','ڵٷվ','http://www.yudan.net.cn/','1923','23','0','0','0','0','0','673','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('293','39԰','http://sex.39.net/','663','1','0','0','3','11','112','395958','0','','','5','3','0','0','','0');
INSERT INTO yowao_site VALUES('45245','й̳','http://bbs.guitarchina.com/','717','9','0','0','0','0','0','0','0','','yowao','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46353','ͥҽ','http://www.familydoctor.com.cn/','864','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46480','39Ů','http://woman.39.net/','664','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46479','ѺŮ','http://women.sohu.com/','664','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46478','TOM','http://she.tom.com/','664','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46522','̫ƽŮ','http://beauty.pclady.com.cn/','665','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46521','Ѻ','http://women.sohu.com/77/50/column203575077.shtml','665','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('39550','С','http://digi.beareyes.com.cn/','796','14','0','0','0','0','0','1209','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('34370','Ż','http://xk.cn.yahoo.com/digi/index.html','796','8','0','0','0','0','0','3739','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('429','˲','http://blog.sina.com.cn','669','3','0','0','0','0','0','22686','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('433','Ѻ','http://blog.sohu.com','669','6','0','0','0','0','4','28353','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('436','','http://www.bokee.com','669','9','0','0','0','0','1','33110','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('15570','й˲','http://blog.edu.cn/index.html','669','15','0','0','0','0','0','4571','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('442','','http://www.blog.com.cn','669','23','0','0','0','0','3','21061','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46694','9158Ƶ','http://vv.9158.com/','2044','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('460','Google','http://blogsearch.google.cn/','835','21','0','0','0','0','0','3163','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('23293','л԰','http://www.emuseum.org.cn/','1797','100','0','0','0','0','0','2887','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('28478','ʹ','http://www.xianguo.com/','670','2','0','0','0','0','0','1564','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('28471','ɵ','http://www.feedsky.com/','670','6','0','0','0','0','0','411','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('34774','ٶȲ','http://blogsearch.baidu.com/','835','22','0','0','0','0','0','31','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('35685','ٶѲ','http://cang.baidu.com/','673','7','0','0','0','0','1','1510','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('483','ժ','http://www.huzhai.com','673','3','0','0','0','0','0','3705','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('15608','˳̨','http://www.bjsytv.com/','1362','100','0','0','0','0','0','614','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('485','Ѷժ','http://bookmark.hexun.com','673','4','0','0','0','0','0','2310','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('489','Pocoժ','http://share.poco.cn','673','1','0','0','0','2','3','4311','0','','','1','0','0','0','','0');
INSERT INTO yowao_site VALUES('38887','ViViղؼ','http://vivi.sina.com.cn/','673','9','0','0','0','0','0','1230','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45695','Ȧ','http://www.niwota.com/','792','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45694','ͬ¥','http://www.tonglou.com.cn/','792','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45685','ǳ','http://fcwr.jstv.com/','790','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45684','','http://www.loveinhere.com/','790','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45670','5460ͬѧ¼','http://www.5460.net/','675','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45669','֪ѧ̳','http://www.hao123.com/college_bbs.htm','675','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('32640','Ħֻ̳','http://www.motobbs.com/','690','8','0','0','0','0','0','40','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45668','΢','http://t.sina.com.cn/','675','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45656','ͬ','http://www.xici.net/','675','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45655','̳','http://bbs.ifeng.com/','675','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45654','ǿ̳','http://bbs.people.com.cn/','675','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('518','Csdn','http://community.csdn.net','678','3','0','0','0','0','0','435','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45667','ٶȿռ','http://hi.baidu.com/','675','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('32244','Ĳ','http://blog.tianya.cn/','669','17','0','0','0','0','9','25270','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('521','ȷ̳','http://bbs.dvbbs.net','678','19','0','0','0','0','0','468','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45653','»̳','http://forum.home.news.cn/','675','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('526','̳','http://bbs.54master.com/','678','23','0','0','0','0','0','391','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('36439','ǭ','http://www.qxn.gov.cn/','1861','9','0','0','0','0','0','115','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45666','ChinaRen','http://www.chinaren.com/','675','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45665','Ѷ','http://www.pengyou.com/','675','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('545','̳','http://bbs.powereasy.net/','678','20','0','0','0','0','0','564','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('549','ˮľ','http://www.newsmth.net','2078','18','0','0','0','0','0','13','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('552','Ϻˮ˼ԴBBS','http://bbs.sjtu.edu.cn','2078','5','0','0','0','0','0','482','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('553','ɽѧ̳','http://bbs.yunjian.com','2078','54','0','0','0','0','0','177','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('554','Ϻѧbbs','http://bbs.shangda.net/','2078','53','0','0','0','0','0','465','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('555','人ѧɽˮBBS','http://bbs.whu.edu.cn','2078','11','0','0','0','0','0','522','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('556','ѧ¹⻪','http://bbs.fudan.edu.cn','2078','8','0','0','0','0','0','723','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('557','ϾѧСٺBBS','http://bbs.nju.edu.cn/','2078','4','0','0','0','0','0','550','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('558','йMBAhome̳','http://bbs.mbahome.com','2078','56','0','0','0','0','0','87','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('560','ˮľ廪BBS','http://www.smth.edu.cn','2078','1','0','0','0','0','2','6010','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('561','ϾѧԺ-ǻ̳','http://xhbbs.njit.edu.cn/','2078','49','0','0','0','0','0','125','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('562','Ŵѧ','http://bbs.xmu.edu.cn','2078','50','0','0','0','0','0','463','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('564','ѧ̳','http://www.gzubbs.com','2078','55','0','0','0','0','0','231','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('565','ѧԺ̳','http://www.yndxs.com/site/swfc.html','2078','51','0','0','0','0','0','101','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('566','̺վ','http://bbs.dlut.edu.cn','2078','23','0','0','0','0','0','196','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('567','ͬôѧBBSͬ۹','http://bbs.tongji.edu.cn/','2078','9','0','0','0','0','0','289','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('569','㽭ҵѧ̳','http://www.zjut.com.cn','2078','47','0','0','0','0','0','253','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('572','ڴѧ԰վ','http://bbs.szu.edu.cn','2078','46','0','0','0','0','0','235','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('573','ѧɽˮվ','http://bbs.neu.com.cn/','2078','52','0','0','0','0','0','131','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('574','Ͻɺվ','http://bbs.njupt.edu.cn','2078','16','0','0','0','0','0','82','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('576','ӱѧBBS','http://bbs.hbu.edu.cn','2078','41','0','0','0','0','0','163','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('577','ľBBS','http://bbs.gznet.edu.cn','2078','2','0','0','0','0','0','702','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('580','йѧԺ','http://www.cjlu.com/bbs/index.asp','2078','45','0','0','0','0','0','116','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('584','¶վ','http://bupt.org/wForum','2078','15','0','0','0','0','0','124','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('585','Ϲҵѧ̳','http://www.hngdbbs.com/bbs/index.php','2078','44','0','0','0','0','0','125','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('32621','ɽѧʱBBS','http://bbs.zsu.edu.cn/','2078','19','0','0','0','0','0','411','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('588','ũ̳','http://www.cau-edu.net.cn/bbs/','2078','48','0','0','0','0','0','100','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('593','Ա̳','http://bbs.shudoo.com/','678','22','0','0','0','0','0','11','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('594','ٶ','http://post.baidu.com/f?kw=','678','26','0','0','0','0','0','351','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('28734','Ӱ̳','http://bbs.greendown.cn/index.php','678','27','0','0','0','0','0','640','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('600','񷴲','http://forum.jiangmin.com','680','1','0','0','0','0','0','6','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('602','Ѻȫ̳','http://bbs.club.sohu.com/main.php?b=hack','680','3','0','0','0','0','0','6','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('607','Ѻר','http://it.sohu.com/90/71/column203667190.shtml','680','6','0','0','0','0','0','257','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('36438','ǭ','http://www.qdn.gov.cn/','1861','8','0','0','0','0','0','329','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('611','ٶȲ','http://post.baidu.com/f?kw=&#30149;&#27602;','680','8','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('612','IT168̳','http://bbs.it168.com','681','8','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('613','С̳','http://bbs.beareyes.com.cn/','681','7','0','0','0','0','0','8','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('32592','̫ƽƷ̳','http://itbbs.pconline.com.cn/','681','5','0','0','0','0','0','571','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('32590','eNetӲ̳','http://diybbs.enet.com.cn/','681','3','0','0','0','0','0','467','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('621','ӲDIY̳','http://diybbs.it168.com/','681','1','0','0','0','0','0','42','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('32589','йش̳','http://bbs.zol.com.cn/','681','4','0','0','0','0','0','25','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('38334','ѧְ','http://www.fillsky.com','1531','8','0','0','0','0','0','379','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('666','-','http://ent.163.com/picture','684','2','0','0','0','10','53','3945','0','','','6','3','0','0','','0');
INSERT INTO yowao_site VALUES('673','ͼ-һ','http://www.oneyule.com/tupian','684','3','0','0','0','0','0','2310','0','','admin','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('674','̳ͼ-TOM̳','http://pic.bbs.tom.com/','684','4','0','0','0','0','1','7769','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46008','Ӫʳ','http://keko.chihe.sohu.com/','2291','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45983','Googleͼ','http://ditu.google.cn/','2290','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('684','԰','http://www.tianya.cn/new/TechForum/ArticlesList.asp?idWriter=0&Key=0&idItem=14','685','9','0','0','0','0','0','879','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45984','ʱ̱','http://qiche.cncn.com/','2290','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('687','Ц̳','http://people.sina.com.cn/forum/xiaohua2.html','685','2','0','0','0','0','0','1700','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('688','sohuЦ','http://club.sohu.com/main.php?b=joke','685','11','0','0','0','1','2','268','0','','','0','1','0','0','','0');
INSERT INTO yowao_site VALUES('689','','http://www.51haha.net/club/','685','5','0','0','0','0','0','1191','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('690','21cnЦֹ','http://free.21cn.com/newbbs/mainframe.jsp?url=/forum/bbsThreadList.act?bbsForumId=56','685','12','0','0','0','0','0','578','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('691','ٶЦ','http://post.baidu.com/f?kw=Ц','685','1','0','0','0','2','19','1094','0','','','1','1','0','0','','0');
INSERT INTO yowao_site VALUES('693','SoGua̳','http://bbs.sogua.com','686','2','0','0','0','0','0','542','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('694','̳','http://www.hebeimusic.com','686','12','0','0','0','0','0','1204','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('36379','ɽ','http://www.zs.gov.cn/','1856','9','0','0','0','0','0','779','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('705','й̳','http://bbs.guitarchina.com','686','16','0','0','0','0','0','851','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('15333','Ϣ','http://www.zgycrs.com.cn/','1536','10','0','0','0','0','0','129','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('15332','Ӣ','http://www.0951job.com/','1536','4','0','0','0','0','0','20','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('35460','ԭ','http://www.wzjobs.cn/html/13582.html','1536','14','0','0','0','0','0','48','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('15329','˲','http://www.zyrc.net/','1540','13','0','0','0','0','0','487','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('15328','˲Ϣ','http://www.gzrc.gov.cn/','1540','2','0','0','0','0','0','3','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('15327','˲','http://www.gzrs.gov.cn/','1540','1','0','0','0','0','0','1522','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('15326','й˲','http://www.gyrc.com.cn/','1540','9','0','0','0','0','0','1833','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('15325','ͨ˲г','http://thrc.th163.jl.cn/','1542','15','0','0','0','0','0','109','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('15324','˲','http://www.ccrc.com.cn/','1542','10','0','0','0','0','0','3','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('15323','˲','http://www.cctalent.com/','1542','12','0','0','0','0','0','515','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('15322','˲г','http://www.jlsrc.com/','1542','5','0','0','0','0','0','597','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('15321','˲','http://www.rczx.com/','1542','4','0','0','0','0','0','278','0','','yowao','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('15319','˲','http://www.jlrc.com.cn/','1542','3','0','0','0','0','0','491','0','','yowao','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('15313','˲','http://www.gz91.com/','1530','8','0','0','0','0','0','900','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('15311','˲','http://www.jiangxirc.com/','1530','1','0','0','0','0','0','2980','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('15310','','http://www.jxrenshi.gov.cn/','1530','3','0','0','0','0','0','71','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('15309','˲','http://www.jxrencai.com/','1530','2','0','0','0','0','0','232','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('746','IT168̳','http://bbs.it168.com','689','5','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('747','׵òƷ̳','http://bbs.soit.com.cn','689','6','0','0','0','0','0','155','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('755','ֻ̳-ֻ֮','http://bbs.imobile.com.cn','690','1','0','0','0','0','0','2','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('762','ֻ','http://club.joyes.com','690','14','0','0','0','0','0','171','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('763','ֻ̳-Ѻ̳','http://it.sohu.com/94/83/column204948394.shtml','690','4','0','0','0','0','0','452','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('766','ֻ̳-˿Ƽ','http://tech.sina.com.cn/mobile/forum.html','690','5','0','0','0','0','0','324','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('767','л̳','http://bbs.military.china.com','691','2','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('768','Ѫ̳','http://bbs.tiexue.net','691','1','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('769','»̳','http://forum.xinhuanet.com/','691','3','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('771','̳','http://bbs.news.sina.com.cn/group.php?tree=0&gid=1','691','5','0','0','0','0','1','2065','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('773','й','http://www.chinamil.com.cn/site1/gwgfsq/index.htm','691','6','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('32717','̳-Ż̳','http://cn.bbs.yahoo.com/forum/read_-c3RvY2sx_.html','693','10','0','0','0','0','0','556','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('32719','Ѷ̳','http://bbs.wayup.hexun.com/','693','2','0','0','0','0','0','1355','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('795','MACDм̳','http://bbs.macd.cn','693','4','0','0','0','0','0','66','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('796','̸۽','http://bbs.finance.sina.com.cn/tableforum/App/index.php?bbsid=62&subid=0','693','6','0','0','0','0','0','1571','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('797','ݺƾ̳','http://www.enoya.com','693','21','0','0','0','0','0','579','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('29048','лװ̳','http://bbs.51fashion.com/','1935','1','0','0','0','0','1','1209','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('29047','ʱзװ̳','http://bbs.nzn.cn/','1935','2','0','0','0','0','0','2187','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45966','Ԥ','http://www.chatianqi.com/','2288','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45965','ƶѲѯ','http://www.chinamobile.com/service/billservice/','2288','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('29041','йŮʱ̳','http://www.mflady.com/bbs/index.php','1935','10','0','0','0','0','0','815','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45469','Ѻ','http://sports.sohu.com/lanqiu.shtml','2116','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45470','Ь̳','http://bbs.x-kicks.com/','2116','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('33508','BTchina','http://www.btchina.net/','1113','1','0','0','0','0','0','486','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('33505','Euroleague','http://www.euroleague.net/','2115','37','0','0','0','0','0','190','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('33504','ٷվ','http://dachao.sports.sohu.com/','2115','38','0','0','0','0','0','306','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('33503','FIBA','http://fiba.qq.com/','2115','39','0','0','0','0','0','946','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('32710','ע̳','http://seeker.aa.topzj.com/','1932','4','0','0','0','0','0','4618','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('33502','CUBAٷվ','http://www.cuba.com.cn/','2115','35','0','0','0','0','1','712','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('39960','ŻCBAר','http://sports.cn.yahoo.com/basketball/cba/index.html','2057','7','0','0','0','0','0','4','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('33499','ʿٿ˶','http://www.nba.com/celtics/','2056','29','0','0','0','0','0','4382','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('33479','մɭǶ','http://www.nba.com/timberwolves/','2056','9','0','0','0','0','1','465','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('848','Ѻ','http://bbs.sports.sohu.com','697','2','0','0','0','0','0','492','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('851','̳','http://bbs1.people.com.cn/boardList.do?action=postList&boardId=30','697','6','0','0','0','0','0','5','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('853','»','http://forum.xinhuanet.com/listtopic.jsp?bid=50&sno=1&catid=5','697','7','0','0','0','0','0','4','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46357','ʱش','http://www.120ask.com/','864','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46195','VOLVOֶ','http://www.volvocars.com.cn/','2177','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('863','Ӿ-Ϸ','http://games.sina.com.cn/esports/','2068','1','0','0','0','0','0','5367','0','','yowao','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('34219','QQսƽ̨','http://battle.qq.com/','2068','6','0','0','0','0','0','5307','0','','yowao','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('35955','ҵĹ','http://www.myjob.com.cn/','1519','12','0','0','0','0','1','8949','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45953','Ԥ','http://www.weather.com.cn/html/weather/101060101.shtml','2286','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45849','СϷ007','http://www.yx007.com/','701','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('40193','','http://www.changning.sh.cn/','1846','4','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('931','17173Ϸ̳','http://bbs.17173.com','703','1','0','0','0','0','3','26560','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45985','ͨΥ²ѯ','http://www.cncn.com/gongju/weizhang.html','2290','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('933','̳','http://bbs.92wy.com','703','7','0','0','0','0','0','3517','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45986','гʱ̱','http://huoche.cncn.com/','2290','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('936','52pkϷ̳','http://bbs.52pk.net','703','6','0','0','0','0','1','7025','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('937','Ϸ','http://bbs.ourgame.com','703','10','0','0','0','0','0','2482','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45987','8684ѯ','http://www.8684.cn/','2290','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45988','ʵʱѯ','http://flights.ctrip.com/Domestic/SearchFlights.aspx','2290','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('949','йϷ̳','http://bbs.chinagames.net/','703','4','0','0','0','0','0','10765','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46070','Ѻ-Ƶ','http://money.sohu.com/','1997','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('40123','ʳ','http://www.chinagrain.gov.cn/','2184','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('961','17173վ','http://download.17173.com','704','1','0','0','0','2','15','132604','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('962','52pk','http://down.52pk.com/','704','2','0','0','0','0','0','79612','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('963','','http://games.sina.com.cn/download/','704','3','0','0','0','0','0','60093','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('965','켫Ϸ','http://game.mydown.com/','704','4','0','0','0','0','0','38502','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('968','Ʒ','http://www.cga.com.cn/download.shtml','704','5','0','0','0','0','0','14379','0','','yowao','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('971','̫ƽϷ','http://dl.pcgames.com.cn/netgame/','704','7','0','0','0','0','0','69908','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('987','ѶϷ','http://games.qq.com/downlo/download.shtml','704','6','0','0','0','3','23','81617','0','','','0','2','0','0','','0');
INSERT INTO yowao_site VALUES('46356','лҽҩ','http://space.tv.cctv.com/podcast/zhyy','864','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46355','þý','http://www.9939.com/','864','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45340','Ӱ','http://movie.tudou.com/','805','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45341','Ӱ','http://movie.gougou.com/','805','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45342','˴Ƭ','http://video.sina.com.cn/movie/','805','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('38550','','http://www.powereasy.net/','2113','9','0','0','0','0','0','395','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46194','LEXUS׿˹','http://www.lexus.com.cn/','2177','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('32462','ٶȲƾ','http://finance.baidu.com/','843','9','0','0','0','4','8','74051','0','','','0','1','0','0','','0');
INSERT INTO yowao_site VALUES('40634','翼̳','http://bbs.kuakao.com/','2265','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('32457','ײƾ','http://money.163.com/','843','10','0','0','0','1','4','76707','0','','','0','1','0','0','','0');
INSERT INTO yowao_site VALUES('40608','ѧϰ','http://www.pallasa.com','966','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('40300','й','http://www.totochina.com','817','6','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46772','','http://www.penshow.cn/','2106','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45648','Ѻ','http://club.sohu.com/','675','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45505','6188ͼ','http://www.6188.net/','710','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45484','PocoͼƬ','http://www.poco.cn/','709','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45660','è','http://tt.mop.com/','675','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('35070','ڰ','http://www.heibai.net/','1139','5','0','0','0','0','0','3700','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45483','','http://bbs.ziling.com/','709','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46275','йشֻ','http://detail.zol.com.cn/cell_phone_index/subcate57_list_1.html','767','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('40601','СϷ','http://www.mx007.com/','2253','5','0','0','0','0','0','1','0','','yowao','0','0','0','0','','1');
INSERT INTO yowao_site VALUES('32514','Ժ','http://bjgy.chinacourt.org/flyz/','2207','20','0','0','0','0','0','205','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('1100','й','http://www.cnscreen.com/','712','6','0','0','0','1','2','29041','0','','','1','0','0','0','','0');
INSERT INTO yowao_site VALUES('34403','̳','http://bbs.digi.163.com/board/postlist.jsp?b=dc','800','1','0','0','0','0','0','2669','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('34402','TOMPDAֻ̳','http://bbs.tompda.com/','800','5','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('34390','ѧԺ','http://www.arch.ethz.ch/','1336','4','0','0','0','0','0','26','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('34386','˹ѧ','http://www.ul.pt/','1337','1','0','0','0','0','0','27','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('34385','ɴѧ','http://www.fu-berlin.de/','1341','12','0','0','0','0','0','28','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('34171','wo99෭','http://www.wo99.com/','719','9','0','0','0','0','2','19884','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('1146','Ѻ','http://music.sohu.com','717','6','0','0','0','0','3','65500','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('1152','KuGouṷ','http://www.kugou.com','717','2','1','0','1','13','138','633184','0','','','4','4','0','0','','0');
INSERT INTO yowao_site VALUES('1153','й','http://www.guitarchina.com','1680','22','0','0','0','0','1','21556','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('1169','ٶMP3','http://mp3.baidu.com/','716','1','1','0','0','0','12','582761','0','','yowao','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('35981','пƼѧ','http://www.hust.edu.cn/','951','14','0','0','0','0','0','49','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('34169','йƶŻ','http://music.10086.cn/','716','20','0','0','1','3','15','172217','0','','yowao','1','1','0','0','','0');
INSERT INTO yowao_site VALUES('34182','̳','http://bbs.democn.com/','686','13','0','0','0','0','0','1907','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('34166','ſ','http://www.9ku.com/','716','11','0','0','0','0','0','90746','0','','yowao','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('23299','ɽ','http://www.wulingshan.com.cn/','1797','100','0','0','0','0','1','1759','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('35987','Ӣѧϰ','http://www.wwenglish.com/','1045','8','0','0','0','0','0','133','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46969','й豸','http://www.sewworld.com','2298','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('1244','ַ','http://www.yyfc.com','719','1','0','0','0','0','13','63035','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('40310','¿','http://www.xker.com/','1124','13','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('11314','Ȥ','http://www.eachnet.com/','852','3','0','0','0','0','0','5297','0','','yowao','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('35979','Ͼѧ','http://www.nju.edu.cn/cps/site/newweb/foreground/','951','13','0','0','0','0','0','1213','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('35980','йѧѧ','http://www.ustc.edu.cn/zh_CN/','951','15','0','0','0','0','0','779','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('39516','ϲƸ','http://www.ncfccf.com/','1775','100','0','0','0','0','0','384','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45806','»','http://www.xinhuanet.com/mil/','726','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45805','Ѻ','http://mil.news.sohu.com/','726','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45804','׶','http://www.junshijia.com/','726','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45803','׾','http://war.news.163.com/','726','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45658','','http://www.kdnet.net/','675','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('32281','ֻ̳','http://a1.timewe.net/cdr/wap.18jw.com','2027','2','0','0','0','0','0','333','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('34055','йԺ','http://www.coddc.com/','1672','4','0','0','0','0','0','1453','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('32274','ͼ','http://a.timewe.net/cdr?s=wap.55kt.cn','1600','1','0','0','0','0','0','4083','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45825','5281ʿ֮','http://bbs.5281.com.cn/','727','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45824','','http://junshi.daqi.com/','727','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45823','8181','http://www.8181.com.cn/','727','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('40055','侯ɶָѧԺ','http://www.wjcd.net/','1921','12','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45822','','http://bbs.voc.com.cn/forum-12-1.html','727','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45821','վ֮','http://www.afwing.com/','727','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('1366','ž','http://www.plapic.com.cn','728','5','0','0','0','0','0','15961','0','','yowao','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('1368','ժ','http://www.jswzmil.com','728','1','0','0','0','0','0','17990','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('35296','йȫϢ','http://www.hacker.cn/','1139','9','0','0','0','0','0','1338','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('38393','ϷɽҽԺ','http://www.hfzs.com','1732','7','0','0','0','0','0','193','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('40054','žϢ̴ѧ','http://www.plaieu.cn/','1921','3','0','0','0','0','0','0','0','','yowao','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('1378','','http://changzheng.china1840-1949.net.cn','729','13','0','0','0','0','0','3043','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('1379','սо','http://warstudy.com','729','30','0','0','0','0','0','4956','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('1380','ë󶫼','http://cpc.people.com.cn/GB/69112/70190/','729','1','0','0','0','0','0','25593','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('1381','ˮʦ','http://www.beiyang.org','729','32','0','0','0','0','0','5519','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('1382','Ͼɱͬ','http://njdts.china1840-1949.net.cn','729','14','0','0','0','0','0','8829','0','','yowao','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('1383','Ԯ','http://kmyc.china5000.cn','729','15','0','0','0','0','1','7373','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('1384','Ͼɱʷʵ','http://www.neverforget.com.cn','729','16','0','0','0','0','3','13926','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('1385','','http://lzx.chinaspirit.net.cn','729','7','0','0','0','0','0','1596','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('1386','Сƽ','http://cpc.people.com.cn/GB/69112/69113/','729','2','0','0','0','0','0','10272','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('1387','','http://dbkl.china1840-1949.net.cn','729','17','0','0','0','0','0','2644','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('1388','Ӣۼ','http://mzh.china5000.cn','729','18','0','0','0','0','0','1560','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('1390','սۼ','http://www.jnzhanyi.com','729','24','0','0','0','0','1','1993','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('1392','ѻƬս','http://ypzz.china1840-1949.net.cn','729','26','0','0','0','0','0','1270','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('1393','ӢҼ','http://kryl.chinaspirit.net.cn','729','19','0','0','0','0','0','2558','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('1394','¼','http://zhude.chinaspirit.net.cn','729','6','0','0','0','0','0','4242','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('1395','9.18±','http://918.china1840-1949.net.cn','729','20','0','0','0','0','0','1100','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('1396','ɽ','http://szs.chinaspirit.net.cn','729','4','0','0','0','0','0','2997','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('1397','Ƽ','http://chenyun.chinaspirit.net.cn','729','8','0','0','0','0','0','1729','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('1398','㽭ʿ','http://www.zjgmls.net','729','25','0','0','0','0','0','1204','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('1399','ʱ','http://rbs.chinaspirit.net.cn','729','11','0','0','0','0','0','1464','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('1400','Ϫ','http://yxgm.yuxi.gov.cn','729','12','0','0','0','0','0','802','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('1402','Ҽ','http://zzz.chinaspirit.net.cn','729','10','0','0','0','0','0','2469','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('1403','л-ʷ','http://military.china.com/zh_cn/history/index.html','729','31','0','0','0','0','0','5166','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('35944','й˲','http://www.cjol.com/','958','3','0','0','0','0','5','26248','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45618','','http://www.chinabug.net/','732','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45617','Ц','http://tieba.baidu.com/f?kw=%D0%A6%BB%B0&amp;fr=ala0','732','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45642','΢Ца','http://t.sina.com.cn/topgirls8','733','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('1474','Ѷ-ʱ','http://luxury.qq.com','735','3','0','0','0','0','2','35902','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('1484','ʱ','http://www.trends.com.cn/','735','1','0','0','0','0','5','37140','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('35129','ʱװ֮Է-ELLE','http://www.ellechina.com/','738','1','0','0','0','0','0','115','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('32779','ޢ-Lancome','http://www.lancome.com.cn/_zh/_cn/index.aspx','737','2','0','0','0','0','0','3299','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('1526','ŷ-Loreal','http://www.lorealparischina.com','737','1','0','0','0','0','1','13768','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('1527','ŷ-Avon','http://www.avon.com.cn/PRSuite/home/home.jsp','737','9','0','0','0','0','0','5419','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('1529','ά-Nivea','http://www.nivea.com/','737','11','0','0','0','0','0','2096','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('1530','-Shiseido','http://www.shiseido.com.tw','737','4','0','0','0','0','1','6649','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('1531','֮','http://www.tayoi.com/','737','19','0','0','0','0','0','1823','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('1532','ʫ-Esteelauder','http://www.esteelauder.com','737','10','0','0','0','0','0','3014','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('1534','õտ-Marykay','http://www.marykay.com.cn/','737','16','0','0','0','0','0','6603','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('1535','ζ-Chanel','http://www.chanel.com/','737','3','0','0','0','0','0','960','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('1544','ٻ-Clinique','http://www.clinique.com.cn/index.tmpl?ngextredir=1','737','8','0','0','0','0','0','1734','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('1545','ֲ','http://www.shu-uemura.co.jp','737','15','0','0','0','0','0','1320','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('1546','ϰ-ChristianDior','http://www.dior.com/pcd/International/JSP/Home/prehomeFlash.jsp','737','17','0','0','0','0','0','1951','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('1547','Ettusaisż','http://www.ettusais.co.jp','737','20','0','0','0','0','0','287','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('1551','-Yuesai','http://www.yuesai.com.cn/','737','14','0','0','0','0','0','1419','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('40081','۾','http://www.formosa-optical.com.tw/','1871','22','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('35141','Vogue[Ӣ]','http://www.vogue.co.uk/','738','19','0','0','1','1','1','17','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('35139','FLARE[Ӣ]','http://www.flare.com/','738','17','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('35138','Marie Claire[]','http://www.marieclaire.com/','738','16','0','0','0','0','0','512','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('35137','Figaro madame[]','http://madame.lefigaro.fr/','738','15','0','0','0','0','0','515','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('35135','ʱ.','http://www.trendsmag.com/trendsmag/cosmogirl/','738','9','0','0','0','0','0','8932','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('35134','־','http://www.metropolis-mag.com/','738','8','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('35133','JESSICA','http://www.jessicahk.com/','738','6','0','0','0','0','0','7404','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('35132','ʱ','http://esquire.trends.com.cn/','738','5','0','0','0','0','0','5250','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('35130','BAZAAR-ʱаɯ','http://www.trendsmag.com/trendsmag/bazaar/','738','2','0','0','0','0','0','11434','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('40404','','http://www.tieliu.com.cn/','2240','100','0','0','0','0','0','11','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('1581','ʱ','http://www.mensuno.com.tw','738','12','0','0','1','1','4','17970','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46140','ԽҰ','http://bbs.fblife.com/','1171','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('1597','ͳ','http://www.fantong.com','739','3','0','0','0','0','7','33076','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('1600','39ʳƵ','http://food.39.net/','739','10','0','0','0','0','0','25418','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('1602','ѺԺ','http://chihe.sohu.com/','739','9','0','0','0','0','3','15667','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('35226','¿','http://www.aokang.com.cn/','1871','57','0','0','0','0','0','780','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('35224','˫','http://www.doublestar.com.cn/','1871','54','0','0','0','0','0','1262','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('35223','ޱ','http://www.robinhood.com.cn/','1871','54','0','0','0','0','0','930','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('35222','','http://www.cnhqt.com/','1871','53','0','0','0','0','0','3486','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('35221','','http://www.sdfgn.com/','1871','30','0','0','0','0','0','1157','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('35220','-Kappa','http://www.kappa.com.cn/','1871','51','0','0','0','0','1','5263','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('35219','ά˹','http://www.jeanswest.com/','1871','50','0','0','0','0','0','168','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('35218','˼ͼ-STACCATO','http://www.staccato.com/','1871','49','0','0','0','0','0','1406','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('35217','ǧٶ','http://www.c-banner.com/','1871','48','0','0','0','0','0','2791','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('35216','ܽ','http://www.daphne.com.cn/','1871','47','0','0','0','0','0','4823','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('40122','ҵ','http://www.saac.gov.cn/','2184','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('35214','˹','http://www.metersbonwe.com/','1871','45','0','0','0','0','0','5301','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('33149','й̱ע','http://www.1628.cn/','1880','1','0','0','0','0','1','618','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('35213','ɭ','http://www.chinasenda.com/','1871','44','0','0','0','0','0','896','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('35160','-ʳƵ','http://www.ruiliren.com/jiankang','2080','5','0','0','0','0','4','6190','0','','admin','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('32610','й̳','http://www.cntrbbs.com/','1933','3','0','0','0','0','0','923','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('32609',';','http://bbs.lotour.com/','1933','7','0','0','0','0','0','484','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45938','ϾԤ','http://www.weather.com.cn/html/weather/101190101.shtml','2286','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('32607','̳-','http://bbs.gotoworld.net/','1933','5','0','0','0','0','1','529','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('32606','̳','http://www.dayout.com.cn/','1933','9','0','0','0','0','0','451','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('32605','Ѻ-Ѻ','http://club.travel.sohu.com/','1933','4','0','0','0','0','1','293','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('32604','ctripЯ','http://www.ctrip.com/Community/CommunityHome.asp','1933','1','0','0','0','0','0','609','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46670','ֻMSN','http://mobile.msn.com.cn/','744','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46669','ֻQQ','http://mobile.qq.com/?from=im_m','744','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46667','','http://shutter.cdream.com','744','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46683','Ȥ','http://chat.netsh.com/','742','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46681','Ƶ','http://www.loveliao.com/','742','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46682','','http://chat.inhe.net/','742','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('40071','Ϻ','http://www.xiami.com','686','20','0','0','0','0','0','2','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('33145','ձNHK','http://www.nhk.or.jp/','749','7','0','0','0','2','4','13323','0','','','0','1','0','0','','0');
INSERT INTO yowao_site VALUES('33144','CNN','http://www.cnn.com/','749','7','0','0','0','0','0','1','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('33143','̨TTV','http://www.ttv.com.tw/','749','7','0','0','0','0','0','3297','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('1759','Ϸ̨','http://www.tvscn.com','749','10','0','0','0','0','0','2009','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('1761','̨ͥCETV','http://www.cetv.com','749','9','0','0','0','0','0','2137','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('1762','ǿ','http://www.xingkong.com.cn','749','11','0','0','0','1','2','17684','0','','','1','0','0','0','','0');
INSERT INTO yowao_site VALUES('1763','̽','http://www.discoverychannel.com.cn','749','100','0','0','0','0','1','2466','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('1765','','http://www.tctc.com.cn','749','12','0','0','0','0','1','2738','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('1766','Channel V','http://www.vchinese.com','749','9','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('1767','','http://www.tvcn.com.cn','749','100','0','0','0','0','0','12970','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('1768','ǵ','http://www.tvworld.com.cn','749','100','0','0','0','0','5','17719','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('40369','ChinaRen֮','http://club.chinaren.com/','2235','2','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('1770','ӢBBC','http://www.bbcworld.com','749','7','0','0','0','1','1','6064','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('1771','ȫѶ','http://www.ctv.com.tw/','749','100','0','0','0','0','0','940','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('33142','뵺̨','http://www.aljazeera.net/','749','100','0','0','0','0','4','11751','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('1777','ѺTVƵ','http://yule.sohu.com/tv.shtml','749','100','0','0','0','0','0','2332','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('36321','ͨ','http://www.cttyn.com','2092','18','0','0','0','0','0','53','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('40037','չ','http://www.chinaxly.cn/','890','4','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('1847','֣ߵ̨','http://www.zzcatv.com.cn','1616','100','0','0','0','0','0','414','0','','yowao','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('1848','Ͼʱ','http://www.njcatv.net','1369','100','0','0','0','0','0','564','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46533','YOKAƵ','http://www.yoka.com/men/','2234','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('32282','ܸ','http://a1.timewe.net/cdr/huohuo.cn','2028','7','0','0','0','0','1','1259','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('1851','ߵ','http://www.wharfcable.com','1393','100','0','0','0','0','0','3554','0','','yowao','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('1853','ൺߵ̨','http://www.qingdaomedia.com/','1366','100','0','0','0','0','0','1555','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('33267','ξ','http://www.enit.it/','2052','16','0','0','0','0','0','301','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('33180','޹㲥̨̨','http://www.abc.net.au/ra/chinese/','754','14','0','0','0','0','0','1049','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('35241','йʹ㲥̨','http://www.chinabroadcast.cn/','754','2','0','0','0','0','0','1550','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('33175','Ժ','http://bjgy.chinacourt.org/','914','6','0','0','0','0','0','459','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('33174','Ϲ㲥̨̨','http://www.un.org/chinese/radio/','754','7','0','0','0','0','0','841','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('1865','QQ̨','http://fm.qq.com','756','2','0','0','0','0','0','1065','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('36298','ͨ','http://www.cttln.com','2092','4','0','0','0','0','0','0','0','','yowao','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('33170','̨Ŀ㲥','http://www.radio.cn/yhtdb/','756','7','0','0','0','0','0','1320','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('35240','ʹ㲥̨','http://world.kbs.co.kr/chinese/','754','12','0','0','0','0','0','1497','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('1871','̨','http://www.nihaotw.com','756','15','0','0','0','0','0','860','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('1872','й㲥-֮','http://musicradio.cnr.cn','756','4','0','0','0','0','0','2828','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('1873','Channel V','http://www.vchinese.com','756','5','0','0','0','0','0','3995','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('33165','֪ʶȨ','http://www.jxipo.gov.cn/','2208','20','0','0','0','0','0','79','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('15733','ձNHK㲥̨','http://www.nhk.or.jp/daily/chinese/','754','6','0','0','0','0','0','2574','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('33198','շԺ','http://www.ahcourt.gov.cn/','914','15','0','0','0','0','0','38','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('33164','й㲥','http://www.cnr.cn/','756','3','0','0','0','0','0','2883','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('1883','ȥȥСϷ','http://www.7k7k.com','759','5','0','0','0','0','0','20883','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('1887','͵۹','http://www.flashempire.com/','758','2','0','0','0','0','3','38057','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('1888','Ϳ','http://www.vlike.com','758','10','0','0','0','1','2','10256','0','','','0','1','0','0','','0');
INSERT INTO yowao_site VALUES('45954','Ԥ','http://www.weather.com.cn/html/weather/101070101.shtml','2286','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('1896','TOMƵ','http://flash.tom.com','758','3','0','0','1','3','7','30105','0','','','1','0','0','0','','0');
INSERT INTO yowao_site VALUES('1909','ˮ','http://www.pacoo.net','758','11','0','0','0','0','0','10207','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('1921','TOMϷ','http://games.tom.com/flash/','759','9','0','0','0','0','34','26057','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('1922','СϷ','http://www.xiaoyouxi.com','759','2','0','0','0','0','0','77384','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('1923','-СϷ','http://games.sina.com.cn/downgames/littlegame','759','7','0','0','1','1','13','20033','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('1927','СϷ','http://www.youxiba.com','759','13','0','0','0','0','0','53216','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('1947','Ѷ-СϷ','http://games.qq.com/mini/mini.shtml','759','10','0','0','0','0','0','1733','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46976','ƷƷλ','/pinpai/index.htm#601','2298','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46977','йͯװƷ','http://www.61kids.com.cn','2298','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('34441','Flash8ɽ̲','http://www2.flash8.net/teach/','760','3','0','0','0','0','1','6516','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('1963','̫ƽ-Flash̳','http://www.pconline.com.cn/pcedu/sj/wz/flash/index.html','760','5','0','0','0','0','0','3095','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('32530','FlashƵ̳','http://www.enet.com.cn/eschool/includes/zhuanti/flash1130/','760','4','0','0','0','0','4','13768','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46975','й','http://www.zgkz.cn','2298','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('36619','пƴ嫺վ','http://bbs.ustc.edu.cn/','2078','13','0','0','0','0','0','118','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('38470','ǿ','http://www.joekoe.com/','2113','10','0','0','0','0','0','226','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46263','ƶ/ͨ/','/tongxun/','766','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46262','ֻ','http://www.pda.cn/index.htm','766','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46261','й','http://www.ct10000.com/','766','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46260','йͨ','http://www.10010.com/','766','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46254','ֻ','http://tech.sina.com.cn/mobile/','766','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46255','ֻ֮','http://www.imobile.com.cn/','766','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46290','Ŵֻ̳','http://www.nokiacn.net/','768','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46291','ŵ̳','http://www.nokiabbs.com/','768','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46289','Maxpda','http://bbs.maxpda.com/','768','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46287','Ħ̳','http://www.motobbs.com/','768','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46286','̳','http://bbs.meizu.com/','768','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46285','52̳','http://bbs.52samsung.com/','768','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46284','̳','http://bbs.dospy.com/','768','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46283','OPDAֻ','http://www.opda.net.cn/','768','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46282','Tompdaֻ̳','http://bbs.tompda.com/','768','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46281','IT168̳','http://sebbs.it168.com/','768','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46280','˻̳','http://forum.younet.com/','768','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46279','ֻ̳֮','http://bbs.imobile.com.cn/','768','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('36679','ຣְҵѧԺ','http://www.qhei.gov.cn/qyycp/qyzs/jywhys/qhjgxy/','1317','5','0','0','0','0','0','79','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46276','ֻ֮ұ','http://product.imobile.com.cn/quoted_price.php','767','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46277','3533ֻ','http://www.3533.com/price/','767','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46278','ֻ','http://product.pcpop.com/Mobile/00000_1.html','767','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('30221','ͨ','http://www.cww.net.cn/','774','2','0','0','0','0','0','887','0','','yowao','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('30218','CCTIME','http://www.cctime.com/','774','9','0','0','0','0','0','590','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('30217','-ͨ','http://telecom.chinabyte.com/','774','3','0','0','0','0','0','492','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('30216','йͨ','http://www.c114.net/','774','4','0','0','0','0','0','1706','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('30215','йͨ','http://www.cnii.com.cn/','774','5','0','0','0','0','0','888','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('30214','̩-ͨҵ','http://www.catr.cn/','774','10','0','0','0','0','0','333','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('40052','йϢҵ','http://www.cnii.com.cn/','774','6','0','0','0','0','0','1','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('2220','ͨ','http://comm.ccidnet.com','774','1','0','0','0','0','0','824','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('2222','ͨѶ','http://tech.sina.com.cn/tech','774','7','0','0','0','0','0','755','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('2229','йƶ','http://www.chinamobile.com/','775','1','0','1','0','0','0','132111','29','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('2230','йͨ','http://www.chinaunicom.com','775','2','0','0','0','0','0','3054','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46066','','http://www.psbc.com/portal/zh_CN/Fund/index.html','1649','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45664','QQռ','http://qzone.qq.com/','675','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('2234','йͨ','http://www.chinatietong.com/','775','4','0','0','0','0','0','1713','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45561','Ƶ','http://cartoon.tudou.com/','777','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45508','','http://astro.sina.com.cn/','784','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45560','ſᶯƵ','http://comic.youku.com/','777','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45622','Խת','http://wenku.baidu.com/search?word=%C4%D4%BD%EE%BC%B1%D7%AA%CD%E4&amp;lm=0&amp;od=0','732','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45559','Ѹ׶','http://anime.xunlei.com/','777','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45509','Ѷ','http://astro.lady.qq.com/','784','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('23300','Բ԰','http://www.yuanmingyuanpark.com/','1797','100','0','0','0','0','2','5458','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('39328','С˵','http://www.yousheng8.com/index.htm','1018','10','0','0','0','0','0','1191','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('36680','ຣְͨҵѧԺ','http://www.qhctc.edu.cn/','1317','6','0','0','0','0','0','46','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45515','','http://lady.163.com/astro/','784','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45514','Ѷ','http://astro.lady.qq.com/augury/augu_test.shtml','784','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45513','Ѻ','http://astro.women.sohu.com/','784','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45512','Ѻ','http://astro.women.sohu.com/ceshi.shtml','784','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45511','','http://astro.sina.com.cn/test/','784','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45541','̳-','http://club.astro.sina.com.cn/','787','100','0','0','0','0','0','0','0','','yowao','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46128','ൺ','http://www.qdcars.com/','1664','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('36610','йѧ˴BBS','http://bbs.ruc.edu.cn/','2078','3','0','0','0','0','0','522','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('33981','ô⽻[]','http://www.dfait-maeci.gc.ca/','1834','100','0','0','0','0','0','39','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45366','RealPlayer','http://realplayer.cn.real.com/','2099','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('32264','Yokaʱ','http://www.yoka.com/','735','4','0','0','0','0','1','19174','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('32247','У','http://www.xiaonei.com','669','7','0','0','0','0','0','663','0','','admin','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('32246','Żռ','http://i.cn.yahoo.com/','669','14','0','0','0','0','0','7692','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45645','è˴ӻ','http://dzh.mop.com/','675','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45646','̳','http://bbs.sina.com.cn/','675','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45647','','http://static.tieba.baidu.com/tb/tiebatuijian/index.html','675','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('32219','Ѷ','http://ent.qq.com/','659','4','0','0','1','9','30','157033','0','','','1','5','0','0','','0');
INSERT INTO yowao_site VALUES('40570','ȫ','http://www.free789.com','2142','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('35658','㽭ѧصʵ','http://www.zju.edu.cn/kxyj/zdsys.htm','989','9','0','0','0','0','0','221','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45683','ͥ','http://www.ccice.com/','790','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45682','100','http://www.juedui100.com/','790','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45681','Ե','http://www.88999.com/','790','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46674','','http://yy.duowan.com/','744','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45936','֣Ԥ','http://www.weather.com.cn/html/weather/101180101.shtml','2286','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45680','Ե','http://www.91yuan.com/','790','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45725','è','http://ent.mop.com/','2368','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('40856','ȫƸϢ','http://www.zph.com.cn','958','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45939','ϷԤ','http://www.weather.com.cn/html/weather/101220101.shtml','2286','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45679','','http://www.marry5.com/','790','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45940','Ԥ','http://www.weather.com.cn/html/weather/101040100.shtml','2286','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45693','ͬѧ¼','http://alumni.163.com/','792','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45675','֪','http://www.zhiji.com/','790','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45937','Ԥ','http://www.weather.com.cn/html/weather/101120101.shtml','2286','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45688','51˿ռ','http://www.51.com/','792','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45689','','http://cyworld.ifensi.com/','792','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45690','','http://www.51taonan.com/','792','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45691','йУ¼','http://class.chinaren.com/','792','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45692','','http://www.myspace.cn/','792','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46474','̫ƽŮ','http://www.pclady.com.cn/','664','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('30042','԰-Ů','http://www.rayli.com.cn/sex/','663','5','0','0','2','12','77','315164','0','','','7','3','0','0','','0');
INSERT INTO yowao_site VALUES('2550','Ѻ','http://digi.it.sohu.com','796','3','0','0','0','0','0','13548','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('2551','','http://tech.sina.com.cn/digi','796','4','0','0','0','0','0','12239','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('2552','','http://digi.163.com','796','6','0','0','0','0','0','8999','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('2554','IT-','http://www.it.com.cn','796','16','0','0','0','0','0','900','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('2555','','http://digi.pcpop.com','796','11','0','0','0','1','2','12485','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('2558','Ѷ','http://digi.qq.com','796','5','0','0','0','0','0','6039','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('2561','IT168','http://digital.it168.com','796','12','0','0','0','0','0','9961','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('34393','ߴѧ','http://www.unige.ch/','1336','6','0','0','0','0','0','2','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('34391','ɣѧԺ','http://www.epfl.ch/','1336','5','0','0','0','0','0','8','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('39808','켫','http://dc.yesky.com/','2145','2','0','0','0','0','0','204','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('2602','켫MP3','http://mp3.yesky.com','799','1','0','0','0','0','0','1591','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('39806','̫ƽ','http://dc.pconline.com.cn/','2145','3','0','0','0','0','0','482','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('39807','IT168','http://dc.it168.com/','2145','4','0','0','0','0','1','264','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('2604','MP3','http://mp3.pcpop.com/','799','10','0','0','0','0','0','604','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('34401','̳','http://bbs.itime.cn/','800','3','0','0','0','0','0','2','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('2609','Mp3۸߲ѯ','http://detail.zol.com.cn/price_search.php?subcatid=19','799','2','0','0','0','0','0','4253','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('2611','IT168̳','http://bbs.it168.com','800','2','0','0','0','0','0','7','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('34400','ڴ̳','http://bbs.pdafans.com/','800','4','0','0','0','0','0','4','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('2615','̳','http://www.qqdc.com.cn/','800','6','0','0','0','1','1','11253','0','','','1','0','0','0','','0');
INSERT INTO yowao_site VALUES('2620','Logitech(޼)','http://www.logitech.com.cn/logitech','801','1','0','0','0','0','0','8','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('2622','Webeye(Ӣ-)','http://www.webeye.com.cn/index.htm','801','18','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('2624','','http://www.jisu.cn','801','2','0','0','0','0','0','1196','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('20967','ٶ','http://www.baidu.com/','1077','2','0','0','0','0','0','9700','0','','yowao','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('20965','е','http://www.yodao.com/','1077','4','0','0','0','0','1','8564','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('20964','Bing','http://cn.bing.com/','1077','9','0','0','0','0','0','4210','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45362','Ӱ','http://www.gougou.com/','1980','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45363','VeryCD','http://www.verycd.com/','1980','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45364','7369Ӱ','http://www.7369.com/','1980','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45367','Media Player','http://www.onlinedown.net/soft/3336.htm','2099','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('34146','й˲','http://www.buildjob.net/','1696','28','0','0','0','0','1','8255','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45347','ٶӰ','http://v.baidu.com/index.shtml','805','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45344','Ѹ׿','http://www.xunlei.com/','805','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('35407','ɹ˲ַȫ','http://www.wzjobs.cn/class/url0442.htm','1532','15','0','0','0','0','0','162','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('2698','','http://www.hunantv.com/','1377','69','0','1','0','0','0','218913','36','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('38256','','http://www.guilin.net','1816','11','0','0','0','0','0','639','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45851','Ϸ','http://games.sina.com.cn/downgames/littlegame/','701','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46258','ֻ','http://mobile.163.com/','766','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('40232','Ȫ','http://www.jiuquan.gov.cn/','1865','6','0','0','0','0','0','1','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('2820','ɽƱ','http://www.sdcp.com.cn','815','8','0','0','0','0','0','17245','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('2821','','http://www.bwlc.net','815','6','0','0','0','1','21','130327','0','','','1','0','0','0','','0');
INSERT INTO yowao_site VALUES('2822','㶫','http://www.gdfc.org.cn','815','16','0','0','2','18','96','257449','0','','','7','4','0','0','','0');
INSERT INTO yowao_site VALUES('2824','','http://www.sxfc.gov.cn','815','9','0','0','0','0','0','5291','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('2825','','http://www.cwl-fj.com','815','10','0','0','0','0','0','9641','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('39829','йش-','http://driver.zol.com.cn/','1118','2','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('40234','','http://www.chongzuo.gov.cn/','1857','11','0','0','0','0','0','3','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('2836','ӱ','http://www.hbtcw.com','816','8','0','0','0','0','0','4859','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('2837','','http://www.hljtcp.com','816','11','0','0','0','0','0','2409','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('36662','㶫ѧԺ','http://www.gdppla.edu.cn/','1295','64','0','0','0','0','0','690','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('2840','Ϻ','http://www.shlottery.gov.cn/','816','7','0','0','0','0','0','46166','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('2842','','http://www.lntycp.com/','816','20','0','0','0','0','0','20740','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('2845','','http://jltcw.net:8000/jitcw/','816','19','0','0','0','0','0','1094','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('13552','й-ʤ','http://www.lottery.gov.cn/winlose/','817','4','0','0','0','0','3','23297','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('2848','','http://www.jxlottery.com','816','20','0','0','0','0','0','2588','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('2850','','http://www.hnlottery.com.cn/','816','9','0','0','0','0','5','27870','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('2852','','http://www.cqlottery.gov.cn','816','22','0','0','0','0','0','1361','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('2856','㶫','http://www.gdlottery.cn/','816','20','0','0','1','8','51','49187','0','','','2','0','0','0','','0');
INSERT INTO yowao_site VALUES('2858','Ĵ','http://www.sclottery.gov.cn/','816','21','0','0','0','0','0','38752','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('2868','Ѻ','http://sports.sohu.com/zuqiucaipiao.shtml','817','2','0','0','0','0','0','23163','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('2870','Tom-','http://sports.tom.com/caipiao.html','817','5','0','0','0','0','0','13210','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45468','','http://sports.163.com/cba','2116','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('33433','21CN-CBA','http://sports.21cn.com/basketball/cba/','2057','6','0','0','0','0','0','588','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('39958','ѶCBA','http://sports.qq.com/cba/','2057','5','0','0','0','0','0','93','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('39957','ѺCBA','http://sports.sohu.com/cba.shtml','2057','4','0','0','0','0','1','112','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('33428','CBAǲ','http://sports.sina.com.cn/blog/cbastar.html','2057','9','0','0','0','0','0','1459','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('33425','йЭٷվ','http://www.cba.gov.cn/','2057','1','0','0','0','0','0','1213','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('39959','CBA','http://sports.163.com/cba/','2057','2','0','0','0','0','0','187','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46544','֪ʶʴ','http://zhidao.baidu.com/browse/151','821','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('2915','Ϻ','http://www.shanghaipet.org','2059','2','0','0','0','0','0','5135','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('33719','ASPӪ','http://www.aspjzy.com/','1155','10','0','0','0','0','2','416','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('33718','LEARNASPEN','http://www.learnasp.com/','1155','17','0','0','0','0','0','53','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('35943','ǰ','http://www.51job.com','958','2','0','1','0','0','0','43553','41','','admin','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('40843','ղ','http://www.htscw.com','1019','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('2932','','http://www.bjpet.com','2059','1','0','0','0','0','0','4529','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('33715','й£','http://www.chinabs.net/','1155','8','0','0','0','0','0','236','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46552','ﹷ','http://www.cndog.net/','1347','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('33707','ASP/ASP.net̫ƽѧԺ','http://www.pconline.com.cn/pcedu/empolder/wz/asp/index.html','1155','1','0','0','0','0','0','1321','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('35463','˲','http://xz.185job.com/','1533','3','0','0','0','0','0','157','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('2943','ݳ','http://www.gz-pet.com','2059','8','0','0','0','0','0','1528','0','','yowao','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('40908','ԱȤƷ','http://s8.taobao.com/search?q=%C7%E9%C8%A4%D3%C3%C6%B7&pid=mm_16140449_0_0&unid=0&mode=63&from=rs&navlog=rs-1-q-%C7%E9%C8%A4%D3%C3%C6%B7','2134','4','0','0','0','0','0','0','0','','yowao','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('33703','̳-CGI','http://www.host01.com/article/cgi/index.htm','1167','3','0','0','0','0','0','599','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('35459','й˲','http://www.wzjobs.cn/html/13573.html','1536','9','0','0','0','0','0','198','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('36035','йг˶Э','http://cycling.sport.org.cn/','931','12','0','0','0','0','0','670','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('36196','ҡ','http://www.yaolan.com/','964','1','0','0','0','0','0','6940','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('39823','йش-','http://driver.zol.com.cn/','1102','2','0','0','0','0','0','283','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('2968','йƷϢ','http://www.craftschina.net','1717','3','0','0','0','0','0','1262','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('2969','лƷ','http://www.parcn.com/','2061','9','0','0','0','0','0','1162','0','','yowao','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('2970','йƷ֮','http://www.lpc8.com','925','7','0','0','0','0','0','68','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('35890','Ѷ-Ƶ','http://ent.qq.com/tv/','752','5','0','0','0','0','0','6124','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('2978','йʻٵ','http://www.cnefs.com','2174','1','0','0','0','0','0','1016','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('2984','Ʒ','http://www.szlpc.com','2061','9','0','0','0','0','0','1917','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('2985','˳Ʒ','http://www.ws888.com','2061','14','0','0','0','0','0','679','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('2990','йƷ','http://www.18a8.com','925','4','0','0','0','0','0','505','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('40130','ԭܻ','http://www.caea.gov.cn/','2184','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('2993','㶫Ʒ','http://www.gdgifts.com','2061','8','0','0','0','0','0','2168','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('21378','ϺƷ','http://www.shgifts.cn/','2061','3','0','0','0','0','0','1298','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('40455','','http://cluclick.leshu.com/pre.php?r=1543_14_0','2141','3','0','0','0','0','0','2','0','','admin','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45760','ݹ','http://www.britneyspears.com/','825','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45759','ܹ','http://www.jetli.com/','825','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45758','S.H.E½Ԯ','http://www.sheshow.net/','825','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45756','Ĳ','http://blog.sina.com.cn/JackieChan','825','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45757','','http://tieba.baidu.com/f?kw=%B6%AB%B7%BD%C9%F1%C6%F0','825','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('3030','ٷվ','http://www.helloziyi.com','827','2','0','0','0','0','1','29216','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('3031','ٷվ','http://www.liyapeng.com','827','10','0','0','0','0','1','8634','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('3032','޽վ','http://www.cuijian.com','827','12','0','0','0','0','0','833','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('3034','С','http://www.shixiaolong.com','827','6','0','0','0','0','3','11956','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('3035','ԲԲٷվ','http://www.gaoyuanyuan.com','827','13','0','0','0','0','1','13195','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('3036','ƃٷվ','http://www.gongbeibi.com','827','14','0','0','0','0','1','1213','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('3037','Ļٷվ','http://www.yuwenhua.com','827','15','0','0','0','0','0','1162','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45942','Ԥ','http://www.weather.com.cn/html/weather/101140101.shtml','2286','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('3044','ӱٷվ','http://www.janezhang.com/','827','16','0','0','0','0','0','7572','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('3045','лٷվ','http://www.zhoha.com','827','21','0','0','0','0','0','642','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('3046','ܹٷ','http://www.wanhongjie.com','827','22','0','0','0','0','0','388','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('3047','Ƹ˹ٷվ','http://www.xuhonghao.com','827','23','0','0','0','0','0','319','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('3048','Ӱ','http://www.donnieyen.net/bbs/','828','7','0','0','0','0','0','3650','0','','yowao','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('3052','½ѻ','http://www.hearfish.net','828','16','0','0','0','0','0','5809','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('3055','Գ','http://www.sunyanzicc.net','828','8','0','0','0','0','0','8176','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('28017','Ρ̳','http://www.xuwei.org.cn/','827','3','0','0','0','0','0','800','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('3058','ٷվ','http://www.jackiechan.com','828','5','0','0','0','0','1','7071','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('3059','-ΰ','http://www.tonyleungcw.org','828','10','0','0','0','0','0','3553','0','','yowao','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('3060','ɣ½','http://www.52asun.com','828','20','0','0','0','0','1','1275','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('3063','ѧ','http://www.jackybbs.com/','828','5','0','0','0','0','0','7080','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('3065','DIDOٷ','http://www.didomusic.com','829','25','0','0','0','0','0','673','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('3066','վ','http://www.westlife.cn','829','1','0','0','0','0','0','3318','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('3067','ձٷվ','http://www.audreyhepburn.com','829','8','0','0','0','0','0','6620','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('3068','','http://www.narajjang.com','829','10','0','0','0','0','4','20721','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('3070','仪','http://www.sonyejin.org','829','32','0','0','0','0','0','2794','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('3072','к','http://www.westlife.com','829','10','0','0','0','0','0','3053','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('3073','ɶ','http://www.leonardodicaprio.com','829','3','0','0','0','0','0','969','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('3074','Ӣٷվ','http://leeyoungae.net','829','24','0','0','0','0','0','3750','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('3078','ͷӢĹٷWվ','http://www.thebeatles.com','829','20','0','0','0','0','0','536','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('3079','Ȩ޻վ','http://www.kwonsangwoo.org/','829','26','0','0','0','0','0','2561','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('3080','norahjones','http://www.norahjones.com','829','27','0','0','0','0','0','495','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('3082','Ƚܿɭ','http://www.janetjackson.com/','829','28','0','0','0','0','0','2402','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('3083','laurapausini','http://www.laurapausini.com','829','29','0','0','0','0','0','365','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('3084','diamonٷվ','http://www.diamondrio.com','829','23','0','0','0','0','0','309','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('3085','Anastacia','http://www.anastacia.com','829','22','0','0','0','0','0','253','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('3086','faithhillٷվ','http://www.faithhill.com','829','20','0','0','0','0','0','237','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('3087','imarobot','http://www.imarobot.com','829','19','0','0','0','0','0','324','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('3090','ٷվ','http://www.myungsebin.net','829','35','0','0','0','0','0','720','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('3091','ٷվ','http://www.jimcarreyonline.com','829','17','0','0','0','0','0','709','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('34431','Flashԭ','http://www.flashyc.com/','758','12','0','0','0','0','2','18524','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45501','ѶͼƬ','http://ent.qq.com/picture.shtml','710','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45502','̫ƽͼ','http://www.pclady.com.cn/photo/','710','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45349','PPS','http://kan.pps.tv/nlist/551/1.html','805','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45348','Ѻ','http://tv.sohu.com/hdtv/','805','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45333','ʱܿ','http://www.time.com/','1919','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45332','˹֮','http://www.ruvr.ru/index.php?lng=pek','1919','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45297','е','http://news.yodao.com/','832','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45289','','http://news.163.com/','832','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45290','й','http://www.chinamil.com.cn/','832','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45291','л','http://news.china.com/','832','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45292','Ϸ','http://www.southcn.com/','832','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45287','й','http://www.gov.cn/jrzg/','832','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45288','','http://www.people.com.cn/','832','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45283','»','http://www.xinhuanet.com/','832','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45284','CCTV','http://www.cctv.com/','832','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45285','й','http://www.china.com.cn/','832','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45286','ʱ','http://www.huanqiu.com/','832','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45282','','http://www.ifeng.com/','832','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45872','','http://www.4399.com/special/8.htm','2255','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45871','ȺӢ','http://www.4399.com/special/33.htm','2255','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45296','ѹ','http://news.sogou.com/','832','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('31917','ǹͨѶ[]','http://www.bernama.com/','2004','1','0','0','0','0','0','368','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('31910','˹[]','http://www.dowjones.com/','2004','2','0','0','0','0','0','456','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45281','Ѻ','http://news.sohu.com/','832','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45280','Ѷ','http://news.qq.com/','832','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('3182','йӦ','http://www.china.cn','1926','6','0','0','0','0','0','12790','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45870','ƽ','http://www.4399.com/special/34.htm','2255','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45310','걨','http://bjyouth.ynet.com/','837','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45309','','http://www.gxnews.com.cn/','837','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45308','йձ','http://www.chinadaily.com.cn/','837','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45307','󹫱','http://www.takungpao.com/','837','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45306','Ļ㱨','http://www.wenweipo.com/','837','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45305','ӱ','http://www.dahe.cn/','837','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45304','̱','http://hsb.hsw.cn/','837','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45303','Ϸĩ','http://www.infzm.com/','837','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45302','Ϸ細','http://www.nfcmag.com/','837','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45301','ձ','http://www.legaldaily.com.cn/','837','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45300','ձ','http://www.ce.cn/','837','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45299','й걨','http://www.cyol.net/','837','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45298','籨','http://www.zaobao.com/','837','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('40462','ѧ','http://www.alaboyu.com','1050','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46398','ٶȷ','http://law.baidu.com/','913','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45317','','http://www.ycwb.com/','837','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45316','򱱷','http://www.enorth.com.cn/','837','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45315','컪','http://www.cqnews.net/','837','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45314','Ϸб','http://www.nddaily.com/','837','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45313','¾','http://www.thebeijingnews.com/','837','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45312','','http://www.fjsen.com/','837','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('45311','ɽ','http://www.daynews.com.cn/','837','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('3310','˲ƾ','http://finance.sina.com.cn','843','2','0','0','2','17','120','644906','0','','','5','5','0','0','','0');
INSERT INTO yowao_site VALUES('3312','йƾ','http://www.fec.com.cn','843','18','0','0','0','1','7','91230','0','','','0','1','0','0','','0');
INSERT INTO yowao_site VALUES('3315','н','http://www.cnfol.com','843','6','0','0','0','0','0','627','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46031','Ļ','http://www.chinaamc.com/portal/cn/index.html','1649','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('41332','֤ȯ','http://www.foundersc.com/','848','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('41331','Ϻ֤ȯ','http://www.962518.com/','848','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('41330','Ͼ֤ȯ','http://www.njzq.com.cn/','848','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('41329','֤ȯ','http://www.stocke.com/','848','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('41328','ԭ֤ȯ','http://www.ccnew.com/','848','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('41327','֤ȯ','http://www.dwjq.com.cn/','848','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('41326','֤ȯ','http://www.dfzq.com.cn/','848','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('41325','֤ͬȯ','http://www.dtsbc.com.cn/','848','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('3417','й֤ȯ','http://www.cs.com.cn','847','1','0','0','0','0','0','13657','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('3418','ձ','http://chinese.wsj.com','847','5','0','0','0','0','0','26226','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('41280','չƱ','http://www.skycn.com/sort/sort2070100_indate_DESC_1.html','2148','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('3420','йӪ','http://www.cb.com.cn','847','11','0','0','0','0','0','1473','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('3421','˹','http://www.forbeschina.com/','847','15','0','0','0','0','0','3856','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('3422','ÿվ','http://www.nbd.com.cn/','847','9','0','0','0','0','0','144','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('41297','й֤','http://www.csrc.gov.cn/','848','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('41279','ǮѶ','http://www.ql18.com.cn/homepage/','2148','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('3428','̱','http://www.hkcd.com.hk/','847','19','0','0','0','0','0','298','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('41278','ͬ˳Ʊ','http://down1.tech.sina.com.cn/download/downContent/2005-02-04/13004.shtml','2148','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('3434','Ϻڱ','http://www.shfinancialnews.com/','847','12','0','0','0','0','0','51','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46133','ֲ','http://club.xcar.com.cn/','1171','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('3462','Ա̳','http://pindao.huoban.taobao.com/tms/channel/channelmall.htm?pid=mm_16140449_0_0&eventid=101334','852','1','1','0','0','0','0','148213','0','','yowao','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('3463','׿Խ','http://www.amazon.cn/?source=yowao-23','852','4','1','0','0','0','0','4107','0','','yowao','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('33160','ɽʡ֪ʶȨ','http://www.sdpatent.gov.cn/','2208','21','0','0','0','0','0','103','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('3497','йƷ','http://www.enwise.net/','925','9','0','0','0','0','0','1290','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('33159','ʡ֪ʶȨ','http://www.ahipo.gov.cn/','2208','18','0','0','0','0','0','76','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('3525','','http://union.dangdang.com/transfer/transfer.aspx?from=P-278870&backurl=http://www.dangdang.com/','853','1','0','0','0','0','0','1414','0','','yowao','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46656','MSN','http://im.live.cn/','744','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('21401','۴ƷƷ','http://www.gift.hc360.com/','925','1','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('36271','׻̳','http://bbs.sports.163.com/bbs/list.jsp?boardid=basketball&frame=y','2058','4','0','0','0','0','0','750','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46988','йЬҵ','http://www.shoeol.com','2298','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('21395','йʻƷ','http://www.flowercn.com/','2174','2','0','0','0','0','0','1815','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('21391','г','http://www.ywtoys.org/','2062','5','0','0','0','0','1','3045','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('21389','','http://www.world-toy.com/','926','9','0','0','0','0','0','1081','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('21380','Ʒ','http://www.teagift.com/','2061','1','0','0','0','0','0','2213','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('39336','ʿŻ','http://www.fangdr.com','1780','100','0','0','0','0','0','711','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46065','йд','http://fund.ccb.com/fund/index.html','1649','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46064','ʩ޵»','http://www.jyfund.com/','1649','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('3627','','http://www.icbc.com.cn','858','1','0','1','10','97','544','933235','26','','','30','30','0','0','','0');
INSERT INTO yowao_site VALUES('32902','ũҵ','http://www.xzrcb.com/','1643','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('3629','','http://www.cmbchina.com','858','2','0','1','1','14','131','225626','27','','','4','4','0','0','','0');
INSERT INTO yowao_site VALUES('3630','','http://www.ccb.com/','858','4','0','0','0','3','13','213589','28','','admin','1','0','0','0','','0');
INSERT INTO yowao_site VALUES('3631','ũҵ','http://www.abchina.com','858','3','0','1','0','0','0','49551','28','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('32901','ʯׯҵ','http://www.sccb.com.cn/','1643','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('32900','ũҵ','http://www.wjnsh.com/','1643','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('32899','Ȫҵ','http://www.qzccbank.com/','1643','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('32898','һ','http://www.fsbankonline.com/','1643','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('32897','','http://www.binbank.com.cn/','1643','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('32896','żҸũҵ','http://www.zjgrcb.com/','1643','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('32895','ҵ','http://www.lyccb.com.cn/','1643','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('32894','⽭ũҵ','http://www.wjrcb.com/','1643','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('32893','ũҵ','http://www.csebank.com/','1643','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('32892','ҵ','http://www.wzcb.com.cn/','1643','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('32891','ũҵ','http://www.jybank.com.cn/','1643','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('32890','Ͳҵ','http://www.zccb.com.cn/index.asp','1643','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('32889','ൺҵ','http://www.qdccb.com/?56606245=3638389013','1643','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('32888','ҵ','http://www.lzbank.com/','1643','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('32887','ɶҵ','http://www.cdccb.com/','1643','100','0','0','0','0','1','8','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('32886','ҵ','http://www.gyccb.cn/','1643','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('32885','ϲҵ','http://www.nccbank.com.cn/','1643','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('32884','ͷҵ','http://www.bcb.com.cn/','1643','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('32883','ҵ','http://www.jnccb.com/','1643','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('32882','Ź','http://www.xib.com.cn/','1643','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('32881','ҵ','http://www.96779.com.cn/','1643','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('32880','ҵ','http://www.hrbcb.com.cn/','1643','100','0','0','0','0','0','3','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('32879','ҵ','http://www.cqcbank.com/','1643','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('32878','Ͼ','http://www.njcb.com.cn/','1643','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('32877','ũҵ','http://www.961200.net/','1643','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('32876','ҵ','http://www.hccb.com.cn/','1643','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('31500','йƲչ˾','http://www.picc.com.cn/','1995','6','0','0','0','0','1','4246','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('31499','»ٱչ˾','http://www.newchinalife.com/','1995','5','0','0','0','0','1','6297','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('31497','йƽչ˾','http://www.pa18.com/','1995','1','0','0','0','1','3','23830','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('16741','йũᱣ','http://www.molss.gov.cn/gb/ywzn/ncbx.htm','856','100','0','0','0','0','0','6','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46345','ô','http://www.haodf.com/','864','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46344','Ϲҩȫʾ','http://www.sda.gov.cn/WS01/CL0441/','864','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('3780','׶','http://www.mn81.com','1721','100','0','0','0','0','0','8088','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46343','ҽԺб','http://www.haodf.com/yiyuan/beijing/list.htm','864','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46362','39','http://bbs.39.net/','2384','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('3797','кҽ˲ҽԺ','http://www.panzhongheng.com','1721','100','0','0','0','0','0','1744','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('3804','ڹڽ','http://www.szhe.com','1739','100','0','0','0','0','0','1096','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('40555','йս','http://www.china1931.cn','1009','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('40553','ǿ','http://www.gtsky.com','1680','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('40548','ֽ','http://www.zhidiy.com','1717','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('34604','','http://www.51haha.net/','1930','13','0','0','0','1','4','1178','0','','','1','0','0','0','','0');
INSERT INTO yowao_site VALUES('34600','Ƹ̳','http://bbs.eastmoney.com/','1930','14','0','0','0','0','0','982','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('34597','Ѹ̳','http://bbs.xunlei.com/','1930','15','0','0','0','0','1','1745','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('34595','Ѫ̳','http://www.tiexue.net/','1930','9','0','0','0','1','24','119658','0','','','0','1','0','0','','0');
INSERT INTO yowao_site VALUES('34593','ͼͼ̳','http://bbs.tucoo.com/','1930','8','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('34579','Ͼպѧͼ','http://lib.nuaa.edu.cn/','955','63','0','0','0','0','0','87','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('34578','ϷѧԺͼ','http://lib.hfuu.edu.cn/','955','60','0','0','0','0','0','100','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('34576','պѧͼ','http://lib.buaa.edu.cn/','955','54','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('34583','ѧͼ','http://www.lib.scut.edu.cn/','955','75','0','0','0','0','0','1','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('34582','Ͼũҵѧͼ','http://libwww.njau.edu.cn/','955','68','0','0','0','0','0','58','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('34581','ʯׯѧԺͼ','http://lib.sjzri.edu.cn/','955','66','0','0','0','0','0','136','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46228','ҰҼװ̳','http://bbs.525j.com.cn/','879','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('33940','˹Ҷ[]','http://www.duma.gov.ru/','1833','1','0','0','0','0','0','142','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46227','','http://www.liba.com/','879','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('40569','԰ѧ','http://www.mktedu.com/','1052','5','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('33938','¹[]','http://www.bundesregierung.de/','1833','7','0','0','0','0','0','44','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('33929','˹ίԱ[]','http://council.gov.ru/','1833','4','0','0','0','0','0','44','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('33937','¹Ժ[]','http://www.bundesrat.de/','1833','8','0','0','0','0','0','12','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('31490','־','http://china.db.com/','1688','17','0','0','0','0','0','318','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('33980','ڸ[]','http://www.cabinet.gov.jm/','1834','100','0','0','0','0','0','24','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('33979','ôฮ[ô]','http://pm.gc.ca/','1834','100','0','0','0','0','0','46','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('33978','Ժ[]','http://www.senat.fr/','1833','14','0','0','0','0','0','6','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('33977','[]','http://www.stjr.is/','1833','15','0','0','0','0','0','27','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('33976','⽻[]','http://www.um.dk/','1833','16','0','0','0','0','0','4','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('33975','޵[]','http://www.vlada.hr/','1833','28','0','0','0','0','0','7','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('33974','ݿ[]','http://www.vlada.cz/','1833','35','0','0','0','0','0','8','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('33973','[]','http://www.valtioneuvosto.fi/','1833','36','0','0','0','0','0','17','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('33972','[]','http://www.urm.lt/','1833','37','0','0','0','0','0','14','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46078','ͳƷ','http://www.vancl.com/?source=kuku8','852','14','1','0','0','0','0','0','0','','yowao','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46209','׾','http://www.eeju.com/','881','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46208','ϴ','http://www.foloda.com/','881','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46207','','http://www.homelink.com.cn/','881','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('41352','ʱ','http://www.haibao.cn','735','7','0','0','0','0','0','0','0','','admin','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('4181','ڷ','http://www.fdc.com.cn','1778','11','0','0','0','0','0','1126','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('32973','ũҵ','http://www.961200.net/','2047','11','0','0','0','0','0','1297','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46206','ҰҼ','http://www.5i5j.com/','881','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('32971','ƽ','http://www.18ebank.com/','2047','10','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('32970','ҵ','http://www.hccb.com.cn/','2047','9','0','0','0','0','0','1144','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('32968','','http://www.nbcb.com.cn/','2047','8','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('32967','Ͼ','http://www.njcb.com.cn/','2047','7','0','0','0','0','1','1631','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('38456','ѯǷѱע','http://cp.35.com/chinese/chk_domain.html','1133','14','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('41324','֤ȯ','http://www.lhzq.com/','848','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46063','̻','http://www.cmfchina.com/','1649','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46062','ҵȫ','http://www.xyfunds.com.cn/','1649','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46401','˾','http://law.baidu.com/pages/chinalawinfo/2/40/4230a42973222c6a70cb5c29e1a698a6_0.html','913','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('41323','Ԫ֤ȯ','http://www.gyzq.com.cn/','848','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('41322','֤ȯ','http://www.essence.com.cn/','848','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('41321','֤ȯ','http://www.nesc.cn/','848','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('41320','ҵ֤ȯ','http://www.xyzq.com.cn/','848','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('33075','ְ Ƹ ','http://www.ggcp.com.cn/','1519','11','0','0','0','0','0','1285','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('36325','½ͨ','http://www.cttxj.com','2092','55','0','0','0','0','0','45','0','','yowao','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46458','','http://www.ryb-baby.com/','886','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46224','װͼ','http://www.tumanduo.com/','879','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('33982','Ű[]','http://www.cubaweb.cu/','1834','100','0','0','0','0','0','46','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('34003','[]','http://www.govt.nz/','1837','100','0','0','0','0','0','48','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('34002','Ĵ[Ĵ]','http://www.gov.au/','1837','100','0','0','0','0','0','63','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('34000','⽻[]','http://www.mfa.gov.eg/','1836','100','0','0','0','0','0','37','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('33999','Ϸ[Ϸ]','http://www.gov.za/','1836','100','0','0','0','0','0','36','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('34001','Ĵ⽻[Ĵ]','http://www.dfat.gov.au/','1837','100','0','0','0','0','0','18','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('33996','Ϸ⽻[Ϸ]','http://www.dfa.gov.za/','1836','100','0','0','0','0','0','23','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('33995','ͳ[]','http://www.planalto.gov.br/','1835','100','0','0','0','0','0','33','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('33969','Ӣʼ[Ӣ]','http://www.royal.gov.uk/','1833','18','0','0','0','0','0','59','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('33968','[]','http://www.regeringen.se/','1833','32','0','0','0','0','0','10','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('33993','͢ͳ[͢]','http://www.presidencia.gov.ar/','1835','100','0','0','0','0','0','27','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('33992','ױ[]','http://www.gobiernoenlinea.gov.co/','1835','100','0','0','0','0','0','12','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('33991','͢⽻[͢]','http://www.cancilleria.gov.ar/','1835','100','0','0','0','0','0','19','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('33990','׹[]','http://www.whitehouse.gov/','1834','100','0','0','0','0','0','177','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('34022','TOM-','http://ent.tom.com/tv/','752','10','0','0','0','0','0','5721','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46454','ⱦ','http://www.bbxpp.com/','886','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46455','ͯȫ','http://tieba.baidu.com/f?kz=184765810','886','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('36323','ͨ','http://www.cttnx.com','2092','6','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('35948','׿˲','http://www.jobcn.com/','958','6','0','0','0','3','13','24643','0','','','2','0','0','0','','0');
INSERT INTO yowao_site VALUES('46464','ѾѾͥ','http://bbs.iyaya.com/','888','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46462','ѺĸӤ','http://club.baby.sohu.com/','888','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('46463','','http://ww123.net/baby/','888','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('38297','','http://bbs.chaoshanren.com/','1955','25','0','0','0','0','0','917','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('4400','й','http://www.ccyl.org.cn','890','3','0','0','0','0','0','802','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('4409','й귢չ','http://www.cydf.org.cn','890','2','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('4425','Ѻ','http://travel.sohu.com','892','12','0','0','0','0','0','4218','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('33257','ξ','http://www.visitfinland.com.cn/','2052','3','0','0','0','0','0','132','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('4427','','http://travel.elong.com/','892','4','0','0','0','0','0','9454','0','','admin','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('33256','Ӣξ','http://www.visitbritain.cn/','2052','2','0','0','0','0','0','417','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('35068','켫簲ȫ','http://soft.yesky.com/security/','1139','7','0','0','0','0','0','1789','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('40410','ͨ','http://www.moc.gov.cn/','2240','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('40411','·Ϣ','http://www.chinahighway.gov.cn/','2240','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('36300','ͨ','http://www.cttbj.com','2092','1','0','0','0','0','0','12','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('4436',';','http://www.lotour.com/','892','9','0','0','0','0','0','6591','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('33254','ξ','http://cn.franceguide.com/','2052','1','0','0','0','0','0','673','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('33252','Խξ','http://www.vietnamtourism.com/','2051','12','0','0','0','0','0','380','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('33251','','http://www.visitmaldives.com/cn/','2051','11','0','0','0','0','0','427','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('33249','ξ','http://www.visitbrunei.cn/','2051','10','0','0','0','0','0','113','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('36310','ͨ','http://www.cttjs.com','2092','15','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('33279','³ξ','http://www.peru.info/','2054','6','0','0','0','0','0','59','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('40417','ź','http://www.xiamenair.com.cn/','2241','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('23226','179','http://www.179.com.tw/','1830','100','0','0','0','0','0','860','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('23225','̨۹ʿ','http://taiwantourbus.justaiwan.com/','1830','100','0','0','0','0','0','1333','0','','yowao','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('23224','̨۹Ѷ','http://www.taiwan.net.tw/','1830','100','0','0','0','0','0','1125','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('23223','̨','http://www.travel-web.com.tw/','1830','100','0','0','0','0','0','48','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('33292','','http://www.archos.com.cn/','1686','6','0','0','0','0','0','710','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('36297','ͨ','http://www.ctthlj.com','2092','5','0','0','0','0','0','44','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('33278','ξ','http://www.braziltourism.org/','2054','5','0','0','0','0','0','138','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('33277','ξ','http://www.gohawaii.cn/','2054','4','0','0','0','0','0','501','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('33276','īξ','http://www.visitmexico.com/wb/Visitmexico/Visi_Home?show=regions','2054','3','0','0','0','0','0','183','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('33275','͢','http://www.turismo.gov.ar/','2054','2','0','0','0','0','0','159','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('33274','ôξ','http://www.explore.canada.travel/ctc/ke/homepage.jsp?localeId=62','2054','1','0','0','0','0','0','348','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('33271','ξ','http://www.egypt.com/','2053','18','0','0','0','0','0','321','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('33270','Ϸξ','http://www.southafrica.net/index.cfm?CountryProfileID=65','2053','17','0','0','0','0','0','430','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('36299','ͨ','http://www.cttjl.com','2092','7','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('33268','ξ','http://www.visitdenmark.com/','2052','17','0','0','0','0','0','107','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('23192','й','http://spot.cnair.com/','2031','1','0','0','0','0','0','2050','0','','','0','0','0','0','','0');
INSERT INTO yowao_site VALUES('40408','','http://