<?php

	/*
	*	This source code is a part of the Ultimix Project. 
	*	It is distributed under BSD license. All other third side source code (like tinyMCE) is distributed under 
	*	it's own license wich could be found from the corresponding files or sources. 
	*	This source code is provided "as is" without any warranties or garanties.
	*
	*	Have a nice day!
	*
	*	@url http://ultimix.sorceforge.net
	*
	*	@author Alexey "gdever" Dodonov
	*/

	/**
	*	\~russian Класс обработки макросов мыши.
	*
	*	@author Додонов А.А.
	*/
	/**
	*	\~english Class processes mouse macro.
	*
	*	@author Dodonov A.A.
	*/
	class	mouse_markup_1_0_0
	{
		/**
		*	\~russian Функция компиляции макроса 'update_record'.
		*
		*	@param $Settings - Параметры.
		*
		*	@return Код макроса.
		*
		*	@exception Exception - Кидается иключение этого типа с описанием ошибки.
		*
		*	@author Додонов А.А.
		*/
		/**
		*	\~english Function compiles macro 'update_record'.
		*
		*	@param $Settings - Parameters.
		*
		*	@return HTML code.
		*
		*	@exception Exception - An exception of this type is thrown.
		*
		*	@author Dodonov A.A.
		*/
		function			compile_update_record( &$Settings )
		{
			try
			{
				$id = $Settings->get_setting( 'id' );
				$Prefix = $Settings->get_setting( 'prefix' );
				$Method = $Settings->get_setting( 'method' , 'post' );

				$Code  = "onclick=\"ultimix.forms.update_record( '$id' , '$Prefix' , '$Method' )\"";
				$Code .= " onmousemove=\"jQuery( this ).css( 'cursor' , 'pointer' );\"";

				return( $Code );
			}
			catch( Exception $e )
			{
				$a = func_get_args();_throw_exception_object( __METHOD__ , $a , $e );
			}
		}
	}

?>