<?php

	/*
	*	This source code is a part of the Ultimix Project. 
	*	It is distributed under BSD license. All other third side source code (like tinyMCE) is distributed under 
	*	it's own license wich could be found from the corresponding files or sources. 
	*	This source code is provided "as is" without any warranties or garanties.
	*
	*	Have a nice day!
	*
	*	@url http://ultimix.sorceforge.net
	*
	*	@author Alexey "gdever" Dodonov
	*/

	/**
	*	\~russian    .
	*
	*	@author  ..
	*/
	/**
	*	\~english Class processes gallery macro.
	*
	*	@author Dodonov A.A.
	*/
	class	gallery_markup_1_0_0{
	
		/**
		*	\~russian  .
		*
		*	@author  ..
		*/
		/**
		*	\~english Cached packages.
		*
		*	@author Dodonov A.A.
		*/
		var					$CachedMultyFS = false;
		var					$GalleryAccess = false;
		var					$GalleryAlgorithms = false;
		var					$Link = false;
		var					$String = false;

		/**
		*	\~russian .
		*
		*	@exception Exception       .
		*
		*	@author   ..
		*/
		/**
		*	\~english Constructor.
		*
		*	@exception Exception An exception of this type is thrown.
		*
		*	@author Dodonov A.A.
		*/
		function			__construct()
		{
			try
			{
				$this->CachedMultyFS = get_package_object( 'cached_multy_fs' , 'last' , __FILE__ );
				$this->GalleryAccess = get_package( 'gallery::gallery_access' , 'last' , __FILE__ );
				$this->GalleryAlgorithms = get_package( 'gallery::gallery_algorithms' , 'last' , __FILE__ );
				$this->Link = get_package( 'link' , 'last' , __FILE__ );
				$this->String = get_package( 'string' , 'last' , __FILE__ );
			}
			catch( Exception $e )
			{
				$a = func_get_args();_throw_exception_object( __METHOD__ , $a , $e );
			}
		}
		
		/**
		*	\~russian  
		*
		*	@param $MasterType -  .
		*
		*	@param $MasterId - Id .
		*
		*	@return  .
		*
		*	@exception Exception       .
		*
		*	@author  ..
		*/
		/**
		*	\~english Function creates gallery.
		*
		*	@param $MasterType - Object's type.
		*
		*	@param $MasterId - Object's id.
		*
		*	@return Gallery's id.
		*
		*	@exception Exception An exception of this type is thrown.
		*
		*	@author Dodonov A.A.
		*/
		private function	create_dependent_gallery( $MasterType , $MasterId )
		{
			try
			{	
				$Gallery = array( 
					'title' => "gallery for $MasterType|id=$MasterId" , 
					'description' => "description for $MasterType|id=$MasterId" 
				);
				
				$id = $this->GalleryAccess->create( $Gallery );
				
				$this->Link->create_link( $MasterId , $id , $MasterType , 'gallery' );
					
				return( $id );
			}
			catch( Exception $e )
			{
				$a = func_get_args();_throw_exception_object( __METHOD__ , $a , $e );
			}
		}
		
		/**
		*	\~russian    .    ,    .
		*
		*	@param $BlockSettings - .
		*
		*	@return  .
		*
		*	@exception Exception       .
		*
		*	@author  ..
		*/
		/**
		*	\~english Function returns id of the dependent gallery. Gallery will be created if necessary.
		*
		*	@param $BlockSettings - Parameters.
		*
		*	@return Gallery's id.
		*
		*	@exception Exception An exception of this type is thrown.
		*
		*	@author Dodonov A.A.
		*/
		function			get_dependent_gallery_id( &$BlockSettings )
		{
			try
			{
				$MasterType = $BlockSettings->get_setting( 'master_type' );
				$MasterId = $BlockSettings->get_setting( 'master_id' );

				if( $this->Link->link_exists( $MasterId , false , $MasterType , 'gallery' ) )
				{
					$Link = $this->Link->get_links( $MasterId , false , $MasterType , 'gallery' );

					return( get_field( $Link[ 0 ] , 'object2_id' ) );
				}
				else
				{
					return( $this->create_dependent_gallery( $MasterType , $MasterId ) );
				}
			}
			catch( Exception $e )
			{
				$a = func_get_args();_throw_exception_object( __METHOD__ , $a , $e );
			}
		}
		
		/**
		*	\~russian   .    ,    .
		*
		*	@param $BlockSettings - .
		*
		*	@return  .
		*
		*	@exception Exception       .
		*
		*	@author  ..
		*/
		/**
		*	\~english Function returns gallery object. Gallery will be created if necessary.
		*
		*	@param $BlockSettings - Parameters.
		*
		*	@return Gallery object.
		*
		*	@exception Exception An exception of this type is thrown.
		*
		*	@author Dodonov A.A.
		*/
		function			get_gallery( &$BlockSettings )
		{
			try
			{
				if( $BlockSettings->get_setting( 'master_id' , false ) === false )
				{
					$id = $BlockSettings->get_setting( 'id' );
				}
				else
				{
					$id = $this->get_dependent_gallery_id( $BlockSettings );
				}
				
				return( $this->GalleryAlgorithms->get_by_id( $id ) );
			}
			catch( Exception $e )
			{
				$a = func_get_args();_throw_exception_object( __METHOD__ , $a , $e );
			}
		}
		
		/**
		*	\~russian    .
		*
		*	@param $FilePath -   .
		*
		*	@param $GalleryId -  .
		*
		*	@return HTML  .
		*
		*	@exception Exception       .
		*
		*	@author  ..
		*/
		/**
		*	\~english GEtting template for the client.
		*
		*	@param $FilePath - Path to the template.
		*
		*	@param $GalleryId - Id of the gallery.
		*
		*	@return HTML code of the template.
		*
		*	@exception Exception An exception of this type is thrown.
		*
		*	@author Dodonov A.A.
		*/
		function			get_galery_template_for_client( $FilePath , $GalleryId )
		{
			try
			{
				$GalleryTemplate = $this->CachedMultyFS->file_get_contents( $FilePath );
				$GalleryTemplate = str_replace( '{gallery_id}' , $GalleryId , $GalleryTemplate );
				$GalleryTemplate = str_replace( '{id}' , '[id]' , $GalleryTemplate );
				$GalleryTemplate = str_replace( '{file_path}' , '[file_path]' , $GalleryTemplate );
				$GalleryTemplate = str_replace( '{original_file_name}' , '[original_file_name]' , $GalleryTemplate );
				$GalleryTemplate = str_replace( '{' , '[lfb]' , $GalleryTemplate );
				$GalleryTemplate = str_replace( '}' , '[rfb]' , $GalleryTemplate );
				
				return( $GalleryTemplate );
			}
			catch( Exception $e )
			{
				$a = func_get_args();_throw_exception_object( __METHOD__ , $a , $e );
			}
		}
		
		/**
		*	\~russian   .
		*
		*	@param $Gallery -  .
		*
		*	@param $Files -  .
		*
		*	@return  .
		*
		*	@exception Exception       .
		*
		*	@author  ..
		*/
		/**
		*	\~english Function compiles gallery.
		*
		*	@param $Gallery - Gallery object.
		*
		*	@param $Files - Gallery files.
		*
		*	@return Gallery parts.
		*
		*	@exception Exception An exception of this type is thrown.
		*
		*	@author Dodonov A.A.
		*/
		private function	compile_gallery_parts( $Gallery , $Files )
		{
			try
			{
				$Code = '';
				$FilePath = dirname( __FILE__ ).'/res/templates/simple_file_list.tpl';
				$id = get_field( $Gallery , 'id' );
				foreach( $Files as $i => $File )
				{
					$Code .= $this->CachedMultyFS->file_get_contents( $FilePath );
					$Code  = $this->String->print_record( $Code , $File );
				}
				$Code  = str_replace( '{gallery_id}' , $id , $Code );
				
				$Input  = "{file_input:file_types=images;upload_url=gallery_upload.html?gallery_id[eq]{gallery_id};";
				$Input .= "upload_success_handler=ultimix_file_input_view_after_image_upload_processor}";
				return( array( $Code , str_replace( '{gallery_id}' , $id , $Input ) ) );
			}
			catch( Exception $e )
			{
				$a = func_get_args();_throw_exception_object( __METHOD__ , $a , $e );
			}
		}
		
		/**
		*	\~russian   .
		*
		*	@param $Gallery -  .
		*
		*	@param $Files -  .
		*
		*	@return HTML  .
		*
		*	@exception Exception       .
		*
		*	@author  ..
		*/
		/**
		*	\~english Function compiles gallery.
		*
		*	@param $Gallery - Gallery object.
		*
		*	@param $Files - Gallery files.
		*
		*	@return HTML code of the gallery.
		*
		*	@exception Exception An exception of this type is thrown.
		*
		*	@author Dodonov A.A.
		*/
		private function	compile_gallery_files( $Gallery , $Files )
		{
			try
			{
				list( $Code , $Input ) = $this->compile_gallery_parts( $Gallery , $Files );

				$Template = $this->get_galery_template_for_client( $FilePath , $GalleryId );

				$Gallery = $this->CachedMultyFS->get_teplate( __FILE__ , 'gallery.tpl' );
				$PlaceHolders = array( '{code}' , '{gallery_template}' , '{input}' );
				$Gallery = str_replace( $PlaceHolders , array( $Code , $Template , $Input ) , $Gallery );
				$Gallery = str_replace( '{gallery_id}' , $GalleryId , $Gallery );
				
				return( $Template );
			}
			catch( Exception $e )
			{
				$a = func_get_args();_throw_exception_object( __METHOD__ , $a , $e );
			}
		}

		/**
		*	\~russian  .
		*
		*	@param $Settings -  .
		*
		*	@return .
		*
		*	@exception Exception -       .
		*
		*	@author  ..
		*/
		/**
		*	\~english Function processes macro 'radio'.
		*
		*	@param $Settings - Compilation parameters.
		*
		*	@return Control.
		*
		*	@exception Exception - An exception of this type is thrown.
		*
		*	@author Dodonov A.A.
		*/
		function			compile_gallery( &$Settings )
		{
			try
			{
				$Gallery = $this->get_gallery( $Settings );

				$Files = $this->GalleryAlgorithms->get_gallery_files( get_field( $Gallery , 'id' ) );

				$Code = $this->compile_gallery_files( $Gallery , $Files );

				return( $Code );
			}
			catch( Exception $e )
			{
				$a = func_get_args();_throw_exception_object( __METHOD__ , $a , $e );
			}
		}
	}
?>