<script>
	jQuery(
		function()
		{
			jQuery( document ).mousemove(
				function( e )
				{
					if( e.pageY <= 5 )
					{
						jQuery( '#prevent_from_leaving' ).modal(
							{
								onOpen : ultimix.ModalOpen ,
								onClose : ultimix.ModalClose
							}
						);
					}
				}
			);
		}
	);

	/**
	* When the open event is called, this function will be used to 'open'
	* the overlay, container and data portions of the modal dialog.
	*
	* onOpen callbacks need to handle 'opening' the overlay, container
	* and data.
	*/
	ultimix.ModalOpen = function( dialog )
	{
		dialog.overlay.fadeIn( 
			'fast' ,
			function()
			{
				dialog.container.fadeIn(
					'fast' , 
					function()
					{
						dialog.data.hide().slideDown( 'fast' );
					}
				);
			}
		);
	}

	/**
	* When the close event is called, this function will be used to 'close'
	* the overlay, container and data portions of the modal dialog.
	*
	* The SimpleModal close function will still perform some actions that
	* don't need to be handled here.
	*
	* onClose callbacks need to handle 'closing' the overlay, container
	* and data.
	*/
	ultimix.ModalClose = function( dialog )
	{
		dialog.data.fadeOut(
			'fast' ,
			function ()
			{
				dialog.container.hide(
					'fast' ,
					function ()
					{
						dialog.overlay.slideUp(
							'fast', 
							function ()
							{
								jQuery.modal.close();
							}
						);
					}
				);
			}
		);
	}
</script>

<div class="hidden" id="prevent_from_leaving"></div>