<?php

	/*
	*	This source code is a part of the Ultimix Project. 
	*	It is distributed under BSD licence. All other third side source code (like tinyMCE) is distributed under 
	*	it's own licence wich could be found from the corresponding files or sources. 
	*	This source code is provided "as is" without any warranties or garanties.
	*
	*	Have a nice day!
	*
	*	@url http://ultimix.sorceforge.net
	*
	*	@author Alexey "gdever" Dodonov
	*/

	require_once( './packages/core/core.php' );
	require_once( './include/php/startup.php' );

	@unlink( './packages/cache/data/cache' );
	@unlink( './packages/cache/data/table' );

	/**
	*	 .
	*
	*	@author  ..
	*/
	/**
	*	First step.
	*
	*	@author Dodonov A.A.
	*/
	function			install_step_1()
	{
		$CachedFS = get_package( 'cached_fs' );
		$Page = $CachedFS->file_get_contents( "./install/res/templates/install_template_1.tpl" );
		print( $Page );
		exit( 0 );
	}

	/**
	*	 ,       .
	*
	*	@param $Silent -  .
	*
	*	@author  ..
	*/
	/**
	*	Function process connection errors.
	*
	*	@param $Silent - Silent processing.
	*
	*	@author Dodonov A.A.
	*/
	function			handle_connection_error( $Silent )
	{
		if( $Silent === false )
		{
			$CachedFS = get_package( 'cached_fs' );
			$Page = $CachedFS->file_get_contents( "./install/res/templates/install_template_2.tpl" );
			$Page = str_replace( '{error_message}' , 'An error occured while database connection' , $Page );

			$Security = get_package( 'security' );

			$PlaceHolders = array( '{host}' , '{database}' , '{prefix}' , '{user}' , '{password}' );
			$Data = array( 
				$Security->get_gp( 'host' , 'string' , '' ) , $Security->get_gp( 'database' , 'string' , '' ) , 
				$Security->get_gp( 'prefix' , 'string' , '' ) , $Security->get_gp( 'user' , 'string' , '' ) , 
				$Security->get_gp( 'password' , 'string' , '' )
			);
			$Page = str_replace( $PlaceHolders , $Data , $Page );

			print( $Page );
			exit( 0 );
		}
	}

	/**
	*	   .
	*
	*	@param $Host - .
	*
	*	@param $Database -  .
	*
	*	@param $Prefix -  .
	*
	*	@param $User - .
	*
	*	@param $Password - .
	*
	*	@param $Silent -  .
	*
	*	@author  ..
	*/
	/**
	*	Function process step 2.
	*
	*	@param $Host - Host.
	*
	*	@param $Database - Database.
	*
	*	@param $Prefix - Tables'es prefix.
	*
	*	@param $User - User.
	*
	*	@param $Password - Password.
	*
	*	@param $Silent - Silent processing.
	*
	*	@author Dodonov A.A.
	*/
	function			handle_step_2( $Host , $Database , $Prefix , $User , $Password , $Silent = false )
	{
		$DatabaseAlgorithms = get_package( 'database::database_algorithms' , 'last' , __FILE__ );
		$CachedFS = get_package( 'cached_fs' );
		$CachedFS->file_put_contents( 
			"packages/_core_data/conf/cf_mysql_database" , "$Host#$User#$Password#$Database#$Prefix"
		);

		if( $DatabaseAlgorithms->try_connect() )
		{
			$DBScript = file_get_contents( './install/sql/data.sql' , 'cleaned' );
			$DBScript = str_replace( '{prefix}' , $Prefix , $DBScript );
			$DatabaseAlgorithms->execute_query_set( $DBScript );
			if( $Silent === false )
			{
				header( 'Location: ./install.php?page=3' );
				exit( 0 );
			}
		}
		else
		{
			handle_connection_error( $Silent );
		}
	}

	/**
	*	    .
	*
	*	@author  ..
	*/
	/**
	*	Show form for the second step.
	*
	*	@author Dodonov A.A.
	*/
	function				show_step_2_form()
	{
		$CachedFS = get_package( 'cached_fs' );
		$Page = $CachedFS->file_get_contents( "./install/res/templates/install_template_2.tpl" );

		$Needles = array( '{host}' , '{user}' , '{password}' , '{database}' , '{prefix}' , '{error_message}' );

		$Config = $CachedFS->file_get_contents( "packages/_core_data/conf/cf_mysql_database" );
		$Replacements = array_merge( explode( '#' , $Config ) , array( '' ) );

		print( str_replace( $Needles , $Replacements , $Page ) );
		exit( 0 );
	}

	/**
	*	 .
	*
	*	@param $Silent -  .
	*
	*	@author  ..
	*/
	/**
	*	Second step.
	*
	*	@param $Silent - Silent processing.
	*
	*	@author Dodonov A.A.
	*/
	function			install_step_2( $Silent = false )
	{
		$Security = get_package( 'security' );

		if( $Security->get_gp( 'setup_db' ) )
		{
			handle_step_2( 
				$Security->get_gp( 'host' , 'string' , '' ) , $Security->get_gp( 'database' , 'string' , '' ) , 
				$Security->get_gp( 'prefix' , 'string' , '' ) , $Security->get_gp( 'user' , 'string' , '' ) , 
				$Security->get_gp( 'password' , 'string' , '' ) , $Silent
			);
		}
		else
		{
			show_step_2_form();
		}
	}

	/**
	*	   .
	*
	*	@param $HttpHost - .
	*
	*	@param $Silent -  .
	*
	*	@author  ..
	*/
	/**
	*	Function process step 3.
	*
	*	@param $HttpHost - Host.
	*
	*	@param $Silent - Silent processing.
	*
	*	@author Dodonov A.A.
	*/
	function			handle_step_3( $HttpHost , $Silent = false )
	{
		$HttpHost = rtrim( $HttpHost , '/\\' );
		$HtAccess = file_get_contents( './install/res/templates/tpl.htaccess' );
		$HtAccess = str_replace( '{http_host}' , $HttpHost , $HtAccess );
		$Result = @file_put_contents( '.htaccess' , $HtAccess );

		if( $Result === false && $Silent === false )
		{
			print( install_step_3_form( $HttpHost , 'Can\'t access .htaccess' ) );
			return;
		}

		file_put_contents( 
			'./packages/_core_data/conf/cf_settings' , "HTTP_HOST=$HttpHost\r\nGZIP_TRAFFIC=false"
		);

		if( $Silent === false )
		{
			header( 'Location: ./install.php?page=4' );
			exit( 0 );
		}
	}

	/**
	*	  .
	*
	*	@param $HttpHost - .
	*
	*	@param $ErrorMessage -   .
	*
	*	@author  ..
	*/
	/**
	*	Third step form.
	*
	*	@param $HttpHost - Host.
	*
	*	@param $ErrorMessage - Error message.
	*
	*	@author Dodonov A.A.
	*/
	function			install_step_3_form( $HttpHost , $ErrorMessage )
	{
		$CachedFS = get_package( 'cached_fs' );

		$HttpHost = $HttpHost ? $HttpHost : 
						rtrim( 'http://'.$_SERVER[ 'SERVER_NAME' ].dirname( $_SERVER[ 'REQUEST_URI' ] ) , '/\\' );

		$Page = $CachedFS->file_get_contents( "./install/res/templates/install_template_3.tpl" );
		$Page = str_replace( array( '{http_root}' , '{error_message}' ) , array( $HttpHost , $ErrorMessage ) , $Page );

		return( $Page );
	}
	
	/**
	*	 .
	*
	*	@param $HttpHost - .
	*
	*	@param $Silent -  .
	*
	*	@param $ErrorMessage -   .
	*
	*	@author  ..
	*/
	/**
	*	Third step.
	*
	*	@param $HttpHost - Host.
	*
	*	@param $Silent - Silent processing.
	*
	*	@param $ErrorMessage - Error message.
	*
	*	@author Dodonov A.A.
	*/
	function			install_step_3( $HttpHost , $Silent = false , $ErrorMessage = false )
	{
		if( $HttpHost === false )
		{
			if( $Silent === false )
			{
				$Page = install_step_3_form( $HttpHost , $ErrorMessage );
				print( $Page );
				exit( 0 );
			}
		}
		else
		{
			handle_step_3( $HttpHost , $Silent );
		}
	}

	/**
	*	 .
	*
	*	@author  ..
	*/
	/**
	*	Forth step.
	*
	*	@author Dodonov A.A.
	*/
	function			install_step_4()
	{
		$CachedFS = get_package( 'cached_fs' );
		$Page = $CachedFS->file_get_contents( "./install/res/templates/install_template_4.tpl" );
		print( $Page );
		exit( 0 );
	}

	/**
	*	 .
	*
	*	@param $HttpHost - .
	*
	*	@param $Silent -  .
	*
	*	@author  ..
	*/
	/**
	*	Third step.
	*
	*	@param $HttpHost - Host.
	*
	*	@param $Silent - Silent processing.
	*
	*	@author Dodonov A.A.
	*/
	function			handle_installation_steps()
	{
		$Security = get_package( 'security' );
		$Page = $Security->get_gp( 'page' , 'integer' , 1 );

		switch( $Page )
		{
			case( 1 ):install_step_1();break;

			case( 2 ):install_step_2( false );break;

			case( 3 ):install_step_3( $Security->get_gp( 'http_root' , 'string' , false ) , false , false );break;

			case( 4 ):install_step_4();break;
		}
	}

	/**
	*	  .
	*
	*	@author  ..
	*/
	/**
	*	Function runs installation wizard.
	*
	*	@author Dodonov A.A.
	*/
	function			run_installation_wizard()
	{
		try
		{
			if( isset( $_GET[ 'auto_install' ] ) === true )
			{
				$DBS = file_get_contents( './install/conf/cf_db_settings' );
				$DBS = explode( '#' , $DBS );

				install_step_2( $DBS[ 0 ] , $DBS[ 1 ] , $DBS[ 2 ] , $DBS[ 3 ] , $DBS[ 4 ] , true );

				$HttpHost = rtrim( 'http://'.$_SERVER[ 'SERVER_NAME' ].dirname( $_SERVER[ 'REQUEST_URI' ] ) , '/\\' );
				install_step_3( $HttpHost , true );
			}
			else
			{
				handle_installation_steps();
			}
		}
		catch( Exception $e )
		{
			handle_script_error( true , $e );
		}
	}

	start_php_script();

	/* running wizard */
	run_installation_wizard();
?>