/*
 * This code has been copied from Project_CMS
 * Copyright (c) 2005 by Phillip Berndt (www.pberndt.com)
 *
 * Extended Textarea for IE and Firefox browsers
 * Features:
 *  - Possibility to place tabs in <textarea> elements using a simply <TAB> key
 *  - Auto-indenting of new lines
 *
 * License: GNU General Public License
 */

function checkBrowser()	{
	browserName = navigator.appName;
	browserVer = parseInt(navigator.appVersion);

	ok=false;
	if (browserName == "Microsoft Internet Explorer" && browserVer >= 4)	ok=true;
	else if (browserName == "Netscape" && browserVer >= 3)	ok=true;

	return ok;
}

	// Automatically change all textarea elements
function changeTextareaElements()	{
	if(!checkBrowser()) return false;	// Stop unless we're using IE or Netscape (includes Mozilla family)

	document.textAreas = document.getElementsByTagName("textarea");

	for(i=0; i<document.textAreas.length; i++)	{
			// Only change if the class parameter contains "enable-tab"
		if(document.textAreas[i].className && document.textAreas[i].className.search(/(^| )enable-tab( |$)/) != -1)	{
			document.textAreas[i].textAreaID = i;
			makeAdvancedTextArea(document.textAreas[i]);
		}
	}
}

	// Wait until the document is completely loaded.
	// Set a timeout instead of using the onLoad() event because it could be used by something else already.
window.setTimeout("changeTextareaElements();", 200);

	// Turn textarea elements into "better" ones. Actually this is just adding some lines of JavaScript...
function makeAdvancedTextArea(textArea)	{
	if(textArea.tagName.toLowerCase() != "textarea") return false;

		// On attempt to leave the element:
		// Do not leave if this.dontLeave is true
	textArea.onblur = function(e)	{
		if(!this.dontLeave) return;
		this.dontLeave = null;
		window.setTimeout("document.textAreas[" + this.textAreaID + "].restoreFocus()", 1);
		return false;
	}

		// Set the focus back to the element and move the cursor to the correct position.
	textArea.restoreFocus = function()	{
		this.focus();

		if(this.caretPos)	{
			this.caretPos.collapse(false);
			this.caretPos.select();
		}
	}

		// Determine the current cursor position
	textArea.getCursorPos = function()	{
		if(this.selectionStart)	{
			currPos = this.selectionStart;
		} else if(this.caretPos)	{	// This is very tricky in IE :-(
			oldText = this.caretPos.text;
			finder = "--getcurrpos" + Math.round(Math.random() * 10000) + "--";
			this.caretPos.text += finder;
			currPos = this.value.indexOf(finder);

			this.caretPos.moveStart('character', -finder.length);
			this.caretPos.text = "";

			this.caretPos.scrollIntoView(true);
		} else return;

		return currPos;
	}

		// On tab, insert a tabulator. Otherwise, check if a slash (/) was pressed.
	textArea.onkeydown = function(e)	{
		if(this.selectionStart == null &! this.createTextRange) return;
		if(!e) e = window.event;

			// Tabulator
		if(e.keyCode == 9)	{
			this.dontLeave = true;
			this.textInsert(String.fromCharCode(9));
		}

			// Newline
		if(e.keyCode == 13)	{
				// Get the cursor position
			currPos = this.getCursorPos();

				// Search the last line
			lastLine = "";
			for(i=currPos-1;i>=0;i--)	{
				if(this.value.substring(i, i + 1) == '\n') break;
			}
			lastLine = this.value.substring(i + 1, currPos);

				// Search for whitespaces in the current line
			whiteSpace = "";
			for(i=0;i<lastLine.length;i++)	{
				if(lastLine.substring(i, i + 1) == '\t') whiteSpace += "\t";
				else if(lastLine.substring(i, i + 1) == ' ') whiteSpace += " ";
				else break;
			}

				// Another ugly IE hack
			if(navigator.appVersion.match(/MSIE/))	{
				whiteSpace = "\\n" + whiteSpace;
			}

				// Insert whitespaces
			window.setTimeout("document.textAreas["+this.textAreaID+"].textInsert(\""+whiteSpace+"\");", 1);
		}
	}

		// Save the current cursor position in IE
	textArea.onkeyup = textArea.onclick = textArea.onselect = function(e)	{
		if(this.createTextRange)	{
			this.caretPos = document.selection.createRange().duplicate();
		}
	}

		// Insert text at the current cursor position
	textArea.textInsert = function(insertText)	{
		if(this.selectionStart != null)	{
			var savedScrollTop = this.scrollTop;
			var begin = this.selectionStart;
			var end = this.selectionEnd;
			if(end > begin + 1)	{
				this.value = this.value.substr(0, begin) + insertText + this.value.substr(end);
			} else {
				this.value = this.value.substr(0, begin) + insertText + this.value.substr(begin);
			}

			this.selectionStart = begin + insertText.length;
			this.selectionEnd = begin + insertText.length;
			this.scrollTop = savedScrollTop;
		} else if(this.caretPos)	{
			this.caretPos.text = insertText;
			this.caretPos.scrollIntoView(true);
		} else {
			text.value += insertText;
		}

		this.focus();
	}
}
