/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;


DROP TABLE IF EXISTS `languages`;
CREATE TABLE IF NOT EXISTS `languages` (
  `lang_code` varchar(8) CHARACTER SET latin1 NOT NULL,
  `lang_name` varchar(24) COLLATE utf8_unicode_ci DEFAULT NULL,
  `lang_show` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `RTL` tinyint(1) NOT NULL DEFAULT '0',
  `translated` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`lang_code`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `languages` (`lang_code`, `lang_name`, `lang_show`, `RTL`, `translated`) VALUES
('en', 'English', 'English', 0, 1),
('de', 'German', 'Deutsch', 0, 1),
('fr', 'French', 'Français', 0, 1),
('it', 'Italian', 'italiano', 0, 1),
('es', 'Spanish', 'español', 0, 1),
('pl', 'Polish', 'polski', 0, 1),
('ru', 'Russian', 'Русский язык', 0, 1),
('hi', 'Hindi', 'हिन्दी', 0, 0),
('ar', 'Arabic', 'العربية', 1, 1),
('pt', 'Portuguese', 'português', 0, 1),
('sv', 'Swedish', 'Svenska', 0, 1),
('no', 'Norwegian', 'Norsk', 0, 0),
('da', 'Danish', 'dansk', 0, 1),
('fi', 'Finnish', 'suomi', 0, 0),
('hu', 'Hungarian', 'magyar', 0, 1),
('nl', 'Dutch', 'Nederlands', 0, 1),
('sr', 'Serbian', 'српски', 0, 0),
('bg', 'Bulgarian', 'български', 0, 1),
('uk', 'Ukrainian', 'Українська', 0, 0),
('el', 'Greek', 'ελληνικά', 0, 1),
('he', 'Hebrew', 'עברית / עִבְרִית', 1, 1),
('ko', 'Korean', '한국어 [韓國語]', 0, 0),
('zh', 'Chinese (Simplified)', '中文（简体）', 0, 1),
('ja', 'Japanese', '日本語 ', 0, 1),
('tl', 'Tagalog', 'Tagalog', 0, 0),
('id', 'Indonesian', 'Bahasa Indonesia', 0, 1),
('fa', 'Farsi', 'پارسی', 1, 1),
('th', 'Thai', 'ภาษาไทย', 0, 0),
('ro', 'Romanian', 'română', 0, 1),
('tr', 'Turkish', 'Türkçe', 0, 1),
('hr', 'Croatian', 'Hrvatski', 0, 0),
('mk', 'Macedonian', 'македонски', 0, 0),
('bs', 'Bosnian', 'Bosanski', 0, 0),
('sq', 'Albanian', 'shqip', 0, 0),
('sw', 'Swahili', 'Kiswahili', 0, 0),
('hy', 'Armenian', 'Հայերէն', 0, 0),
('cs', 'Czech', 'čeština', 0, 1),
('sk', 'Slovak', 'slovenčina', 0, 1),
('cn', 'Chinese (Traditional)', '中文（繁體）', 0, 1),
('pt-br', 'Portuguese - Brazil', 'português brasileiro', 0, 1),
('vn', 'Vietnamese', 'Việt', 0, 1),
('es-ar', 'Spanish Argentina', 'español rioplatense', 0, 1),
('sl', 'Slovenian', 'slovenščina', 0, 1),
('lt', 'Lithuanian', 'lietuvių kalba', 0, 1),
('ca', 'Catalan', 'Català', 0, 0);

DROP TABLE IF EXISTS `texts`;
CREATE TABLE IF NOT EXISTS `texts` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `lang_code` varchar(8) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'en',
  `category` varchar(32) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'common',
  `label` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `content` text COLLATE utf8_unicode_ci,
  `changed` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `language_id` (`lang_code`,`category`,`label`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=13253 ;

INSERT INTO `texts` (`id`, `lang_code`, `category`, `label`, `content`, `changed`) VALUES
(1, 'en', 'common', 'lang', 'Language', '2010-09-08 07:37:53'),
(2, 'de', 'common', 'lang', 'Sprache', '2016-01-02 23:21:04'),
(3, 'fr', 'common', 'lang', 'Langue', '2016-12-09 18:11:57'),
(4, 'en', 'common', 'contact', 'Contact', '2010-09-08 08:08:36'),
(5, 'en', 'common', 'help', 'Help', '2010-09-08 08:09:00'),
(6, 'en', 'common', 'forum', 'Forum', '2010-09-08 08:09:19'),
(7, 'en', 'common', 'signin', 'Sign in', '2010-09-08 08:09:50'),
(8, 'en', 'common', 'Sign out', 'Sign out', '2010-09-08 08:11:47'),
(9, 'en', 'common', 'Seo Tools', 'Seo Tools', '2010-09-08 08:13:44'),
(10, 'en', 'common', 'Seo Plugins', 'Seo Plugins', '2010-09-08 08:13:57'),
(11, 'en', 'common', 'Support', 'Support', '2010-09-08 08:14:15'),
(12, 'en', 'common', 'Donate', 'Donate', '2010-09-08 08:14:25'),
(13, 'en', 'common', 'My Account', 'My Account', '2010-09-08 08:14:38'),
(14, 'en', 'common', 'Sign Up', 'Sign Up', '2010-09-08 08:14:49'),
(15, 'fr', 'common', 'Support', 'Support', '2016-12-09 18:11:57'),
(16, 'en', 'common', 'User Panel', 'User Panel', '2010-09-08 08:25:16'),
(17, 'en', 'common', 'Admin Panel', 'Admin Panel', '2010-09-08 08:25:37'),
(18, 'en', 'common', 'copyright', 'Copyright &#169; [year] www.seopanel.in All rights reserved', '2010-09-08 08:29:30'),
(19, 'en', 'home', 'home_cont1', '<h1 style="text-align: center;margin-bottom: 30px;font-size: 19px;">Welcome to Seo Panel - World''s first seo control panel for multiple websites</h1>\r\n		<p>\r\n			A complete <b>open source seo control panel</b> for managing <b>search engine optimization</b> of your websites. \r\n			Seo Panel is a <b>seo tool kit</b> includes latest hot seo tools to <b>increase and track</b> the <b>performace</b> of your websites.\r\n			It is a <b>free software</b> released under <b>GNU GENERAL PUBLIC LICENSE</b>.\r\n			The main feature of seo panel is its <b>extendability</b> by using <a href="<?=SP_PLUGINSITE?>" target="_blank">seo plugins</a>.\r\n			Any one can easily <b>develop and install</b> required plugins for their seo panel. \r\n		</p>\r\n		<p></p>\r\n		<p>\r\n			This open source software was <b>released on January 2010</b>.\r\n			With in this <b>short period</b> of  time <b>thousands</b> of <b>web masters</b> are using this software for <b>optimizing</b> their websites.\r\n			Use seo panel today itself and <b>enjoy</b> everything related to seo under a <b>single platform</b>.\r\n		</p>', '2010-09-08 08:43:06'),
(20, 'en', 'home', 'home_cont2', '<fieldset>\r\n<legend>Major Features of Seo Panel <?=SP_INSTALLED?></legend>\r\n<ul class="infobox">\r\n	<li>		\r\n		<h1>Automatic Directory Submission Tool</h1>\r\n		<p>\r\n			Automatic directory submission tool help us to <b>submit our websites</b> into to major <b>free and paid internet directories</b>.\r\n			We can also <b>track the status</b> of each submision through <b>periodical check</b> using submission <b>status checker script</b>.\r\n			<b>Directory manager</b> will help us to find out whether <b>directory is active</b> or not.\r\n		</p>\r\n	</li>\r\n	<li>		\r\n		<h1>Keyword Position Checker</h1>\r\n		<p>\r\n			Keyword position checker will find the <b>search engine position</b> of <b>targetted keywords</b> of your website and <b>stores</b> it in the system.\r\n			In keyword position reports section, we can see the <b>daily positions</b> of keywords in different search engines by <b>beautiful graphs</b> and <b>detailed reports</b>.\r\n		</p>\r\n	</li>\r\n	<li>		\r\n		<h1>Site Auditor</h1>\r\n		<p>Site Auditor will <b>audit all SEO factors</b> of each pages of a site and will give a <b>detailed report</b> about each page. This will help us to create <b>XML,HTML,TEXT</b> sitemap files of our website for <b>submit</b> to search engines.</p>\r\n	</li>\r\n	<li>		\r\n		<h1>Google and Alexa Rank Checker</h1>\r\n		<p>\r\n			Google and alexa rank checker will find <b>google pagerank</b> and <b>alexa rank</b> of our websites and <b>stores</b> it in the system.\r\n			In <b>rank reports</b> section, we can see the <b>daily</b> google and alexa rank of each website by <b>detailed reports</b>.\r\n		</p>\r\n	</li>\r\n	<li>		\r\n		<h1>Backlinks Checker</h1>\r\n		<p>\r\n			Backlinks checker will find <b>number of backlinks</b> of our websites in different search engines<b>(google,yahoo,msn etc)</b> and <b>stores</b> it in the system.\r\n			<br>In <b>backlink reports</b> section, we can see the <b>daily backlinks count</b> of each website by <b>detailed reports</b>.\r\n		</p>\r\n	</li>	\r\n	<li>		\r\n		<h1>Search Engine Saturation Checker</h1>\r\n		<p>\r\n			Search Engine Saturation checker will find <b>number of indexed pages</b> of our websites in different search engines<b>(google,yahoo,msn etc)</b> and <b>stores</b> it in the system.\r\n			In <b>search engine saturation checker reports</b> section, we can see the <b>daily indexed page count</b> of each website by <b>detailed reports</b>.\r\n		</p>\r\n	</li>\r\n	<li>		\r\n		<h1>Seo Panel Plugins</h1>\r\n		<p>\r\n			The <b>major feature</b> of seo control panel is its <b>extentability</b>.\r\n			Add <b>seo plugins</b> to your seo panel to <b>extend the features</b> according to your requirement.\r\n			<a href="<?=SP_PLUGINSITE?>" target="_blank">Seo panel plugins</a> are provided by both seo panel and third party sites.\r\n			You can also easily <b>develop</b> seo plugins for your seo panel.\r\n			You can <a href="<?=SP_PLUGINSITE?>" target="_blank">submit</a> your seo plugin to seo panel and we will <b>publish</b> it in our website after our <b>review</b> process.\r\n		</p>\r\n	</li>\r\n	<li>		\r\n		<h1>Meta Tag Generator</h1>\r\n		<p>\r\n			Meta tag generator is a <b>seo panel plugin</b> for creating <b>custom meta tags</b> for our site.\r\n			It will help us to give <b>more information</b> about our website to <b>search engine bots</b> while they crawl our website.\r\n		</p>\r\n	</li>\r\n</ul>\r\n</fieldset>', '2011-07-05 08:50:22'),
(21, 'en', 'home', 'home_cont3', '<fieldset>\r\n<legend>Seo Panel Online Resources</legend>	\r\n<ul class="infobox">\r\n\r\n	<li>\r\n		<h1>Seo Panel Online Resources for Reference</h1>				\r\n		\r\n		\r\n		<p>\r\n			<a href="http://www.seopanel.in" target="_blank">Seo Panel Official Site</a>\r\n		</p>\r\n		<p>\r\n			<a href="<?=SP_DOWNLOAD_LINK?>" target="_blank">Download Seo Panel</a>\r\n		</p>\r\n		\r\n		<p>\r\n			<a href="<?=SP_DEMO_LINK?>" target="_blank">Seo Panel Demo</a>\r\n		</p>\r\n		\r\n		<p>\r\n			<a href="<?=SP_CONTACT_LINK?>" target="_blank">Conatct Seo Panel</a>\r\n		</p>\r\n		\r\n		<p>\r\n			<a href="<?=SP_HELP_LINK?>" target="_blank">Seo Panel Help Guide</a>\r\n		</p>\r\n		\r\n		<p>\r\n			<a href="<?=SP_FORUM_LINK?>" target="_blank">Seo Panel Forum</a>\r\n		</p>\r\n		\r\n		<p>\r\n			<a href="<?=SP_SUPPORT_LINK?>" target="_blank">Seo Panel Support System</a>\r\n		</p>\r\n		\r\n		<p>\r\n			<a href="<?=SP_DONATE_LINK?>" target="_blank">Donate to Seo Panel</a>\r\n		</p>\r\n	</li>\r\n	\r\n</ul>\r\n</fieldset>', '2010-09-08 08:54:46'),
(22, 'en', 'support', 'support_cont1', '<fieldset>\r\n<legend>Seo Panel Support System</legend>\r\n<ul class="infobox">\r\n	<li>\r\n		<h1>Seo Panel All Plugin Tool kit</h1> \r\n		<p>\r\n			It includes most of the plugins developed by seo panel team for just <font class="success bold" size="14">$160</font> includes <b>Membership Subscription</b>,<b>themes</b> etc.\r\n		</p>		\r\n		<p>\r\n			<a href="http://www.seopanel.in/plugin/l/75/" target="_blank">Visit this link to order it</a>\r\n		</p>\r\n		<br>\r\n	</li>\r\n	\r\n	<li>\r\n		<h1>Local Search Engines Package</h1> \r\n		<p>\r\n			Add <b>local search engine domains</b> of google,yahoo,msn(<b>eg: www.google.de,www.google.fr etc</b>) to seo panel <b>keyword position checker</b>, to track your site perfomance locally.\r\n			To get local search engines package(according to your requirement) please <a href="<?=SP_DONATE_LINK?>" target="_blank">donate</a> $10 or more to improve the features of seo panel.\r\n			Before sending donation, please <a href="<?=SP_CONTACT_LINK?>" target="_blank">contact us</a> to provide us required search engine domain list.\r\n			<br><br>			  \r\n			Also to add <b>new search engines(eg:baidu.com)</b> to your seo panel keyword position checker, please <a href="<?=SP_CONTACT_LINK?>" target="_blank">contact us</a> or open a ticket in <a href="<?=SP_SUPPORT_LINK?>" target="_blank">support system</a>. \r\n		</p>		\r\n		<p class="visit">\r\n			<a href="<?=SP_CONTACT_LINK?>" target="_blank">Visit this link to contact us</a>\r\n		</p>\r\n		<br>\r\n	</li>\r\n	\r\n	<li>\r\n		<h1>Seo Panel Plugins</h1> \r\n		<p>\r\n			Add <b>seo plugins</b> to your seo panel to <b>extend the features</b> according to your requirement.\r\n			<a href="<?=SP_PLUGINSITE?>" target="_blank">Seo panel plugins</a> are provided by both seo panel and third party sites.\r\n			You can also easily <b>develop</b> seo plugins for your seo panel.\r\n			You can <a href="<?=SP_PLUGINSITE?>" target="_blank">submit</a> your seo plugin to seo panel and we will <b>publish</b> it in our website after our <b>review</b> process.        \r\n		</p>		\r\n		<p>\r\n			<a href="<?=SP_PLUGINSITE?>" target="_blank">Visit this link to get seo panel plugins</a>\r\n		</p>\r\n		<br>\r\n	</li>	\r\n	<li>\r\n		<h1>Contact Us</h1> \r\n		<p>\r\n			Contact us for any questions about <b>seo panel tools,plugins and features etc</b> by using below link.        \r\n		</p>		\r\n		<p>\r\n			<a href="<?=SP_CONTACT_LINK?>" target="_blank">Visit this link to contact us</a>\r\n		</p>\r\n		<br>\r\n	</li>	\r\n	<li>\r\n		<h1>Support Tickets</h1> \r\n		<p>\r\n			To get <b>technical support</b> from seo panel team to setup the <b>seo panel tools,plugins and features</b>. Eg: To set up cron for keyword position checker.\r\n		</p>		\r\n		<p>\r\n			<a href="<?=SP_SUPPORT_LINK?>" target="_blank">Visit this link to create a support ticket</a>\r\n		</p>\r\n		<br>\r\n	</li>	\r\n	<li>\r\n		<h1>Report Bugs</h1> \r\n		<p>\r\n			Report <b>bugs</b> about <b>seo panel tools,plugins and features etc</b> by using below link. \r\n			please help us to improve the features in next versions.          \r\n		</p>		\r\n		<p>\r\n			<a href="<?=SP_SUPPORT_LINK?>" target="_blank">Visit this link to report bugs</a>\r\n		</p>\r\n		<br>\r\n	</li>	\r\n</ul>\r\n</fieldset>', '2010-09-08 09:12:25'),
(23, 'en', 'support', 'support_cont2', '<fieldset>\r\n<legend>Seo Panel Online Resources</legend>\r\n<ul class="infobox">\r\n		\r\n	<li>\r\n		<h1>Seo Panel Help Guide</h1> \r\n		<p>\r\n			You can view the <a href="<?=SP_HELP_LINK?>" target="_blank">seo panel documentation</a> in the <b>help guide</b>, it contains the <b>documentation</b> for the seo panel tools,plugins and related features.\r\n			<br>It is the best place in internet to <b>get help</b> about seo panel. We hope that you <b>contribute</b> to the seo panel help guide, if you find errors or things missing.  	          \r\n		</p>\r\n		<p>\r\n			<a href="<?=SP_HELP_LINK?>" target="_blank">Visit seo panel help guide</a>\r\n		</p>\r\n		<br>\r\n	</li>	\r\n	<li>\r\n		<h1>Seo Panel Forum</h1> \r\n		<p>\r\n			A place to discuss about world''s first open source <b>seo control panel</b>. \r\n			It is the best place to find the <b>answers</b> to <b>your questions</b> about seo panel. \r\n			<br>Also you can <b>share</b> your <b>experience</b> while using seo panel for optimizing your websites.			     	          \r\n		</p>		\r\n		<p>\r\n			<a href="<?=SP_FORUM_LINK?>" target="_blank">Visit seo panel forum</a>\r\n		</p>\r\n		<br>\r\n	</li>\r\n</ul>	\r\n</fieldset>', '2010-09-08 09:13:38'),
(24, 'en', 'support', 'support_cont3', '<fieldset>\r\n<legend>Donate to Seo Panel</legend>\r\n<ul class="infobox">		\r\n	<li>\r\n		<h1>Donate to Seo Panel - First Open source seo control panel in the world</h1> \r\n		<p>\r\n			<b>Donate</b> to seo panel to support first open source seo control panel in the world.\r\n			We are planning to <b>add and improve</b> features of seo panel in future. \r\n			<br>With all your <b>support</b> only we can achieve our <b>goals</b>.\r\n			If you feel that seo panel is <b>worth</b> for you, please donate some amount to seo panel team.\r\n			<br>We will <b>publish</b> your name and site information in <a href="<?=SP_DONATE_LINK?>" target="_blank">donation page</a>, once we get donation.\r\n		</p>\r\n		<p>\r\n			<a href="<?=SP_DONATE_LINK?>" target="_blank">Visit this link to donate to seo panel</a>\r\n		</p>\r\n		<br>\r\n	</li>\r\n</ul>\r\n</fieldset>', '2010-09-08 09:13:38'),
(25, 'en', 'login', 'Login', 'Login', '2010-09-09 07:50:01'),
(26, 'en', 'login', 'Password', 'Password', '2010-09-09 07:50:01'),
(27, 'en', 'login', 'Register', 'Register', '2010-09-09 07:50:51'),
(46, 'en', 'login', 'User inactive', 'User inactive', '2010-09-09 08:48:22'),
(29, 'en', 'login', 'Create New Account', 'Create New Account', '2010-09-09 08:01:09'),
(30, 'en', 'login', 'Username', 'Username', '2010-09-09 08:01:09'),
(31, 'en', 'login', 'Confirm Password', 'Confirm Password', '2010-09-09 08:02:29'),
(32, 'en', 'login', 'First Name', 'First Name', '2010-09-09 08:02:29'),
(33, 'en', 'login', 'Last Name', 'Last Name', '2010-09-09 08:03:06'),
(34, 'en', 'login', 'Email', 'Email', '2010-09-09 08:03:06'),
(35, 'en', 'login', 'Enter the code as it is shown', 'Enter the code as it is shown', '2010-09-09 08:03:45'),
(36, 'en', 'login', 'Create my account', 'Create my account', '2010-09-09 08:03:45'),
(37, 'en', 'common', 'hidenews', 'Hide Seo Panel News', '2010-09-09 08:21:34'),
(38, 'en', 'common', 'Entry cannot be blank', 'Entry cannot be blank', '2010-09-09 08:26:49'),
(39, 'en', 'common', 'Invalid characters', 'Invalid characters', '2010-09-09 08:26:49'),
(40, 'en', 'common', 'entrynotvalid', 'The entry entered doesn''t seem to be  valid', '2010-09-09 08:27:47'),
(41, 'en', 'common', 'Invalid value', 'Invalid value', '2010-09-09 08:27:47'),
(42, 'en', 'common', 'Invalid email address entered', 'Invalid email address entered', '2010-09-09 08:28:31'),
(43, 'en', 'common', 'password632', 'The password string should have a length between 6 and 32', '2010-09-09 08:28:31'),
(44, 'en', 'common', 'passwordnotmatch', 'The passwords do not match', '2010-09-09 08:29:45'),
(45, 'en', 'common', 'Invalid code entered', 'Invalid code entered', '2010-09-09 08:29:45'),
(47, 'en', 'login', 'Password incorrect', 'Password incorrect', '2010-09-09 08:48:22'),
(48, 'en', 'login', 'Login incorrect', 'Login incorrect', '2010-09-09 08:48:40'),
(49, 'en', 'login', 'emailexist', 'Email already exist!', '2010-09-09 08:52:17'),
(50, 'en', 'login', 'usernameexist', 'Username already exist!', '2010-09-09 08:52:17'),
(51, 'en', 'login', 'newaccountsuccess', 'New account created successfully!', '2010-09-09 08:52:56'),
(52, 'en', 'login', 'Sign in to your account', 'Sign in to your account', '2010-09-09 08:52:56'),
(53, 'en', 'home', 'Account Summary', 'Account Summary', '2010-09-09 09:09:20'),
(54, 'en', 'home', 'Website Statistics', 'Website Statistics', '2010-09-09 09:09:20'),
(55, 'en', 'home', 'SiteNameUrl', 'Site Name/Url', '2010-09-09 09:10:04'),
(56, 'en', 'home', 'Ranks', 'Ranks', '2010-09-09 09:10:04'),
(57, 'en', 'home', 'Backlinks', 'Backlinks', '2010-09-09 09:14:54'),
(58, 'en', 'home', 'Pages Indexed', 'Pages Indexed', '2010-09-09 09:14:54'),
(59, 'en', 'home', 'Directory Submission', 'Directory Submission', '2010-09-09 09:15:01'),
(60, 'en', 'common', 'Total', 'Total', '2010-09-09 09:16:10'),
(61, 'en', 'common', 'Active', 'Active', '2010-09-09 09:16:10'),
(62, 'en', 'common', 'nowebsites', 'No Websites Found', '2010-09-09 09:16:26'),
(63, 'en', 'common', 'Id', 'Id', '2010-09-09 09:21:56'),
(64, 'de', 'common', 'Active', 'Aktiv', '2016-01-02 23:21:04'),
(65, 'de', 'common', 'Total', 'Gesamt', '2016-01-02 23:21:04'),
(66, 'en', 'seotools', 'keyword-position-checker', 'Keyword Position Checker', '2010-09-09 09:32:00'),
(67, 'en', 'seotools', 'sitemap-generator', 'Sitemap Generator', '2010-09-09 09:32:00'),
(68, 'en', 'seotools', 'rank-checker', 'Rank Checker', '2010-09-09 09:32:17'),
(69, 'en', 'seotools', 'backlink-checker', 'Backlinks Checker', '2010-09-09 09:32:59'),
(70, 'en', 'seotools', 'directory-submission', 'Directory Submission', '2010-09-09 09:32:59'),
(71, 'en', 'seotools', 'saturation-checker', 'Search Engine Saturation', '2010-09-09 09:33:19'),
(72, 'en', 'common', 'noactivetools', 'No Active Seo Tools Found!', '2010-09-09 09:37:09'),
(73, 'en', 'seotools', 'Keyword Position Summary', 'Keyword Position Summary', '2010-09-09 09:43:22'),
(74, 'en', 'seotools', 'Detailed Position Reports', 'Detailed Position Reports', '2010-09-09 09:43:22'),
(75, 'en', 'seotools', 'Graphical Position Reports', 'Graphical Position Reports', '2010-09-09 09:43:40'),
(76, 'en', 'seotools', 'Quick Position Checker', 'Quick Position Checker', '2010-09-09 09:43:40'),
(77, 'en', 'seotools', 'Keywords Manager', 'Keywords Manager', '2010-09-09 09:44:01'),
(78, 'en', 'seotools', 'Generate Keyword Reports', 'Generate Keyword Reports', '2010-09-09 09:44:01'),
(79, 'en', 'seotools', 'Google Sitemap Generator', 'Google Sitemap Generator', '2010-09-09 09:44:20'),
(80, 'en', 'seotools', 'Quick Rank Checker', 'Quick Rank Checker', '2010-09-09 09:44:20'),
(81, 'en', 'seotools', 'Rank Reports', 'Rank Reports', '2010-09-09 09:47:08'),
(82, 'en', 'seotools', 'Generate Rank Reports', 'Generate Rank Reports', '2010-09-09 09:47:08'),
(83, 'en', 'seotools', 'Quick Backlinks Checker', 'Quick Backlinks Checker', '2010-09-09 09:47:25'),
(84, 'en', 'seotools', 'Backlinks Reports', 'Backlinks Reports', '2010-09-09 09:47:25'),
(86, 'en', 'seotools', 'Generate Backlinks Reports', 'Generate Backlinks Reports', '2010-09-09 09:48:45'),
(87, 'en', 'seotools', 'Automatic Submission', 'Automatic Submission', '2010-09-09 09:48:45'),
(88, 'en', 'seotools', 'Featured Submission', 'Featured Submission', '2010-09-09 09:49:45'),
(89, 'en', 'seotools', 'Skipped Directories', 'Skipped Directories', '2010-09-09 09:49:45'),
(90, 'en', 'seotools', 'Submission Reports', 'Submission Reports', '2010-09-09 09:49:45'),
(91, 'en', 'seotools', 'Check Submission Status', 'Check Submission Status', '2010-09-09 09:49:45'),
(92, 'en', 'seotools', 'Quick Saturation Checker', 'Quick Saturation Checker', '2010-09-09 09:49:45'),
(93, 'en', 'seotools', 'Saturation Reports', 'Saturation Reports', '2010-09-09 09:50:06'),
(94, 'en', 'seotools', 'Generate Saturation Reports', 'Generate Saturation Reports', '2010-09-09 09:50:06'),
(95, 'en', 'common', 'Website', 'Website', '2010-09-10 07:15:10'),
(96, 'en', 'common', 'Keyword', 'Keyword', '2010-09-10 07:15:54'),
(97, 'en', 'common', 'No Keywords Found', 'No Keywords Found', '2010-09-10 07:17:35'),
(98, 'en', 'common', 'No Records Found', 'No Records Found', '2010-09-10 07:17:35'),
(99, 'en', 'common', 'Period', 'Period', '2010-09-10 07:21:03'),
(100, 'en', 'common', 'Search Engine', 'Search Engine', '2010-09-10 07:21:03'),
(101, 'en', 'common', 'Country', 'Country', '2010-09-10 07:56:16'),
(102, 'en', 'keyword', 'Detailed Keyword Position Reports', 'Detailed Keyword Position Reports', '2010-09-10 07:57:06'),
(103, 'en', 'common', 'Results', 'Results', '2010-09-10 07:59:51'),
(104, 'en', 'common', 'Rank', 'Rank', '2010-09-10 08:06:00'),
(105, 'en', 'common', 'Date', 'Date', '2010-09-10 08:06:00'),
(106, 'de', 'common', 'Date', 'Datum', '2016-01-02 23:21:04'),
(107, 'de', 'common', 'Rank', 'Rang', '2016-01-02 23:21:04'),
(108, 'en', 'keyword', 'Graphical Keyword Position Reports', 'Graphical Keyword Position Reports', '2010-09-10 08:26:06'),
(109, 'en', 'keyword', 'Keyword Position Report', 'Keyword Position Report', '2010-09-10 08:35:16'),
(110, 'en', 'keyword', 'Quick Keyword Position Checker', 'Quick Keyword Position Checker', '2010-09-10 08:45:24'),
(111, 'en', 'keyword', 'Show All results', 'Show All results', '2010-09-10 08:46:12'),
(112, 'en', 'seotools', 'clickgeneratereports', 'Click on <b>Proceed</b> to generate reports', '2010-09-10 08:50:57'),
(113, 'en', 'common', 'Details', 'Details', '2010-09-10 08:55:38'),
(114, 'en', 'Common', 'Name', 'Name', '2010-09-10 08:58:01'),
(115, 'en', 'common', 'Status', 'Status', '2010-09-10 09:06:18'),
(116, 'en', 'common', 'Action', 'Action', '2010-09-10 09:06:31'),
(117, 'en', 'common', 'Inactivate', 'Inactivate', '2010-09-10 09:07:12'),
(118, 'en', 'common', 'Activate', 'Activate', '2010-09-10 09:07:12'),
(119, 'en', 'common', 'Select', 'Select', '2010-09-10 09:07:39'),
(120, 'en', 'common', 'Edit', 'Edit', '2010-09-10 09:07:39'),
(121, 'en', 'common', 'Delete', 'Delete', '2010-09-10 09:07:51'),
(122, 'en', 'common', 'Reports', 'Reports', '2010-09-10 09:09:27'),
(123, 'en', 'common', 'All', 'All', '2010-09-10 09:20:10'),
(124, 'en', 'common', 'Inactive', 'Inactive', '2010-09-10 09:21:44'),
(125, 'de', 'common', 'Edit', 'Bearbeiten', '2016-01-02 23:21:04'),
(126, 'de', 'common', 'Delete', 'Löschen', '2016-01-02 23:21:04'),
(127, 'en', 'keyword', 'Edit Keyword', 'Edit Keyword', '2010-09-11 07:46:49'),
(128, 'en', 'keyword', 'Keyword already exist', 'Keyword already exist', '2010-09-11 08:06:04'),
(129, 'en', 'keyword', 'New Keyword', 'New Keyword', '2010-09-11 08:08:04'),
(130, 'en', 'keyword', 'Successfully crawled keyword', 'Successfully crawled keyword', '2010-09-11 08:28:06'),
(131, 'en', 'keyword', 'results from ', 'results from ', '2010-09-11 08:28:06'),
(132, 'en', 'keyword', 'not assigned to required search engines', 'not assigned to required search engines', '2010-09-11 08:32:25'),
(133, 'en', 'keyword', 'Crawling keyword', 'Crawling keyword', '2010-09-11 08:32:44'),
(134, 'en', 'common', 'failed', 'failed', '2010-09-11 08:33:37'),
(135, 'en', 'sitemap', 'processtaketime', 'This process will take time according to number of links in your site. Please wait to get sitemap files', '2010-09-11 08:48:08'),
(136, 'en', 'sitemap', 'clickproceedsitemap', 'Click on <b>Proceed</b> to create sitemap file', '2010-09-11 08:48:34'),
(137, 'en', 'sitemap', 'Exclude Url', 'Exclude Url', '2010-09-11 08:48:34'),
(138, 'en', 'common', 'Priority', 'Priority', '2010-09-11 08:48:45'),
(139, 'en', 'sitemap', 'Change frequency', 'Change frequency', '2010-09-11 08:48:56'),
(140, 'en', 'sitemap', 'Sitemap Type', 'Sitemap Type', '2010-09-11 08:49:10'),
(141, 'en', 'sitemap', 'Download sitemap file from', 'Download sitemap file from', '2010-09-11 09:26:47'),
(142, 'en', 'common', 'Found', 'Found', '2010-09-11 09:30:25'),
(143, 'en', 'rank', 'enterurlproceed', 'Enter URL''s <b>One per line</b>. Click on <b>Proceed</b> to check Google and Alexa rank.', '2010-09-14 08:26:31'),
(144, 'en', 'common', 'Url', 'Url', '2010-09-14 08:28:03'),
(145, 'en', 'common', 'Google Pagerank', 'Google Pagerank', '2010-09-14 08:28:34'),
(146, 'en', 'common', 'Alexa Rank', 'Alexa Rank', '2010-09-14 08:28:34'),
(147, 'en', 'rank', 'Google and Alexa Rank Reports', 'Google and Alexa Rank Reports', '2010-09-14 08:32:24'),
(148, 'en', 'rank', 'Saved rank results of', 'Saved rank results of', '2010-09-14 08:44:40'),
(149, 'en', 'backlink', 'clickproceedbacklink', 'Enter URL''s <b>One per line</b>. Click on <b>Proceed</b> to check Backlinks.', '2010-09-14 08:51:24'),
(150, 'en', 'backlink', 'Saved backlink results of', 'Saved backlink results of', '2010-09-14 09:04:29'),
(151, 'en', 'saturation', 'Quick Search Engine Saturation Checker', 'Quick Search Engine Saturation Checker', '2010-09-14 09:07:59'),
(152, 'en', 'saturation', 'clickproceedsaturation', 'Enter URL''s <b>One per line</b>. Click on <b>Proceed</b> to check Search Engine Saturation Results', '2010-09-14 09:09:39'),
(153, 'en', 'saturation', 'Search Engine Saturation Reports', 'Search Engine Saturation Reports', '2010-09-14 09:12:33'),
(154, 'en', 'saturation', 'GenerateSaturationReports', 'Generate Search Engine Saturation Reports', '2010-09-14 09:16:59'),
(155, 'en', 'saturation', 'Saved Search Engine Saturation results of', 'Saved Search Engine Saturation results of', '2010-09-14 09:19:31'),
(156, 'en', 'directory', 'Semi Automatic Directory Submission Tool', 'Semi Automatic Directory Submission Tool', '2010-09-14 09:24:11'),
(157, 'en', 'directory', 'Directories with out captcha', 'Directories with out captcha', '2010-09-14 09:24:25'),
(158, 'en', 'directory', 'selectwebsiteproceed', 'Select a <b>Website</b> to <b>Proceed</b> directory submission.<br>Check <b>Directories with out captcha</b> to submit to directories with out captcha', '2010-09-14 09:26:51'),
(159, 'en', 'directory', 'Please select a website to proceed', 'Please select a website to proceed', '2010-09-14 09:27:39'),
(160, 'en', 'common', 'Crawl Meta Data', 'Crawl Meta Data', '2010-09-14 09:29:34'),
(161, 'en', 'directory', 'Submission Details', 'Submission Details', '2010-09-15 07:54:18'),
(162, 'en', 'directory', 'Owner Name', 'Owner Name', '2010-09-15 07:54:18'),
(163, 'en', 'directory', 'Owner Email', 'Owner Email', '2010-09-15 07:55:08'),
(164, 'en', 'directory', 'spamemailnote', 'Some directories may send spam, we do not recommend using your primary email address.', '2010-09-15 07:55:08'),
(165, 'en', 'directory', 'Website Category', 'Website Category', '2010-09-15 07:58:00'),
(166, 'en', 'directory', 'categorynote', 'Categories, separate them with comma according to the priority. Start with Top priority category.', '2010-09-15 07:58:00'),
(167, 'en', 'directory', 'Website Url', 'Website Url', '2010-09-15 07:58:33'),
(168, 'en', 'directory', 'Submit Title', 'Submit Title', '2010-09-15 07:58:33'),
(169, 'en', 'directory', 'Submit Description', 'Submit Description', '2010-09-15 08:01:23'),
(170, 'en', 'directory', 'Submit Keywords', 'Submit Keywords', '2010-09-15 08:01:23'),
(171, 'en', 'directory', 'optionalnote', 'Optional titles and descriptions to submit random title and description to directories for better results.', '2010-09-15 08:02:11'),
(172, 'en', 'directory', 'desnote', 'Some directories require minimum 150 characters for the description field.', '2010-09-15 08:06:57'),
(173, 'en', 'common', 'Category', 'Category', '2010-09-15 08:15:24'),
(174, 'en', 'directory', 'Enter the code shown', 'Enter the code shown', '2010-09-15 08:15:38'),
(175, 'en', 'directory', 'nodirnote', 'No <b>Active</b> directories Found', '2010-09-15 08:17:08'),
(176, 'en', 'directory', 'nocatnote', 'The submission category not found in submission page. Please click on <b>Reload</b> or <b>Skip</b>', '2010-09-15 08:22:50'),
(177, 'en', 'directory', 'nosuccessnote', 'Didn''t get success message, Please check your mail to find the confirm message', '2010-09-15 08:27:40'),
(179, 'en', 'common', 'Directory', 'Directory', '2010-09-15 08:39:32'),
(181, 'en', 'directory', 'Add back to directory list', 'Add back to directory list', '2010-09-15 08:42:58'),
(182, 'en', 'directory', 'Directory Submission Reports', 'Directory Submission Reports', '2010-09-15 08:43:47'),
(183, 'en', 'directory', 'Confirmation', 'Confirmation', '2010-09-15 08:48:25'),
(184, 'en', 'directory', 'Pending', 'Pending', '2010-09-15 08:49:14'),
(185, 'en', 'directory', 'Approved', 'Approved', '2010-09-15 08:49:14'),
(247, 'en', 'proxy', 'Proxy Username', 'Proxy Username', '2010-09-17 08:26:36'),
(187, 'en', 'common', 'No', 'No', '2010-09-15 08:52:29'),
(188, 'en', 'common', 'Yes', 'Yes', '2010-09-15 08:52:29'),
(189, 'en', 'directory', 'Check Directory Submission Status', 'Check Directory Submission Status', '2010-09-15 08:53:21'),
(190, 'en', 'directory', 'selectwebsiteschecksub', 'Select a <b>Website</b> to <b>Proceed</b> check directory submission.', '2010-09-15 08:56:22'),
(191, 'en', 'panel', 'Website Manager', 'Website Manager', '2010-09-15 09:14:20'),
(192, 'en', 'panel', 'User Manager', 'User Manager', '2010-09-15 09:14:20'),
(193, 'en', 'panel', 'Reports Manager', 'Reports Manager', '2010-09-15 09:14:37'),
(194, 'en', 'panel', 'Seo Tools Manager', 'Seo Tools Manager', '2010-09-15 09:14:37'),
(195, 'en', 'panel', 'Seo Plugins Manager', 'Seo Plugins Manager', '2010-09-15 09:14:56'),
(196, 'en', 'panel', 'Directory Manager', 'Directory Manager', '2010-09-15 09:14:56'),
(197, 'en', 'panel', 'Proxy Manager', 'Proxy Manager', '2010-09-15 09:15:14'),
(198, 'en', 'panel', 'System Settings', 'System Settings', '2010-09-15 09:15:14'),
(199, 'en', 'panel', 'My Profile', 'My Profile', '2010-09-15 09:15:25'),
(200, 'en', 'panel', 'New Website', 'New Website', '2010-09-15 09:24:04'),
(201, 'en', 'panel', 'New User', 'New User', '2010-09-15 09:24:04'),
(202, 'en', 'panel', 'Report Generation Manager', 'Report Generation Manager', '2010-09-15 09:25:41'),
(203, 'en', 'panel', 'New Proxy', 'New Proxy', '2010-09-15 09:25:51'),
(204, 'en', 'panel', 'Check Directory', 'Check Directory', '2010-09-15 09:26:31'),
(205, 'en', 'panel', 'Edit My Profile', 'Edit My Profile', '2010-09-15 09:26:53'),
(206, 'de', 'common', 'Select', 'Wählen', '2016-01-02 23:21:04'),
(207, 'en', 'common', 'User', 'User', '2010-09-16 06:04:19'),
(208, 'en', 'button', 'Cancel', 'Cancel', '2010-09-16 06:19:25'),
(209, 'en', 'button', 'Proceed', 'Proceed', '2010-09-16 06:19:25'),
(210, 'en', 'website', 'plscrtwebsite', 'Please create a website before start to using seo tools and seo plugins.', '2010-09-16 06:29:11'),
(211, 'en', 'website', 'yourwebalreday', 'your website if you have already created one.', '2010-09-16 06:34:08'),
(216, 'en', 'website', 'Website already exist', 'Website already exist', '2010-09-16 07:15:40'),
(213, 'en', 'label', 'Title', 'Title', '2010-09-16 06:43:26'),
(214, 'en', 'label', 'Description', 'Description', '2010-09-16 06:43:50'),
(215, 'en', 'label', 'Keywords', 'Keywords', '2010-09-16 06:43:50'),
(217, 'en', 'website', 'Edit Website', 'Edit Website', '2010-09-16 07:18:48'),
(218, 'en', 'user', 'Edit User', 'Edit User', '2010-09-16 07:40:32'),
(219, 'en', 'keyword', 'pleaseselecttool', 'Please select atleast one Seo Tools', '2010-09-16 08:41:49'),
(230, 'en', 'label', 'Upgrade', 'Upgrade', '2010-09-16 09:18:29'),
(229, 'en', 'label', 'Installation', 'Installation', '2010-09-16 09:15:16'),
(227, 'en', 'label', 'Plugin', 'Plugin', '2010-09-16 09:13:44'),
(228, 'en', 'label', 'Author', 'Author', '2010-09-16 09:14:09'),
(225, 'en', 'label', 'Cron', 'Cron', '2010-09-16 09:05:44'),
(226, 'en', 'seotools', 'User Access', 'User Access', '2010-09-16 09:06:49'),
(231, 'en', 'label', 'Re-install', 'Re-install', '2010-09-16 09:18:29'),
(232, 'en', 'plugin', 'Edit Seo Plugin', 'Edit Seo Plugin', '2010-09-16 09:19:06'),
(233, 'en', 'plugin', 'Plugin Name', 'Plugin Name', '2010-09-16 09:20:15'),
(234, 'en', 'plugin', 'Seo Plugin Details', 'Seo Plugin Details', '2010-09-16 09:26:18'),
(235, 'en', 'label', 'Version', 'Version', '2010-09-16 09:26:52'),
(237, 'en', 'directory', 'Captcha', 'Captcha', '2010-09-16 09:36:37'),
(238, 'en', 'button', 'Show Records', 'Show Records', '2010-09-16 09:38:21'),
(239, 'de', 'common', 'Yes', 'Ja', '2016-01-02 23:21:04'),
(240, 'de', 'common', 'No', 'Nein', '2016-01-02 23:21:04'),
(241, 'en', 'directory', 'Check Directory Status', 'Check Directory Status', '2010-09-16 09:51:36'),
(242, 'en', 'directory', 'clicktoproceeddirsts', 'Click on <b>Proceed</b> to Check Directory Status.', '2010-09-16 09:54:05'),
(243, 'en', 'label', 'Proxy', 'Proxy', '2010-09-17 07:51:18'),
(244, 'en', 'label', 'Port', 'Port', '2010-09-17 07:51:18'),
(245, 'en', 'label', 'Authentication', 'Authentication', '2010-09-17 07:51:41'),
(246, 'en', 'button', 'Check Status', 'Check Status', '2010-09-17 07:53:35'),
(248, 'en', 'proxy', 'Proxy Password', 'Proxy Password', '2010-09-17 08:26:36'),
(249, 'en', 'proxy', 'Proxyalreadyexist', 'Proxy already exist!', '2010-09-17 08:30:31'),
(250, 'en', 'proxy', 'Edit Proxy', 'Edit Proxy', '2010-09-17 08:41:24'),
(251, 'en', 'settings', 'SP_TITLE', 'Seo Panel Title', '2010-09-17 08:43:41'),
(252, 'en', 'settings', 'SP_DESCRIPTION', 'Seo Panel Description', '2010-09-17 08:43:41'),
(253, 'en', 'settings', 'SP_KEYWORDS', 'Seo Panel Keywords', '2010-09-17 08:44:15'),
(254, 'en', 'settings', 'SP_PAGINGNO', 'Number of entries per page', '2010-09-17 08:44:15'),
(255, 'en', 'settings', 'SP_CRAWL_DELAY', 'Delay between each spider crawl(seconds)', '2010-09-17 08:44:50'),
(256, 'en', 'settings', 'SP_USER_GEN_REPORT', 'Allow user to generate reports', '2010-09-17 08:44:50'),
(257, 'en', 'settings', 'SP_HOTLINKING', 'Image hotlink protection enabled', '2010-09-17 08:45:22'),
(258, 'en', 'settings', 'SP_USER_REGISTRATION', 'User registration interface', '2010-09-17 08:45:22'),
(259, 'en', 'settings', 'SP_ENABLE_PROXY', 'Enable Proxy', '2010-09-17 08:45:39'),
(260, 'en', 'settings', 'syssettingssaved', 'System settings saved successfully!', '2010-09-17 08:49:53'),
(261, 'en', 'user', 'Saved My Profile Details', 'Saved My Profile Details', '2010-09-17 09:36:33'),
(262, 'en', 'button', 'Show Details', 'Show Details', '2010-09-17 10:22:10'),
(263, 'en', 'button', 'Skip', 'Skip', '2010-09-17 10:25:35'),
(264, 'en', 'button', 'Submit', 'Submit', '2010-09-17 10:25:35'),
(265, 'en', 'button', 'Reload', 'Reload', '2010-09-17 10:25:50'),
(266, 'en', 'label', 'wantproceed', 'Do you really want to proceed?', '2010-09-18 06:53:29'),
(267, 'de', 'label', 'wantproceed', 'Wollen Sie wirklich fortfahren?', '2016-01-02 23:23:15'),
(268, 'en', 'label', 'translation by', 'translation by', '2010-09-18 07:29:51'),
(269, 'en', 'label', 'Download', 'Download', '2010-09-18 07:36:36'),
(270, 'en', 'label', 'noactiveplugins', 'No Active Seo Plugins Found!', '2010-09-18 09:52:57'),
(271, 'de', 'backlink', 'clickproceedbacklink', '<b>Pro Zeile</b> eine URL angeben. Auf <b>Starten</b> klicken um Backlinks zu pruefen.', '2010-09-30 02:19:47'),
(272, 'de', 'backlink', 'Saved backlink results of', 'Gespeicherte Ergebnisse der Backlink', '2010-09-30 02:19:47'),
(273, 'es', 'backlink', 'clickproceedbacklink', 'Introduzca las URL, <b>una por línea</b>. Haga clic en <b>Continuar</b> para comprobar los backlinks.', '2012-05-31 10:35:06'),
(274, 'es', 'backlink', 'Saved backlink results of', 'Se han guardado los resultados de ', '2012-05-31 10:35:06'),
(275, 'fr', 'backlink', 'clickproceedbacklink', 'Indiquer <b>une URL par ligne</b>. Cliquer sur <b>Valider</b> pour vérifier les liens entrants.', '2010-09-27 10:14:29'),
(276, 'fr', 'backlink', 'Saved backlink results of', 'Résultats enregistrés des liens entrants de ', '2010-09-27 10:14:29'),
(277, 'fr', 'website', 'Edit Website', 'Editer le site web', '2016-01-04 09:47:20'),
(278, 'fr', 'website', 'plscrtwebsite', 'Merci de créer un site web avant d''utiliser les outils et plugins seo.', '2016-01-04 09:47:20'),
(279, 'fr', 'website', 'Website already exist', 'Le site web existe déjà.', '2016-01-04 09:47:20'),
(280, 'fr', 'website', 'yourwebalreday', 'votre site web si vous en avez déjà créé un.', '2016-01-04 09:47:20'),
(281, 'es', 'button', 'Cancel', 'Cancelar', '2014-01-08 19:34:14'),
(282, 'es', 'button', 'Check Status', 'Comprobar estado', '2014-01-08 19:34:14'),
(283, 'es', 'button', 'Proceed', 'Proceder', '2014-01-08 19:34:14'),
(284, 'es', 'button', 'Reload', 'Reintentar', '2014-01-08 19:34:14'),
(285, 'es', 'button', 'Show Details', 'Mostrar detalles', '2014-01-08 19:34:14'),
(286, 'es', 'button', 'Show Records', 'Mostrar registros', '2014-01-08 19:34:14'),
(287, 'es', 'button', 'Skip', 'Omitir', '2014-01-08 19:34:14'),
(288, 'es', 'button', 'Submit', 'Enviar', '2014-01-08 19:34:14'),
(289, 'es', 'common', 'Action', 'Acción', '2012-11-12 20:17:40'),
(290, 'es', 'common', 'Activate', 'Activar', '2012-11-12 20:17:40'),
(291, 'es', 'common', 'Active', 'Activo', '2012-11-12 20:17:40'),
(292, 'es', 'common', 'Admin Panel', 'Panel de administración', '2012-11-12 20:17:40'),
(293, 'es', 'common', 'Alexa Rank', 'Rango Alexa', '2012-11-12 20:17:40'),
(294, 'es', 'common', 'All', 'Todos', '2012-11-12 20:17:40'),
(295, 'es', 'common', 'Category', 'Categoría', '2012-11-12 20:17:40'),
(296, 'es', 'common', 'contact', 'Contacto', '2012-11-12 20:17:40'),
(297, 'es', 'common', 'copyright', 'Derechos de autor © [year] www.seopanel.in Reservados todos los derechos', '2012-11-12 20:17:40'),
(298, 'es', 'common', 'Country', 'País', '2012-11-12 20:17:40'),
(299, 'es', 'common', 'Crawl Meta Data', 'Rastrear Meta Etiquetas', '2012-11-12 20:17:40'),
(300, 'es', 'common', 'Date', 'Fecha', '2012-11-12 20:17:40'),
(301, 'es', 'common', 'Delete', 'Borrar', '2012-11-12 20:17:40'),
(302, 'es', 'common', 'Details', 'Detalles', '2012-11-12 20:17:40'),
(303, 'es', 'common', 'Directory', 'Directorio', '2012-11-12 20:17:40'),
(304, 'es', 'common', 'Donate', 'Donar', '2012-11-12 20:17:40'),
(305, 'es', 'common', 'Edit', 'Editar', '2012-11-12 20:17:40'),
(306, 'es', 'common', 'Entry cannot be blank', 'La entrada no puede estar en blanco', '2012-11-12 20:17:40'),
(307, 'es', 'common', 'entrynotvalid', 'La entrada realizada parece no ser válida.', '2012-11-12 20:17:40'),
(308, 'es', 'common', 'failed', 'ha fallado', '2012-11-12 20:17:40'),
(309, 'es', 'common', 'forum', 'Foro', '2012-11-12 20:17:40'),
(310, 'es', 'common', 'Found', 'Encontrado', '2012-11-12 20:17:40'),
(311, 'es', 'common', 'Google Pagerank', 'Google Pagerank', '2012-11-12 20:17:40'),
(312, 'es', 'common', 'help', 'Ayuda', '2012-11-12 20:17:40'),
(313, 'es', 'common', 'hidenews', 'Ocultar las noticias del panel Seo.', '2012-11-12 20:17:40'),
(314, 'es', 'common', 'Id', 'Id', '2012-11-12 20:17:40'),
(315, 'es', 'common', 'Inactivate', 'Desactivar', '2012-11-12 20:17:40'),
(316, 'es', 'common', 'Inactive', 'Inactivo', '2012-11-12 20:17:40'),
(317, 'es', 'common', 'Invalid characters', 'Caracteres no válidos', '2012-11-12 20:17:40'),
(318, 'es', 'common', 'Invalid code entered', 'el código es incorrecto', '2012-11-12 20:17:40'),
(319, 'es', 'common', 'Invalid email address entered', 'Entró una dirección de correo electrónico inválida', '2012-11-12 20:17:40'),
(320, 'es', 'common', 'Invalid value', 'Valor no válido', '2012-11-12 20:17:40'),
(321, 'es', 'common', 'Keyword', 'Palabra clave', '2012-11-12 20:17:40'),
(322, 'es', 'common', 'lang', 'Idioma', '2012-11-12 20:17:40'),
(323, 'es', 'common', 'My Account', 'Mi Cuenta', '2012-11-12 20:17:40'),
(324, 'es', 'common', 'Name', 'Nombre', '2012-11-12 20:17:40'),
(325, 'es', 'common', 'No', 'No', '2012-11-12 20:17:40'),
(326, 'es', 'common', 'No Keywords Found', 'No hay palabras clave encontradas', '2012-11-12 20:17:40'),
(327, 'es', 'common', 'No Records Found', 'No se encontraron registros', '2012-11-12 20:17:40'),
(328, 'es', 'common', 'noactivetools', 'No se encontraron Herramientas Seo activas.', '2012-11-12 20:17:40'),
(329, 'es', 'common', 'nowebsites', 'No se encontraron páginas web', '2012-11-12 20:17:40'),
(330, 'es', 'common', 'password632', 'La contraseña debe tener una longitud de entre 6 y 32', '2012-11-12 20:17:40'),
(331, 'es', 'common', 'passwordnotmatch', 'Las contraseñas no coinciden', '2012-11-12 20:17:40'),
(332, 'es', 'common', 'Period', 'Periodo', '2012-11-12 20:17:40'),
(333, 'es', 'common', 'Priority', 'Prioridad', '2012-11-12 20:17:40'),
(334, 'es', 'common', 'Rank', 'Rango', '2012-11-12 20:17:40'),
(335, 'es', 'common', 'Reports', 'Informes', '2012-11-12 20:17:40'),
(336, 'es', 'common', 'Results', 'Resultados', '2012-11-12 20:17:40'),
(337, 'es', 'common', 'Search Engine', 'Motor de búsqueda', '2012-11-12 20:17:40'),
(338, 'es', 'common', 'Select', 'Seleccionar', '2012-11-12 20:17:40'),
(339, 'es', 'common', 'Seo Plugins', 'Plugins Seo', '2012-11-12 20:17:40'),
(340, 'es', 'common', 'Seo Tools', 'Herramientas Seo', '2012-11-12 20:17:40'),
(341, 'es', 'common', 'Sign out', 'Salir', '2012-11-12 20:17:40'),
(342, 'es', 'common', 'Sign Up', 'Regístrate', '2012-11-12 20:17:40'),
(343, 'es', 'common', 'signin', 'Registrarse', '2012-11-12 20:17:40'),
(344, 'es', 'common', 'Status', 'Estado', '2012-11-12 20:17:40'),
(345, 'es', 'common', 'Support', 'Apoyo', '2012-11-12 20:17:40'),
(346, 'es', 'common', 'Total', 'Total', '2012-11-12 20:17:40'),
(347, 'es', 'common', 'Url', 'Url', '2012-11-12 20:17:40'),
(348, 'es', 'common', 'User', 'Usuario', '2012-11-12 20:17:40'),
(349, 'es', 'common', 'User Panel', 'Panel de usuario', '2012-11-12 20:17:40'),
(350, 'es', 'common', 'Website', 'Página web', '2012-11-12 20:17:40'),
(351, 'es', 'common', 'Yes', 'Sí', '2012-11-12 20:17:40'),
(352, 'es', 'directory', 'Add back to directory list', 'Añadir de nuevo a la lista de directorios', '2012-05-31 10:35:43'),
(353, 'es', 'directory', 'Approved', 'Aprobado', '2012-05-31 10:35:43'),
(354, 'es', 'directory', 'Captcha', 'Código anti-Spam', '2012-05-31 10:35:43'),
(355, 'es', 'directory', 'categorynote', 'Categorías, separadas con comas según la prioridad. Comience con categoría de máxima prioridad.', '2012-05-31 10:35:43'),
(356, 'es', 'directory', 'Check Directory Status', 'Comprobar el estado del directorio', '2012-05-31 10:35:43'),
(357, 'es', 'directory', 'Check Directory Submission Status', 'Comprobar el estado de las páginas enviadas a los directorios', '2012-05-31 10:35:43'),
(358, 'es', 'directory', 'clicktoproceeddirsts', 'Hacer clic en <b>Proceder</b> para comprobar el estado del directorio.', '2012-05-31 10:35:43'),
(359, 'es', 'directory', 'Confirmation', 'Confirmación', '2012-05-31 10:35:43'),
(360, 'es', 'directory', 'desnote', 'Algunos directorios requieren como mínimo 150 caracteres para el campo de descripción.', '2012-05-31 10:35:43'),
(361, 'es', 'directory', 'Directories with out captcha', 'Directorios sin captcha o Anti-spam', '2012-05-31 10:35:43'),
(362, 'es', 'directory', 'Directory Submission Reports', 'Informe de los envios a directorios.', '2012-05-31 10:35:43'),
(363, 'es', 'directory', 'Enter the code shown', 'Introduzca el código que se muestra', '2012-05-31 10:35:43'),
(364, 'es', 'directory', 'nocatnote', 'La categoría que configuró no se encuentra en el directorio de destino. Por favor, haga clic en <b>Recargar</b> o <b>Omitir</b>', '2012-05-31 10:35:43'),
(365, 'es', 'directory', 'nodirnote', 'Ningún directorio <b>Activo</b> fue encontrado', '2012-05-31 10:35:43'),
(366, 'es', 'directory', 'nosuccessnote', '¿No hemos recibido confirmación de que su envío haya sido exitoso, por favor revise su correo para encontrar el mensaje de confirmación.', '2012-05-31 10:35:43'),
(367, 'es', 'directory', 'optionalnote', 'Títulos opcionales y descripciones a presentar.Use diferentes títulos y descripciones que nosotros enviaremos al azar para mejorar los resultados.', '2012-05-31 10:35:43'),
(368, 'es', 'directory', 'Owner Email', 'Correo electrónico del propietario', '2012-05-31 10:35:43'),
(369, 'es', 'directory', 'Owner Name', 'Nombre del propietario', '2012-05-31 10:35:43'),
(370, 'es', 'directory', 'Pending', 'Pendiente', '2012-05-31 10:35:43'),
(371, 'es', 'directory', 'Please select a website to proceed', 'Por favor, seleccione una página web para proceder', '2012-05-31 10:35:43'),
(372, 'es', 'directory', 'selectwebsiteproceed', 'Seleccione una <b>Página web</b> para <b>Proceder</b> a el envio del directorio.<br>Seleccione los <b>Directorios sin\r\ncaptcha</b> para enviar solo a directorios sin captcha o anti-spam', '2012-05-31 10:35:43'),
(373, 'es', 'directory', 'selectwebsiteschecksub', 'Seleccione una <b>página web</b> para <b>Proceder</b> Comprobar el envio al directorio.', '2012-05-31 10:35:43'),
(374, 'es', 'directory', 'Semi Automatic Directory Submission Tool', 'Herramienta semiautomática de envío a los directorios.', '2012-05-31 10:35:43'),
(375, 'es', 'directory', 'spamemailnote', 'Algunos directorios le pueden enviar spam, no recomendamos el uso de su dirección de correo electrónico principal.', '2012-05-31 10:35:43'),
(376, 'es', 'directory', 'Submission Details', 'Envio de los detalles', '2012-05-31 10:35:43'),
(377, 'es', 'directory', 'Submit Description', 'Enviar descripción', '2012-05-31 10:35:43'),
(378, 'es', 'directory', 'Submit Keywords', 'Enviar palabras clave', '2012-05-31 10:35:43'),
(379, 'es', 'directory', 'Submit Title', 'Enviar el título', '2012-05-31 10:35:43'),
(380, 'es', 'directory', 'Website Category', 'Categoría del sitio web', '2012-05-31 10:35:43'),
(381, 'es', 'directory', 'Website Url', 'URL del sitio web', '2012-05-31 10:35:43'),
(382, 'fr', 'user', 'Edit User', 'Editer le profil', '2016-01-02 18:14:56'),
(383, 'fr', 'user', 'Saved My Profile Details', 'Votre profil a été sauvegardé.', '2016-01-02 18:14:56'),
(384, 'fr', 'sitemap', 'Change frequency', 'Modifier la fréquence', '2011-07-13 03:13:40'),
(385, 'fr', 'sitemap', 'clickproceedsitemap', 'Cliquer sur <b>Valider</b> pour créer le fichier sitemap', '2011-07-13 03:13:40'),
(386, 'fr', 'sitemap', 'Download sitemap file from', 'Télécharger le fichier sitemap depuis', '2011-07-13 03:13:40'),
(387, 'fr', 'sitemap', 'Exclude Url', 'URL à exclure', '2011-07-13 03:13:40'),
(388, 'fr', 'sitemap', 'processtaketime', 'Le temps de traitement dépends du nombre de liens sur votre site. Merci de patienter pendant la génération du sitemap.', '2011-07-13 03:13:40'),
(389, 'fr', 'sitemap', 'Sitemap Type', 'Type de sitemap', '2011-07-13 03:13:40'),
(390, 'fr', 'login', 'Confirm Password', 'Confirmer le mot de passe', '2016-01-02 18:08:21'),
(391, 'fr', 'login', 'Create my account', 'Créer mon compte', '2016-01-02 18:08:21'),
(392, 'fr', 'login', 'Create New Account', 'Créer un nouveau compte', '2016-01-02 18:08:21'),
(393, 'fr', 'login', 'Email', 'Email', '2016-01-02 18:08:21'),
(394, 'fr', 'login', 'emailexist', 'L''adresse mail existe déjà !', '2016-01-02 18:08:21'),
(395, 'fr', 'login', 'Enter the code as it is shown', 'Veuillez saisir le code qui apparait', '2016-01-02 18:08:21'),
(396, 'fr', 'login', 'First Name', 'Prénom', '2016-01-02 18:08:21'),
(397, 'fr', 'login', 'Last Name', 'Nom', '2016-01-02 18:08:21'),
(398, 'fr', 'login', 'Login', 'Identifiant', '2016-01-02 18:08:21'),
(399, 'fr', 'login', 'Login incorrect', 'Identifiant incorrect', '2016-01-02 18:08:21'),
(400, 'fr', 'login', 'newaccountsuccess', 'Le nouveau compte a bien été créé !', '2016-01-02 18:08:21'),
(401, 'fr', 'login', 'Password', 'Mot de passe', '2016-01-02 18:08:21'),
(402, 'fr', 'login', 'Password incorrect', 'Mot de passe incorrect', '2016-01-02 18:08:21'),
(403, 'fr', 'login', 'Register', 'S''enregistrer', '2016-01-02 18:08:21'),
(404, 'fr', 'login', 'Sign in to your account', 'Connectez-vous', '2016-01-02 18:08:21'),
(405, 'fr', 'login', 'User inactive', 'Utilisateur inactif', '2016-01-02 18:08:21'),
(406, 'fr', 'login', 'Username', 'Nom d''utilisateur', '2016-01-02 18:08:21'),
(407, 'fr', 'login', 'usernameexist', 'Le nom d''utilisateur existe déjà !', '2016-01-02 18:08:21'),
(408, 'fr', 'label', 'Authentication', 'Authentification', '2016-12-09 18:11:17'),
(409, 'fr', 'label', 'Author', 'Auteur', '2016-12-09 18:11:17'),
(410, 'fr', 'label', 'Cron', 'CRON', '2016-12-09 18:11:17'),
(411, 'fr', 'label', 'Description', 'Description', '2016-12-09 18:11:17'),
(412, 'fr', 'label', 'Download', 'Téléchargement', '2016-12-09 18:11:17'),
(413, 'fr', 'label', 'Installation', 'Installation', '2016-12-09 18:11:17'),
(414, 'fr', 'label', 'Keywords', 'Mots clés', '2016-12-09 18:11:17'),
(415, 'fr', 'label', 'noactiveplugins', 'Aucun plugin SEO actif !', '2016-12-09 18:11:17'),
(416, 'fr', 'label', 'Plugin', 'Plugin', '2016-12-09 18:11:17'),
(417, 'fr', 'label', 'Port', 'Port', '2016-12-09 18:11:17'),
(418, 'fr', 'label', 'Proxy', 'Proxy', '2016-12-09 18:11:17'),
(419, 'fr', 'label', 'Re-install', 'Réinstaller', '2016-12-09 18:11:17'),
(420, 'fr', 'label', 'Title', 'Titre', '2016-12-09 18:11:17'),
(421, 'fr', 'label', 'translation by', 'Traduit par', '2016-12-09 18:11:17'),
(422, 'fr', 'label', 'Upgrade', 'Mise à jour', '2016-12-09 18:11:17'),
(423, 'fr', 'label', 'Version', 'Version', '2016-12-09 18:11:17'),
(424, 'fr', 'label', 'wantproceed', 'Voulez-vous vraiment poursuivre ?', '2016-12-09 18:11:17'),
(425, 'fr', 'button', 'Cancel', 'Annuler', '2014-01-08 19:26:19'),
(426, 'fr', 'button', 'Check Status', 'Vérifier', '2014-01-08 19:26:19'),
(427, 'fr', 'button', 'Proceed', 'Valider', '2014-01-08 19:26:19'),
(428, 'fr', 'button', 'Reload', 'Recharger', '2014-01-08 19:26:19'),
(429, 'fr', 'button', 'Show Details', 'Afficher les détails', '2014-01-08 19:26:19'),
(430, 'fr', 'button', 'Show Records', 'Afficher les enregistrements', '2014-01-08 19:26:19'),
(431, 'fr', 'button', 'Skip', 'Passer', '2014-01-08 19:26:19'),
(432, 'fr', 'button', 'Submit', 'Valider', '2014-01-08 19:26:19'),
(433, 'es', 'keyword', 'Crawling keyword', 'Rastreo de palabras clave', '2011-07-07 10:24:15'),
(434, 'es', 'keyword', 'Detailed Keyword Position Reports', 'Informes detallados de posición de palabras clave', '2011-07-07 10:24:15'),
(435, 'es', 'keyword', 'Edit Keyword', 'Editar palabra clave', '2011-07-07 10:24:15'),
(436, 'es', 'keyword', 'Graphical Keyword Position Reports', 'Informe gráfico de la posición de palabras clave', '2011-07-07 10:24:15'),
(437, 'es', 'keyword', 'Keyword already exist', 'Palabra clave ya existe', '2011-07-07 10:24:15'),
(438, 'es', 'keyword', 'Keyword Position Report', 'Informe de posición palabra clave', '2011-07-07 10:24:15'),
(439, 'es', 'keyword', 'New Keyword', 'Nueva palabra clave.', '2011-07-07 10:24:15'),
(440, 'es', 'keyword', 'not assigned to required search engines', 'no asignados a los motores de búsqueda', '2011-07-07 10:24:15'),
(441, 'es', 'keyword', 'pleaseselecttool', 'Por favor, seleccione al menos una herramienta seo.', '2011-07-07 10:24:15'),
(442, 'es', 'keyword', 'Quick Keyword Position Checker', 'Comprobador rápido de posición.', '2011-07-07 10:24:15'),
(443, 'es', 'keyword', 'results from ', 'los resultados de', '2011-07-07 10:24:15'),
(444, 'es', 'keyword', 'Show All results', 'Mostrar todos los resultados', '2011-07-07 10:24:15'),
(445, 'es', 'keyword', 'Successfully crawled keyword', 'Palabra clave rastreada correctamente', '2011-07-07 10:24:15'),
(446, 'es', 'label', 'Authentication', 'Autenticación', '2012-05-12 10:54:10'),
(447, 'es', 'label', 'Author', 'Autor', '2012-05-12 10:54:10'),
(448, 'es', 'label', 'Cron', 'Cron', '2012-05-12 10:54:10'),
(449, 'es', 'label', 'Description', 'Descripción', '2012-05-12 10:54:10'),
(450, 'es', 'label', 'Download', 'Descargar', '2012-05-12 10:54:10'),
(451, 'es', 'label', 'Installation', 'Instalación', '2012-05-12 10:54:10'),
(452, 'es', 'label', 'Keywords', 'Palabras claves', '2012-05-12 10:54:10'),
(453, 'es', 'label', 'noactiveplugins', 'No se encuentra ningún plugin activo.', '2012-05-12 10:54:10'),
(454, 'es', 'label', 'Plugin', 'Plugin', '2012-05-12 10:54:10'),
(455, 'es', 'label', 'Port', 'Port', '2012-05-12 10:54:10'),
(456, 'es', 'label', 'Proxy', 'Proxy', '2012-05-12 10:54:10'),
(457, 'es', 'label', 'Re-install', 'Vuelva a instalar', '2012-05-12 10:54:10'),
(458, 'es', 'label', 'Title', 'Título', '2012-05-12 10:54:10'),
(459, 'es', 'label', 'translation by', 'traducción realizada por', '2012-05-12 10:54:10');
INSERT INTO `texts` (`id`, `lang_code`, `category`, `label`, `content`, `changed`) VALUES
(460, 'es', 'label', 'Upgrade', 'Mejorar', '2012-05-12 10:54:10'),
(461, 'es', 'label', 'Version', 'Versión', '2012-05-12 10:54:10'),
(462, 'es', 'label', 'wantproceed', '¿Realmente deseas continuar?', '2012-05-12 10:54:10'),
(463, 'es', 'website', 'Edit Website', 'Editar página web', '2012-05-31 10:35:22'),
(464, 'es', 'website', 'plscrtwebsite', 'Por favor, cree un sitio web antes de comenzar a usar las herramientas y los plugins seo.', '2012-05-31 10:35:22'),
(465, 'es', 'website', 'Website already exist', 'Esta página web ya existe', '2012-05-31 10:35:22'),
(466, 'es', 'website', 'yourwebalreday', 'su sitio web si ya ha creado una.', '2012-05-31 10:35:22'),
(467, 'es', 'user', 'Edit User', 'Editar usuario', '2011-03-12 11:37:16'),
(468, 'es', 'user', 'Saved My Profile Details', 'Guardados los datos de mi perfil', '2011-03-12 11:37:16'),
(469, 'es', 'sitemap', 'Change frequency', 'Cambiar frecuencia', '2011-03-12 11:23:32'),
(470, 'es', 'sitemap', 'clickproceedsitemap', 'Haga clic en <b> Continuar </b> para crear el archivo sitemap', '2011-03-12 11:23:32'),
(471, 'es', 'sitemap', 'Download sitemap file from', 'Descargar archivo sitemap desde', '2011-03-12 11:23:32'),
(472, 'es', 'sitemap', 'Exclude Url', 'Excluir Url', '2011-03-12 11:23:32'),
(473, 'es', 'sitemap', 'processtaketime', 'Este proceso llevará su tiempo según el número de enlaces en su sitio. Por favor, espere  el tiempo suficiente para conseguir e archivo sitemap', '2011-03-12 11:23:32'),
(474, 'es', 'sitemap', 'Sitemap Type', 'Mapa del sitio Tipo', '2011-03-12 11:23:32'),
(475, 'es', 'saturation', 'clickproceedsaturation', 'Escriba las URL <b> Una por línea </b>. Haga clic en <b> Continuar </b> para comprobar los resultados de motores de búsqueda Saturación', '2011-03-12 11:06:48'),
(476, 'es', 'saturation', 'GenerateSaturationReports', 'Generar informes de saturación del buscador.', '2011-03-12 11:06:48'),
(477, 'es', 'saturation', 'Quick Search Engine Saturation Checker', 'Comprobador rápido del indice de saturación', '2011-03-12 11:06:48'),
(478, 'es', 'saturation', 'Saved Search Engine Saturation results of', 'Guardados indices de saturación de los buscadores de', '2011-03-12 11:06:48'),
(479, 'es', 'saturation', 'Search Engine Saturation Reports', 'Informes de saturación de los buscadores', '2011-03-12 11:06:48'),
(480, 'es', 'rank', 'enterurlproceed', 'Escriba la URL <b> Una por línea </b>. Haga clic en <b> Continuar o Proceder </b> para comprobar el ranking de Google y Alexa.', '2011-03-12 11:03:38'),
(481, 'es', 'rank', 'Google and Alexa Rank Reports', 'Informe de los rankings de Google y Alexa.', '2011-03-12 11:03:38'),
(482, 'es', 'rank', 'Saved rank results of', 'Resultados guardados de', '2011-03-12 11:03:38'),
(483, 'es', 'plugin', 'Edit Seo Plugin', 'Editar Plugin Seo', '2012-05-12 10:55:24'),
(484, 'es', 'plugin', 'Plugin Name', 'Nombre del Plugin', '2012-05-12 10:55:24'),
(485, 'es', 'plugin', 'Seo Plugin Details', 'Detalles del Plugin Seo ', '2012-05-12 10:55:24'),
(486, 'es', 'home', 'Account Summary', 'Resumen de la cuenta', '2012-05-31 10:36:10'),
(487, 'es', 'home', 'Backlinks', 'Backlinks', '2012-05-31 10:36:10'),
(488, 'es', 'home', 'Directory Submission', 'Envío a directorios', '2012-05-31 10:36:10'),
(489, 'es', 'home', 'home_cont1', '<h1 style=\\"text-align: center;margin-bottom: 30px;font-size: 19px;\\">Bienvenido a Seo Panel – El primer panel de control SEO para la supervisión de sitios web.</h1>\r\n\r\n<p>Un programa <b>open source</b> para la <b>gestión y optimización</b> de sus sitios web ideal para conseguir <b>primeras posiciones en los buscadores</b> más destacados.\r\nEn este panel de control encontraras las herramientas imprescindibles para que su sitio web pueda tener unas posiciones preferentes en los buscadores. Este <b>software es completamente libre</b> y esta bajo la licencia <b>GNU GENERAL PUBLIC LICENSE</b>.</p><p></p>\r\n<p>Una de las mejores características de este panel de control, es la posibilidad de <b>ampliación mediante plugins</b> ya sean realizados por terceros o realizados por nosotros mismos, la incorporación de estos plugins sera sencilla y rápida permitiendo así poder evolucionar la herramienta a la misma velocidad que las nuevas directrices SEO.</p>\r\n', '2012-05-31 10:36:10'),
(4672, 'cs', 'website', 'Edit Website', 'Upravit website', '2011-03-21 14:13:51'),
(490, 'es', 'home', 'home_cont2', '<fieldset>\r\n<legend>Caracteristicas principales de SEO PANEL <?=SP_INSTALLED?></legend>\r\n<ul class=\\"infobox\\">\r\n\r\n<li>\r\n<h1>Herramienta para la automatización de entradas en directorios.</h1>\r\n<p>\r\nEsta herramienta nos permitirá <b>semi automatizar las entradas de nuestras webs a directorios</b> gratuitos y de pago. Una de sus características principales es la posibilidad de seguir y controlar si el directorio finalmente ha dado de alta nuestra web en su directorio de forma automática, siendo el seguimiento de las altas mucho más sencillo y eficaz.\r\n</p>\r\n</li>\r\n \r\n<li>\r\n<h1>Herramienta automática de seguimiento de la posición de una palabra en un buscador.</h1>\r\n<p>\r\nEsta herramienta nos permitirá seguir la <b>evolución de una palabra</b> en un buscador concreto, obteniendo información diaria de su posición y de su evolución, podremos ver y exportar estos datos de forma gráfica o incluso en otros formatos de fichero.\r\n</p>\r\n</li>\r\n<li>\r\n<h1>Site Auditor</h1>\r\n<p><p>Site Auditor will <b>audit all SEO factors</b> of each pages of a site and will give a <b>detailed report</b> about each page.\r\nEsta herramienta nos permitirá crear en formatos <b>XML, HTML, TEXT</b> los mapas de nuestras páginas webs para facilitar la indexación a los buscadores.\r\n</p>\r\n</li>\r\n\r\n<li>\r\n<h1>Verificador del ranking en Google y Alexa.</h1>\r\n<p>\r\nDispondrás de una utilidad para seguir diariamente la evolución de tus páginas web en los <b>rankings de Google y Alexa</b>.\r\n</p>\r\n</li>\r\n\r\n<li>\r\n<h1>Herramienta de backlinks</h1>\r\n<p>\r\nPodrás ver la evolución de los <b>backlinks</b> de tus páginas web de una forma diaria, rapida y efectiva en los buscadores más populares de la red como <b>Google, Yahoo, Msn</b> y más que podres incorporar mediante plugins.\r\n</p>\r\n</li>\r\n\r\n<li>\r\n<h1>Medidor del índice de saturación</h1>\r\n<p>\r\nPodrás obtener el número de <b>páginas indexadas</b> de tus web y de esta forma ver la evolución diaria de como los buscadores indexan tu página web.\r\n</p>\r\n</li>\r\n\r\n<li>\r\n<h1>Incorporación de nuevos Plugins</h1>\r\n<p>\r\nEs una de las funciones más potentes de este panel de control, ya que nos permitirá expandir nuestra información a nuestro gusto. Todo el mundo <b>puede desarrollar plugins</b> para nuestra plataforma y de este modo aumentar las posibilidades del panel de control. Si ud. desarrolla una Plugin para nuestro panel de control, lo publicaremos en nuestra página web para que todos los usuarios puedan disfrutar de él.\r\n</p>\r\n</li>\r\n\r\n<li>\r\n<h1>Generador de Meta-Tags</h1>\r\n<p>\r\nDisponemos de una utilidad para poder generar de forma fácil y cómoda el código necesario para que todos los<b> META TAG</b> de sus paginas web estén generados de una forma correcta y de esta forma incentivar a los buscadores a darnos su mejor posición en el índice.\r\n</p>\r\n</li>\r\n</fieldset>', '2012-05-31 10:36:10'),
(4673, 'cs', 'website', 'plscrtwebsite', 'Prosím před tím, než začnete používat seo tools a seo plugins, vytvořte website', '2011-03-21 14:13:51'),
(4674, 'cs', 'website', 'Website already exist', 'Website již existuje', '2011-03-21 14:13:51'),
(4675, 'cs', 'website', 'yourwebalreday', 'vaše website, pokud byla již vytvořena.', '2011-03-21 14:13:51'),
(491, 'es', 'home', 'home_cont3', '<fieldset>\r\n<legend>Recursos en linea para SEO PANEL</legend>    \r\n<ul class=\\"infobox\\">\r\n\r\n    <li>\r\n        <h1>Recursos SEO PANEL en linea</h1>                \r\n        \r\n        \r\n        <p>\r\n            <a href=\\"http://www.seopanel.in\\" target=\\"_blank\\">Sitio Oficial de Seo Panel</a>\r\n        </p>\r\n        <p>\r\n            <a href=\\"<?=SP_DOWNLOAD_LINK?>\\" target=\\"_blank\\">Descarga de SEO PANEL</a>\r\n        </p>\r\n        \r\n        <p>\r\n            <a href=\\"<?=SP_DEMO_LINK?>\\" target=\\"_blank\\">Demo SEO PANEL</a>\r\n        </p>\r\n        \r\n        <p>\r\n            <a href=\\"<?=SP_CONTACT_LINK?>\\" target=\\"_blank\\">Contacto SEO PANEL</a>\r\n        </p>\r\n        \r\n        <p>\r\n            <a href=\\"<?=SP_HELP_LINK?>\\" target=\\"_blank\\">Guía de Ayuda para SEO PANEL</a>\r\n        </p>\r\n        \r\n        <p>\r\n            <a href=\\"<?=SP_FORUM_LINK?>\\" target=\\"_blank\\">Foro SEO PANEL</a>\r\n        </p>\r\n        \r\n        <p>\r\n            <a href=\\"<?=SP_SUPPORT_LINK?>\\" target=\\"_blank\\">Soporte SEO PANEL</a>\r\n        </p>\r\n        \r\n        <p>\r\n            <a href=\\"<?=SP_DONATE_LINK?>\\" target=\\"_blank\\">Haz una donación al equipo de SEO PANEL</a>\r\n        </p>\r\n    </li>\r\n    \r\n</ul>\r\n</fieldset>', '2012-05-31 10:36:11'),
(492, 'es', 'home', 'Pages Indexed', 'Páginas indexadas', '2012-05-31 10:36:11'),
(493, 'es', 'home', 'Ranks', 'Rankings', '2012-05-31 10:36:11'),
(494, 'es', 'home', 'SiteNameUrl', 'Nombre del sitio / URL', '2012-05-31 10:36:11'),
(495, 'es', 'home', 'Website Statistics', 'Estadísticas del Sitio', '2012-05-31 10:36:11'),
(496, 'es', 'panel', 'Check Directory', 'Compruebe Directorio', '2012-05-12 10:55:03'),
(497, 'es', 'panel', 'Directory Manager', 'Administrador de directorios', '2012-05-12 10:55:03'),
(498, 'es', 'panel', 'Edit My Profile', 'Modificar mi perfil', '2012-05-12 10:55:03'),
(499, 'es', 'panel', 'My Profile', 'Mi Perfil', '2012-05-12 10:55:03'),
(500, 'es', 'panel', 'New Proxy', 'Nuevo Proxy', '2012-05-12 10:55:03'),
(501, 'es', 'panel', 'New User', 'Nuevo Usuario', '2012-05-12 10:55:03'),
(502, 'es', 'panel', 'New Website', 'Nuevo Sitio Web', '2012-05-12 10:55:03'),
(503, 'es', 'panel', 'Proxy Manager', 'Administrar Proxy', '2012-05-12 10:55:03'),
(504, 'es', 'panel', 'Report Generation Manager', 'Administrador de la generación de informes ', '2012-05-12 10:55:03'),
(505, 'es', 'panel', 'Reports Manager', 'Administrador de informes', '2012-05-12 10:55:03'),
(506, 'es', 'panel', 'Seo Plugins Manager', 'Administrador de plugins Seo', '2012-05-12 10:55:03'),
(507, 'es', 'panel', 'Seo Tools Manager', 'Administración de herramientas Seo', '2012-05-12 10:55:03'),
(508, 'es', 'panel', 'System Settings', 'Configuración del sistema', '2012-05-12 10:55:03'),
(509, 'es', 'panel', 'User Manager', 'Administrador de usuarios', '2012-05-12 10:55:03'),
(510, 'es', 'panel', 'Website Manager', 'Administrador de sitio web', '2012-05-12 10:55:03'),
(511, 'es', 'proxy', 'Edit Proxy', 'Editar Proxy', '2011-03-12 11:00:44'),
(512, 'es', 'proxy', 'Proxy Password', 'Contraseña proxy', '2011-03-12 11:00:44'),
(513, 'es', 'proxy', 'Proxy Username', 'Nombre de usuario proxy', '2011-03-12 11:00:44'),
(514, 'es', 'proxy', 'Proxyalreadyexist', 'Proxy ya existe!', '2011-03-12 11:00:44'),
(515, 'es', 'seotools', 'Automatic Submission', 'Envío automático', '2011-07-13 19:32:41'),
(516, 'es', 'seotools', 'backlink-checker', 'Verificador de backlinks', '2011-07-13 19:32:41'),
(517, 'es', 'seotools', 'Backlinks Reports', 'Informes de backlinks', '2011-07-13 19:32:41'),
(518, 'es', 'seotools', 'Check Submission Status', 'Comprobar el estado de los envios', '2011-07-13 19:32:41'),
(519, 'es', 'seotools', 'clickgeneratereports', 'Haga clic en <b> Continuar </b> para generar informes', '2011-07-13 19:32:41'),
(520, 'es', 'seotools', 'Detailed Position Reports', 'Informes detallados de posición', '2011-07-13 19:32:41'),
(521, 'es', 'seotools', 'directory-submission', 'Directorio sumisión ', '2011-07-13 19:32:41'),
(522, 'es', 'seotools', 'Featured Submission', 'Directorio destacado', '2011-07-13 19:32:41'),
(523, 'es', 'seotools', 'Generate Backlinks Reports', 'Generar Informes de los backlinks', '2011-07-13 19:32:41'),
(524, 'es', 'seotools', 'Generate Keyword Reports', 'Generar informes de palabras clave', '2011-07-13 19:32:41'),
(525, 'es', 'seotools', 'Generate Rank Reports', 'Generar informes de los rankings', '2011-07-13 19:32:41'),
(526, 'es', 'seotools', 'Generate Saturation Reports', 'Generar informes de saturación', '2011-07-13 19:32:41'),
(527, 'es', 'seotools', 'Google Sitemap Generator', 'Generador de Google Sitemap', '2011-07-13 19:32:41'),
(528, 'es', 'seotools', 'Graphical Position Reports', 'Informe de posición gráfico', '2011-07-13 19:32:41'),
(529, 'es', 'seotools', 'Keyword Position Summary', 'Resumen de posición para palabra clave', '2011-07-13 19:32:41'),
(530, 'es', 'seotools', 'keyword-position-checker', 'Verificador de posición palabra clave.', '2011-07-13 19:32:41'),
(531, 'es', 'seotools', 'Keywords Manager', 'Administrador de palabras clave.', '2011-07-13 19:32:41'),
(532, 'es', 'seotools', 'Quick Backlinks Checker', 'Verificador rápido de backlinks', '2011-07-13 19:32:41'),
(533, 'es', 'seotools', 'Quick Position Checker', 'Verificador rápida de posición', '2011-07-13 19:32:41'),
(534, 'es', 'seotools', 'Quick Rank Checker', 'Verificador rápido rankings', '2011-07-13 19:32:41'),
(535, 'es', 'seotools', 'Quick Saturation Checker', 'Verificador rápida de saturación', '2011-07-13 19:32:41'),
(536, 'es', 'seotools', 'Rank Reports', 'Informes Rankings', '2011-07-13 19:32:41'),
(537, 'es', 'seotools', 'rank-checker', 'Verificador Ranking', '2011-07-13 19:32:41'),
(538, 'es', 'seotools', 'Saturation Reports', 'Informes de saturación', '2011-07-13 19:32:41'),
(539, 'es', 'seotools', 'saturation-checker', 'Saturación del motor de búsqueda', '2011-07-13 19:32:41'),
(540, 'es', 'seotools', 'sitemap-generator', 'Generador de sitemap', '2011-07-13 19:32:41'),
(541, 'es', 'seotools', 'Skipped Directories', 'Directorios omitidos', '2011-07-13 19:32:41'),
(542, 'es', 'seotools', 'Submission Reports', 'Informes de los envíos', '2011-07-13 19:32:41'),
(543, 'es', 'seotools', 'User Access', 'Acceso de usuario', '2011-07-13 19:32:41'),
(544, 'es', 'settings', 'SP_CRAWL_DELAY', 'Tiempo de retardo entre cada rastreo de la araña (segundos)', '2012-05-12 11:03:05'),
(545, 'es', 'settings', 'SP_DESCRIPTION', 'Seo Panel Descripción', '2012-05-12 11:03:05'),
(546, 'es', 'settings', 'SP_ENABLE_PROXY', 'Activar Proxy', '2012-05-12 11:03:05'),
(547, 'es', 'settings', 'SP_HOTLINKING', 'Protección de imágenes hotlink activado', '2012-05-12 11:03:05'),
(548, 'es', 'settings', 'SP_KEYWORDS', 'Palabras claves Seo Panel', '2012-05-12 11:03:05'),
(549, 'es', 'settings', 'SP_PAGINGNO', 'Número de entradas por página', '2012-05-12 11:03:05'),
(550, 'es', 'settings', 'SP_TITLE', 'Título Seo Panel', '2012-05-12 11:03:05'),
(551, 'es', 'settings', 'SP_USER_GEN_REPORT', 'Permite a los usuarios generar informes', '2012-05-12 11:03:05'),
(552, 'es', 'settings', 'SP_USER_REGISTRATION', 'Interfaz de usuario para el registro', '2012-05-12 11:03:05'),
(553, 'es', 'settings', 'syssettingssaved', 'La configuración del sistema se han guardado correctamente!', '2012-05-12 11:03:05'),
(554, 'es', 'login', 'Confirm Password', 'Confirmar contraseña', '2011-03-12 10:53:35'),
(555, 'es', 'login', 'Create my account', 'Crear una cuenta', '2011-03-12 10:53:35'),
(556, 'es', 'login', 'Create New Account', 'Crear una cuenta nueva', '2011-03-12 10:53:35'),
(557, 'es', 'login', 'Email', 'Correo electrónico', '2011-03-12 10:53:35'),
(558, 'es', 'login', 'emailexist', 'Correo electrónico ya existe!', '2011-03-12 10:53:35'),
(559, 'es', 'login', 'Enter the code as it is shown', 'Introduzca el código tal como se muestra', '2011-03-12 10:53:35'),
(560, 'es', 'login', 'First Name', 'Nombre', '2011-03-12 10:53:35'),
(561, 'es', 'login', 'Last Name', 'Apellido', '2011-03-12 10:53:35'),
(562, 'es', 'login', 'Login', 'Inicio de sesión', '2011-03-12 10:53:35'),
(563, 'es', 'login', 'Login incorrect', 'Inicio de sesión incorrecto', '2011-03-12 10:53:35'),
(564, 'es', 'login', 'newaccountsuccess', 'Nueva cuenta creada con éxito!', '2011-03-12 10:53:35'),
(565, 'es', 'login', 'Password', 'Contraseña', '2011-03-12 10:53:35'),
(566, 'es', 'login', 'Password incorrect', 'Contraseña incorrecta', '2011-03-12 10:53:35'),
(567, 'es', 'login', 'Register', 'Registro', '2011-03-12 10:53:35'),
(568, 'es', 'login', 'Sign in to your account', 'Acceda a su cuenta', '2011-03-12 10:53:35'),
(569, 'es', 'login', 'User inactive', 'Usuario inactivo', '2011-03-12 10:53:35'),
(570, 'es', 'login', 'Username', 'Nombre de usuario', '2011-03-12 10:53:35'),
(571, 'es', 'login', 'usernameexist', 'Nombre de usuario ya existe!', '2011-03-12 10:53:35'),
(572, 'es', 'support', 'support_cont1', '<fieldset>\r\n<legend>Seo Panel Sistema de Soporte</legend>\r\n<ul class=\\"infobox\\">\r\n    <li>\r\n        <h1>1000 Directorios Paquete</h1> \r\n        <p>\r\n            Estamos proporcionando un paquete con <b>1000 directorios en internet activos y verificados</b>, para que los pueda agregar a su Seo Panel dentro de la herramienta para el envio a directorios.\r\n         Le ayudará a aumentar los <b> backlilnks </b> de sus sitios web.\r\n            \r\nEn realidad la lista de 1000 directorios se realizó para recoger algo de dinero para el futuro <b>\r\ndesarrollo </b> de Seo Panel.\r\n\r\n           Para obtener la lista de directorios 1000 por favor <a href=\\"<?=SP_DONATE_LINK?>\\" target=\\"_blank\\">realice una donación de </a>\r\n$10 o más para mejorar las características del seo panel.\r\n            Si usted tiene alguna pregunta sobre el paquete de 1000 directorios, por favor <a href=\\"<?=SP_CONTACT_LINK?>\\"\r\ntarget=\\"_blank\\">contáctenos</a> o abrir un ticket en <a href=\\"<?=SP_SUPPORT_LINK?>\\"\r\ntarget=\\"_blank\\">soporte del sistema</a>.   \r\n        </p>        \r\n        <p>\r\n            <a href=\\"<?=SP_DONATE_LINK?>\\" target=\\"_blank\\">Visite este enlace para donar a seo panel</a>\r\n        </p>\r\n        <br>\r\n    </li>\r\n    \r\n    <li>\r\n        <h1>Paquete de motores de búsqueda local</h1> \r\n        <p>\r\n   \r\nAñada <b> motores de búsqueda locales </b> de google, yahoo, msn (<b>por ejemplo, : www.google.de, www.google.fr Etc </b>) para que Seo Panel verifique sus palabras clave en buscadores a nivel local.\r\n\r\n\r\n           Para obtener el paquete de búsqueda en motores de busqueda locales (de acuerdo a sus necesidades), por favor <a\r\nhref=\\"<?=SP_DONATE_LINK?>\\" target=\\"_blank\\">realice una donación de</a> $ 10 o más para mejorar las características de seo panel.\r\n            Antes de la donación, por favor <a href=\\"<?=SP_CONTACT_LINK?>\\" target=\\"_blank\\">contactenos</a> para que nos proporcione la lista de los buscadores locales.\r\n            <br><br>              \r\n            También para agregar <b> nuevos motores de búsqueda (por ejemplo: baidu.com) </b> para poder comprobar sus mejoras en estos buscadores con sus palabras clave,\r\npor favor <a href=\\"<?=SP_CONTACT_LINK?>\\" target=\\"_blank\\">contactenos</a> o abra un ticket en<a\r\nhref=\\"<?=SP_SUPPORT_LINK?>\\" target=\\"_blank\\">la sección de soporte del sistema</a>. \r\n        </p>        \r\n        <p class=\\"visit\\">\r\n            <a href=\\"<?=SP_CONTACT_LINK?>\\" target=\\"_blank\\">Visita este enlace para contactar con nosotros</a>\r\n        </p>\r\n        <br>\r\n    </li>\r\n    \r\n    <li>\r\n        <h1>Seo Panel Plugins</h1> \r\n        <p>\r\n        Añada <b> plugins SEO </b> a su panel seo para <b> ampliar las características </b> de acuerdo a sus requisitos.\r\n            <a href=\\"<?=SP_PLUGINSITE?>\\" target=\\"_blank\\">Seo panel plugins</a> son proporcionados por el panel seo\r\ny sitios de terceros.\r\n           También es posible <b> desarrollar  </b> plugins SEO para su panel de seo.\r\n            Usted puede <a href=\\"<?=SP_PLUGINSITE?>\\" target=\\"_blank\\">presentar</a> su plugin seo a Seo Panel y\r\nvamos a <b>publicarlo</b> en nuestro sitio web después de nuestra  <b>  revisión</b>.        \r\n        </p>        \r\n        <p>\r\n            <a href=\\"<?=SP_PLUGINSITE?>\\" target=\\"_blank\\">Visita este enlace para obtener los plugins de Seo Panel</a>\r\n        </p>\r\n        <br>\r\n    </li>    \r\n    <li>\r\n        <h1>Contactenos</h1> \r\n        <p>\r\n        Contacte con nosotros para cualquier pregunta sobre las <b>Herramientas Seo Panel, plugins y otras características </b> mediante el uso de este enlace.   \r\n        </p>        \r\n        <p>\r\n            <a href=\\"<?=SP_CONTACT_LINK?>\\" target=\\"_blank\\">Visita este enlace para contactar con nosotros</a>\r\n        </p>\r\n        <br>\r\n    </li>    \r\n    <li>\r\n        <h1>Boletos de Soporte</h1> \r\n        <p>\r\n           Para obtener <b> apoyo técnico</b> del equipo Seo Panel o para configurar el panel de <b>Herramientas Seo o plugins y\r\n otras características </b>. Por ejemplo: Para configurar el cron para la posición corrector de palabras clave.\r\n        </p>        \r\n        <p>\r\n            <a href=\\"<?=SP_SUPPORT_LINK?>\\" target=\\"_blank\\">Visita este enlace para crear un tiket de soporte</a>\r\n        </p>\r\n        <br>\r\n    </li>    \r\n    <li>\r\n        <h1>Informar de bugs</h1> \r\n        <p>\r\n            Informanos de<b>bugs o errores</b> sobre <b>Seo Panel, las herramientas, plugins o características </b> mediante el uso de link de abajo.\r\n           Ayudanos a mejorar las características en las versiones siguientes.       \r\n        </p>        \r\n        <p>\r\n            <a href=\\"<?=SP_SUPPORT_LINK?>\\" target=\\"_blank\\">Visita este enlace para informar de los errores</a>\r\n        </p>\r\n        <br>\r\n    </li>    \r\n</ul>\r\n</fieldset>', '2011-07-13 19:45:23'),
(573, 'es', 'support', 'support_cont2', '<fieldset>\r\n<legend>Seo Panel Recursos en linea</legend>\r\n<ul class=\\"infobox\\">\r\n        \r\n    <li>\r\n        <h1>Seo Panel Guía de Ayuda</h1> \r\n        <p>\r\n            Puede ver la <a href=\\"<?=SP_HELP_LINK?>\\" target=\\"_blank\\">seo panel documentación</a> en el\r\n<b>guía de ayuda</b>, que contiene e <b>documentación</b> para el panel de herramientas seo, plugins y afines\r\ncaracterísticas.\r\n            <br>Es el mejor lugar en Internet para obtener <b> ayuda </b> acerca del panel de seo. Esperamos que\r\n<b> contribuir </b> para ayudar a la guía del panel seo, si usted encuentra errores o cosas que faltan.      \r\n        </p>\r\n        <p>\r\n            <a href=\\"<?=SP_HELP_LINK?>\\" target=\\"_blank\\">Visita seo panel de guía de ayuda</a>\r\n        </p>\r\n        <br>\r\n    </li>    \r\n    <li>\r\n        <h1>Seo Panel Foro</h1> \r\n        <p>\r\n            Un sitio para hablar sobre la primera fuente abierta del mundo <b> seo panel de control </b>.\r\n            Es el mejor lugar para encontrar las <b>respuestas </b> para su <b> preguntas </b> acerca del panel de seo. \r\n            <br>Además, puede <b> comparte </b> el  <b>experiencia</b>, mientras que usando el panel de SEO para optimizar su\r\nsitios web.                             \r\n        </p>        \r\n        <p>\r\n            <a href=\\"<?=SP_FORUM_LINK?>\\" target=\\"_blank\\">Visita seo panel foro</a>\r\n        </p>\r\n        <br>\r\n    </li>\r\n</ul>    \r\n</fieldset>', '2011-07-13 19:45:23'),
(574, 'es', 'support', 'support_cont3', '<fieldset>\r\n<legend>Haz una donación a Seo Panel</legend>\r\n<ul class=\\"infobox\\">        \r\n    <li>\r\n        <h1>Haz una donación a Seo Panel - El primer Open source seo panel de control en el mundo</h1> \r\n        <p>\r\n            <b>Realiza una donación a </b> Seo Panel para ayudar al primer portal Open Source para el control SEO del mundo.\r\n            Estamos planeando añadir y mejorar <b>  características </b> del Seo panel en el futuro.\r\n            <br>Solo con sus <b> apoyos </b> podremos alcanzar nuesttros <b>objetivos</b>.\r\n            Si usted siente que es el panel seo <b> vale la pena </b> para usted, por favor, realice alguna donación para el equipo de Seo Panel.\r\n            <br>Nosostros  <b> publicararemos </b> su nombre y pápgina web en la sección de donaciónes de nuestra página web <a href=\\"<?=SP_DONATE_LINK?>\\"\r\ntarget=\\"_blank\\">Página de donaciones</a>, una vez que tengamos su donación.\r\n        </p>\r\n        <p>\r\n            <a href=\\"<?=SP_DONATE_LINK?>\\" target=\\"_blank\\">Visita este enlace para donar a seo panel</a>\r\n        </p>\r\n        <br>\r\n    </li>\r\n</ul>\r\n</fieldset>', '2011-07-13 19:45:23'),
(575, 'en', 'panel', 'Cron Command', 'Cron Command', '2010-09-23 07:43:06'),
(576, 'en', 'panel', 'Add following command to your cron tab', 'Add following command to your cron tab', '2010-09-23 08:04:03'),
(577, 'es', 'panel', 'Add following command to your cron tab', 'Añadir el siguiente comando para el cron del sistema', '2012-05-12 10:55:03'),
(578, 'es', 'panel', 'Cron Command', 'Comando Cron', '2012-05-12 10:55:03'),
(579, 'en', 'panel', 'alsocheckfollowlink', 'Also check following link if you need more details.', '2010-09-23 08:46:30'),
(580, 'es', 'panel', 'alsocheckfollowlink', 'Verifique este link si Ud. necesitas más detalles', '2012-05-12 10:55:03'),
(581, 'en', 'label', 'Click Here', 'Click Here', '2010-09-23 09:22:08'),
(582, 'en', 'keyword', 'to create new keywords', 'to create new keywords', '2010-09-23 09:23:07'),
(583, 'en', 'keyword', 'Import Keywords', 'Import Keywords', '2010-09-26 07:47:00'),
(584, 'en', 'common', 'Keywords', 'Keywords', '2010-09-26 07:56:11'),
(585, 'en', 'label', 'already exist', 'already exist', '2010-09-26 08:08:07'),
(586, 'en', 'panel', 'About Us', 'About Us', '2010-09-26 09:35:05'),
(587, 'en', 'label', 'Developers', 'Developers', '2010-09-26 10:06:56'),
(588, 'en', 'label', 'Translators', 'Translators', '2010-09-26 10:06:56'),
(589, 'en', 'settings', 'Click here to become a sponsor for Seo Panel', '<b>Donate $100</b> and become a <b>sponsor</b> of Seo Panel.', '2010-09-29 08:25:10'),
(590, 'en', 'label', 'Sponsors', 'Sponsors', '2010-09-26 10:18:27'),
(591, 'en', 'settings', 'SP_DEFAULTLANG', 'Default Language', '2010-09-27 08:46:39'),
(592, 'fr', 'common', 'Action', 'Action', '2016-12-09 18:11:57'),
(593, 'fr', 'common', 'Activate', 'Activer', '2016-12-09 18:11:57'),
(594, 'fr', 'common', 'Active', 'Active', '2016-12-09 18:11:57'),
(595, 'fr', 'common', 'Admin Panel', 'Administration', '2016-12-09 18:11:57'),
(596, 'fr', 'common', 'Alexa Rank', 'Rank Alexa', '2016-12-09 18:11:57'),
(597, 'fr', 'common', 'All', 'Tout', '2016-12-09 18:11:57'),
(598, 'fr', 'common', 'Category', 'Catégorie', '2016-12-09 18:11:57'),
(599, 'fr', 'common', 'contact', 'Contact', '2016-12-09 18:11:57'),
(600, 'fr', 'common', 'copyright', 'Copyright © [year] www.seopanel.in Tous droits réservés.', '2016-12-09 18:11:57'),
(601, 'fr', 'common', 'Country', 'Pays', '2016-12-09 18:11:57'),
(602, 'fr', 'common', 'Crawl Meta Data', 'Exploration des métadonnées', '2016-12-09 18:11:57'),
(603, 'fr', 'common', 'Date', 'Date', '2016-12-09 18:11:57'),
(604, 'fr', 'common', 'Delete', 'Supprimer', '2016-12-09 18:11:57'),
(605, 'fr', 'common', 'Details', 'Détails', '2016-12-09 18:11:57'),
(606, 'fr', 'common', 'Directory', 'Annuaire', '2016-12-09 18:11:57'),
(607, 'fr', 'common', 'Donate', 'Faire un don', '2016-12-09 18:11:57'),
(608, 'fr', 'common', 'Edit', 'Editer', '2016-12-09 18:11:57'),
(609, 'fr', 'common', 'Entry cannot be blank', 'Vous devez saisir quelque chose', '2016-12-09 18:11:57'),
(610, 'fr', 'common', 'entrynotvalid', 'La saisie ne semble pas être valide', '2016-12-09 18:11:57'),
(611, 'fr', 'common', 'failed', 'échoué', '2016-12-09 18:11:57'),
(612, 'fr', 'common', 'forum', 'Forum', '2016-12-09 18:11:57'),
(613, 'fr', 'common', 'Found', 'Trouvé', '2016-12-09 18:11:57'),
(614, 'fr', 'common', 'Google Pagerank', 'Google PageRank', '2016-12-09 18:11:57'),
(615, 'fr', 'common', 'help', 'Aide', '2016-12-09 18:11:57'),
(616, 'fr', 'common', 'hidenews', 'Cacher les nouvelles SeoPanel', '2016-12-09 18:11:57'),
(617, 'fr', 'common', 'Id', 'Id', '2016-12-09 18:11:57'),
(618, 'fr', 'common', 'Inactivate', 'Désactiver', '2016-12-09 18:11:57'),
(619, 'fr', 'common', 'Inactive', 'Désactivé', '2016-12-09 18:11:57'),
(620, 'fr', 'common', 'Invalid characters', 'Caractères invalides', '2016-12-09 18:11:57'),
(621, 'fr', 'common', 'Invalid code entered', 'Code incorrect', '2016-12-09 18:11:57'),
(622, 'fr', 'common', 'Invalid email address entered', 'Adresse mail incorrecte', '2016-12-09 18:11:57'),
(623, 'fr', 'common', 'Invalid value', 'Valeur incorrecte', '2016-12-09 18:11:57'),
(624, 'fr', 'common', 'Keyword', 'Mot clé', '2016-12-09 18:11:57'),
(625, 'fr', 'common', 'Keywords', 'Mots clé', '2016-12-09 18:11:57'),
(626, 'fr', 'common', 'My Account', 'Mon compte', '2016-12-09 18:11:57'),
(627, 'fr', 'common', 'Name', 'Nom', '2016-12-09 18:11:57'),
(628, 'fr', 'common', 'No', 'Non', '2016-12-09 18:11:57'),
(629, 'fr', 'common', 'No Keywords Found', 'Aucun mots clé', '2016-12-09 18:11:57'),
(630, 'fr', 'common', 'No Records Found', 'Aucun élément', '2016-12-09 18:11:57'),
(631, 'fr', 'common', 'noactivetools', 'Aucun outil Seo actif trouvé !', '2016-12-09 18:11:57'),
(632, 'fr', 'common', 'nowebsites', 'Aucun site ', '2016-12-09 18:11:57'),
(633, 'fr', 'common', 'password632', 'Le mot de passe doit faire entre 6 et 32 caractères', '2016-12-09 18:11:57'),
(634, 'fr', 'common', 'passwordnotmatch', 'Les mots de passe ne correspondent pas', '2016-12-09 18:11:57'),
(635, 'fr', 'common', 'Period', 'Période', '2016-12-09 18:11:57'),
(636, 'fr', 'common', 'Priority', 'Priorité', '2016-12-09 18:11:57'),
(637, 'fr', 'common', 'Rank', 'Rang', '2016-12-09 18:11:57'),
(638, 'fr', 'common', 'Reports', 'Rapports', '2016-12-09 18:11:57'),
(639, 'fr', 'common', 'Results', 'Résultats', '2016-12-09 18:11:57'),
(640, 'fr', 'common', 'Search Engine', 'Moteur de recherche', '2016-12-09 18:11:57'),
(641, 'fr', 'common', 'Select', 'Sélection', '2016-12-09 18:11:57'),
(642, 'fr', 'common', 'Seo Plugins', 'Plugins Seo', '2016-12-09 18:11:57'),
(643, 'fr', 'common', 'Seo Tools', 'Outils Seo', '2016-12-09 18:11:57'),
(644, 'fr', 'common', 'Sign out', 'Déconnecter', '2016-12-09 18:11:57'),
(645, 'fr', 'common', 'Sign Up', 'S''enregistrer', '2016-12-09 18:11:57'),
(646, 'fr', 'common', 'signin', 'Se connecter', '2016-12-09 18:11:57'),
(647, 'fr', 'common', 'Status', 'Statut', '2016-12-09 18:11:57'),
(648, 'fr', 'common', 'Total', 'Total', '2016-12-09 18:11:57'),
(649, 'fr', 'common', 'Url', 'Url', '2016-12-09 18:11:57'),
(650, 'fr', 'common', 'User', 'Utilisateur', '2016-12-09 18:11:57'),
(651, 'fr', 'common', 'User Panel', 'Panneau utilisateur', '2016-12-09 18:11:57'),
(652, 'fr', 'common', 'Website', 'Site web', '2016-12-09 18:11:57'),
(653, 'fr', 'common', 'Yes', 'Oui', '2016-12-09 18:11:57'),
(654, 'fr', 'label', 'already exist', 'déjà existant', '2016-12-09 18:11:17'),
(655, 'fr', 'label', 'Click Here', 'Cliquer ici', '2016-12-09 18:11:17'),
(656, 'fr', 'label', 'Developers', 'Développeurs  ', '2016-12-09 18:11:17'),
(657, 'fr', 'label', 'Sponsors', 'Sponsors', '2016-12-09 18:11:17'),
(658, 'fr', 'label', 'Translators', 'Traducteurs', '2016-12-09 18:11:17'),
(659, 'fr', 'settings', 'Click here to become a sponsor for Seo Panel', '<b>Faire un don $100</b> et devenir un <b>sponsor</b> de Seo Panel.', '2016-12-09 18:04:37'),
(660, 'fr', 'settings', 'SP_CRAWL_DELAY', 'Délai entre chaque exploration (en secondes)', '2016-12-09 18:04:37'),
(661, 'fr', 'settings', 'SP_DEFAULTLANG', 'Langue par défaut', '2016-12-09 18:04:37'),
(662, 'fr', 'settings', 'SP_DESCRIPTION', 'Description', '2016-12-09 18:04:37'),
(663, 'fr', 'settings', 'SP_ENABLE_PROXY', 'Activer le proxy', '2016-12-09 18:04:37'),
(664, 'fr', 'settings', 'SP_HOTLINKING', 'Protection hotlink des images activée', '2016-12-09 18:04:37'),
(665, 'fr', 'settings', 'SP_KEYWORDS', 'Mots clé Seo Panel', '2016-12-09 18:04:37'),
(666, 'fr', 'settings', 'SP_PAGINGNO', 'Nombre d''éléments par page', '2016-12-09 18:04:37'),
(667, 'fr', 'settings', 'SP_TITLE', 'Titre Seo Panel', '2016-12-09 18:04:37'),
(668, 'fr', 'settings', 'SP_USER_GEN_REPORT', 'Autoriser l''utilisateur à générer un rapport', '2016-12-09 18:04:37'),
(669, 'fr', 'settings', 'SP_USER_REGISTRATION', 'Interface d''enregistrement utilisateur', '2016-12-09 18:04:37'),
(670, 'fr', 'settings', 'syssettingssaved', 'Paramètres bien enregistrés !', '2016-12-09 18:04:37'),
(671, 'fr', 'plugin', 'Edit Seo Plugin', 'Editer le pluing Seo', '2012-05-14 11:42:00'),
(672, 'fr', 'plugin', 'Plugin Name', 'Nom du plugin', '2012-05-14 11:42:00'),
(673, 'fr', 'plugin', 'Seo Plugin Details', 'Détails du plugin Seo', '2012-05-14 11:42:00'),
(674, 'fr', 'panel', 'About Us', 'A propos', '2016-12-09 18:10:57'),
(675, 'fr', 'panel', 'Add following command to your cron tab', 'Ajouter la commande suivante à votre crontab', '2016-12-09 18:10:57'),
(676, 'fr', 'panel', 'alsocheckfollowlink', 'Cliquer sur le lien suivant pour plus de détails.', '2016-12-09 18:10:57'),
(677, 'fr', 'panel', 'Check Directory', 'Vérifier l''annuaire', '2016-12-09 18:10:57'),
(678, 'fr', 'panel', 'Cron Command', 'Commande Cron', '2016-12-09 18:10:57'),
(679, 'fr', 'panel', 'Directory Manager', 'Gestionnaire d''annuaires', '2016-12-09 18:10:57'),
(680, 'fr', 'panel', 'Edit My Profile', 'Editer mon profil', '2016-12-09 18:10:57'),
(681, 'fr', 'panel', 'My Profile', 'Mon profil', '2016-12-09 18:10:57'),
(682, 'fr', 'panel', 'New Proxy', 'Nouveau proxy', '2016-12-09 18:10:57'),
(683, 'fr', 'panel', 'New User', 'Nouvel utilisateur', '2016-12-09 18:10:57'),
(684, 'fr', 'panel', 'New Website', 'Nouveau site web', '2016-12-09 18:10:57'),
(685, 'fr', 'panel', 'Proxy Manager', 'Gestion Proxy', '2016-12-09 18:10:57'),
(686, 'fr', 'panel', 'Report Generation Manager', 'Gestion de la génération des rapports', '2016-12-09 18:10:57'),
(687, 'fr', 'panel', 'Reports Manager', 'Gestion des rapports', '2016-12-09 18:10:57'),
(688, 'fr', 'panel', 'Seo Plugins Manager', 'Gestion des plugins Seo', '2016-12-09 18:10:57'),
(689, 'fr', 'panel', 'Seo Tools Manager', 'Gestion des outils Seo', '2016-12-09 18:10:57'),
(690, 'fr', 'panel', 'System Settings', 'Paramètres', '2016-12-09 18:10:57'),
(691, 'fr', 'panel', 'User Manager', 'Gestion des utilisateurs', '2016-12-09 18:10:57'),
(692, 'fr', 'panel', 'Website Manager', 'Gestion des sites web', '2016-12-09 18:10:57'),
(693, 'fr', 'home', 'Account Summary', 'Résumé du compte', '2011-07-10 10:26:55'),
(694, 'fr', 'home', 'Backlinks', 'Liens entrants', '2011-07-10 10:26:55'),
(695, 'fr', 'home', 'Directory Submission', 'Soumission', '2011-07-10 10:26:55'),
(696, 'fr', 'home', 'home_cont1', '<h1 style=\\"text-align: center;margin-bottom: 30px;font-size: 19px;\\">Bienvenue sur le site de Seo Panel - Le premier panneau de contrôle Seo multisite au monde</h1>\r\n        <p>\r\n            <b>Seo Panel</b> est un <b>panneau de contrôle Seo, open source</b>, pour gérer le <b>référencement</b> de vos sites internet.\r\n            Seo Panel est une <b>boite à outils</b> intégrant les tous derniers outils Seo pour <b>suivre et optimiser</b> les <b>résultats</b> de vos sites.\r\n            C\\''est un <b>logiciel libre</b>, sous licence <b>GNU GENERAL PUBLIC LICENSE</b>.\r\n\r\n            L\\''atout majeur de Seo Panel est d\\''être <b>évolutif</b> grâce à son système de <a href=\\"<?=SP_PLUGINSITE?>\\" target=\\"_blank\\">plugins Seo</a>.\r\n            Tout le monde peut <b>développer et installer</b> facilement des plugins pour ajouter de nouvelles fonctionnalités.</p>\r\n        <p></p>\r\n        <p>\r\n            Ce logiciel open source a <b>vu le jour en janvier 2010</b>.\r\n            Depuis cette date, des <b>milliers</b> de <b>webmasters</b> utilise ce logiciel pour le référencement de leurs sites.\r\n            Utilisez Seo Panel dès aujourd\\''hui, et <b>appréciez</b> l\\''intégration de <b>toutes les techniques Seo</b> dans un seul et même outil, <b>Seo Panel</b>.\r\n        </p>', '2011-07-10 10:26:55'),
(697, 'fr', 'home', 'home_cont2', '<fieldset>\r\n<legend>Principales fonctionnalités de Seo Panel <?=SP_INSTALLED?></legend>\r\n<ul class=\\"infobox\\">\r\n    <li>        \r\n        <h1>Outil de soumission automatisée</h1>\r\n        <p>\r\n            L\\''outil de soumission automatisée permet de <b>soumettre vos sites internet</b> aux principaux <b>annuaires gratuits et commerciaux</b>.\r\n            Le <b>statut</b> de chaque soumission peut être <b>suivi périodiquement</b> par le <b>script de contrôle</b>.\r\n            Le <b>gestionnaire d\\''annuaires</b> vous aidera à vérifier le statut de chacun des annuaires.\r\n        </p>\r\n    </li>\r\n    <li>        \r\n        <h1>Contrôle de position sur mot-clé</h1>\r\n        <p>\r\n            L\\''outil de contrôle de position sur mot-clé va trouver et sauvegarder la <b>position de votre site</b> dans les moteurs de recherche pour les <b>mots-clés visés</b>.\r\n            Dans la section des rapports de position, un <b>suivi quotidien et détaillé</b> des positions sur les différents mots-clés dans les moteurs de recherche est présenté <b>sous forme graphique</b>.\r\n        </p>\r\n    </li>\r\n    <li>        \r\n        <h1>Vérificateur de site</h1>\r\n        <p>Le vérificateur de site va <b>vérifier tous les paramètres SEO</b> des pages du site audité, et fournir un <b>rapport détaillé</b> sur chacune des pages. Cela permet de créer des fichiers sitemap <b>XML, HTML, ou texte</b> de votre site, afin de les <b>envoyer aux moteurs de rechercher.</b></p>\r\n    </li>\r\n    <li>        \r\n        <h1>Contrôle des rangs Google et Alexa</h1>\r\n        <p>\r\n            L\\''outil de contrôle du rang Google et Alexa va trouver et sauvegarder les <b>rangs Google et Alexa</b> de vos sites.\r\n            Dans la section rapports de rang, un <b>suivi quotidien et détaillé</b> du rang Google et du rang Alexa est effectué, pour chacun de vos sites.\r\n        </p>\r\n    </li>\r\n    <li>        \r\n        <h1>Contrôle des liens retour</h1>\r\n        <p>\r\n            Le contrôle des liens retour permet de trouver et sauvegarder le <b>nombre de liens retour</b> vers vos sites sur les différents moteurs de recherche <b>(Google, Yahoo, MSN, ...)</b>.\r\n            <br>Dans la section des rapports sur liens retour, vous pouvez voir un <b>comptage quotidien et détaillé des liens retour</b> de chacun des sites.\r\n        </p>\r\n    </li>    \r\n    <li>        \r\n        <h1>Contrôle de saturation des moteurs de recherche</h1>\r\n        <p>\r\n            Le contrôle de saturation va trouver et sauvegarder le <b>nombre de pages indexées</b> de vos sites, sur les différents moteurs de recherche <b>(Google, Yahoo, MSN, ...)</b>.<br>\r\n            Dans les rapports de saturation, vous pouvez voir les <b>détails quotidiens</b> du <b>nombre de pages indexées</b> pour chacun de vos sites.\r\n        </p>\r\n    </li>\r\n    <li>        \r\n        <h1>Plugins Seo Panel</h1></h1>\r\n        <p>\r\n        	Le <b>principal atout</b> de Seo Panel est son <b>évolutivité</b>.\r\n        	Ajoutez <b>vos propres plugins</b> pour <b>étendre les fonctionnalités</b> de votre Seo Panel, selon vos besoins.<br/>\r\n            Les <a href=\\"<?=SP_PLUGINSITE?>\\" target=\\"_blank\\">plugins Seo Panel</a> sont disponibles via le site Seo Panel, ou par des tiers.\r\n            Vous pouvez facilement <b>développer</b> des plugins pour votre Seo Panel, \r\n            Et vous pouvez aussi <a href=\\"<?=SP_PLUGINSITE?>\\" target=\\"_blank\\">soumettre</a> vos plugins à Seo Panel. Ils seront <b>publiés</b> sur notre site, après validation.\r\n        </p>\r\n    </li>\r\n    <li>        \r\n        <h1>Générateur de tags Meta</h1>\r\n        <p>\r\n            Le générateur de tags Meta est un <b>plugin Seo Panel</b> permettant de créer des <b>tags Meta personnalisés</b> pour vos sites.\r\n            Il vous aidera à donner <b>plus d\\''informations</b> sur vos sites aux <b>robots de recherche</b> lors de leurs visites.\r\n        </p>\r\n    </li>\r\n</ul>\r\n</fieldset>', '2011-07-10 10:26:55'),
(698, 'fr', 'home', 'home_cont3', '<fieldset>\r\n<legend>Seo Panel - Ressources en ligne</legend>    \r\n<ul class=\\"infobox\\">\r\n\r\n    <li>\r\n        <h1>Références Seo Panel</h1>                \r\n        \r\n        \r\n        <p>\r\n            <a href=\\"http://www.seopanel.in\\" target=\\"_blank\\">Site officiel Seo Panel</a>\r\n        </p>\r\n        <p>\r\n            <a href=\\"<?=SP_DOWNLOAD_LINK?>\\" target=\\"_blank\\">Télécharger Seo Panel</a>\r\n        </p>\r\n        \r\n        <p>\r\n            <a href=\\"<?=SP_DEMO_LINK?>\\" target=\\"_blank\\">Site de démonstration Seo Panel</a>\r\n        </p>\r\n        \r\n        <p>\r\n            <a href=\\"<?=SP_CONTACT_LINK?>\\" target=\\"_blank\\">Contacter l\\''équipe Seo Panel</a>\r\n        </p>\r\n        \r\n        <p>\r\n            <a href=\\"<?=SP_HELP_LINK?>\\" target=\\"_blank\\">Guide Seo Panel</a>\r\n        </p>\r\n        \r\n        <p>\r\n            <a href=\\"<?=SP_FORUM_LINK?>\\" target=\\"_blank\\">Forum Seo Panel</a>\r\n        </p>\r\n        \r\n        <p>\r\n            <a href=\\"<?=SP_SUPPORT_LINK?>\\" target=\\"_blank\\">Support Seo Panel</a>\r\n        </p>\r\n        \r\n        <p>\r\n            <a href=\\"<?=SP_DONATE_LINK?>\\" target=\\"_blank\\">Faites un don pour Seo Panel</a>\r\n        </p>\r\n    </li>\r\n    \r\n</ul>\r\n</fieldset>', '2011-07-10 10:26:55'),
(699, 'fr', 'home', 'Pages Indexed', 'Pages indexées', '2011-07-10 10:26:55'),
(700, 'fr', 'home', 'Ranks', 'Rangs', '2011-07-10 10:26:55'),
(701, 'fr', 'home', 'SiteNameUrl', 'Nom du site / URL', '2011-07-10 10:26:55'),
(702, 'fr', 'home', 'Website Statistics', 'Statistiques de vos sites', '2011-07-10 10:26:55'),
(703, 'fr', 'directory', 'Add back to directory list', 'Remettre dans la liste des annuaires', '2012-11-10 20:37:55'),
(704, 'fr', 'directory', 'Approved', 'Approuvé', '2012-11-10 20:37:55'),
(705, 'fr', 'directory', 'Captcha', 'Captcha', '2012-11-10 20:37:55'),
(706, 'fr', 'directory', 'categorynote', 'Catégories, à séparer par des virgules, dans l\\''ordre de priorité. Débuter par la catégorie ayant la priorité la plus haute.', '2012-11-10 20:37:55'),
(707, 'fr', 'directory', 'Check Directory Status', 'Vérifier le statut de l\\''annuaire', '2012-11-10 20:37:55'),
(708, 'fr', 'directory', 'Check Directory Submission Status', 'Vérifier le statut de l\\''envoi', '2012-11-10 20:37:55'),
(709, 'fr', 'directory', 'clicktoproceeddirsts', 'Cliquer sur <b>Valider</b> pour vérifier le statut de l\\''annuaire.', '2012-11-10 20:37:55'),
(710, 'fr', 'directory', 'Confirmation', 'Confirmation', '2012-11-10 20:37:55'),
(711, 'fr', 'directory', 'desnote', 'Certains annuaires requiert un minimum de 150 caractères pour la description.', '2012-11-10 20:37:55'),
(712, 'fr', 'directory', 'Directories with out captcha', 'Annuaires sans captcha', '2012-11-10 20:37:55'),
(713, 'fr', 'directory', 'Directory Submission Reports', 'Rapports d\\''envois aux annuaires', '2012-11-10 20:37:55'),
(714, 'fr', 'directory', 'Enter the code shown', 'Veuillez saisir le code indiqué', '2012-11-10 20:37:55'),
(715, 'fr', 'directory', 'nocatnote', 'Catégorie d\\''envoi non trouvée dans la page d\\''envoi. Veuillez cliquer sur <b>Recharger</a> ou <b>Passer</b>', '2012-11-10 20:37:55'),
(716, 'fr', 'directory', 'nodirnote', 'Aucun annuaire <b>actif</b>', '2012-11-10 20:37:55'),
(717, 'fr', 'directory', 'nosuccessnote', 'Aucune confirmation n\\''a été reçue, veuillez vérifier vos mails', '2012-11-10 20:37:55'),
(718, 'fr', 'directory', 'optionalnote', 'Titres et descriptions optionnels à soumettre aléatoirement aux annuaires pour de meilleurs résultats.', '2012-11-10 20:37:55'),
(719, 'fr', 'directory', 'Owner Email', 'Mail du propriétaire', '2012-11-10 20:37:55'),
(720, 'fr', 'directory', 'Owner Name', 'Nom du propriétaire', '2012-11-10 20:37:55'),
(721, 'fr', 'directory', 'Pending', 'En attente', '2012-11-10 20:37:55'),
(722, 'fr', 'directory', 'Please select a website to proceed', 'Veuillez sélectionner un site', '2012-11-10 20:37:55'),
(723, 'fr', 'directory', 'selectwebsiteproceed', 'Sélectionner un <b>site</b> à envoyer à l\\''annuaire. <br>Cocher l\\''option <b>Annuaires sans captcha</b> pour envoyer aux annuaires sans confirmation humaine.', '2012-11-10 20:37:55'),
(724, 'fr', 'directory', 'selectwebsiteschecksub', 'Sélectionner un <b>site</b> à envoyer à l\\''annuaire.', '2012-11-10 20:37:55'),
(725, 'fr', 'directory', 'Semi Automatic Directory Submission Tool', 'Outil de soumission semi automatique', '2012-11-10 20:37:55'),
(726, 'fr', 'directory', 'spamemailnote', 'Certains annuaires envoient des courriers indésirables, nous vous déconseillons d\\''utiliser votre adresse mail principale.', '2012-11-10 20:37:55'),
(727, 'fr', 'directory', 'Submission Details', 'Détails de l\\''envoi', '2012-11-10 20:37:55'),
(728, 'fr', 'directory', 'Submit Description', 'Description', '2012-11-10 20:37:55'),
(729, 'fr', 'directory', 'Submit Keywords', 'Mots-clés', '2012-11-10 20:37:55'),
(730, 'fr', 'directory', 'Submit Title', 'Titre', '2012-11-10 20:37:55'),
(731, 'fr', 'directory', 'Website Category', 'Catégorie', '2012-11-10 20:37:55'),
(732, 'fr', 'directory', 'Website Url', 'URL du site', '2012-11-10 20:37:55'),
(733, 'fr', 'keyword', 'Crawling keyword', 'Mot clé exploré', '2016-01-02 18:07:27'),
(734, 'fr', 'keyword', 'Detailed Keyword Position Reports', 'Rapports détaillés de position sur mot-clé', '2016-01-02 18:07:27'),
(735, 'fr', 'keyword', 'Edit Keyword', 'Editer le mot-clé', '2016-01-02 18:07:27'),
(736, 'fr', 'keyword', 'Graphical Keyword Position Reports', 'Rapport graphique de position sur mot-clé', '2016-01-02 18:07:27'),
(737, 'fr', 'keyword', 'Import Keywords', 'Importer les mots-clés', '2016-01-02 18:07:27'),
(738, 'fr', 'keyword', 'Keyword already exist', 'Le mot-clé existe déjà', '2016-01-02 18:07:27'),
(739, 'fr', 'keyword', 'Keyword Position Report', 'Rapport de position sur mot-clé', '2016-01-02 18:07:27'),
(740, 'fr', 'keyword', 'New Keyword', 'Nouveau mot-clé', '2016-01-02 18:07:27'),
(741, 'fr', 'keyword', 'not assigned to required search engines', 'non assigné aux moteurs de recherches requis', '2016-01-02 18:07:27'),
(742, 'fr', 'keyword', 'pleaseselecttool', 'Merci de sélectionner au moins un outil Seo', '2016-01-02 18:07:27'),
(743, 'fr', 'keyword', 'Quick Keyword Position Checker', 'Contrôle rapide de position sur mot-clé', '2016-01-02 18:07:27'),
(744, 'fr', 'keyword', 'results from ', 'résultats de', '2016-01-02 18:07:27'),
(745, 'fr', 'keyword', 'Show All results', 'Afficher tous les résultats', '2016-01-02 18:07:27'),
(746, 'fr', 'keyword', 'Successfully crawled keyword', 'Exploration réussie du mot-clé', '2016-01-02 18:07:27'),
(747, 'fr', 'keyword', 'to create new keywords', 'pour créer de nouveaux mots-clés', '2016-01-02 18:07:27'),
(748, 'fr', 'proxy', 'Edit Proxy', 'Editer le proxy', '2016-12-09 18:07:31'),
(749, 'fr', 'proxy', 'Proxy Password', 'Mot de passe', '2016-12-09 18:07:31'),
(750, 'fr', 'proxy', 'Proxy Username', 'Nom d''utilisateur', '2016-12-09 18:07:31'),
(751, 'fr', 'proxy', 'Proxyalreadyexist', 'Le proxy existe déjà !', '2016-12-09 18:07:31'),
(752, 'fr', 'rank', 'enterurlproceed', 'Indiquez <b>une URL par ligne</b>. Cliquer sur <b>Valider</b> pour vérifier les rangs Google et Alexa.', '2010-09-28 09:16:21'),
(753, 'fr', 'rank', 'Google and Alexa Rank Reports', 'Rapport de rangs Google et Alexa', '2010-09-28 09:16:21'),
(754, 'fr', 'rank', 'Saved rank results of', 'Résultats sauvegardés', '2010-09-28 09:16:21'),
(755, 'fr', 'saturation', 'clickproceedsaturation', 'Indiquez <b>une URL par ligne</b>. Cliquez sur <b>valider</b> pour vérifier les résultats de saturation des moteurs de recherche.', '2010-09-28 09:18:11'),
(756, 'fr', 'saturation', 'GenerateSaturationReports', 'Générer les rapports de saturation de moteur de recherche', '2010-09-28 09:18:11'),
(757, 'fr', 'saturation', 'Quick Search Engine Saturation Checker', 'Contrôle rapide de saturation des moteurs de recherche', '2010-09-28 09:18:11'),
(758, 'fr', 'saturation', 'Saved Search Engine Saturation results of', 'Résultats sauvegardés', '2010-09-28 09:18:11'),
(759, 'fr', 'saturation', 'Search Engine Saturation Reports', 'Rapports de saturation des moteurs de recherche', '2010-09-28 09:18:11'),
(760, 'fr', 'seotools', 'Automatic Submission', 'Soumission automatisée', '2011-07-10 10:50:35'),
(761, 'fr', 'seotools', 'backlink-checker', 'Contrôle des liens retour', '2011-07-10 10:50:35'),
(762, 'fr', 'seotools', 'Backlinks Reports', 'Rapports sur les liens retour', '2011-07-10 10:50:35'),
(763, 'fr', 'seotools', 'Check Submission Status', 'Vérifier le statut de la soumission', '2011-07-10 10:50:35'),
(764, 'fr', 'seotools', 'clickgeneratereports', 'Cliquer sur <b>Valider</b> pour générer les rapports', '2011-07-10 10:50:35'),
(765, 'fr', 'seotools', 'Detailed Position Reports', 'Rapports détaillés de position', '2011-07-10 10:50:35'),
(766, 'fr', 'seotools', 'directory-submission', 'Soumission annuaire', '2011-07-10 10:50:35'),
(767, 'fr', 'seotools', 'Featured Submission', 'Soumission active', '2011-07-10 10:50:35'),
(768, 'fr', 'seotools', 'Generate Backlinks Reports', 'Générer les rapports de liens retour', '2011-07-10 10:50:35'),
(769, 'fr', 'seotools', 'Generate Keyword Reports', 'Générer les rapports sur le mot-clé', '2011-07-10 10:50:35'),
(770, 'fr', 'seotools', 'Generate Rank Reports', 'Générer les rapports de rangs', '2011-07-10 10:50:35'),
(771, 'fr', 'seotools', 'Generate Saturation Reports', 'Générer les rapports de saturation', '2011-07-10 10:50:35'),
(772, 'fr', 'seotools', 'Google Sitemap Generator', 'Générateur de sitemap Google', '2011-07-10 10:50:35'),
(773, 'fr', 'seotools', 'Graphical Position Reports', 'Rapports graphiques de position', '2011-07-10 10:50:35');
INSERT INTO `texts` (`id`, `lang_code`, `category`, `label`, `content`, `changed`) VALUES
(774, 'fr', 'seotools', 'Keyword Position Summary', 'Résumé de position sur mot-clé', '2011-07-10 10:50:35'),
(775, 'fr', 'seotools', 'keyword-position-checker', 'Contrôle de position sur mot-clé', '2011-07-10 10:50:35'),
(776, 'fr', 'seotools', 'Keywords Manager', 'Gestionnaire de mots-clés', '2011-07-10 10:50:35'),
(777, 'fr', 'seotools', 'Quick Backlinks Checker', 'Contrôle rapide des liens retour', '2011-07-10 10:50:35'),
(778, 'fr', 'seotools', 'Quick Position Checker', 'Contrôle rapide de position', '2011-07-10 10:50:35'),
(779, 'fr', 'seotools', 'Quick Rank Checker', 'Contrôle rapide de rang', '2011-07-10 10:50:35'),
(780, 'fr', 'seotools', 'Quick Saturation Checker', 'Contrôle rapide de saturation', '2011-07-10 10:50:35'),
(781, 'fr', 'seotools', 'Rank Reports', 'Rapports de rang', '2011-07-10 10:50:35'),
(782, 'fr', 'seotools', 'rank-checker', 'Contrôle de rang', '2011-07-10 10:50:35'),
(783, 'fr', 'seotools', 'Saturation Reports', 'Rapports de saturation', '2011-07-10 10:50:35'),
(784, 'fr', 'seotools', 'saturation-checker', 'Saturation de moteur de recherche', '2011-07-10 10:50:35'),
(785, 'fr', 'seotools', 'sitemap-generator', 'Générateur de Sitemap', '2011-07-10 10:50:35'),
(786, 'fr', 'seotools', 'Skipped Directories', 'Annuaires non traités', '2011-07-10 10:50:35'),
(787, 'fr', 'seotools', 'Submission Reports', 'Rapports de soumission', '2011-07-10 10:50:35'),
(788, 'fr', 'seotools', 'User Access', 'Accès utilisateur', '2011-07-10 10:50:35'),
(789, 'fr', 'support', 'support_cont1', '<fieldset>\r\n<legend>Support Seo Panel</legend>\r\n<ul class=\\"infobox\\">\r\n    <li>\r\n        <h1>Pack de 1000 annuaires</h1> \r\n        <p>\r\n            Nous pouvons vous fournir un pack de <b>1000 annuaires gratuits, actifs et vérifiés</b>, à ajouter à votre Seo Panel.\r\n            Cela vous aidera à <b>augmenter les liens retour</b> vers vos sites.<br/>\r\n            Ce pack a été créé pour <b>financer les prochains dévelopements</b> de Seo Panel.<br/>\r\n            Pour obtenir le pack, merci de <a href=\\"<?=SP_DONATE_LINK?>\\" target=\\"_blank\\">donner</a> 10$ ou plus, pour aider à améliorer Seo Panel.<br>\r\n            Si vous avez des questions sur ce pack de 1000 annuaires, n\\''hésitez pas à <a href=\\"<?=SP_CONTACT_LINK?>\\" target=\\"_blank\\">nous contacter</a> ou à <a href=\\"<?=SP_SUPPORT_LINK?>\\" target=\\"_blank\\">ouvrir un ticket</a>.\r\n        </p>        \r\n        <p>\r\n            <a href=\\"<?=SP_DONATE_LINK?>\\" target=\\"_blank\\">Cliquer ici pour aider à financer Seo Panel.</a>\r\n        </p>\r\n        <br>\r\n    </li>\r\n    \r\n    <li>\r\n        <h1>Pack de moteurs de recherche locaux</h1> \r\n        <p>\r\n            Ajoutez les moteurs de recherche locaux de Google, Yahoo, MSN (<b>ex: www.google.fr, www.yahoo.fr, ...</b>) au <b>contrôle de position sur mot-clé</b>, pour suivre le référencement local de vos sites.<br/>\r\n            Pour obtenir le pack de moteurs de recherche locaux (en fonction de vos besoins), merci de <a href=\\"<?=SP_DONATE_LINK?>\\" target=\\"_blank\\">donner</a> 10$ ou plus pour aider à améliorer Seo Panel.<br/>\r\n            Avant de faire le don, merci de <a href=\\"<?=SP_CONTACT_LINK?>\\" target=\\"_blank\\">nous contacter</a> afin de nous communiquer la liste des moteurs de recherche souhaités.<br><br>\r\n            Si vous souhaitez ajouter de <b>nouveaux moteurs de recherches</b> à votre suivi de position sur mot-clé Seo Panel, merci de <a href=\\"<?=SP_CONTACT_LINK?>\\" target=\\"_blank\\">nous contacter</a> ou d\\''<a href=\\"<?=SP_SUPPORT_LINK?>\\" target=\\"_blank\\">ouvrir un ticket</a>.\r\n        </p>        \r\n        <p class=\\"visit\\">\r\n            <a href=\\"<?=SP_CONTACT_LINK?>\\" target=\\"_blank\\">Cliquer ici pour nous contacter.</a>\r\n        </p>\r\n        <br>\r\n    </li>\r\n    \r\n    <li>\r\n        <h1>Plugins Seo Panel</h1> \r\n        <p>\r\n           Ajouter des <b>plugins</b> à votre Seo Panel, afin d\\''ajouter de <b>nouvelles fonctionnalités</b>, selon vos besoins.<br/>\r\n           Les <a href=\\"<?=SP_PLUGINSITE?>\\" target=\\"_blank\\">plugins Seo Panel</a> sont disponibles via Seo Panel, ou des tiers.<br/>\r\n           Vous pouvez facilement <b>développer</b> des plugins pour votre Seo Panel, et <a href=\\"<?=SP_PLUGINSITE?>\\" target=\\"_blank\\">soumettre vos plugins</a> sur le site Seo Panel, où ils seront publiés après <b>validation</b>. \r\n        </p>        \r\n        <p>\r\n            <a href=\\"<?=SP_PLUGINSITE?>\\" target=\\"_blank\\">Cliquer ici pour obtenir les plugins disponibles.</a>\r\n        </p>\r\n        <br>\r\n    </li>    \r\n    <li>\r\n        <h1>Nous contacter</h1> \r\n        <p>\r\n            N\\''hésitez pas à nous contacter à propos des <b>outils, plugins et fonctionnalités de Seo Panel</b> en utilisant le lien ci-dessous.\r\n        </p>        \r\n        <p>\r\n            <a href=\\"<?=SP_CONTACT_LINK?>\\" target=\\"_blank\\">Cliquer ici pour nous contacter.</a>\r\n        </p>\r\n        <br>\r\n    </li>    \r\n    <li>\r\n        <h1>Tickets de Support</h1> \r\n        <p>\r\n            Pour obtenir un <b>support technique</b> de l\\''équipe Seo Panel sur l\\''<b>installation de Seo Panel, des outils ou des plugins</b>. Ex.: Configurer l\\''exécution périodique (cron) du contrôle de position sur mot-clé, résoudre un dysfonctionnement post-installation, ...\r\n        </p>        \r\n        <p>\r\n            <a href=\\"<?=SP_SUPPORT_LINK?>\\" target=\\"_blank\\">Cliquer ici pour ouvrir un ticket de support technique.</a>\r\n        </p>\r\n        <br>\r\n    </li>    \r\n    <li>\r\n        <h1>Signaler un bug</h1> \r\n        <p>\r\n            Signalez les <b>bugs</b> de <b>Seo Panel, des outils ou des plugins</b> en utilisant le lien ci-dessous.<br/>\r\n            Cela nous aidera à améliorer les prochaines versions.\r\n        </p>        \r\n        <p>\r\n            <a href=\\"<?=SP_SUPPORT_LINK?>\\" target=\\"_blank\\">Cliquer ici pour signaler un bug.</a>\r\n        </p>\r\n        <br>\r\n    </li>    \r\n</ul>\r\n</fieldset>', '2010-09-28 10:36:44'),
(790, 'fr', 'support', 'support_cont2', '<fieldset>\r\n<legend>Seo Panel - Ressources en ligne</legend>\r\n<ul class=\\"infobox\\">\r\n        \r\n    <li>\r\n        <h1>L\\''aide Seo Panel</h1> \r\n        <p>\r\n            Vous pouvez consulter la <a href=\\"<?=SP_HELP_LINK?>\\" target=\\"_blank\\">documentation</a> pour Seo Panel, ses fonctionnalités, ainsi que les outils et plugins.\r\n            <br>C\\''est le meilleur endroit pour <b>avoir de l\\''aide</b> sur Seo Panel. Nous espérons que vous pourrez <b>contribuer</b> au guide Seo Panel, si vous trouvez des erreurs ou des choses qui manquent.\r\n        </p>\r\n        <p>\r\n            <a href=\\"<?=SP_HELP_LINK?>\\" target=\\"_blank\\">Cliquer ici pour voir l\\''aide Seo Panel.</a>\r\n        </p>\r\n        <br>\r\n    </li>    \r\n    <li>\r\n        <h1>Le forum Seo Panel</h1> \r\n        <p>\r\n            Un endroit où discuter du <b>premier panneau de contrôle Seo en open source au monde</b>.<br>C\\''est le meilleur endroit pour trouver des <b>réponses</b> à <b>vos questions</b> à propos de Seo Panel.<br>Vous pouvez aussi y <b>partager vos expériences</b> afin d\\''optimiser le référencement de vos sites internet.\r\n        </p>        \r\n        <p>\r\n            <a href=\\"<?=SP_FORUM_LINK?>\\" target=\\"_blank\\">Cliquer ici pour aller sur le forum Seo Panel</a>\r\n        </p>\r\n        <br>\r\n    </li>\r\n</ul>    \r\n</fieldset>', '2010-09-28 10:36:44'),
(791, 'fr', 'support', 'support_cont3', '<fieldset>\r\n<legend>Dons pour Seo Panel</legend>\r\n<ul class=\\"infobox\\">        \r\n    <li>\r\n        <h1>Donnez pour Seo Panel - Le premier panneau de contr&ocirc;le open source Seo au monde</h1> \r\n        <p>\r\n            <b>Donnez</b> &agrave; Seo Panel pour financer le premier panneau de contr&ocirc;le open source Seo au monde.<br/>\r\n            Nous pr&eacute;voyons bien sur des <b>ajouts et am&eacute;liorations</b> des fonctionnalit&eacute;s de Seo Panel, et gr&acirc;ce &agrave; votre support, nous pourrons atteindre les <b>buts fix&eacute;s</b>.\r\n            Si <b>vous appr&eacute;ciez Seo Panel</b>, merci de <b>faire un don</b> &agrave; l\\''&eacute;quipe Seo Panel afin d\\''aider &agrave; financer son d&eacute;veloppement.<br/>\r\n            D&egrave;s r&eacute;ception de votre don, nous publierons, avec votre accord, votre nom et votre site sur la <a href=\\"<?=SP_DONATE_LINK?>\\" target=\\"_blank\\">page de dons</a>.\r\n            \r\n            \r\n        </p>\r\n        <p>\r\n            <a href=\\"<?=SP_DONATE_LINK?>\\" target=\\"_blank\\">Cliquer ici pour faire un don</a>\r\n        </p>\r\n        <br>\r\n    </li>\r\n</ul>\r\n</fieldset>', '2010-09-28 10:36:44'),
(792, 'es', 'common', 'Keywords', 'Palabras clave', '2012-11-12 20:17:40'),
(793, 'es', 'keyword', 'Import Keywords', 'Importación de palabras clave.', '2011-07-07 10:24:15'),
(794, 'es', 'keyword', 'to create new keywords', 'para crear nuevas palabras clave', '2011-07-07 10:24:15'),
(795, 'es', 'label', 'already exist', 'ya existen', '2012-05-12 10:54:10'),
(796, 'es', 'label', 'Click Here', 'Haga clic aquí', '2012-05-12 10:54:10'),
(797, 'es', 'label', 'Developers', 'Desarrolladores', '2012-05-12 10:54:10'),
(798, 'es', 'label', 'Sponsors', 'Patrocinadores', '2012-05-12 10:54:10'),
(799, 'es', 'label', 'Translators', 'Traductores', '2012-05-12 10:54:10'),
(800, 'es', 'panel', 'About Us', 'Quiénes somos', '2012-05-12 10:55:03'),
(801, 'es', 'settings', 'Click here to become a sponsor for Seo Panel', '<b>Realiza una donación de 100 usd</b> y conviértete en un <b>sponsor</b> de Seo Panel.', '2012-05-12 11:03:05'),
(802, 'es', 'settings', 'SP_DEFAULTLANG', 'Idioma por defecto', '2012-05-12 11:03:05'),
(803, 'de', 'button', 'Cancel', 'Abbrechen', '2014-01-08 19:19:28'),
(804, 'de', 'button', 'Check Status', 'Status pruefen', '2014-01-08 19:19:28'),
(805, 'de', 'button', 'Proceed', 'Speichern', '2014-01-08 19:19:28'),
(806, 'de', 'button', 'Reload', 'Neu laden', '2014-01-08 19:19:28'),
(807, 'de', 'button', 'Show Details', 'Details zeigen', '2014-01-08 19:19:28'),
(808, 'de', 'button', 'Show Records', 'Aufzeichnungen anzeigen', '2014-01-08 19:19:28'),
(809, 'de', 'button', 'Skip', 'Ueberspringen', '2014-01-08 19:19:28'),
(810, 'de', 'button', 'Submit', 'Uebermitteln', '2014-01-08 19:19:28'),
(811, 'de', 'common', 'Action', 'Aktion', '2016-01-02 23:21:04'),
(812, 'de', 'common', 'Activate', 'Aktivieren', '2016-01-02 23:21:04'),
(813, 'de', 'common', 'Admin Panel', 'Admin Bereich', '2016-01-02 23:21:04'),
(814, 'de', 'common', 'Alexa Rank', 'Alexa Rank', '2016-01-02 23:21:04'),
(815, 'de', 'common', 'All', 'Alle', '2016-01-02 23:21:04'),
(816, 'de', 'common', 'Category', 'Kategorie', '2016-01-02 23:21:04'),
(817, 'de', 'common', 'contact', 'Kontakt', '2016-01-02 23:21:04'),
(818, 'de', 'common', 'copyright', 'Copyright © [year] www.seopanel.in Alle Rechte vorbehalten', '2016-01-02 23:21:04'),
(819, 'de', 'common', 'Country', 'Land', '2016-01-02 23:21:04'),
(820, 'de', 'common', 'Crawl Meta Data', 'Meta Daten abrufen', '2016-01-02 23:21:04'),
(821, 'de', 'common', 'Details', 'Details', '2016-01-02 23:21:04'),
(822, 'de', 'common', 'Directory', 'Verzeichnis', '2016-01-02 23:21:04'),
(823, 'de', 'common', 'Donate', 'Spenden', '2016-01-02 23:21:04'),
(824, 'de', 'common', 'Entry cannot be blank', 'Eintrag kann nicht leer gelassen werden', '2016-01-02 23:21:04'),
(825, 'de', 'common', 'entrynotvalid', 'Das Eingetragene scheint nicht zu stimmen', '2016-01-02 23:21:04'),
(826, 'de', 'common', 'failed', 'fehlgeschlagen', '2016-01-02 23:21:04'),
(827, 'de', 'common', 'forum', 'Forum', '2016-01-02 23:21:04'),
(828, 'de', 'common', 'Found', 'gefunden', '2016-01-02 23:21:04'),
(829, 'de', 'common', 'Google Pagerank', 'Google Pagerank', '2016-01-02 23:21:04'),
(830, 'de', 'common', 'help', 'Hilfe', '2016-01-02 23:21:04'),
(831, 'de', 'common', 'hidenews', 'SEO Panel News verbergen', '2016-01-02 23:21:04'),
(832, 'de', 'common', 'Id', 'Id', '2016-01-02 23:21:04'),
(833, 'de', 'common', 'Inactivate', 'Deaktiviert', '2016-01-02 23:21:04'),
(834, 'de', 'common', 'Inactive', 'Inaktiv', '2016-01-02 23:21:04'),
(835, 'de', 'common', 'Invalid characters', 'ungueltige Zeichen', '2016-01-02 23:21:04'),
(836, 'de', 'common', 'Invalid code entered', 'ungueltigen Code angegeben', '2016-01-02 23:21:04'),
(837, 'de', 'common', 'Invalid email address entered', 'ungueltige Mailadresse angegeben', '2016-01-02 23:21:04'),
(838, 'de', 'common', 'Invalid value', 'ungueltiger Wert', '2016-01-02 23:21:04'),
(839, 'de', 'common', 'Keyword', 'Keyword', '2016-01-02 23:21:04'),
(840, 'de', 'common', 'Keywords', 'Keywords', '2016-01-02 23:21:04'),
(841, 'de', 'common', 'My Account', 'Mein Account', '2016-01-02 23:21:04'),
(842, 'de', 'common', 'Name', 'Name', '2016-01-02 23:21:04'),
(843, 'de', 'common', 'No Keywords Found', 'Keine Keywords gefunden', '2016-01-02 23:21:04'),
(844, 'de', 'common', 'No Records Found', 'Keine Aufzeichnungen gefunden', '2016-01-02 23:21:04'),
(845, 'de', 'common', 'noactivetools', 'Keine aktiven SEO Tools gefunden!', '2016-01-02 23:21:04'),
(846, 'de', 'common', 'nowebsites', 'Keine Webseiten gefunden', '2016-01-02 23:21:04'),
(847, 'de', 'common', 'password632', 'Das Passwort sollte aus 6-32 Zeichen bestehen', '2016-01-02 23:21:04'),
(848, 'de', 'common', 'passwordnotmatch', 'Die Passwoerter stimmen nicht ueberein', '2016-01-02 23:21:04'),
(849, 'de', 'common', 'Period', 'Periode', '2016-01-02 23:21:04'),
(850, 'de', 'common', 'Priority', 'Prioritaet', '2016-01-02 23:21:04'),
(851, 'de', 'common', 'Reports', 'Berichte', '2016-01-02 23:21:04'),
(852, 'de', 'common', 'Results', 'Ergebnisse', '2016-01-02 23:21:04'),
(853, 'de', 'common', 'Search Engine', 'Suchmaschine', '2016-01-02 23:21:04'),
(854, 'de', 'common', 'Seo Plugins', 'SEO Erweiterungen', '2016-01-02 23:21:04'),
(855, 'de', 'common', 'Seo Tools', 'SEO Werkzeuge', '2016-01-02 23:21:04'),
(856, 'de', 'common', 'Sign out', 'Ausloggen', '2016-01-02 23:21:04'),
(857, 'de', 'common', 'Sign Up', 'Registrieren', '2016-01-02 23:21:04'),
(858, 'de', 'common', 'signin', 'Einloggen', '2016-01-02 23:21:04'),
(859, 'de', 'common', 'Status', 'Status', '2016-01-02 23:21:04'),
(860, 'de', 'common', 'Support', 'Hilfe', '2016-01-02 23:21:04'),
(861, 'de', 'common', 'Url', 'URL', '2016-01-02 23:21:04'),
(862, 'de', 'common', 'User', 'Benutzer', '2016-01-02 23:21:04'),
(863, 'de', 'common', 'User Panel', 'Benutzer Bereich', '2016-01-02 23:21:04'),
(864, 'de', 'common', 'Website', 'Webseite', '2016-01-02 23:21:04'),
(865, 'de', 'directory', 'Add back to directory list', 'Zur Verzeichnis Liste hinzufuegen', '2014-01-19 11:37:36'),
(866, 'de', 'directory', 'Approved', 'Bestaetigt', '2014-01-19 11:37:36'),
(867, 'de', 'directory', 'Captcha', 'Captcha', '2014-01-19 11:37:36'),
(868, 'de', 'directory', 'categorynote', 'Kategorien, durch Komma getrennt. Sortiert nach Wichtigkeit.', '2014-01-19 11:37:36'),
(869, 'de', 'directory', 'Check Directory Status', 'Verzeichnis Status ueberpruefen', '2014-01-19 11:37:36'),
(870, 'de', 'directory', 'Check Directory Submission Status', 'Verzeichnis Eintragungs Status ueberpruefen', '2014-01-19 11:37:36'),
(871, 'de', 'directory', 'clicktoproceeddirsts', 'Auf <b>Starten</b> klicken um Verzeichnis Status zu ueberpruefen.', '2014-01-19 11:37:36'),
(872, 'de', 'directory', 'Confirmation', 'Bestaetigung', '2014-01-19 11:37:36'),
(873, 'de', 'directory', 'desnote', 'Einige Verzeichnisse verlangen mindestens 150 Zeichen als Beschreibung', '2014-01-19 11:37:36'),
(874, 'de', 'directory', 'Directories with out captcha', 'Verzeichnisse ohne Captcha Abfrage', '2014-01-19 11:37:36'),
(875, 'de', 'directory', 'Directory Submission Reports', 'Verzeichnis Eintragungs Berichte', '2014-01-19 11:37:36'),
(876, 'de', 'directory', 'Enter the code shown', 'Gib den angezeigten Code ein', '2014-01-19 11:37:36'),
(877, 'de', 'directory', 'nocatnote', 'Die gewuenschte Kategorie exestiert nicht in diesem Verzeichnis. Klick <b>Neu laden</b> oder <b>Ueberspringen</b>  	 ', '2014-01-19 11:37:36'),
(878, 'de', 'directory', 'nodirnote', 'Keine <b>aktiven</b> Verzeichnisse gefunden', '2014-01-19 11:37:36'),
(879, 'de', 'directory', 'nosuccessnote', 'Keine Bestaetigung erhalten - Bitte im Email Postfach nach der Bestaetigungsmail schauen.', '2014-01-19 11:37:36'),
(880, 'de', 'directory', 'optionalnote', 'Optional verschiedene Beschreibungen und Titel angeben um bessere Ergebnisse zu erhalten.', '2014-01-19 11:37:36'),
(881, 'de', 'directory', 'Owner Email', 'Besitzer Email', '2014-01-19 11:37:36'),
(882, 'de', 'directory', 'Owner Name', 'Besitzer Name', '2014-01-19 11:37:36'),
(883, 'de', 'directory', 'Pending', 'Wartend..', '2014-01-19 11:37:36'),
(884, 'de', 'directory', 'Please select a website to proceed', 'Bitte Webseite auswaehlen um fortzufahren', '2014-01-19 11:37:36'),
(885, 'de', 'directory', 'selectwebsiteproceed', 'Waehle eine <b>Webseite</b> und <b>Starte</b> die Verzeichnis Eintragung.<br>Setze einen Haken bei <b>Verzeichnisse ohne Captcha Abfrage</b> um Verzeichnisse mit Captcha Abfrage zu ueberspringen.', '2014-01-19 11:37:36'),
(886, 'de', 'directory', 'selectwebsiteschecksub', 'Waehle eine <b>Webseite</b> und <b>Starte</b> die Verzeichnis Eintragungs Ueberpruefung.', '2014-01-19 11:37:36'),
(887, 'de', 'directory', 'Semi Automatic Directory Submission Tool', 'Semi Automatisches Verzeichnis Eintragungs Tool', '2014-01-19 11:37:36'),
(888, 'de', 'directory', 'spamemailnote', 'Einige Verzeichnisse versenden SPAM, wir empfehelen nicht die echte Mailadresse anzugeben.', '2014-01-19 11:37:36'),
(889, 'de', 'directory', 'Submission Details', 'Eintragungs Details', '2014-01-19 11:37:36'),
(890, 'de', 'directory', 'Submit Description', 'Beschreibung uebertragen', '2014-01-19 11:37:36'),
(891, 'de', 'directory', 'Submit Keywords', 'Keywords uebertragen', '2014-01-19 11:37:36'),
(892, 'de', 'directory', 'Submit Title', 'Title uebertragen', '2014-01-19 11:37:36'),
(893, 'de', 'directory', 'Website Category', 'Webseiten Kategorie', '2014-01-19 11:37:36'),
(894, 'de', 'directory', 'Website Url', 'Webseiten URL', '2014-01-19 11:37:36'),
(895, 'de', 'home', 'Account Summary', 'Account Zusammenfassung', '2011-07-07 19:09:22'),
(896, 'de', 'home', 'Backlinks', 'Backlinks', '2011-07-07 19:09:22'),
(897, 'de', 'home', 'Directory Submission', 'Verzeichnis Eintragung', '2011-07-07 19:09:22'),
(898, 'de', 'home', 'home_cont1', '<h1 style=\\"text-align: center;margin-bottom: 30px;font-size: 19px;\\">Willkommen im SEO Panel - Das weltweit erste SEO Kontroll Panel fuer multiple Webseiten</h1>\r\n        <p>\r\n            Ein komplettes <b>Open Source SEO Panel</b> zur <b>Suchmaschinenoptimierung</b> deiner Webseiten.\r\n            Das SEO Panel ist ein <b>SEO Tool Kit</b> mit den wichtigsten Funktionen um die <b>Suchmaschinenoptimierung</b> deiner Eebseiten zu\r\n<b>beobachten und verbessern</b>.\r\n            Es handelt sich um <b>kostenlose Software</b> erschienen unter der <b>GNU GENERAL PUBLIC LICENSE</b>.\r\n            Die Hauptfunktion von SEO Panel ist die <b>Erweiterungsfaehigkeit</b> durch das Nutzen von <a href=\\"<?=SP_PLUGINSITE?>\\"\r\ntarget=\\"_blank\\">SEO Erweiterungen</a>.\r\n            Jeder kann ganz einfach weitere Erweiterungen fuer das SEO Panel <b>entwickeln und installieren</b>. \r\n        </p>\r\n        <p></p>\r\n        <p>\r\n            Diese Open Source Software wurde <b>im Januar 2010 veroeffentlicht</b>.\r\n            In diesem <b>kurzen Zeitraum</b> haben sich bereits <b>Tausende</b> von <b>Webmastern</b> gefunden, die diese Software nutzen um Ihre Webseiten zu <b>optimieren</b>.\r\n            Beginne noch heute, das SEO Panel zu nutzen und <b>geniesse</b> die Vorteile, alles SEO-technische in einer <b>einzigen Platform</b> wiederzufinden.\r\n        </p>', '2011-07-07 19:09:22'),
(899, 'de', 'home', 'home_cont2', '<fieldset>\r\n<legend>Hauptfunktionen des SEO Panel <?=SP_INSTALLED?></legend>\r\n<ul class=\\"infobox\\">\r\n    <li>        \r\n        <h1>Automatisches Webkatalog Eintragungs Tool</h1>\r\n		<p>\r\n			Das automatische Webverzeichnis Eintragungs Tool ermoeglicht <b>die Eintragung</b> in die wichtigsten <b>kostenlosen und kostenpflichtigen Webkataloge</b>.\r\n			Ausserdem kann der <b>Status jeder Eintragung periodisch ueberprueft werden</b> mithilfe des <b>Status Checker Skripts</b>.\r\n			Der <b>Directory manager</b> ermoeglicht herauszufinden welches <b>Verzeichnis aktiv ist</b> und welches nicht.\r\n		</p>\r\n    </li>\r\n    <li>        \r\n        <h1>Keyword Positions Checker</h1>\r\n		<p>\r\n			Der Keyword Positions Checker findet die <b>Suchmaschinenposition</b> von <b>bestimmten keywords</b> deiner Webseite und <b>speichert</b> diese im System.\r\n			So kann man im Report Bereich das <b>taegliche Ranking</b> von keywords in verschiedenen Suchmaschinen <b>grafisch</b> und <b>detailliert</b> darstellen.\r\n		</p>\r\n    </li>\r\n    <li>\r\n<h1>Website-Doktor</h1>\r\n        <p>Der Website-Doktor <b>prueft alle SEO Faktoren</b> aller Einzelseiten einer Webseite und generiert\r\n<b>detaillierte Berichte</b> fuer jede Seite. Das ist hilfreich um <b>XML,HTML,TEXT</b> Sitemaps zu generieren und an Suchmaschinen zu uebermitteln.</p>\r\n    </li>\r\n    <li>        \r\n        <h1>Google und Alexa Rank Checker</h1>\r\n		<p>\r\n			Der Google and Alexa Rank Checker zeigt den <b>Google Pagerank</b> und <b>Alexa Rank</b> deiner Webseiten und <b>speichert</b> diesen im System.\r\n			Im <b>Rank Berichte</b> Bereich lassen sich <b>taeglich</b> dafuer <b>detaillierte Berichte</b> erstellen.\r\n		</p>\r\n    </li>\r\n    <li>        \r\n        <h1>Backlink Checker</h1>\r\n		<p>\r\n			Der Backlink Checker findet die <b>Anzahl an Backlinks</b> deiner Webseite in diversen Suchmaschinen<b>(google,yahoo,msn etc)</b> und <b>speichert</b> sie im System.\r\n			<br>Im <b>Backlink Berichte</b> Bereich lassen sich <b>taeglich</b> fuer jede Webseite <b>detaillierte Berichte</b> erstellen.\r\n		</p>\r\n    </li>    \r\n    <li>        \r\n        <h1>Suchmaschinensichtbarkeits Checker</h1>\r\n		<p>\r\n			Der Suchmaschinensichtbarkeits Checker findet die <b>Anzahl der indizerten Seiten</b> deiner Webseiten in diversen Suchmaschinen<b>(google,yahoo,msn etc)</b> und <b>speichert</b> sie im System.\r\n			Im <b>Suchmaschinensichtbarkeits Berichte</b> Bereich lassen sich <b>taeglich</b> fuer jede Webseite <b>detaillierte Berichte</b> erstellen.\r\n		</p>\r\n    </li>\r\n    <li>        \r\n        <h1>SEO Panel Erweiterungen</h1>\r\n        <p>\r\n            Eine  <b>Hauptfunktion</b> des SEO Panel ist die <b>Erweiterungsfaehigkeit</b>.\r\n            Entwickle oder installiere <b>SEO Erweiterungen</b> in deinem eigenen SEO Panel um die <b>Funktionen zu erweitern</b>, dass Sie deine Anforderungen erfuellen.\r\n            <a href=\\"<?=SP_PLUGINSITE?>\\" target=\\"_blank\\">Seo Panel Erweiterungen</a> werden angeboten vom SEO Panel Team und von Dritten.\r\n            Du kannst auch einfach eigene SEO Erweiterungen fuer dein SEO Panel <b>entwickeln</b>.\r\n            Du kannst ausserdem deine SEO Erweiterung <a href=\\"<?=SP_PLUGINSITE?>\\" target=\\"_blank\\">an die Entwickler schicken</a> und es wird auf der SEO Panel Webseite <b>veroeffentlicht</b>, nachdem es <b>ueberprueft</b> wurde.\r\n        </p>\r\n    </li>\r\n    <li>        \r\n        <h1>Meta Tag Generator</h1>\r\n		<p>\r\n			Der Meta Tag Generator ist eine <b>Seo Panel Erweiterung</b> zum Erstellen von <b>Meta Tags</b> fuer deine Seite.\r\n			Es hilft uns <b>mehr Informationen</b> ueber Webseiten an die <b>Suchmaschinenrobots</b> zu uebermitteln.\r\n		</p>\r\n    </li>\r\n</ul>\r\n</fieldset>', '2011-07-07 19:09:22'),
(900, 'de', 'home', 'home_cont3', '<fieldset>\r\n<legend>SEO Panel Online Ressourcen</legend>    \r\n<ul class=\\"infobox\\">\r\n\r\n    <li>\r\n        <h1>SEO Panel Online Ressourcen zum Nachschlagen</h1>                \r\n        \r\n        \r\n        <p>\r\n            <a href=\\"http://www.seopanel.in\\" target=\\"_blank\\">Offizielle SEO Panel Webseite</a>\r\n        </p>\r\n        <p>\r\n            <a href=\\"<?=SP_DOWNLOAD_LINK?>\\" target=\\"_blank\\">SEO Panel downloaden</a>\r\n        </p>\r\n        \r\n        <p>\r\n            <a href=\\"<?=SP_DEMO_LINK?>\\" target=\\"_blank\\">Seo Panel Demo</a>\r\n        </p>\r\n        \r\n        <p>\r\n            <a href=\\"<?=SP_CONTACT_LINK?>\\" target=\\"_blank\\">Seo Panel Kontakt</a>\r\n        </p>\r\n        \r\n        <p>\r\n            <a href=\\"<?=SP_HELP_LINK?>\\" target=\\"_blank\\">Seo Panel Hilfe</a>\r\n        </p>\r\n        \r\n        <p>\r\n            <a href=\\"<?=SP_FORUM_LINK?>\\" target=\\"_blank\\">Seo Panel Forum</a>\r\n        </p>\r\n        \r\n        <p>\r\n            <a href=\\"<?=SP_SUPPORT_LINK?>\\" target=\\"_blank\\">Seo Panel Support System</a>\r\n        </p>\r\n        \r\n        <p>\r\n            <a href=\\"<?=SP_DONATE_LINK?>\\" target=\\"_blank\\">Fuer SEO Panel spenden</a>\r\n        </p>\r\n    </li>\r\n    \r\n</ul>\r\n</fieldset>', '2011-07-07 19:09:22'),
(901, 'de', 'home', 'Pages Indexed', 'Indizierte Seiten', '2011-07-07 19:09:22'),
(902, 'de', 'home', 'Ranks', 'Ranks', '2011-07-07 19:09:22'),
(903, 'de', 'home', 'SiteNameUrl', 'Seiten Name / URL', '2011-07-07 19:09:22'),
(904, 'de', 'home', 'Website Statistics', 'Webseiten Statistiken', '2011-07-07 19:09:22'),
(905, 'de', 'keyword', 'Crawling keyword', 'Ueberpruefe Keyword', '2016-01-02 23:22:50'),
(906, 'de', 'keyword', 'Detailed Keyword Position Reports', 'Detaillierte Keyword Ranking Berichte', '2016-01-02 23:22:50'),
(907, 'de', 'keyword', 'Edit Keyword', 'Keyword bearbeiten', '2016-01-02 23:22:50'),
(908, 'de', 'keyword', 'Graphical Keyword Position Reports', 'Grafische Keyword Ranking Berichte', '2016-01-02 23:22:50'),
(909, 'de', 'keyword', 'Import Keywords', 'Keywords importieren', '2016-01-02 23:22:50'),
(910, 'de', 'keyword', 'Keyword already exist', 'Keyword bereits vorhanden', '2016-01-02 23:22:50'),
(911, 'de', 'keyword', 'Keyword Position Report', 'Keyword Ranking Bericht', '2016-01-02 23:22:50'),
(912, 'de', 'keyword', 'New Keyword', 'Neues Keyword', '2016-01-02 23:22:50'),
(913, 'de', 'keyword', 'not assigned to required search engines', 'nicht vertreten in relevanten Suchmaschinen', '2016-01-02 23:22:50'),
(914, 'de', 'keyword', 'pleaseselecttool', 'Waehle bitte mindestens 1 SEO Tool', '2016-01-02 23:22:50'),
(915, 'de', 'keyword', 'Quick Keyword Position Checker', 'Schneller Keyword Ranking Check', '2016-01-02 23:22:50'),
(916, 'de', 'keyword', 'results from ', 'Ergebnisse von', '2016-01-02 23:22:50'),
(917, 'de', 'keyword', 'Show All results', 'ALLE Ergebnisse anzeigen', '2016-01-02 23:22:50'),
(918, 'de', 'keyword', 'Successfully crawled keyword', 'Keyword erfolgreich geprueft', '2016-01-02 23:22:50'),
(919, 'de', 'keyword', 'to create new keywords', 'um neues Keyword zu erstellen', '2016-01-02 23:22:50'),
(920, 'de', 'label', 'already exist', 'bereits vorhanden', '2016-01-02 23:23:15'),
(921, 'de', 'label', 'Authentication', 'Authentifizierung', '2016-01-02 23:23:15'),
(922, 'de', 'label', 'Author', 'Autor', '2016-01-02 23:23:15'),
(923, 'de', 'label', 'Click Here', 'Hier klicken', '2016-01-02 23:23:15'),
(924, 'de', 'label', 'Cron', 'Cronjob', '2016-01-02 23:23:15'),
(925, 'de', 'label', 'Description', 'Beschreibung', '2016-01-02 23:23:15'),
(926, 'de', 'label', 'Developers', 'Entwickler', '2016-01-02 23:23:15'),
(927, 'de', 'label', 'Download', 'Download', '2016-01-02 23:23:15'),
(928, 'de', 'label', 'Installation', 'Installation', '2016-01-02 23:23:15'),
(929, 'de', 'label', 'Keywords', 'Keywords', '2016-01-02 23:23:15'),
(930, 'de', 'label', 'noactiveplugins', 'Keine aktiven SEO Erweiterungen gefunden!', '2016-01-02 23:23:15'),
(931, 'de', 'label', 'Plugin', 'Erweiterung', '2016-01-02 23:23:15'),
(932, 'de', 'label', 'Port', 'Port', '2016-01-02 23:23:15'),
(933, 'de', 'label', 'Proxy', 'Proxy', '2016-01-02 23:23:15'),
(934, 'de', 'label', 'Re-install', 'Neu-Installation', '2016-01-02 23:23:15'),
(935, 'de', 'label', 'Sponsors', 'Sponsoren', '2016-01-02 23:23:15'),
(936, 'de', 'label', 'Title', 'Titel', '2016-01-02 23:23:15'),
(937, 'de', 'label', 'translation by', 'Uebersetzung von', '2016-01-02 23:23:15'),
(938, 'de', 'label', 'Translators', 'Uebersetzer', '2016-01-02 23:23:15'),
(939, 'de', 'label', 'Upgrade', 'Aufstufen', '2016-01-02 23:23:15'),
(940, 'de', 'label', 'Version', 'Version', '2016-01-02 23:23:15'),
(941, 'de', 'login', 'Confirm Password', 'Passwort bestätigen', '2016-01-02 23:23:33'),
(942, 'de', 'login', 'Create my account', 'Meinen Account erstellen', '2016-01-02 23:23:33'),
(943, 'de', 'login', 'Create New Account', 'Neuen Account erstellen', '2016-01-02 23:23:33'),
(944, 'de', 'login', 'Email', 'Email', '2016-01-02 23:23:33'),
(945, 'de', 'login', 'emailexist', 'Email bereits vorhanden!', '2016-01-02 23:23:33'),
(946, 'de', 'login', 'Enter the code as it is shown', 'Gib bitte den angezeigten Code ein', '2016-01-02 23:23:33'),
(947, 'de', 'login', 'First Name', 'Vorname', '2016-01-02 23:23:33'),
(948, 'de', 'login', 'Last Name', 'Nachname', '2016-01-02 23:23:33'),
(949, 'de', 'login', 'Login', 'Einloggen', '2016-01-02 23:23:33'),
(950, 'de', 'login', 'Login incorrect', 'Falsche Login Informationen', '2016-01-02 23:23:33'),
(951, 'de', 'login', 'newaccountsuccess', 'Account erfolgreich registriert!', '2016-01-02 23:23:33'),
(952, 'de', 'login', 'Password', 'Passwort', '2016-01-02 23:23:33'),
(953, 'de', 'login', 'Password incorrect', 'Falsches Passwort', '2016-01-02 23:23:33'),
(954, 'de', 'login', 'Register', 'Registrieren', '2016-01-02 23:23:33'),
(955, 'de', 'login', 'Sign in to your account', 'In Account einloggen', '2016-01-02 23:23:33'),
(956, 'de', 'login', 'User inactive', 'Benutzer inaktiv', '2016-01-02 23:23:33'),
(957, 'de', 'login', 'Username', 'Benutzername', '2016-01-02 23:23:33'),
(958, 'de', 'login', 'usernameexist', 'Benutzername bereits vorhanden!', '2016-01-02 23:23:33'),
(959, 'de', 'panel', 'About Us', 'Ueber Uns', '2016-01-02 23:23:58'),
(960, 'de', 'panel', 'Add following command to your cron tab', 'Folgendes Kommando zum Cronjob hinzufuegen', '2016-01-02 23:23:58'),
(961, 'de', 'panel', 'alsocheckfollowlink', 'Folgenden Link klicken, falls mehr Details benoetigt werden.', '2016-01-02 23:23:58'),
(962, 'de', 'panel', 'Check Directory', 'Verzeichnis prüfen', '2016-01-02 23:23:58'),
(963, 'de', 'panel', 'Cron Command', 'Cronjob Kommando', '2016-01-02 23:23:58'),
(964, 'de', 'panel', 'Directory Manager', 'Verzeichnis Manager', '2016-01-02 23:23:58'),
(965, 'de', 'panel', 'Edit My Profile', 'Profil bearbeiten', '2016-01-02 23:23:58'),
(966, 'de', 'panel', 'My Profile', 'Mein Profil', '2016-01-02 23:23:58'),
(967, 'de', 'panel', 'New Proxy', 'Neue Proxy', '2016-01-02 23:23:58'),
(968, 'de', 'panel', 'New User', 'Neuer Benutzer', '2016-01-02 23:23:58'),
(969, 'de', 'panel', 'New Website', 'Neue Webseite', '2016-01-02 23:23:58'),
(970, 'de', 'panel', 'Proxy Manager', 'Proxy Manager', '2016-01-02 23:23:58'),
(971, 'de', 'panel', 'Report Generation Manager', 'Berichtgenerierungs Manager', '2016-01-02 23:23:58'),
(972, 'de', 'panel', 'Reports Manager', 'Berichte Manager', '2016-01-02 23:23:58'),
(973, 'de', 'panel', 'Seo Plugins Manager', 'SEO Erweiterungen Manager', '2016-01-02 23:23:58'),
(974, 'de', 'panel', 'Seo Tools Manager', 'SEO Tools Manager', '2016-01-02 23:23:58'),
(975, 'de', 'panel', 'System Settings', 'System Einstellungen', '2016-01-02 23:23:58'),
(976, 'de', 'panel', 'User Manager', 'Benutzer Manager', '2016-01-02 23:23:58'),
(977, 'de', 'panel', 'Website Manager', 'Webseiten Manager', '2016-01-02 23:23:58'),
(978, 'de', 'plugin', 'Edit Seo Plugin', 'SEO Erweiterungen bearbeiten', '2012-05-13 20:53:16'),
(979, 'de', 'plugin', 'Plugin Name', 'Name der Erweiterung', '2012-05-13 20:53:17'),
(980, 'de', 'plugin', 'Seo Plugin Details', 'SEO Erweiterung - Details', '2012-05-13 20:53:17'),
(981, 'de', 'proxy', 'Edit Proxy', 'Proxy bearbeiten', '2014-06-22 11:45:56'),
(982, 'de', 'proxy', 'Proxy Password', 'Proxy Passwort', '2014-06-22 11:45:56'),
(983, 'de', 'proxy', 'Proxy Username', 'Proxy Benutzername', '2014-06-22 11:45:56'),
(984, 'de', 'proxy', 'Proxyalreadyexist', 'Proxy bereits vorhanden!', '2014-06-22 11:45:56'),
(985, 'de', 'rank', 'enterurlproceed', '<b>Pro Zeile</b> eine URL angeben. Auf <b>Starten</b> klicken um Google und Alexa Rank zu prüfen', '2010-09-30 03:03:32'),
(986, 'de', 'rank', 'Google and Alexa Rank Reports', 'Google und Alexa Rank Berichte', '2010-09-30 03:03:32'),
(987, 'de', 'rank', 'Saved rank results of', 'Erfolgreich Ergebnisse gespeichert fuer', '2010-09-30 03:03:32'),
(988, 'de', 'saturation', 'clickproceedsaturation', '<b>Pro Zeile</b> eine URL angeben. Auf <b>Starten</b> klicken um Suchmaschinensichtbarkeit zu prüfen', '2010-09-30 03:05:34'),
(989, 'de', 'saturation', 'GenerateSaturationReports', 'Suchmaschinensichtbarkeits Berichte erstellen', '2010-09-30 03:05:34'),
(990, 'de', 'saturation', 'Quick Search Engine Saturation Checker', 'Schneller Suchmaschinensichtbarkeits Check', '2010-09-30 03:05:34'),
(991, 'de', 'saturation', 'Saved Search Engine Saturation results of', 'Erfolgreich Suchmaschinensichtbarkeits Egebnisse gespeichert für', '2010-09-30 03:05:34'),
(992, 'de', 'saturation', 'Search Engine Saturation Reports', 'Suchmaschinensichtbarkeits Berichte', '2010-09-30 03:05:34'),
(993, 'de', 'seotools', 'Automatic Submission', 'Automatische Eintragung', '2011-07-07 19:13:48'),
(994, 'de', 'seotools', 'backlink-checker', 'Backlink Checker', '2011-07-07 19:13:48'),
(995, 'de', 'seotools', 'Backlinks Reports', 'Backlink Berichte', '2011-07-07 19:13:48'),
(996, 'de', 'seotools', 'Check Submission Status', 'Eintragungsstatus prüfen', '2011-07-07 19:13:48'),
(997, 'de', 'seotools', 'clickgeneratereports', 'Auf <b>Starten</b> klicken, um Berichte zu erstellen', '2011-07-07 19:13:48'),
(998, 'de', 'seotools', 'Detailed Position Reports', 'Detaillierte Ranking Berichte', '2011-07-07 19:13:48'),
(999, 'de', 'seotools', 'directory-submission', 'Verzeichnis Eintragung', '2011-07-07 19:13:48'),
(1000, 'de', 'seotools', 'Featured Submission', 'Empfohlene Eintragung', '2011-07-07 19:13:48'),
(1001, 'de', 'seotools', 'Generate Backlinks Reports', 'Backlink Berichte erstellen', '2011-07-07 19:13:48'),
(1002, 'de', 'seotools', 'Generate Keyword Reports', 'Keyword Berichte erstellen', '2011-07-07 19:13:48'),
(1003, 'de', 'seotools', 'Generate Rank Reports', 'Rank Berichte erstellen', '2011-07-07 19:13:48'),
(1004, 'de', 'seotools', 'Generate Saturation Reports', 'Suchmaschinensichtbarkeits Berichte erstellen', '2011-07-07 19:13:48'),
(1005, 'de', 'seotools', 'Google Sitemap Generator', 'Google Sitemap Generator', '2011-07-07 19:13:48'),
(1006, 'de', 'seotools', 'Graphical Position Reports', 'Grafische Ranking Berichte', '2011-07-07 19:13:48'),
(1007, 'de', 'seotools', 'Keyword Position Summary', 'Keyword Ranking Zusammenfassung', '2011-07-07 19:13:48'),
(1008, 'de', 'seotools', 'keyword-position-checker', 'Keyword Ranking Checker', '2011-07-07 19:13:48'),
(1009, 'de', 'seotools', 'Keywords Manager', 'Keywords Manager', '2011-07-07 19:13:48'),
(1010, 'de', 'seotools', 'Quick Backlinks Checker', 'Schneller Backlink Check', '2011-07-07 19:13:48'),
(1011, 'de', 'seotools', 'Quick Position Checker', 'Schneller Ranking Check', '2011-07-07 19:13:48'),
(1012, 'de', 'seotools', 'Quick Rank Checker', 'Schneller Rank Ckeck', '2011-07-07 19:13:48'),
(1013, 'de', 'seotools', 'Quick Saturation Checker', 'Schneller Suchmaschinensichtbarkeits Ckeck', '2011-07-07 19:13:48'),
(1014, 'de', 'seotools', 'Rank Reports', 'Rank Berichte', '2011-07-07 19:13:48'),
(1015, 'de', 'seotools', 'rank-checker', 'Rank Checker', '2011-07-07 19:13:48'),
(1016, 'de', 'seotools', 'Saturation Reports', 'Sichtbarkeits Berichte', '2011-07-07 19:13:48'),
(1017, 'de', 'seotools', 'saturation-checker', 'Suchmaschinensichtbarkeit', '2011-07-07 19:13:48'),
(1018, 'de', 'seotools', 'sitemap-generator', 'Sitemap Generator', '2011-07-07 19:13:48'),
(1019, 'de', 'seotools', 'Skipped Directories', 'Übersprungene Verzeichnisse', '2011-07-07 19:13:48'),
(1020, 'de', 'seotools', 'Submission Reports', 'Eintragungs Berichte', '2011-07-07 19:13:48'),
(1021, 'de', 'seotools', 'User Access', 'Benutzer Zugriff', '2011-07-07 19:13:48'),
(1022, 'de', 'settings', 'Click here to become a sponsor for Seo Panel', '<b>Spende $100</b> und werde SEO Panel <b>Sponsor</b>.', '2015-06-16 08:32:07'),
(1023, 'de', 'settings', 'SP_CRAWL_DELAY', 'Pause zwischen Crawl Abfragen (in Sekunden)', '2015-06-16 08:32:07'),
(1024, 'de', 'settings', 'SP_DEFAULTLANG', 'Standard Sprache', '2015-06-16 08:32:07'),
(1025, 'de', 'settings', 'SP_DESCRIPTION', 'Seo Panel Beschreibung', '2015-06-16 08:32:07'),
(1026, 'de', 'settings', 'SP_ENABLE_PROXY', 'Proxy aktivieren', '2015-06-16 08:32:07'),
(1027, 'de', 'settings', 'SP_HOTLINKING', 'Hotlink Schutz für Grafiken aktiviert', '2015-06-16 08:32:07'),
(1028, 'de', 'settings', 'SP_KEYWORDS', 'SEO Panel Keywords', '2015-06-16 08:32:07'),
(1029, 'de', 'settings', 'SP_PAGINGNO', 'Anzahl an Einträgen pro Seite', '2015-06-16 08:32:07'),
(1030, 'de', 'settings', 'SP_TITLE', 'SEO Panel Titel', '2015-06-16 08:32:07'),
(1031, 'de', 'settings', 'SP_USER_GEN_REPORT', 'Benutzern erlauben Berichte zu erstellen', '2015-06-16 08:32:07'),
(1032, 'de', 'settings', 'SP_USER_REGISTRATION', 'Oberfläche der Benutzer Registrierung', '2015-06-16 08:32:07'),
(1033, 'de', 'settings', 'syssettingssaved', 'System Einstellungen erfolgreich gespeichert!', '2015-06-16 08:32:07'),
(1034, 'de', 'sitemap', 'Change frequency', 'Frequenz ändern', '2010-09-30 03:19:03'),
(1035, 'de', 'sitemap', 'clickproceedsitemap', 'Auf <b>Starten</b> klicken um Sitemap zu erstellen', '2010-09-30 03:19:03'),
(1036, 'de', 'sitemap', 'Download sitemap file from', 'Sitemap Datei herunterladen', '2010-09-30 03:19:03'),
(1037, 'de', 'sitemap', 'Exclude Url', 'URL ausschließen', '2010-09-30 03:19:03'),
(1038, 'de', 'sitemap', 'processtaketime', 'Dieser Prozess kann einige Minuten in Anspruch nehmen, abhängig von der Anzahl der Links auf der Webseite. Bitte kurz gedulden.', '2010-09-30 03:19:03'),
(1039, 'de', 'sitemap', 'Sitemap Type', 'Sitemap Typ', '2010-09-30 03:19:03'),
(1040, 'de', 'user', 'Edit User', 'Benutzer bearbeiten', '2016-01-02 23:30:39'),
(1041, 'de', 'user', 'Saved My Profile Details', 'Profil Details gespeichert', '2016-01-02 23:30:39'),
(1042, 'de', 'website', 'Edit Website', 'Webseite bearbeiten', '2016-01-02 23:32:29'),
(1043, 'de', 'website', 'plscrtwebsite', 'Bitte erst Webseite erstellen um SEO Tools und Erweiterungen zu nutzen.', '2016-01-02 23:32:29'),
(1044, 'de', 'website', 'Website already exist', 'Webseite bereits vorhanden', '2016-01-02 23:32:29'),
(1045, 'de', 'website', 'yourwebalreday', 'Deine Webseite, falls bereits eine erstellt wurde.', '2016-01-02 23:32:29'),
(1046, 'de', 'support', 'support_cont1', '<fieldset>\r\n<legend>Seo Panel Support System</legend>\r\n<ul class=\\"infobox\\">\r\n	<li>\r\n		<h1>1000-Webkataloge-Paket</h1> \r\n		<p>\r\n			Wir bieten dir ein Paket mit <b>1000 kostenlosen, aktiven und verifizierten</b> Webkatalogen, zur Integration in das <b>Verzeichnis Eintragungs Tool</b>.\r\n			Dieses hilft dir die Anzahl an <b>Backlinks</b> deiner eigenen Webseiten <b>erheblich zu steigern</b>.\r\n			Wir stellen diese Liste momentan zur Verfuegung um Geld zu sammeln fuer <b>zukuenftige Entwicklungen</b> fuer SEO Panel.\r\n			Um die Liste zu erhalten, <a href=\\"<?=SP_DONATE_LINK?>\\" target=\\"_blank\\">spende</a> $10 oder mehr um SEO Panel zu verbessern.\r\n			Falls du Fragen hast, nimm bitte <a href=\\"<?=SP_CONTACT_LINK?>\\" target=\\"_blank\\">Kontakt</a> auf oder oeffne ein Ticket im <a href=\\"<?=SP_SUPPORT_LINK?>\\" target=\\"_blank\\">Support System</a>.   \r\n		</p>		\r\n		<p>\r\n			<a href=\\"<?=SP_DONATE_LINK?>\\" target=\\"_blank\\">Hier klicken um eine Spende abzugeben.</a>\r\n		</p>\r\n		<br>\r\n	</li>\r\n	\r\n	<li>\r\n		<h1>Das Lokale-Suchmaschinen-Paket</h1> \r\n		<p>\r\n			Fuege <b>lokale Suchmaschinendomains</b> fuer google,yahoo,msn(<b>z.B: www.google.de,www.google.fr etc</b>) zum Seo Panel <b>Keyword Ranking Checker</b> hinzu, um das Ranking lokal zu analysieren.\r\n			Um lokale Suchmaschinen-Pakete zu erhalten, bitte <a href=\\"<?=SP_DONATE_LINK?>\\" target=\\"_blank\\">spende</a> $10 oder mehr um SEO Panel zu verbessern.\r\n			Bevor du spendest, nimm bitte <a href=\\"<?=SP_CONTACT_LINK?>\\" target=\\"_blank\\">Kontakt</a> auf und nenne uns die benoetigten Suchmaschinen Laenderkennzeichnungen.\r\n			<br><br>			  \r\n			Um <b>neue Suchmaschinen(z.B.:baidu.com)</b> hinzuzufuegen, nimm bitte <a href=\\"<?=SP_CONTACT_LINK?>\\" target=\\"_blank\\">Kontakt</a> auf oder oeffne ein Ticket im <a href=\\"<?=SP_SUPPORT_LINK?>\\" target=\\"_blank\\">Support System</a>. \r\n		</p>		\r\n		<p class=\\"visit\\">\r\n			<a href=\\"<?=SP_CONTACT_LINK?>\\" target=\\"_blank\\">Hier klicken um Kontakt aufzunehmen.</a>\r\n		</p>\r\n		<br>\r\n	</li>\r\n	\r\n	<li>\r\n		<h1>Seo Panel Erweiterungen</h1> \r\n		<p>\r\n			Integriere <b>SEO Erweiterungen</b> in Seo Panel, um die <b>Features zu erweiteren</b> um Sie deinen Anforderungen anzupassen.\r\n			<a href=\\"<?=SP_PLUGINSITE?>\\" target=\\"_blank\\">Seo Panel Erweiterungen</a> sind erhaeltlich von Seo Panel und Drittanbietern.\r\n			Es ist auch leicht, selbst Erweiterungen fuer Seo Panel zu <b>entwickeln</b>.\r\n			Du kannst deine eigene Erweiterung <a href=\\"<?=SP_PLUGINSITE?>\\" target=\\"_blank\\">uebermitteln</a> und wir werden es auf der webseite <b>veroeffentlichen</b>.        \r\n		</p>		\r\n		<p>\r\n			<a href=\\"<?=SP_PLUGINSITE?>\\" target=\\"_blank\\">Hier klicken fuer Seo Panel Erweiterungen</a>\r\n		</p>\r\n		<br>\r\n	</li>	\r\n	<li>\r\n		<h1>Kontakt</h1> \r\n		<p>\r\n			Nimm mit uns Kontakt auf, wenn Fragen zu <b>Seo Panel Tools, Erweiterungen, etc..</b> bestehen.       \r\n		</p>		\r\n		<p>\r\n			<a href=\\"<?=SP_CONTACT_LINK?>\\" target=\\"_blank\\">Hier klicken um Kontakt aufzunehmen.</a>\r\n		</p>\r\n		<br>\r\n	</li>	\r\n	<li>\r\n		<h1>Support Tickets</h1> \r\n		<p>\r\n			Fuer <b>technischen Support</b> vom Seo Panel Team.\r\n		</p>		\r\n		<p>\r\n			<a href=\\"<?=SP_SUPPORT_LINK?>\\" target=\\"_blank\\">Hier klicken um ein Support Ticken zu oeffnen.</a>\r\n		</p>\r\n		<br>\r\n	</li>	\r\n	<li>\r\n		<h1>Fehler berichten.</h1> \r\n		<p>\r\n			Berichte uns von <b>Fehlern</b> ueber <b>Seo panel Tools, Erweiterungen, etc. </b> durch klick auf diesen Link. \r\n			Bitte unterstuetze uns, Seo Panel in der Zukunft zu verbessern.          \r\n		</p>		\r\n		<p>\r\n			<a href=\\"<?=SP_SUPPORT_LINK?>\\" target=\\"_blank\\">Hier klicken um Fehler zu berichten.</a>\r\n		</p>\r\n		<br>\r\n	</li>	\r\n</ul>\r\n</fieldset>\r\n\r\n\r\n<fieldset>\r\n<legend>Seo Panel Online Ressourcen</legend>\r\n<ul class=\\"infobox\\">\r\n		\r\n	<li>\r\n		<h1>Seo Panel Hilfe</h1> \r\n		<p>\r\n			Schau dir die <a href=\\"<?=SP_HELP_LINK?>\\" target=\\"_blank\\">Seo Panel Dokumentation</a> in der <b>Hilfestellung</b> an. Diese beinhaltet die <b>Dokumentation</b> ueber Seo Panel Tools, Erweiterungen und vieles mehr.\r\n			<br>Dies ist der beste Platz im Internet um <b>Hilfe</b> fuer Seo Panel zu erhalten. Wir bitten darum im SEO Panel \\"help guide\\" darueber zu <b>berichten</b> falls Fehler entdeckt werden. 	          \r\n		</p>\r\n		<p>\r\n			<a href=\\"<?=SP_HELP_LINK?>\\" target=\\"_blank\\">Hier klicken um zum Hilfe-Bereich zu gelangen.</a>\r\n		</p>\r\n		<br>\r\n	</li>	\r\n	<li>\r\n		<h1>Seo Panel Forum</h1> \r\n		<p>\r\n			Der Platz um ueber das weltweit erste Open Source <b>Seo Control Panel</b> zu diskutieren. \r\n			Der beste Platz um <b>Antworten</b> auf <b>deine Fragen</b> ueber Seo Panel zu finden.\r\n			<br>Hier koennen auch <b>Erfahrungen ausgetauscht werden</b>.		     	          \r\n		</p>		\r\n		<p>\r\n			<a href=\\"<?=SP_FORUM_LINK?>\\" target=\\"_blank\\">Hier klicken um zum Seo Panel Forum zu gelangen.</a>\r\n		</p>\r\n		<br>\r\n	</li>\r\n</ul>	\r\n</fieldset>\r\n\r\n\r\n<fieldset>\r\n<legend>Spenden fuer Seo Panel</legend>\r\n<ul class=\\"infobox\\">		\r\n	<li>\r\n		<h1>Gib eine Spende fuer Seo Panel ab - Das erste Open Source Seo Control Panel weltweit.</h1> \r\n		<p>\r\n			<b>Spende</b> an Seo Panel um die weltweit erste Open Source SEO Software zu unterstuetzen.\r\n			Es ist geplant in der Zukunft weitere Features <b>hinzuzufügen und zu verbessern</b> . \r\n			<br>Nur mit dem <b>Support</b> unserer Benutzer ist es moeglich unsere <b>Ziele</b> zu erreichen.\r\n			Bist du der Meinung, Seo Panel ist <b>nuetzlich</b> fuer dich, gib bitte eine kleine Spende ab.\r\n			<br>Wir werden deinen Namen und deine Webseite auf unserer <a href=\\"<?=SP_DONATE_LINK?>\\" target=\\"_blank\\">Spendenseite</a> <b>veroeffentlichen</b> \r\n		</p>\r\n		<p>\r\n			<a href=\\"<?=SP_DONATE_LINK?>\\" target=\\"_blank\\">Hier klicken um fuer Seo Panel zu spenden</a>\r\n		</p>\r\n		<br>\r\n	</li>\r\n</ul>\r\n</fieldset>', '2010-09-30 06:25:32'),
(1047, 'de', 'support', 'support_cont2', '<fieldset>\r\n<legend>Seo Panel Online Ressourcen</legend>\r\n<ul class=\\"infobox\\">\r\n		\r\n	<li>\r\n		<h1>Seo Panel Hilfe</h1> \r\n		<p>\r\n			Schau dir die <a href=\\"<?=SP_HELP_LINK?>\\" target=\\"_blank\\">Seo Panel Dokumentation</a> in der <b>Hilfestellung</b> an. Diese beinhaltet die <b>Dokumentation</b> ueber Seo Panel Tools, Erweiterungen und vieles mehr.\r\n			<br>Dies ist der beste Platz im Internet um <b>Hilfe</b> fuer Seo Panel zu erhalten. Wir bitten darum im SEO Panel \\"help guide\\" darueber zu <b>berichten</b> falls Fehler entdeckt werden. 	          \r\n		</p>\r\n		<p>\r\n			<a href=\\"<?=SP_HELP_LINK?>\\" target=\\"_blank\\">Hier klicken um zum Hilfe-Bereich zu gelangen.</a>\r\n		</p>\r\n		<br>\r\n	</li>	\r\n	<li>\r\n		<h1>Seo Panel Forum</h1> \r\n		<p>\r\n			Der Platz um ueber das weltweit erste Open Source <b>Seo Control Panel</b> zu diskutieren. \r\n			Der beste Platz um <b>Antworten</b> auf <b>deine Fragen</b> ueber Seo Panel zu finden.\r\n			<br>Hier koennen auch <b>Erfahrungen ausgetauscht werden</b>.		     	          \r\n		</p>		\r\n		<p>\r\n			<a href=\\"<?=SP_FORUM_LINK?>\\" target=\\"_blank\\">Hier klicken um zum Seo Panel Forum zu gelangen.</a>\r\n		</p>\r\n		<br>\r\n	</li>\r\n</ul>	\r\n</fieldset>', '2010-09-30 06:25:32'),
(1048, 'de', 'support', 'support_cont3', '<fieldset>\r\n<legend>Fuer SEO Panel spenden</legend>\r\n<ul class=\\"infobox\\">		\r\n	<li>\r\n		<h1>Spende fuer die zukuenftige SEO Panel Entwicklung - Das erste Open Source Seo Control Panel weltweit.</h1> \r\n		<p>\r\n			<b>Spende</b> an Seo Panel um die weltweit erste Open Source SEO Software zu unterstuetzen.\r\n			Es ist geplant in der Zukunft weitere Features <b>hinzuzufügen und zu verbessern</b> . \r\n			<br>Nur mit dem <b>Support</b> unserer Benutzer ist es moeglich unsere <b>Ziele</b> zu erreichen.\r\n			Bist du der Meinung, Seo Panel ist <b>nuetzlich</b> fuer dich, gib bitte eine kleine Spende ab.\r\n			<br>Wir werden deinen Namen und deine Webseite auf unserer <a href=\\"<?=SP_DONATE_LINK?>\\" target=\\"_blank\\">Spendenseite</a> <b>veroeffentlichen</b> \r\n		</p>\r\n		<p>\r\n			<a href=\\"<?=SP_DONATE_LINK?>\\" target=\\"_blank\\">Hier klicken um fuer Seo Panel zu spenden</a>\r\n		</p>\r\n		<br>\r\n	</li>\r\n</ul>\r\n</fieldset>', '2010-09-30 06:25:32'),
(1049, 'en', 'settings', 'seopanel_title', 'Seo Panel: World''s first open source seo control panel for managing multiple web sites', '2010-09-30 07:46:04'),
(1050, 'en', 'settings', 'seopanel_description', 'A complete free control panel for managing search engine optimization of your websites. It containing lots of hot seo tools to increase and track the performace your websites. Its an open source software and also you can develop your own seo plugins for seo panel.', '2010-09-30 07:46:04'),
(1051, 'de', 'settings', 'seopanel_description', 'Ein vollkommen kostenloses Kontrollzentrum zur Verwaltung der Suchmaschinenoptimierung deiner\r\nWebseiten. Es beinhaltet die wichtigsten SEO Tools um die Leistung deiner Webseiten zu analysieren und verbessern.\r\nEs handelt sich um Open Source Software, du kannst also selbst SEO Erweiterungen für dein SEO Panel entwickeln.', '2015-06-16 08:32:07'),
(1052, 'de', 'settings', 'seopanel_title', 'SEO Panel: Das weltweit erste Open Source Kontrollzentrum zur Verwaltung mehrerer Webseiten.', '2015-06-16 08:32:07'),
(1053, 'es', 'settings', 'seopanel_description', 'Un completo panel de control gratuito para la gestión de la optimización para buscadores de su sitios. Que contiene un montón de herramientas seo de gran utilidad para realizar el seguimiento del rendimiento de su sitios web. Se trata de un software de código abierto y también ud. puede desarrollar sus propios plugins para el panel de control.', '2012-05-12 11:03:05'),
(1054, 'es', 'settings', 'seopanel_title', 'Seo Panel: Primero programa del mundo open source para la gestión Seo de varios sitios web', '2012-05-12 11:03:05'),
(1055, 'fr', 'settings', 'seopanel_description', 'Un panneau de contrôle complet, gratuit, pour gérer le référencement de vos sites internet. Seo Panel inclut de nombreux outils Seo pour suivre et améliorer les performances de vos sites. Il s''agit d''un logiciel open source pour lequel vous pouvez développer vos propres extensions.', '2016-12-09 18:04:37'),
(1056, 'fr', 'settings', 'seopanel_title', 'Seo Panel: le premier panneau de contrôle de référencement multisite open source au monde', '2016-12-09 18:04:37'),
(1840, 'nl', 'common', 'Invalid code entered', 'Ongeldige code ingevoerd', '2014-01-07 21:29:58'),
(1841, 'nl', 'common', 'Invalid email address entered', 'Ongeldig e-mailadres ingevoerd', '2014-01-07 21:29:58'),
(1839, 'nl', 'common', 'Invalid characters', 'Ongeldige karakters', '2014-01-07 21:29:58'),
(1838, 'nl', 'common', 'Inactive', 'Inactief', '2014-01-07 21:29:58'),
(1837, 'nl', 'common', 'Inactivate', 'Deactiveren', '2014-01-07 21:29:58'),
(1836, 'nl', 'common', 'Id', 'Id', '2014-01-07 21:29:58'),
(1835, 'nl', 'common', 'hidenews', 'Seo Panel Nieuws verbergen', '2014-01-07 21:29:58');
INSERT INTO `texts` (`id`, `lang_code`, `category`, `label`, `content`, `changed`) VALUES
(1834, 'nl', 'common', 'help', 'Help', '2014-01-07 21:29:58'),
(1833, 'nl', 'common', 'Google Pagerank', 'Google Pagerank', '2014-01-07 21:29:58'),
(1832, 'nl', 'common', 'Found', 'Gevonden', '2014-01-07 21:29:58'),
(1831, 'nl', 'common', 'forum', 'Forum', '2014-01-07 21:29:58'),
(1830, 'nl', 'common', 'failed', 'mislukt', '2014-01-07 21:29:58'),
(1829, 'nl', 'common', 'entrynotvalid', 'De invoer is niet correct', '2014-01-07 21:29:58'),
(1828, 'nl', 'common', 'Entry cannot be blank', 'Invoer mag niet leeg zijn', '2014-01-07 21:29:58'),
(1827, 'nl', 'common', 'Donate', 'Doneren', '2014-01-07 21:29:58'),
(1826, 'nl', 'common', 'Directory', 'Directory', '2014-01-07 21:29:58'),
(1825, 'nl', 'common', 'Details', 'Details', '2014-01-07 21:29:58'),
(1824, 'nl', 'common', 'Crawl Meta Data', 'Meta-Data opvragen', '2014-01-07 21:29:58'),
(1823, 'nl', 'common', 'Country', 'Land', '2014-01-07 21:29:58'),
(1822, 'nl', 'common', 'copyright', 'Copyright © [year] www.seopanel.in Alle rechten voorbehouden', '2014-01-07 21:29:58'),
(1821, 'nl', 'common', 'contact', 'Contact', '2014-01-07 21:29:58'),
(1820, 'nl', 'common', 'Category', 'Categorie', '2014-01-07 21:29:58'),
(1819, 'nl', 'common', 'All', 'Alle', '2014-01-07 21:29:58'),
(1818, 'nl', 'common', 'Alexa Rank', 'Alexa Rank', '2014-01-07 21:29:58'),
(1817, 'nl', 'common', 'Admin Panel', 'Admin Instellingen', '2014-01-07 21:29:58'),
(2053, 'nl', 'settings', 'seopanel_description', 'Een compleet gratis bedieningspaneel voor het beheren van de zoekmachine optimalisatie van uw websites. Het bevat vele Seo tools om de prestaties van uw websites te verbeteren en op te volgen. Het is open source software en u kunt ook uw eigen Seo plugins voor Seo panel ontwikkelen.', '2014-01-07 21:51:05'),
(1816, 'nl', 'common', 'Activate', 'Activeren', '2014-01-07 21:29:58'),
(1815, 'nl', 'common', 'Action', 'Actie', '2014-01-07 21:29:58'),
(1814, 'nl', 'button', 'Submit', 'Versturen', '2014-01-08 19:25:07'),
(1813, 'nl', 'button', 'Skip', 'Overslaan', '2014-01-08 19:25:07'),
(1812, 'nl', 'button', 'Show Records', 'Toon Rapporten', '2014-01-08 19:25:07'),
(1811, 'nl', 'button', 'Show Details', 'Toon Details', '2014-01-08 19:25:07'),
(1810, 'nl', 'button', 'Reload', 'Herladen', '2014-01-08 19:25:07'),
(1809, 'nl', 'button', 'Proceed', 'Ga verder', '2014-01-08 19:25:07'),
(1808, 'nl', 'button', 'Check Status', 'Status controleren', '2014-01-08 19:25:07'),
(1807, 'nl', 'button', 'Cancel', 'Annuleren', '2014-01-08 19:25:07'),
(1806, 'nl', 'backlink', 'Saved backlink results of', 'Backlink resultaten opgeslagen voor', '2010-10-22 11:58:05'),
(1805, 'nl', 'backlink', 'clickproceedbacklink', 'Geef één URL <b>per regel</b>. Klik op <b>Ga verder</b> om de backlinks te controleren.', '2010-10-22 11:58:05'),
(1804, 'nl', 'label', 'wantproceed', 'Bent u zeker dat u wilt doorgaan?', '2014-01-07 21:37:43'),
(1803, 'nl', 'common', 'No', 'Nr.', '2014-01-07 21:29:58'),
(1802, 'nl', 'common', 'Yes', 'Ja', '2014-01-07 21:29:58'),
(1801, 'nl', 'common', 'Select', 'Selecteer', '2014-01-07 21:29:58'),
(1800, 'nl', 'common', 'Delete', 'Verwijderen', '2014-01-07 21:29:58'),
(1799, 'nl', 'common', 'Edit', 'Bewerken', '2014-01-07 21:29:58'),
(1794, 'nl', 'common', 'lang', 'Taal', '2014-01-07 21:29:58'),
(1795, 'nl', 'common', 'Active', 'Actief', '2014-01-07 21:29:58'),
(1796, 'nl', 'common', 'Total', 'Totaal', '2014-01-07 21:29:58'),
(1797, 'nl', 'common', 'Date', 'Datum', '2014-01-07 21:29:58'),
(1798, 'nl', 'common', 'Rank', 'Rank', '2014-01-07 21:29:58'),
(1845, 'nl', 'common', 'My Account', 'Mijn Account', '2014-01-07 21:29:58'),
(1844, 'nl', 'common', 'Keywords', 'Zoekwoorden', '2014-01-07 21:29:58'),
(1843, 'nl', 'common', 'Keyword', 'Zoekwoord', '2014-01-07 21:29:58'),
(1842, 'nl', 'common', 'Invalid value', 'Ongeldige waarde', '2014-01-07 21:29:58'),
(1131, 'it', 'backlink', 'clickproceedbacklink', 'Inserisci gli Indirizzi Web <b>Uno per riga</b>. Clicca su <b>Continua</b> per controllare i Backlink', '2011-10-15 19:15:58'),
(1132, 'it', 'backlink', 'Saved backlink results of', 'Salva risultati backlink per', '2011-10-15 19:15:59'),
(1133, 'it', 'button', 'Cancel', 'Cancella', '2014-01-08 19:28:28'),
(1134, 'it', 'button', 'Check Status', 'Verifica stato', '2014-01-08 19:28:28'),
(1135, 'it', 'button', 'Proceed', 'Procedi', '2014-01-08 19:28:28'),
(1136, 'it', 'button', 'Reload', 'Ricarica', '2014-01-08 19:28:28'),
(1137, 'it', 'button', 'Show Details', 'Mostra dettagli', '2014-01-08 19:28:28'),
(1138, 'it', 'button', 'Show Records', 'Mostra records', '2014-01-08 19:28:28'),
(1139, 'it', 'button', 'Skip', 'Salta', '2014-01-08 19:28:28'),
(1140, 'it', 'button', 'Submit', 'Invia', '2014-01-08 19:28:28'),
(1141, 'it', 'common', 'Action', 'Azione', '2016-12-09 09:17:20'),
(1142, 'it', 'common', 'Activate', 'Attivare', '2016-12-09 09:17:20'),
(1143, 'it', 'common', 'Active', 'Attivo', '2016-12-09 09:17:20'),
(1144, 'it', 'common', 'Admin Panel', 'Pannello Admin', '2016-12-09 09:17:20'),
(1145, 'it', 'common', 'Alexa Rank', 'Alexa Rank', '2016-12-09 09:17:20'),
(1146, 'it', 'common', 'All', 'Tutto', '2016-12-09 09:17:20'),
(1147, 'it', 'common', 'Category', 'Categoria', '2016-12-09 09:17:20'),
(1148, 'it', 'common', 'contact', 'Contatto', '2016-12-09 09:17:20'),
(1149, 'it', 'common', 'copyright', 'Copyright © [year] www.seopanel.in All rights reserved', '2016-12-09 09:17:20'),
(2885, 'ro', 'panel', 'About Us', 'Despre Noi', '2012-05-18 21:04:43'),
(2886, 'ro', 'panel', 'Add following command to your cron tab', 'Adauga urmatoare comanda la fila cron', '2012-05-18 21:04:43'),
(1150, 'it', 'common', 'Country', 'Paese', '2016-12-09 09:17:20'),
(1151, 'it', 'common', 'Crawl Meta Data', 'Recupera Meta Data ', '2016-12-09 09:17:20'),
(1152, 'it', 'common', 'Date', 'Data', '2016-12-09 09:17:20'),
(1153, 'it', 'common', 'Delete', 'Cancella', '2016-12-09 09:17:20'),
(1154, 'it', 'common', 'Details', 'Dettagli', '2016-12-09 09:17:20'),
(1155, 'it', 'common', 'Directory', 'Directory', '2016-12-09 09:17:20'),
(1156, 'it', 'common', 'Donate', 'Dona', '2016-12-09 09:17:20'),
(1157, 'it', 'common', 'Edit', 'Modifica', '2016-12-09 09:17:20'),
(1158, 'it', 'common', 'Entry cannot be blank', 'La voce non può essere vuota', '2016-12-09 09:17:20'),
(1159, 'it', 'common', 'entrynotvalid', 'La voce inserita non sembra essere valida', '2016-12-09 09:17:20'),
(1160, 'it', 'common', 'failed', 'fallito', '2016-12-09 09:17:20'),
(1161, 'it', 'common', 'forum', 'Forum', '2016-12-09 09:17:20'),
(1162, 'it', 'common', 'Found', 'Trovato', '2016-12-09 09:17:20'),
(1163, 'it', 'common', 'Google Pagerank', 'Google Pagerank', '2016-12-09 09:17:20'),
(1164, 'it', 'common', 'help', 'Aiuto', '2016-12-09 09:17:20'),
(1165, 'it', 'common', 'hidenews', 'Nasconti il pannello news seo', '2016-12-09 09:17:20'),
(1166, 'it', 'common', 'Id', 'ID', '2016-12-09 09:17:20'),
(1167, 'it', 'common', 'Inactivate', 'Inattività', '2016-12-09 09:17:20'),
(1168, 'it', 'common', 'Inactive', 'Inattivo', '2016-12-09 09:17:20'),
(1169, 'it', 'common', 'Invalid characters', 'Caratteri non validi', '2016-12-09 09:17:20'),
(1170, 'it', 'common', 'Invalid code entered', 'Codice inserito non valido', '2016-12-09 09:17:20'),
(1171, 'it', 'common', 'Invalid email address entered', 'Indirizzo email inserito non valido', '2016-12-09 09:17:20'),
(1172, 'it', 'common', 'Invalid value', 'Valore non valido', '2016-12-09 09:17:20'),
(1173, 'it', 'common', 'Keyword', 'Keyword', '2016-12-09 09:17:20'),
(1174, 'it', 'common', 'Keywords', 'Keywords', '2016-12-09 09:17:20'),
(1175, 'it', 'common', 'lang', 'Lingua', '2016-12-09 09:17:20'),
(1176, 'it', 'common', 'My Account', 'Il mio account', '2016-12-09 09:17:20'),
(1177, 'it', 'common', 'Name', 'Nome', '2016-12-09 09:17:20'),
(1178, 'it', 'common', 'No', 'No', '2016-12-09 09:17:20'),
(1179, 'it', 'common', 'No Keywords Found', 'Keywords non trovate', '2016-12-09 09:17:20'),
(1180, 'it', 'common', 'No Records Found', 'Campo non trovato', '2016-12-09 09:17:20'),
(1181, 'it', 'common', 'noactivetools', 'Non sono stati trovati strumenti seo attivi!', '2016-12-09 09:17:20'),
(1182, 'it', 'common', 'nowebsites', 'Nessun sito web trovato', '2016-12-09 09:17:20'),
(1183, 'it', 'common', 'password632', 'La lunghezza della password deve essere tra i 6 e i 32 caratteri', '2016-12-09 09:17:20'),
(1184, 'it', 'common', 'passwordnotmatch', 'La password non corrisponde', '2016-12-09 09:17:20'),
(1185, 'it', 'common', 'Period', 'Periodo', '2016-12-09 09:17:20'),
(1186, 'it', 'common', 'Priority', 'Priorità', '2016-12-09 09:17:20'),
(1187, 'it', 'common', 'Rank', 'Rank', '2016-12-09 09:17:20'),
(1188, 'it', 'common', 'Reports', 'Report', '2016-12-09 09:17:20'),
(1189, 'it', 'common', 'Results', 'Risultati', '2016-12-09 09:17:20'),
(1190, 'it', 'common', 'Search Engine', 'Motore di ricerca', '2016-12-09 09:17:20'),
(1191, 'it', 'common', 'Select', 'Seleziona', '2016-12-09 09:17:20'),
(1192, 'it', 'common', 'Seo Plugins', 'Plugins seo', '2016-12-09 09:17:20'),
(1193, 'it', 'common', 'Seo Tools', 'Strumenti seo', '2016-12-09 09:17:20'),
(1194, 'it', 'common', 'Sign out', 'Esci', '2016-12-09 09:17:20'),
(1195, 'it', 'common', 'Sign Up', 'Iscriviti', '2016-12-09 09:17:20'),
(1196, 'it', 'common', 'signin', 'Entra', '2016-12-09 09:17:20'),
(1197, 'it', 'common', 'Status', 'Stato', '2016-12-09 09:17:20'),
(1198, 'it', 'common', 'Support', 'Supporto', '2016-12-09 09:17:20'),
(1199, 'it', 'common', 'Total', 'Totale', '2016-12-09 09:17:20'),
(1200, 'it', 'common', 'Url', 'Url', '2016-12-09 09:17:20'),
(1201, 'it', 'common', 'User', 'Utente', '2016-12-09 09:17:20'),
(1202, 'it', 'common', 'User Panel', 'Pannello utente', '2016-12-09 09:17:20'),
(1203, 'it', 'common', 'Website', 'Sito web', '2016-12-09 09:17:20'),
(1204, 'it', 'common', 'Yes', 'Si', '2016-12-09 09:17:20'),
(1205, 'it', 'directory', 'Add back to directory list', 'Aggiungi alla fine della lista directory', '2012-11-08 19:50:02'),
(1206, 'it', 'directory', 'Approved', 'Approvato', '2012-11-08 19:50:02'),
(1207, 'it', 'directory', 'Captcha', 'Verifica umana', '2012-11-08 19:50:02'),
(1208, 'it', 'directory', 'categorynote', 'Categorie, separare con una virgola in base alla priorità. Partire con la categoria con maggiore priorità.', '2012-11-08 19:50:02'),
(1209, 'it', 'directory', 'Check Directory Status', 'Verifica stato directory', '2012-11-08 19:50:02'),
(1210, 'it', 'directory', 'Check Directory Submission Status', 'Verifica stato immissione directory', '2012-11-08 19:50:02'),
(1211, 'it', 'directory', 'clicktoproceeddirsts', 'Clicca su <b>Procedi</b> per verificare lo stato delle directory', '2012-11-08 19:50:02'),
(1212, 'it', 'directory', 'Confirmation', 'Conferma', '2012-11-08 19:50:02'),
(1213, 'it', 'directory', 'desnote', 'Alcune directory richiedono un minimo di 150 caratteri per il campo della descrizione.', '2012-11-08 19:50:02'),
(1214, 'it', 'directory', 'Directories with out captcha', 'Directory senza la verifica umana', '2012-11-08 19:50:02'),
(1215, 'it', 'directory', 'Directory Submission Reports', 'Resoconto immissione directory', '2012-11-08 19:50:02'),
(1216, 'it', 'directory', 'Enter the code shown', 'Inserisci il codice mostrato', '2012-11-08 19:50:02'),
(1217, 'it', 'directory', 'nocatnote', 'La categoria inserita non è stata trovata nella pagina di inserimento. Per cortesia cliccare su <b>Ricarica</b> oppure <b>Salta</b>', '2012-11-08 19:50:02'),
(1218, 'it', 'directory', 'nodirnote', 'Nessuna directory <b>Attiva</b> trovata', '2012-11-08 19:50:02'),
(1219, 'it', 'directory', 'nosuccessnote', 'Non hai ricevuto il messaggio di successo. Per cortesia verifica la tua mail per trovare il messagigo di conferma.', '2012-11-08 19:50:02'),
(1220, 'it', 'directory', 'optionalnote', 'Titoli e descrizioni opzionali da inviare in modalità random nel titolo e nella descrizione delle directory per un miglior risultato.', '2012-11-08 19:50:02'),
(1221, 'it', 'directory', 'Owner Email', 'Email del proprietario', '2012-11-08 19:50:02'),
(1222, 'it', 'directory', 'Owner Name', 'Nome del proprietario', '2012-11-08 19:50:02'),
(1223, 'it', 'directory', 'Pending', 'In attesa di approvazione', '2012-11-08 19:50:02'),
(1224, 'it', 'directory', 'Please select a website to proceed', 'Per cortesia seleziona il sito web per procedere', '2012-11-08 19:50:02'),
(1225, 'it', 'directory', 'selectwebsiteproceed', 'Seleziona un <b>Sito web</b> per <b>Procedere</b> con l\\''invio nella directory.<br>Verifica l\\''invio nelle<b>directory senza verifica umana</b> ', '2012-11-08 19:50:02'),
(1226, 'it', 'directory', 'selectwebsiteschecksub', 'Seleziona un <b>Sito web</b> per <b>Procedere</b> con la verifica dell\\''immssione nelle directory', '2012-11-08 19:50:02'),
(1227, 'it', 'directory', 'Semi Automatic Directory Submission Tool', 'Strumento per l\\''invio semi automatico nelle directory', '2012-11-08 19:50:02'),
(1228, 'it', 'directory', 'spamemailnote', 'Alcune directory potrebbero effettuare invii spam, ti consigliamo di non utilizzare il tuo indirizzo email principale.', '2012-11-08 19:50:02'),
(1229, 'it', 'directory', 'Submission Details', 'Dettagli invio', '2012-11-08 19:50:02'),
(1230, 'it', 'directory', 'Submit Description', 'Inserire descrizione', '2012-11-08 19:50:02'),
(1231, 'it', 'directory', 'Submit Keywords', 'Inserire keywords', '2012-11-08 19:50:02'),
(1232, 'it', 'directory', 'Submit Title', 'Inserire titolo', '2012-11-08 19:50:02'),
(1233, 'it', 'directory', 'Website Category', 'Categoria sito web', '2012-11-08 19:50:02'),
(1234, 'it', 'directory', 'Website Url', 'Url del sito web', '2012-11-08 19:50:02'),
(1235, 'it', 'home', 'Account Summary', 'Sommario account', '2011-07-10 20:10:02'),
(1236, 'it', 'home', 'Backlinks', 'Backlinks', '2011-07-10 20:10:02'),
(1237, 'it', 'home', 'Directory Submission', 'Immissione directory', '2011-07-10 20:10:02'),
(1238, 'it', 'home', 'home_cont1', '<h1 style=\\"text-align: center;margin-bottom: 30px;font-size: 19px;\\">Benvenuto nel Pannello Seo - Il primo pannello di controllo seo al monto per più siti web</h1>\r\n        <p>\r\n            Un <b>pannello di controllo open source </b> completo per gestire <b>l\\''ottimizzazione nei motori di ricerca</b> dei tuoi siti web.\r\n            Il pannello seo è uno<b>stumento</b> che include gli ultimi strumenti seo aggiornati per<b>incrementare e tracciare</b> le\r\n<b>performace</b> dei tuoi siti web.\r\n            E\\'' un <b>software gratuito</b> rilasciato sotto <b>GNU GENERAL PUBLIC LICENSE</b>.\r\n            Le caratteristiche principali del pannello seo sono l\\''<b> estendibilità</b>grazie all\\''utilizzo di <a href=\\"<?=SP_PLUGINSITE?>\\"\r\ntarget=\\"_blank\\">plugin seo</a>.\r\n            Chiunque può facilmente <b>sviluppare e installare</b> i plugin richiesti dal proprio pannello seo. \r\n        </p>\r\n        <p></p>\r\n        <p>\r\n            Questo software open source è stato rilasciato <b>nel gennaio 2010</b>.\r\n            In questo <b>breve periodo</b> di tempo <b>migliaia</b> di <b>web masters</b> hanno utilizzato questo software per<b>ottimizzare</b> i propri siti web.\r\n            Utilizza il pannello seo oggi per te stesso e <b>gusta</b> tutti questi strumenti seo unificati in una<b>sola piattaforma</b>.\r\n        </p>', '2011-07-10 20:10:02'),
(1239, 'it', 'home', 'home_cont2', '<fieldset>\r\n<legend>Maggiori caratteristiche del Pannello Seol <?=SP_INSTALLED?></legend>\r\n<ul class=\\"infobox\\">\r\n    <li>        \r\n        <h1>Strumento di invio automatico nelle directory</h1>\r\n        <p>\r\n        \r\n            Strumento automatico per l\\''invio nelle directory che ti aiuterà a <b>segnalare il tuo sito web</b> nelle maggiori<b> directory gratuite e a pagamento</b>.\r\n            Possiamo anche <b>tracciare lo stato</b> di ogni invio attraverso una <b>verifica periodica</b> utilizzando lo <b>script di verifica stato</b>.\r\n            <b>Directory manager</b> will help us to find out whether <b>directory is active</b> or not.\r\n        </p>\r\n    </li>\r\n    <li>        \r\n        <h1>Verifica posizione keyword</h1>\r\n        <p>\r\n            Verifica la posizione della keyword trovando la <b>posizione nelle ricerche dei motori </b> delle <b>keyword mirate</b>\r\ndel tuo sito web e <b>che si trovano </b> nel sistema.\r\n            Nei report delle posizioni delle keyword possiamo vedere  <b>il posizionamento giornaliero</b> delle  keywords nei differenti motori di ricerca attraverso un <strong> bellissimo grafico </strong>e <b>report dettagliati</b>.        </p>\r\n  </li>\r\n    <li>        \r\n        <h1>Site Auditor</h1>\r\n        <p>Site Auditor will <b>audit all SEO factors</b> of each pages of a site and will give a <b>detailed report</b> about each page. Questo ti aiuterà a creare file sitemap in formato  <b>XML,HTML,TEXT</b>del tuo sito web <strong>inviandole </strong>ai motori di ricerca.</p>\r\n  </li>\r\n    <li>        \r\n        <h1>Verifica Google and Alexa Rank</h1>\r\n  <p>\r\n            La verifica di Google e alexa rank troverà il <b>pagerank di google</b> e il <b>rank di alexa</b> dei tuoi siti web e <b>memorizzarli</b> nel sistema.\r\n            Nella sezione dei <b>report dei rank</b>, possiamo visualizzare <b>giornalmente</b> il rank di google e di alexagdi ogni sito web con i <b>report dettagliati</b>.        </p>\r\n  </li>\r\n    <li>        \r\n        <h1>Verifica Backlinks</h1>\r\n  <p>\r\n            La verifica dei backlinks ti troverà il <b>numero di backlinks</b> verso i nostri siti web nel differenti motori di ricerca <b>(google,yahoo,msn etc)</b> e li <b>memorizzerà</b> nel sistema.<br>\r\n      Nella sezione <b>report backlink</b>, potremo vedere il <b>conteggio giornaliero dei backlink</b> di ogni sito web nel <b>report giornaliero</b>.\r\n        </p>\r\n  </li>    \r\n    <li>        \r\n        <h1>Verifica Saturazione Motori di Ricerca</h1>\r\n  <p>\r\n            La verifica della saturazione dei Motori di Ricerca troverà il <b>numero di pagine indicizzate</b> dei nostri siti web nei differenti motori di ricerca <b>(google,yahoo,msn ecc)</b> e li<b>memorizzerà</b> nel sistema.\r\n      Nella sezione <b>report di verifica di saturazione dei motori di ricerca </b>, noi possiamo vedere <b>il conteggio delle pagine indicizzate giornalmente</b> per ogni sito web con i <b>report dettagliati</b>.        </p>\r\n  </li>\r\n    <li>        \r\n        <h1>Seo Panel Plugins</h1>\r\n        <p>\r\n            La <b>maggior caratteristica </b>del pannello seo è la sua  <b>estendibilità</b>.\r\n            Aggiungere  <b>plugin seo</b> al tuo pannello seo per  <b>estendere le sue caratteristiche</b> in base alle tue esigenze.\r\n            <a href=\\"<?=SP_PLUGINSITE?>\\" target=\\"_blank\\">I plugin del pannello seo</a> sono prodotti dallo stesso pannello seo e da terzi siti.\r\n            Tu puoi anche <b>sviluppare</b> semplici plugin seo per il tuo pannello seo.\r\n      Puoi  <a href=\\"<?=SP_PLUGINSITE?>\\" target=\\"_blank\\">inviaret</a> i tuoi plugin seo al pannello seo e noi li  <b>pubblicheremo</b> nel nostro sito web dopo la <b>verifica</b>.        </p>\r\n  </li>\r\n    <li>        \r\n        <h1>Generatore Meta Tag </h1>\r\n  <p>\r\n            Il generatore di Meta tag è un <b>plugin del pannello seo</b> per creare  <b>meta tags personalizzati </b> per il nostro sito.\r\n            Ti aiuterà ad avere  <b>maggiori informazioni</b> sul nostro sito web con i <b>bot dei motori di ricerca</b>\r\nmentre viene scansionato.        </p>\r\n  </li>\r\n</ul>\r\n</fieldset>', '2011-07-10 20:10:02'),
(1240, 'it', 'home', 'home_cont3', '<fieldset>\r\n<legend>RoSeo Panel Online Resources</legend>    \r\n<ul class=\\"infobox\\">\r\n\r\n    <li>\r\n        <h1>Risorse online del pannello Seo per referenza</h1>                \r\n        \r\n        \r\n        <p>\r\n            <a href=\\"http://www.seopanel.in\\" target=\\"_blank\\">Sito web ufficiale Pannello Seo</a>\r\n        </p>\r\n        <p>\r\n            <a href=\\"<?=SP_DOWNLOAD_LINK?>\\" target=\\"_blank\\">Scarica Pannello Seo </a>\r\n        </p>\r\n        \r\n        <p>\r\n            <a href=\\"<?=SP_DEMO_LINK?>\\" target=\\"_blank\\">Demo Pannello Seo</a>\r\n        </p>\r\n        \r\n        <p>\r\n            <a href=\\"<?=SP_CONTACT_LINK?>\\" target=\\"_blank\\">Contatta Pannello Seo</a>\r\n        </p>\r\n        \r\n        <p>\r\n            <a href=\\"<?=SP_HELP_LINK?>\\" target=\\"_blank\\">Guida/Aiuto Pannello Seo</a>\r\n        </p>\r\n        \r\n        <p>\r\n            <a href=\\"<?=SP_FORUM_LINK?>\\" target=\\"_blank\\">Forum Pannello Seo</a>\r\n        </p>\r\n        \r\n        <p>\r\n            <a href=\\"<?=SP_SUPPORT_LINK?>\\" target=\\"_blank\\">Sistema di supporto Pannello Seo</a>\r\n        </p>\r\n        \r\n        <p>\r\n            <a href=\\"<?=SP_DONATE_LINK?>\\" target=\\"_blank\\">Sostieni Pannello Seo</a>\r\n        </p>\r\n    </li>\r\n    \r\n</ul>\r\n</fieldset>', '2011-07-10 20:10:02'),
(1241, 'it', 'home', 'Pages Indexed', 'Pagine indicizzate', '2011-07-10 20:10:02'),
(1242, 'it', 'home', 'Ranks', 'Ranks', '2011-07-10 20:10:02'),
(1243, 'it', 'home', 'SiteNameUrl', 'Nome sito/Url', '2011-07-10 20:10:02'),
(1244, 'it', 'home', 'Website Statistics', 'Statistiche sito web', '2011-07-10 20:10:02'),
(1245, 'pl', 'website', 'Edit Website', 'Edytuj Stronę', '2010-10-09 05:52:58'),
(1246, 'pl', 'website', 'plscrtwebsite', 'Proszę utworzyć Stronę zanim będziesz mógł używać Narzędzi seo i Pluginów seo.', '2010-10-09 05:52:58'),
(1247, 'pl', 'website', 'Website already exist', 'Taka Strona już istnieje', '2010-10-09 05:52:58'),
(1248, 'pl', 'website', 'yourwebalreday', 'twoją Stronę jeśli już ją stworzyłeś.', '2010-10-09 05:52:58'),
(1249, 'pl', 'user', 'Edit User', 'Edytuj Użytkownika', '2010-10-09 05:53:49'),
(1250, 'pl', 'user', 'Saved My Profile Details', 'Zapisano Profil', '2010-10-09 05:53:49'),
(1251, 'pl', 'support', 'support_cont1', '<fieldset> \r\n<legend>System Wsparcia Seo Panel</legend> \r\n<ul class=\\"infobox\\"> \r\n    <li> \r\n        <h1>Pakiet 1000 Katalogów</h1>  \r\n        <p> \r\n            Dostarczamy <b>1000 darmowych aktywnych i zweryfikowanych</b> katalogów internetowych w jednym pakiecie, gotowe do dodania do Twojego panelu Seo  <b>Narzędzia do submisji Seo</b>. \r\n            Pomoże Ci to <b>powiększyć liczbę backlinków</b> twoich Stron. \r\n            Właściwie to lista 1000 Katalogów jest <b>wprowadzona</b> aby zebrać trochę pieniędzy na <b>rozwijanie funkcjonalności</b> Seo Panel. \r\n            Aby otrzymać listę 1000 internetowych Katalogów prosimy <a href=\\"<?=SP_DONATE_LINK?>\\" target=\\"_blank\\">o złożenie donacji</a>\r\n$10 lub więcej aby pomóc nam rozwinąć funkcjonalność Seo Panel. \r\n            Jeżeli masz jakieś pytania dotyczące pakietu 1000 Katalogów, prosimy <a href=\\"<?=SP_CONTACT_LINK?>\\"\r\ntarget=\\"_blank\\">o kontakt</a> lub utwórz pytanie <a href=\\"<?=SP_SUPPORT_LINK?>\\"\r\ntarget=\\"_blank\\">w systemie wsparcia</a>.    \r\n        </p>         \r\n        <p> \r\n            <a href=\\"<?=SP_DONATE_LINK?>\\" target=\\"_blank\\">Otwórz link aby złożyć donację dla Seo Panel</a> \r\n        </p> \r\n        <br> \r\n    </li> \r\n     \r\n    <li> \r\n        <h1>Lokalny pakiet Wyszukiwarek</h1>  \r\n        <p> \r\n            Dodaj <b>lokalne wyszukiwarki</b> google,yahoo,msn(<b>np: www.google.de,www.google.fr\r\nitd.</b>) do Seo Panel <b>sprawdzenie pozycji Keyword\\''ów</b>, aby śledzić wydajność twoich Stron w lokalnych wyszukiwarkach. \r\n            Aby otrzymać pakiet lokalnych wyszukiwarek (w zależności od twoich wymagań) prosimy <a\r\nhref=\\"<?=SP_DONATE_LINK?>\\" target=\\"_blank\\">o donację</a> $10 lub więcej aby pomóc w rozwoju funkcjonalności Seo Panel. \r\n            Przed złożeniem donacji, prosimy <a href=\\"<?=SP_CONTACT_LINK?>\\" target=\\"_blank\\">o kontakt</a> aby powiadomić nas o żądanej liście lokalnych wyszukiwarek. \r\n            <br><br>               \r\n            Zawsze dodawaj <b>nowe wyszukiwarki (np:baidu.com)</b> do Sprawdzania pozycji Keyword\\''ów w Seo Panel,\r\nprosimy <a href=\\"<?=SP_CONTACT_LINK?>\\" target=\\"_blank\\">o kontakt</a> lub utworzenie pytania w <a\r\nhref=\\"<?=SP_SUPPORT_LINK?>\\" target=\\"_blank\\">systemie wsparcia</a>.  \r\n        </p>         \r\n        <p class=\\"visit\\"> \r\n            <a href=\\"<?=SP_CONTACT_LINK?>\\" target=\\"_blank\\">Otwórz link aby skontaktować się z nami</a> \r\n        </p> \r\n        <br> \r\n    </li> \r\n     \r\n    <li> \r\n        <h1>Pluginy Seo Panel</h1>  \r\n        <p> \r\n            Dodaj <b>pluginy seo</b> do Twojego Seo Panel by <b>rozszerzyć funkcjonalność</b> według twoich wymagań. \r\n            <a href=\\"<?=SP_PLUGINSITE?>\\" target=\\"_blank\\">Pluginy Seo Panel</a> są dostarczane przez Seo Panel oraz zewnętrznych źródeł. \r\n            Możesz także równie łatwo <b>tworzyć</b> pluginy Seo dla Twojego Seo Panel. \r\n            Możesz także <a href=\\"<?=SP_PLUGINSITE?>\\" target=\\"_blank\\">submitować</a> twoje pluginy do Seo Panel a my je <b>opublikujemy</b>na naszej stronie po uprzednim <b>zatwierdzeniu</b>.         \r\n        </p>         \r\n        <p> \r\n            <a href=\\"<?=SP_PLUGINSITE?>\\" target=\\"_blank\\">Otwórz link aby sciągnąć pluginy Seo Panel</a> \r\n        </p> \r\n        <br> \r\n    </li>     \r\n    <li> \r\n        <h1>Kontakt</h1>  \r\n        <p> \r\n            Skontaktuj się z Nami jeśli masz pytanie dotyczące <b>Narzędzi Seo Panel, pluginów oraz funkcjonalności itp.</b> prze użycie poniższego linka.         \r\n        </p>         \r\n        <p> \r\n            <a href=\\"<?=SP_CONTACT_LINK?>\\" target=\\"_blank\\">Otwórz link aby skontaktować się z Nami</a> \r\n        </p> \r\n        <br> \r\n    </li>     \r\n    <li> \r\n        <h1>System Zapytań</h1>  \r\n        <p> \r\n            Aby uzyskać <b>pomoc techniczną</b> od teamu Seo Panel odnośnie instalacji i ustawień Narzędzi Seo Panel, pluginów i funkcjonalności</b>. Np: Aby ustawić zadania Cron dla automatycznego sprawdzania pozycji Keyword\\''ów. \r\n        </p>         \r\n        <p> \r\n            <a href=\\"<?=SP_SUPPORT_LINK?>\\" target=\\"_blank\\">Otwórz link aby utworzyć zapytanie</a> \r\n        </p> \r\n        <br> \r\n    </li>     \r\n    <li> \r\n        <h1>Raportowanie błędów</h1>  \r\n        <p> \r\n            Raportuj <b>błędy</b> w <b>Narzędziach Seo Panel, pluginach i funkcjonalności itp.</b> używając poniższego linka.  \r\n            Prosimy o pomoc w usprawnieniu funkcjonalności w nowych wersjach.           \r\n        </p>         \r\n        <p> \r\n            <a href=\\"<?=SP_SUPPORT_LINK?>\\" target=\\"_blank\\">Otwórz link aby raportować błąd</a> \r\n        </p> \r\n        <br> \r\n    </li>     \r\n</ul> \r\n</fieldset>', '2010-10-25 06:38:20'),
(1252, 'pl', 'support', 'support_cont2', '<fieldset> \r\n<legend>Seo Panel Zasoby Online</legend> \r\n<ul class=\\"infobox\\"> \r\n         \r\n    <li> \r\n        <h1>Pomoc Użytkownika Seo Panel</h1>  \r\n        <p> \r\n            Dokumentacja Seo Panel jest dostępna na <a href=\\"<?=SP_HELP_LINK?>\\" target=\\"_blank\\"> w\r\n<b>Pomocy Użytkownika</b></a>, zawiera ona <b>dokumentację</b> Narzędzi Seo Panel, plugin\\''ów , i funkcjonalności. \r\n            <br>To jest najlepsze miejsce w internecie aby <b>znaleźć pomoc</b> o Seo Panel. mamy nadzieję że pomożesz \r\n<b>udoskonalić</b> Pomoc Użytkownika, jeśli znajdziesz jakiś błąd lub brak czegoś.                 \r\n        </p> \r\n        <p> \r\n            <a href=\\"<?=SP_HELP_LINK?>\\" target=\\"_blank\\">Zobacz Pomoc Użytkownika Seo Panel</a> \r\n        </p> \r\n        <br> \r\n    </li>     \r\n    <li> \r\n        <h1>Forum Seo Panel</h1>  \r\n        <p> \r\n            To miejsce do dyskusji o pierwszym na świecie opensource\\''owym <b> panelem kontrolym seo</b>.  \r\n            To najlepsze miejsce by znaleźć <b>odpowiedź</b> na <b>Twoje pytania</b> o Seo Panel.  \r\n            <br>Możesz także <b>dzielić się</b> twoim <b>doświadczeniem</b> z użytkowanie Seo Panel do optymalizacji twoich Stron.                                \r\n        </p>         \r\n        <p> \r\n            <a href=\\"<?=SP_FORUM_LINK?>\\" target=\\"_blank\\">Odwiedź forum Seo Panel</a> \r\n        </p> \r\n        <br> \r\n    </li> \r\n</ul>     \r\n</fieldset>', '2010-10-25 06:38:20'),
(1253, 'pl', 'support', 'support_cont3', '<fieldset> \r\n<legend>Złóż donację dla Seo Panel</legend> \r\n<ul class=\\"infobox\\">         \r\n    <li> \r\n        <h1>Złóż donację dla Seo Panel - Pierwszy na świecie Open source\\''owy panel kontrolny seo</h1>  \r\n        <p> \r\n            <b>Złóż donację</b> dla Seo Panel aby wesprzeć pierwszy na świecie open source\\''owy panel kontrolny seo. \r\n            Planujemy <b>zwiększać i ulepszać</b> funkcjonalość Seo Panel w przyszłości.  \r\n            <br>Tylko z Twoim <b>wsparciem</b> możemy osiągnąć nasz <b>cel</b>. \r\n            Jeżeli uważasz że Seo Panel jest dla Ciebie <b>cenny</b>, prosimy o donację jakiejkolwiek kwoty dla Seo Panel. \r\n            <br>W zamian <b>opublikujemy</b> Twoje Nazwisko i adres twojej strony na <a href=\\"<?=SP_DONATE_LINK?>\\"\r\ntarget=\\"_blank\\">stronie donacji</a>, jak tylko otrzymamy donację. \r\n        </p> \r\n        <p> \r\n            <a href=\\"<?=SP_DONATE_LINK?>\\" target=\\"_blank\\">Otwórz tą linkę i złóż donację dla Seo Panel</a> \r\n        </p> \r\n        <br> \r\n    </li> \r\n</ul> \r\n</fieldset>', '2010-10-25 06:38:20'),
(1254, 'pl', 'sitemap', 'Change frequency', 'Zmień częstotliwość', '2010-10-09 06:26:35'),
(1255, 'pl', 'sitemap', 'clickproceedsitemap', 'Kliknij na <b>Proceed</b> aby utworzyć mapę Strony', '2010-10-09 06:26:35'),
(1256, 'pl', 'sitemap', 'Download sitemap file from', 'Ściągnij mapę Strony', '2010-10-09 06:26:35'),
(1257, 'pl', 'sitemap', 'Exclude Url', 'Wyklucz Url', '2010-10-09 06:26:35'),
(1258, 'pl', 'sitemap', 'processtaketime', 'Ten proces może trochę potrwać w zależności od ilości linków na Twojej stronie. Proszę czekać aż mapa zostanie wygenerowana.', '2010-10-09 06:26:35'),
(1259, 'pl', 'sitemap', 'Sitemap Type', 'Typ mapy Strony', '2010-10-09 06:26:35'),
(1260, 'pl', 'login', 'Confirm Password', 'Potwierdź hasło', '2014-01-17 19:04:15'),
(1261, 'pl', 'login', 'Create my account', 'Utwórz moje konto', '2014-01-17 19:04:15'),
(1262, 'pl', 'login', 'Create New Account', 'Utwórz nowe konto', '2014-01-17 19:04:15'),
(1263, 'pl', 'login', 'Email', 'Email', '2014-01-17 19:04:15'),
(1264, 'pl', 'login', 'emailexist', 'Ten email jest już używany!', '2014-01-17 19:04:15'),
(1265, 'pl', 'login', 'Enter the code as it is shown', 'Wprowadź kod', '2014-01-17 19:04:15'),
(1266, 'pl', 'login', 'First Name', 'Imię', '2014-01-17 19:04:15'),
(1267, 'pl', 'login', 'Last Name', 'Nazwisko', '2014-01-17 19:04:15'),
(1268, 'pl', 'login', 'Login', 'Login', '2014-01-17 19:04:15'),
(1269, 'pl', 'login', 'Login incorrect', 'Błędny login', '2014-01-17 19:04:15'),
(1270, 'pl', 'login', 'newaccountsuccess', 'Nowe konto zostało utworzone', '2014-01-17 19:04:15'),
(1271, 'pl', 'login', 'Password', 'Hasło', '2014-01-17 19:04:15'),
(1272, 'pl', 'login', 'Password incorrect', 'Błędne hasło', '2014-01-17 19:04:15'),
(1273, 'pl', 'login', 'Register', 'Rejestruj', '2014-01-17 19:04:15'),
(1274, 'pl', 'login', 'Sign in to your account', 'Zaloguj się na swoje konto', '2014-01-17 19:04:15'),
(1275, 'pl', 'login', 'User inactive', 'Użytkownik nie jest aktywny', '2014-01-17 19:04:15'),
(1276, 'pl', 'login', 'Username', 'Użytkownik', '2014-01-17 19:04:15'),
(1277, 'pl', 'login', 'usernameexist', 'Użytkownik o tej nazwie juz istnieje!', '2014-01-17 19:04:15'),
(1278, 'pl', 'label', 'already exist', 'już istnieje', '2014-05-11 20:04:08'),
(1279, 'pl', 'label', 'Authentication', 'Autentykacja', '2014-05-11 20:04:08'),
(1280, 'pl', 'label', 'Author', 'Autor', '2014-05-11 20:04:08'),
(1281, 'pl', 'label', 'Click Here', 'Kliknij tutaj', '2014-05-11 20:04:08'),
(1282, 'pl', 'label', 'Cron', 'Cron', '2014-05-11 20:04:08'),
(1283, 'pl', 'label', 'Description', 'Opis', '2014-05-11 20:04:08'),
(1284, 'pl', 'label', 'Developers', 'Deweloperzy', '2014-05-11 20:04:08'),
(1285, 'pl', 'label', 'Download', 'Download', '2014-05-11 20:04:08'),
(1286, 'pl', 'label', 'Installation', 'Instalacja', '2014-05-11 20:04:08'),
(1287, 'pl', 'label', 'Keywords', 'Keywordy', '2014-05-11 20:04:08'),
(1288, 'pl', 'label', 'noactiveplugins', 'Nie znaleziono aktywnych pluginów!', '2014-05-11 20:04:08'),
(1289, 'pl', 'label', 'Plugin', 'Plugin', '2014-05-11 20:04:08'),
(1290, 'pl', 'label', 'Port', 'Port', '2014-05-11 20:04:08'),
(1291, 'pl', 'label', 'Proxy', 'Proxy', '2014-05-11 20:04:08'),
(1292, 'pl', 'label', 'Re-install', 'Przeinstaluj', '2014-05-11 20:04:08'),
(1293, 'pl', 'label', 'Sponsors', 'Sponsorzy', '2014-05-11 20:04:08'),
(1294, 'pl', 'label', 'Title', 'Tytuł', '2014-05-11 20:04:08'),
(1295, 'pl', 'label', 'translation by', 'przetłumaczone przez', '2014-05-11 20:04:08'),
(1296, 'pl', 'label', 'Translators', 'Tłumaczenie', '2014-05-11 20:04:08'),
(1297, 'pl', 'label', 'Upgrade', 'Upgrade', '2014-05-11 20:04:08'),
(1298, 'pl', 'label', 'Version', 'Wersja', '2014-05-11 20:04:08'),
(1299, 'pl', 'label', 'wantproceed', 'Czy na pewno chcesz kontynuować?', '2014-05-11 20:04:08'),
(1300, 'pl', 'button', 'Cancel', 'Anuluj', '2014-01-17 18:41:10'),
(1301, 'pl', 'button', 'Check Status', 'Sprawdź status', '2014-01-17 18:41:10'),
(1302, 'pl', 'button', 'Proceed', 'Kontynuuj', '2014-01-17 18:41:10'),
(1303, 'pl', 'button', 'Reload', 'Odśwież', '2014-01-17 18:41:10'),
(1304, 'pl', 'button', 'Show Details', 'Pokaż właściwości', '2014-01-17 18:41:10'),
(1305, 'pl', 'button', 'Show Records', 'Pokaż Rekordy', '2014-01-17 18:41:10'),
(1306, 'pl', 'button', 'Skip', 'Pomiń', '2014-01-17 18:41:10'),
(1307, 'pl', 'button', 'Submit', 'Submituj', '2014-01-17 18:41:10'),
(1308, 'pl', 'common', 'Action', 'Akcja', '2014-01-17 18:46:42'),
(1309, 'pl', 'common', 'Activate', 'Aktywuj', '2014-01-17 18:46:42'),
(1310, 'pl', 'common', 'Active', 'Aktywna', '2014-01-17 18:46:42'),
(1311, 'pl', 'common', 'Admin Panel', 'Admin Panel', '2014-01-17 18:46:42'),
(1312, 'pl', 'common', 'Alexa Rank', 'Alexa Rank', '2014-01-17 18:46:42'),
(1313, 'pl', 'common', 'All', 'Wszystko', '2014-01-17 18:46:42'),
(1314, 'pl', 'common', 'Category', 'Kategoria', '2014-01-17 18:46:42'),
(1315, 'pl', 'common', 'contact', 'Kontakt', '2014-01-17 18:46:42'),
(1316, 'pl', 'common', 'copyright', 'Copyright © [year] www.seopanel.in Wszelkie prawa zastrzeżone', '2014-01-17 18:46:42'),
(1317, 'pl', 'common', 'Country', 'Kraj', '2014-01-17 18:46:42'),
(1318, 'pl', 'common', 'Crawl Meta Data', 'Pobierz dane Meta', '2014-01-17 18:46:42'),
(1319, 'pl', 'common', 'Date', 'Data', '2014-01-17 18:46:42'),
(1320, 'pl', 'common', 'Delete', 'Usuń', '2014-01-17 18:46:42'),
(1321, 'pl', 'common', 'Details', 'Szczegóły', '2014-01-17 18:46:42'),
(1322, 'pl', 'common', 'Directory', 'Folder', '2014-01-17 18:46:42'),
(1323, 'pl', 'common', 'Donate', 'Złóż donację', '2014-01-17 18:46:42'),
(1324, 'pl', 'common', 'Edit', 'Edytuj', '2014-01-17 18:46:42'),
(1325, 'pl', 'common', 'Entry cannot be blank', 'Pole nie może być puste', '2014-01-17 18:46:42'),
(1326, 'pl', 'common', 'entrynotvalid', 'Nieprawidłowa zawartość', '2014-01-17 18:46:42'),
(1327, 'pl', 'common', 'failed', 'nie powiodło się', '2014-01-17 18:46:42'),
(1328, 'pl', 'common', 'forum', 'Forum', '2014-01-17 18:46:42'),
(1329, 'pl', 'common', 'Found', 'Znaleziono', '2014-01-17 18:46:42'),
(1330, 'pl', 'common', 'Google Pagerank', 'Google Pagerank', '2014-01-17 18:46:42'),
(1331, 'pl', 'common', 'help', 'Pomoc', '2014-01-17 18:46:42'),
(1332, 'pl', 'common', 'hidenews', 'Ukryj wiadomości Seo Panel', '2014-01-17 18:46:42'),
(1333, 'pl', 'common', 'Id', 'Id', '2014-01-17 18:46:42'),
(1334, 'pl', 'common', 'Inactivate', 'Deaktywuj', '2014-01-17 18:46:42'),
(1335, 'pl', 'common', 'Inactive', 'Nie aktywne', '2014-01-17 18:46:42'),
(1336, 'pl', 'common', 'Invalid characters', 'Nieprawidłowe znaki', '2014-01-17 18:46:42'),
(1337, 'pl', 'common', 'Invalid code entered', 'Nieprawidłowy kod', '2014-01-17 18:46:42'),
(1338, 'pl', 'common', 'Invalid email address entered', 'Nieprawidłowy adres email', '2014-01-17 18:46:42'),
(1339, 'pl', 'common', 'Invalid value', 'Nieprawidłowa wartość', '2014-01-17 18:46:42'),
(1340, 'pl', 'common', 'Keyword', 'Słowo kluczowe', '2014-01-17 18:46:42'),
(1341, 'pl', 'common', 'Keywords', 'Słowa kluczowe', '2014-01-17 18:46:42'),
(1342, 'pl', 'common', 'lang', 'Język', '2014-01-17 18:46:42'),
(1343, 'pl', 'common', 'My Account', 'Moje Konto', '2014-01-17 18:46:42'),
(1344, 'pl', 'common', 'Name', 'Imię', '2014-01-17 18:46:42'),
(1345, 'pl', 'common', 'No', 'Nie', '2014-01-17 18:46:42'),
(1346, 'pl', 'common', 'No Keywords Found', 'Nie znaleziono Keyword''ów', '2014-01-17 18:46:42'),
(1347, 'pl', 'common', 'No Records Found', 'Nie znaleziono rekordów', '2014-01-17 18:46:42'),
(1348, 'pl', 'common', 'noactivetools', 'Nie znaleziono aktywnych Narzędzi Seo Panel', '2014-01-17 18:46:42'),
(1349, 'pl', 'common', 'nowebsites', 'Nie znaleziono żadnych Stron', '2014-01-17 18:46:42'),
(1350, 'pl', 'common', 'password632', 'Hasło powinno mieć 6 do 32 znaków długości', '2014-01-17 18:46:42'),
(1351, 'pl', 'common', 'passwordnotmatch', 'Hasła nie są identyczne', '2014-01-17 18:46:42'),
(1352, 'pl', 'common', 'Period', 'Okres', '2014-01-17 18:46:42'),
(1353, 'pl', 'common', 'Priority', 'Priorytet', '2014-01-17 18:46:42'),
(1354, 'pl', 'common', 'Rank', 'Rank', '2014-01-17 18:46:42'),
(1355, 'pl', 'common', 'Reports', 'Raporty', '2014-01-17 18:46:42'),
(1356, 'pl', 'common', 'Results', 'Rezultaty', '2014-01-17 18:46:42'),
(1357, 'pl', 'common', 'Search Engine', 'Wyszukiwarka', '2014-01-17 18:46:42'),
(1358, 'pl', 'common', 'Select', 'Wybierz', '2014-01-17 18:46:42'),
(1359, 'pl', 'common', 'Seo Plugins', 'Pluginy Seo', '2014-01-17 18:46:42'),
(1360, 'pl', 'common', 'Seo Tools', 'Narzędzia Seo', '2014-01-17 18:46:42'),
(1361, 'pl', 'common', 'Sign out', 'Wyloguj się', '2014-01-17 18:46:42'),
(1362, 'pl', 'common', 'Sign Up', 'Zarejestruj się', '2014-01-17 18:46:42'),
(1363, 'pl', 'common', 'signin', 'Zaloguj się', '2014-01-17 18:46:42'),
(1364, 'pl', 'common', 'Status', 'Status', '2014-01-17 18:46:42'),
(1365, 'pl', 'common', 'Support', 'Wsparcie', '2014-01-17 18:46:42'),
(1366, 'pl', 'common', 'Total', 'Suma', '2014-01-17 18:46:42'),
(1367, 'pl', 'common', 'Url', 'Url', '2014-01-17 18:46:42'),
(1368, 'pl', 'common', 'User', 'Użytkownik', '2014-01-17 18:46:42'),
(1369, 'pl', 'common', 'User Panel', 'Panel Użytkownika', '2014-01-17 18:46:42'),
(1370, 'pl', 'common', 'Website', 'Strona', '2014-01-17 18:46:42'),
(1371, 'pl', 'common', 'Yes', 'Tak', '2014-01-17 18:46:42'),
(1372, 'pl', 'directory', 'Add back to directory list', 'Dodaj z powrotem do listy Katalogów', '2014-01-17 18:50:38'),
(1373, 'pl', 'directory', 'Approved', 'Zatwierdzono', '2014-01-17 18:50:38'),
(1374, 'pl', 'directory', 'Captcha', 'Captcha', '2014-01-17 18:50:38'),
(1375, 'pl', 'directory', 'categorynote', 'Kategorie, oddziel je przecinkiem według priorytetu. Zacznij od Kategorii o najwyższym priorytecie.', '2014-01-17 18:50:38'),
(1376, 'pl', 'directory', 'Check Directory Status', 'Sprawdź status Katalogu', '2014-01-17 18:50:38'),
(1377, 'pl', 'directory', 'Check Directory Submission Status', 'Sprawdź status submisji do Katalogu', '2014-01-17 18:50:38'),
(1378, 'pl', 'directory', 'clicktoproceeddirsts', 'Kliknij <b>Proceed</b> aby sprawdzić status Katalogu', '2014-01-17 18:50:38'),
(1379, 'pl', 'directory', 'Confirmation', 'Potwierdzenie', '2014-01-17 18:50:38'),
(1380, 'pl', 'directory', 'desnote', 'Niektóre katalogi wymagają minimum 150 znaków w opisie Strony', '2014-01-17 18:50:38'),
(1381, 'pl', 'directory', 'Directories with out captcha', 'Katalogi bez Captcha', '2014-01-17 18:50:38'),
(1382, 'pl', 'directory', 'Directory Submission Reports', 'Raport submisji do Katalogów', '2014-01-17 18:50:38'),
(1383, 'pl', 'directory', 'Enter the code shown', 'Wprowadź kod', '2014-01-17 18:50:38'),
(1384, 'pl', 'directory', 'nocatnote', 'Kategoria submisji nie została znaleziona na stronie submisji. Kliknij na <b>Przeładuj</b> lub <b>Pomiń</b>', '2014-01-17 18:50:38'),
(1385, 'pl', 'directory', 'nodirnote', 'Nie znaleziono <b>Aktywnych</b> Katalogów', '2014-01-17 18:50:38'),
(1386, 'pl', 'directory', 'nosuccessnote', 'Nie otrzymano potwierdzenia. Proszę sprawdzić twój email by znaleźć wiadomość potwierdzającą.', '2014-01-17 18:50:38'),
(1387, 'pl', 'directory', 'optionalnote', 'Opcjonalne tytuły i opisy aby submitować Stronę z róźnymi tytułami i opisami do Katalogów aby uzyskać lepsze rezultaty.', '2014-01-17 18:50:38'),
(1388, 'pl', 'directory', 'Owner Email', 'Email właściciela', '2014-01-17 18:50:38'),
(1389, 'pl', 'directory', 'Owner Name', 'Imię właściciela', '2014-01-17 18:50:38'),
(1390, 'pl', 'directory', 'Pending', 'Oczekuje', '2014-01-17 18:50:38'),
(1391, 'pl', 'directory', 'Please select a website to proceed', 'Proszę wybrać Stronę aby kontynuować', '2014-01-17 18:50:38'),
(1392, 'pl', 'directory', 'selectwebsiteproceed', 'Wybierz <b>Stronę</b> aby <b>Kontunuować</b> submitowanie. <br>Zaznacz <b>Katalogi bez Captcha</b> aby submitować do Katalogów nie wymagających Captcha w trakcie submisji.', '2014-01-17 18:50:38'),
(1393, 'pl', 'directory', 'selectwebsiteschecksub', 'Wybierz  <b>Stronę</b> aby <b>Kontynuować</b> sprawdzanie statusu submisji do Katalogów.', '2014-01-17 18:50:38'),
(1394, 'pl', 'directory', 'Semi Automatic Directory Submission Tool', 'Narzędzie do półautomatycznej submisji Strony do Katalogów', '2014-01-17 18:50:38'),
(1395, 'pl', 'directory', 'spamemailnote', 'Niektóre Katalogi mogą wysyłać spam, zalecamy nie używać swojego głównego adresu email.', '2014-01-17 18:50:38'),
(1396, 'pl', 'directory', 'Submission Details', 'Detale Submisji', '2014-01-17 18:50:38'),
(1397, 'pl', 'directory', 'Submit Description', 'Submituj Opis', '2014-01-17 18:50:38'),
(1398, 'pl', 'directory', 'Submit Keywords', 'Submituj Keyword''y', '2014-01-17 18:50:38'),
(1399, 'pl', 'directory', 'Submit Title', 'Submituj Tytuł', '2014-01-17 18:50:38'),
(1400, 'pl', 'directory', 'Website Category', 'Kategoria Strony', '2014-01-17 18:50:38'),
(1401, 'pl', 'directory', 'Website Url', 'Url Strony', '2014-01-17 18:50:38'),
(1402, 'pl', 'home', 'Account Summary', 'Informacja o Koncie', '2014-01-17 19:53:11'),
(1403, 'pl', 'home', 'Backlinks', 'Backlinki', '2014-01-17 19:53:11'),
(1404, 'pl', 'home', 'Directory Submission', 'Submisja do Katalogu', '2014-01-17 19:53:11'),
(1405, 'pl', 'home', 'home_cont1', '<h1 style="text-align: center;margin-bottom: 30px;font-size: 19px;">Witamy w Seo Panel - pierwszym na świecie panelu kontrolnym dla wielu Stron</h1> \r\n        <p> \r\n           Kompletne źródło <b> Seo Panel</b> do zarządzania <b>Optymalizacją dla Wyszukiwarek (Search Engine Optimization)</b> twoich Stron.  \r\n            Seo Panel jest to zbiór <b>Narzędzi Seo</b> włączając najnowsze narzędzia aby <b>zwiększyć kontrolę i wydajność</b> twoich Stron. \r\n            Jest to <b>darmowe narzędzie</b> rozpowszechniane na licencji <b>GNU GENERAL PUBLIC LICENSE</b>. \r\n            Główną funkcją Seo Panel jest <b>rozszerzalność</b> o nowe <a href="<?=SP_PLUGINSITE?>"\r\ntarget="_blank">pluginy Seo</a>. \r\n            Każdy może łatwo <b>tworzyć i instalować</b> pluginy do swojego Seo Panel.  \r\n        </p> \r\n        <p></p> \r\n        <p> \r\n            Jest to Open source''owe oprogramowanie <b>wydane w Styczniu 2010</b>. \r\n            W tym <b>krótkim okresie</b> czasu <b>tysiąc</b> of <b>web masterów</b> używają ten software do <b>optymalizowania</b> swoich Stron. \r\n            Uzyj Seo Panel dzisiaj i <b>ciesz</b> się pełną kontrolą Seo w jednym narzędziu</b>. \r\n        </p>', '2014-01-17 19:53:11'),
(1406, 'pl', 'home', 'home_cont2', '<fieldset> \r\n<legend>Główne fukcje Seo Panel <?=SP_INSTALLED?></legend> \r\n<ul class="infobox"> \r\n    <li>         \r\n        <h1>Narzędzie to automatycznej submisji Stron do Katalogów</h1> \r\n        <p> \r\n            Narzędzie to automatycznej submisji Stron do Katalogów pomaga nam <b>submitować Strony</b> do największych<b> darmowych i płatnych Katalogów</b>. \r\n            Możemy również <b>śledzić status</b> każdej submisji przez <b>okresowe sprawdzania statusów</b>. \r\n            <b>Manadżer Katalogów</b> pomoże nam sprawdzić czy dany <b>katalog jest aktywny</b> czy nie. \r\n        </p> \r\n    </li> \r\n    <li>         \r\n        <h1>Sprawdzenie pozycji słów kluczowych</h1> \r\n        <p> \r\n            Sprawdzenie pozycji keyword''ów  pozwoli znaleźć <b>pozycję w wyszukiwarkach</b> dla <b>zdefiniowanych Keyword''ów</b> dla twojej Strony. \r\n           W raportach możemy zobaczyć <b>dzienne pozycje</b> Keyword''ów w różnych wyszukiwarkach, <b>piękne wykresy</b> i <b> szczegółowe raporty</b>. \r\n        </p> \r\n    </li> \r\n    <li>         \r\n        <h1>Audytor Strony</h1> \r\n        <p>Audytor Strony sprawdzi <b>wszystkie składniki SEO</b> każdje strony i wygeneruje <b>dokładny raport</b> o każdje stronie. Pomoże nam również wygenerować mapy Strony <b>XML,HTML,TEXT</b> w formie plików gotowe do <b>submitowania</b> do wyszukiwarek.</p> \r\n    </li> \r\n    <li>         \r\n        <h1>Sprawdzanie Google Rank i Alexa Rank</h1> \r\n        <p> \r\n            Sprawdzacz Google Rank i Alexa Rank znajdzie <b>google pagerank</b> i <b>alexa rank</b> naszych stron i <b>zapisze</b> je w systemie. \r\n            W sekcji <b>Raport rankingów</b>, możemy zobaczyć <b>dzienne</b> rankingi google i alexa rank każdej Strony w <b>szczegółowym raporcie</b>. \r\n        </p> \r\n    </li> \r\n    <li>         \r\n        <h1>Sprawdzanie linków zwrotnych</h1> \r\n        <p> \r\n            Sprawdzanie backlinków znajdzie <b>liczbę backlinków</b> w różnych wyszukiwarkach <b>(google,yahoo,msn itd.)</b> i <b>zapisuje</b> je w systemie. \r\n            <br>W sekcji <b>Sprawdzanie backlinków</b>, możemy zobaczyć <b>dzienne raporty</b> ze sprawdzania backlinkow każdej Strony <b>ze szczegółami</b>.\r\n        </p> \r\n    </li>     \r\n    <li>         \r\n        <h1>Sprawdzanie Nasycenia w Wyszukiwarkach</h1> \r\n        <p> \r\n            Sprawdzanie Nasycenia w Wyszukiwarkach znajdzie <b>liczbę zaindexowanych podstron</b> naszych Stron w różnych wyszukiwarkach <b>(google,yahoo,msn etc)</b> i <b>zapisze</b> je w systemie. \r\n            W sekcji <b>raport nasycenia w wyszukiwarkach</b> możemy zobaczyć <b>dzienną liczbę zaindeksowanych podstron</b> i <b>szczegółowy raport</b> o każdej Stronie. \r\n        </p> \r\n    </li> \r\n    <li>         \r\n        <h1>Pluginy Seo Panel</h1> \r\n        <p> \r\n            <b>Główną funkcjonalnością</b> Seo Panel jest <b>rozszerzalność</b>. \r\n            Dodaj <b>pluginy Seo</b> do twojego Seo Panel aby <b>rozszerzyć funkcjonalność</b> według twoich potrzeb.\r\n            <a href="<?=SP_PLUGINSITE?>" target="_blank">Pluginy Seo Panel</a> są dostarczane przez Seo Panel oraz źródła zewnętrzne. \r\n            Możesz łatwo <b>tworzyć</b> pluginy Seo dla swojego Seo Panel. \r\n            możesz <a href="<?=SP_PLUGINSITE?>" target="_blank">submitować</a> twoje pluginy do Seo Panel a my je <b>opublikujemy</b> na naszej stronie po uprzednim <b>sprawdzeniu</b>. \r\n        </p> \r\n    </li> \r\n    <li>         \r\n        <h1>Generator tagów Meta</h1> \r\n        <p> \r\n            Generator tagów Meta jest także <b>pluginem Seo</b> do generowania <b>własnych tagów Metas</b> na naszą Stronę. \r\n           Pomoże nam to dać <b>więcej informacji</b> o naszej Stronie dla <b>robotów wyszukiwarek</b>\r\npodczas indeksowanie Strony. \r\n        </p> \r\n    </li> \r\n</ul> \r\n</fieldset>', '2014-01-17 19:53:11'),
(1407, 'pl', 'home', 'home_cont3', '<fieldset> \r\n<legend>Zasoby online dla Seo Panel</legend>     \r\n<ul class="infobox"> \r\n\r\n    <li> \r\n        <h1>Zasoby online dla Seo Panel dla szybkiej referencji</h1>                 \r\n         \r\n         \r\n        <p> \r\n            <a href="http://www.seopanel.in" target="_blank">Oficjalna strona Seo Panel</a> \r\n        </p> \r\n        <p> \r\n            <a href="<?=SP_DOWNLOAD_LINK?>" target="_blank">Sciągnij Seo Panel</a> \r\n        </p> \r\n         \r\n        <p> \r\n            <a href="<?=SP_DEMO_LINK?>" target="_blank">Demo Seo Panel</a> \r\n        </p> \r\n         \r\n        <p> \r\n            <a href="<?=SP_CONTACT_LINK?>" target="_blank">Skontaktuj się z Seo Panel</a> \r\n        </p> \r\n         \r\n        <p> \r\n            <a href="<?=SP_HELP_LINK?>" target="_blank">Pomoc Użytkownika Seo Panel</a> \r\n        </p> \r\n         \r\n        <p> \r\n            <a href="<?=SP_FORUM_LINK?>" target="_blank">Forum Seo Panel</a> \r\n        </p> \r\n         \r\n        <p> \r\n            <a href="<?=SP_SUPPORT_LINK?>" target="_blank">System Wsparcia Seo Panel</a> \r\n        </p> \r\n         \r\n        <p> \r\n            <a href="<?=SP_DONATE_LINK?>" target="_blank">Złóż donację dla Seo Panel</a> \r\n        </p> \r\n    </li> \r\n     \r\n</ul> \r\n</fieldset>', '2014-01-17 19:53:11'),
(1408, 'pl', 'home', 'Pages Indexed', 'Zaindexowane Strony', '2014-01-17 19:53:11'),
(1409, 'pl', 'home', 'Ranks', 'Ranking', '2014-01-17 19:53:11'),
(1410, 'pl', 'home', 'SiteNameUrl', 'Nazwa Strony/Url', '2014-01-17 19:53:11'),
(1411, 'pl', 'home', 'Website Statistics', 'Statystyki Strony', '2014-01-17 19:53:11'),
(1412, 'pl', 'keyword', 'Crawling keyword', 'Indeksowanie Keyword''u', '2014-01-17 18:54:55'),
(1413, 'pl', 'keyword', 'Detailed Keyword Position Reports', 'Szczegółowy Raport o Pozycji Keyword''u', '2014-01-17 18:54:55'),
(1414, 'pl', 'keyword', 'Edit Keyword', 'Edytuj Keyword', '2014-01-17 18:54:55');
INSERT INTO `texts` (`id`, `lang_code`, `category`, `label`, `content`, `changed`) VALUES
(1415, 'pl', 'keyword', 'Graphical Keyword Position Reports', 'Wykres Pozycji Keyword''u', '2014-01-17 18:54:55'),
(1416, 'pl', 'keyword', 'Import Keywords', 'Importuj Keyword''y', '2014-01-17 18:54:55'),
(1417, 'pl', 'keyword', 'Keyword already exist', 'Keyword już istnieje', '2014-01-17 18:54:55'),
(1418, 'pl', 'keyword', 'Keyword Position Report', 'Raport o Pozycji Keyword''u', '2014-01-17 18:54:55'),
(1419, 'pl', 'keyword', 'New Keyword', 'Nowy Keyword', '2014-01-17 18:54:55'),
(1420, 'pl', 'keyword', 'not assigned to required search engines', 'nie przypisane do wymaganych wyszukiwarek', '2014-01-17 18:54:55'),
(1421, 'pl', 'keyword', 'pleaseselecttool', 'Proszę wybrać co najmniej jedno Narzędzie Seo', '2014-01-17 18:54:55'),
(1422, 'pl', 'keyword', 'Quick Keyword Position Checker', 'Szybkie Sprawdzenie Pozycji Keyword''u', '2014-01-17 18:54:55'),
(1423, 'pl', 'keyword', 'results from ', 'rezultaty z', '2014-01-17 18:54:55'),
(1424, 'pl', 'keyword', 'Show All results', 'Pokaż wszystkie rezultaty', '2014-01-17 18:54:55'),
(1425, 'pl', 'keyword', 'Successfully crawled keyword', 'Keyword zaindeksowany pomyślnie', '2014-01-17 18:54:55'),
(1426, 'pl', 'keyword', 'to create new keywords', 'aby utworzyć nowe Keyword''y', '2014-01-17 18:54:55'),
(1427, 'pl', 'panel', 'About Us', 'O Nas', '2014-05-11 19:55:16'),
(1428, 'pl', 'panel', 'Add following command to your cron tab', 'Dodaj Komendę to zakładki Cron', '2014-05-11 19:55:16'),
(1429, 'pl', 'panel', 'alsocheckfollowlink', 'Sprawdź link jeśli chcesz więcej szczegółów', '2014-05-11 19:55:16'),
(1430, 'pl', 'panel', 'Check Directory', 'Sprawdź Katalog', '2014-05-11 19:55:16'),
(1431, 'pl', 'panel', 'Cron Command', 'Komenda Cron', '2014-05-11 19:55:16'),
(1432, 'pl', 'panel', 'Directory Manager', 'Manadżer Katalogów', '2014-05-11 19:55:16'),
(1433, 'pl', 'panel', 'Edit My Profile', 'Edytuj Profil', '2014-05-11 19:55:16'),
(1434, 'pl', 'panel', 'My Profile', 'Mój Profil', '2014-05-11 19:55:16'),
(1435, 'pl', 'panel', 'New Proxy', 'Nowe Proxy', '2014-05-11 19:55:16'),
(1436, 'pl', 'panel', 'New User', 'Nowy Użytkownik', '2014-05-11 19:55:16'),
(1437, 'pl', 'panel', 'New Website', 'Nowa Strona', '2014-05-11 19:55:16'),
(1438, 'pl', 'panel', 'Proxy Manager', 'Manadżer Proxy', '2014-05-11 19:55:16'),
(1439, 'pl', 'panel', 'Report Generation Manager', 'Manadżer Generowania Raportów', '2014-05-11 19:55:16'),
(1440, 'pl', 'panel', 'Reports Manager', 'Manadżer Raportów', '2014-05-11 19:55:16'),
(1441, 'pl', 'panel', 'Seo Plugins Manager', 'Manadżer Pluginów Seo', '2014-05-11 19:55:16'),
(1442, 'pl', 'panel', 'Seo Tools Manager', 'Manadżer Narzędzi Seo', '2014-05-11 19:55:16'),
(1443, 'pl', 'panel', 'System Settings', 'Ustawienia Systemu', '2014-05-11 19:55:16'),
(1444, 'pl', 'panel', 'User Manager', 'Manadżer Użytkowników', '2014-05-11 19:55:16'),
(1445, 'pl', 'panel', 'Website Manager', 'Manadżer Stron', '2014-05-11 19:55:16'),
(1446, 'pl', 'plugin', 'Edit Seo Plugin', 'Edytuj Plugin Seo', '2014-01-17 19:06:52'),
(1447, 'pl', 'plugin', 'Plugin Name', 'Nazwa Pluginu', '2014-01-17 19:06:52'),
(1448, 'pl', 'plugin', 'Seo Plugin Details', 'Szczegóły Pluginu Seo', '2014-01-17 19:06:52'),
(1449, 'pl', 'proxy', 'Edit Proxy', 'Edytuj Proxy', '2014-05-11 19:50:59'),
(1450, 'pl', 'proxy', 'Proxy Password', 'Hasło Proxy', '2014-05-11 19:50:59'),
(1451, 'pl', 'proxy', 'Proxy Username', 'Nazwa Użytkownika Proxy', '2014-05-11 19:50:59'),
(1452, 'pl', 'proxy', 'Proxyalreadyexist', 'Takie Proxy już istnieje', '2014-05-11 19:50:59'),
(1453, 'pl', 'rank', 'enterurlproceed', 'Wprowadź adresy Url <b>Jeden adres na linię</b> Kliknij <b>Kontynuuj</b> by sprawdzić Google Rank i Alexa Rank', '2010-10-09 07:33:20'),
(1454, 'pl', 'rank', 'Google and Alexa Rank Reports', 'raporty Google Rank i Alexa Rank', '2010-10-09 07:33:20'),
(1455, 'pl', 'rank', 'Saved rank results of', 'Zapisane rezultaty', '2010-10-09 07:33:20'),
(1456, 'pl', 'saturation', 'clickproceedsaturation', 'Wprowadź adresy Url <b>Jeden adres na linię</b> Kliknij <b>Kontynuuj</b> by sprawdzić Nasycenie w Wyszukiwarkach (Search Engine Saturation Results)', '2010-10-09 07:36:19'),
(1457, 'pl', 'saturation', 'GenerateSaturationReports', 'Generuj raport Nasycenia w Wyszukiwarkach', '2010-10-09 07:36:19'),
(1458, 'pl', 'saturation', 'Quick Search Engine Saturation Checker', 'Szybkie Sprawdzenie Nasycenia w Wyszukiwarkach', '2010-10-09 07:36:19'),
(1459, 'pl', 'saturation', 'Saved Search Engine Saturation results of', 'Zapisane stany Nasycenia w Wyszukiwarkach', '2010-10-09 07:36:19'),
(1460, 'pl', 'saturation', 'Search Engine Saturation Reports', 'Raporty Nasycenia w Wyszukiwarkach', '2010-10-09 07:36:19'),
(1461, 'pl', 'seotools', 'Automatic Submission', 'Automatyczna submisja', '2014-01-17 19:15:54'),
(1462, 'pl', 'seotools', 'backlink-checker', 'Sprawdzanie backlinków', '2014-01-17 19:15:54'),
(1463, 'pl', 'seotools', 'Backlinks Reports', 'Raporty backlinków', '2014-01-17 19:15:54'),
(1464, 'pl', 'seotools', 'Check Submission Status', 'Sprawdź status submisji', '2014-01-17 19:15:54'),
(1465, 'pl', 'seotools', 'clickgeneratereports', 'Kliknij <b>Kontynuuj</b> aby wygenerować raport', '2014-01-17 19:15:54'),
(1466, 'pl', 'seotools', 'Detailed Position Reports', 'Szczegółowy raport o pozycji', '2014-01-17 19:15:54'),
(1467, 'pl', 'seotools', 'directory-submission', 'Submisja do katalogów', '2014-01-17 19:15:54'),
(1468, 'pl', 'seotools', 'Featured Submission', 'Zintegrowana submisja', '2014-01-17 19:15:54'),
(1469, 'pl', 'seotools', 'Generate Backlinks Reports', 'Generuj raport o backlink''ach', '2014-01-17 19:15:54'),
(1470, 'pl', 'seotools', 'Generate Keyword Reports', 'Generuj raport o keyword''ach', '2014-01-17 19:15:54'),
(1471, 'pl', 'seotools', 'Generate Rank Reports', 'Generuj raport o pozycjach w rankingach', '2014-01-17 19:15:54'),
(1472, 'pl', 'seotools', 'Generate Saturation Reports', 'Generuj raport o nasyceniu w Wyszukiwarkach', '2014-01-17 19:15:54'),
(1473, 'pl', 'seotools', 'Google Sitemap Generator', 'Generator Google map Strony ', '2014-01-17 19:15:54'),
(1474, 'pl', 'seotools', 'Graphical Position Reports', 'Wykres pozycji w rankingach', '2014-01-17 19:15:54'),
(1475, 'pl', 'seotools', 'Keyword Position Summary', 'Podsumowanie pozycji keyword''ów', '2014-01-17 19:15:54'),
(1476, 'pl', 'seotools', 'keyword-position-checker', 'Sprawdzenie pozycji keyword''ów', '2014-01-17 19:15:54'),
(1477, 'pl', 'seotools', 'Keywords Manager', 'Manadżer keyword''ów', '2014-01-17 19:15:54'),
(1478, 'pl', 'seotools', 'Quick Backlinks Checker', 'Szybkie sprawdzenie backlink''ów', '2014-01-17 19:15:54'),
(1479, 'pl', 'seotools', 'Quick Position Checker', 'Szybkie sprawdzenie pozycji ', '2014-01-17 19:15:54'),
(1480, 'pl', 'seotools', 'Quick Rank Checker', 'Szybkie sprawdzenie rankingów', '2014-01-17 19:15:54'),
(1481, 'pl', 'seotools', 'Quick Saturation Checker', 'Szybkie sprawdzenie nasycenia w wyszukiwarkach', '2014-01-17 19:15:54'),
(1482, 'pl', 'seotools', 'Rank Reports', 'Raport rankingów', '2014-01-17 19:15:54'),
(1483, 'pl', 'seotools', 'rank-checker', 'Sprawdzenie rankingów', '2014-01-17 19:15:54'),
(1484, 'pl', 'seotools', 'Saturation Reports', 'Raport nasycenia w wyszukiwarkach', '2014-01-17 19:15:54'),
(1485, 'pl', 'seotools', 'saturation-checker', 'Nasycenie w wyszukiwarkach', '2014-01-17 19:15:54'),
(1486, 'pl', 'seotools', 'sitemap-generator', 'Generator mapy Strony', '2014-01-17 19:15:54'),
(1487, 'pl', 'seotools', 'Skipped Directories', 'Pominięte katalogi', '2014-01-17 19:15:54'),
(1488, 'pl', 'seotools', 'Submission Reports', 'Raporty submisji', '2014-01-17 19:15:54'),
(1489, 'pl', 'seotools', 'User Access', 'Dostęp użytkowników', '2014-01-17 19:15:54'),
(1490, 'pl', 'settings', 'Click here to become a sponsor for Seo Panel', '<b>Złóż donację $100</b> i zostań <b>sponsorem</b> Seo Panel.', '2014-05-11 19:49:58'),
(1491, 'pl', 'settings', 'seopanel_description', 'Darmowy kompletny panel do zarządzania Optymalizacją Stron. Zawiera mnóstwo nowych Narzędzi Seo aby kontrolować wydajność twoich Stron. Jest to open source''owy software do którego łatwo możesz pisać własne pluginy Seo.', '2014-05-11 19:49:58'),
(1492, 'pl', 'settings', 'seopanel_title', 'Seo Panel: Pierwszy na świecie open source''owy panel do zarządzania wieloma Stronami', '2014-05-11 19:49:58'),
(1493, 'pl', 'settings', 'SP_CRAWL_DELAY', 'Opóźnienie między każdym indexowaniem robota (w sekundach)', '2014-05-11 19:49:58'),
(1494, 'pl', 'settings', 'SP_DEFAULTLANG', 'Domyślny język', '2014-05-11 19:49:58'),
(1495, 'pl', 'settings', 'SP_DESCRIPTION', 'Opis Seo Panel', '2014-05-11 19:49:58'),
(1496, 'pl', 'settings', 'SP_ENABLE_PROXY', 'Włącz Proxy', '2014-05-11 19:49:58'),
(1497, 'pl', 'settings', 'SP_HOTLINKING', 'Zabezpieczenie hotlinkowania obrazków włączone', '2014-05-11 19:49:58'),
(1498, 'pl', 'settings', 'SP_KEYWORDS', 'Słowa kluczowe Seo Panel', '2014-05-11 19:49:58'),
(1499, 'pl', 'settings', 'SP_PAGINGNO', 'Numer rekordów na stronie', '2014-05-11 19:49:58'),
(1500, 'pl', 'settings', 'SP_TITLE', 'Tytuł Seo Panel', '2014-05-11 19:49:58'),
(1501, 'pl', 'settings', 'SP_USER_GEN_REPORT', 'Pozwól użytkownikowi generować raporty', '2014-05-11 19:49:58'),
(1502, 'pl', 'settings', 'SP_USER_REGISTRATION', 'Interfejs rejestracji użytkownika', '2014-05-11 19:49:58'),
(1503, 'pl', 'settings', 'syssettingssaved', 'Ustawienia Systemu zapisane!', '2014-05-11 19:49:58'),
(1504, 'pl', 'backlink', 'clickproceedbacklink', 'Wprowadź adresy URL <b>każdy w osobnej linii</b>. Kliknij <b>Kontynuuj</b> by sprawdzić Backlinki.', '2014-01-17 18:40:05'),
(1505, 'pl', 'backlink', 'Saved backlink results of', 'Zapisane rezultaty backlink', '2014-01-17 18:40:05'),
(1506, 'hu', 'backlink', 'clickproceedbacklink', 'Soronként <b>Egy</b> weboldal címét írd be. Kattints az <b>Elküldésre</b> a Backlinkek ellenőrzéséhez.  	 ', '2010-10-10 23:45:36'),
(1507, 'hu', 'backlink', 'Saved backlink results of', 'Elmentett Backlinkek:', '2010-10-10 23:45:36'),
(1508, 'hu', 'button', 'Cancel', 'Vissza', '2014-01-08 19:27:48'),
(1509, 'hu', 'button', 'Check Status', 'Állapot ellenőrzése', '2014-01-08 19:27:48'),
(1510, 'hu', 'button', 'Proceed', 'Elküld', '2014-01-08 19:27:48'),
(1511, 'hu', 'button', 'Reload', 'Újra', '2014-01-08 19:27:48'),
(1512, 'hu', 'button', 'Show Details', 'Részletek mutatása', '2014-01-08 19:27:48'),
(1513, 'hu', 'button', 'Show Records', 'Mutasd', '2014-01-08 19:27:48'),
(1514, 'hu', 'button', 'Skip', 'Kihagyás', '2014-01-08 19:27:48'),
(1515, 'hu', 'button', 'Submit', 'Elküld', '2014-01-08 19:27:48'),
(1516, 'hu', 'common', 'Action', 'Művelet', '2013-02-05 19:22:36'),
(1517, 'hu', 'common', 'Activate', 'Aktivál', '2013-02-05 19:22:36'),
(1518, 'hu', 'common', 'Active', 'Aktív', '2013-02-05 19:22:36'),
(1519, 'hu', 'common', 'Admin Panel', 'Admin felület', '2013-02-05 19:22:36'),
(1520, 'hu', 'common', 'Alexa Rank', 'Alexa Rang', '2013-02-05 19:22:36'),
(1521, 'hu', 'common', 'All', 'Összes', '2013-02-05 19:22:36'),
(1522, 'hu', 'common', 'Category', 'Kategória', '2013-02-05 19:22:36'),
(1523, 'hu', 'common', 'contact', 'Kapcsolat', '2013-02-05 19:22:36'),
(1524, 'hu', 'common', 'copyright', 'Copyright © [year] www.seopanel.in Minden jog fenntartva!', '2013-02-05 19:22:36'),
(1525, 'hu', 'common', 'Country', 'Ország', '2013-02-05 19:22:36'),
(1526, 'hu', 'common', 'Crawl Meta Data', 'Meta Adatok Kiolvasása', '2013-02-05 19:22:36'),
(1527, 'hu', 'common', 'Date', 'Dátum', '2013-02-05 19:22:36'),
(1528, 'hu', 'common', 'Delete', 'Törlés', '2013-02-05 19:22:36'),
(1529, 'hu', 'common', 'Details', 'Részletek', '2013-02-05 19:22:36'),
(1530, 'hu', 'common', 'Directory', 'Katalógus', '2013-02-05 19:22:36'),
(1531, 'hu', 'common', 'Donate', 'Seo Panel Támogatása', '2013-02-05 19:22:36'),
(1532, 'hu', 'common', 'Edit', 'Szerkesztés', '2013-02-05 19:22:36'),
(1533, 'hu', 'common', 'Entry cannot be blank', 'Ez a mező nem maradhat üresen!', '2013-02-05 19:22:36'),
(1534, 'hu', 'common', 'entrynotvalid', 'A beírt adatok nem tűnnek valódinak', '2013-02-05 19:22:36'),
(1535, 'hu', 'common', 'failed', 'hiba', '2013-02-05 19:22:36'),
(1536, 'hu', 'common', 'forum', 'Fórum', '2013-02-05 19:22:36'),
(1537, 'hu', 'common', 'Found', 'Találat', '2013-02-05 19:22:36'),
(1538, 'hu', 'common', 'Google Pagerank', 'Google Pagerank', '2013-02-05 19:22:36'),
(1539, 'hu', 'common', 'help', 'Segítség', '2013-02-05 19:22:36'),
(1540, 'hu', 'common', 'hidenews', 'Seo Panel Hírek Elrejtése', '2013-02-05 19:22:36'),
(1541, 'hu', 'common', 'Id', 'Sorszám', '2013-02-05 19:22:36'),
(1542, 'hu', 'common', 'Inactivate', 'Inaktiválás', '2013-02-05 19:22:36'),
(1543, 'hu', 'common', 'Inactive', 'Inaktív', '2013-02-05 19:22:36'),
(1544, 'hu', 'common', 'Invalid characters', 'Érvénytelen Karakterek', '2013-02-05 19:22:36'),
(1545, 'hu', 'common', 'Invalid code entered', 'Hibás kódot írtál be', '2013-02-05 19:22:36'),
(1546, 'hu', 'common', 'Invalid email address entered', 'Hibás e-mail cím', '2013-02-05 19:22:36'),
(1547, 'hu', 'common', 'Invalid value', 'Érvénytelen érték', '2013-02-05 19:22:36'),
(1548, 'hu', 'common', 'Keyword', 'Kulcsszó', '2013-02-05 19:22:36'),
(1549, 'hu', 'common', 'Keywords', 'Kulcsszavak', '2013-02-05 19:22:36'),
(1550, 'hu', 'common', 'lang', 'Nyelv', '2013-02-05 19:22:36'),
(1551, 'hu', 'common', 'My Account', 'Fiókom', '2013-02-05 19:22:36'),
(1552, 'hu', 'common', 'Name', 'Név', '2013-02-05 19:22:36'),
(1553, 'hu', 'common', 'No', 'Nem', '2013-02-05 19:22:36'),
(1554, 'hu', 'common', 'No Keywords Found', 'Nem Találtunk Kulcsszót', '2013-02-05 19:22:36'),
(1555, 'hu', 'common', 'No Records Found', 'Nincs Találat', '2013-02-05 19:22:36'),
(1556, 'hu', 'common', 'noactivetools', 'Nem találtunk Aktív Seo eszközt!', '2013-02-05 19:22:36'),
(1557, 'hu', 'common', 'nowebsites', 'Nem Találtunk Weboldalt', '2013-02-05 19:22:36'),
(1558, 'hu', 'common', 'password632', 'A jelszónak minimum 6, maximum 32 karakteresnek kell lennie', '2013-02-05 19:22:36'),
(1559, 'hu', 'common', 'passwordnotmatch', 'A jelszavak nem egyeznek', '2013-02-05 19:22:36'),
(1560, 'hu', 'common', 'Period', 'Időszak', '2013-02-05 19:22:36'),
(1561, 'hu', 'common', 'Priority', 'Prioritás', '2013-02-05 19:22:36'),
(1562, 'hu', 'common', 'Rank', 'Rang', '2013-02-05 19:22:36'),
(1563, 'hu', 'common', 'Reports', 'Jelentések', '2013-02-05 19:22:36'),
(1564, 'hu', 'common', 'Results', 'Eredmények', '2013-02-05 19:22:36'),
(1565, 'hu', 'common', 'Search Engine', 'Keresőmotor', '2013-02-05 19:22:36'),
(1566, 'hu', 'common', 'Select', 'Választ', '2013-02-05 19:22:36'),
(1567, 'hu', 'common', 'Seo Plugins', 'Seo Beépülők', '2013-02-05 19:22:36'),
(1568, 'hu', 'common', 'Seo Tools', 'Seo Eszközök', '2013-02-05 19:22:36'),
(1569, 'hu', 'common', 'Sign out', 'Kilépés', '2013-02-05 19:22:36'),
(1570, 'hu', 'common', 'Sign Up', 'Regisztráció', '2013-02-05 19:22:36'),
(1571, 'hu', 'common', 'signin', 'Bejelentkezés', '2013-02-05 19:22:36'),
(1572, 'hu', 'common', 'Status', 'Állapot', '2013-02-05 19:22:36'),
(1573, 'hu', 'common', 'Support', 'Támogatás', '2013-02-05 19:22:36'),
(1574, 'hu', 'common', 'Total', 'Összesen', '2013-02-05 19:22:36'),
(1575, 'hu', 'common', 'Url', 'Url', '2013-02-05 19:22:36'),
(1576, 'hu', 'common', 'User', 'Felhasználó', '2013-02-05 19:22:36'),
(1577, 'hu', 'common', 'User Panel', 'Felhasználói Felület', '2013-02-05 19:22:36'),
(1578, 'hu', 'common', 'Website', 'Weboldal', '2013-02-05 19:22:36'),
(1579, 'hu', 'common', 'Yes', 'Igen', '2013-02-05 19:22:36'),
(1580, 'hu', 'directory', 'Add back to directory list', 'Visszahelyezés a katalóguslistába', '2013-02-05 19:23:52'),
(1581, 'hu', 'directory', 'Approved', 'Elfogadva', '2013-02-05 19:23:52'),
(1582, 'hu', 'directory', 'Captcha', 'Captcha', '2013-02-05 19:23:52'),
(1583, 'hu', 'directory', 'categorynote', 'Kategóriák, vesszővel elválasztva, fontossági sorrendbe. A legfontosabban kezd.', '2013-02-05 19:23:52'),
(1584, 'hu', 'directory', 'Check Directory Status', 'Katalógus Állapotának Ellenőrzése', '2013-02-05 19:23:52'),
(1585, 'hu', 'directory', 'Check Directory Submission Status', 'Katalógus Linkek állapota', '2013-02-05 19:23:52'),
(1586, 'hu', 'directory', 'clicktoproceeddirsts', 'Kattints az <b>Elküldésre</b> ahhoz, hogy ellenőrizd a katalógus állapotát.', '2013-02-05 19:23:52'),
(1587, 'hu', 'directory', 'Confirmation', 'Megerősítés', '2013-02-05 19:23:52'),
(1588, 'hu', 'directory', 'desnote', 'Néhány katalógusba minimum 150 karakteresnek kell lennie a leírásnak. ', '2013-02-05 19:23:52'),
(1589, 'hu', 'directory', 'Directories with out captcha', 'Katalógusok captcha nélkül', '2013-02-05 19:23:52'),
(1590, 'hu', 'directory', 'Directory Submission Reports', 'Jelentés a Linkbeküldésekről', '2013-02-05 19:23:52'),
(1591, 'hu', 'directory', 'Enter the code shown', 'Írd be az alábbi kódot', '2013-02-05 19:23:52'),
(1592, 'hu', 'directory', 'nocatnote', 'Az általad megadott kategóriát nem találtuk a katalógusba. Kérlek kattints az <b>Újra</b> vagy a <b>Tovább</b> feliratra  	 ', '2013-02-05 19:23:52'),
(1593, 'hu', 'directory', 'nodirnote', 'Nem találtunk <b>Aktív</b> katalógust', '2013-02-05 19:23:52'),
(1594, 'hu', 'directory', 'nosuccessnote', 'Ha nem jelenik meg a \\"sikeres beküldés\\" az ajánlás után, akkor ellenőrizd az e-mailjeidet, hogy nem kell-e aktiválni a linket.', '2013-02-05 19:23:52'),
(1595, 'hu', 'directory', 'optionalnote', 'További Cím és leírások melyek automatikusan cserélődni fognak minden linkbeküldésnél.', '2013-02-05 19:23:52'),
(1596, 'hu', 'directory', 'Owner Email', 'Kapcsolattartó E-mail címe', '2013-02-05 19:23:52'),
(1597, 'hu', 'directory', 'Owner Name', 'Kapcsolattartó Neve', '2013-02-05 19:23:52'),
(1598, 'hu', 'directory', 'Pending', 'Függőben', '2013-02-05 19:23:52'),
(1599, 'hu', 'directory', 'Please select a website to proceed', 'Kérlek válassz egy weboldalt elküldésre', '2013-02-05 19:23:52'),
(1600, 'hu', 'directory', 'selectwebsiteproceed', 'Válassz ki egy <b>Weboldalt</b> és kattints az <b>Elküldésre</b>.<br>Válaszd ki a  \\"<b>Katalógusok captcha nélkül</b>\\" opciót, hogy meggyorsítsd a linkbeküldést.', '2013-02-05 19:23:52'),
(1601, 'hu', 'directory', 'selectwebsiteschecksub', 'Válassz ki egy <b>Weboldalt</b> és kattints az <b>Elküldésre</b>.', '2013-02-05 19:23:52'),
(1602, 'hu', 'directory', 'Semi Automatic Directory Submission Tool', 'Félautomata Linkbeküldés', '2013-02-05 19:23:52'),
(1603, 'hu', 'directory', 'spamemailnote', 'Néhány katalógus küldhet spam leveleket, ezért ne a fő e-mail címünket használjuk. ', '2013-02-05 19:23:52'),
(1604, 'hu', 'directory', 'Submission Details', 'Linkbeküldése adatai', '2013-02-05 19:23:52'),
(1605, 'hu', 'directory', 'Submit Description', 'Leírás', '2013-02-05 19:23:52'),
(1606, 'hu', 'directory', 'Submit Keywords', 'Kulcsszavak', '2013-02-05 19:23:52'),
(1607, 'hu', 'directory', 'Submit Title', 'Cím', '2013-02-05 19:23:52'),
(1608, 'hu', 'directory', 'Website Category', 'Kategória', '2013-02-05 19:23:52'),
(1609, 'hu', 'directory', 'Website Url', 'URL', '2013-02-05 19:23:52'),
(1610, 'hu', 'home', 'Account Summary', 'Felhasználói Fiók', '2011-07-11 06:51:07'),
(1611, 'hu', 'home', 'Backlinks', 'Backlinkek', '2011-07-11 06:51:07'),
(1612, 'hu', 'home', 'Directory Submission', 'Linkbeküldés', '2011-07-11 06:51:07'),
(1613, 'hu', 'home', 'home_cont1', '<h1 style=\\"text-align: center;margin-bottom: 30px;font-size: 19px;\\">Üdvözöllek a Seo Panelben - A világ első nyílt forráskódú Seo Segédjében</h1> \r\n<p> \r\nEz egy teljesen <b>ingyenes</b> eszköz, mely nagy mértékben megkönnyíti a <b>keresőoptimalizálást</b>. Egyszerre több népszerű Seo eszközt foglal magában, hogy weblapjából a maximumot hozhassa ki. Nyílt forráskódú (GNU GENERAL PUBLIC LICENSE) ezért Ön is fejleszthet hozzá különböző kiegészítőket.\r\nLegfőbb tulajdonsága a <b>bővíthetőség</b>, mivel könnyedén bővíteni lehet <a href=\\"<?=SP_PLUGINSITE?>\\"\r\ntarget=\\"_blank\\">seo kiegészítőkkel</a>. \r\n</p>\r\n <p></p>\r\n <p> Ez az ingyenes software <b>2010 Januárjában</b> lett közzétéve. Azóta több <b>ezer</b> <b>webmester</b> használja világszerte.\r\n</p>', '2011-07-11 06:51:07'),
(1614, 'hu', 'home', 'home_cont2', '<fieldset>\r\n<legend>A Seo Panel legfőbb Tulajdonságai <?=SP_INSTALLED?></legend>\r\n<ul class=\\"infobox\\">\r\n    <li>        \r\n        <h1>Automatikus linkbeküldés katalógusokba</h1>\r\n        <p>\r\n            Az automatikus linkbeküldő eszköz segít Önnek, hogy <b>weboldalai</b> bekerüljenek a legnagyobb <b>ingyenes és fizetős katalógusokba.</b>\r\n            A beküldés után az <b>állapotellenőrző scripttel</b> <b>ellenőrizheti</b> minden egyes katalógusban <b>linkjei állapotát</b>.\r\n          Ezen felül a <b>Katalógusrendező</b> segít Önnek, hogy mely <b> katalógusok működnek</b> és melyek azok amik már nem.\r\n        </p>\r\n    </li>\r\n    <li>        \r\n        <h1>Kulcsszó helyezés Viszgáló</h1>\r\n        <p>\r\n            A <b>kulcsszó helyezés</b> vizsgáló segítségével ellenőrizheti, hogy az Ön által <b>választott kulcsszavak</b> milyen helyen szerepelnek a keresők <b>találati listáján</b>.\r\n            A Helyezésekről <b>részletes</b>, grafikus jelentéseket készíthet, ahol megtekintheti kulcsszavainak <b>napi pozícióját</b> a különböző keresők találati listáján.\r\n        </p>\r\n    </li>\r\n    <li>        \r\n        <h1>Site Auditor</h1>\r\n        <p>Site Auditor will <b>audit all SEO factors</b> of each pages of a site and will give a <b>detailed report</b> about each page. A Seo Panel segítségével különböző formátumú(<b>XML,HTML,TEXT</b>) oldaltérképet készíthet, amit később <b>beküldhet</b> a keresőknek.</p>\r\n    </li>\r\n    <li>        \r\n        <h1>Google and Alexa Rang Ellenőrző</h1>\r\n        <p>\r\n            A Google és Alexa rang ellenőrző segítségével megtudhatja oldalának <b>Pagerank</b>-ját, valamint az <b>Alexa pozícióját</b>. A kapott adatokat <b>eltárolhatja</b>.\r\n          A tárolt adatokról <b>jelentéseket</b> készíthet, amiben weboldalainak napi Pagerankja és Alexa pozíciója lesz látható.\r\n        </p>\r\n    </li>\r\n    <li>        \r\n        <h1>Backlink Ellenőrző</h1>\r\n        <p>\r\n            A Backlink ellenőrzővel megtudhatja, hogy a különböző keresők<b>(google,yahoo,msn etc)</b> <b>mennyi linket</b> látnak amik az Ön oldalára mutatnak. A kapott adatokat <b>eltárolhatja</b>.\r\n                      <br> A tárolt adatokról <b>jelentéseket</b> készíthet, amiben weboldalainak backlinjeinek számát láthatja napi lebontásban.\r\n        </p>\r\n    </li>    \r\n    <li>        \r\n        <h1>Indexelt oldalak</h1>\r\n        <p>\r\n            Az Indexelt oldalak vizsgálatával kiderül, hogy a különböző keresőkben<b>(google,yahoo,msn stb..)</b> mennyi <br>indexelt oldala</br> van a weblapjának. A kapott adatokat <b>eltárolhatja</b>.\r\n\r\n              A tárolt adatokról <b>jelentéseket</b> készíthet, amiben az <br>indexelt oldalak</br> számát napi nézetben láthatja.\r\n        </p>\r\n    </li>\r\n    <li>        \r\n        <h1>Seo Panel Kiegészítők</h1>\r\n        <p>\r\n            A legfőbb <b>tulajdonsága</b>  a Seo Panel-nek a <b>bővíthetőség</b>. További kiegészítőket itt tud letölteni: <a href=\\"<?=SP_PLUGINSITE?>\\" target=\\"_blank\\">Seo panel kiegészítők</a>.\r\n           \r\n            \r\n            Könnyedén <b>fejleszthet</b> Ön is Seo Kiegészítőket a Seo Panelhez.\r\n            Az Ön által fejlesztett kiegészítőket <a href=\\"<?=SP_PLUGINSITE?>\\" target=\\"_blank\\">beküldheti</a> a Seo Panel oldalára, ahol egy rövid áttekintés után <b>megjelenik</b> a többi kiegészítő között.\r\n        </p>\r\n    </li>\r\n    <li>        \r\n        <h1>Meta Tag Generátor</h1>\r\n        <p>\r\n            A meta tag generátor egy <b>Seo panel kiegészítő</b> amivel <b>egyedi meta tagokat</b> készíthet weboldalai számára.\r\n        \r\n        </p>\r\n    </li>\r\n</ul>\r\n</fieldset>', '2011-07-11 06:51:07'),
(1615, 'hu', 'home', 'home_cont3', '<fieldset>\r\n<legend>További információk a Seo Panelről</legend>    \r\n<ul class=\\"infobox\\">\r\n\r\n    <li>\r\n        <h1>Seo Panel a neten</h1>                \r\n        \r\n        \r\n        <p>\r\n            <a href=\\"http://www.seopanel.in\\" target=\\"_blank\\">Seo Panel Hivatalos Oldala</a>\r\n        </p>\r\n        <p>\r\n            <a href=\\"<?=SP_DOWNLOAD_LINK?>\\" target=\\"_blank\\">Seo Panel Letöltése</a>\r\n        </p>\r\n        \r\n        <p>\r\n            <a href=\\"<?=SP_DEMO_LINK?>\\" target=\\"_blank\\">Seo Panel Demó</a>\r\n        </p>\r\n        \r\n        <p>\r\n            <a href=\\"<?=SP_CONTACT_LINK?>\\" target=\\"_blank\\">Kapcsolat</a>\r\n        </p>\r\n        \r\n        <p>\r\n            <a href=\\"<?=SP_HELP_LINK?>\\" target=\\"_blank\\">Seo Panel Kézikönyv</a>\r\n        </p>\r\n        \r\n        <p>\r\n            <a href=\\"<?=SP_FORUM_LINK?>\\" target=\\"_blank\\">Seo Panel Fórum</a>\r\n        </p>\r\n        \r\n        <p>\r\n            <a href=\\"<?=SP_SUPPORT_LINK?>\\" target=\\"_blank\\">Seo Panel Segítségnyújtás</a>\r\n        </p>\r\n        \r\n        <p>\r\n            <a href=\\"<?=SP_DONATE_LINK?>\\" target=\\"_blank\\">Seo Panel Támogatása</a>\r\n        </p>\r\n    </li>\r\n    \r\n</ul>\r\n</fieldset>', '2011-07-11 06:51:07'),
(1616, 'hu', 'home', 'Pages Indexed', 'Indexelt oldalak', '2011-07-11 06:51:07'),
(1617, 'hu', 'home', 'Ranks', 'Rang', '2011-07-11 06:51:07'),
(1618, 'hu', 'home', 'SiteNameUrl', 'Oldal Neve/Url', '2011-07-11 06:51:07'),
(1619, 'hu', 'home', 'Website Statistics', 'Weboldal statisztika', '2011-07-11 06:51:07'),
(1620, 'hu', 'keyword', 'Crawling keyword', 'Kulcsszó ellenőrzése', '2011-07-11 06:53:54'),
(1621, 'hu', 'keyword', 'Detailed Keyword Position Reports', 'Részletes Kulcsszó Beszámoló', '2011-07-11 06:53:54'),
(1622, 'hu', 'keyword', 'Edit Keyword', 'Kulcsszó Szerkesztése', '2011-07-11 06:53:54'),
(1623, 'hu', 'keyword', 'Graphical Keyword Position Reports', 'Grafikus Kulcsszó Beszámoló', '2011-07-11 06:53:54'),
(1624, 'hu', 'keyword', 'Import Keywords', 'Kulcsszó importálása', '2011-07-11 06:53:54'),
(1625, 'hu', 'keyword', 'Keyword already exist', 'Ez a Kulcsszó már létezik', '2011-07-11 06:53:54'),
(1626, 'hu', 'keyword', 'Keyword Position Report', 'Beszámoló a Helyezésekről', '2011-07-11 06:53:54'),
(1627, 'hu', 'keyword', 'New Keyword', 'Új Kulcsszó', '2011-07-11 06:53:54'),
(1628, 'hu', 'keyword', 'not assigned to required search engines', 'not assigned to required search engines', '2011-07-11 06:53:54'),
(1629, 'hu', 'keyword', 'pleaseselecttool', 'Kérlek válassz minimum egy Seo eszközt', '2011-07-11 06:53:54'),
(1630, 'hu', 'keyword', 'Quick Keyword Position Checker', 'Gyors Helyezés vizsgáló', '2011-07-11 06:53:54'),
(1631, 'hu', 'keyword', 'results from ', 'eredmények', '2011-07-11 06:53:54'),
(1632, 'hu', 'keyword', 'Show All results', 'Összes eredmény mutatása', '2011-07-11 06:53:54'),
(1633, 'hu', 'keyword', 'Successfully crawled keyword', 'Sikeresen leellenőrzött kulcsszó', '2011-07-11 06:53:54'),
(1634, 'hu', 'keyword', 'to create new keywords', 'egy új kulcsszó hozzáadása', '2011-07-11 06:53:54'),
(1635, 'hu', 'label', 'already exist', 'már létezik', '2013-02-05 19:24:43'),
(1636, 'hu', 'label', 'Authentication', 'Hitelesítés', '2013-02-05 19:24:43'),
(1637, 'hu', 'label', 'Author', 'Szerző', '2013-02-05 19:24:43'),
(1638, 'hu', 'label', 'Click Here', 'Kattints Ide', '2013-02-05 19:24:43'),
(1639, 'hu', 'label', 'Cron', 'Cron', '2013-02-05 19:24:43'),
(1640, 'hu', 'label', 'Description', 'Leírás', '2013-02-05 19:24:43'),
(1641, 'hu', 'label', 'Developers', 'Fejlesztők', '2013-02-05 19:24:43'),
(1642, 'hu', 'label', 'Download', 'Letöltés', '2013-02-05 19:24:43'),
(1643, 'hu', 'label', 'Installation', 'Telepítés', '2013-02-05 19:24:43'),
(1644, 'hu', 'label', 'Keywords', 'Kulcsszavak', '2013-02-05 19:24:43'),
(1645, 'hu', 'label', 'noactiveplugins', 'Nem találtunk aktív Seo beépülőket!', '2013-02-05 19:24:43'),
(1646, 'hu', 'label', 'Plugin', 'Beépülő', '2013-02-05 19:24:43'),
(1647, 'hu', 'label', 'Port', 'Port', '2013-02-05 19:24:43'),
(1648, 'hu', 'label', 'Proxy', 'Proxy', '2013-02-05 19:24:43'),
(1649, 'hu', 'label', 'Re-install', 'Újrainstallálom', '2013-02-05 19:24:43'),
(1650, 'hu', 'label', 'Sponsors', 'Támogatók', '2013-02-05 19:24:43'),
(1651, 'hu', 'label', 'Title', 'Cím', '2013-02-05 19:24:43'),
(1652, 'hu', 'label', 'translation by', 'fordította:', '2013-02-05 19:24:43'),
(1653, 'hu', 'label', 'Translators', 'Fordítók', '2013-02-05 19:24:43'),
(1654, 'hu', 'label', 'Upgrade', 'Frissítés', '2013-02-05 19:24:43'),
(1655, 'hu', 'label', 'Version', 'Verzió', '2013-02-05 19:24:43'),
(1656, 'hu', 'label', 'wantproceed', 'Biztos vagy benne?', '2013-02-05 19:24:43'),
(1657, 'hu', 'login', 'Confirm Password', 'Jelszó megerősítése', '2010-10-10 22:33:10'),
(1658, 'hu', 'login', 'Create my account', 'Felhasználói fiók létrehozása', '2010-10-10 22:33:11'),
(1659, 'hu', 'login', 'Create New Account', 'Új Felhasználói Fiók', '2010-10-10 22:33:11'),
(1660, 'hu', 'login', 'Email', 'E-mail', '2010-10-10 22:33:11'),
(1661, 'hu', 'login', 'emailexist', 'Ez az E-mail cím már létezik!', '2010-10-10 22:33:11'),
(1662, 'hu', 'login', 'Enter the code as it is shown', 'Írd be az alábbi kódot', '2010-10-10 22:33:11'),
(1663, 'hu', 'login', 'First Name', 'Vezetéknév', '2010-10-10 22:33:11'),
(1664, 'hu', 'login', 'Last Name', 'Keresztnév', '2010-10-10 22:33:11'),
(1665, 'hu', 'login', 'Login', 'Bejelentkezés', '2010-10-10 22:33:11'),
(1666, 'hu', 'login', 'Login incorrect', 'Nem sikerült bejelentkezned', '2010-10-10 22:33:11'),
(1667, 'hu', 'login', 'newaccountsuccess', 'Az új felhasználói fiók sikeresen elkészült!', '2010-10-10 22:33:11'),
(1668, 'hu', 'login', 'Password', 'Jelszó', '2010-10-10 22:33:11'),
(1669, 'hu', 'login', 'Password incorrect', 'A Jelszó hibás', '2010-10-10 22:33:11'),
(1670, 'hu', 'login', 'Register', 'Regisztráció', '2010-10-10 22:33:11'),
(1671, 'hu', 'login', 'Sign in to your account', 'Jelentkezz be', '2010-10-10 22:33:11'),
(1672, 'hu', 'login', 'User inactive', 'Inaktív felhasználó', '2010-10-10 22:33:11'),
(1673, 'hu', 'login', 'Username', 'Felhasználónév', '2010-10-10 22:33:11'),
(1674, 'hu', 'login', 'usernameexist', 'Ilyen felhasználónévvel már regisztráltak!', '2010-10-10 22:33:11'),
(1675, 'hu', 'panel', 'About Us', 'A Készítőkről', '2013-02-05 19:25:03'),
(1676, 'hu', 'panel', 'Add following command to your cron tab', 'Add hozzá az alábbi utasítást a cron tabodhoz', '2013-02-05 19:25:03'),
(1677, 'hu', 'panel', 'alsocheckfollowlink', 'Nézd meg az alábbi linket ha szükséged van további részletekre.', '2013-02-05 19:25:03'),
(1678, 'hu', 'panel', 'Check Directory', 'Katalógus ellenőrzése', '2013-02-05 19:25:03'),
(1679, 'hu', 'panel', 'Cron Command', 'Cron Parancs', '2013-02-05 19:25:03'),
(1680, 'hu', 'panel', 'Directory Manager', 'Katalógus Kezelő', '2013-02-05 19:25:03'),
(1681, 'hu', 'panel', 'Edit My Profile', 'profilom Szerkesztése', '2013-02-05 19:25:03'),
(1682, 'hu', 'panel', 'My Profile', 'Profilom', '2013-02-05 19:25:03'),
(1683, 'hu', 'panel', 'New Proxy', 'Új Proxy', '2013-02-05 19:25:03'),
(1684, 'hu', 'panel', 'New User', 'Új Felhasználó', '2013-02-05 19:25:03'),
(1685, 'hu', 'panel', 'New Website', 'Új Weboldal', '2013-02-05 19:25:03'),
(1686, 'hu', 'panel', 'Proxy Manager', 'Proxy Kezelő', '2013-02-05 19:25:03'),
(1687, 'hu', 'panel', 'Report Generation Manager', 'Jelentéskészítő Beállításai', '2013-02-05 19:25:03'),
(1688, 'hu', 'panel', 'Reports Manager', 'Jelentések Kezelése', '2013-02-05 19:25:03'),
(1689, 'hu', 'panel', 'Seo Plugins Manager', 'Seo Beépülők Kezelése', '2013-02-05 19:25:03'),
(1690, 'hu', 'panel', 'Seo Tools Manager', 'Seo kiegészítések kezelése', '2013-02-05 19:25:03'),
(1691, 'hu', 'panel', 'System Settings', 'Rendszerbeállítások', '2013-02-05 19:25:03'),
(1692, 'hu', 'panel', 'User Manager', 'Felhasználókezelő', '2013-02-05 19:25:03'),
(1693, 'hu', 'panel', 'Website Manager', 'Weboldalkezelő', '2013-02-05 19:25:03'),
(1694, 'hu', 'plugin', 'Edit Seo Plugin', 'Seo Beépülő Szerkesztése', '2012-05-22 22:30:42'),
(1695, 'hu', 'plugin', 'Plugin Name', 'Beépülő Neve', '2012-05-22 22:30:42'),
(1696, 'hu', 'plugin', 'Seo Plugin Details', 'Seo Beépülő Leírása', '2012-05-22 22:30:42'),
(1697, 'hu', 'proxy', 'Edit Proxy', 'Proxy Szerkesztése', '2010-10-10 22:42:13'),
(1698, 'hu', 'proxy', 'Proxy Password', 'Proxy Jelszó', '2010-10-10 22:42:14'),
(1699, 'hu', 'proxy', 'Proxy Username', 'Proxy Felhasználónév', '2010-10-10 22:42:14'),
(1700, 'hu', 'proxy', 'Proxyalreadyexist', 'Ez a Proxy már létezik!', '2010-10-10 22:42:14'),
(1701, 'hu', 'rank', 'enterurlproceed', 'Írd be a weboldalak Url-jét <b>egyesével soronként</b>. Kattints az  <b>Elküldése</b> feliratra a Google és Alexa rank ellenőrzéséhez.', '2010-10-10 22:45:42'),
(1702, 'hu', 'rank', 'Google and Alexa Rank Reports', 'Google és Alexa Rank Jelentések', '2010-10-10 22:45:42'),
(1703, 'hu', 'rank', 'Saved rank results of', 'Elmentett eredmények:', '2010-10-10 22:45:42'),
(1704, 'hu', 'saturation', 'clickproceedsaturation', 'Írd be az ellenőrizendő weboldalak Url-jét(<b>soronként egyet</b>). Kattints az  <b>Elküldés</b> feliratra, hogy ellenőrizd az indexelt oldalak számát.', '2010-10-10 22:52:43'),
(1705, 'hu', 'saturation', 'GenerateSaturationReports', 'Jelentés készítése a keresők által indexelt oldalak számából', '2010-10-10 22:52:43'),
(1706, 'hu', 'saturation', 'Quick Search Engine Saturation Checker', 'Gyors ellenőrzése az indexelt oldalak számának', '2010-10-10 22:52:43'),
(1707, 'hu', 'saturation', 'Saved Search Engine Saturation results of', 'Indexelt oldalak száma elmentve:', '2010-10-10 22:52:43'),
(1708, 'hu', 'saturation', 'Search Engine Saturation Reports', 'Indexelt Oldalak Számának Jelentése', '2010-10-10 22:52:43'),
(1709, 'hu', 'seotools', 'Automatic Submission', 'Automata Linkbeküldés', '2011-07-11 07:00:18'),
(1710, 'hu', 'seotools', 'backlink-checker', 'Backlink Ellenőrző', '2011-07-11 07:00:18'),
(1711, 'hu', 'seotools', 'Backlinks Reports', 'Backlink Jelentések', '2011-07-11 07:00:18'),
(1712, 'hu', 'seotools', 'Check Submission Status', 'Beküldés állapotának ellenőrzése', '2011-07-11 07:00:18'),
(1713, 'hu', 'seotools', 'clickgeneratereports', 'Kattints az <b>Elküldés</b> feliratra, hogy elkészüljön a jelentés\r\n', '2011-07-11 07:00:18'),
(1714, 'hu', 'seotools', 'Detailed Position Reports', 'Részletes Jelentés a Helyezésekről', '2011-07-11 07:00:18'),
(1715, 'hu', 'seotools', 'directory-submission', 'Linkbeküldés', '2011-07-11 07:00:18'),
(1716, 'hu', 'seotools', 'Featured Submission', 'Kiemelt Linkbeküldés', '2011-07-11 07:00:18'),
(1717, 'hu', 'seotools', 'Generate Backlinks Reports', 'Backlink jelentés készítése', '2011-07-11 07:00:18'),
(1718, 'hu', 'seotools', 'Generate Keyword Reports', 'Kulcsszó Jelentés Készítése', '2011-07-11 07:00:18'),
(1719, 'hu', 'seotools', 'Generate Rank Reports', 'Google és Alexa Rank Jelentés', '2011-07-11 07:00:18'),
(1720, 'hu', 'seotools', 'Generate Saturation Reports', 'jelentés az Indexelt Oldalakról', '2011-07-11 07:00:18'),
(1721, 'hu', 'seotools', 'Google Sitemap Generator', 'Google Oldaltérkép Készítése', '2011-07-11 07:00:18'),
(1722, 'hu', 'seotools', 'Graphical Position Reports', 'Grafikus Helyezés Jelentés', '2011-07-11 07:00:18'),
(1723, 'hu', 'seotools', 'Keyword Position Summary', 'Kulcsszavak Pozíciójának Összefoglalója', '2011-07-11 07:00:18'),
(1724, 'hu', 'seotools', 'keyword-position-checker', 'Helyezés Vizsgáló', '2011-07-11 07:00:18'),
(1725, 'hu', 'seotools', 'Keywords Manager', 'Kulcsszókezelő', '2011-07-11 07:00:18'),
(1726, 'hu', 'seotools', 'Quick Backlinks Checker', 'Gyors Backlink Ellenőrző', '2011-07-11 07:00:18'),
(1727, 'hu', 'seotools', 'Quick Position Checker', 'Gyors Helyezés Vizsgáló', '2011-07-11 07:00:18'),
(1728, 'hu', 'seotools', 'Quick Rank Checker', 'Gyors \\"Rang\\" Vizsgáló', '2011-07-11 07:00:18'),
(1729, 'hu', 'seotools', 'Quick Saturation Checker', 'Gyors Indexelés Vizsgáló', '2011-07-11 07:00:18'),
(1730, 'hu', 'seotools', 'Rank Reports', '\\"Rang\\" Jelentések', '2011-07-11 07:00:18'),
(1731, 'hu', 'seotools', 'rank-checker', 'Alexa és Pagerank', '2011-07-11 07:00:18'),
(1732, 'hu', 'seotools', 'Saturation Reports', 'Indexelésről Jelentések', '2011-07-11 07:00:18'),
(1733, 'hu', 'seotools', 'saturation-checker', 'Indexelt Oldalak ', '2011-07-11 07:00:18'),
(1734, 'hu', 'seotools', 'sitemap-generator', 'Oldaltérkép Készítése', '2011-07-11 07:00:18'),
(1735, 'hu', 'seotools', 'Skipped Directories', 'Kihagyott Katalógusok', '2011-07-11 07:00:18'),
(1736, 'hu', 'seotools', 'Submission Reports', 'Jelentés a Linkbeküldésekről', '2011-07-11 07:00:18'),
(1737, 'hu', 'seotools', 'User Access', 'Hozzáférés', '2011-07-11 07:00:18'),
(1738, 'hu', 'settings', 'Click here to become a sponsor for Seo Panel', '<b>Támogasd $100-al</b> a Seo Panlelt és válj <b>Támogatóvá</b>.', '2013-02-05 19:25:44'),
(1739, 'hu', 'settings', 'seopanel_description', 'Egy teljesen ingyenes eszköz mely nagy mértékben megkönnyíti a keresőoptimalizálást. Egyszerre több népszerű Seo eszközt foglal magában, hogy Weblapjából a maximumot hozhassa ki. Nyílt forráskódú ezért Ön is fejleszthet hozzá különböző Seo Kiegészítőket.', '2013-02-05 19:25:44'),
(1740, 'hu', 'settings', 'seopanel_title', 'Seo Panel: A világ első nyílt forráskódú Keresőoptimalizáló \\"Panel\\"-je. ', '2013-02-05 19:25:44'),
(1741, 'hu', 'settings', 'SP_CRAWL_DELAY', 'Várakozás a lekérdezések között(másodperc)', '2013-02-05 19:25:44'),
(1742, 'hu', 'settings', 'SP_DEFAULTLANG', 'Alapértelmezett Nyelv', '2013-02-05 19:25:44'),
(1743, 'hu', 'settings', 'SP_DESCRIPTION', 'Seo Panel Leírás', '2013-02-05 19:25:44'),
(1744, 'hu', 'settings', 'SP_ENABLE_PROXY', 'Proxy Engedélyezése', '2013-02-05 19:25:44'),
(1745, 'hu', 'settings', 'SP_HOTLINKING', 'Képek \\"hotlink\\" védelmének engedélyezése', '2013-02-05 19:25:44'),
(1746, 'hu', 'settings', 'SP_KEYWORDS', 'Seo Panel Kulcsszavak', '2013-02-05 19:25:44'),
(1747, 'hu', 'settings', 'SP_PAGINGNO', 'Bejegyzések száma oldalanként', '2013-02-05 19:25:44'),
(1748, 'hu', 'settings', 'SP_TITLE', 'Seo Panel Cím', '2013-02-05 19:25:44'),
(1749, 'hu', 'settings', 'SP_USER_GEN_REPORT', 'Felhasználók készíthetnek-e jelentéseket', '2013-02-05 19:25:44'),
(1750, 'hu', 'settings', 'SP_USER_REGISTRATION', 'Regisztráció engedélyezése', '2013-02-05 19:25:44'),
(1751, 'hu', 'settings', 'syssettingssaved', 'A Beállításokat sikeresen elmentettük!', '2013-02-05 19:25:44'),
(1752, 'hu', 'sitemap', 'Change frequency', 'Frissítés gyakorisága', '2010-10-10 23:31:58'),
(1753, 'hu', 'sitemap', 'clickproceedsitemap', 'Kattints az <b>Elküldés</b> feliratra, hogy az oldaltérképed elkészüljön', '2010-10-10 23:31:58'),
(1754, 'hu', 'sitemap', 'Download sitemap file from', 'Oldaltérkép letöltése', '2010-10-10 23:31:58'),
(1755, 'hu', 'sitemap', 'Exclude Url', 'Kihagyandó URL-ek', '2010-10-10 23:31:58'),
(1756, 'hu', 'sitemap', 'processtaketime', 'Az oldaltérkép elkészítése eltarthat egy ideig, attól függően, hogy az oldalán mennyi link található. Kérem várjon...', '2010-10-10 23:31:58'),
(1757, 'hu', 'sitemap', 'Sitemap Type', 'Oldaltérkép típusa', '2010-10-10 23:31:58'),
(1758, 'hu', 'user', 'Edit User', 'Felhasználó szerkesztése', '2010-10-10 23:35:28'),
(1759, 'hu', 'user', 'Saved My Profile Details', 'A változtatásokat elmentettük', '2010-10-10 23:35:28'),
(1760, 'hu', 'website', 'Edit Website', 'Weboldal Szerkesztése', '2010-10-11 22:15:03'),
(1761, 'hu', 'website', 'plscrtwebsite', 'Kérem először adjon meg egy weboldalt mielőtt elkezdi használni a Seo eszközöket és beépülőket.', '2010-10-11 22:15:03'),
(1762, 'hu', 'website', 'Website already exist', 'Ez a Weboldal már megtalálható az adatbázisunkban.', '2010-10-11 22:15:03'),
(1763, 'hu', 'website', 'yourwebalreday', 'Weboldalad, ha már legalább egyet megadtál.', '2010-10-11 22:15:03'),
(1764, 'it', 'website', 'Edit Website', 'Modifica sito web', '2010-10-11 03:22:02'),
(1765, 'it', 'website', 'plscrtwebsite', 'Per cortesia crea il sito web proma di utilizzareo gli strumenti seo e i plugin seo.', '2010-10-11 03:22:02'),
(1766, 'it', 'website', 'Website already exist', 'Sito web già esistente', '2010-10-11 03:22:02'),
(1767, 'it', 'website', 'yourwebalreday', 'il tuo sito web se ne hai già creato uno.', '2010-10-11 03:22:02'),
(1768, 'it', 'user', 'Edit User', 'Modifica utente', '2010-10-11 03:22:16'),
(1769, 'it', 'user', 'Saved My Profile Details', 'Salva i miei dettagli del profilo', '2010-10-11 03:22:16'),
(1770, 'it', 'sitemap', 'Change frequency', 'Frequenza di aggiornamento', '2010-10-11 03:23:32'),
(1771, 'it', 'sitemap', 'clickproceedsitemap', 'Clicca su <b>Procedi</b> per creare il file sitemap', '2010-10-11 03:23:32'),
(1772, 'it', 'sitemap', 'Download sitemap file from', 'Scarica file sitemap da', '2010-10-11 03:23:32'),
(1773, 'it', 'sitemap', 'Exclude Url', 'Url da escludere', '2010-10-11 03:23:32'),
(1774, 'it', 'sitemap', 'processtaketime', 'Questo processo durerà in base al numero di link presenti nel tuo sito. Per cortesia aspetta per la sitemap.', '2010-10-11 03:23:32'),
(1775, 'it', 'sitemap', 'Sitemap Type', 'Tipo sitemap', '2010-10-11 03:23:32'),
(1776, 'it', 'login', 'Confirm Password', 'Conferma password', '2016-12-09 09:19:09'),
(1777, 'it', 'login', 'Create my account', 'Crea il mio account', '2016-12-09 09:19:09'),
(1778, 'it', 'login', 'Create New Account', 'Crea nuovo account', '2016-12-09 09:19:09'),
(1779, 'it', 'login', 'Email', 'Email', '2016-12-09 09:19:09'),
(1780, 'it', 'login', 'emailexist', 'La mail esiste già!', '2016-12-09 09:19:09'),
(1781, 'it', 'login', 'Enter the code as it is shown', 'Inserisci il codice mostrato', '2016-12-09 09:19:09'),
(1782, 'it', 'login', 'First Name', 'Nome', '2016-12-09 09:19:09'),
(1783, 'it', 'login', 'Last Name', 'Cognome', '2016-12-09 09:19:09'),
(1784, 'it', 'login', 'Login', 'Login', '2016-12-09 09:19:09'),
(1785, 'it', 'login', 'Login incorrect', 'Login errato', '2016-12-09 09:19:09'),
(1786, 'it', 'login', 'newaccountsuccess', 'Nuovo account creato con successo!', '2016-12-09 09:19:09'),
(1787, 'it', 'login', 'Password', 'Password', '2016-12-09 09:19:09'),
(1788, 'it', 'login', 'Password incorrect', 'Password non corretta', '2016-12-09 09:19:09'),
(1789, 'it', 'login', 'Register', 'Registrati', '2016-12-09 09:19:09'),
(1790, 'it', 'login', 'Sign in to your account', 'Collegati con il tuo account', '2016-12-09 09:19:09'),
(1791, 'it', 'login', 'User inactive', 'Utente inattivo', '2016-12-09 09:19:09'),
(1792, 'it', 'login', 'Username', 'Nome utente', '2016-12-09 09:19:09'),
(1793, 'it', 'login', 'usernameexist', 'Nome utente già esistente!', '2016-12-09 09:19:09'),
(1846, 'nl', 'common', 'Name', 'Naam', '2014-01-07 21:29:58'),
(1847, 'nl', 'common', 'No Keywords Found', 'Geen Zoekwoorden gevonden', '2014-01-07 21:29:58'),
(1848, 'nl', 'common', 'No Records Found', 'Geen Rapporten Gevonden', '2014-01-07 21:29:58'),
(1849, 'nl', 'common', 'noactivetools', 'Geen actieve Seo Tools gevonden!', '2014-01-07 21:29:58'),
(1850, 'nl', 'common', 'nowebsites', 'Geen Websites gevonden', '2014-01-07 21:29:58'),
(1851, 'nl', 'common', 'password632', 'Het wachtwoord moet 6 tot 32 tekens lang zijn', '2014-01-07 21:29:58'),
(1852, 'nl', 'common', 'passwordnotmatch', 'De opgegeven wachtwoorden komen niet overeen', '2014-01-07 21:29:58'),
(1853, 'nl', 'common', 'Period', 'Periode', '2014-01-07 21:29:58'),
(1854, 'nl', 'common', 'Priority', 'Prioriteit', '2014-01-07 21:29:58'),
(1855, 'nl', 'common', 'Reports', 'Rapporten', '2014-01-07 21:29:58'),
(1856, 'nl', 'common', 'Results', 'Resultaten', '2014-01-07 21:29:58'),
(1857, 'nl', 'common', 'Search Engine', 'Zoekmachine', '2014-01-07 21:29:58'),
(1858, 'nl', 'common', 'Seo Plugins', 'Seo Plugins', '2014-01-07 21:29:58'),
(1859, 'nl', 'common', 'Seo Tools', 'Seo Tools', '2014-01-07 21:29:58'),
(1860, 'nl', 'common', 'Sign out', 'Uitloggen', '2014-01-07 21:29:58'),
(1861, 'nl', 'common', 'Sign Up', 'Registreren', '2014-01-07 21:29:58'),
(1862, 'nl', 'common', 'signin', 'Inloggen', '2014-01-07 21:29:58'),
(1863, 'nl', 'common', 'Status', 'Status', '2014-01-07 21:29:58'),
(1864, 'nl', 'common', 'Support', 'Support', '2014-01-07 21:29:58'),
(1865, 'nl', 'common', 'Url', 'URL', '2014-01-07 21:29:58'),
(1866, 'nl', 'common', 'User', 'Gebruiker', '2014-01-07 21:29:58'),
(1867, 'nl', 'common', 'User Panel', 'Gebruiker Instellingen', '2014-01-07 21:29:58'),
(1868, 'nl', 'common', 'Website', 'Website', '2014-01-07 21:29:58'),
(1869, 'nl', 'directory', 'Add back to directory list', 'Toevoegen aan de directory lijst', '2014-01-07 21:36:56'),
(1870, 'nl', 'directory', 'Approved', 'Goedgekeurd', '2014-01-07 21:36:56'),
(1871, 'nl', 'directory', 'Captcha', 'Captcha', '2014-01-07 21:36:56'),
(1872, 'nl', 'directory', 'categorynote', 'Categorieën, gescheiden door komma''s in volgorde van belangrijkheid. Start met de meest relevante categorie.', '2014-01-07 21:36:56'),
(1873, 'nl', 'directory', 'Check Directory Status', 'Controleer Directory Status', '2014-01-07 21:36:56'),
(1874, 'nl', 'directory', 'Check Directory Submission Status', 'Controleer Directory Inschrijving Status', '2014-01-07 21:36:56'),
(1875, 'nl', 'directory', 'clicktoproceeddirsts', 'Klik op <b>ga verder</b> om de directory status te controleren.', '2014-01-07 21:36:56'),
(1876, 'nl', 'directory', 'Confirmation', 'Bevestiging', '2014-01-07 21:36:56'),
(1877, 'nl', 'directory', 'desnote', 'Sommige directory''s vereisen ten minste 150 karakters als beschrijving.', '2014-01-07 21:36:56'),
(1878, 'nl', 'directory', 'Directories with out captcha', 'Directory''s zonder captcha', '2014-01-07 21:36:56'),
(1879, 'nl', 'directory', 'Directory Submission Reports', 'Directory Inschrijving Rapporten', '2014-01-07 21:36:56'),
(1880, 'nl', 'directory', 'Enter the code shown', 'Voer de getoonde code in', '2014-01-07 21:36:56'),
(1881, 'nl', 'directory', 'nocatnote', 'De gevraagde categorie bestaat niet in deze map. Klik <b>Vernieuwen</b> of <b>Overslaan</b>.', '2014-01-07 21:36:56'),
(1882, 'nl', 'directory', 'nodirnote', 'Geen <b>actieve</b> directory''s gevonden.', '2014-01-07 21:36:56'),
(1883, 'nl', 'directory', 'nosuccessnote', 'Geen bevestiging ontvangen - Controleer uw e-mail voor een bevestigingsmail.', '2014-01-07 21:36:56'),
(1884, 'nl', 'directory', 'optionalnote', 'Optioneel kunt u verschillende beschrijvingen en titels toevoegen voor wisselende beschrijvingen en titels in de directory''s. Dit om betere resultaten te krijgen.', '2014-01-07 21:36:56'),
(1885, 'nl', 'directory', 'Owner Email', 'Eigenaar E-mail', '2014-01-07 21:36:56'),
(1886, 'nl', 'directory', 'Owner Name', 'Eigenaar Naam', '2014-01-07 21:36:56'),
(1887, 'nl', 'directory', 'Pending', 'In afwachting', '2014-01-07 21:36:56'),
(1888, 'nl', 'directory', 'Please select a website to proceed', 'Selecteer een website om verder te gaan', '2014-01-07 21:36:56'),
(1889, 'nl', 'directory', 'selectwebsiteproceed', 'Selecteer een <b>Website</b> om te <b>starten</b> met de directory inschrijvingen.<br>Zet een vinkje bij <b>Directory''s zonder captcha</b> om directory''s met Captcha over te slaan.', '2014-01-07 21:36:56'),
(1890, 'nl', 'directory', 'selectwebsiteschecksub', 'Selecteer een <b>Website</b> om te <b>starten</b> met de controle van de directory inschrijvingen', '2014-01-07 21:36:56'),
(1891, 'nl', 'directory', 'Semi Automatic Directory Submission Tool', 'Semi-Automatische Directory Inschrijf Tool', '2014-01-07 21:36:56'),
(1892, 'nl', 'directory', 'spamemailnote', 'Sommige directory''s versturen SPAM, wij raden aan niet uw primaire e-mail adres te gebruiken, maar een apart e-mail adres.', '2014-01-07 21:36:56'),
(1893, 'nl', 'directory', 'Submission Details', 'Registratie details', '2014-01-07 21:36:56'),
(1894, 'nl', 'directory', 'Submit Description', 'Omschrijving website ', '2014-01-07 21:36:56'),
(1895, 'nl', 'directory', 'Submit Keywords', 'Zoekwoorden  ', '2014-01-07 21:36:56'),
(1896, 'nl', 'directory', 'Submit Title', 'Titel ', '2014-01-07 21:36:56'),
(1897, 'nl', 'directory', 'Website Category', 'Website Categorie', '2014-01-07 21:36:56'),
(1898, 'nl', 'directory', 'Website Url', 'Website URL', '2014-01-07 21:36:56'),
(1899, 'nl', 'home', 'Account Summary', 'Overzicht accounts', '2011-07-05 21:52:28'),
(1900, 'nl', 'home', 'Backlinks', 'Backlinks', '2011-07-05 21:52:28'),
(1901, 'nl', 'home', 'Directory Submission', 'Directory Inschrijving', '2011-07-05 21:52:28'),
(1902, 'nl', 'home', 'home_cont1', '<h1 style=\\"text-align: center;margin-bottom: 30px;font-size: 19px;\\">Welkom bij Seo Panel - \\''s Werelds eerste Seo bedieningspaneel voor meerdere Websites</h1>\r\n        <p>\r\n            Een compleet <b>Open Source Seo bedieningspaneel</b> voor <b>zoekmachine optimalisering</b> van uw websites.\r\n           Seo Panel is in feite een <b>Seo Tool Kit</b> met de belangrijkste functies om de <b>zoekmachine optimalisering</b> van uw websites te\r\n<b>observeren en te verbeteren</b>.\r\n            Dit is <b>Gratis Software</b> vrijgegeven onder de <b>GNU GENERAL PUBLIC LICENSE</b>.\r\n            De kracht van Seo Panel ligt in de <b>uitbreidingsmogelijkheden</b>; door gebruik te maken van de <a href=\\"<?=SP_PLUGINSITE?>\\"\r\ntarget=\\"_blank\\">Seo Plugins</a>.\r\n            Iedereen kan eenvoudig nieuwe <b>plugins ontwikkelen en installeren</b> voor Seo Panel.\r\n        </p>\r\n        <p></p>\r\n        <p>\r\n            Deze Open Source software werd <b>januari 2010 uitgegeven</b>.\r\n			In een <b>korte periode</b> zijn er <b>duizenden webmasters</b> die deze software gebruiken om hun websites te <b>optimaliseren</b>. \r\n			Probeer Seo Panel zelf en <b>maak kennis</b> met het platform en alle seo gerelateerde functionaliteit.\r\n        </p>', '2011-07-05 21:52:28');
INSERT INTO `texts` (`id`, `lang_code`, `category`, `label`, `content`, `changed`) VALUES
(1903, 'nl', 'home', 'home_cont2', '<fieldset>\r\n<legend>Hoofd functionaliteiten van Seo Panel <?=SP_INSTALLED?></legend>\r\n<ul class=\\"infobox\\">\r\n    <li>        \r\n        <h1>Automatische Directory Inschrijving Tool</h1>\r\n		<p>\r\n			De automatische directory inschrijving tool geeft <b>toegang naar veel gratis en betaalde web-directories</b>. Daarnaast kan de <b>status van elke inschrijving periodiek worden gecontroleerd</b>; met behulp van het <b>Controleer Status Inschrijving script</b>. De <b>Directory Manager</b> helpt aan te tonen in<b>welke directory uw domein actief is en welke niet</b>.\r\n			\r\n		</p>\r\n    </li>\r\n    <li>        \r\n        <h1>Posities van Zoekwoorden</h1>\r\n		<p>\r\n			U kunt de <b>zoekmachine posities</b> van <b>de betreffende zoekwoorden</b> die u heeft toegewezen aan de websites <b>opslaan</b> in het systeem.\r\n			Zo kunt u de <b>dagelijkse posities</b> van zoekwoorden van verschillende zoekmachines <b>gedetailleerd</b> en in <b>grafieken</b> weergeven.			\r\n		</p>\r\n    </li>\r\n    <li>         \r\n        <h1>Site Auditor</h1> \r\n        <p>Site Auditor zal <b>alle SEO factoren controleren</b> van iedere pagina van een site en geeft een \r\n<b>gedetailleerd rapport</b> over iedere pagina. Dit helpt ons om <b>XML,HTML,TEXT</b> sitemap bestanden van de website om <b>toe te voegen</b> aan zoekmachines.</p> \r\n    </li> \r\n    <li>        \r\n    <li>        \r\n        <h1>Sitemap Generator</h1>\r\n		<p>Genereert <b>XML,HTML,TEXT</b> sitemap bestanden voor alle websites. Vervolgens kunt u de bestanden aanbieden aan de zoekmachines.\r\n    </li>\r\n    <li>        \r\n        <h1>Google en Alexa Rank Controle</h1>\r\n		<p>\r\n		Met deze functionaliteit controleert u de <b>Google Pagerank</b> en <b>Alexa Rank</b> van de websites en slaat de gegevens op in het systeem.\r\n		In de <b>Rank Controle</b> sectie, kunnen we dagelijks de <b>Google en Alexa Rank</b> van elke website zien met <b>gedetailleerde informatie</b>.\r\n		</p>\r\n    </li>\r\n    <li>        \r\n        <h1>Backlink Controle</h1>\r\n		<p>\r\n		De Backlink Controle vindt het <b>aantal Backlinks</b> naar de website in de verschillende zoekmachines <b>(google,yahoo,msn etc)</b> en slaat de gegevens op in het systeem.\r\n			<br>\r\n			In de <b>backlink Rapporten</b> sectie, kunnen we de <b>dagelijkse</b> backlink tellingen zien van elke website met <b>gedetailleerde informatie</b>.\r\n		</p>\r\n    </li>    \r\n    <li>        \r\n        <h1>Zoekmachine Verzadiging Controle</h1>\r\n		<p>\r\n		Zoekmachine Verzadiging Controle vindt het <b>aantal geïndexeerde pagina\\''s</b> van de websites in de verschillende zoekmachines <b>(Google, Yahoo, MSN enz)</b> en slaat deze op in het systeem. In de <b>Zoekmachine Verzadiging Controle rapporten</b> sectie, kunnen we de <b>dagelijks</b> geïndexeerde pagina tellingen terugvinden van elke website met <b>gedetailleerde informatie</b>.\r\n			</p>\r\n    </li>\r\n    <li>        \r\n        <h1>Seo Panel Plugins</h1>\r\n        <p>\r\n		Het <b>belangrijkste kenmerk</b> van Seo Panel is de <b>uitbreidingsmogelijkheid</b>. Voeg <b>Seo plugins</b> toe om uw Seo panel <b>functies uit te breiden</b> volgens uw behoefte. <a href=\\"<?=SP_PLUGINSITE?>\\" target=\\"_blank\\">Seo panel plugins</a> worden geleverd door zowel Seo panel en sites van derden. U kunt zelf ook makkelijk Seo plugins <b>ontwikkelen</b> voor Seo Panel. U kunt uw Seo plugin <a href=\\"<?=SP_PLUGINSITE?>\\" target=\\"_blank\\">doorsturen naar Seo Panel</a>. Na deze <b>getest</b> te hebben zullen wij deze vervolgens op de Seo Panel website plubliceren!\r\n        </p>\r\n    </li>\r\n    <li>        \r\n        <h1>Meta Tag Generator</h1>\r\n		<p>\r\n		Meta Tag generator is een <b>Seo Panel Plugin</b> voor het maken van aangepaste <b>Meta Tags</b> voor uw websites. Het helpt u om <b>meer informatie</b> over uw website te geven aan de <b>spiderbots van de zoekmachines</b> terwijl zij de website doorlopen.\r\n		\r\n		</p>\r\n    </li>\r\n</ul>\r\n</fieldset>', '2011-07-05 21:52:28'),
(1904, 'nl', 'home', 'home_cont3', '<fieldset>\r\n<legend>Seo Panel Online Hulpbronnen</legend>    \r\n<ul class=\\"infobox\\">\r\n\r\n    <li>\r\n        <h1>Seo Panel Online Hulpbronnen ter Referentie</h1>                \r\n        \r\n        \r\n        <p>\r\n            <a href=\\"http://www.seopanel.in\\" target=\\"_blank\\">Officiële Seo Panel Website</a>\r\n        </p>\r\n        <p>\r\n            <a href=\\"<?=SP_DOWNLOAD_LINK?>\\" target=\\"_blank\\">Seo Panel Downloaden</a>\r\n        </p>\r\n        \r\n        <p>\r\n            <a href=\\"<?=SP_DEMO_LINK?>\\" target=\\"_blank\\">Seo Panel Demo</a>\r\n        </p>\r\n        \r\n        <p>\r\n            <a href=\\"<?=SP_CONTACT_LINK?>\\" target=\\"_blank\\">Seo Panel Contact</a>\r\n        </p>\r\n        \r\n        <p>\r\n            <a href=\\"<?=SP_HELP_LINK?>\\" target=\\"_blank\\">Seo Panel Helpdesk</a>\r\n        </p>\r\n        \r\n        <p>\r\n            <a href=\\"<?=SP_FORUM_LINK?>\\" target=\\"_blank\\">Seo Panel Forum</a>\r\n        </p>\r\n        \r\n        <p>\r\n            <a href=\\"<?=SP_SUPPORT_LINK?>\\" target=\\"_blank\\">Seo Panel Support Systeem</a>\r\n        </p>\r\n        \r\n        <p>\r\n            <a href=\\"<?=SP_DONATE_LINK?>\\" target=\\"_blank\\">Seo Panel Donatie</a>\r\n        </p>\r\n    </li>\r\n    \r\n</ul>\r\n</fieldset>', '2011-07-05 21:52:28'),
(1905, 'nl', 'home', 'Pages Indexed', 'Geïndexeerde pagina\\''s', '2011-07-05 21:52:28'),
(1906, 'nl', 'home', 'Ranks', 'Ranks', '2011-07-05 21:52:28'),
(1907, 'nl', 'home', 'SiteNameUrl', 'Website Naam / URL', '2011-07-05 21:52:28'),
(1908, 'nl', 'home', 'Website Statistics', 'Website Statistieken', '2011-07-05 21:52:28'),
(1909, 'nl', 'keyword', 'Crawling keyword', 'Zoekwoord aan het controleren', '2011-07-05 21:54:33'),
(1910, 'nl', 'keyword', 'Detailed Keyword Position Reports', 'Gedetailleerd Zoekwoord Positie Rapporten', '2011-07-05 21:54:33'),
(1911, 'nl', 'keyword', 'Edit Keyword', 'Wijzig Zoekwoord', '2011-07-05 21:54:33'),
(1912, 'nl', 'keyword', 'Graphical Keyword Position Reports', 'Grafische Zoekwoord Positie Rapporten ', '2011-07-05 21:54:33'),
(1913, 'nl', 'keyword', 'Import Keywords', 'Zoekwoorden importeren', '2011-07-05 21:54:33'),
(1914, 'nl', 'keyword', 'Keyword already exist', 'Zoekwoord bestaat al', '2011-07-05 21:54:33'),
(1915, 'nl', 'keyword', 'Keyword Position Report', 'Zoekwoord Positie Rapport', '2011-07-05 21:54:33'),
(1916, 'nl', 'keyword', 'New Keyword', 'Nieuw Zoekwoord', '2011-07-05 21:54:33'),
(1917, 'nl', 'keyword', 'not assigned to required search engines', 'niet vertegenwoordigd in relevante zoekmachines', '2011-07-05 21:54:33'),
(1918, 'nl', 'keyword', 'pleaseselecttool', 'Selecteer minstens één Seo Tool', '2011-07-05 21:54:33'),
(1919, 'nl', 'keyword', 'Quick Keyword Position Checker', 'Snelle Zoekwoord Positie controle', '2011-07-05 21:54:33'),
(1920, 'nl', 'keyword', 'results from ', 'Resultaten van', '2011-07-05 21:54:33'),
(1921, 'nl', 'keyword', 'Show All results', 'Alle resultaten weergeven', '2011-07-05 21:54:33'),
(1922, 'nl', 'keyword', 'Successfully crawled keyword', 'Zoekwoord succesvol getest', '2011-07-05 21:54:33'),
(1923, 'nl', 'keyword', 'to create new keywords', 'om nieuwe zoekwoorden te maken', '2011-07-05 21:54:33'),
(1924, 'nl', 'label', 'already exist', 'bestaat al', '2014-01-07 21:37:43'),
(1925, 'nl', 'label', 'Authentication', 'Authenticatie', '2014-01-07 21:37:43'),
(1926, 'nl', 'label', 'Author', 'Auteur', '2014-01-07 21:37:43'),
(1927, 'nl', 'label', 'Click Here', 'Hier klikken', '2014-01-07 21:37:43'),
(1928, 'nl', 'label', 'Cron', 'Cronjob', '2014-01-07 21:37:43'),
(1929, 'nl', 'label', 'Description', 'Beschrijving', '2014-01-07 21:37:43'),
(1930, 'nl', 'label', 'Developers', 'Ontwikkelaars', '2014-01-07 21:37:43'),
(1931, 'nl', 'label', 'Download', 'Download', '2014-01-07 21:37:43'),
(1932, 'nl', 'label', 'Installation', 'Installatie', '2014-01-07 21:37:43'),
(1933, 'nl', 'label', 'Keywords', 'Zoekwoorden', '2014-01-07 21:37:43'),
(1934, 'nl', 'label', 'noactiveplugins', 'Geen actieve Seo plugins gevonden!', '2014-01-07 21:37:43'),
(1935, 'nl', 'label', 'Plugin', 'Plugin', '2014-01-07 21:37:43'),
(1936, 'nl', 'label', 'Port', 'Poort', '2014-01-07 21:37:43'),
(1937, 'nl', 'label', 'Proxy', 'Proxy', '2014-01-07 21:37:43'),
(1938, 'nl', 'label', 'Re-install', 'Opnieuw installeren', '2014-01-07 21:37:43'),
(1939, 'nl', 'label', 'Sponsors', 'Sponsors', '2014-01-07 21:37:43'),
(1940, 'nl', 'label', 'Title', 'Titel', '2014-01-07 21:37:43'),
(1941, 'nl', 'label', 'translation by', 'vertaald door', '2014-01-07 21:37:43'),
(1942, 'nl', 'label', 'Translators', 'Vertalers', '2014-01-07 21:37:43'),
(1943, 'nl', 'label', 'Upgrade', 'Updaten', '2014-01-07 21:37:43'),
(1944, 'nl', 'label', 'Version', 'Versie', '2014-01-07 21:37:43'),
(1945, 'nl', 'login', 'Confirm Password', 'Bevestig wachtwoord', '2014-01-07 21:45:36'),
(1946, 'nl', 'login', 'Create my account', 'Maak mijn account', '2014-01-07 21:45:36'),
(1947, 'nl', 'login', 'Create New Account', 'Maak nieuwe account', '2014-01-07 21:45:36'),
(1948, 'nl', 'login', 'Email', 'E-mail', '2014-01-07 21:45:36'),
(1949, 'nl', 'login', 'emailexist', 'E-mail bestaat al!', '2014-01-07 21:45:36'),
(1950, 'nl', 'login', 'Enter the code as it is shown', 'Vul de afgebeelde code in', '2014-01-07 21:45:36'),
(1951, 'nl', 'login', 'First Name', 'Voornaam', '2014-01-07 21:45:36'),
(1952, 'nl', 'login', 'Last Name', 'Achternaam', '2014-01-07 21:45:36'),
(1953, 'nl', 'login', 'Login', 'Inloggen', '2014-01-07 21:45:36'),
(1954, 'nl', 'login', 'Login incorrect', 'Onjuiste inlog gegevens', '2014-01-07 21:45:36'),
(1955, 'nl', 'login', 'newaccountsuccess', 'Account succesvol geregistreerd!', '2014-01-07 21:45:36'),
(1956, 'nl', 'login', 'Password', 'Wachtwoord', '2014-01-07 21:45:36'),
(1957, 'nl', 'login', 'Password incorrect', 'Onjuist wachtwoord', '2014-01-07 21:45:36'),
(1958, 'nl', 'login', 'Register', 'Registreren', '2014-01-07 21:45:36'),
(1959, 'nl', 'login', 'Sign in to your account', 'Meld u aan bij uw account', '2014-01-07 21:45:36'),
(1960, 'nl', 'login', 'User inactive', 'Gebruiker inactief', '2014-01-07 21:45:36'),
(1961, 'nl', 'login', 'Username', 'Gebruikersnaam', '2014-01-07 21:45:36'),
(1962, 'nl', 'login', 'usernameexist', 'Gebruikersnaam bestaat al!', '2014-01-07 21:45:36'),
(1963, 'nl', 'panel', 'About Us', 'Over ons', '2014-01-07 21:46:33'),
(1964, 'nl', 'panel', 'Add following command to your cron tab', 'Voeg het volgende commando toe aan uw cronjob', '2014-01-07 21:46:33'),
(1965, 'nl', 'panel', 'alsocheckfollowlink', 'Klik op de onderstaande link, voor meer informatie. ', '2014-01-07 21:46:33'),
(1966, 'nl', 'panel', 'Check Directory', 'Controleer directory', '2014-01-07 21:46:33'),
(1967, 'nl', 'panel', 'Cron Command', 'Cronjob commando', '2014-01-07 21:46:33'),
(1968, 'nl', 'panel', 'Directory Manager', 'Directory Manager', '2014-01-07 21:46:33'),
(1969, 'nl', 'panel', 'Edit My Profile', 'Wijzig mijn profiel', '2014-01-07 21:46:33'),
(1970, 'nl', 'panel', 'My Profile', 'Mijn profiel', '2014-01-07 21:46:33'),
(1971, 'nl', 'panel', 'New Proxy', 'Nieuwe Proxy', '2014-01-07 21:46:33'),
(1972, 'nl', 'panel', 'New User', 'Nieuwe gebruiker', '2014-01-07 21:46:33'),
(1973, 'nl', 'panel', 'New Website', 'Nieuwe Website', '2014-01-07 21:46:33'),
(1974, 'nl', 'panel', 'Proxy Manager', 'Proxy Manager', '2014-01-07 21:46:33'),
(1975, 'nl', 'panel', 'Report Generation Manager', 'Rapporten Generatie Manager', '2014-01-07 21:46:33'),
(1976, 'nl', 'panel', 'Reports Manager', 'Rapporten Manager', '2014-01-07 21:46:33'),
(1977, 'nl', 'panel', 'Seo Plugins Manager', 'Seo Plugins Manager', '2014-01-07 21:46:33'),
(1978, 'nl', 'panel', 'Seo Tools Manager', 'Seo Tools Manager', '2014-01-07 21:46:33'),
(1979, 'nl', 'panel', 'System Settings', 'Systeem instellingen', '2014-01-07 21:46:33'),
(1980, 'nl', 'panel', 'User Manager', 'Gebuiker Manager', '2014-01-07 21:46:33'),
(1981, 'nl', 'panel', 'Website Manager', 'Website Manager', '2014-01-07 21:46:33'),
(1982, 'nl', 'plugin', 'Edit Seo Plugin', 'Wijzig Seo Plugin', '2012-05-19 08:28:08'),
(1983, 'nl', 'plugin', 'Plugin Name', 'Plugin Naam', '2012-05-19 08:28:08'),
(1984, 'nl', 'plugin', 'Seo Plugin Details', 'Seo Plugin Details', '2012-05-19 08:28:08'),
(1985, 'nl', 'proxy', 'Edit Proxy', 'Proxy wijzigen', '2014-01-07 21:48:32'),
(1986, 'nl', 'proxy', 'Proxy Password', 'Proxy wachtwoord', '2014-01-07 21:48:32'),
(1987, 'nl', 'proxy', 'Proxy Username', 'Proxy gebruikersnaam', '2014-01-07 21:48:32'),
(1988, 'nl', 'proxy', 'Proxyalreadyexist', 'Proxy bestaat al!', '2014-01-07 21:48:32'),
(1989, 'nl', 'rank', 'enterurlproceed', 'Geef één URL op <b>per regel</b>. Klik op <b>ga verder</b> om de Google en Alexa Rank te controleren.', '2010-10-27 04:25:36'),
(1990, 'nl', 'rank', 'Google and Alexa Rank Reports', 'Google en Alexa Positie rapporten', '2010-10-27 04:25:36'),
(1991, 'nl', 'rank', 'Saved rank results of', 'Rank resultaten opgeslagen voor', '2010-10-27 04:25:36'),
(1992, 'nl', 'saturation', 'clickproceedsaturation', 'Geef één URL op <b>per regel</b>. Klik op <b>ga verder</b> om Zoekmachine Verzadiging te controleren.', '2010-10-27 04:26:25'),
(1993, 'nl', 'saturation', 'GenerateSaturationReports', 'Genereer Zoekmachine Verzadiging Rapporten', '2010-10-27 04:26:25'),
(1994, 'nl', 'saturation', 'Quick Search Engine Saturation Checker', 'Snelle Zoekmachine Verzadiging Controle', '2010-10-27 04:26:25'),
(1995, 'nl', 'saturation', 'Saved Search Engine Saturation results of', 'Resultaten van zoekmachine verzadiging opgeslagen voor', '2010-10-27 04:26:25'),
(1996, 'nl', 'saturation', 'Search Engine Saturation Reports', 'Zoekmachine Verzadiging Rapporten', '2010-10-27 04:26:25'),
(1997, 'nl', 'seotools', 'Automatic Submission', 'Automatische Inschrijving', '2011-07-05 22:20:43'),
(1998, 'nl', 'seotools', 'backlink-checker', 'Backlink Controle', '2011-07-05 22:20:43'),
(1999, 'nl', 'seotools', 'Backlinks Reports', 'Backlink Rapporten', '2011-07-05 22:20:43'),
(2000, 'nl', 'seotools', 'Check Submission Status', 'Controleer Inschrijving Status', '2011-07-05 22:20:43'),
(2001, 'nl', 'seotools', 'clickgeneratereports', 'Klik op <b>ga verder</b> om rapporten te genereren.', '2011-07-05 22:20:43'),
(2002, 'nl', 'seotools', 'Detailed Position Reports', 'Zoekwoord Positie Rapporten', '2011-07-05 22:20:43'),
(2003, 'nl', 'seotools', 'directory-submission', 'Directory Inschrijving', '2011-07-05 22:20:43'),
(2004, 'nl', 'seotools', 'Featured Submission', 'Aanbevolen Inschrijving', '2011-07-05 22:20:43'),
(2005, 'nl', 'seotools', 'Generate Backlinks Reports', 'Genereer Backlink Rapporten', '2011-07-05 22:20:43'),
(2006, 'nl', 'seotools', 'Generate Keyword Reports', 'Genereer Zoekwoord Rapporten', '2011-07-05 22:20:43'),
(2007, 'nl', 'seotools', 'Generate Rank Reports', 'Genereer Rank Rapporten', '2011-07-05 22:20:43'),
(2008, 'nl', 'seotools', 'Generate Saturation Reports', 'Genereer Zoekmachine Verzadiging Rapporten', '2011-07-05 22:20:43'),
(2009, 'nl', 'seotools', 'Google Sitemap Generator', 'Google Sitemap Generator', '2011-07-05 22:20:43'),
(2010, 'nl', 'seotools', 'Graphical Position Reports', 'Grafische Positie Rapporten', '2011-07-05 22:20:43'),
(2011, 'nl', 'seotools', 'Keyword Position Summary', 'Overzicht Zoekwoord Posities', '2011-07-05 22:20:43'),
(2012, 'nl', 'seotools', 'keyword-position-checker', 'Posities van Zoekwoorden', '2011-07-05 22:20:43'),
(2013, 'nl', 'seotools', 'Keywords Manager', 'Zoekwoorden Manager', '2011-07-05 22:20:43'),
(2014, 'nl', 'seotools', 'Quick Backlinks Checker', 'Snelle Backlink Controle', '2011-07-05 22:20:43'),
(2015, 'nl', 'seotools', 'Quick Position Checker', 'Snelle Positie Controle', '2011-07-05 22:20:43'),
(2016, 'nl', 'seotools', 'Quick Rank Checker', 'Snelle Rank Controle', '2011-07-05 22:20:43'),
(2017, 'nl', 'seotools', 'Quick Saturation Checker', 'Snelle Zoekmachine Verzadiging Controle', '2011-07-05 22:20:43'),
(2018, 'nl', 'seotools', 'Rank Reports', 'Rank Rapporten', '2011-07-05 22:20:43'),
(2019, 'nl', 'seotools', 'rank-checker', 'Rank Controle', '2011-07-05 22:20:43'),
(2020, 'nl', 'seotools', 'Saturation Reports', 'Zoekmachine Verzadiging Rapporten', '2011-07-05 22:20:43'),
(2021, 'nl', 'seotools', 'saturation-checker', 'Zoekmachine Verzadiging', '2011-07-05 22:20:43'),
(2022, 'nl', 'seotools', 'sitemap-generator', 'Sitemap Generator', '2011-07-05 22:20:43'),
(2023, 'nl', 'seotools', 'Skipped Directories', 'Overgeslagen Directories', '2011-07-05 22:20:43'),
(2024, 'nl', 'seotools', 'Submission Reports', 'Inschrijving Rapporten', '2011-07-05 22:20:43'),
(2025, 'nl', 'seotools', 'User Access', 'Gebruikers toegang', '2011-07-05 22:20:43'),
(2026, 'nl', 'settings', 'Click here to become a sponsor for Seo Panel', '<b>Doneer $100</b> en wordt Seo Panel <b>Sponsor</b>.', '2014-01-07 21:51:05'),
(2027, 'nl', 'settings', 'SP_CRAWL_DELAY', 'Pauze tussen Crawl queries (in seconden)', '2014-01-07 21:51:05'),
(2028, 'nl', 'settings', 'SP_DEFAULTLANG', 'Standaard taal', '2014-01-07 21:51:05'),
(2029, 'nl', 'settings', 'SP_DESCRIPTION', 'Seo Panel Beschrijving', '2014-01-07 21:51:05'),
(2030, 'nl', 'settings', 'SP_ENABLE_PROXY', 'Proxy activeren', '2014-01-07 21:51:05'),
(2031, 'nl', 'settings', 'SP_HOTLINKING', 'Hotlink beveiliging voor grafieken', '2014-01-07 21:51:05'),
(2032, 'nl', 'settings', 'SP_KEYWORDS', 'Seo Panel Zoekwoorden', '2014-01-07 21:51:05'),
(2033, 'nl', 'settings', 'SP_PAGINGNO', 'Aantal records per pagina', '2014-01-07 21:51:05'),
(2034, 'nl', 'settings', 'SP_TITLE', 'Seo Panel Titel', '2014-01-07 21:51:05'),
(2035, 'nl', 'settings', 'SP_USER_GEN_REPORT', 'Gebruikers toestaan rapporten te genereren', '2014-01-07 21:51:05'),
(2036, 'nl', 'settings', 'SP_USER_REGISTRATION', 'Gebruiker registratie scherm', '2014-01-07 21:51:05'),
(2037, 'nl', 'settings', 'syssettingssaved', 'Systeemvoorkeuren succesvol opgeslagen!', '2014-01-07 21:51:05'),
(2038, 'nl', 'sitemap', 'Change frequency', 'Wijzigingsfrequentie', '2010-10-22 13:27:53'),
(2039, 'nl', 'sitemap', 'clickproceedsitemap', 'Klik op <b>ga verder</b> om een sitemap te maken.', '2010-10-22 13:27:53'),
(2040, 'nl', 'sitemap', 'Download sitemap file from', 'Download sitemap bestand van', '2010-10-22 13:27:53'),
(2041, 'nl', 'sitemap', 'Exclude Url', 'URL uitsluiten', '2010-10-22 13:27:53'),
(2042, 'nl', 'sitemap', 'processtaketime', 'Dit proces kan enige minuten duren afhankelijk van het aantal pagina\\''s op de website. Een moment geduld a.u.b. ', '2010-10-22 13:27:53'),
(2043, 'nl', 'sitemap', 'Sitemap Type', 'Sitemap Type', '2010-10-22 13:27:53'),
(2044, 'nl', 'user', 'Edit User', 'Wijzig gebruiker', '2010-10-16 00:42:51'),
(2045, 'nl', 'user', 'Saved My Profile Details', 'Uw profiel gegevens zijn opgeslaan!', '2010-10-16 00:42:51'),
(2046, 'nl', 'website', 'Edit Website', 'Wijzig website', '2014-01-07 21:53:10'),
(2047, 'nl', 'website', 'plscrtwebsite', 'Voeg eerst een website toe om gebruik te maken van de Seo Tools en Seo Plugins.', '2014-01-07 21:53:10'),
(2048, 'nl', 'website', 'Website already exist', 'Website bestaat al', '2014-01-07 21:53:10'),
(2049, 'nl', 'website', 'yourwebalreday', 'uw website, indien u er al een gemaakt heeft.', '2014-01-07 21:53:10'),
(2050, 'nl', 'support', 'support_cont1', '<fieldset>\r\n<legend>Seo Panel Support Systeem</legend>\r\n<ul class=\\"infobox\\">\r\n	<li>\r\n		<h1>1000 Directories Pakket</h1> \r\n		<p>\r\n			Wij bieden een pakket aan met <b>1000 gratis, actieve en gecontroleerde </b> Directories, ter integratie in uw <b>Directory Inschrijving Tool</b>.\r\n			Dit zal helpen het aantal <b>backlinks</b> van uw eigen websites <b>aanzienlijk te verhogen</b>.\r\n			Wij bieden deze lijst momenteel aan om geld in te zamelen voor <b>de toekomstige ontwikkelingen</b> van Seo panel. \r\n			<a href=\\"<?=SP_DONATE_LINK?>\\" target=\\"_blank\\">Doneer</a> $10 of meer om Seo Panel verder te helpen ontwikkelen en verbeteren.\r\n			Als u vragen hebt over het 1000 directories pakket, neem dan gerust<a href=\\"<?=SP_CONTACT_LINK?>\\" target=\\"_blank\\">contact</a> op of open een ticket in het <a href=\\"<?=SP_SUPPORT_LINK?>\\" target=\\"_blank\\">support</a> systeem.\r\n		</p>		\r\n		<p>\r\n			<a href=\\"<?=SP_DONATE_LINK?>\\" target=\\"_blank\\">Klik hier om een donatie aan Seo Panel te doen.</a>\r\n		</p>\r\n		<br>\r\n	</li>\r\n	\r\n	<li>\r\n		<h1>Het Lokale Zoekmachine Pakket</h1> \r\n		<p>\r\n			Voeg <b>lokale zoekmachines</b> toe van google,yahoo en msn (<b>Bv.: www.google.nl, www.google.fr etc</b>) aan Seo Panel <b>Posities en Zoekwoorden</b>, om uw site performance lokaal te kunnen controleren. \r\n			Om het lokale zoekmachines pakket (op basis van uw behoefte) te ontvangen <a href=\\"<?=SP_DONATE_LINK?>\\" target=\\"_blank\\">doneert u</a> $10 of meer om de functies van SEO panel te verbeteren.\r\n			Neemt u voordat u doneert  <a href=\\"<?=SP_CONTACT_LINK?>\\" target=\\"_blank\\">contact</a> met ons op met een lijst van de gewenste lokale zoekmachine toevoegingen.\r\n			<br><br>			  \r\n			Om <b>nieuwe zoekmachines (bijvoorbeeld: baidu.com)</b> toe te voegen, neemt u <a href=\\"<?=SP_CONTACT_LINK?>\\" target=\\"_blank\\">contact</a> met ons op of opent u een ticket in het <a href=\\"<?=SP_SUPPORT_LINK?>\\" target=\\"_blank\\">Support System</a>. \r\n		</p>		\r\n		<p class=\\"visit\\">\r\n			<a href=\\"<?=SP_CONTACT_LINK?>\\" target=\\"_blank\\">Klik hier om contact op te nemen.</a>\r\n		</p>\r\n		<br>\r\n	</li>\r\n	\r\n	<li>\r\n		<h1>Seo Panel Plugins</h1> \r\n		<p>\r\n			Voeg <b>Seo plugins</b> toe om uw Seo panel <b>functies uit te breiden</b> volgens uw behoefte. <a href=\\"<?=SP_PLUGINSITE?>\\" target=\\"_blank\\">Seo panel plugins</a> worden geleverd door zowel Seo panel als sites van derden. U kunt zelf ook makkelijk Seo plugins <b>ontwikkelen</b> voor Seo Panel. U kunt uw Seo plugin <a href=\\"<?=SP_PLUGINSITE?>\\" target=\\"_blank\\">opsturen naar Seo Panel</a> en wij zullen deze vervolgens publiceren op onze website nadat wij deze <b>getest</b> hebben.\r\n			\r\n		</p>		\r\n		<p>\r\n			<a href=\\"<?=SP_PLUGINSITE?>\\" target=\\"_blank\\">Klik hier voor Seo Panel Plugins</a>\r\n		</p>\r\n		<br>\r\n	</li>	\r\n	<li>\r\n		<h1>Contact</h1> \r\n		<p>\r\n			Neem contact met ons op voor eventuele vragen over <b>Seo Panel Tools, Plugins, Functies, etc..</b> met behulp van de onderstaande link.\r\n		</p>		\r\n		<p>\r\n			<a href=\\"<?=SP_CONTACT_LINK?>\\" target=\\"_blank\\">Klik hier om contact op te nemen.</a>\r\n		</p>\r\n		<br>\r\n	</li>	\r\n	<li>\r\n		<h1>Support Tickets</h1> \r\n		<p>\r\n			Voor <b>technische Ondersteuning</b> van het Seo Panel Team voor het instellen van <b>Seo Panel tools, plugins en andere functies</b>. Bijvoorbeeld voor het instellen van een Cronjob.\r\n		</p>		\r\n		<p>\r\n			<a href=\\"<?=SP_SUPPORT_LINK?>\\" target=\\"_blank\\">Klik hier om een support ticket aan te maken.</a>\r\n		</p>\r\n		<br>\r\n	</li>	\r\n	<li>\r\n		<h1>Bugs rapporteren.</h1> \r\n		<p>\r\n		Help ons door <b>bugs</b> te rapporteren van <b>Seo Panel Tools, Plugins en Functies</b> met behulp van onderstaande link. \r\n		\r\n		</p>		\r\n		<p>\r\n			<a href=\\"<?=SP_SUPPORT_LINK?>\\" target=\\"_blank\\">Klik hier om bugs te rapporteren.</a>\r\n		</p>\r\n		<br>\r\n	</li>	\r\n</ul>\r\n</fieldset>\r\n', '2010-10-27 04:56:53'),
(2051, 'nl', 'support', 'support_cont2', '<fieldset>\r\n<legend>Seo Panel Online Naslag</legend>\r\n<ul class=\\"infobox\\">\r\n		\r\n	<li>\r\n		<h1>Seo Panel Hulp</h1> \r\n		<p>\r\n		U kunt de <a href=\\"<?=SP_HELP_LINK?>\\" target=\\"_blank\\">Seo panel documentatie</a> in de <b>hulp gids</b> vinden, het bevat de <b>documentatie</b> voor de Seo panel tools, plugins en aanverwante functies.\r\n		<br>Het is de beste plek op internet om <b>hulp</b> te krijgen voor Seo panel. We hopen dat u bijdraagt aan de SEO Panel \\"hulp gids\\", indien u fouten vindt of als er zaken ontbreken.\r\n		</p>\r\n		<p>\r\n			<a href=\\"<?=SP_HELP_LINK?>\\" target=\\"_blank\\">Klik hier om de hulp gids te bekijken.</a>\r\n		</p>\r\n		<br>\r\n	</li>	\r\n	<li>\r\n		<h1>Seo Panel Forum</h1> \r\n		<p>\r\n		De plek om te discussiëren over \\''s werelds eerste open source <b>Seo bedieningspaneel</b>. Het is de beste plek om <b>antwoorden</b> te vinden op uw vragen over Seo Panel.\r\n		<br>Ook kunt u uw <b>ervaringen uitwisselen</b> tijdens het gebruik van Seo Panel voor het optimaliseren van uw websites.	          \r\n		</p>		\r\n		<p>\r\n			<a href=\\"<?=SP_FORUM_LINK?>\\" target=\\"_blank\\">Klik hier om naar het Seo Panel Forum te gaan.</a>\r\n		</p>\r\n		<br>\r\n	</li>\r\n</ul>	\r\n</fieldset>', '2010-10-27 04:56:53'),
(2052, 'nl', 'support', 'support_cont3', '<fieldset>\r\n<legend>Doneren voor Seo Panel</legend>\r\n<ul class=\\"infobox\\">		\r\n	<li>\r\n		<h1>Geef een donatie voor de verbetering van - \\''s werelds eerste Open Source Seo Bedieningspaneel.</h1> \r\n		<p>\r\n			<b>Doneer</b> aan Seo Panel om de \\''s werelds eerste Open Source Seo Software te ondersteunen.\r\n			\r\n			We zijn van plan om in de toekomst <b>nieuwe functies</b> toe te voegen en Seo Panel te <b>verbeteren</b>.<br>Alleen met uw steun kunnen we onze doelstellingen bereiken. Indien u vindt dat Seo panel voor u de moeite waard is, draag dan a.u.b. een steentje bij.\r\n			Zodra wij uw donatie hebben ontavngen zullen wij uw naam en website vernoemen op onze <a href=\\"<?=SP_DONATE_LINK?>\\" target=\\"_blank\\">donatie pagina</a>.\r\n			\r\n		</p>\r\n		<p>\r\n			<a href=\\"<?=SP_DONATE_LINK?>\\" target=\\"_blank\\">Klik hier om te doneren aan Seo Panel.</a>\r\n		</p>\r\n		<br>\r\n	</li>\r\n</ul>\r\n</fieldset>', '2010-10-27 04:56:53'),
(2054, 'nl', 'settings', 'seopanel_title', 'Seo Panel: ''s Werelds eerste open source Seo bedieningspaneel voor meerdere websites', '2014-01-07 21:51:05'),
(2055, 'it', 'keyword', 'Crawling keyword', 'Scansiona parole chiave', '2016-12-09 09:18:13'),
(2056, 'it', 'keyword', 'Detailed Keyword Position Reports', 'Dettagli report posizione keywords', '2016-12-09 09:18:13'),
(2057, 'it', 'keyword', 'Edit Keyword', 'Modifica keyword', '2016-12-09 09:18:13'),
(2058, 'it', 'keyword', 'Graphical Keyword Position Reports', 'Report grafico posizione keyword', '2016-12-09 09:18:13'),
(2059, 'it', 'keyword', 'Import Keywords', 'Importa keywords', '2016-12-09 09:18:13'),
(2060, 'it', 'keyword', 'Keyword already exist', 'Keyword già esistente', '2016-12-09 09:18:13'),
(2061, 'it', 'keyword', 'Keyword Position Report', 'Report posizione keyword', '2016-12-09 09:18:13'),
(2062, 'it', 'keyword', 'New Keyword', 'Nuova keyword', '2016-12-09 09:18:13'),
(2063, 'it', 'keyword', 'not assigned to required search engines', 'non assegnato ai motori di ricerca richiesti', '2016-12-09 09:18:13'),
(2064, 'it', 'keyword', 'pleaseselecttool', 'Per cortesia seleziona almeno uno strumento seo', '2016-12-09 09:18:13'),
(2065, 'it', 'keyword', 'Quick Keyword Position Checker', 'Verifica rapida posizione keyword', '2016-12-09 09:18:13'),
(2066, 'it', 'keyword', 'results from ', 'risultati da', '2016-12-09 09:18:13'),
(2067, 'it', 'keyword', 'Show All results', 'Mostra tutti i risultati', '2016-12-09 09:18:13'),
(2068, 'it', 'keyword', 'Successfully crawled keyword', 'Scansione keyword eseguita con successo', '2016-12-09 09:18:13'),
(2069, 'it', 'keyword', 'to create new keywords', 'per creare nuove keyword', '2016-12-09 09:18:13'),
(2070, 'it', 'label', 'already exist', 'già esiste', '2016-12-09 09:18:33'),
(2071, 'it', 'label', 'Authentication', 'Autenticazione', '2016-12-09 09:18:33'),
(2072, 'it', 'label', 'Author', 'Autore', '2016-12-09 09:18:33'),
(2073, 'it', 'label', 'Click Here', 'Clicca quì', '2016-12-09 09:18:33'),
(2074, 'it', 'label', 'Cron', 'Cron', '2016-12-09 09:18:33'),
(2075, 'it', 'label', 'Description', 'Descrizione', '2016-12-09 09:18:33'),
(2076, 'it', 'label', 'Developers', 'Sviluppatori', '2016-12-09 09:18:33'),
(2077, 'it', 'label', 'Download', 'Download', '2016-12-09 09:18:33'),
(2078, 'it', 'label', 'Installation', 'Installazione', '2016-12-09 09:18:33'),
(2079, 'it', 'label', 'Keywords', 'Keyword', '2016-12-09 09:18:33'),
(2080, 'it', 'label', 'noactiveplugins', 'Non è stato trovato alcun Plugin Seo attivo!', '2016-12-09 09:18:33'),
(2081, 'it', 'label', 'Plugin', 'Plugin', '2016-12-09 09:18:33'),
(2082, 'it', 'label', 'Port', 'Porta', '2016-12-09 09:18:33'),
(2083, 'it', 'label', 'Proxy', 'Proxy', '2016-12-09 09:18:33'),
(2084, 'it', 'label', 'Re-install', 'Re-installa', '2016-12-09 09:18:33'),
(2085, 'it', 'label', 'Sponsors', 'Sponsor', '2016-12-09 09:18:33'),
(2086, 'it', 'label', 'Title', 'Titolo', '2016-12-09 09:18:33'),
(2087, 'it', 'label', 'translation by', 'Tradotto da', '2016-12-09 09:18:33'),
(2088, 'it', 'label', 'Translators', 'Traduttori', '2016-12-09 09:18:33'),
(2089, 'it', 'label', 'Upgrade', 'Aggiornamento', '2016-12-09 09:18:33'),
(2090, 'it', 'label', 'Version', 'Versione', '2016-12-09 09:18:33'),
(2091, 'it', 'label', 'wantproceed', 'Vuoi procedere veramente?', '2016-12-09 09:18:33'),
(2092, 'it', 'panel', 'About Us', 'Su di noi', '2016-12-09 09:19:55'),
(2093, 'it', 'panel', 'Add following command to your cron tab', 'Aggiungi i seguenti comandi alle tue azioni pianificate', '2016-12-09 09:19:55'),
(2094, 'it', 'panel', 'alsocheckfollowlink', 'Verificare anche se i seguenti link necessitano di maggiori dettagli.', '2016-12-09 09:19:55'),
(2095, 'it', 'panel', 'Check Directory', 'Verifica directory', '2016-12-09 09:19:55'),
(2096, 'it', 'panel', 'Cron Command', 'Comando azione pianificata', '2016-12-09 09:19:55'),
(2097, 'it', 'panel', 'Directory Manager', 'Gestione directory', '2016-12-09 09:19:55'),
(2098, 'it', 'panel', 'Edit My Profile', 'Modifica il mio profilo', '2016-12-09 09:19:55'),
(2099, 'it', 'panel', 'My Profile', 'Mio profilo', '2016-12-09 09:19:55'),
(2100, 'it', 'panel', 'New Proxy', 'Nuovo proxy', '2016-12-09 09:19:55'),
(2101, 'it', 'panel', 'New User', 'Nuovo utente', '2016-12-09 09:19:55'),
(2102, 'it', 'panel', 'New Website', 'Nuovo sito web', '2016-12-09 09:19:55'),
(2103, 'it', 'panel', 'Proxy Manager', 'Gestione proxy', '2016-12-09 09:19:55'),
(2104, 'it', 'panel', 'Report Generation Manager', 'Gestione generazione report', '2016-12-09 09:19:55'),
(2105, 'it', 'panel', 'Reports Manager', 'Gestione report', '2016-12-09 09:19:55'),
(2106, 'it', 'panel', 'Seo Plugins Manager', 'Gestione plugin seo', '2016-12-09 09:19:55'),
(2107, 'it', 'panel', 'Seo Tools Manager', 'Gestione strumenti seo', '2016-12-09 09:19:55'),
(2108, 'it', 'panel', 'System Settings', 'Impostazioni di sistema', '2016-12-09 09:19:55'),
(2109, 'it', 'panel', 'User Manager', 'Gestione utente', '2016-12-09 09:19:55'),
(2110, 'it', 'panel', 'Website Manager', 'Gestione sito web', '2016-12-09 09:19:55'),
(2111, 'it', 'plugin', 'Edit Seo Plugin', 'Modifica plugin seo', '2012-05-12 10:38:03'),
(2112, 'it', 'plugin', 'Plugin Name', 'Nome plugin', '2012-05-12 10:38:03'),
(2113, 'it', 'plugin', 'Seo Plugin Details', 'Dettagli plugin seo', '2012-05-12 10:38:03'),
(2114, 'it', 'proxy', 'Edit Proxy', 'Modifica proxy', '2016-12-09 09:20:46'),
(2115, 'it', 'proxy', 'Proxy Password', 'Password proxy', '2016-12-09 09:20:46'),
(2116, 'it', 'proxy', 'Proxy Username', 'Nome utente proxy', '2016-12-09 09:20:46'),
(2117, 'it', 'proxy', 'Proxyalreadyexist', 'Il proxy già esiste!', '2016-12-09 09:20:46'),
(2118, 'it', 'rank', 'enterurlproceed', 'Inserisci le URL <b>una per riga</b>. Clicca su <b>Procedi</b> per verificare il rank di Google e Alexa. ', '2010-10-15 20:50:06'),
(2119, 'it', 'rank', 'Google and Alexa Rank Reports', 'Report rank di Google e Alexs', '2010-10-15 20:50:06'),
(2120, 'it', 'rank', 'Saved rank results of', 'Salva i risultati del rank per', '2010-10-15 20:50:06'),
(2121, 'it', 'saturation', 'clickproceedsaturation', 'Inserisci le URL <b>Una per riga</b>. Clicca su <b>Procedi</b> per salvare i risultati di saturazione dei motori di ricerca.', '2010-10-15 20:52:19'),
(2122, 'it', 'saturation', 'GenerateSaturationReports', 'Genera report sulla saturazione dei motori di ricerca', '2010-10-15 20:52:19'),
(2123, 'it', 'saturation', 'Quick Search Engine Saturation Checker', 'Verifica rapida saturazione motori di ricerca', '2010-10-15 20:52:19'),
(2124, 'it', 'saturation', 'Saved Search Engine Saturation results of', 'Salva i risultati della saturazione dei motori di ricerca per', '2010-10-15 20:52:19'),
(2125, 'it', 'saturation', 'Search Engine Saturation Reports', 'Report saturazione motori di ricerca', '2010-10-15 20:52:19'),
(2126, 'it', 'seotools', 'Automatic Submission', 'Invio automatico', '2011-07-10 20:17:34'),
(2127, 'it', 'seotools', 'backlink-checker', 'Verifica backlink', '2011-07-10 20:17:34'),
(2128, 'it', 'seotools', 'Backlinks Reports', 'Report backlink', '2011-07-10 20:17:34'),
(2129, 'it', 'seotools', 'Check Submission Status', 'Verifica stato invio', '2011-07-10 20:17:34'),
(2130, 'it', 'seotools', 'clickgeneratereports', 'Clicca su <b>Procedi</b> per generare il report', '2011-07-10 20:17:34'),
(2131, 'it', 'seotools', 'Detailed Position Reports', 'Dettagli report posizione', '2011-07-10 20:17:34'),
(2132, 'it', 'seotools', 'directory-submission', 'Invio directory', '2011-07-10 20:17:34'),
(2133, 'it', 'seotools', 'Featured Submission', 'Caratteristiche invio', '2011-07-10 20:17:34'),
(2134, 'it', 'seotools', 'Generate Backlinks Reports', 'Genera report dei backlink', '2011-07-10 20:17:34'),
(2135, 'it', 'seotools', 'Generate Keyword Reports', 'Genera report delle keyword', '2011-07-10 20:17:34'),
(2136, 'it', 'seotools', 'Generate Rank Reports', 'Genera raport del rank', '2011-07-10 20:17:34'),
(2137, 'it', 'seotools', 'Generate Saturation Reports', 'Genera report della saturazione', '2011-07-10 20:17:34'),
(2138, 'it', 'seotools', 'Google Sitemap Generator', 'Genera sitemap google', '2011-07-10 20:17:34'),
(2139, 'it', 'seotools', 'Graphical Position Reports', 'Report grafico di posizionamento', '2011-07-10 20:17:34'),
(2140, 'it', 'seotools', 'Keyword Position Summary', 'Sommario posizionamento keyword', '2011-07-10 20:17:34'),
(2141, 'it', 'seotools', 'keyword-position-checker', 'Verifica posizionamento keyword', '2011-07-10 20:17:34'),
(2142, 'it', 'seotools', 'Keywords Manager', 'Gestione keyword', '2011-07-10 20:17:34'),
(2143, 'it', 'seotools', 'Quick Backlinks Checker', 'Verifica rapida backlink', '2011-07-10 20:17:34'),
(2144, 'it', 'seotools', 'Quick Position Checker', 'Verifica rapida posizionamento', '2011-07-10 20:17:34'),
(2145, 'it', 'seotools', 'Quick Rank Checker', 'Verifica rapida rank', '2011-07-10 20:17:34'),
(2146, 'it', 'seotools', 'Quick Saturation Checker', 'Verifica rapida saturazione', '2011-07-10 20:17:34'),
(2147, 'it', 'seotools', 'Rank Reports', 'Report rank', '2011-07-10 20:17:34'),
(2148, 'it', 'seotools', 'rank-checker', 'Verifica rank', '2011-07-10 20:17:34'),
(2149, 'it', 'seotools', 'Saturation Reports', 'Report saturazione', '2011-07-10 20:17:34'),
(2150, 'it', 'seotools', 'saturation-checker', 'Saturazione motori di ricerca', '2011-07-10 20:17:34'),
(2151, 'it', 'seotools', 'sitemap-generator', 'Generatore sitemap', '2011-07-10 20:17:34'),
(2152, 'it', 'seotools', 'Skipped Directories', 'Directory saltate', '2011-07-10 20:17:34'),
(2153, 'it', 'seotools', 'Submission Reports', 'Report di invio', '2011-07-10 20:17:34'),
(2154, 'it', 'seotools', 'User Access', 'Accesso utente', '2011-07-10 20:17:34'),
(2155, 'it', 'settings', 'Click here to become a sponsor for Seo Panel', '<b>Dona $100</b> e diventa <b>sponsor</b> del pannello seo.', '2016-12-09 09:21:50'),
(2156, 'it', 'settings', 'seopanel_description', 'Un pannello di controllo gratuito per gestire l''ottimizzazione dei tuoi siti web. Contiene molti tool seo che potranno esserti utili per incrementare e verificare le performance dei tuoi siti web. Si tratta di un progetto open source e puoi sviluppare i tuoi stessi plugin seo per il pannello seo.', '2016-12-09 09:21:50'),
(2157, 'it', 'settings', 'seopanel_title', 'Pannello seo: Il primo pannello di controllo open source per la gestione di più siti web.', '2016-12-09 09:21:50'),
(2158, 'it', 'settings', 'SP_CRAWL_DELAY', 'Ritardo tra ogni scansione degli spider (secondi)', '2016-12-09 09:21:50'),
(2159, 'it', 'settings', 'SP_DEFAULTLANG', 'Lingua di default', '2016-12-09 09:21:50'),
(2160, 'it', 'settings', 'SP_DESCRIPTION', 'Descrizione pannello seo', '2016-12-09 09:21:50'),
(2161, 'it', 'settings', 'SP_ENABLE_PROXY', 'Abilita proxy', '2016-12-09 09:21:50'),
(2162, 'it', 'settings', 'SP_HOTLINKING', 'Protezione immagine hotlink attiva', '2016-12-09 09:21:50'),
(2163, 'it', 'settings', 'SP_KEYWORDS', 'Keyword pannello seo', '2016-12-09 09:21:50'),
(2164, 'it', 'settings', 'SP_PAGINGNO', 'Numero di risultati per pagina', '2016-12-09 09:21:50'),
(2165, 'it', 'settings', 'SP_TITLE', 'Titolo pannello seo', '2016-12-09 09:21:50'),
(2166, 'it', 'settings', 'SP_USER_GEN_REPORT', 'Permetti a tutti gli utenti di generare report', '2016-12-09 09:21:50'),
(2167, 'it', 'settings', 'SP_USER_REGISTRATION', 'Interfaccia registrazione utente', '2016-12-09 09:21:50'),
(2168, 'it', 'settings', 'syssettingssaved', 'Impostazioni di sistema salvate con successo!', '2016-12-09 09:21:50'),
(2169, 'zh', 'backlink', 'clickproceedbacklink', '输入URL，<b>每行一条</b>。单击<b>处理</b>开始检测反向链接', '2011-05-06 08:30:24'),
(2170, 'zh', 'backlink', 'Saved backlink results of', '保存反向链接结果', '2011-05-06 08:30:24'),
(2171, 'zh', 'button', 'Cancel', '取消', '2014-01-08 19:21:34'),
(2172, 'zh', 'button', 'Check Status', '检测状态', '2014-01-08 19:21:34'),
(2173, 'zh', 'button', 'Proceed', '处理', '2014-01-08 19:21:34'),
(2174, 'zh', 'button', 'Reload', '重新载入', '2014-01-08 19:21:34'),
(2175, 'zh', 'button', 'Show Details', '显示细节', '2014-01-08 19:21:34'),
(2176, 'zh', 'button', 'Show Records', '显示记录', '2014-01-08 19:21:34'),
(2177, 'zh', 'button', 'Skip', '跳过', '2014-01-08 19:21:34'),
(2178, 'zh', 'button', 'Submit', '提交', '2014-01-08 19:21:34'),
(2179, 'zh', 'common', 'Action', '执行', '2014-01-09 15:04:07'),
(2180, 'zh', 'common', 'Activate', '激活', '2014-01-09 15:04:07'),
(2181, 'zh', 'common', 'Active', '已激活', '2014-01-09 15:04:07'),
(2182, 'zh', 'common', 'Admin Panel', '管理面板', '2014-01-09 15:04:07'),
(2183, 'zh', 'common', 'Alexa Rank', 'Alexa 排名', '2014-01-09 15:04:07'),
(2184, 'zh', 'common', 'All', '所有', '2014-01-09 15:04:07'),
(2185, 'zh', 'common', 'Category', '类别', '2014-01-09 15:04:07'),
(2186, 'zh', 'common', 'contact', '联系', '2014-01-09 15:04:07'),
(2187, 'zh', 'common', 'copyright', '版权所有 © 【2010】www.seopanel.in 保留所有权利', '2014-01-09 15:04:07'),
(2188, 'zh', 'common', 'Country', '国家', '2014-01-09 15:04:07'),
(2189, 'zh', 'common', 'Crawl Meta Data', '爬取meta信息', '2014-01-09 15:04:07'),
(2190, 'zh', 'common', 'Date', '日期', '2014-01-09 15:04:07'),
(2191, 'zh', 'common', 'Delete', '删除', '2014-01-09 15:04:07'),
(2192, 'zh', 'common', 'Details', '细节', '2014-01-09 15:04:07'),
(2193, 'zh', 'common', 'Directory', '目录', '2014-01-09 15:04:07'),
(2194, 'zh', 'common', 'Donate', '捐赠', '2014-01-09 15:04:07'),
(2195, 'zh', 'common', 'Edit', '编辑', '2014-01-09 15:04:07'),
(2196, 'zh', 'common', 'Entry cannot be blank', '不能输入空值', '2014-01-09 15:04:07'),
(2197, 'zh', 'common', 'entrynotvalid', '输入不合法', '2014-01-09 15:04:07'),
(2198, 'zh', 'common', 'failed', '失败', '2014-01-09 15:04:07'),
(2199, 'zh', 'common', 'forum', '论坛', '2014-01-09 15:04:07'),
(2200, 'zh', 'common', 'Found', '资助', '2014-01-09 15:04:07'),
(2201, 'zh', 'common', 'Google Pagerank', '谷歌 Page Rank', '2014-01-09 15:04:07'),
(2202, 'zh', 'common', 'help', '帮助', '2014-01-09 15:04:07'),
(2203, 'zh', 'common', 'hidenews', '隐藏seopanel新闻', '2014-01-09 15:04:07'),
(2204, 'zh', 'common', 'Id', 'Id', '2014-01-09 15:04:07'),
(2205, 'zh', 'common', 'Inactivate', '关闭', '2014-01-09 15:04:07'),
(2206, 'zh', 'common', 'Inactive', '未激活的', '2014-01-09 15:04:07'),
(2207, 'zh', 'common', 'Invalid characters', '非法字符', '2014-01-09 15:04:07'),
(2208, 'zh', 'common', 'Invalid code entered', '输入的代码不合法', '2014-01-09 15:04:07'),
(2209, 'zh', 'common', 'Invalid email address entered', 'Email 地址不合法', '2014-01-09 15:04:07'),
(2210, 'zh', 'common', 'Invalid value', '无效数值', '2014-01-09 15:04:07'),
(2211, 'zh', 'common', 'Keyword', '关键字', '2014-01-09 15:04:07'),
(2212, 'zh', 'common', 'Keywords', '全部关键字', '2014-01-09 15:04:07'),
(2213, 'zh', 'common', 'lang', '语言', '2014-01-09 15:04:07'),
(2214, 'zh', 'common', 'My Account', '我的账户', '2014-01-09 15:04:07'),
(2215, 'zh', 'common', 'Name', '名字', '2014-01-09 15:04:07'),
(2216, 'zh', 'common', 'No', '没有', '2014-01-09 15:04:07'),
(2217, 'zh', 'common', 'No Keywords Found', '未找到关键字', '2014-01-09 15:04:07'),
(2218, 'zh', 'common', 'No Records Found', '未找到相关记录', '2014-01-09 15:04:07'),
(2219, 'zh', 'common', 'noactivetools', '没有可用的seo工具', '2014-01-09 15:04:07'),
(2220, 'zh', 'common', 'nowebsites', '未发现站点', '2014-01-09 15:04:07'),
(2221, 'zh', 'common', 'password632', '密码长度必须为6-32位', '2014-01-09 15:04:07'),
(2222, 'zh', 'common', 'passwordnotmatch', '密码不匹配', '2014-01-09 15:04:07'),
(2223, 'zh', 'common', 'Period', '一段时间', '2014-01-09 15:04:07'),
(2224, 'zh', 'common', 'Priority', '优先级', '2014-01-09 15:04:07'),
(2225, 'zh', 'common', 'Rank', 'PR/排名', '2014-01-09 15:04:07'),
(2226, 'zh', 'common', 'Reports', '报告', '2014-01-09 15:04:07'),
(2227, 'zh', 'common', 'Results', '结果', '2014-01-09 15:04:07'),
(2228, 'zh', 'common', 'Search Engine', '搜索引擎', '2014-01-09 15:04:07'),
(2229, 'zh', 'common', 'Select', '选择', '2014-01-09 15:04:07'),
(2230, 'zh', 'common', 'Seo Plugins', 'seo插件', '2014-01-09 15:04:07'),
(2231, 'zh', 'common', 'Seo Tools', 'seo工具', '2014-01-09 15:04:07'),
(2232, 'zh', 'common', 'Sign out', '登出', '2014-01-09 15:04:07'),
(2233, 'zh', 'common', 'Sign Up', '注册', '2014-01-09 15:04:07'),
(2234, 'zh', 'common', 'signin', '登录', '2014-01-09 15:04:07'),
(2235, 'zh', 'common', 'Status', '状态', '2014-01-09 15:04:07'),
(2236, 'zh', 'common', 'Support', '支持', '2014-01-09 15:04:07'),
(2237, 'zh', 'common', 'Total', '所有', '2014-01-09 15:04:07'),
(2238, 'zh', 'common', 'Url', 'URL', '2014-01-09 15:04:07'),
(2239, 'zh', 'common', 'User', '用户', '2014-01-09 15:04:07'),
(2240, 'zh', 'common', 'User Panel', '用户面板', '2014-01-09 15:04:07'),
(2241, 'zh', 'common', 'Website', '站点', '2014-01-09 15:04:07'),
(2242, 'zh', 'common', 'Yes', '是', '2014-01-09 15:04:07'),
(2243, 'zh', 'directory', 'Add back to directory list', '增加到目录列表', '2014-01-09 15:03:35'),
(2244, 'zh', 'directory', 'Approved', '通过的', '2014-01-09 15:03:35'),
(2245, 'zh', 'directory', 'Captcha', '验证码', '2014-01-09 15:03:35'),
(2246, 'zh', 'directory', 'categorynote', '根据优先级用逗号隔开的提交的具体目录分类。从优先级最高提交的具体目录分类开始', '2014-01-09 15:03:35'),
(2247, 'zh', 'directory', 'Check Directory Status', '检查目录状态', '2014-01-09 15:03:35'),
(2248, 'zh', 'directory', 'Check Directory Submission Status', '检查目录提交状态', '2014-01-09 15:03:35'),
(2249, 'zh', 'directory', 'clicktoproceeddirsts', '点击<b>处理</b> 以检查目录状态', '2014-01-09 15:03:35'),
(2250, 'zh', 'directory', 'Confirmation', '确认', '2014-01-09 15:03:35'),
(2251, 'zh', 'directory', 'desnote', '有些目录最少需要150字符描述信息', '2014-01-09 15:03:35'),
(2252, 'zh', 'directory', 'Directories with out captcha', '没有验证码的目录', '2014-01-09 15:03:35'),
(2253, 'zh', 'directory', 'Directory Submission Reports', '目录提交报告', '2014-01-09 15:03:35'),
(2254, 'zh', 'directory', 'Enter the code shown', '输入显示的字符', '2014-01-09 15:03:35'),
(2255, 'zh', 'directory', 'nocatnote', '在提交页面未找到提交类别。请点击<b>重载</b>或者<b>跳过</b>', '2014-01-09 15:03:35'),
(2256, 'zh', 'directory', 'nodirnote', '未发现<b>已激活的</b>目录', '2014-01-09 15:03:35'),
(2257, 'zh', 'directory', 'nosuccessnote', '如果没得到成功的信息，请检查邮件中的确认信息', '2014-01-09 15:03:35'),
(2258, 'zh', 'directory', 'optionalnote', '提交标题和描述信息比提交随机信息会获得更好的结果', '2014-01-09 15:03:35'),
(2259, 'zh', 'directory', 'Owner Email', '用户邮件', '2014-01-09 15:03:35'),
(2260, 'zh', 'directory', 'Owner Name', '用户名字', '2014-01-09 15:03:35'),
(2261, 'zh', 'directory', 'Pending', '待定', '2014-01-09 15:03:35'),
(2262, 'zh', 'directory', 'Please select a website to proceed', '请选择一个站点来处理', '2014-01-09 15:03:35'),
(2263, 'zh', 'directory', 'selectwebsiteproceed', '选择一个 <b>站点</b> 来 <b>处理</b> 目录提交。<br>检查 <b>没有验证码的目录</b> 来提交没有验证码的目录', '2014-01-09 15:03:35'),
(2264, 'zh', 'directory', 'selectwebsiteschecksub', '选择一个<b>站点</b> 来 <b>处理</b> 检查目录提交信息', '2014-01-09 15:03:35'),
(2265, 'zh', 'directory', 'Semi Automatic Directory Submission Tool', '半自动目录提交工具', '2014-01-09 15:03:35'),
(2266, 'zh', 'directory', 'spamemailnote', '一些目录可能会发送垃圾邮件，我们建议不要不要使用你常用的邮箱地址', '2014-01-09 15:03:35'),
(2267, 'zh', 'directory', 'Submission Details', '提交细节', '2014-01-09 15:03:35'),
(2268, 'zh', 'directory', 'Submit Description', '提交描述信息', '2014-01-09 15:03:35'),
(2269, 'zh', 'directory', 'Submit Keywords', '提交关键字', '2014-01-09 15:03:35'),
(2270, 'zh', 'directory', 'Submit Title', '提交标题', '2014-01-09 15:03:35'),
(2271, 'zh', 'directory', 'Website Category', '网站目录', '2014-01-09 15:03:35'),
(2272, 'zh', 'directory', 'Website Url', '网站地址', '2014-01-09 15:03:35'),
(2273, 'zh', 'keyword', 'Crawling keyword', '爬取关键字', '2011-07-06 06:03:07'),
(2274, 'zh', 'keyword', 'Detailed Keyword Position Reports', '显示关键字排名报告', '2011-07-06 06:03:07'),
(2275, 'zh', 'keyword', 'Edit Keyword', '编辑关键字', '2011-07-06 06:03:07'),
(2276, 'zh', 'keyword', 'Graphical Keyword Position Reports', '关键字位置图形报表', '2011-07-06 06:03:07'),
(2277, 'zh', 'keyword', 'Import Keywords', '导入关键字', '2011-07-06 06:03:07'),
(2278, 'zh', 'keyword', 'Keyword already exist', '关键字已存在', '2011-07-06 06:03:07'),
(2279, 'zh', 'keyword', 'Keyword Position Report', '关键字位置报告', '2011-07-06 06:03:07'),
(2280, 'zh', 'keyword', 'New Keyword', '新的关键字', '2011-07-06 06:03:07'),
(2281, 'zh', 'keyword', 'not assigned to required search engines', '未设置请求的搜索引擎', '2011-07-06 06:03:07'),
(2282, 'zh', 'keyword', 'pleaseselecttool', '请至少选择一个seo工具', '2011-07-06 06:03:07'),
(2283, 'zh', 'keyword', 'Quick Keyword Position Checker', '快速关键字查询', '2011-07-06 06:03:07'),
(2284, 'zh', 'keyword', 'results from ', '结果来自', '2011-07-06 06:03:07'),
(2285, 'zh', 'keyword', 'Show All results', '显示所有结果', '2011-07-06 06:03:07'),
(2286, 'zh', 'keyword', 'Successfully crawled keyword', '成功爬取关键字', '2011-07-06 06:03:07'),
(2287, 'zh', 'keyword', 'to create new keywords', '创建新关键字', '2011-07-06 06:03:07'),
(2288, 'zh', 'login', 'Confirm Password', '确认密码', '2014-01-09 15:07:15'),
(2289, 'zh', 'login', 'Create my account', '创建我的账户', '2014-01-09 15:07:15'),
(2290, 'zh', 'login', 'Create New Account', '创建一个新账户', '2014-01-09 15:07:15'),
(2291, 'zh', 'login', 'Email', '邮箱', '2014-01-09 15:07:15'),
(2292, 'zh', 'login', 'emailexist', '邮箱已存在', '2014-01-09 15:07:15'),
(2293, 'zh', 'login', 'Enter the code as it is shown', '输入显示的字符', '2014-01-09 15:07:15'),
(2294, 'zh', 'login', 'First Name', '名字', '2014-01-09 15:07:15'),
(2295, 'zh', 'login', 'Last Name', '姓', '2014-01-09 15:07:15'),
(2296, 'zh', 'login', 'Login', '登录', '2014-01-09 15:07:15'),
(2297, 'zh', 'login', 'Login incorrect', '登录信息不正确', '2014-01-09 15:07:15'),
(2298, 'zh', 'login', 'newaccountsuccess', '创建新账户成功', '2014-01-09 15:07:15'),
(2299, 'zh', 'login', 'Password', '密码', '2014-01-09 15:07:15'),
(2300, 'zh', 'login', 'Password incorrect', '密码不正确', '2014-01-09 15:07:15'),
(2301, 'zh', 'login', 'Register', '注册', '2014-01-09 15:07:15'),
(2302, 'zh', 'login', 'Sign in to your account', '登录你的账户', '2014-01-09 15:07:15'),
(2303, 'zh', 'login', 'User inactive', '用户无效', '2014-01-09 15:07:15'),
(2304, 'zh', 'login', 'Username', '用户名', '2014-01-09 15:07:15'),
(2305, 'zh', 'login', 'usernameexist', '用户名已存在', '2014-01-09 15:07:15'),
(2306, 'zh', 'panel', 'About Us', '关于我们', '2014-05-15 17:48:57'),
(2307, 'zh', 'panel', 'Add following command to your cron tab', '加入以下命令到CRON列表', '2014-05-15 17:48:57'),
(2308, 'zh', 'panel', 'alsocheckfollowlink', '如果需要更多细节，请检查一下链接', '2014-05-15 17:48:57'),
(2309, 'zh', 'panel', 'Check Directory', '检查目录', '2014-05-15 17:48:57'),
(2310, 'zh', 'panel', 'Cron Command', 'cron命令', '2014-05-15 17:48:57'),
(2311, 'zh', 'panel', 'Directory Manager', '目录管理', '2014-05-15 17:48:57'),
(2312, 'zh', 'panel', 'Edit My Profile', '编辑我的资料', '2014-05-15 17:48:57'),
(2313, 'zh', 'panel', 'My Profile', '我的资料', '2014-05-15 17:48:57'),
(2314, 'zh', 'panel', 'New Proxy', '新建代理', '2014-05-15 17:48:57'),
(2315, 'zh', 'panel', 'New User', '新建用户', '2014-05-15 17:48:57'),
(2316, 'zh', 'panel', 'New Website', '新的站点', '2014-05-15 17:48:57'),
(2317, 'zh', 'panel', 'Proxy Manager', '代理管理器', '2014-05-15 17:48:57'),
(2318, 'zh', 'panel', 'Report Generation Manager', '报告生成管理', '2014-05-15 17:48:57'),
(2319, 'zh', 'panel', 'Reports Manager', '报告管理', '2014-05-15 17:48:57'),
(2320, 'zh', 'panel', 'Seo Plugins Manager', 'seo插件管理', '2014-05-15 17:48:57'),
(2321, 'zh', 'panel', 'Seo Tools Manager', 'seo工具管理', '2014-05-15 17:48:57'),
(2322, 'zh', 'panel', 'System Settings', '系统设置', '2014-05-15 17:48:57'),
(2323, 'zh', 'panel', 'User Manager', '用户管理', '2014-05-15 17:48:57'),
(2324, 'zh', 'panel', 'Website Manager', '站点管理', '2014-05-15 17:48:57');
INSERT INTO `texts` (`id`, `lang_code`, `category`, `label`, `content`, `changed`) VALUES
(2325, 'ru', 'backlink', 'clickproceedbacklink', 'Введите URL <b>по одному в каждой строке</b>. Нажмите <b>продолжить</b> для проверки обратных ссылок.', '2012-12-05 19:31:54'),
(2326, 'ru', 'backlink', 'Saved backlink results of', 'Сохранение результатов обратных ссылок', '2012-12-05 19:31:54'),
(2327, 'ru', 'button', 'Cancel', 'Отмена', '2014-01-08 19:33:07'),
(2328, 'ru', 'button', 'Check Status', 'Проверить статус', '2014-01-08 19:33:07'),
(2329, 'ru', 'button', 'Proceed', 'Продолжить', '2014-01-08 19:33:07'),
(2330, 'ru', 'button', 'Reload', 'Перезагрузить', '2014-01-08 19:33:07'),
(2331, 'ru', 'button', 'Show Details', 'Показать детали', '2014-01-08 19:33:07'),
(2332, 'ru', 'button', 'Show Records', 'Показать записи', '2014-01-08 19:33:07'),
(2333, 'ru', 'button', 'Skip', 'Пропустить', '2014-01-08 19:33:07'),
(2334, 'ru', 'button', 'Submit', 'Отправить', '2014-01-08 19:33:07'),
(2335, 'ru', 'common', 'Action', 'Действие', '2016-12-09 16:23:08'),
(2336, 'ru', 'common', 'Activate', 'Включить', '2016-12-09 16:23:08'),
(2337, 'ru', 'common', 'Active', 'Активный', '2016-12-09 16:23:08'),
(2338, 'ru', 'common', 'Admin Panel', 'Панель администратора', '2016-12-09 16:23:08'),
(2339, 'ru', 'common', 'Alexa Rank', 'Alexa Rank', '2016-12-09 16:23:08'),
(2340, 'ru', 'common', 'All', 'Все', '2016-12-09 16:23:08'),
(2341, 'ru', 'common', 'Category', 'Категория', '2016-12-09 16:23:08'),
(2342, 'ru', 'common', 'contact', 'Контакты', '2016-12-09 16:23:08'),
(2343, 'ru', 'common', 'copyright', 'Авторские права © [year] www.seopanel.in. Все права защищены', '2016-12-09 16:23:08'),
(2344, 'ru', 'common', 'Country', 'Страна', '2016-12-09 16:23:08'),
(2345, 'ru', 'common', 'Crawl Meta Data', 'Сканирование метаданных', '2016-12-09 16:23:08'),
(2346, 'ru', 'common', 'Date', 'Дата', '2016-12-09 16:23:08'),
(2347, 'ru', 'common', 'Delete', 'Удалить', '2016-12-09 16:23:08'),
(2348, 'ru', 'common', 'Details', 'Детали', '2016-12-09 16:23:08'),
(2349, 'ru', 'common', 'Directory', 'Каталог', '2016-12-09 16:23:08'),
(2350, 'ru', 'common', 'Donate', 'Пожертвовать', '2016-12-09 16:23:08'),
(2351, 'ru', 'common', 'Edit', 'Редактировать', '2016-12-09 16:23:08'),
(2352, 'ru', 'common', 'Entry cannot be blank', 'Поле не может быть пустым', '2016-12-09 16:23:08'),
(2353, 'ru', 'common', 'entrynotvalid', 'Введена не правильная запись', '2016-12-09 16:23:08'),
(2354, 'ru', 'common', 'failed', 'неудачно', '2016-12-09 16:23:08'),
(2355, 'ru', 'common', 'forum', 'Форум', '2016-12-09 16:23:08'),
(2356, 'ru', 'common', 'Found', 'Найдено', '2016-12-09 16:23:08'),
(2357, 'ru', 'common', 'Google Pagerank', 'Google Pagerank', '2016-12-09 16:23:08'),
(2358, 'ru', 'common', 'help', 'Помощь', '2016-12-09 16:23:08'),
(2359, 'ru', 'common', 'hidenews', 'Скрыть новости Seo panel', '2016-12-09 16:23:08'),
(2360, 'ru', 'common', 'Id', 'Id', '2016-12-09 16:23:08'),
(2361, 'ru', 'common', 'Inactivate', 'Отключить', '2016-12-09 16:23:08'),
(2362, 'ru', 'common', 'Inactive', 'Неактивный', '2016-12-09 16:23:08'),
(2363, 'ru', 'common', 'Invalid characters', 'Недопустимые символы', '2016-12-09 16:23:08'),
(2364, 'ru', 'common', 'Invalid code entered', 'Введен неправильный код', '2016-12-09 16:23:08'),
(2365, 'ru', 'common', 'Invalid email address entered', 'Введен неправильный email', '2016-12-09 16:23:08'),
(2366, 'ru', 'common', 'Invalid value', 'Неправильное значение', '2016-12-09 16:23:08'),
(2367, 'ru', 'common', 'Keyword', 'Ключевое слово', '2016-12-09 16:23:08'),
(2368, 'ru', 'common', 'Keywords', 'Ключевые слова', '2016-12-09 16:23:08'),
(2369, 'ru', 'common', 'lang', 'Язык', '2016-12-09 16:23:08'),
(2370, 'ru', 'common', 'My Account', 'Мой аккаунт', '2016-12-09 16:23:08'),
(2371, 'ru', 'common', 'Name', 'Название', '2016-12-09 16:23:08'),
(2372, 'ru', 'common', 'No', 'Нет', '2016-12-09 16:23:08'),
(2373, 'ru', 'common', 'No Keywords Found', 'Ключевые слова не найдены', '2016-12-09 16:23:08'),
(2374, 'ru', 'common', 'No Records Found', 'Записей не найдено', '2016-12-09 16:23:08'),
(2375, 'ru', 'common', 'noactivetools', 'Нет активных сео-инструментов!', '2016-12-09 16:23:08'),
(2376, 'ru', 'common', 'nowebsites', 'Сайты не найдены!', '2016-12-09 16:23:08'),
(2377, 'ru', 'common', 'password632', 'Длина пароля должна быть от 6 до 32 символов', '2016-12-09 16:23:08'),
(2378, 'ru', 'common', 'passwordnotmatch', 'Пароли не совпадают', '2016-12-09 16:23:08'),
(2379, 'ru', 'common', 'Period', 'Период', '2016-12-09 16:23:08'),
(2380, 'ru', 'common', 'Priority', 'Приоритет', '2016-12-09 16:23:08'),
(2381, 'ru', 'common', 'Rank', 'Rank', '2016-12-09 16:23:08'),
(2382, 'ru', 'common', 'Reports', 'Отчеты', '2016-12-09 16:23:08'),
(2383, 'ru', 'common', 'Results', 'Результаты', '2016-12-09 16:23:08'),
(2384, 'ru', 'common', 'Search Engine', 'Поисковые системы', '2016-12-09 16:23:08'),
(2385, 'ru', 'common', 'Select', 'Выбор', '2016-12-09 16:23:08'),
(2386, 'ru', 'common', 'Seo Plugins', 'Сео-плагины', '2016-12-09 16:23:08'),
(2387, 'ru', 'common', 'Seo Tools', 'Сео-инструменты', '2016-12-09 16:23:08'),
(2388, 'ru', 'common', 'Sign out', 'Выход', '2016-12-09 16:23:08'),
(2389, 'ru', 'common', 'Sign Up', 'Зарегистрироваться', '2016-12-09 16:23:08'),
(2390, 'ru', 'common', 'signin', 'Вход', '2016-12-09 16:23:08'),
(2391, 'ru', 'common', 'Status', 'Статус', '2016-12-09 16:23:08'),
(2392, 'ru', 'common', 'Support', 'Поддержка', '2016-12-09 16:23:08'),
(2393, 'ru', 'common', 'Total', 'Всего', '2016-12-09 16:23:08'),
(2394, 'ru', 'common', 'Url', 'Url', '2016-12-09 16:23:08'),
(2395, 'ru', 'common', 'User', 'Пользователь', '2016-12-09 16:23:08'),
(2396, 'ru', 'common', 'User Panel', 'Панель пользователя', '2016-12-09 16:23:08'),
(2397, 'ru', 'common', 'Website', 'Сайт', '2016-12-09 16:23:08'),
(2398, 'ru', 'common', 'Yes', 'Да', '2016-12-09 16:23:08'),
(2399, 'ru', 'directory', 'Add back to directory list', 'Вернуться к добавлению в список каталогов', '2012-11-09 06:03:15'),
(2400, 'ru', 'directory', 'Approved', 'Утвержденный', '2012-11-09 06:03:15'),
(2401, 'ru', 'directory', 'Captcha', 'Проверочный код', '2012-11-09 06:03:15'),
(2402, 'ru', 'directory', 'categorynote', 'Категории разделите запятой в соответствии с приоритетом. Начните с верхней категории наиболее приоритетной.', '2012-11-09 06:03:15'),
(2403, 'ru', 'directory', 'Check Directory Status', 'Проверить состояния регистра', '2012-11-09 06:03:15'),
(2404, 'ru', 'directory', 'Check Directory Submission Status', 'Проверить статус рассылки в каталоги', '2012-11-09 06:03:15'),
(2405, 'ru', 'directory', 'clicktoproceeddirsts', 'Нажмите <b>продолжить</b> для проверки статуса каталогов.', '2012-11-09 06:03:15'),
(2406, 'ru', 'directory', 'Confirmation', 'Подтверждение', '2012-11-09 06:03:15'),
(2407, 'ru', 'directory', 'desnote', 'Некоторые каталоги требуют минимум 150 символов для ввода в поле описание.', '2012-11-09 06:03:15'),
(2408, 'ru', 'directory', 'Directories with out captcha', 'Каталоги сайтов с каптчей', '2012-11-09 06:03:15'),
(2409, 'ru', 'directory', 'Directory Submission Reports', 'Отчеты по рассылке в каталоги', '2012-11-09 06:03:15'),
(2410, 'ru', 'directory', 'Enter the code shown', 'Введите код из изображения', '2012-11-09 06:03:15'),
(2411, 'ru', 'directory', 'nocatnote', 'Введенная категория не найдена в отправленной странице. Пожалуйста нажмите <b>перезагрузить</b> или <b>пропустить</b>  	 ', '2012-11-09 06:03:15'),
(2412, 'ru', 'directory', 'nodirnote', 'Нет <b>активных</b> каталогов', '2012-11-09 06:03:15'),
(2413, 'ru', 'directory', 'nosuccessnote', 'Не получено сообщение об успешном добавлении! Пожалуйста проверьте свою почту, возможно сообщение о подтверждении пришло к вам на почту', '2012-11-09 06:03:15'),
(2414, 'ru', 'directory', 'optionalnote', 'Дополнительные заголовки и описания представляются как случайные названия и описания в каталогах для лучшего результата.', '2012-11-09 06:03:15'),
(2415, 'ru', 'directory', 'Owner Email', 'Email владельца', '2012-11-09 06:03:15'),
(2416, 'ru', 'directory', 'Owner Name', 'Имя владельца', '2012-11-09 06:03:15'),
(2417, 'ru', 'directory', 'Pending', 'В ожидании', '2012-11-09 06:03:15'),
(2418, 'ru', 'directory', 'Please select a website to proceed', 'Для продолжения выберите сайт', '2012-11-09 06:03:15'),
(2419, 'ru', 'directory', 'selectwebsiteproceed', 'Выберите <b>сайт</b> для <b>продолжения</b> рассылки в каталоги.<br>Выберите <b>каталоги с капчей</b> для рассылки в каталоги.', '2012-11-09 06:03:15'),
(2420, 'ru', 'directory', 'selectwebsiteschecksub', 'Выберите <b>сайт</b> для <b>продолжения</b> выбора каталогов.', '2012-11-09 06:03:15'),
(2421, 'ru', 'directory', 'Semi Automatic Directory Submission Tool', 'Полуавтоматический инструмент рассылки в каталоги', '2012-11-09 06:03:15'),
(2422, 'ru', 'directory', 'spamemailnote', 'Некоторые каталоги могут рассылать спам, мы не рекомендуем использовать Ваш основной email почты.', '2012-11-09 06:03:15'),
(2423, 'ru', 'directory', 'Submission Details', 'Детали рассылки', '2012-11-09 06:03:15'),
(2424, 'ru', 'directory', 'Submit Description', 'Описание рассылки', '2012-11-09 06:03:15'),
(2425, 'ru', 'directory', 'Submit Keywords', 'Отправить ключевые слова', '2012-11-09 06:03:15'),
(2426, 'ru', 'directory', 'Submit Title', 'Отправить заголовок', '2012-11-09 06:03:15'),
(2427, 'ru', 'directory', 'Website Category', 'Категория сайта', '2012-11-09 06:03:15'),
(2428, 'ru', 'directory', 'Website Url', 'Url сайта', '2012-11-09 06:03:15'),
(2429, 'zh', 'plugin', 'Edit Seo Plugin', '编辑SEO插件', '2014-01-09 15:08:57'),
(2430, 'zh', 'plugin', 'Plugin Name', '插件名字', '2014-01-09 15:08:57'),
(2431, 'zh', 'plugin', 'Seo Plugin Details', 'SEO插件细节', '2014-01-09 15:08:57'),
(2432, 'zh', 'proxy', 'Edit Proxy', '编辑代理', '2014-05-15 17:51:10'),
(2433, 'zh', 'proxy', 'Proxy Password', '代理密码', '2014-05-15 17:51:10'),
(2434, 'zh', 'proxy', 'Proxy Username', '代理用户名', '2014-05-15 17:51:10'),
(2435, 'zh', 'proxy', 'Proxyalreadyexist', '代理已经存在', '2014-05-15 17:51:10'),
(2436, 'zh', 'rank', 'enterurlproceed', '输入URL，<b>每行一条</b>。点击<b>处理</b>开始检查Google PR和 Alexa 排名', '2011-05-04 08:41:24'),
(2437, 'zh', 'rank', 'Google and Alexa Rank Reports', 'Google PR和 Alexa 排名报告', '2011-05-04 08:41:25'),
(2438, 'zh', 'rank', 'Saved rank results of', '保存排名结果', '2011-05-04 08:41:25'),
(2439, 'zh', 'saturation', 'clickproceedsaturation', '输入URL，<b>每行一条</b>。点击<b>处理</b>开始检查搜索引擎搜录报告', '2011-05-04 09:45:58'),
(2440, 'zh', 'saturation', 'GenerateSaturationReports', '生成搜索引擎搜录报告', '2011-05-04 09:45:58'),
(2441, 'zh', 'saturation', 'Quick Search Engine Saturation Checker', '快速搜索引擎搜录检查', '2011-05-04 09:45:58'),
(2442, 'zh', 'saturation', 'Saved Search Engine Saturation results of', '保存搜索引擎搜录结果\r\n', '2011-05-04 09:45:58'),
(2443, 'zh', 'saturation', 'Search Engine Saturation Reports', '搜索引擎搜录报告', '2011-05-04 09:45:58'),
(2444, 'zh', 'seotools', 'Automatic Submission', '自动提交', '2011-07-06 06:05:37'),
(2445, 'zh', 'seotools', 'backlink-checker', '反向链接检查', '2011-07-06 06:05:37'),
(2446, 'zh', 'seotools', 'Backlinks Reports', '反向链接报告', '2011-07-06 06:05:37'),
(2447, 'zh', 'seotools', 'Check Submission Status', '检查提交状态', '2011-07-06 06:05:37'),
(2448, 'zh', 'seotools', 'clickgeneratereports', '点击<b>处理</b>开始生成报告 ', '2011-07-06 06:05:37'),
(2449, 'zh', 'seotools', 'Detailed Position Reports', '详细的位置报告', '2011-07-06 06:05:37'),
(2450, 'zh', 'seotools', 'directory-submission', '目录提交', '2011-07-06 06:05:37'),
(2451, 'zh', 'seotools', 'Featured Submission', '筛选提交', '2011-07-06 06:05:37'),
(2452, 'zh', 'seotools', 'Generate Backlinks Reports', '生成反向链接报告', '2011-07-06 06:05:37'),
(2453, 'zh', 'seotools', 'Generate Keyword Reports', '生成关键字报告', '2011-07-06 06:05:37'),
(2454, 'zh', 'seotools', 'Generate Rank Reports', '生成排名报告', '2011-07-06 06:05:37'),
(2455, 'zh', 'seotools', 'Generate Saturation Reports', '生成收录量报告', '2011-07-06 06:05:37'),
(2456, 'zh', 'seotools', 'Google Sitemap Generator', 'Google网站地图报告', '2011-07-06 06:05:37'),
(2457, 'zh', 'seotools', 'Graphical Position Reports', '图形位置报告', '2011-07-06 06:05:37'),
(2458, 'zh', 'seotools', 'Keyword Position Summary', '关键字概述', '2011-07-06 06:05:37'),
(2459, 'zh', 'seotools', 'keyword-position-checker', '关键字检查', '2011-07-06 06:05:37'),
(2460, 'zh', 'seotools', 'Keywords Manager', '关键字管理', '2011-07-06 06:05:37'),
(2461, 'zh', 'seotools', 'Quick Backlinks Checker', '快速反向链接检查', '2011-07-06 06:05:37'),
(2462, 'zh', 'seotools', 'Quick Position Checker', '快速位置检查', '2011-07-06 06:05:37'),
(2463, 'zh', 'seotools', 'Quick Rank Checker', '快速排名检查', '2011-07-06 06:05:37'),
(2464, 'zh', 'seotools', 'Quick Saturation Checker', '快速收录量检查', '2011-07-06 06:05:37'),
(2465, 'zh', 'seotools', 'Rank Reports', '排名报告', '2011-07-06 06:05:37'),
(2466, 'zh', 'seotools', 'rank-checker', '排名检查', '2011-07-06 06:05:37'),
(2467, 'zh', 'seotools', 'Saturation Reports', '收录量报告', '2011-07-06 06:05:37'),
(2468, 'zh', 'seotools', 'saturation-checker', '搜索引擎收录量', '2011-07-06 06:05:37'),
(2469, 'zh', 'seotools', 'sitemap-generator', '站点地图生成器', '2011-07-06 06:05:37'),
(2470, 'zh', 'seotools', 'Skipped Directories', '跳过的目录', '2011-07-06 06:05:37'),
(2471, 'zh', 'seotools', 'Submission Reports', '提交报告', '2011-07-06 06:05:37'),
(2472, 'zh', 'seotools', 'User Access', '用户访问', '2011-07-06 06:05:37'),
(2473, 'zh', 'settings', 'Click here to become a sponsor for Seo Panel', '<b>捐赠 $100</b> 成为Seo Panel的一个<b>赞助人</b>.', '2014-05-15 17:56:30'),
(2474, 'zh', 'settings', 'seopanel_description', 'Seo panel是一个完整的免费的能对你的站点进行搜索引擎优化的控制面板。它拥有很多热门的seo工具来追踪你的站点情况。它是一个开源软件，而且你可以开发自己的seopanel。', '2014-05-15 17:56:30'),
(2475, 'zh', 'settings', 'seopanel_title', 'Seo Panel：全球第一款多站点seo处理开源软件', '2014-05-15 17:56:30'),
(2476, 'zh', 'settings', 'SP_CRAWL_DELAY', '每次爬去间隔时间(秒)', '2014-05-15 17:56:30'),
(2477, 'zh', 'settings', 'SP_DEFAULTLANG', '默认语言', '2014-05-15 17:56:30'),
(2478, 'zh', 'settings', 'SP_DESCRIPTION', 'Seo Panel 描述', '2014-05-15 17:56:30'),
(2479, 'zh', 'settings', 'SP_ENABLE_PROXY', '使用代理', '2014-05-15 17:56:30'),
(2480, 'zh', 'settings', 'SP_HOTLINKING', '使用图片盗链保护', '2014-05-15 17:56:30'),
(2481, 'zh', 'settings', 'SP_KEYWORDS', 'Seo Panel 关键字', '2014-05-15 17:56:30'),
(2482, 'zh', 'settings', 'SP_PAGINGNO', '每页条目数量', '2014-05-15 17:56:30'),
(2483, 'zh', 'settings', 'SP_TITLE', 'Seo Panel 标题', '2014-05-15 17:56:30'),
(2484, 'zh', 'settings', 'SP_USER_GEN_REPORT', '允许用户生成报告', '2014-05-15 17:56:30'),
(2485, 'zh', 'settings', 'SP_USER_REGISTRATION', '用户注册接口', '2014-05-15 17:56:30'),
(2486, 'zh', 'settings', 'syssettingssaved', '系统设置保存成功', '2014-05-15 17:56:30'),
(2487, 'zh', 'sitemap', 'Change frequency', '改变频率', '2010-10-17 21:33:58'),
(2488, 'zh', 'sitemap', 'clickproceedsitemap', '点击<b>处理</b>创建站点地图文件', '2010-10-17 21:33:58'),
(2489, 'zh', 'sitemap', 'Download sitemap file from', '下载站点地图文件', '2010-10-17 21:33:58'),
(2490, 'zh', 'sitemap', 'Exclude Url', '不包括的URL', '2010-10-17 21:33:58'),
(2491, 'zh', 'sitemap', 'processtaketime', '本次处理需要一段时间根据你的站点连接数。请等待，稍后将获取站点地图文件', '2010-10-17 21:33:58'),
(2492, 'zh', 'sitemap', 'Sitemap Type', '站点地图类型', '2010-10-17 21:33:58'),
(2493, 'zh', 'user', 'Edit User', '编辑用户信息', '2010-10-17 21:35:39'),
(2494, 'zh', 'user', 'Saved My Profile Details', '保存我的详细资料', '2010-10-17 21:35:39'),
(2495, 'zh', 'website', 'Edit Website', '编辑站点', '2010-10-17 21:37:23'),
(2496, 'zh', 'website', 'plscrtwebsite', '使用seo工具和插件前，请先创建一个站点', '2010-10-17 21:37:23'),
(2497, 'zh', 'website', 'Website already exist', '站点已经存在', '2010-10-17 21:37:23'),
(2498, 'zh', 'website', 'yourwebalreday', '你的站点，如果你已经创建了一个', '2010-10-17 21:37:23'),
(2499, 'zh', 'label', 'already exist', '已经存在', '2014-05-15 17:47:51'),
(2500, 'zh', 'label', 'Authentication', '认证', '2014-05-15 17:47:51'),
(2501, 'zh', 'label', 'Author', '作者', '2014-05-15 17:47:51'),
(2502, 'zh', 'label', 'Click Here', '点击这里', '2014-05-15 17:47:51'),
(2503, 'zh', 'label', 'Cron', 'Cron', '2014-05-15 17:47:51'),
(2504, 'zh', 'label', 'Description', '描述', '2014-05-15 17:47:51'),
(2505, 'zh', 'label', 'Developers', '开发人员', '2014-05-15 17:47:51'),
(2506, 'zh', 'label', 'Download', '下载', '2014-05-15 17:47:51'),
(2507, 'zh', 'label', 'Installation', '安装', '2014-05-15 17:47:51'),
(2508, 'zh', 'label', 'Keywords', '关键字', '2014-05-15 17:47:51'),
(2509, 'zh', 'label', 'noactiveplugins', '未找到可用的seo插件', '2014-05-15 17:47:51'),
(2510, 'zh', 'label', 'Plugin', '插件', '2014-05-15 17:47:51'),
(2511, 'zh', 'label', 'Port', '端口', '2014-05-15 17:47:51'),
(2512, 'zh', 'label', 'Proxy', '代理', '2014-05-15 17:47:51'),
(2513, 'zh', 'label', 'Re-install', '重新安装', '2014-05-15 17:47:51'),
(2514, 'zh', 'label', 'Sponsors', '赞助商', '2014-05-15 17:47:51'),
(2515, 'zh', 'label', 'Title', '标题', '2014-05-15 17:47:51'),
(2516, 'zh', 'label', 'translation by', '译者：', '2014-05-15 17:47:51'),
(2517, 'zh', 'label', 'Translators', '所有译者：', '2014-05-15 17:47:51'),
(2518, 'zh', 'label', 'Upgrade', '升级', '2014-05-15 17:47:51'),
(2519, 'zh', 'label', 'Version', '版本', '2014-05-15 17:47:51'),
(2520, 'zh', 'label', 'wantproceed', '你确实要开始处理了吗？', '2014-05-15 17:47:51'),
(2521, 'ru', 'home', 'Account Summary', 'Резюме аккаунта', '2011-07-13 09:05:21'),
(2522, 'ru', 'home', 'Backlinks', 'Обратные ссылки', '2011-07-13 09:05:21'),
(2523, 'ru', 'home', 'Directory Submission', 'Рассылка в каталоги', '2011-07-13 09:05:21'),
(2524, 'ru', 'home', 'home_cont1', '<h1 style=\\"text-align: center;margin-bottom: 30px;font-size: 19px;\\">Добро пожаловать на сайт Seo Panel - первый в мире бесплатный инструмент для продвижения сайтов</h1>\r\n        <p>\r\n            Seo panel - <b>скрипт с открытым исходным кодом</b>, для управления <b>оптимизацией сайтов</b> для поисковых систем. \r\n            Seo Panel это <b>набор инструментов для сео,</b> включающий в себя инструменты для \r\n<b>отслеживания и увеличения</b> <b>позиций</b> ваших сайтов в поисковых системах.\r\n            Seo panel <b>бесплатное программное обеспечение,</b> выпущенное под лицензией <b>GNU GENERAL PUBLIC LICENSE</b>.\r\n            Главной особенностью Seo panel, является ее <b>настраиваемость</b>, с помощью <a href=\\"<?=SP_PLUGINSITE?>\\" target=\\"_blank\\">сео плагинов</a>.\r\n            Любой разработчик может легко <b>разработать и установить</b> необходимые плагины для Seo panel.\r\n        </p>\r\n        <p></p>\r\n        <p>\r\n            Seo panel - открытое программное обеспечение, <b>выпущено в январе 2010 года</b>.\r\n            За этот <b>короткий период</b> времени, <b>тысячи</b> <b>веб-мастеров</b> начали использовать программу для <b>оптимизации</b> своих сайтов.\r\n            Используйте Seo panel сегодня вместе с нами, для <b>успешного</b> <b>продвижения сайтов в поисковых системах, применяя единую платформу</b>.\r\n        </p>', '2011-07-13 09:05:21'),
(2525, 'ru', 'home', 'home_cont2', '<fieldset>\r\n<legend>Основные характеристики Seo Panel <?=SP_INSTALLED?></legend>\r\n<ul class=\\"infobox\\">\r\n    <li>        \r\n        <h1>Инструмент автоматический рассылки в каталоги</h1>\r\n        <p>\r\n            Инструмент автоматический рассылки в каталоги поможет вам <b>рассылать ваши сайты</b> во многие <b>бесплатные\r\nи платные каталоги</b>.\r\n            А так же скрипт рассылки <b>отслеживает состояние</b> каждой отправленной ссылки <b>через периодические проверки</b> с помощью\r\n  программы <b>проверки статуса отправки</b>.\r\n            <b>Менеджер каталогов</b> поможет вам узнать, <b>активный каталог</b> или нет.\r\n        </p>\r\n    </li>\r\n    <li>        \r\n        <h1>Проверка позиции ключевых слов</h1>\r\n        <p>\r\n            Поиск позиции ключевых слов в <b>поисковых системах</b> по <b>целевым ключевым словам</b>\r\nсайта и <b>сохранение их в</b> системе.\r\n            В разделе отчетов о положении ключевых слов, вы можете увидеть <b>ежедневные позиции</b> ключевых слов в \r\nразличных поисковых системах в виде <b>красивой графики</b> и <b>подробных отчетов</b>.\r\n        </p>\r\n    </li>\r\n    <li>        \r\n        <h1>Аудит сайта</h1>\r\n        <p>Аудитор сайта будет проводить <b> сео-проверку всех факторов</b> каждой страницы сайта и предоставит\r\n<b>подробный отчет</b> о каждой странице. Это поможет вам создавать <b>XML,HTML,TEXT</b> файлы карты сайта\r\n с для <b>отправки</b> в поисковые системы.</p>\r\n    </li>\r\n    <li>        \r\n        <h1>Проверка рейтинга Google и Alexa Rank</h1>\r\n        <p>\r\n            Отслеживание Google и Alexa Rank, <b>google pagerank</b> и <b>alexa rank</b> ваших\r\nсайтов и <b>сохранение</b> их в системе.\r\n            В разделе <b>отчеты по рейтингу</b>, вы увидите <b>ежедневные детальные отчеты</b> google и alexa rank каждого добавленного вами сайта.\r\n        </p>\r\n    </li>\r\n    <li>        \r\n        <h1>Проверка обратных ссылок</h1>\r\n        <p>\r\n            Проверка обратных ссылок даст <b>количество отчет о количестве ссылок</b> на ваши сайты в различных поисковых\r\nсистемах<b> (yandex, google, yahoo, msn и т.д.)</b>, сохранит отчет в системе.\r\n            <br>В <b>ежедневных отчетах</b> вы увидите подробно статистику <b>о обратных ссылках</b> на ваши сайты.\r\n        </p>\r\n    </li>    \r\n    <li>        \r\n        <h1>Проверка поисковой насыщенности</h1>\r\n        <p>\r\n            Проверка поисковой насыщенности покажет <b>количество проиндексированных страниц</b> вашего сайта или магазина в\r\nразличных поисковых системах<b> (yandex, google, yahoo, msn и т.д.)</b>.\r\n            В разделе <b>отчеты о проверке поисковой насыщенности</b>, вы можете увидеть <b>подсчет ежедневно проиндексированных\r\nстраниц</b> каждого добавленного сайта <b>в виде детального отчета</b>.\r\n        </p>\r\n    </li>\r\n    <li>        \r\n        <h1>Плагины Seo Panel</h1>\r\n        <p>\r\n           Главной особенностью <b>Seo Panel</b> является его <b>расширяемость</b>.\r\n            Добавьте <b>seo плагины</b> в вашу Seo panel для <b>расширения ее возможностей</b> в соответствии с вашим\r\nтребованиями.\r\n            <a href=\\"<?=SP_PLUGINSITE?>\\" target=\\"_blank\\">Плагины Seo panel</a>, предоставляются как разработчиками системы\r\nтак и сторонними разработчиками.\r\n            И вы можно легко <b>разрабатывать</b> сео плагины для Seo panel.\r\n            Вы можете <a href=\\"<?=SP_PLUGINSITE?>\\" target=\\"_blank\\">отпрваить</a> ваши seo плагины для Seo panel нам, \r\nмы обязательно <b>опубликуем</b> после рассмотрения на нашем сайте ваши <b>плагины</b>.\r\n        </p>\r\n    </li>\r\n    <li>        \r\n        <h1>Генератор мета-тегов</h1>\r\n        <p>\r\n            Генератор мета-тегов это <b>плагин Seo panel</b> для создания <b>мета-тегов сайта</b> пользователей.\r\n            Генератор мета-тегов позволит вам дать <b>более подробную информацию</b> о вашем сайте <b>ботам поисковых систем</b>\r\nво время индексации вашего сайта.\r\n        </p>\r\n    </li>\r\n</ul>\r\n</fieldset>', '2011-07-13 09:05:21'),
(5116, 'ru', 'home', 'Indexed', 'Проиндексировано', '2011-07-13 09:05:21'),
(5117, 'ru', 'keyword', 'Insert keywords separated with comma', 'Вставьте ключевые слова разделенные запятыми', '2016-01-12 21:28:48'),
(5118, 'ru', 'label', 'Brocken', 'Сломанный', '2017-07-13 16:42:21'),
(5119, 'ru', 'label', 'Comments', 'Комментарии', '2017-07-13 16:42:21'),
(5120, 'ru', 'label', 'Count', 'Подсчет', '2017-07-13 16:42:21'),
(5121, 'ru', 'label', 'Exclude', 'Исключить', '2017-07-13 16:42:21'),
(5122, 'ru', 'label', 'Include', 'Включить', '2017-07-13 16:42:21'),
(5123, 'ru', 'label', 'Project', 'Проект', '2017-07-13 16:42:21'),
(5124, 'ru', 'label', 'Report Type', 'Тип отчета', '2017-07-13 16:42:21'),
(5125, 'ru', 'label', 'Score', 'Оценка', '2017-07-13 16:42:21'),
(5126, 'ru', 'label', 'Total Results', 'Всего результатов', '2017-07-13 16:42:21'),
(2526, 'ru', 'home', 'home_cont3', '<fieldset>\r\n<legend>Онлайн ресурсы Seo Panel</legend>    \r\n<ul class=\\"infobox\\">\r\n\r\n    <li>\r\n        <h1>Онлайн справочник Seo Panel</h1>                \r\n        \r\n        \r\n        <p>\r\n            <a href=\\"http://www.seopanel.in\\" target=\\"_blank\\">Официальный сайт Seo Panel</a>\r\n        </p>\r\n        <p>\r\n            <a href=\\"<?=SP_DOWNLOAD_LINK?>\\" target=\\"_blank\\">Страница загрузки Seo Panel</a>\r\n        </p>\r\n        \r\n        <p>\r\n            <a href=\\"<?=SP_DEMO_LINK?>\\" target=\\"_blank\\">Демо Seo Panel</a>\r\n        </p>\r\n        \r\n        <p>\r\n            <a href=\\"<?=SP_CONTACT_LINK?>\\" target=\\"_blank\\">Контакты Seo Panel</a>\r\n        </p>\r\n        \r\n        <p>\r\n            <a href=\\"<?=SP_HELP_LINK?>\\" target=\\"_blank\\">Документация Seo Panel</a>\r\n        </p>\r\n        \r\n        <p>\r\n            <a href=\\"<?=SP_SUPPORT_LINK?>\\" target=\\"_blank\\">Служба поддержки Seo Panel</a>\r\n        </p>\r\n		\r\n        <p>\r\n            <a href=\\"<?=SP_DONATE_LINK?>\\" target=\\"_blank\\">Пожертвовать Seo Panel</a>\r\n        </p>\r\n    </li>\r\n    \r\n</ul>\r\n</fieldset>', '2011-07-13 09:05:21'),
(6550, 'fa', 'support', 'support_cont1', '<fieldset> \r\n<legend>Seo Panel Support System</legend> \r\n<ul class=\\"infobox\\"> \r\n    <li> \r\n        <h1>1000 Directory Package</h1>  \r\n        <p> \r\n            We are providing <b>1000 free active and verified</b> internet directory package, to add into\r\nyour seo panel <b>directory submission tool</b>. \r\n            It will help you to <b>increase the backlinks</b> of your websites. \r\n            Actually 1000 directory list is <b>introduced</b> to collect some money for <b>future\r\ndevelopment</b> of seo panel. \r\n            To get the 1000 directory list please <a href=\\"<?=SP_DONATE_LINK?>\\" target=\\"_blank\\">donate</a>\r\n$10 or more to improve the features of seo panel. \r\n            If you have any questions about 1000 directory package, please <a href=\\"<?=SP_CONTACT_LINK?>\\"\r\ntarget=\\"_blank\\">contact us</a> or open a ticket in <a href=\\"<?=SP_SUPPORT_LINK?>\\"\r\ntarget=\\"_blank\\">support system</a>.    \r\n        </p>         \r\n        <p> \r\n            <a href=\\"<?=SP_DONATE_LINK?>\\" target=\\"_blank\\">Visit this link to donate to seo panel</a> \r\n        </p> \r\n        <br> \r\n    </li> \r\n     \r\n    <li> \r\n        <h1>Local Search Engines Package</h1>  \r\n        <p> \r\n            Add <b>local search engine domains</b> of google,yahoo,msn(<b>eg: www.google.de,www.google.fr\r\netc</b>) to seo panel <b>keyword position checker</b>, to track your site perfomance locally. \r\n            To get local search engines package(according to your requirement) please <a\r\nhref=\\"<?=SP_DONATE_LINK?>\\" target=\\"_blank\\">donate</a> $10 or more to improve the features of seo\r\npanel. \r\n            Before sending donation, please <a href=\\"<?=SP_CONTACT_LINK?>\\" target=\\"_blank\\">contact us</a> to\r\nprovide us required search engine domain list. \r\n            <br><br>               \r\n            Also to add <b>new search engines(eg:baidu.com)</b> to your seo panel keyword position checker,\r\nplease <a href=\\"<?=SP_CONTACT_LINK?>\\" target=\\"_blank\\">contact us</a> or open a ticket in <a\r\nhref=\\"<?=SP_SUPPORT_LINK?>\\" target=\\"_blank\\">support system</a>.  \r\n        </p>         \r\n        <p class=\\"visit\\"> \r\n            <a href=\\"<?=SP_CONTACT_LINK?>\\" target=\\"_blank\\">Visit this link to contact us</a> \r\n        </p> \r\n        <br> \r\n    </li> \r\n     \r\n    <li> \r\n        <h1>Seo Panel Plugins</h1>  \r\n        <p> \r\n            Add <b>seo plugins</b> to your seo panel to <b>extend the features</b> according to your\r\nrequirement. \r\n            <a href=\\"<?=SP_PLUGINSITE?>\\" target=\\"_blank\\">Seo panel plugins</a> are provided by both seo panel\r\nand third party sites. \r\n            You can also easily <b>develop</b> seo plugins for your seo panel. \r\n            You can <a href=\\"<?=SP_PLUGINSITE?>\\" target=\\"_blank\\">submit</a> your seo plugin to seo panel and\r\nwe will <b>publish</b> it in our website after our <b>review</b> process.         \r\n        </p>         \r\n        <p> \r\n            <a href=\\"<?=SP_PLUGINSITE?>\\" target=\\"_blank\\">Visit this link to get seo panel plugins</a> \r\n        </p> \r\n        <br> \r\n    </li>     \r\n    <li> \r\n        <h1>Contact Us</h1>  \r\n        <p> \r\n            Contact us for any questions about <b>seo panel tools,plugins and features etc</b> by using below\r\nlink.         \r\n        </p>         \r\n        <p> \r\n            <a href=\\"<?=SP_CONTACT_LINK?>\\" target=\\"_blank\\">Visit this link to contact us</a> \r\n        </p> \r\n        <br> \r\n    </li>     \r\n    <li> \r\n        <h1>Support Tickets</h1>  \r\n        <p> \r\n            To get <b>technical support</b> from seo panel team to setup the <b>seo panel tools,plugins and\r\nfeatures</b>. Eg: To set up cron for keyword position checker. \r\n        </p>         \r\n        <p> \r\n            <a href=\\"<?=SP_SUPPORT_LINK?>\\" target=\\"_blank\\">Visit this link to create a support ticket</a> \r\n        </p> \r\n        <br> \r\n    </li>     \r\n    <li> \r\n        <h1>Report Bugs</h1>  \r\n        <p> \r\n            Report <b>bugs</b> about <b>seo panel tools,plugins and features etc</b> by using below link.  \r\n            please help us to improve the features in next versions.           \r\n        </p>         \r\n        <p> \r\n            <a href=\\"<?=SP_SUPPORT_LINK?>\\" target=\\"_blank\\">Visit this link to report bugs</a> \r\n        </p> \r\n        <br> \r\n    </li>     \r\n</ul> \r\n</fieldset>', '2012-04-30 04:02:02'),
(2527, 'ru', 'home', 'Pages Indexed', 'Проиндексированные страницы', '2011-07-13 09:05:21'),
(2528, 'ru', 'home', 'Ranks', 'Rank', '2011-07-13 09:05:21'),
(2529, 'ru', 'home', 'SiteNameUrl', 'Название сайта/Url', '2011-07-13 09:05:21'),
(2530, 'ru', 'home', 'Website Statistics', 'Статистика сайта', '2011-07-13 09:05:21'),
(2531, 'zh', 'home', 'Account Summary', '账户概览', '2011-07-06 06:02:25'),
(2532, 'zh', 'home', 'Backlinks', '反向链接', '2011-07-06 06:02:25'),
(2533, 'zh', 'home', 'Directory Submission', '目录提交', '2011-07-06 06:02:25'),
(2534, 'zh', 'home', 'home_cont1', '<h1 style=\\"text-align: center;margin-bottom: 30px;font-size: 19px;\\">欢迎来到 Seo Panel - 全球第一款支\r\n\r\n持多站点的开源SEO工具</h1> \r\n        <p> \r\n            一个完整的 <b>开源seo 控制面板</b> 来控制你的站点<b>操作</b> .  \r\n            Seo Panel 是一个拥有最前沿热门的seo工具 <b>增加和追踪</b> 你的站点表现的\r\n<b>SEO工具包</b>. \r\n            它是一个<b>免费的软件</b> 在遵循<b>GNU GENERAL PUBLIC LICENSE</b>协议下发布. \r\n            seopanel主要的功能是 <b>扩展性</b> 通过使用 <a href=\\"<?=SP_PLUGINSITE?>\\"\r\ntarget=\\"_blank\\">seo 插件</a>. \r\n            任何人都可以简单 <b>开发和安装</b> 各自需要的插件.  \r\n        </p> \r\n        <p></p> \r\n        <p> \r\n            这款开源软件发布自<b>2010年1月</b>. \r\n            在这么<b>少的</b>时间 <b>上千</b><b>站长</b> 在用此软件 <b>操作</b> 他们的站点. \r\n            现在您可以在<b>同一个平台下</b>使用和<b>享受</b> seo的任何东西. \r\n        </p>\r\n', '2011-07-06 06:02:25'),
(2535, 'zh', 'home', 'home_cont2', '<fieldset> \r\n<legend> Seo Panel主要功能 <?=SP_INSTALLED?></legend> \r\n<ul class=\\"infobox\\"> \r\n    <li>         \r\n        <h1>自动目录提交工具</h1> \r\n        <p> \r\n            自动目录提交工具帮助我们<b>提交我们的站点</b>进入主要<b>免费和付费internet目录</b>. \r\n            我们也可以每次使用<b>状态检查脚本</b>提交<b>定期检查</b><b>追踪状态</b>. \r\n            <b>目录管理器</b>会帮助我们找出<b>目录是否激活</b>. \r\n        </p> \r\n    </li> \r\n    <li>         \r\n        <h1>关键字位置查询器</h1> \r\n        <p> \r\n           关键字位置查询器会系统中找出你的站点的<b>目标关键字</b>在<b>搜索引擎的排名位置</b> \r\n并且 <b>存储排名数据</b> . \r\n            在关键字报告区域, 我们可以通过<b>简洁的图表</b>和<b>详细报告</b>看到<b>每日</b>关键字在不\r\n\r\n同的搜索引擎排名的报告. \r\n        </p> \r\n    </li> \r\n    <li>         \r\n        <h1>站点审计器</h1> \r\n        <p>站点审计器可以 <b>审计所有的SEO要素</b> 在一个网站上的所有页面并且生成\r\n<b>详细报告t</b> 定位每一张网页. 这将会有助于创建我们的 <b>XML,HTML,TEXT</b>站点地图文件来<b>提交</b> 给\r\n\r\n搜索引擎.</p> \r\n    </li> \r\n    <li>         \r\n        <h1>Google和Alexa排名查询器</h1> \r\n        <p> \r\n            Google和Alexa排名查询器 会查询<b>Google PageRank</b> 和 <b>Alexa排名</b> 我们的站点并 <b>\r\n\r\n存储</b>在系统中. \r\n            在<b>排名报告</b> 中, 我们可以看到<b>每天</b>每个Google PR和 Alexa排名<b>详细报告</b>. \r\n        </p> \r\n    </li> \r\n    <li>         \r\n        <h1>反向链接查询器</h1> \r\n        <p> \r\n            反向链接查询器会在不同的搜索引擎中<b>(google,yahoo,msn 等)</b>找出>我们的站点的<b>反向链\r\n\r\n接数量</b>并<b>存储</b>到系统中. \r\n            <br>在<b>反向链接报告</b> 中, 我们可以通过<b>详细报告</b>看到每个站点的<b>每天反向链接数\r\n\r\n量</b>. \r\n        </p> \r\n    </li>     \r\n    <li>         \r\n        <h1>搜索引擎收录量查询器</h1> \r\n        <p> \r\n            搜索引擎收录量查询器会查询>我们的站点在不同的搜索引擎<b>(google,yahoo,msn 等)的<b>数量页\r\n\r\n面排名</b</b>并<b>存储</b>到系统中. \r\n            在 <b>搜索引擎收录量查询报告</b> 中, 我们可以通过<b>详细报告</b>看到每个站点的<b>每天的页\r\n\r\n面收录数量\r\n</b>. \r\n        </p> \r\n    </li> \r\n    <li>         \r\n        <h1>Seo Panel 插件</h1> \r\n        <p> \r\n            SEO控制面板的<b>主要功能</b>是它的<b>扩展性</b>. \r\n            根据你的需求增到<b>seo插件</b>到你的seo panel<b>扩展功能</b>. \r\n            <a href=\\"<?=SP_插件ITE?>\\" target=\\"_blank\\">Seo panel 插件</a>由seopanel\r\n和第三方站点提供. \r\n            你可以为你的seo panel简单<b>开发</b> seo插件. \r\n            你可以在<a href=\\"<?=SP_PLUGINSITE?>\\" target=\\"_blank\\">submit</a>发布你的seo插件seo panel，\r\n\r\n在我们通过 <b>审查</b> 处理之后就会<b>公布</b> 在我们的站点. \r\n        </p> \r\n    </li> \r\n    <li>         \r\n        <h1>Meta标签生成器</h1> \r\n        <p> \r\n            Meta标签生成器是一个为我们的站点创建 <b>自定义Mta标签</b>的<b>seo panel 插件</b>. \r\n            它帮助<b>搜索引擎机器人</b>\r\n爬行我们站点的时候获得关于我们的站点<b>更多信息</b>  . \r\n        </p> \r\n    </li> \r\n</ul> \r\n</fieldset>', '2011-07-06 06:02:25'),
(2536, 'zh', 'home', 'home_cont3', '<fieldset> \r\n<legend>Seo Panel 在线资源</legend>     \r\n<ul class=\\"infobox\\"> \r\n\r\n    <li> \r\n        <h1>Seo Panel 在线资源信息</h1>                 \r\n         \r\n         \r\n        <p> \r\n            <a href=\\"http://www.seopanel.in\\" target=\\"_blank\\">Seo Panel 官方站点</a> \r\n        </p> \r\n        <p> \r\n            <a href=\\"<?=SP_DOWNLOAD_LINK?>\\" target=\\"_blank\\">下载Seo Panel</a> \r\n        </p> \r\n         \r\n        <p> \r\n            <a href=\\"<?=SP_DEMO_LINK?>\\" target=\\"_blank\\">Seo Panel 例子</a> \r\n        </p> \r\n         \r\n        <p> \r\n            <a href=\\"<?=SP_CONTACT_LINK?>\\" target=\\"_blank\\">联系Seo Panel</a> \r\n        </p> \r\n         \r\n        <p> \r\n            <a href=\\"<?=SP_HELP_LINK?>\\" target=\\"_blank\\">Seo Panel 帮助向导</a> \r\n        </p> \r\n         \r\n        <p> \r\n            <a href=\\"<?=SP_FORUM_LINK?>\\" target=\\"_blank\\">Seo Panel 论坛</a> \r\n        </p> \r\n         \r\n        <p> \r\n            <a href=\\"<?=SP_SUPPORT_LINK?>\\" target=\\"_blank\\">Seo Panel 支持系统</a> \r\n        </p> \r\n         \r\n        <p> \r\n            <a href=\\"<?=SP_DONATE_LINK?>\\" target=\\"_blank\\">捐赠 Seo Panel</a> \r\n        </p> \r\n    </li> \r\n     \r\n</ul> \r\n</fieldset>', '2011-07-06 06:02:25'),
(2537, 'zh', 'home', 'Pages Indexed', '页面检索', '2011-07-06 06:02:25'),
(2538, 'zh', 'home', 'Ranks', '排名', '2011-07-06 06:02:25'),
(2539, 'zh', 'home', 'SiteNameUrl', '站点 名字/URL', '2011-07-06 06:02:25'),
(2540, 'zh', 'home', 'Website Statistics', '站点统计', '2011-07-06 06:02:25'),
(2541, 'ru', 'website', 'Edit Website', 'Редактировать сайт', '2016-01-12 21:42:41'),
(2542, 'ru', 'website', 'plscrtwebsite', 'Создайте веб-сайт до начала использования SEO инструментов и SEO плагинов.', '2016-01-12 21:42:41'),
(2543, 'ru', 'website', 'Website already exist', 'Сайт уже существует', '2016-01-12 21:42:41'),
(2544, 'ru', 'website', 'yourwebalreday', 'ваш сайт, если вы его создали.', '2016-01-12 21:42:41'),
(2545, 'ru', 'user', 'Edit User', 'Редактировать пользователя', '2016-01-12 21:39:26'),
(2546, 'ru', 'user', 'Saved My Profile Details', 'Сохранить профиль', '2016-01-12 21:39:26'),
(2547, 'ru', 'sitemap', 'Change frequency', 'Выберите частоту', '2010-10-18 01:35:53'),
(2548, 'ru', 'sitemap', 'clickproceedsitemap', 'Нажмите <b>продолжить</b> для создания карты сайта', '2010-10-18 01:35:53'),
(2549, 'ru', 'sitemap', 'Download sitemap file from', 'Скачать файл Sitemap из', '2010-10-18 01:35:53'),
(2550, 'ru', 'sitemap', 'Exclude Url', 'Исключить Url', '2010-10-18 01:35:53'),
(2551, 'ru', 'sitemap', 'processtaketime', 'Этот процесс займет некоторое время в зависимости от количества ссылок на сайте. Пожалуйста, подождите, через некоторое время вы получите файл Sitemap', '2010-10-18 01:35:53'),
(2552, 'ru', 'sitemap', 'Sitemap Type', 'Тип карты сайтов', '2010-10-18 01:35:53'),
(2701, 'bg', 'button', 'Check Status', 'Провери статуса', '2014-01-08 19:20:35'),
(2702, 'bg', 'button', 'Proceed', 'Продължи', '2014-01-08 19:20:35'),
(2703, 'bg', 'button', 'Reload', 'Презареди', '2014-01-08 19:20:35'),
(2704, 'bg', 'button', 'Show Details', 'Покажи детайли', '2014-01-08 19:20:35'),
(2705, 'bg', 'button', 'Show Records', 'Покажи записите', '2014-01-08 19:20:35'),
(2706, 'bg', 'button', 'Skip', 'Пропусни', '2014-01-08 19:20:35'),
(2707, 'bg', 'button', 'Submit', 'Изпрати', '2014-01-08 19:20:35'),
(2708, 'bg', 'backlink', 'clickproceedbacklink', 'Въведете <b>по един</b> URL адрес на ред. Натиснете върху <b>Продължи</b> за да проверите беклинковете', '2010-11-14 18:52:58'),
(2709, 'bg', 'backlink', 'Saved backlink results of', 'Запазени беклинк резултати за', '2010-11-14 18:52:58'),
(2710, 'bg', 'common', 'Action', 'Действие', '2016-12-18 17:04:53'),
(2711, 'bg', 'common', 'Activate', 'Активирай', '2016-12-18 17:04:53'),
(2712, 'bg', 'common', 'Active', 'Активен', '2016-12-18 17:04:53'),
(2713, 'bg', 'common', 'Admin Panel', 'Админ Панел', '2016-12-18 17:04:53'),
(2553, 'ru', 'keyword', 'Crawling keyword', 'Сканирование ключевых слов', '2016-01-12 21:28:48'),
(2554, 'ru', 'keyword', 'Detailed Keyword Position Reports', 'Детальные отчеты по позициям ключевых слов', '2016-01-12 21:28:48'),
(2555, 'ru', 'keyword', 'Edit Keyword', 'Редактировать ключевое слово', '2016-01-12 21:28:48'),
(2556, 'ru', 'keyword', 'Graphical Keyword Position Reports', 'Графический отчет по позициям ключевых слов', '2016-01-12 21:28:48'),
(2557, 'ru', 'keyword', 'Import Keywords', 'Импорт ключевых слов', '2016-01-12 21:28:48'),
(2558, 'ru', 'keyword', 'Keyword already exist', 'Ключевое слово уже существует', '2016-01-12 21:28:48'),
(2559, 'ru', 'keyword', 'Keyword Position Report', 'Отчет о позиции ключевого слова', '2016-01-12 21:28:48'),
(2560, 'ru', 'keyword', 'New Keyword', 'Новое ключевое слово', '2016-01-12 21:28:48'),
(2561, 'ru', 'keyword', 'not assigned to required search engines', 'не выбраны необходимые поисковые системы', '2016-01-12 21:28:48'),
(2562, 'ru', 'keyword', 'pleaseselecttool', 'Пожалуйста, выберите хотя бы один сео-инструмент', '2016-01-12 21:28:48'),
(2563, 'ru', 'keyword', 'Quick Keyword Position Checker', 'Быстрая проверка позиций ключевых слов', '2016-01-12 21:28:48'),
(2564, 'ru', 'keyword', 'results from ', 'Результаты', '2016-01-12 21:28:48'),
(2565, 'ru', 'keyword', 'Show All results', 'Показать все результаты', '2016-01-12 21:28:48'),
(2566, 'ru', 'keyword', 'Successfully crawled keyword', 'Ключевое слово успешно просканировано', '2016-01-12 21:28:48'),
(2567, 'ru', 'keyword', 'to create new keywords', 'создать новые ключевые слова', '2016-01-12 21:28:48'),
(2568, 'ru', 'label', 'already exist', 'уже существует', '2017-07-13 16:42:21'),
(2569, 'ru', 'label', 'Authentication', 'Аутентификация', '2017-07-13 16:42:21'),
(2570, 'ru', 'label', 'Author', 'Автор', '2017-07-13 16:42:21'),
(2571, 'ru', 'label', 'Click Here', 'Нажмите сюда', '2017-07-13 16:42:21'),
(2572, 'ru', 'label', 'Cron', 'Cron', '2017-07-13 16:42:21'),
(2573, 'ru', 'label', 'Description', 'Описание', '2017-07-13 16:42:21'),
(2574, 'ru', 'label', 'Developers', 'Разработчики', '2017-07-13 16:42:21'),
(2575, 'ru', 'label', 'Download', 'Скачать', '2017-07-13 16:42:21'),
(2576, 'ru', 'label', 'Installation', 'Установка', '2017-07-13 16:42:21'),
(2577, 'ru', 'label', 'Keywords', 'Ключевые слова', '2017-07-13 16:42:21'),
(2578, 'ru', 'label', 'noactiveplugins', 'Нет активных дополнений для Seo panel!', '2017-07-13 16:42:21'),
(2579, 'ru', 'label', 'Plugin', 'Плагины', '2017-07-13 16:42:21'),
(2580, 'ru', 'label', 'Port', 'Порт', '2017-07-13 16:42:21'),
(2581, 'ru', 'label', 'Proxy', 'Прокси', '2017-07-13 16:42:21'),
(2582, 'ru', 'label', 'Re-install', 'Переустановить', '2017-07-13 16:42:21'),
(2583, 'ru', 'label', 'Sponsors', 'Спонсоры', '2017-07-13 16:42:21'),
(2584, 'ru', 'label', 'Title', 'Заголовок', '2017-07-13 16:42:21'),
(2585, 'ru', 'label', 'translation by', 'переведен', '2017-07-13 16:42:21'),
(2586, 'ru', 'label', 'Translators', 'Переводчики', '2017-07-13 16:42:21'),
(2587, 'ru', 'label', 'Upgrade', 'Обновление', '2017-07-13 16:42:21'),
(2588, 'ru', 'label', 'Version', 'Версия', '2017-07-13 16:42:21'),
(2589, 'ru', 'label', 'wantproceed', 'Вы действительно хотите продолжить?', '2017-07-13 16:42:21'),
(2590, 'ru', 'login', 'Confirm Password', 'Повторите пароль', '2016-01-12 21:29:41'),
(2591, 'ru', 'login', 'Create my account', 'Создать аккаунт', '2016-01-12 21:29:41'),
(2592, 'ru', 'login', 'Create New Account', 'Создать новый аккаунт', '2016-01-12 21:29:41'),
(2593, 'ru', 'login', 'Email', 'Email', '2016-01-12 21:29:41'),
(2594, 'ru', 'login', 'emailexist', 'Email уже существует', '2016-01-12 21:29:41');
INSERT INTO `texts` (`id`, `lang_code`, `category`, `label`, `content`, `changed`) VALUES
(2595, 'ru', 'login', 'Enter the code as it is shown', 'Введите код с картинки', '2016-01-12 21:29:41'),
(2596, 'ru', 'login', 'First Name', 'Имя', '2016-01-12 21:29:41'),
(2597, 'ru', 'login', 'Last Name', 'Фамилия', '2016-01-12 21:29:41'),
(2598, 'ru', 'login', 'Login', 'Логин', '2016-01-12 21:29:41'),
(2599, 'ru', 'login', 'Login incorrect', 'Неправильный логин', '2016-01-12 21:29:41'),
(2600, 'ru', 'login', 'newaccountsuccess', 'Новый аккаунт успешно создан!', '2016-01-12 21:29:41'),
(2601, 'ru', 'login', 'Password', 'Пароль', '2016-01-12 21:29:41'),
(2602, 'ru', 'login', 'Password incorrect', 'Неправильный пароль', '2016-01-12 21:29:41'),
(2603, 'ru', 'login', 'Register', 'Регистрация', '2016-01-12 21:29:41'),
(2604, 'ru', 'login', 'Sign in to your account', 'Войдите в свой аккаунт', '2016-01-12 21:29:41'),
(2605, 'ru', 'login', 'User inactive', 'Неактивный пользователь', '2016-01-12 21:29:41'),
(2606, 'ru', 'login', 'Username', 'Имя пользователя', '2016-01-12 21:29:41'),
(2607, 'ru', 'login', 'usernameexist', 'Имя пользователя уже существует!', '2016-01-12 21:29:41'),
(2608, 'ru', 'panel', 'About Us', 'О нас', '2017-07-13 16:46:03'),
(2609, 'ru', 'panel', 'Add following command to your cron tab', 'Добавить следующую команду в вкладку Cron', '2017-07-13 16:46:03'),
(2610, 'ru', 'panel', 'alsocheckfollowlink', 'Также просмотрите следующую ссылку, если вам нужны больше подробностей.', '2017-07-13 16:46:03'),
(2611, 'ru', 'panel', 'Check Directory', 'Выбор каталогов', '2017-07-13 16:46:03'),
(2612, 'ru', 'panel', 'Cron Command', 'Команда Cron', '2017-07-13 16:46:03'),
(2613, 'ru', 'panel', 'Directory Manager', 'Менеджер каталогов', '2017-07-13 16:46:03'),
(2614, 'ru', 'panel', 'Edit My Profile', 'Редактировать профиль', '2017-07-13 16:46:03'),
(2615, 'ru', 'panel', 'My Profile', 'Мой профиль', '2017-07-13 16:46:03'),
(2616, 'ru', 'panel', 'New Proxy', 'Новый прокси', '2017-07-13 16:46:03'),
(2617, 'ru', 'panel', 'New User', 'Новый пользователь', '2017-07-13 16:46:03'),
(2618, 'ru', 'panel', 'New Website', 'Новый сайт', '2017-07-13 16:46:03'),
(2619, 'ru', 'panel', 'Proxy Manager', 'Менеджер прокси', '2017-07-13 16:46:03'),
(2620, 'ru', 'panel', 'Report Generation Manager', 'Менеджер формирования отчетов', '2017-07-13 16:46:03'),
(2621, 'ru', 'panel', 'Reports Manager', 'Менеджер отчетов', '2017-07-13 16:46:03'),
(2622, 'ru', 'panel', 'Seo Plugins Manager', 'Менеджер сео-плагинов', '2017-07-13 16:46:03'),
(2623, 'ru', 'panel', 'Seo Tools Manager', 'Менеджер сео-инструментов', '2017-07-13 16:46:03'),
(2624, 'ru', 'panel', 'System Settings', 'Системные настройки', '2017-07-13 16:46:03'),
(2625, 'ru', 'panel', 'User Manager', 'Менеджер пользователей', '2017-07-13 16:46:03'),
(2626, 'ru', 'panel', 'Website Manager', 'Менеджер сайтов', '2017-07-13 16:46:03'),
(2627, 'ru', 'plugin', 'Edit Seo Plugin', 'Редактировать сео-плагин', '2012-05-13 03:10:56'),
(2628, 'ru', 'plugin', 'Plugin Name', 'Название плагина', '2012-05-13 03:10:56'),
(2629, 'ru', 'plugin', 'Seo Plugin Details', 'Детали сео-плагина', '2012-05-13 03:10:56'),
(2630, 'ru', 'proxy', 'Edit Proxy', 'Редактировать прокси', '2016-12-09 16:23:58'),
(2631, 'ru', 'proxy', 'Proxy Password', 'Пароль прокси', '2016-12-09 16:23:58'),
(2632, 'ru', 'proxy', 'Proxy Username', 'Имя пользователя прокси', '2016-12-09 16:23:58'),
(2633, 'ru', 'proxy', 'Proxyalreadyexist', 'Прокси уже существует!', '2016-12-09 16:23:58'),
(2634, 'ru', 'rank', 'enterurlproceed', 'Введите URL, <b>по одному в каждой строке</b>. Нажмите <b>продолжить</b>, для проверки Google и Alexa Rank.', '2010-10-26 09:52:58'),
(2635, 'ru', 'rank', 'Google and Alexa Rank Reports', 'Отчеты Google и Alexa Rank', '2010-10-26 09:52:58'),
(2636, 'ru', 'rank', 'Saved rank results of', 'Сохраненные результаты', '2010-10-26 09:52:58'),
(2637, 'ru', 'saturation', 'clickproceedsaturation', 'Введите URL, <b>по одному в каждой строке </b>. Нажмите <b>продолжить</b>, для проверки результатов насыщенности в поисковых системах', '2010-10-21 09:16:23'),
(2638, 'ru', 'saturation', 'GenerateSaturationReports', 'Создание отчетов по поисковой насыщенности', '2010-10-21 09:16:23'),
(2639, 'ru', 'saturation', 'Quick Search Engine Saturation Checker', 'Быстрая проверка поисковой насыщенности', '2010-10-21 09:16:23'),
(2640, 'ru', 'saturation', 'Saved Search Engine Saturation results of', 'Сохраненные результаты поисковой насыщенности', '2010-10-21 09:16:23'),
(2641, 'ru', 'saturation', 'Search Engine Saturation Reports', 'Отчеты по поисковой насыщенности', '2010-10-21 09:16:23'),
(2642, 'ru', 'seotools', 'Automatic Submission', 'Автоматическая рассылка', '2017-07-13 16:49:15'),
(2643, 'ru', 'seotools', 'backlink-checker', 'Проверка обратных ссылок', '2017-07-13 16:49:15'),
(2644, 'ru', 'seotools', 'Backlinks Reports', 'Отчеты обратных ссылок', '2017-07-13 16:49:15'),
(2645, 'ru', 'seotools', 'Check Submission Status', 'Проверить статус рассылки', '2017-07-13 16:49:15'),
(2646, 'ru', 'seotools', 'clickgeneratereports', 'Нажмите <b>продолжить</b> для генерации отчета', '2017-07-13 16:49:15'),
(2647, 'ru', 'seotools', 'Detailed Position Reports', 'Детальный отчет о позициях', '2017-07-13 16:49:15'),
(2648, 'ru', 'seotools', 'directory-submission', 'Рассылка в каталоги', '2017-07-13 16:49:15'),
(2649, 'ru', 'seotools', 'Featured Submission', 'Рекомендуемые рассылки', '2017-07-13 16:49:15'),
(2650, 'ru', 'seotools', 'Generate Backlinks Reports', 'Создать отчет по обратным ссылкам', '2017-07-13 16:49:15'),
(2651, 'ru', 'seotools', 'Generate Keyword Reports', 'Создать отчет по ключевым словам', '2017-07-13 16:49:15'),
(2652, 'ru', 'seotools', 'Generate Rank Reports', 'Создать отчет по рейтингу', '2017-07-13 16:49:15'),
(2653, 'ru', 'seotools', 'Generate Saturation Reports', 'Создать отчет по насыщенности', '2017-07-13 16:49:15'),
(2654, 'ru', 'seotools', 'Google Sitemap Generator', 'Генератор карты сайтов Google', '2017-07-13 16:49:15'),
(2655, 'ru', 'seotools', 'Graphical Position Reports', 'Графический отчет о позициях', '2017-07-13 16:49:15'),
(2656, 'ru', 'seotools', 'Keyword Position Summary', 'Отчет по позициям ключевых слов', '2017-07-13 16:49:15'),
(2657, 'ru', 'seotools', 'keyword-position-checker', 'Проверка позиций ключевых слов', '2017-07-13 16:49:15'),
(2658, 'ru', 'seotools', 'Keywords Manager', 'Менеджер ключевых слов', '2017-07-13 16:49:15'),
(2659, 'ru', 'seotools', 'Quick Backlinks Checker', 'Быстрая проверка обратных ссылок', '2017-07-13 16:49:15'),
(2660, 'ru', 'seotools', 'Quick Position Checker', 'Быстрая проверка ключевых слов', '2017-07-13 16:49:15'),
(2661, 'ru', 'seotools', 'Quick Rank Checker', 'Быстрая проверка рейтинга', '2017-07-13 16:49:15'),
(2662, 'ru', 'seotools', 'Quick Saturation Checker', 'Быстрая проверка насыщенности', '2017-07-13 16:49:15'),
(2663, 'ru', 'seotools', 'Rank Reports', 'Отчет по рейтингу', '2017-07-13 16:49:15'),
(2664, 'ru', 'seotools', 'rank-checker', 'Проверка рейтинга', '2017-07-13 16:49:15'),
(2665, 'ru', 'seotools', 'Saturation Reports', 'Проверка насыщенности', '2017-07-13 16:49:15'),
(2666, 'ru', 'seotools', 'saturation-checker', 'Насыщенность в поисковых системах', '2017-07-13 16:49:15'),
(2667, 'ru', 'seotools', 'sitemap-generator', 'Генератор карты сайтов', '2017-07-13 16:49:15'),
(2668, 'ru', 'seotools', 'Skipped Directories', 'Пропущенные каталоги', '2017-07-13 16:49:15'),
(2669, 'ru', 'seotools', 'Submission Reports', 'Отчет по рассылкам', '2017-07-13 16:49:15'),
(2670, 'ru', 'seotools', 'User Access', 'Доступ пользователей', '2017-07-13 16:49:15'),
(2671, 'ru', 'settings', 'Click here to become a sponsor for Seo Panel', '<b>Пожертвовать $100</b> и стать <b>спонсором</b> Seo Panel. ', '2017-07-13 16:50:08'),
(2672, 'ru', 'settings', 'seopanel_description', 'Панель управления поисковой оптимизации сайтов. Содержащего большое количество инструментов для увеличения и отслеживания посещения ваших сайтов. Seo panel инструмент с открытым исходным кодом. Вы можете принять участие в разработке своих собственных плагинов для Seo panel.', '2017-07-13 16:50:08'),
(2673, 'ru', 'settings', 'seopanel_title', 'Seo panel: первый в мире продукт с открытым исходным кодом для управления несколькими сайтами.', '2017-07-13 16:50:08'),
(2674, 'ru', 'settings', 'SP_CRAWL_DELAY', 'Задержка между сканированием паука (в секундах)', '2017-07-13 16:50:08'),
(2675, 'ru', 'settings', 'SP_DEFAULTLANG', 'Язык по умолчанию', '2017-07-13 16:50:08'),
(2676, 'ru', 'settings', 'SP_DESCRIPTION', 'Описание сео-панели', '2017-07-13 16:50:08'),
(2677, 'ru', 'settings', 'SP_ENABLE_PROXY', 'Включить прокси', '2017-07-13 16:50:08'),
(2678, 'ru', 'settings', 'SP_HOTLINKING', 'Проверочное изображение включено', '2017-07-13 16:50:08'),
(2679, 'ru', 'settings', 'SP_KEYWORDS', 'Ключевые слова сео-панели', '2017-07-13 16:50:08'),
(2680, 'ru', 'settings', 'SP_PAGINGNO', 'Количество записей на странице', '2017-07-13 16:50:08'),
(2681, 'ru', 'settings', 'SP_TITLE', 'Заголовок сео-панели', '2017-07-13 16:50:08'),
(2682, 'ru', 'settings', 'SP_USER_GEN_REPORT', 'Разрешить пользователю создавать отчеты', '2017-07-13 16:50:08'),
(2683, 'ru', 'settings', 'SP_USER_REGISTRATION', 'Интерфейс регистрации пользователя', '2017-07-13 16:50:08'),
(2684, 'ru', 'settings', 'syssettingssaved', 'Системные настройки успешно сохранены!', '2017-07-13 16:50:08'),
(2685, 'ru', 'support', 'support_cont1', '<fieldset>\r\n<legend>Служба поддержки Seo Panel</legend>\r\n<ul class=\\"infobox\\">\r\n    <li>\r\n        <h1>Пакет из 1000 каталогов.</h1> \r\n        <p>\r\n            Мы представляем пакет из <b>1000 качественных бесплатных и проверенных</b> интернет-каталогов, для добавления\r\nв вашу seo panel.\r\n            Рассылка поможет вам <b>увеличить количество обратных ссылок</b> на ваш сайт.\r\n            На самом деле список из 1000 каталогов <b>введен</b> для сбора денег на <b>будущее\r\nразвитие</b> seo panel.\r\n            Чтобы получить список из 1000 каталогов, пожалуйста <a href=\\"<?=SP_DONATE_LINK?>\\" target=\\"_blank\\">пожертвуйте</a>\r\n$10 или больше, для улучшения Seo panel.\r\n            Если у вас возникли вопросы связанные с пакетом из 1000 каталогов, пожалуйста,<a href=\\"<?=SP_CONTACT_LINK?>\\"\r\ntarget=\\"_blank\\">свяжитесь с нами</a> или откройте запрос в <a href=\\"<?=SP_SUPPORT_LINK?>\\"\r\ntarget=\\"_blank\\">службе поддержки</a>.   \r\n        </p>        \r\n        <p>\r\n            <a href=\\"<?=SP_DONATE_LINK?>\\" target=\\"_blank\\">Нажмите на ссылку для пожертвования на развитие</a>\r\n        </p>\r\n        <br>\r\n    </li>\r\n    \r\n    <li>\r\n        <h1>Локальный пакет поисковых систем</h1> \r\n        <p>\r\n            Добавить <b>домены локальных поисковых систем</b> google,yahoo,msn(<b>например: www.google.de,www.google.fr\r\nи т.д.</b>) в seo panel, <b>для проверки позиций в поисковых системах</b>, отслеживания производительности вашего сайта \r\nв вашей стране или регионе.\r\n            Для того чтобы получить информацию о добавлении локальных поисковых системах (согласно вашему требованию), пожалуйста, <a\r\nhref=\\"<?=SP_DONATE_LINK?>\\" target=\\"_blank\\">пожертвуйте</a> $10 или больше, для улучшения сео-панели.\r\n            Перед отправкой пожертвования, пожалуйста, <a href=\\"<?=SP_CONTACT_LINK?>\\" target=\\"_blank\\">свяжитесь с нами,</a> мы отправим\r\nвам список необходимых доменов поисковых систем.\r\n            <br><br>              \r\n            Кроме того, чтобы добавить <b>новые поисковые системы (например:yandex.ru)</b> в вашу Seo panel для проверки ключевых слов,\r\nпожалуйста <a href=\\"<?=SP_CONTACT_LINK?>\\" target=\\"_blank\\">свяжитесь с нами</a> или откройте запрос <a\r\nhref=\\"<?=SP_SUPPORT_LINK?>\\" target=\\"_blank\\">в службе поддержки</a>. \r\n        </p>        \r\n        <p class=\\"visit\\">\r\n            <a href=\\"<?=SP_CONTACT_LINK?>\\" target=\\"_blank\\">Пройдите по ссылке, чтобы связаться с нами</a>\r\n        </p>\r\n        <br>\r\n    </li>\r\n    \r\n    <li>\r\n        <h1>Плагины Seo Panel</h1> \r\n        <p>\r\n            Добавить <b>сео-плагины</b> в вашу seo panel для <b>расширения возможностей</b> по вашему требованию.\r\n            <a href=\\"<?=SP_PLUGINSITE?>\\" target=\\"_blank\\">Плагины Seo panel</a> предоставляются разработчиками Seo panel\r\nи сторонними разработчиками.\r\n            Вы также можете легко <b>разработать</b> сео-плагин для вашего seo panel.\r\n            Вы можете <a href=\\"<?=SP_PLUGINSITE?>\\" target=\\"_blank\\">отправить</a> ваш SEO плагин для Seo panel, \r\nмы <b>опубликуем</b> его на нашем сайте после <b>предварительной</b> проверки.        \r\n        </p>        \r\n        <p>\r\n            <a href=\\"<?=SP_PLUGINSITE?>\\" target=\\"_blank\\">Пройдите по ссылке, для получения сео-плагинов</a>\r\n        </p>\r\n        <br>\r\n    </li>    \r\n    <li>\r\n        <h1>Связаться с нами</h1> \r\n        <p>\r\n            Обращайтесь к нам по любым возникшим вопросам по работе с <b>инструментами, плагинами и расширениями seo panel,</b> для\r\nперехода нажмите на ссылку.\r\n        </p>        \r\n        <p>\r\n            <a href=\\"<?=SP_CONTACT_LINK?>\\" target=\\"_blank\\">Пройдите по ссылке для связи с нами.</a>\r\n        </p>\r\n        <br>\r\n    </li>    \r\n    <li>\r\n        <h1>Запросы в поддержку</h1> \r\n        <p>\r\n            Для того чтобы получить <b>техническую поддержку</b> по установке seo panel <b>инструментов, плагинов и\r\nрасширений</b>. Например: Настроить крон для проверки позиций ключевых слов.\r\n        </p>        \r\n        <p>\r\n            <a href=\\"<?=SP_SUPPORT_LINK?>\\" target=\\"_blank\\">Пройдите по ссылке в службу технической поддержки</a>\r\n        </p>\r\n        <br>\r\n    </li>    \r\n    <li>\r\n        <h1>Отчеты по ошибкам</h1> \r\n        <p>\r\n            Для отправки отчетов по <b>ошибкам</b> в <b>инструментах seo panel, плагинах и расширениях</b> нажмите на ссылку.\r\nПожалуйста, помогите нам улучшить возможности в следующей версии.\r\n        </p>        \r\n        <p>\r\n            <a href=\\"<?=SP_SUPPORT_LINK?>\\" target=\\"_blank\\">Пройдите по ссылке для сообщения об ошибке.</a>\r\n        </p>\r\n        <br>\r\n    </li>    \r\n</ul>\r\n</fieldset>', '2011-07-13 18:24:27'),
(2686, 'ru', 'support', 'support_cont2', '<fieldset>\r\n<legend>Онлайн ресурсы Seo Panel</legend>\r\n<ul class=\\"infobox\\">\r\n        \r\n    <li>\r\n        <h1>Руководство Seo Panel</h1> \r\n        <p>\r\n            Вы можете посмотреть <a href=\\"<?=SP_HELP_LINK?>\\" target=\\"_blank\\">документацию seo panel</a> в разделе\r\n<b>руководство</b>, которая содержит <b>документацию</b> по использованию инструментов seo panel, плагинов и расширений.\r\n			<br>Это лучшее место в интернете для получения <br>справки</br> о SEO панели. Мы надеемся, что вы\r\n<b>поможете</b> seo panel в совершенствовании разработки первого бесплатного инструмента для продвижения сайтов!\r\n        </p>\r\n        <p>\r\n            <a href=\\"<?=SP_HELP_LINK?>\\" target=\\"_blank\\">Перейти в раздел помощь</a>\r\n        </p>\r\n        <br>\r\n    </li>    \r\n    <li>\r\n        <h1>Форум Seo Panel</h1> \r\n        <p>\r\n            <b>Форум Seo panel</b>, место для обсуждения первого открытого программного продукта для продвижения сайтов. \r\n            Это лучшее место для поиска <b>ответов</b> на <b>ваши вопросы</b> о seo panel. \r\n            <br>Также вы можете <b>внести</b> долю вашего <b>опыта</b> При использовании Seo panel для оптимизации\r\nсайтов.\r\n        </p>        \r\n        <p>\r\n            <a href=\\"<?=SP_FORUM_LINK?>\\" target=\\"_blank\\">Перейти на форум Seo panel</a>\r\n        </p>\r\n        <br>\r\n    </li>\r\n</ul>    \r\n</fieldset>', '2011-07-13 18:24:27'),
(2687, 'ru', 'support', 'support_cont3', '<fieldset>\r\n<legend>Пожертвования на развитие Seo Panel</legend>\r\n<ul class=\\"infobox\\">        \r\n    <li>\r\n        <h1>Пожертвования на развитие Seo Panel - первой в мире программы для оптимизации сайтов с открытым исходным кодом.</h1> \r\n        <p>\r\n            <b>Поддержите</b> первый в мире скрипт для создания сервиса по продвижению сайтов в интернете.\r\n            Мы планируем в будущем развивать <b>и улучшать </b> программное обеспечение.\r\n            <br>По всем вопросам <b>поддержки</b>, только мы сможем дать правильные <b>ответы</b>.\r\n            Если вы понимаете, что Seo panel <b>стоит</b> вашего внимания, пожалуйста пожертвуйте команде разработчиков.\r\n            <br>Мы <b>опубликуем</b> ваше имя на нашем сайте и ссылку на ваши ресурсы <a href=\\"<?=SP_DONATE_LINK?>\\"\r\ntarget=\\"_blank\\">на странице пожертований</a>, после получения пожертвования.\r\n        </p>\r\n        <p>\r\n            <a href=\\"<?=SP_DONATE_LINK?>\\" target=\\"_blank\\">Перейти на страницу пожертвования seo panel</a>\r\n        </p>\r\n        <br>\r\n    </li>\r\n</ul>\r\n</fieldset>\r\n', '2011-07-13 18:24:27'),
(2688, 'en', 'common', 'Profile', 'Profile', '2010-10-23 07:26:59'),
(2689, 'de', 'common', 'Profile', 'Profil', '2016-01-02 23:21:04'),
(2690, 'zh', 'common', 'Profile', '簡介', '2014-01-09 15:04:07'),
(2691, 'nl', 'common', 'Profile', 'Profiel', '2014-01-07 21:29:58'),
(2692, 'fr', 'common', 'Profile', 'Profil', '2016-12-09 18:11:57'),
(2693, 'hu', 'common', 'Profile', 'Profil', '2013-02-05 19:22:36'),
(2694, 'it', 'common', 'Profile', 'Profilo', '2016-12-09 09:17:20'),
(2695, 'pl', 'common', 'Profile', 'Profil', '2014-01-17 18:46:42'),
(2696, 'ru', 'common', 'Profile', 'Профиль', '2016-12-09 16:23:08'),
(2697, 'es', 'common', 'Profile', 'Perfil', '2012-11-12 20:17:40'),
(2698, 'bg', 'user', 'Edit User', 'Промени', '2016-12-18 17:18:03'),
(2699, 'bg', 'user', 'Saved My Profile Details', 'Детайлите на профила са запазени', '2016-12-18 17:18:03'),
(2700, 'bg', 'button', 'Cancel', 'Откажи', '2014-01-08 19:20:35'),
(2714, 'bg', 'common', 'Alexa Rank', 'Alexa Rank', '2016-12-18 17:04:53'),
(2715, 'bg', 'common', 'All', 'Всичко', '2016-12-18 17:04:53'),
(2716, 'bg', 'common', 'Category', 'Категория', '2016-12-18 17:04:53'),
(2717, 'bg', 'common', 'contact', 'Контакт', '2016-12-18 17:04:53'),
(2718, 'bg', 'common', 'copyright', 'Всички права запазени www.seopanel.in © [year]', '2016-12-18 17:04:53'),
(2719, 'bg', 'common', 'Country', 'Страна', '2016-12-18 17:04:53'),
(2720, 'bg', 'common', 'Crawl Meta Data', 'Обери Мета данни', '2016-12-18 17:04:53'),
(2721, 'bg', 'common', 'Date', 'Дата', '2016-12-18 17:04:53'),
(2722, 'bg', 'common', 'Delete', 'Изтрий', '2016-12-18 17:04:53'),
(2723, 'bg', 'common', 'Details', 'Детайли', '2016-12-18 17:04:53'),
(2724, 'bg', 'common', 'Directory', 'Директория', '2016-12-18 17:04:53'),
(2725, 'bg', 'common', 'Donate', 'Дарение', '2016-12-18 17:04:53'),
(2726, 'bg', 'common', 'Edit', 'Промени', '2016-12-18 17:04:53'),
(2727, 'bg', 'common', 'Entry cannot be blank', 'Не можете да оставите празно', '2016-12-18 17:04:53'),
(2728, 'bg', 'common', 'entrynotvalid', 'Въведените данни са невалидни', '2016-12-18 17:04:53'),
(2729, 'bg', 'common', 'failed', 'неуспешно', '2016-12-18 17:04:53'),
(2730, 'bg', 'common', 'forum', 'Форум', '2016-12-18 17:04:53'),
(2731, 'bg', 'common', 'Found', 'Намерени', '2016-12-18 17:04:53'),
(2732, 'bg', 'common', 'Google Pagerank', 'Google Пейдж Ранк ', '2016-12-18 17:04:53'),
(2733, 'bg', 'common', 'help', 'Помощ', '2016-12-18 17:04:53'),
(2734, 'bg', 'common', 'hidenews', 'Скрий новините', '2016-12-18 17:04:53'),
(2735, 'bg', 'common', 'Id', 'Id', '2016-12-18 17:04:53'),
(2736, 'bg', 'common', 'Inactivate', 'Деактивирай', '2016-12-18 17:04:53'),
(2737, 'bg', 'common', 'Inactive', 'Неактивен', '2016-12-18 17:04:53'),
(2738, 'bg', 'common', 'Invalid characters', 'Невалидни символи', '2016-12-18 17:04:53'),
(2739, 'bg', 'common', 'Invalid code entered', 'Невалиден код', '2016-12-18 17:04:53'),
(2740, 'bg', 'common', 'Invalid email address entered', 'Невалиден email адрес', '2016-12-18 17:04:53'),
(2741, 'bg', 'common', 'Invalid value', 'Невалидна стойност', '2016-12-18 17:04:53'),
(2742, 'bg', 'common', 'Keyword', 'Ключова дума', '2016-12-18 17:04:53'),
(2743, 'bg', 'common', 'Keywords', 'Ключови думи', '2016-12-18 17:04:53'),
(2744, 'bg', 'common', 'lang', 'Език', '2016-12-18 17:04:53'),
(2745, 'bg', 'common', 'My Account', 'Моят профил', '2016-12-18 17:04:53'),
(2746, 'bg', 'common', 'Name', 'Име', '2016-12-18 17:04:53'),
(2747, 'bg', 'common', 'No', 'Не', '2016-12-18 17:04:53'),
(2748, 'bg', 'common', 'No Keywords Found', 'Не са намерени ключови думи', '2016-12-18 17:04:53'),
(2749, 'bg', 'common', 'No Records Found', 'Не са намерени записи', '2016-12-18 17:04:53'),
(2750, 'bg', 'common', 'noactivetools', 'Не са намерени активни SEO инструменти', '2016-12-18 17:04:53'),
(2751, 'bg', 'common', 'nowebsites', 'Не са открити сайтове', '2016-12-18 17:04:53'),
(2752, 'bg', 'common', 'password632', 'Паролата трябва да е с дължина от 6 до 32 символа', '2016-12-18 17:04:53'),
(2753, 'bg', 'common', 'passwordnotmatch', 'Паролите не съвпадат', '2016-12-18 17:04:53'),
(2754, 'bg', 'common', 'Period', 'Период', '2016-12-18 17:04:53'),
(2755, 'bg', 'common', 'Priority', 'Приоритет', '2016-12-18 17:04:53'),
(2756, 'bg', 'common', 'Profile', 'Профил', '2016-12-18 17:04:53'),
(2757, 'bg', 'common', 'Rank', 'Ранк', '2016-12-18 17:04:53'),
(2758, 'bg', 'common', 'Reports', 'Доклади', '2016-12-18 17:04:53'),
(2759, 'bg', 'common', 'Results', 'Резултати', '2016-12-18 17:04:53'),
(2760, 'bg', 'common', 'Search Engine', 'Търсачка', '2016-12-18 17:04:53'),
(2761, 'bg', 'common', 'Select', 'Избери', '2016-12-18 17:04:53'),
(2762, 'bg', 'common', 'Seo Plugins', 'Seo Модули', '2016-12-18 17:04:53'),
(2763, 'bg', 'common', 'Seo Tools', 'Seo Инструменти', '2016-12-18 17:04:53'),
(2764, 'bg', 'common', 'Sign out', 'Изход', '2016-12-18 17:04:53'),
(2765, 'bg', 'common', 'Sign Up', 'Регистрация', '2016-12-18 17:04:53'),
(2766, 'bg', 'common', 'signin', 'Вход', '2016-12-18 17:04:53'),
(2767, 'bg', 'common', 'Status', 'Статус', '2016-12-18 17:04:53'),
(2768, 'bg', 'common', 'Support', 'Поддръжка', '2016-12-18 17:04:53'),
(2769, 'bg', 'common', 'Total', 'Общо', '2016-12-18 17:04:53'),
(2770, 'bg', 'common', 'Url', 'Url', '2016-12-18 17:04:53'),
(2771, 'bg', 'common', 'User', 'Потребител', '2016-12-18 17:04:53'),
(2772, 'bg', 'common', 'User Panel', 'Потребителски панел', '2016-12-18 17:04:53'),
(2773, 'bg', 'common', 'Website', 'Сайт', '2016-12-18 17:04:53'),
(2774, 'bg', 'common', 'Yes', 'Да', '2016-12-18 17:04:53'),
(2775, 'pt', 'backlink', 'clickproceedbacklink', 'Introduza o URL <b>Um por linha</b>. Pressione on <b>Proceda</b> para verificar os Backlinks ', '2010-10-27 03:30:04'),
(2776, 'pt', 'backlink', 'Saved backlink results of', 'Resultados guardados do Checklink de', '2010-10-27 03:30:04'),
(2777, 'pt', 'button', 'Cancel', 'Cancelar', '2014-01-08 19:31:51'),
(2778, 'pt', 'button', 'Check Status', 'Verificar Status', '2014-01-08 19:31:51'),
(2779, 'pt', 'button', 'Proceed', 'Prosseguir', '2014-01-08 19:31:51'),
(2780, 'pt', 'button', 'Reload', 'Carregar', '2014-01-08 19:31:51'),
(2781, 'pt', 'button', 'Show Details', 'Ver detalhes', '2014-01-08 19:31:51'),
(2782, 'pt', 'button', 'Show Records', 'Ver Registos', '2014-01-08 19:31:51'),
(2783, 'pt', 'button', 'Skip', 'Passar', '2014-01-08 19:31:51'),
(2784, 'pt', 'button', 'Submit', 'Submeter', '2014-01-08 19:31:51'),
(2785, 'ro', 'backlink', 'clickproceedbacklink', 'Introduceti URL-urile <b> Cate unul pe rand <b>. Apasa pe <b>Continua<b> pentru a verifica Backlink-urile', '2010-10-27 01:19:53'),
(2786, 'ro', 'backlink', 'Saved backlink results of', 'Backlink-uri salvate rezultat al', '2010-10-27 01:19:53'),
(2787, 'ro', 'button', 'Cancel', 'Anuleaza', '2014-01-08 19:32:28'),
(2788, 'ro', 'button', 'Check Status', 'Verifica statusul', '2014-01-08 19:32:28'),
(2789, 'ro', 'button', 'Proceed', 'Continua', '2014-01-08 19:32:28'),
(2790, 'ro', 'button', 'Reload', 'Reincarca', '2014-01-08 19:32:28'),
(2791, 'ro', 'button', 'Show Details', 'Arata detalii', '2014-01-08 19:32:28'),
(2792, 'ro', 'button', 'Show Records', 'Arata inregistrari', '2014-01-08 19:32:28'),
(2793, 'ro', 'button', 'Skip', 'Sari', '2014-01-08 19:32:28'),
(2794, 'ro', 'button', 'Submit', 'Executa', '2014-01-08 19:32:28'),
(2795, 'ro', 'common', 'Action', 'Actiune', '2012-05-18 20:47:00'),
(2796, 'ro', 'common', 'Activate', 'Activeaza', '2012-05-18 20:47:00'),
(2797, 'ro', 'common', 'Active', 'Activ', '2012-05-18 20:47:00'),
(2798, 'ro', 'common', 'Admin Panel', 'Panoul de comanda', '2012-05-18 20:47:00'),
(2799, 'ro', 'common', 'Alexa Rank', 'Rank Alexa', '2012-05-18 20:47:00'),
(2800, 'ro', 'common', 'All', 'Toate', '2012-05-18 20:47:00'),
(2801, 'ro', 'common', 'Category', 'Categorie', '2012-05-18 20:47:00'),
(2802, 'ro', 'common', 'contact', 'Contact', '2012-05-18 20:47:00'),
(2803, 'ro', 'common', 'copyright', 'Copyright © [year] www.seopanel.in Toate drepturile rezervate', '2012-05-18 20:47:00'),
(2804, 'ro', 'common', 'Country', 'Tara', '2012-05-18 20:47:00'),
(2805, 'ro', 'common', 'Crawl Meta Data', 'Crawl Meta Data', '2012-05-18 20:47:00'),
(2806, 'ro', 'common', 'Date', 'Data', '2012-05-18 20:47:00'),
(2807, 'ro', 'common', 'Delete', 'Sterge', '2012-05-18 20:47:00'),
(2808, 'ro', 'common', 'Details', 'Detalii', '2012-05-18 20:47:00'),
(2809, 'ro', 'common', 'Directory', 'Director', '2012-05-18 20:47:00'),
(2810, 'ro', 'common', 'Donate', 'Doneaza', '2012-05-18 20:47:00'),
(2811, 'ro', 'common', 'Edit', 'Editeaza', '2012-05-18 20:47:00'),
(2812, 'ro', 'common', 'Entry cannot be blank', 'Campul nu poate fi gol', '2012-05-18 20:47:00'),
(2813, 'ro', 'common', 'entrynotvalid', 'Datele din camp nu sunt valide', '2012-05-18 20:47:00'),
(2814, 'ro', 'common', 'failed', 'esuat', '2012-05-18 20:47:00'),
(2815, 'ro', 'common', 'forum', 'Forum', '2012-05-18 20:47:00'),
(2816, 'ro', 'common', 'Found', 'Gasit', '2012-05-18 20:47:00'),
(2817, 'ro', 'common', 'Google Pagerank', 'Google Pagerank', '2012-05-18 20:47:00'),
(2818, 'ro', 'common', 'help', 'Ajutor', '2012-05-18 20:47:00'),
(2819, 'ro', 'common', 'hidenews', 'Ascunde Noutatile Seo Panel', '2012-05-18 20:47:00'),
(2820, 'ro', 'common', 'Id', 'Id', '2012-05-18 20:47:00'),
(2821, 'ro', 'common', 'Inactivate', 'Inactiva', '2012-05-18 20:47:00'),
(2822, 'ro', 'common', 'Inactive', 'Inactiv', '2012-05-18 20:47:00'),
(2823, 'ro', 'common', 'Invalid characters', 'Caractere invalide', '2012-05-18 20:47:00'),
(2824, 'ro', 'common', 'Invalid code entered', 'Cod introdus invalid', '2012-05-18 20:47:00'),
(2825, 'ro', 'common', 'Invalid email address entered', 'Adresa de e-mail introdusa invalida', '2012-05-18 20:47:00'),
(2826, 'ro', 'common', 'Invalid value', 'Valoare invalida', '2012-05-18 20:47:00'),
(2827, 'ro', 'common', 'Keyword', 'Cuvant cheie', '2012-05-18 20:47:00'),
(2828, 'ro', 'common', 'Keywords', 'Cuvinte cheie', '2012-05-18 20:47:00'),
(2829, 'ro', 'common', 'lang', 'Limba', '2012-05-18 20:47:00'),
(2830, 'ro', 'common', 'My Account', 'Contul Meu', '2012-05-18 20:47:00'),
(2831, 'ro', 'common', 'Name', 'Nume', '2012-05-18 20:47:00'),
(2832, 'ro', 'common', 'No', 'Nu', '2012-05-18 20:47:00'),
(2833, 'ro', 'common', 'No Keywords Found', 'Niciun cuvant cheie gasit', '2012-05-18 20:47:00'),
(2834, 'ro', 'common', 'No Records Found', 'Nicio inregistrare gasita', '2012-05-18 20:47:00'),
(2835, 'ro', 'common', 'noactivetools', 'Nicio unealta Seo gasita', '2012-05-18 20:47:00'),
(2836, 'ro', 'common', 'nowebsites', 'Niciun website gasit', '2012-05-18 20:47:00'),
(2837, 'ro', 'common', 'password632', 'Parola trebuie sa aibe intre 6 si 32 de caractere', '2012-05-18 20:47:00'),
(2838, 'ro', 'common', 'passwordnotmatch', 'Parola nu se potriveste', '2012-05-18 20:47:00'),
(2839, 'ro', 'common', 'Period', 'Perioada', '2012-05-18 20:47:00'),
(2840, 'ro', 'common', 'Priority', 'Prioritate', '2012-05-18 20:47:00'),
(2841, 'ro', 'common', 'Profile', 'Profil', '2012-05-18 20:47:00'),
(2842, 'ro', 'common', 'Rank', 'Rank', '2012-05-18 20:47:00'),
(2843, 'ro', 'common', 'Reports', 'Rapoarte', '2012-05-18 20:47:00'),
(2844, 'ro', 'common', 'Results', 'Rezultate', '2012-05-18 20:47:00'),
(2845, 'ro', 'common', 'Search Engine', 'Motor de cautare', '2012-05-18 20:47:00'),
(2846, 'ro', 'common', 'Select', 'Selecteaza', '2012-05-18 20:47:00'),
(2847, 'ro', 'common', 'Seo Plugins', 'Plugin-uri seo', '2012-05-18 20:47:00'),
(2848, 'ro', 'common', 'Seo Tools', 'Unelte Seo', '2012-05-18 20:47:00'),
(2849, 'ro', 'common', 'Sign out', 'Iesire', '2012-05-18 20:47:00'),
(2850, 'ro', 'common', 'Sign Up', 'Inregistrare', '2012-05-18 20:47:00'),
(2851, 'ro', 'common', 'signin', 'Autentificare', '2012-05-18 20:47:00'),
(2852, 'ro', 'common', 'Status', 'Status', '2012-05-18 20:47:00'),
(2853, 'ro', 'common', 'Support', 'Suport', '2012-05-18 20:47:00'),
(2854, 'ro', 'common', 'Total', 'Total', '2012-05-18 20:47:00'),
(2855, 'ro', 'common', 'Url', 'Url', '2012-05-18 20:47:00'),
(2856, 'ro', 'common', 'User', 'Utilizator', '2012-05-18 20:47:00'),
(2857, 'ro', 'common', 'User Panel', 'Panoul utilizatorului', '2012-05-18 20:47:00'),
(2858, 'ro', 'common', 'Website', 'Site web', '2012-05-18 20:47:00'),
(2859, 'ro', 'common', 'Yes', 'Da', '2012-05-18 20:47:00'),
(2860, 'it', 'support', 'support_cont1', '<fieldset>\r\n<legend>Sistema supporto pannello seo</legend>\r\n<ul class=\\"infobox\\">\r\n    <li>\r\n        <h1>Pacchetto 1000 Directory</h1> \r\n        <p>\r\n            Forniamo un pacchetto di <b>1000 directory gratuite verificate e attive</b>, puoi inserirlo nel tuo pannello seo tramite lo <b>strumento di invio directory</b>.Ti aiuterà ad  <b>incrementare i backlink</b> verso il tuo sito web.\r\n        Attualmente l\\''elenco di <span id=\\"result_box\\" lang=\\"it\\"><span title=\\"\\"> 1000  directory viene utilizzato per raccogliere fondi per il <strong>futuro sviluppo</strong> del pannello di seo</span></span>.\r\n        Per avere la lista delle 1000 directory è sufficiente  <a href=\\"<?=SP_DONATE_LINK?>\\" target=\\"_blank\\">fare una donazione di </a> $10 o più per migliorare le caratteristiche del pannello seo.\r\n        Per qualsiasi informazione sulle 1000 directory non esitare a  <a href=\\"<?=SP_CONTACT_LINK?>\\"\r\ntarget=\\"_blank\\">contattarci</a> o ad aprire un ticket sul  <a href=\\"<?=SP_SUPPORT_LINK?>\\"\r\ntarget=\\"_blank\\">forum di supporto</a>.        </p>\r\n    </li>\r\n    \r\n    <li>\r\n      <p>\r\n      <a href=\\"<?=SP_DONATE_LINK?>\\" target=\\"_blank\\">Visita questo link per effettuare una donazione per il pannello seo</a></p>\r\n      <br>\r\n    </li>\r\n    <li>\r\n        <h1>Pacchetti modori di ricerca in locale</h1> \r\n        <p>\r\n            Aggiungi i  <b>domini dei motori di ricerca in locale</b> di google,yahoo,msn(<b>es: www.google.de,www.google.fr ecc\r\n</b>) al pannello seo per la  <b>verifica della posizione delle keyword</b>, per tracciare le performance del tuo sito in locale.\r\n            Per ottenere il pacchetto dei motori di ricerca in locale(in base alle tue esigenze) per cortesia <a\r\nhref=\\"<?=SP_DONATE_LINK?>\\" target=\\"_blank\\">donae</a> $10 o di più per migliorare le caratteristiche del pannello seo. Prima di inviare una donazione, per cortesia <a href=\\"<?=SP_CONTACT_LINK?>\\" target=\\"_blank\\">contattaci</a> per fornirci l\\''elenco dei domini che vuoi richiedere.<br>\r\n<br>              \r\n            Puoi anche aggiungere  <b>nuovi motori di ricerca (es:baidu.com)</b> al tuo pannello seo per la verifica della posizione delle keyword. Per fare questo puoi <a href=\\"<?=SP_CONTACT_LINK?>\\" target=\\"_blank\\">contattarci</a> o aprire un ticket nel <a\r\nhref=\\"<?=SP_SUPPORT_LINK?>\\" target=\\"_blank\\">sistema di supporto</a>.        </p>        \r\n<p class=\\"visit\\">\r\n            <a href=\\"<?=SP_CONTACT_LINK?>\\" target=\\"_blank\\">Visita questo link per contattarci</a></p>\r\n      <br>\r\n    </li>\r\n    \r\n    <li>\r\n        <h1>Plugin pannello seo</h1> \r\n  <p>\r\n            Aggiungi <b>plugin seo </b>al tuo pannello seo per  <b>estendere le caratteristiche</b> in base alle tue esigenze.\r\n      <a href=\\"<?=SP_PLUGINSITE?>\\" target=\\"_blank\\">I plugin del pannello seo </a>sono realizzati dallo stesso SeoPanel che da terze parti. Puoi anche semplicemente <b>sviluppare</b> i plugin seo per il tuo stesso pannello.Puoi  <a href=\\"<?=SP_PLUGINSITE?>\\" target=\\"_blank\\">inviare</a> il tuo plugin seo e noi e provvederemo a  <b>pubblicarlo </b>nel nostro sito web dopo il nostro processo di  <b>verifica</b>.    </p>\r\n    </li>    \r\n    <li>\r\n      <p>\r\n    <a href=\\"<?=SP_PLUGINSITE?>\\" target=\\"_blank\\">Visita questo link per prelevare plugin del pannello seo</a></p>\r\n  <br>\r\n    </li>\r\n    <li>\r\n        <h1>Contattaci</h1> \r\n        <p>\r\n      Contattaci per qualsiasi questione riguardante il <b>pannello seo, plugin e caratteristiche ecc</b> utilizzando il link che si presenta di seguito.        </p>        \r\n        <p>\r\n            <a href=\\"<?=SP_CONTACT_LINK?>\\" target=\\"_blank\\">Visita questo link per contattarci.</a></p>\r\n        <br>\r\n    </li>    \r\n    <li>\r\n        <h1>Ticket di supporto</h1> \r\n        <p>\r\n      Per avere  <b>supporto tecnico </b>dal team del pannello seo per installare gli <b>strumenti del pannello seo, plugin e altre caratteristiche.</b> Es: per configurare la cronologia per la verifica delle posizioni per le keyword.        </p>\r\n    </li>    \r\n    <li>\r\n      <p>\r\n        <a href=\\"<?=SP_SUPPORT_LINK?>\\" target=\\"_blank\\">Visita questo link per creare un ticket di supporto</a></p>\r\n      <br>\r\n    </li>\r\n    <li>\r\n        <h1>Segnala bug</h1> \r\n        <p>\r\n            Riporta i  <b>bug</b> relativi gli <b>strumenti del pannello seo,plugin, caratteristiche ecc</b> utilizzando il seguente link. Per cortesia aiutaci a migliorare tutte le caratteristiche per la prossima versione.        </p>        \r\n        <p>\r\n            <a href=\\"<?=SP_SUPPORT_LINK?>\\" target=\\"_blank\\">Visita questo link per segnalare bug</a></p>\r\n        <br>\r\n    </li>    \r\n</ul>\r\n</fieldset>', '2010-10-27 02:36:28'),
(2861, 'it', 'support', 'support_cont2', '<fieldset>\r\n<legend>Risorse online pannello seo</legend>\r\n<ul class=\\"infobox\\">\r\n        \r\n    <li>\r\n      <h1>Guida di aiuto del pannello seo</h1> \r\n      <p>\r\n            Puoi visualizzare la  <a href=\\"<?=SP_HELP_LINK?>\\" target=\\"_blank\\">documentazione del pannello seo </a> nella<b> guida di aiuto</b>, che contiene la<b> documentazione</b> per gli strumenti del pannello seo, plugin e relative caratteristiche.<br>\r\n          Questo è il miglior posto su internet per  <b>ricevere aiuto</b> circa il pannello seo. Speriamo che tu possa \r\n<b>contribuire</b> per la guida del pannello seo se sono errori o dimenticanze.</p>\r\n        <p>\r\n        <a href=\\"<?=SP_HELP_LINK?>\\" target=\\"_blank\\">Visita la guida di aiuto del pannello seo</a></p>\r\n        <br>\r\n    </li>    \r\n    <li>\r\n        <h1>Forum Pannello Seo</h1> \r\n        <p>\r\n            Un posto dove discutere del primo <b>pannello di controllo seo </b>open source al mondo.          Questo è il posto migliore dove trovare le <b>risposte</b> alle <b>tue domande</b> circa il pannello seo. \r\n            <br>\r\n      Puoi anche <b>condividere</b> la tua  <b>esperienza</b> nell\\''utilizzo del pannello seo per ottimizzare il tuo sito web.      </p>        \r\n        <p>\r\n        <a href=\\"<?=SP_FORUM_LINK?>\\" target=\\"_blank\\">Visita il forum del pannello seo</a></p>\r\n        <br>\r\n  </li>\r\n</ul>    \r\n</fieldset>', '2010-10-27 02:36:28'),
(2862, 'it', 'support', 'support_cont3', '<fieldset>\r\n<legend>Dona al pannello seo</legend>\r\n<ul class=\\"infobox\\">        \r\n  <li>\r\n      <h1>Dona al Pannello Seo - Il primo pannello di controllo seo Open Source al mondo</h1> \r\n        <p>\r\n            <b>Dona</b> al pannello seo per supportare il primo pannello di controllo seo open source al mondo.Abbiamo programmato di  <b>aggiungere e migliorare</b> molte caratteristiche del pannello seo in futuro. \r\n            <br>\r\n            Con il vostro <b>supporto</b> possiamo raggiungere i nostri  <b>obiettivi</b>. <span id=\\"result_box\\" lang=\\"it\\" xml:lang=\\"it\\"><span title=\\"\\">Se ritieni che il pannello seo è fatto<strong> per voi,</strong> fate una donazione al team del pannello seo.<br />\r\n            </span><span title=\\"\\">Noi <strong>pubblicheremo</strong> il vostro nome e informazioni sul sito nella <a href=\\"<?=SP_DONATE_LINK?>\\"\r\ntarget=\\"_blank\\">pagina di donazione</a>, una volta ottenuta.</span></span><br>\r\n        </p>\r\n        <p>\r\n            <a href=\\"<?=SP_DONATE_LINK?>\\" target=\\"_blank\\">Visita questo link per donare al pannello seo</a></p>\r\n        <br>\r\n  </li>\r\n</ul>\r\n</fieldset>', '2010-10-27 02:36:28'),
(2863, 'ro', 'website', 'Edit Website', 'Editare Site Web', '2010-10-27 02:48:10'),
(2864, 'ro', 'website', 'plscrtwebsite', 'Va rugam creati un Site Web inainte sa folositi Unelte Seo si Plugin-uri Seo', '2010-10-27 02:48:10'),
(2865, 'ro', 'website', 'Website already exist', 'Site Web deja existent', '2010-10-27 02:48:10'),
(2866, 'ro', 'website', 'yourwebalreday', 'Site-ul Web al dvs. daca deja ati creat unul.', '2010-10-27 02:48:10'),
(2867, 'ro', 'user', 'Edit User', 'Editare utilizator', '2010-10-27 02:48:37'),
(2868, 'ro', 'user', 'Saved My Profile Details', 'Salvati detaliile profilului meu.', '2010-10-27 02:48:37'),
(2869, 'ro', 'sitemap', 'Change frequency', 'Schimba frecventa', '2010-10-29 01:26:49'),
(2870, 'ro', 'sitemap', 'clickproceedsitemap', 'Apasa pe <b>Continua</b> pentru a creea un fisier sitemap', '2010-10-29 01:26:49'),
(2871, 'ro', 'sitemap', 'Download sitemap file from', 'Descarca fisierul sitemap de la', '2010-10-29 01:26:49'),
(2872, 'ro', 'sitemap', 'Exclude Url', 'Exclude Url', '2010-10-29 01:26:49'),
(2873, 'ro', 'sitemap', 'processtaketime', 'Acest proces va dura ceva timp in functie de numarul link-urilor din site. Va rugam asteptati sa luati fisierele sitemap', '2010-10-29 01:26:49'),
(2874, 'ro', 'sitemap', 'Sitemap Type', 'Tip Sitemap', '2010-10-29 01:26:49'),
(2875, 'ro', 'rank', 'enterurlproceed', 'Introduceti adresele Url <b>Una pe linie</b>. Apasa pe <b>Continua</b> pentru a verifica Google si Alexa Rank', '2010-10-27 02:53:36'),
(2876, 'ro', 'rank', 'Google and Alexa Rank Reports', 'Rapoarte Google si Alexa Rank ', '2010-10-27 02:53:36'),
(2877, 'ro', 'rank', 'Saved rank results of', 'Salveaza rezultatele de rank pentru', '2010-10-27 02:53:36'),
(2878, 'ro', 'proxy', 'Edit Proxy', 'Editeaza Proxy', '2010-10-27 02:54:27'),
(2879, 'ro', 'proxy', 'Proxy Password', 'Parola Proxy', '2010-10-27 02:54:27'),
(2880, 'ro', 'proxy', 'Proxy Username', 'Utilizator Proxy', '2010-10-27 02:54:27'),
(2881, 'ro', 'proxy', 'Proxyalreadyexist', 'Proxy deja existent!', '2010-10-27 02:54:27'),
(2882, 'ro', 'plugin', 'Edit Seo Plugin', 'Editeaza Plugin Seo', '2012-05-18 21:05:13'),
(2883, 'ro', 'plugin', 'Plugin Name', 'Nume PLugin', '2012-05-18 21:05:13'),
(2884, 'ro', 'plugin', 'Seo Plugin Details', 'Detalii Plugin Seo', '2012-05-18 21:05:13'),
(2887, 'ro', 'panel', 'alsocheckfollowlink', 'Deasemenea verificati urmatorul link daca doriti mai multe detalii.', '2012-05-18 21:04:43'),
(2888, 'ro', 'panel', 'Check Directory', 'Verifica Director', '2012-05-18 21:04:43'),
(2889, 'ro', 'panel', 'Cron Command', 'Comanda Cron', '2012-05-18 21:04:43'),
(2890, 'ro', 'panel', 'Directory Manager', 'Manager Directoare', '2012-05-18 21:04:43'),
(2891, 'ro', 'panel', 'Edit My Profile', 'Editeaza Profilul Meu', '2012-05-18 21:04:43'),
(2892, 'ro', 'panel', 'My Profile', 'Profilul Meu', '2012-05-18 21:04:43'),
(2893, 'ro', 'panel', 'New Proxy', 'Proxy Nou', '2012-05-18 21:04:43'),
(2894, 'ro', 'panel', 'New User', 'Utilizator Nou', '2012-05-18 21:04:43'),
(2895, 'ro', 'panel', 'New Website', 'Site Web Nou', '2012-05-18 21:04:43'),
(2896, 'ro', 'panel', 'Proxy Manager', 'Manager Proxy', '2012-05-18 21:04:43'),
(2897, 'ro', 'panel', 'Report Generation Manager', 'Manager generare rapoarte', '2012-05-18 21:04:43'),
(2898, 'ro', 'panel', 'Reports Manager', 'Manager Rapoarte', '2012-05-18 21:04:43'),
(2899, 'ro', 'panel', 'Seo Plugins Manager', 'Manager Plugin Seo', '2012-05-18 21:04:43'),
(2900, 'ro', 'panel', 'Seo Tools Manager', 'Manager Unelte Seo', '2012-05-18 21:04:43'),
(2901, 'ro', 'panel', 'System Settings', 'Setari Sistem', '2012-05-18 21:04:43'),
(2902, 'ro', 'panel', 'User Manager', 'Manager utilizator', '2012-05-18 21:04:43'),
(2903, 'ro', 'panel', 'Website Manager', 'Manager Site Web', '2012-05-18 21:04:43'),
(2904, 'pt', 'common', 'Action', 'Acção ', '2016-01-17 18:56:05'),
(2905, 'pt', 'common', 'Activate', 'Activar ', '2016-01-17 18:56:05'),
(2906, 'pt', 'common', 'Active', 'Activo', '2016-01-17 18:56:05'),
(2907, 'pt', 'common', 'Admin Panel', 'Painel de Administração ', '2016-01-17 18:56:05'),
(2908, 'pt', 'common', 'Alexa Rank', 'Classificação na Alexa', '2016-01-17 18:56:05'),
(2909, 'pt', 'common', 'All', 'Categoria ', '2016-01-17 18:56:05'),
(2910, 'pt', 'common', 'Category', 'Categoria ', '2016-01-17 18:56:05'),
(2911, 'pt', 'common', 'contact', 'Contacto ', '2016-01-17 18:56:05'),
(2912, 'pt', 'common', 'copyright', 'Copyright © [year] www.seopanel.in Todos os direitos reservados ', '2016-01-17 18:56:05'),
(2913, 'pt', 'common', 'Country', 'País ', '2016-01-17 18:56:05'),
(2914, 'pt', 'common', 'Crawl Meta Data', 'Meta dados de pesquisa', '2016-01-17 18:56:05'),
(2915, 'pt', 'common', 'Date', 'Data ', '2016-01-17 18:56:05'),
(2916, 'pt', 'common', 'Delete', 'Excluir ', '2016-01-17 18:56:05'),
(2917, 'pt', 'common', 'Details', 'Detalhes ', '2016-01-17 18:56:05'),
(2918, 'pt', 'common', 'Directory', 'Directório', '2016-01-17 18:56:05'),
(2919, 'pt', 'common', 'Donate', 'Doar ', '2016-01-17 18:56:05'),
(2920, 'pt', 'common', 'Edit', 'Editar ', '2016-01-17 18:56:05'),
(2921, 'pt', 'common', 'Entry cannot be blank', 'Entrada não pode estar em branco', '2016-01-17 18:56:05'),
(2922, 'pt', 'common', 'entrynotvalid', 'A entrada digitada não parece ser válido ', '2016-01-17 18:56:05'),
(2923, 'pt', 'common', 'failed', 'falhado', '2016-01-17 18:56:05'),
(2924, 'pt', 'common', 'forum', 'Fórum ', '2016-01-17 18:56:05'),
(2925, 'pt', 'common', 'Found', 'Encontrados ', '2016-01-17 18:56:05'),
(2926, 'pt', 'common', 'Google Pagerank', 'Google Pagerank ', '2016-01-17 18:56:05'),
(2927, 'pt', 'common', 'help', 'Ajuda ', '2016-01-17 18:56:05'),
(2928, 'pt', 'common', 'hidenews', 'Ocultar Noticias do Painel Seo ', '2016-01-17 18:56:05'),
(2929, 'pt', 'common', 'Id', 'ID ', '2016-01-17 18:56:05'),
(2930, 'pt', 'common', 'Inactivate', 'Desactivar', '2016-01-17 18:56:05'),
(2931, 'pt', 'common', 'Inactive', 'Inactivo ', '2016-01-17 18:56:05'),
(2932, 'pt', 'common', 'Invalid characters', 'caracteres inválidos ', '2016-01-17 18:56:05'),
(2933, 'pt', 'common', 'Invalid code entered', 'Código inválido entrou ', '2016-01-17 18:56:05'),
(2934, 'pt', 'common', 'Invalid email address entered', 'Endereço de email inválido entrou ', '2016-01-17 18:56:05'),
(2935, 'pt', 'common', 'Invalid value', 'Valor inválido ', '2016-01-17 18:56:05'),
(2936, 'pt', 'common', 'Keyword', 'Palavra ', '2016-01-17 18:56:05'),
(2937, 'pt', 'common', 'Keywords', 'Palavras-chave ', '2016-01-17 18:56:05'),
(2938, 'pt', 'common', 'lang', 'Idioma ', '2016-01-17 18:56:05'),
(2939, 'pt', 'common', 'My Account', 'Minha Conta ', '2016-01-17 18:56:05'),
(2940, 'pt', 'common', 'Name', 'Nome ', '2016-01-17 18:56:05'),
(2941, 'pt', 'common', 'No', 'Não ', '2016-01-17 18:56:05'),
(2942, 'pt', 'common', 'No Keywords Found', 'Nenhuma palavra-chave encontrados ', '2016-01-17 18:56:05'),
(2943, 'pt', 'common', 'No Records Found', 'Nenhum Registo Encontrado ', '2016-01-17 18:56:05'),
(2944, 'pt', 'common', 'noactivetools', 'Não Seo Tools activo encontrado! ', '2016-01-17 18:56:05'),
(2945, 'pt', 'common', 'nowebsites', 'Nenhum dos sites encontrados ', '2016-01-17 18:56:05'),
(2946, 'pt', 'common', 'password632', 'A sequência de senha deve ter um comprimento entre 6 e 32 ', '2016-01-17 18:56:05'),
(2947, 'pt', 'common', 'passwordnotmatch', 'As senhas não coincidem ', '2016-01-17 18:56:05'),
(2948, 'pt', 'common', 'Period', 'Período ', '2016-01-17 18:56:05'),
(2949, 'pt', 'common', 'Priority', 'Prioridade ', '2016-01-17 18:56:05'),
(2950, 'pt', 'common', 'Profile', 'Perfil ', '2016-01-17 18:56:05'),
(2951, 'pt', 'common', 'Rank', 'Classificar ', '2016-01-17 18:56:05'),
(2952, 'pt', 'common', 'Reports', 'Relatórios ', '2016-01-17 18:56:05'),
(2953, 'pt', 'common', 'Results', 'Resultados', '2016-01-17 18:56:05');
INSERT INTO `texts` (`id`, `lang_code`, `category`, `label`, `content`, `changed`) VALUES
(2954, 'pt', 'common', 'Search Engine', 'Motor de pesquisa', '2016-01-17 18:56:05'),
(2955, 'pt', 'common', 'Select', 'Seleccione ', '2016-01-17 18:56:05'),
(2956, 'pt', 'common', 'Seo Plugins', 'Seo Plugins ', '2016-01-17 18:56:05'),
(2957, 'pt', 'common', 'Seo Tools', 'Seo Tools ', '2016-01-17 18:56:05'),
(2958, 'pt', 'common', 'Sign out', 'Sair', '2016-01-17 18:56:05'),
(2959, 'pt', 'common', 'Sign Up', 'Inscreva-se', '2016-01-17 18:56:05'),
(2960, 'pt', 'common', 'signin', 'Entrar', '2016-01-17 18:56:05'),
(2961, 'pt', 'common', 'Status', 'Status ', '2016-01-17 18:56:05'),
(2962, 'pt', 'common', 'Support', 'Suporte ', '2016-01-17 18:56:05'),
(2963, 'pt', 'common', 'Total', 'Total ', '2016-01-17 18:56:05'),
(2964, 'pt', 'common', 'Url', 'Url ', '2016-01-17 18:56:05'),
(2965, 'pt', 'common', 'User', 'Utilizador', '2016-01-17 18:56:05'),
(2966, 'pt', 'common', 'User Panel', 'Painel de Utilizador', '2016-01-17 18:56:05'),
(2967, 'pt', 'common', 'Website', 'Web-site ', '2016-01-17 18:56:05'),
(2968, 'pt', 'common', 'Yes', 'Sim ', '2016-01-17 18:56:05'),
(2969, 'pt', 'website', 'Edit Website', 'Editar site ', '2016-01-17 19:19:53'),
(2970, 'pt', 'website', 'plscrtwebsite', 'Crie um site antes de começar a usar ferramentas e plugins seo. ', '2016-01-17 19:19:53'),
(2971, 'pt', 'website', 'Website already exist', 'Web-site já existe ', '2016-01-17 19:19:53'),
(2972, 'pt', 'website', 'yourwebalreday', 'seu site se você já tiver criado um. ', '2016-01-17 19:19:53'),
(2973, 'pt', 'user', 'Edit User', 'Editar Utilizador', '2016-01-17 19:20:08'),
(2974, 'pt', 'user', 'Saved My Profile Details', 'Salvar os meus detalhes do perfil ', '2016-01-17 19:20:08'),
(2975, 'pt', 'sitemap', 'Change frequency', 'Mudar a frequência ', '2010-10-27 04:57:13'),
(2976, 'pt', 'sitemap', 'clickproceedsitemap', 'Clique em <b>Continuar</b> para criar o arquivo sitemap ', '2010-10-27 04:57:13'),
(2977, 'pt', 'sitemap', 'Download sitemap file from', 'Baixar o arquivo de sitemap ', '2010-10-27 04:57:13'),
(2978, 'pt', 'sitemap', 'Exclude Url', 'Excluir Url ', '2010-10-27 04:57:13'),
(2979, 'pt', 'sitemap', 'processtaketime', 'Este processo levará tempo, de acordo com o número de links em seu site. Por favor, aguarde para obter sitemap\r\narquivos ', '2010-10-27 04:57:13'),
(2980, 'pt', 'sitemap', 'Sitemap Type', 'Tipo Sitemap ', '2010-10-27 04:57:13'),
(2981, 'pt', 'settings', 'Click here to become a sponsor for Seo Panel', '<b>Doar $100<b/> e se tornar um <b>patrocinador<b/> de Seo Panel. ', '2016-01-17 19:16:12'),
(2982, 'pt', 'settings', 'seopanel_description', 'Um painel de controle livre completo para a gestão do motor de pesquisa e optimização de seus websites. Este Seo contem muitas ferramentas de SEO para aumentar e controlar a sua performance superior do site. É um software open source e você também pode desenvolver seus próprios plugins seo para o painel seo.', '2016-01-17 19:16:12'),
(2983, 'pt', 'settings', 'seopanel_title', 'Seo Painel: É o primeiro painel de controle seo open Source do mundo para geriro seo vários sites ', '2016-01-17 19:16:12'),
(2984, 'pt', 'settings', 'SP_CRAWL_DELAY', 'Atraso entre cada spider crawl (segundos) ', '2016-01-17 19:16:12'),
(2985, 'pt', 'settings', 'SP_DEFAULTLANG', 'Idioma padrão ', '2016-01-17 19:16:12'),
(2986, 'pt', 'settings', 'SP_DESCRIPTION', 'Seo Descrição Painel ', '2016-01-17 19:16:12'),
(2987, 'pt', 'settings', 'SP_ENABLE_PROXY', 'Activar Proxy ', '2016-01-17 19:16:12'),
(2988, 'pt', 'settings', 'SP_HOTLINKING', 'Imagem de  hotlink com protecção activada', '2016-01-17 19:16:12'),
(2989, 'pt', 'settings', 'SP_KEYWORDS', 'Palavras-chave Painel Seo ', '2016-01-17 19:16:12'),
(2990, 'pt', 'settings', 'SP_PAGINGNO', 'Número de entradas por página ', '2016-01-17 19:16:12'),
(2991, 'pt', 'settings', 'SP_TITLE', 'Seo título do painel ', '2016-01-17 19:16:12'),
(2992, 'pt', 'settings', 'SP_USER_GEN_REPORT', 'Permitir ao usuário gerar relatórios ', '2016-01-17 19:16:12'),
(2993, 'pt', 'settings', 'SP_USER_REGISTRATION', 'Interface de registo de utilizador', '2016-01-17 19:16:12'),
(2994, 'pt', 'settings', 'syssettingssaved', 'As definições do sistema salvas com sucesso! ', '2016-01-17 19:16:12'),
(2995, 'pt', 'seotools', 'Automatic Submission', 'Envio automático ', '2011-07-10 09:45:40'),
(2996, 'pt', 'seotools', 'backlink-checker', 'Backlinks Checker ', '2011-07-10 09:45:40'),
(2997, 'pt', 'seotools', 'Backlinks Reports', 'Backlinks Relatórios ', '2011-07-10 09:45:40'),
(2998, 'pt', 'seotools', 'Check Submission Status', 'Verificar status da submissão ', '2011-07-10 09:45:40'),
(2999, 'pt', 'seotools', 'clickgeneratereports', 'Clique em <b>proseguir<b/> para gerar relatórios ', '2011-07-10 09:45:40'),
(3000, 'pt', 'seotools', 'Detailed Position Reports', 'Relatórios detalhados da posição ', '2011-07-10 09:45:40'),
(3001, 'pt', 'seotools', 'directory-submission', 'A submissão do directório ', '2011-07-10 09:45:40'),
(3002, 'pt', 'seotools', 'Featured Submission', 'Submissão destacada', '2011-07-10 09:45:40'),
(3003, 'pt', 'seotools', 'Generate Backlinks Reports', 'Gerar relatórios Backlinks ', '2011-07-10 09:45:40'),
(3004, 'pt', 'seotools', 'Generate Keyword Reports', 'Palavra Gerar relatórios ', '2011-07-10 09:45:40'),
(3005, 'pt', 'seotools', 'Generate Rank Reports', 'Gerar relatórios da Classificação', '2011-07-10 09:45:40'),
(3006, 'pt', 'seotools', 'Generate Saturation Reports', 'Gerar relatórios de Saturação ', '2011-07-10 09:45:40'),
(3007, 'pt', 'seotools', 'Google Sitemap Generator', 'Google Sitemap Generator ', '2011-07-10 09:45:40'),
(3008, 'pt', 'seotools', 'Graphical Position Reports', 'Posição Relatórios Gráficos ', '2011-07-10 09:45:40'),
(3009, 'pt', 'seotools', 'Keyword Position Summary', 'Palavra Resumo posição ', '2011-07-10 09:45:40'),
(3010, 'pt', 'seotools', 'keyword-position-checker', 'Verificador de palavras-chave posição ', '2011-07-10 09:45:40'),
(3011, 'pt', 'seotools', 'Keywords Manager', 'Palavras-chave Manager ', '2011-07-10 09:45:40'),
(3012, 'pt', 'seotools', 'Quick Backlinks Checker', 'Verificação rápida do Backlinks ', '2011-07-10 09:45:40'),
(3013, 'pt', 'seotools', 'Quick Position Checker', 'Verificação rápida da posição ', '2011-07-10 09:45:40'),
(3014, 'pt', 'seotools', 'Quick Rank Checker', 'Verificação rápida da Classificação', '2011-07-10 09:45:40'),
(3015, 'pt', 'seotools', 'Quick Saturation Checker', 'Verificação rápida da Saturação ', '2011-07-10 09:45:40'),
(3016, 'pt', 'seotools', 'Rank Reports', 'Relatórios da Classificação ', '2011-07-10 09:45:40'),
(3017, 'pt', 'seotools', 'rank-checker', 'Verificação da Classificação', '2011-07-10 09:45:40'),
(3018, 'pt', 'seotools', 'Saturation Reports', 'Saturação Relatórios ', '2011-07-10 09:45:40'),
(3019, 'pt', 'seotools', 'saturation-checker', 'Saturação do Motor de busca', '2011-07-10 09:45:40'),
(3020, 'pt', 'seotools', 'sitemap-generator', 'Gerar Sitemap ', '2011-07-10 09:45:40'),
(3021, 'pt', 'seotools', 'Skipped Directories', 'Directórios não introduzidos ', '2011-07-10 09:45:40'),
(3022, 'pt', 'seotools', 'Submission Reports', 'Apresentação Relatórios ', '2011-07-10 09:45:40'),
(3023, 'pt', 'seotools', 'User Access', 'Acesso do Usuário ', '2011-07-10 09:45:40'),
(3024, 'pt', 'rank', 'enterurlproceed', 'Digite um URL <b>por linha<b/>. Clique em <b>Continuar<b/> para verificar a classificação no Google e Alexa.', '2010-10-27 05:33:40'),
(3025, 'pt', 'rank', 'Google and Alexa Rank Reports', 'Relatórios de classificação em Alexa e Google', '2010-10-27 05:33:40'),
(3026, 'pt', 'rank', 'Saved rank results of', 'resultados de classificação dos salvos ', '2010-10-27 05:33:40'),
(3027, 'pt', 'saturation', 'clickproceedsaturation', 'Digite um URL <b>por linha<b/>.Clique em <b>Continuar<b/> para verificar os Relatórios da Saturação do Motor de Busca', '2010-10-27 05:39:07'),
(3028, 'pt', 'saturation', 'GenerateSaturationReports', 'Gerar Relatórios da Saturação do Motor de Busca ', '2010-10-27 05:39:07'),
(3029, 'pt', 'saturation', 'Quick Search Engine Saturation Checker', 'Pesquisa Rápida Saturação do Motor de Busca', '2010-10-27 05:39:07'),
(3030, 'pt', 'saturation', 'Saved Search Engine Saturation results of', 'guardar os resultados da Saturação do Motor de Busca', '2010-10-27 05:39:07'),
(3031, 'pt', 'saturation', 'Search Engine Saturation Reports', 'Relatórios Saturação do Motor de Busca', '2010-10-27 05:39:07'),
(3032, 'pt', 'proxy', 'Edit Proxy', 'Editar Proxy ', '2014-05-14 00:44:54'),
(3033, 'pt', 'proxy', 'Proxy Password', 'password do Proxy ', '2014-05-14 00:44:54'),
(3034, 'pt', 'proxy', 'Proxy Username', 'Nome de utilizador Proxy ', '2014-05-14 00:44:54'),
(3035, 'pt', 'proxy', 'Proxyalreadyexist', 'A Proxy já existe! ', '2014-05-14 00:44:54'),
(3036, 'pt', 'plugin', 'Edit Seo Plugin', 'Editar Seo Plugin ', '2012-06-01 19:11:02'),
(3037, 'pt', 'plugin', 'Plugin Name', 'Nome do Plugin ', '2012-06-01 19:11:02'),
(3038, 'pt', 'plugin', 'Seo Plugin Details', 'Detalhes do Plugin Seo  ', '2012-06-01 19:11:02'),
(3039, 'pt', 'directory', 'Add back to directory list', 'Adicionar de volta à lista de directórios ', '2012-11-10 20:59:13'),
(3040, 'pt', 'directory', 'Approved', 'Aprovado ', '2012-11-10 20:59:13'),
(3041, 'pt', 'directory', 'Captcha', 'Captcha ', '2012-11-10 20:59:13'),
(3042, 'pt', 'directory', 'categorynote', 'Categorias, separe-os com vírgula de acordo com a prioridade. Comece com a categoria com mais prioridade. ', '2012-11-10 20:59:13'),
(3043, 'pt', 'directory', 'Check Directory Status', 'Verificar status Directório ', '2012-11-10 20:59:13'),
(3044, 'pt', 'directory', 'Check Directory Submission Status', 'Verifique o Estado da submissão do directório ', '2012-11-10 20:59:13'),
(3045, 'pt', 'directory', 'clicktoproceeddirsts', 'Clique em <b>Continuar<b/> para verificar o status do Directório. ', '2012-11-10 20:59:13'),
(3046, 'pt', 'directory', 'Confirmation', 'Confirmação ', '2012-11-10 20:59:13'),
(3047, 'pt', 'directory', 'desnote', 'Alguns directórios requerem mínima de 150 caracteres para o campo de descrição. ', '2012-11-10 20:59:13'),
(3048, 'pt', 'directory', 'Directories with out captcha', 'Directórios sem captcha ', '2012-11-10 20:59:13'),
(3049, 'pt', 'directory', 'Directory Submission Reports', 'Relatórios de inserção no Directório ', '2012-11-10 20:59:13'),
(3050, 'pt', 'directory', 'Enter the code shown', 'Digite o código mostrado ', '2012-11-10 20:59:13'),
(3051, 'pt', 'directory', 'nocatnote', 'A categoria de inserção não foi encontrado na página de inserção. Por favor, clique em <b>Actualizar<b/> ou <b>passar<b/> ', '2012-11-10 20:59:13'),
(3052, 'pt', 'directory', 'nodirnote', 'Nenhum directório <b>activo<b/> encontrado ', '2012-11-10 20:59:13'),
(3053, 'pt', 'directory', 'nosuccessnote', 'Não recebi mensagem de sucesso, por favor, verifique seu e-mail para encontrar a mensagem de confirmação ', '2012-11-10 20:59:13'),
(3054, 'pt', 'directory', 'optionalnote', 'Opcional títulos e descrições apresentar título aleatório e descrição de directórios para melhor os resultados. ', '2012-11-10 20:59:13'),
(3055, 'pt', 'directory', 'Owner Email', 'E-mail do proprietário ', '2012-11-10 20:59:13'),
(3056, 'pt', 'directory', 'Owner Name', 'Nome do proprietário ', '2012-11-10 20:59:13'),
(3057, 'pt', 'directory', 'Pending', 'Pendente', '2012-11-10 20:59:13'),
(3058, 'pt', 'directory', 'Please select a website to proceed', 'Por favor, seleccione um site para continuar ', '2012-11-10 20:59:13'),
(3059, 'pt', 'directory', 'selectwebsiteproceed', 'Seleccione um  <b>web-site</b> para <b> Continuar </b> submissão do directório. <br> Directórios Verifique <b> com a captcha </b> para enviar aos directórios com captcha fora ', '2012-11-10 20:59:13'),
(3060, 'pt', 'directory', 'selectwebsiteschecksub', 'Seleccione um <b>web-site<b/> para <b>Continuar<b/> a verificar o directório de inserção. ', '2012-11-10 20:59:13'),
(3061, 'pt', 'directory', 'Semi Automatic Directory Submission Tool', 'Ferramenta semi-automática da submissão do Directório ', '2012-11-10 20:59:13'),
(3062, 'pt', 'directory', 'spamemailnote', 'Alguns directórios podem enviar spam, nós não recomendamos usar seu endereço de e-mail principal. ', '2012-11-10 20:59:13'),
(3063, 'pt', 'directory', 'Submission Details', 'Detalhes da apresentação ', '2012-11-10 20:59:13'),
(3064, 'pt', 'directory', 'Submit Description', 'Submeter Descrição ', '2012-11-10 20:59:13'),
(3065, 'pt', 'directory', 'Submit Keywords', 'Submeter Envie-chave ', '2012-11-10 20:59:13'),
(3066, 'pt', 'directory', 'Submit Title', 'Envie título ', '2012-11-10 20:59:13'),
(3067, 'pt', 'directory', 'Website Category', 'Website Categoria ', '2012-11-10 20:59:13'),
(3068, 'pt', 'directory', 'Website Url', 'Website URL ', '2012-11-10 20:59:13'),
(3069, 'pt', 'keyword', 'Crawling keyword', 'Procura da palavra-chave', '2016-01-17 19:11:49'),
(3070, 'pt', 'keyword', 'Detailed Keyword Position Reports', 'Relatórios detalhados da posição da palavra-chave', '2016-01-17 19:11:49'),
(3071, 'pt', 'keyword', 'Edit Keyword', 'Editar palavras-chave ', '2016-01-17 19:11:49'),
(3072, 'pt', 'keyword', 'Graphical Keyword Position Reports', 'Relatórios Gráficos da posição da palavra-chave ', '2016-01-17 19:11:49'),
(3073, 'pt', 'keyword', 'Import Keywords', 'Importar palavra-chave ', '2016-01-17 19:11:49'),
(3074, 'pt', 'keyword', 'Keyword already exist', 'Palavra-chave já existe', '2016-01-17 19:11:49'),
(3075, 'pt', 'keyword', 'Keyword Position Report', 'Relatório da posição da palavra-chave', '2016-01-17 19:11:49'),
(3076, 'pt', 'keyword', 'New Keyword', 'Nova palavra-chave ', '2016-01-17 19:11:49'),
(3077, 'pt', 'keyword', 'not assigned to required search engines', 'não atribuídos aos motores de busca necessária ', '2016-01-17 19:11:49'),
(3078, 'pt', 'keyword', 'pleaseselecttool', 'Por favor, seleccione pelo menos uma da ferramentas Seo ', '2016-01-17 19:11:49'),
(3079, 'pt', 'keyword', 'Quick Keyword Position Checker', 'Busca rápida da posição da palavra-chave ', '2016-01-17 19:11:49'),
(3080, 'pt', 'keyword', 'results from ', 'resultados de', '2016-01-17 19:11:49'),
(3081, 'pt', 'keyword', 'Show All results', 'Mostrar todos os resultados ', '2016-01-17 19:11:49'),
(3082, 'pt', 'keyword', 'Successfully crawled keyword', 'Rastreados com sucesso palavra-chave ', '2016-01-17 19:11:49'),
(3083, 'pt', 'keyword', 'to create new keywords', 'para criar novas palavras-chave ', '2016-01-17 19:11:49'),
(3084, 'pt', 'label', 'already exist', 'já existem ', '2016-01-17 19:12:15'),
(3085, 'pt', 'label', 'Authentication', 'Autenticação ', '2016-01-17 19:12:15'),
(3086, 'pt', 'label', 'Author', 'Autor ', '2016-01-17 19:12:15'),
(3087, 'pt', 'label', 'Click Here', 'Clique Aqui ', '2016-01-17 19:12:15'),
(3088, 'pt', 'label', 'Cron', 'Cron ', '2016-01-17 19:12:15'),
(3089, 'pt', 'label', 'Description', 'Descrição ', '2016-01-17 19:12:15'),
(3090, 'pt', 'label', 'Developers', 'Criadores', '2016-01-17 19:12:15'),
(3091, 'pt', 'label', 'Download', 'Download ', '2016-01-17 19:12:15'),
(3092, 'pt', 'label', 'Installation', 'Instalação ', '2016-01-17 19:12:15'),
(3093, 'pt', 'label', 'Keywords', 'Palavras-chave ', '2016-01-17 19:12:15'),
(3094, 'pt', 'label', 'noactiveplugins', 'Nenhum plugins SEO activos encontrados! ', '2016-01-17 19:12:15'),
(3095, 'pt', 'label', 'Plugin', 'Plugin ', '2016-01-17 19:12:15'),
(3096, 'pt', 'label', 'Port', 'Porto ', '2016-01-17 19:12:15'),
(3097, 'pt', 'label', 'Proxy', 'Proxy ', '2016-01-17 19:12:15'),
(3098, 'pt', 'label', 'Re-install', 'Re-instalar ', '2016-01-17 19:12:15'),
(3099, 'pt', 'label', 'Sponsors', 'Patrocinadores ', '2016-01-17 19:12:15'),
(3100, 'pt', 'label', 'Title', 'Título ', '2016-01-17 19:12:15'),
(3101, 'pt', 'label', 'translation by', 'Tradução por ', '2016-01-17 19:12:15'),
(3102, 'pt', 'label', 'Translators', 'Tradutores ', '2016-01-17 19:12:15'),
(3103, 'pt', 'label', 'Upgrade', 'Upgrade ', '2016-01-17 19:12:15'),
(3104, 'pt', 'label', 'Version', 'Versão ', '2016-01-17 19:12:15'),
(3105, 'pt', 'label', 'wantproceed', 'Você realmente deseja continuar? ', '2016-01-17 19:12:15'),
(3106, 'pt', 'login', 'Confirm Password', 'Confirme a senha ', '2016-01-17 19:13:26'),
(3107, 'pt', 'login', 'Create my account', 'Criar a minha conta ', '2016-01-17 19:13:26'),
(3108, 'pt', 'login', 'Create New Account', 'Criar uma nova conta ', '2016-01-17 19:13:26'),
(3109, 'pt', 'login', 'Email', 'E-mail ', '2016-01-17 19:13:26'),
(3110, 'pt', 'login', 'emailexist', 'E-mail já existe! ', '2016-01-17 19:13:26'),
(3111, 'pt', 'login', 'Enter the code as it is shown', 'Digite o código como é mostrado ', '2016-01-17 19:13:26'),
(3112, 'pt', 'login', 'First Name', 'Nome ', '2016-01-17 19:13:26'),
(3113, 'pt', 'login', 'Last Name', 'Sobrenome ', '2016-01-17 19:13:26'),
(3114, 'pt', 'login', 'Login', 'Login ', '2016-01-17 19:13:26'),
(3115, 'pt', 'login', 'Login incorrect', 'Login incorrecto ', '2016-01-17 19:13:26'),
(3116, 'pt', 'login', 'newaccountsuccess', 'Nova conta criada com sucesso! ', '2016-01-17 19:13:26'),
(3117, 'pt', 'login', 'Password', 'Senha ', '2016-01-17 19:13:26'),
(3118, 'pt', 'login', 'Password incorrect', 'Senha incorrecta ', '2016-01-17 19:13:26'),
(3119, 'pt', 'login', 'Register', 'Registe-se ', '2016-01-17 19:13:26'),
(3120, 'pt', 'login', 'Sign in to your account', 'Inscreva-se na sua conta ', '2016-01-17 19:13:26'),
(3121, 'pt', 'login', 'User inactive', 'Utilizador inactivo ', '2016-01-17 19:13:26'),
(3122, 'pt', 'login', 'Username', 'Nome de Utilizador', '2016-01-17 19:13:26'),
(3123, 'pt', 'login', 'usernameexist', 'Nome do Utilizador já existe! ', '2016-01-17 19:13:26'),
(3124, 'pt', 'panel', 'About Us', 'Quem Somos ', '2016-01-17 19:16:33'),
(3125, 'pt', 'panel', 'Add following command to your cron tab', 'Adicionar seguinte comando para o seu cron tab ', '2016-01-17 19:16:33'),
(3126, 'pt', 'panel', 'alsocheckfollowlink', 'também seleccione o link a seguir se precisar de mais detalhes. ', '2016-01-17 19:16:33'),
(3127, 'pt', 'panel', 'Check Directory', 'Lista de Verificação ', '2016-01-17 19:16:33'),
(3128, 'pt', 'panel', 'Cron Command', 'Comando Cron ', '2016-01-17 19:16:33'),
(3129, 'pt', 'panel', 'Directory Manager', 'Administrador de directório', '2016-01-17 19:16:33'),
(3130, 'pt', 'panel', 'Edit My Profile', 'Editar meu perfil ', '2016-01-17 19:16:33'),
(3131, 'pt', 'panel', 'My Profile', 'Meu Perfil ', '2016-01-17 19:16:33'),
(3132, 'pt', 'panel', 'New Proxy', 'Proxy novo', '2016-01-17 19:16:33'),
(3133, 'pt', 'panel', 'New User', 'Novo Utilizador', '2016-01-17 19:16:33'),
(3134, 'pt', 'panel', 'New Website', 'Novo Website ', '2016-01-17 19:16:33'),
(3135, 'pt', 'panel', 'Proxy Manager', 'Administrador de proxy', '2016-01-17 19:16:33'),
(3136, 'pt', 'panel', 'Report Generation Manager', 'Administrador de Relatórios Geração ', '2016-01-17 19:16:33'),
(3137, 'pt', 'panel', 'Reports Manager', 'administrador de Relatórios ', '2016-01-17 19:16:33'),
(3138, 'pt', 'panel', 'Seo Plugins Manager', 'administrador de Seo Plugins ', '2016-01-17 19:16:33'),
(3139, 'pt', 'panel', 'Seo Tools Manager', 'administrador de ferramentas seo', '2016-01-17 19:16:33'),
(3140, 'pt', 'panel', 'System Settings', 'Configurações do Sistema ', '2016-01-17 19:16:33'),
(3141, 'pt', 'panel', 'User Manager', 'administrador de utilizadores', '2016-01-17 19:16:33'),
(3142, 'pt', 'panel', 'Website Manager', 'administrador de website', '2016-01-17 19:16:33'),
(3143, 'pt', 'home', 'Account Summary', 'Resumo da Conta ', '2011-07-10 09:41:24'),
(3144, 'pt', 'home', 'Backlinks', 'Backlinks ', '2011-07-10 09:41:24'),
(3145, 'pt', 'home', 'Directory Submission', 'A Submissão do Directório ', '2011-07-10 09:41:24'),
(3146, 'pt', 'home', 'home_cont1', '<h1 style=\\"text-align: center;margin-bottom: 30px;font-size: 19px;\\">Bem-vindo ao Seo Painel - ao primeiro painel de controle seo para vários sites do mundo</h1>\r\n<p>\r\nUm completo <b>  Seo Panel de controle, software livre </b> para gerenciar <b> a optimização do motor de busca </b> dos seus sites.\r\nSeo Panel é um <b> kit de ferramentas </b> que inclui as mais recentes ferramentas de SEO para <b> aumentar e controlar </b>\r\n<b> performace </B> dos seus sites.\r\nÉ um software livre <b> </b> lançado em <b>  GNU LICENÇA PÚBLICA GERAL </b>.\r\nA principal característica do painel de seo é a sua extensibilidade <b> </b> usando <a href = \\"<?=SP_PLUGINSITE?>\\" target = \\"_blank\\"> seo plugins </a>.\r\nQualquer um pode facilmente <b> desenvolver e instalar </b>  plugins necessários para seu painel de seo.\r\n</P>\r\n</p>\r\n<p>\r\nEste software de código aberto foi <b> lançado em janeiro de 2010 </b>.\r\nCom <b> neste curto período </b> de tempo milhares de <b> webmasters </b> estão usando este software para optimização dos seus sites.\r\nUtilize o painel de SEO hoje  <b>e desfrute </b> tudo relacionado ao seo sob uma única <b> plataforma </b>.\r\n</P> ', '2011-07-10 09:41:24'),
(3147, 'pt', 'home', 'home_cont2', '<fieldset>\r\n<legend> Principais Características do Seo Panel <?=SP_INSTALLED?> </legend>\r\n<ul class=\\"infobox\\">\r\n<li>\r\n<h1>Ferramenta de Envio automático Diretório </h1>\r\n<p>\r\nFerramenta automática da submissão do directório para nos ajudar<b> a apresentar os nossos sites </b> nos maiores <b> , grandes\r\ne pagos directórios da Internet </b>.\r\nNós também podemos <b> acompanhar o status </b> de cada submissão através <b> de uma verificação periódica </b> usando o \r\nstatus <b> submissão de script </b>.\r\n<b> gerenciando o Directório </b> irá nos ajudar a descobrir se está ativo diretório <b> </b> ou não.\r\n</P>\r\n</Li>\r\n<li>\r\n<h1> Posição Palavra Checker </h1>\r\n<p>\r\nPalavra verificador posição encontra-se o <b> posição do motor de pesquisa </b> de <b> palavras-chave específicas </b>\r\ndo seu site e lojas <b> </b>-lo no sistema.\r\nNa seção de palavra-chave relatórios de posição, podemos ver o <b> posições diárias </b> de palavras-chave\r\ndiferentes motores de busca, <b> belos gráficos </b> e <b> relatórios detalhados </b>.\r\n</P>\r\n</Li>\r\n<li>\r\n<h1> Site Auditor </h1>\r\n<p> Site Auditor will <b>audit all SEO factors</b> of each pages of a site and will give a <b>detailed report</b> about each page.  Isso ajudará a criar <b> XML, HTML, TEXTO </b> arquivos sitemap do nosso site para apresentar aos motores de busca. </p>\r\n</Li>\r\n<li>\r\n<h1> Google e Alexa Rank Checker </h1>\r\n<p>\r\nGoogle e verificador alexa rank vai encontrar <b> google pagerank </b>e <b> alexa rank </b> da nossos<b> sites e lojas </b> no sistema.\r\nEm <b> relatórios Rank </b>, podemos ver o <b> rank diário da </b> Google e Alexa rank de cada website por <b> relatórios detalhados </b>.\r\n</P>\r\n</Li>\r\n<li>\r\n<h1> Backlinks Checker </h1>\r\n<p>\r\nverificador Backlinks encontrará <b> número de backlinks </b> dos nossos sites em busca diferentes\r\nmotores <b>(Yahoo, google, msn, etc) </b> e lojas <b> </b>-lo no sistema.\r\n<br> Em <b> relatórios backlink </b>, podemos ver os backlinks <b> contagem diária </b> de cada\r\nsite por <b> relatórios detalhados </b>.\r\n</P>\r\n</Li>\r\n<li>\r\n<h1> Saturação Search Engine Checker </h1>\r\n<p>\r\nSearch Engine verificador Saturação encontrará <b> número de páginas indexadas </b> dos nossos sites em diferentes<b> motores de busca (google, yahoo, MSN etc) </b> e lojas <b> </b>-lo no sistema.\r\nEm <b> motor de busca de saturação verificador relatórios </b>, podemos ver a página <b> diários indexados\r\nContagem </b> de cada site por <b> relatórios detalhados </b>.\r\n</P>\r\n</Li>\r\n<li>\r\n<h1>Seo plugins </h1>\r\n<p>\r\nA característica principal <b> </b> do painel de controle é o seu seo extentability <b> </b>.\r\nAdicionar seo <b> plugins </b> ao seu painel de seo para <b> estender os recursos </b> De acordo com o seu\r\nexigência.\r\n<A href = \\"<?=SP_PLUGINSITE?>\\" Target = \\"_blank\\"> Painel Seo plugins </a> são fornecidos por ambas painel seo\r\ne terceiro locais do partido.\r\nVocê também pode facilmente desenvolver <b> </b> plugins de SEO para seu painel de seo.\r\nVocê pode <a href = \\"<?=SP_PLUGINSITE?>\\" Target = \\"_blank\\"> apresentar </a> o seu plugin para seo seo painel e\r\nvamos publicar <b> </B> em nosso site depois da nossa <revisão <b> processo </b>.\r\n</P>\r\n</Li>\r\n<li>\r\n<h1> Meta Tag Generator </h1>\r\n<p>\r\nMeta tag é um gerador de painel seo <b> plugin </b> para criar <b> personalizado meta tags </b> para o nosso\r\nsite.\r\nIsso nos ajudará a dar mais informações <b> </b> sobre o nosso site para <b> motor de busca robôs </b>\r\nenquanto que rastejam nosso site.\r\n</P>\r\n</Li>\r\n</Ul>\r\n</Fieldset> ', '2011-07-10 09:41:24'),
(3148, 'pt', 'home', 'home_cont3', '<fieldset>\r\n<legend> Recursos on-line do Seo Panel </legend>\r\n<ul class=\\"infobox\\">\r\n\r\n<li>\r\n<h1> Recursos Online de Referência do SEO Panel  </h1>\r\n\r\n\r\n<p>\r\n<a href=\\"http://www.seopanel.in\\" target=\\"_blank\\"> Site Oficial do Seo Panel </a>\r\n</P>\r\n<p>\r\n<A href = \\"<?=SP_DOWNLOAD_LINK?>\\" Target = \\"_blank\\"> Download Seo Panel </a>\r\n</P>\r\n\r\n<p>\r\n<A href = \\"<?=SP_DEMO_LINK?>\\" Target = \\"_blank\\"> Seo Panel Demo </a>\r\n</P>\r\n\r\n<p>\r\n<A href = \\"<?=SP_CONTACT_LINK?>\\" Target = \\"_blank\\"> contactar Seo Panel </a>\r\n</P>\r\n\r\n<p>\r\n<A href = \\"<?=SP_HELP_LINK?>\\" Target = \\"_blank\\"> Guia de Ajuda do Seo Panel  </a>\r\n</P>\r\n\r\n<p>\r\n<A href = \\"<?=SP_FORUM_LINK?>\\" Target = \\"_blank\\"> Fórum do Seo Panel </a></P>\r\n\r\n<p>\r\n<A href = \\"<?=SP_SUPPORT_LINK?>\\" Target = \\"_blank\\"> Seo panel sistema de suporte </a>\r\n</P>\r\n\r\n<p>\r\n<A href = \\"<?=SP_DONATE_LINK?>\\" Target = \\"_blank\\"> Doar para Seo Panel </a>\r\n</P>\r\n</Li>\r\n\r\n</Ul>\r\n</Fieldset> ', '2011-07-10 09:41:24'),
(3149, 'pt', 'home', 'Pages Indexed', 'Páginas cadastradas ', '2011-07-10 09:41:24'),
(3150, 'pt', 'home', 'Ranks', 'Posições ', '2011-07-10 09:41:24'),
(3151, 'pt', 'home', 'SiteNameUrl', 'Nome do URL do site / ', '2011-07-10 09:41:24'),
(3152, 'pt', 'home', 'Website Statistics', 'Estatísticas do site ', '2011-07-10 09:41:24'),
(3153, 'ro', 'directory', 'Add back to directory list', 'Adauga la sfarsitul listei de directoare', '2012-05-18 20:52:34'),
(3154, 'ro', 'directory', 'Approved', 'Aprobat', '2012-05-18 20:52:34'),
(3155, 'ro', 'directory', 'Captcha', 'Captcha', '2012-05-18 20:52:34'),
(3156, 'ro', 'directory', 'categorynote', 'Categoriile, separatile prin virgula in functie de prioritate. Incepeti cu categoria de top prioritara.', '2012-05-18 20:52:34'),
(3157, 'ro', 'directory', 'Check Directory Status', 'Verificati Statusul Directorului', '2012-05-18 20:52:34'),
(3158, 'ro', 'directory', 'Check Directory Submission Status', 'Verificati Statusul Directorului Inscris', '2012-05-18 20:52:34'),
(3159, 'ro', 'directory', 'clicktoproceeddirsts', 'Apasa pe <b>Continua</b> pentru a verifica statusul directorului.', '2012-05-18 20:52:34'),
(3160, 'ro', 'directory', 'Confirmation', 'Confirmare', '2012-05-18 20:52:34'),
(3161, 'ro', 'directory', 'desnote', 'Unele directoare au nevoie de minim 150 caractere pentru campul descriere.', '2012-05-18 20:52:34'),
(3162, 'ro', 'directory', 'Directories with out captcha', 'Directoare fara captcha', '2012-05-18 20:52:34'),
(3163, 'ro', 'directory', 'Directory Submission Reports', 'Rapoarte Directoare Inscrise', '2012-05-18 20:52:34'),
(3164, 'ro', 'directory', 'Enter the code shown', 'Introduceti codul din imagine', '2012-05-18 20:52:34'),
(3165, 'ro', 'directory', 'nocatnote', 'Categoria inscrisa nu a fost gasita in pagina trimise. Va rugam apasati pe <b>Reincarca</b> sau <b>Sari peste</b>', '2012-05-18 20:52:34'),
(3166, 'ro', 'directory', 'nodirnote', 'Nu s-a gasit niciun director <b>Activ</b> ', '2012-05-18 20:52:34'),
(3167, 'ro', 'directory', 'nosuccessnote', 'Nu ati primit mesajul de confirmare, va rugam verificati-va e-mailul pentru a gasi mesajul de confirmare.', '2012-05-18 20:52:34'),
(3168, 'ro', 'directory', 'optionalnote', 'Titluri si descrieri optionale sunt trimise aleator la directoare pentru un rezultat mai bun.', '2012-05-18 20:52:34'),
(3169, 'ro', 'directory', 'Owner Email', 'E-mail detinator', '2012-05-18 20:52:34'),
(3170, 'ro', 'directory', 'Owner Name', 'Nume detinator', '2012-05-18 20:52:34'),
(3171, 'ro', 'directory', 'Pending', 'In asteptare', '2012-05-18 20:52:34'),
(3172, 'ro', 'directory', 'Please select a website to proceed', 'Va rugam selectati un site web pentru a Continua', '2012-05-18 20:52:34'),
(3173, 'ro', 'directory', 'selectwebsiteproceed', 'Selectati un <b>Site Web<b/> pentru a <b>Continua</b> inscrierea in directoare. <br> Verifica <b>Directoarele fara captcha</b> pentru a inscrie in directoarele fara captcha', '2012-05-18 20:52:34'),
(3174, 'ro', 'directory', 'selectwebsiteschecksub', 'Selectati un <b>Director</b> pentru a <b>Continua</b> verificarea directoarelor inscrise.', '2012-05-18 20:52:34'),
(3175, 'ro', 'directory', 'Semi Automatic Directory Submission Tool', 'Unealta de inscriere Directoare Semi Automata', '2012-05-18 20:52:34'),
(3176, 'ro', 'directory', 'spamemailnote', 'Unele directoare pot trimite spam, nu recomandam sa folositi adresa dvs. de e-mail primara.', '2012-05-18 20:52:34'),
(3177, 'ro', 'directory', 'Submission Details', 'Detalii Inscriere', '2012-05-18 20:52:34'),
(3178, 'ro', 'directory', 'Submit Description', 'Descriere Inscriere', '2012-05-18 20:52:34'),
(3179, 'ro', 'directory', 'Submit Keywords', 'Inscriere cuvinte cheie', '2012-05-18 20:52:34'),
(3180, 'ro', 'directory', 'Submit Title', 'Inscriere Titlu', '2012-05-18 20:52:34'),
(3181, 'ro', 'directory', 'Website Category', 'Categorie Site Web', '2012-05-18 20:52:34'),
(3182, 'ro', 'directory', 'Website Url', 'Url site web', '2012-05-18 20:52:34'),
(3183, 'zh', 'support', 'support_cont1', '<fieldset> \r\n<legend>Seo Panel 帮助系统</legend> \r\n<ul class=\\"infobox\\"> \r\n    <li> \r\n        <h1>1000 目录包</h1>  \r\n        <p> \r\n            我们提供<b>超过1000个可用的</b>网络目录包,加到\r\n你的seo panel <b>目录提交工具</b>. \r\n            它会帮助你<b>增加反向链接</b>你的站点. \r\n            在我们获得捐赠后为seo panel<b>以为未来发展</b>,您将获得<b>推荐</b>的1000目录列表，. \r\n            想要获得1000目录列表请<a href=\\"<?=SP_DONATE_LINK?>\\" target=\\"_blank\\">捐赠</a>\r\n$10 或者更多 来改善 seo panel 的功能 . \r\n            如果你有任何问题关于1000目录包,请<a href=\\"<?=SP_CONTACT_LINK?>\\"\r\ntarget=\\"_blank\\">联系我们</a>或者打开一个页面 <a href=\\"<?=SP_SUPPORT_LINK?>\\"\r\ntarget=\\"_blank\\">帮助系统</a>.    \r\n        </p>         \r\n        <p> \r\n            <a href=\\"<?=SP_DONATE_LINK?>\\" target=\\"_blank\\">访问这个链接捐赠seo panel</a> \r\n        </p> \r\n        <br> \r\n    </li> \r\n     \r\n    <li> \r\n        <h1>本地搜索引擎包</h1>  \r\n        <p> \r\n            增加<b>本地 搜索引擎 域</b>google,yahoo,msn(<b>例如: www.google.de,www.google.fr\r\netc</b>) seo panel <b>关键字position checker</b>, 追踪你的站点行为本地. \r\n            为了获得本地搜索引擎包(根据你的需求) 请<a\r\nhref=\\"<?=SP_DONATE_LINK?>\\" target=\\"_blank\\">捐赠</a> $10或者更多来改善功能seo\r\npanel. \r\n            捐赠之前, 请 <a href=\\"<?=SP_CONTACT_LINK?>\\" target=\\"_blank\\">联系我们</a> to\r\n提供给我们需要的搜索引擎域名列表. \r\n            <br><br>               \r\n             增加<b>新的搜索引擎(例如:baidu.com)</b>你的 seo panel关键字position checker,\r\n请 <a href=\\"<?=SP_CONTACT_LINK?>\\" target=\\"_blank\\">联系我们</a>或者打开一个页面在<a\r\nhref=\\"<?=SP_SUPPORT_LINK?>\\" target=\\"_blank\\">帮助系统</a>.  \r\n        </p>         \r\n        <p class=\\"visit\\"> \r\n            <a href=\\"<?=SP_CONTACT_LINK?>\\" target=\\"_blank\\">访问这个链接联系我们</a> \r\n        </p> \r\n        <br> \r\n    </li> \r\n     \r\n    <li> \r\n        <h1>Seo Panel插件</h1>  \r\n        <p> \r\n            增加<b>seo插件</b> 你的seo panel <b>扩展功能</b>根据你的\r\n需求. \r\n            <a href=\\"<?=SP_PLUGINSITE?>\\" target=\\"_blank\\">Seo panel插件</a>由seo panel\r\n和第三方站点提供. \r\n            你可以 easily <b>develop</b> seo插件来你的seo panel. \r\n            你可以<a href=\\"<?=SP_PLUGINSITE?>\\" target=\\"_blank\\">提交</a>你的seo plugin seo panel 并且\r\n我们会<b>发布</b>到我们的站点在<b>审查</b>之后.         \r\n        </p>         \r\n        <p> \r\n            <a href=\\"<?=SP_PLUGINSITE?>\\" target=\\"_blank\\">访问这个链接为了获得seo panel插件</a> \r\n        </p> \r\n        <br> \r\n    </li>     \r\n    <li> \r\n        <h1>联系我们</h1>  \r\n        <p> \r\n            联系我们来 任何问题 关于 <b>seo panel 工具,插件和功能等等</b> 通过以下链接.         \r\n        </p>         \r\n        <p> \r\n            <a href=\\"<?=SP_CONTACT_LINK?>\\" target=\\"_blank\\">访问这个链接 联系我们</a> \r\n        </p> \r\n        <br> \r\n    </li>     \r\n    <li> \r\n        <h1>技术支持</h1>  \r\n        <p> \r\n            为了获得 <b>技术支持</b>从seo panel团队设置<b>seo panel工具,插件和\r\n功能</b>. 例如: 设置cron来关键字位置checker. \r\n        </p>         \r\n        <p> \r\n            <a href=\\"<?=SP_SUPPORT_LINK?>\\" target=\\"_blank\\">访问这个链接创建一个支持ticket</a> \r\n        </p> \r\n        <br> \r\n    </li>     \r\n    <li> \r\n        <h1>报告Bugs</h1>  \r\n        <p> \r\n            报告<b>bugs</b> 关于 <b>seo panel 工具,插件和功能等等</b> 通过以下链接.  \r\n            请 帮助我们在下个版本来改善功能.           \r\n        </p>         \r\n        <p> \r\n            <a href=\\"<?=SP_SUPPORT_LINK?>\\" target=\\"_blank\\">访问这个链接 报告bugs</a> \r\n        </p> \r\n        <br> \r\n    </li>     \r\n</ul> \r\n</fieldset>', '2011-05-04 08:56:00'),
(3184, 'zh', 'support', 'support_cont2', '<fieldset> \r\n<legend>Seo Panel 在线资源</legend> \r\n<ul class=\\"infobox\\"> \r\n         \r\n    <li> \r\n        <h1>Seo Panel 帮助向导</h1>  \r\n        <p> \r\n            你可以看 <a href=\\"<?=SP_HELP_LINK?>\\" target=\\"_blank\\">seo panel文档</a>在 \r\n<b>帮助向导</b>, 它包括<b>文档</b>来  seo panel 工具,插件和相关的\r\n功能. \r\n            <br>这是在因特网获得关于seo panel帮助的<b>最好的地方</b>.如果你发现错误或者缺少东西,我们希望你seo panel 帮助向导<b>报告</b>.                 \r\n        </p> \r\n        <p> \r\n            <a href=\\"<?=SP_HELP_LINK?>\\" target=\\"_blank\\">访问seo panel 帮助向导</a> \r\n        </p> \r\n        <br> \r\n    </li>     \r\n    <li> \r\n        <h1>Seo Panel论坛</h1>  \r\n        <p> \r\n            一个地方讨论关于世界上第一款开源的<b>seo control panel</b>.  \r\n            这是最好的地方找到<b>答案</b> <b>你的问题</b> 关于 seo panel.  \r\n            <br> 你可以<b>分享</b>你的<b>经验</b> 在使用seo panel来操作你的\r\n站点.                                \r\n        </p>         \r\n        <p> \r\n            <a href=\\"<?=SP_FORUM_LINK?>\\" target=\\"_blank\\">访问seo panel论坛</a> \r\n        </p> \r\n        <br> \r\n    </li> \r\n</ul>     \r\n</fieldset>', '2011-05-04 08:56:00'),
(3185, 'zh', 'support', 'support_cont3', '<fieldset> \r\n<legend>捐赠 Seo Panel</legend> \r\n<ul class=\\"infobox\\">         \r\n    <li> \r\n        <h1>捐赠 Seo Panel - 世界上第一款开源的seo control panel</h1>  \r\n        <p> \r\n            <b>捐赠</b> seo panel支持第一款开源的seo control panel世界上. \r\n            我们计划<b>增加和提高</b> 功能 seo panel 的在未来.  \r\n            <br>有了你的<b>支持</b>我们才能达到我们的<b>目标</b>. \r\n            如果你觉得seo panel是<b>值得</b>你拥有, 请捐赠支持seo panel 团队. \r\n            <br>我们<b>会公布</b> 你的名字和站点信息在<a href=\\"<?=SP_DONATE_LINK?>\\"\r\ntarget=\\"_blank\\">捐赠页面</a>, 一旦我们获得捐赠. \r\n        </p> \r\n        <p> \r\n            <a href=\\"<?=SP_DONATE_LINK?>\\" target=\\"_blank\\">访问这个链接捐赠 seo panel</a> \r\n        </p> \r\n        <br> \r\n    </li> \r\n</ul> \r\n</fieldset>', '2011-05-04 08:56:00'),
(3186, 'ro', 'keyword', 'Crawling keyword', 'Cuvant cheie Crawling', '2012-05-18 20:57:55'),
(3187, 'ro', 'keyword', 'Detailed Keyword Position Reports', 'Raport detaliat pozitionare cuvinte cheie', '2012-05-18 20:57:55'),
(3188, 'ro', 'keyword', 'Edit Keyword', 'Editeaza cuvant cheie', '2012-05-18 20:57:55'),
(3189, 'ro', 'keyword', 'Graphical Keyword Position Reports', 'Raport grafic pozitionare cuvant cheie', '2012-05-18 20:57:55'),
(3190, 'ro', 'keyword', 'Import Keywords', 'Importa cuvant cheie', '2012-05-18 20:57:55'),
(3191, 'ro', 'keyword', 'Keyword already exist', 'Cuvantul cheie deja exista', '2012-05-18 20:57:55'),
(3192, 'ro', 'keyword', 'Keyword Position Report', 'Raport pozitionare cavant cheie', '2012-05-18 20:57:55'),
(3193, 'ro', 'keyword', 'New Keyword', 'Cuvant cheie nou', '2012-05-18 20:57:55'),
(3194, 'ro', 'keyword', 'not assigned to required search engines', 'neasignat la motoarele de cautare necesare', '2012-05-18 20:57:55'),
(3195, 'ro', 'keyword', 'pleaseselecttool', 'Va rugam selectati cel putin o unealta Seo', '2012-05-18 20:57:55'),
(3196, 'ro', 'keyword', 'Quick Keyword Position Checker', 'Verificare rapida pozitie cuvant cheie', '2012-05-18 20:57:55'),
(3197, 'ro', 'keyword', 'results from ', 'Rezultate din', '2012-05-18 20:57:55'),
(3198, 'ro', 'keyword', 'Show All results', 'Arata toate rezultatele', '2012-05-18 20:57:55'),
(3199, 'ro', 'keyword', 'Successfully crawled keyword', 'Cuvint cheie crawled cu succes', '2012-05-18 20:57:55'),
(3200, 'ro', 'keyword', 'to create new keywords', 'pentru a crea cuvinte cheie noi', '2012-05-18 20:57:55'),
(3201, 'ro', 'home', 'Account Summary', 'Sumar cont', '2012-05-18 20:57:04'),
(3202, 'ro', 'home', 'Backlinks', 'Backlinks', '2012-05-18 20:57:04'),
(3203, 'ro', 'home', 'Directory Submission', 'Inscriere directoare', '2012-05-18 20:57:04'),
(3204, 'ro', 'home', 'home_cont1', '<h1 style=\\"text-align: center;margin-bottom: 30px;font-size: 19px;\\">Bine ati venit la Seo Panel - Primul panou de control Seo din lume pentru mai multe site-uri web</h1> \r\n        <p> \r\n            Un panou de control seo <b>complet open source</b> pentru managementul <b>optimizarii motoarelor de cautare</b> pentru site-urile dvs..  \r\n            Seo Panel este <b>un kit de unelte seo</b> ce include ultimile unelete seo de pe piata pentru a <b>creste si verifica</b> \r\n<b>performantele</b> site-ului dvs.. \r\n            Este un <b>software gratis</b> lansat sub <b>GNU GENERAL PUBLIC LICENSE</b>. \r\n            Principalul atu al panoului ce control Seo este <b>expandabilitatea</b> prin utilizarea <a href=\\"<?=SP_PLUGINSITE?>\\"\r\ntarget=\\"_blank\\">plugin-urilor seo</a>. \r\n            Oricine poate foarte usor sa <b>dezvolte si sa instaleze</b> plugin-ul necesar nevoilor sale.  \r\n        </p> \r\n        <p></p> \r\n        <p> \r\n            Acest software open source a fost <b>lansat in Ianuarie 2010</b>. \r\n            Cu toate acestea si intr-o <b>periada scurta</b> de timp <b>mii</b> de <b>web masters</b> folosesc acest software\r\npentru <b>optimizarea</b> site-urilor lor. \r\n            Utilizati panoul de control chiar azi si <b>bucurativa</b> de tot ce tine de seo sub o  <b>singura platforma</b>. \r\n        </p>', '2012-05-18 20:57:04'),
(3205, 'ro', 'home', 'home_cont2', '<fieldset> \r\n<legend>Noutati majore ale Panoului de control Seo <?=SP_INSTALLED?></legend> \r\n<ul class=\\"infobox\\"> \r\n    <li>         \r\n        <h1>Unealta de inregistrare automata in directoare</h1> \r\n        <p> \r\n            Unealta de inregistrare automata in directoare ne ajuta sa  <b>inregistram site-urile noastre</b> in majoritatea <b>directoarelor gratis sau cu plata</b>. \r\n            Putem deasemenea sa <b>urmarim statusul</b> fiecarei inregistrari prin <b>verificare periodica</b> utilizand scriptul <b>verificare status</b>. \r\n            <b>Managerul directoare</b> ne va ajuta sa gasim daca <b>un director este activ sau</b> nu. \r\n        </p> \r\n    </li> \r\n    <li>         \r\n        <h1>Verificator pozitionare cuvant cheie</h1> \r\n        <p> \r\n            Verificatorul de cuvinte cheie va gasi  <b>pozitia in motoarele de cautare</b> pentru <b>cuvintele cheie alese</b>\r\npentru site-ul dvs. si le <b>salveaza</b> in sistem. \r\n            In sectiunea pozitionarii cuvintelor cheie, putem vedea <b>pozitionarea zilnica</b> a cuvintelor cheie in diferite motaore de cautare\r\nprin <b>grafice frumoase</b> si <b>rapoarte detaliate</b>. \r\n        </p> \r\n    </li> \r\n    <li>        \r\n        <h1>Evaluator Site</h1>\r\n        <p>Evaluator site va <b>evalua toti factori SEO</b> al fiecarei pagini dintr-un site si va da\r\n<b>raport detaliat</b> inlegatura cu fiecare pagina. Aceasta ne va ajuta sa creem fisiere sitemap <b>XML,HTML,TEXT</b> ale site-urilor noastre pentru a le trimite <b>submit</b> motoarelor de cautare.</p>\r\n    </li> \r\n    <li>         \r\n        <h1>Verificator rank Google si Alexa</h1> \r\n        <p> \r\n           Verificatorul Google si Alexa rank va gasi <b>google pagerank</b> si <b>alexa rank</b> al site-urilor noastre pe care le <b>salveaza</b> in sistem. \r\n            In sectiunea <b>rapoarte rank</b> , putem vedea <b>zilnic</b> google si alexa rank pentru fiecare site prin <b>rapoarte detaliate</b>. \r\n        </p> \r\n    </li> \r\n    <li>         \r\n        <h1>Verificator backlink-uri</h1> \r\n        <p> \r\n            Verifiatorul de backlink-uri va gasi un <b>numar de backlink-uri</b> al site-urilor noastre in diferite motoare de cautare\r\n<b>(google,yahoo,msn etc)</b> si le <b>salveaza</b> in sistem. \r\n            <br>In sectiunea <b>rapoartelor de backlink-uri</b>, putem vedea <b>numarul zilnic de backlink-uri</b> pentru fiecare site web prin <b>rapoarte detaliate</b>. \r\n        </p> \r\n    </li>     \r\n    <li>         \r\n        <h1>Verificator saturatie motoare de cautare</h1> \r\n        <p> \r\n            Verificatorul de saturatie al motoarelor de cutare va gasi <b>numarul paginilor indexate</b> al site-urilor dvs. in diferite motoare de cautare\r\n<b>(google,yahoo,msn etc)</b> si le va <b>salva</b> in sistemm. \r\n            In sectiunea <b>rapoarte verificatoar saturatie motoare de cautare</b> putem vedea <b>numarul paginilor indexate zilnic</b> pentru fiecare site web prin  <b>rapoarte detaliate</b>. \r\n        </p> \r\n    </li> \r\n    <li>         \r\n        <h1>Plugin-uri Panou de control Seo</h1> \r\n        <p> \r\n            Principala <b>caracteristica majora</b> a panoului de control seo este <b>expandabilitatea</b>. \r\n            Adauga <b>pluginuri seo</b> la panoul de control seo pentru a <b>extinde carcteristicile</b> dupa necesitatile dvs.. \r\n            <a href=\\"<?=SP_PLUGINSITE?>\\" target=\\"_blank\\">Plugin-urile panoului de control seo</a> Sunt dezvoltate atat de catre echipa seo Panel cat si de site-uri colaboratoare. \r\n            Puteti deasemenea foarte usor sa <b>dezvoltati</b> plugin-uri seo pentru panoul de control Seo al dvs.. \r\n            Puteti <a href=\\"<?=SP_PLUGINSITE?>\\" target=\\"_blank\\">trimite</a> pluginul dvs. la seo panel si noi il vom\r\n <b>publica</b> pe site-ul oficial dupa ce va trece printr-un proces de <b>verificare</b>. \r\n        </p> \r\n    </li> \r\n    <li>         \r\n        <h1>generator meta tagu-ri</h1> \r\n        <p> \r\n            Generatorul de meta tag-uri este <b>un plugin pentru</b> crearea<b> de mata tag-uri la comanda(custom)</b> pentru site-ul nostru. \r\n            Ne va ajuta sa dam <b>mai multe informatii</b> despre siteul nostru la <b>bots ale motoarelor de cautare</b>\r\nin timp ce ne urmaresc site-ul. \r\n        </p> \r\n    </li> \r\n</ul> \r\n</fieldset>', '2012-05-18 20:57:04'),
(3206, 'ro', 'home', 'home_cont3', '<fieldset> \r\n<legend>resusre online ale Panoului de control Seo</legend>     \r\n<ul class=\\"infobox\\"> \r\n\r\n    <li> \r\n        <h1>resurse ale panoului de control pentru  Reference</h1>                 \r\n         \r\n         \r\n        <p> \r\n            <a href=\\"http://www.seopanel.in\\" target=\\"_blank\\">Seo Panel Site oficial</a> \r\n        </p> \r\n        <p> \r\n            <a href=\\"<?=SP_DOWNLOAD_LINK?>\\" target=\\"_blank\\">Download Seo Panel</a> \r\n        </p> \r\n         \r\n        <p> \r\n            <a href=\\"<?=SP_DEMO_LINK?>\\" target=\\"_blank\\">Seo Panel Demo</a> \r\n        </p> \r\n         \r\n        <p> \r\n            <a href=\\"<?=SP_CONTACT_LINK?>\\" target=\\"_blank\\">Conatcteaza Seo Panel</a> \r\n        </p> \r\n         \r\n        <p> \r\n            <a href=\\"<?=SP_HELP_LINK?>\\" target=\\"_blank\\">Seo Panel Ghid ajutor</a> \r\n        </p> \r\n         \r\n        <p> \r\n            <a href=\\"<?=SP_FORUM_LINK?>\\" target=\\"_blank\\">Seo Panel Forum</a> \r\n        </p> \r\n         \r\n        <p> \r\n            <a href=\\"<?=SP_SUPPORT_LINK?>\\" target=\\"_blank\\">Seo Panel Suport de sitem</a> \r\n        </p> \r\n         \r\n        <p> \r\n            <a href=\\"<?=SP_DONATE_LINK?>\\" target=\\"_blank\\">Donati pentru Seo Panel</a> \r\n        </p> \r\n    </li> \r\n     \r\n</ul> \r\n</fieldset>', '2012-05-18 20:57:04'),
(3207, 'ro', 'home', 'Pages Indexed', 'Pagini Indexate', '2012-05-18 20:57:04'),
(3208, 'ro', 'home', 'Ranks', 'Ranks', '2012-05-18 20:57:04'),
(3209, 'ro', 'home', 'SiteNameUrl', 'Nume Site/Url', '2012-05-18 20:57:04'),
(3210, 'ro', 'home', 'Website Statistics', 'Statistici Site Web', '2012-05-18 20:57:04');
INSERT INTO `texts` (`id`, `lang_code`, `category`, `label`, `content`, `changed`) VALUES
(3211, 'ro', 'support', 'support_cont1', '<fieldset> \r\n<legend>Centrul de suport Seo Panel</legend> \r\n<ul class=\\"infobox\\"> \r\n    <li> \r\n        <h1>Pachet 1000 de directoare</h1>  \r\n        <p> \r\n            Va oferim <b>1000 de directoare active si pe deasupra gratis</b> un pachet pe care il puteti adauga in panoul SEO la\r\n <b>sectiunea inregistrare in directoare</b>. \r\n            Va vom ajuta sa <b>va cresteti backlink-urile</b> site-ului dvs. \r\n            Deocamdata lista cu 1000 de directoare <b>mai sus mentionata</b> este pentru colectarea de fonduri <b>pentru desvoltarea viitoare a</b> Seo Panel. \r\n            Pentru a lua lista cu 1000 de directoare va rugam <a href=\\"<?=SP_DONATE_LINK?>\\" target=\\"_blank\\">donati</a>\r\n$10 sau mai mult pentru a imbunatati caracteristicile pachetului Seo Panel. \r\n            Daca aveti intrebari asupra pachetului de 1000 de directoare, va rugam <a href=\\"<?=SP_CONTACT_LINK?>\\"\r\ntarget=\\"_blank\\">contactati-ne</a> sau deschideti un tiket la <a href=\\"<?=SP_SUPPORT_LINK?>\\"\r\ntarget=\\"_blank\\">centrul de suport</a>.    \r\n        </p>         \r\n        <p> \r\n            <a href=\\"<?=SP_DONATE_LINK?>\\" target=\\"_blank\\">Vizitati acest link pentru a dona pentru Seo Panel</a> \r\n        </p> \r\n        <br> \r\n    </li> \r\n     \r\n    <li> \r\n        <h1>Pachet motoare de cautare locale</h1>  \r\n        <p> \r\n            Adauga <b>domenii de motoare de cautare locale</b> pentru google,yahoo,msn(<b>eg: www.google.de,www.google.fr, www.google.ro\r\netc</b>) in panoul de control Seo <b>Verificare pozitie cuvinte cheie</b>, pentru a va urmari site-ul personal local. \r\n            Pentru a beneficia de pachetul motarelor de cautare local(in functie de nevoile dvs.) va rugam <a\r\nhref=\\"<?=SP_DONATE_LINK?>\\" target=\\"_blank\\">donati</a> $10 sau mai mult pentru a imbunatati caracteristicile pachetului Seo Panel. \r\n           Inainte de a trimite donatii va rugam, <a href=\\"<?=SP_CONTACT_LINK?>\\" target=\\"_blank\\">contactati-ne</a> pentru a ne da detalii despre motaorele de cautare locale ale dvs.. \r\n            <br><br>               \r\n            Deasemenea pentru a adauga <b>noi motoare de cautare(eg:baidu.com)</b> la verificare pozitionare cuvinte cheie al Panoului Seo al dvs.,\r\nva rugam <a href=\\"<?=SP_CONTACT_LINK?>\\" target=\\"_blank\\">contactati-ne</a> sau deschideti un tiket la <a\r\nhref=\\"<?=SP_SUPPORT_LINK?>\\" target=\\"_blank\\">centru de suport</a>.  \r\n        </p>         \r\n        <p class=\\"visit\\"> \r\n            <a href=\\"<?=SP_CONTACT_LINK?>\\" target=\\"_blank\\">Vizitati acest link pentru a ne contacta</a> \r\n        </p> \r\n        <br> \r\n    </li> \r\n     \r\n    <li> \r\n        <h1>Plugin-uri Seo Panel</h1>  \r\n        <p> \r\n            Adauga <b>plugin-uri Seo</b> in panoul de control Seo al dvs. <b>extindeti caracteristicile</b> in functie de necesitatile dvs.. \r\n            <a href=\\"<?=SP_PLUGINSITE?>\\" target=\\"_blank\\">Plugin-uri Seo Panel</a> sunt dezvoltate atat de Seo Panel cat si de alte site-uri afiliate. \r\n            Puteti deasemenea foarte usor <b>sa dezvoltati</b> plugin-uri seo pentru panoul de control al dvs.\r\n            Puteti <a href=\\"<?=SP_PLUGINSITE?>\\" target=\\"_blank\\">uploada</a> plugin-urile dvs in panoul de contro Seo si\r\nnoi le vom <b>publica</b> pe site-ul nostru dupa ce le vom  <b>verifica</b>.         \r\n        </p>         \r\n        <p> \r\n            <a href=\\"<?=SP_PLUGINSITE?>\\" target=\\"_blank\\">Vizitati acest link pentru a descarca plugin-uri Seo Panel</a> \r\n        </p> \r\n        <br> \r\n    </li>     \r\n    <li> \r\n        <h1>Contactati-ne</h1>  \r\n        <p> \r\n            Contactati-ne pentru orice intrebare despre <b>unelte seo panel,plugin-uri si caracteristici etc</b> utilizind link-ul de mai jos.         \r\n        </p>         \r\n        <p> \r\n            <a href=\\"<?=SP_CONTACT_LINK?>\\" target=\\"_blank\\">Vizitati acest link pentru a ne contacta</a> \r\n        </p> \r\n        <br> \r\n    </li>     \r\n    <li> \r\n        <h1>Suport Tickete</h1>  \r\n        <p> \r\n            Pentru a avea <b>suport tehnict</b> din partea echipei Seo Panel pentru a seta <b>uneltele Seo panel, plugin-urile si facilitati\r\n</b>. Ex: Pentru a seta un cron pentru verificare pozitionare cuvinte cheie. \r\n        </p>         \r\n        <p> \r\n            <a href=\\"<?=SP_SUPPORT_LINK?>\\" target=\\"_blank\\">Vizitati acest link pentru a creea un tiket de suport nou</a> \r\n        </p> \r\n        <br> \r\n    </li>     \r\n    <li> \r\n        <h1>Raportai bug-uri</h1>  \r\n        <p> \r\n            rapoortati <b>bug-uri</b> despre<b>unelte seo panel,plugin-uri si caracteristici etc</b> utilizand link-ul de mai jos.  \r\n            va rugam ajutati-ne sa imbunatatim facilitatile din noile versiuni.           \r\n        </p>         \r\n        <p> \r\n            <a href=\\"<?=SP_SUPPORT_LINK?>\\" target=\\"_blank\\">Vizitati acest link pentru raporta un bug nou </a> \r\n        </p> \r\n        <br> \r\n    </li>     \r\n</ul> \r\n</fieldset>', '2010-11-05 19:42:48'),
(3212, 'ro', 'support', 'support_cont2', '<fieldset> \r\n<legend>Panoul Seo resurse Online</legend> \r\n<ul class=\\"infobox\\"> \r\n         \r\n    <li> \r\n        <h1>Ghid ajutor Panoul Seo</h1>  \r\n        <p> \r\n            Puteti vedea <a href=\\"<?=SP_HELP_LINK?>\\" target=\\"_blank\\">documentatia panoului Seo</a> in\r\n<b>Ghidul de ajutor</b>, contine <b>documentatia</b> pentru uneltele panoului seo ,plugin-uri si caracteristici . \r\n            <br>Este cel mai bun loc de pe internet pentru a <b>primi ajutor</b> despre panoul Seo. Speram ca tu vei\r\n<b>contribui</b> la ghidul de ajutor al panoului Seo, daca gasiti erori sau ceva lipsuri.                 \r\n        </p> \r\n        <p> \r\n            <a href=\\"<?=SP_HELP_LINK?>\\" target=\\"_blank\\">Vizitati ghidul de ajutor al panoului Seo</a> \r\n        </p> \r\n        <br> \r\n    </li>     \r\n    <li> \r\n        <h1>Forum Seo Panel</h1>  \r\n        <p> \r\n            Un loc pentru discutii despre primul opensource <b>panou de control Seo</b>.  \r\n            Este cel mai bun loc pentru a gasi <b>raspunsuri</b> la <b>intrebarile tale</b> despre panoul Seo.  \r\n            <br>Deasemenea poti <b>imparti</b> <b>experienta</b> ta in timp de utilizezi panoul seo pentru site-urile tale.                                \r\n        </p>         \r\n        <p> \r\n            <a href=\\"<?=SP_FORUM_LINK?>\\" target=\\"_blank\\">Vizitati forumul panoului Seo</a> \r\n        </p> \r\n        <br> \r\n    </li> \r\n</ul>     \r\n</fieldset>', '2010-11-05 19:42:48'),
(3213, 'ro', 'support', 'support_cont3', '<fieldset> \r\n<legend>Donati panoului Seo</legend> \r\n<ul class=\\"infobox\\">         \r\n    <li> \r\n        <h1>Donati panoului seo - Primul Open Source panou de control Seo din lume</h1>  \r\n        <p> \r\n            <b>Donati</b> panoului Seo pentru sustinerea primului panou seo din lume. \r\n            Planuim sa  <b>adaugam si imbunatatim</b> caracteristici ale panoului seo pe viitor.  \r\n            <br>Cu ajutorul <b>suportului</b> dvs. ne putem atinge  <b>telul</b>. \r\n            Daca crezi ca panoul de control seo  <b>conteaza</b> pentru tine, va rugam donati cat vreti echipei Seo Panel. \r\n            <br>Va vom <b>publica</b> numele si informatii despre site-ul dvs in <a href=\\"<?=SP_DONATE_LINK?>\\"\r\ntarget=\\"_blank\\">pagina de donatii</a>, de indata ce primim donatia. \r\n        </p> \r\n        <p> \r\n            <a href=\\"<?=SP_DONATE_LINK?>\\" target=\\"_blank\\">Vizitati acest link pentru a dona Panoului Seo</a> \r\n        </p> \r\n        <br> \r\n    </li> \r\n</ul> \r\n</fieldset>', '2010-11-05 19:42:48'),
(3214, 'ro', 'settings', 'Click here to become a sponsor for Seo Panel', '<b>Donati $100</b> si deveniti <b>sponsor</b> al Seo Panel.', '2012-05-18 21:16:44'),
(3215, 'ro', 'settings', 'seopanel_description', 'Un panou de control complet gratis pentru a controla optimizarea site-urilor dvs. Contine o ultime de unelte noi pentru a creste si verifica performantele site-ului dvs. Este un software open source si deasemenea va puteti dezvolta singuri plugin-urile pentru panoul seo al dvs.', '2012-05-18 21:16:44'),
(3216, 'ro', 'settings', 'seopanel_title', 'Panoul Seo: Primul open source panou de control Seo din lume pentru managemenetul mai multor site-uri web.', '2012-05-18 21:16:44'),
(3217, 'ro', 'settings', 'SP_CRAWL_DELAY', 'Intarziere intre fiecare spider crawl (secunde)', '2012-05-18 21:16:44'),
(3218, 'ro', 'settings', 'SP_DEFAULTLANG', 'Limba de baza', '2012-05-18 21:16:44'),
(3219, 'ro', 'settings', 'SP_DESCRIPTION', 'Descriere Panou de control Seo', '2012-05-18 21:16:44'),
(3220, 'ro', 'settings', 'SP_ENABLE_PROXY', 'Activare Proxy', '2012-05-18 21:16:44'),
(3221, 'ro', 'settings', 'SP_HOTLINKING', 'Imagine protectie hotlink activata', '2012-05-18 21:16:44'),
(3222, 'ro', 'settings', 'SP_KEYWORDS', 'Cuvinte cheie panoul de control Seo', '2012-05-18 21:16:44'),
(3223, 'ro', 'settings', 'SP_PAGINGNO', 'Numar de intrari per pagina', '2012-05-18 21:16:44'),
(3224, 'ro', 'settings', 'SP_TITLE', 'Titlu panou de control seo', '2012-05-18 21:16:44'),
(3225, 'ro', 'settings', 'SP_USER_GEN_REPORT', 'Lasa utilizatorii sa genereze rapoarte', '2012-05-18 21:16:44'),
(3226, 'ro', 'settings', 'SP_USER_REGISTRATION', 'Interfata inregistrare utilizator', '2012-05-18 21:16:44'),
(3227, 'ro', 'settings', 'syssettingssaved', 'Setarea sistemului salvata cu succes!', '2012-05-18 21:16:44'),
(3228, 'ro', 'seotools', 'Automatic Submission', 'Inregistrare automata', '2011-07-13 02:03:17'),
(3229, 'ro', 'seotools', 'backlink-checker', 'Verificator backlink-uri', '2011-07-13 02:03:17'),
(3230, 'ro', 'seotools', 'Backlinks Reports', 'Rapoarte backlink-uri', '2011-07-13 02:03:17'),
(3231, 'ro', 'seotools', 'Check Submission Status', 'Verifica status inregistrari', '2011-07-13 02:03:17'),
(3232, 'ro', 'seotools', 'clickgeneratereports', 'Apasa pe <b>Continua</b> pentru a genera rapoarte', '2011-07-13 02:03:17'),
(3233, 'ro', 'seotools', 'Detailed Position Reports', 'Rapoarte pozitionare detaliate', '2011-07-13 02:03:17'),
(3234, 'ro', 'seotools', 'directory-submission', 'Inregistrare directoare', '2011-07-13 02:03:17'),
(3235, 'ro', 'seotools', 'Featured Submission', 'Inregistrare viitoare', '2011-07-13 02:03:17'),
(3236, 'ro', 'seotools', 'Generate Backlinks Reports', 'Genereaza rapoarte backlink-uri', '2011-07-13 02:03:17'),
(3237, 'ro', 'seotools', 'Generate Keyword Reports', 'Genereaza rapoarte cuvinte cheie', '2011-07-13 02:03:17'),
(3238, 'ro', 'seotools', 'Generate Rank Reports', 'Genereaza rapoarte de rank', '2011-07-13 02:03:17'),
(3239, 'ro', 'seotools', 'Generate Saturation Reports', 'Genereaza rapoarte de saturatie', '2011-07-13 02:03:17'),
(3240, 'ro', 'seotools', 'Google Sitemap Generator', 'Generator Google Sitemap', '2011-07-13 02:03:17'),
(3241, 'ro', 'seotools', 'Graphical Position Reports', 'Rapoarte pozitionale grafica', '2011-07-13 02:03:17'),
(3242, 'ro', 'seotools', 'Keyword Position Summary', 'Sumar pozitionare cuvinte cheie', '2011-07-13 02:03:17'),
(3243, 'ro', 'seotools', 'keyword-position-checker', 'Verificator pozitionare cuvinte cheie', '2011-07-13 02:03:17'),
(3244, 'ro', 'seotools', 'Keywords Manager', 'Manager cuvinte cheie', '2011-07-13 02:03:17'),
(3245, 'ro', 'seotools', 'Quick Backlinks Checker', 'Verificator rapid backlink-uri', '2011-07-13 02:03:17'),
(3246, 'ro', 'seotools', 'Quick Position Checker', 'Verificator rapid pozitionare', '2011-07-13 02:03:17'),
(3247, 'ro', 'seotools', 'Quick Rank Checker', 'Verificator rapid rank', '2011-07-13 02:03:17'),
(3248, 'ro', 'seotools', 'Quick Saturation Checker', 'Verificator rapid saturatie', '2011-07-13 02:03:17'),
(3249, 'ro', 'seotools', 'Rank Reports', 'Rapoarte Rank', '2011-07-13 02:03:17'),
(3250, 'ro', 'seotools', 'rank-checker', 'Verificator Rank', '2011-07-13 02:03:17'),
(3251, 'ro', 'seotools', 'Saturation Reports', 'Rapoarte Saturatie', '2011-07-13 02:03:17'),
(3252, 'ro', 'seotools', 'saturation-checker', 'Saturatie motoare de cautare', '2011-07-13 02:03:17'),
(3253, 'ro', 'seotools', 'sitemap-generator', 'Generator Sitemap', '2011-07-13 02:03:17'),
(3254, 'ro', 'seotools', 'Skipped Directories', 'Directoare neinscrise', '2011-07-13 02:03:17'),
(3255, 'ro', 'seotools', 'Submission Reports', 'Rapoarte inregistrare', '2011-07-13 02:03:17'),
(3256, 'ro', 'seotools', 'User Access', 'Acces utilizator', '2011-07-13 02:03:17'),
(3257, 'ro', 'saturation', 'clickproceedsaturation', 'Introduceti URL-urile <b>cate unul pe rand</b>. Apasa pe <b>Continua</b> pentru a verifica rezultatele saturatiei motoarelor de cautare', '2010-11-02 08:44:38'),
(3258, 'ro', 'saturation', 'GenerateSaturationReports', 'Genereaza rapoarte saturatie motoare de cautare', '2010-11-02 08:44:38'),
(3259, 'ro', 'saturation', 'Quick Search Engine Saturation Checker', 'Verificator rapid saturatie motoare de cautare', '2010-11-02 08:44:38'),
(3260, 'ro', 'saturation', 'Saved Search Engine Saturation results of', 'Saturatie motoare de cautare salvate rezultat din', '2010-11-02 08:44:38'),
(3261, 'ro', 'saturation', 'Search Engine Saturation Reports', 'rapoarte saturatie motoare de cuatare', '2010-11-02 08:44:38'),
(3262, 'ro', 'login', 'Confirm Password', 'Confirmare parola', '2012-05-18 21:02:44'),
(3263, 'ro', 'login', 'Create my account', 'Creaza contul', '2012-05-18 21:02:44'),
(3264, 'ro', 'login', 'Create New Account', 'Creaza cont nou', '2012-05-18 21:02:44'),
(3265, 'ro', 'login', 'Email', 'E-mail', '2012-05-18 21:02:44'),
(3266, 'ro', 'login', 'emailexist', 'Adresa de e-mail exista in baza de date!', '2012-05-18 21:02:44'),
(3267, 'ro', 'login', 'Enter the code as it is shown', 'Introduceti codul dupa cum este aratat', '2012-05-18 21:02:44'),
(3268, 'ro', 'login', 'First Name', 'Nume', '2012-05-18 21:02:44'),
(3269, 'ro', 'login', 'Last Name', 'Prenume', '2012-05-18 21:02:44'),
(3270, 'ro', 'login', 'Login', 'Autentificare', '2012-05-18 21:02:44'),
(3271, 'ro', 'login', 'Login incorrect', 'Autentificare incorecta', '2012-05-18 21:02:44'),
(3272, 'ro', 'login', 'newaccountsuccess', 'Cont nou creat cu succes!', '2012-05-18 21:02:44'),
(3273, 'ro', 'login', 'Password', 'Parola', '2012-05-18 21:02:44'),
(3274, 'ro', 'login', 'Password incorrect', 'Parola incorecta', '2012-05-18 21:02:44'),
(3275, 'ro', 'login', 'Register', 'Inregistrare', '2012-05-18 21:02:44'),
(3276, 'ro', 'login', 'Sign in to your account', 'Autentificare in contul dvs.', '2012-05-18 21:02:44'),
(3277, 'ro', 'login', 'User inactive', 'Utilizator inactiv', '2012-05-18 21:02:44'),
(3278, 'ro', 'login', 'Username', 'Nume utilizator', '2012-05-18 21:02:44'),
(3279, 'ro', 'login', 'usernameexist', 'Nume utilizator deja existenta', '2012-05-18 21:02:44'),
(3280, 'ro', 'label', 'already exist', 'deje exista', '2012-05-18 21:00:22'),
(3281, 'ro', 'label', 'Authentication', 'Autentificare', '2012-05-18 21:00:22'),
(3282, 'ro', 'label', 'Author', 'Autor', '2012-05-18 21:00:22'),
(3283, 'ro', 'label', 'Click Here', 'Apasa aici', '2012-05-18 21:00:22'),
(3284, 'ro', 'label', 'Cron', 'Cron', '2012-05-18 21:00:22'),
(3285, 'ro', 'label', 'Description', 'Descriere', '2012-05-18 21:00:22'),
(3286, 'ro', 'label', 'Developers', 'Dezvoltatori', '2012-05-18 21:00:22'),
(3287, 'ro', 'label', 'Download', 'Download', '2012-05-18 21:00:22'),
(3288, 'ro', 'label', 'Installation', 'Instalare', '2012-05-18 21:00:22'),
(3289, 'ro', 'label', 'Keywords', 'Cuvinte cheie', '2012-05-18 21:00:22'),
(3290, 'ro', 'label', 'noactiveplugins', 'Niciun plugin seo gasit!', '2012-05-18 21:00:22'),
(3291, 'ro', 'label', 'Plugin', 'Plugin', '2012-05-18 21:00:22'),
(3292, 'ro', 'label', 'Port', 'Port', '2012-05-18 21:00:22'),
(3293, 'ro', 'label', 'Proxy', 'Proxy', '2012-05-18 21:00:22'),
(3294, 'ro', 'label', 'Re-install', 'Re-instaleaza', '2012-05-18 21:00:22'),
(3295, 'ro', 'label', 'Sponsors', 'Sponsori', '2012-05-18 21:00:22'),
(3296, 'ro', 'label', 'Title', 'Titlu', '2012-05-18 21:00:22'),
(3297, 'ro', 'label', 'translation by', 'Tradus de', '2012-05-18 21:00:22'),
(3298, 'ro', 'label', 'Translators', 'Traducatori', '2012-05-18 21:00:22'),
(3299, 'ro', 'label', 'Upgrade', 'Upgrade', '2012-05-18 21:00:22'),
(3300, 'ro', 'label', 'Version', 'Versiune', '2012-05-18 21:00:22'),
(3301, 'ro', 'label', 'wantproceed', 'Chiar vrei sa continui?', '2012-05-18 21:00:22'),
(3302, 'hu', 'support', 'support_cont1', '<fieldset>\r\n<legend>Seo Panel Támogatói Rendszer</legend>\r\n<ul class=\\"infobox\\">\r\n    <li>\r\n        <h1>1000 darabos katalóguscsomag</h1> \r\n        <p>\r\n           Biztosítunk egy <b>1000 darabos ingyenes</b> katalóguscsomagot, melyekbe automatikusan tudja weboldalait beküldeni a <b>linkbeküldő eszközzel</b>.\r\n            Ezzel könnyedén növelheti oldalainak backlink számát <b>oldalainak backlink számát</b>.\r\n            A katalógusok megszerzéséhez kérlek <a href=\\"<?=SP_DONATE_LINK?>\\" target=\\"_blank\\">támogasd</a> minimum\r\n$10-al a Seo Panel fejlesztését.\r\n            Ha kérdésed van a csomaggal kapcsolatban kérlek lépj <a href=\\"<?=SP_CONTACT_LINK?>\\"\r\ntarget=\\"_blank\\">kapcsolatba velünk</a>, vagy kérjen egy jegyet az <a href=\\"<?=SP_SUPPORT_LINK?>\\"\r\ntarget=\\"_blank\\">ügyfélszolgálattól</a>.   \r\n        </p>        \r\n        <p>\r\n            <a href=\\"<?=SP_DONATE_LINK?>\\" target=\\"_blank\\">A Seo panel támogatáshoz látogassa meg ezt a linket.</a>\r\n        </p>\r\n        <br>\r\n    </li>\r\n    \r\n    <li>\r\n        <h1>Helyi keresőmotor csomag</h1> \r\n        <p>\r\n            Adjon <b>helyi keresést</b> a google-hoz,yahoo-hoz,msn-hez(például: <b>www.google.de,www.google.fr,www.google.hu\r\nstb..</b>). Így a <b>kulcsszóhelyezés vizsgálóval</b> a lokalizált eredményeket tudja megtekinteni. \r\n            A helyi keresőcsomag megszerzéséhez <a\r\nhref=\\"<?=SP_DONATE_LINK?>\\" target=\\"_blank\\">támogatnia</a> kell minimum $10-al a Seo Panelt.\r\n            Mielőtt elküldené a támogatást, kérem lépjen <a href=\\"<?=SP_CONTACT_LINK?>\\" target=\\"_blank\\">velünk kapcsolatba</a>, és küldje el nekünk az Ön által kívánt keresőmotor domain kiterjesztését(pl.: .hu, .fr stb..).\r\n            <br><br>              \r\n           Új <b>keresőmotor</b>(pl.:baidu.com) hozzáadásához,\r\nkérem lépjen <a href=\\"<?=SP_CONTACT_LINK?>\\"\r\ntarget=\\"_blank\\">kapcsolatba velünk</a>, vagy kérjen egy jegyet az <a href=\\"<?=SP_SUPPORT_LINK?>\\"\r\ntarget=\\"_blank\\">ügyfélszolgálattól</a>.  \r\n        </p>        \r\n        <p class=\\"visit\\">\r\n            <a href=\\"<?=SP_CONTACT_LINK?>\\" target=\\"_blank\\">Látogassa meg ezt a linket, hogy kapcsolatba léphessen velünk.</a>\r\n        </p>\r\n        <br>\r\n    </li>\r\n    \r\n    <li>\r\n        <h1>Seo Panel Kiegészítők</h1> \r\n        <p>\r\n            Adjon hozzá különböző <b>kiegészítőket</b> Seo paneljéhez, hogy <b>bővíthesse a funkcióit</b>.\r\n            <a href=\\"<?=SP_PLUGINSITE?>\\" target=\\"_blank\\">Seo panel kiegészítőket</a> a Seo panel hivatalos oldala mellett egyéb oldalakon is találhat.\r\n             Könnyedén <b>fejleszthet</b> Ön is Seo Kiegészítőket a Seo Panelhez.\r\n            Az ön által fejlesztett kiegészítőket <a href=\\"<?=SP_PLUGINSITE?>\\" target=\\"_blank\\">beküldheti</a> a Seo Panel oldalára ahol egy rövid áttekintés után <b>megjelenik</b> a többi kiegészítő között.       \r\n        </p>        \r\n        <p>\r\n            <a href=\\"<?=SP_PLUGINSITE?>\\" target=\\"_blank\\">Kiegészítők letöltéséhez látogassa meg ezt az oldalt.</a>\r\n        </p>\r\n        <br>\r\n    </li>    \r\n    <li>\r\n        <h1>Kapcsolat</h1> \r\n        <p>\r\n            Ha bármilyen kérdése van(<b>kiegészítők, fejlesztés, stb..</b>), akkor az alábbi linken lépjen velünk kapcsolatba.        \r\n        </p>        \r\n        <p>\r\n            <a href=\\"<?=SP_CONTACT_LINK?>\\" target=\\"_blank\\">Látogassa meg ezt az oldalt a kapcsolatfelvételhez.</a>\r\n        </p>\r\n        <br>\r\n    </li>    \r\n    <li>\r\n        <h1>Ügyfélszolgálati jegy</h1> \r\n        <p>\r\n          A Seo panel csapat <b>Technikai támogatásért</b>(kiegészítők telepítése, cron beállítása) lépjen kapcsolatba az ügyfélszolgálattal.\r\n        </p>        \r\n        <p>\r\n            <a href=\\"<?=SP_SUPPORT_LINK?>\\" target=\\"_blank\\">Látogassa meg ezt a linket, hogy kapcsolatba léphessen az ügyfélszolgálattal.</a>\r\n        </p>\r\n        <br>\r\n    </li>    \r\n    <li>\r\n        <h1>Hibák bejelentése</h1> \r\n        <p>\r\n            <b>Hibák</b> bejelentéséhez használja az alábbi linket. Ezzel nagymértékben hozzájárul a program fejlesztéséhez. \r\n                     \r\n        </p>        \r\n        <p>\r\n            <a href=\\"<?=SP_SUPPORT_LINK?>\\" target=\\"_blank\\">Hibabejelentéshez kérem látogassa meg az alábbi oldalt.</a>\r\n        </p>\r\n        <br>\r\n    </li>    \r\n</ul>\r\n</fieldset>', '2010-11-06 02:21:42'),
(3303, 'hu', 'support', 'support_cont2', '<fieldset>\r\n<legend>Seo Panel Online Források</legend>\r\n<ul class=\\"infobox\\">\r\n        \r\n    <li>\r\n        <h1>Seo Panel Útmutató</h1> \r\n        <p>\r\n            A <a href=\\"<?=SP_HELP_LINK?>\\" target=\\"_blank\\">Seo panel-hez tartozó dokumentációt</a> az\r\n<b>útmutatóban</b> találja, amely tartalmaz minden olyan információt amely segít a Seo panel használatában.\r\n            <br>Ez a legjobb hely az interneten, hogy <b>segítséget kapj</b> a Seo panellel kapcsolatban. Reméljük, hogy az esetleges elírásokat, hiányosságokat segít nekünk pótolni.               \r\n        </p>\r\n        <p>\r\n            <a href=\\"<?=SP_HELP_LINK?>\\" target=\\"_blank\\">Seo Panel útmutató megtekintése.</a>\r\n        </p>\r\n        <br>\r\n    </li>    \r\n    <li>\r\n        <h1>Seo Panel Fórum</h1> \r\n        <p>\r\n            Ez az a hely ahol szabadon megoszthatja <b>tapasztalatait</b> a <b>Seo panel</b>-el kapcsolatban. \r\n            Válaszokat találhat a megoldhatatlannak tűnő <b>kérdéseire</b>, továbbá <b>tapasztalatait</b> is megoszthatja másokkal. \r\n                             \r\n        </p>        \r\n        <p>\r\n            <a href=\\"<?=SP_FORUM_LINK?>\\" target=\\"_blank\\">Seo panel fórumának megtekintése</a>\r\n        </p>\r\n        <br>\r\n    </li>\r\n</ul>    \r\n</fieldset>', '2010-11-06 02:21:42'),
(3304, 'hu', 'support', 'support_cont3', '<fieldset>\r\n<legend>Seo panel támogatása</legend>\r\n<ul class=\\"infobox\\">        \r\n    <li>\r\n        <h1>Támogassa a Seo panelt - amely a világ első nyílt forráskódú Seo segédje.</h1> \r\n        <p>\r\n            <b>Támogassa</b> a Seo panelt - amely a világ első nyílt forráskódú Seo segédje.\r\n            Tervezzük, hogy a jövőben folyamatosan új <b>funkciókat</b> adunk a Seo panelhez, de ehhez az Ön segítségére is szükség van.\r\n           \r\n            Ha úgy érzed, hogy a Seo panel <b>hasznos</b> számodra, akkor kérlek támogasd a fejlesztők csapatát.\r\n            Miután támogattál minket, nevedet és oldalad linkjét <br><b>közzé</b> tesszük a <a href=\\"<?=SP_DONATE_LINK?>\\"\r\ntarget=\\"_blank\\">támogatói oldalon</a>.\r\n        </p>\r\n        <p>\r\n            <a href=\\"<?=SP_DONATE_LINK?>\\" target=\\"_blank\\">A seo panel támogatásához látogassa meg ezt az oldalt.</a>\r\n        </p>\r\n        <br>\r\n    </li>\r\n</ul>\r\n</fieldset>', '2010-11-06 02:21:42'),
(3305, 'bg', 'website', 'Edit Website', 'Редакция', '2016-12-18 17:19:36'),
(3306, 'bg', 'website', 'plscrtwebsite', 'Моля, добавете интернет сайт, преди да използвате SEO инструментите и SEO модулите.', '2016-12-18 17:19:36'),
(3307, 'bg', 'website', 'Website already exist', 'Сайтът вече съществува', '2016-12-18 17:19:36'),
(3308, 'bg', 'website', 'yourwebalreday', 'вашия сайт, ако вече сте създали такъв.', '2016-12-18 17:19:36'),
(3309, 'bg', 'sitemap', 'Change frequency', 'Честота на обхождане', '2011-07-13 01:14:40'),
(3310, 'bg', 'sitemap', 'clickproceedsitemap', 'Кликнете на <b>Продължи</b> за да създадете файл с карата на сайта ', '2011-07-13 01:14:41'),
(3311, 'bg', 'sitemap', 'Download sitemap file from', 'Изтегли карта на сайта от', '2011-07-13 01:14:41'),
(3312, 'bg', 'sitemap', 'Exclude Url', 'Изключи Url', '2011-07-13 01:14:41'),
(3313, 'bg', 'sitemap', 'processtaketime', 'Продължителността на процеса зависи от броя линкове в сайта Ви. Моля, изчакайте за да изтеглите картата на сайта ', '2011-07-13 01:14:41'),
(3314, 'bg', 'sitemap', 'Sitemap Type', 'Тип на картата', '2011-07-13 01:14:41'),
(3315, 'bg', 'label', 'already exist', 'вече съществува', '2016-12-18 17:06:39'),
(3316, 'bg', 'label', 'Authentication', 'Проверка', '2016-12-18 17:06:39'),
(3317, 'bg', 'label', 'Author', 'Автор', '2016-12-18 17:06:39'),
(3318, 'bg', 'label', 'Click Here', 'Кликнете тук', '2016-12-18 17:06:39'),
(3319, 'bg', 'label', 'Cron', 'Cron', '2016-12-18 17:06:39'),
(3320, 'bg', 'label', 'Description', 'Описание', '2016-12-18 17:06:39'),
(3321, 'bg', 'label', 'Developers', 'Разработчици', '2016-12-18 17:06:39'),
(3322, 'bg', 'label', 'Download', 'Изтегли', '2016-12-18 17:06:39'),
(3323, 'bg', 'label', 'Installation', 'Инсталация', '2016-12-18 17:06:39'),
(3324, 'bg', 'label', 'Keywords', 'Ключови думи', '2016-12-18 17:06:39'),
(3325, 'bg', 'label', 'noactiveplugins', 'Не са намерени активни SEO модули!', '2016-12-18 17:06:39'),
(3326, 'bg', 'label', 'Plugin', 'Модул', '2016-12-18 17:06:39'),
(3327, 'bg', 'label', 'Port', 'Порт', '2016-12-18 17:06:39'),
(3328, 'bg', 'label', 'Proxy', 'Прокси', '2016-12-18 17:06:39'),
(3329, 'bg', 'label', 'Re-install', 'Пре-инсталация', '2016-12-18 17:06:39'),
(3330, 'bg', 'label', 'Sponsors', 'Спонсори', '2016-12-18 17:06:39'),
(3331, 'bg', 'label', 'Title', 'Заглавие', '2016-12-18 17:06:39'),
(3332, 'bg', 'label', 'translation by', 'превод от', '2016-12-18 17:06:39'),
(3333, 'bg', 'label', 'Translators', 'Преводачи', '2016-12-18 17:06:39'),
(3334, 'bg', 'label', 'Upgrade', 'Обнови', '2016-12-18 17:06:39'),
(3335, 'bg', 'label', 'Version', 'Версия', '2016-12-18 17:06:39'),
(3336, 'bg', 'label', 'wantproceed', 'Наистина ли желаете да продължите?', '2016-12-18 17:06:39'),
(3337, 'bg', 'keyword', 'Crawling keyword', 'Обиране на ключова дума', '2016-12-18 17:06:16'),
(3338, 'bg', 'keyword', 'Detailed Keyword Position Reports', 'Детайлни доклади за позиция по ключова дума', '2016-12-18 17:06:16'),
(3339, 'bg', 'keyword', 'Edit Keyword', 'Редакция на ключова дума', '2016-12-18 17:06:16'),
(3340, 'bg', 'keyword', 'Graphical Keyword Position Reports', 'Графични доклади за позиция по ключова дума', '2016-12-18 17:06:16'),
(3341, 'bg', 'keyword', 'Import Keywords', 'Импортиране на ключови думи', '2016-12-18 17:06:16'),
(3342, 'bg', 'keyword', 'Keyword already exist', 'Ключовата дума вече съществува', '2016-12-18 17:06:16'),
(3343, 'bg', 'keyword', 'Keyword Position Report', 'Доклад за позиция по ключова дума', '2016-12-18 17:06:16'),
(3344, 'bg', 'keyword', 'New Keyword', 'Нова ключова дума', '2016-12-18 17:06:16'),
(3345, 'bg', 'keyword', 'not assigned to required search engines', 'не са избрани задължителните търсачки', '2016-12-18 17:06:16'),
(3346, 'bg', 'keyword', 'pleaseselecttool', 'Моля, изберете поне един SEO инструмент', '2016-12-18 17:06:16'),
(3347, 'bg', 'keyword', 'Quick Keyword Position Checker', 'Бърза проверка на позиция', '2016-12-18 17:06:16'),
(3348, 'bg', 'keyword', 'results from ', 'резултати от', '2016-12-18 17:06:16'),
(3349, 'bg', 'keyword', 'Show All results', 'Показване на всички резултати', '2016-12-18 17:06:16'),
(3350, 'bg', 'keyword', 'Successfully crawled keyword', 'Успешно обрана ключова дума', '2016-12-18 17:06:16'),
(3351, 'bg', 'keyword', 'to create new keywords', 'за да добавите нова ключова дума', '2016-12-18 17:06:16'),
(3352, 'bg', 'rank', 'enterurlproceed', 'Въведете <b>по един</b> URL адрес на ред. Кликнете на <b>Продължи</b> за да проверите ранга в Google и Alexa.', '2010-11-14 19:34:40'),
(3353, 'bg', 'rank', 'Google and Alexa Rank Reports', 'Доклади за ранга в Google и Alexa', '2010-11-14 19:34:40'),
(3354, 'bg', 'rank', 'Saved rank results of', 'Запазени ранг резултати за', '2010-11-14 19:34:40'),
(3355, 'bg', 'proxy', 'Edit Proxy', 'Редакция', '2016-12-18 17:08:18'),
(3356, 'bg', 'proxy', 'Proxy Password', 'Прокси парола', '2016-12-18 17:08:18'),
(3357, 'bg', 'proxy', 'Proxy Username', 'Прокси потребител', '2016-12-18 17:08:18'),
(3358, 'bg', 'proxy', 'Proxyalreadyexist', 'Вече съществува такова прокси!', '2016-12-18 17:08:18'),
(3359, 'bg', 'plugin', 'Edit Seo Plugin', 'Редакция', '2012-05-28 18:53:11'),
(3360, 'bg', 'plugin', 'Plugin Name', 'Име на модула', '2012-05-28 18:53:11'),
(3361, 'bg', 'plugin', 'Seo Plugin Details', 'Детайли на SEO модула', '2012-05-28 18:53:11'),
(3362, 'bg', 'login', 'Confirm Password', 'Потвърди парола', '2016-12-18 17:07:02'),
(3363, 'bg', 'login', 'Create my account', 'Създай профил', '2016-12-18 17:07:02'),
(3364, 'bg', 'login', 'Create New Account', 'Създаване на нов профил', '2016-12-18 17:07:02'),
(3365, 'bg', 'login', 'Email', 'Имейл', '2016-12-18 17:07:02'),
(3366, 'bg', 'login', 'emailexist', 'Имейлът вече съществува', '2016-12-18 17:07:02'),
(3367, 'bg', 'login', 'Enter the code as it is shown', 'Въведете кода от картинката', '2016-12-18 17:07:02'),
(3368, 'bg', 'login', 'First Name', 'Име', '2016-12-18 17:07:02'),
(3369, 'bg', 'login', 'Last Name', 'Фамилия', '2016-12-18 17:07:02'),
(3370, 'bg', 'login', 'Login', 'Вход', '2016-12-18 17:07:02'),
(3371, 'bg', 'login', 'Login incorrect', 'Грешен вход', '2016-12-18 17:07:02'),
(3372, 'bg', 'login', 'newaccountsuccess', 'Новият акаунт е създаден успешно!', '2016-12-18 17:07:02'),
(3373, 'bg', 'login', 'Password', 'Парола', '2016-12-18 17:07:02'),
(3374, 'bg', 'login', 'Password incorrect', 'Грешна парола', '2016-12-18 17:07:02'),
(3375, 'bg', 'login', 'Register', 'Регистрация', '2016-12-18 17:07:02'),
(3376, 'bg', 'login', 'Sign in to your account', 'Влез в профила си', '2016-12-18 17:07:02'),
(3377, 'bg', 'login', 'User inactive', 'Потребителят е неактивен', '2016-12-18 17:07:02'),
(3378, 'bg', 'login', 'Username', 'Потребителко име', '2016-12-18 17:07:02'),
(3379, 'bg', 'login', 'usernameexist', 'Потребителското име вече съществува!', '2016-12-18 17:07:02'),
(3380, 'bg', 'panel', 'About Us', 'За нас', '2016-12-18 17:07:48'),
(3381, 'bg', 'panel', 'Add following command to your cron tab', 'Въведете следната команда в вашият cron таб', '2016-12-18 17:07:48'),
(3382, 'bg', 'panel', 'alsocheckfollowlink', 'Проверете и следният линк ако имате нужда от повече детайли.', '2016-12-18 17:07:48'),
(3383, 'bg', 'panel', 'Check Directory', 'Проверка на директория', '2016-12-18 17:07:48'),
(3384, 'bg', 'panel', 'Cron Command', 'Cron Команда', '2016-12-18 17:07:48'),
(3385, 'bg', 'panel', 'Directory Manager', 'Управление на директории', '2016-12-18 17:07:48'),
(3386, 'bg', 'panel', 'Edit My Profile', 'Редакция', '2016-12-18 17:07:48'),
(3387, 'bg', 'panel', 'My Profile', 'Моят профил', '2016-12-18 17:07:48'),
(3388, 'bg', 'panel', 'New Proxy', 'Ново прокси', '2016-12-18 17:07:48'),
(3389, 'bg', 'panel', 'New User', 'Нов потребител', '2016-12-18 17:07:48'),
(3390, 'bg', 'panel', 'New Website', 'Добавяне на уеб сайт', '2016-12-18 17:07:48'),
(3391, 'bg', 'panel', 'Proxy Manager', 'Управление на прокси', '2016-12-18 17:07:48'),
(3392, 'bg', 'panel', 'Report Generation Manager', 'Генериране на доклади', '2016-12-18 17:07:48'),
(3393, 'bg', 'panel', 'Reports Manager', 'Управление на доклади', '2016-12-18 17:07:48'),
(3394, 'bg', 'panel', 'Seo Plugins Manager', 'Управление на SEO модули', '2016-12-18 17:07:48'),
(3395, 'bg', 'panel', 'Seo Tools Manager', 'Управление на SEO инструменти', '2016-12-18 17:07:48'),
(3396, 'bg', 'panel', 'System Settings', 'Системни настройки', '2016-12-18 17:07:48'),
(3397, 'bg', 'panel', 'User Manager', 'Управление на потребители', '2016-12-18 17:07:48'),
(3398, 'bg', 'panel', 'Website Manager', 'Управление на сайтове', '2016-12-18 17:07:48'),
(3399, 'bg', 'settings', 'Click here to become a sponsor for Seo Panel', '<b>Дарете 100 $</b> и станете <b>спонсор</b> на Seo Panel.', '2016-12-18 17:09:40'),
(3400, 'bg', 'settings', 'seopanel_description', 'Напълно безплатен контролен панел, за управление на оптимизацията за търсещи машини на вашият уеб сайт. Предоставящ много SEO инструменти за оптимизация, увеличаване и проследяване, представянето на вашите уеб сайтове. Софтуер с отворен код, предоставящ ви възможност да развиете собствени SEO модули за Seo Panel.\r\n', '2016-12-18 17:09:40'),
(3401, 'bg', 'settings', 'seopanel_title', 'Seo Panel: Първият в света SEO контролен панел с отворен код', '2016-12-18 17:09:40'),
(3402, 'bg', 'settings', 'SP_CRAWL_DELAY', 'Забавяне между всяко обхождане от "паяка" (секунди)\r\n', '2016-12-18 17:09:40'),
(3403, 'bg', 'settings', 'SP_DEFAULTLANG', 'Език по подразбиране', '2016-12-18 17:09:40'),
(3404, 'bg', 'settings', 'SP_DESCRIPTION', 'Описание на Seo Panel', '2016-12-18 17:09:40'),
(3405, 'bg', 'settings', 'SP_ENABLE_PROXY', 'Разрешаване на прокси', '2016-12-18 17:09:40'),
(3406, 'bg', 'settings', 'SP_HOTLINKING', 'Включване на защитата против хотлинкинг на снимки', '2016-12-18 17:09:40'),
(3407, 'bg', 'settings', 'SP_KEYWORDS', 'Seo Panel Ключови думи', '2016-12-18 17:09:40'),
(3408, 'bg', 'settings', 'SP_PAGINGNO', 'Резултати на страница', '2016-12-18 17:09:40'),
(3409, 'bg', 'settings', 'SP_TITLE', 'Seo Panel Заглавие', '2016-12-18 17:09:40'),
(3410, 'bg', 'settings', 'SP_USER_GEN_REPORT', 'Позволи на потребителите да генерират доклади', '2016-12-18 17:09:40'),
(3411, 'bg', 'settings', 'SP_USER_REGISTRATION', 'Интерфейс за потребителска регистрация', '2016-12-18 17:09:40'),
(3412, 'bg', 'settings', 'syssettingssaved', 'Настройките са запазени успешно', '2016-12-18 17:09:40'),
(3413, 'bg', 'home', 'Account Summary', 'Обобщена информация', '2011-07-07 01:34:27'),
(3414, 'bg', 'home', 'Backlinks', 'Беклинкове', '2011-07-07 01:34:28'),
(3415, 'bg', 'home', 'Directory Submission', 'Регистрация в Директории', '2011-07-07 01:34:28'),
(3416, 'bg', 'home', 'home_cont1', '<h1 style=\\"text-align: center;margin-bottom: 30px;font-size: 19px;\\">Добре дошли в Seo Panel - Първият в света SEO контролен панел</h1> \r\n        <p> \r\n            SEO контролен панел с <b>напълно отворен код</b>, за управление на <b>оптимизацията за търсещи машини</b> на вашите сайтове.  \r\n            Seo Panel е <b>комплект от SEO инструменти</b>, включващ последните и най-нови инструменти, необходими за <b>повишаване и следене</b> на <b>представянето</b> на вашите уеб сайтове. \r\n            Това е <b>безплатен софтуер</b> разпространяващ се под <b>GNU - GENERAL PUBLIC LICENSE</b>. \r\n            Основаната характеристика на SEO Panel е възможността за <b>разширение на функционалността</b>, чрез използването на <a href=\\"<?=SP_PLUGINSITE?>\\"\r\ntarget=\\"_blank\\">SEO модули</a>. \r\n            Всеки може лесно да <b>разработи и инсталира</b> необходимите му модули за неговият SEO panel.  \r\n        </p> \r\n        <p></p> \r\n        <p> \r\n            Този софтуер с отворен код, се разпространява от <b>Януари 2010</b>. \r\n            За този <b>кратък период</b> от време <b>хиляди уеб разработчици</b> използваха този софтуер, за да <b>оптимизират</b>  техните сайтове. \r\n            Изполвайте SEO panel сега и открийте <b>предимствата</b> на работа с много SEO инструменти под една <b>платформа</b>. \r\n        </p> ', '2011-07-07 01:34:28'),
(3417, 'bg', 'home', 'home_cont2', '<fieldset> \r\n<legend>Основни характеристики на Seo Panel <?=SP_INSTALLED?></legend> \r\n<ul class=\\"infobox\\"> \r\n    <li>         \r\n        <h1>Инструмент за Автоматично регистриране в Директории</h1> \r\n        <p> \r\n            Инструмента за автоматично регистриране в директории, помага да <b>регистрирате вашите сайтове</b> в голям брой <b>безплатни и платени интернет директории</b>. \r\n            Също така можете да <b>следите статуса</b> на всяка регистрация чрез <b>периодична проверка</b>, използвайки <b>скрипта за следене статуса</b> на регистрация. \r\n            <b>Управлението на директории</b> ви помога да установите дали дадена директория е <b>активна</b> или не. \r\n        </p> \r\n    </li> \r\n    <li>         \r\n        <h1>Инструмент за Проверка на позиция по ключова дума</h1> \r\n        <p> \r\n            Инструмента за проверка на позиция по ключова дума ще открие <b>позицията в търсачка</b> за <b>въведените ключови думи</b>\r\nкъм вашият сайт и ще <b>запази</b> резултата в системата. \r\n            В секцията с доклади за позиция по ключова дума, можете да видите <b>дневните позиции</b> на ключовите думи за различните търсачки чрез <b>графики</b> и <b>детайлни доклади</b>. \r\n        </p> \r\n    </li> \r\n    <li>         \r\n        <h1>Сайт Одитор</h1> \r\n        <p>Сайт Одитора <b>ще направи проверка на всички SEO фактори</b> за страниците на посоченият сайт и ще покаже <b>детайлен доклад</b> за всяка страница. Това ще помогне да се създаде <b>XML,HTML,TEXT</b> карта на сайта, която <b>да се използва</b> за търсещите машини.</p> \r\n    </li> \r\n    <li>         \r\n        <h1>Проверка на ранга в Google и Alexa</h1> \r\n        <p> \r\n            Инструмента за проверка на ранга в Google и Alexa, ще ви покаже <b>пейдж ранга в google</b> и <b>ранга в alexa</b> на вашите сайтове и ще го <b>запази</b> в системата. \r\n            В секцията <b>доклади за ранг</b>, можете да видите <b>дневния</b> google и alexa ранг за всеки от въведените сайтове, посредством <b>детайлни доклади</b>. \r\n        </p> \r\n    </li> \r\n    <li>         \r\n        <h1>Инструмент за проверка на беклинкове</h1> \r\n        <p> \r\n            Инструмента за проверка на беклинкове ще провери <b>броя на беклинковете</b> за въведените сайтове в различните търсачки <b>(google,yahoo,msn и т.н.)</b> и <b>ще го запази</b> в системата. \r\n            <br>В секцията <b>Доклади за беклинкове</b>, можете да видите <b>дневното преброяване на беклинковете</b> за всеки от въведените сайтове, посредством <b>детайлни доклади</b>. \r\n        </p> \r\n    </li>     \r\n    <li>         \r\n        <h1>Инструмент за проверка на наситеността в търсачка</h1> \r\n        <p> \r\n            Инструмента за проверка на наситеността, ще открие <b>броя индексирани страници</b> за въведените сайтове в различните търсачки <b>(google,yahoo,msn и т.н.)</b> и ще го <b>запази</b> в системата. \r\n            В секцията  <b>Доклади за наситеността</b>, можете да видите <b>броят индексирани страници по дни</b> за всеки от въведните сайтове, посредством <b>детайлни доклади</b>. \r\n        </p> \r\n    </li> \r\n    <li>         \r\n        <h1>Seo Panel Модули</h1> \r\n        <p> \r\n            <b>Основната харектиристика</b> и преимущество на SEO control panel е възможността за <b>разширяване на броя инструменти</b>. \r\n            Добавете <b>SEO модул</b> към вашият SEO panel за да <b>разширите функционалността</b> според вашите нужди. \r\n            <a href=\\"<?=SP_PLUGINSITE?>\\" target=\\"_blank\\">Seo panel модулите</a> се разработват от SEO panel, както и от външни разработчици. \r\n            Можете лесно да <b>разработите</b> SEO модули за вашият SEO panel и да <a href=\\"<?=SP_PLUGINSITE?>\\" target=\\"_blank\\">добавите</a> вашият SEO модул към SEO panel, ние ще го <b>публикуваме</b> на нашият сайт, след като го <b>прегледаме</b>. \r\n        </p> \r\n    </li> \r\n    <li>         \r\n        <h1>Генератор на мета тагове</h1> \r\n        <p> \r\n            Генераторът на мета тагове е <b>SEO panel модул</b> за създаване на <b>мета тагове</b> за вашият сайт. \r\n            Мета таговете помагат, да дадете <b>повече информация</b> относно сайта ви на <b>роботите на търсачката</b>, докато те обират информация от сайта ви. \r\n        </p> \r\n    </li> \r\n</ul> \r\n</fieldset> ', '2011-07-07 01:34:28'),
(3418, 'bg', 'home', 'home_cont3', '<fieldset> \r\n<legend>Seo Panel - Онлайн ресурси</legend>     \r\n<ul class=\\"infobox\\"> \r\n\r\n    <li> \r\n        <h1>Seo Panel - Онлайн ресурси</h1>                 \r\n         \r\n         \r\n        <p> \r\n            <a href=\\"http://www.seopanel.in\\" target=\\"_blank\\">Seo Panel - Официален сайт</a> \r\n        </p> \r\n        <p> \r\n            <a href=\\"<?=SP_DOWNLOAD_LINK?>\\" target=\\"_blank\\">Изтеглете Seo Panel</a> \r\n        </p> \r\n         \r\n        <p> \r\n            <a href=\\"<?=SP_DEMO_LINK?>\\" target=\\"_blank\\">Seo Panel Демо</a> \r\n        </p> \r\n         \r\n        <p> \r\n            <a href=\\"<?=SP_CONTACT_LINK?>\\" target=\\"_blank\\">Контакти</a> \r\n        </p> \r\n         \r\n        <p> \r\n            <a href=\\"<?=SP_HELP_LINK?>\\" target=\\"_blank\\">Помощна информация</a> \r\n        </p> \r\n         \r\n        <p> \r\n            <a href=\\"<?=SP_FORUM_LINK?>\\" target=\\"_blank\\">Seo Panel Форум</a> \r\n        </p> \r\n         \r\n        <p> \r\n            <a href=\\"<?=SP_SUPPORT_LINK?>\\" target=\\"_blank\\">Техническа поддръжка</a> \r\n        </p> \r\n         \r\n        <p> \r\n            <a href=\\"<?=SP_DONATE_LINK?>\\" target=\\"_blank\\">Направете дарение</a> \r\n        </p> \r\n    </li> \r\n     \r\n</ul> \r\n</fieldset>', '2011-07-07 01:34:28'),
(3419, 'bg', 'home', 'Pages Indexed', 'Индексирани страници', '2011-07-07 01:34:28'),
(3420, 'bg', 'home', 'Ranks', 'Ранг', '2011-07-07 01:34:28'),
(3421, 'bg', 'home', 'SiteNameUrl', 'Име/Адрес', '2011-07-07 01:34:28'),
(3422, 'bg', 'home', 'Website Statistics', 'Общи статистики', '2011-07-07 01:34:28');
INSERT INTO `texts` (`id`, `lang_code`, `category`, `label`, `content`, `changed`) VALUES
(3423, 'bg', 'support', 'support_cont1', '<fieldset> \r\n<legend>SEO Panel Техническа подръжка</legend> \r\n<ul class=\\"infobox\\"> \r\n    <li> \r\n        <h1>Пакет от 1000 Директории</h1>  \r\n        <p> \r\n            Осигуряваме <b>пакет от 1000 безплатни и потвърдени</b> интернет директории, които можете да добавите към вашият <b>инструмент за регистрация в директории</b> в seo panel. \r\n            Този пакет ще ви помогне <b>да увеличите беклинковете</b> към вашите сайтове. \r\n            Всъщност, списъка с 1000 директории се <b>представя</b> за да съберем средства за <b>бъдеща разработка</b> на seo panel. \r\n            За да получите списъка с 1000 директории, моля <a href=\\"<?=SP_DONATE_LINK?>\\" target=\\"_blank\\">направете дарение</a>\r\nот 10 $ или повече. Дарението ще се използва за подобряване на seo panel. \r\n            Ако имате въпроси относно списъка с 1000 директории, моля <a href=\\"<?=SP_CONTACT_LINK?>\\"\r\ntarget=\\"_blank\\">свържете се с нас</a> или създайте билет в <a href=\\"<?=SP_SUPPORT_LINK?>\\"\r\ntarget=\\"_blank\\">системата за техническа подръжка</a>.    \r\n        </p>         \r\n        <p> \r\n            <a href=\\"<?=SP_DONATE_LINK?>\\" target=\\"_blank\\">Посетете този линк за да направите дарение на seo panel</a> \r\n        </p> \r\n        <br> \r\n    </li> \r\n     \r\n    <li> \r\n        <h1>Пакет локални търсачки</h1>  \r\n        <p> \r\n            Добавяне <b>локализирани домейни на търсачка</b> - google,yahoo,msn(<b>например: www.google.de,www.google.fr\r\nи др.</b>) към SEO panel за <b>позиция по ключова дума</b>, за да следите локалните резултати за вашите сайтове. \r\n            За да добавим пакета за локални търсачки (според вашите изисквания), моля <a\r\nhref=\\"<?=SP_DONATE_LINK?>\\" target=\\"_blank\\">направете дарение</a> от 10 $ или повече. Дарението ще се използва за подобряване на seo panel. \r\n            Преди да изпратите даренията, моля <a href=\\"<?=SP_CONTACT_LINK?>\\" target=\\"_blank\\">свържете се с нас</a> за да ни предоставите списък с желаните домейни на търсачки за локално търсене. \r\n            <br><br>               \r\n            Също така, за да добавим <b>нови търсачки (напр.:baidu.com)</b> към проверката на позиция по ключова дума към вашият seo panel,\r\nмоля <a href=\\"<?=SP_CONTACT_LINK?>\\" target=\\"_blank\\">свържете се с нас</a> или създайте билет в <a\r\nhref=\\"<?=SP_SUPPORT_LINK?>\\" target=\\"_blank\\">системата за техническа подръжка</a>.  \r\n        </p>         \r\n        <p class=\\"visit\\"> \r\n            <a href=\\"<?=SP_CONTACT_LINK?>\\" target=\\"_blank\\">Посетете този линк за да се свържете с нас</a> \r\n        </p> \r\n        <br> \r\n    </li> \r\n     \r\n    <li> \r\n        <h1>Seo Panel Модули</h1>  \r\n        <p> \r\n            Добавете <b>seo модули</b> към вашият seo panel за да <b>разширите възможностите му</b>, според вашите нужди. \r\n            <a href=\\"<?=SP_PLUGINSITE?>\\" target=\\"_blank\\">Seo panel модулите</a> се разработват, както от екипа на seo panel, така и от други разработчици. \r\n            Можете лесно да <b>разработите</b> seo модули за вашият seo panel. \r\n            Можете да ни <a href=\\"<?=SP_PLUGINSITE?>\\" target=\\"_blank\\">изпратите</a> вашият seo модул за seo panel и ние ще го <b>публикуваме</b> на нашият сайт след като го <b>прегледаме</b>.         \r\n        </p>         \r\n        <p> \r\n            <a href=\\"<?=SP_PLUGINSITE?>\\" target=\\"_blank\\">Посетете този линк за да изтеглите последните seo panel модули</a> \r\n        </p> \r\n        <br> \r\n    </li>     \r\n    <li> \r\n        <h1>Връзка с нас</h1>  \r\n        <p> \r\n            Свържете се с нас за всякакви въпроси свързани с <b>инструментите, модулите, опциите и т.н. на seo panel </b> като използвате линка по-долу.         \r\n        </p>         \r\n        <p> \r\n            <a href=\\"<?=SP_CONTACT_LINK?>\\" target=\\"_blank\\">Посетете този линк за да се свържете с нас</a> \r\n        </p> \r\n        <br> \r\n    </li>     \r\n    <li> \r\n        <h1>Система за техническа подръжка</h1>  \r\n        <p> \r\n            За да получите <b>техническа подръжка</b> от екипа на seo panel относно <b>инсталирането, модулите, инструментите и опциите на seo panel</b>. Например: Да настройте cron за проверката на позиция по ключова дума. \r\n        </p>         \r\n        <p> \r\n            <a href=\\"<?=SP_SUPPORT_LINK?>\\" target=\\"_blank\\">Посетете този линк за да създадете билет в системата за техническа подръжка</a> \r\n        </p> \r\n        <br> \r\n    </li>     \r\n    <li> \r\n        <h1>Докладване на бъгове(грешки)</h1>  \r\n        <p> \r\n            Докладвайте за <b>бъгове</b> в <b>инсталирането, модулите, инструментите, опциите и т.н. на seo panel</b> използвайки линка по долу.  \r\n           По този начин, ни помогате да подобрим работата на следащите версии на seo panel.           \r\n        </p>         \r\n        <p> \r\n            <a href=\\"<?=SP_SUPPORT_LINK?>\\" target=\\"_blank\\">Посетете този линк за да докладвате за бъгове</a> \r\n        </p> \r\n        <br> \r\n    </li>     \r\n</ul> \r\n</fieldset>', '2010-11-14 19:47:30'),
(3424, 'bg', 'support', 'support_cont2', '<fieldset> \r\n<legend>SEO Panel - Онлайн ресурси</legend> \r\n<ul class=\\"infobox\\"> \r\n         \r\n    <li> \r\n        <h1>Seo Panel - Помощна информация</h1>  \r\n        <p> \r\n            Можете да разгледате <a href=\\"<?=SP_HELP_LINK?>\\" target=\\"_blank\\">документацията на SEO panel</a> в <b>помощната информация</b>. Съдържа <b>документация</b> за инструментите на SEO panel, модулите и различните функционалности. \r\n            <br>Най доброто място в интернет, където можете да <b>получите помощ</b> относно SEO panel. Надяваме се да\r\n<b>допълвате</b> помощната информация на seo panel, ако намерите някакви грешки или нещо липсва.                 \r\n        </p> \r\n        <p> \r\n            <a href=\\"<?=SP_HELP_LINK?>\\" target=\\"_blank\\">Посетете секцията Помощна информация</a> \r\n        </p> \r\n        <br> \r\n    </li>     \r\n    <li> \r\n        <h1>Форум Seo Panel</h1>  \r\n        <p> \r\n            Мястото за дискусии на първият в света <b>seo контролен панел</b> с отворен код.  \r\n            Най-доброто място да откриете <b>отговори</b> на вашите <b>въпроси</b> относно seo panel.  \r\n            <br>Също така можете да <b>споделите</b> вашият <b>опит</b> в използването на seo panel за оптимизиране на вашите уеб сайтове.                                \r\n        </p>         \r\n        <p> \r\n            <a href=\\"<?=SP_FORUM_LINK?>\\" target=\\"_blank\\">Посетете форума на seo panel</a> \r\n        </p> \r\n        <br> \r\n    </li> \r\n</ul>     \r\n</fieldset>', '2010-11-14 19:47:30'),
(3425, 'bg', 'support', 'support_cont3', '<fieldset> \r\n<legend>Направете дарение на SEO Panel</legend> \r\n<ul class=\\"infobox\\">         \r\n    <li> \r\n        <h1>Направете дарение на Seo Panel - Първият в света, SEO контролен панел с отворен код</h1>  \r\n        <p> \r\n            <b>Направете дарение</b> на SEO panel за да подкрепите първият SEO контролен панел с отворен код в света. \r\n            Планираме да <b>добавяме и подобряваме</b> функционалността на SEO panel в бъдеще.  \r\n            <br>Заедно, с <b>вашата подкрепа</b> можем да постигнем нашите <b>цели</b>. \r\n            Ако смятате, че SEO panel си <b>струва</b>, моля дарете някаква сума на екипа на SEO panel. \r\n            <br>Ще <b>публикуваме</b> вашето име и информация за вашият сайт на <a href=\\"<?=SP_DONATE_LINK?>\\"\r\ntarget=\\"_blank\\">страницата с дарители</a>, след като получим дарението ви. \r\n        </p> \r\n        <p> \r\n            <a href=\\"<?=SP_DONATE_LINK?>\\" target=\\"_blank\\">Посетете този линк за да направите дарение на SEO panel</a> \r\n        </p> \r\n        <br> \r\n    </li> \r\n</ul> \r\n</fieldset> ', '2010-11-14 19:47:30'),
(3426, 'bg', 'seotools', 'Automatic Submission', 'Автоматична регистрация', '2011-07-07 01:42:13'),
(3427, 'bg', 'seotools', 'backlink-checker', 'Проверка на беклинкове', '2011-07-07 01:42:13'),
(3428, 'bg', 'seotools', 'Backlinks Reports', 'Доклади за беклинкове', '2011-07-07 01:42:13'),
(3429, 'bg', 'seotools', 'Check Submission Status', 'Проверка на статуса на регистрация', '2011-07-07 01:42:13'),
(3430, 'bg', 'seotools', 'clickgeneratereports', 'Кликнете на <b>Продължи</b> за да генерирате доклади', '2011-07-07 01:42:13'),
(3431, 'bg', 'seotools', 'Detailed Position Reports', 'Детайлни доклади за позиция', '2011-07-07 01:42:13'),
(3432, 'bg', 'seotools', 'directory-submission', 'Регистриране в директории', '2011-07-07 01:42:13'),
(3433, 'bg', 'seotools', 'Featured Submission', 'Препоръчана регистрация', '2011-07-07 01:42:13'),
(3434, 'bg', 'seotools', 'Generate Backlinks Reports', 'Генериране на доклади за беклинкове', '2011-07-07 01:42:13'),
(3435, 'bg', 'seotools', 'Generate Keyword Reports', 'Генериране на доклади за ключови думи', '2011-07-07 01:42:13'),
(3436, 'bg', 'seotools', 'Generate Rank Reports', 'Генериране на доклади за ранг', '2011-07-07 01:42:13'),
(3437, 'bg', 'seotools', 'Generate Saturation Reports', 'Генериране на доклади за наситеността', '2011-07-07 01:42:13'),
(3438, 'bg', 'seotools', 'Google Sitemap Generator', 'Генериране на карта за Google', '2011-07-07 01:42:13'),
(3439, 'bg', 'seotools', 'Graphical Position Reports', 'Графични доклади за позиция', '2011-07-07 01:42:13'),
(3440, 'bg', 'seotools', 'Keyword Position Summary', 'Позиции по ключови думи', '2011-07-07 01:42:13'),
(3441, 'bg', 'seotools', 'keyword-position-checker', 'Позиция по ключова дума', '2011-07-07 01:42:13'),
(3442, 'bg', 'seotools', 'Keywords Manager', 'Управление на ключови думи', '2011-07-07 01:42:13'),
(3443, 'bg', 'seotools', 'Quick Backlinks Checker', 'Бърза проверка на беклинкове', '2011-07-07 01:42:13'),
(3444, 'bg', 'seotools', 'Quick Position Checker', 'Бърза проверка на позиция', '2011-07-07 01:42:13'),
(3445, 'bg', 'seotools', 'Quick Rank Checker', 'Бърза проверка на ранг', '2011-07-07 01:42:13'),
(3446, 'bg', 'seotools', 'Quick Saturation Checker', 'Бърза проверка на наситеността', '2011-07-07 01:42:13'),
(3447, 'bg', 'seotools', 'Rank Reports', 'Доклади за ранг', '2011-07-07 01:42:13'),
(3448, 'bg', 'seotools', 'rank-checker', 'Проверка на ранг', '2011-07-07 01:42:13'),
(3449, 'bg', 'seotools', 'Saturation Reports', 'Доклади за наситеността', '2011-07-07 01:42:13'),
(3450, 'bg', 'seotools', 'saturation-checker', 'Наситеност в търсачка', '2011-07-07 01:42:13'),
(3451, 'bg', 'seotools', 'sitemap-generator', 'Генератор на карта на сайта', '2011-07-07 01:42:13'),
(3452, 'bg', 'seotools', 'Skipped Directories', 'Прескочени директории', '2011-07-07 01:42:13'),
(3453, 'bg', 'seotools', 'Submission Reports', 'Доклади за добавени в директории', '2011-07-07 01:42:13'),
(3454, 'bg', 'seotools', 'User Access', 'Потребителски достъп', '2011-07-07 01:42:13'),
(3455, 'bg', 'saturation', 'clickproceedsaturation', 'Въведете <b>по един</b> URL адрес на ред. Кликнете на <b>Продължи</b> за да видите резултатите за наситеност в търсачка', '2010-11-14 19:40:27'),
(3456, 'bg', 'saturation', 'GenerateSaturationReports', 'Генериране на доклади за наситеността', '2010-11-14 19:40:27'),
(3457, 'bg', 'saturation', 'Quick Search Engine Saturation Checker', 'Бърза проверка за наситеността', '2010-11-14 19:40:27'),
(3458, 'bg', 'saturation', 'Saved Search Engine Saturation results of', 'Запазени доклади за наситеността за', '2010-11-14 19:40:27'),
(3459, 'bg', 'saturation', 'Search Engine Saturation Reports', 'Доклади за наситеността', '2010-11-14 19:40:27'),
(3460, 'bg', 'directory', 'Add back to directory list', 'Добави обратно към списъка с директории', '2012-11-09 21:03:43'),
(3461, 'bg', 'directory', 'Approved', 'Одобрено', '2012-11-09 21:03:43'),
(3462, 'bg', 'directory', 'Captcha', 'Картинен код', '2012-11-09 21:03:43'),
(3463, 'bg', 'directory', 'categorynote', 'Категории, разделете ги с запетая според приоритета. Започнете с категорията с най-висок приоритет.', '2012-11-09 21:03:43'),
(3464, 'bg', 'directory', 'Check Directory Status', 'Проверка на статуса на директория', '2012-11-09 21:03:43'),
(3465, 'bg', 'directory', 'Check Directory Submission Status', 'Проверете статуса на регистрация за директория', '2012-11-09 21:03:43'),
(3466, 'bg', 'directory', 'clicktoproceeddirsts', 'Кликнете на <b>Продължи</b> за да проверите статуса на директория.', '2012-11-09 21:03:43'),
(3467, 'bg', 'directory', 'Confirmation', 'Потвърждение', '2012-11-09 21:03:43'),
(3468, 'bg', 'directory', 'desnote', 'Някои директории изискват да въведете минимум 150 символа в полето за описание.', '2012-11-09 21:03:43'),
(3469, 'bg', 'directory', 'Directories with out captcha', 'Директории без картинен код', '2012-11-09 21:03:43'),
(3470, 'bg', 'directory', 'Directory Submission Reports', 'Доклади за регистрация в директория', '2012-11-09 21:03:43'),
(3471, 'bg', 'directory', 'Enter the code shown', 'Въведете кода от картинката', '2012-11-09 21:03:43'),
(3472, 'bg', 'directory', 'nocatnote', 'Категорията за регистрация не е намерена на страницата за регистрация. Моля кликнете на <b>Презареди</b> или <b>Пропусни</b>', '2012-11-09 21:03:43'),
(3473, 'bg', 'directory', 'nodirnote', 'Няма намерени <b>Активни</b> директории ', '2012-11-09 21:03:43'),
(3474, 'bg', 'directory', 'nosuccessnote', 'Не сте получили съобщение за потвърждаване, Моля проверете вашият имейл за съобщението за потвърждаване', '2012-11-09 21:03:43'),
(3475, 'bg', 'directory', 'optionalnote', 'Описанията и заглавията по-долу, не са задължителни! Използват се за добавяне на произволни заглавие и описание към директорията, за по добри резултати.', '2012-11-09 21:03:43'),
(3476, 'bg', 'directory', 'Owner Email', 'Имейл на собственика', '2012-11-09 21:03:43'),
(3477, 'bg', 'directory', 'Owner Name', 'Име на собственика', '2012-11-09 21:03:43'),
(3478, 'bg', 'directory', 'Pending', 'Изчакващ', '2012-11-09 21:03:43'),
(3479, 'bg', 'directory', 'Please select a website to proceed', 'Моля, изберете уеб сайт, за да продължите', '2012-11-09 21:03:43'),
(3480, 'bg', 'directory', 'selectwebsiteproceed', 'Изберете <b>Интернет сайт</b> за да <b>Продължите</b> с регистрацията в директория.<br /><br />Отбележете <b>Директории без картинен код</b> за да регистрирате в директории, в които не се изисква потвърждение чрез картинен код  ', '2012-11-09 21:03:43'),
(3481, 'bg', 'directory', 'selectwebsiteschecksub', 'Изберете <b>Интернет сайт</b> за да <b>Продължите</b> с проверка на регистрацията в директория. ', '2012-11-09 21:03:43'),
(3482, 'bg', 'directory', 'Semi Automatic Directory Submission Tool', 'Полу-автоматично регистриране в директории', '2012-11-09 21:03:43'),
(3483, 'bg', 'directory', 'spamemailnote', 'Някой директори може да изпращат SPAM съобщения, не ви препоръчваме да използвате главния си имейл адрес.', '2012-11-09 21:03:43'),
(3484, 'bg', 'directory', 'Submission Details', 'Детайли на регистрацията', '2012-11-09 21:03:43'),
(3485, 'bg', 'directory', 'Submit Description', 'Описание за регистрацията', '2012-11-09 21:03:43'),
(3486, 'bg', 'directory', 'Submit Keywords', 'Ключови думи за регистрацията', '2012-11-09 21:03:43'),
(3487, 'bg', 'directory', 'Submit Title', 'Заглавие за регистрацията', '2012-11-09 21:03:43'),
(3488, 'bg', 'directory', 'Website Category', 'Категория на сайта', '2012-11-09 21:03:43'),
(3489, 'bg', 'directory', 'Website Url', 'Адрес на сайта', '2012-11-09 21:03:43'),
(3490, 'pt', 'support', 'support_cont1', '<fieldset>\r\n<legend> Seo panel sistema de suporte </legend>\r\n<ul class=\\"infobox\\"> \r\n<li>\r\n<h1> Pacote de 1000 directórios </h1>\r\n<p>\r\nNós estamos fornecendo <b>um pacote de 1000 activos e verificados </b> inserções em directórios da internet, para adicionar no seu Seo panel <b> na ferramenta de submissão de directórios </b>.\r\nVai ajudar você a aumentar <b> backlinks </b> a visibilidade dos seus sites.\r\nActualmente estamos a angariar<b> uma doacção para futuros desenvolvimentos </b>\r\npara o Seo Panel.\r\nPara obter a lista 1000 directórios <a href = \\"<?=SP_DONATE_LINK?>\\" target = \\"_blank\\"> doe </a>\r\nUS $ 20 ou mais para melhorar as características do Seo Panel.\r\nSe você tiver alguma dúvida sobre pacote de 1000 do directórios, por favor <a href = \\"<?=SP_CONTACT_LINK?>\\"\r\ntarget ="_blank"> contato nos </a> ou submeta um ticket no <a href = \\"<?=SP_SUPPORT_LINK?>\\"\r\ntarget = \\"_blank\\"> Suporte Sistema </a>.\r\n</P>\r\n<p>\r\n<A href = \\"<?=SP_DONATE_LINK?> \\" Target ="_blank"> Visite este link para doar para seo panel </a>\r\n</P>\r\n<br>\r\n</Li>\r\n\r\n<li>\r\n<h1> Pacote de motores de busca Locais </h1>\r\n<p>\r\nAdicionar <b> motor de busca locais , domínios </b> do google, yahoo, msn (por exemplo, <b>: www.google.de, www.google.fr, etc </b>) para seo panel <b> palavra-chave verifica a posição </b>, para acompanhar a sua perfomance site localmente.\r\nPara obter pacotes de motores de busca locais (de acordo com sua exigência) <a\r\nhref = \\"<?=SP_DONATE_LINK?>\\" target =\\"_blank \\"> doar </a> US $ 20 ou mais para melhorar as características de seo panel.\r\nAntes de enviar doações, por favor <a href = \\"<?=SP_CONTACT_LINK?>\\" Target = \\"_blank\\"> Entre em contato </a> para fornecer-nos o domínio do motor de busca em questão.\r\n<br>\r\nTambém para adicionar <b> novos motores de pesquisa (por exemplo: baidu.com) </b> no seu seo panel e palavras-chave,\r\npor favor <a href = \\"<?=SP_CONTACT_LINK?>\\" target = \\" _blank\\">contato nos </a> ou abrir um ticket no <a\r\nhref = \\"<?=SP_SUPPORT_LINK?>\\" target = \\"_blank\\"> sistema de suporte </a>.\r\n</P>\r\n<p class=\\"visit\\"> \r\n<A href = \\"<?=SP_CONTACT_LINK?>\\" Target = \\"_blank\\"> Visite este link para entrar em contacto connosco </a>\r\n</P>\r\n<br>\r\n</Li>\r\n\r\n<li>\r\n<h1>Seo plugins </h1>\r\n<p>\r\nAdicionar <b> plugins </b> ao seu Seo Panel para <b> estender os recursos </b> de acordo com a sua exigência.\r\n<A href = \\"<?=SP_PLUGINSITE?>\\" Target = \\"_blank\\"> Seo Panel plugins </a> são fornecidos por Seo Panel e e por terceiros.\r\nVocê também pode facilmente desenvolver <b> </b> plugins de SEO para seu painel de seo.\r\nVocê pode <a href = \\"<?=SP_PLUGINSITE?> \\"Target =\\" _blank \\"> apresentar </a> o seu plugin para Seo, Seo Panel vai publicar <b> </b> no nosso site após testarmos o plugin.\r\n</P>\r\n<p>\r\n<A href = \\"<?=SP_PLUGINSITE?>\\" Target = \\"_blank\\"> Visite este link para obter os plugins para o Seo Panel </a>\r\n</P>\r\n<br>\r\n</Li>\r\n<li>\r\n<h1>Fale Connosco </h1>\r\n<p>\r\nEntre em contacto connosco para esclarecer qualquer dúvida sobre as ferramentas de  <b>Seo Panel, plugins e funcionalidades etc </b> usando o link abaixo.\r\n</P>\r\n<p>\r\n<A href = \\"<?=SP_CONTACT_LINK?>\\" Target = \\"_blank\\"> Visite este link para contacto connosco </a>\r\n</P>\r\n<br>\r\n</Li>\r\n<li>\r\n <h1>Tickets de Suporte </h1>\r\n<p>\r\nPara obter suporte técnico <b> </b> da equipe do Seo Panel para configurar as ferramentas do <b>Seo Panel, plugins e\r\nrecursos </b> Por exemplo:. Para configurar o cron para verificador de posição da palavra-chave.\r\n</P>\r\n<p>\r\n<A href = \\"<?=SP_SUPPORT_LINK?>\\" Target = \\"_blank\\"> Visite este link para criar um ticket de suporte </a>\r\n</P>\r\n<br>\r\n</Li>\r\n<li>\r\n<h1>Relatar bugs </h1> \r\n<p>\r\nRelatório de  <b> bugs </b> sobre ferramentas do <b> Seo painel, plugins e funcionalidades etc </b> usando o link abaixo.\r\npor favor, ajude-nos a melhorar as características das versões vindouras.\r\n</P>\r\n<p>\r\n<A href = \\"<?=SP_SUPPORT_LINK?> \\"Target =\\"_blank\\"> Visite este link para relatar bugs </a>\r\n</P>\r\n<br>\r\n</Li>\r\n</Ul>\r\n</Fieldset> ', '2010-11-18 02:21:31'),
(3491, 'pt', 'support', 'support_cont2', '<fieldset>\r\n<legend>  Recursos on-line do Seo Panel </legend>\r\n<ul class=\\"infobox\\"> \r\n\r\n<li>\r\n<h1>Guia de Ajuda do Seo Panel</h1>\r\n<p>\r\nVocê pode ver a <a href = \\"<?=SP_HELP_LINK?>\\" Target = \\"_blank\\"> documentação de ajuda</A> do Seo Panel , que contém documentos dos recursos para as ferramentas do SEO Panel, plugins e afins.\r\n<br> É o melhor lugar na internet para <b> obter ajuda </b> sobre SEO Panel. Esperamos que você<b> possa contribuir </b> para o guia de ajuda do Seo Panel , caso você encontre erros ou coisas que faltam.\r\n</P>\r\n<p>\r\n<A href = \\"<?=SP_HELP_LINK?>\\" Target = \\"_blank\\"> Visite o guia de ajuda do Seo Panel </A>\r\n</P>\r\n<br>\r\n</Li>\r\n<li>\r\n<h1> Fórum do Seo Panel </h1>\r\n<p>\r\nUm lugar para discutir sobre a primeiro software livre do mundo de <b> controle de Seo</b>.\r\nÉ o melhor local para encontrar as respostas para <b>as suas perguntas </b> sobre SEO Panel.\r\n<br> Também você pode <b> partilhar</b> a sua experiência <b></B>, enquanto usa o SEO Panel para optimizar os seus sites.\r\n</P>\r\n<p>\r\n<A href = \\"<?=SP_FORUM_LINK?>\\" Target = \\"_blank\\"> Visite Fórum do Seo Panel </a>\r\n</P>\r\n<br>\r\n</Li>\r\n</Ul>\r\n</Fieldset> ', '2010-11-18 02:21:31'),
(3492, 'pt', 'support', 'support_cont3', '<fieldset>\r\n<legend> Doações para Seo Panel </legend>\r\n<ul class=\\"infobox\\"> \r\n<li>\r\n<h1> Doações para Seo Panel - Primeiro software livre de controle Seo do mundo </h1>\r\n<p>\r\n<b> Doe </b> para o suporte do Seo Panel, o primeiro Seo de código aberto do mundo.\r\nEstamos planear <b> acrescentar e melhorar </b> características do Seo Panel no futuro.\r\n<br> Só com o seu apoio é nós podemos alcançar nossos objectivos.\r\nSe você acha que o Seo Panel preenche os <b>requisitos</b>, por favor doe alguma quantia para a equipa do Seo Panel.\r\n<br> Vamos <b> publicar </b> seu nome e informações do seu site <a href = \\"<?=SP_DONATE_LINK?>\\"\r\ntarget = \\"_blank\\"> página de doações </a>, quando recebermos a sua doação.\r\n</P>\r\n<p>\r\n<A href = \\"<?=SP_DONATE_LINK?>\\" Target = \\"_blank\\"> Visite este link para doar para seo painel </a>\r\n</P>\r\n<br>\r\n</Li>\r\n</Ul>\r\n</Fieldset> ', '2010-11-18 02:21:31'),
(3493, 'en', 'settings', 'SP_USER_AGENT', 'User agent', '2010-11-19 08:11:24'),
(3494, 'de', 'settings', 'SP_USER_AGENT', 'User-Agent', '2015-06-16 08:32:07'),
(3495, 'bg', 'settings', 'SP_USER_AGENT', 'Потребителски агент', '2016-12-18 17:09:40'),
(3496, 'zh', 'settings', 'SP_USER_AGENT', '用户代理', '2014-05-15 17:56:30'),
(3497, 'nl', 'settings', 'SP_USER_AGENT', 'User agent', '2014-01-07 21:51:05'),
(3498, 'fr', 'settings', 'SP_USER_AGENT', 'User agent', '2016-12-09 18:04:37'),
(3499, 'hu', 'settings', 'SP_USER_AGENT', 'User agent', '2013-02-05 19:25:44'),
(3500, 'it', 'settings', 'SP_USER_AGENT', 'User agent', '2016-12-09 09:21:50'),
(3501, 'pl', 'settings', 'SP_USER_AGENT', 'agent użytkownika', '2014-05-11 19:49:58'),
(3502, 'pt', 'settings', 'SP_USER_AGENT', 'User-agent', '2016-01-17 19:16:12'),
(3503, 'ro', 'settings', 'SP_USER_AGENT', 'Utilizator agent', '2012-05-18 21:16:44'),
(3504, 'ru', 'settings', 'SP_USER_AGENT', 'Пользователь агента', '2017-07-13 16:50:08'),
(3505, 'es', 'settings', 'SP_USER_AGENT', 'Agente de usuario', '2012-05-12 11:03:05'),
(3506, 'tr', 'website', 'Edit Website', 'Siteyi Düzenle', '2017-02-04 13:19:01'),
(3507, 'tr', 'website', 'plscrtwebsite', 'Lütfen Seo Araçları ve Seo Eklentilerini kullanmaya başlamadan önce bir site oluşturunuz.', '2017-02-04 13:19:01'),
(3508, 'tr', 'website', 'Website already exist', 'Web site zaten var.', '2017-02-04 13:19:01'),
(3509, 'tr', 'website', 'yourwebalreday', 'Web siteniz Zaten oluşturulmuş.', '2017-02-04 13:19:01'),
(3510, 'tr', 'user', 'Edit User', 'Üye Düzenle', '2017-02-04 13:22:48'),
(3511, 'tr', 'user', 'Saved My Profile Details', 'Profil detaylarınız kaydedildi.', '2017-02-04 13:22:48'),
(3512, 'tr', 'sitemap', 'Change frequency', 'Frekansı Değiştir', '2010-11-23 10:10:28'),
(3513, 'tr', 'sitemap', 'clickproceedsitemap', 'Site haritası dosyası oluşturmak için <b> devam </ b> tıklayın\r\n', '2010-11-23 10:10:28'),
(3514, 'tr', 'sitemap', 'Download sitemap file from', 'Site haritası dosyasından indir', '2010-11-23 10:10:28'),
(3515, 'tr', 'sitemap', 'Exclude Url', 'URL çıkar', '2010-11-23 10:10:28'),
(3516, 'tr', 'sitemap', 'processtaketime', 'Bu süreçte sitenize link sayısına göre zaman alacaktır. site haritası dosyaları almak için bekleyin', '2010-11-23 10:10:28'),
(3517, 'tr', 'sitemap', 'Sitemap Type', 'Site Haritası Tipi', '2010-11-23 10:10:28'),
(3518, 'tr', 'settings', 'Click here to become a sponsor for Seo Panel', '<b>$100 Bağış yap</b> ve <b>sponsor ol</b> Seo Panel''e', '2017-02-04 13:45:16'),
(3519, 'tr', 'settings', 'seopanel_description', 'web sitelerinin arama motoru optimizasyonu yönetmek için tam bir ücretsiz kontrol paneli. O gelişmiş seo araçları içeren verimliliği arttırmak için web sitelerini izleyebilir. Onun açık kaynak yazılım ve ayrıca seo panel için kendi seo eklentileri gelişebilir.', '2017-02-04 13:45:16'),
(3520, 'tr', 'settings', 'seopanel_title', 'Seo Panel:birden çok web sitelerini yönetmek için dünyanın ilk açık kaynak seo kontrol paneli', '2017-02-04 13:45:16'),
(3521, 'tr', 'settings', 'SP_CRAWL_DELAY', 'Gecikme her tarama (saniye) arasında', '2017-02-04 13:45:16'),
(3522, 'tr', 'settings', 'SP_DEFAULTLANG', 'Varsayılan Dil', '2017-02-04 13:45:16'),
(3523, 'tr', 'settings', 'SP_DESCRIPTION', 'Seo Panel DAçıklama', '2017-02-04 13:45:16'),
(3524, 'tr', 'settings', 'SP_ENABLE_PROXY', 'Proxy Etkinleştir', '2017-02-04 13:45:16'),
(3525, 'tr', 'settings', 'SP_HOTLINKING', 'hotlink koruması etkin', '2017-02-04 13:45:16'),
(3526, 'tr', 'settings', 'SP_KEYWORDS', 'Seo Panel Kelimeleri', '2017-02-04 13:45:16'),
(3527, 'tr', 'settings', 'SP_PAGINGNO', 'sayfa başına girişlerin sayısı', '2017-02-04 13:45:16'),
(3528, 'tr', 'settings', 'SP_TITLE', 'Seo Panel Başlığı', '2017-02-04 13:45:16'),
(3529, 'tr', 'settings', 'SP_USER_AGENT', 'Kullanıcı Arayüzü', '2017-02-04 13:45:16'),
(3530, 'tr', 'settings', 'SP_USER_GEN_REPORT', 'rapor oluşturmak için üyeye izin verin', '2017-02-04 13:45:16'),
(3531, 'tr', 'settings', 'SP_USER_REGISTRATION', 'Kullanıcı kaydı arabirimi', '2017-02-04 13:45:16'),
(3532, 'tr', 'settings', 'syssettingssaved', 'Sistem ayarlarını başarıyla kaydedildi!', '2017-02-04 13:45:16'),
(3533, 'tr', 'seotools', 'Automatic Submission', 'Otomatik Gönderme', '2011-07-10 10:12:15'),
(3534, 'tr', 'seotools', 'backlink-checker', 'Backlink Denetleyicisi', '2011-07-10 10:12:15'),
(3535, 'tr', 'seotools', 'Backlinks Reports', 'Backlink Raporları', '2011-07-10 10:12:15'),
(3536, 'tr', 'seotools', 'Check Submission Status', 'Kontrol Gönderme Durumu', '2011-07-10 10:12:15'),
(3537, 'tr', 'seotools', 'clickgeneratereports', 'Raporları oluşturmak için <b>Devam</b> tıklayınız', '2011-07-10 10:12:15'),
(3538, 'tr', 'seotools', 'Detailed Position Reports', 'Ayrıntılı Pozisyon Raporları', '2011-07-10 10:12:15'),
(3539, 'tr', 'seotools', 'directory-submission', 'Dizin Gönderme', '2011-07-10 10:12:15'),
(3540, 'tr', 'seotools', 'Featured Submission', 'Özellikli Gönderme', '2011-07-10 10:12:15'),
(3541, 'tr', 'seotools', 'Generate Backlinks Reports', 'Geri raporları oluştur', '2011-07-10 10:12:15'),
(3542, 'tr', 'seotools', 'Generate Keyword Reports', 'Anhtar Kelime raporları oluştur', '2011-07-10 10:12:15'),
(3543, 'tr', 'seotools', 'Generate Rank Reports', 'Rütbe raporları oluştur', '2011-07-10 10:12:15'),
(3544, 'tr', 'seotools', 'Generate Saturation Reports', 'Doygunluk raporları oluştur', '2011-07-10 10:12:15'),
(3545, 'tr', 'seotools', 'Google Sitemap Generator', 'Google Site Haritası Raporu', '2011-07-10 10:12:15'),
(3546, 'tr', 'seotools', 'Graphical Position Reports', 'Grafik pozisyon raporları', '2011-07-10 10:12:15'),
(3547, 'tr', 'seotools', 'Keyword Position Summary', 'Anahtar Kelime Konumu Özeti', '2011-07-10 10:12:15'),
(3548, 'tr', 'seotools', 'keyword-position-checker', 'Anahtar Kelime Konumu Denetleme', '2011-07-10 10:12:15'),
(3549, 'tr', 'seotools', 'Keywords Manager', 'Anahtar Kelime yöneticisi', '2011-07-10 10:12:15'),
(3550, 'tr', 'seotools', 'Quick Backlinks Checker', 'Hızlı Backlink denetçisi', '2011-07-10 10:12:15'),
(3551, 'tr', 'seotools', 'Quick Position Checker', 'Hızlı Pozisyon denetçisi', '2011-07-10 10:12:15'),
(3552, 'tr', 'seotools', 'Quick Rank Checker', 'Hızlı rütbe denetçisi', '2011-07-10 10:12:15'),
(3553, 'tr', 'seotools', 'Quick Saturation Checker', 'Hızlı Doygunluk denetimi', '2011-07-10 10:12:15'),
(3554, 'tr', 'seotools', 'Rank Reports', 'Rütbe raporları', '2011-07-10 10:12:15'),
(3555, 'tr', 'seotools', 'rank-checker', 'rütbe denetçisi', '2011-07-10 10:12:15'),
(3556, 'tr', 'seotools', 'Saturation Reports', 'Doygunluk raporları', '2011-07-10 10:12:15'),
(3557, 'tr', 'seotools', 'saturation-checker', 'Doygunluk Araman motoru', '2011-07-10 10:12:15'),
(3558, 'tr', 'seotools', 'sitemap-generator', 'Site Haritası Oluşturucu', '2011-07-10 10:12:15'),
(3559, 'tr', 'seotools', 'Skipped Directories', 'Atlanan Dizinler', '2011-07-10 10:12:15'),
(3560, 'tr', 'seotools', 'Submission Reports', 'Hazırlanmış Raporlar', '2011-07-10 10:12:15'),
(3561, 'tr', 'seotools', 'User Access', 'Kullanıcı Erişimi', '2011-07-10 10:12:15'),
(3562, 'tr', 'backlink', 'clickproceedbacklink', 'Backlink sonuçlarını görmek istediğiniz sitelerin URL'' lerini alt alta yazarak <b>Devam</b> Tıklayınız.', '2017-02-04 13:05:06'),
(3563, 'tr', 'backlink', 'Saved backlink results of', 'Kaydedilen backlink sonuçları', '2017-02-04 13:05:06'),
(3564, 'tr', 'button', 'Cancel', 'Kapat', '2014-01-08 19:36:20'),
(3565, 'tr', 'button', 'Check Status', 'Kontrol Et', '2014-01-08 19:36:20'),
(3566, 'tr', 'button', 'Proceed', 'Devam', '2014-01-08 19:36:20'),
(3567, 'tr', 'button', 'Reload', 'Yeniden', '2014-01-08 19:36:20'),
(3568, 'tr', 'button', 'Show Details', 'Detayları Görüntüle', '2014-01-08 19:36:20'),
(3569, 'tr', 'button', 'Show Records', 'Kayıtları Göster', '2014-01-08 19:36:20'),
(3570, 'tr', 'button', 'Skip', 'Geç', '2014-01-08 19:36:20'),
(3571, 'tr', 'button', 'Submit', 'Onayla', '2014-01-08 19:36:20'),
(3572, 'tr', 'common', 'Action', 'Eylem', '2017-02-04 13:15:42'),
(3573, 'tr', 'common', 'Activate', 'Etkinlik', '2017-02-04 13:15:42'),
(3574, 'tr', 'common', 'Active', 'Aktif', '2017-02-04 13:15:42'),
(3575, 'tr', 'common', 'Admin Panel', 'Yönetici Paneli', '2017-02-04 13:15:42'),
(3576, 'tr', 'common', 'Alexa Rank', 'Alexa Rank', '2017-02-04 13:15:42'),
(3577, 'tr', 'common', 'All', 'Hepsi', '2017-02-04 13:15:42'),
(3578, 'tr', 'common', 'Category', 'Kategori', '2017-02-04 13:15:42'),
(3579, 'tr', 'common', 'contact', 'İletişim', '2017-02-04 13:15:42'),
(3580, 'tr', 'common', 'copyright', 'Copyright © [year] www.seopanel.in Tüm Hakları Saklıdır. Türkçeleştiren Innova Think', '2017-02-04 13:15:42'),
(3581, 'tr', 'common', 'Country', 'Ülke', '2017-02-04 13:15:42'),
(3582, 'tr', 'common', 'Crawl Meta Data', 'Meta Tarama Verisi', '2017-02-04 13:15:42'),
(3583, 'tr', 'common', 'Date', 'Tarih', '2017-02-04 13:15:42'),
(3584, 'tr', 'common', 'Delete', 'Sil', '2017-02-04 13:15:42'),
(3585, 'tr', 'common', 'Details', 'Detay', '2017-02-04 13:15:42'),
(3586, 'tr', 'common', 'Directory', 'Dizin', '2017-02-04 13:15:42'),
(3587, 'tr', 'common', 'Donate', 'Bağış', '2017-02-04 13:15:42'),
(3588, 'tr', 'common', 'Edit', 'Düzenle', '2017-02-04 13:15:42'),
(3589, 'tr', 'common', 'Entry cannot be blank', 'Giriş boş olamaz', '2017-02-04 13:15:42'),
(3590, 'tr', 'common', 'entrynotvalid', 'Geçerli Bir giriş görünmüyor', '2017-02-04 13:15:42'),
(3591, 'tr', 'common', 'failed', 'hatalı', '2017-02-04 13:15:42'),
(3592, 'tr', 'common', 'forum', 'Forum', '2017-02-04 13:15:42'),
(3593, 'tr', 'common', 'Found', 'Bulundu', '2017-02-04 13:15:42'),
(3594, 'tr', 'common', 'Google Pagerank', 'Google Pagerank', '2017-02-04 13:15:42'),
(3595, 'tr', 'common', 'help', 'Yardım', '2017-02-04 13:15:42'),
(3596, 'tr', 'common', 'hidenews', 'Seo Panel haberlerini sakla', '2017-02-04 13:15:42'),
(3597, 'tr', 'common', 'Id', 'İD', '2017-02-04 13:15:42'),
(3598, 'tr', 'common', 'Inactivate', 'Etkin değil', '2017-02-04 13:15:42'),
(3599, 'tr', 'common', 'Inactive', 'Pasif', '2017-02-04 13:15:42'),
(3600, 'tr', 'common', 'Invalid characters', 'hatalı karakter', '2017-02-04 13:15:42'),
(3601, 'tr', 'common', 'Invalid code entered', 'hatalı kod girdiniz', '2017-02-04 13:15:42'),
(3602, 'tr', 'common', 'Invalid email address entered', 'hatalı mail adresi girdiniz', '2017-02-04 13:15:42'),
(3603, 'tr', 'common', 'Invalid value', 'Geçersiz değer', '2017-02-04 13:15:42'),
(3604, 'tr', 'common', 'Keyword', 'Kelime', '2017-02-04 13:15:42'),
(3605, 'tr', 'common', 'Keywords', 'Kelimeler', '2017-02-04 13:15:42'),
(3606, 'tr', 'common', 'lang', 'Dil', '2017-02-04 13:15:42'),
(3607, 'tr', 'common', 'My Account', 'Hesabım', '2017-02-04 13:15:42'),
(3608, 'tr', 'common', 'Name', 'Ad', '2017-02-04 13:15:42'),
(3609, 'tr', 'common', 'No', 'Hayır', '2017-02-04 13:15:42'),
(3610, 'tr', 'common', 'No Keywords Found', 'Anahtar Kelimeler Bulunamadı', '2017-02-04 13:15:42'),
(3611, 'tr', 'common', 'No Records Found', 'Kayıt Bulunamadı', '2017-02-04 13:15:42'),
(3612, 'tr', 'common', 'noactivetools', 'Aktif Seo Araçları Bulunamadı!', '2017-02-04 13:15:42'),
(3613, 'tr', 'common', 'nowebsites', 'Web Site Bulunamadı', '2017-02-04 13:15:42'),
(3614, 'tr', 'common', 'password632', 'Şifreniz 6 - 32 arasında bir uzunlukta olmalıdır', '2017-02-04 13:15:42'),
(3615, 'tr', 'common', 'passwordnotmatch', 'Şifreler eşleşmiyor', '2017-02-04 13:15:42'),
(3616, 'tr', 'common', 'Period', 'Dönem', '2017-02-04 13:15:42'),
(3617, 'tr', 'common', 'Priority', 'Öncelik', '2017-02-04 13:15:42'),
(3618, 'tr', 'common', 'Profile', 'Profil', '2017-02-04 13:15:42'),
(3619, 'tr', 'common', 'Rank', 'Rank', '2017-02-04 13:15:42'),
(3620, 'tr', 'common', 'Reports', 'Raporlar', '2017-02-04 13:15:42'),
(3621, 'tr', 'common', 'Results', 'Sonuçlar', '2017-02-04 13:15:42'),
(3622, 'tr', 'common', 'Search Engine', 'Arama Motoru', '2017-02-04 13:15:42'),
(3623, 'tr', 'common', 'Select', 'Seçiniz', '2017-02-04 13:15:42'),
(3624, 'tr', 'common', 'Seo Plugins', 'Seo Eklentileri', '2017-02-04 13:15:42'),
(3625, 'tr', 'common', 'Seo Tools', 'Seo Ayarları', '2017-02-04 13:15:42'),
(3626, 'tr', 'common', 'Sign out', 'Çıkış Yap', '2017-02-04 13:15:42'),
(3627, 'tr', 'common', 'Sign Up', 'Kaydol', '2017-02-04 13:15:42'),
(3628, 'tr', 'common', 'signin', 'Giriş Yap', '2017-02-04 13:15:42'),
(3629, 'tr', 'common', 'Status', 'Durum', '2017-02-04 13:15:42'),
(3630, 'tr', 'common', 'Support', 'Destek', '2017-02-04 13:15:42'),
(3631, 'tr', 'common', 'Total', 'Toplam', '2017-02-04 13:15:42'),
(3632, 'tr', 'common', 'Url', 'Url', '2017-02-04 13:15:42'),
(3633, 'tr', 'common', 'User', 'Üye', '2017-02-04 13:15:42'),
(3634, 'tr', 'common', 'User Panel', 'Üye Paneli', '2017-02-04 13:15:42'),
(3635, 'tr', 'common', 'Website', 'Web site', '2017-02-04 13:15:42'),
(3636, 'tr', 'common', 'Yes', 'Evet', '2017-02-04 13:15:42'),
(3637, 'tr', 'home', 'Account Summary', 'Hesap Özeti', '2017-02-04 21:23:57'),
(3638, 'tr', 'home', 'Backlinks', 'Backlinkler', '2017-02-04 21:23:57'),
(3639, 'tr', 'home', 'Directory Submission', 'Dizin Gönderme', '2017-02-04 21:23:57'),
(3640, 'tr', 'home', 'home_cont1', '<h1 style="text-align: center;margin-bottom: 30px;font-size: 19px;">Seo Panel''e Hoşgeldiniz - En çok\r\ntercih edilen bir çok sitenin seo paneli</h1>\r\n        <p>\r\n            sitenizin <b>arama motoru optimizasyonu</b> kontrolu için tamamen <b>açık kaynak kodlu seo</b>\r\n<b>kontrol paneli</b>\r\n\r\n            Seo Panel bir <b>seo aracıdır</b> ve sitenizin <b>hitini ve performansını arttırmak</b> için en son\r\n araçlara sahip.\r\n            <b>Ücretsiz</b> bir software ve <b>GNU GENERAL PUBLIC LICENSE</b>''a sahiptir.\r\n            Seo panelin ana özelliği <a href="<?=SP_PLUGINSITE?>" target="_blank">seo pluginler</a>\r\nkullanarak <b>genişletilebilirliği</b>\r\n.\r\n            Herkes kolayca kendi gerekli seo pluginleri <b>geliştirebilir ve yükleyebilir</b>. \r\n        </p>\r\n        <p></p>\r\n        <p>\r\n            Bu open source software <b>yayım tarihi Ocak 2010</b>.\r\n            Bu <b>kısa sürede binlerce webmaster</b> bu software''i kullanarak sitelerini optimize ediyor.\r\n            Bugün <b>tek bir platform</b> altında seo paneli kullanın.\r\n        </p>', '2017-02-04 21:23:57'),
(3641, 'tr', 'home', 'home_cont2', '<fieldset>\r\n<legend>Seo Panel Ana Özellikleri<?=SP_INSTALLED?></legend>\r\n<ul class="infobox">\r\n    <li>        \r\n        <h1>Automatik Directory Ekleme Aracı</h1>\r\n        <p>\r\n            Automatik directory ekleme aracı bize <b>sitelerimizi</b> ücretli ya da ücretsiz ana internet rehberlerine\r\neklememize yardımcı olur.\r\n            Hatta <b>statu kontrol script</b>i ile herbir rehbere ekli siteyi kontrol edebiliriz.\r\n            <b>Directory yöneticisi</b> aktif olsada olmasada bize bulmamızda yardımcı olur.\r\n        </p>\r\n    </li>\r\n    <li>        \r\n        <h1>Anahtar kelime (keyword) Pozisyon Kontrol</h1>\r\n        <p>\r\n            Anahtar kelime pozisyon kontrolu sayesinde sistemdeki sitenize ait <b>hedef kelimenin arama motorundaki pozisyonunu</b>\r\nkontrol edebilir ve kaydedebilirsiniz.\r\n            Anahtar kelime pozisyon bölümünde, ayrıntılı raporlar ile grafikli farklı arama motorlarındaki analizleri görebiliriz.\r\n        </p>\r\n    </li>\r\n    <li>        \r\n        <h1>Site Denetçisi</h1>\r\n        <p>Site Denetçisi bir siteye ait her bir sayfadaki <b>tüm seo faktörlerini denetlicek</b> ve hersayfa hakkında\r\n<b>detaylı rapor vericek</b>. Buda <b>XML,HTML,TEXT</b> arama motorlarına gönderilecek sitenizin sitemap dosyasını\r\noluşturmaya yardımcı olacak.</p>\r\n    </li>\r\n    <li>        \r\n        <h1>Google ve Alexa Rank Kontrol</h1>\r\n        <p>\r\n            Google ve alexa rank kontrolu websitenizin <b>google pagerank</b> ve <b>alexa rank</b>ini bulur\r\nve sistem içine <b>kayıt</b> eder.\r\n            <b>Rank raporları</b> bölümünde, <b>günlük</b> google ve alexa rank''lerini <b>detaylı raporlarla</b> görebiliriz.\r\n        </p>\r\n    </li>\r\n    <li>        \r\n        <h1>Backlink Kontrol</h1>\r\n        <p>\r\n            Backlinks Kontrol arama mototlarında (<b>google,yahoo,msn</b> etc) <b>backlinklerin sayısını</b> bulur ve sisteme kayıt eder.\r\n            <br><b>Backlink raporları</b> bölümünde, detaylı raporları ile birlikte herbir siteye ait <b>günlük backlink sayıları</b> bulunur.\r\n        </p>\r\n    </li>    \r\n    <li>        \r\n        <h1>Arama Motoru İndex Kontrol</h1>\r\n        <p>\r\n            Arama Motoru İndex Kontrol farklı arama motorlarına (<b>google,yahoo,msn</b> etc) ait <b>indexlenmiş\r\nsayfaların sayısını</b> gösteririr ve sisteme kaydeder.\r\n            <b>Arama Motoru İndex Kontrol raporları</b> böşümünde, detaylı raporları ile herbir siteye ait\r\n<b>günlük indexli sayfa sayısını</b>gösterir.\r\n        </p>\r\n    </li>\r\n    <li>        \r\n        <h1>Seo Panel Pluginleri</h1>\r\n        <p>\r\n            Seo Panalin <b>ana özelliği</b> <b>genişletilebilirliği</b>.\r\n            <b>Seo pluginleri</b>size gerekli olanlar çercevesinde özelliklerinizi geliştirmek için kendi panelinize eleyin.\r\n            <a href="<?=SP_PLUGINSITE?>" target="_blank">Seo panel pluginler</a> seo panel ve\r\nüçüncü parti yazılımları destekler.\r\n            Seo pluginleri seo panel için kolayca <b>geliştirebilirsiniz</b>.\r\n            Seo pluginleri seo panelinize <a href="<?=SP_PLUGINSITE?>" target="_blank">ekleyebilirsiniz</a> ve\r\nBiz gözden geçirme prosesinden sonra kendi sitemizde <b>yayınlarız</b>.\r\n        </p>\r\n    </li>\r\n    <li>        \r\n        <h1>Meta Tag Oluşturucu</h1>\r\n        <p>\r\n            Meta tag Oluşturucu sitemize meta tagler oluşturmak için bir <b>seo panel pluginidir</b>.\r\n            Arama motorlar <b>botları</b> sitemizi listelerken daha fazla bilgi alabilmeri için yardımcı olur.\r\n        </p>\r\n    </li>\r\n</ul>\r\n</fieldset>', '2017-02-04 21:23:57'),
(3642, 'tr', 'home', 'home_cont3', '<fieldset>\r\n<legend>Seo Panel Online Kaynaklar</legend>    \r\n<ul class="infobox">\r\n\r\n    <li>\r\n        <h1>Seo Panel Online Kaynaklar</h1>                \r\n        \r\n        \r\n        <p>\r\n            <a href="http://www.seopanel.in" target="_blank">Seo Panel Resmi Site</a>\r\n        </p>\r\n        <p>\r\n            <a href="<?=SP_DOWNLOAD_LINK?>" target="_blank">Seo Panel İndir</a>\r\n        </p>\r\n        \r\n        <p>\r\n            <a href="<?=SP_DEMO_LINK?>" target="_blank">Seo Panel Demo</a>\r\n        </p>\r\n        \r\n        <p>\r\n            <a href="<?=SP_CONTACT_LINK?>" target="_blank">Seo Panel İletişim</a>\r\n        </p>\r\n        \r\n        <p>\r\n            <a href="<?=SP_HELP_LINK?>" target="_blank">Seo Panel Yardım</a>\r\n        </p>\r\n        \r\n        <p>\r\n            <a href="<?=SP_FORUM_LINK?>" target="_blank">Seo Panel Forum</a>\r\n        </p>\r\n        \r\n        <p>\r\n            <a href="<?=SP_SUPPORT_LINK?>" target="_blank">Seo Panel Destek Sistemi</a>\r\n        </p>\r\n        \r\n        <p>\r\n            <a href="<?=SP_DONATE_LINK?>" target="_blank">Seo Panel''e Bağış Yap</a>\r\n        </p>\r\n    </li>\r\n    \r\n</ul>\r\n</fieldset>', '2017-02-04 21:23:57'),
(3643, 'tr', 'home', 'Pages Indexed', 'Sayfaları İndeklendi', '2017-02-04 21:23:57'),
(3644, 'tr', 'home', 'Ranks', 'Ranklar', '2017-02-04 21:23:57'),
(3645, 'tr', 'home', 'SiteNameUrl', 'Site Adı/URL', '2017-02-04 21:23:57'),
(3646, 'tr', 'home', 'Website Statistics', 'Website İstatistikleri', '2017-02-04 21:23:57'),
(3647, 'tr', 'keyword', 'Crawling keyword', 'Kelimeler Taranıyor', '2017-02-04 20:48:33'),
(3648, 'tr', 'keyword', 'Detailed Keyword Position Reports', 'Ayrıntılı Anahtar Kelime Konumu Raporlar', '2017-02-04 20:48:33'),
(3649, 'tr', 'keyword', 'Edit Keyword', 'Anahtar kelime düzenle', '2017-02-04 20:48:33'),
(3650, 'tr', 'keyword', 'Graphical Keyword Position Reports', 'Grafik Anahtar Kelime Konumu Raporları', '2017-02-04 20:48:33'),
(3651, 'tr', 'keyword', 'Import Keywords', 'Anahtar Kelimeleri içe aktar', '2017-02-04 20:48:33'),
(3652, 'tr', 'keyword', 'Keyword already exist', 'Anahtar kelime zaten mevcut\r\n', '2017-02-04 20:48:33'),
(3653, 'tr', 'keyword', 'Keyword Position Report', 'Anahtar kelime pozisyon Raporu', '2017-02-04 20:48:33'),
(3654, 'tr', 'keyword', 'New Keyword', 'Yeni Kelimeler', '2017-02-04 20:48:33'),
(3655, 'tr', 'keyword', 'not assigned to required search engines', 'gerekli arama motorlarına atanmamış', '2017-02-04 20:48:33'),
(3656, 'tr', 'keyword', 'pleaseselecttool', 'en az bir Seo Araçları seçiniz\r\n', '2017-02-04 20:48:33'),
(3657, 'tr', 'keyword', 'Quick Keyword Position Checker', 'Hızlı Anahtar Kelime Konumu kontrolü', '2017-02-04 20:48:33'),
(3658, 'tr', 'keyword', 'results from ', 'sonuçlar', '2017-02-04 20:48:33'),
(3659, 'tr', 'keyword', 'Show All results', 'Tüm sonuçları göster\r\n', '2017-02-04 20:48:33'),
(3660, 'tr', 'keyword', 'Successfully crawled keyword', 'Başarılı bir anahtar kelime taraması', '2017-02-04 20:48:33'),
(3661, 'tr', 'keyword', 'to create new keywords', 'yeni anahtar kelimeler oluşturmak', '2017-02-04 20:48:33'),
(3662, 'tr', 'label', 'already exist', 'zaten var', '2012-11-11 08:14:34'),
(3663, 'tr', 'label', 'Authentication', 'Kimlik doğrulama', '2012-11-11 08:14:34'),
(3664, 'tr', 'label', 'Author', 'Yazar', '2012-11-11 08:14:34'),
(3665, 'tr', 'label', 'Click Here', 'Tıklayın', '2012-11-11 08:14:34'),
(3666, 'tr', 'label', 'Cron', 'Cron', '2012-11-11 08:14:34'),
(3667, 'tr', 'label', 'Description', 'Açıklama', '2012-11-11 08:14:34'),
(3668, 'tr', 'label', 'Developers', 'Geliştiriciler', '2012-11-11 08:14:34'),
(3669, 'tr', 'label', 'Download', 'İndir', '2012-11-11 08:14:34'),
(3670, 'tr', 'label', 'Installation', 'Yükleme', '2012-11-11 08:14:34'),
(3671, 'tr', 'label', 'Keywords', 'Anahtar kelimeler\r\n', '2012-11-11 08:14:34'),
(3672, 'tr', 'label', 'noactiveplugins', 'Hiçbir Aktif Seo Eklentiler Bulunamadı!', '2012-11-11 08:14:34'),
(3673, 'tr', 'label', 'Plugin', 'Eklenti', '2012-11-11 08:14:34'),
(3674, 'tr', 'label', 'Port', 'Port', '2012-11-11 08:14:34'),
(3675, 'tr', 'label', 'Proxy', 'Proxy', '2012-11-11 08:14:34'),
(3676, 'tr', 'label', 'Re-install', 'Yeniden yüklemek\r\n', '2012-11-11 08:14:34'),
(3677, 'tr', 'label', 'Sponsors', 'Sponsorlar', '2012-11-11 08:14:34'),
(3678, 'tr', 'label', 'Title', 'Başlık', '2012-11-11 08:14:34'),
(3679, 'tr', 'label', 'translation by', 'Çeviren', '2012-11-11 08:14:34'),
(3680, 'tr', 'label', 'Translators', 'Çevirmenler', '2012-11-11 08:14:34'),
(3681, 'tr', 'label', 'Upgrade', 'Yükselt', '2012-11-11 08:14:34'),
(3682, 'tr', 'label', 'Version', 'Versiyon', '2012-11-11 08:14:34');
INSERT INTO `texts` (`id`, `lang_code`, `category`, `label`, `content`, `changed`) VALUES
(3683, 'tr', 'label', 'wantproceed', 'Devam etmek istiyor musunuz?', '2012-11-11 08:14:34'),
(3684, 'tr', 'login', 'Confirm Password', 'Şifreyi Onayla', '2017-02-04 20:55:53'),
(3685, 'tr', 'login', 'Create my account', 'Hesabımı oluştur', '2017-02-04 20:55:53'),
(3686, 'tr', 'login', 'Create New Account', 'Yeni Hesap Oluştur', '2017-02-04 20:55:53'),
(3687, 'tr', 'login', 'Email', 'E-posta', '2017-02-04 20:55:53'),
(3688, 'tr', 'login', 'emailexist', 'E-posta zaten var!', '2017-02-04 20:55:53'),
(3689, 'tr', 'login', 'Enter the code as it is shown', 'Görünen kodu giriniz', '2017-02-04 20:55:53'),
(3690, 'tr', 'login', 'First Name', 'Ad', '2017-02-04 20:55:53'),
(3691, 'tr', 'login', 'Last Name', 'Soyad', '2017-02-04 20:55:53'),
(3692, 'tr', 'login', 'Login', 'Giriş', '2017-02-04 20:55:53'),
(3693, 'tr', 'login', 'Login incorrect', 'Giriş yanlış\r\n', '2017-02-04 20:55:53'),
(3694, 'tr', 'login', 'newaccountsuccess', 'Yeni hesap başarıyla oluşturuldu!\r\n', '2017-02-04 20:55:53'),
(3695, 'tr', 'login', 'Password', 'Şifre', '2017-02-04 20:55:53'),
(3696, 'tr', 'login', 'Password incorrect', 'Şifre yanlış', '2017-02-04 20:55:53'),
(3697, 'tr', 'login', 'Register', 'Kayıt ol', '2017-02-04 20:55:53'),
(3698, 'tr', 'login', 'Sign in to your account', 'Hesabınızda oturum açın', '2017-02-04 20:55:53'),
(3699, 'tr', 'login', 'User inactive', 'Kullanıcı inaktif', '2017-02-04 20:55:53'),
(3700, 'tr', 'login', 'Username', 'Kullanıcı adı', '2017-02-04 20:55:53'),
(3701, 'tr', 'login', 'usernameexist', 'Kullanıcı adı zaten var!', '2017-02-04 20:55:53'),
(3702, 'tr', 'panel', 'About Us', 'Hakkımızda', '2017-02-04 20:50:50'),
(3703, 'tr', 'panel', 'Add following command to your cron tab', 'cron sekmesine aşağıdaki komutu ekleyin', '2017-02-04 20:50:50'),
(3704, 'tr', 'panel', 'alsocheckfollowlink', 'Daha fazla bilgi gerekiyorsa aşağıdaki linki kontrol edin.', '2017-02-04 20:50:50'),
(3705, 'tr', 'panel', 'Check Directory', 'Dizin Kontrolü', '2017-02-04 20:50:50'),
(3706, 'tr', 'panel', 'Cron Command', 'Cron Komut', '2017-02-04 20:50:50'),
(3707, 'tr', 'panel', 'Directory Manager', 'Dizin Yöneticisi', '2017-02-04 20:50:50'),
(3708, 'tr', 'panel', 'Edit My Profile', 'Profilimi Düzenle', '2017-02-04 20:50:50'),
(3709, 'tr', 'panel', 'My Profile', 'Profilim', '2017-02-04 20:50:50'),
(3710, 'tr', 'panel', 'New Proxy', 'Yeni Proxy', '2017-02-04 20:50:50'),
(3711, 'tr', 'panel', 'New User', 'Yeni Üye', '2017-02-04 20:50:50'),
(3712, 'tr', 'panel', 'New Website', 'Yeni Web Site', '2017-02-04 20:50:50'),
(3713, 'tr', 'panel', 'Proxy Manager', 'Proxy Yöneticisi', '2017-02-04 20:50:50'),
(3714, 'tr', 'panel', 'Report Generation Manager', 'Rapor Üretim Yöneticisi', '2017-02-04 20:50:50'),
(3715, 'tr', 'panel', 'Reports Manager', 'Rapor Yöneticisi', '2017-02-04 20:50:50'),
(3716, 'tr', 'panel', 'Seo Plugins Manager', 'Seo Araçları Yöneticisi', '2017-02-04 20:50:50'),
(3717, 'tr', 'panel', 'Seo Tools Manager', 'Seo Araçlar Yöneticisi', '2017-02-04 20:50:50'),
(3718, 'tr', 'panel', 'System Settings', 'Sistem Ayarları', '2017-02-04 20:50:50'),
(3719, 'tr', 'panel', 'User Manager', 'Kullanıcı Yöneticisi', '2017-02-04 20:50:50'),
(3720, 'tr', 'panel', 'Website Manager', 'Web Site Yöneticisi', '2017-02-04 20:50:50'),
(3721, 'tr', 'plugin', 'Edit Seo Plugin', 'Seo Eklentisini Düzenle', '2012-11-11 08:16:59'),
(3722, 'tr', 'plugin', 'Plugin Name', 'Eklenti Adı', '2012-11-11 08:16:59'),
(3723, 'tr', 'plugin', 'Seo Plugin Details', 'Seo Eklenti Detayları', '2012-11-11 08:16:59'),
(3724, 'tr', 'proxy', 'Edit Proxy', 'Proxyi Düzenle', '2010-11-23 11:31:24'),
(3725, 'tr', 'proxy', 'Proxy Password', 'Proxy Şifresi', '2010-11-23 11:31:24'),
(3726, 'tr', 'proxy', 'Proxy Username', 'Proxy Kullanıcı adı', '2010-11-23 11:31:24'),
(3727, 'tr', 'proxy', 'Proxyalreadyexist', 'Proxy zaten mevcut!', '2010-11-23 11:31:24'),
(3728, 'tr', 'rank', 'enterurlproceed', 'Google ve Alexa rank sonuçlarını görmek için bir web sitesi seçin ve <b>Devam</b> tıklayınız.', '2010-11-24 04:38:45'),
(3729, 'tr', 'rank', 'Google and Alexa Rank Reports', 'Google and Alexa Rank Raporları', '2010-11-24 04:38:45'),
(3730, 'tr', 'rank', 'Saved rank results of', 'Rank Sonuçlaro Kaydedildi', '2010-11-24 04:38:45'),
(3731, 'tr', 'directory', 'Add back to directory list', 'dizin listesine geri ekle', '2012-11-11 08:13:26'),
(3732, 'tr', 'directory', 'Approved', 'Onaylı', '2012-11-11 08:13:26'),
(3733, 'tr', 'directory', 'Captcha', 'Resim', '2012-11-11 08:13:26'),
(3734, 'tr', 'directory', 'categorynote', 'Kategoriler, öncelik göre virgülle birbirinden ayırın. Öncelikli kategori ile başlayın.', '2012-11-11 08:13:26'),
(3735, 'tr', 'directory', 'Check Directory Status', 'Dizin Durumu kontrolü', '2012-11-11 08:13:26'),
(3736, 'tr', 'directory', 'Check Directory Submission Status', 'Dizin Gönderme Durumu Kontrolü', '2012-11-11 08:13:26'),
(3737, 'tr', 'directory', 'clicktoproceeddirsts', 'Dizin durum kontrol durumunu için  <b>Devam</b> Tıklayınız', '2012-11-11 08:13:26'),
(3738, 'tr', 'directory', 'Confirmation', 'Onay', '2012-11-11 08:13:26'),
(3739, 'tr', 'directory', 'desnote', 'Bazı dizinleri açıklama alanı için en az 150 karakter gerektirir.', '2012-11-11 08:13:26'),
(3740, 'tr', 'directory', 'Directories with out captcha', 'Dizinlerin resim çıkışı', '2012-11-11 08:13:26'),
(3741, 'tr', 'directory', 'Directory Submission Reports', 'Dizin Gönderme Raporları', '2012-11-11 08:13:26'),
(3742, 'tr', 'directory', 'Enter the code shown', 'Güvenlik kodunu giriniz', '2012-11-11 08:13:26'),
(3743, 'tr', 'directory', 'nocatnote', 'Lütfen <b>Yeniden Yükle</b> veya <b>Geç</b>', '2012-11-11 08:13:26'),
(3744, 'tr', 'directory', 'nodirnote', 'Hiçbir <b> Etkin </ b> Dizin Bulunamadı', '2012-11-11 08:13:26'),
(3745, 'tr', 'directory', 'nosuccessnote', 'Başarılı mesaj alamıyorsan, posta kutunuzu kontrol ediniz.', '2012-11-11 08:13:26'),
(3746, 'tr', 'directory', 'optionalnote', 'Isteğe bağlı başlıkları ve açıklamaları daha iyi sonuçlar için rasgele başlık ve dizinlere açıklama gönder.', '2012-11-11 08:13:26'),
(3747, 'tr', 'directory', 'Owner Email', 'E-posta sahibi', '2012-11-11 08:13:26'),
(3748, 'tr', 'directory', 'Owner Name', 'İsmin Sahibi', '2012-11-11 08:13:26'),
(3749, 'tr', 'directory', 'Pending', 'Beklemede', '2012-11-11 08:13:26'),
(3750, 'tr', 'directory', 'Please select a website to proceed', 'Devam etmek için bir web sitesi seçiniz', '2012-11-11 08:13:26'),
(3751, 'tr', 'directory', 'selectwebsiteproceed', 'Dizin onay kontrolü için Bir <b>Website</b seçin ve sonra <b>Devam</b> tıklayın.', '2012-11-11 08:13:26'),
(3752, 'tr', 'directory', 'selectwebsiteschecksub', '<b>Devam</b> Dizin listesi sunulması için bir <b>Website</b> seçin.', '2012-11-11 08:13:26'),
(3753, 'tr', 'directory', 'Semi Automatic Directory Submission Tool', 'Yarı Otomatik Dizin Gönderme Aracı', '2012-11-11 08:13:26'),
(3754, 'tr', 'directory', 'spamemailnote', 'Bazı dizinleri spam gönderebilir, biz birincil e-posta adresinizi kullanmanızı tavsiye etmiyoruz.', '2012-11-11 08:13:26'),
(3755, 'tr', 'directory', 'Submission Details', 'Teslim Detayları', '2012-11-11 08:13:26'),
(3756, 'tr', 'directory', 'Submit Description', 'Açıklamasını gönderin', '2012-11-11 08:13:26'),
(3757, 'tr', 'directory', 'Submit Keywords', 'Anahtar kelimeleri bul', '2012-11-11 08:13:26'),
(3758, 'tr', 'directory', 'Submit Title', 'Başlık Gönder', '2012-11-11 08:13:26'),
(3759, 'tr', 'directory', 'Website Category', 'Website Kategori', '2012-11-11 08:13:26'),
(3760, 'tr', 'directory', 'Website Url', 'Website Url ', '2012-11-11 08:13:26'),
(3761, 'tr', 'saturation', 'clickproceedsaturation', 'Arama motoru Doygunluk Sonuçları kontrol için bir URL gir ve <b>Devam</b> tıklyınız.', '2010-11-24 04:43:51'),
(3762, 'tr', 'saturation', 'GenerateSaturationReports', 'Arama Motoru Doygunluk Raporları üret', '2010-11-24 04:43:51'),
(3763, 'tr', 'saturation', 'Quick Search Engine Saturation Checker', 'Hızlı Arama Motoru Doygunluk Denetleyicisi', '2010-11-24 04:43:51'),
(3764, 'tr', 'saturation', 'Saved Search Engine Saturation results of', 'Kaydedilmiş Arama Motoru Doygunluk sonuçları', '2010-11-24 04:43:51'),
(3765, 'tr', 'saturation', 'Search Engine Saturation Reports', 'Arama motoru Doygunluk Raporları', '2010-11-24 04:43:51'),
(3766, 'fa', 'website', 'Edit Website', 'ویرایش سایت ', '2010-12-02 05:01:43'),
(3767, 'fa', 'website', 'plscrtwebsite', 'لطفا قبل از شروع استفاده از ابزار ها و افزونه های سئو یک وب سایت ایجاد کنید ', '2010-12-02 05:01:43'),
(3768, 'fa', 'website', 'Website already exist', 'هم اکنون وب سایت موجود است ', '2010-12-02 05:01:43'),
(3769, 'fa', 'website', 'yourwebalreday', 'وب سایت هایی که تا به حال ساخته ایید', '2010-12-02 05:01:43'),
(3770, 'fa', 'user', 'Edit User', 'ویرایش اطلاعات کاربر ', '2010-12-02 01:44:32'),
(3771, 'fa', 'user', 'Saved My Profile Details', 'جزیات نمایه من را ذخیره کن', '2010-12-02 01:44:32'),
(3772, 'fa', 'proxy', 'Edit Proxy', 'ویرایش پروکسی', '2010-12-02 02:34:16'),
(3773, 'fa', 'proxy', 'Proxy Password', 'رمز عبور پروکسی', '2010-12-02 02:34:17'),
(3774, 'fa', 'proxy', 'Proxy Username', 'نام کاربری پروکسی', '2010-12-02 02:34:17'),
(3775, 'fa', 'proxy', 'Proxyalreadyexist', 'هم اکنون پروکسی موجود است', '2010-12-02 02:34:17'),
(3776, 'fa', 'label', 'already exist', 'هم اکنون موجود است ', '2012-05-12 21:14:56'),
(3777, 'fa', 'label', 'Authentication', 'تصدیق نامه', '2012-05-12 21:14:56'),
(3778, 'fa', 'label', 'Author', 'نویسنده', '2012-05-12 21:14:56'),
(3779, 'fa', 'label', 'Click Here', 'اینجا را فشار دهید ', '2012-05-12 21:14:56'),
(3780, 'fa', 'label', 'Cron', 'کرون', '2012-05-12 21:14:56'),
(3781, 'fa', 'label', 'Description', 'توضیحات', '2012-05-12 21:14:56'),
(3782, 'fa', 'label', 'Developers', 'توسعه دهندگان ', '2012-05-12 21:14:56'),
(3783, 'fa', 'label', 'Download', 'بارگیری ها ', '2012-05-12 21:14:56'),
(3784, 'fa', 'label', 'Installation', 'نصب', '2012-05-12 21:14:56'),
(3785, 'fa', 'label', 'Keywords', 'کلمات کلیدی', '2012-05-12 21:14:56'),
(3786, 'fa', 'label', 'noactiveplugins', 'هیچ افزونه ی فعالی پیدانشد', '2012-05-12 21:14:56'),
(3787, 'fa', 'label', 'Plugin', 'افزونه', '2012-05-12 21:14:56'),
(3788, 'fa', 'label', 'Port', 'درگاه', '2012-05-12 21:14:56'),
(3789, 'fa', 'label', 'Proxy', 'پروکسی', '2012-05-12 21:14:56'),
(3790, 'fa', 'label', 'Re-install', 'نصب دوباره', '2012-05-12 21:14:56'),
(3791, 'fa', 'label', 'Sponsors', 'حامیان', '2012-05-12 21:14:56'),
(3792, 'fa', 'label', 'Title', 'عنوان', '2012-05-12 21:14:56'),
(3793, 'fa', 'label', 'translation by', 'ترجمه شده توسط', '2012-05-12 21:14:56'),
(3794, 'fa', 'label', 'Translators', 'مترجم', '2012-05-12 21:14:56'),
(3795, 'fa', 'label', 'Upgrade', 'ارتقا', '2012-05-12 21:14:56'),
(3796, 'fa', 'label', 'Version', 'نسخه', '2012-05-12 21:14:56'),
(3797, 'fa', 'label', 'wantproceed', 'آیا واقعا می خواهید ادامه بدهید؟', '2012-05-12 21:14:56'),
(3798, 'fa', 'login', 'Confirm Password', 'تکرار رمز عبور', '2010-12-02 02:51:12'),
(3799, 'fa', 'login', 'Create my account', 'حساب کاربری مرا بساز', '2010-12-02 02:51:12'),
(3800, 'fa', 'login', 'Create New Account', 'ایجاد حساب کاربری جدید', '2010-12-02 02:51:12'),
(3801, 'fa', 'login', 'Email', 'پست الکترونیک', '2010-12-02 02:51:12'),
(3802, 'fa', 'login', 'emailexist', 'این آدرس الکترونیک تکراری است', '2010-12-02 02:51:12'),
(3803, 'fa', 'login', 'Enter the code as it is shown', 'کد نمایش داده شده را وارد کنید ', '2010-12-02 02:51:12'),
(3804, 'fa', 'login', 'First Name', 'اسم کوجک', '2010-12-02 02:51:12'),
(3805, 'fa', 'login', 'Last Name', 'نام خانوادگی', '2010-12-02 02:51:12'),
(3806, 'fa', 'login', 'Login', 'ورود', '2010-12-02 02:51:12'),
(3807, 'fa', 'login', 'Login incorrect', 'ورود اشتباه', '2010-12-02 02:51:12'),
(3808, 'fa', 'login', 'newaccountsuccess', 'حساب کاربری جدید با موفقیت ساخته شد', '2010-12-02 02:51:12'),
(3809, 'fa', 'login', 'Password', 'رمز عبور', '2010-12-02 02:51:12'),
(3810, 'fa', 'login', 'Password incorrect', 'رمز عبور اشتباه است ', '2010-12-02 02:51:12'),
(3811, 'fa', 'login', 'Register', 'ثبت نام کردن', '2010-12-02 02:51:12'),
(3812, 'fa', 'login', 'Sign in to your account', 'ورود به حساب کاربری', '2010-12-02 02:51:12'),
(3813, 'fa', 'login', 'User inactive', 'کاربر غیر فعال', '2010-12-02 02:51:12'),
(3814, 'fa', 'login', 'Username', 'نام کاربری', '2010-12-02 02:51:12'),
(3815, 'fa', 'login', 'usernameexist', 'این نام کاربری تکراری است ', '2010-12-02 02:51:12'),
(3816, 'fa', 'panel', 'About Us', 'درباره ما ', '2012-05-16 19:23:21'),
(3817, 'fa', 'panel', 'Add following command to your cron tab', 'دستورات زیر را به تب کرون خود اضافه کنید ', '2012-05-16 19:23:21'),
(3818, 'fa', 'panel', 'alsocheckfollowlink', 'همچنین اگر شما به اطلاعات بیشتری نیاز دارید پیوندهای زیر را بررسی کنید ', '2012-05-16 19:23:21'),
(3819, 'fa', 'panel', 'Check Directory', 'بررسی دایرکتوری', '2012-05-16 19:23:21'),
(3820, 'fa', 'panel', 'Cron Command', 'دستورات کرون', '2012-05-16 19:23:21'),
(3821, 'fa', 'panel', 'Directory Manager', 'مدیریت فهرست ها ', '2012-05-16 19:23:21'),
(3822, 'fa', 'panel', 'Edit My Profile', 'ویرایش نمایه من', '2012-05-16 19:23:21'),
(3823, 'fa', 'panel', 'My Profile', 'نمایه من ', '2012-05-16 19:23:21'),
(3824, 'fa', 'panel', 'New Proxy', 'ایجاد پروکسی جدید', '2012-05-16 19:23:21'),
(3825, 'fa', 'panel', 'New User', ' ایجاد کابر جدید', '2012-05-16 19:23:21'),
(3826, 'fa', 'panel', 'New Website', 'ایجاد یک وب سایت جدید', '2012-05-16 19:23:21'),
(3827, 'fa', 'panel', 'Proxy Manager', 'مدیریت پروکسی', '2012-05-16 19:23:21'),
(3828, 'fa', 'panel', 'Report Generation Manager', 'مدیریت تولید گزارشات', '2012-05-16 19:23:21'),
(3829, 'fa', 'panel', 'Reports Manager', 'مدیریت گزارشات', '2012-05-16 19:23:21'),
(3830, 'fa', 'panel', 'Seo Plugins Manager', 'مدیریت افزونه های سئو', '2012-05-16 19:23:21'),
(3831, 'fa', 'panel', 'Seo Tools Manager', 'مدیریت ابزار سئو', '2012-05-16 19:23:21'),
(3832, 'fa', 'panel', 'System Settings', 'تنظیمات سیستم', '2012-05-16 19:23:21'),
(3833, 'fa', 'panel', 'User Manager', 'مدیریت کاربران ', '2012-05-16 19:23:21'),
(3834, 'fa', 'panel', 'Website Manager', 'مدیریت وب سایت ها ', '2012-05-16 19:23:21'),
(3835, 'fa', 'rank', 'enterurlproceed', '  کلیک کنید </b> ادامه <b> بر روی </b> در هر خط <b> برای دیدن رتبه در گوگل والکسا   \r\n ', '2010-12-03 03:30:18'),
(3836, 'fa', 'rank', 'Google and Alexa Rank Reports', 'گزارش رتبه های گوگل و الکسا', '2010-12-03 03:30:18'),
(3837, 'fa', 'rank', 'Saved rank results of', 'ذخیره کن رتبه های نتایج را ', '2010-12-03 03:30:18'),
(3838, 'fa', 'plugin', 'Edit Seo Plugin', 'ویرایش افزونه های سئو', '2012-03-08 09:22:34'),
(3839, 'fa', 'plugin', 'Plugin Name', 'نام افزونه ها', '2012-03-08 09:22:34'),
(3840, 'fa', 'plugin', 'Seo Plugin Details', 'جزیات افزونه سئو', '2012-03-08 09:22:34'),
(3841, 'fa', 'keyword', 'Crawling keyword', 'کلمان کلیدی خزنده', '2011-07-13 01:19:39'),
(3842, 'fa', 'keyword', 'Detailed Keyword Position Reports', 'جزیات گزارش وضعیت  کلمه کلیدی ', '2011-07-13 01:19:39'),
(3843, 'fa', 'keyword', 'Edit Keyword', 'ویرایش کلمات کلیدی', '2011-07-13 01:19:39'),
(3844, 'fa', 'keyword', 'Graphical Keyword Position Reports', 'گزارشات تصویری وضعیت کلمه کلیدی', '2011-07-13 01:19:39'),
(3845, 'fa', 'keyword', 'Import Keywords', 'وارد کردن کلمات کلیدی ', '2011-07-13 01:19:39'),
(3846, 'fa', 'keyword', 'Keyword already exist', 'کلمه کلیدی هم اکنون موجود است ', '2011-07-13 01:19:39'),
(3847, 'fa', 'keyword', 'Keyword Position Report', 'گزارش وضیعت کلمه کلیدی', '2011-07-13 01:19:39'),
(3848, 'fa', 'keyword', 'New Keyword', 'کلمه کلیدی جدید', '2011-07-13 01:19:39'),
(3849, 'fa', 'keyword', 'not assigned to required search engines', 'هیچ نیاز مندی به موتور جست و جو اختصاص داده نشده ', '2011-07-13 01:19:39'),
(3850, 'fa', 'keyword', 'pleaseselecttool', 'لطفا حداقل یک ابزار سئو را انتخاب کنید ', '2011-07-13 01:19:39'),
(3851, 'fa', 'keyword', 'Quick Keyword Position Checker', 'چک کردن سریع وضیعت کلمه کلیدی', '2011-07-13 01:19:39'),
(3852, 'fa', 'keyword', 'results from ', 'نتایج از ', '2011-07-13 01:19:39'),
(3853, 'fa', 'keyword', 'Show All results', 'نمایش تمام نتایج', '2011-07-13 01:19:39'),
(3854, 'fa', 'keyword', 'Successfully crawled keyword', 'کلمه کلیدی با موفقیت خزانده شد ', '2011-07-13 01:19:39'),
(3855, 'fa', 'keyword', 'to create new keywords', 'ایجاد کلمات کلیدی  جدید', '2011-07-13 01:19:39'),
(3856, 'fa', 'sitemap', 'Change frequency', 'عوض کردن تعداد تکرار', '2010-12-02 05:37:19'),
(3857, 'fa', 'sitemap', 'clickproceedsitemap', '<b> ادامه </b>روی گزینه \r\n کلیک کنید تا نقشه سایت ساخته شود', '2010-12-02 05:37:19'),
(3858, 'fa', 'sitemap', 'Download sitemap file from', 'بارگیری کن نقشه سایت را از ', '2010-12-02 05:37:19'),
(3859, 'fa', 'sitemap', 'Exclude Url', 'آدرس های مستثنی', '2010-12-02 05:37:19'),
(3860, 'fa', 'sitemap', 'processtaketime', 'این فرایند با توجه به تعداد لینک های درونی سایت شما طول حواهد کشید .\r\nلطفا صبر کنید تا نقشه سایت را دریافت کنید', '2010-12-02 05:37:19'),
(3861, 'fa', 'sitemap', 'Sitemap Type', 'نوع نقشه سایت ', '2010-12-02 05:37:19'),
(3862, 'fa', 'settings', 'Click here to become a sponsor for Seo Panel', '<b>صد دلار</b> پرداخت کنيد و <b>اسپانسر</b> سئوپنل شويد.', '2012-05-16 20:03:34'),
(3863, 'fa', 'settings', 'seopanel_description', 'یک کنترل پنل کاملا رایگان برای مدیریت بهینه سازی سایت هایتان در مورتورهای جستجو.این کنترل پنل شامل بسیاری از ابزارهای مفید سئو بریا عملکرد سایت شما می باشد.این برنامه متن باز می باد و شما می توانید افزونه های مورد نیاز خودتان برای سئوپنل را توسعه دهید.', '2012-05-16 20:03:34'),
(3864, 'fa', 'settings', 'seopanel_title', 'سئوپنل: اولین کنترل پنل سئو متن باز در جهان برای مدیریت چندین سایت', '2012-05-16 20:03:34'),
(3865, 'fa', 'settings', 'SP_CRAWL_DELAY', 'تاخیر بین هر خزیدن عنکبوت ( بر اساس ثانیه ) ', '2012-05-16 20:03:34'),
(3866, 'fa', 'settings', 'SP_DEFAULTLANG', 'زیان پیش فرض ', '2012-05-16 20:03:34'),
(3867, 'fa', 'settings', 'SP_DESCRIPTION', 'توضحات پنل سئو', '2012-05-16 20:03:34'),
(3868, 'fa', 'settings', 'SP_ENABLE_PROXY', 'فعال سازی پروکسی', '2012-05-16 20:03:34'),
(3869, 'fa', 'settings', 'SP_HOTLINKING', 'فعال سازی حفاطت از عکس های هات لینک', '2012-05-16 20:03:34'),
(3870, 'fa', 'settings', 'SP_KEYWORDS', 'کلید واژه های پنل سئو', '2012-05-16 20:03:34'),
(3871, 'fa', 'settings', 'SP_PAGINGNO', 'تعداد ورودی های هر صفحه ', '2012-05-16 20:03:34'),
(3872, 'fa', 'settings', 'SP_TITLE', 'عنوان پنل سئو ', '2012-05-16 20:03:34'),
(3873, 'fa', 'settings', 'SP_USER_AGENT', 'عامل کاربر', '2012-05-16 20:03:34'),
(3874, 'fa', 'settings', 'SP_USER_GEN_REPORT', 'اجازه دادن به کاربران برای تولید گزارشات ', '2012-05-16 20:03:34'),
(3875, 'fa', 'settings', 'SP_USER_REGISTRATION', 'رابط کاربری ثبت نام ', '2012-05-16 20:03:34'),
(3876, 'fa', 'settings', 'syssettingssaved', 'تنظیمات سیستم با موفقیت ذخیره شد', '2012-05-16 20:03:34'),
(3877, 'fa', 'seotools', 'Automatic Submission', 'توابع خودکار ', '2011-07-13 01:25:14'),
(3878, 'fa', 'seotools', 'backlink-checker', 'چک کننده لیتک دهنده ها ', '2011-07-13 01:25:14'),
(3879, 'fa', 'seotools', 'Backlinks Reports', 'گزارشات لینک دهنده ها ', '2011-07-13 01:25:14'),
(3880, 'fa', 'seotools', 'Check Submission Status', 'بررسی کن وضیعت تابع را', '2011-07-13 01:25:14'),
(3881, 'fa', 'seotools', 'clickgeneratereports', ' کلیک کنید </b> ادامه  <b>    برای تولید گزارشات بر روی ', '2011-07-13 01:25:14'),
(3882, 'fa', 'seotools', 'Detailed Position Reports', 'جزیات گزارشات وضعیت ', '2011-07-13 01:25:14'),
(3883, 'fa', 'seotools', 'directory-submission', 'مسیر های تابع ', '2011-07-13 01:25:14'),
(3884, 'fa', 'seotools', 'Featured Submission', 'ویژگی های تابع ', '2011-07-13 01:25:14'),
(3885, 'fa', 'seotools', 'Generate Backlinks Reports', 'گزارشات مولد لینک دهنده ها ', '2011-07-13 01:25:14'),
(3886, 'fa', 'seotools', 'Generate Keyword Reports', 'گزارشات مولد کلید واژه  ', '2011-07-13 01:25:14'),
(3887, 'fa', 'seotools', 'Generate Rank Reports', 'مولد گزارشات رتبه ', '2011-07-13 01:25:14'),
(3888, 'fa', 'seotools', 'Generate Saturation Reports', 'مولد گزارشات اشباع ', '2011-07-13 01:25:14'),
(3889, 'fa', 'seotools', 'Google Sitemap Generator', 'مولد نقشه سایت گوگل', '2011-07-13 01:25:14'),
(3890, 'fa', 'seotools', 'Graphical Position Reports', 'گزارشات تصویری وضعیت ', '2011-07-13 01:25:14'),
(3891, 'fa', 'seotools', 'Keyword Position Summary', 'خلاصه وضیعت کلید واژه ', '2011-07-13 01:25:14'),
(3892, 'fa', 'seotools', 'keyword-position-checker', 'چک کننده وضیعت کلید واژه ', '2011-07-13 01:25:14'),
(3893, 'fa', 'seotools', 'Keywords Manager', 'میدیریت کلید واژه ', '2011-07-13 01:25:14'),
(3894, 'fa', 'seotools', 'Quick Backlinks Checker', 'جک کننده سریع لینک دهنده ها ', '2011-07-13 01:25:14'),
(3895, 'fa', 'seotools', 'Quick Position Checker', 'جک کننده سریع وضیعت ', '2011-07-13 01:25:14'),
(3896, 'fa', 'seotools', 'Quick Rank Checker', 'جک کننده سریع رتبه ', '2011-07-13 01:25:14'),
(3897, 'fa', 'seotools', 'Quick Saturation Checker', 'جک کننده سریع اشباع ', '2011-07-13 01:25:14'),
(3898, 'fa', 'seotools', 'Rank Reports', 'گزارشات رتبه ', '2011-07-13 01:25:14'),
(3899, 'fa', 'seotools', 'rank-checker', 'چک کننده رتبه ', '2011-07-13 01:25:14'),
(3900, 'fa', 'seotools', 'Saturation Reports', 'گزارشات اشباع ', '2011-07-13 01:25:14'),
(3901, 'fa', 'seotools', 'saturation-checker', 'موتور جست و جو ی اشباع ', '2011-07-13 01:25:14'),
(3902, 'fa', 'seotools', 'sitemap-generator', 'مولد نقشه سایت', '2011-07-13 01:25:14'),
(3903, 'fa', 'seotools', 'Skipped Directories', 'مسیر های نادیده گرفته شده ', '2011-07-13 01:25:14'),
(3904, 'fa', 'seotools', 'Submission Reports', 'گزارشات تابع', '2011-07-13 01:25:14'),
(3905, 'fa', 'seotools', 'User Access', 'دسترسی کاربری', '2011-07-13 01:25:14'),
(3906, 'fa', 'common', 'Action', 'اقدام', '2014-09-01 21:04:16'),
(3907, 'fa', 'common', 'Activate', 'فعال سازی', '2014-09-01 21:04:16'),
(3908, 'fa', 'common', 'Active', 'فعال', '2014-09-01 21:04:16'),
(3909, 'fa', 'common', 'Admin Panel', 'پنل مدیریت', '2014-09-01 21:04:16'),
(3910, 'fa', 'common', 'Alexa Rank', 'رتبه در الکسا', '2014-09-01 21:04:16'),
(3911, 'fa', 'common', 'All', 'همه', '2014-09-01 21:04:16'),
(3912, 'fa', 'common', 'Category', 'طبقه بندی', '2014-09-01 21:04:16'),
(3913, 'fa', 'common', 'contact', 'تماس', '2014-09-01 21:04:16'),
(3914, 'fa', 'common', 'copyright', 'Copyright © [year] محفوظ است www.seopanel.in تمامی حقوق برای', '2014-09-01 21:04:16'),
(3915, 'fa', 'common', 'Country', 'کشور', '2014-09-01 21:04:16'),
(3916, 'fa', 'common', 'Crawl Meta Data', 'خزیدن متا داده ها ', '2014-09-01 21:04:16'),
(3917, 'fa', 'common', 'Date', 'تاریخ', '2014-09-01 21:04:16'),
(3918, 'fa', 'common', 'Delete', 'حذف', '2014-09-01 21:04:16'),
(3919, 'fa', 'common', 'Details', 'جزیات', '2014-09-01 21:04:16'),
(3920, 'fa', 'common', 'Directory', 'مسیر', '2014-09-01 21:04:16'),
(3921, 'fa', 'common', 'Donate', 'کمک مالی', '2014-09-01 21:04:16'),
(3922, 'fa', 'common', 'Edit', 'ویرایش', '2014-09-01 21:04:16'),
(3923, 'fa', 'common', 'Entry cannot be blank', 'ورودی نمی تواند خالی باشد ', '2014-09-01 21:04:16'),
(3924, 'fa', 'common', 'entrynotvalid', 'ورودی که وارد کرده ایدد به نطر قابل قبول نیست ', '2014-09-01 21:04:16'),
(3925, 'fa', 'common', 'failed', 'نا موفق', '2014-09-01 21:04:16'),
(3926, 'fa', 'common', 'forum', 'تالار گفت و گو', '2014-09-01 21:04:16'),
(3927, 'fa', 'common', 'Found', 'پیدا شده ها ', '2014-09-01 21:04:16'),
(3928, 'fa', 'common', 'Google Pagerank', 'رتبه در گوگل', '2014-09-01 21:04:16'),
(3929, 'fa', 'common', 'help', 'راهنما', '2014-09-01 21:04:16'),
(3930, 'fa', 'common', 'hidenews', 'پنهان سازی اخبار پنل سئو', '2014-09-01 21:04:16'),
(3931, 'fa', 'common', 'Id', 'شناسه', '2014-09-01 21:04:16'),
(3932, 'fa', 'common', 'Inactivate', 'غیر فعال کردن ', '2014-09-01 21:04:16'),
(3933, 'fa', 'common', 'Inactive', 'ف', '2014-09-01 21:04:16'),
(3934, 'fa', 'common', 'Invalid characters', 'کارکتر های غیر قابل قبول ', '2014-09-01 21:04:16'),
(3935, 'fa', 'common', 'Invalid code entered', 'کد های غیر قابل قبول وارد شده ', '2014-09-01 21:04:16'),
(3936, 'fa', 'common', 'Invalid email address entered', 'آدرس غیر قابل قبول وارد شده ', '2014-09-01 21:04:16'),
(3937, 'fa', 'common', 'Invalid value', 'مقدار غیر قابل قبول ', '2014-09-01 21:04:16'),
(3938, 'fa', 'common', 'Keyword', 'کلمه کلیدی', '2014-09-01 21:04:16'),
(3939, 'fa', 'common', 'Keywords', 'کلمات کلیدی', '2014-09-01 21:04:16'),
(3940, 'fa', 'common', 'lang', 'زبان', '2014-09-01 21:04:16'),
(3941, 'fa', 'common', 'My Account', 'حساب کاربری من ', '2014-09-01 21:04:16'),
(3942, 'fa', 'common', 'Name', 'نام ', '2014-09-01 21:04:16'),
(3943, 'fa', 'common', 'No', 'خیر', '2014-09-01 21:04:16'),
(3944, 'fa', 'common', 'No Keywords Found', 'هیچ کلمه کلیدی پیدا نشد ', '2014-09-01 21:04:16'),
(3945, 'fa', 'common', 'No Records Found', 'هیچ سابقه ایی پیدا نشد ', '2014-09-01 21:04:16'),
(3946, 'fa', 'common', 'noactivetools', 'هیچ ابزار فعال سئوی پیدا نشد ', '2014-09-01 21:04:17'),
(3947, 'fa', 'common', 'nowebsites', 'هیچ وب سایتی پیدا نشد ', '2014-09-01 21:04:17'),
(3948, 'fa', 'common', 'password632', 'طول رمز عبور باید بین 6 تا 32 کارکتر باشد ', '2014-09-01 21:04:17'),
(3949, 'fa', 'common', 'passwordnotmatch', 'رمز عبور صحیح نیست ', '2014-09-01 21:04:17'),
(3950, 'fa', 'common', 'Period', 'دوره ', '2014-09-01 21:04:17'),
(3951, 'fa', 'common', 'Priority', 'اولویت', '2014-09-01 21:04:17'),
(3952, 'fa', 'common', 'Profile', 'نمایه ', '2014-09-01 21:04:17'),
(3953, 'fa', 'common', 'Rank', 'رتبه ', '2014-09-01 21:04:17'),
(3954, 'fa', 'common', 'Reports', 'گزارش', '2014-09-01 21:04:17'),
(3955, 'fa', 'common', 'Results', 'نتایج ', '2014-09-01 21:04:17'),
(3956, 'fa', 'common', 'Search Engine', 'موتور جست و جو ', '2014-09-01 21:04:17'),
(3957, 'fa', 'common', 'Select', 'انتخاب', '2014-09-01 21:04:17'),
(3958, 'fa', 'common', 'Seo Plugins', 'افزونه های سئو', '2014-09-01 21:04:17'),
(3959, 'fa', 'common', 'Seo Tools', 'ابزار های سئو', '2014-09-01 21:04:17'),
(3960, 'fa', 'common', 'Sign out', 'خروج ', '2014-09-01 21:04:17'),
(3961, 'fa', 'common', 'Sign Up', 'ثبت نام ', '2014-09-01 21:04:17'),
(3962, 'fa', 'common', 'signin', 'ورود ', '2014-09-01 21:04:17'),
(3963, 'fa', 'common', 'Status', 'وضعیت', '2014-09-01 21:04:17'),
(3964, 'fa', 'common', 'Support', 'پشتیبانی', '2014-09-01 21:04:17'),
(3965, 'fa', 'common', 'Total', 'مجموع', '2014-09-01 21:04:17'),
(3966, 'fa', 'common', 'Url', 'آدرس', '2014-09-01 21:04:17'),
(3967, 'fa', 'common', 'User', 'کاربر', '2014-09-01 21:04:17'),
(3968, 'fa', 'common', 'User Panel', 'پنل کاربری', '2014-09-01 21:04:17'),
(3969, 'fa', 'common', 'Website', 'وب سایت ', '2014-09-01 21:04:17'),
(3970, 'fa', 'common', 'Yes', 'بله', '2014-09-01 21:04:17'),
(3971, 'fa', 'directory', 'Add back to directory list', 'اضافه کردن به لیست مسیر ', '2012-05-12 21:11:23'),
(3972, 'fa', 'directory', 'Approved', 'مصوب ', '2012-05-12 21:11:23'),
(3973, 'fa', 'directory', 'Captcha', 'Captcha', '2012-05-12 21:11:23'),
(3974, 'fa', 'directory', 'categorynote', 'بخش ها را با یک کاما از هم جدا کنید بر اساس اولویت آنها.\r\nبا آنهایی که دارای اولویت بالاتری هستند شروع کنید', '2012-05-12 21:11:23'),
(3975, 'fa', 'directory', 'Check Directory Status', 'برسی وضیعت مسیر ', '2012-05-12 21:11:23'),
(3976, 'fa', 'directory', 'Check Directory Submission Status', 'بررسی وضعیت مسیرهای توابع', '2012-05-12 21:11:23'),
(3977, 'fa', 'directory', 'clicktoproceeddirsts', 'کلیک کنید بر  <b>اقدام </b> برای برسی وضعیت مسیر', '2012-05-12 21:11:23'),
(3978, 'fa', 'directory', 'Confirmation', 'تایید', '2012-05-12 21:11:23'),
(3979, 'fa', 'directory', 'desnote', 'بعضی از مسیر هاحداقل 150 کارکتر برای قسمت توضیحات لازم است  ', '2012-05-12 21:11:24'),
(3980, 'fa', 'directory', 'Directories with out captcha', 'مسیر های با captcha خروجی', '2012-05-12 21:11:24'),
(3981, 'fa', 'directory', 'Directory Submission Reports', 'گزارشات مسیر توابع ', '2012-05-12 21:11:24'),
(3982, 'fa', 'directory', 'Enter the code shown', 'کد وارد نمایش داده شده را وارد کنید ', '2012-05-12 21:11:24'),
(3983, 'fa', 'directory', 'nocatnote', 'بخش توابع در صفحه توابع پیدا نشد .\r\nلطفا کلیک کنید بر <b> بار گذاری دوباره </b> یا <b> پرش </b>', '2012-05-12 21:11:24'),
(3984, 'fa', 'directory', 'nodirnote', 'هیچ <b> فعالی</b> مسیری پیدا نشد ', '2012-05-12 21:11:24'),
(3985, 'fa', 'directory', 'nosuccessnote', 'پیام به درستی دریافت نشد.\r\nلطفا ایمیل خود را  برای دیدن پیغام تایید بررسی کنید  ', '2012-05-12 21:11:24'),
(3986, 'fa', 'directory', 'optionalnote', 'عنوان و توضیحات اختیاری برای ارسال عنوان تصادفی و توضیحات به دایرکتوری ها برای نتایج بهتر\r\n', '2012-05-12 21:11:24'),
(3987, 'fa', 'directory', 'Owner Email', 'صاحب پست الکترونیک ', '2012-05-12 21:11:24'),
(3988, 'fa', 'directory', 'Owner Name', 'نام مالک', '2012-05-12 21:11:24'),
(3989, 'fa', 'directory', 'Pending', 'در انتظار', '2012-05-12 21:11:24'),
(3990, 'fa', 'directory', 'Please select a website to proceed', 'لطفا یک وب سابت را برای ادامه انتخاب کنید ', '2012-05-12 21:11:24'),
(3991, 'fa', 'directory', 'selectwebsiteproceed', 'سایت را برای ثبت در دایرکتوری انتخاب نمایید.برای ثبت در دایرکتوری هایی که نیاز به کد تشخیص انسان از روبوت ندارد، گزینه Directories with out\r\ncaptcha را انتخاب نمایید.', '2012-05-12 21:11:24'),
(3992, 'fa', 'directory', 'selectwebsiteschecksub', 'انتخاب کن <b> وب سایت </b>  برای <b> اقدام </b>  بررسی مسیر توابع را', '2012-05-12 21:11:24'),
(3993, 'fa', 'directory', 'Semi Automatic Directory Submission Tool', 'مسیر های نیمه اوتوماتیک ابزار توابع', '2012-05-12 21:11:24'),
(3994, 'fa', 'directory', 'spamemailnote', 'برخی از دایرکتوری ها ممکن است هرز نامه ارسال کنند ٰ.\r\nپیشنهاد نمی کنیم که از پست الکترونیک اصلی خود استفاده کنید ', '2012-05-12 21:11:24'),
(3995, 'fa', 'directory', 'Submission Details', 'جزیات تابع ', '2012-05-12 21:11:24'),
(3996, 'fa', 'directory', 'Submit Description', 'ثبت توضیحات ', '2012-05-12 21:11:24'),
(3997, 'fa', 'directory', 'Submit Keywords', 'ثبت کلمات کلیدی ', '2012-05-12 21:11:24'),
(3998, 'fa', 'directory', 'Submit Title', 'ثبت عنوان ', '2012-05-12 21:11:24'),
(3999, 'fa', 'directory', 'Website Category', 'طبقه بندی وب سایت ها ', '2012-05-12 21:11:24'),
(4000, 'fa', 'directory', 'Website Url', 'آدرس وب سایت ', '2012-05-12 21:11:24'),
(4001, 'fa', 'saturation', 'clickproceedsaturation', 'وترد کنید آدرس ها را <b> در هر خط یکی </b> . \r\nکلیک کنید بر روی <b> اقدام </b>  \r\nبرای بررسی موتور جست و جوی اشباع ', '2011-01-25 10:45:36'),
(4002, 'fa', 'saturation', 'GenerateSaturationReports', 'تولید موتور جستجو گزارش اشباع', '2011-01-25 10:45:36'),
(4003, 'fa', 'saturation', 'Quick Search Engine Saturation Checker', 'جستجوی سریع موتور جستجوگر اشباع', '2011-01-25 10:45:36'),
(4004, 'fa', 'saturation', 'Saved Search Engine Saturation results of', 'ذخیره نتایج اشباع موتور جست و جو ', '2011-01-25 10:45:36'),
(4005, 'fa', 'saturation', 'Search Engine Saturation Reports', 'گزارشات اشباع موتور های جست و جو ', '2011-01-25 10:45:36'),
(4006, 'fa', 'button', 'Cancel', 'انصراف ', '2014-01-08 19:25:49'),
(4007, 'fa', 'button', 'Check Status', 'بررسی وضیعت ', '2014-01-08 19:25:49'),
(4008, 'fa', 'button', 'Proceed', 'ادامه ', '2014-01-08 19:25:49'),
(4009, 'fa', 'button', 'Reload', 'بار گذاری دوباره ', '2014-01-08 19:25:49'),
(4010, 'fa', 'button', 'Show Details', 'نمابش چزیات ', '2014-01-08 19:25:49'),
(4011, 'fa', 'button', 'Show Records', 'نمایش سوابق ', '2014-01-08 19:25:49'),
(4012, 'fa', 'button', 'Skip', 'پرش ', '2014-01-08 19:25:49'),
(4013, 'fa', 'button', 'Submit', 'ثبت کردن ', '2014-01-08 19:25:49'),
(4014, 'fa', 'home', 'Account Summary', 'خلاصه حساب کاربری ', '2012-05-22 23:09:44'),
(4015, 'fa', 'home', 'Backlinks', 'لینک دهدنده ها ', '2012-05-22 23:09:44'),
(4016, 'fa', 'home', 'Directory Submission', 'مسیر توابع ', '2012-05-22 23:09:44'),
(4017, 'fa', 'home', 'home_cont1', '<h1 style=\\"text-align: center;margin-bottom: 30px;font-size: 19px;\\">به سئوپنل، اولین کنترل پنل در جهان برای بررسی سئو چندین سایت خوش آمدید</h1> \r\n        <p> \r\n            یک برنامه متن باز برای مدیریت بهینه سازی سایت های شما برایموتورهای جستجو  \r\n          سئوپنل یک ابزار سئو با بهترین امکانات برای بالا بردن و بررسی وضعیت سایت های شماست. \r\n           سئوپنل یک برنامه متن باز است.\r\n           بزرگترین خصیصه سئوپنل گسترش پذیری آن به کمک  <a href=\\"<?=SP_PLUGINSITE?>\\"\r\ntarget=\\"_blank\\">افزونه های سئوست</a>. \r\n          هر کسی می تواند افزونه مورد نیاز خود را انتشار دهد و یا اینکه بخرد و در پنل خود به راحتی نصب کند.  \r\n        </p> \r\n        <p></p> \r\n        <p> \r\n            این برنامه متن باز در سال 2010 انتشار یافت.</b>. \r\n           در همین دوره زمانی کوتاه بسیاری از وبمستران از این پنل برای کنترل وضعیت سئو سایت های خود استفاده می کنند\r\n           همین امروز از سئوپنل استفاده کنید و کنترل وضعیت سئو سایتتان را در دست بگیرید.\r\nسایت www.3eo.ir پشتیبان رسمی سئوپنل در کشورهای فارسی زبان\r\n        </p>', '2012-05-22 23:09:44'),
(4018, 'fa', 'home', 'home_cont2', '<fieldset>\r\n<legend>خصوصیات اصلی سئوپنل <?=SP_INSTALLED?></legend>\r\n<ul class=\\"infobox\\">\r\n    <li>        \r\n        <h1>ثبت اتوماتیک سایت در دایرکتوری ها</h1>\r\n </li>\r\n    <li>        \r\n        <h1>بررسی موقعیت کلمات کلیدی</h1> \r\n </li>\r\n    <li>        \r\n        <h1>نظارت بر سایت</h1> \r\n</li>\r\n    <li>        \r\n        <h1>بررسی وضعیت گوگل و الکسا</h1> \r\n</li>\r\n    <li>        \r\n        <h1>بررسی بک لینک ها</h1> \r\n   </li>    \r\n    <li>        \r\n        <h1>بررسی اشباع موتور جستجو</h1> \r\n </li>\r\n    <li>        \r\n        <h1>افزونه های سئوپنل</h1> \r\n </li>\r\n    <li>        \r\n        <h1>ساخت متا تگ ها</h1> \r\n </li>\r\n</ul>\r\n</fieldset>', '2012-05-22 23:09:44'),
(4019, 'fa', 'home', 'home_cont3', '<fieldset> \r\n<legend>منابع آنلاین سئو</legend>     \r\n<ul class=\\"infobox\\"> \r\n\r\n    <li> \r\n        <h1>منابع آنلاین سئو به عنوان مرجع </h1>                 \r\n         \r\n         \r\n        <p> \r\n            <a href=\\"http://www.seopanel.in\\" target=\\"_blank\\">سایت اختصاصی سئو پنل  </a> \r\n        </p> \r\n <p> \r\n            <a href=\\"http://seopanel.3eo.ir\\" target=\\"_blank\\">پشتیبانی فارسی سئوپنل  </a> \r\n        </p> \r\n        <p> \r\n            <a href=\\"<?=SP_DOWNLOAD_LINK?>\\" target=\\"_blank\\">بارگیری سئو پنل </a> \r\n        </p> \r\n         \r\n        <p> \r\n            <a href=\\"<?=SP_DEMO_LINK?>\\" target=\\"_blank\\">نمونه سئو پنل </a> \r\n        </p> \r\n         \r\n        <p> \r\n            <a href=\\"<?=SP_CONTACT_LINK?>\\" target=\\"_blank\\">تماس با سئو پنل </a> \r\n        </p> \r\n         \r\n        <p> \r\n            <a href=\\"<?=SP_HELP_LINK?>\\" target=\\"_blank\\">راهنمایی سئو پنل </a> \r\n        </p> \r\n         \r\n        <p> \r\n            <a href=\\"<?=SP_FORUM_LINK?>\\" target=\\"_blank\\">فرم سئو پنل </a> \r\n        </p> \r\n         \r\n        <p> \r\n            <a href=\\"<?=SP_SUPPORT_LINK?>\\" target=\\"_blank\\">سیستم پشتیبانیه سئوپنل  </a> \r\n        </p> \r\n         \r\n        <p> \r\n            <a href=\\"<?=SP_DONATE_LINK?>\\" target=\\"_blank\\">حمایت مالی از سئو پنل </a> \r\n        </p> \r\n    </li> \r\n     \r\n</ul> \r\n</fieldset>', '2012-05-22 23:09:44'),
(4020, 'fa', 'home', 'Pages Indexed', 'صفحات نمایه', '2012-05-22 23:09:44'),
(4021, 'fa', 'home', 'Ranks', 'رتبه ها', '2012-05-22 23:09:44'),
(4022, 'fa', 'home', 'SiteNameUrl', 'نام سایت / آدرس', '2012-05-22 23:09:44'),
(4023, 'fa', 'home', 'Website Statistics', 'آمار وب سایت', '2012-05-22 23:09:44'),
(4024, 'fa', 'backlink', 'clickproceedbacklink', '  <b> در هر خط یکی </b> برای چک کردن لینک دهنده ها آدرس ها راوارد کنید', '2010-12-03 04:50:08'),
(4025, 'fa', 'backlink', 'Saved backlink results of', 'ذخیره کن نتایج لینک دهنده ها را ', '2010-12-03 04:50:08'),
(4026, 'el', 'website', 'Edit Website', 'Επεξεργασία website', '2016-01-27 08:14:51'),
(4027, 'el', 'website', 'plscrtwebsite', 'Παρακαλώ καταχωρίστε ένα website, πριν αρχίσετε να χρησιμοποιείτε τα εργαλεία seo και τα seo plugins.', '2016-01-27 08:14:51'),
(4028, 'el', 'website', 'Website already exist', 'Το Website ήδη υπάρχει', '2016-01-27 08:14:51'),
(4029, 'el', 'website', 'yourwebalreday', 'Το website σας αν ήδη έχετε καταχωρίσει ένα.', '2016-01-27 08:14:51'),
(4030, 'el', 'user', 'Edit User', 'Επεξεργασία χρήστη', '2016-01-27 08:13:11'),
(4031, 'el', 'user', 'Saved My Profile Details', 'Οι Λεπτομέρειες Προφίλ αποθηκεύτηκαν', '2016-01-27 08:13:11'),
(4032, 'el', 'sitemap', 'Change frequency', 'Αλλαγή συχνότητας', '2010-12-12 01:47:57'),
(4033, 'el', 'sitemap', 'clickproceedsitemap', 'Κάντε κλικ στο <b>Ανάθεση</b> για να δημιουργήσετε ένα sitemap αρχείο', '2010-12-12 01:47:57'),
(4034, 'el', 'sitemap', 'Download sitemap file from', 'Κατεβάστε το αρχείο sitemap από', '2010-12-12 01:47:57'),
(4035, 'el', 'sitemap', 'Exclude Url', 'Απομονώστε Url', '2010-12-12 01:47:57'),
(4036, 'el', 'sitemap', 'processtaketime', 'Αυτή η διαδικασία θα κρατήσει τόση ώρα ανάλογα με τον αριθμό των link που υπάρχουν στο website. Παρακαλώ περιμένετε ώστε να λάβετε τα αρχεία sitemap', '2010-12-12 01:47:57'),
(4037, 'el', 'sitemap', 'Sitemap Type', 'Τύπος Sitemap', '2010-12-12 01:47:57'),
(4038, 'el', 'backlink', 'clickproceedbacklink', 'Πληκτρολογήστε τα URL\\''s <b>ένα σε κάθε γραμμή</b>. Κάντε κλικ στο <b>Ανάθεση</b> για να εξετάσετε τα Backlinks. ', '2010-12-14 05:04:32'),
(4039, 'el', 'backlink', 'Saved backlink results of', 'Αποθηκεύτηκαν αποτελέσματα backlink για', '2010-12-14 05:04:32'),
(4040, 'el', 'button', 'Cancel', 'Ακύρωση', '2014-01-08 19:26:57'),
(4041, 'el', 'button', 'Check Status', 'Έλεγχος κατάστασης', '2014-01-08 19:26:57'),
(4042, 'el', 'button', 'Proceed', 'Εκκίνηση', '2014-01-08 19:26:57'),
(4043, 'el', 'button', 'Reload', 'Επαναφόρτωση', '2014-01-08 19:26:57'),
(4044, 'el', 'button', 'Show Details', 'Εμφάνιση λεπτομερειών', '2014-01-08 19:26:57'),
(4045, 'el', 'button', 'Show Records', 'Εμφάνιση εγγραφών', '2014-01-08 19:26:57'),
(4046, 'el', 'button', 'Skip', 'Παράβλεψη', '2014-01-08 19:26:57'),
(4047, 'el', 'button', 'Submit', 'Καταχώριση ', '2014-01-08 19:26:57'),
(4048, 'el', 'common', 'Action', 'Ενέργεια', '2016-12-29 13:05:21'),
(4049, 'el', 'common', 'Activate', 'Ενεργοποίηση', '2016-12-29 13:05:21'),
(4050, 'el', 'common', 'Active', 'Ενεργό', '2016-12-29 13:05:21'),
(4051, 'el', 'common', 'Admin Panel', 'Πίνακας διαχειριστή', '2016-12-29 13:05:21'),
(4052, 'el', 'common', 'Alexa Rank', 'Alexa Rank ', '2016-12-29 13:05:21'),
(4053, 'el', 'common', 'All', 'Όλα', '2016-12-29 13:05:21'),
(4054, 'el', 'common', 'Category', 'Κατηγορία', '2016-12-29 13:05:21'),
(4055, 'el', 'common', 'contact', 'Επικοινωνία', '2016-12-29 13:05:21'),
(4056, 'el', 'common', 'copyright', 'Copyright © [year] www.seopanel.in All rights reserved ', '2016-12-29 13:05:21'),
(4057, 'el', 'common', 'Country', 'Χώρα', '2016-12-29 13:05:21'),
(4058, 'el', 'common', 'Crawl Meta Data', 'Crawl Meta Data ', '2016-12-29 13:05:21'),
(4059, 'el', 'common', 'Date', 'Ημερομηνία', '2016-12-29 13:05:21'),
(4060, 'el', 'common', 'Delete', 'Διαγραφή', '2016-12-29 13:05:21'),
(4061, 'el', 'common', 'Details', 'Λεπτομέρειες', '2016-12-29 13:05:21'),
(4062, 'el', 'common', 'Directory', 'Κατάλογος', '2016-12-29 13:05:21'),
(4063, 'el', 'common', 'Donate', 'Ενίσχυση', '2016-12-29 13:05:21'),
(4064, 'el', 'common', 'Edit', 'Επεξεργασία', '2016-12-29 13:05:21'),
(4065, 'el', 'common', 'Entry cannot be blank', 'Η καταχώριση δεν μπορεί να είναι κενή', '2016-12-29 13:05:21'),
(4066, 'el', 'common', 'entrynotvalid', 'Η καταχώριση που εισάγατε δεν δείχνει να είναι σωστή', '2016-12-29 13:05:21'),
(4067, 'el', 'common', 'failed', 'Απέτυχε', '2016-12-29 13:05:21'),
(4068, 'el', 'common', 'forum', 'Συζητήστε', '2016-12-29 13:05:21'),
(4069, 'el', 'common', 'Found', 'Βρέθηκε', '2016-12-29 13:05:21'),
(4070, 'el', 'common', 'Google Pagerank', 'Google Pagerank ', '2016-12-29 13:05:21'),
(4071, 'el', 'common', 'help', 'Βοήθεια', '2016-12-29 13:05:21'),
(4072, 'el', 'common', 'hidenews', 'Απόκρυψη των ειδήσεων Seo Panel ', '2016-12-29 13:05:21'),
(4073, 'el', 'common', 'Id', 'Id', '2016-12-29 13:05:21'),
(4074, 'el', 'common', 'Inactivate', 'Απενεργοποίηση', '2016-12-29 13:05:21'),
(4075, 'el', 'common', 'Inactive', 'Απενεργοποιημένος', '2016-12-29 13:05:21'),
(4076, 'el', 'common', 'Invalid characters', 'Μη αποδεκτοί χαρακτήρες', '2016-12-29 13:05:21'),
(4077, 'el', 'common', 'Invalid code entered', 'Εισήχθη μη αποδεκτός κωδικός', '2016-12-29 13:05:21'),
(4078, 'el', 'common', 'Invalid email address entered', 'Εισήχθη μη αποδεκτή διεύθυνση email', '2016-12-29 13:05:21'),
(4079, 'el', 'common', 'Invalid value', 'Μη αποδεκτή τιμή', '2016-12-29 13:05:21'),
(4080, 'el', 'common', 'Keyword', 'Λέξη κλειδί', '2016-12-29 13:05:21'),
(4081, 'el', 'common', 'Keywords', 'Λέξεις κλειδιά', '2016-12-29 13:05:21'),
(4082, 'el', 'common', 'lang', 'Γλώσσα', '2016-12-29 13:05:21'),
(4083, 'el', 'common', 'My Account', 'Ο λογαριασμός μου', '2016-12-29 13:05:21'),
(4084, 'el', 'common', 'Name', 'Όνομα', '2016-12-29 13:05:21'),
(4085, 'el', 'common', 'No', 'Όχι', '2016-12-29 13:05:21'),
(4086, 'el', 'common', 'No Keywords Found', 'Δεν βρέθηκαν λέξεις κλειδιά', '2016-12-29 13:05:21'),
(4087, 'el', 'common', 'No Records Found', 'Δεν βρέθηκαν εγγραφές', '2016-12-29 13:05:21'),
(4088, 'el', 'common', 'noactivetools', 'Δεν βρέθηκαν ενεργά Seo Tools!', '2016-12-29 13:05:21'),
(4089, 'el', 'common', 'nowebsites', 'Δεν βρέθηκαν websites', '2016-12-29 13:05:21'),
(4090, 'el', 'common', 'password632', 'Το μέγεθος του κωδικού πρέπει να έχει μήκος από 6 ως 32 χαρακτήρες', '2016-12-29 13:05:21'),
(4091, 'el', 'common', 'passwordnotmatch', 'Ο κωδικός δεν ταιριάζει', '2016-12-29 13:05:21'),
(4092, 'el', 'common', 'Period', 'Περίοδος', '2016-12-29 13:05:21'),
(4093, 'el', 'common', 'Priority', 'Προτεραιότητα ', '2016-12-29 13:05:21'),
(4094, 'el', 'common', 'Profile', 'Προφίλ', '2016-12-29 13:05:21'),
(4095, 'el', 'common', 'Rank', 'Rank', '2016-12-29 13:05:21'),
(4096, 'el', 'common', 'Reports', 'Αναφορές', '2016-12-29 13:05:21'),
(4097, 'el', 'common', 'Results', 'Αποτελέσματα', '2016-12-29 13:05:21'),
(4098, 'el', 'common', 'Search Engine', 'Μηχανή Αναζήτησης', '2016-12-29 13:05:21'),
(4099, 'el', 'common', 'Select', 'Επιλογή', '2016-12-29 13:05:21'),
(4100, 'el', 'common', 'Seo Plugins', 'Seo Plugins', '2016-12-29 13:05:21'),
(4101, 'el', 'common', 'Seo Tools', 'Seo Εργαλεία', '2016-12-29 13:05:21'),
(4102, 'el', 'common', 'Sign out', 'Αποσύνδεση', '2016-12-29 13:05:21'),
(4103, 'el', 'common', 'Sign Up', 'Εγγραφή', '2016-12-29 13:05:21'),
(4104, 'el', 'common', 'signin', 'Σύνδεση', '2016-12-29 13:05:21'),
(4105, 'el', 'common', 'Status', 'Κατάσταση', '2016-12-29 13:05:21'),
(4106, 'el', 'common', 'Support', 'Υποστήριξη', '2016-12-29 13:05:21'),
(4107, 'el', 'common', 'Total', 'Σύνολο', '2016-12-29 13:05:21'),
(4108, 'el', 'common', 'Url', 'Url', '2016-12-29 13:05:21'),
(4109, 'el', 'common', 'User', 'Χρήστης', '2016-12-29 13:05:21'),
(4110, 'el', 'common', 'User Panel', 'Πίνακας ελέγχου χρήστη', '2016-12-29 13:05:21'),
(4111, 'el', 'common', 'Website', 'Website', '2016-12-29 13:05:21'),
(4112, 'el', 'common', 'Yes', 'Ναι', '2016-12-29 13:05:21'),
(4113, 'el', 'directory', 'Add back to directory list', 'Προσθέστε πίσω στην λίστα καταλόγου', '2014-01-20 11:07:08'),
(4114, 'el', 'directory', 'Approved', 'Ελέχθη ', '2014-01-20 11:07:08'),
(4115, 'el', 'directory', 'Captcha', 'Captcha ', '2014-01-20 11:07:08'),
(4116, 'el', 'directory', 'categorynote', 'Κατηγορίες, διαχωρισμένες με κόμμα σύμφωνα με την προτεραιότητα. Ξεκινήστε με την κατηγορία Πρώτης προτεραιότητας. ', '2014-01-20 11:07:08'),
(4117, 'el', 'directory', 'Check Directory Status', 'Έλεγχος κατάστασης καταλόγου', '2014-01-20 11:07:08'),
(4118, 'el', 'directory', 'Check Directory Submission Status', 'Έλεγχος κατάστασης καταχώρισης καταλόγου', '2014-01-20 11:07:08'),
(4119, 'el', 'directory', 'clicktoproceeddirsts', 'Επιλέξτε <b>Ανάθεση</b> για τον Έλεγχο Κατάστασης Καταλόγου. ', '2014-01-20 11:07:08');
INSERT INTO `texts` (`id`, `lang_code`, `category`, `label`, `content`, `changed`) VALUES
(4120, 'el', 'directory', 'Confirmation', 'Επιβεβαίωση', '2014-01-20 11:07:08'),
(4121, 'el', 'directory', 'desnote', 'Μερικοί κατάλογοι απαιτούν το ελάχιστο 150 χαρακτήρες για το πεδίο περιγραφής.', '2014-01-20 11:07:08'),
(4122, 'el', 'directory', 'Directories with out captcha', 'Κατάλογοι χωρίς captcha', '2014-01-20 11:07:08'),
(4123, 'el', 'directory', 'Directory Submission Reports', 'Αναφορά Καταχώρισης καταλόγου', '2014-01-20 11:07:08'),
(4124, 'el', 'directory', 'Enter the code shown', 'Πληκτρολογήστε τον προβαλλόμενο κωδικό', '2014-01-20 11:07:08'),
(4125, 'el', 'directory', 'nocatnote', 'Ο κατάλογος καταχωρίσεων δεν βρέθηκε στην σελίδα καταχώρισης. Παρακαλώ κάντε κλικ στην <b>Επαναφόρτωση</b> ή <b>Παράβλεψη</b> ', '2014-01-20 11:07:08'),
(4126, 'el', 'directory', 'nodirnote', 'Δεν βρέθηκε <b>Ενεργός</b> κατάλογος', '2014-01-20 11:07:08'),
(4127, 'el', 'directory', 'nosuccessnote', 'Δεν ελήφθη μήνυμα επιτυχίας, Παρακαλώ ελέγξτε το email σας για να βρείτε το μήνυμα επιβεβαίωσης.', '2014-01-20 11:07:08'),
(4128, 'el', 'directory', 'optionalnote', 'Εναλλακτικοί τίτλοι και κατηγορίες για την καταχώριση random τίτλου και περιγραφής σε καταλόγους για καλύτερα αποτελέσματα.', '2014-01-20 11:07:08'),
(4129, 'el', 'directory', 'Owner Email', 'Email ιδιοκτήτη', '2014-01-20 11:07:08'),
(4130, 'el', 'directory', 'Owner Name', 'Όνομα ιδιοκτήτη', '2014-01-20 11:07:08'),
(4131, 'el', 'directory', 'Pending', 'Εν αναμονή', '2014-01-20 11:07:08'),
(4132, 'el', 'directory', 'Please select a website to proceed', 'Παρακαλώ επιλέξτε ένα website για ανάθεση', '2014-01-20 11:07:08'),
(4133, 'el', 'directory', 'selectwebsiteproceed', 'Επιλέξτε ένα <b>Website</b> για <b>Ανάθεση</b> καταχώρισης καταλόγου.<br>Ελέγξτε <b> τον κατάλογο χωρίς captcha</b> για καταχώριση σε κατάλογο χωρίς captcha', '2014-01-20 11:07:08'),
(4134, 'el', 'directory', 'selectwebsiteschecksub', 'Επιλέξτε ένα <b>Website</b> για <b>Ανάθεση</b> ελέγχου καταχώρισης καταλόγου. ', '2014-01-20 11:07:08'),
(4135, 'el', 'directory', 'Semi Automatic Directory Submission Tool', 'Ημιαυτόματο Εργαλείο Καταχώρισης Καταλόγου', '2014-01-20 11:07:08'),
(4136, 'el', 'directory', 'spamemailnote', 'Μερικοί κατάλογοι μπορεί να στείλουν spam, δεν προτείνουμε να χρησιμοποιήσετε την κύρια διεύθυνση email σας.', '2014-01-20 11:07:08'),
(4137, 'el', 'directory', 'Submission Details', 'Λεπτομέρειες Καταχώρισης', '2014-01-20 11:07:08'),
(4138, 'el', 'directory', 'Submit Description', 'Περιγραφή Καταχώρισης', '2014-01-20 11:07:08'),
(4139, 'el', 'directory', 'Submit Keywords', 'Καταχώριση Λέξεων Κλειδιών', '2014-01-20 11:07:08'),
(4140, 'el', 'directory', 'Submit Title', 'Καταχώριση Τίτλου', '2014-01-20 11:07:08'),
(4141, 'el', 'directory', 'Website Category', 'Κατηγορία Website', '2014-01-20 11:07:08'),
(4142, 'el', 'directory', 'Website Url', 'Website Url ', '2014-01-20 11:07:08'),
(4143, 'el', 'plugin', 'Edit Seo Plugin', 'Επεξεργασία Seo Plugin', '2012-06-02 21:56:43'),
(4144, 'el', 'plugin', 'Plugin Name', 'Όνομα Plugin', '2012-06-02 21:56:43'),
(4145, 'el', 'plugin', 'Seo Plugin Details', 'Λεπτομέρειες Seo Plugin', '2012-06-02 21:56:43'),
(4146, 'el', 'support', 'support_cont1', '<fieldset> \r\n<legend>Seo Panel Σύστημα Υποστήριξης</legend> \r\n<ul class=\\"infobox\\"> \r\n    <li> \r\n        <h1>Πακέτο Καταλόγου 1000</h1>  \r\n        <p> \r\n            Σας παρέχουμε <b>1000 δωρεάν και ενεργά</b> πακέτα internet καταλόγων, ώστε να τα προσθέσετε \r\nστο seo panel σας με το<b>εργαλείο καταχώρισης καταλόγων</b>. \r\n            Αυτό θα σας βοηθήσει να <b>αυξήσετε τα backlinks</b> των websites σας. \r\n            Πρακτικά, η 1000 λίστα καταλόγου είναι <b>εισαγωγική</b> για να μαζευτούν χρήματα για τη <b>μελλοντική\r\n ανάπτυξη</b> του seo panel. \r\n            Για να παραλάβετε την λίστα καταλόγων 1000 παρακαλώ <a href=\\"<?=SP_DONATE_LINK?>\\" target=\\"_blank\\">δωρίστε</a>\r\n$10 ή λιγότερο για την βελτίωση των λειτουργιών και των εργαλείων του seo panel. \r\n            Αν έχετε ερωτήσεις για το πακέτο καταλόγων 1000, παρακαλώ <a href=\\"<?=SP_CONTACT_LINK?>\\"\r\ntarget=\\"_blank\\">επικοινωνήστε μαζί μας</a> ή ανοίξτε ένα ερώτημα στο<a href=\\"<?=SP_SUPPORT_LINK?>\\"\r\ntarget=\\"_blank\\">σύστημα υποστήριξης</a>.    \r\n        </p>         \r\n        <p> \r\n            <a href=\\"<?=SP_DONATE_LINK?>\\" target=\\"_blank\\">Επισκεφτείτε αυτόν το σύνδεσμο για να δωρίσετε στο seo panel</a> \r\n        </p> \r\n        <br> \r\n    </li> \r\n     \r\n    <li> \r\n        <h1>Πακέτο Τοπικών Μηχανών Αναζήτησης</h1>  \r\n        <p> \r\n            Προσθέστε<b> domains τοπικών μηχανών αναζήτησης</b> για το google,yahoo,msn(<b>eg: www.google.de,www.google.gr\r\nκλπ</b>) στο seo panel <b> έλεγχος κατάταξης keyword</b>, ώστε να παρακολουθηθεί η απόδοση του site σας τοπικά. \r\n            Για να λάβετε το πακέτο των τοπικών μηχανών αναζήτησης(σύμφωνα με τις απαιτήσεις σας) παρακαλώ <a\r\nhref=\\"<?=SP_DONATE_LINK?>\\" target=\\"_blank\\">δωρίστε</a> $10 ή περισσότερα για την βελτίωση των υπηρεσιών που προσφέρει το seo panel. \r\n            Πριν στείλετε την δωρεά, παρακαλώ <a href=\\"<?=SP_CONTACT_LINK?>\\" target=\\"_blank\\">επικοινωνήστε μαζί μας</a> για να \r\nσας παρέχουμε την απαιτούμενη λίστα των domain μηχανών αναζήτησης. \r\n            <br><br>               \r\n            Επίσης, για να προσθέσετε <b>νέες μηχανές αναζήτησης(eg:in.gr)</b> στο seo panel εργαλείο ελέγχου κατάταξης keyword,\r\nπαρακαλώ <a href=\\"<?=SP_CONTACT_LINK?>\\" target=\\"_blank\\">επικοινωνήστε μαζί μας</a> ή ανοίξτε ένα ερώτημα στο <a\r\nhref=\\"<?=SP_SUPPORT_LINK?>\\" target=\\"_blank\\">σύστημα υποστήριξης</a>.  \r\n        </p>         \r\n        <p class=\\"visit\\"> \r\n            <a href=\\"<?=SP_CONTACT_LINK?>\\" target=\\"_blank\\">Κάντε κλικ εδώ για να επικοινωνήσετε μαζί μας</a> \r\n        </p> \r\n        <br> \r\n    </li> \r\n     \r\n    <li> \r\n        <h1>Seo Panel Plugins</h1>  \r\n        <p> \r\n            Προσθέστε <b>seo plugins</b> στο seo panel σας για να <b>επεκτίνετε τις δυνατότητες</b> σύμφωνα με τις\r\nαπαιτήσεις σας. \r\n            Τα <a href=\\"<?=SP_PLUGINSITE?>\\" target=\\"_blank\\">Seo panel plugins</a> υποστηρίζονται από το seo panel\r\nαλλά και sites τρίτων. \r\n            Επίσης, μπορείτε εύκολα να <b>αναπτύξετε</b> seo plugins για το δικό σας seo panel. \r\n            Μπορείτε να <a href=\\"<?=SP_PLUGINSITE?>\\" target=\\"_blank\\">καταχωρίσετε</a> το seo plugin στο seo panel και\r\nεμείς θα το <b>δημοσιεύσουμε</b> στο website σας μετά από τον <b>επανέλεγχο</b> που κάνουμε.         \r\n        </p>         \r\n        <p> \r\n            <a href=\\"<?=SP_PLUGINSITE?>\\" target=\\"_blank\\">Κάντε κλικ εδώ για να κατεβάσετε seo panel plugins</a> \r\n        </p> \r\n        <br> \r\n    </li>     \r\n    <li> \r\n        <h1>Επικοινωνήστε μαζί μας</h1>  \r\n        <p> \r\n            Επικοινωνήστε μαζί μας για οποιεσδήποτε ερωτήσεις αφορούν τα <b>seo panel tools,plugins και δυνατότητες etc</b> χρησιμοποιώντας το ακόλουθο\r\nlink.         \r\n        </p>         \r\n        <p> \r\n            <a href=\\"<?=SP_CONTACT_LINK?>\\" target=\\"_blank\\">Κάντε κλικ εδώ για να επικοινωνήσετε μαζί μας</a> \r\n        </p> \r\n        <br> \r\n    </li>     \r\n    <li> \r\n        <h1>Ερωτήματα Υποστήριξης</h1>  \r\n        <p> \r\n            Για να έχετε <b>τεχνική υποστήριξη</b> από τη ομάδα του seo panel που αφοροούν την εγκατάσταση των <b>seo panel tools,plugins and\r\nδυνατοτήτων</b>. Π.χ.: Για εγκατάσταση cron για έλεγχο κατάταξης keyword. \r\n        </p>         \r\n        <p> \r\n            <a href=\\"<?=SP_SUPPORT_LINK?>\\" target=\\"_blank\\">Κάντε κλικ εδώ για να δημιουργήσετε ένα ερώτημα υποστήριξης</a> \r\n        </p> \r\n        <br> \r\n    </li>     \r\n    <li> \r\n        <h1>Αναφορά Bugs</h1>  \r\n        <p> \r\n            Αναφέρετε τα <b>bugs</b> για τα <b>seo panel tools,plugins των δυνατοτήτων κλπ</b> χρησιμοποιώντας το ακόλουθο link.  \r\n            Παρακαλώ βοηθήστε μας να βελτιώσουμε τις δυνατότητες στις επόμενες εκδόσεις.           \r\n        </p>         \r\n        <p> \r\n            <a href=\\"<?=SP_SUPPORT_LINK?>\\" target=\\"_blank\\">Κάντε κλικ εδώ για να αναφέρετε  bugs</a> \r\n        </p> \r\n        <br> \r\n    </li>     \r\n</ul> \r\n</fieldset>', '2011-01-19 22:35:57'),
(4147, 'el', 'support', 'support_cont2', '<fieldset> \r\n<legend>Seo Panel Online Πόροι</legend> \r\n<ul class=\\"infobox\\"> \r\n         \r\n    <li> \r\n        <h1>Οδηγός Βοηθείας Seo Panel</h1>  \r\n        <p> \r\n            Μπορείτε να διαβάσετε την <a href=\\"<?=SP_HELP_LINK?>\\" target=\\"_blank\\">τεκμηρίωση του seo panel</a> στον <b>οδηγό βοηθείας</b>, ο οποίος περιλαμβάνει <b>τεκμηρίωση</b> για τα εργαλεία του seo panel, τα plugins και τα συναφή χαρακτηριστικά και δυνατότητες. \r\n            <br>Είναι το καλύτερο μέρος στο internet για <b>λήψη βοήθειας</b> στο seo panel. Ελπίζουμε ότι και εσείς θα <b>συμβάλλετε</b> στον οδηγό βοήθειας του seo panel, σε περίπτωση που βρείτε σφάλματα ή στοιχεία που λείπουν.\r\n        </p> \r\n        <p> \r\n            <a href=\\"<?=SP_HELP_LINK?>\\" target=\\"_blank\\">Επισκεφθείτε τον οδηγό βοηθείας του seo panel</a> \r\n        </p> \r\n        <br> \r\n    </li>     \r\n    <li> \r\n        <h1>Seo Panel Forum</h1>  \r\n        <p> \r\n            Ένα μέρος για να συζητήσετε το πρώτο παγκοσμίως open source <b>seo control panel</b>.  \r\n            Είναι το καλύτερο μέρος για να βρείτε <b>απαντήσεις</b> στις <b>ερωτήσεις σας</b> για το seo panel.  \r\n            <br>Επίσης μπορείτε να <b>μοιραστείτε</b> την <b>εμπειρία σας</b> όσο χρησιμοποιείτε το seo panel για την βελτιστοποίηση των websites σας.\r\n        </p>         \r\n        <p> \r\n            <a href=\\"<?=SP_FORUM_LINK?>\\" target=\\"_blank\\">Επισκεφθείτε το seo panel forum</a> \r\n        </p> \r\n        <br> \r\n    </li> \r\n</ul>     \r\n</fieldset>', '2011-01-19 22:35:57'),
(4148, 'el', 'support', 'support_cont3', '<fieldset> \r\n<legend> Δωρίστε στο Seo Panel</legend> \r\n<ul class=\\"infobox\\">         \r\n    <li> \r\n        <h1> Δωρίστε στο Seo Panel - Το πρώτο Open source seo control panel παγκοσμίως</h1>  \r\n        <p> \r\n            <b>Δωρίστε</b> στο seo panel για την υποστήριξη του πρώτου open source seo control panel παγκοσμίως. \r\n            Σχεδιάζουμε να <b>προσθέσουμε και βελτιώσουμε</b> τις δυνατότητες του seo panel στο μέλλον.  \r\n            <br>Μόνο με όλη την <b>υποστήριξη σας</b> μπορούμε να επιτύχουμε τους <b>στόχους</b>. \r\n            Αν πιστεύετε ότι το seo panel <b>αξίζει</b> για σας, παρακαλώ δωρίστε ένα μερικό ποσό στην ομάδα του  seo panel.\r\n            <br>Εμείς θα <b>δημοσιεύσουμε</b> το όνομα σας και τις πληροφορίες του site στην <a href=\\"<?=SP_DONATE_LINK?>\\" target=\\"_blank\\">σελίδα δωρεάς</a>, μόλις παραλάβουμε την δωρεά. \r\n        </p> \r\n        <p> \r\n            <a href=\\"<?=SP_DONATE_LINK?>\\" target=\\"_blank\\">Επισκεφθείτε αυτόν το σύνδεσμο για να δωρίσετε στο seo panel</a> \r\n        </p> \r\n        <br> \r\n    </li> \r\n</ul> \r\n</fieldset>', '2011-01-19 22:35:57'),
(4149, 'da', 'backlink', 'clickproceedbacklink', 'Indtast URL''s <b> En per linie </b>. Klik på <b> Fortsæt </b> for at kontrollere backlinks.\r\n', '2014-01-17 19:42:13'),
(4150, 'da', 'backlink', 'Saved backlink results of', 'Gemte backlink resultater', '2014-01-17 19:42:13'),
(4151, 'da', 'button', 'Cancel', 'Annuller', '2014-01-08 19:24:44'),
(4152, 'da', 'button', 'Check Status', 'Kontroller Status\r\n', '2014-01-08 19:24:44'),
(4153, 'da', 'button', 'Proceed', 'Fortsæt', '2014-01-08 19:24:44'),
(4154, 'da', 'button', 'Reload', 'Opdater', '2014-01-08 19:24:44'),
(4155, 'da', 'button', 'Show Details', 'Vis Detaljer\r\n', '2014-01-08 19:24:44'),
(4156, 'da', 'button', 'Show Records', 'Vis Data', '2014-01-08 19:24:44'),
(4157, 'da', 'button', 'Skip', 'Spring Over', '2014-01-08 19:24:44'),
(4158, 'da', 'button', 'Submit', 'Indsend', '2014-01-08 19:24:44'),
(4159, 'da', 'common', 'Action', 'Handling', '2014-01-17 19:45:27'),
(4160, 'da', 'common', 'Activate', 'Aktiver', '2014-01-17 19:45:27'),
(4161, 'da', 'common', 'Active', 'Aktiv', '2014-01-17 19:45:27'),
(4162, 'da', 'common', 'Admin Panel', 'Admin Panel\r\n', '2014-01-17 19:45:27'),
(4163, 'da', 'common', 'Alexa Rank', 'Alexa Rank', '2014-01-17 19:45:27'),
(4164, 'da', 'common', 'All', 'Alle', '2014-01-17 19:45:27'),
(4165, 'da', 'common', 'Category', 'Kategori', '2014-01-17 19:45:27'),
(4166, 'da', 'common', 'contact', 'Kontakt', '2014-01-17 19:45:27'),
(4167, 'da', 'common', 'copyright', 'Copyright © [year] www.seopanel.in Alle rettigheder forbeholdes\r\n', '2014-01-17 19:45:27'),
(4168, 'da', 'common', 'Country', 'Land', '2014-01-17 19:45:27'),
(4169, 'da', 'common', 'Crawl Meta Data', 'Kravle Meta Data\r\n', '2014-01-17 19:45:27'),
(4170, 'da', 'common', 'Date', 'Dato', '2014-01-17 19:45:27'),
(4171, 'da', 'common', 'Delete', 'Slet', '2014-01-17 19:45:27'),
(4172, 'da', 'common', 'Details', 'Detaljer', '2014-01-17 19:45:27'),
(4173, 'da', 'common', 'Directory', 'Bibliotek', '2014-01-17 19:45:27'),
(4174, 'da', 'common', 'Donate', 'Donere\r\n', '2014-01-17 19:45:27'),
(4175, 'da', 'common', 'Edit', 'Rediger', '2014-01-17 19:45:27'),
(4176, 'da', 'common', 'Entry cannot be blank', 'Punktet må ikke være tom\r\n', '2014-01-17 19:45:27'),
(4177, 'da', 'common', 'entrynotvalid', 'De indtastede punkter synes ikke at være gyldig\r\n', '2014-01-17 19:45:27'),
(4178, 'da', 'common', 'failed', 'mislykkedes', '2014-01-17 19:45:27'),
(4179, 'da', 'common', 'forum', 'Forum', '2014-01-17 19:45:27'),
(4180, 'da', 'common', 'Found', 'Fundet', '2014-01-17 19:45:27'),
(4181, 'da', 'common', 'Google Pagerank', 'Google Pagerank', '2014-01-17 19:45:27'),
(4182, 'da', 'common', 'help', 'Hjælp', '2014-01-17 19:45:27'),
(4183, 'da', 'common', 'hidenews', 'Skjul Seo Panel Nyheder\r\n', '2014-01-17 19:45:27'),
(4184, 'da', 'common', 'Id', 'ID', '2014-01-17 19:45:27'),
(4185, 'da', 'common', 'Inactivate', 'Inaktivere', '2014-01-17 19:45:27'),
(4186, 'da', 'common', 'Inactive', 'Inaktive\r\n', '2014-01-17 19:45:27'),
(4187, 'da', 'common', 'Invalid characters', 'Ugyldige tegn', '2014-01-17 19:45:27'),
(4188, 'da', 'common', 'Invalid code entered', 'Ugyldig indtastning\r\n', '2014-01-17 19:45:27'),
(4189, 'da', 'common', 'Invalid email address entered', 'Ugyldig indtastet email adresse\r\n', '2014-01-17 19:45:27'),
(4190, 'da', 'common', 'Invalid value', 'Ugyldig værdi', '2014-01-17 19:45:27'),
(4191, 'da', 'common', 'Keyword', 'Søgeord', '2014-01-17 19:45:27'),
(4192, 'da', 'common', 'Keywords', 'Søgeord', '2014-01-17 19:45:27'),
(4193, 'da', 'common', 'lang', 'Sprog', '2014-01-17 19:45:27'),
(4194, 'da', 'common', 'My Account', 'Min Konto', '2014-01-17 19:45:27'),
(4195, 'da', 'common', 'Name', 'Navn', '2014-01-17 19:45:27'),
(4196, 'da', 'common', 'No', 'Nej', '2014-01-17 19:45:27'),
(4197, 'da', 'common', 'No Keywords Found', 'Søgeord', '2014-01-17 19:45:27'),
(4198, 'da', 'common', 'No Records Found', 'Ingen Poster Fundet\r\n', '2014-01-17 19:45:27'),
(4199, 'da', 'common', 'noactivetools', 'Intet aktivt Seo Tools fundet!\r\n', '2014-01-17 19:45:27'),
(4200, 'da', 'common', 'nowebsites', 'Ingen Hjemmeside Fundet', '2014-01-17 19:45:27'),
(4201, 'da', 'common', 'password632', 'Adgangskoden skal have en længde mellem 6 og 32\r\n', '2014-01-17 19:45:27'),
(4202, 'da', 'common', 'passwordnotmatch', 'Adgangskoden stemmer ikke overens\r\n', '2014-01-17 19:45:27'),
(4203, 'da', 'common', 'Period', 'Periode', '2014-01-17 19:45:27'),
(4204, 'da', 'common', 'Priority', 'Prioritet', '2014-01-17 19:45:27'),
(4205, 'da', 'common', 'Profile', 'Profil', '2014-01-17 19:45:27'),
(4206, 'da', 'common', 'Rank', 'Rank', '2014-01-17 19:45:27'),
(4207, 'da', 'common', 'Reports', 'Rapporter', '2014-01-17 19:45:27'),
(4208, 'da', 'common', 'Results', 'Resultater', '2014-01-17 19:45:27'),
(4209, 'da', 'common', 'Search Engine', 'Søgemaskine', '2014-01-17 19:45:27'),
(4210, 'da', 'common', 'Select', 'Vælg', '2014-01-17 19:45:27'),
(4211, 'da', 'common', 'Seo Plugins', 'Seo Plugins', '2014-01-17 19:45:27'),
(4212, 'da', 'common', 'Seo Tools', 'Seo Værktøjer', '2014-01-17 19:45:27'),
(4213, 'da', 'common', 'Sign out', 'Log ud', '2014-01-17 19:45:27'),
(4214, 'da', 'common', 'Sign Up', 'Tilmeld', '2014-01-17 19:45:27'),
(4215, 'da', 'common', 'signin', 'Log på', '2014-01-17 19:45:27'),
(4216, 'da', 'common', 'Status', 'Status', '2014-01-17 19:45:27'),
(4217, 'da', 'common', 'Support', 'Support', '2014-01-17 19:45:27'),
(4218, 'da', 'common', 'Total', 'Total', '2014-01-17 19:45:27'),
(4219, 'da', 'common', 'Url', 'Url', '2014-01-17 19:45:27'),
(4220, 'da', 'common', 'User', 'Bruger', '2014-01-17 19:45:27'),
(4221, 'da', 'common', 'User Panel', 'Bruger Panel', '2014-01-17 19:45:27'),
(4222, 'da', 'common', 'Website', 'Hjemmeside', '2014-01-17 19:45:27'),
(4223, 'da', 'common', 'Yes', 'Ja', '2014-01-17 19:45:27'),
(4224, 'da', 'rank', 'enterurlproceed', 'Indtast URL\\''s <b> En per linie </b>. Klik på <b> Fortsæt </b> for at kontrollere Google og Alexa rang.\r\n', '2010-12-16 07:06:52'),
(4225, 'da', 'rank', 'Google and Alexa Rank Reports', 'Google og Alexa Rank Rapporter\r\n', '2010-12-16 07:06:52'),
(4226, 'da', 'rank', 'Saved rank results of', 'Gemte rank resultater\r\n', '2010-12-16 07:06:52'),
(4227, 'da', 'website', 'Edit Website', 'Rediger Hjemmesiden\r\n', '2010-12-16 07:44:33'),
(4228, 'da', 'website', 'plscrtwebsite', 'Før du starter at bruge seo værktøj og seo plugin, så opret venligst en hjemmeside.\r\n\r\n', '2010-12-16 07:44:33'),
(4229, 'da', 'website', 'Website already exist', 'hjemmesiden findes allerede\r\n', '2010-12-16 07:44:33'),
(4230, 'da', 'website', 'yourwebalreday', 'din hjemmeside, hvis du allerede har oprettet en.\r\n', '2010-12-16 07:44:33'),
(4231, 'da', 'user', 'Edit User', 'Rediger Bruger\r\n', '2010-12-16 07:45:31'),
(4232, 'da', 'user', 'Saved My Profile Details', 'Gem Min Profil Detaljer\r\n', '2010-12-16 07:45:31'),
(4233, 'da', 'label', 'already exist', 'findes allerede\r\n', '2014-01-17 19:52:14'),
(4234, 'da', 'label', 'Authentication', 'Autentificering', '2014-01-17 19:52:14'),
(4235, 'da', 'label', 'Author', 'Forfatter', '2014-01-17 19:52:14'),
(4236, 'da', 'label', 'Click Here', 'Klik her\r\n', '2014-01-17 19:52:14'),
(4237, 'da', 'label', 'Cron', 'Cron ', '2014-01-17 19:52:14'),
(4238, 'da', 'label', 'Description', 'Beskrivelse', '2014-01-17 19:52:14'),
(4239, 'da', 'label', 'Developers', 'Udviklere\r\n', '2014-01-17 19:52:14'),
(4240, 'da', 'label', 'Download', 'Download', '2014-01-17 19:52:14'),
(4241, 'da', 'label', 'Installation', 'Installation\r\n', '2014-01-17 19:52:14'),
(4242, 'da', 'label', 'Keywords', 'Søgeord', '2014-01-17 19:52:14'),
(4243, 'da', 'label', 'noactiveplugins', 'Intet aktivt Seo Plugin fundet!\r\n', '2014-01-17 19:52:14'),
(4244, 'da', 'label', 'Plugin', 'Plugin', '2014-01-17 19:52:14'),
(4245, 'da', 'label', 'Port', 'Port', '2014-01-17 19:52:14'),
(4246, 'da', 'label', 'Proxy', 'Proxy', '2014-01-17 19:52:14'),
(4247, 'da', 'label', 'Re-install', 'Geninstaller', '2014-01-17 19:52:14'),
(4248, 'da', 'label', 'Sponsors', 'Sponsorer', '2014-01-17 19:52:14'),
(4249, 'da', 'label', 'Title', 'Titel', '2014-01-17 19:52:14'),
(4250, 'da', 'label', 'translation by', 'oversat af\r\n', '2014-01-17 19:52:14'),
(4251, 'da', 'label', 'Translators', 'Oversættere', '2014-01-17 19:52:14'),
(4252, 'da', 'label', 'Upgrade', 'Opgrader', '2014-01-17 19:52:14'),
(4253, 'da', 'label', 'Version', 'Version', '2014-01-17 19:52:14'),
(4254, 'da', 'label', 'wantproceed', 'Vil du virkelig ønsker at fortsætte?', '2014-01-17 19:52:14'),
(4255, 'da', 'proxy', 'Edit Proxy', 'Rediger Proxy\r\n', '2014-01-20 09:44:35'),
(4256, 'da', 'proxy', 'Proxy Password', 'Proxy Kodeord\r\n', '2014-01-20 09:44:35'),
(4257, 'da', 'proxy', 'Proxy Username', 'Proxy Brugernavn\r\n', '2014-01-20 09:44:35'),
(4258, 'da', 'proxy', 'Proxyalreadyexist', 'Proxy findes allerede!\r\n', '2014-01-20 09:44:35'),
(4259, 'da', 'home', 'Account Summary', 'Konto resume', '2014-01-20 08:56:43'),
(4260, 'da', 'home', 'Backlinks', 'Backlinks', '2014-01-20 08:56:43'),
(4261, 'da', 'home', 'Directory Submission', 'Bibliotek tilmelding', '2014-01-20 08:56:43'),
(4262, 'da', 'home', 'home_cont1', '<h1 style="text-align: center;margin-bottom: 30px; font-size: 19px;">Velkommen til Seo Panels - Verdens første seo kontrolpanel til websteder</h1>\r\n<p> \r\nEn komplet <b> open source seo kontrolpanel</b> for at redigere søgemaskine optimering </b> af dine websites.\r\nSeo Panel er et <b> seo værktøj</b> inkludere det nyeste seo værktøjer for at <b> forøge og spore </b> ydelsen af dine websteder.\r\ndet er <b> gratis software</b> udgivet under <b>GNU GENERAL PUBLIC LICENSE</b>\r\nhoved værktøjet i seo panel er <b>udvidelses</b> mulighederne ved at bruge <a href ="<?=SP_PLUGINSITE?>"target="_blank">seo plugins</a>.\r\nMan kan nemt <b>udvikle og installere</b> de nødvendige plugins i ens seo panel\r\n</p>\r\n<p></p>\r\n<p>\r\nDet er et open-source software som er <b>udgivet i januar 2010</b>\r\nMed denne korte periode af tid, har tusinder af webmasters brugt denne software til at optimere deres hjemmeside. Brug seo panel i dag og <b> nyd</b> at alt seo er under <b>en platform</b>\r\n\r\n</p>\r\n\r\n ', '2014-01-20 08:56:43'),
(4263, 'da', 'home', 'home_cont2', '', '2014-01-20 08:56:43'),
(4264, 'da', 'home', 'home_cont3', '<fieldset> \r\n<legend>Seo Panel Online Resources</legend>     \r\n<ul class="infobox"> \r\n\r\n    <li> \r\n        <h1>Seo Panel Online resurcer for referencer</h1>                 \r\n         \r\n         \r\n        <p> \r\n            <a href="http://www.seopanel.in" target="_blank">Seo Panel Officielle hjemmeside</a> \r\n        </p> \r\n        <p> \r\n            <a href="<?=SP_DOWNLOAD_LINK?>" target="_blank">Download Seo Panel</a> \r\n        </p> \r\n         \r\n        <p> \r\n            <a href="<?=SP_DEMO_LINK?>" target="_blank">Seo Panel Demo</a> \r\n        </p> \r\n         \r\n        <p> \r\n            <a href="<?=SP_CONTACT_LINK?>" target="_blank">Kontakt Seo Panel</a> \r\n        </p> \r\n         \r\n        <p> \r\n            <a href="<?=SP_HELP_LINK?>" target="_blank">Seo Panel hjælpe guide</a> \r\n        </p> \r\n         \r\n        <p> \r\n            <a href="<?=SP_FORUM_LINK?>" target="_blank">Seo Panel Forum</a> \r\n        </p> \r\n         \r\n        <p> \r\n            <a href="<?=SP_SUPPORT_LINK?>" target="_blank">Seo Panel Support system</a> \r\n        </p> \r\n         \r\n        <p> \r\n            <a href="<?=SP_DONATE_LINK?>" target="_blank">Donér til Seo Panel</a> \r\n        </p> \r\n    </li> \r\n     \r\n</ul> \r\n</fieldset>', '2014-01-20 08:56:43'),
(4265, 'da', 'home', 'Pages Indexed', 'Sider der er indekseret', '2014-01-20 08:56:43'),
(4266, 'da', 'home', 'Ranks', 'Ranks', '2014-01-20 08:56:43'),
(4267, 'da', 'home', 'SiteNameUrl', 'Hjemmeside Navn/Url\r\n', '2014-01-20 08:56:43'),
(4268, 'da', 'home', 'Website Statistics', 'Hjemmeside Statistik\r\n', '2014-01-20 08:56:43'),
(4269, 'el', 'keyword', 'Crawling keyword', 'Ανίχνευση λέξης κλειδί', '2016-01-27 08:02:49'),
(4270, 'el', 'keyword', 'Detailed Keyword Position Reports', 'Λεπτομερής αναφορά κατάταξης της λέξης κλειδί', '2016-01-27 08:02:49'),
(4271, 'el', 'keyword', 'Edit Keyword', 'Επεξεργασία λέξης κλειδί', '2016-01-27 08:02:49'),
(4272, 'el', 'keyword', 'Graphical Keyword Position Reports', 'Γραφικές αναφορές κατάταξης των λέξεων κλειδιών ', '2016-01-27 08:02:49'),
(4273, 'el', 'keyword', 'Import Keywords', 'Εισαγωγή λέξεων κλειδιών', '2016-01-27 08:02:49'),
(4274, 'el', 'keyword', 'Keyword already exist', 'Η λέξη κλειδί ήδη υπάρχει', '2016-01-27 08:02:49'),
(4275, 'el', 'keyword', 'Keyword Position Report', 'Αναφορά κατάταξης της λέξης κλειδί', '2016-01-27 08:02:49'),
(4276, 'el', 'keyword', 'New Keyword', 'Νέα λέξη κλειδί', '2016-01-27 08:02:49'),
(4277, 'el', 'keyword', 'not assigned to required search engines', 'δεν υπάγονται στις απαιτούμενες μηχανές αναζήτησης', '2016-01-27 08:02:49'),
(4278, 'el', 'keyword', 'pleaseselecttool', 'Παρακαλώ επιλέξτε τουλάχιστον ένα Seo Εργαλείο', '2016-01-27 08:02:49'),
(4279, 'el', 'keyword', 'Quick Keyword Position Checker', 'Γρήγορη αναζήτησης κατάταξης της λέξης κλειδί', '2016-01-27 08:02:49'),
(4280, 'el', 'keyword', 'results from ', 'αποτελέσματα από', '2016-01-27 08:02:49'),
(4281, 'el', 'keyword', 'Show All results', 'Προβολή όλων των αποτελεσμάτων', '2016-01-27 08:02:49'),
(4282, 'el', 'keyword', 'Successfully crawled keyword', 'Επιτυχής ανίχνευση της λέξη κλειδί', '2016-01-27 08:02:49'),
(4283, 'el', 'keyword', 'to create new keywords', 'για να δημιουργήσετε νέες λέξεις κλειδιά', '2016-01-27 08:02:49'),
(4284, 'el', 'rank', 'enterurlproceed', 'Εισάγετε τα URL\\''s <b>ένα σε κάθε γραμμή</b>. Κάνετε κλικ στο <b>Ανάθεση</b> για τον έλεγχο του Google Rank και του Alexa rank. ', '2010-12-23 08:30:08'),
(4285, 'el', 'rank', 'Google and Alexa Rank Reports', 'Αναφορά Google Rank και Alexa Rank ', '2010-12-23 08:30:08'),
(4286, 'el', 'rank', 'Saved rank results of', 'Αποθήκευση αποτελεσμάτων Rank για ', '2010-12-23 08:30:08'),
(4287, 'el', 'panel', 'About Us', 'Για Εμάς', '2017-07-17 11:24:15'),
(4288, 'el', 'panel', 'Add following command to your cron tab', 'Προσθέστε ακόλουθη εντολή για στην καρτέλα cron', '2017-07-17 11:24:15'),
(4289, 'el', 'panel', 'alsocheckfollowlink', 'Επίσης ελέγξτε ακόλουθο link αν χρειάζεστε περισσότερες πληροφορίες', '2017-07-17 11:24:15'),
(4290, 'el', 'panel', 'Check Directory', 'Έλεγχος καταλόγου', '2017-07-17 11:24:15'),
(4291, 'el', 'panel', 'Cron Command', 'Εντολή Cron', '2017-07-17 11:24:15'),
(4292, 'el', 'panel', 'Directory Manager', 'Διαχείριση καταλόγου', '2017-07-17 11:24:15'),
(4293, 'el', 'panel', 'Edit My Profile', 'Επεξεργασία του Προφίλ μου', '2017-07-17 11:24:15'),
(4294, 'el', 'panel', 'My Profile', 'To Προφίλ μου', '2017-07-17 11:24:15'),
(4295, 'el', 'panel', 'New Proxy', 'Νέο Proxy', '2017-07-17 11:24:15'),
(4296, 'el', 'panel', 'New User', 'Νέος Χρήστης', '2017-07-17 11:24:15'),
(4297, 'el', 'panel', 'New Website', 'Νέο Website', '2017-07-17 11:24:15'),
(4298, 'el', 'panel', 'Proxy Manager', 'Διαχείριση Proxy', '2017-07-17 11:24:15'),
(4299, 'el', 'panel', 'Report Generation Manager', 'Διαχείριση Παραγωγής Αναφορών', '2017-07-17 11:24:15'),
(4300, 'el', 'panel', 'Reports Manager', 'Διαχείριση αναφορών', '2017-07-17 11:24:15'),
(4301, 'el', 'panel', 'Seo Plugins Manager', 'Διαχείριση Seo Plugins', '2017-07-17 11:24:15'),
(4302, 'el', 'panel', 'Seo Tools Manager', 'Διαχείριση Seo Εργαλεία', '2017-07-17 11:24:15'),
(4303, 'el', 'panel', 'System Settings', 'Ρυθμίσεις Συστήματος', '2017-07-17 11:24:15'),
(4304, 'el', 'panel', 'User Manager', 'Διαχείριση Χρηστών', '2017-07-17 11:24:15'),
(4305, 'el', 'panel', 'Website Manager', 'Διαχείριση Website', '2017-07-17 11:24:15'),
(4306, 'el', 'label', 'already exist', 'υπάρχει ήδη', '2017-07-17 11:21:25'),
(4307, 'el', 'label', 'Authentication', 'Πιστοποίηση', '2017-07-17 11:21:25'),
(4308, 'el', 'label', 'Author', 'Συγγραφέας', '2017-07-17 11:21:25'),
(4309, 'el', 'label', 'Click Here', 'Κλικ Εδώ', '2017-07-17 11:21:25'),
(4310, 'el', 'label', 'Cron', 'Cron', '2017-07-17 11:21:25'),
(4311, 'el', 'label', 'Description', 'Περιγραφή', '2017-07-17 11:21:25'),
(4312, 'el', 'label', 'Developers', 'Ανάπτυξη', '2017-07-17 11:21:25'),
(4313, 'el', 'label', 'Download', 'Λήψη', '2017-07-17 11:21:25'),
(4314, 'el', 'label', 'Installation', 'Εγκατάσταση', '2017-07-17 11:21:25'),
(4315, 'el', 'label', 'Keywords', 'Λέξεις κλειδιά', '2017-07-17 11:21:25'),
(4316, 'el', 'label', 'noactiveplugins', 'Δεν βρέθηκαν ενεργά Seo Plugin', '2017-07-17 11:21:25'),
(4317, 'el', 'label', 'Plugin', 'Pugin', '2017-07-17 11:21:25'),
(4318, 'el', 'label', 'Port', 'Port', '2017-07-17 11:21:25'),
(4319, 'el', 'label', 'Proxy', 'Proxy', '2017-07-17 11:21:25'),
(4320, 'el', 'label', 'Re-install', 'Επανεγκατάσταση ', '2017-07-17 11:21:25'),
(4321, 'el', 'label', 'Sponsors', 'Χορηγοί', '2017-07-17 11:21:25'),
(4322, 'el', 'label', 'Title', 'Τίτλος', '2017-07-17 11:21:25'),
(4323, 'el', 'label', 'translation by', 'μετάφραση από τον', '2017-07-17 11:21:25'),
(4324, 'el', 'label', 'Translators', 'Μεταφραστές', '2017-07-17 11:21:25'),
(4325, 'el', 'label', 'Upgrade', 'Αναβάθμιση', '2017-07-17 11:21:25'),
(4326, 'el', 'label', 'Version', 'Έκδοση', '2017-07-17 11:21:25'),
(4327, 'el', 'label', 'wantproceed', 'Θέλετε πραγματικά να προχωρήσει;', '2017-07-17 11:21:25'),
(4328, 'el', 'seotools', 'Automatic Submission', 'Αυτόματη Καταχώρηση ', '2017-07-17 11:26:22'),
(4329, 'el', 'seotools', 'backlink-checker', 'Ελεγκτής Backlink', '2017-07-17 11:26:22'),
(4330, 'el', 'seotools', 'Backlinks Reports', 'Αναφορές Backlink', '2017-07-17 11:26:22'),
(4331, 'el', 'seotools', 'Check Submission Status', 'Έλεγχος κατάστασης καταχώρησης', '2017-07-17 11:26:22'),
(4332, 'el', 'seotools', 'clickgeneratereports', 'Κάντε κλικ στο <b>Εκκίνηση</b> για την παραγωγή αναφορών', '2017-07-17 11:26:22'),
(4333, 'el', 'seotools', 'Detailed Position Reports', 'λεπτομερείς αναφορές κατάταξης', '2017-07-17 11:26:22'),
(4334, 'el', 'seotools', 'directory-submission', 'Καταχώρηση σε καταλόγους', '2017-07-17 11:26:22'),
(4335, 'el', 'seotools', 'Featured Submission', 'Προτεινόμενη Καταχώρηση', '2017-07-17 11:26:22'),
(4336, 'el', 'seotools', 'Generate Backlinks Reports', 'Παραγωγή Αναφορών Backlink', '2017-07-17 11:26:22'),
(4337, 'el', 'seotools', 'Generate Keyword Reports', 'Παραγωγή Αναφορών Λέξεων Κλειδιών', '2017-07-17 11:26:22'),
(4338, 'el', 'seotools', 'Generate Rank Reports', 'Παραγωγή Αναφορών Rank', '2017-07-17 11:26:22'),
(4339, 'el', 'seotools', 'Generate Saturation Reports', 'Παραγωγή Αναφορών Κορεσμού', '2017-07-17 11:26:22'),
(4340, 'el', 'seotools', 'Google Sitemap Generator', 'Παραγωγή Google Sitemap', '2017-07-17 11:26:22'),
(4341, 'el', 'seotools', 'Graphical Position Reports', 'Γραφικές Αναφορές Κατάταξης', '2017-07-17 11:26:22'),
(4342, 'el', 'seotools', 'Keyword Position Summary', 'Σύνοψη Κατάταξης Λέξεων Κλειδιών', '2017-07-17 11:26:22'),
(4343, 'el', 'seotools', 'keyword-position-checker', 'Έλεγχος Κατάταξης Λέξεων Κλειδιών', '2017-07-17 11:26:22'),
(4344, 'el', 'seotools', 'Keywords Manager', 'Διαχείριση Λέξεων Κλειδιών', '2017-07-17 11:26:22'),
(4345, 'el', 'seotools', 'Quick Backlinks Checker', 'Γρήγορος Έλεγχος Backlinks ', '2017-07-17 11:26:22'),
(4346, 'el', 'seotools', 'Quick Position Checker', 'Γρήγορος Έλεγχος Κατάταξης', '2017-07-17 11:26:22'),
(4347, 'el', 'seotools', 'Quick Rank Checker', 'Γρήγορος Έλεγχος Rank', '2017-07-17 11:26:22'),
(4348, 'el', 'seotools', 'Quick Saturation Checker', 'Γρήγορος Έλεγχος Κορεσμού', '2017-07-17 11:26:22'),
(4349, 'el', 'seotools', 'Rank Reports', 'Αναφορές Rank', '2017-07-17 11:26:22'),
(4350, 'el', 'seotools', 'rank-checker', 'Έλεγχος Rank', '2017-07-17 11:26:22'),
(4351, 'el', 'seotools', 'Saturation Reports', 'Αναφορές Κορεσμού', '2017-07-17 11:26:22'),
(4352, 'el', 'seotools', 'saturation-checker', 'Κορεσμός Μηχανής Αναζήτησης', '2017-07-17 11:26:22'),
(4353, 'el', 'seotools', 'sitemap-generator', 'Παραγωγή Sitemap', '2017-07-17 11:26:22'),
(4354, 'el', 'seotools', 'Skipped Directories', 'Κατάλογοι εν Αναμονή', '2017-07-17 11:26:22'),
(4355, 'el', 'seotools', 'Submission Reports', 'Αναφορές Καταχώρησης', '2017-07-17 11:26:22'),
(4356, 'el', 'seotools', 'User Access', 'Πρόσβαση Χρήστη', '2017-07-17 11:26:22'),
(4357, 'el', 'login', 'Confirm Password', 'Επιβεβαίωση κωδικού', '2016-01-27 08:04:41'),
(4358, 'el', 'login', 'Create my account', 'Δημιούργησε τον λογαριασμό μου', '2016-01-27 08:04:41'),
(4359, 'el', 'login', 'Create New Account', 'Δημιουργία λογαριασμού', '2016-01-27 08:04:41'),
(4360, 'el', 'login', 'Email', 'Email', '2016-01-27 08:04:41'),
(4361, 'el', 'login', 'emailexist', 'Το Email ήδη υπάρχει!', '2016-01-27 08:04:41'),
(4362, 'el', 'login', 'Enter the code as it is shown', 'Πληκτρολογήστε τον κωδικό όπως φαίνεται', '2016-01-27 08:04:41'),
(4363, 'el', 'login', 'First Name', 'Όνομα', '2016-01-27 08:04:41'),
(4364, 'el', 'login', 'Last Name', 'Επώνυμο', '2016-01-27 08:04:41'),
(4365, 'el', 'login', 'Login', 'Σύνδεση', '2016-01-27 08:04:41'),
(4366, 'el', 'login', 'Login incorrect', 'Αποτυχία σύνδεσης', '2016-01-27 08:04:41'),
(4367, 'el', 'login', 'newaccountsuccess', 'Ο νέος λογαριασμός δημιουργήθηκε με επιτυχία!', '2016-01-27 08:04:41'),
(4368, 'el', 'login', 'Password', 'Κωδικός', '2016-01-27 08:04:41'),
(4369, 'el', 'login', 'Password incorrect', 'Λάθος κωδικός', '2016-01-27 08:04:41'),
(4370, 'el', 'login', 'Register', 'Εγγραφή', '2016-01-27 08:04:41'),
(4371, 'el', 'login', 'Sign in to your account', 'Συνδεθείτε στον λογαριασμό σας', '2016-01-27 08:04:41'),
(4372, 'el', 'login', 'User inactive', 'Μη ενεργός χρήστης', '2016-01-27 08:04:41'),
(4373, 'el', 'login', 'Username', 'Όνομα χρήστη', '2016-01-27 08:04:41'),
(4374, 'el', 'login', 'usernameexist', 'Το όνομα χρήστη ήδη υπάρχει!', '2016-01-27 08:04:41'),
(4375, 'el', 'saturation', 'clickproceedsaturation', 'Πληκτρολογήστε τα URL\\''s <b>Ένα σε κάθε γραμμή</b>. Κάντε κλικ στο <b>Ανάθεση</b> για να δείτε τα αποτελέσματα Κορεσμού της Μηχανής Αναζήτησης', '2010-12-23 09:01:23'),
(4376, 'el', 'saturation', 'GenerateSaturationReports', 'Παραγωγή Αναφορών Κορεσμού για την Μηχανή Αναζήτησης', '2010-12-23 09:01:23'),
(4377, 'el', 'saturation', 'Quick Search Engine Saturation Checker', 'Γρήγορος Έλεγχος Κορεσμού της Μηχανής Αναζήτησης', '2010-12-23 09:01:23'),
(4378, 'el', 'saturation', 'Saved Search Engine Saturation results of', 'Αποθήκευση των αποτελεσμάτων Κορεσμού της Μηχανής Αναζήτησης για', '2010-12-23 09:01:23'),
(4379, 'el', 'saturation', 'Search Engine Saturation Reports', 'Αναφορές Κορεσμού Μηχανής Αναζήτησης', '2010-12-23 09:01:23'),
(4380, 'ja', 'backlink', 'clickproceedbacklink', 'URLを<b>一行につき１つ</b>入力してください。バックリンクをチェックするには<b>開始</b>をクリックします。', '2011-01-07 14:13:00'),
(4381, 'ja', 'backlink', 'Saved backlink results of', 'バックリンク結果を保存しました', '2011-01-07 14:13:00'),
(4382, 'ja', 'button', 'Cancel', 'キャンセル', '2014-01-08 19:28:54'),
(4383, 'ja', 'button', 'Check Status', '状態をチェック', '2014-01-08 19:28:54'),
(4384, 'ja', 'button', 'Proceed', '開始', '2014-01-08 19:28:54'),
(4385, 'ja', 'button', 'Reload', 'リロード', '2014-01-08 19:28:54'),
(4386, 'ja', 'button', 'Show Details', '詳細を表示', '2014-01-08 19:28:54'),
(4387, 'ja', 'button', 'Show Records', '履歴を表示', '2014-01-08 19:28:54'),
(4388, 'ja', 'button', 'Skip', 'スキップ', '2014-01-08 19:28:54'),
(4389, 'ja', 'button', 'Submit', '送信', '2014-01-08 19:28:54'),
(4390, 'ja', 'common', 'Action', 'アクション', '2016-12-12 04:25:10'),
(4391, 'ja', 'common', 'Activate', '起動', '2016-12-12 04:25:10'),
(4392, 'ja', 'common', 'Active', 'アクティブ', '2016-12-12 04:25:10'),
(4393, 'ja', 'common', 'Admin Panel', '管理パネル', '2016-12-12 04:25:10'),
(4394, 'ja', 'common', 'Alexa Rank', 'Alexaランク', '2016-12-12 04:25:10'),
(4395, 'ja', 'common', 'All', 'すべて', '2016-12-12 04:25:10'),
(4396, 'ja', 'common', 'Category', 'カテゴリ', '2016-12-12 04:25:10'),
(4397, 'ja', 'common', 'contact', '問合せ', '2016-12-12 04:25:10'),
(4398, 'ja', 'common', 'copyright', '著作権 © [year] www.seopanel.in　無断での複写・転載禁止', '2016-12-12 04:25:10'),
(4399, 'ja', 'common', 'Country', '国', '2016-12-12 04:25:10'),
(4400, 'ja', 'common', 'Crawl Meta Data', 'メタデータをクロール', '2016-12-12 04:25:10'),
(4401, 'ja', 'common', 'Date', '日付', '2016-12-12 04:25:10'),
(4402, 'ja', 'common', 'Delete', '削除', '2016-12-12 04:25:10'),
(4403, 'ja', 'common', 'Details', '詳細', '2016-12-12 04:25:10'),
(4404, 'ja', 'common', 'Directory', 'ディレクトリ', '2016-12-12 04:25:10'),
(4405, 'ja', 'common', 'Donate', '寄付', '2016-12-12 04:25:10'),
(4406, 'ja', 'common', 'Edit', '編集', '2016-12-12 04:25:10'),
(4407, 'ja', 'common', 'Entry cannot be blank', '入力は必須です', '2016-12-12 04:25:10'),
(4408, 'ja', 'common', 'entrynotvalid', '入力したデータが無効のようです', '2016-12-12 04:25:10'),
(4409, 'ja', 'common', 'failed', '失敗', '2016-12-12 04:25:10'),
(4410, 'ja', 'common', 'forum', 'フォーラム', '2016-12-12 04:25:10'),
(4411, 'ja', 'common', 'Found', '検出', '2016-12-12 04:25:10'),
(4412, 'ja', 'common', 'Google Pagerank', 'Googleページランク', '2016-12-12 04:25:10'),
(4413, 'ja', 'common', 'help', 'ヘルプ', '2016-12-12 04:25:10'),
(4414, 'ja', 'common', 'hidenews', 'Seo Panelニュースを隠す', '2016-12-12 04:25:10'),
(4415, 'ja', 'common', 'Id', 'ID', '2016-12-12 04:25:10'),
(4416, 'ja', 'common', 'Inactivate', '終了', '2016-12-12 04:25:10'),
(4417, 'ja', 'common', 'Inactive', '非アクティブ', '2016-12-12 04:25:10'),
(4418, 'ja', 'common', 'Invalid characters', '無効な文字', '2016-12-12 04:25:10'),
(4419, 'ja', 'common', 'Invalid code entered', '無効なコードが入力されています', '2016-12-12 04:25:10'),
(4420, 'ja', 'common', 'Invalid email address entered', '無効なメールアドレスが入力されています', '2016-12-12 04:25:10'),
(4421, 'ja', 'common', 'Invalid value', '不正な値', '2016-12-12 04:25:10'),
(4422, 'ja', 'common', 'Keyword', 'キーワード', '2016-12-12 04:25:10'),
(4423, 'ja', 'common', 'Keywords', 'キーワード', '2016-12-12 04:25:10'),
(4424, 'ja', 'common', 'lang', '言語', '2016-12-12 04:25:10'),
(4425, 'ja', 'common', 'My Account', 'マイアカウント', '2016-12-12 04:25:10'),
(4426, 'ja', 'common', 'Name', '名前', '2016-12-12 04:25:10'),
(4427, 'ja', 'common', 'No', 'いいえ', '2016-12-12 04:25:10'),
(4428, 'ja', 'common', 'No Keywords Found', 'キーワードはありません', '2016-12-12 04:25:10'),
(4429, 'ja', 'common', 'No Records Found', '履歴はありません', '2016-12-12 04:25:10'),
(4430, 'ja', 'common', 'noactivetools', 'アクティブなSeoツールはありません！', '2016-12-12 04:25:10'),
(4431, 'ja', 'common', 'nowebsites', 'ウェブサイトはありません', '2016-12-12 04:25:10'),
(4432, 'ja', 'common', 'password632', 'パスワードは6～32文字です', '2016-12-12 04:25:10'),
(4433, 'ja', 'common', 'passwordnotmatch', 'パスワードが一致しません', '2016-12-12 04:25:10'),
(4434, 'ja', 'common', 'Period', '期間', '2016-12-12 04:25:10'),
(4435, 'ja', 'common', 'Priority', '優先度', '2016-12-12 04:25:10'),
(4436, 'ja', 'common', 'Profile', 'プロフィール', '2016-12-12 04:25:10'),
(4437, 'ja', 'common', 'Rank', 'ランク', '2016-12-12 04:25:10'),
(4438, 'ja', 'common', 'Reports', 'レポート', '2016-12-12 04:25:10'),
(4439, 'ja', 'common', 'Results', '結果', '2016-12-12 04:25:10'),
(4440, 'ja', 'common', 'Search Engine', '検索エンジン', '2016-12-12 04:25:10'),
(4441, 'ja', 'common', 'Select', '選択', '2016-12-12 04:25:10'),
(4442, 'ja', 'common', 'Seo Plugins', 'Seoプラグイン', '2016-12-12 04:25:10'),
(4443, 'ja', 'common', 'Seo Tools', 'Seoツール', '2016-12-12 04:25:10'),
(4444, 'ja', 'common', 'Sign out', 'ログアウト', '2016-12-12 04:25:10'),
(4445, 'ja', 'common', 'Sign Up', '登録', '2016-12-12 04:25:10'),
(4446, 'ja', 'common', 'signin', 'ログイン', '2016-12-12 04:25:10'),
(4447, 'ja', 'common', 'Status', '状態', '2016-12-12 04:25:10'),
(4448, 'ja', 'common', 'Support', 'サポート', '2016-12-12 04:25:10'),
(4449, 'ja', 'common', 'Total', '合計', '2016-12-12 04:25:10'),
(4450, 'ja', 'common', 'Url', 'URL', '2016-12-12 04:25:10'),
(4451, 'ja', 'common', 'User', 'ユーザ', '2016-12-12 04:25:10'),
(4452, 'ja', 'common', 'User Panel', 'ユーザパネル', '2016-12-12 04:25:10'),
(4453, 'ja', 'common', 'Website', 'ウェブサイト', '2016-12-12 04:25:10'),
(4454, 'ja', 'common', 'Yes', 'はい', '2016-12-12 04:25:10'),
(4455, 'ja', 'directory', 'Add back to directory list', 'ディレクトリリストへ戻す', '2012-11-09 04:20:41'),
(4456, 'ja', 'directory', 'Approved', '承認済', '2012-11-09 04:20:41'),
(4457, 'ja', 'directory', 'Captcha', 'キャプチャ', '2012-11-09 04:20:41'),
(4458, 'ja', 'directory', 'categorynote', 'カテゴリ、優先順にカンマで区切る。最優先カテゴリが一番目。', '2012-11-09 04:20:41'),
(4459, 'ja', 'directory', 'Check Directory Status', 'ディレクトリ状態をチェック', '2012-11-09 04:20:41'),
(4460, 'ja', 'directory', 'Check Directory Submission Status', 'ディレクトリサブミッション状態をチェック', '2012-11-09 04:20:41'),
(4461, 'ja', 'directory', 'clicktoproceeddirsts', 'ディレクトリ状態をチェックするには<b>開始</b>をクリック', '2012-11-09 04:20:41'),
(4462, 'ja', 'directory', 'Confirmation', '確認', '2012-11-09 04:20:41'),
(4463, 'ja', 'directory', 'desnote', 'ディレクトリによっては、ディスクリプション欄に最低150文字必要です。', '2012-11-09 04:20:41'),
(4464, 'ja', 'directory', 'Directories with out captcha', 'キャプチャなしのディレクトリ', '2012-11-09 04:20:41'),
(4465, 'ja', 'directory', 'Directory Submission Reports', 'ディレクトリサブミッションレポート', '2012-11-09 04:20:41'),
(4466, 'ja', 'directory', 'Enter the code shown', '表示されているコードを入力', '2012-11-09 04:20:41'),
(4467, 'ja', 'directory', 'nocatnote', 'サブミッションページに送信カテゴリはありません。<b>リロード</b>もしくは<b>スキップ</b>をクリックしてください', '2012-11-09 04:20:41'),
(4468, 'ja', 'directory', 'nodirnote', '<b>アクティブ</b>なディレクトリはありません', '2012-11-09 04:20:41'),
(4469, 'ja', 'directory', 'nosuccessnote', '成功メッセージを取得できませんでした、メールをチェックして確認メッセージをご確認ください', '2012-11-09 04:20:41'),
(4470, 'ja', 'directory', 'optionalnote', 'より良い結果を得る目的で、タイトルとディスクリプションをランダムにディレクトリへ送信するための任意のタイトル及びディスクリプション。', '2012-11-09 04:20:41'),
(4471, 'ja', 'directory', 'Owner Email', '所有者メールアドレス', '2012-11-09 04:20:41'),
(4472, 'ja', 'directory', 'Owner Name', '所有者名', '2012-11-09 04:20:41'),
(4473, 'ja', 'directory', 'Pending', '保留', '2012-11-09 04:20:41'),
(4474, 'ja', 'directory', 'Please select a website to proceed', '実行するウェブサイトを選択してください', '2012-11-09 04:20:41'),
(4475, 'ja', 'directory', 'selectwebsiteproceed', 'ディレクトリサブミッションを<b>実行</b>する<b>ウェブサイト</b>を選択してください。<br>キャプチャなしでディレクトリへ送信するには<b>キャプチャなしのディレクトリ</b>をチェックしてください', '2012-11-09 04:20:41'),
(4476, 'ja', 'directory', 'selectwebsiteschecksub', 'ディレクトリサブミッションチェックを<b>実行</b>する<b>ウェブサイト</b>を選択してください', '2012-11-09 04:20:41'),
(4477, 'ja', 'directory', 'Semi Automatic Directory Submission Tool', '半自動ディレクトリサブミッションツール', '2012-11-09 04:20:41'),
(4478, 'ja', 'directory', 'spamemailnote', 'ディレクトリがスパムを送信する可能性もありますので、大切なメールアドレスの使用はお控えください。', '2012-11-09 04:20:41'),
(4479, 'ja', 'directory', 'Submission Details', 'サブミッション詳細', '2012-11-09 04:20:41'),
(4480, 'ja', 'directory', 'Submit Description', '送信ディスクリプション', '2012-11-09 04:20:41'),
(4481, 'ja', 'directory', 'Submit Keywords', '送信キーワード', '2012-11-09 04:20:41'),
(4482, 'ja', 'directory', 'Submit Title', '送信タイトル', '2012-11-09 04:20:41'),
(4483, 'ja', 'directory', 'Website Category', 'ウェブサイトカテゴリ', '2012-11-09 04:20:41'),
(4484, 'ja', 'directory', 'Website Url', 'ウェブサイトURL', '2012-11-09 04:20:41'),
(4485, 'ja', 'home', 'Account Summary', 'アカウントサマリ', '2011-07-05 13:26:54'),
(4486, 'ja', 'home', 'Backlinks', 'バックリンク', '2011-07-05 13:26:54'),
(4487, 'ja', 'home', 'Directory Submission', 'ディレクトリサブミッション', '2011-07-05 13:26:54');
INSERT INTO `texts` (`id`, `lang_code`, `category`, `label`, `content`, `changed`) VALUES
(4488, 'ja', 'home', 'home_cont1', '<h1 style=\\"text-align: center;margin-bottom: 30px;font-size: 19px;\\">ようこそSeo Panelへ - 世界初の\r\n複数ウェブサイト対応SEOコントロールパネル</h1>\r\n        <p>\r\n            ウェブサイトの<b>検索エンジン最適化</b>を管理するための完全な<b>オープンソースSEOコントロールパネル</b>。 \r\n            Seo Panelは、ウェブサイト<b>パフォーマンス</b>の<b>向上および追跡</b>に特化した魅力的な最新SEOツールを備えた<b>SEOツールキット</b>です。\r\n            <b>GNU GENERAL PUBLIC LICENSE</b>に基づいてリリースされる<b>フリーソフトウェア</b>です。\r\n            seo panelの主な特徴は、その<b>拡張性</b>にあり、<a href=\\"<?=SP_PLUGINSITE?>\\"\r\ntarget=\\"_blank\\">seoプラグイン</a>を使って実現されます。\r\n            誰でも簡単に、それぞれのseo panelに必要なプラグインを<b>開発しインストール</b>することができます。 \r\n        </p>\r\n        <p></p>\r\n        <p>\r\n            このオープンソースソフトウェアは、<b>2010年1月にリリースされました</b>。\r\n            この<b>短期間</b>の内に、実に<b>数千</b>に上る<b>ウェブマスター達</b>が、ウェブサイトの<b>最適化</b>にこのソフトウェアを使用しているのです。\r\n            さっそく今日からseo panelを使って、SEOに関連するすべてを<b>単一プラットフォーム</b>下で<b>活用しましょう</b>。\r\n        </p>', '2011-07-05 13:26:54'),
(4489, 'ja', 'home', 'home_cont2', '<fieldset>\r\n<legend>Seo Panelの主な特徴 <?=SP_INSTALLED?></legend>\r\n<ul class=\\"infobox\\">\r\n    <li>        \r\n        <h1>自動ディレクトリサブミッションツール</h1>\r\n        <p>\r\n            自動ディレクトリサブミッションツールは、主要な<b>無料および有料のインターネットディレクトリ</b>へ<b>ウェブサイトを送信</b>するのに役立ちます。\r\n            また、サブミッション<b>ステータスチェッカースクリプト</b>を使うことで、<b>定期チェック</b>を通じて各サブミッションの<b>状態を追跡</b>することもできます。\r\n            <b>ディレクトリマネージャー</b>を使うと、<b>ディレクトリがアクティブ</b>か非アクティブかを容易に判断することができます。\r\n        </p>\r\n    </li>\r\n    <li>        \r\n        <h1>キーワード順位チェッカー</h1>\r\n        <p>\r\n            キーワード順位チェッカーは、ウェブサイトの<b>対象キーワード</b>の<b>検索エンジン順位</b>を検出し、システムに<b>保存</b>します。\r\n            キーワード順位レポートセクションでは、 各検索エンジンにおけるキーワードの<b>日毎の順位</b>を<b>綺麗なグラフ</b>と<b>詳細なレポート</b>にて確認することができます。\r\n        </p>\r\n    </li>\r\n    <li>        \r\n        <h1>サイト監査</h1>\r\n        <p>サイト監査は、サイトの各ページの<b>SEOファクターをすべて監査し</b>、それぞれにページに対し<b>詳細なレポート</b>を提供します。これは、検索エンジンへの<b>サブミット</b>向けに、 <b>XML,HTML,TEXT</b>サイトマップファイルを作成するのに役立ちます。</p>\r\n    </li> \r\n    <li>        \r\n        <h1>GoogleおよびAlexaランクチェッカー</h1>\r\n        <p>\r\n            GoogleおよびAlexaランクチェッカーは、ウェブサイトの<b>googleページランク</b>と<b>Alexa ランク</b>を検出し、システムに<b>保存</b>します。\r\n            <b>ランクレポート</b>セクションでは、各ウェブサイトの<b>日毎の</b>googleおよびAlexaランキングを<b>詳細レポート</b>にて確認できます。\r\n        </p>\r\n    </li>\r\n    <li>        \r\n        <h1>バックリンクチェッカー</h1>\r\n        <p>\r\n            バックリンクチェッカーは、各検索エンジン<b>(google,yahoo,msn etc)</b>におけるウェブサイトのバックリンク数を検出し、それをシステムに<b>保存</b>します。\r\n            <br><b>バックリンクレポート</b>セクションでは、各ウェブサイトの<b>日毎のバックリンク数</b>を<b>詳細レポート</b>にて確認することができます。\r\n        </p>\r\n    </li>    \r\n    <li>        \r\n        <h1>検索エンジンサチュレーションチェッカー</h1>\r\n        <p>\r\n            検索エンジンサチュレーションチェッカーは、各検索エンジン<b>(google,yahoo,msn etc)</b>におけるウェブサイトの<b>インデックスされたページ数</b>を検出し、システムに<b>保存</b>します。\r\n            <b>検索エンジンサチュレーションチェッカーレポート</b>セクションでは、各ウェブサイトの<b>日毎のインデックスされたページ数</b>を<b>詳細レポート</b>にて確認することができます。\r\n        </p>\r\n    </li>\r\n    <li>        \r\n        <h1>Seo Panelプラグイン</h1>\r\n        <p>\r\n            Seoコントロールパネルの<b>主な特徴</b>は、その<b>拡張性</b>です。\r\n            各自の要件に応じて、seo panelに<b>seoプラグイン</b>を追加し、<b>機能を拡張</b>することができます。\r\n            <a href=\\"<?=SP_PLUGINSITE?>\\" target=\\"_blank\\">Seo panel プラグイン</a>は、seo panelおよびサードパーティサイトの両方によって提供されます。\r\n            各自のseo panel向けにseoプラグインを<b>開発</b>することも簡単に可能です。\r\n            seo panelに各自のseoプラグインを<a href=\\"<?=SP_PLUGINSITE?>\\" target=\\"_blank\\">送信</a>して頂くと、こちらで<b>審査</b>をした後<b>公開</b>いたします。\r\n        </p>\r\n    </li>\r\n    <li>        \r\n        <h1>メタタグジェネレータ</h1>\r\n        <p>\r\n            メタタグジェネレータは、<b>カスタムメタタグ</b>を作成するための<b>seo panelプラグイン</b>です。\r\n            これにより、検索エンジンボットがウェブサイトをクロールする際、<b>より多くの情報</b>を提供することが可能になります。\r\n        </p>\r\n    </li>\r\n</ul>\r\n</fieldset>', '2011-07-05 13:26:54'),
(4490, 'ja', 'home', 'home_cont3', '<fieldset>\r\n<legend>Seo Panel オンラインリソース</legend>    \r\n<ul class=\\"infobox\\">\r\n\r\n    <li>\r\n        <h1>お役立ち Seo Panel オンラインリソース</h1>                \r\n        \r\n        \r\n        <p>\r\n            <a href=\\"http://www.seopanel.in\\" target=\\"_blank\\">Seo Panel オフィシャルサイト</a>\r\n        </p>\r\n        <p>\r\n            <a href=\\"<?=SP_DOWNLOAD_LINK?>\\" target=\\"_blank\\">Seo Panel ダウロード</a>\r\n        </p>\r\n        \r\n        <p>\r\n            <a href=\\"<?=SP_DEMO_LINK?>\\" target=\\"_blank\\">Seo Panel デモ</a>\r\n        </p>\r\n        \r\n        <p>\r\n            <a href=\\"<?=SP_CONTACT_LINK?>\\" target=\\"_blank\\">Seo Panel　問合せ</a>\r\n        </p>\r\n        \r\n        <p>\r\n            <a href=\\"<?=SP_HELP_LINK?>\\" target=\\"_blank\\">Seo Panel ヘルプガイド</a>\r\n        </p>\r\n        \r\n        <p>\r\n            <a href=\\"<?=SP_FORUM_LINK?>\\" target=\\"_blank\\">Seo Panel フォーラム</a>\r\n        </p>\r\n        \r\n        <p>\r\n            <a href=\\"<?=SP_SUPPORT_LINK?>\\" target=\\"_blank\\">Seo Panel サポートシステム</a>\r\n        </p>\r\n        \r\n        <p>\r\n            <a href=\\"<?=SP_DONATE_LINK?>\\" target=\\"_blank\\">Seo Panel へ寄付</a>\r\n        </p>\r\n    </li>\r\n    \r\n</ul>\r\n</fieldset>', '2011-07-05 13:26:54'),
(4491, 'ja', 'home', 'Pages Indexed', 'インデックスされたページ', '2011-07-05 13:26:54'),
(4492, 'ja', 'home', 'Ranks', 'ランク', '2011-07-05 13:26:54'),
(4493, 'ja', 'home', 'SiteNameUrl', 'サイト名/URL', '2011-07-05 13:26:54'),
(4494, 'ja', 'home', 'Website Statistics', 'ウェブサイト統計', '2011-07-05 13:26:54'),
(4495, 'ja', 'keyword', 'Crawling keyword', 'キーワードのクローリング中', '2016-01-04 06:34:06'),
(4496, 'ja', 'keyword', 'Detailed Keyword Position Reports', 'キーワード順位詳細レポート', '2016-01-04 06:34:06'),
(4497, 'ja', 'keyword', 'Edit Keyword', 'キーワード編集', '2016-01-04 06:34:06'),
(4498, 'ja', 'keyword', 'Graphical Keyword Position Reports', 'キーワード順位グラフレポート', '2016-01-04 06:34:06'),
(4499, 'ja', 'keyword', 'Import Keywords', 'キーワードのインポート', '2016-01-04 06:34:06'),
(4500, 'ja', 'keyword', 'Keyword already exist', 'キーワードは既に存在します', '2016-01-04 06:34:06'),
(4501, 'ja', 'keyword', 'Keyword Position Report', 'キーワード順位レポート', '2016-01-04 06:34:06'),
(4502, 'ja', 'keyword', 'New Keyword', '新しいキーワード', '2016-01-04 06:34:06'),
(4503, 'ja', 'keyword', 'not assigned to required search engines', '要求された検索エンジンに割り当てされていません', '2016-01-04 06:34:06'),
(4504, 'ja', 'keyword', 'pleaseselecttool', 'Seoツールを最低でも１つ選んでください', '2016-01-04 06:34:06'),
(4505, 'ja', 'keyword', 'Quick Keyword Position Checker', 'キーワード順位クイックチェッカー', '2016-01-04 06:34:06'),
(4506, 'ja', 'keyword', 'results from ', '結果元', '2016-01-04 06:34:06'),
(4507, 'ja', 'keyword', 'Show All results', 'すべての結果を表示', '2016-01-04 06:34:06'),
(4508, 'ja', 'keyword', 'Successfully crawled keyword', 'クロールに成功したキーワード', '2016-01-04 06:34:06'),
(4509, 'ja', 'keyword', 'to create new keywords', '新しいキーワードを作成', '2016-01-04 06:34:06'),
(4510, 'ja', 'label', 'already exist', '既に存在します', '2016-12-12 01:03:47'),
(4511, 'ja', 'label', 'Authentication', '認証', '2016-12-12 01:03:47'),
(4512, 'ja', 'label', 'Author', '作者', '2016-12-12 01:03:47'),
(4513, 'ja', 'label', 'Click Here', 'ここをクリック', '2016-12-12 01:03:47'),
(4514, 'ja', 'label', 'Cron', 'Cron', '2016-12-12 01:03:47'),
(4515, 'ja', 'label', 'Description', 'ディスクリプション', '2016-12-12 01:03:47'),
(4516, 'ja', 'label', 'Developers', '開発者', '2016-12-12 01:03:47'),
(4517, 'ja', 'label', 'Download', 'ダウンロード', '2016-12-12 01:03:47'),
(4518, 'ja', 'label', 'Installation', 'インストール', '2016-12-12 01:03:47'),
(4519, 'ja', 'label', 'Keywords', 'キーワード', '2016-12-12 01:03:47'),
(4520, 'ja', 'label', 'noactiveplugins', 'アクティブなSeoプラグインがありません！', '2016-12-12 01:03:47'),
(4521, 'ja', 'label', 'Plugin', 'プラグイン', '2016-12-12 01:03:47'),
(4522, 'ja', 'label', 'Port', 'ポート', '2016-12-12 01:03:47'),
(4523, 'ja', 'label', 'Proxy', 'プロキシ', '2016-12-12 01:03:47'),
(4524, 'ja', 'label', 'Re-install', '再インストール', '2016-12-12 01:03:47'),
(4525, 'ja', 'label', 'Sponsors', 'スポンサー', '2016-12-12 01:03:47'),
(4526, 'ja', 'label', 'Title', 'タイトル', '2016-12-12 01:03:47'),
(4527, 'ja', 'label', 'translation by', '翻訳', '2016-12-12 01:03:47'),
(4528, 'ja', 'label', 'Translators', '翻訳者', '2016-12-12 01:03:47'),
(4529, 'ja', 'label', 'Upgrade', 'アップグレード', '2016-12-12 01:03:47'),
(4530, 'ja', 'label', 'Version', 'バージョン', '2016-12-12 01:03:47'),
(4531, 'ja', 'label', 'wantproceed', '本当に処理を続行してよろしいですか？', '2016-12-12 01:03:47'),
(4532, 'ja', 'login', 'Confirm Password', 'パスワードの確認', '2016-01-04 06:34:40'),
(4533, 'ja', 'login', 'Create my account', 'マイアカウントの作成', '2016-01-04 06:34:40'),
(4534, 'ja', 'login', 'Create New Account', '新規アカウントの作成', '2016-01-04 06:34:40'),
(4535, 'ja', 'login', 'Email', 'メールアドレス', '2016-01-04 06:34:40'),
(4536, 'ja', 'login', 'emailexist', 'メールアドレスは既に存在します', '2016-01-04 06:34:40'),
(4537, 'ja', 'login', 'Enter the code as it is shown', 'コードを表示通りに入力してください', '2016-01-04 06:34:40'),
(4538, 'ja', 'login', 'First Name', '名前', '2016-01-04 06:34:40'),
(4539, 'ja', 'login', 'Last Name', '姓', '2016-01-04 06:34:40'),
(4540, 'ja', 'login', 'Login', 'ログイン', '2016-01-04 06:34:40'),
(4541, 'ja', 'login', 'Login incorrect', 'ログインが不正です', '2016-01-04 06:34:40'),
(4542, 'ja', 'login', 'newaccountsuccess', '新規アカウントの作成に成功しました！', '2016-01-04 06:34:40'),
(4543, 'ja', 'login', 'Password', 'パスワード', '2016-01-04 06:34:40'),
(4544, 'ja', 'login', 'Password incorrect', 'パスワードが不正です', '2016-01-04 06:34:40'),
(4545, 'ja', 'login', 'Register', '登録', '2016-01-04 06:34:40'),
(4546, 'ja', 'login', 'Sign in to your account', 'あなたのアカウントにログイン', '2016-01-04 06:34:40'),
(4547, 'ja', 'login', 'User inactive', 'ユーザが非アクティブです', '2016-01-04 06:34:40'),
(4548, 'ja', 'login', 'Username', 'ユーザ名', '2016-01-04 06:34:40'),
(4549, 'ja', 'login', 'usernameexist', 'ユーザ名は既に存在します！', '2016-01-04 06:34:40'),
(4550, 'ja', 'panel', 'About Us', 'Seo Panelについて', '2016-12-12 01:06:09'),
(4551, 'ja', 'panel', 'Add following command to your cron tab', '以下のコマンドをあなたのcronタブに追加してください', '2016-12-12 01:06:09'),
(4552, 'ja', 'panel', 'alsocheckfollowlink', 'さらに詳細が必要なら下記リンクもチェックしてください', '2016-12-12 01:06:09'),
(4553, 'ja', 'panel', 'Check Directory', 'ディレクトリをチェック', '2016-12-12 01:06:09'),
(4554, 'ja', 'panel', 'Cron Command', 'cronコマンド', '2016-12-12 01:06:09'),
(4555, 'ja', 'panel', 'Directory Manager', 'ディレクトリマネージャー', '2016-12-12 01:06:09'),
(4556, 'ja', 'panel', 'Edit My Profile', 'マイプロフィールの編集', '2016-12-12 01:06:09'),
(4557, 'ja', 'panel', 'My Profile', 'マイプロフィール', '2016-12-12 01:06:09'),
(4558, 'ja', 'panel', 'New Proxy', '新規プロキシ', '2016-12-12 01:06:09'),
(4559, 'ja', 'panel', 'New User', '新規ユーザ', '2016-12-12 01:06:09'),
(4560, 'ja', 'panel', 'New Website', '新規ウェブサイト', '2016-12-12 01:06:09'),
(4561, 'ja', 'panel', 'Proxy Manager', 'プロキシマネージャー', '2016-12-12 01:06:09'),
(4562, 'ja', 'panel', 'Report Generation Manager', 'レポート生成マネージャー', '2016-12-12 01:06:09'),
(4563, 'ja', 'panel', 'Reports Manager', 'レポートマネージャー', '2016-12-12 01:06:09'),
(4564, 'ja', 'panel', 'Seo Plugins Manager', 'Seoプラグインマネージャー', '2016-12-12 01:06:09'),
(4565, 'ja', 'panel', 'Seo Tools Manager', 'Seoツールマネージャー', '2016-12-12 01:06:09'),
(4566, 'ja', 'panel', 'System Settings', 'システム設定', '2016-12-12 01:06:09'),
(4567, 'ja', 'panel', 'User Manager', 'ユーザマネージャー', '2016-12-12 01:06:09'),
(4568, 'ja', 'panel', 'Website Manager', 'ウェブサイトマネージャー', '2016-12-12 01:06:09'),
(4569, 'ja', 'plugin', 'Edit Seo Plugin', 'Seoプラグインの編集', '2012-05-14 13:00:09'),
(4570, 'ja', 'plugin', 'Plugin Name', 'プラグイン名', '2012-05-14 13:00:09'),
(4571, 'ja', 'plugin', 'Seo Plugin Details', 'Seoプラグイン詳細', '2012-05-14 13:00:09'),
(4572, 'ja', 'proxy', 'Edit Proxy', 'プロキシの編集', '2016-12-12 01:08:13'),
(4573, 'ja', 'proxy', 'Proxy Password', 'プロキシパスワード', '2016-12-12 01:08:13'),
(4574, 'ja', 'proxy', 'Proxy Username', 'プロキシユーザ名', '2016-12-12 01:08:13'),
(4575, 'ja', 'proxy', 'Proxyalreadyexist', 'プロキシは既に存在します！', '2016-12-12 01:08:13'),
(4576, 'ja', 'rank', 'enterurlproceed', 'URLを<b>一行につき１つ</b>入力してください。GoogleおよびAlexaランキングをチェックするには<b>開始</b>をクリックします。', '2011-01-07 18:34:13'),
(4577, 'ja', 'rank', 'Google and Alexa Rank Reports', 'GoogleおよびAlexaランクレポート', '2011-01-07 18:34:13'),
(4578, 'ja', 'rank', 'Saved rank results of', 'ランキング結果を保存しました', '2011-01-07 18:34:13'),
(4579, 'ja', 'saturation', 'clickproceedsaturation', 'URLを<b>一行につき１つ</b>入力してください。検索エンジンサチュレーション結果を確認するには<b>開始</b>をクリックします。', '2011-01-07 18:36:27'),
(4580, 'ja', 'saturation', 'GenerateSaturationReports', '検索エンジンサチュレーション結果を生成', '2011-01-07 18:36:27'),
(4581, 'ja', 'saturation', 'Quick Search Engine Saturation Checker', '検索エンジンサチュレーション・クイックチェッカー', '2011-01-07 18:36:27'),
(4582, 'ja', 'saturation', 'Saved Search Engine Saturation results of', '検索エンジンサチュレーション結果を保存しました', '2011-01-07 18:36:27'),
(4583, 'ja', 'saturation', 'Search Engine Saturation Reports', '検索エンジンサチュレーションレポート', '2011-01-07 18:36:27'),
(4584, 'ja', 'seotools', 'Automatic Submission', '自動サブミッション', '2011-07-05 13:39:46'),
(4585, 'ja', 'seotools', 'backlink-checker', 'バックリンクチェッカー', '2011-07-05 13:39:46'),
(4586, 'ja', 'seotools', 'Backlinks Reports', 'バックリンクレポート', '2011-07-05 13:39:46'),
(4587, 'ja', 'seotools', 'Check Submission Status', 'サブミッション状態をチェック', '2011-07-05 13:39:46'),
(4588, 'ja', 'seotools', 'clickgeneratereports', 'レポートを生成するには<b>開始</b>をクリック', '2011-07-05 13:39:46'),
(4589, 'ja', 'seotools', 'Detailed Position Reports', '順位詳細レポート', '2011-07-05 13:39:46'),
(4590, 'ja', 'seotools', 'directory-submission', 'ディレクトリサブミッション', '2011-07-05 13:39:46'),
(4591, 'ja', 'seotools', 'Featured Submission', '主要サブミッション', '2011-07-05 13:39:46'),
(4592, 'ja', 'seotools', 'Generate Backlinks Reports', 'バックリンクレポートを生成', '2011-07-05 13:39:46'),
(4593, 'ja', 'seotools', 'Generate Keyword Reports', 'キーワードレポートを生成', '2011-07-05 13:39:46'),
(4594, 'ja', 'seotools', 'Generate Rank Reports', 'ランキングレポートを生成', '2011-07-05 13:39:46'),
(4595, 'ja', 'seotools', 'Generate Saturation Reports', 'サチュレーションレポートを生成', '2011-07-05 13:39:46'),
(4596, 'ja', 'seotools', 'Google Sitemap Generator', 'Googleサイトマップジェネレータ', '2011-07-05 13:39:46'),
(4597, 'ja', 'seotools', 'Graphical Position Reports', '順位グラフレポート', '2011-07-05 13:39:46'),
(4598, 'ja', 'seotools', 'Keyword Position Summary', 'キーワード順位サマリ', '2011-07-05 13:39:46'),
(4599, 'ja', 'seotools', 'keyword-position-checker', 'キーワード順位チェッカー', '2011-07-05 13:39:46'),
(4600, 'ja', 'seotools', 'Keywords Manager', 'キーワードマネージャー', '2011-07-05 13:39:46'),
(4601, 'ja', 'seotools', 'Quick Backlinks Checker', 'クイック・バックリンクチェッカー', '2011-07-05 13:39:46'),
(4602, 'ja', 'seotools', 'Quick Position Checker', 'クイック順位チェッカー', '2011-07-05 13:39:46'),
(4603, 'ja', 'seotools', 'Quick Rank Checker', 'クイック・ランクチェッカー', '2011-07-05 13:39:46'),
(4604, 'ja', 'seotools', 'Quick Saturation Checker', 'クイック・サチュレーションチェッカー', '2011-07-05 13:39:46'),
(4605, 'ja', 'seotools', 'Rank Reports', 'ランキングレポート', '2011-07-05 13:39:46'),
(4606, 'ja', 'seotools', 'rank-checker', 'ランクチェッカー', '2011-07-05 13:39:46'),
(4607, 'ja', 'seotools', 'Saturation Reports', 'サチュレーションレポート', '2011-07-05 13:39:46'),
(4608, 'ja', 'seotools', 'saturation-checker', '検索エンジンサチュレーション', '2011-07-05 13:39:46'),
(4609, 'ja', 'seotools', 'sitemap-generator', 'サイトマップジェネレータ', '2011-07-05 13:39:46'),
(4610, 'ja', 'seotools', 'Skipped Directories', 'スキップされたディレクトリ', '2011-07-05 13:39:46'),
(4611, 'ja', 'seotools', 'Submission Reports', 'サブミッションレポート', '2011-07-05 13:39:46'),
(4612, 'ja', 'seotools', 'User Access', 'ユーザアクセス', '2011-07-05 13:39:46'),
(4613, 'ja', 'settings', 'Click here to become a sponsor for Seo Panel', '<b>100ドルを寄付</>してSeo Panelのスポンサーになる。', '2016-12-12 04:26:25'),
(4614, 'ja', 'settings', 'seopanel_description', 'ウェブサイトの検索エンジン最適化を管理するための完全フリーなコントロールパネル。サイトパフォーマンスの向上と追跡に特化した魅力的なSEOツールを多数備えています。オープンソースのソフトウェアで、seo panel用に独自のseoプラグインを開発することもできます。', '2016-12-12 04:26:25'),
(4615, 'ja', 'settings', 'seopanel_title', 'Seo Panel: 世界初の複数ウェブサイト対応オープンソースSEOコントロールパネル', '2016-12-12 04:26:25'),
(4616, 'ja', 'settings', 'SP_CRAWL_DELAY', '各スパイダーのクロール頻度（秒）', '2016-12-12 04:26:25'),
(4617, 'ja', 'settings', 'SP_DEFAULTLANG', 'デフォルト言語', '2016-12-12 04:26:25'),
(4618, 'ja', 'settings', 'SP_DESCRIPTION', 'Seo Panelディスクリプション', '2016-12-12 04:26:25'),
(4619, 'ja', 'settings', 'SP_ENABLE_PROXY', 'プロキシを有効化', '2016-12-12 04:26:25'),
(4620, 'ja', 'settings', 'SP_HOTLINKING', 'イメージホットリンクプロテクションが有効です', '2016-12-12 04:26:25'),
(4621, 'ja', 'settings', 'SP_KEYWORDS', 'Seo Panelキーワード', '2016-12-12 04:26:25'),
(4622, 'ja', 'settings', 'SP_PAGINGNO', 'ページ毎の入力数', '2016-12-12 04:26:25'),
(4623, 'ja', 'settings', 'SP_TITLE', 'Seo Panel タイトル', '2016-12-12 04:26:25'),
(4624, 'ja', 'settings', 'SP_USER_AGENT', 'ユーザエージェント', '2016-12-12 04:26:25'),
(4625, 'ja', 'settings', 'SP_USER_GEN_REPORT', 'ユーザのレポート生成を許可', '2016-12-12 04:26:25'),
(4626, 'ja', 'settings', 'SP_USER_REGISTRATION', 'ユーザ登録インターフェース', '2016-12-12 04:26:25'),
(4627, 'ja', 'settings', 'syssettingssaved', 'システム設定の保存に成功しました！', '2016-12-12 04:26:25'),
(4628, 'ja', 'sitemap', 'Change frequency', '頻度を変更', '2011-01-07 19:02:02'),
(4629, 'ja', 'sitemap', 'clickproceedsitemap', 'サイトマップファイルを作成するには<b>開始</b>をクリック', '2011-01-07 19:02:02'),
(4630, 'ja', 'sitemap', 'Download sitemap file from', 'サイトマップファイルをダウンロード', '2011-01-07 19:02:02'),
(4631, 'ja', 'sitemap', 'Exclude Url', 'URLを除外', '2011-01-07 19:02:02'),
(4632, 'ja', 'sitemap', 'processtaketime', 'サイトのリンク数によっては、この処理に時間が掛かります。サイトマップファイルを取得するまでお待ちください', '2011-01-07 19:02:02'),
(4633, 'ja', 'sitemap', 'Sitemap Type', 'サイトマップタイプ', '2011-01-07 19:02:02'),
(4634, 'ja', 'user', 'Edit User', 'ユーザの編集', '2016-01-04 06:41:28'),
(4635, 'ja', 'user', 'Saved My Profile Details', 'マイプロフィール詳細が保存されました', '2016-01-04 06:41:28'),
(4636, 'ja', 'website', 'Edit Website', 'ウェブサイトの編集', '2016-01-04 06:43:11'),
(4637, 'ja', 'website', 'plscrtwebsite', 'seoツールやseoプラグインを使用開始する前に、ウェブサイトを作成してください。', '2016-01-04 06:43:11'),
(4638, 'ja', 'website', 'Website already exist', 'ウェブサイトは既に存在します', '2016-01-04 06:43:11'),
(4639, 'ja', 'website', 'yourwebalreday', '既に作成済みの場合はご自身のウェブサイト', '2016-01-04 06:43:11'),
(4640, 'ja', 'support', 'support_cont1', '<fieldset>\r\n<legend>Seo Panel サポートシステム</legend>\r\n<ul class=\\"infobox\\">\r\n    <li>\r\n        <h1>1000 ディレクトリパッケージ</h1> \r\n        <p>\r\n            <b>アクティブで検証済みの</b>インターネットディレクトリパッケージを<b>1000</b>提供しており、各自のseo panel<b>ディレクトリサブミッションツール</b>に追加して頂くことが可能です。\r\n            お使いのウェブサイトの<b>バックリンク増加</b>に役立ちます。\r\n            実際、seo panelの将来開発に向け費用を集めるために1000のディレクトリリストが<b>紹介されています</b>。\r\n            1000ディレクトリリストを入手するには、seo panel機能向上のため10ドル以上を<a href=\\"<?=SP_DONATE_LINK?>\\" target=\\"_blank\\">寄付</a>してください。\r\n            1000ディレクトリパッケージについてご質問がありましたら、<a href=\\"<?=SP_CONTACT_LINK?>\\"\r\ntarget=\\"_blank\\">お問合せ</a>頂くか<a href=\\"<?=SP_SUPPORT_LINK?>\\"\r\ntarget=\\"_blank\\">サポートシステム</a>にてチケットを開いてください。.   \r\n        </p>        \r\n        <p>\r\n            <a href=\\"<?=SP_DONATE_LINK?>\\" target=\\"_blank\\">seo panelへの寄付はこちらから</a>\r\n        </p>\r\n        <br>\r\n    </li>\r\n    \r\n    <li>\r\n        <h1>ローカル検索エンジンパッケージ</h1> \r\n        <p>\r\n            googleやyahooおよびmsnの<b>ローカル検索エンジンドメイン</b><\r\nb>（例：www.google.de,www.google.fr\r\netc</b>）をseo panel<b>キーワード順位チェッカー</b>に追加すると、サイトのパフォーマンスを地域的に追跡することができます。\r\n            ローカル検索エンジンパッケージを取得するには（要件に応じて）、seo panel機能向上のため10ドル以上を<a　href=\\"<?=SP_DONATE_LINK?>\\" target=\\"_blank\\">寄付</a>してください。\r\n            寄付をお送り頂く前に、必要な検索エンジンドメインリストを提供していただくため、<a href=\\"<?=SP_CONTACT_LINK?>\\" target=\\"_blank\\">お問合せ</a>ください。\r\n            <br><br>              \r\n            また<b>新しい検索エンジン（例：baidu.com）</b>をseo panelキーワード順位チェッカーに追加するには、<a href=\\"<?=SP_CONTACT_LINK?>\\" target=\\"_blank\\">お問合せ</a>頂くか<a\r\nhref=\\"<?=SP_SUPPORT_LINK?>\\" target=\\"_blank\\">サポートシステム</a>にてチケットを開いてください。 \r\n        </p>        \r\n        <p class=\\"visit\\">\r\n            <a href=\\"<?=SP_CONTACT_LINK?>\\" target=\\"_blank\\">お問合せはこちらから</a>\r\n        </p>\r\n        <br>\r\n    </li>\r\n    \r\n    <li>\r\n        <h1>Seo Panel プラグイン</h1> \r\n        <p>\r\n            それぞれの要件に応じて<b>機能を拡張</b>するには<b>seoプラグイン</b>をseo panelに追加してくだださい。\r\n            <a href=\\"<?=SP_PLUGINSITE?>\\" target=\\"_blank\\">Seo panel プラグイン</a>は、seo panelおよびサードパーティサイトの両方より提供されています。\r\n            各自のseo panel用にseoプラグインを<b>開発</b>することも可能です。\r\n            ご自身のseoプラグインをseo panelに<a href=\\"<?=SP_PLUGINSITE?>\\" target=\\"_blank\\">送信</a>して頂くと、こちらで<b>審査</b>した後<b>公開</b>いたします。        \r\n        </p>        \r\n        <p>\r\n            <a href=\\"<?=SP_PLUGINSITE?>\\" target=\\"_blank\\">seo panelプラグインの入手はこちらから</a>\r\n        </p>\r\n        <br>\r\n    </li>    \r\n    <li>\r\n        <h1>お問合せ</h1> \r\n        <p>\r\n            <b>seo panel ツール、プラグイン、機能、etc</b>に関するご質問は、 以下のリンクよりお問合せください。        \r\n        </p>        \r\n        <p>\r\n            <a href=\\"<?=SP_CONTACT_LINK?>\\" target=\\"_blank\\">お問合せはこちらから</a>\r\n        </p>\r\n        <br>\r\n    </li>    \r\n    <li>\r\n        <h1>サポートチケット</h1> \r\n        <p>\r\n            <b>seo panelツール、プラグイン、機能</b>をセットアップするにあたり、seo panelチームより<b>テクニカルサポート</b>を受けるためのものです。例：キーワード順位チェッカーにcronをセットアップする。\r\n        </p>        \r\n        <p>\r\n            <a href=\\"<?=SP_SUPPORT_LINK?>\\" target=\\"_blank\\">サポートチケットの作成はこちらから</a>\r\n        </p>\r\n        <br>\r\n    </li>    \r\n    <li>\r\n        <h1>不具合レポート</h1> \r\n        <p>\r\n            <b>seo panelツール、プラグイン、機能、etc</b>に関する<b>不具合</b>を報告するには、以下のリンクを使用します。 \r\n            次のバージョンで機能を向上できるよう、どうぞご協力をお願いします。          \r\n        </p>        \r\n        <p>\r\n            <a href=\\"<?=SP_SUPPORT_LINK?>\\" target=\\"_blank\\">不具合報告はこちらから</a>\r\n        </p>\r\n        <br>\r\n    </li>    \r\n</ul>\r\n</fieldset>', '2011-01-07 20:37:35'),
(4641, 'ja', 'support', 'support_cont2', '<fieldset>\r\n<legend>Seo Panel オンラインリソース</legend>\r\n<ul class=\\"infobox\\">\r\n        \r\n    <li>\r\n        <h1>Seo Panel ヘルプガイド</h1> \r\n        <p>\r\n            <b>ヘルプガイド</b>では、<a href=\\"<?=SP_HELP_LINK?>\\" target=\\"_blank\\">seo panel ドキュメント</a>を閲覧することができ、seo panelツールやプラグイン、関連機能についての<b>ドキュメント</b>があります。 \r\n            <br>これは、seo panelについての<b>ヘルプを受けられる</b>インターネット上で一番の場所です。 間違いや抜けている箇所を発見された場合には、seo panelヘルプガイドに<b>貢献</b>して頂ければ幸いです。                \r\n        </p>\r\n        <p>\r\n            <a href=\\"<?=SP_HELP_LINK?>\\" target=\\"_blank\\">seo panelヘルプガイドはこちらから</a>\r\n        </p>\r\n        <br>\r\n    </li>    \r\n    <li>\r\n        <h1>Seo Panel フォーラム</h1> \r\n        <p>\r\n            世界初のオープンソース<b>seoコントロールパネル</b>についてディスカッションをする場です。 \r\n            seo panelについての<b>あなたの疑問</b>に対して<b>答え</b>を見つけるには最適な場所です。 \r\n            <br>また、seo panelを使って最適化を行ったあなたの<b>経験</b>を<b>共有</b>することもできます。                               \r\n        </p>        \r\n        <p>\r\n            <a href=\\"<?=SP_FORUM_LINK?>\\" target=\\"_blank\\">seo panelフォーラムはこちらから</a>\r\n        </p>\r\n        <br>\r\n    </li>\r\n</ul>    \r\n</fieldset>', '2011-01-07 20:37:35'),
(4642, 'ja', 'support', 'support_cont3', '<fieldset>\r\n<legend>Seo Panelへ寄付</legend>\r\n<ul class=\\"infobox\\">        \r\n    <li>\r\n        <h1>Seo Panelへ寄付 - 世界初のオープンソースseoコントロールパネル</h1> \r\n        <p>\r\n            seo panelへ<b>寄付</b>し、世界初のオープンソースseoコントロールパネルを支援します。 \r\n            将来、seo panel機能の<b>追加、向上</b>を予定しています。 \r\n            <br>あなたの<b>サポート</b>なしでは、その<b>ゴール</b>に到達できません。\r\n            seo panelがあなたにとって<b>価値のある</b>ものだと感じて頂けるなら、どうかseo panelチームへ寄付をお願いします。\r\n            <br>寄付して頂きましたら、あなたのお名前とサイト情報を<a href=\\"<?=SP_DONATE_LINK?>\\"\r\ntarget=\\"_blank\\">寄付ページ</a>にて<b>公開</b>します。\r\n        </p>\r\n        <p>\r\n            <a href=\\"<?=SP_DONATE_LINK?>\\" target=\\"_blank\\">seo panelへの寄付はこちらから</a>\r\n        </p>\r\n        <br>\r\n    </li>\r\n</ul>\r\n</fieldset>', '2011-01-07 20:37:35'),
(4643, 'el', 'home', 'Account Summary', 'Σύνοψη Λογαριασμού', '2011-07-08 02:16:51'),
(4644, 'el', 'home', 'Backlinks', 'Backlinks', '2011-07-08 02:16:51'),
(4645, 'el', 'home', 'Directory Submission', 'Καταχώρηση Καταλόγου', '2011-07-08 02:16:51'),
(4646, 'el', 'home', 'home_cont1', '<h1 style=\\"text-align: center;margin-bottom: 30px;font-size: 19px;\\"> Καλωσορίσατε στο  Seo Panel - το πρώτο παγκόσμιο control panel για πολλαπλά site</h1> \r\n        <p> \r\n            Ένα ολοκληρωμένο <b>seo control panel ανοικτού κώδικα</b> για την διαχείριση του <b>search engine optimization</b> των website σας.  \r\n            Το Seo Panel είναι μία <b>seo εργαλειοθήκη </b> η οποία περιλαμβάνει τα τελευταία hot seo εργαλεία για να <b>αυξήσετε και να παρακολουθήσετε</b> την\r\n<b>απόδοση</b> των website σας. \r\n            Είναι ένα <b>δωρεάν λογισμικό</b> δημοσιευμένο υπό την <b>GNU GENERAL PUBLIC LICENSE</b>. \r\n            Το κύριο χαρακτηριστικό του seo panel είναι η <b>επεκτασιμότητα</b> του με τη χρήση <a href=\\"<?=SP_PLUGINSITE?>\\" target=\\"_blank\\">seo plugins</a>. \r\n            Οποιοσδήποτε μπορεί εύκολα να  <b>αναπτύξει και να εγκαταστήσει</b> τα επιθυμητά  plugins για το δικό του seo panel.  \r\n        </p> \r\n        <p></p> \r\n        <p> \r\n            Αυτό το open source λογισμικό <b>δημοσιεύτηκε τον Ιανουάριο του 2010</b>. \r\n            Μέσα σε αυτή την <b>σύντομη περίοδο</b> ανάπτυξης, <b>χιλιάδες</b> από <b>web masters</b> χρησιμοποιούν αυτό το λογισμικό <b>βελτιστοποιώντας</b> τα website τους. \r\n            Χρησιμοποιήστε το seo panel σήμερα και <b>απολαύστε</b> τα πάντα σχετικά με το seo κάτω από μια  <b>απλή πλατφόρμα</b>. \r\n        </p>', '2011-07-08 02:16:51'),
(4647, 'el', 'home', 'home_cont2', '<fieldset> \r\n<legend>Μείζονα Χαρακτηριστικά του Seo Panel <?=SP_INSTALLED?></legend> \r\n<ul class=\\"infobox\\"> \r\n    <li>         \r\n        <h1>Εργαλείο Αυτόματης Καταχώρησης σε Καταλόγους</h1> \r\n        <p> \r\n            Το εργαλείο Αυτόματης Καταχώρησης μας βοηθάει να <b>καταχωρήσουμε τα websites μας</b> σε μείζονες <b>δωρεάν και επί πληρωμή καταλόγους στο internet</b>. \r\n            Επίσης μπορούμε <b>να παρακολουθήσουμε τη κατάσταση</b> κάθε καταχώρησης μέσω <b>περιοδικού ελέγχου</b> χρησιμοποιώντας το <b>script ελέγχου κατάστασης</b> της καταχώρησης. \r\n            Η <b>Διαχείριση Καταλόγων</b> θα μας βοηθήσει να βρούμε κατά πόσον <b>ένας κατάλογος είναι ενεργός</b> ή όχι. \r\n        </p> \r\n    </li> \r\n    <li>         \r\n        <h1>Ελεγκτής Κατάταξης Keyword</h1> \r\n        <p> \r\n            Ο Ελεγκτής Κατάταξης Keyword θα βρει την <b>κατάταξη στην μηχανή αναζήτησης</b> για <b>στοχευμένες λέξεις κλειδιά</b>\r\nγια το website σας και <b>τις αποθηκεύει </b> στο σύστημα. \r\n            Στον τομέα αναφοράς κατάταξης keyword, μπορούμε να δούμε τις <b>καθημερινές κατατάξεις</b> των λέξεων κλειδιών σε διαφορετικές μηχανές αναζήτησης με <b>όμορφα γραφήματα</b> και <b>λεπτομερείς αναφορές</b>. \r\n        </p> \r\n    </li> \r\n    <li>         \r\n        <h1>Site Auditor</h1> \r\n        <p>Site Auditor will <b>audit all SEO factors</b> of each pages of a site and will give a <b>detailed report</b> about each page. Αυτή θα μας βοηθήσει να δημιουργήσουμε <b>XML,HTML,TEXT</b> sitemap αρχεία για το website, ώστε να  <b>καταχωρηθούν</b> σε μηχανές αναζήτησης.</p> \r\n    </li> \r\n    <li>         \r\n        <h1>Ελεγκτής Google και Alexa Rank</h1> \r\n        <p> \r\n            Ο ελεγκτής Google και Alexa Rank θα βρει <b>την κατάταξη στο google</b> και την <b> κατάταξη alexa</b> στα websites και <b> αποθηκεύονται </b> στο σύστημα. \r\n            Στον τομέα <b>αναφορές κατάταξης</b>, μπορούμε να δούμε <b>καθημερινά</b> τις κατατάξεις στο google και alexa για κάθε website με <b>λεπτομερείς αναφορές</b>. \r\n        </p> \r\n    </li> \r\n    <li>         \r\n        <h1>Ελεγκτής Backlinks</h1> \r\n        <p> \r\n            Ο Ελεγκτής Backlinks - συνδέσμων επιστροφής θα βρει <b>τον αριθμό των backlinks</b> για τα websites σε διαφορετικές μηχανές αναζήτησης <b>(google,yahoo,msn etc)</b> και <b>αποθηκεύονται</b> στο σύστημα. \r\n            <br>Στον τομέα <b>αναφορές backlink</b>, μπορούμε να δούμε τις <b>καθημερινές μετρήσεις  backlinks</b> για κάθε website με <b>λεπτομερείς αναφορές</b>. \r\n        </p> \r\n    </li>     \r\n    <li>         \r\n        <h1>Έλεγχος Κορεσμού Μηχανής Αναζήτησης</h1> \r\n        <p> \r\n            Με τον έλεγχος Κορεσμού Μηχανής Αναζήτησης θα βρούμε <b>τον αριθμό των indexed σελίδων</b> στα websites μας σε διαφορετικές μηχανές αναζήτησης<b>(google,yahoo,msn etc)</b> και θα <b>αποθηκευτούν</b> στο σύστημα. \r\n            Στον τομέα <b>Αναφορές Ελέγχου Κορεσμού Μηχανής Αναζήτησης</b>, μπορούμε να δούμε <b>τις καθημερινές μετρήσεις indexed σελίδων </b> για κάθε website με <b>λεπτομερείς αναφορές</b>. \r\n        </p> \r\n    </li> \r\n    <li>         \r\n        <h1>Seo Panel Plugins</h1> \r\n        <p> \r\n            Τα <b> μείζονα χαρακτηριστικά </b> του seo control panel αφορούν την <b>επεκτασιμότητα του</b>. \r\n            Προσθέστε <b> μείζονα plugins</b> στο seo panel σας <b>για επέκταση των χαρακτηριστικών</b> σύμφωνα με τις ανάγκες σας. \r\n            <a href=\\"<?=SP_PLUGINSITE?>\\" target=\\"_blank\\">Seo panel plugins</a> παρέχονται από το seo panel και από sites τρίτων. \r\n            Μπορείτε και εσείς επίσης να <b>αναπτύξετε</b> seo plugins για το seo panel σας. \r\n            Μπορείτε να <a href=\\"<?=SP_PLUGINSITE?>\\" target=\\"_blank\\">καταχωρήσετε</a> τα seo plugin στο seo panel και να τα <b>δημοσιεύσετε</b> στο website σας μετά από την διαδικασία <b>επιθεώρησης</b> μας. \r\n        </p> \r\n    </li> \r\n    <li>         \r\n        <h1>Δημιουργία Meta Tag</h1> \r\n        <p> \r\n            Η Δημιουργία Meta tag είναι ένα <b>seo panel plugin</b> για την δημιουργία <b>custom meta tags</b> για τα website μας. \r\n            Αυτό θα μας βοηθήσει να αποκτήσουμε <b>περισσότερες πληροφορίες</b> για το website στα <b>bots των μηχανών αναζήτησης</b> όσο αυτά ανιχνεύουν τα website μας. \r\n        </p> \r\n    </li> \r\n</ul> \r\n</fieldset>', '2011-07-08 02:16:51'),
(4648, 'el', 'home', 'home_cont3', '<fieldset> \r\n<legend>Seo Panel Online Πηγές</legend>     \r\n<ul class=\\"infobox\\"> \r\n\r\n    <li> \r\n        <h1>Seo Panel Online Πηγές Αναφοράς</h1>                 \r\n         \r\n         \r\n        <p> \r\n            <a href=\\"http://www.seopanel.in\\" target=\\"_blank\\">Seo Panel Επίσημο Site</a> \r\n        </p> \r\n        <p> \r\n            <a href=\\"<?=SP_DOWNLOAD_LINK?>\\" target=\\"_blank\\">Λήψη του Seo Panel</a> \r\n        </p> \r\n         \r\n        <p> \r\n            <a href=\\"<?=SP_DEMO_LINK?>\\" target=\\"_blank\\">Seo Panel Demo</a> \r\n        </p> \r\n         \r\n        <p> \r\n            <a href=\\"<?=SP_CONTACT_LINK?>\\" target=\\"_blank\\">Επικοινωνήστε με το Seo Panel</a> \r\n        </p> \r\n         \r\n        <p> \r\n            <a href=\\"<?=SP_HELP_LINK?>\\" target=\\"_blank\\">Seo Panel Οδηγός Βοήθειας</a> \r\n        </p> \r\n         \r\n        <p> \r\n            <a href=\\"<?=SP_FORUM_LINK?>\\" target=\\"_blank\\">Seo Panel Forum</a> \r\n        </p> \r\n         \r\n        <p> \r\n            <a href=\\"<?=SP_SUPPORT_LINK?>\\" target=\\"_blank\\">Seo Panel Σύστημα Υποστήριξης</a> \r\n        </p> \r\n         \r\n        <p> \r\n            <a href=\\"<?=SP_DONATE_LINK?>\\" target=\\"_blank\\"> Δωρίστε στο Seo Panel</a> \r\n        </p> \r\n    </li> \r\n     \r\n</ul> \r\n</fieldset>', '2011-07-08 02:16:51'),
(4649, 'el', 'home', 'Pages Indexed', 'Indexed σελίδες', '2011-07-08 02:16:51'),
(4650, 'el', 'home', 'Ranks', 'Ranks', '2011-07-08 02:16:51'),
(4651, 'el', 'home', 'SiteNameUrl', 'Όνομα Site/Url', '2011-07-08 02:16:51'),
(4652, 'el', 'home', 'Website Statistics', 'Στατιστικά του website', '2011-07-08 02:16:51'),
(4653, 'el', 'settings', 'Click here to become a sponsor for Seo Panel', '<b>Δωρίστε $100</b> και γίνετε <b>υποστηρικτής</b> του Seo Panel.	', '2017-07-18 06:10:58'),
(4654, 'el', 'settings', 'seopanel_description', 'Ένα ολοκληρωμένο και δωρεάν control panel για την διαχείριση της βελτιστοποίησης των ιστοτόπων σας για τις μηχανές αναζήτησης. Περιλαμβάνει πολλά από τα δυνατά seo εργαλεία για την αύξηση και παρακολούθηση της απόδοσης των website σας. Είναι open source λογισμικό και μπορείτε και εσείς επίσης να αναπτύξετε τα δικά σας seo plugins για το Seo Panel.', '2017-07-18 06:10:58'),
(4655, 'el', 'settings', 'seopanel_title', 'Seo Panel: Το πρώτο open source seo control panel παγκοσμίως, για την διαχείριση πολλαπλών sites.', '2017-07-18 06:10:58'),
(4656, 'el', 'settings', 'SP_CRAWL_DELAY', 'Καθυστέρηση μεταξύ των spider ανιχνευτών (δευτερόλεπτα)', '2017-07-18 06:10:58'),
(4657, 'el', 'settings', 'SP_DEFAULTLANG', 'Προκαθορισμένη Γλώσσα', '2017-07-18 06:10:58'),
(4658, 'el', 'settings', 'SP_DESCRIPTION', 'Περιγραφή του Seo Panel', '2017-07-18 06:10:58'),
(4659, 'el', 'settings', 'SP_ENABLE_PROXY', 'Ενεργοποίηση Proxy', '2017-07-18 06:10:58'),
(4660, 'el', 'settings', 'SP_HOTLINKING', 'Προστασία εικόνας από hotlink', '2017-07-18 06:10:58'),
(4661, 'el', 'settings', 'SP_KEYWORDS', 'Λέξεις Κλειδιά του Seo Panel', '2017-07-18 06:10:58'),
(4662, 'el', 'settings', 'SP_PAGINGNO', 'Αριθμός εγγραφών ανά σελίδα', '2017-07-18 06:10:58'),
(4663, 'el', 'settings', 'SP_TITLE', 'Τίτλος του Seo Panel', '2017-07-18 06:10:58'),
(4664, 'el', 'settings', 'SP_USER_AGENT', 'Πράκτορας χρήστη', '2017-07-18 06:10:58'),
(4665, 'el', 'settings', 'SP_USER_GEN_REPORT', 'Επιτρέπεται οι χρήστες να δημιουργήσουν αναφορές', '2017-07-18 06:10:58'),
(4666, 'el', 'settings', 'SP_USER_REGISTRATION', 'Περιβάλλον εγγραφής χρήστη', '2017-07-18 06:10:58'),
(4667, 'el', 'settings', 'syssettingssaved', 'Οι ρυθμίσεις του συστήματος αποθηκεύτηκαν με επιτυχία!', '2017-07-18 06:10:58'),
(4668, 'el', 'proxy', 'Edit Proxy', 'Επεξεργασία Proxy', '2016-12-29 13:06:18'),
(4669, 'el', 'proxy', 'Proxy Password', 'Κωδικός Proxy', '2016-12-29 13:06:18'),
(4670, 'el', 'proxy', 'Proxy Username', 'Όνομα χρήστη Proxy', '2016-12-29 13:06:18'),
(4671, 'el', 'proxy', 'Proxyalreadyexist', 'Ο Proxy ήδη υπάρχει!', '2016-12-29 13:06:18'),
(4676, 'cs', 'user', 'Edit User', 'Upravit uživatele', '2011-03-21 14:14:30'),
(4677, 'cs', 'user', 'Saved My Profile Details', 'Detaily v mém profilu byly uloženy', '2011-03-21 14:14:30'),
(4678, 'cs', 'support', 'support_cont1', '', '2011-03-23 08:41:17'),
(4679, 'cs', 'support', 'support_cont2', '<fieldset> \r\n<legend>Online zdroje SEO panelu</legend> \r\n<ul class=\\"infobox\\"> \r\n         \r\n    <li> \r\n        <h1>Nápověda SEO panelu</h1>  \r\n        <p> \r\n            Můžete se podívat do <a href=\\"<?=SP_HELP_LINK?>\\" target=\\"_blank\\">dokumentace SEO panelu</a> v\r\n<b>nápovědě</b>, která obsahuje <b>dokumentaci</b> k SEO panelu, nástrojům, pluginům a k příslušným vlastnostem. \r\n            <br>Je to to nejlepší místo na internetu, kde <b>získáte nápovědu</b> o SEO panelu. Doufáme, že <b>přispějete</b> do nápovědy SEO panelu v případě, že objevíte chyby nebo chybějící věci.   \r\n        </p> \r\n        <p> \r\n            <a href=\\"<?=SP_HELP_LINK?>\\" target=\\"_blank\\">Podívejte se do nápovědy SEO panelu</a> \r\n        </p> \r\n        <br> \r\n    </li>     \r\n    <li> \r\n        <h1>Forum SEO panelu</h1>  \r\n        <p> \r\n           Místo k diskuzi o prvním otevřeném <b>ovládacím panelu pro SEO</b> na světe.\r\nJe to nejlepší místo, kde najít <b>odpovědi</b> na vaše <b>otázky</b> o SEO panelu.\r\n            <br>Můžete také <b>sdílet</b> vaše <b>zkušenosti</b> z toho, jak pomocí SEO panelu optimalizujete vaše stránky.                                \r\n        </p>         \r\n        <p> \r\n            <a href=\\"<?=SP_FORUM_LINK?>\\" target=\\"_blank\\">Navštivte forum SEO panelu</a> \r\n        </p> \r\n        <br> \r\n    </li> \r\n</ul>     \r\n</fieldset>', '2011-03-23 08:41:17'),
(4680, 'cs', 'support', 'support_cont3', '<fieldset> \r\n<legend>Podpořte finančně SEO Panel</legend> \r\n<ul class=\\"infobox\\">         \r\n    <li> \r\n        <h1>Podpořte finančně SEO Panel - první open source ovládací panel pro SEO na světě</h1>  \r\n        <p> \r\n            <b>Podpořte finančně</b> Seo Panel - první open source ovládací panel pro SEO na světě \r\n            Chceme v budoucnu <b>přidávat a vylepšovat</b> funkce SEO panelu.  \r\n            <br>Pouze s vaší <b>podporou</b> můžeme dosáhnout našich <b>cílů</b>. \r\n            Pokud máte pocit, že SEO Panel je pro vás <b>přínosem</b>, prosíme podpořte finančně určitou částkou tým SEO Panelu. \r\n            <br>Jakmile obdržíme vaši finanční podporu, <b>zveřejníme</b> vaše jméno a informace o vašich stránkách na <a href=\\"<?=SP_DONATE_LINK?>\\"\r\ntarget=\\"_blank\\">stránce s dary</a>. \r\n        </p> \r\n        <p> \r\n            <a href=\\"<?=SP_DONATE_LINK?>\\" target=\\"_blank\\">Navštivte tento odkaz, abyste mohli finančně podpořit SEO Panel.</a> \r\n        </p> \r\n        <br> \r\n    </li> \r\n</ul> \r\n</fieldset>', '2011-03-23 08:41:17'),
(4681, 'cs', 'backlink', 'clickproceedbacklink', 'Vložte <b>po jednom URL na každou řádku</b>. Klikněte na <b>Provést</b>, aby byly zkontrolovány zpětné odkazy.', '2011-03-23 08:08:28'),
(4682, 'cs', 'backlink', 'Saved backlink results of', 'Uložené výsledky zpětných odkazů na', '2011-03-23 08:08:28'),
(4683, 'cs', 'button', 'Cancel', 'Zrušit', '2014-01-08 19:24:18'),
(4684, 'cs', 'button', 'Check Status', 'Zkontrolovat stav', '2014-01-08 19:24:18'),
(4685, 'cs', 'button', 'Proceed', 'Provést', '2014-01-08 19:24:18'),
(4686, 'cs', 'button', 'Reload', 'Znovu načíst', '2014-01-08 19:24:18'),
(4687, 'cs', 'button', 'Show Details', 'Ukázat detaily', '2014-01-08 19:24:18'),
(4688, 'cs', 'button', 'Show Records', 'Ukázat záznamy', '2014-01-08 19:24:18');
INSERT INTO `texts` (`id`, `lang_code`, `category`, `label`, `content`, `changed`) VALUES
(4689, 'cs', 'button', 'Skip', 'Přeskočit', '2014-01-08 19:24:18'),
(4690, 'cs', 'button', 'Submit', 'Odeslat', '2014-01-08 19:24:18'),
(4691, 'cs', 'common', 'Action', 'Akce', '2011-07-10 07:17:16'),
(4692, 'cs', 'common', 'Activate', 'Zapnout', '2011-07-10 07:17:16'),
(4693, 'cs', 'common', 'Active', 'Zapnuté', '2011-07-10 07:17:16'),
(4694, 'cs', 'common', 'Admin Panel', 'Administrační panel', '2011-07-10 07:17:16'),
(4695, 'cs', 'common', 'Alexa Rank', 'Alexa Rank', '2011-07-10 07:17:16'),
(4696, 'cs', 'common', 'All', 'Vše', '2011-07-10 07:17:16'),
(4697, 'cs', 'common', 'Category', 'Kategorie', '2011-07-10 07:17:16'),
(4698, 'cs', 'common', 'contact', 'Kontakt', '2011-07-10 07:17:16'),
(4699, 'cs', 'common', 'copyright', 'Copyright © [year] www.seopanel.in Všechna práva vyhrazena', '2011-07-10 07:17:16'),
(4700, 'cs', 'common', 'Country', 'Země', '2011-07-10 07:17:16'),
(4701, 'cs', 'common', 'Crawl Meta Data', 'Prohledat meta data', '2011-07-10 07:17:16'),
(4702, 'cs', 'common', 'Date', 'Datum', '2011-07-10 07:17:16'),
(4703, 'cs', 'common', 'Delete', 'Vymazat', '2011-07-10 07:17:16'),
(4704, 'cs', 'common', 'Details', 'Detaily', '2011-07-10 07:17:16'),
(4705, 'cs', 'common', 'Directory', 'Adresář', '2011-07-10 07:17:16'),
(4706, 'cs', 'common', 'Donate', 'Finančně podpořit', '2011-07-10 07:17:16'),
(4707, 'cs', 'common', 'Edit', 'Upravit', '2011-07-10 07:17:16'),
(4708, 'cs', 'common', 'Entry cannot be blank', 'Hodnota nemůže být prázdná', '2011-07-10 07:17:16'),
(4709, 'cs', 'common', 'entrynotvalid', 'Vložená hodnota zřejmě není platná', '2011-07-10 07:17:16'),
(4710, 'cs', 'common', 'failed', 'selhal', '2011-07-10 07:17:16'),
(4711, 'cs', 'common', 'forum', 'Forum', '2011-07-10 07:17:16'),
(4712, 'cs', 'common', 'Found', 'Nalezeno', '2011-07-10 07:17:16'),
(4713, 'cs', 'common', 'Google Pagerank', 'Google Pagerank', '2011-07-10 07:17:16'),
(4714, 'cs', 'common', 'help', 'Nápověda', '2011-07-10 07:17:16'),
(4715, 'cs', 'common', 'hidenews', 'Skrýt novinky SEO panelu', '2011-07-10 07:17:16'),
(4716, 'cs', 'common', 'Id', 'ID', '2011-07-10 07:17:16'),
(4717, 'cs', 'common', 'Inactivate', 'Vypnout', '2011-07-10 07:17:16'),
(4718, 'cs', 'common', 'Inactive', 'Vypnuté', '2011-07-10 07:17:16'),
(4719, 'cs', 'common', 'Invalid characters', 'Neplatné znaky', '2011-07-10 07:17:16'),
(4720, 'cs', 'common', 'Invalid code entered', 'Vložen neplatný kód', '2011-07-10 07:17:16'),
(4721, 'cs', 'common', 'Invalid email address entered', 'Vložena neplatná emailová adresa', '2011-07-10 07:17:16'),
(4722, 'cs', 'common', 'Invalid value', 'Neplatná hodnota', '2011-07-10 07:17:16'),
(4723, 'cs', 'common', 'Keyword', 'Klíčové slov', '2011-07-10 07:17:16'),
(4724, 'cs', 'common', 'Keywords', 'Klíčová slova', '2011-07-10 07:17:16'),
(4725, 'cs', 'common', 'lang', 'Jazyk', '2011-07-10 07:17:16'),
(4726, 'cs', 'common', 'My Account', 'Můj účet', '2011-07-10 07:17:16'),
(4727, 'cs', 'common', 'Name', 'Jméno', '2011-07-10 07:17:16'),
(4728, 'cs', 'common', 'No', 'Ne', '2011-07-10 07:17:16'),
(4729, 'cs', 'common', 'No Keywords Found', 'Nenalezena žádná klíčová slova', '2011-07-10 07:17:16'),
(4730, 'cs', 'common', 'No Records Found', 'Nenalezeny žádné záznamy', '2011-07-10 07:17:16'),
(4731, 'cs', 'common', 'noactivetools', 'Žádný SEO nástroj není aktivní!', '2011-07-10 07:17:16'),
(4732, 'cs', 'common', 'nowebsites', 'Nenalezeny žádné website', '2011-07-10 07:17:16'),
(4733, 'cs', 'common', 'password632', 'Délka hesla by měla být mezi 6 a 32 znaky', '2011-07-10 07:17:16'),
(4734, 'cs', 'common', 'passwordnotmatch', 'Hesla neodpovídají', '2011-07-10 07:17:16'),
(4735, 'cs', 'common', 'Period', 'Perioda', '2011-07-10 07:17:16'),
(4736, 'cs', 'common', 'Priority', 'Priorita', '2011-07-10 07:17:16'),
(4737, 'cs', 'common', 'Profile', 'Profil', '2011-07-10 07:17:16'),
(4738, 'cs', 'common', 'Rank', 'Rank', '2011-07-10 07:17:16'),
(4739, 'cs', 'common', 'Reports', 'Reporty', '2011-07-10 07:17:16'),
(4740, 'cs', 'common', 'Results', 'Výsledky', '2011-07-10 07:17:16'),
(4741, 'cs', 'common', 'Search Engine', 'Vyhledávač', '2011-07-10 07:17:16'),
(4742, 'cs', 'common', 'Select', 'Vybrat', '2011-07-10 07:17:16'),
(4743, 'cs', 'common', 'Seo Plugins', 'Pluginy SEO', '2011-07-10 07:17:16'),
(4744, 'cs', 'common', 'Seo Tools', 'Nástroje SEO', '2011-07-10 07:17:16'),
(4745, 'cs', 'common', 'Sign out', 'Odhlásit se', '2011-07-10 07:17:16'),
(4746, 'cs', 'common', 'Sign Up', 'Zaregistrovat se', '2011-07-10 07:17:16'),
(4747, 'cs', 'common', 'signin', 'Přihlásit se', '2011-07-10 07:17:16'),
(4748, 'cs', 'common', 'Status', 'Stav', '2011-07-10 07:17:16'),
(4749, 'cs', 'common', 'Support', 'Podpora', '2011-07-10 07:17:16'),
(4750, 'cs', 'common', 'Total', 'Celkem', '2011-07-10 07:17:16'),
(4751, 'cs', 'common', 'Url', 'URL', '2011-07-10 07:17:16'),
(4752, 'cs', 'common', 'User', 'Uživatel', '2011-07-10 07:17:16'),
(4753, 'cs', 'common', 'User Panel', 'Uživatelský panel', '2011-07-10 07:17:16'),
(4754, 'cs', 'common', 'Website', 'Website', '2011-07-10 07:17:16'),
(4755, 'cs', 'common', 'Yes', 'Ano', '2011-07-10 07:17:16'),
(4756, 'cn', 'backlink', 'clickproceedbacklink', '輸入URL，<b>每行一條</b>。單擊<b>處理</b>開始檢測反向鏈接', '2011-05-04 09:01:01'),
(4757, 'cn', 'backlink', 'Saved backlink results of', '保存反向鏈接結果', '2011-05-04 09:01:01'),
(4758, 'cn', 'button', 'Cancel', '取消', '2014-01-08 19:22:02'),
(4759, 'cn', 'button', 'Check Status', '檢測狀態', '2014-01-08 19:22:02'),
(4760, 'cn', 'button', 'Proceed', '處理', '2014-01-08 19:22:02'),
(4761, 'cn', 'button', 'Reload', '重新載入', '2014-01-08 19:22:02'),
(4762, 'cn', 'button', 'Show Details', '顯示細節', '2014-01-08 19:22:02'),
(4763, 'cn', 'button', 'Show Records', '顯示記錄', '2014-01-08 19:22:02'),
(4764, 'cn', 'button', 'Skip', '跳過', '2014-01-08 19:22:02'),
(4765, 'cn', 'button', 'Submit', '提交', '2014-01-08 19:22:02'),
(4766, 'cn', 'common', 'Action', '執行', '2014-01-09 15:25:10'),
(4767, 'cn', 'common', 'Activate', '激活', '2014-01-09 15:25:10'),
(4768, 'cn', 'common', 'Active', '已激活', '2014-01-09 15:25:10'),
(4769, 'cn', 'common', 'Admin Panel', '管理面板', '2014-01-09 15:25:10'),
(4770, 'cn', 'common', 'Alexa Rank', 'Alexa 排名', '2014-01-09 15:25:10'),
(4771, 'cn', 'common', 'All', '所有', '2014-01-09 15:25:10'),
(4772, 'cn', 'common', 'Category', '類別', '2014-01-09 15:25:10'),
(4773, 'cn', 'common', 'contact', '聯繫', '2014-01-09 15:25:10'),
(4774, 'cn', 'common', 'copyright', '版權所有© 【2010】www.seopanel.in 保留所有權利', '2014-01-09 15:25:10'),
(4775, 'cn', 'common', 'Country', '國家', '2014-01-09 15:25:10'),
(4776, 'cn', 'common', 'Crawl Meta Data', '爬取meta信息', '2014-01-09 15:25:10'),
(4777, 'cn', 'common', 'Date', '日期', '2014-01-09 15:25:10'),
(4778, 'cn', 'common', 'Delete', '刪除', '2014-01-09 15:25:10'),
(4779, 'cn', 'common', 'Details', '細節', '2014-01-09 15:25:10'),
(4780, 'cn', 'common', 'Directory', '目錄', '2014-01-09 15:25:10'),
(4781, 'cn', 'common', 'Donate', '捐贈', '2014-01-09 15:25:10'),
(4782, 'cn', 'common', 'Edit', '編輯', '2014-01-09 15:25:10'),
(4783, 'cn', 'common', 'Entry cannot be blank', '不能輸入空值', '2014-01-09 15:25:10'),
(4784, 'cn', 'common', 'entrynotvalid', '輸入不合法', '2014-01-09 15:25:10'),
(4785, 'cn', 'common', 'failed', '失敗', '2014-01-09 15:25:10'),
(4786, 'cn', 'common', 'forum', '論壇', '2014-01-09 15:25:10'),
(4787, 'cn', 'common', 'Found', '資助', '2014-01-09 15:25:10'),
(4788, 'cn', 'common', 'Google Pagerank', '谷歌 Page Rank', '2014-01-09 15:25:10'),
(4789, 'cn', 'common', 'help', '幫助', '2014-01-09 15:25:10'),
(4790, 'cn', 'common', 'hidenews', '隱藏seopanel新聞', '2014-01-09 15:25:10'),
(4791, 'cn', 'common', 'Id', 'Id', '2014-01-09 15:25:10'),
(4792, 'cn', 'common', 'Inactivate', '關閉', '2014-01-09 15:25:10'),
(4793, 'cn', 'common', 'Inactive', '未激活的', '2014-01-09 15:25:10'),
(4794, 'cn', 'common', 'Invalid characters', '非法字符', '2014-01-09 15:25:10'),
(4795, 'cn', 'common', 'Invalid code entered', '輸入的代碼不合法', '2014-01-09 15:25:10'),
(4796, 'cn', 'common', 'Invalid email address entered', 'Email 地址不合法', '2014-01-09 15:25:10'),
(4797, 'cn', 'common', 'Invalid value', '無效數值', '2014-01-09 15:25:10'),
(4798, 'cn', 'common', 'Keyword', '關鍵字', '2014-01-09 15:25:10'),
(4799, 'cn', 'common', 'Keywords', '全部關鍵字', '2014-01-09 15:25:10'),
(4800, 'cn', 'common', 'lang', '語言', '2014-01-09 15:25:10'),
(4801, 'cn', 'common', 'My Account', '我的賬戶', '2014-01-09 15:25:10'),
(4802, 'cn', 'common', 'Name', '名字', '2014-01-09 15:25:10'),
(4803, 'cn', 'common', 'No', '沒有', '2014-01-09 15:25:10'),
(4804, 'cn', 'common', 'No Keywords Found', '未找到關鍵字', '2014-01-09 15:25:10'),
(4805, 'cn', 'common', 'No Records Found', '未找到相關記錄', '2014-01-09 15:25:10'),
(4806, 'cn', 'common', 'noactivetools', '沒有可用的seo工具', '2014-01-09 15:25:10'),
(4807, 'cn', 'common', 'nowebsites', '未發現站點', '2014-01-09 15:25:10'),
(4808, 'cn', 'common', 'password632', '密碼長度必須為6-32位', '2014-01-09 15:25:10'),
(4809, 'cn', 'common', 'passwordnotmatch', '密碼不匹配', '2014-01-09 15:25:10'),
(4810, 'cn', 'common', 'Period', '一段時間', '2014-01-09 15:25:10'),
(4811, 'cn', 'common', 'Priority', '優先級', '2014-01-09 15:25:10'),
(4812, 'cn', 'common', 'Profile', '簡介', '2014-01-09 15:25:10'),
(4813, 'cn', 'common', 'Rank', 'PR/排名', '2014-01-09 15:25:10'),
(4814, 'cn', 'common', 'Reports', '報告', '2014-01-09 15:25:10'),
(4815, 'cn', 'common', 'Results', '結果', '2014-01-09 15:25:10'),
(4816, 'cn', 'common', 'Search Engine', '搜索引擎', '2014-01-09 15:25:10'),
(4817, 'cn', 'common', 'Select', '選擇', '2014-01-09 15:25:10'),
(4818, 'cn', 'common', 'Seo Plugins', 'seo插件', '2014-01-09 15:25:10'),
(4819, 'cn', 'common', 'Seo Tools', 'seo工具', '2014-01-09 15:25:10'),
(4820, 'cn', 'common', 'Sign out', '登出', '2014-01-09 15:25:10'),
(4821, 'cn', 'common', 'Sign Up', '註冊', '2014-01-09 15:25:10'),
(4822, 'cn', 'common', 'signin', '登錄', '2014-01-09 15:25:10'),
(4823, 'cn', 'common', 'Status', '狀態', '2014-01-09 15:25:10'),
(4824, 'cn', 'common', 'Support', '支持', '2014-01-09 15:25:10'),
(4825, 'cn', 'common', 'Total', '所有', '2014-01-09 15:25:10'),
(4826, 'cn', 'common', 'Url', 'URL', '2014-01-09 15:25:10'),
(4827, 'cn', 'common', 'User', '用户', '2014-01-09 15:25:10'),
(4828, 'cn', 'common', 'User Panel', '用戶面板', '2014-01-09 15:25:10'),
(4829, 'cn', 'common', 'Website', '站點', '2014-01-09 15:25:10'),
(4830, 'cn', 'common', 'Yes', '是', '2014-01-09 15:25:10'),
(4831, 'cn', 'directory', 'Add back to directory list', '增加到目錄列表', '2014-01-09 15:30:58'),
(4832, 'cn', 'directory', 'Approved', '通過的', '2014-01-09 15:30:58'),
(4833, 'cn', 'directory', 'Captcha', '驗證碼', '2014-01-09 15:30:58'),
(4834, 'cn', 'directory', 'categorynote', '根據優先級用逗號隔開的提交的具體目錄分類。從優先級最高提交的具體目錄分類開始', '2014-01-09 15:30:58'),
(4835, 'cn', 'directory', 'Check Directory Status', '檢查目錄狀態', '2014-01-09 15:30:58'),
(4836, 'cn', 'directory', 'Check Directory Submission Status', '檢查目錄提交狀態', '2014-01-09 15:30:58'),
(4837, 'cn', 'directory', 'clicktoproceeddirsts', '點擊<b>處理</b> 以檢查目錄狀態', '2014-01-09 15:30:58'),
(4838, 'cn', 'directory', 'Confirmation', '確認', '2014-01-09 15:30:58'),
(4839, 'cn', 'directory', 'desnote', '有些目錄最少需要150字符描述信息', '2014-01-09 15:30:58'),
(4840, 'cn', 'directory', 'Directories with out captcha', '沒有驗證碼的目錄', '2014-01-09 15:30:58'),
(4841, 'cn', 'directory', 'Directory Submission Reports', '目錄提交報告', '2014-01-09 15:30:58'),
(4842, 'cn', 'directory', 'Enter the code shown', '輸入顯示的字符', '2014-01-09 15:30:58'),
(4843, 'cn', 'directory', 'nocatnote', '在提交頁面未找到提交類別。請點擊<b>重載</b>或者<b>跳過</b>', '2014-01-09 15:30:58'),
(4844, 'cn', 'directory', 'nodirnote', '未發現<b>已激活的</b>目錄', '2014-01-09 15:30:58'),
(4845, 'cn', 'directory', 'nosuccessnote', '如果沒得到成功的信息，請檢查郵件中的確認信息', '2014-01-09 15:30:58'),
(4846, 'cn', 'directory', 'optionalnote', '提交標題和描述信息比提交隨機信息會獲得更好的結果', '2014-01-09 15:30:58'),
(4847, 'cn', 'directory', 'Owner Email', '用戶郵件', '2014-01-09 15:30:58'),
(4848, 'cn', 'directory', 'Owner Name', '用戶名字', '2014-01-09 15:30:58'),
(4849, 'cn', 'directory', 'Pending', '待定', '2014-01-09 15:30:58'),
(4850, 'cn', 'directory', 'Please select a website to proceed', '請選擇一個站點來處理', '2014-01-09 15:30:58'),
(4851, 'cn', 'directory', 'selectwebsiteproceed', '選擇一個<b>站點</b> 來<b>處理</b> 目錄提交。 <br>檢查<b>沒有驗證碼的目錄</b> 來提交沒有驗證碼的目錄', '2014-01-09 15:30:58'),
(4852, 'cn', 'directory', 'selectwebsiteschecksub', '選擇一個<b>站點</b> 來<b>處理</b> 檢查目錄提交信息', '2014-01-09 15:30:58'),
(4853, 'cn', 'directory', 'Semi Automatic Directory Submission Tool', '半自動目錄提交工具', '2014-01-09 15:30:58'),
(4854, 'cn', 'directory', 'spamemailnote', '一些目錄可能會發送垃圾郵件，我們建議不要不要使用你常用的郵箱地址', '2014-01-09 15:30:58'),
(4855, 'cn', 'directory', 'Submission Details', '提交細節', '2014-01-09 15:30:58'),
(4856, 'cn', 'directory', 'Submit Description', '提交描述信息', '2014-01-09 15:30:58'),
(4857, 'cn', 'directory', 'Submit Keywords', '提交關鍵字', '2014-01-09 15:30:58'),
(4858, 'cn', 'directory', 'Submit Title', '提交標題', '2014-01-09 15:30:58'),
(4859, 'cn', 'directory', 'Website Category', '網站目錄', '2014-01-09 15:30:58'),
(4860, 'cn', 'directory', 'Website Url', '網站地址', '2014-01-09 15:30:58'),
(4861, 'cn', 'home', 'Account Summary', '賬戶概覽', '2011-07-06 06:47:27'),
(4862, 'cn', 'home', 'Backlinks', '反向鏈接', '2011-07-06 06:47:27'),
(4863, 'cn', 'home', 'Directory Submission', '目錄提交', '2011-07-06 06:47:27'),
(4864, 'cn', 'home', 'home_cont1', '<h1 style=\\"text-align: center;margin-bottom: 30px;font-size: 19px;\\">歡迎來到Seo Panel - 全球第一款支 \r\n\r\n持多站點的開源SEO工具</h1> \r\n        <p> \r\n            一個完整的<b>開源seo 控制面板</b> 來控制你的站點<b>操作</b> . \r\n            Seo Panel 是一個擁有最前沿熱門的seo工具<b>增加和追踪</b> 你的站點表現的 \r\n<b>SEO工具包</b>. \r\n            它是一個<b>免費的軟件</b> 在遵循<b>GNU GENERAL PUBLIC LICENSE</b>協議下發布. \r\n            seopanel主要的功能是<b>擴展性</b> 通過使用<a href=\\"<?=SP_PLUGINSITE?>\\" \r\ntarget=\\"_blank\\">seo 插件</a>. \r\n            任何人都可以簡單<b>開發和安裝</b> 各自需要的插件. \r\n        </p> \r\n        <p></p> \r\n        <p> \r\n            這款開源軟件發布自<b>2010年1月</b>. \r\n            在這麼<b>少的</b>時間<b>上千</b><b>站長</b> 在用此軟件<b>操作</b> 他們的站點. \r\n            現在您可以在<b>同一個平台下</b>使用和<b>享受</b> seo的任何東西. \r\n        </p> ', '2011-07-06 06:47:27'),
(4865, 'cn', 'home', 'home_cont2', '<fieldset> \r\n<legend> Seo Panel主要功能<?=SP_INSTALLED?></legend> \r\n<ul class=\\"infobox\\"> \r\n    <li> \r\n        <h1>自動目錄提交工具</h1> \r\n        <p> \r\n            自動目錄提交工具幫助我們<b>提交我們的站點</b>進入主要<b>免費和付費internet目錄</b>. \r\n            我們也可以每次使用<b>狀態檢查腳本</b>提交<b>定期檢查</b><b>追踪狀態</b>. \r\n            <b>目錄管理器</b>會幫助我們找出<b>目錄是否激活</b>. \r\n        </p> \r\n    </li> \r\n    <li> \r\n        <h1>關鍵字位置查詢器</h1> \r\n        <p> \r\n           關鍵字位置查詢器會系統中找出你的站點的<b>目標關鍵字</b>在<b>搜索引擎的排名位置</b> \r\n並且 <b>存儲排名數據</b> . \r\n            在關鍵字報告區域, 我們可以通過<b>簡潔的圖表</b>和<b>詳細報告</b>看到<b>每日</b>關鍵字在不 \r\n\r\n同的搜索引擎排名的報告. \r\n        </p> \r\n    </li> \r\n    <li> \r\n        <h1>站點審計器</h1> \r\n        <p>站點審計器可以<b>審計所有的SEO要素</b> 在一個網站上的所有頁面並且生成 \r\n<b>詳細報告t</b> 定位每一張網頁. 這將會有助於創建我們的<b>XML,HTML,TEXT</b>站點地圖文件來<b>提交</b> 給 \r\n\r\n搜索引擎.</p> \r\n    </li> \r\n    <li> \r\n        <h1>Google和Alexa排名查詢器</h1> \r\n        <p> \r\n            Google和Alexa排名查詢器會查詢<b>Google PageRank</b> 和<b>Alexa排名</b> 我們的站點並<b> \r\n\r\n存儲</b>在系統中. \r\n            在<b>排名報告</b> 中, 我們可以看到<b>每天</b>每個Google PR和Alexa排名<b>詳細報告</b>. \r\n        </p> \r\n    </li> \r\n    <li> \r\n        <h1>反向鏈接查詢器</h1> \r\n        <p> \r\n            反向鏈接查詢器會在不同的搜索引擎中<b>(google,yahoo,msn 等)</b>找出>我們的站點的<b>反向鏈 \r\n\r\n接數量</b>並<b>存儲</b>到系統中. \r\n            <br>在<b>反向鏈接報告</b> 中, 我們可以通過<b>詳細報告</b>看到每個站點的<b>每天反向鏈接數 \r\n\r\n量</b>. \r\n        </p> \r\n    </li> \r\n    <li> \r\n        <h1>搜索引擎收錄量查詢器</h1> \r\n        <p> \r\n            搜索引擎收錄量查詢器會查詢>我們的站點在不同的搜索引擎<b>(google,yahoo,msn 等)的<b>數量頁 \r\n\r\n面排名</b</b>並<b>存儲</b>到系統中. \r\n            在<b>搜索引擎收錄量查詢報告</b> 中, 我們可以通過<b>詳細報告</b>看到每個站點的<b>每天的頁 \r\n\r\n面收錄數量 \r\n</b>. \r\n        </p> \r\n    </li> \r\n    <li> \r\n        <h1>Seo Panel 插件</h1> \r\n        <p> \r\n            SEO控制面板的<b>主要功能</b>是它的<b>擴展性</b>. \r\n            根據你的需求增到<b>seo插件</b>到你的seo panel<b>擴展功能</b>. \r\n            <a href=\\"<?=SP_插件ITE?>\\" target=\\"_blank\\">Seo panel 插件</a>由seopanel \r\n和第三方站點提供. \r\n            你可以為你的seo panel簡單<b>開發</b> seo插件. \r\n            你可以在<a href=\\"<?=SP_PLUGINSITE?>\\" target=\\"_blank\\">submit</a>發布你的seo插件seo panel， \r\n\r\n在我們通過<b>審查</b> 處理之後就會<b>公佈</b> 在我們的站點. \r\n        </p> \r\n    </li> \r\n    <li> \r\n        <h1>Meta標籤生成器</h1> \r\n        <p> \r\n            Meta標籤生成器是一個為我們的站點創建<b>自定義Mta標籤</b>的<b>seo panel 插件</b>. \r\n            它幫助<b>搜索引擎機器人</b> \r\n爬行我們站點的時候獲得關於我們的站點<b>更多信息</b> . \r\n        </p> \r\n    </li> \r\n</ul> \r\n</fieldset>', '2011-07-06 06:47:27'),
(4866, 'cn', 'home', 'home_cont3', '<fieldset>\r\n<legend>Seo Panel 在線資源</legend>\r\n<ul class=\\"infobox\\">\r\n\r\n    <li>\r\n        <h1>Seo Panel 在線資源信息</h1>\r\n         \r\n         \r\n        <p>\r\n            <a href=\\"http://www.seopanel.in\\" target=\\"_blank\\">Seo Panel 官方站點</a>\r\n        </p>\r\n        <p>\r\n            <a href=\\"<?=SP_DOWNLOAD_LINK?>\\" target=\\"_blank\\">下載Seo Panel</a>\r\n        </p>\r\n         \r\n        <p>\r\n            <a href=\\"<?=SP_DEMO_LINK?>\\" target=\\"_blank\\">Seo Panel 例子</a>\r\n        </p>\r\n         \r\n        <p>\r\n            <a href=\\"<?=SP_CONTACT_LINK?>\\" target=\\"_blank\\">聯繫Seo Panel</a>\r\n        </p>\r\n         \r\n        <p>\r\n            <a href=\\"<?=SP_HELP_LINK?>\\" target=\\"_blank\\">Seo Panel 幫助嚮導</a>\r\n        </p>\r\n         \r\n        <p>\r\n            <a href=\\"<?=SP_FORUM_LINK?>\\" target=\\"_blank\\">Seo Panel 論壇</a>\r\n        </p>\r\n         \r\n        <p>\r\n            <a href=\\"<?=SP_SUPPORT_LINK?>\\" target=\\"_blank\\">Seo Panel 支持系統</a>\r\n        </p>\r\n         \r\n        <p>\r\n            <a href=\\"<?=SP_DONATE_LINK?>\\" target=\\"_blank\\">捐贈Seo Panel</a>\r\n        </p>\r\n    </li>\r\n     \r\n</ul>\r\n</fieldset>\r\n', '2011-07-06 06:47:27'),
(4867, 'cn', 'home', 'Pages Indexed', '頁面檢索', '2011-07-06 06:47:27'),
(4868, 'cn', 'home', 'Ranks', '排名', '2011-07-06 06:47:27'),
(4869, 'cn', 'home', 'SiteNameUrl', '站點 名字/URL', '2011-07-06 06:47:27'),
(4870, 'cn', 'home', 'Website Statistics', '站點統計', '2011-07-06 06:47:27'),
(4871, 'cn', 'keyword', 'Crawling keyword', '爬取關鍵字', '2011-07-06 06:50:02'),
(4872, 'cn', 'keyword', 'Detailed Keyword Position Reports', '顯示關鍵字排名報告', '2011-07-06 06:50:02'),
(4873, 'cn', 'keyword', 'Edit Keyword', '編輯關鍵字', '2011-07-06 06:50:02'),
(4874, 'cn', 'keyword', 'Graphical Keyword Position Reports', '關鍵字位置圖形報表', '2011-07-06 06:50:02'),
(4875, 'cn', 'keyword', 'Import Keywords', '導入關鍵字', '2011-07-06 06:50:02'),
(4876, 'cn', 'keyword', 'Keyword already exist', '關鍵字已存在', '2011-07-06 06:50:02'),
(4877, 'cn', 'keyword', 'Keyword Position Report', '關鍵字位置報告', '2011-07-06 06:50:02'),
(4878, 'cn', 'keyword', 'New Keyword', '新的關鍵字', '2011-07-06 06:50:02'),
(4879, 'cn', 'keyword', 'not assigned to required search engines', '未設置請求的搜索引擎', '2011-07-06 06:50:02'),
(4880, 'cn', 'keyword', 'pleaseselecttool', '請至少選擇一個seo工具', '2011-07-06 06:50:02'),
(4881, 'cn', 'keyword', 'Quick Keyword Position Checker', '快速關鍵字查詢', '2011-07-06 06:50:02'),
(4882, 'cn', 'keyword', 'results from ', '結果來自', '2011-07-06 06:50:02'),
(4883, 'cn', 'keyword', 'Show All results', '顯示所有結果', '2011-07-06 06:50:02'),
(4884, 'cn', 'keyword', 'Successfully crawled keyword', '成功爬取關鍵字', '2011-07-06 06:50:02'),
(4885, 'cn', 'keyword', 'to create new keywords', '創建新關鍵字', '2011-07-06 06:50:02'),
(4886, 'cn', 'label', 'already exist', '已經存在', '2014-01-09 15:35:37'),
(4887, 'cn', 'label', 'Authentication', '認證', '2014-01-09 15:35:37'),
(4888, 'cn', 'label', 'Author', '作者', '2014-01-09 15:35:37'),
(4889, 'cn', 'label', 'Click Here', '點擊這裡', '2014-01-09 15:35:37'),
(4890, 'cn', 'label', 'Cron', 'Cron', '2014-01-09 15:35:37'),
(4891, 'cn', 'label', 'Description', '描述', '2014-01-09 15:35:37'),
(4892, 'cn', 'label', 'Developers', '開發人員', '2014-01-09 15:35:37'),
(4893, 'cn', 'label', 'Download', '下載', '2014-01-09 15:35:37'),
(4894, 'cn', 'label', 'Installation', '安裝', '2014-01-09 15:35:37'),
(4895, 'cn', 'label', 'Keywords', '關鍵字', '2014-01-09 15:35:37'),
(4896, 'cn', 'label', 'noactiveplugins', '未找到可用的seo插件', '2014-01-09 15:35:37'),
(4897, 'cn', 'label', 'Plugin', '插件', '2014-01-09 15:35:37'),
(4898, 'cn', 'label', 'Port', '端口', '2014-01-09 15:35:37'),
(4899, 'cn', 'label', 'Proxy', '代理', '2014-01-09 15:35:37'),
(4900, 'cn', 'label', 'Re-install', '重新安裝', '2014-01-09 15:35:37'),
(4901, 'cn', 'label', 'Sponsors', '贊助商', '2014-01-09 15:35:37'),
(4902, 'cn', 'label', 'Title', '標題', '2014-01-09 15:35:37'),
(4903, 'cn', 'label', 'translation by', '譯者：', '2014-01-09 15:35:37'),
(4904, 'cn', 'label', 'Translators', '所有譯者：', '2014-01-09 15:35:37'),
(4905, 'cn', 'label', 'Upgrade', '升級', '2014-01-09 15:35:37'),
(4906, 'cn', 'label', 'Version', '版本', '2014-01-09 15:35:37'),
(4907, 'cn', 'label', 'wantproceed', '你確實要開始處理了嗎？', '2014-01-09 15:35:37'),
(4908, 'cn', 'login', 'Confirm Password', '確認密碼', '2014-01-09 15:40:06'),
(4909, 'cn', 'login', 'Create my account', '創建我的賬戶', '2014-01-09 15:40:06'),
(4910, 'cn', 'login', 'Create New Account', '創建一個新賬戶', '2014-01-09 15:40:06'),
(4911, 'cn', 'login', 'Email', '郵箱', '2014-01-09 15:40:06'),
(4912, 'cn', 'login', 'emailexist', '郵箱已存在', '2014-01-09 15:40:06'),
(4913, 'cn', 'login', 'Enter the code as it is shown', '輸入顯示的字符', '2014-01-09 15:40:06'),
(4914, 'cn', 'login', 'First Name', '名字', '2014-01-09 15:40:06'),
(4915, 'cn', 'login', 'Last Name', '姓', '2014-01-09 15:40:06'),
(4916, 'cn', 'login', 'Login', '登錄', '2014-01-09 15:40:06'),
(4917, 'cn', 'login', 'Login incorrect', '登錄信息不正確', '2014-01-09 15:40:06'),
(4918, 'cn', 'login', 'newaccountsuccess', '創建新賬戶成功', '2014-01-09 15:40:06'),
(4919, 'cn', 'login', 'Password', '密碼', '2014-01-09 15:40:06'),
(4920, 'cn', 'login', 'Password incorrect', '密碼不正確', '2014-01-09 15:40:06'),
(4921, 'cn', 'login', 'Register', '註冊', '2014-01-09 15:40:06'),
(4922, 'cn', 'login', 'Sign in to your account', '登錄你的賬戶', '2014-01-09 15:40:06'),
(4923, 'cn', 'login', 'User inactive', '用戶無效', '2014-01-09 15:40:06'),
(4924, 'cn', 'login', 'Username', '用戶名', '2014-01-09 15:40:06'),
(4925, 'cn', 'login', 'usernameexist', '用戶名已存在', '2014-01-09 15:40:06'),
(4926, 'cn', 'panel', 'About Us', '關於我們', '2014-01-09 15:37:31'),
(4927, 'cn', 'panel', 'Add following command to your cron tab', '加入以下命令到CRON列表', '2014-01-09 15:37:31'),
(4928, 'cn', 'panel', 'alsocheckfollowlink', '如果需要更多細節，請檢查一下鏈接', '2014-01-09 15:37:31'),
(4929, 'cn', 'panel', 'Check Directory', '檢查目錄', '2014-01-09 15:37:31'),
(4930, 'cn', 'panel', 'Cron Command', 'cron命令', '2014-01-09 15:37:31'),
(4931, 'cn', 'panel', 'Directory Manager', '目錄管理', '2014-01-09 15:37:31'),
(4932, 'cn', 'panel', 'Edit My Profile', '編輯我的資料', '2014-01-09 15:37:31'),
(4933, 'cn', 'panel', 'My Profile', '我的資料', '2014-01-09 15:37:31'),
(4934, 'cn', 'panel', 'New Proxy', '新建代理', '2014-01-09 15:37:31'),
(4935, 'cn', 'panel', 'New User', '新建用戶', '2014-01-09 15:37:31'),
(4936, 'cn', 'panel', 'New Website', '新的站點', '2014-01-09 15:37:31'),
(4937, 'cn', 'panel', 'Proxy Manager', '代理管理器', '2014-01-09 15:37:31'),
(4938, 'cn', 'panel', 'Report Generation Manager', '報告生成管理', '2014-01-09 15:37:31'),
(4939, 'cn', 'panel', 'Reports Manager', '報告管理', '2014-01-09 15:37:31'),
(4940, 'cn', 'panel', 'Seo Plugins Manager', 'seo插件管理', '2014-01-09 15:37:31'),
(4941, 'cn', 'panel', 'Seo Tools Manager', 'seo工具管理', '2014-01-09 15:37:31'),
(4942, 'cn', 'panel', 'System Settings', '系統設置', '2014-01-09 15:37:31'),
(4943, 'cn', 'panel', 'User Manager', '用戶管理', '2014-01-09 15:37:31'),
(4944, 'cn', 'panel', 'Website Manager', '站點管理', '2014-01-09 15:37:31'),
(4945, 'cn', 'plugin', 'Edit Seo Plugin', '編輯SEO插件', '2014-01-09 15:43:38'),
(4946, 'cn', 'plugin', 'Plugin Name', '插件名字', '2014-01-09 15:43:38'),
(4947, 'cn', 'plugin', 'Seo Plugin Details', 'SEO插件細節', '2014-01-09 15:43:38'),
(4948, 'cn', 'proxy', 'Edit Proxy', '編輯代理', '2014-01-09 15:44:24'),
(4949, 'cn', 'proxy', 'Proxy Password', '代理密碼', '2014-01-09 15:44:24'),
(4950, 'cn', 'proxy', 'Proxy Username', '代理用戶名', '2014-01-09 15:44:24'),
(4951, 'cn', 'proxy', 'Proxyalreadyexist', '代理已經存在', '2014-01-09 15:44:24'),
(4952, 'cn', 'rank', 'enterurlproceed', '輸入URL，<b>每行一條</b>。點擊<b>處理</b>開始檢查Google PR和Alexa 排名', '2011-05-04 09:43:04'),
(4953, 'cn', 'rank', 'Google and Alexa Rank Reports', 'Google PR和 Alexa 排名報告', '2011-05-04 09:43:04'),
(4954, 'cn', 'rank', 'Saved rank results of', '保存排名結果', '2011-05-04 09:43:04'),
(4955, 'cn', 'saturation', 'clickproceedsaturation', '輸入URL，<b>每行一條</b>。點擊<b>處理</b>開始檢查搜索引擎搜錄報告', '2011-05-04 09:46:51'),
(4956, 'cn', 'saturation', 'GenerateSaturationReports', '生成搜索引擎搜錄報告', '2011-05-04 09:46:51'),
(4957, 'cn', 'saturation', 'Quick Search Engine Saturation Checker', '快速搜索引擎搜錄檢查', '2011-05-04 09:46:51'),
(4958, 'cn', 'saturation', 'Saved Search Engine Saturation results of', '保存搜索引擎搜錄結果', '2011-05-04 09:46:51'),
(4959, 'cn', 'saturation', 'Search Engine Saturation Reports', '搜索引擎搜錄報告', '2011-05-04 09:46:51'),
(4960, 'cn', 'seotools', 'Automatic Submission', '自動提交', '2011-07-06 06:55:41'),
(4961, 'cn', 'seotools', 'backlink-checker', '反向鏈接檢查', '2011-07-06 06:55:41'),
(4962, 'cn', 'seotools', 'Backlinks Reports', '反向鏈接報告', '2011-07-06 06:55:41'),
(4963, 'cn', 'seotools', 'Check Submission Status', '檢查提交狀態', '2011-07-06 06:55:41'),
(4964, 'cn', 'seotools', 'clickgeneratereports', '點擊<b>處理</b>開始生成報告', '2011-07-06 06:55:41'),
(4965, 'cn', 'seotools', 'Detailed Position Reports', '詳細的位置報告', '2011-07-06 06:55:41'),
(4966, 'cn', 'seotools', 'directory-submission', '目錄提交', '2011-07-06 06:55:41'),
(4967, 'cn', 'seotools', 'Featured Submission', '篩選提交', '2011-07-06 06:55:41'),
(4968, 'cn', 'seotools', 'Generate Backlinks Reports', '生成反向鏈接報告', '2011-07-06 06:55:41'),
(4969, 'cn', 'seotools', 'Generate Keyword Reports', '生成關鍵字報告', '2011-07-06 06:55:41'),
(4970, 'cn', 'seotools', 'Generate Rank Reports', '生成排名報告', '2011-07-06 06:55:41'),
(4971, 'cn', 'seotools', 'Generate Saturation Reports', '生成收錄量報告', '2011-07-06 06:55:41'),
(4972, 'cn', 'seotools', 'Google Sitemap Generator', 'Google網站地圖報告', '2011-07-06 06:55:41'),
(4973, 'cn', 'seotools', 'Graphical Position Reports', '圖形位置報告', '2011-07-06 06:55:41'),
(4974, 'cn', 'seotools', 'Keyword Position Summary', '關鍵字概述', '2011-07-06 06:55:41'),
(4975, 'cn', 'seotools', 'keyword-position-checker', '關鍵字檢查', '2011-07-06 06:55:41'),
(4976, 'cn', 'seotools', 'Keywords Manager', '關鍵字管理', '2011-07-06 06:55:41'),
(4977, 'cn', 'seotools', 'Quick Backlinks Checker', '快速反向鏈接檢查', '2011-07-06 06:55:41'),
(4978, 'cn', 'seotools', 'Quick Position Checker', '快速位置檢查', '2011-07-06 06:55:41'),
(4979, 'cn', 'seotools', 'Quick Rank Checker', '快速排名檢查', '2011-07-06 06:55:41'),
(4980, 'cn', 'seotools', 'Quick Saturation Checker', '快速收錄量檢查', '2011-07-06 06:55:41'),
(4981, 'cn', 'seotools', 'Rank Reports', '排名報告', '2011-07-06 06:55:41'),
(4982, 'cn', 'seotools', 'rank-checker', '排名檢查', '2011-07-06 06:55:41'),
(4983, 'cn', 'seotools', 'Saturation Reports', '收錄量報告', '2011-07-06 06:55:41'),
(4984, 'cn', 'seotools', 'saturation-checker', '搜索引擎收錄量', '2011-07-06 06:55:41'),
(4985, 'cn', 'seotools', 'sitemap-generator', '站點地圖生成器', '2011-07-06 06:55:41'),
(4986, 'cn', 'seotools', 'Skipped Directories', '跳過的目錄', '2011-07-06 06:55:41'),
(4987, 'cn', 'seotools', 'Submission Reports', '提交報告', '2011-07-06 06:55:41'),
(4988, 'cn', 'seotools', 'User Access', '用戶訪問', '2011-07-06 06:55:41'),
(4989, 'cn', 'settings', 'Click here to become a sponsor for Seo Panel', '<b>捐贈$100</b> 成為Seo Panel的一個<b>贊助人</b>.', '2014-01-09 16:04:14'),
(4990, 'cn', 'settings', 'seopanel_description', 'Seo panel是一個完整的免費的能對你的站點進行搜索引擎優化的控制面板。它擁有很多熱門的seo工具來追踪你的站點情況。它是一個開源軟件，而且你可以開發自己的seopanel。', '2014-01-09 16:04:14'),
(4991, 'cn', 'settings', 'seopanel_title', 'Seo Panel：全球第一款多​​站點seo處理開源軟件', '2014-01-09 16:04:14'),
(4992, 'cn', 'settings', 'SP_CRAWL_DELAY', '每次爬去间隔时间(秒)', '2014-01-09 16:04:14'),
(4993, 'cn', 'settings', 'SP_DEFAULTLANG', '默認語言', '2014-01-09 16:04:14'),
(4994, 'cn', 'settings', 'SP_DESCRIPTION', 'Seo Panel 描述', '2014-01-09 16:04:14'),
(4995, 'cn', 'settings', 'SP_ENABLE_PROXY', '使用代理', '2014-01-09 16:04:14'),
(4996, 'cn', 'settings', 'SP_HOTLINKING', '使用圖片盜鏈保護', '2014-01-09 16:04:14'),
(4997, 'cn', 'settings', 'SP_KEYWORDS', 'Seo Panel 關鍵字', '2014-01-09 16:04:14'),
(4998, 'cn', 'settings', 'SP_PAGINGNO', '每頁條目數量', '2014-01-09 16:04:14'),
(4999, 'cn', 'settings', 'SP_TITLE', 'Seo Panel 標題', '2014-01-09 16:04:14'),
(5000, 'cn', 'settings', 'SP_USER_AGENT', '用戶代理', '2014-01-09 16:04:14'),
(5001, 'cn', 'settings', 'SP_USER_GEN_REPORT', '允許用戶生成報告', '2014-01-09 16:04:14'),
(5002, 'cn', 'settings', 'SP_USER_REGISTRATION', '用戶註冊接口', '2014-01-09 16:04:14'),
(5003, 'cn', 'settings', 'syssettingssaved', '系統設置保存成功', '2014-01-09 16:04:14'),
(5004, 'cn', 'sitemap', 'Change frequency', '改變頻率', '2011-05-04 09:58:33'),
(5005, 'cn', 'sitemap', 'clickproceedsitemap', '點擊<b>處理</b>創建站點地圖文件', '2011-05-04 09:58:33'),
(5006, 'cn', 'sitemap', 'Download sitemap file from', '下載站點地圖文件', '2011-05-04 09:58:33'),
(5007, 'cn', 'sitemap', 'Exclude Url', '不包括的URL', '2011-05-04 09:58:33'),
(5008, 'cn', 'sitemap', 'processtaketime', '本次處理需要一段時間根據你的站點連接數。請等待，稍後將獲取站點地圖文件', '2011-05-04 09:58:33'),
(5009, 'cn', 'sitemap', 'Sitemap Type', '站點地圖類型', '2011-05-04 09:58:33'),
(5010, 'cn', 'support', 'support_cont1', '<fieldset>\r\n<legend>Seo Panel 幫助系統</legend>\r\n<ul class=\\"infobox\\">\r\n    <li>\r\n        <h1>1000 目錄包</h1>\r\n        <p>\r\n            我們提供<b>超過1000個可用的</b>網絡目錄包,加到\r\n你的seo panel <b>目錄提交工具</b>.\r\n            它會幫助你<b>增加反向鏈接</b>你的站點.\r\n            在我們獲得捐贈後為seo panel<b>以為未來發展</b>,您將獲得<b>推薦</b>的1000目錄列表，.\r\n            想要獲得1000目錄列表請<a href=\\"<?=SP_DONATE_LINK?>\\" target=\\"_blank\\">捐贈</a>\r\n$10 或者更多 來改善 seo panel 的功能 .\r\n            如果你有任何問題關於1000目錄包,請<a href=\\"<?=SP_CONTACT_LINK?>\\"\r\ntarget=\\"_blank\\">聯繫我們</a>或者打開一個頁面<a href=\\"<?=SP_SUPPORT_LINK?>\\"\r\ntarget=\\"_blank\\">幫助系統</a>.\r\n        </p>\r\n        <p>\r\n            <a href=\\"<?=SP_DONATE_LINK?>\\" target=\\"_blank\\">訪問這個鏈接捐贈seo panel</a>\r\n        </p>\r\n        <br>\r\n    </li>\r\n     \r\n    <li>\r\n        <h1>本地搜索引擎包</h1>\r\n        <p>\r\n            增加<b>本地搜索引擎域</b>google,yahoo,msn(<b>例如: www.google.de,www.google.fr\r\netc</b>) seo panel <b>關鍵字position checker</b>, 追踪你的站點行為本地.\r\n            為了獲得本地搜索引擎包(根據你的需求) 請<a\r\nhref=\\"<?=SP_DONATE_LINK?>\\" target=\\"_blank\\">捐贈</a> $10或者更多來改善功能seo\r\npanel.\r\n            捐贈之前, 請<a href=\\"<?=SP_CONTACT_LINK?>\\" target=\\"_blank\\">聯繫我們</a> to\r\n提供給我們需要的搜索引擎域名列表.\r\n            <br><br>\r\n             增加<b>新的搜索引擎(例如:baidu.com)</b>你的seo panel關鍵字position checker,\r\n請<a href=\\"<?=SP_CONTACT_LINK?>\\" target=\\"_blank\\">聯繫我們</a>或者打開一個頁面在<a\r\nhref=\\"<?=SP_SUPPORT_LINK?>\\" target=\\"_blank\\">幫助系統</a>.\r\n        </p>\r\n        <p class=\\"visit\\">\r\n            <a href=\\"<?=SP_CONTACT_LINK?>\\" target=\\"_blank\\">訪問這個鏈接聯繫我們</a>\r\n        </p>\r\n        <br>\r\n    </li>\r\n     \r\n    <li>\r\n        <h1>Seo Panel插件</h1>\r\n        <p>\r\n            增加<b>seo插件</b> 你的seo panel <b>擴展功能</b>根據你的\r\n需求.\r\n            <a href=\\"<?=SP_PLUGINSITE?>\\" target=\\"_blank\\">Seo panel插件</a>由seo panel\r\n和第三方站點提供.\r\n            你可以easily <b>develop</b> seo插件來你的seo panel.\r\n            你可以<a href=\\"<?=SP_PLUGINSITE?>\\" target=\\"_blank\\">提交</a>你的seo plugin seo panel 並且\r\n我們會<b>發布</b>到我們的站點在<b>審查</b>之後.\r\n        </p>\r\n        <p>\r\n            <a href=\\"<?=SP_PLUGINSITE?>\\" target=\\"_blank\\">訪問這個鏈接為了獲得seo panel插件</a>\r\n        </p>\r\n        <br>\r\n    </li>\r\n    <li>\r\n        <h1>聯繫我們</h1>\r\n        <p>\r\n            聯繫我們來任何問題關於<b>seo panel 工具,插件和功能等等</b> 通過以下鏈接.\r\n        </p>\r\n        <p>\r\n            <a href=\\"<?=SP_CONTACT_LINK?>\\" target=\\"_blank\\">訪問這個鏈接聯繫我們</a>\r\n        </p>\r\n        <br>\r\n    </li>\r\n    <li>\r\n        <h1>技術支持</h1>\r\n        <p>\r\n            為了獲得<b>技術支持</b>從seo panel團隊設置<b>seo panel工具,插件和\r\n功能</b>. 例如: 設置cron來關鍵字位置checker.\r\n        </p>\r\n        <p>\r\n            <a href=\\"<?=SP_SUPPORT_LINK?>\\" target=\\"_blank\\">訪問這個鏈接創建一個支持ticket</a>\r\n        </p>\r\n        <br>\r\n    </li>\r\n    <li>\r\n        <h1>報告Bugs</h1>\r\n        <p>\r\n            報告<b>bugs</b> 關於<b>seo panel 工具,插件和功能等等</b> 通過以下鏈接.\r\n            請幫助我們在下個版本來改善功能.\r\n        </p>\r\n        <p>\r\n            <a href=\\"<?=SP_SUPPORT_LINK?>\\" target=\\"_blank\\">訪問這個鏈接報告bugs</a>\r\n        </p>\r\n        <br>\r\n    </li>\r\n</ul>\r\n</fieldset>', '2011-05-04 09:59:39'),
(5011, 'cn', 'support', 'support_cont2', '<fieldset>\r\n<legend>Seo Panel 在線資源</legend>\r\n<ul class=\\"infobox\\">\r\n         \r\n    <li>\r\n        <h1>Seo Panel 幫助嚮導</h1>\r\n        <p>\r\n            你可以看<a href=\\"<?=SP_HELP_LINK?>\\" target=\\"_blank\\">seo panel文檔</a>在\r\n<b>幫助嚮導</b>, 它包括<b>文檔</b>來seo panel 工具,插件和相關的\r\n功能.\r\n            <br>這是在因特網獲得關於seo panel幫助的<b>最好的地方</b>.如果你發現錯誤或者缺少東西,我們希望你seo panel 幫助嚮導<b>報告</b>.\r\n        </p>\r\n        <p>\r\n            <a href=\\"<?=SP_HELP_LINK?>\\" target=\\"_blank\\">訪問seo panel 幫助嚮導</a>\r\n        </p>\r\n        <br>\r\n    </li>\r\n    <li>\r\n        <h1>Seo Panel論壇</h1>\r\n        <p>\r\n            一個地方討論關於世界上第一款開源的<b>seo control panel</b>.\r\n            這是最好的地方找到<b>答案</b> <b>你的問題</b> 關於seo panel.\r\n            <br> 你可以<b>分享</b>你的<b>經驗</b> 在使用seo panel來操作你的\r\n站點.\r\n        </p>\r\n        <p>\r\n            <a href=\\"<?=SP_FORUM_LINK?>\\" target=\\"_blank\\">訪問seo panel論壇</a>\r\n        </p>\r\n        <br>\r\n    </li>\r\n</ul>\r\n</fieldset>\r\n', '2011-05-04 09:59:39'),
(5012, 'cn', 'support', 'support_cont3', '<fieldset>\r\n<legend>捐贈 Seo Panel</legend>\r\n<ul class=\\"infobox\\">\r\n    <li>\r\n        <h1>捐贈Seo Panel - 世界上第一款開源的seo control panel</h1>\r\n        <p>\r\n            <b>捐贈</b> seo panel支持第一款開源的seo control panel世界上.\r\n            我們計劃<b>增加和提高</b> 功能seo panel 的在未來.\r\n            <br>有了你的<b>支持</b>我們才能達到我們的<b>目標</b>.\r\n            如果你覺得seo panel是<b>值得</b>你擁有, 請捐贈支持seo panel 團隊.\r\n            <br>我們<b>會公佈</b> 你的名字和站點信息在<a href=\\"<?=SP_DONATE_LINK?>\\"\r\ntarget=\\"_blank\\">捐贈頁面</a>, 一旦我們獲得捐贈.\r\n        </p>\r\n        <p>\r\n            <a href=\\"<?=SP_DONATE_LINK?>\\" target=\\"_blank\\">訪問這個鏈接捐贈seo panel</a>\r\n        </p>\r\n        <br>\r\n    </li>\r\n</ul>\r\n</fieldset>', '2011-05-04 09:59:39'),
(5013, 'cn', 'user', 'Edit User', '編輯用戶信息', '2011-05-04 10:00:10'),
(5014, 'cn', 'user', 'Saved My Profile Details', '保存我的詳細資料', '2011-05-04 10:00:10'),
(5015, 'cn', 'website', 'Edit Website', '編輯站點', '2011-05-04 10:00:54'),
(5016, 'cn', 'website', 'plscrtwebsite', '使用seo工具和插件前，請先創建一個站點', '2011-05-04 10:00:54'),
(5017, 'cn', 'website', 'Website already exist', '站點已經存在', '2011-05-04 10:00:54'),
(5018, 'cn', 'website', 'yourwebalreday', '你的站點，如果你已經創建了一個', '2011-05-04 10:00:54'),
(5019, 'en', 'settings', 'Check for Updates', 'Check for Updates', '2011-06-09 09:10:34'),
(5020, 'en', 'settings', 'Your Seo Panel installation is up to date', 'Your Seo Panel installation is up to date.', '2011-06-09 09:40:14'),
(5021, 'en', 'settings', 'versionnotuptodatemsg', 'Your Seo Panel installation is not up to date. <br>Please download new version', '2011-06-09 09:40:14'),
(5022, 'en', 'seotools', 'site-auditor', 'Site Auditor', '2011-06-14 07:46:30'),
(5023, 'en', 'seotools', 'Auditor Projects', 'Auditor Projects', '2011-06-15 01:20:18'),
(5024, 'en', 'seotools', 'Auditor Settings', 'Auditor Settings', '2011-06-15 01:21:50'),
(5025, 'en', 'seotools', 'Auditor Reports', 'Auditor Reports', '2011-06-15 01:21:50'),
(5026, 'en', 'panel', 'New Project', 'New Project', '2011-06-15 01:39:23'),
(5027, 'en', 'panel', 'Edit Project', 'Edit Project', '2011-06-15 06:24:40'),
(5028, 'es', 'panel', 'Edit Project', 'Editar proyecto', '2012-05-12 10:55:03'),
(5029, 'es', 'panel', 'New Project', 'Nuevo proyecto', '2012-05-12 10:55:03'),
(5030, 'es', 'settings', 'Check for Updates', 'Buscar actualizaciones', '2012-05-12 11:03:05'),
(5031, 'es', 'settings', 'versionnotuptodatemsg', 'Tu version de Seo Panle está desactualizada<br /> Descarga la nueva version.', '2012-05-12 11:03:05'),
(5032, 'es', 'settings', 'Your Seo Panel installation is up to date', 'Tu version de Seo Panel está actualizada.', '2012-05-12 11:03:05'),
(5033, 'es', 'seotools', 'Auditor Projects', 'Proyectos', '2011-07-13 19:32:41'),
(5034, 'es', 'seotools', 'Auditor Reports', 'Informes', '2011-07-13 19:32:41'),
(5035, 'es', 'seotools', 'Auditor Settings', 'Configuración', '2011-07-13 19:32:41'),
(5036, 'es', 'seotools', 'site-auditor', 'Informe del sitio', '2011-07-13 19:32:41'),
(5037, 'en', 'keyword', 'Insert keywords separated with comma', 'Insert keywords separated with comma', '2011-07-04 07:48:43'),
(5038, 'en', 'siteauditor', 'Maximum Pages', 'Maximum Pages', '2011-07-04 07:53:29'),
(5039, 'en', 'siteauditor', 'Pages Found', 'Pages Found', '2011-07-04 07:53:29'),
(5040, 'en', 'siteauditor', 'Crawled Pages', 'Crawled Pages', '2011-07-04 07:54:08'),
(5041, 'en', 'siteauditor', 'Recheck Pages', 'Recheck Pages', '2011-07-04 07:54:08'),
(5042, 'en', 'label', 'Score', 'Score', '2011-07-04 07:57:57'),
(5043, 'en', 'label', 'Updated', 'Updated', '2011-07-04 07:58:33'),
(5044, 'en', 'label', 'View Reports', 'View Reports', '2011-07-04 08:10:55'),
(5045, 'en', 'siteauditor', 'Run Project', 'Run Project', '2011-07-04 08:11:28'),
(5046, 'en', 'settings', 'SA_MAX_NO_PAGES', 'Maximum number of pages allowed per website', '2011-07-04 08:14:44'),
(5047, 'en', 'siteauditor', 'Site Auditor Settings', 'Site Auditor Settings', '2011-07-04 08:20:36'),
(5048, 'en', 'settings', 'SA_CRAWL_DELAY_TIME', 'Site auditor crawl delay between each pages', '2011-07-04 08:24:45'),
(5049, 'en', 'seotools', 'Import Project Links', 'Import Project Links', '2011-07-04 08:27:22'),
(5050, 'en', 'label', 'Project', 'Project', '2011-07-04 08:29:24'),
(5051, 'en', 'siteauditor', 'Maximum number of pages to be checked', 'Maximum number of pages to be checked', '2011-07-04 08:45:26'),
(5052, 'en', 'siteauditor', 'Exclude links', 'Exclude links', '2011-07-04 08:45:50'),
(5053, 'en', 'siteauditor', 'insertlinkssepcoma', 'Insert links separated with comma to exclude infinite links from the reports', '2011-07-04 08:49:43'),
(5054, 'en', 'siteauditor', 'anylinkcontainabovelinks', 'Any links contain above links will be excluded from reports', '2011-07-04 08:50:19'),
(5055, 'en', 'siteauditor', 'Check google pagerank of pages', 'Check google pagerank of pages', '2011-07-04 08:52:15'),
(5056, 'en', 'siteauditor', 'Check backlinks of pages', 'Check backlinks of pages', '2011-07-04 08:52:15'),
(5057, 'en', 'siteauditor', 'Check pages indexed or not', 'Check pages indexed or not', '2011-07-04 08:52:32'),
(5058, 'en', 'siteauditor', 'Store all links found in a page', 'Store all links found in a page', '2011-07-04 08:52:32'),
(5059, 'en', 'siteauditor', 'Check broken links in a page', 'Check broken links in a page', '2011-07-04 08:53:05'),
(5060, 'en', 'siteauditor', 'checkborckenlinkwait', 'Check brocken links will increase the execution time of a project', '2011-07-04 08:53:05'),
(5061, 'en', 'siteauditor', 'Execute with cron', 'Execute with cron', '2011-07-04 08:53:21'),
(5062, 'en', 'siteauditor', 'Number of pages is greater than', 'Number of pages is greater than', '2011-07-04 09:03:18'),
(5063, 'en', 'siteauditor', 'Number of pages should be greater than', 'Number of pages should be greater than', '2011-07-04 09:05:57'),
(5064, 'en', 'siteauditor', 'projectalreadyexist', 'Project for this website already exist', '2011-07-04 09:07:07'),
(5065, 'en', 'label', 'Exclude', 'Exclude', '2011-07-04 09:10:34'),
(5066, 'en', 'label', 'Include', 'Include', '2011-07-04 09:10:34'),
(5067, 'en', 'siteauditor', 'should start with', 'should start with', '2011-07-04 09:12:04'),
(5068, 'en', 'siteauditor', 'Project Summary', 'Project Summary', '2011-07-04 09:36:28'),
(5069, 'en', 'siteauditor', 'Crawling Page', 'Crawling Page', '2011-07-04 09:36:28'),
(5070, 'en', 'siteauditor', 'pressescapetostopexecution', 'Press <b>escape</b> key to stop execution of script', '2011-07-04 09:37:42'),
(5071, 'en', 'siteauditor', 'to run project again if you stopped execution', 'to run project again if you stopped execution', '2011-07-04 09:39:32'),
(5072, 'en', 'siteauditor', 'crawledsuccesssfullywaitfornext', 'crawled successfully! Waiting for crawling next page for', '2011-07-04 09:40:57'),
(5073, 'en', 'siteauditor', 'Completed project execution', 'Completed project execution', '2011-07-04 09:42:06'),
(5074, 'en', 'siteauditor', 'to view the reports', 'to view the reports', '2011-07-04 09:42:06'),
(5075, 'en', 'siteauditor', 'Link Reports', 'Link Reports', '2011-07-05 07:03:09'),
(5076, 'en', 'siteauditor', 'Report Summary', 'Report Summary', '2011-07-05 07:03:09'),
(5077, 'en', 'siteauditor', 'Duplicate Title', 'Duplicate Title', '2011-07-05 07:03:27'),
(5078, 'en', 'siteauditor', 'Duplicate Description', 'Duplicate Description', '2011-07-05 07:03:27'),
(5079, 'en', 'siteauditor', 'Duplicate Keywords', 'Duplicate Keywords', '2011-07-05 07:03:36'),
(5080, 'en', 'siteauditor', 'No active projects found', 'No active projects found', '2011-07-05 07:04:13'),
(5081, 'en', 'label', 'Report Type', 'Report Type', '2011-07-05 07:07:46'),
(5082, 'en', 'siteauditor', 'Crawled', 'Crawled', '2011-07-05 07:08:35'),
(5083, 'en', 'siteauditor', 'Page Link', 'Page Link', '2011-07-05 07:10:01'),
(5084, 'en', 'label', 'Brocken', 'Broken', '2011-07-05 07:14:20'),
(5085, 'en', 'home', 'Indexed', 'Indexed', '2011-07-05 07:16:54'),
(5086, 'en', 'siteauditor', 'Total Links', 'Total Links', '2011-07-05 07:25:02'),
(5087, 'en', 'siteauditor', 'External Links', 'External Links', '2011-07-05 07:28:13'),
(5088, 'en', 'label', 'Comments', 'Comments', '2011-07-05 07:37:55'),
(5089, 'en', 'label', 'Total Results', 'Total Results', '2011-07-05 07:40:51'),
(5090, 'en', 'siteauditor', 'Project Url', 'Project Url', '2011-07-05 07:43:00'),
(5091, 'en', 'siteauditor', 'Page Details', 'Page Details', '2011-07-05 07:48:12'),
(5092, 'en', 'siteauditor', 'Check Score', 'Check Score', '2011-07-05 07:48:12'),
(5093, 'en', 'siteauditor', 'Import Project Links', 'Import Project Links', '2011-07-05 07:49:36'),
(5094, 'en', 'siteauditor', 'Page Links', 'Page Links', '2011-07-05 08:02:58'),
(5095, 'en', 'siteauditor', 'Anchor', 'Anchor', '2011-07-05 08:04:07'),
(5096, 'en', 'siteauditor', 'Link Title', 'Link Title', '2011-07-05 08:04:45'),
(5097, 'en', 'siteauditor', 'Nofollow', 'Nofollow', '2011-07-05 08:05:25'),
(5098, 'en', 'siteauditor', 'External', 'External', '2011-07-05 08:06:26'),
(5099, 'en', 'label', 'Count', 'Count', '2011-07-05 08:33:22'),
(5100, 'en', 'siteauditor', 'Insert links separated with comma', 'Insert links separated with comma', '2011-07-05 08:50:06'),
(5101, 'en', 'siteauditor', 'totallinksgreaterallowed', 'Total links will become greater than maximum links allowed to the project', '2011-07-05 08:53:12'),
(5102, 'en', 'siteauditor', 'anylinkcontainexcludesitemap', 'Any links contain above links will be excluded from sitemap', '2011-07-05 09:13:12'),
(5103, 'en', 'siteauditor', 'The page title length is not between', 'The page title length is not between', '2011-07-05 09:18:06'),
(5104, 'en', 'siteauditor', 'The page description length is not between', 'The page description length is not between', '2011-07-05 09:18:58'),
(5105, 'en', 'siteauditor', 'The page keywords length is not between', 'The page keywords length is not between', '2011-07-05 09:19:53'),
(5106, 'en', 'siteauditor', 'The page is brocken', 'The page is brocken', '2011-07-05 09:23:30'),
(5107, 'en', 'siteauditor', 'The total number of links in page is greater than', 'The total number of links in page is greater than\r\n', '2011-07-05 09:23:30'),
(5108, 'en', 'siteauditor', 'The page is having exellent pagerank', 'The page is having exellent pagerank', '2011-07-05 09:23:50'),
(5109, 'en', 'siteauditor', 'The page is having very good pagerank', 'The page is having very good pagerank', '2011-07-05 09:23:50'),
(5110, 'en', 'siteauditor', 'The page is having good pagerank', 'The page is having good pagerank', '2011-07-05 09:24:11'),
(5111, 'en', 'siteauditor', 'The page is having poor pagerank', 'The page is having poor pagerank', '2011-07-05 09:24:11'),
(5112, 'en', 'siteauditor', 'The page is having exellent number of backlinks in', 'The page is having exellent number of backlinks in', '2011-07-05 09:24:32'),
(5113, 'en', 'siteauditor', 'The page is having good number of backlinks in', 'The page is having good number of backlinks in', '2011-07-05 09:24:32');
INSERT INTO `texts` (`id`, `lang_code`, `category`, `label`, `content`, `changed`) VALUES
(5114, 'en', 'siteauditor', 'The page is not having backlinks in', 'The page is not having backlinks in', '2011-07-05 09:24:51'),
(5115, 'en', 'siteauditor', 'The page is not indexed in', 'The page is not indexed in', '2011-07-05 09:24:51'),
(5127, 'ru', 'label', 'Updated', 'Обновлено', '2017-07-13 16:42:21'),
(5128, 'ru', 'label', 'View Reports', 'Просмотр отчетов', '2017-07-13 16:42:21'),
(5129, 'ru', 'panel', 'Edit Project', 'Редактировать проект', '2017-07-13 16:46:03'),
(5130, 'ru', 'panel', 'New Project', 'Новый проект', '2017-07-13 16:46:03'),
(5131, 'ru', 'seotools', 'Auditor Projects', 'Аудитор проектов', '2017-07-13 16:49:15'),
(5132, 'ru', 'seotools', 'Auditor Reports', 'Аудитор отчетов', '2017-07-13 16:49:15'),
(5133, 'ru', 'seotools', 'Auditor Settings', 'Настройки аудитора', '2017-07-13 16:49:15'),
(5134, 'ru', 'seotools', 'Import Project Links', 'Импорт ссылки проекта', '2017-07-13 16:49:15'),
(5135, 'ru', 'seotools', 'site-auditor', 'Аудитор сайта', '2017-07-13 16:49:15'),
(5136, 'ru', 'settings', 'Check for Updates', 'Проверить наличие обновлений', '2017-07-13 16:50:08'),
(5137, 'ru', 'settings', 'SA_CRAWL_DELAY_TIME', 'Задержка между обходом каждой страницы сайта при аудите', '2017-07-13 16:50:08'),
(5138, 'ru', 'settings', 'SA_MAX_NO_PAGES', 'Максимально разрешенное количество страниц на сайте', '2017-07-13 16:50:08'),
(5139, 'ru', 'settings', 'versionnotuptodatemsg', 'Ваша Seo Panel устарела. <br>Пожалуйста, скачайте новую версию', '2017-07-13 16:50:08'),
(5140, 'ru', 'settings', 'Your Seo Panel installation is up to date', 'Установленная Seo Panel в актуальном состоянии.', '2017-07-13 16:50:08'),
(5141, 'ja', 'home', 'Indexed', 'インデックス済', '2011-07-05 13:26:54'),
(5142, 'ja', 'keyword', 'Insert keywords separated with comma', 'キーワードをカンマ区切りで挿入', '2016-01-04 06:34:06'),
(5143, 'ja', 'label', 'Brocken', 'リンク切れ', '2016-12-12 01:03:47'),
(5144, 'ja', 'label', 'Comments', 'コメント', '2016-12-12 01:03:47'),
(5145, 'ja', 'label', 'Count', 'カウント', '2016-12-12 01:03:47'),
(5146, 'ja', 'label', 'Exclude', '除外する', '2016-12-12 01:03:47'),
(5147, 'ja', 'label', 'Include', '含める', '2016-12-12 01:03:47'),
(5148, 'ja', 'label', 'Project', 'プロジェクト', '2016-12-12 01:03:47'),
(5149, 'ja', 'label', 'Report Type', 'レポートタイプ', '2016-12-12 01:03:47'),
(5150, 'ja', 'label', 'Score', 'スコア', '2016-12-12 01:03:47'),
(5151, 'ja', 'label', 'Total Results', '総合結果', '2016-12-12 01:03:47'),
(5152, 'ja', 'label', 'Updated', '更新済', '2016-12-12 01:03:47'),
(5153, 'ja', 'label', 'View Reports', 'レポートを閲覧', '2016-12-12 01:03:47'),
(5154, 'ja', 'panel', 'Edit Project', 'プロジェクトの編集', '2016-12-12 01:06:09'),
(5155, 'ja', 'panel', 'New Project', '新規プロジェクト', '2016-12-12 01:06:09'),
(5156, 'ja', 'seotools', 'Auditor Projects', '監査プロジェクト', '2011-07-05 13:39:46'),
(5157, 'ja', 'seotools', 'Auditor Reports', '監査レポート', '2011-07-05 13:39:46'),
(5158, 'ja', 'seotools', 'Auditor Settings', '監査設定', '2011-07-05 13:39:46'),
(5159, 'ja', 'seotools', 'Import Project Links', 'プロジェクトリンクのインポート', '2011-07-05 13:39:46'),
(5160, 'ja', 'seotools', 'site-auditor', 'サイト監査', '2011-07-05 13:39:46'),
(5161, 'ja', 'settings', 'Check for Updates', '更新を確認', '2016-12-12 04:26:25'),
(5162, 'ja', 'settings', 'SA_CRAWL_DELAY_TIME', '各ページのサイト監査巡回頻度', '2016-12-12 04:26:25'),
(5163, 'ja', 'settings', 'SA_MAX_NO_PAGES', '１ウェブサイトに許可される最大ページ数', '2016-12-12 04:26:25'),
(5164, 'ja', 'settings', 'versionnotuptodatemsg', 'お使いのSeo Panelは最新版ではありません。　<br>新バージョンをダウンロードしてください。', '2016-12-12 04:26:25'),
(5165, 'ja', 'settings', 'Your Seo Panel installation is up to date', '最新版のSeo Panelがインストールされています。', '2016-12-12 04:26:25'),
(5166, 'ja', 'siteauditor', 'Anchor', 'アンカー', '2016-12-12 04:56:08'),
(5167, 'ja', 'siteauditor', 'anylinkcontainabovelinks', '上記リンクを含むリンクはレポートから除外されます', '2016-12-12 04:56:08'),
(5168, 'ja', 'siteauditor', 'anylinkcontainexcludesitemap', '上記リンクを含むリンクはサイトマップから除外されます', '2016-12-12 04:56:08'),
(5169, 'ja', 'siteauditor', 'Check backlinks of pages', 'ページのバックリンクを確認', '2016-12-12 04:56:08'),
(5170, 'ja', 'siteauditor', 'Check broken links in a page', 'ページ内のリンク切れを確認', '2016-12-12 04:56:08'),
(5171, 'ja', 'siteauditor', 'Check google pagerank of pages', 'ページのgoogleページランクを確認', '2016-12-12 04:56:08'),
(5172, 'ja', 'siteauditor', 'Check pages indexed or not', 'ページのインデックス状況を確認', '2016-12-12 04:56:08'),
(5173, 'ja', 'siteauditor', 'Check Score', 'スコアの確認', '2016-12-12 04:56:08'),
(5174, 'ja', 'siteauditor', 'checkborckenlinkwait', 'リンク切れ確認は、プロジェクトの実行時間を増加させます', '2016-12-12 04:56:08'),
(5175, 'ja', 'siteauditor', 'Completed project execution', 'プロジェクトの実行完了', '2016-12-12 04:56:08'),
(5176, 'ja', 'siteauditor', 'Crawled', 'クロール済', '2016-12-12 04:56:08'),
(5177, 'ja', 'siteauditor', 'Crawled Pages', 'クロール済ページ', '2016-12-12 04:56:08'),
(5178, 'ja', 'siteauditor', 'crawledsuccesssfullywaitfornext', 'クロールに成功！次ページのクロール待機中', '2016-12-12 04:56:08'),
(5179, 'ja', 'siteauditor', 'Crawling Page', 'クロール中のページ', '2016-12-12 04:56:08'),
(5180, 'ja', 'siteauditor', 'Duplicate Description', '重複ディスクリプション', '2016-12-12 04:56:08'),
(5181, 'ja', 'siteauditor', 'Duplicate Keywords', '重複キーワード', '2016-12-12 04:56:08'),
(5182, 'ja', 'siteauditor', 'Duplicate Title', '重複タイトル', '2016-12-12 04:56:08'),
(5183, 'ja', 'siteauditor', 'Exclude links', 'リンクを除外', '2016-12-12 04:56:08'),
(5184, 'ja', 'siteauditor', 'Execute with cron', 'クーロンで実行', '2016-12-12 04:56:08'),
(5185, 'ja', 'siteauditor', 'External', '外部', '2016-12-12 04:56:08'),
(5186, 'ja', 'siteauditor', 'External Links', '外部リンク', '2016-12-12 04:56:08'),
(5187, 'ja', 'siteauditor', 'Import Project Links', 'プロジェクトリンクのインポート', '2016-12-12 04:56:08'),
(5188, 'ja', 'siteauditor', 'Insert links separated with comma', 'リンクをカンマ区切りで挿入', '2016-12-12 04:56:08'),
(5189, 'ja', 'siteauditor', 'insertlinkssepcoma', '無限リンクをレポートから除外するには、カンマ区切りでリンクを挿入', '2016-12-12 04:56:08'),
(5190, 'ja', 'siteauditor', 'Link Reports', 'リンクレポート', '2016-12-12 04:56:08'),
(5191, 'ja', 'siteauditor', 'Link Title', 'リンクタイトル', '2016-12-12 04:56:08'),
(5192, 'ja', 'siteauditor', 'Maximum number of pages to be checked', 'チェックされるページの最大数', '2016-12-12 04:56:08'),
(5193, 'ja', 'siteauditor', 'Maximum Pages', '最大ページ数', '2016-12-12 04:56:08'),
(5194, 'ja', 'siteauditor', 'No active projects found', 'アクティブなプロジェクトはありません', '2016-12-12 04:56:08'),
(5195, 'ja', 'siteauditor', 'Nofollow', 'ノーフォロー', '2016-12-12 04:56:08'),
(5196, 'ja', 'siteauditor', 'Number of pages is greater than', 'ページ数が次を超えています：', '2016-12-12 04:56:08'),
(5197, 'ja', 'siteauditor', 'Number of pages should be greater than', 'ページ数が次を満たしていません：', '2016-12-12 04:56:08'),
(5198, 'ja', 'siteauditor', 'Page Details', 'ページ詳細', '2016-12-12 04:56:08'),
(5199, 'ja', 'siteauditor', 'Page Link', 'ページリンク', '2016-12-12 04:56:08'),
(5200, 'ja', 'siteauditor', 'Page Links', 'ページリンク', '2016-12-12 04:56:08'),
(5201, 'ja', 'siteauditor', 'Pages Found', '検出ページ', '2016-12-12 04:56:08'),
(5202, 'ja', 'siteauditor', 'pressescapetostopexecution', 'スクリプトの実行を停止するには<b>エスケープ</b>キーを押して下さい', '2016-12-12 04:56:08'),
(5203, 'ja', 'siteauditor', 'Project Summary', 'プロジェクトサマリ', '2016-12-12 04:56:08'),
(5204, 'ja', 'siteauditor', 'Project Url', 'プロジェクトURL', '2016-12-12 04:56:08'),
(5205, 'ja', 'siteauditor', 'projectalreadyexist', 'このウェブサイトのプロジェクトは既に存在します', '2016-12-12 04:56:08'),
(5206, 'ja', 'siteauditor', 'Recheck Pages', 'ページの再チェック', '2016-12-12 04:56:08'),
(5207, 'ja', 'siteauditor', 'Report Summary', 'レポートサマリ', '2016-12-12 04:56:08'),
(5208, 'ja', 'siteauditor', 'Run Project', 'プロジェクトの実行', '2016-12-12 04:56:08'),
(5209, 'ja', 'siteauditor', 'should start with', '次で始まるべきです：', '2016-12-12 04:56:08'),
(5210, 'ja', 'siteauditor', 'Site Auditor Settings', 'サイト監査設定', '2016-12-12 04:56:08'),
(5211, 'ja', 'siteauditor', 'Store all links found in a page', 'ページで検出されたリンクをすべて保存する', '2016-12-12 04:56:08'),
(5212, 'ja', 'siteauditor', 'The page description length is not between', 'ページディスクリプションの長さが次に当てはまりません：', '2016-12-12 04:56:08'),
(5213, 'ja', 'siteauditor', 'The page is brocken', 'ページは破損しています', '2016-12-12 04:56:08'),
(5214, 'ja', 'siteauditor', 'The page is having exellent number of backlinks in', 'ページのバックリンク数は極めて優秀です', '2016-12-12 04:56:08'),
(5215, 'ja', 'siteauditor', 'The page is having exellent pagerank', 'ページのページランクは極めて優秀です', '2016-12-12 04:56:08'),
(5216, 'ja', 'siteauditor', 'The page is having good number of backlinks in', 'ページのバックリンク数は良好です', '2016-12-12 04:56:08'),
(5217, 'ja', 'siteauditor', 'The page is having good pagerank', 'ページのページランクは良好です', '2016-12-12 04:56:08'),
(5218, 'ja', 'siteauditor', 'The page is having poor pagerank', 'ページのページランクは悪いです', '2016-12-12 04:56:08'),
(5219, 'ja', 'siteauditor', 'The page is having very good pagerank', 'ページのページランクはとても良いです', '2016-12-12 04:56:08'),
(5220, 'ja', 'siteauditor', 'The page is not having backlinks in', 'ページにはバックリンクがありません', '2016-12-12 04:56:08'),
(5221, 'ja', 'siteauditor', 'The page is not indexed in', 'ページはインデックスされていません', '2016-12-12 04:56:08'),
(5222, 'ja', 'siteauditor', 'The page keywords length is not between', 'ページキーワードの長さが次に当てはまりません：', '2016-12-12 04:56:08'),
(5223, 'ja', 'siteauditor', 'The page title length is not between', 'ページタイトルの長さが次に当てはまりません：', '2016-12-12 04:56:08'),
(5224, 'ja', 'siteauditor', 'The total number of links in page is greater than', 'ページ内のリンク合計数が次を超過しています：', '2016-12-12 04:56:08'),
(5225, 'ja', 'siteauditor', 'to run project again if you stopped execution', '実行を停止した場合に再度プロジェクトを実行するには', '2016-12-12 04:56:08'),
(5226, 'ja', 'siteauditor', 'to view the reports', 'レポートを見るには', '2016-12-12 04:56:08'),
(5227, 'ja', 'siteauditor', 'Total Links', '合計リンク数', '2016-12-12 04:56:08'),
(5228, 'ja', 'siteauditor', 'totallinksgreaterallowed', '合計リンク数が、プロジェクトに許可された合計リンク数を超過します', '2016-12-12 04:56:08'),
(5229, 'ru', 'siteauditor', 'Anchor', 'Якорь', '2017-07-13 16:51:34'),
(5230, 'ru', 'siteauditor', 'anylinkcontainabovelinks', 'Все ссылки уже присутствующие в проекте, будут исключены из отчетов', '2017-07-13 16:51:34'),
(5231, 'ru', 'siteauditor', 'anylinkcontainexcludesitemap', 'Все ссылки содержащие ссылки выше, будут исключены из карты сайта', '2017-07-13 16:51:34'),
(5232, 'ru', 'siteauditor', 'Check backlinks of pages', 'Проверка обратных ссылок страниц', '2017-07-13 16:51:34'),
(5233, 'ru', 'siteauditor', 'Check broken links in a page', 'Проверить нерабочие ссылки на страницы', '2017-07-13 16:51:34'),
(5234, 'ru', 'siteauditor', 'Check google pagerank of pages', 'Проверка Google PageRank страниц', '2017-07-13 16:51:34'),
(5235, 'ru', 'siteauditor', 'Check pages indexed or not', 'Проверка индексации страниц', '2017-07-13 16:51:34'),
(5236, 'ru', 'siteauditor', 'Check Score', 'Проверка оценки', '2017-07-13 16:51:34'),
(5237, 'ru', 'siteauditor', 'checkborckenlinkwait', 'Проверка битых ссылок, увеличит время выполнения проекта', '2017-07-13 16:51:34'),
(5238, 'ru', 'siteauditor', 'Completed project execution', 'Завершено выполненных проектов', '2017-07-13 16:51:34'),
(5239, 'ru', 'siteauditor', 'Crawled', 'Сканирование', '2017-07-13 16:51:34'),
(5240, 'ru', 'siteauditor', 'Crawled Pages', 'Просканированных страниц', '2017-07-13 16:51:34'),
(5241, 'ru', 'siteauditor', 'crawledsuccesssfullywaitfornext', 'сканирование выполнено успешно! Ожидание сканирования следующей страницы', '2017-07-13 16:51:34'),
(5242, 'ru', 'siteauditor', 'Crawling Page', 'Сканирование страницы', '2017-07-13 16:51:34'),
(5243, 'ru', 'siteauditor', 'Duplicate Description', 'Дубликат описания', '2017-07-13 16:51:34'),
(5244, 'ru', 'siteauditor', 'Duplicate Keywords', 'Повторяющиеся ключевые слова', '2017-07-13 16:51:34'),
(5245, 'ru', 'siteauditor', 'Duplicate Title', 'Дубликат заголовка', '2017-07-13 16:51:34'),
(5246, 'ru', 'siteauditor', 'Exclude links', 'Исключить ссылки', '2017-07-13 16:51:34'),
(5247, 'ru', 'siteauditor', 'Execute with cron', 'Выполнить cron', '2017-07-13 16:51:34'),
(5248, 'ru', 'siteauditor', 'External', 'Внешний', '2017-07-13 16:51:34'),
(5249, 'ru', 'siteauditor', 'External Links', 'Внешние ссылки', '2017-07-13 16:51:34'),
(5250, 'ru', 'siteauditor', 'Import Project Links', 'Импорт ссылки проекта', '2017-07-13 16:51:34'),
(5251, 'ru', 'siteauditor', 'Insert links separated with comma', 'Вставьте ссылки, разделенные запятыми', '2017-07-13 16:51:34'),
(5252, 'ru', 'siteauditor', 'insertlinkssepcoma', 'Вставка ссылок через запятую, для исключения бесконечных ссылок в отчетах', '2017-07-13 16:51:34'),
(5253, 'ru', 'siteauditor', 'Link Reports', 'Отчеты по ссылкам', '2017-07-13 16:51:34'),
(5254, 'ru', 'siteauditor', 'Link Title', 'Заголовок ссылки', '2017-07-13 16:51:34'),
(5255, 'ru', 'siteauditor', 'Maximum number of pages to be checked', 'Максимальное количество страниц для проверки', '2017-07-13 16:51:34'),
(5256, 'ru', 'siteauditor', 'Maximum Pages', 'Максимум страниц', '2017-07-13 16:51:34'),
(5257, 'ru', 'siteauditor', 'No active projects found', 'Не активных проектов не найдено', '2017-07-13 16:51:34'),
(5258, 'ru', 'siteauditor', 'Nofollow', 'Не следует', '2017-07-13 16:51:34'),
(5259, 'ru', 'siteauditor', 'Number of pages is greater than', 'Количество страниц больше', '2017-07-13 16:51:34'),
(5260, 'ru', 'siteauditor', 'Number of pages should be greater than', 'Количество страниц должно быть более', '2017-07-13 16:51:34'),
(5261, 'ru', 'siteauditor', 'Page Details', 'Детали страниц', '2017-07-13 16:51:34'),
(5262, 'ru', 'siteauditor', 'Page Link', 'Ссылка страницы', '2017-07-13 16:51:34'),
(5263, 'ru', 'siteauditor', 'Page Links', 'Ссылки страниц', '2017-07-13 16:51:34'),
(5264, 'ru', 'siteauditor', 'Pages Found', 'Страница не существует', '2017-07-13 16:51:34'),
(5265, 'ru', 'siteauditor', 'pressescapetostopexecution', 'Нажмите <b>пробел</b> для остановки работы скрипта', '2017-07-13 16:51:34'),
(5266, 'ru', 'siteauditor', 'Project Summary', 'Краткое описание проекта', '2017-07-13 16:51:34'),
(5267, 'ru', 'siteauditor', 'Project Url', 'URL проекта', '2017-07-13 16:51:34'),
(5268, 'ru', 'siteauditor', 'projectalreadyexist', 'Проект данного сайта уже существуют', '2017-07-13 16:51:34'),
(5269, 'ru', 'siteauditor', 'Recheck Pages', 'Повторная проверка страниц', '2017-07-13 16:51:34'),
(5270, 'ru', 'siteauditor', 'Report Summary', 'Краткий отчет', '2017-07-13 16:51:34'),
(5271, 'ru', 'siteauditor', 'Run Project', 'Выполнить проект', '2017-07-13 16:51:34'),
(5272, 'ru', 'siteauditor', 'should start with', 'должна начинаться с', '2017-07-13 16:51:34'),
(5273, 'ru', 'siteauditor', 'Site Auditor Settings', 'Настройки аудитора сайта', '2017-07-13 16:51:34'),
(5274, 'ru', 'siteauditor', 'Store all links found in a page', 'Сохранять все ссылки, найденные на страницах', '2017-07-13 16:51:34'),
(5275, 'ru', 'siteauditor', 'The page description length is not between', 'Длина описания страниц не в пределах', '2017-07-13 16:51:34'),
(5276, 'ru', 'siteauditor', 'The page is brocken', 'Битые страницы', '2017-07-13 16:51:34'),
(5277, 'ru', 'siteauditor', 'The page is having exellent number of backlinks in', 'Страница с хорошим количеством обратных ссылок в', '2017-07-13 16:51:34'),
(5278, 'ru', 'siteauditor', 'The page is having exellent pagerank', 'Страницы с хорошим PageRank', '2017-07-13 16:51:34'),
(5279, 'ru', 'siteauditor', 'The page is having good number of backlinks in', 'Страницы, имеющие большое количество обратных ссылок на', '2017-07-13 16:51:34'),
(5280, 'ru', 'siteauditor', 'The page is having good pagerank', 'Страницы имеющие хороший PageRank', '2017-07-13 16:51:34'),
(5281, 'ru', 'siteauditor', 'The page is having poor pagerank', 'Страницы с низким PageRank', '2017-07-13 16:51:34'),
(5282, 'ru', 'siteauditor', 'The page is having very good pagerank', 'Страницы с очень высоким PageRank', '2017-07-13 16:51:34'),
(5283, 'ru', 'siteauditor', 'The page is not having backlinks in', 'Страницы не имеющие обратных ссылок на', '2017-07-13 16:51:34'),
(5284, 'ru', 'siteauditor', 'The page is not indexed in', 'Не проиндексированные страницы в', '2017-07-13 16:51:34'),
(5285, 'ru', 'siteauditor', 'The page keywords length is not between', 'Длина страницы ключевых слов не между', '2017-07-13 16:51:34'),
(5286, 'ru', 'siteauditor', 'The page title length is not between', 'Длина заголовка страницы не между', '2017-07-13 16:51:34'),
(5287, 'ru', 'siteauditor', 'The total number of links in page is greater than', 'Общее количество ссылок на странице больше', '2017-07-13 16:51:34'),
(5288, 'ru', 'siteauditor', 'to run project again if you stopped execution', 'запустить проект снова, если вы остановили выполнение', '2017-07-13 16:51:34'),
(5289, 'ru', 'siteauditor', 'to view the reports', 'Для просмотра отчетов', '2017-07-13 16:51:34'),
(5290, 'ru', 'siteauditor', 'Total Links', 'Всего ссылок', '2017-07-13 16:51:34'),
(5291, 'ru', 'siteauditor', 'totallinksgreaterallowed', 'Количество ссылок станет больше максимально разрешенных ссылок для одного проекта', '2017-07-13 16:51:34'),
(5292, 'nl', 'home', 'Indexed', 'Geïndexeerd', '2011-07-05 21:52:28'),
(5293, 'nl', 'keyword', 'Insert keywords separated with comma', 'Voeg zoekwoorden toe net komma gescheiden ', '2011-07-05 21:54:33'),
(5294, 'nl', 'label', 'Brocken', 'Kapot', '2014-01-07 21:37:43'),
(5295, 'nl', 'label', 'Comments', 'Commentaar', '2014-01-07 21:37:43'),
(5296, 'nl', 'label', 'Count', 'Aantal', '2014-01-07 21:37:43'),
(5297, 'nl', 'label', 'Exclude', 'Uitsluiten', '2014-01-07 21:37:43'),
(5298, 'nl', 'label', 'Include', 'Insluiten', '2014-01-07 21:37:43'),
(5299, 'nl', 'label', 'Project', 'Project', '2014-01-07 21:37:43'),
(5300, 'nl', 'label', 'Report Type', 'Rapport type', '2014-01-07 21:37:43'),
(5301, 'nl', 'label', 'Score', 'Score', '2014-01-07 21:37:43'),
(5302, 'nl', 'label', 'Total Results', 'Totaal resultaten', '2014-01-07 21:37:43'),
(5303, 'nl', 'label', 'Updated', 'Ge-update', '2014-01-07 21:37:43'),
(5304, 'nl', 'label', 'View Reports', 'Bekijk rapporten', '2014-01-07 21:37:43'),
(5305, 'nl', 'panel', 'Edit Project', 'Bewerk project', '2014-01-07 21:46:33'),
(5306, 'nl', 'panel', 'New Project', 'Nieuw project', '2014-01-07 21:46:33'),
(5307, 'nl', 'seotools', 'Auditor Projects', 'Auditor Projecten', '2011-07-05 22:20:43'),
(5308, 'nl', 'seotools', 'Auditor Reports', 'Auditor Rapporten ', '2011-07-05 22:20:43'),
(5309, 'nl', 'seotools', 'Auditor Settings', 'Auditor Instellingen', '2011-07-05 22:20:43'),
(5310, 'nl', 'seotools', 'Import Project Links', 'Importeer Project Links', '2011-07-05 22:20:43'),
(5311, 'nl', 'seotools', 'site-auditor', 'Site Auditor', '2011-07-05 22:20:43'),
(5312, 'nl', 'settings', 'Check for Updates', 'Controleer voor updates', '2014-01-07 21:51:05'),
(5313, 'nl', 'settings', 'SA_CRAWL_DELAY_TIME', 'Site auditor pauze tussen pagina''s', '2014-01-07 21:51:05'),
(5314, 'nl', 'settings', 'SA_MAX_NO_PAGES', 'Maximum aantal pagina''s toegestaan per website', '2014-01-07 21:51:05'),
(5315, 'nl', 'settings', 'versionnotuptodatemsg', 'Uw Seo Panel installatie is niet up to date. <br>Download a.u.b. de nieuwste versie', '2014-01-07 21:51:05'),
(5316, 'nl', 'settings', 'Your Seo Panel installation is up to date', 'Uw Seo Panel installatie is up to date.', '2014-01-07 21:51:05'),
(5317, 'nl', 'siteauditor', 'Anchor', 'Anker', '2011-07-13 09:45:04'),
(5318, 'nl', 'siteauditor', 'anylinkcontainabovelinks', 'Alle links hierboven worden uitgesloten in de rapporten ', '2011-07-13 09:45:04'),
(5319, 'nl', 'siteauditor', 'anylinkcontainexcludesitemap', 'Alle links hierboven worden uitgesloten in de sitemap', '2011-07-13 09:45:04'),
(5320, 'nl', 'siteauditor', 'Check backlinks of pages', 'Controleer backlinks van de pagina\\''s', '2011-07-13 09:45:04'),
(5321, 'nl', 'siteauditor', 'Check broken links in a page', 'Controleer defecte links in een pagina', '2011-07-13 09:45:04'),
(5322, 'nl', 'siteauditor', 'Check google pagerank of pages', 'Controleer google pagerank van de pagina\\''s', '2011-07-13 09:45:04'),
(5323, 'nl', 'siteauditor', 'Check pages indexed or not', 'Controleer of de pagina\\''s geïndexeerd zijn', '2011-07-13 09:45:04'),
(5324, 'nl', 'siteauditor', 'Check Score', 'Controleer score', '2011-07-13 09:45:04'),
(5325, 'nl', 'siteauditor', 'checkborckenlinkwait', 'Controleer defecte links zal de tijd van de uitvoering vergroten van een project.', '2011-07-13 09:45:04'),
(5326, 'nl', 'siteauditor', 'Completed project execution', 'Voltooide project uitvoering', '2011-07-13 09:45:04'),
(5327, 'nl', 'siteauditor', 'Crawled', 'Onderzocht', '2011-07-13 09:45:04'),
(5328, 'nl', 'siteauditor', 'Crawled Pages', 'Onderzochte pagina\\''s', '2011-07-13 09:45:04'),
(5329, 'nl', 'siteauditor', 'crawledsuccesssfullywaitfornext', 'succesvol Onderzocht! Wacht voor het onderzoeken van de volgende pagina voor', '2011-07-13 09:45:04'),
(5330, 'nl', 'siteauditor', 'Crawling Page', 'Pagina aan het onderzoeken', '2011-07-13 09:45:04'),
(5331, 'nl', 'siteauditor', 'Duplicate Description', 'Dubbele omschrijving', '2011-07-13 09:45:04'),
(5332, 'nl', 'siteauditor', 'Duplicate Keywords', 'Dubbele zoekwoorden', '2011-07-13 09:45:04'),
(5333, 'nl', 'siteauditor', 'Duplicate Title', 'Dubbele titel', '2011-07-13 09:45:04'),
(5334, 'nl', 'siteauditor', 'Exclude links', 'Links uitsluiten', '2011-07-13 09:45:04'),
(5335, 'nl', 'siteauditor', 'Execute with cron', 'Voer uit met cron', '2011-07-13 09:45:04'),
(5336, 'nl', 'siteauditor', 'External', 'Extern', '2011-07-13 09:45:04'),
(5337, 'nl', 'siteauditor', 'External Links', 'Externe links', '2011-07-13 09:45:04'),
(5338, 'nl', 'siteauditor', 'Import Project Links', 'Importeer project links', '2011-07-13 09:45:04'),
(5339, 'nl', 'siteauditor', 'Insert links separated with comma', 'Voeg link toe, komma gescheiden', '2011-07-13 09:45:04'),
(5340, 'nl', 'siteauditor', 'insertlinkssepcoma', 'Voeg komma gescheiden links toe om oneindige links in rapporten uit te sluiten', '2011-07-13 09:45:04'),
(5341, 'nl', 'siteauditor', 'Link Reports', 'Link rapporten', '2011-07-13 09:45:04'),
(5342, 'nl', 'siteauditor', 'Link Title', 'Link titel', '2011-07-13 09:45:04'),
(5343, 'nl', 'siteauditor', 'Maximum number of pages to be checked', 'Maximaal aantal te controleren pagina\\''s', '2011-07-13 09:45:04'),
(5344, 'nl', 'siteauditor', 'Maximum Pages', 'Maximale pagina\\''s ', '2011-07-13 09:45:04'),
(5345, 'nl', 'siteauditor', 'No active projects found', 'Geen actieve projecten gevonden', '2011-07-13 09:45:04'),
(5346, 'nl', 'siteauditor', 'Nofollow', 'Niet volgen', '2011-07-13 09:45:04'),
(5347, 'nl', 'siteauditor', 'Number of pages is greater than', 'Aantal pagina\\''s is groter dan', '2011-07-13 09:45:04'),
(5348, 'nl', 'siteauditor', 'Number of pages should be greater than', 'Aantal pagina\\''s dient groter te zijn dan', '2011-07-13 09:45:04'),
(5349, 'nl', 'siteauditor', 'Page Details', 'Pagina details', '2011-07-13 09:45:04'),
(5350, 'nl', 'siteauditor', 'Page Link', 'Pagina link', '2011-07-13 09:45:04'),
(5351, 'nl', 'siteauditor', 'Page Links', 'Pagina links', '2011-07-13 09:45:04'),
(5352, 'nl', 'siteauditor', 'Pages Found', 'Gevonden pagina\\''s', '2011-07-13 09:45:04'),
(5353, 'nl', 'siteauditor', 'pressescapetostopexecution', 'Druk op <b>escape</b> om de uitvoering te stoppen.', '2011-07-13 09:45:04'),
(5354, 'nl', 'siteauditor', 'Project Summary', 'Project overzicht', '2011-07-13 09:45:04'),
(5355, 'nl', 'siteauditor', 'Project Url', 'Project Url', '2011-07-13 09:45:04'),
(5356, 'nl', 'siteauditor', 'projectalreadyexist', 'Project voor deze website bestaat al', '2011-07-13 09:45:04'),
(5357, 'nl', 'siteauditor', 'Recheck Pages', 'Controleer pagina\\''s opnieuw', '2011-07-13 09:45:04'),
(5358, 'nl', 'siteauditor', 'Report Summary', 'Rapport overzicht', '2011-07-13 09:45:04'),
(5359, 'nl', 'siteauditor', 'Run Project', 'Voer project uit', '2011-07-13 09:45:04'),
(5360, 'nl', 'siteauditor', 'should start with', 'moet beginnen met', '2011-07-13 09:45:04'),
(5361, 'nl', 'siteauditor', 'Site Auditor Settings', 'Site auditor instellingen', '2011-07-13 09:45:04'),
(5362, 'nl', 'siteauditor', 'Store all links found in a page', 'Sla alle links op in een pagina', '2011-07-13 09:45:04'),
(5363, 'nl', 'siteauditor', 'The page description length is not between', 'De pagina omschrijving lengte is niet tussen', '2011-07-13 09:45:04'),
(5364, 'nl', 'siteauditor', 'The page is brocken', 'De pagina is defect', '2011-07-13 09:45:04'),
(5365, 'nl', 'siteauditor', 'The page is having exellent number of backlinks in', 'De pagina heeft een perfecte hoeveelheid backlinks', '2011-07-13 09:45:04'),
(5366, 'nl', 'siteauditor', 'The page is having exellent pagerank', 'De pagina heeft een perfecte pagerank', '2011-07-13 09:45:04'),
(5367, 'nl', 'siteauditor', 'The page is having good number of backlinks in', 'De pagina heeft een goede hoeveelheid backlinks', '2011-07-13 09:45:04'),
(5368, 'nl', 'siteauditor', 'The page is having good pagerank', 'De pagina heeft een goede pagerank', '2011-07-13 09:45:04'),
(5369, 'nl', 'siteauditor', 'The page is having poor pagerank', 'De pagina heeft een matige hoeveelheid backlinks', '2011-07-13 09:45:04'),
(5370, 'nl', 'siteauditor', 'The page is having very good pagerank', 'De pagina heeft een erg goede pagerank', '2011-07-13 09:45:04'),
(5371, 'nl', 'siteauditor', 'The page is not having backlinks in', 'De pagina heeft een geen backlinks in', '2011-07-13 09:45:04'),
(5372, 'nl', 'siteauditor', 'The page is not indexed in', 'De pagina is niet geïndexeerd in', '2011-07-13 09:45:04'),
(5373, 'nl', 'siteauditor', 'The page keywords length is not between', 'De pagina zoekwoorden lengte is niet tussen', '2011-07-13 09:45:04'),
(5374, 'nl', 'siteauditor', 'The page title length is not between', 'De pagina titel lengte is niet tussen', '2011-07-13 09:45:04'),
(5375, 'nl', 'siteauditor', 'The total number of links in page is greater than', 'Het totaal aantal links op de pagina is groter dan', '2011-07-13 09:45:04'),
(5376, 'nl', 'siteauditor', 'to run project again if you stopped execution', 'om het project uit te voeren als u de uitvoering heeft gestopt', '2011-07-13 09:45:04'),
(5377, 'nl', 'siteauditor', 'to view the reports', 'om rapporten te bekijken', '2011-07-13 09:45:04'),
(5378, 'nl', 'siteauditor', 'Total Links', 'Totaal aantal links', '2011-07-13 09:45:04'),
(5379, 'nl', 'siteauditor', 'totallinksgreaterallowed', 'Totaal aantal links wordt groter dan de maximaal aantal links toegestaan voor het project', '2011-07-13 09:45:04'),
(5380, 'zh', 'home', 'Indexed', '索引', '2011-07-06 06:02:25'),
(5381, 'zh', 'keyword', 'Insert keywords separated with comma', '插入关键词(可逗号分隔多个)', '2011-07-06 06:03:07'),
(5382, 'zh', 'label', 'Brocken', '损坏', '2014-05-15 17:47:51'),
(5383, 'zh', 'label', 'Comments', '评论', '2014-05-15 17:47:51'),
(5384, 'zh', 'label', 'Count', '数量', '2014-05-15 17:47:51'),
(5385, 'zh', 'label', 'Exclude', '除去', '2014-05-15 17:47:51'),
(5386, 'zh', 'label', 'Include', '包括', '2014-05-15 17:47:51'),
(5387, 'zh', 'label', 'Project', '项目', '2014-05-15 17:47:51'),
(5388, 'zh', 'label', 'Report Type', '报告类型', '2014-05-15 17:47:51'),
(5389, 'zh', 'label', 'Score', '得分', '2014-05-15 17:47:51'),
(5390, 'zh', 'label', 'Total Results', '总结果', '2014-05-15 17:47:51'),
(5391, 'zh', 'label', 'Updated', '更新', '2014-05-15 17:47:51'),
(5392, 'zh', 'label', 'View Reports', '查看报告', '2014-05-15 17:47:51'),
(5393, 'zh', 'panel', 'Edit Project', '编辑项目', '2014-05-15 17:48:57'),
(5394, 'zh', 'panel', 'New Project', '新的项目', '2014-05-15 17:48:57'),
(5395, 'zh', 'seotools', 'Auditor Projects', '审计项目', '2011-07-06 06:05:37'),
(5396, 'zh', 'seotools', 'Auditor Reports', '审计报告', '2011-07-06 06:05:37'),
(5397, 'zh', 'seotools', 'Auditor Settings', '审计设置', '2011-07-06 06:05:37'),
(5398, 'zh', 'seotools', 'Import Project Links', '导入项目链接', '2011-07-06 06:05:37'),
(5399, 'zh', 'seotools', 'site-auditor', '站点审计器', '2011-07-06 06:05:37'),
(5400, 'zh', 'settings', 'Check for Updates', '检测更新', '2014-05-15 17:56:30'),
(5401, 'zh', 'settings', 'SA_CRAWL_DELAY_TIME', '站点审计器停留抓取每张网页', '2014-05-15 17:56:30'),
(5402, 'zh', 'settings', 'SA_MAX_NO_PAGES', '每个站点最大数量页面', '2014-05-15 17:56:30'),
(5403, 'zh', 'settings', 'versionnotuptodatemsg', '你的Seo Panel安装没有更新. <br>请下载新版本', '2014-05-15 17:56:30'),
(5404, 'zh', 'settings', 'Your Seo Panel installation is up to date', '你的Seo Panel安装没有更新.', '2014-05-15 17:56:30'),
(5405, 'zh', 'siteauditor', 'Anchor', '锚标记', '2011-07-06 06:45:08'),
(5406, 'zh', 'siteauditor', 'anylinkcontainabovelinks', '以上的链接均会被在报告中排除', '2011-07-06 06:45:08'),
(5407, 'zh', 'siteauditor', 'anylinkcontainexcludesitemap', '以上的链接均会被在站点地图中排除', '2011-07-06 06:45:08'),
(5408, 'zh', 'siteauditor', 'Check backlinks of pages', '检查页面的外部链接', '2011-07-06 06:45:08'),
(5409, 'zh', 'siteauditor', 'Check broken links in a page', '检查页面的错误连接', '2011-07-06 06:45:08'),
(5410, 'zh', 'siteauditor', 'Check google pagerank of pages', '检查页面的PR', '2011-07-06 06:45:08'),
(5411, 'zh', 'siteauditor', 'Check pages indexed or not', '检测页面索引状态', '2011-07-06 06:45:08'),
(5412, 'zh', 'siteauditor', 'Check Score', '检测得分', '2011-07-06 06:45:08'),
(5413, 'zh', 'siteauditor', 'checkborckenlinkwait', '检测页面的错误链接将增加一个项目的执行时间', '2011-07-06 06:45:08'),
(5414, 'zh', 'siteauditor', 'Completed project execution', '完成项目执行', '2011-07-06 06:45:08'),
(5415, 'zh', 'siteauditor', 'Crawled', '被抓取', '2011-07-06 06:45:08'),
(5416, 'zh', 'siteauditor', 'Crawled Pages', '被抓取的页面', '2011-07-06 06:45:08'),
(5417, 'zh', 'siteauditor', 'crawledsuccesssfullywaitfornext', '抓取成功！等待抓取下一页面', '2011-07-06 06:45:08'),
(5418, 'zh', 'siteauditor', 'Crawling Page', '抓取页面', '2011-07-06 06:45:08'),
(5419, 'zh', 'siteauditor', 'Duplicate Description', '重复的描述', '2011-07-06 06:45:08'),
(5420, 'zh', 'siteauditor', 'Duplicate Keywords', '重复的关键词', '2011-07-06 06:45:08'),
(5421, 'zh', 'siteauditor', 'Duplicate Title', '重复的标题', '2011-07-06 06:45:08'),
(5422, 'zh', 'siteauditor', 'Exclude links', '排除连接', '2011-07-06 06:45:08'),
(5423, 'zh', 'siteauditor', 'Execute with cron', 'Cron任务执行', '2011-07-06 06:45:08'),
(5424, 'zh', 'siteauditor', 'External', '外部的', '2011-07-06 06:45:08'),
(5425, 'zh', 'siteauditor', 'External Links', '外部的链接', '2011-07-06 06:45:08'),
(5426, 'zh', 'siteauditor', 'Import Project Links', '导入项目链接', '2011-07-06 06:45:08'),
(5427, 'zh', 'siteauditor', 'Insert links separated with comma', '插入链接（可逗号分隔多个链接）', '2011-07-06 06:45:08'),
(5428, 'zh', 'siteauditor', 'insertlinkssepcoma', '插入需要从报告中排除的链接', '2011-07-06 06:45:08'),
(5429, 'zh', 'siteauditor', 'Link Reports', '链接报告', '2011-07-06 06:45:08'),
(5430, 'zh', 'siteauditor', 'Link Title', '链接标题', '2011-07-06 06:45:08'),
(5431, 'zh', 'siteauditor', 'Maximum number of pages to be checked', '最大检测页面数量', '2011-07-06 06:45:08'),
(5432, 'zh', 'siteauditor', 'Maximum Pages', '最大数量页面', '2011-07-06 06:45:08'),
(5433, 'zh', 'siteauditor', 'No active projects found', '没有被激活的项目被发现', '2011-07-06 06:45:08'),
(5434, 'zh', 'siteauditor', 'Nofollow', 'Nofollow', '2011-07-06 06:45:08'),
(5435, 'zh', 'siteauditor', 'Number of pages is greater than', '页面数量更好优于', '2011-07-06 06:45:08'),
(5436, 'zh', 'siteauditor', 'Number of pages should be greater than', '页面数量应该更好优于', '2011-07-06 06:45:08'),
(5437, 'zh', 'siteauditor', 'Page Details', '页面详情', '2011-07-06 06:45:08'),
(5438, 'zh', 'siteauditor', 'Page Link', '页面链接', '2011-07-06 06:45:08'),
(5439, 'zh', 'siteauditor', 'Page Links', '页面链接', '2011-07-06 06:45:08'),
(5440, 'zh', 'siteauditor', 'Pages Found', '页面发现', '2011-07-06 06:45:08'),
(5441, 'zh', 'siteauditor', 'pressescapetostopexecution', '按ESC键来停止脚本执行', '2011-07-06 06:45:08'),
(5442, 'zh', 'siteauditor', 'Project Summary', '项目总汇', '2011-07-06 06:45:08'),
(5443, 'zh', 'siteauditor', 'Project Url', '项目URL', '2011-07-06 06:45:08'),
(5444, 'zh', 'siteauditor', 'projectalreadyexist', '该网站的项目已经存在', '2011-07-06 06:45:08'),
(5445, 'zh', 'siteauditor', 'Recheck Pages', '重新检测页面', '2011-07-06 06:45:08'),
(5446, 'zh', 'siteauditor', 'Report Summary', '报告总汇', '2011-07-06 06:45:08'),
(5447, 'zh', 'siteauditor', 'Run Project', '运行项目', '2011-07-06 06:45:08'),
(5448, 'zh', 'siteauditor', 'should start with', '应该开始于', '2011-07-06 06:45:08'),
(5449, 'zh', 'siteauditor', 'Site Auditor Settings', '站点审计设置', '2011-07-06 06:45:08'),
(5450, 'zh', 'siteauditor', 'Store all links found in a page', '存储页面的所有链接', '2011-07-06 06:45:08'),
(5451, 'zh', 'siteauditor', 'The page description length is not between', '该页面的描述长度没有位于', '2011-07-06 06:45:08'),
(5452, 'zh', 'siteauditor', 'The page is brocken', '该页面已经损坏', '2011-07-06 06:45:08'),
(5453, 'zh', 'siteauditor', 'The page is having exellent number of backlinks in', '该页面拥有高质量的数量反链在', '2011-07-06 06:45:08'),
(5454, 'zh', 'siteauditor', 'The page is having exellent pagerank', '该页面拥有高质量的PR', '2011-07-06 06:45:08'),
(5455, 'zh', 'siteauditor', 'The page is having good number of backlinks in', '该页面拥有不错的反链在', '2011-07-06 06:45:08'),
(5456, 'zh', 'siteauditor', 'The page is having good pagerank', '该页面拥有较好的PR', '2011-07-06 06:45:08'),
(5457, 'zh', 'siteauditor', 'The page is having poor pagerank', '该页面拥有较差的PR', '2011-07-06 06:45:08'),
(5458, 'zh', 'siteauditor', 'The page is having very good pagerank', '该页面拥有非常不错的PR', '2011-07-06 06:45:08'),
(5459, 'zh', 'siteauditor', 'The page is not having backlinks in', '该页面没有拥有反链在', '2011-07-06 06:45:08'),
(5460, 'zh', 'siteauditor', 'The page is not indexed in', '该页面没有被索引在', '2011-07-06 06:45:08'),
(5461, 'zh', 'siteauditor', 'The page keywords length is not between', '该页面的关键词长度没有位于', '2011-07-06 06:45:08'),
(5462, 'zh', 'siteauditor', 'The page title length is not between', '该页面的标题长度没有位于', '2011-07-06 06:45:08'),
(5463, 'zh', 'siteauditor', 'The total number of links in page is greater than', '所有页面链接数量优于', '2011-07-06 06:45:08'),
(5464, 'zh', 'siteauditor', 'to run project again if you stopped execution', '如果你停止项目，请重新运行项目', '2011-07-06 06:45:08'),
(5465, 'zh', 'siteauditor', 'to view the reports', '浏览报告', '2011-07-06 06:45:08'),
(5466, 'zh', 'siteauditor', 'Total Links', '全部链接', '2011-07-06 06:45:08'),
(5467, 'zh', 'siteauditor', 'totallinksgreaterallowed', '全部链接将优于可允许的项目最大链接', '2011-07-06 06:45:08'),
(5468, 'cn', 'home', 'Indexed', '索引', '2011-07-06 06:47:27'),
(5469, 'cn', 'keyword', 'Insert keywords separated with comma', '插入關鍵詞(可逗號分隔多個)', '2011-07-06 06:50:02'),
(5470, 'cn', 'label', 'Brocken', '損壞', '2014-01-09 15:35:37'),
(5471, 'cn', 'label', 'Comments', '評論', '2014-01-09 15:35:37'),
(5472, 'cn', 'label', 'Count', '數量', '2014-01-09 15:35:37'),
(5473, 'cn', 'label', 'Exclude', '排除', '2014-01-09 15:35:37'),
(5474, 'cn', 'label', 'Include', '包括', '2014-01-09 15:35:37'),
(5475, 'cn', 'label', 'Project', '項目', '2014-01-09 15:35:37'),
(5476, 'cn', 'label', 'Report Type', '報告類型', '2014-01-09 15:35:37'),
(5477, 'cn', 'label', 'Score', '得分', '2014-01-09 15:35:37'),
(5478, 'cn', 'label', 'Total Results', '總結果', '2014-01-09 15:35:37'),
(5479, 'cn', 'label', 'Updated', '更新', '2014-01-09 15:35:37'),
(5480, 'cn', 'label', 'View Reports', '查看報告', '2014-01-09 15:35:37'),
(5481, 'cn', 'panel', 'Edit Project', '編輯項目', '2014-01-09 15:37:31'),
(5482, 'cn', 'panel', 'New Project', '新的項目', '2014-01-09 15:37:31'),
(5483, 'cn', 'seotools', 'Auditor Projects', '審計項目', '2011-07-06 06:55:41'),
(5484, 'cn', 'seotools', 'Auditor Reports', '審計報告', '2011-07-06 06:55:41'),
(5485, 'cn', 'seotools', 'Auditor Settings', '審計設置', '2011-07-06 06:55:41'),
(5486, 'cn', 'seotools', 'Import Project Links', '導入項目鏈接', '2011-07-06 06:55:41'),
(5487, 'cn', 'seotools', 'site-auditor', '站點審計器', '2011-07-06 06:55:41'),
(5488, 'cn', 'settings', 'Check for Updates', '檢測更新', '2014-01-09 16:04:14'),
(5489, 'cn', 'settings', 'SA_CRAWL_DELAY_TIME', '站點審計器停留抓取每張網頁', '2014-01-09 16:04:14'),
(5490, 'cn', 'settings', 'SA_MAX_NO_PAGES', '每個站點最大數量頁面', '2014-01-09 16:04:14'),
(5491, 'cn', 'settings', 'versionnotuptodatemsg', '你的Seo Panel安裝沒有更新. <br>請下載新版本', '2014-01-09 16:04:14'),
(5492, 'cn', 'settings', 'Your Seo Panel installation is up to date', '你的Seo Panel安裝沒有更新.', '2014-01-09 16:04:14'),
(5493, 'cn', 'siteauditor', 'Anchor', '錨標記', '2011-07-06 07:09:13'),
(5494, 'cn', 'siteauditor', 'anylinkcontainabovelinks', '以上的鏈接均會被在報告中排除', '2011-07-06 07:09:13'),
(5495, 'cn', 'siteauditor', 'anylinkcontainexcludesitemap', '以上的鏈接均會被在站點地圖中排除', '2011-07-06 07:09:13'),
(5496, 'cn', 'siteauditor', 'Check backlinks of pages', '檢查頁面的外部鏈接', '2011-07-06 07:09:13'),
(5497, 'cn', 'siteauditor', 'Check broken links in a page', '檢查頁面的錯誤連接', '2011-07-06 07:09:13'),
(5498, 'cn', 'siteauditor', 'Check google pagerank of pages', '檢查頁面的PR', '2011-07-06 07:09:13'),
(5499, 'cn', 'siteauditor', 'Check pages indexed or not', '檢測頁面索引狀態', '2011-07-06 07:09:13'),
(5500, 'cn', 'siteauditor', 'Check Score', '檢測得分', '2011-07-06 07:09:13'),
(5501, 'cn', 'siteauditor', 'checkborckenlinkwait', '檢測頁面的錯誤鏈接將增加一個項目的執行時間', '2011-07-06 07:09:13'),
(5502, 'cn', 'siteauditor', 'Completed project execution', '完成項目執行', '2011-07-06 07:09:13'),
(5503, 'cn', 'siteauditor', 'Crawled', '被抓取', '2011-07-06 07:09:13'),
(5504, 'cn', 'siteauditor', 'Crawled Pages', '被抓取的頁面', '2011-07-06 07:09:13'),
(5505, 'cn', 'siteauditor', 'crawledsuccesssfullywaitfornext', '抓取成功！等待抓取下一頁面', '2011-07-06 07:09:13'),
(5506, 'cn', 'siteauditor', 'Crawling Page', '抓取頁面', '2011-07-06 07:09:13'),
(5507, 'cn', 'siteauditor', 'Duplicate Description', '重複的描述', '2011-07-06 07:09:13'),
(5508, 'cn', 'siteauditor', 'Duplicate Keywords', '重複的關鍵詞', '2011-07-06 07:09:13'),
(5509, 'cn', 'siteauditor', 'Duplicate Title', '重複的標題', '2011-07-06 07:09:13'),
(5510, 'cn', 'siteauditor', 'Exclude links', '排除連接', '2011-07-06 07:09:13'),
(5511, 'cn', 'siteauditor', 'Execute with cron', 'Cron任務執行', '2011-07-06 07:09:13'),
(5512, 'cn', 'siteauditor', 'External', '外部的', '2011-07-06 07:09:13'),
(5513, 'cn', 'siteauditor', 'External Links', '外部的鏈接', '2011-07-06 07:09:13'),
(5514, 'cn', 'siteauditor', 'Import Project Links', '導入項目鏈接', '2011-07-06 07:09:13'),
(5515, 'cn', 'siteauditor', 'Insert links separated with comma', '插入鏈接（可逗號分隔多個鏈接）', '2011-07-06 07:09:13'),
(5516, 'cn', 'siteauditor', 'insertlinkssepcoma', '插入需要從報告中排除的鏈接', '2011-07-06 07:09:13'),
(5517, 'cn', 'siteauditor', 'Link Reports', '鏈接報告', '2011-07-06 07:09:13'),
(5518, 'cn', 'siteauditor', 'Link Title', '鏈接標題', '2011-07-06 07:09:13'),
(5519, 'cn', 'siteauditor', 'Maximum number of pages to be checked', '最大檢測頁面數量', '2011-07-06 07:09:13'),
(5520, 'cn', 'siteauditor', 'Maximum Pages', '最大數量頁面', '2011-07-06 07:09:13'),
(5521, 'cn', 'siteauditor', 'No active projects found', '沒有被激活的項目被發現', '2011-07-06 07:09:13'),
(5522, 'cn', 'siteauditor', 'Nofollow', 'Nofollow', '2011-07-06 07:09:13'),
(5523, 'cn', 'siteauditor', 'Number of pages is greater than', '頁面數量更好優於', '2011-07-06 07:09:13'),
(5524, 'cn', 'siteauditor', 'Number of pages should be greater than', '頁面數量應該更好優於', '2011-07-06 07:09:13'),
(5525, 'cn', 'siteauditor', 'Page Details', '頁面詳情', '2011-07-06 07:09:13'),
(5526, 'cn', 'siteauditor', 'Page Link', '頁面鏈接', '2011-07-06 07:09:13'),
(5527, 'cn', 'siteauditor', 'Page Links', '頁面鏈接', '2011-07-06 07:09:13'),
(5528, 'cn', 'siteauditor', 'Pages Found', '頁面發現', '2011-07-06 07:09:13'),
(5529, 'cn', 'siteauditor', 'pressescapetostopexecution', '按ESC鍵來停止腳本執行', '2011-07-06 07:09:13'),
(5530, 'cn', 'siteauditor', 'Project Summary', '項目總匯', '2011-07-06 07:09:13'),
(5531, 'cn', 'siteauditor', 'Project Url', '項目URL', '2011-07-06 07:09:13'),
(5532, 'cn', 'siteauditor', 'projectalreadyexist', '該網站的項目已經存在', '2011-07-06 07:09:13'),
(5533, 'cn', 'siteauditor', 'Recheck Pages', '重新檢測頁面', '2011-07-06 07:09:13'),
(5534, 'cn', 'siteauditor', 'Report Summary', '報告總匯', '2011-07-06 07:09:13'),
(5535, 'cn', 'siteauditor', 'Run Project', '運行項目', '2011-07-06 07:09:13'),
(5536, 'cn', 'siteauditor', 'should start with', '應該開始於', '2011-07-06 07:09:13'),
(5537, 'cn', 'siteauditor', 'Site Auditor Settings', '站點審計設置', '2011-07-06 07:09:13'),
(5538, 'cn', 'siteauditor', 'Store all links found in a page', '存儲頁面的所有鏈接', '2011-07-06 07:09:13'),
(5539, 'cn', 'siteauditor', 'The page description length is not between', '該頁面的描述長度沒有位於', '2011-07-06 07:09:13'),
(5540, 'cn', 'siteauditor', 'The page is brocken', '該頁面已經損壞', '2011-07-06 07:09:13'),
(5541, 'cn', 'siteauditor', 'The page is having exellent number of backlinks in', '該頁面擁有高質量的數量反鏈在', '2011-07-06 07:09:13'),
(5542, 'cn', 'siteauditor', 'The page is having exellent pagerank', '該頁面擁有高質量的PR', '2011-07-06 07:09:13'),
(5543, 'cn', 'siteauditor', 'The page is having good number of backlinks in', '該頁面擁有不錯的反鏈在', '2011-07-06 07:09:13'),
(5544, 'cn', 'siteauditor', 'The page is having good pagerank', '該頁面擁有較好的PR', '2011-07-06 07:09:13'),
(5545, 'cn', 'siteauditor', 'The page is having poor pagerank', '該頁面擁有較差的PR', '2011-07-06 07:09:13'),
(5546, 'cn', 'siteauditor', 'The page is having very good pagerank', '該頁面擁有非常不錯的PR', '2011-07-06 07:09:13'),
(5547, 'cn', 'siteauditor', 'The page is not having backlinks in', '該頁面沒有擁有反鏈在', '2011-07-06 07:09:13'),
(5548, 'cn', 'siteauditor', 'The page is not indexed in', '該頁面沒有被索引在', '2011-07-06 07:09:13'),
(5549, 'cn', 'siteauditor', 'The page keywords length is not between', '該頁面的關鍵詞長度沒有位於', '2011-07-06 07:09:13'),
(5550, 'cn', 'siteauditor', 'The page title length is not between', '該頁面的標題長度沒有位於', '2011-07-06 07:09:13'),
(5551, 'cn', 'siteauditor', 'The total number of links in page is greater than', '所有頁面鏈接數量優於', '2011-07-06 07:09:13'),
(5552, 'cn', 'siteauditor', 'to run project again if you stopped execution', '如果你停止項目，請重新運行項目', '2011-07-06 07:09:13'),
(5553, 'cn', 'siteauditor', 'to view the reports', '瀏覽報告', '2011-07-06 07:09:13'),
(5554, 'cn', 'siteauditor', 'Total Links', '全部鏈接', '2011-07-06 07:09:13'),
(5555, 'cn', 'siteauditor', 'totallinksgreaterallowed', '全部鏈接將優於可允許的項目最大鏈接', '2011-07-06 07:09:13'),
(5556, 'da', 'directory', 'Add back to directory list', 'Tilføj tilbage til directory liste', '2013-01-14 22:40:16'),
(5557, 'da', 'directory', 'Approved', 'Godkendt', '2013-01-14 22:40:16'),
(5558, 'da', 'directory', 'Captcha', 'Captcha', '2013-01-14 22:40:16'),
(5559, 'da', 'directory', 'categorynote', 'Kategorier, skal du adskille dem med komma efter prioritet. Start med Top prioritet kategori.', '2013-01-14 22:40:16'),
(5560, 'da', 'directory', 'Check Directory Status', 'Tjek Bibliotek Status ', '2013-01-14 22:40:16'),
(5561, 'da', 'directory', 'Check Directory Submission Status', 'Tjek Bibliotek Indsendelse Status ', '2013-01-14 22:40:16'),
(5562, 'da', 'directory', 'clicktoproceeddirsts', 'Klik på <b> Fortsæt </ b> for at tjekke Bibliotek status.', '2013-01-14 22:40:16'),
(5563, 'da', 'directory', 'Confirmation', 'Bekræftelse', '2013-01-14 22:40:16'),
(5564, 'da', 'directory', 'desnote', 'Nogle biblioteker kræver dog minimum 150 tegn i feltet Beskrivelse.', '2013-01-14 22:40:16'),
(5565, 'da', 'directory', 'Directories with out captcha', 'Biblioteker uden Captcha', '2013-01-14 22:40:16'),
(5566, 'da', 'directory', 'Directory Submission Reports', 'Bibliotek Indsendelses Rapporter', '2013-01-14 22:40:16'),
(5567, 'da', 'directory', 'Enter the code shown', 'Indtast den viste kode', '2013-01-14 22:40:16'),
(5568, 'da', 'directory', 'nocatnote', 'De indsendte kategori ikke findes i indsendelse side. Klik på <b> Reload </ b> eller <b> Spring </ b>', '2013-01-14 22:40:16'),
(5569, 'da', 'directory', 'nodirnote', 'Ingen <b> Aktive</b> biblioteker er fundet', '2013-01-14 22:40:16'),
(5570, 'da', 'directory', 'nosuccessnote', 'Der blev ikke modtaget succes beskeden, Check venligst din mail for at bekræfte beskeden', '2013-01-14 22:40:16'),
(5571, 'da', 'directory', 'optionalnote', 'Mulige titler og beskrivelser af tilfældige titler og beskrivelser i biblioteket, for bedre resultater', '2013-01-14 22:40:16'),
(5572, 'da', 'directory', 'Owner Email', 'Ejerens email', '2013-01-14 22:40:16'),
(5573, 'da', 'directory', 'Owner Name', 'Ejerens navn', '2013-01-14 22:40:16'),
(5574, 'da', 'directory', 'Pending', 'Afventende', '2013-01-14 22:40:16'),
(5575, 'da', 'directory', 'Please select a website to proceed', 'Venligst vælg et websted for at forsætte', '2013-01-14 22:40:16'),
(5576, 'da', 'directory', 'selectwebsiteproceed', 'Vælg et <b>Websted</b> for <b>forsætte</b>  tilmeldingen i biblioteket. <br> tjek <b> biblioteker uden captcha </b> for at tilmelde biblioteker uden captcha', '2013-01-14 22:40:16'),
(5577, 'da', 'directory', 'selectwebsiteschecksub', 'Vælg et <b>Websted</b> for <b>Forsætte</b> check bibliotekets tilmelding', '2013-01-14 22:40:16');
INSERT INTO `texts` (`id`, `lang_code`, `category`, `label`, `content`, `changed`) VALUES
(5578, 'da', 'directory', 'Semi Automatic Directory Submission Tool', 'Semi automatisk bibliotek tilmeldings værktøj', '2013-01-14 22:40:16'),
(5579, 'da', 'directory', 'spamemailnote', 'Nogle biblioteker kan sende spam, vi anbefaler at man IKKE tilføjer sin primære email adresse', '2013-01-14 22:40:16'),
(5580, 'da', 'directory', 'Submission Details', 'Indsendelses detaljer', '2013-01-14 22:40:16'),
(5581, 'da', 'directory', 'Submit Description', 'tilmeld beskrivelse', '2013-01-14 22:40:16'),
(5582, 'da', 'directory', 'Submit Keywords', 'Tilmeld nøgleord', '2013-01-14 22:40:16'),
(5583, 'da', 'directory', 'Submit Title', 'Tilmeld titel', '2013-01-14 22:40:16'),
(5584, 'da', 'directory', 'Website Category', 'Webside kategori', '2013-01-14 22:40:16'),
(5585, 'da', 'directory', 'Website Url', 'Websted URL', '2013-01-14 22:40:16'),
(5586, 'bg', 'home', 'Indexed', 'Индексирани', '2011-07-07 01:34:28'),
(5587, 'bg', 'keyword', 'Insert keywords separated with comma', 'Въведете ключови думи разделени със запетайка', '2016-12-18 17:06:16'),
(5588, 'bg', 'label', 'Brocken', 'Повреден', '2016-12-18 17:06:39'),
(5589, 'bg', 'label', 'Comments', 'Коментари', '2016-12-18 17:06:39'),
(5590, 'bg', 'label', 'Count', 'Брой', '2016-12-18 17:06:39'),
(5591, 'bg', 'label', 'Exclude', 'Изключи', '2016-12-18 17:06:39'),
(5592, 'bg', 'label', 'Include', 'Включи', '2016-12-18 17:06:39'),
(5593, 'bg', 'label', 'Project', 'Проект', '2016-12-18 17:06:39'),
(5594, 'bg', 'label', 'Report Type', 'Тип доклад', '2016-12-18 17:06:39'),
(5595, 'bg', 'label', 'Score', 'Резултат', '2016-12-18 17:06:39'),
(5596, 'bg', 'label', 'Total Results', 'Общи резултати', '2016-12-18 17:06:39'),
(5597, 'bg', 'label', 'Updated', 'Обновен', '2016-12-18 17:06:39'),
(5598, 'bg', 'label', 'View Reports', 'Прегледай доклади', '2016-12-18 17:06:39'),
(5599, 'bg', 'panel', 'Edit Project', 'Редакция', '2016-12-18 17:07:48'),
(5600, 'bg', 'panel', 'New Project', 'Нов проект', '2016-12-18 17:07:48'),
(5601, 'bg', 'seotools', 'Auditor Projects', 'Одитор Проекти', '2011-07-07 01:42:13'),
(5602, 'bg', 'seotools', 'Auditor Reports', 'Одитор Доклади', '2011-07-07 01:42:13'),
(5603, 'bg', 'seotools', 'Auditor Settings', 'Настройки на Одитора', '2011-07-07 01:42:13'),
(5604, 'bg', 'seotools', 'Import Project Links', 'Импортиране линкове на проекта', '2011-07-07 01:42:13'),
(5605, 'bg', 'seotools', 'site-auditor', 'Сайт Одитор', '2011-07-07 01:42:13'),
(5606, 'bg', 'settings', 'Check for Updates', 'Проверка за обновления', '2016-12-18 17:09:40'),
(5607, 'bg', 'settings', 'SA_CRAWL_DELAY_TIME', 'Забавяне, при обхождане на страниците, от Сайт Одитора ', '2016-12-18 17:09:40'),
(5608, 'bg', 'settings', 'SA_MAX_NO_PAGES', 'Максимален позволен брой страници за уебсайт', '2016-12-18 17:09:40'),
(5609, 'bg', 'settings', 'versionnotuptodatemsg', 'Излязла е по-нова версия на Seo Panel.<br />Моля, изтеглете новата версия.', '2016-12-18 17:09:40'),
(5610, 'bg', 'settings', 'Your Seo Panel installation is up to date', 'Вашият Seo Panel e последна версия.', '2016-12-18 17:09:40'),
(5611, 'bg', 'siteauditor', 'Anchor', 'Връзка', '2016-12-18 17:17:52'),
(5612, 'bg', 'siteauditor', 'anylinkcontainabovelinks', 'Всички линкове, съдържащи горепосочените, ще бъдат изключени от докладите', '2016-12-18 17:17:52'),
(5613, 'bg', 'siteauditor', 'anylinkcontainexcludesitemap', 'Всички линкове, съдържащи горепосочените, ще бъдат изключени от картата на сайта', '2016-12-18 17:17:52'),
(5614, 'bg', 'siteauditor', 'Check backlinks of pages', 'Проверка на беклинковете на страниците', '2016-12-18 17:17:52'),
(5615, 'bg', 'siteauditor', 'Check broken links in a page', 'Проверка и на повредени линкове по страница', '2016-12-18 17:17:52'),
(5616, 'bg', 'siteauditor', 'Check google pagerank of pages', 'Проверка на гугъл пейдж ранг на страниците', '2016-12-18 17:17:52'),
(5617, 'bg', 'siteauditor', 'Check pages indexed or not', 'Проверка на страниците индексирани или не', '2016-12-18 17:17:52'),
(5618, 'bg', 'siteauditor', 'Check Score', 'Проверка', '2016-12-18 17:17:52'),
(5619, 'bg', 'siteauditor', 'checkborckenlinkwait', 'Проверката на повредени линкове, ще увеличи времето за изпълнение на проекта', '2016-12-18 17:17:52'),
(5620, 'bg', 'siteauditor', 'Completed project execution', 'Завършено изпълнение на проекта', '2016-12-18 17:17:52'),
(5621, 'bg', 'siteauditor', 'Crawled', 'Обходени', '2016-12-18 17:17:52'),
(5622, 'bg', 'siteauditor', 'Crawled Pages', 'Обходени страници', '2016-12-18 17:17:52'),
(5623, 'bg', 'siteauditor', 'crawledsuccesssfullywaitfornext', 'обходена успешно! Изчакване на обхождането на следващата страница за', '2016-12-18 17:17:52'),
(5624, 'bg', 'siteauditor', 'Crawling Page', 'Обхождане на страница', '2016-12-18 17:17:52'),
(5625, 'bg', 'siteauditor', 'Duplicate Description', 'Дубликирано Описание', '2016-12-18 17:17:52'),
(5626, 'bg', 'siteauditor', 'Duplicate Keywords', 'Дубликирани Ключови думи', '2016-12-18 17:17:52'),
(5627, 'bg', 'siteauditor', 'Duplicate Title', 'Дубликирано Заглавие', '2016-12-18 17:17:52'),
(5628, 'bg', 'siteauditor', 'Exclude links', 'Изключи линковете', '2016-12-18 17:17:52'),
(5629, 'bg', 'siteauditor', 'Execute with cron', 'Изпълни с CRON', '2016-12-18 17:17:52'),
(5630, 'bg', 'siteauditor', 'External', 'Външен', '2016-12-18 17:17:52'),
(5631, 'bg', 'siteauditor', 'External Links', 'Външни линкове', '2016-12-18 17:17:52'),
(5632, 'bg', 'siteauditor', 'Import Project Links', 'Импортиране на линкове', '2016-12-18 17:17:52'),
(5633, 'bg', 'siteauditor', 'Insert links separated with comma', 'Въведете линковете разделени със запетайка', '2016-12-18 17:17:52'),
(5634, 'bg', 'siteauditor', 'insertlinkssepcoma', 'Въведете линковете разделени със запетайка за да изключите безкрайните от докладите', '2016-12-18 17:17:52'),
(5635, 'bg', 'siteauditor', 'Link Reports', 'Доклади за линк', '2016-12-18 17:17:52'),
(5636, 'bg', 'siteauditor', 'Link Title', 'Заглавие на линка', '2016-12-18 17:17:52'),
(5637, 'bg', 'siteauditor', 'Maximum number of pages to be checked', 'Максимален брой страници, които да бъдат проверени', '2016-12-18 17:17:52'),
(5638, 'bg', 'siteauditor', 'Maximum Pages', 'Макс. бр. страници', '2016-12-18 17:17:52'),
(5639, 'bg', 'siteauditor', 'No active projects found', 'Няма намерени активни проекти', '2016-12-18 17:17:52'),
(5640, 'bg', 'siteauditor', 'Nofollow', 'Nofollow', '2016-12-18 17:17:52'),
(5641, 'bg', 'siteauditor', 'Number of pages is greater than', 'Броят страници е по-голям от', '2016-12-18 17:17:52'),
(5642, 'bg', 'siteauditor', 'Number of pages should be greater than', 'Броят на страниците, трябва да бъде по голям от', '2016-12-18 17:17:52'),
(5643, 'bg', 'siteauditor', 'Page Details', 'Детайли', '2016-12-18 17:17:52'),
(5644, 'bg', 'siteauditor', 'Page Link', 'Линк на страницата', '2016-12-18 17:17:52'),
(5645, 'bg', 'siteauditor', 'Page Links', 'Линкове на страницата', '2016-12-18 17:17:52'),
(5646, 'bg', 'siteauditor', 'Pages Found', 'Намерени страници', '2016-12-18 17:17:52'),
(5647, 'bg', 'siteauditor', 'pressescapetostopexecution', 'Натиснете клавиша <b>Escape</b> за да спрете изпълнението на скрипта', '2016-12-18 17:17:52'),
(5648, 'bg', 'siteauditor', 'Project Summary', 'Накратко за проекта', '2016-12-18 17:17:52'),
(5649, 'bg', 'siteauditor', 'Project Url', 'URL на проекта', '2016-12-18 17:17:52'),
(5650, 'bg', 'siteauditor', 'projectalreadyexist', 'Вече съществува проект за този уебсайт', '2016-12-18 17:17:52'),
(5651, 'bg', 'siteauditor', 'Recheck Pages', 'Препровери страниците', '2016-12-18 17:17:52'),
(5652, 'bg', 'siteauditor', 'Report Summary', 'Опростен доклад', '2016-12-18 17:17:52'),
(5653, 'bg', 'siteauditor', 'Run Project', 'Стартирай проекта', '2016-12-18 17:17:52'),
(5654, 'bg', 'siteauditor', 'should start with', 'трябва да започва с', '2016-12-18 17:17:52'),
(5655, 'bg', 'siteauditor', 'Site Auditor Settings', 'Настройки на Сайт Одитора', '2016-12-18 17:17:52'),
(5656, 'bg', 'siteauditor', 'Store all links found in a page', 'Запази всички линкове намерени на страницата', '2016-12-18 17:17:52'),
(5657, 'bg', 'siteauditor', 'The page description length is not between', 'Дължината на описанието на страница не е между', '2016-12-18 17:17:52'),
(5658, 'bg', 'siteauditor', 'The page is brocken', 'Страницата е повредена', '2016-12-18 17:17:52'),
(5659, 'bg', 'siteauditor', 'The page is having exellent number of backlinks in', 'Страницата има отличен брой беклинкове в', '2016-12-18 17:17:52'),
(5660, 'bg', 'siteauditor', 'The page is having exellent pagerank', 'Страницата има отличен пейдж ранк', '2016-12-18 17:17:52'),
(5661, 'bg', 'siteauditor', 'The page is having good number of backlinks in', 'Страницата има добър брой беклинкове в', '2016-12-18 17:17:52'),
(5662, 'bg', 'siteauditor', 'The page is having good pagerank', 'Страницата има добър пейдж ранк', '2016-12-18 17:17:52'),
(5663, 'bg', 'siteauditor', 'The page is having poor pagerank', 'Страницата има лош пейдж ранк', '2016-12-18 17:17:52'),
(5664, 'bg', 'siteauditor', 'The page is having very good pagerank', 'Страницата има много добър педйж ранк', '2016-12-18 17:17:52'),
(5665, 'bg', 'siteauditor', 'The page is not having backlinks in', 'Страницата няма беклинкове в', '2016-12-18 17:17:52'),
(5666, 'bg', 'siteauditor', 'The page is not indexed in', 'Страницата не е индексриана в', '2016-12-18 17:17:52'),
(5667, 'bg', 'siteauditor', 'The page keywords length is not between', 'Броят на ключовите думи на страницата не е между', '2016-12-18 17:17:52'),
(5668, 'bg', 'siteauditor', 'The page title length is not between', 'Дължината на залгавието на страницата не е между', '2016-12-18 17:17:52'),
(5669, 'bg', 'siteauditor', 'The total number of links in page is greater than', 'Общият брой на линковете по страницата е по-голям от', '2016-12-18 17:17:52'),
(5670, 'bg', 'siteauditor', 'to run project again if you stopped execution', 'за да стартирате проекта отново, ако сте спрели изпълнението', '2016-12-18 17:17:52'),
(5671, 'bg', 'siteauditor', 'to view the reports', 'за да видите докладите', '2016-12-18 17:17:52'),
(5672, 'bg', 'siteauditor', 'Total Links', 'Общо линкове', '2016-12-18 17:17:52'),
(5673, 'bg', 'siteauditor', 'totallinksgreaterallowed', 'Общият брой линкове, ще бъде по-голям от максимума, позволен за този проект ', '2016-12-18 17:17:52'),
(5674, 'en', 'settings', 'SP_API_KEY', 'Seo Panel API Key', '2011-07-07 07:54:02'),
(5675, 'ro', 'home', 'Indexed', 'Indexate', '2012-05-18 20:57:04'),
(5676, 'ro', 'keyword', 'Insert keywords separated with comma', 'Introduceti cuvintele cheie despartite prin virgula', '2012-05-18 20:57:55'),
(5677, 'ro', 'label', 'Brocken', 'Stricat', '2012-05-18 21:00:22'),
(5678, 'ro', 'label', 'Comments', 'Comentarii', '2012-05-18 21:00:22'),
(5679, 'ro', 'label', 'Count', 'Numara', '2012-05-18 21:00:22'),
(5680, 'ro', 'label', 'Exclude', 'Exclude', '2012-05-18 21:00:22'),
(5681, 'ro', 'label', 'Include', 'Include', '2012-05-18 21:00:22'),
(5682, 'ro', 'label', 'Project', 'Proiect', '2012-05-18 21:00:22'),
(5683, 'ro', 'label', 'Report Type', 'Tip Raport', '2012-05-18 21:00:22'),
(5684, 'ro', 'label', 'Score', 'Scor', '2012-05-18 21:00:22'),
(5685, 'ro', 'label', 'Total Results', 'Rezultate totale', '2012-05-18 21:00:22'),
(5686, 'ro', 'label', 'Updated', 'Updatat', '2012-05-18 21:00:22'),
(5687, 'ro', 'label', 'View Reports', 'Vezi rapoarte', '2012-05-18 21:00:22'),
(5688, 'ro', 'panel', 'Edit Project', 'Editeaza proiect', '2012-05-18 21:04:43'),
(5689, 'ro', 'panel', 'New Project', 'Proiect Nou', '2012-05-18 21:04:43'),
(5690, 'ro', 'seotools', 'Auditor Projects', 'Proiecte Auditor', '2011-07-13 02:03:17'),
(5691, 'ro', 'seotools', 'Auditor Reports', 'Rapoarte Auditor', '2011-07-13 02:03:17'),
(5692, 'ro', 'seotools', 'Auditor Settings', 'Setari Auditor', '2011-07-13 02:03:17'),
(5693, 'ro', 'seotools', 'Import Project Links', 'Importa link-uri proiect', '2011-07-13 02:03:17'),
(5694, 'ro', 'seotools', 'site-auditor', 'Auditor Site', '2011-07-13 02:03:17'),
(5695, 'ro', 'settings', 'Check for Updates', 'Cauta actualizari', '2012-05-18 21:16:44'),
(5696, 'ro', 'settings', 'SA_CRAWL_DELAY_TIME', 'Crawl Evaluator site intarziere intre pagini', '2012-05-18 21:16:44'),
(5697, 'ro', 'settings', 'SA_MAX_NO_PAGES', 'Numar maxim de pagini permise per site', '2012-05-18 21:16:44'),
(5698, 'ro', 'settings', 'SP_API_KEY', 'Seo Panel API Key', '2012-05-18 21:16:44'),
(5699, 'ro', 'settings', 'versionnotuptodatemsg', 'Kitul de instalare Seo Panel nu este la zi. <br> Va rugam descarcati versiunea noua', '2012-05-18 21:16:44'),
(5700, 'ro', 'settings', 'Your Seo Panel installation is up to date', 'Kitul de instalare Seo Panel este la zi', '2012-05-18 21:16:44'),
(5701, 'ro', 'siteauditor', 'Anchor', 'Ancora', '2011-07-13 02:12:41'),
(5702, 'ro', 'siteauditor', 'anylinkcontainabovelinks', 'Orice link continand linkurile alaturate vor fi excluse din raport', '2011-07-13 02:12:43'),
(5703, 'ro', 'siteauditor', 'anylinkcontainexcludesitemap', 'Orice link continand linkurile alaturate vor fi excluse din sitemap', '2011-07-13 02:12:43'),
(5704, 'ro', 'siteauditor', 'Check backlinks of pages', 'Verificati backlink-urile paginilor', '2011-07-13 02:12:43'),
(5705, 'ro', 'siteauditor', 'Check broken links in a page', 'Verificati linkurile intrerupte dintr-o pagina', '2011-07-13 02:12:43'),
(5706, 'ro', 'siteauditor', 'Check google pagerank of pages', 'Verificati pagerank-ul Google al paginilor', '2011-07-13 02:12:43'),
(5707, 'ro', 'siteauditor', 'Check pages indexed or not', 'Verificati paginile indexate sau nu', '2011-07-13 02:12:43'),
(5708, 'ro', 'siteauditor', 'Check Score', 'Verificati scor', '2011-07-13 02:12:43'),
(5709, 'ro', 'siteauditor', 'checkborckenlinkwait', 'Verificarea linkurile intrerupte va creste timpul de executie al proiectului', '2011-07-13 02:12:43'),
(5710, 'ro', 'siteauditor', 'Completed project execution', 'Execuatre proiect completata', '2011-07-13 02:12:43'),
(5711, 'ro', 'siteauditor', 'Crawled', 'Crawled', '2011-07-13 02:12:43'),
(5712, 'ro', 'siteauditor', 'Crawled Pages', 'Pagini Crawled', '2011-07-13 02:12:43'),
(5713, 'ro', 'siteauditor', 'crawledsuccesssfullywaitfornext', 'Crawled cu succes! In asteptarea crawlink pagina urmatoare', '2011-07-13 02:12:43'),
(5714, 'ro', 'siteauditor', 'Crawling Page', 'Crawling pagina', '2011-07-13 02:12:43'),
(5715, 'ro', 'siteauditor', 'Duplicate Description', 'Descrie duplicat', '2011-07-13 02:12:43'),
(5716, 'ro', 'siteauditor', 'Duplicate Keywords', 'Cuvinte cheie duplicate', '2011-07-13 02:12:43'),
(5717, 'ro', 'siteauditor', 'Duplicate Title', 'Titlu duplicat', '2011-07-13 02:12:43'),
(5718, 'ro', 'siteauditor', 'Exclude links', 'linkuri excluse', '2011-07-13 02:12:43'),
(5719, 'ro', 'siteauditor', 'Execute with cron', 'Executa cu cron', '2011-07-13 02:12:43'),
(5720, 'ro', 'siteauditor', 'External', 'Extern', '2011-07-13 02:12:43'),
(5721, 'ro', 'siteauditor', 'External Links', 'Linkuri externe', '2011-07-13 02:12:43'),
(5722, 'ro', 'siteauditor', 'Import Project Links', 'Importa linkuri proiect', '2011-07-13 02:12:43'),
(5723, 'ro', 'siteauditor', 'Insert links separated with comma', 'Insereaza linkuri separate cu virgula', '2011-07-13 02:12:43'),
(5724, 'ro', 'siteauditor', 'insertlinkssepcoma', 'Insereaza linkuri separate prin virgula pentru a exclude linkuri infinite din rapoarte', '2011-07-13 02:12:43'),
(5725, 'ro', 'siteauditor', 'Link Reports', 'Linkuri rapoarte', '2011-07-13 02:12:43'),
(5726, 'ro', 'siteauditor', 'Link Title', 'Titlu link', '2011-07-13 02:12:43'),
(5727, 'ro', 'siteauditor', 'Maximum number of pages to be checked', 'Numar maxim de pagini care trebuiesc verificate', '2011-07-13 02:12:43'),
(5728, 'ro', 'siteauditor', 'Maximum Pages', 'Pagini maxime', '2011-07-13 02:12:43'),
(5729, 'ro', 'siteauditor', 'No active projects found', 'Niciun proiect activ gasit', '2011-07-13 02:12:43'),
(5730, 'ro', 'siteauditor', 'Nofollow', 'Nofollow', '2011-07-13 02:12:43'),
(5731, 'ro', 'siteauditor', 'Number of pages is greater than', 'Numarul paginilor este mai mare de', '2011-07-13 02:12:43'),
(5732, 'ro', 'siteauditor', 'Number of pages should be greater than', 'Numarul paginilor ar trebui sa fie mai mare de', '2011-07-13 02:12:43'),
(5733, 'ro', 'siteauditor', 'Page Details', 'Detalii pagina', '2011-07-13 02:12:43'),
(5734, 'ro', 'siteauditor', 'Page Link', 'Link pagina', '2011-07-13 02:12:43'),
(5735, 'ro', 'siteauditor', 'Page Links', 'Linkuri pagina', '2011-07-13 02:12:43'),
(5736, 'ro', 'siteauditor', 'Pages Found', 'Pgini gasite', '2011-07-13 02:12:43'),
(5737, 'ro', 'siteauditor', 'pressescapetostopexecution', 'Apasa <b>anulare</b> pentru a opri executarea scriptului', '2011-07-13 02:12:43'),
(5738, 'ro', 'siteauditor', 'Project Summary', 'Sumar proiect', '2011-07-13 02:12:43'),
(5739, 'ro', 'siteauditor', 'Project Url', 'Url proiect', '2011-07-13 02:12:43'),
(5740, 'ro', 'siteauditor', 'projectalreadyexist', 'Proiect pentru acest site exista deja', '2011-07-13 02:12:43'),
(5741, 'ro', 'siteauditor', 'Recheck Pages', 'Reverifica paginile', '2011-07-13 02:12:43'),
(5742, 'ro', 'siteauditor', 'Report Summary', 'Sumar raport', '2011-07-13 02:12:43'),
(5743, 'ro', 'siteauditor', 'Run Project', 'Start proiect', '2011-07-13 02:12:43'),
(5744, 'ro', 'siteauditor', 'should start with', 'ar trebuie sa inceapa cu', '2011-07-13 02:12:43'),
(5745, 'ro', 'siteauditor', 'Site Auditor Settings', 'Setari Verificator site', '2011-07-13 02:12:43'),
(5746, 'ro', 'siteauditor', 'Store all links found in a page', 'Salveaza toate linkurile gasite intr-o pagina', '2011-07-13 02:12:43'),
(5747, 'ro', 'siteauditor', 'The page description length is not between', 'dimensiunea descrierii paginii nu este intre', '2011-07-13 02:12:43'),
(5748, 'ro', 'siteauditor', 'The page is brocken', 'Pagina este intrerupta', '2011-07-13 02:12:43'),
(5749, 'ro', 'siteauditor', 'The page is having exellent number of backlinks in', 'Pagina are un numar excelent de backlinkuri in', '2011-07-13 02:12:43'),
(5750, 'ro', 'siteauditor', 'The page is having exellent pagerank', 'Pagina are un pagerank excelent', '2011-07-13 02:12:43'),
(5751, 'ro', 'siteauditor', 'The page is having good number of backlinks in', 'Pagina are numere bune de backlinkuri in', '2011-07-13 02:12:43'),
(5752, 'ro', 'siteauditor', 'The page is having good pagerank', 'Pagina are pagerank bun', '2011-07-13 02:12:43'),
(5753, 'ro', 'siteauditor', 'The page is having poor pagerank', 'Pagina are pagerank slab', '2011-07-13 02:12:43'),
(5754, 'ro', 'siteauditor', 'The page is having very good pagerank', 'Pagina are un page rank foarte bun', '2011-07-13 02:12:43'),
(5755, 'ro', 'siteauditor', 'The page is not having backlinks in', 'Pagina nu are backlinkuri in', '2011-07-13 02:12:43'),
(5756, 'ro', 'siteauditor', 'The page is not indexed in', 'Pagina nu este indexata in', '2011-07-13 02:12:43'),
(5757, 'ro', 'siteauditor', 'The page keywords length is not between', 'Lungimea cuvintelor cheie din pagina nu este intre', '2011-07-13 02:12:43'),
(5758, 'ro', 'siteauditor', 'The page title length is not between', 'Lungimea titlului paginii nu este intre', '2011-07-13 02:12:43'),
(5759, 'ro', 'siteauditor', 'The total number of links in page is greater than', 'Numarul total de linkuri in pagina este mai mare de', '2011-07-13 02:12:43'),
(5760, 'ro', 'siteauditor', 'to run project again if you stopped execution', 'pentru a incepe proiectul dinou daca intrerupeti executarea', '2011-07-13 02:12:43'),
(5761, 'ro', 'siteauditor', 'to view the reports', 'pentru avedea rapoartele', '2011-07-13 02:12:43'),
(5762, 'ro', 'siteauditor', 'Total Links', 'Linkuri Totale', '2011-07-13 02:12:43'),
(5763, 'ro', 'siteauditor', 'totallinksgreaterallowed', 'Linkuri totale vor deveni mai mari decat maximul de linkuri permise in proiect', '2011-07-13 02:12:43'),
(5764, 'es', 'home', 'Indexed', 'Indexado', '2012-05-31 10:36:11'),
(5765, 'es', 'keyword', 'Insert keywords separated with comma', 'Inserta las palabras clave separadas por comas', '2011-07-07 10:24:15'),
(5766, 'es', 'label', 'Brocken', 'Roto', '2012-05-12 10:54:10'),
(5767, 'es', 'label', 'Comments', 'Comentarios', '2012-05-12 10:54:10'),
(5768, 'es', 'label', 'Count', 'Contador', '2012-05-12 10:54:10'),
(5769, 'es', 'label', 'Exclude', 'Excluir', '2012-05-12 10:54:10'),
(5770, 'es', 'label', 'Include', 'Incluir', '2012-05-12 10:54:10'),
(5771, 'es', 'label', 'Project', 'Proyecto', '2012-05-12 10:54:10'),
(5772, 'es', 'label', 'Report Type', 'Tipo de Informe', '2012-05-12 10:54:10'),
(5773, 'es', 'label', 'Score', 'Puntuación', '2012-05-12 10:54:10'),
(5774, 'es', 'label', 'Total Results', 'Resultado total', '2012-05-12 10:54:10'),
(5775, 'es', 'label', 'Updated', 'Actualizado', '2012-05-12 10:54:10'),
(5776, 'es', 'label', 'View Reports', 'Ver Informes', '2012-05-12 10:54:10'),
(5777, 'es', 'seotools', 'Import Project Links', 'Importar Proyecto links', '2011-07-13 19:32:41'),
(5778, 'es', 'settings', 'SA_CRAWL_DELAY_TIME', 'Tiempo de espera entre rastreo', '2012-05-12 11:03:05'),
(5779, 'es', 'settings', 'SA_MAX_NO_PAGES', 'Número máximo de páginas permitidas por sitio web', '2012-05-12 11:03:05'),
(5780, 'es', 'settings', 'SP_API_KEY', 'Llave API para el Seo Panel', '2012-05-12 11:03:05'),
(5781, 'es', 'siteauditor', 'Anchor', 'Ancla (Anchor)', '2011-07-13 19:09:35'),
(5782, 'es', 'siteauditor', 'anylinkcontainabovelinks', 'Todos los enlaces ubicados por encima de los enlaces serán excluidos de los informes', '2011-07-13 19:09:35'),
(5783, 'es', 'siteauditor', 'anylinkcontainexcludesitemap', 'Todos los enlaces ubicados por encima de los enlaces serán excluidos del sitemap', '2011-07-13 19:09:35'),
(5784, 'es', 'siteauditor', 'Check backlinks of pages', 'Comprobar los backlinks de las páginas', '2011-07-13 19:09:35'),
(5785, 'es', 'siteauditor', 'Check broken links in a page', 'Comprobar los links rotos en la página', '2011-07-13 19:09:35'),
(5786, 'es', 'siteauditor', 'Check google pagerank of pages', 'Comprobar el google page rank de las páginas', '2011-07-13 19:09:35'),
(5787, 'es', 'siteauditor', 'Check pages indexed or not', 'Comprobar las páginas indexadas', '2011-07-13 19:09:35'),
(5788, 'es', 'siteauditor', 'Check Score', 'Comprobar posición', '2011-07-13 19:09:35'),
(5789, 'es', 'siteauditor', 'checkborckenlinkwait', 'La comprobación de los links rotos incrementara el tiempo del proyecto', '2011-07-13 19:09:35'),
(5790, 'es', 'siteauditor', 'Completed project execution', 'Ejecución del proyecto completada', '2011-07-13 19:09:35'),
(5791, 'es', 'siteauditor', 'Crawled', 'Indexado', '2011-07-13 19:09:35'),
(5792, 'es', 'siteauditor', 'Crawled Pages', 'Páginas Indexadas', '2011-07-13 19:09:35'),
(5793, 'es', 'siteauditor', 'crawledsuccesssfullywaitfornext', 'Indexado completado! Esperando la próxima indexación de', '2011-07-13 19:09:35'),
(5794, 'es', 'siteauditor', 'Crawling Page', 'Página Indexando', '2011-07-13 19:09:35'),
(5795, 'es', 'siteauditor', 'Duplicate Description', 'Descripción duplicada', '2011-07-13 19:09:35'),
(5796, 'es', 'siteauditor', 'Duplicate Keywords', 'Palabra clave duplicada', '2011-07-13 19:09:35'),
(5797, 'es', 'siteauditor', 'Duplicate Title', 'Titulo duplicado', '2011-07-13 19:09:35'),
(5798, 'es', 'siteauditor', 'Exclude links', 'Links Excluidos', '2011-07-13 19:09:35'),
(5799, 'es', 'siteauditor', 'Execute with cron', 'Ejecución con CRON', '2011-07-13 19:09:35'),
(5800, 'es', 'siteauditor', 'External', 'Externo', '2011-07-13 19:09:35'),
(5801, 'es', 'siteauditor', 'External Links', 'Links externos', '2011-07-13 19:09:35'),
(5802, 'es', 'siteauditor', 'Import Project Links', 'Importar proyecto links', '2011-07-13 19:09:35'),
(5803, 'es', 'siteauditor', 'Insert links separated with comma', 'Inserta los links separados por una coma', '2011-07-13 19:09:35'),
(5804, 'es', 'siteauditor', 'insertlinkssepcoma', 'Inserta los links separados por una coma para excluir infinitamente los links de los informes', '2011-07-13 19:09:35'),
(5805, 'es', 'siteauditor', 'Link Reports', 'Informe de Links', '2011-07-13 19:09:35'),
(5806, 'es', 'siteauditor', 'Link Title', 'Titulo del Link', '2011-07-13 19:09:35'),
(5807, 'es', 'siteauditor', 'Maximum number of pages to be checked', 'Número máximo de páginas a ser comprobadas', '2011-07-13 19:09:35'),
(5808, 'es', 'siteauditor', 'Maximum Pages', 'Páginas máximas', '2011-07-13 19:09:35'),
(5809, 'es', 'siteauditor', 'No active projects found', 'No hay proyectos activos', '2011-07-13 19:09:35'),
(5810, 'es', 'siteauditor', 'Nofollow', 'Nofollow', '2011-07-13 19:09:35'),
(5811, 'es', 'siteauditor', 'Number of pages is greater than', 'El número de páginas es mayor de', '2011-07-13 19:09:35'),
(5812, 'es', 'siteauditor', 'Number of pages should be greater than', 'El número de páginas debería ser mayor de', '2011-07-13 19:09:35'),
(5813, 'es', 'siteauditor', 'Page Details', 'Detalles de la página', '2011-07-13 19:09:35'),
(5814, 'es', 'siteauditor', 'Page Link', 'Página del link', '2011-07-13 19:09:35'),
(5815, 'es', 'siteauditor', 'Page Links', 'Página de los links', '2011-07-13 19:09:35'),
(5816, 'es', 'siteauditor', 'Pages Found', 'Páginas encontradas', '2011-07-13 19:09:35'),
(5817, 'es', 'siteauditor', 'pressescapetostopexecution', 'Pulsa <b>Escape</b> para parar la ejecución', '2011-07-13 19:09:35'),
(5818, 'es', 'siteauditor', 'Project Summary', 'Resumen del proyecto', '2011-07-13 19:09:35'),
(5819, 'es', 'siteauditor', 'Project Url', 'URL del proyecto', '2011-07-13 19:09:35'),
(5820, 'es', 'siteauditor', 'projectalreadyexist', 'El proyecto para esta página web ya existe', '2011-07-13 19:09:35'),
(5821, 'es', 'siteauditor', 'Recheck Pages', 'Re-comprobar las páginas', '2011-07-13 19:09:35'),
(5822, 'es', 'siteauditor', 'Report Summary', 'Informe resumen', '2011-07-13 19:09:35'),
(5823, 'es', 'siteauditor', 'Run Project', 'Ejecutar proyecto', '2011-07-13 19:09:35'),
(5824, 'es', 'siteauditor', 'should start with', 'debería empezar con', '2011-07-13 19:09:35'),
(5825, 'es', 'siteauditor', 'Site Auditor Settings', 'Parámetros del Site Auditor', '2011-07-13 19:09:35'),
(5826, 'es', 'siteauditor', 'Store all links found in a page', 'Salvar todos los links encontrados en la página', '2011-07-13 19:09:35'),
(5827, 'es', 'siteauditor', 'The page description length is not between', 'La longitud de la descripción no esta entre', '2011-07-13 19:09:35'),
(5828, 'es', 'siteauditor', 'The page is brocken', 'La página no es correcta o contiene errores', '2011-07-13 19:09:35'),
(5829, 'es', 'siteauditor', 'The page is having exellent number of backlinks in', 'La página esta teniendo un excelente número de backlinks en', '2011-07-13 19:09:35'),
(5830, 'es', 'siteauditor', 'The page is having exellent pagerank', 'La página esta teniendo un excelente pagerank', '2011-07-13 19:09:35'),
(5831, 'es', 'siteauditor', 'The page is having good number of backlinks in', 'La página esta teniendo un buen número de backlinks en ', '2011-07-13 19:09:35'),
(5832, 'es', 'siteauditor', 'The page is having good pagerank', 'La página esta teniendo un buen pagerank', '2011-07-13 19:09:35'),
(5833, 'es', 'siteauditor', 'The page is having poor pagerank', 'La página esta teniendo un bajo pagerank', '2011-07-13 19:09:35'),
(5834, 'es', 'siteauditor', 'The page is having very good pagerank', 'La página esta teniendo un muy buen pagerank', '2011-07-13 19:09:35'),
(5835, 'es', 'siteauditor', 'The page is not having backlinks in', 'La página no esta teniendo backlinks en', '2011-07-13 19:09:35'),
(5836, 'es', 'siteauditor', 'The page is not indexed in', 'La página no esta siendo indexada en', '2011-07-13 19:09:35'),
(5837, 'es', 'siteauditor', 'The page keywords length is not between', 'La longitud de las palabran en página no esta entre', '2011-07-13 19:09:35'),
(5838, 'es', 'siteauditor', 'The page title length is not between', 'La longitud del título de la página no esta entre ', '2011-07-13 19:09:35'),
(5839, 'es', 'siteauditor', 'The total number of links in page is greater than', 'El número total de backlinks en la página es mayor de', '2011-07-13 19:09:35'),
(5840, 'es', 'siteauditor', 'to run project again if you stopped execution', 'para ejecutar el proyecto otra vez si se paró la ejecución anteriormente', '2011-07-13 19:09:35'),
(5841, 'es', 'siteauditor', 'to view the reports', 'para ver los informes', '2011-07-13 19:09:35'),
(5842, 'es', 'siteauditor', 'Total Links', 'Links totales', '2011-07-13 19:09:35'),
(5843, 'es', 'siteauditor', 'totallinksgreaterallowed', 'El número total de links será mayor que el número máximo de links permitidos en el proyecto', '2011-07-13 19:09:35'),
(5844, 'de', 'home', 'Indexed', 'Indiziert', '2011-07-07 19:09:22'),
(5845, 'de', 'keyword', 'Insert keywords separated with comma', 'Keywords durch Komma getrennt angeben.', '2016-01-02 23:22:50'),
(5846, 'de', 'label', 'Brocken', 'Fehlerhaft', '2016-01-02 23:23:15'),
(5847, 'de', 'label', 'Comments', 'Kommentare', '2016-01-02 23:23:15'),
(5848, 'de', 'label', 'Count', 'Anzahl', '2016-01-02 23:23:15'),
(5849, 'de', 'label', 'Exclude', 'ausschliessen', '2016-01-02 23:23:15'),
(5850, 'de', 'label', 'Include', 'einschliessen', '2016-01-02 23:23:15'),
(5851, 'de', 'label', 'Project', 'Projekt', '2016-01-02 23:23:15'),
(5852, 'de', 'label', 'Report Type', 'Art des Berichtes', '2016-01-02 23:23:15'),
(5853, 'de', 'label', 'Score', 'Wertung', '2016-01-02 23:23:15'),
(5854, 'de', 'label', 'Total Results', 'Gesamtergebnisse', '2016-01-02 23:23:15'),
(5855, 'de', 'label', 'Updated', 'Aktualisiert', '2016-01-02 23:23:15'),
(5856, 'de', 'label', 'View Reports', 'Berichte einsehen', '2016-01-02 23:23:15'),
(5857, 'de', 'panel', 'Edit Project', 'Projekt bearbeiten', '2016-01-02 23:23:58'),
(5858, 'de', 'panel', 'New Project', 'Neues Projekt', '2016-01-02 23:23:58'),
(5859, 'de', 'seotools', 'Auditor Projects', 'Website-Doktor Projekte', '2011-07-07 19:13:48'),
(5860, 'de', 'seotools', 'Auditor Reports', 'Website-Doktor Berichte', '2011-07-07 19:13:48'),
(5861, 'de', 'seotools', 'Auditor Settings', 'Website-Doktor Einstellungen', '2011-07-07 19:13:48'),
(5862, 'de', 'seotools', 'Import Project Links', 'Projekt-Links importieren', '2011-07-07 19:13:48'),
(5863, 'de', 'seotools', 'site-auditor', 'Website-Doktor', '2011-07-07 19:13:48'),
(5864, 'de', 'settings', 'Check for Updates', 'Nach Updates suchen', '2015-06-16 08:32:07'),
(5865, 'de', 'settings', 'SA_CRAWL_DELAY_TIME', 'Website-Doktor Pausen zwischen Seitenpruefungen', '2015-06-16 08:32:07'),
(5866, 'de', 'settings', 'SA_MAX_NO_PAGES', 'Maximale Anzahl an Seiten pro Webseite', '2015-06-16 08:32:07'),
(5867, 'de', 'settings', 'SP_API_KEY', 'SEO Panel API Schluessel', '2015-06-16 08:32:07'),
(5868, 'de', 'settings', 'versionnotuptodatemsg', 'Ihre SEO Panel Installation ist nicht auf dem neusten Stand. <br>Bitte updaten / Neuste Version herunterladen.', '2015-06-16 08:32:07'),
(5869, 'de', 'settings', 'Your Seo Panel installation is up to date', 'Ihre SEO Panel Installation ist auf dem neusten Stand.', '2015-06-16 08:32:07'),
(5870, 'de', 'siteauditor', 'Anchor', 'Ankertext', '2011-07-07 19:27:48'),
(5871, 'de', 'siteauditor', 'anylinkcontainabovelinks', 'Alle oben aufgefuehrten Links werden vom Bericht ausgeschlossen', '2011-07-07 19:27:48'),
(5872, 'de', 'siteauditor', 'anylinkcontainexcludesitemap', 'Alle oben aufgefuehrten Links werden vom Sitemap ausgeschlossen', '2011-07-07 19:27:48'),
(5873, 'de', 'siteauditor', 'Check backlinks of pages', 'Backlinks der Seiten ueberpruefen', '2011-07-07 19:27:48'),
(5874, 'de', 'siteauditor', 'Check broken links in a page', 'Kaputte Links einer Seite ueberpruefen', '2011-07-07 19:27:48'),
(5875, 'de', 'siteauditor', 'Check google pagerank of pages', 'Google Pagerank der Seiten ueberpruefen', '2011-07-07 19:27:48'),
(5876, 'de', 'siteauditor', 'Check pages indexed or not', 'Ueberpruefen ob Seiten indiziert sind oder nicht.', '2011-07-07 19:27:48'),
(5877, 'de', 'siteauditor', 'Check Score', 'Gesamtwertung ermitteln', '2011-07-07 19:27:48'),
(5878, 'de', 'siteauditor', 'checkborckenlinkwait', 'Das Ueberpruefen von kaputten Links wird die Ausfuehrungsdauer eines Projektes verlaengern.', '2011-07-07 19:27:48'),
(5879, 'de', 'siteauditor', 'Completed project execution', 'Projekt ausgefuehrt.', '2011-07-07 19:27:48'),
(5880, 'de', 'siteauditor', 'Crawled', 'Seiten geprueft', '2011-07-07 19:27:48'),
(5881, 'de', 'siteauditor', 'Crawled Pages', 'Gepruefte Seiten', '2011-07-07 19:27:48'),
(5882, 'de', 'siteauditor', 'crawledsuccesssfullywaitfornext', 'Pruefung erfolgreich! Starte Pruefung der naechsten Seite fuer', '2011-07-07 19:27:48'),
(5883, 'de', 'siteauditor', 'Crawling Page', 'Ueberpruefe Seite', '2011-07-07 19:27:48'),
(5884, 'de', 'siteauditor', 'Duplicate Description', 'Doppelte Beschreibung', '2011-07-07 19:27:48'),
(5885, 'de', 'siteauditor', 'Duplicate Keywords', 'Doppelte Keywords', '2011-07-07 19:27:48'),
(5886, 'de', 'siteauditor', 'Duplicate Title', 'Doppelte Titel', '2011-07-07 19:27:48'),
(5887, 'de', 'siteauditor', 'Exclude links', 'Links ausschliessen', '2011-07-07 19:27:48'),
(5888, 'de', 'siteauditor', 'Execute with cron', 'Als Cronjob ausfuehren', '2011-07-07 19:27:48'),
(5889, 'de', 'siteauditor', 'External', 'Extern', '2011-07-07 19:27:48'),
(5890, 'de', 'siteauditor', 'External Links', 'Externe Links', '2011-07-07 19:27:48'),
(5891, 'de', 'siteauditor', 'Import Project Links', 'Projektlinks importieren', '2011-07-07 19:27:48'),
(5892, 'de', 'siteauditor', 'Insert links separated with comma', 'Links kommagetrennt angeben.', '2011-07-07 19:27:48'),
(5893, 'de', 'siteauditor', 'insertlinkssepcoma', 'Links kommagetrennt angeben um unendliche Links aus Berichten auszuschliessen', '2011-07-07 19:27:48'),
(5894, 'de', 'siteauditor', 'Link Reports', 'Link Bericht', '2011-07-07 19:27:48'),
(5895, 'de', 'siteauditor', 'Link Title', 'Link Titel', '2011-07-07 19:27:48'),
(5896, 'de', 'siteauditor', 'Maximum number of pages to be checked', 'Maximale Anzahl der zu ueberpruefenden Seiten', '2011-07-07 19:27:48'),
(5897, 'de', 'siteauditor', 'Maximum Pages', 'Maximale Seiten', '2011-07-07 19:27:48'),
(5898, 'de', 'siteauditor', 'No active projects found', 'Keine aktiven Projekte gefunden', '2011-07-07 19:27:48'),
(5899, 'de', 'siteauditor', 'Nofollow', 'NoFollow', '2011-07-07 19:27:48'),
(5900, 'de', 'siteauditor', 'Number of pages is greater than', 'Anzahl der Seiten ist hoeher als', '2011-07-07 19:27:48'),
(5901, 'de', 'siteauditor', 'Number of pages should be greater than', 'Anzahl der Seiten sollte hoeher sein als', '2011-07-07 19:27:48'),
(5902, 'de', 'siteauditor', 'Page Details', 'Seiten Details', '2011-07-07 19:27:48'),
(5903, 'de', 'siteauditor', 'Page Link', 'Seiten Link', '2011-07-07 19:27:48'),
(5904, 'de', 'siteauditor', 'Page Links', 'Seiten Links', '2011-07-07 19:27:48'),
(5905, 'de', 'siteauditor', 'Pages Found', 'Seiten gefunden', '2011-07-07 19:27:48'),
(5906, 'de', 'siteauditor', 'pressescapetostopexecution', '<b>ESC</b> druecken um abzubrechen', '2011-07-07 19:27:48'),
(5907, 'de', 'siteauditor', 'Project Summary', 'Projekt Zusammenfassung', '2011-07-07 19:27:48'),
(5908, 'de', 'siteauditor', 'Project Url', 'Projekt URL', '2011-07-07 19:27:48'),
(5909, 'de', 'siteauditor', 'projectalreadyexist', 'Projekt fuer diese Webseite ist bereits vorhanden', '2011-07-07 19:27:48'),
(5910, 'de', 'siteauditor', 'Recheck Pages', 'Seiten nochmals ueberpruefen', '2011-07-07 19:27:48'),
(5911, 'de', 'siteauditor', 'Report Summary', 'Bericht Zusammenfassung', '2011-07-07 19:27:48'),
(5912, 'de', 'siteauditor', 'Run Project', 'Projekt ausfuehren', '2011-07-07 19:27:48'),
(5913, 'de', 'siteauditor', 'should start with', 'sollte beginnen mit', '2011-07-07 19:27:48'),
(5914, 'de', 'siteauditor', 'Site Auditor Settings', 'Website-Doktor Einstellungen', '2011-07-07 19:27:48'),
(5915, 'de', 'siteauditor', 'Store all links found in a page', 'Alle gefundenen Links speichern', '2011-07-07 19:27:48'),
(5916, 'de', 'siteauditor', 'The page description length is not between', 'Die Laenge der Seiten-Beschreibung ist nicht zwischen', '2011-07-07 19:27:48'),
(5917, 'de', 'siteauditor', 'The page is brocken', 'Die Seite ist fehlerhaft', '2011-07-07 19:27:48'),
(5918, 'de', 'siteauditor', 'The page is having exellent number of backlinks in', 'Die Seite hat eine exzellente Anzahl an Links in', '2011-07-07 19:27:48'),
(5919, 'de', 'siteauditor', 'The page is having exellent pagerank', 'Die Seite hat einen exzellenten Pagerank', '2011-07-07 19:27:48'),
(5920, 'de', 'siteauditor', 'The page is having good number of backlinks in', 'Die Seite hat eine gute Anzahl an Backlinks in', '2011-07-07 19:27:48'),
(5921, 'de', 'siteauditor', 'The page is having good pagerank', 'Die Seite hat einen guten Pagerank', '2011-07-07 19:27:48'),
(5922, 'de', 'siteauditor', 'The page is having poor pagerank', 'Die Seite hat einen sehr niedrigen Pagerank', '2011-07-07 19:27:48'),
(5923, 'de', 'siteauditor', 'The page is having very good pagerank', 'Die Seite hat einen sehr guten Pagerank', '2011-07-07 19:27:48'),
(5924, 'de', 'siteauditor', 'The page is not having backlinks in', 'Die Seite hat keine Backlinks in', '2011-07-07 19:27:48'),
(5925, 'de', 'siteauditor', 'The page is not indexed in', 'Die Seite ist nicht indiziert in', '2011-07-07 19:27:48'),
(5926, 'de', 'siteauditor', 'The page keywords length is not between', 'Die Laenge der Keywords ist nicht zwischen', '2011-07-07 19:27:48'),
(5927, 'de', 'siteauditor', 'The page title length is not between', 'Die Laenge des Seiten-Titels ist nicht zwischen', '2011-07-07 19:27:48'),
(5928, 'de', 'siteauditor', 'The total number of links in page is greater than', 'Die Gesamtanzahl an Links ist hoeher als', '2011-07-07 19:27:48'),
(5929, 'de', 'siteauditor', 'to run project again if you stopped execution', 'um ein Projekt neu zu starten nach einem Abbruch', '2011-07-07 19:27:48'),
(5930, 'de', 'siteauditor', 'to view the reports', 'um die Berichte zu betrachten', '2011-07-07 19:27:48'),
(5931, 'de', 'siteauditor', 'Total Links', 'Links gesamt', '2011-07-07 19:27:48'),
(5932, 'de', 'siteauditor', 'totallinksgreaterallowed', 'Die Gesamtanzahl der Links ist hoeher als das erlaubte Maximum pro Projekt', '2011-07-07 19:27:48'),
(5933, 'el', 'home', 'Indexed', 'Καταχωρήθηκαν', '2011-07-08 02:16:51'),
(5934, 'el', 'keyword', 'Insert keywords separated with comma', 'Εισάγετε τις λέξεις κλειδιά, διαχωρισμένες με κόμμα.', '2016-01-27 08:02:49'),
(5935, 'el', 'label', 'Brocken', 'Σπασμένο', '2017-07-17 11:21:25'),
(5936, 'el', 'label', 'Comments', 'Σχόλια', '2017-07-17 11:21:25'),
(5937, 'el', 'label', 'Count', 'Καταμέτρηση', '2017-07-17 11:21:25'),
(5938, 'el', 'label', 'Exclude', 'Απόκλεισε', '2017-07-17 11:21:25'),
(5939, 'el', 'label', 'Include', 'Συμπερίλαβε', '2017-07-17 11:21:25'),
(5940, 'el', 'label', 'Project', 'Εργασία', '2017-07-17 11:21:25'),
(5941, 'el', 'label', 'Report Type', 'Τύπος αναφοράς', '2017-07-17 11:21:25'),
(5942, 'el', 'label', 'Score', 'Βαθμολογία', '2017-07-17 11:21:25'),
(5943, 'el', 'label', 'Total Results', 'Συνολικά αποτελέσματα', '2017-07-17 11:21:25'),
(5944, 'el', 'label', 'Updated', 'Αναβαθμίστηκε', '2017-07-17 11:21:25'),
(5945, 'el', 'label', 'View Reports', 'Προβολή αναφορών', '2017-07-17 11:21:25'),
(5946, 'el', 'panel', 'Edit Project', 'Επεξεργασία εργασίας', '2017-07-17 11:24:15'),
(5947, 'el', 'panel', 'New Project', 'Νέα εργασία', '2017-07-17 11:24:15'),
(5948, 'el', 'seotools', 'Auditor Projects', 'Εργασίες ελεγκτή ', '2017-07-17 11:26:22'),
(5949, 'el', 'seotools', 'Auditor Reports', 'Αναφορές ελεγκτή', '2017-07-17 11:26:22'),
(5950, 'el', 'seotools', 'Auditor Settings', 'Ρυθμίσεις ελεγκτή ', '2017-07-17 11:26:22'),
(5951, 'el', 'seotools', 'Import Project Links', 'Εισαγωγή συνδέσμων εργασίας', '2017-07-17 11:26:22'),
(5952, 'el', 'seotools', 'site-auditor', 'Ελεγκτής ιστοσελίδας', '2017-07-17 11:26:22'),
(5953, 'el', 'settings', 'Check for Updates', 'Έλεγχος για νέες εκδόσεις', '2017-07-18 06:10:58'),
(5954, 'el', 'settings', 'SA_CRAWL_DELAY_TIME', 'Καθυστέρηση ανιχνευτή ιστοτόπων, μεταξύ των σελίδων', '2017-07-18 06:10:58'),
(5955, 'el', 'settings', 'SA_MAX_NO_PAGES', 'Μέγιστος επιτρεπόμενος αριθμός σελίδων ανά ιστότοπο', '2017-07-18 06:10:58'),
(5956, 'el', 'settings', 'SP_API_KEY', 'Seo Panel API Key', '2017-07-18 06:10:58'),
(5957, 'el', 'settings', 'versionnotuptodatemsg', 'Η έκδοση του Seo Panel που χρησιμοποιείτε δεν είναι αναβαθμισμένη. <br>Παρακαλώ κατεβάστε την τελευταία έκδοση', '2017-07-18 06:10:58'),
(5958, 'el', 'settings', 'Your Seo Panel installation is up to date', 'Η έκδοση του Seo Panel είναι αναβαθμισμένη', '2017-07-18 06:10:58'),
(5959, 'el', 'siteauditor', 'Anchor', 'Σήμανση', '2017-07-18 06:05:38'),
(5960, 'el', 'siteauditor', 'anylinkcontainabovelinks', 'Όποιος από τους συνδέσμους περιλαμβάνει τους συνδέσμους από πάνω δεν θα περιλαμβάνεται στις αναφορές', '2017-07-18 06:05:38'),
(5961, 'el', 'siteauditor', 'anylinkcontainexcludesitemap', 'Όποιος από τους συνδέσμους περιλαμβάνει τους συνδέσμους από πάνω δεν θα περιλαμβάνεται στο sitemap', '2017-07-18 06:05:38'),
(5962, 'el', 'siteauditor', 'Check backlinks of pages', 'Ελέγξτε τα backlink των σελίδων', '2017-07-18 06:05:38'),
(5963, 'el', 'siteauditor', 'Check broken links in a page', 'Έλεγχος σπασμένων συνδέσμων σε σελίδα', '2017-07-18 06:05:38'),
(5964, 'el', 'siteauditor', 'Check google pagerank of pages', 'Έλεγχος Google pagerank των σελίδων', '2017-07-18 06:05:38'),
(5965, 'el', 'siteauditor', 'Check pages indexed or not', 'Έλεγχος καταχώρισης ή όχι των σελίδων', '2017-07-18 06:05:38'),
(5966, 'el', 'siteauditor', 'Check Score', 'Έλεγχος βαθμολογίας', '2017-07-18 06:05:38'),
(5967, 'el', 'siteauditor', 'checkborckenlinkwait', 'Ο έλεγχος των σπασμένων συνδέσμων θα αυξήσει τον χρόνο εκτέλεσης μιας εργασίας', '2017-07-18 06:05:38'),
(5968, 'el', 'siteauditor', 'Completed project execution', 'Ολοκληρωμένη εκτέλεση εργασίας', '2017-07-18 06:05:38'),
(5969, 'el', 'siteauditor', 'Crawled', 'Ανιχνεύθηκε', '2017-07-18 06:05:38'),
(5970, 'el', 'siteauditor', 'Crawled Pages', 'Σελίδες που ανιχνεύθηκαν', '2017-07-18 06:05:38'),
(5971, 'el', 'siteauditor', 'crawledsuccesssfullywaitfornext', 'Επιτυχής ανίχνευση! Περιμένετε για την ανίχνευση της επόμενης σελίδας για', '2017-07-18 06:05:38'),
(5972, 'el', 'siteauditor', 'Crawling Page', 'Ανίχνευση σελίδας', '2017-07-18 06:05:38'),
(5973, 'el', 'siteauditor', 'Duplicate Description', 'Διπλή περιγραφή', '2017-07-18 06:05:38'),
(5974, 'el', 'siteauditor', 'Duplicate Keywords', 'Διπλές λέξεις κλειδιά', '2017-07-18 06:05:38'),
(5975, 'el', 'siteauditor', 'Duplicate Title', 'Διπλός τίτλος', '2017-07-18 06:05:38'),
(5976, 'el', 'siteauditor', 'Exclude links', 'Μην συμπεριλάβετε τους συνδέσμους', '2017-07-18 06:05:38'),
(5977, 'el', 'siteauditor', 'Execute with cron', 'Εκτέλεση με cron', '2017-07-18 06:05:38'),
(5978, 'el', 'siteauditor', 'External', 'Εξωτερικά', '2017-07-18 06:05:38'),
(5979, 'el', 'siteauditor', 'External Links', 'Εξωτερικοί σύνδεσμοι', '2017-07-18 06:05:38'),
(5980, 'el', 'siteauditor', 'Import Project Links', 'Εισαγωγή συνδέσμων εργασίας', '2017-07-18 06:05:38'),
(5981, 'el', 'siteauditor', 'Insert links separated with comma', 'Εισαγωγή συνδέσμων διαχωρισμένοι με κόμμα', '2017-07-18 06:05:38'),
(5982, 'el', 'siteauditor', 'insertlinkssepcoma', 'Τοποθετήστε συνδέσμους διαχωρισμένους με κόμμα για να αποκλείσετε άπειρους συνδέσμους από τις αναφορές', '2017-07-18 06:05:38'),
(5983, 'el', 'siteauditor', 'Link Reports', 'Αναφορές συνδέσμων', '2017-07-18 06:05:38'),
(5984, 'el', 'siteauditor', 'Link Title', 'Τίτλος συνδέσμου', '2017-07-18 06:05:38'),
(5985, 'el', 'siteauditor', 'Maximum number of pages to be checked', 'Μέγιστος αριθμός σελίδων για έλεγχο', '2017-07-18 06:05:38'),
(5986, 'el', 'siteauditor', 'Maximum Pages', 'Μέγιστος αριθμός σελίδων', '2017-07-18 06:05:38'),
(5987, 'el', 'siteauditor', 'No active projects found', 'Δεν βρέθηκαν ενεργές εργασίες', '2017-07-18 06:05:38'),
(5988, 'el', 'siteauditor', 'Nofollow', 'Δεν ακολουθείται', '2017-07-18 06:05:38'),
(5989, 'el', 'siteauditor', 'Number of pages is greater than', 'Αριθμός των σελίδων μεγαλύτερες από', '2017-07-18 06:05:38'),
(5990, 'el', 'siteauditor', 'Number of pages should be greater than', 'Αριθμός των σελίδων που έπρεπε να είναι μεγαλύτερες από', '2017-07-18 06:05:38'),
(5991, 'el', 'siteauditor', 'Page Details', 'Λεπτομέρειες σελίδας', '2017-07-18 06:05:38'),
(5992, 'el', 'siteauditor', 'Page Link', 'Σύνδεσμος σελίδας', '2017-07-18 06:05:38'),
(5993, 'el', 'siteauditor', 'Page Links', 'Σύνδεσμοι σελίδας', '2017-07-18 06:05:38'),
(5994, 'el', 'siteauditor', 'Pages Found', 'Σελίδες που βρέθηκαν', '2017-07-18 06:05:38'),
(5995, 'el', 'siteauditor', 'pressescapetostopexecution', 'Πατήστε το πλήκτρο <b>escape</b> της εκτέλεσης της διεργασίας', '2017-07-18 06:05:38'),
(5996, 'el', 'siteauditor', 'Project Summary', 'Σύνοψη εργασίας', '2017-07-18 06:05:38'),
(5997, 'el', 'siteauditor', 'Project Url', 'URL εργασίας', '2017-07-18 06:05:38'),
(5998, 'el', 'siteauditor', 'projectalreadyexist', 'Η εργασία για αυτόν τον ιστότοπο ήδη υπάρχει', '2017-07-18 06:05:38'),
(5999, 'el', 'siteauditor', 'Recheck Pages', 'Επανέλεγχος σελίδων', '2017-07-18 06:05:38'),
(6000, 'el', 'siteauditor', 'Report Summary', 'Σύνοψη αναφοράς', '2017-07-18 06:05:38'),
(6001, 'el', 'siteauditor', 'Run Project', 'Εκτέλεση εργασίας', '2017-07-18 06:05:38'),
(6002, 'el', 'siteauditor', 'should start with', 'πρέπει να ξεκινάει με', '2017-07-18 06:05:38'),
(6003, 'el', 'siteauditor', 'Site Auditor Settings', 'Ρυθμίσεις του Ελεγκτή ιστοτόπου', '2017-07-18 06:05:38'),
(6004, 'el', 'siteauditor', 'Store all links found in a page', 'Αποθήκευση όλων των συνδέσμων που βρίσκονται σε μια σελίδα', '2017-07-18 06:05:38'),
(6005, 'el', 'siteauditor', 'The page description length is not between', 'Η περιγραφή της σελίδας δεν είναι ανάμεσα', '2017-07-18 06:05:38'),
(6006, 'el', 'siteauditor', 'The page is brocken', 'Η σελίδα είναι σπασμένη', '2017-07-18 06:05:38'),
(6007, 'el', 'siteauditor', 'The page is having exellent number of backlinks in', 'Η σελίδα έχει άριστο αριθμό backlink σε', '2017-07-18 06:05:38'),
(6008, 'el', 'siteauditor', 'The page is having exellent pagerank', 'Η σελίδα έχει άριστο pagerank', '2017-07-18 06:05:38'),
(6009, 'el', 'siteauditor', 'The page is having good number of backlinks in', 'Η σελίδα έχει καλό αριθμό backlinks σε', '2017-07-18 06:05:38'),
(6010, 'el', 'siteauditor', 'The page is having good pagerank', 'Η σελίδα έχει καλό pagerank', '2017-07-18 06:05:38'),
(6011, 'el', 'siteauditor', 'The page is having poor pagerank', 'Η σελίδα έχει χαμηλό pagerank', '2017-07-18 06:05:38');
INSERT INTO `texts` (`id`, `lang_code`, `category`, `label`, `content`, `changed`) VALUES
(6012, 'el', 'siteauditor', 'The page is having very good pagerank', 'Η σελίδα έχει πολύ καλό pagerank', '2017-07-18 06:05:38'),
(6013, 'el', 'siteauditor', 'The page is not having backlinks in', 'Η σελίδα δεν έχει backlinks σε', '2017-07-18 06:05:38'),
(6014, 'el', 'siteauditor', 'The page is not indexed in', 'H σελίδα δεν είναι καταχωρημένη σε', '2017-07-18 06:05:38'),
(6015, 'el', 'siteauditor', 'The page keywords length is not between', 'Το μήκος των λέξεων κλειδιών της σελίδα δεν είναι ανάμεσα σε', '2017-07-18 06:05:38'),
(6016, 'el', 'siteauditor', 'The page title length is not between', 'Το μήκος του τίτλου της σελίδας δεν είναι ανάμεσα σε', '2017-07-18 06:05:38'),
(6017, 'el', 'siteauditor', 'The total number of links in page is greater than', 'Ο συνολικός αριθμός των συνδέσμων στην σελίδα είναι μεγαλύτερος από', '2017-07-18 06:05:38'),
(6018, 'el', 'siteauditor', 'to run project again if you stopped execution', 'για να εκκινήσετε την εργασία ξανά αν σταματήσατε την εκτέλεση της', '2017-07-18 06:05:38'),
(6019, 'el', 'siteauditor', 'to view the reports', 'για να δείτε τις αναφορές', '2017-07-18 06:05:38'),
(6020, 'el', 'siteauditor', 'Total Links', 'Συνολικοί Σύνδεσμοι', '2017-07-18 06:05:38'),
(6021, 'el', 'siteauditor', 'totallinksgreaterallowed', 'Οι συνολικοί σύνδεσμοι θα είναι μεγαλύτεροι από το μέγιστο αριθμό συνδέσμων που επιτρέπονται στην εργασία', '2017-07-18 06:05:38'),
(6022, 'en', 'directory', 'Reciprocal Link', 'Reciprocal Link', '2011-07-08 08:09:43'),
(6023, 'el', 'directory', 'Reciprocal Link', 'Ανταποδοτικοί σύνδεσμοι', '2014-01-20 11:07:08'),
(6024, 'tr', 'directory', 'Reciprocal Link', 'Karşılıklı Link', '2012-11-11 08:13:26'),
(6025, 'tr', 'home', 'Indexed', 'İndexlendi', '2017-02-04 21:23:57'),
(6026, 'tr', 'keyword', 'Insert keywords separated with comma', 'Anahtar kelimeleri virgül ile ayırarak giriniz', '2017-02-04 20:48:33'),
(6027, 'tr', 'label', 'Brocken', 'Kırık', '2012-11-11 08:14:34'),
(6028, 'tr', 'label', 'Comments', 'Yorumlar', '2012-11-11 08:14:34'),
(6029, 'tr', 'label', 'Count', 'Sayı', '2012-11-11 08:14:34'),
(6030, 'tr', 'label', 'Exclude', 'Çıkar', '2012-11-11 08:14:34'),
(6031, 'tr', 'label', 'Include', 'İçer', '2012-11-11 08:14:34'),
(6032, 'tr', 'label', 'Project', 'Proje', '2012-11-11 08:14:34'),
(6033, 'tr', 'label', 'Report Type', 'Rapor Biçini', '2012-11-11 08:14:34'),
(6034, 'tr', 'label', 'Score', 'Skor', '2012-11-11 08:14:34'),
(6035, 'tr', 'label', 'Total Results', 'Toplam sonuç', '2012-11-11 08:14:34'),
(6036, 'tr', 'label', 'Updated', 'Güncelle', '2012-11-11 08:14:34'),
(6037, 'tr', 'label', 'View Reports', 'Raporları Görüntüle', '2012-11-11 08:14:34'),
(6038, 'pt', 'directory', 'Reciprocal Link', 'Link reciproco', '2012-11-10 20:59:13'),
(6039, 'pt', 'home', 'Indexed', 'Indexar', '2011-07-10 09:41:24'),
(6040, 'pt', 'keyword', 'Insert keywords separated with comma', 'Insira as palavras(keywords) entre virgulas', '2016-01-17 19:11:49'),
(6041, 'pt', 'label', 'Brocken', 'Partido', '2016-01-17 19:12:15'),
(6042, 'pt', 'label', 'Comments', 'Comentario', '2016-01-17 19:12:15'),
(6043, 'pt', 'label', 'Count', 'Contagem', '2016-01-17 19:12:15'),
(6044, 'pt', 'label', 'Exclude', 'Excluir', '2016-01-17 19:12:15'),
(6045, 'pt', 'label', 'Include', 'Incluir', '2016-01-17 19:12:15'),
(6046, 'pt', 'label', 'Project', 'Projecto', '2016-01-17 19:12:15'),
(6047, 'pt', 'label', 'Report Type', 'Reportar Tipo', '2016-01-17 19:12:15'),
(6048, 'pt', 'label', 'Score', 'Pontuação', '2016-01-17 19:12:15'),
(6049, 'pt', 'label', 'Total Results', 'Total de resultados', '2016-01-17 19:12:15'),
(6050, 'pt', 'label', 'Updated', 'Modificado', '2016-01-17 19:12:15'),
(6051, 'pt', 'label', 'View Reports', 'Ver Relatórios', '2016-01-17 19:12:15'),
(6052, 'pt', 'panel', 'Edit Project', 'Editar Projecto', '2016-01-17 19:16:33'),
(6053, 'pt', 'panel', 'New Project', 'Novo projecto', '2016-01-17 19:16:33'),
(6054, 'pt', 'seotools', 'Auditor Projects', 'Auditar Projectos', '2011-07-10 09:45:40'),
(6055, 'pt', 'seotools', 'Auditor Reports', 'Auditar Relatórios', '2011-07-10 09:45:40'),
(6056, 'pt', 'seotools', 'Auditor Settings', 'Auditar configurações', '2011-07-10 09:45:40'),
(6057, 'pt', 'seotools', 'Import Project Links', 'Importar Links de projectos', '2011-07-10 09:45:40'),
(6058, 'pt', 'seotools', 'site-auditor', 'Auditar Site', '2011-07-10 09:45:40'),
(6059, 'pt', 'settings', 'Check for Updates', 'Verificar Actualizações', '2016-01-17 19:16:12'),
(6060, 'pt', 'settings', 'SA_CRAWL_DELAY_TIME', 'Atraso entre páginas do auditar site', '2016-01-17 19:16:12'),
(6061, 'pt', 'settings', 'SA_MAX_NO_PAGES', 'Numero de paginas permitidas por sites', '2016-01-17 19:16:12'),
(6062, 'pt', 'settings', 'SP_API_KEY', 'API Key do Seo Panel', '2016-01-17 19:16:12'),
(6063, 'pt', 'settings', 'versionnotuptodatemsg', 'A instalação do seu Seo Panel não está actualizada. <br> faça o download da nova versão', '2016-01-17 19:16:12'),
(6064, 'pt', 'settings', 'Your Seo Panel installation is up to date', 'Tem o Seo Panel Actualizado', '2016-01-17 19:16:12'),
(6065, 'tr', 'panel', 'Edit Project', 'Projeyi Düzenle', '2017-02-04 20:50:50'),
(6066, 'tr', 'panel', 'New Project', 'Yeni Proje', '2017-02-04 20:50:50'),
(6067, 'fr', 'siteauditor', 'Anchor', 'Ancre', '2016-12-09 18:03:26'),
(6068, 'fr', 'siteauditor', 'anylinkcontainabovelinks', 'Tous les liens figurant ci-dessus seront exclus des rapports', '2016-12-09 18:03:26'),
(6069, 'fr', 'siteauditor', 'anylinkcontainexcludesitemap', 'Tous les liens figurant ci-dessus seront exclus du sitemap', '2016-12-09 18:03:26'),
(6070, 'fr', 'siteauditor', 'Check backlinks of pages', 'Vérifier les liens retour des pages', '2016-12-09 18:03:26'),
(6071, 'fr', 'siteauditor', 'Check broken links in a page', 'Vérifier les liens cassés d''une page', '2016-12-09 18:03:26'),
(6072, 'fr', 'siteauditor', 'Check google pagerank of pages', 'Vérifier le pagerank Google des pages', '2016-12-09 18:03:26'),
(6073, 'fr', 'siteauditor', 'Check pages indexed or not', 'Vérifier si les pages sont indexées ou non', '2016-12-09 18:03:26'),
(6074, 'fr', 'siteauditor', 'Check Score', 'Vérifier le score', '2016-12-09 18:03:26'),
(6075, 'fr', 'siteauditor', 'checkborckenlinkwait', 'La vérification des liens cassés accroit le temps d''exécution du projet', '2016-12-09 18:03:26'),
(6076, 'fr', 'siteauditor', 'Completed project execution', 'Projet terminé', '2016-12-09 18:03:26'),
(6077, 'fr', 'siteauditor', 'Crawled', 'Exploré', '2016-12-09 18:03:26'),
(6078, 'fr', 'siteauditor', 'Crawled Pages', 'Pages explorées', '2016-12-09 18:03:26'),
(6079, 'fr', 'siteauditor', 'crawledsuccesssfullywaitfornext', 'exploré avec succès ! En attente d''exploration de la prochaine page de', '2016-12-09 18:03:26'),
(6080, 'fr', 'siteauditor', 'Crawling Page', 'Page en exploration', '2016-12-09 18:03:26'),
(6081, 'fr', 'siteauditor', 'Duplicate Description', 'Description dupliquée', '2016-12-09 18:03:26'),
(6082, 'fr', 'siteauditor', 'Duplicate Keywords', 'Mots clés dupliqués', '2016-12-09 18:03:26'),
(6083, 'fr', 'siteauditor', 'Duplicate Title', 'Titre dupliqué', '2016-12-09 18:03:26'),
(6084, 'fr', 'siteauditor', 'Exclude links', 'Liens à exclure', '2016-12-09 18:03:26'),
(6085, 'fr', 'siteauditor', 'Execute with cron', 'Exécuter avec cron', '2016-12-09 18:03:26'),
(6086, 'fr', 'siteauditor', 'External', 'Externe', '2016-12-09 18:03:26'),
(6087, 'fr', 'siteauditor', 'External Links', 'Liens externes', '2016-12-09 18:03:26'),
(6088, 'fr', 'siteauditor', 'Import Project Links', 'Importer les liens', '2016-12-09 18:03:26'),
(6089, 'fr', 'siteauditor', 'Insert links separated with comma', 'Entrez les liens en les séparant par des virgules', '2016-12-09 18:03:26'),
(6090, 'fr', 'siteauditor', 'insertlinkssepcoma', 'Entrez les liens (en les séparant par des virgules) pour éviter des liens sans fin dans les rapports', '2016-12-09 18:03:26'),
(6091, 'fr', 'siteauditor', 'Link Reports', 'Rapports sur les liens', '2016-12-09 18:03:26'),
(6092, 'fr', 'siteauditor', 'Link Title', 'Titre du lien', '2016-12-09 18:03:26'),
(6093, 'fr', 'siteauditor', 'Maximum number of pages to be checked', 'Nombre maximum de pages à traiter', '2016-12-09 18:03:26'),
(6094, 'fr', 'siteauditor', 'Maximum Pages', 'Pages maximum', '2016-12-09 18:03:26'),
(6095, 'fr', 'siteauditor', 'No active projects found', 'Aucun projet actif', '2016-12-09 18:03:26'),
(6096, 'fr', 'siteauditor', 'Nofollow', 'Nofollow', '2016-12-09 18:03:26'),
(6097, 'fr', 'siteauditor', 'Number of pages is greater than', 'Le nombre de pages est plus grand que ', '2016-12-09 18:03:26'),
(6098, 'fr', 'siteauditor', 'Number of pages should be greater than', 'Le nombre de pages devrait être supérieur à ', '2016-12-09 18:03:26'),
(6099, 'fr', 'siteauditor', 'Page Details', 'Détails de la page', '2016-12-09 18:03:26'),
(6100, 'fr', 'siteauditor', 'Page Link', 'Lien de la page', '2016-12-09 18:03:26'),
(6101, 'fr', 'siteauditor', 'Page Links', 'Liens de la page', '2016-12-09 18:03:26'),
(6102, 'fr', 'siteauditor', 'Pages Found', 'Pages trouvées', '2016-12-09 18:03:26'),
(6103, 'fr', 'siteauditor', 'pressescapetostopexecution', 'Appuyez sur la touche <b>Echap/Esc</b> pour arrêter l''exécution du script', '2016-12-09 18:03:26'),
(6104, 'fr', 'siteauditor', 'Project Summary', 'Résumé du projet', '2016-12-09 18:03:26'),
(6105, 'fr', 'siteauditor', 'Project Url', 'URL du projet', '2016-12-09 18:03:26'),
(6106, 'fr', 'siteauditor', 'projectalreadyexist', 'Un projet existe déjà pour ce site web', '2016-12-09 18:03:26'),
(6107, 'fr', 'siteauditor', 'Recheck Pages', 'Revérifier les pages', '2016-12-09 18:03:26'),
(6108, 'fr', 'siteauditor', 'Report Summary', 'Rapport résumé', '2016-12-09 18:03:26'),
(6109, 'fr', 'siteauditor', 'Run Project', 'Lancer le projet', '2016-12-09 18:03:26'),
(6110, 'fr', 'siteauditor', 'should start with', 'devrait commencer par', '2016-12-09 18:03:26'),
(6111, 'fr', 'siteauditor', 'Site Auditor Settings', 'Paramètres du vérificateur de site', '2016-12-09 18:03:26'),
(6112, 'fr', 'siteauditor', 'Store all links found in a page', 'Enregistre tous les liens de la page', '2016-12-09 18:03:26'),
(6113, 'fr', 'siteauditor', 'The page description length is not between', 'La description de la page n''est pas entre ', '2016-12-09 18:03:26'),
(6114, 'fr', 'siteauditor', 'The page is brocken', 'La page est cassée', '2016-12-09 18:03:26'),
(6115, 'fr', 'siteauditor', 'The page is having exellent number of backlinks in', 'La page a un très bon nombre de liens retour pour ', '2016-12-09 18:03:26'),
(6116, 'fr', 'siteauditor', 'The page is having exellent pagerank', 'La page a un rang excellent', '2016-12-09 18:03:26'),
(6117, 'fr', 'siteauditor', 'The page is having good number of backlinks in', 'La page a un bon nombre de liens retour pour ', '2016-12-09 18:03:26'),
(6118, 'fr', 'siteauditor', 'The page is having good pagerank', 'La page a un bon pagerank ', '2016-12-09 18:03:26'),
(6119, 'fr', 'siteauditor', 'The page is having poor pagerank', 'La page a un pagerank faible', '2016-12-09 18:03:26'),
(6120, 'fr', 'siteauditor', 'The page is having very good pagerank', 'La page a un très bon pagerank', '2016-12-09 18:03:26'),
(6121, 'fr', 'siteauditor', 'The page is not having backlinks in', 'La page n''a pas de liens retour pour ', '2016-12-09 18:03:26'),
(6122, 'fr', 'siteauditor', 'The page is not indexed in', 'La page n''est pas indexé dans ', '2016-12-09 18:03:26'),
(6123, 'fr', 'siteauditor', 'The page keywords length is not between', 'La longueur des mots clés de la page n''est pas entre ', '2016-12-09 18:03:26'),
(6124, 'fr', 'siteauditor', 'The page title length is not between', 'La longueur du titre de la page n''est pas entre ', '2016-12-09 18:03:26'),
(6125, 'fr', 'siteauditor', 'The total number of links in page is greater than', 'Le nombre total de liens dans la page est supérieur à ', '2016-12-09 18:03:26'),
(6126, 'fr', 'siteauditor', 'to run project again if you stopped execution', 'pour lancer le projet de nouveau si vous l''avez arrêté', '2016-12-09 18:03:26'),
(6127, 'fr', 'siteauditor', 'to view the reports', 'pour voir les rapports', '2016-12-09 18:03:26'),
(6128, 'fr', 'siteauditor', 'Total Links', 'Total liens', '2016-12-09 18:03:26'),
(6129, 'fr', 'siteauditor', 'totallinksgreaterallowed', 'Le nombre de liens au total sera supérieur au maximum autorisé sur ce projet.', '2016-12-09 18:03:26'),
(6130, 'fr', 'directory', 'Reciprocal Link', 'Lien réciproque', '2012-11-10 20:37:55'),
(6131, 'tr', 'seotools', 'Auditor Projects', 'Denetçi Projeler', '2011-07-10 10:12:15'),
(6132, 'tr', 'seotools', 'Auditor Reports', 'Denetçi Raporlar', '2011-07-10 10:12:15'),
(6133, 'tr', 'seotools', 'Auditor Settings', 'Denetçi Ayarları', '2011-07-10 10:12:15'),
(6134, 'tr', 'seotools', 'Import Project Links', 'Proje linklerini İçe aktar (import)', '2011-07-10 10:12:15'),
(6135, 'tr', 'seotools', 'site-auditor', 'Site Denetçisi', '2011-07-10 10:12:15'),
(6136, 'fr', 'home', 'Indexed', 'Indexé', '2011-07-10 10:26:55'),
(6144, 'fr', 'label', 'Brocken', 'Cassé(s)', '2016-12-09 18:11:17'),
(6145, 'fr', 'label', 'Comments', 'Commentaires', '2016-12-09 18:11:17'),
(6146, 'fr', 'label', 'Count', 'Nombre', '2016-12-09 18:11:17'),
(6147, 'fr', 'label', 'Exclude', 'Exclure', '2016-12-09 18:11:17'),
(6148, 'fr', 'label', 'Include', 'Inclure', '2016-12-09 18:11:17'),
(6137, 'fr', 'keyword', 'Insert keywords separated with comma', 'Indiquer les mots-clés, séparés par des virgules', '2016-01-02 18:07:27'),
(6138, 'tr', 'settings', 'Check for Updates', 'Güncellemeleri Kontol Et', '2017-02-04 13:45:16'),
(6139, 'tr', 'settings', 'SA_CRAWL_DELAY_TIME', 'Her sayfa arasındaki site denetçisi yavaş ilerlemesi', '2017-02-04 13:45:16'),
(6140, 'tr', 'settings', 'SA_MAX_NO_PAGES', 'Bir site için maksimum izin verilen sayfa sayısı', '2017-02-04 13:45:16'),
(6141, 'tr', 'settings', 'SP_API_KEY', 'Seo Panel API Key', '2017-02-04 13:45:16'),
(6142, 'tr', 'settings', 'versionnotuptodatemsg', 'Seo Panel yüklemeniz güncel değil. <br>Lütfen, yeni versiyonu indiriniz', '2017-02-04 13:45:16'),
(6143, 'tr', 'settings', 'Your Seo Panel installation is up to date', 'Seo Panel yüklemeniz güncel.', '2017-02-04 13:45:16'),
(6149, 'fr', 'label', 'Project', 'Projet', '2016-12-09 18:11:17'),
(6150, 'fr', 'label', 'Report Type', 'Type de rapport', '2016-12-09 18:11:17'),
(6151, 'fr', 'label', 'Score', 'Score', '2016-12-09 18:11:17'),
(6152, 'fr', 'label', 'Total Results', 'Total', '2016-12-09 18:11:17'),
(6153, 'fr', 'label', 'Updated', 'Mis à jour', '2016-12-09 18:11:17'),
(6154, 'fr', 'label', 'View Reports', 'Voir les rapports', '2016-12-09 18:11:17'),
(6155, 'fr', 'panel', 'Edit Project', 'Editer le projet', '2016-12-09 18:10:57'),
(6156, 'fr', 'panel', 'New Project', 'Nouveau projet', '2016-12-09 18:10:57'),
(6157, 'fr', 'seotools', 'Auditor Projects', 'Projets du Vérificateur de site', '2011-07-10 10:50:35'),
(6158, 'fr', 'seotools', 'Auditor Reports', 'Rapports du Vérificateur de site', '2011-07-10 10:50:35'),
(6159, 'fr', 'seotools', 'Auditor Settings', 'Paramètres du Vérificateur de site', '2011-07-10 10:50:35'),
(6160, 'fr', 'seotools', 'Import Project Links', 'Importer les liens du projet', '2011-07-10 10:50:35'),
(6161, 'fr', 'seotools', 'site-auditor', 'Vérificateur de site', '2011-07-10 10:50:35'),
(6162, 'fr', 'settings', 'Check for Updates', 'Vérifier les mises à jour', '2016-12-09 18:04:37'),
(6163, 'fr', 'settings', 'SA_CRAWL_DELAY_TIME', 'Délai d''exploration entre chaque page pour le Vérificateur de site', '2016-12-09 18:04:37'),
(6164, 'fr', 'settings', 'SA_MAX_NO_PAGES', 'Nombre maximum de pages autorisées par site web', '2016-12-09 18:04:37'),
(6165, 'fr', 'settings', 'SP_API_KEY', 'Clé API SeoPanel', '2016-12-09 18:04:37'),
(6166, 'fr', 'settings', 'versionnotuptodatemsg', 'Votre installation de Seo Panel n''est plus à jour.<br/>Vous devriez télécharger la dernière version et effectuer la mise à jour.\r\n', '2016-12-09 18:04:37'),
(6167, 'fr', 'settings', 'Your Seo Panel installation is up to date', 'Votre installation Seo Panel est à jour.', '2016-12-09 18:04:37'),
(6168, 'it', 'directory', 'Reciprocal Link', 'Link reciproco', '2012-11-08 19:50:02'),
(6169, 'it', 'home', 'Indexed', 'Indicizzati', '2011-07-10 20:10:02'),
(6170, 'it', 'keyword', 'Insert keywords separated with comma', 'Inserisci le keywords separandole con una virgola', '2016-12-09 09:18:13'),
(6171, 'it', 'label', 'Brocken', 'Rotto', '2016-12-09 09:18:33'),
(6172, 'it', 'label', 'Comments', 'Commenti', '2016-12-09 09:18:33'),
(6173, 'it', 'label', 'Count', 'Conteggio', '2016-12-09 09:18:33'),
(6174, 'it', 'label', 'Exclude', 'Escludi', '2016-12-09 09:18:33'),
(6175, 'it', 'label', 'Include', 'Includi', '2016-12-09 09:18:33'),
(6176, 'it', 'label', 'Project', 'Progetto', '2016-12-09 09:18:33'),
(6177, 'it', 'label', 'Report Type', 'Riporta tipologia', '2016-12-09 09:18:33'),
(6178, 'it', 'label', 'Score', 'Punteggio', '2016-12-09 09:18:33'),
(6179, 'it', 'label', 'Total Results', 'Risultati totali', '2016-12-09 09:18:33'),
(6180, 'it', 'label', 'Updated', 'Aggiornato', '2016-12-09 09:18:33'),
(6181, 'it', 'label', 'View Reports', 'Visualizza report', '2016-12-09 09:18:33'),
(6182, 'it', 'panel', 'Edit Project', 'Modifica progetto', '2016-12-09 09:19:55'),
(6183, 'it', 'panel', 'New Project', 'Nuovo progetto', '2016-12-09 09:19:55'),
(6184, 'it', 'seotools', 'Auditor Projects', 'Revisore progetti', '2011-07-10 20:17:33'),
(6185, 'it', 'seotools', 'Auditor Reports', 'Revisore report', '2011-07-10 20:17:34'),
(6186, 'it', 'seotools', 'Auditor Settings', 'Revisore impostazioni', '2011-07-10 20:17:34'),
(6187, 'it', 'seotools', 'Import Project Links', 'Importa link progetto', '2011-07-10 20:17:34'),
(6188, 'it', 'seotools', 'site-auditor', 'Revisore sito', '2011-07-10 20:17:34'),
(6189, 'it', 'settings', 'Check for Updates', 'Controlla aggiornamenti.', '2016-12-09 09:21:50'),
(6190, 'it', 'settings', 'SA_CRAWL_DELAY_TIME', 'Ritardo controllo sito da parte del crawl tra ogni pagina.', '2016-12-09 09:21:50'),
(6191, 'it', 'settings', 'SA_MAX_NO_PAGES', 'Massimo numero di pagine permesse per sito.', '2016-12-09 09:21:50'),
(6192, 'it', 'settings', 'SP_API_KEY', 'API KEY del Seo Panel.', '2016-12-09 09:21:50'),
(6193, 'it', 'settings', 'versionnotuptodatemsg', 'La tua attuale versione del Seo Panel non risulta essere aggiornata. <br>Aggiornalo alla nuova versione.', '2016-12-09 09:21:50'),
(6194, 'it', 'settings', 'Your Seo Panel installation is up to date', 'Il tuo Seo Panel risulta attualmente aggiornato.', '2016-12-09 09:21:50'),
(6195, 'it', 'siteauditor', 'Anchor', 'Anchor', '2016-12-09 09:23:32'),
(6196, 'it', 'siteauditor', 'anylinkcontainabovelinks', 'Tutti i link contenuti nei link presenti sopra saranno esclusi dai reports', '2016-12-09 09:23:32'),
(6197, 'it', 'siteauditor', 'anylinkcontainexcludesitemap', 'Tutti i link contenuti nei link presenti sopra saranno esclusi dalla sitemap', '2016-12-09 09:23:32'),
(6198, 'it', 'siteauditor', 'Check backlinks of pages', 'Controlla backlinks delle pagine', '2016-12-09 09:23:32'),
(6199, 'it', 'siteauditor', 'Check broken links in a page', 'Controlla i link rotti nella pagina', '2016-12-09 09:23:32'),
(6200, 'it', 'siteauditor', 'Check google pagerank of pages', 'Controlla il page rank di google per la pagina', '2016-12-09 09:23:32'),
(6201, 'it', 'siteauditor', 'Check pages indexed or not', 'Controlla se la pagina è nell''indice di ricerca o meno', '2016-12-09 09:23:32'),
(6202, 'it', 'siteauditor', 'Check Score', 'Verifica punteggio', '2016-12-09 09:23:32'),
(6203, 'it', 'siteauditor', 'checkborckenlinkwait', 'Verifica i link rotti che incrementano il tempo di esecuzione del progetto', '2016-12-09 09:23:32'),
(6204, 'it', 'siteauditor', 'Completed project execution', 'Esecuzione progetto completato', '2016-12-09 09:23:32'),
(6205, 'it', 'siteauditor', 'Crawled', 'Catturato', '2016-12-09 09:23:32'),
(6206, 'it', 'siteauditor', 'Crawled Pages', 'Pagine catturate', '2016-12-09 09:23:32'),
(6207, 'it', 'siteauditor', 'crawledsuccesssfullywaitfornext', 'Cattura effettuata con successo! Attendi perla cattura della prossima pagina.', '2016-12-09 09:23:32'),
(6208, 'it', 'siteauditor', 'Crawling Page', 'Cattura pagina', '2016-12-09 09:23:32'),
(6209, 'it', 'siteauditor', 'Duplicate Description', 'Descrizione duplicata', '2016-12-09 09:23:32'),
(6210, 'it', 'siteauditor', 'Duplicate Keywords', 'Keywords duplicate', '2016-12-09 09:23:32'),
(6211, 'it', 'siteauditor', 'Duplicate Title', 'Titoli duplicati', '2016-12-09 09:23:32'),
(6212, 'it', 'siteauditor', 'Exclude links', 'Escludi link', '2016-12-09 09:23:32'),
(6213, 'it', 'siteauditor', 'Execute with cron', 'Esegui con cron', '2016-12-09 09:23:32'),
(6214, 'it', 'siteauditor', 'External', 'Esterno', '2016-12-09 09:23:32'),
(6215, 'it', 'siteauditor', 'External Links', 'Link esterni', '2016-12-09 09:23:32'),
(6216, 'it', 'siteauditor', 'Import Project Links', 'Importa progetto link', '2016-12-09 09:23:32'),
(6217, 'it', 'siteauditor', 'Insert links separated with comma', 'Inserisci link separandoli con una virgola', '2016-12-09 09:23:32'),
(6218, 'it', 'siteauditor', 'insertlinkssepcoma', 'Inserisci link separandoli con una virgola per escludere link infiniti nei report', '2016-12-09 09:23:32'),
(6219, 'it', 'siteauditor', 'Link Reports', 'Report link', '2016-12-09 09:23:32'),
(6220, 'it', 'siteauditor', 'Link Title', 'Titolilink', '2016-12-09 09:23:32'),
(6221, 'it', 'siteauditor', 'Maximum number of pages to be checked', 'Massimo numero di pagine da controllare', '2016-12-09 09:23:32'),
(6222, 'it', 'siteauditor', 'Maximum Pages', 'Massimo pagine', '2016-12-09 09:23:32'),
(6223, 'it', 'siteauditor', 'No active projects found', 'Nessun progetto attivo trovato', '2016-12-09 09:23:32'),
(6224, 'it', 'siteauditor', 'Nofollow', 'Nofollow', '2016-12-09 09:23:32'),
(6225, 'it', 'siteauditor', 'Number of pages is greater than', 'Il numero di pagine è più grande di', '2016-12-09 09:23:32'),
(6226, 'it', 'siteauditor', 'Number of pages should be greater than', 'Il numero di pagine dovrebbe essere più grande di', '2016-12-09 09:23:32'),
(6227, 'it', 'siteauditor', 'Page Details', 'Dettagli pagina', '2016-12-09 09:23:32'),
(6228, 'it', 'siteauditor', 'Page Link', 'Link pagina', '2016-12-09 09:23:32'),
(6229, 'it', 'siteauditor', 'Page Links', 'Link pagina', '2016-12-09 09:23:32'),
(6230, 'it', 'siteauditor', 'Pages Found', 'Pagine trovate', '2016-12-09 09:23:32'),
(6231, 'it', 'siteauditor', 'pressescapetostopexecution', 'Premi<b>esc</b> per bloccare l''esecuzione dello script', '2016-12-09 09:23:32'),
(6232, 'it', 'siteauditor', 'Project Summary', 'Sommario progetto', '2016-12-09 09:23:32'),
(6233, 'it', 'siteauditor', 'Project Url', 'Url progetto', '2016-12-09 09:23:32'),
(6234, 'it', 'siteauditor', 'projectalreadyexist', 'Il progetto per questo sito web esiste già', '2016-12-09 09:23:32'),
(6235, 'it', 'siteauditor', 'Recheck Pages', 'Ricontrolla pagine', '2016-12-09 09:23:32'),
(6236, 'it', 'siteauditor', 'Report Summary', 'Report sommario', '2016-12-09 09:23:32'),
(6237, 'it', 'siteauditor', 'Run Project', 'Avvia progetto', '2016-12-09 09:23:32'),
(6238, 'it', 'siteauditor', 'should start with', 'dovrebbe iniziare con', '2016-12-09 09:23:32'),
(6239, 'it', 'siteauditor', 'Site Auditor Settings', 'Impostazioni sito controllore', '2016-12-09 09:23:32'),
(6240, 'it', 'siteauditor', 'Store all links found in a page', 'Memorizza tutti i link presenti nella pagina', '2016-12-09 09:23:32'),
(6241, 'it', 'siteauditor', 'The page description length is not between', 'La lunghezza della descrizione della pagina non è tra', '2016-12-09 09:23:32'),
(6242, 'it', 'siteauditor', 'The page is brocken', 'La pagina è rotta', '2016-12-09 09:23:32'),
(6243, 'it', 'siteauditor', 'The page is having exellent number of backlinks in', 'La pagina ha un numero eccellente di backlink  da', '2016-12-09 09:23:32'),
(6244, 'it', 'siteauditor', 'The page is having exellent pagerank', 'La pagina ha un eccellente pagerank', '2016-12-09 09:23:32'),
(6245, 'it', 'siteauditor', 'The page is having good number of backlinks in', 'La pagina ha un buon numero di backlink da', '2016-12-09 09:23:32'),
(6246, 'it', 'siteauditor', 'The page is having good pagerank', 'La pagina ha un buon pagerank', '2016-12-09 09:23:32'),
(6247, 'it', 'siteauditor', 'The page is having poor pagerank', 'La pagina ha un basso pagerank', '2016-12-09 09:23:32'),
(6248, 'it', 'siteauditor', 'The page is having very good pagerank', 'La pagina ha un buonissimo pagerank', '2016-12-09 09:23:32'),
(6249, 'it', 'siteauditor', 'The page is not having backlinks in', 'La pagina non ha backlinks da', '2016-12-09 09:23:32'),
(6250, 'it', 'siteauditor', 'The page is not indexed in', 'La pagina non è nell''index di', '2016-12-09 09:23:32'),
(6251, 'it', 'siteauditor', 'The page keywords length is not between', 'La lunghezza delle keywords non è tra', '2016-12-09 09:23:32'),
(6252, 'it', 'siteauditor', 'The page title length is not between', 'Il  titolo della pagina non è tra', '2016-12-09 09:23:32'),
(6253, 'it', 'siteauditor', 'The total number of links in page is greater than', 'Il numero totale di link nella pagine è più grande di ', '2016-12-09 09:23:32'),
(6254, 'it', 'siteauditor', 'to run project again if you stopped execution', 'per avviare il progetto nuovamente se hai fermato l''esecuzione', '2016-12-09 09:23:32'),
(6255, 'it', 'siteauditor', 'to view the reports', 'per vedere i report', '2016-12-09 09:23:32'),
(6256, 'it', 'siteauditor', 'Total Links', 'Totale link', '2016-12-09 09:23:32'),
(6257, 'it', 'siteauditor', 'totallinksgreaterallowed', 'Il totale dei link diventerà più grande del massimo numero di link consentiti per il progetto', '2016-12-09 09:23:32'),
(6258, 'hu', 'home', 'Indexed', 'Indexelt', '2011-07-11 06:51:07'),
(6259, 'hu', 'directory', 'Reciprocal Link', 'Visszamutató link', '2013-02-05 19:23:52'),
(6260, 'hu', 'keyword', 'Insert keywords separated with comma', 'Add meg a kulcsszavakat vesszővel elválasztva', '2011-07-11 06:53:54'),
(6261, 'hu', 'label', 'Brocken', 'Törött', '2013-02-05 19:24:43'),
(6262, 'hu', 'label', 'Comments', 'Hozzászólások', '2013-02-05 19:24:43'),
(6263, 'hu', 'label', 'Count', 'Összeg', '2013-02-05 19:24:43'),
(6264, 'hu', 'label', 'Exclude', 'Kihagy', '2013-02-05 19:24:43'),
(6265, 'hu', 'label', 'Include', 'Belefoglal', '2013-02-05 19:24:43'),
(6266, 'hu', 'label', 'Project', 'Projekt', '2013-02-05 19:24:43'),
(6267, 'hu', 'label', 'Report Type', 'Jelentés Típusa', '2013-02-05 19:24:43'),
(6268, 'hu', 'label', 'Score', 'Pont', '2013-02-05 19:24:43'),
(6269, 'hu', 'label', 'Total Results', 'Végeredmény', '2013-02-05 19:24:43'),
(6270, 'hu', 'label', 'Updated', 'Frissítve', '2013-02-05 19:24:43'),
(6271, 'hu', 'label', 'View Reports', 'Jelentések Megtekintése', '2013-02-05 19:24:43'),
(6272, 'hu', 'panel', 'Edit Project', 'Projekt szerkesztése', '2013-02-05 19:25:03'),
(6273, 'hu', 'panel', 'New Project', 'Új Projekt', '2013-02-05 19:25:03'),
(6274, 'hu', 'seotools', 'Auditor Projects', 'Projektek', '2011-07-11 07:00:18'),
(6275, 'hu', 'seotools', 'Auditor Reports', 'Jelentések', '2011-07-11 07:00:18'),
(6276, 'hu', 'seotools', 'Auditor Settings', 'Beállítások', '2011-07-11 07:00:18'),
(6277, 'hu', 'seotools', 'Import Project Links', 'Linkek importálása', '2011-07-11 07:00:18'),
(6278, 'hu', 'seotools', 'site-auditor', 'Oldal Kezelője', '2011-07-11 07:00:18'),
(6279, 'hu', 'settings', 'Check for Updates', 'Frissítések Keresése', '2013-02-05 19:25:44'),
(6280, 'hu', 'settings', 'SA_CRAWL_DELAY_TIME', 'Késleltetés az oldalak feltérképezése között ', '2013-02-05 19:25:44'),
(6281, 'hu', 'settings', 'SA_MAX_NO_PAGES', 'Maximum oldalak száma weblaponként', '2013-02-05 19:25:44'),
(6282, 'hu', 'settings', 'SP_API_KEY', 'Seo Panel API Kulcs', '2013-02-05 19:25:44'),
(6283, 'hu', 'settings', 'versionnotuptodatemsg', 'Seo Paneled elavult. Kérlek töltsd le az új verziót.', '2013-02-05 19:25:44'),
(6284, 'hu', 'settings', 'Your Seo Panel installation is up to date', 'A legfrissebb Seo Panel van telepítve.', '2013-02-05 19:25:44'),
(6285, 'hu', 'siteauditor', 'Anchor', 'Anchor', '2011-07-11 08:52:14'),
(6286, 'hu', 'siteauditor', 'anylinkcontainabovelinks', 'Kihagyandó linkek a jelentésből', '2011-07-11 08:52:14'),
(6287, 'hu', 'siteauditor', 'anylinkcontainexcludesitemap', 'Kihagyandó linkek az oldaltérképből', '2011-07-11 08:52:14'),
(6288, 'hu', 'siteauditor', 'Check backlinks of pages', 'Backlinkek ellenőrzése', '2011-07-11 08:52:14'),
(6289, 'hu', 'siteauditor', 'Check broken links in a page', 'Törött linkek ellenőrzése', '2011-07-11 08:52:14'),
(6290, 'hu', 'siteauditor', 'Check google pagerank of pages', 'Pagerank ellenőrzése', '2011-07-11 08:52:14'),
(6291, 'hu', 'siteauditor', 'Check pages indexed or not', 'Indexelt-e az oldal', '2011-07-11 08:52:14'),
(6292, 'hu', 'siteauditor', 'Check Score', 'Pontszám Ellenőrzése', '2011-07-11 08:52:14'),
(6293, 'hu', 'siteauditor', 'checkborckenlinkwait', 'A törött linkek ellenőrzése megnöveli a jelentés készítésének az idejét.', '2011-07-11 08:52:14'),
(6294, 'hu', 'siteauditor', 'Completed project execution', 'Befejezett projectek', '2011-07-11 08:52:14'),
(6295, 'hu', 'siteauditor', 'Crawled', 'Feltérképezett', '2011-07-11 08:52:14'),
(6296, 'hu', 'siteauditor', 'Crawled Pages', 'Feltérképezett oldalak', '2011-07-11 08:52:14'),
(6297, 'hu', 'siteauditor', 'crawledsuccesssfullywaitfornext', 'feltérképezése sikeres! Új oldal feltérképezése:', '2011-07-11 08:52:14'),
(6298, 'hu', 'siteauditor', 'Crawling Page', 'Oldal Feltérképezése', '2011-07-11 08:52:14'),
(6299, 'hu', 'siteauditor', 'Duplicate Description', 'Leírás Duplikálása', '2011-07-11 08:52:14'),
(6300, 'hu', 'siteauditor', 'Duplicate Keywords', 'kulcsszavak Duplikálása', '2011-07-11 08:52:14'),
(6301, 'hu', 'siteauditor', 'Duplicate Title', 'Cím Duplikálása', '2011-07-11 08:52:14'),
(6302, 'hu', 'siteauditor', 'Exclude links', 'Kihagyandó Linkek', '2011-07-11 08:52:14'),
(6303, 'hu', 'siteauditor', 'Execute with cron', 'Execute with cron', '2011-07-11 08:52:14'),
(6304, 'hu', 'siteauditor', 'External', 'Kimenő', '2011-07-11 08:52:14'),
(6305, 'hu', 'siteauditor', 'External Links', 'Kimenő Linkek', '2011-07-11 08:52:14'),
(6306, 'hu', 'siteauditor', 'Import Project Links', 'Projekt Linkek Importálása', '2011-07-11 08:52:14'),
(6307, 'hu', 'siteauditor', 'Insert links separated with comma', 'Linkek megadása vesszővel elválasztva', '2011-07-11 08:52:14'),
(6308, 'hu', 'siteauditor', 'insertlinkssepcoma', 'Linkek megadása vesszővel elválasztva, amiket ki szeretnénk hagyni a jelentésből', '2011-07-11 08:52:14'),
(6309, 'hu', 'siteauditor', 'Link Reports', 'Jelentés a Linkekről', '2011-07-11 08:52:14'),
(6310, 'hu', 'siteauditor', 'Link Title', 'Link Címe', '2011-07-11 08:52:14'),
(6311, 'hu', 'siteauditor', 'Maximum number of pages to be checked', 'Leellenőrizendő oldalak száma', '2011-07-11 08:52:14'),
(6312, 'hu', 'siteauditor', 'Maximum Pages', 'Maximum Oldalak száma', '2011-07-11 08:52:14'),
(6313, 'hu', 'siteauditor', 'No active projects found', 'Nem található aktív projekt', '2011-07-11 08:52:14'),
(6314, 'hu', 'siteauditor', 'Nofollow', 'Nofollow', '2011-07-11 08:52:14'),
(6315, 'hu', 'siteauditor', 'Number of pages is greater than', 'Number of pages is greater than', '2011-07-11 08:52:14'),
(6316, 'hu', 'siteauditor', 'Number of pages should be greater than', 'Number of pages should be greater than', '2011-07-11 08:52:14'),
(6317, 'hu', 'siteauditor', 'Page Details', 'Oldal Részletei', '2011-07-11 08:52:14'),
(6318, 'hu', 'siteauditor', 'Page Link', 'Oldal Link', '2011-07-11 08:52:14'),
(6319, 'hu', 'siteauditor', 'Page Links', 'Oldal Link', '2011-07-11 08:52:14'),
(6320, 'hu', 'siteauditor', 'Pages Found', 'Az oldal nem található', '2011-07-11 08:52:14'),
(6321, 'hu', 'siteauditor', 'pressescapetostopexecution', 'Press <b>escape</b> key to stop execution of script', '2011-07-11 08:52:14'),
(6322, 'hu', 'siteauditor', 'Project Summary', 'Projekt Összegzés', '2011-07-11 08:52:14'),
(6323, 'hu', 'siteauditor', 'Project Url', 'Projekt Url', '2011-07-11 08:52:14'),
(6324, 'hu', 'siteauditor', 'projectalreadyexist', 'Ez a weboldal már szerepel egy projektben', '2011-07-11 08:52:14'),
(6325, 'hu', 'siteauditor', 'Recheck Pages', 'oldalak Újraellenőrzése', '2011-07-11 08:52:14'),
(6326, 'hu', 'siteauditor', 'Report Summary', 'Jelentés Összefoglaló', '2011-07-11 08:52:14'),
(6327, 'hu', 'siteauditor', 'Run Project', 'Projekt Futtatása', '2011-07-11 08:52:14'),
(6328, 'hu', 'siteauditor', 'should start with', 'should start with', '2011-07-11 08:52:14'),
(6329, 'hu', 'siteauditor', 'Site Auditor Settings', 'Oldal Kezelőjének Beállítása', '2011-07-11 08:52:14'),
(6330, 'hu', 'siteauditor', 'Store all links found in a page', 'Összes link tárolása', '2011-07-11 08:52:14'),
(6331, 'hu', 'siteauditor', 'The page description length is not between', 'The page description length is not between', '2011-07-11 08:52:14'),
(6332, 'hu', 'siteauditor', 'The page is brocken', 'Az oldal összeomlott', '2011-07-11 08:52:14'),
(6333, 'hu', 'siteauditor', 'The page is having exellent number of backlinks in', 'The page is having exellent number of backlinks in', '2011-07-11 08:52:14'),
(6334, 'hu', 'siteauditor', 'The page is having exellent pagerank', 'Az oldalnak magas a pagerankja', '2011-07-11 08:52:14'),
(6335, 'hu', 'siteauditor', 'The page is having good number of backlinks in', 'Az oldalnak sok backlinkje van', '2011-07-11 08:52:14'),
(6336, 'hu', 'siteauditor', 'The page is having good pagerank', 'Az oldalnak magas a pagerankja', '2011-07-11 08:52:14'),
(6337, 'hu', 'siteauditor', 'The page is having poor pagerank', 'Az oldalnak alacsony a pagerankja', '2011-07-11 08:52:14'),
(6338, 'hu', 'siteauditor', 'The page is having very good pagerank', 'Az oldalnak magas a pagerankja', '2011-07-11 08:52:14'),
(6339, 'hu', 'siteauditor', 'The page is not having backlinks in', 'Az oldalnak nincs backlinkje', '2011-07-11 08:52:14'),
(6340, 'hu', 'siteauditor', 'The page is not indexed in', 'Az oldal nincs indexelve', '2011-07-11 08:52:14'),
(6341, 'hu', 'siteauditor', 'The page keywords length is not between', 'The page keywords length is not between', '2011-07-11 08:52:14'),
(6342, 'hu', 'siteauditor', 'The page title length is not between', 'The page title length is not between', '2011-07-11 08:52:14'),
(6343, 'hu', 'siteauditor', 'The total number of links in page is greater than', 'The total number of links in page is greater than ', '2011-07-11 08:52:14'),
(6344, 'hu', 'siteauditor', 'to run project again if you stopped execution', 'to run project again if you stopped execution', '2011-07-11 08:52:14'),
(6345, 'hu', 'siteauditor', 'to view the reports', 'jelentés megtekintése', '2011-07-11 08:52:14'),
(6346, 'hu', 'siteauditor', 'Total Links', 'Összes Link', '2011-07-11 08:52:14'),
(6347, 'hu', 'siteauditor', 'totallinksgreaterallowed', 'Total links will become greater than maximum links allowed to the project', '2011-07-11 08:52:14'),
(6348, 'tr', 'siteauditor', 'Anchor', 'Sunucu', '2017-02-04 13:37:17'),
(6349, 'tr', 'siteauditor', 'anylinkcontainabovelinks', 'Yukarıdaki herhani bir link rapordan çıkarılacak', '2017-02-04 13:37:17'),
(6350, 'tr', 'siteauditor', 'anylinkcontainexcludesitemap', 'Yukarıdaki herhani bir link sitemap''ten çıkarılacak', '2017-02-04 13:37:17'),
(6351, 'tr', 'siteauditor', 'Check backlinks of pages', 'Sayfa backlink''lerini kontrol et', '2017-02-04 13:37:17'),
(6352, 'tr', 'siteauditor', 'Check broken links in a page', 'Sayfadaki kırık linkleri kontrol et', '2017-02-04 13:37:17'),
(6353, 'tr', 'siteauditor', 'Check google pagerank of pages', 'Sayfaların google page rank değerini kontrol et', '2017-02-04 13:37:17'),
(6354, 'tr', 'siteauditor', 'Check pages indexed or not', 'Sayfaların indexlenli olup olmadıklarını kontrol et', '2017-02-04 13:37:17'),
(6355, 'tr', 'siteauditor', 'Check Score', 'Skoru Kontrol et', '2017-02-04 13:37:17'),
(6356, 'tr', 'siteauditor', 'checkborckenlinkwait', 'Kırık linkleri kontrol etmek proje düzenleme zaman kaybınızı azaltır', '2017-02-04 13:37:17'),
(6357, 'tr', 'siteauditor', 'Completed project execution', 'Proje düzenlemesi tamamlandı', '2017-02-04 13:37:17'),
(6358, 'tr', 'siteauditor', 'Crawled', 'Tarandı', '2017-02-04 13:37:17'),
(6359, 'tr', 'siteauditor', 'Crawled Pages', 'Taranan Sayfalar', '2017-02-04 13:37:17'),
(6360, 'tr', 'siteauditor', 'crawledsuccesssfullywaitfornext', 'trama işlemi başarılı! sonraki sayfayı taramak için bekliyor', '2017-02-04 13:37:17'),
(6361, 'tr', 'siteauditor', 'Crawling Page', 'Sayfa taranıyor', '2017-02-04 13:37:17'),
(6362, 'tr', 'siteauditor', 'Duplicate Description', 'Açıklamayı Kopyala', '2017-02-04 13:37:17'),
(6363, 'tr', 'siteauditor', 'Duplicate Keywords', 'Anahtar kelimeleri Kopyala', '2017-02-04 13:37:17'),
(6364, 'tr', 'siteauditor', 'Duplicate Title', 'Başlığı Kopyala', '2017-02-04 13:37:17'),
(6365, 'tr', 'siteauditor', 'Exclude links', 'Linkleri çıkar', '2017-02-04 13:37:17'),
(6366, 'tr', 'siteauditor', 'Execute with cron', 'Cron ile çıkar', '2017-02-04 13:37:17'),
(6367, 'tr', 'siteauditor', 'External', 'Harici', '2017-02-04 13:37:17'),
(6368, 'tr', 'siteauditor', 'External Links', 'Harici Linkler', '2017-02-04 13:37:17'),
(6369, 'tr', 'siteauditor', 'Import Project Links', 'Proje linklerini içe aktar', '2017-02-04 13:37:17'),
(6370, 'tr', 'siteauditor', 'Insert links separated with comma', 'Linkleri virgül ile ayırarak giriniz', '2017-02-04 13:37:17'),
(6371, 'tr', 'siteauditor', 'insertlinkssepcoma', 'sonuz linkleri rapordan ayrı tutmak için linkleri virgül ile ayırarak giriniz', '2017-02-04 13:37:17'),
(6372, 'tr', 'siteauditor', 'Link Reports', 'Link raporu', '2017-02-04 13:37:17'),
(6373, 'tr', 'siteauditor', 'Link Title', 'Link Başlığı', '2017-02-04 13:37:17'),
(6374, 'tr', 'siteauditor', 'Maximum number of pages to be checked', 'Kontol edilen maksimum sayfa sayısı', '2017-02-04 13:37:17'),
(6375, 'tr', 'siteauditor', 'Maximum Pages', 'Maksimum Sayfa', '2017-02-04 13:37:17'),
(6376, 'tr', 'siteauditor', 'No active projects found', 'Aktif proje yok', '2017-02-04 13:37:17'),
(6377, 'tr', 'siteauditor', 'Nofollow', 'Takip etme (nofollow)', '2017-02-04 13:37:17'),
(6378, 'tr', 'siteauditor', 'Number of pages is greater than', 'Sayfa sayısı bundan daha büyük, ', '2017-02-04 13:37:17'),
(6379, 'tr', 'siteauditor', 'Number of pages should be greater than', 'Sayfa sayısı bundan fazla olmalı, ', '2017-02-04 13:37:17'),
(6380, 'tr', 'siteauditor', 'Page Details', 'Sayfa Detayları', '2017-02-04 13:37:17'),
(6381, 'tr', 'siteauditor', 'Page Link', 'Sayfa Linki', '2017-02-04 13:37:17'),
(6382, 'tr', 'siteauditor', 'Page Links', 'Sayfa Linkleri', '2017-02-04 13:37:17'),
(6383, 'tr', 'siteauditor', 'Pages Found', 'Sayfa Bulundu', '2017-02-04 13:37:17'),
(6384, 'tr', 'siteauditor', 'pressescapetostopexecution', 'script düzenlemesini durdurmak için <b>ESC escape</b> tuşuna basınız', '2017-02-04 13:37:17'),
(6385, 'tr', 'siteauditor', 'Project Summary', 'Proje Özeti', '2017-02-04 13:37:17'),
(6386, 'tr', 'siteauditor', 'Project Url', 'Proje Url', '2017-02-04 13:37:17'),
(6387, 'tr', 'siteauditor', 'projectalreadyexist', 'Bu site için proje daha önce oluşturuldu', '2017-02-04 13:37:17'),
(6388, 'tr', 'siteauditor', 'Recheck Pages', 'Sayfaları Tekrar Kontrol Et', '2017-02-04 13:37:17'),
(6389, 'tr', 'siteauditor', 'Report Summary', 'Rapor Özeti', '2017-02-04 13:37:17'),
(6390, 'tr', 'siteauditor', 'Run Project', 'Projeyi Çalıştır', '2017-02-04 13:37:17'),
(6391, 'tr', 'siteauditor', 'should start with', 'bunla başlamalı, ', '2017-02-04 13:37:17'),
(6392, 'tr', 'siteauditor', 'Site Auditor Settings', 'Site Denetçi Ayarları', '2017-02-04 13:37:17'),
(6393, 'tr', 'siteauditor', 'Store all links found in a page', 'Bir sayfada bulunan tüm linkleri depola', '2017-02-04 13:37:17'),
(6394, 'tr', 'siteauditor', 'The page description length is not between', 'Sayfa açıklaması uzunluğu şu aralıkta değil, ', '2017-02-04 13:37:17'),
(6395, 'tr', 'siteauditor', 'The page is brocken', 'Sayfa parça', '2017-02-04 13:37:17'),
(6396, 'tr', 'siteauditor', 'The page is having exellent number of backlinks in', 'Sayfa mükemmel sayıda backlink almaktadır. ', '2017-02-04 13:37:17'),
(6397, 'tr', 'siteauditor', 'The page is having exellent pagerank', 'Sayfa mükemmel pagerank almaktadır', '2017-02-04 13:37:17'),
(6398, 'tr', 'siteauditor', 'The page is having good number of backlinks in', 'Sayfa iyi sayıda backlink almaktadır. ', '2017-02-04 13:37:17'),
(6399, 'tr', 'siteauditor', 'The page is having good pagerank', 'Sayfa iyi pagerank almaktadır', '2017-02-04 13:37:17'),
(6400, 'tr', 'siteauditor', 'The page is having poor pagerank', 'Sayfa zayıf pagerank almaktadır', '2017-02-04 13:37:17'),
(6401, 'tr', 'siteauditor', 'The page is having very good pagerank', 'Sayfa çok iyi pagerank almaktadır', '2017-02-04 13:37:17'),
(6402, 'tr', 'siteauditor', 'The page is not having backlinks in', 'Sayfa backlink almamaktadır. ', '2017-02-04 13:37:17'),
(6403, 'tr', 'siteauditor', 'The page is not indexed in', 'Sayfa indexli değil', '2017-02-04 13:37:17'),
(6404, 'tr', 'siteauditor', 'The page keywords length is not between', 'Sayfa anahtar kelimeleri uzunluğu şu aralıkta değil, ', '2017-02-04 13:37:17'),
(6405, 'tr', 'siteauditor', 'The page title length is not between', 'Sayfa başlığı uzunluğu şu aralıkta değil, ', '2017-02-04 13:37:17'),
(6406, 'tr', 'siteauditor', 'The total number of links in page is greater than', 'Sayfadaki toplam link sayısı şundan büyük', '2017-02-04 13:37:17'),
(6407, 'tr', 'siteauditor', 'to run project again if you stopped execution', 'eğer uygulamayı durdursanız, projeyi yeniden çalıştırmak için', '2017-02-04 13:37:17'),
(6408, 'tr', 'siteauditor', 'to view the reports', 'raporları görüntülemek için ', '2017-02-04 13:37:17'),
(6409, 'tr', 'siteauditor', 'Total Links', 'Toplam Linkler', '2017-02-04 13:37:17'),
(6410, 'tr', 'siteauditor', 'totallinksgreaterallowed', 'Toplam linkler projede izin verilen maksimum link sayısından fazla olacak', '2017-02-04 13:37:17'),
(6411, 'ru', 'directory', 'Reciprocal Link', 'Взаимные ссылки', '2012-11-09 06:03:15'),
(6412, 'ru', 'settings', 'SP_API_KEY', 'API ключ Seo Panel', '2017-07-13 16:50:08'),
(6413, 'de', 'directory', 'Reciprocal Link', 'Reciprocal Link', '2014-01-19 11:37:36'),
(6414, 'ro', 'directory', 'Reciprocal Link', 'Link Reciproc', '2012-05-18 20:52:34'),
(6415, 'bg', 'directory', 'Reciprocal Link', 'взаимна връзка', '2012-11-09 21:03:43'),
(6416, 'bg', 'settings', 'SP_API_KEY', 'Seo Panel API Key', '2016-12-18 17:09:40'),
(6417, 'cs', 'directory', 'Add back to directory list', 'Přidat zpět do adresáře', '2011-07-12 12:28:25'),
(6418, 'cs', 'directory', 'Approved', 'Schváleno', '2011-07-12 12:28:25'),
(6419, 'cs', 'directory', 'Captcha', 'Captcha', '2011-07-12 12:28:25'),
(6420, 'cs', 'directory', 'categorynote', 'Kategorie oddělené čárkou a seřazené dle priority od nejvyšší.', '2011-07-12 12:28:25'),
(6421, 'cs', 'directory', 'Check Directory Status', 'Zkontrolovat stav adresáře', '2011-07-12 12:28:25'),
(6422, 'cs', 'directory', 'Check Directory Submission Status', 'Zkontrolovat stav odeslání do adresáře', '2011-07-12 12:28:25'),
(6423, 'cs', 'directory', 'clicktoproceeddirsts', 'Pro kontrolu stavu adresáře klikněte na <b>Provést</b>.', '2011-07-12 12:28:25'),
(6424, 'cs', 'directory', 'Confirmation', 'Potvrzení', '2011-07-12 12:28:25'),
(6425, 'cs', 'directory', 'desnote', 'Některé adresáře vyžadují v poli popisu nejméně 150 znaků.', '2011-07-12 12:28:25'),
(6426, 'cs', 'directory', 'Directories with out captcha', 'Adresáře bez ověření captcha', '2011-07-12 12:28:25'),
(6427, 'cs', 'directory', 'Directory Submission Reports', 'Reporty odeslání do adresářů', '2011-07-12 12:28:25'),
(6428, 'cs', 'directory', 'Enter the code shown', 'Vlože zobrazený kód', '2011-07-12 12:28:25'),
(6429, 'cs', 'directory', 'nocatnote', 'Zadaná kategorie nebyla nalezena na vkládací stránce. Prosím kliněte na <b>Znovu načíst</b> nebo <b>Přeskočit</b>', '2011-07-12 12:28:25'),
(6430, 'cs', 'directory', 'nodirnote', 'Nebyly nalezeny žádné <b>Aktivní</b> adresáře', '2011-07-12 12:28:25'),
(6431, 'cs', 'directory', 'nosuccessnote', 'Nebylo získáno potvrzení o úspěchu. Prosím zkontrolujte svůj email, možná došlo tam.', '2011-07-12 12:28:25'),
(6432, 'cs', 'directory', 'optionalnote', 'Dodatečné titulky a popisy, které jsou využívány pro náhodné vkládáních dalších titulků a popisů pro získání lepších výsledků.', '2011-07-12 12:28:25'),
(6433, 'cs', 'directory', 'Owner Email', 'Email vlastníka', '2011-07-12 12:28:25'),
(6434, 'cs', 'directory', 'Owner Name', 'Jméno vlastníka.', '2011-07-12 12:28:25'),
(6435, 'cs', 'directory', 'Pending', 'Zprácováváno', '2011-07-12 12:28:25'),
(6436, 'cs', 'directory', 'Please select a website to proceed', 'Prosím vyberte website k provedení', '2011-07-12 12:28:25'),
(6437, 'cs', 'directory', 'Reciprocal Link', 'Reciproční odkaz', '2011-07-12 12:28:25'),
(6438, 'cs', 'directory', 'selectwebsiteproceed', 'Vyberte <b>Website</b> aby se vkládání do adresářů mohlo <b>Provést</b>.<br>Zkontrolujte <b>Adresáře bez ověření captcha</b> pro odeslání do adresářů bez captcha.', '2011-07-12 12:28:25'),
(6439, 'cs', 'directory', 'selectwebsiteschecksub', 'Vyberte <b>Website</b> aby se mohla <b>Provést</b> kontrola vložení do adresářů.', '2011-07-12 12:28:25'),
(6440, 'cs', 'directory', 'Semi Automatic Directory Submission Tool', 'Poloautomatický nástroj na vkládání do adresářů', '2011-07-12 12:28:25'),
(6441, 'cs', 'directory', 'spamemailnote', 'Některé adresáře mohou rozesílat spam, nedoporučujeme používat vaši primární emailovou adresu.', '2011-07-12 12:28:25'),
(6442, 'cs', 'directory', 'Submission Details', 'Detaily odeslání', '2011-07-12 12:28:25'),
(6443, 'cs', 'directory', 'Submit Description', 'Odeslat popis', '2011-07-12 12:28:25'),
(6444, 'cs', 'directory', 'Submit Keywords', 'Odeslat klíčová slova', '2011-07-12 12:28:25'),
(6445, 'cs', 'directory', 'Submit Title', 'Odeslat titulek', '2011-07-12 12:28:25'),
(6446, 'cs', 'directory', 'Website Category', 'Kategorie webu', '2011-07-12 12:28:25'),
(6447, 'cs', 'directory', 'Website Url', 'URL webu', '2011-07-12 12:28:25'),
(6448, 'cs', 'home', 'Account Summary', 'Shrnutí účtu', '2011-08-06 12:26:49'),
(6449, 'cs', 'home', 'Backlinks', 'Zpětné odkazy', '2011-08-06 12:26:49'),
(6450, 'cs', 'home', 'Directory Submission', 'Odeslání do adresářů', '2011-08-06 12:26:49'),
(6451, 'cs', 'home', 'home_cont1', '<h1 style=\\"text-align: center;margin-bottom: 30px;font-size: 19px;\\">Vítejte v SEO panelu - prvním ovládacím panelu pro SEO spravujícím více webů</h1> \r\n        <p> \r\n            Kompletní <b>ovládací panel pro SEO s otevřeným kódem</b> pro správu <b>SEO optimalizace</b> vašich webů.  \r\n            SEO panel je <b>nástroj pro SEO</b>, který zahrnuje nejnovější a špičkové nástroje pro SEO, jež <b>zvyšují a sledují výkon</b> vašeho webu. \r\n            Je to <b>volný software</b> zveřejněný pod <b>GNU GENERAL PUBLIC LICENSE</b>. \r\n            Hlavní vlastností SEO panelu je jeho <b>rozšířitelnost</b> prostřednictvím <a href=\\"<?=SP_PLUGINSITE?>\\" target=\\"_blank\\">SEO pluginů</a>. \r\n            Kdokoliv může snadno <b>vyvíjet a instalovat</b> požadované pluginy pro svůj SEO panel. \r\n        </p> \r\n        <p></p> \r\n        <p> \r\n            Tento volný software byl <b>uvolněn v lednu 2010</b>. \r\n            Během této <b>krátké doby</b> <b>tisíce správců webu</b> používají ten to softwarový nástroj k <b>optimalizaci</b> jejich webů. \r\n            Používejte SEO panel také a <b>užijte si</b> všeho co souvisí se SEO optimalizací pod <b>jedinou platformou</b>. \r\n        </p>', '2011-08-06 12:26:49');
INSERT INTO `texts` (`id`, `lang_code`, `category`, `label`, `content`, `changed`) VALUES
(6452, 'cs', 'home', 'home_cont2', '<fieldset> \r\n<legend>Hlavní vlastnosti aplikace SEO Panel<?=SP_INSTALLED?></legend> \r\n<ul class=\\"infobox\\"> \r\n    <li>         \r\n        <h1>Automatický nástroj pro zapisování do adresářů</h1> \r\n        <p> \r\n          Automatický nástroj pro zapisování do adresářů nám umožňuje <b>zapsat naše stránky</b> do hlavních <b>bezplatných i placených internetových adresářů</b>.\r\n           Můžeme také <b>zjišťovat průběh</b> každého zapsaní prostřednictvím <b>periodických kontrol</b> s použitím skriptu <b>kontroly stavu zápisů</b>.\r\n           <b>Manažer adresářů</b> nám pomůže zjistit, zda je <b>adresář aktivní</b> či nikoliv.\r\n        </p> \r\n    </li> \r\n    <li>         \r\n        <h1>Kontrola pozice klíčových slov</h1> \r\n        <p> \r\n            Kontrola pozice klíčových slov zjistí <b>pozice klíčových slov</b> vaší webové stránky v <b>internetových vyhledávačích</b> a <b>uloží je</b> do systému.\r\n         V reportech pozic klíčových slov můžeme vidět <b>denní pozice</b> klíčových slov v různých vyhledávačích prostřednictvím <b>pěkných grafů</b> a <b>detailních reportů</b>.\r\n        </p> \r\n    </li> \r\n    <li>         \r\n        <h1>Site Auditor</h1> \r\n        <p>Site Auditor will <b>audit all SEO factors</b> of each pages of a site and will give a\r\n<b>detailed report</b> about each page. This will help us to create <b>XML,HTML,TEXT</b> sitemap\r\nfiles of our website for <b>submit</b> to search engines.</p> \r\n    </li> \r\n    <li>         \r\n        <h1>Google and Alexa Rank Checker</h1> \r\n        <p> \r\n            Google and alexa rank checker will find <b>google pagerank</b> and <b>alexa rank</b> of our\r\nwebsites and <b>stores</b> it in the system. \r\n            In <b>rank reports</b> section, we can see the <b>daily</b> google and alexa rank of each website\r\nby <b>detailed reports</b>. \r\n        </p> \r\n    </li> \r\n    <li>         \r\n        <h1>Backlinks Checker</h1> \r\n        <p> \r\n            Backlinks checker will find <b>number of backlinks</b> of our websites in different search\r\nengines<b>(google,yahoo,msn etc)</b> and <b>stores</b> it in the system. \r\n            <br>In <b>backlink reports</b> section, we can see the <b>daily backlinks count</b> of each\r\nwebsite by <b>detailed reports</b>. \r\n        </p> \r\n    </li>     \r\n    <li>         \r\n        <h1>Search Engine Saturation Checker</h1> \r\n        <p> \r\n            Search Engine Saturation checker will find <b>number of indexed pages</b> of our websites in\r\ndifferent search engines<b>(google,yahoo,msn etc)</b> and <b>stores</b> it in the system. \r\n            In <b>search engine saturation checker reports</b> section, we can see the <b>daily indexed page\r\ncount</b> of each website by <b>detailed reports</b>. \r\n        </p> \r\n    </li> \r\n    <li>         \r\n        <h1>Seo Panel Plugins</h1> \r\n        <p> \r\n            The <b>major feature</b> of seo control panel is its <b>extentability</b>. \r\n            Add <b>seo plugins</b> to your seo panel to <b>extend the features</b> according to your\r\nrequirement. \r\n            <a href=\\"<?=SP_PLUGINSITE?>\\" target=\\"_blank\\">Seo panel plugins</a> are provided by both seo panel\r\nand third party sites. \r\n            You can also easily <b>develop</b> seo plugins for your seo panel. \r\n            You can <a href=\\"<?=SP_PLUGINSITE?>\\" target=\\"_blank\\">submit</a> your seo plugin to seo panel and\r\nwe will <b>publish</b> it in our website after our <b>review</b> process. \r\n        </p> \r\n    </li> \r\n    <li>         \r\n        <h1>Meta Tag Generator</h1> \r\n        <p> \r\n            Meta tag generator is a <b>seo panel plugin</b> for creating <b>custom meta tags</b> for our\r\nsite. \r\n            It will help us to give <b>more information</b> about our website to <b>search engine bots</b>\r\nwhile they crawl our website. \r\n        </p> \r\n    </li> \r\n</ul> \r\n</fieldset>', '2011-08-06 12:26:49'),
(6556, 'cs', 'keyword', 'Crawling keyword', 'Prozkoumávám klíčová slova', '2011-07-14 11:20:41'),
(6557, 'cs', 'keyword', 'Detailed Keyword Position Reports', 'Detailní reporty pozic klíčových slov', '2011-07-14 11:20:41'),
(6558, 'cs', 'keyword', 'Edit Keyword', 'Upravit klíčové slovo', '2011-07-14 11:20:41'),
(6559, 'cs', 'keyword', 'Graphical Keyword Position Reports', 'Grafické reporty pozic klíčových slov', '2011-07-14 11:20:41'),
(6560, 'cs', 'keyword', 'Import Keywords', 'Importovat klíčová slova', '2011-07-14 11:20:41'),
(6561, 'cs', 'keyword', 'Insert keywords separated with comma', 'Vložte klíčová slova oddělená čárkou', '2011-07-14 11:20:41'),
(6562, 'cs', 'keyword', 'Keyword already exist', 'Klíčové slovo již existuje', '2011-07-14 11:20:41'),
(6563, 'cs', 'keyword', 'Keyword Position Report', 'Report pozic klíčových slov', '2011-07-14 11:20:41'),
(6564, 'cs', 'keyword', 'New Keyword', 'Nové klíčové slovo', '2011-07-14 11:20:41'),
(6565, 'cs', 'keyword', 'not assigned to required search engines', 'není přiřazeno k požadovaným vyhledávačům', '2011-07-14 11:20:41'),
(6566, 'cs', 'keyword', 'pleaseselecttool', 'Prosím vyberte alespoň jeden nástroj pro SEO', '2011-07-14 11:20:41'),
(6567, 'cs', 'keyword', 'Quick Keyword Position Checker', 'Rychlá kontrola pozic klíčových slov', '2011-07-14 11:20:41'),
(6568, 'cs', 'keyword', 'results from ', 'výsledky z', '2011-07-14 11:20:41'),
(6569, 'cs', 'keyword', 'Show All results', 'Zobrazit všechny výsledky', '2011-07-14 11:20:41'),
(6570, 'cs', 'keyword', 'Successfully crawled keyword', 'Úspěšně prozkoumaná klíčová slova', '2011-07-14 11:20:41'),
(6571, 'cs', 'keyword', 'to create new keywords', 'k vytvoření nových klíčových slov', '2011-07-14 11:20:41'),
(6572, 'cs', 'label', 'already exist', 'již existují', '2011-07-14 11:25:05'),
(6573, 'cs', 'label', 'Authentication', 'Ověření', '2011-07-14 11:25:05'),
(6574, 'cs', 'label', 'Author', 'Autor', '2011-07-14 11:25:05'),
(6575, 'cs', 'label', 'Brocken', 'Poškozené', '2011-07-14 11:25:05'),
(6576, 'cs', 'label', 'Click Here', 'Klikněte zde', '2011-07-14 11:25:05'),
(6577, 'cs', 'label', 'Comments', 'Komentáře', '2011-07-14 11:25:05'),
(6578, 'cs', 'label', 'Count', 'Počet', '2011-07-14 11:25:05'),
(6579, 'cs', 'label', 'Cron', 'Cron', '2011-07-14 11:25:05'),
(6580, 'cs', 'label', 'Description', 'Popis', '2011-07-14 11:25:05'),
(6581, 'cs', 'label', 'Developers', 'Vývojáři', '2011-07-14 11:25:05'),
(6582, 'cs', 'label', 'Download', 'Stáhnout', '2011-07-14 11:25:05'),
(6583, 'cs', 'label', 'Exclude', 'Vyloučit', '2011-07-14 11:25:05'),
(6584, 'cs', 'label', 'Include', 'Zahrnout', '2011-07-14 11:25:05'),
(6585, 'cs', 'label', 'Installation', 'Instalace', '2011-07-14 11:25:05'),
(6586, 'cs', 'label', 'Keywords', 'Klíčová slova', '2011-07-14 11:25:05'),
(6587, 'cs', 'label', 'noactiveplugins', 'Nebyly nalezeny žádné aktivní SEO pluginy', '2011-07-14 11:25:05'),
(6588, 'cs', 'label', 'Plugin', 'Pluginy', '2011-07-14 11:25:05'),
(6589, 'cs', 'label', 'Port', 'Port', '2011-07-14 11:25:05'),
(6590, 'cs', 'label', 'Project', 'Projekt', '2011-07-14 11:25:05'),
(6591, 'cs', 'label', 'Proxy', 'Proxy', '2011-07-14 11:25:05'),
(6592, 'cs', 'label', 'Re-install', 'Znovu nainstalovat', '2011-07-14 11:25:05'),
(6593, 'cs', 'label', 'Report Type', 'Typ reportu', '2011-07-14 11:25:05'),
(6594, 'cs', 'label', 'Score', 'Skóre', '2011-07-14 11:25:05'),
(6595, 'cs', 'label', 'Sponsors', 'Sponzoři', '2011-07-14 11:25:05'),
(6596, 'cs', 'label', 'Title', 'Titule', '2011-07-14 11:25:05'),
(6597, 'cs', 'label', 'Total Results', 'Celkové výsledky', '2011-07-14 11:25:05'),
(6598, 'cs', 'label', 'translation by', 'přeložil', '2011-07-14 11:25:05'),
(6599, 'cs', 'label', 'Translators', 'Překladatelé', '2011-07-14 11:25:05'),
(6600, 'cs', 'label', 'Updated', 'Aktualizováno', '2011-07-14 11:25:05'),
(6601, 'cs', 'label', 'Upgrade', 'Aktualizace', '2011-07-14 11:25:05'),
(6453, 'cs', 'home', 'home_cont3', '', '2011-08-06 12:26:49'),
(6454, 'cs', 'home', 'Indexed', 'Indexován', '2011-08-06 12:26:49'),
(6455, 'cs', 'home', 'Pages Indexed', 'Indexovaných stránek', '2011-08-06 12:26:49'),
(6456, 'cs', 'home', 'Ranks', 'Ranky', '2011-08-06 12:26:49'),
(6457, 'cs', 'home', 'SiteNameUrl', 'Jméno webu/URL', '2011-08-06 12:26:49'),
(6458, 'cs', 'home', 'Website Statistics', 'Statistiky webu', '2011-08-06 12:26:49'),
(6459, 'pt', 'siteauditor', 'Anchor', 'Âncora ', '2011-07-12 16:11:46'),
(6460, 'pt', 'siteauditor', 'anylinkcontainabovelinks', 'Todos os links acima contêm links que serão excluídos a partir de relatórios ', '2011-07-12 16:11:46'),
(6461, 'pt', 'siteauditor', 'anylinkcontainexcludesitemap', 'Todos os links acima que contêm links serão excluídos sitemap ', '2011-07-12 16:11:46'),
(6462, 'pt', 'siteauditor', 'Check backlinks of pages', 'Verificar backlinks de páginas ', '2011-07-12 16:11:46'),
(6463, 'pt', 'siteauditor', 'Check broken links in a page', 'Verificar os links inválidos da página ', '2011-07-12 16:11:46'),
(6464, 'pt', 'siteauditor', 'Check google pagerank of pages', 'Verifique o Google PageRank de páginas ', '2011-07-12 16:11:46'),
(6465, 'pt', 'siteauditor', 'Check pages indexed or not', 'Verifique páginas indexadas ou não ', '2011-07-12 16:11:46'),
(6466, 'pt', 'siteauditor', 'Check Score', 'Verifique Pontuação ', '2011-07-12 16:11:46'),
(6467, 'pt', 'siteauditor', 'checkborckenlinkwait', 'Confira os links inválidos irá aumentar o tempo de execução do projecto ', '2011-07-12 16:11:46'),
(6468, 'pt', 'siteauditor', 'Completed project execution', 'Execução do projecto concluído ', '2011-07-12 16:11:46'),
(6469, 'pt', 'siteauditor', 'Crawled', 'Rastreado ', '2011-07-12 16:11:46'),
(6470, 'pt', 'siteauditor', 'Crawled Pages', 'Páginas rastreadas', '2011-07-12 16:11:46'),
(6471, 'pt', 'siteauditor', 'crawledsuccesssfullywaitfornext', 'rastreado com sucesso! Esperando o rastreamento da próxima página para ', '2011-07-12 16:11:46'),
(6472, 'pt', 'siteauditor', 'Crawling Page', 'Rastreando Página ', '2011-07-12 16:11:46'),
(6473, 'pt', 'siteauditor', 'Duplicate Description', 'Descrição Duplicada', '2011-07-12 16:11:46'),
(6474, 'pt', 'siteauditor', 'Duplicate Keywords', 'Palavras-chave duplicadas ', '2011-07-12 16:11:46'),
(6475, 'pt', 'siteauditor', 'Duplicate Title', 'título duplicado', '2011-07-12 16:11:46'),
(6476, 'pt', 'siteauditor', 'Exclude links', 'Exclui links', '2011-07-12 16:11:46'),
(6477, 'pt', 'siteauditor', 'Execute with cron', 'Executar com através da cron ', '2011-07-12 16:11:46'),
(6478, 'pt', 'siteauditor', 'External', 'Externo ', '2011-07-12 16:11:46'),
(6479, 'pt', 'siteauditor', 'External Links', 'Ligações externas ', '2011-07-12 16:11:46'),
(6480, 'pt', 'siteauditor', 'Import Project Links', 'importar os links do projecto', '2011-07-12 16:11:46'),
(6481, 'pt', 'siteauditor', 'Insert links separated with comma', 'Inserir os links separados por vírgula ', '2011-07-12 16:11:46'),
(6482, 'pt', 'siteauditor', 'insertlinkssepcoma', 'Inserir links separados por vírgula, para excluir ligações infinitas a partir dos relatórios ', '2011-07-12 16:11:46'),
(6483, 'pt', 'siteauditor', 'Link Reports', 'Relatórios apontam ', '2011-07-12 16:11:46'),
(6484, 'pt', 'siteauditor', 'Link Title', 'Título do Link ', '2011-07-12 16:11:46'),
(6485, 'pt', 'siteauditor', 'Maximum number of pages to be checked', 'Número máximo de páginas a serem verificados ', '2011-07-12 16:11:46'),
(6486, 'pt', 'siteauditor', 'Maximum Pages', 'Máximo de Páginas', '2011-07-12 16:11:46'),
(6487, 'pt', 'siteauditor', 'No active projects found', 'Nenhum projecto activo encontrado ', '2011-07-12 16:11:46'),
(6488, 'pt', 'siteauditor', 'Nofollow', 'Não siga em frente', '2011-07-12 16:11:46'),
(6489, 'pt', 'siteauditor', 'Number of pages is greater than', 'Número de páginas é maior que ', '2011-07-12 16:11:46'),
(6490, 'pt', 'siteauditor', 'Number of pages should be greater than', 'Número de páginas deve ser maior que ', '2011-07-12 16:11:46'),
(6491, 'pt', 'siteauditor', 'Page Details', 'Detalhes da Página ', '2011-07-12 16:11:46'),
(6492, 'pt', 'siteauditor', 'Page Link', 'Link da Página ', '2011-07-12 16:11:46'),
(6493, 'pt', 'siteauditor', 'Page Links', 'links da Página', '2011-07-12 16:11:46'),
(6494, 'pt', 'siteauditor', 'Pages Found', 'Páginas encontradas ', '2011-07-12 16:11:46'),
(6495, 'pt', 'siteauditor', 'pressescapetostopexecution', 'Pressione <b>Escape</b> para parar a execução do script ', '2011-07-12 16:11:46'),
(6496, 'pt', 'siteauditor', 'Project Summary', 'Resumo do Projecto ', '2011-07-12 16:11:46'),
(6497, 'pt', 'siteauditor', 'Project Url', 'Url do projecto ', '2011-07-12 16:11:46'),
(6498, 'pt', 'siteauditor', 'projectalreadyexist', 'Projecto para este site já existe ', '2011-07-12 16:11:46'),
(6499, 'pt', 'siteauditor', 'Recheck Pages', 'verifique novamente as Páginas ', '2011-07-12 16:11:46'),
(6500, 'pt', 'siteauditor', 'Report Summary', 'Resumo do relatório ', '2011-07-12 16:11:46'),
(6501, 'pt', 'siteauditor', 'Run Project', 'Executar projecto ', '2011-07-12 16:11:46'),
(6502, 'pt', 'siteauditor', 'should start with', 'deve começar com ', '2011-07-12 16:11:46'),
(6503, 'pt', 'siteauditor', 'Site Auditor Settings', 'Definições do Site Auditor ', '2011-07-12 16:11:46'),
(6504, 'pt', 'siteauditor', 'Store all links found in a page', 'Armazenar todos os links encontrados em uma página ', '2011-07-12 16:11:46'),
(6505, 'pt', 'siteauditor', 'The page description length is not between', 'O comprimento da descrição da página não é entre ', '2011-07-12 16:11:46'),
(6506, 'pt', 'siteauditor', 'The page is brocken', 'A página não está concluída', '2011-07-12 16:11:46'),
(6507, 'pt', 'siteauditor', 'The page is having exellent number of backlinks in', 'A página está com excelente número de backlinks em ', '2011-07-12 16:11:46'),
(6508, 'pt', 'siteauditor', 'The page is having exellent pagerank', 'A página está a ter um excelente pagerank ', '2011-07-12 16:11:46'),
(6509, 'pt', 'siteauditor', 'The page is having good number of backlinks in', 'A página está a ter bom número de backlinks em ', '2011-07-12 16:11:46'),
(6510, 'pt', 'siteauditor', 'The page is having good pagerank', 'A página está com bom pagerank  ', '2011-07-12 16:11:46'),
(6511, 'pt', 'siteauditor', 'The page is having poor pagerank', 'A página está a ter um mau pagerank', '2011-07-12 16:11:46'),
(6512, 'pt', 'siteauditor', 'The page is having very good pagerank', 'A página está a ter um muito bom pagerank ', '2011-07-12 16:11:46'),
(6513, 'pt', 'siteauditor', 'The page is not having backlinks in', 'A página não está a ter backlinks em ', '2011-07-12 16:11:46'),
(6514, 'pt', 'siteauditor', 'The page is not indexed in', 'A página não está indexada em ', '2011-07-12 16:11:46'),
(6515, 'pt', 'siteauditor', 'The page keywords length is not between', 'A página das palavras-chave não tem palavras entre ', '2011-07-12 16:11:46'),
(6516, 'pt', 'siteauditor', 'The page title length is not between', 'O comprimento título da página não está entre ', '2011-07-12 16:11:46'),
(6517, 'pt', 'siteauditor', 'The total number of links in page is greater than', 'O número total de links na página é maior do que ', '2011-07-12 16:11:46'),
(6518, 'pt', 'siteauditor', 'to run project again if you stopped execution', 'para executar o projecto novamente, se você parou de execução ', '2011-07-12 16:11:46'),
(6519, 'pt', 'siteauditor', 'to view the reports', 'para ver os relatórios ', '2011-07-12 16:11:46'),
(6520, 'pt', 'siteauditor', 'Total Links', 'Total de Links ', '2011-07-12 16:11:46'),
(6521, 'pt', 'siteauditor', 'totallinksgreaterallowed', 'o total de Links vai se tornar maior do que o máximo de ligações permitido para o projecto ', '2011-07-12 16:11:46'),
(6522, 'fa', 'directory', 'Reciprocal Link', 'لینک متقابل ', '2012-05-12 21:11:24'),
(6523, 'fa', 'keyword', 'Insert keywords separated with comma', 'کلید واژه ها را وارد کن و با کاما از هم جدا کن ', '2011-07-13 01:19:39'),
(6524, 'fa', 'label', 'Brocken', 'شکسته', '2012-05-12 21:14:56'),
(6525, 'fa', 'label', 'Comments', 'نظرات', '2012-05-12 21:14:56'),
(6526, 'fa', 'label', 'Count', 'تعداد', '2012-05-12 21:14:56'),
(6527, 'fa', 'label', 'Exclude', 'مستثنی کردن', '2012-05-12 21:14:56'),
(6528, 'fa', 'label', 'Include', 'شامل کردن', '2012-05-12 21:14:56'),
(6529, 'fa', 'label', 'Project', 'پروژه', '2012-05-12 21:14:56'),
(6530, 'fa', 'label', 'Report Type', 'نوع گزارش', '2012-05-12 21:14:56'),
(6531, 'fa', 'label', 'Score', 'امتیاز', '2012-05-12 21:14:56'),
(6532, 'fa', 'label', 'Total Results', 'نتایج نهایی', '2012-05-12 21:14:56'),
(6533, 'fa', 'label', 'Updated', 'به روز رسانی', '2012-05-12 21:14:56'),
(6534, 'fa', 'label', 'View Reports', 'نمایش گزارشات', '2012-05-12 21:14:56'),
(6535, 'fa', 'panel', 'Edit Project', 'ویرایش پروژه', '2012-05-16 19:23:21'),
(6536, 'fa', 'panel', 'New Project', 'پروژه جدید', '2012-05-16 19:23:21'),
(6537, 'fa', 'seotools', 'Auditor Projects', 'پروژه های ممیزی', '2011-07-13 01:25:12'),
(6538, 'fa', 'seotools', 'Auditor Reports', 'گزارشات ممیزی', '2011-07-13 01:25:14'),
(6539, 'fa', 'seotools', 'Auditor Settings', 'تنظیمات ممیزی', '2011-07-13 01:25:14'),
(6540, 'fa', 'seotools', 'Import Project Links', 'وارد کن لینکهای پروژه را ', '2011-07-13 01:25:14'),
(6541, 'fa', 'seotools', 'site-auditor', 'سایز ممیز', '2011-07-13 01:25:14'),
(6542, 'fa', 'settings', 'Check for Updates', 'برای به روز رسانی چک کنید ', '2012-05-16 20:03:34'),
(6543, 'fa', 'settings', 'SA_CRAWL_DELAY_TIME', 'تاخیر خزیدن چک کننده های سایت بین هر یک از صفحات', '2012-05-16 20:03:34'),
(6544, 'fa', 'settings', 'SA_MAX_NO_PAGES', 'بیشترین تعداد صفحات مجاز برای هر سایت', '2012-05-16 20:03:34'),
(6545, 'fa', 'settings', 'SP_API_KEY', 'کلید ای پی آی سئو پنل', '2012-05-16 20:03:34'),
(6546, 'fa', 'settings', 'versionnotuptodatemsg', 'سئو پنل شما به روز نیست . <br> لطفا ورژن جدید را دریافت کنید ', '2012-05-16 20:03:34'),
(6547, 'fa', 'settings', 'Your Seo Panel installation is up to date', ' سئو پنل شما به روز است ', '2012-05-16 20:03:34'),
(6549, 'nl', 'settings', 'SP_API_KEY', 'Seo Panel Api Sleutel', '2014-01-07 21:51:05'),
(6548, 'es', 'directory', 'Reciprocal Link', 'Enlace recíproco', '2012-05-31 10:35:43'),
(6551, 'fa', 'support', 'support_cont2', '<fieldset> \r\n<legend>منابع آنلاین سئو پنل</legend> \r\n<ul class=\\"infobox\\"> \r\n         \r\n    <li> \r\n        <h1>راهنمای سئو پنل </h1>  \r\n        <p> \r\n            شما می توانید ببینید  <a href=\\"<?=SP_HELP_LINK?>\\" target=\\"_blank\\">  را مدارک سئو پنل </a> در\r\n<b>راهنما </b>, این شمال میشه  <b>مدارک </b> ابزارات سئو پنل و ویژگی های  مربوط به آن \r\n. \r\n            <br>این بهترین مکان در اینترنت است که  <b>کمک کرده بشه </b> درباره سئو پنل \r\n<b>کمک می کنیم </b> که راهنمای سئو پنل ,اگر شما ایرادی پیدا کردید یا چیزی از دست رفت .                 \r\n        </p> \r\n        <p> \r\n            <a href=\\"<?=SP_HELP_LINK?>\\" target=\\"_blank\\">نگاه کن به راهنمای سئو پنل </a> \r\n        </p> \r\n        <br> \r\n    </li>     \r\n    <li> \r\n        <h1>فرم سئو پنل </h1>  \r\n        <p> \r\n            جایی برای بحث درباره اولین نرم افزار آزاد سئو در جهان  <b>سئو کنترل پنل </b>.  \r\n            بهترین جا برای پیدا کردن  <b>جواب </b> to <b>سوال هایتان </b> درباره پنل \r\n            <br>همچنین شما می توانید  <b>به اشتراک بگذارید </b>  <b>تجربیاتتان را </b> وقتی استفاده می کنید از سئو پنل برای بهبود سایتتان \r\n        </p>         \r\n        <p> \r\n            <a href=\\"<?=SP_FORUM_LINK?>\\" target=\\"_blank\\">مشاهده کنید فرم سئو پنل را </a> \r\n        </p> \r\n        <br> \r\n    </li> \r\n</ul>     \r\n</fieldset>', '2012-04-30 04:02:03'),
(6552, 'fa', 'support', 'support_cont3', '<fieldset> \r\n<legend>پشتیبانی مالی </legend> \r\n<ul class=\\"infobox\\">         \r\n    <li> \r\n        <h1> پشتیبانی کن از سئو پنل , اولین نرم افزار آزاد سئو در دنیا</h1>  \r\n        <p> \r\n            <b>پشتیبانی</b> کن از سئو پنل , اولین نرم افزار آزاد سئو در دنیا\r\n            ما برنامه داریم  <b>اضافه کنیم و بهبود ببخشیم </b> ویژگی های سئو پنل را در آینده \r\n            <br>با تمام  <b>پشتیبانی های شما </b> فقط ما میتوانیم دست پیدا کینم به <b>اهدافمان </b>. \r\n            اگر شما احساس می کنید که سئو پنل <b>ارزش </b> برای شما لطفا پشتیبانی کنید از تیم نرم افزاری آن \r\n            <br>ما  <b>انتشار خواهیم داد </b> اسم شما و اطلاعات شما را در  <a href=\\"<?=SP_DONATE_LINK?>\\"\r\ntarget=\\"_blank\\">صفحه پشتیبانی مالی </a>, اولین باری که ما دریافت کنیم کمک را . \r\n        </p> \r\n        <p> \r\n            <a href=\\"<?=SP_DONATE_LINK?>\\" target=\\"_blank\\">برای کمک مالی کردن روی این لینک کلیک کنید </a> \r\n        </p> \r\n        <br> \r\n    </li> \r\n</ul> \r\n</fieldset>', '2012-04-30 04:02:03'),
(6553, 'zh', 'directory', 'Reciprocal Link', '互惠链接', '2014-01-09 15:03:35'),
(6554, 'zh', 'settings', 'SP_API_KEY', 'SEO Panel API接口', '2014-05-15 17:56:30'),
(6555, 'fa', 'home', 'Indexed', 'نمایه ', '2012-05-22 23:09:44'),
(6602, 'cs', 'label', 'Version', 'Verze', '2011-07-14 11:25:05'),
(6603, 'cs', 'label', 'View Reports', 'Prohlédnout reporty', '2011-07-14 11:25:05'),
(6604, 'cs', 'label', 'wantproceed', 'Opravdu to chcete provést?', '2011-07-14 11:25:05'),
(6605, 'cs', 'login', 'Confirm Password', 'Potvrdit heslo', '2011-07-14 11:27:09'),
(6606, 'cs', 'login', 'Create my account', 'Vytvořit můj účet', '2011-07-14 11:27:11'),
(6607, 'cs', 'login', 'Create New Account', 'Vytvořit nový účet', '2011-07-14 11:27:11'),
(6608, 'cs', 'login', 'Email', 'Email', '2011-07-14 11:27:11'),
(6609, 'cs', 'login', 'emailexist', 'Email již existuje', '2011-07-14 11:27:11'),
(6610, 'cs', 'login', 'Enter the code as it is shown', 'Vložte kód přesně tak, jak je zobrazen', '2011-07-14 11:27:11'),
(6611, 'cs', 'login', 'First Name', 'Jméno (křestní)', '2011-07-14 11:27:11'),
(6612, 'cs', 'login', 'Last Name', 'Příjmení', '2011-07-14 11:27:11'),
(6613, 'cs', 'login', 'Login', 'Uživatelské jméno', '2011-07-14 11:27:11'),
(6614, 'cs', 'login', 'Login incorrect', 'Špatné uživatelské jméno', '2011-07-14 11:27:11'),
(6615, 'cs', 'login', 'newaccountsuccess', 'Nový účet byl úspěšně vytvořen!', '2011-07-14 11:27:11'),
(6616, 'cs', 'login', 'Password', 'Heslo', '2011-07-14 11:27:11'),
(6617, 'cs', 'login', 'Password incorrect', 'Špatné heslo', '2011-07-14 11:27:11'),
(6618, 'cs', 'login', 'Register', 'Registrovat', '2011-07-14 11:27:11'),
(6619, 'cs', 'login', 'Sign in to your account', 'Přihlásit se k vašemu účtu', '2011-07-14 11:27:11'),
(6620, 'cs', 'login', 'User inactive', 'Neaktivní uživatel', '2011-07-14 11:27:11'),
(6621, 'cs', 'login', 'Username', 'Uživatelské jméno', '2011-07-14 11:27:11'),
(6622, 'cs', 'login', 'usernameexist', 'Uživatelské jméno již existuje!', '2011-07-14 11:27:11'),
(6623, 'cs', 'panel', 'About Us', 'O nás', '2011-07-14 11:30:24'),
(6624, 'cs', 'panel', 'Add following command to your cron tab', 'Přidejte do tabulky Cronu následující příkaz', '2011-07-14 11:30:24'),
(6625, 'cs', 'panel', 'alsocheckfollowlink', 'Pokud potřebujete další detaily, podívejte se také na následující odkaz.', '2011-07-14 11:30:24'),
(6626, 'cs', 'panel', 'Check Directory', 'Zkontrolujte adresář', '2011-07-14 11:30:24'),
(6627, 'cs', 'panel', 'Cron Command', 'Příkaz Cronu', '2011-07-14 11:30:24'),
(6628, 'cs', 'panel', 'Directory Manager', 'Manažer adresářů', '2011-07-14 11:30:24'),
(6629, 'cs', 'panel', 'Edit My Profile', 'Upravit můj profil', '2011-07-14 11:30:24'),
(6630, 'cs', 'panel', 'Edit Project', 'Upravit projekt', '2011-07-14 11:30:24'),
(6631, 'cs', 'panel', 'My Profile', 'Můj profil', '2011-07-14 11:30:24'),
(6632, 'cs', 'panel', 'New Project', 'Nový projekt', '2011-07-14 11:30:24'),
(6633, 'cs', 'panel', 'New Proxy', 'Nová proxy', '2011-07-14 11:30:24'),
(6634, 'cs', 'panel', 'New User', 'Nový uživatel', '2011-07-14 11:30:24'),
(6635, 'cs', 'panel', 'New Website', 'Nový web', '2011-07-14 11:30:24'),
(6636, 'cs', 'panel', 'Proxy Manager', 'Manažer Proxy', '2011-07-14 11:30:24'),
(6637, 'cs', 'panel', 'Report Generation Manager', 'Manažer pro vytváření reportů', '2011-07-14 11:30:24'),
(6638, 'cs', 'panel', 'Reports Manager', 'Manažer reportů', '2011-07-14 11:30:24'),
(6639, 'cs', 'panel', 'Seo Plugins Manager', 'Manažer SEO pluginů', '2011-07-14 11:30:24'),
(6640, 'cs', 'panel', 'Seo Tools Manager', 'Manažer SEO nástrojů', '2011-07-14 11:30:24'),
(6641, 'cs', 'panel', 'System Settings', 'Systémová nastavení', '2011-07-14 11:30:24'),
(6642, 'cs', 'panel', 'User Manager', 'Manažer uživatelů', '2011-07-14 11:30:24'),
(6643, 'cs', 'panel', 'Website Manager', 'Manažer webů', '2011-07-14 11:30:24'),
(6644, 'cs', 'plugin', 'Edit Seo Plugin', 'Upravit SEO plugin', '2011-07-14 11:30:44'),
(6645, 'cs', 'plugin', 'Plugin Name', 'Jméno pluginu', '2011-07-14 11:30:44'),
(6646, 'cs', 'plugin', 'Seo Plugin Details', 'Detaily o SEO pluginu', '2011-07-14 11:30:44'),
(6647, 'cs', 'proxy', 'Edit Proxy', 'Upravit proxy', '2011-07-14 11:31:13'),
(6648, 'cs', 'proxy', 'Proxy Password', 'Heslo k proxy', '2011-07-14 11:31:13'),
(6649, 'cs', 'proxy', 'Proxy Username', 'Uživatelské jméno k proxy', '2011-07-14 11:31:13'),
(6650, 'cs', 'proxy', 'Proxyalreadyexist', 'Proxy již existuje!', '2011-07-14 11:31:13'),
(6651, 'cs', 'rank', 'enterurlproceed', 'Vložte URL, <b>každé na samostatnou řádku</b>. Klikněte na <b>Provést</b>, aby došlo ke kontrole ranku v Google a Alexa.', '2011-07-14 11:32:45'),
(6652, 'cs', 'rank', 'Google and Alexa Rank Reports', 'Reporty ranku v Google a Alexa', '2011-07-14 11:32:45'),
(6653, 'cs', 'rank', 'Saved rank results of', 'Uložené výsledky ranků webu', '2011-07-14 11:32:45'),
(6654, 'cs', 'saturation', 'clickproceedsaturation', 'Vložte URL <b>na každý řádek jedno</b>. Klikněte na <b>Provést</b> pro kontrolu nasycení výsledků vyhledávačů.', '2011-07-14 11:35:25'),
(6655, 'cs', 'saturation', 'GenerateSaturationReports', 'Vytvořit report nasycení vyhledávačů', '2011-07-14 11:35:25'),
(6656, 'cs', 'saturation', 'Quick Search Engine Saturation Checker', 'Rychlá kontrola nasycení vyhledávačů', '2011-07-14 11:35:25'),
(6657, 'cs', 'saturation', 'Saved Search Engine Saturation results of', 'Uložené výsledky nasycení vyhledávačů webu', '2011-07-14 11:35:25'),
(6658, 'cs', 'saturation', 'Search Engine Saturation Reports', 'Reporty nasycení vyhledávačů', '2011-07-14 11:35:25'),
(6659, 'cs', 'sitemap', 'Change frequency', 'Změnit frekvenci', '2011-07-14 11:38:47'),
(6660, 'cs', 'sitemap', 'clickproceedsitemap', 'Pro vytvoření sitemapy klikněte na <b>Provést</b>', '2011-07-14 11:38:47'),
(6661, 'cs', 'sitemap', 'Download sitemap file from', 'Stáhnout soubor sitemapy z', '2011-07-14 11:38:47'),
(6662, 'cs', 'sitemap', 'Exclude Url', 'Vyjmout URL', '2011-07-14 11:38:47'),
(6663, 'cs', 'sitemap', 'processtaketime', 'Tento proces může podle počtu odkazů na vašem webu zabrat nějaký čas. Prosím počkejte, dokud neobdržíte soubory sitemapy', '2011-07-14 11:38:47'),
(6664, 'cs', 'sitemap', 'Sitemap Type', 'Typ sitemapy', '2011-07-14 11:38:47'),
(6665, 'tr', 'support', 'support_cont1', '<fieldset>\r\n<legend>Seo Panel Destek Sistemi</legend>\r\n<ul class=\\"infobox\\">\r\n    <li>\r\n        <h1>1000 Directory (Link Listesi - Rehber) Paketi</h1> \r\n        <p>\r\n            Biz <b>1000 ücretsiz ve onaylı</b> link listesi paketi sağlıyoruz , seo panelinize\r\neklemek için <b>directory ekleme aracı</b>.\r\n            Bu websitenize ait <b>backlinklerinizi</b> arttıracak.\r\n            Aslında 1000 directory link listesi seo panel özelliklerini gelistirmek için gerekli tutarı\r\nkarşılayabilmek için <b>tanıtıldı</b>\r\n</b>.\r\n            1000 directory link listesini almak için lütfen seo paneli geliştirebilmemiz için<a href=\\"<?=SP_DONATE_LINK?>\\" target=\\"_blank\\">bağış\r\nyapınız</a>. $10 veya daha fazla.\r\n            Eğer 1000 directory paketi hakkında sorunuz varsa, lütfen <a href=\\"<?=SP_CONTACT_LINK?>\\"\r\ntarget=\\"_blank\\">bizimle irtibata geçiniz</a> ya da <a href=\\"<?=SP_SUPPORT_LINK?>\\"\r\ntarget=\\"_blank\\">destek sisteminden</a> bir konu açınız.   \r\n        </p>        \r\n        <p>\r\n            <a href=\\"<?=SP_DONATE_LINK?>\\" target=\\"_blank\\">Seo Panel\\''e Bağış Yap Sayfası</a>\r\n        </p>\r\n        <br>\r\n    </li>\r\n    \r\n    <li>\r\n        <h1>Yerel Arama Motoru Paketi</h1> \r\n        <p>\r\n            Ülkenize ait<b>yerel arama motoru</b> linklerini seo panele giriniz örnek; google,yahoo,msn(<b>eg: www.google.de,www.google.fr\r\ngibi</b>) ve <b>Anahtar kelimeleri</b> yerel sitenizin performansını görmek için ekleyiniz.\r\n            İhtiyaçlarınıza bağlı seo paketi almak için lütfen seo paneli geliştirebilmemiz için<a\r\nhref=\\"<?=SP_DONATE_LINK?>\\" target=\\"_blank\\">bağış yapınız</a> $10 veya daha fazla.\r\n            Bağışı göndermeden önce, lütfen hangi domain için başvurduğunuzu bildirmek için\r\n<a href=\\"<?=SP_CONTACT_LINK?>\\" target=\\"_blank\\">bizimle iletişime geçin.</a>\r\n            <br><br>              \r\n            Ayrıca seo panelinize anahtar kelime kontrolu için <b>yeni bir arama motoru(eg:baidu.com)</b> eklemeden önce,\r\nlütfen <a href=\\"<?=SP_CONTACT_LINK?>\\" target=\\"_blank\\">bizimle iletişime</a> geçin ya da <a\r\nhref=\\"<?=SP_SUPPORT_LINK?>\\" target=\\"_blank\\">destek sisteminde</a> bir konu açın. \r\n        </p>        \r\n        <p class=\\"visit\\">\r\n            <a href=\\"<?=SP_CONTACT_LINK?>\\" target=\\"_blank\\">İletişim Sayfasını Ziyaret Edin</a>\r\n        </p>\r\n        <br>\r\n    </li>\r\n    \r\n    <li>\r\n        <h1>Seo Panel Pluginleri</h1> \r\n        <p>\r\n            İhtiyaçlarınıza göre seo panelinizi geliştirmek için <b>seo pluginler</b> ekleyin.\r\n            <a href=\\"<?=SP_PLUGINSITE?>\\" target=\\"_blank\\">Seo panel pluginler</a> hem seo panel hemde üçüncü parti\r\nsiteleri desteklemektedir.\r\n            Seo panel pluginleri kendi seo paneliniz için kolayca <b>geliştirebilirsiniz</b>.\r\n            Kendi pluginlerinizi seo panenle <a href=\\"<?=SP_PLUGINSITE?>\\" target=\\"_blank\\">gönderebilirsiniz</a> ve\r\nBiz <b>inceledikten</b> sonra <b>paylaşırız</b>.        \r\n        </p>        \r\n        <p>\r\n            <a href=\\"<?=SP_PLUGINSITE?>\\" target=\\"_blank\\">Seo Panel Plugin Edinmek İçin Tıklayınız</a>\r\n        </p>\r\n        <br>\r\n    </li>    \r\n    <li>\r\n        <h1>İletişim</h1> \r\n        <p>\r\n           <b>seo panel araçları, pluginleri veya herhangi bir konu hakkında bir sorunuz olduğunda aşağıdaki linkten\r\nbizimle iletişime geçebilirsiniz</b>\r\n        </p>        \r\n        <p>\r\n            <a href=\\"<?=SP_CONTACT_LINK?>\\" target=\\"_blank\\">İletişim Sayfası</a>\r\n        </p>\r\n        <br>\r\n    </li>    \r\n    <li>\r\n        <h1>Destek Konusu</h1> \r\n        <p>\r\n            seo panel araçları, pluginleri veya herhangi bir konu hakkında <b>teknik destek</b>\r\nalmak için konu açınız</b>. örnek: anahtar kelime kontrol ayarları hatası.\r\n        </p>        \r\n        <p>\r\n            <a href=\\"<?=SP_SUPPORT_LINK?>\\" target=\\"_blank\\">Destek Konusu Açmak için Tıklayınız</a>\r\n        </p>\r\n        <br>\r\n    </li>    \r\n    <li>\r\n        <h1>Bugları- Hataları Rapor Et</h1> \r\n        <p>\r\n           Lütfen bir sonraki versiyonda hataları düzelmek için bize destek olun ve\r\n           bugları-hataları bize bilidirin.          \r\n        </p>        \r\n        <p>\r\n            <a href=\\"<?=SP_SUPPORT_LINK?>\\" target=\\"_blank\\">Hata Bildirme Sayfası için Tıkla</a>\r\n        </p>\r\n        <br>\r\n    </li>    \r\n</ul>\r\n</fieldset>', '2011-07-15 15:03:36'),
(6666, 'tr', 'support', 'support_cont2', '<fieldset>\r\n<legend>Seo Panel Online Kaynakları</legend>\r\n<ul class=\\"infobox\\">\r\n        \r\n    <li>\r\n        <h1>Seo Panel Yardım Rehberi</h1> \r\n        <p>\r\n            Seo Panel kullanım <a href=\\"<?=SP_HELP_LINK?>\\" target=\\"_blank\\">dökümanı</a>,\r\niçerisinde seo panel için araçlar, pluginler ve ilişkili konular var.\r\n            <br><b>Yardım almak</b> için internettiki en iyi seo panel yardım rehberidir. Ümüd ederizki\r\nseo panel hakkında unuttuğumuz ya da kaçırdığımız bir konu hakkında katkıda bulunursunuz.                \r\n        </p>\r\n        <p>\r\n            <a href=\\"<?=SP_HELP_LINK?>\\" target=\\"_blank\\">Seo Panel Yardım Rehberi Ziyaret Edin</a>\r\n        </p>\r\n        <br>\r\n    </li>    \r\n    <li>\r\n        <h1>Seo Panel Forum</h1> \r\n        <p>\r\n            Dünyanın ilk open source </b>seo paneli</b> hakkında tartışmalar yardımlar. \r\n            Seo panel hakkında <b>sorularınıza</b> en iyi <b>cevapları</b> bulabileceğiniz tek yer. \r\n            <br>sitenize arama motoru optimizasyonu yaparken seo panel <b>tecrübelerinizide</b>\r\npaylaşabilirsiniz..                               \r\n        </p>        \r\n        <p>\r\n            <a href=\\"<?=SP_FORUM_LINK?>\\" target=\\"_blank\\">Seo panel forumu ziyaret edin</a>\r\n        </p>\r\n        <br>\r\n    </li>\r\n</ul>    \r\n</fieldset>', '2011-07-15 15:03:36'),
(6667, 'tr', 'support', 'support_cont3', '<fieldset>\r\n<legend>Seo Panel\\''e Bağış</legend>\r\n<ul class=\\"infobox\\">        \r\n    <li>\r\n        <h1>Seo Panel\\''e Bağış Yap - Dünyadaki ilk open source seo kontrol paneli</h1> \r\n        <p>\r\n            <b>Bağış yaparak</b>dünyadaki ilk open source seo kontrol paneline destek olun.\r\n            Seo panele yeni özellikler <b>eklemeyi ve geliştirmyi</b> planlıyoruz. \r\n            <br>Sadece sizin <b>desteğinizle</b> hedeflerimizi gerçekleştirebiliriz.\r\n            Eğer seo panel sizin için de <b>değer kazandırıcı</b> ise, lütfen seo panel için bağış yapın.\r\n            <br>İsminiz ve site bilgilerinizi bağışı aldıktan sonra <a href=\\"<?=SP_DONATE_LINK?>\\"\r\ntarget=\\"_blank\\">Bağış Sayfasında</a> <b>yayınlıyacağız</b>.\r\n        </p>\r\n        <p>\r\n            <a href=\\"<?=SP_DONATE_LINK?>\\" target=\\"_blank\\">Bağış Yapmak için Tıklayınız</a>\r\n        </p>\r\n        <br>\r\n    </li>\r\n</ul>\r\n</fieldset>', '2011-07-15 15:03:36'),
(6668, 'ar', 'backlink', 'clickproceedbacklink', 'اكتب رابط العناوين<b>كل في سطر</b>.إضغط على <b>لتفعيل</b>للتاكد من صحة الروابط المتصلة.', '2011-07-29 10:44:50'),
(6670, 'ar', 'button', 'Cancel', 'إلغاء', '2014-01-08 19:20:10'),
(6669, 'ar', 'backlink', 'Saved backlink results of', 'نتائج الروابط المتصلة من', '2011-07-29 10:44:50'),
(6671, 'ar', 'button', 'Check Status', 'تفقد الحالة', '2014-01-08 19:20:10'),
(6672, 'ar', 'button', 'Proceed', 'تفعيل', '2014-01-08 19:20:10'),
(6673, 'ar', 'button', 'Reload', 'إعادة تحميل', '2014-01-08 19:20:10'),
(6674, 'ar', 'button', 'Show Details', 'عرض التفاصيل', '2014-01-08 19:20:10'),
(6675, 'ar', 'button', 'Show Records', 'إعرض السجلات', '2014-01-08 19:20:10'),
(6676, 'ar', 'button', 'Skip', 'تخطى', '2014-01-08 19:20:10'),
(6677, 'ar', 'button', 'Submit', 'إضغط هنا', '2014-01-08 19:20:10'),
(6678, 'ar', 'common', 'Action', 'نشاط', '2012-11-12 20:12:46'),
(6679, 'ar', 'common', 'Activate', 'تفعيل', '2012-11-12 20:12:46'),
(6680, 'ar', 'common', 'Active', 'مفعل', '2012-11-12 20:12:46'),
(6681, 'ar', 'common', 'Admin Panel', 'لوحة اللإدارة', '2012-11-12 20:12:46'),
(6682, 'ar', 'common', 'Alexa Rank', 'ترتيب أليكسا', '2012-11-12 20:12:46'),
(6683, 'ar', 'common', 'All', 'الجميع', '2012-11-12 20:12:46'),
(6684, 'ar', 'common', 'Category', 'قسم', '2012-11-12 20:12:46'),
(6685, 'ar', 'common', 'contact', 'إتصل', '2012-11-12 20:12:46'),
(6686, 'ar', 'common', 'copyright', 'جميع الحقوق محفوظة www.seopanel.in [year] © حقوق النشر والإستخدام', '2012-11-12 20:12:46'),
(6687, 'ar', 'common', 'Country', 'المنطقة', '2012-11-12 20:12:46'),
(6688, 'ar', 'common', 'Crawl Meta Data', 'نمو بيانات الأوسمة', '2012-11-12 20:12:46'),
(6689, 'ar', 'common', 'Date', 'التاريخ', '2012-11-12 20:12:46'),
(6690, 'ar', 'common', 'Delete', 'حذف', '2012-11-12 20:12:46'),
(6691, 'ar', 'common', 'Details', 'التفاصيل', '2012-11-12 20:12:46'),
(6692, 'ar', 'common', 'Directory', 'القسم', '2012-11-12 20:12:46'),
(6693, 'ar', 'common', 'Donate', 'تبرع للبرنامج', '2012-11-12 20:12:46'),
(6694, 'ar', 'common', 'Edit', 'تعديل', '2012-11-12 20:12:46'),
(6695, 'ar', 'common', 'Entry cannot be blank', 'المدخلات لايمكن ان تكون خاليه', '2012-11-12 20:12:46'),
(6696, 'ar', 'common', 'entrynotvalid', 'المدخلات لايمكن ان تكون صحيحة', '2012-11-12 20:12:46'),
(6697, 'ar', 'common', 'failed', 'فشل', '2012-11-12 20:12:46'),
(6698, 'ar', 'common', 'forum', 'المنتدى', '2012-11-12 20:12:46'),
(6699, 'ar', 'common', 'Found', 'تم العثور عليه', '2012-11-12 20:12:46'),
(6700, 'ar', 'common', 'Google Pagerank', 'ترتيب بموقع جوجل', '2012-11-12 20:12:46'),
(6701, 'ar', 'common', 'help', 'مساعدة', '2012-11-12 20:12:46'),
(6702, 'ar', 'common', 'hidenews', 'إخفي أخبار لوحة تحكم البحث', '2012-11-12 20:12:46'),
(6703, 'ar', 'common', 'Id', 'رقم', '2012-11-12 20:12:46'),
(6704, 'ar', 'common', 'Inactivate', 'تعطيل', '2012-11-12 20:12:46'),
(6705, 'ar', 'common', 'Inactive', 'غير فعال', '2012-11-12 20:12:46'),
(6706, 'ar', 'common', 'Invalid characters', 'أحرف غير صالحة', '2012-11-12 20:12:46'),
(6707, 'ar', 'common', 'Invalid code entered', 'إدخال كود خاطئ', '2012-11-12 20:12:46'),
(6708, 'ar', 'common', 'Invalid email address entered', 'إدخال بريد خاطئ', '2012-11-12 20:12:46'),
(6709, 'ar', 'common', 'Invalid value', 'قيمة خاطئة', '2012-11-12 20:12:46'),
(6710, 'ar', 'common', 'Keyword', 'كلمة رئيسية للبحث', '2012-11-12 20:12:46'),
(6711, 'ar', 'common', 'Keywords', 'كلمات رئيسية للبحث', '2012-11-12 20:12:46'),
(6712, 'ar', 'common', 'lang', 'اللغة', '2012-11-12 20:12:46'),
(6713, 'ar', 'common', 'My Account', 'حسابي', '2012-11-12 20:12:46'),
(6714, 'ar', 'common', 'Name', 'الإسم', '2012-11-12 20:12:46'),
(6715, 'ar', 'common', 'No', 'لا', '2012-11-12 20:12:46'),
(6716, 'ar', 'common', 'No Keywords Found', 'لايوجد كلمات بحث عثر عليها', '2012-11-12 20:12:46'),
(6717, 'ar', 'common', 'No Records Found', 'لايوجد مدخلات', '2012-11-12 20:12:46'),
(6718, 'ar', 'common', 'noactivetools', 'لم يوجد ادوات فعاله للوحة تحكم البحث', '2012-11-12 20:12:46'),
(6719, 'ar', 'common', 'nowebsites', 'لايوجد مواقع بحث', '2012-11-12 20:12:46'),
(6720, 'ar', 'common', 'password632', 'كلمة المرور يجب ان تتكون من 6 الى 32 حرف و رقم', '2012-11-12 20:12:46'),
(6721, 'ar', 'common', 'passwordnotmatch', 'كلمة المرور لم تتطابق', '2012-11-12 20:12:46'),
(6722, 'ar', 'common', 'Period', 'حتى تاريخ', '2012-11-12 20:12:46'),
(6723, 'ar', 'common', 'Priority', 'الاهمية', '2012-11-12 20:12:46'),
(6724, 'ar', 'common', 'Profile', 'الملف الشخصي', '2012-11-12 20:12:46'),
(6725, 'ar', 'common', 'Rank', 'الترتيب', '2012-11-12 20:12:46'),
(6726, 'ar', 'common', 'Reports', 'التقارير', '2012-11-12 20:12:46'),
(6727, 'ar', 'common', 'Results', 'النتائج', '2012-11-12 20:12:46'),
(6728, 'ar', 'common', 'Search Engine', 'محرك البحث', '2012-11-12 20:12:46'),
(6729, 'ar', 'common', 'Select', 'إختر', '2012-11-12 20:12:46'),
(6730, 'ar', 'common', 'Seo Plugins', 'إضافات لوحة تحكم البحث', '2012-11-12 20:12:46'),
(6731, 'ar', 'common', 'Seo Tools', 'أدوات لوحة تحكم البحث', '2012-11-12 20:12:46'),
(6732, 'ar', 'common', 'Sign out', 'تسجيل خروج', '2012-11-12 20:12:46'),
(6733, 'ar', 'common', 'Sign Up', 'تسجيل جديد', '2012-11-12 20:12:46'),
(6734, 'ar', 'common', 'signin', 'تسجيل دخول', '2012-11-12 20:12:46'),
(6735, 'ar', 'common', 'Status', 'الحالة', '2012-11-12 20:12:46'),
(6736, 'ar', 'common', 'Support', 'الدعم الفني', '2012-11-12 20:12:46'),
(6737, 'ar', 'common', 'Total', 'المجموع', '2012-11-12 20:12:46'),
(6738, 'ar', 'common', 'Url', 'الرابط', '2012-11-12 20:12:46'),
(6739, 'ar', 'common', 'User', 'العضو', '2012-11-12 20:12:46'),
(6740, 'ar', 'common', 'User Panel', 'لوحة تحكم العضو', '2012-11-12 20:12:46'),
(6741, 'ar', 'common', 'Website', 'الموقع', '2012-11-12 20:12:46'),
(6742, 'ar', 'common', 'Yes', 'نعم', '2012-11-12 20:12:46'),
(6743, 'ar', 'website', 'Edit Website', 'تعديل الموقع', '2011-07-29 23:31:19'),
(6744, 'ar', 'website', 'plscrtwebsite', 'الرجاء إنشـاء الموقع قبل إستخدام إضافات محرك البحث او أدواته.', '2011-07-29 23:31:20'),
(6745, 'ar', 'website', 'Website already exist', 'الموقع مضاف مسبقا', '2011-07-29 23:31:20'),
(6746, 'ar', 'website', 'yourwebalreday', 'موقعك إن قمت بإنشـائه من قبل.', '2011-07-29 23:31:20'),
(6747, 'ar', 'user', 'Edit User', 'تعديل العضو', '2011-07-29 23:33:17'),
(6748, 'ar', 'user', 'Saved My Profile Details', 'إحفظ متفاصيل ملفي الشخصي', '2011-07-29 23:33:17'),
(6749, 'ar', 'sitemap', 'Change frequency', 'قم بتغيير التردد', '2011-07-29 23:36:19'),
(6750, 'ar', 'sitemap', 'clickproceedsitemap', 'إضغط على <b>تفعيل</b> لإنشاء خريطة الموقع.', '2011-07-29 23:36:19'),
(6751, 'ar', 'sitemap', 'Download sitemap file from', 'قم بتحميل ملف خريطة الموقع من', '2011-07-29 23:36:19'),
(6752, 'ar', 'sitemap', 'Exclude Url', 'أبعد الرابط', '2011-07-29 23:36:19'),
(6753, 'ar', 'sitemap', 'processtaketime', 'هذه العلمية ستتطلب وقتا إضافيا إذا كان لديك روابط كثيرة في موقعك. يرجى الإنتظار قليلا لتحميل ملف خريطة موقعك.', '2011-07-29 23:36:19'),
(6754, 'ar', 'sitemap', 'Sitemap Type', 'نوع خريطة الموقع', '2011-07-29 23:36:19'),
(6755, 'ar', 'siteauditor', 'Anchor', 'مثبت', '2011-07-30 00:53:00'),
(6756, 'ar', 'siteauditor', 'anylinkcontainabovelinks', 'سيتم إستبعاد أي روابط تحتوي على وصلات من التقارير', '2011-07-30 00:53:00'),
(6757, 'ar', 'siteauditor', 'anylinkcontainexcludesitemap', 'سيتم إستبعاد أي روابط تحتوي على وصلات من خريطة الموقع', '2011-07-30 00:53:00'),
(6758, 'ar', 'siteauditor', 'Check backlinks of pages', 'تفقد الروابط المتصلة في الصفحات', '2011-07-30 00:53:00'),
(6759, 'ar', 'siteauditor', 'Check broken links in a page', 'تفقد الروابط المعطوبة في الصفحة', '2011-07-30 00:53:00'),
(6760, 'ar', 'siteauditor', 'Check google pagerank of pages', 'تفقد ترتيب الصفحات لدى جوجل بيج رانك', '2011-07-30 00:53:00'),
(6761, 'ar', 'siteauditor', 'Check pages indexed or not', 'تفقد الصفحات المؤرشفة أو لا', '2011-07-30 00:53:00'),
(6762, 'ar', 'siteauditor', 'Check Score', 'تفقد مجموع النقاط', '2011-07-30 00:53:00'),
(6763, 'ar', 'siteauditor', 'checkborckenlinkwait', 'تفقد حالة الروابط المعطوبة سيؤدي إلى تمديد فترة إنتهاء المشروع', '2011-07-30 00:53:00'),
(6764, 'ar', 'siteauditor', 'Completed project execution', 'إكتمال تنفيذ المشروع', '2011-07-30 00:53:00'),
(6765, 'ar', 'siteauditor', 'Crawled', 'زحف', '2011-07-30 00:53:00'),
(6766, 'ar', 'siteauditor', 'Crawled Pages', 'زحف الصفحات', '2011-07-30 00:53:00'),
(6767, 'ar', 'siteauditor', 'crawledsuccesssfullywaitfornext', 'تمت عملية الزحف بنجاح! بإنتظار زحف الصفحة التالية إلى', '2011-07-30 00:53:00'),
(6768, 'ar', 'siteauditor', 'Crawling Page', 'زحف الصفحة', '2011-07-30 00:53:00'),
(6769, 'ar', 'siteauditor', 'Duplicate Description', 'وصف مكرر', '2011-07-30 00:53:00'),
(6770, 'ar', 'siteauditor', 'Duplicate Keywords', 'كلمات بحث مكررة', '2011-07-30 00:53:00'),
(6771, 'ar', 'siteauditor', 'Duplicate Title', 'عنوان مكرر', '2011-07-30 00:53:00'),
(6772, 'ar', 'siteauditor', 'Exclude links', 'إستبعاد الروابط', '2011-07-30 00:53:00'),
(6773, 'ar', 'siteauditor', 'Execute with cron', 'تفعيله مع كرون', '2011-07-30 00:53:00'),
(6774, 'ar', 'siteauditor', 'External', 'خارجي', '2011-07-30 00:53:00'),
(6775, 'ar', 'siteauditor', 'External Links', 'روابط خارجية', '2011-07-30 00:53:00'),
(6776, 'ar', 'siteauditor', 'Import Project Links', 'إدراج روابط المشاريع', '2011-07-30 00:53:00'),
(6777, 'ar', 'siteauditor', 'Insert links separated with comma', 'إدراج الروابط مفصولة بفاصله بينهما', '2011-07-30 00:53:00'),
(6778, 'ar', 'siteauditor', 'insertlinkssepcoma', 'إدراج الروابط مع فصل فاصلة لاستبعاد الروابط اللانهائية من التقارير', '2011-07-30 00:53:00'),
(6779, 'ar', 'siteauditor', 'Link Reports', 'رابط التقارير', '2011-07-30 00:53:00'),
(6780, 'ar', 'siteauditor', 'Link Title', 'عنوان الرابط', '2011-07-30 00:53:00'),
(6781, 'ar', 'siteauditor', 'Maximum number of pages to be checked', 'الحد الأقصى لعدد الصفحات التي سيتم فحصها', '2011-07-30 00:53:00'),
(6782, 'ar', 'siteauditor', 'Maximum Pages', 'الحد الأقصى للصفحة', '2011-07-30 00:53:00'),
(6783, 'ar', 'siteauditor', 'No active projects found', 'لم يتم العثور على مشاريع فعاله', '2011-07-30 00:53:00'),
(6784, 'ar', 'siteauditor', 'Nofollow', 'لا يتبع', '2011-07-30 00:53:00'),
(6785, 'ar', 'siteauditor', 'Number of pages is greater than', 'عدد الصفحات أكبر من', '2011-07-30 00:53:00'),
(6786, 'ar', 'siteauditor', 'Number of pages should be greater than', 'ينبغي ان تكون عدد الصفحات أكبر من', '2011-07-30 00:53:00'),
(6787, 'ar', 'siteauditor', 'Page Details', 'تفاصيل الصفحة', '2011-07-30 00:53:00'),
(6788, 'ar', 'siteauditor', 'Page Link', 'رابط الصفحة', '2011-07-30 00:53:00'),
(6789, 'ar', 'siteauditor', 'Page Links', 'روابط الصفحة', '2011-07-30 00:53:00'),
(6790, 'ar', 'siteauditor', 'Pages Found', 'صفحة تم العثور عليها', '2011-07-30 00:53:00'),
(6791, 'ar', 'siteauditor', 'pressescapetostopexecution', 'إضغط مفتاح <b>Escape</b> لإيقاف عمل السكربت.', '2011-07-30 00:53:00'),
(6792, 'ar', 'siteauditor', 'Project Summary', 'ملخص المشروع', '2011-07-30 00:53:00'),
(6793, 'ar', 'siteauditor', 'Project Url', 'رابط المشروع', '2011-07-30 00:53:00'),
(6794, 'ar', 'siteauditor', 'projectalreadyexist', 'مشروع هذا الموقع مضاف من قبل', '2011-07-30 00:53:00'),
(6795, 'ar', 'siteauditor', 'Recheck Pages', 'إعادة فحص الصفحات', '2011-07-30 00:53:00'),
(6796, 'ar', 'siteauditor', 'Report Summary', 'تقرير موجز', '2011-07-30 00:53:00'),
(6797, 'ar', 'siteauditor', 'Run Project', 'تفعيل المشروع', '2011-07-30 00:53:00'),
(6798, 'ar', 'siteauditor', 'should start with', 'يجب أن تبدأ', '2011-07-30 00:53:00'),
(6799, 'ar', 'siteauditor', 'Site Auditor Settings', 'إعدادات مدقق الموقع', '2011-07-30 00:53:00'),
(6800, 'ar', 'siteauditor', 'Store all links found in a page', 'حفظ جميع الروابط الموجودة في الصفحة', '2011-07-30 00:53:00'),
(6801, 'ar', 'siteauditor', 'The page description length is not between', 'طول وصف الصفحة ليس بين', '2011-07-30 00:53:00'),
(6802, 'ar', 'siteauditor', 'The page is brocken', 'هذه الصفحة مقسمة', '2011-07-30 00:53:00'),
(6803, 'ar', 'siteauditor', 'The page is having exellent number of backlinks in', 'يتوفر في هذه الصفحة عدد ممتاز من الروابط المتصلة في', '2011-07-30 00:53:00'),
(6804, 'ar', 'siteauditor', 'The page is having exellent pagerank', 'لدى الصفحة بيج رانك ممتاز', '2011-07-30 00:53:00'),
(6805, 'ar', 'siteauditor', 'The page is having good number of backlinks in', 'يتوفر في هذه الصفحة عدد جيد من الروابط المتصلة في', '2011-07-30 00:53:00'),
(6806, 'ar', 'siteauditor', 'The page is having good pagerank', 'لدى الصفحة بيج رانك جيد', '2011-07-30 00:53:00');
INSERT INTO `texts` (`id`, `lang_code`, `category`, `label`, `content`, `changed`) VALUES
(6807, 'ar', 'siteauditor', 'The page is having poor pagerank', 'لدى الصفحة بيج رانك ضعيف', '2011-07-30 00:53:00'),
(6808, 'ar', 'siteauditor', 'The page is having very good pagerank', 'لدى الصفحة بيج رانك جيد جدا', '2011-07-30 00:53:00'),
(6809, 'ar', 'siteauditor', 'The page is not having backlinks in', 'لايوجد روابط متصلة في هذه الصفحة في', '2011-07-30 00:53:00'),
(6810, 'ar', 'siteauditor', 'The page is not indexed in', 'الصفحة غير مؤرشفة بعد في', '2011-07-30 00:53:00'),
(6811, 'ar', 'siteauditor', 'The page keywords length is not between', 'طول عدد كلمات البحث ليس بين', '2011-07-30 00:53:00'),
(6812, 'ar', 'siteauditor', 'The page title length is not between', 'طول عنوان الصفحة ليس بين', '2011-07-30 00:53:00'),
(6813, 'ar', 'siteauditor', 'The total number of links in page is greater than', 'عدد الروابط في هذه الصفحة اكبر من', '2011-07-30 00:53:00'),
(6814, 'ar', 'siteauditor', 'to run project again if you stopped execution', 'لتشغيل المشروع مرة أخرى إذا قمت بإيقاف التنفيذ', '2011-07-30 00:53:00'),
(6815, 'ar', 'siteauditor', 'to view the reports', 'لعرض التقارير', '2011-07-30 00:53:00'),
(6816, 'ar', 'siteauditor', 'Total Links', 'مجموع الروابط', '2011-07-30 00:53:00'),
(6817, 'ar', 'siteauditor', 'totallinksgreaterallowed', 'مجموع الروابط ستصبح أكبر من الحد الأقصى المسموح به في المشروع', '2011-07-30 00:53:00'),
(6818, 'ar', 'settings', 'Check for Updates', 'تفقد إصدار جديد', '2011-07-30 01:16:11'),
(6819, 'ar', 'settings', 'Click here to become a sponsor for Seo Panel', '<b>تبرع ب100 دولار</b>حتى تصبح من<b>الرعايا</b>في لوحة تحكم محسن محرك البحث.', '2011-07-30 01:16:11'),
(6820, 'ar', 'settings', 'SA_CRAWL_DELAY_TIME', 'تأخر الزحف في موقع المدقق بين كل صفحة', '2011-07-30 01:16:11'),
(6821, 'ar', 'settings', 'SA_MAX_NO_PAGES', 'الحد الأقصى من الصفحات المسموحة لكل موقع', '2011-07-30 01:16:11'),
(6822, 'ar', 'settings', 'seopanel_description', 'لوحة تحكم متكاملة لتحسين محرك البحث لموقعك. وتحتوي اللوحة العديد من أدوات البحث الفعالة لتحسين وتسريع الأرشفة لدى موقعك. يعتبر هذه البرنامج من فئة المصادر المفتوحة حيث يمكنك من إنشاء وتكوين إضافات خاصة حسب طلبك للوحة تحسين محرك البحث.', '2011-07-30 01:16:11'),
(6823, 'ar', 'settings', 'seopanel_title', 'لوحة تحكم تحسين محرك البحث: الاولى في العالم من البرامج مفتوحة المصدر لتحسين محركات البحث للمواقع الإلكترونية في الشرق الأوسط.', '2011-07-30 01:16:11'),
(6824, 'ar', 'settings', 'SP_API_KEY', 'الكود الخاص لل<b>API</b>.', '2011-07-30 01:16:11'),
(6825, 'ar', 'settings', 'SP_CRAWL_DELAY', 'فترة التأخير بين كل عملية زحف عنكبوتية - بلثواني.', '2011-07-30 01:16:11'),
(6826, 'ar', 'settings', 'SP_DEFAULTLANG', 'اللغة الرئيسية', '2011-07-30 01:16:11'),
(6827, 'ar', 'settings', 'SP_DESCRIPTION', 'وصف لوحة التحكم لتحسين محرك البحث', '2011-07-30 01:16:11'),
(6828, 'ar', 'settings', 'SP_ENABLE_PROXY', 'تفعيل البروكسي', '2011-07-30 01:16:11'),
(6829, 'ar', 'settings', 'SP_HOTLINKING', 'تفعيل حماية الروابط الساخنة', '2011-07-30 01:16:11'),
(6830, 'ar', 'settings', 'SP_KEYWORDS', 'كلمات البحث للوحة تحسين محرك البحث', '2011-07-30 01:16:11'),
(6831, 'ar', 'settings', 'SP_PAGINGNO', 'عدد المدخلات لكل صفحة', '2011-07-30 01:16:11'),
(6832, 'ar', 'settings', 'SP_TITLE', 'عنوان لوحة تحسين محرك البحث', '2011-07-30 01:16:11'),
(6833, 'ar', 'settings', 'SP_USER_AGENT', 'عميل المستخدم', '2011-07-30 01:16:11'),
(6834, 'ar', 'settings', 'SP_USER_GEN_REPORT', 'تمكين الاعضاء من إنشاء تقارير', '2011-07-30 01:16:11'),
(6835, 'ar', 'settings', 'SP_USER_REGISTRATION', 'واجهة تسجيل المستخدم', '2011-07-30 01:16:11'),
(6836, 'ar', 'settings', 'syssettingssaved', 'تم حفظ إعدادات النظام بنجاح', '2011-07-30 01:16:11'),
(6837, 'ar', 'settings', 'versionnotuptodatemsg', 'لوحة تحسين محرك البحث بحاجة إلى ترقية أمنية الأن.<br>يرجى تحميل النسخة الجديدة من هنا.', '2011-07-30 01:16:11'),
(6838, 'ar', 'settings', 'Your Seo Panel installation is up to date', 'لايوجد إصدارات جديدة للوحة تنصيب محسن محرك البحث ', '2011-07-30 01:16:11'),
(6839, 'ar', 'seotools', 'Auditor Projects', 'مشاريع المدقق', '2011-07-30 01:28:48'),
(6840, 'ar', 'seotools', 'Auditor Reports', 'تقارير المدقق', '2011-07-30 01:28:48'),
(6841, 'ar', 'seotools', 'Auditor Settings', 'إعدادات المدقق', '2011-07-30 01:28:48'),
(6842, 'ar', 'seotools', 'Automatic Submission', 'تقديم التلقائي', '2011-07-30 01:28:48'),
(6843, 'ar', 'seotools', 'backlink-checker', 'مدقق الروابط المتصلة', '2011-07-30 01:28:48'),
(6844, 'ar', 'seotools', 'Backlinks Reports', 'تقارير الروابط المتصلة', '2011-07-30 01:28:48'),
(6845, 'ar', 'seotools', 'Check Submission Status', 'تحقق حالة التقديم', '2011-07-30 01:28:48'),
(6846, 'ar', 'seotools', 'clickgeneratereports', 'إضغط على<b>تفعيل</b>لإنشاء التقارير.', '2011-07-30 01:28:48'),
(6847, 'ar', 'seotools', 'Detailed Position Reports', 'تقارير وظيفية مفصلة', '2011-07-30 01:28:48'),
(6848, 'ar', 'seotools', 'directory-submission', 'تقديم الاقسام', '2011-07-30 01:28:48'),
(6849, 'ar', 'seotools', 'Featured Submission', 'تقديم مميز', '2011-07-30 01:28:48'),
(6850, 'ar', 'seotools', 'Generate Backlinks Reports', 'إنشاء تقارير حول الروابط المتصلة', '2011-07-30 01:28:48'),
(6851, 'ar', 'seotools', 'Generate Keyword Reports', 'إنشاء تقارير حول كلمات البحث', '2011-07-30 01:28:48'),
(6852, 'ar', 'seotools', 'Generate Rank Reports', 'إنشاء تقارير حول ترتيب البيج رنك', '2011-07-30 01:28:48'),
(6853, 'ar', 'seotools', 'Generate Saturation Reports', 'إنشاء تقارير مشبعة', '2011-07-30 01:28:48'),
(6854, 'ar', 'seotools', 'Google Sitemap Generator', 'مولد خريطة جوجل', '2011-07-30 01:28:48'),
(6855, 'ar', 'seotools', 'Graphical Position Reports', 'تقارير المركز الرسومية', '2011-07-30 01:28:48'),
(6856, 'ar', 'seotools', 'Import Project Links', 'خيارات استيراد المشروع', '2011-07-30 01:28:48'),
(6857, 'ar', 'seotools', 'Keyword Position Summary', 'ملخص الموقف لكلمات البحث', '2011-07-30 01:28:48'),
(6858, 'ar', 'seotools', 'keyword-position-checker', 'التحقق من موقف كلمات البحث', '2011-07-30 01:28:48'),
(6859, 'ar', 'seotools', 'Keywords Manager', 'إدارة الكلمات الرئيسية', '2011-07-30 01:28:48'),
(6860, 'ar', 'seotools', 'Quick Backlinks Checker', 'فحص سريع للروابط المتصلة', '2011-07-30 01:28:48'),
(6861, 'ar', 'seotools', 'Quick Position Checker', 'التحقق السريع للموقف', '2011-07-30 01:28:48'),
(6862, 'ar', 'seotools', 'Quick Rank Checker', 'التحقق السريع للبيج رنك', '2011-07-30 01:28:48'),
(6863, 'ar', 'seotools', 'Quick Saturation Checker', 'التحقق السريع من التشبع', '2011-07-30 01:28:48'),
(6864, 'ar', 'seotools', 'Rank Reports', 'تقارير البيج رنك', '2011-07-30 01:28:48'),
(6865, 'ar', 'seotools', 'rank-checker', 'التحقق من البيج رنك', '2011-07-30 01:28:48'),
(6866, 'ar', 'seotools', 'Saturation Reports', 'التحقق من التشبع', '2011-07-30 01:28:48'),
(6867, 'ar', 'seotools', 'saturation-checker', 'محرك البحث المشبع', '2011-07-30 01:28:48'),
(6868, 'ar', 'seotools', 'site-auditor', 'مدقق الموقع', '2011-07-30 01:28:48'),
(6869, 'ar', 'seotools', 'sitemap-generator', 'مولد خريطة البحث', '2011-07-30 01:28:48'),
(6870, 'ar', 'seotools', 'Skipped Directories', 'تخطي الاقسام', '2011-07-30 01:28:48'),
(6871, 'ar', 'seotools', 'Submission Reports', 'تقديم التقارير', '2011-07-30 01:28:48'),
(6872, 'ar', 'seotools', 'User Access', 'صلاحية العضو', '2011-07-30 01:28:48'),
(6873, 'ar', 'saturation', 'clickproceedsaturation', 'ضع الروابط<b>واحدا تلو الاخر</b>. ومن ثم إضغط على<b>تفعيل</b>للتحقق من نتائج محرك البحث المشبعة.', '2011-07-30 01:31:02'),
(6874, 'ar', 'saturation', 'GenerateSaturationReports', 'إنشاء تقارير محرك البحث المشبعة', '2011-07-30 01:31:02'),
(6875, 'ar', 'saturation', 'Quick Search Engine Saturation Checker', 'التحقق السريع لمحرك البحث المشبع', '2011-07-30 01:31:02'),
(6876, 'ar', 'saturation', 'Saved Search Engine Saturation results of', 'النتائج المحفوظة لمحرك البحث المشبع من', '2011-07-30 01:31:02'),
(6877, 'ar', 'saturation', 'Search Engine Saturation Reports', 'تقارير محرك البحث المشبع', '2011-07-30 01:31:02'),
(6878, 'ar', 'rank', 'enterurlproceed', 'ضع الروابط<b>واحدا تلو الاخر</b>. ومن ثم إضغط على<b>تفعيل</b>للتحقق من نقاط جوجل بيج رنك وأليكسا.', '2011-07-30 01:32:35'),
(6879, 'ar', 'rank', 'Google and Alexa Rank Reports', 'تقارير جوجل بيج رنك وأليكسا', '2011-07-30 01:32:35'),
(6880, 'ar', 'rank', 'Saved rank results of', 'نتائج الترتيب المحفوظ من', '2011-07-30 01:32:35'),
(6881, 'ar', 'proxy', 'Edit Proxy', 'تعديل البروكسي', '2011-07-30 01:33:16'),
(6882, 'ar', 'proxy', 'Proxy Password', 'كلمة مرور البروكسي', '2011-07-30 01:33:16'),
(6883, 'ar', 'proxy', 'Proxy Username', 'اسم المستخدم للبروكسي', '2011-07-30 01:33:16'),
(6884, 'ar', 'proxy', 'Proxyalreadyexist', 'البروكسي موجود مسبقا', '2011-07-30 01:33:16'),
(6885, 'ar', 'plugin', 'Edit Seo Plugin', 'تحرير إضافة محسن محرك البحث', '2011-07-30 01:33:57'),
(6886, 'ar', 'plugin', 'Plugin Name', 'إسم الإضافة', '2011-07-30 01:33:57'),
(6887, 'ar', 'plugin', 'Seo Plugin Details', 'تفاصيل إضافة محسن محرك البحث', '2011-07-30 01:33:57'),
(6888, 'ar', 'panel', 'About Us', 'من نحن', '2011-07-30 01:37:52'),
(6889, 'ar', 'panel', 'Add following command to your cron tab', 'أضف الاوامر التالية للكرون تاب الخاص بك', '2011-07-30 01:37:52'),
(6890, 'ar', 'panel', 'alsocheckfollowlink', 'وأيضا قم بلتحقق من الرابط التالي إذا كنت بحاجة لمعلومات أخرى.', '2011-07-30 01:37:52'),
(6891, 'ar', 'panel', 'Check Directory', 'تحقق من القسم', '2011-07-30 01:37:52'),
(6892, 'ar', 'panel', 'Cron Command', 'أمر الكرون تاب', '2011-07-30 01:37:52'),
(6893, 'ar', 'panel', 'Directory Manager', 'مدير الاقسام', '2011-07-30 01:37:52'),
(6894, 'ar', 'panel', 'Edit My Profile', 'تعديل الملف الشخصي', '2011-07-30 01:37:52'),
(6895, 'ar', 'panel', 'Edit Project', 'تحرير المشروع', '2011-07-30 01:37:52'),
(6896, 'ar', 'panel', 'My Profile', 'ملفي الشخصي', '2011-07-30 01:37:52'),
(6897, 'ar', 'panel', 'New Project', 'مشروع جديد', '2011-07-30 01:37:52'),
(6898, 'ar', 'panel', 'New Proxy', 'بروكسي جديد', '2011-07-30 01:37:52'),
(6899, 'ar', 'panel', 'New User', 'مستخدم جديد', '2011-07-30 01:37:52'),
(6900, 'ar', 'panel', 'New Website', 'موقع جديد', '2011-07-30 01:37:52'),
(6901, 'ar', 'panel', 'Proxy Manager', 'مدير البروكسي', '2011-07-30 01:37:52'),
(6902, 'ar', 'panel', 'Report Generation Manager', 'مدير إنشاء التقرير', '2011-07-30 01:37:52'),
(6903, 'ar', 'panel', 'Reports Manager', 'مدير التقارير', '2011-07-30 01:37:52'),
(6904, 'ar', 'panel', 'Seo Plugins Manager', 'مدير إضافة محسن محرك البحث', '2011-07-30 01:37:52'),
(6905, 'ar', 'panel', 'Seo Tools Manager', 'مدير أدوات محسن محرك البحث', '2011-07-30 01:37:52'),
(6906, 'ar', 'panel', 'System Settings', 'إعدادات النظام', '2011-07-30 01:37:52'),
(6907, 'ar', 'panel', 'User Manager', 'مدير المستخدم', '2011-07-30 01:37:52'),
(6908, 'ar', 'panel', 'Website Manager', 'مدير الموقع', '2011-07-30 01:37:52'),
(6909, 'ar', 'login', 'Confirm Password', 'تاكيد كلمة المرور', '2011-07-30 01:40:13'),
(6910, 'ar', 'login', 'Create my account', 'إنشاء حسابي', '2011-07-30 01:40:13'),
(6911, 'ar', 'login', 'Create New Account', 'إنشاء حساب جديد', '2011-07-30 01:40:13'),
(6912, 'ar', 'login', 'Email', 'بريد إلكتروني', '2011-07-30 01:40:13'),
(6913, 'ar', 'login', 'emailexist', 'البريد الإلكتروني مسجل من قبل', '2011-07-30 01:40:13'),
(6914, 'ar', 'login', 'Enter the code as it is shown', 'ضع رمز التحقق كما هو', '2011-07-30 01:40:13'),
(6915, 'ar', 'login', 'First Name', 'الإسم الأول', '2011-07-30 01:40:13'),
(6916, 'ar', 'login', 'Last Name', 'الإسم الاخير', '2011-07-30 01:40:13'),
(6917, 'ar', 'login', 'Login', 'دخول', '2011-07-30 01:40:13'),
(6918, 'ar', 'login', 'Login incorrect', 'الدخول غير صحيح', '2011-07-30 01:40:13'),
(6919, 'ar', 'login', 'newaccountsuccess', 'تم إنشاء الحساب الجديد بنجاح', '2011-07-30 01:40:13'),
(6920, 'ar', 'login', 'Password', 'كلمة المرور', '2011-07-30 01:40:13'),
(6921, 'ar', 'login', 'Password incorrect', 'كلمة المرور خاطئة', '2011-07-30 01:40:13'),
(6922, 'ar', 'login', 'Register', 'تسجيل', '2011-07-30 01:40:13'),
(6923, 'ar', 'login', 'Sign in to your account', 'سجل دخول بحسابك', '2011-07-30 01:40:13'),
(6924, 'ar', 'login', 'User inactive', 'عضو نشط', '2011-07-30 01:40:13'),
(6925, 'ar', 'login', 'Username', 'المستخدم', '2011-07-30 01:40:13'),
(6926, 'ar', 'login', 'usernameexist', 'المستخدم موجود من قبل', '2011-07-30 01:40:13'),
(6927, 'ar', 'label', 'already exist', 'موجود من قبل', '2011-07-30 01:44:19'),
(6928, 'ar', 'label', 'Authentication', 'التحقق', '2011-07-30 01:44:19'),
(6929, 'ar', 'label', 'Author', 'المدقق', '2011-07-30 01:44:19'),
(6930, 'ar', 'label', 'Brocken', 'معطل', '2011-07-30 01:44:19'),
(6931, 'ar', 'label', 'Click Here', 'إضغط هنا', '2011-07-30 01:44:19'),
(6932, 'ar', 'label', 'Comments', 'تعليقات', '2011-07-30 01:44:19'),
(6933, 'ar', 'label', 'Count', 'الإحصائية', '2011-07-30 01:44:19'),
(6934, 'ar', 'label', 'Cron', 'كرون تاب', '2011-07-30 01:44:19'),
(6935, 'ar', 'label', 'Description', 'وصف', '2011-07-30 01:44:19'),
(6936, 'ar', 'label', 'Developers', 'المبرمجون', '2011-07-30 01:44:19'),
(6937, 'ar', 'label', 'Download', 'تحميل', '2011-07-30 01:44:19'),
(6938, 'ar', 'label', 'Exclude', 'إستثناء', '2011-07-30 01:44:19'),
(6939, 'ar', 'label', 'Include', 'إدراج', '2011-07-30 01:44:19'),
(6940, 'ar', 'label', 'Installation', 'عملية التنصيب', '2011-07-30 01:44:19'),
(6941, 'ar', 'label', 'Keywords', 'كلمة البحث', '2011-07-30 01:44:19'),
(6942, 'ar', 'label', 'noactiveplugins', 'لايوجد إضافات لمحسن محرك البحث مفعله حاليا', '2011-07-30 01:44:19'),
(6943, 'ar', 'label', 'Plugin', 'إضافة', '2011-07-30 01:44:19'),
(6944, 'ar', 'label', 'Port', 'منفذ', '2011-07-30 01:44:19'),
(6945, 'ar', 'label', 'Project', 'مشروع', '2011-07-30 01:44:19'),
(6946, 'ar', 'label', 'Proxy', 'بروكسي', '2011-07-30 01:44:19'),
(6947, 'ar', 'label', 'Re-install', 'إعادة تنصيب', '2011-07-30 01:44:19'),
(6948, 'ar', 'label', 'Report Type', 'نوع التقرير', '2011-07-30 01:44:19'),
(6949, 'ar', 'label', 'Score', 'النقاط', '2011-07-30 01:44:19'),
(6950, 'ar', 'label', 'Sponsors', 'رعايا', '2011-07-30 01:44:19'),
(6951, 'ar', 'label', 'Title', 'عنوان', '2011-07-30 01:44:19'),
(6952, 'ar', 'label', 'Total Results', 'مجموع النتائج', '2011-07-30 01:44:19'),
(6953, 'ar', 'label', 'translation by', 'تم التعريب والنطوير بواسطة', '2011-07-30 01:44:19'),
(6954, 'ar', 'label', 'Translators', 'مترجمون ومطورون', '2011-07-30 01:44:19'),
(6955, 'ar', 'label', 'Updated', 'محدث', '2011-07-30 01:44:19'),
(6956, 'ar', 'label', 'Upgrade', 'ترقية', '2011-07-30 01:44:19'),
(6957, 'ar', 'label', 'Version', 'إصدار', '2011-07-30 01:44:19'),
(6958, 'ar', 'label', 'View Reports', 'عرض التقارير', '2011-07-30 01:44:19'),
(6959, 'ar', 'label', 'wantproceed', 'هل تريد حقا من المتابعة؟', '2011-07-30 01:44:19'),
(6960, 'ar', 'keyword', 'Crawling keyword', 'زحف كلمات البحث', '2011-07-30 02:01:13'),
(6961, 'ar', 'keyword', 'Detailed Keyword Position Reports', 'تقارير مفصلة لمعلومات كلمات البحث', '2011-07-30 02:01:13'),
(6962, 'ar', 'keyword', 'Edit Keyword', 'تحرير كلمة البحث', '2011-07-30 02:01:13'),
(6963, 'ar', 'keyword', 'Graphical Keyword Position Reports', 'رسم بياني مفصل لكلمات البحث', '2011-07-30 02:01:13'),
(6964, 'ar', 'keyword', 'Import Keywords', 'إستيراد كلمات البحث', '2011-07-30 02:01:13'),
(6965, 'ar', 'keyword', 'Insert keywords separated with comma', 'أرفاق كلمات بحث مبتاعدة بفواصل', '2011-07-30 02:01:13'),
(6966, 'ar', 'keyword', 'Keyword already exist', 'كلمة البحث موجودة مسبقا', '2011-07-30 02:01:13'),
(6967, 'ar', 'keyword', 'Keyword Position Report', 'تقرير مركز لكلمة البحث', '2011-07-30 02:01:13'),
(6968, 'ar', 'keyword', 'New Keyword', 'كلمة بحث جديدة', '2011-07-30 02:01:13'),
(6969, 'ar', 'keyword', 'not assigned to required search engines', 'لم يتم تعيينها لمتطلبات محركات البحث', '2011-07-30 02:01:13'),
(6970, 'ar', 'keyword', 'pleaseselecttool', 'كحد أدنى يمكنك إختيار أداة واحدة لتحسن محرك البحث', '2011-07-30 02:01:13'),
(6971, 'ar', 'keyword', 'Quick Keyword Position Checker', 'التحقق السريع لكلمة البحث', '2011-07-30 02:01:13'),
(6972, 'ar', 'keyword', 'results from ', 'النتائج من', '2011-07-30 02:01:13'),
(6973, 'ar', 'keyword', 'Show All results', 'عرض كافة النتائج', '2011-07-30 02:01:13'),
(6974, 'ar', 'keyword', 'Successfully crawled keyword', 'تم زحف كلمة البحث بنجاح', '2011-07-30 02:01:13'),
(6975, 'ar', 'keyword', 'to create new keywords', 'لإنشاء كلمة بحث جديدة', '2011-07-30 02:01:13'),
(6976, 'ar', 'directory', 'Add back to directory list', 'إضافة إلى قائمة الأقسام', '2011-07-30 02:28:07'),
(6977, 'ar', 'directory', 'Approved', 'تم الموافقة عليه', '2011-07-30 02:28:07'),
(6978, 'ar', 'directory', 'Captcha', 'رمز التحقق', '2011-07-30 02:28:07'),
(6979, 'ar', 'directory', 'categorynote', 'الاقسام, متباعدون بفاصلة بين بعضهم حسب أهمية القسم. مبتدأين بلقسم الأكثر أهمية.', '2011-07-30 02:28:07'),
(6980, 'ar', 'directory', 'Check Directory Status', 'تفقد حالة القسم', '2011-07-30 02:28:07'),
(6981, 'ar', 'directory', 'Check Directory Submission Status', 'تفقد حالة القسم المقدمة', '2011-07-30 02:28:07'),
(6982, 'ar', 'directory', 'clicktoproceeddirsts', 'إضغط هنا<b>للتفعيل</b>ولتفقد حالة القسم.', '2011-07-30 02:28:07'),
(6983, 'ar', 'directory', 'Confirmation', 'تأكيد', '2011-07-30 02:28:07'),
(6984, 'ar', 'directory', 'desnote', 'بعض الاقسام تتطلب كحد أدنى 150 حرف في خانة الوصف.', '2011-07-30 02:28:07'),
(6985, 'ar', 'directory', 'Directories with out captcha', 'القسم بدون تحقق', '2011-07-30 02:28:07'),
(6986, 'ar', 'directory', 'Directory Submission Reports', 'تقديم تقارير القسم', '2011-07-30 02:28:07'),
(6987, 'ar', 'directory', 'Enter the code shown', 'قم بكتابة الكود', '2011-07-30 02:28:07'),
(6988, 'ar', 'directory', 'nocatnote', 'لم يتم العثور على فئة التقديم في صفحة التقديم. يرجى الضغط على <b>Reload</b> أو <b>skip</b>.', '2011-07-30 02:28:07'),
(6989, 'ar', 'directory', 'nodirnote', 'لايوجد <b>Active</b> قسم موجود.', '2011-07-30 02:28:07'),
(6990, 'ar', 'directory', 'nosuccessnote', 'لم تحصل على رسالة نجاح, يرجى التحقق من وصول رسالة لبريديك لتأكيد الرسالة.', '2011-07-30 02:28:07'),
(6991, 'ar', 'directory', 'optionalnote', 'عنوان ووصف إختياري لطلب تقديم عنوان ووصف عشوائي لنتائج أفضل.', '2011-07-30 02:28:07'),
(6992, 'ar', 'directory', 'Owner Email', 'بريد المالك', '2011-07-30 02:28:07'),
(6993, 'ar', 'directory', 'Owner Name', 'إسم المالك', '2011-07-30 02:28:07'),
(6994, 'ar', 'directory', 'Pending', 'في الإنتظار', '2011-07-30 02:28:07'),
(6995, 'ar', 'directory', 'Please select a website to proceed', 'يرجى تحديد موقع للتفعيل', '2011-07-30 02:28:07'),
(6996, 'ar', 'directory', 'Reciprocal Link', 'روابط متبادلة', '2011-07-30 02:28:07'),
(6997, 'ar', 'directory', 'selectwebsiteproceed', 'إختر <b>Website</b> إلى <b>Proceed</b> قسم التقديم.<br>Check<b>أقسام بدون رمز تحقق</b> لتقديم الاقسام بدون رمز تحقق.', '2011-07-30 02:28:07'),
(6998, 'ar', 'directory', 'selectwebsiteschecksub', 'إختر <b>Website</b> حتى يتم <b>Proceed</b> قسم التقديم.', '2011-07-30 02:28:07'),
(6999, 'ar', 'directory', 'Semi Automatic Directory Submission Tool', 'أداة مشابهه للتقديم التلقائي', '2011-07-30 02:28:07'),
(7000, 'ar', 'directory', 'spamemailnote', 'بعض الاقسام ستقوم بإرسال بعض الرسائل المزعجة, لاننصحك حاليا بإستخدام بريد بديل بحسابك.', '2011-07-30 02:28:07'),
(7001, 'ar', 'directory', 'Submission Details', 'تقديم مفصل', '2011-07-30 02:28:07'),
(7002, 'ar', 'directory', 'Submit Description', 'تقديم الوصف', '2011-07-30 02:28:07'),
(7003, 'ar', 'directory', 'Submit Keywords', 'تقديم كلمات البحث', '2011-07-30 02:28:07'),
(7004, 'ar', 'directory', 'Submit Title', 'تقديم العنوان', '2011-07-30 02:28:07'),
(7005, 'ar', 'directory', 'Website Category', 'عنوان الموقع', '2011-07-30 02:28:07'),
(7006, 'ar', 'directory', 'Website Url', 'رابط الموقع', '2011-07-30 02:28:07'),
(7007, 'ar', 'home', 'Account Summary', 'ملخص الحساب', '2011-08-04 08:07:28'),
(7008, 'ar', 'home', 'Backlinks', 'روابط متصلة', '2011-08-04 08:07:29'),
(7009, 'ar', 'home', 'Directory Submission', 'دليل التقديم', '2011-08-04 08:07:29'),
(7010, 'ar', 'home', 'home_cont1', '<h1 style=\\"text-align: center;margin-bottom: 30px;font-size: 19px;\\">مرحبا بك في لوحة التحكم أول برنامج في الشرق الأوسط لتدشين مواقعكم بكلمات البحث الدلالية</h1>\r\n       <p>\r\n           <b>البرنامج المتكامل مفتوح المصدر لتحسين محركات البحث في الشرق الأوسط</b>وللتحكم<b>بمحركات البحث للمواقع الإلكترونية</b>\r\n           <b>يعتبر برنامج تحسين محركات البحث مفتوح المصدر ومجاني للجميع بلإضافة لإستطاعة مستخدمينه من إنشاء إضافات خاصة لهم في هذا البرنامج من خلال<a href=\\"<?=SP_PLUGINSITE?>\\" target=\\"_blank\\">إضافات المحرك</a>.\r\n</p><p></p><p>\r\nتم إقلاع هذا البرنامج في <b>شهر 1 لسنة 2010</b>من خلال هذه الفترة, الالاف من أصحاب المواقع الإلكترونية قامو بلمشاركة في إستخدام هذا البرنامج مما يؤدي الى تعرف الالاف ومئات الالات من الزوار لمواقعهم من خلال محركات البحث المشهورة مثل شركة جوجل, وبينج, والياهو.</b>\r\nقم بإستخدام محسن كلمات البحث اليوم <b>وإستمتع</b> بكل مافيه من مميزات لأصحاب المواقع لإشهار مواقعهم بطريقة ذكية.\r\n</p>', '2011-08-04 08:07:29'),
(7011, 'ar', 'home', 'home_cont2', '<fieldset>\r\n<legend>ميزات اللوحة الرئيسية لمحسن محرك البحث<?=SP_INSTALLED?></legend>\r\n<ul class=\\"infobox\\">\r\n    <li>        \r\n        <h1>أداة تقديم كلمات الدلائل التلقائية</h1>\r\n        <p>\r\n            دليل المساعدة لأداة تقديم الكلمات الدلالية لمحرك البحث<b>لموقعنا</b>في طليعة الرئيسية<b>للإضافات المدفوعة والمجانية</b>.\r\n            يمكننا ايضا<b>من تعقب حالة</b>كل طلب تقديم من خلال<b>دورية طلبات الاختيار</b>بإستخدام<b>سكربت فحص الحالة</b>.\r\n            <b>إدارة كلمات الدلائل</b> ستقوم بمساعدتك بلعثور على <b>كلمات دلالية فعالة</b> أو لا.\r\n        </p>\r\n    </li>\r\n    <li> \r\n        <h1>فحص كلمات البحث </h1>\r\n        <p>\r\n            أداة فحص كلمات البحث ستقوم في العثور <b>على كلمات بحث فعالة في محركات البحث بدرجة جيدة جدا</b> من <b>كلمات البحث المدرجة من قبلك</b>\r\nلموقعك ومن خلال <b>حفظها في النظام</b>.\r\n            من خلال حالة فحص كلمات البحث يمكننا أن نرى<b>كلمات بحث معينة يوميا</b> لمحركات بحث عديدة <b>بمناظر جرافيكية جميلة ومفصلة</b> و <b>بتفاصل تقريرية حول حالتها</b>.\r\n        </p>\r\n    </li>\r\n    <li>        \r\n        <h1>موقع المحرر</h1>\r\n        <p>موقع المحرر سيقوم <b>بمراجعة جميل دلائل محركات البحث</b>لكل صفحة مقدمة من موقعك\r\n<b>بتقرير مفصل </b> لكل صفحة. وبلتالي ستقوم بإنشـاء ملفات <b>XML,HTML,TEXT</b>وخرائط لموقعك بصيغة فعالة لمحركات البحث\r\nوملفات موقعك <b>للتقديم</b> لمحركات البحث.</p>\r\n    </li>\r\n    <li> \r\n        <h1>فحص نقاط جوجل وأليكسا</h1>\r\n        <p>\r\n            فحص نقاط جوجل وأليكسا ستقوم بلعثور على <b>نقاط جوجل</b> و <b>نقاط اليكسا</b> لموقعنا <b>المحفوظ</b> في النظام.\r\n            في <b>تقارير خانة نقاط الموقع</b>,سنرى <b>بشكل يومي</b> نقاط جوجل واليكسا على شكل <b>تقارير مفصلة</b>.\r\n        </p>\r\n    </li>\r\n    <li> \r\n        <h1>فحص الروابط المتصلة</h1>\r\n        <p>\r\n            فحص الروابط المتصلة ستقوم بلعثور على <b>عدد الروابط المتصلة</b> لمواقعنا بمحركات بحث عديدة<b>(جوجل, اليكسا, بينج, ياهو, وغيرهم...)</b> بلإضافة إلى <b>حفظ النظام</b>لها في برنامجنا.\r\n            <br>في <b>خانة تقارير الروابط المتصلة</b>, سنرى<b>بشكل يومي تعداد الروابط المتصلة </b>لكل موقع <b>بتقارير مفصلة</b>.\r\n        </p>\r\n    </li>    \r\n    <li>     \r\n        <h1>مدقق فحص محركات البحث</h1>\r\n        <p>\r\n            مدقق الفحص لمحركات البحث سيقوم بلعثور على <b>عدد المواقع المؤرشفة لكل</b> لكل موقع في كل محرك بحث مثل<b>(جوجل, اليكسا, بينج, الياهو, وغيرهم...)</b> بلإضافة <b>لحفظهم</b> في نظامنا.\r\n            في <b>خانة مدقق الفحص لمحركات البحث</b> ,سنرى بشكل يومي تعداد <b>الصفحات المؤرشفة</b> لكل موقع <b>بتقارير مفصلة</b>.\r\n        </p>\r\n    </li>\r\n    <li>        \r\n        <h1>إضافاة لوحة محسن محرك البحث</h1>\r\n        <p>\r\n            الإستفادة<b>من هذه الخاصية</b> لإضافة محسن محرك البحث <b>متفرعة بشكل مميز جدا</b>.\r\n            لتمكين <b>إضافة لمحسن محرك البحث</b> للوحة التحكم الخاصة بك <b>وتمديد الفوائد</b> بحسب متطلباتك..\r\n            <a href=\\"<?=SP_PLUGINSITE?>\\" target=\\"_blank\\">إضافة لوحة محسن البحث</a> مزودة من قبل طاقم الإدارة لمحسن محرك البحث ومتطوعين للبرنامج\r\n            بحيث يمكنك بكل سهولة<b>develop</b> إضافة للوحة محسن محرك البحث لديك.\r\n            ويمكنك <a href=\\"<?=SP_PLUGINSITE?>\\"  target=\\"_blank\\">إضافة</a> إضافتك للوحة محسن محرك البحث وسنقوم <b>publish</b>في موقعنا الرسمي بعد مراجعتها و <b>review</b>بشكل كامل.\r\n        </p>\r\n    </li>\r\n    <li>    \r\n        <h1>مولد الكلمات الدلالية</h1>\r\n        <p>\r\n            أداة توليد الكلمات الدلالية تتوفر على<b>إضافة في لوحة تحكم محسن محرك البحث</b> لإنشـاء <b>custom meta tags</b> لموقعك.\r\n            ستساعدنا في توفير <b>معلومات اكثر</b> حول موقعنا <b>لعناكب محركات البحث</b>خلال زحفهم إلينا.\r\n        </p>\r\n    </li>\r\n</ul>\r\n</fieldset>', '2011-08-04 08:07:29'),
(7012, 'ar', 'home', 'home_cont3', '<fieldset>\r\n<legend>المصادر لوحة تحسين محرك البحث</legend>    \r\n<ul class=\\"infobox\\">\r\n\r\n   <li>\r\n        <h1>لوحة مصادر تحسين محرك البحث</h1>                \r\n        \r\n        \r\n        <p>\r\n            <a href=\\"http://www.seopanel.in\\" target=\\"_blank\\">الموقع الرسمي لتحسين محرك البحث</a>\r\n        </p>\r\n        <p>\r\n            <a href=\\"<?=SP_DOWNLOAD_LINK?>\\" target=\\"_blank\\">حمل برنامج محسن البحث</a>\r\n        </p>\r\n        \r\n        <p>\r\n            <a href=\\"<?=SP_DEMO_LINK?>\\" target=\\"_blank\\">لوحة تجريبية لمحسن محرك البحث</a>\r\n        </p>\r\n        \r\n        <p>\r\n            <a href=\\"<?=SP_CONTACT_LINK?>\\" target=\\"_blank\\">إتصل بإدارة محسن محرك البحث</a>\r\n        </p>\r\n        \r\n        <p>\r\n            <a href=\\"<?=SP_HELP_LINK?>\\" target=\\"_blank\\">دليل المستخدم لمحسن محرك البحث</a>\r\n        </p>\r\n        \r\n        <p>\r\n            <a href=\\"<?=SP_FORUM_LINK?>\\" target=\\"_blank\\">ملتقى أعضاء محسن محرك البحث</a>\r\n        </p>\r\n        \r\n        <p>\r\n            <a href=\\"<?=SP_SUPPORT_LINK?>\\" target=\\"_blank\\">نظام مساعدة محسن محرك البحث</a>\r\n        </p>\r\n        \r\n        <p>\r\n            <a href=\\"<?=SP_DONATE_LINK?>\\" target=\\"_blank\\">تبرع لمساعدة إدارة محرك البحث للمزيد من الإضافاة الذكية</a>\r\n        </p>\r\n    </li>\r\n    \r\n</ul>\r\n</fieldset>', '2011-08-04 08:07:29'),
(7013, 'ar', 'home', 'Indexed', 'مؤرشف', '2011-08-04 08:07:29'),
(7014, 'ar', 'home', 'Pages Indexed', 'صفحة مؤرشفة', '2011-08-04 08:07:29'),
(7015, 'ar', 'home', 'Ranks', 'ترتيب الموقع', '2011-08-04 08:07:29'),
(7016, 'ar', 'home', 'SiteNameUrl', 'إسم الموقع - الرابط', '2011-08-04 08:07:29'),
(7017, 'ar', 'home', 'Website Statistics', 'إحصائية الموقع', '2011-08-04 08:07:29'),
(7018, 'he', 'button', 'Cancel', 'ביטול', '2014-01-08 19:27:21'),
(7019, 'he', 'button', 'Check Status', 'בדוק סטטוס', '2014-01-08 19:27:21'),
(7020, 'he', 'button', 'Proceed', 'המשך', '2014-01-08 19:27:21'),
(7021, 'he', 'button', 'Reload', 'טען מחדש', '2014-01-08 19:27:21'),
(7022, 'he', 'button', 'Show Details', 'הצג פרטים', '2014-01-08 19:27:21'),
(7023, 'he', 'button', 'Show Records', 'הצג רשומות', '2014-01-08 19:27:21'),
(7024, 'he', 'button', 'Skip', 'דלג', '2014-01-08 19:27:21'),
(7025, 'he', 'button', 'Submit', 'אישור', '2014-01-08 19:27:21'),
(7026, 'he', 'login', 'Confirm Password', 'אמת סיסמה', '2011-09-06 08:48:12'),
(7027, 'he', 'login', 'Create my account', 'צור את החשבון שלי', '2011-09-06 08:48:12'),
(7028, 'he', 'login', 'Create New Account', 'צור חשבון חדש', '2011-09-06 08:48:12'),
(7029, 'he', 'login', 'Email', 'דואר אלקטרוני', '2011-09-06 08:48:12'),
(7030, 'he', 'login', 'emailexist', 'כתובת הדואר אלקטרוני כבר קיימת במערכת!', '2011-09-06 08:48:12'),
(7031, 'he', 'login', 'Enter the code as it is shown', 'הכנס את הקוד אשר מופיע', '2011-09-06 08:48:12'),
(7032, 'he', 'login', 'First Name', 'שם פרטי', '2011-09-06 08:48:12'),
(7033, 'he', 'login', 'Last Name', 'שם משפחה', '2011-09-06 08:48:12'),
(7034, 'he', 'login', 'Login', 'כניסה', '2011-09-06 08:48:12'),
(7035, 'he', 'login', 'Login incorrect', 'כניסה לא נכונה', '2011-09-06 08:48:12'),
(7036, 'he', 'login', 'newaccountsuccess', 'חשבון חדש נוצר בהצלחה!', '2011-09-06 08:48:12'),
(7037, 'he', 'login', 'Password', 'סיסמה', '2011-09-06 08:48:12'),
(7038, 'he', 'login', 'Password incorrect', 'סיסמה שגויה', '2011-09-06 08:48:12'),
(7039, 'he', 'login', 'Register', 'הרשם', '2011-09-06 08:48:12'),
(7040, 'he', 'login', 'Sign in to your account', 'התחבר לחשבונך', '2011-09-06 08:48:12'),
(7041, 'he', 'login', 'User inactive', 'משתמש לא פעיל', '2011-09-06 08:48:12'),
(7042, 'he', 'login', 'Username', 'שם משתמש', '2011-09-06 08:48:12'),
(7043, 'he', 'login', 'usernameexist', 'שם המשתמש כבר קיים במערכת!', '2011-09-06 08:48:12'),
(7044, 'he', 'website', 'Edit Website', 'ערוך אתר', '2011-08-11 22:32:15'),
(7045, 'he', 'website', 'plscrtwebsite', 'אנא הכנס אתר למערכת לפני תחילת השימוש במערכת', '2011-08-11 22:32:15'),
(7046, 'he', 'website', 'Website already exist', 'האתר כבר קיים', '2011-08-11 22:32:15'),
(7047, 'he', 'website', 'yourwebalreday', 'האתר שלך במידה ויצרת אחד', '2011-08-11 22:32:15'),
(7048, 'he', 'user', 'Edit User', 'ערוך משתמש', '2011-08-11 22:33:05'),
(7049, 'he', 'user', 'Saved My Profile Details', 'שמור את הפרטים שלי', '2011-08-11 22:33:05'),
(7050, 'he', 'settings', 'Check for Updates', 'בדוק עידכונים', '2011-08-11 22:50:44'),
(7051, 'he', 'settings', 'Click here to become a sponsor for Seo Panel', '<b>תרום 100$</a> בכדי להיות <b>ספונסר</b> of Seo Panel.', '2011-08-11 22:50:44'),
(7052, 'he', 'settings', 'SA_CRAWL_DELAY_TIME', '', '2011-08-11 22:50:44'),
(7053, 'he', 'settings', 'SA_MAX_NO_PAGES', '', '2011-08-11 22:50:44'),
(7054, 'he', 'settings', 'seopanel_description', '', '2011-08-11 22:50:44'),
(7055, 'he', 'settings', 'seopanel_title', '', '2011-08-11 22:50:44'),
(7056, 'he', 'settings', 'SP_API_KEY', '', '2011-08-11 22:50:44'),
(7057, 'he', 'settings', 'SP_CRAWL_DELAY', '', '2011-08-11 22:50:44'),
(7058, 'he', 'settings', 'SP_DEFAULTLANG', 'שפה ברירת מחדל', '2011-08-11 22:50:44'),
(7059, 'he', 'settings', 'SP_DESCRIPTION', '', '2011-08-11 22:50:44'),
(7060, 'he', 'settings', 'SP_ENABLE_PROXY', 'אפשר פרוקסי', '2011-08-11 22:50:44'),
(7061, 'he', 'settings', 'SP_HOTLINKING', '', '2011-08-11 22:50:44'),
(7062, 'he', 'settings', 'SP_KEYWORDS', '', '2011-08-11 22:50:44'),
(7063, 'he', 'settings', 'SP_PAGINGNO', '', '2011-08-11 22:50:44'),
(7064, 'he', 'settings', 'SP_TITLE', '', '2011-08-11 22:50:44'),
(7065, 'he', 'settings', 'SP_USER_AGENT', '', '2011-08-11 22:50:44'),
(7066, 'he', 'settings', 'SP_USER_GEN_REPORT', '', '2011-08-11 22:50:44'),
(7067, 'he', 'settings', 'SP_USER_REGISTRATION', '', '2011-08-11 22:50:44'),
(7068, 'he', 'settings', 'syssettingssaved', '', '2011-08-11 22:50:44'),
(7069, 'he', 'settings', 'versionnotuptodatemsg', '', '2011-08-11 22:50:44'),
(7070, 'he', 'settings', 'Your Seo Panel installation is up to date', '', '2011-08-11 22:50:44'),
(7071, 'he', 'common', 'Action', 'פעולה', '2011-09-06 08:27:27'),
(7072, 'he', 'common', 'Activate', 'הפעל', '2011-09-06 08:27:27'),
(7073, 'he', 'common', 'Active', 'פועל', '2011-09-06 08:27:27'),
(7074, 'he', 'common', 'Admin Panel', 'ממשק ניהול', '2011-09-06 08:27:27'),
(7075, 'he', 'common', 'Alexa Rank', 'ניקוד Alaxa', '2011-09-06 08:27:27'),
(7076, 'he', 'common', 'All', 'הכל', '2011-09-06 08:27:27'),
(7077, 'he', 'common', 'Category', 'קטגוריה', '2011-09-06 08:27:27'),
(7078, 'he', 'common', 'contact', 'צור קשר', '2011-09-06 08:27:27'),
(7079, 'he', 'common', 'copyright', 'כל הזכויות שמורות [year] www.seopanel.in ', '2011-09-06 08:27:27'),
(7080, 'he', 'common', 'Country', 'ארץ', '2011-09-06 08:27:27'),
(7081, 'he', 'common', 'Crawl Meta Data', 'ייבא מידע מתגיות מטה', '2011-09-06 08:27:27'),
(7082, 'he', 'common', 'Date', 'תאריך', '2011-09-06 08:27:27'),
(7083, 'he', 'common', 'Delete', 'מחק', '2011-09-06 08:27:27'),
(7084, 'he', 'common', 'Details', 'פרטים', '2011-09-06 08:27:27'),
(7085, 'he', 'common', 'Directory', 'תיקיה', '2011-09-06 08:27:27'),
(7086, 'he', 'common', 'Donate', 'תרום', '2011-09-06 08:27:27'),
(7087, 'he', 'common', 'Edit', 'ערוך', '2011-09-06 08:27:27'),
(7088, 'he', 'common', 'Entry cannot be blank', 'השדה איננו יכול להיות ריק', '2011-09-06 08:27:27'),
(7089, 'he', 'common', 'entrynotvalid', 'הערך שהכנסת כנראה איננו חוקי', '2011-09-06 08:27:27'),
(7090, 'he', 'common', 'failed', 'נכשל', '2011-09-06 08:27:27'),
(7091, 'he', 'common', 'forum', 'פורום', '2011-09-06 08:27:27'),
(7092, 'he', 'common', 'Found', 'נמצאו', '2011-09-06 08:27:27'),
(7093, 'he', 'common', 'Google Pagerank', 'ניקוד גוגל(פייג ראנק)', '2011-09-06 08:27:27'),
(7094, 'he', 'common', 'help', 'עזרה', '2011-09-06 08:27:27'),
(7095, 'he', 'common', 'hidenews', 'הסתר פאנל חדשות', '2011-09-06 08:27:27'),
(7096, 'he', 'common', 'Id', 'מזהה', '2011-09-06 08:27:27'),
(7097, 'he', 'common', 'Inactivate', 'לא מופעל', '2011-09-06 08:27:27'),
(7098, 'he', 'common', 'Inactive', 'לא פעיל', '2011-09-06 08:27:27'),
(7099, 'he', 'common', 'Invalid characters', 'תווים לא חוקיים', '2011-09-06 08:27:27'),
(7100, 'he', 'common', 'Invalid code entered', 'קוד לא חוקי הוכנס', '2011-09-06 08:27:27'),
(7101, 'he', 'common', 'Invalid email address entered', 'אימייל לא חוקי הוכנס', '2011-09-06 08:27:27'),
(7102, 'he', 'common', 'Invalid value', 'ערך לא חוקי', '2011-09-06 08:27:27'),
(7103, 'he', 'common', 'Keyword', 'מילת מפתח', '2011-09-06 08:27:27'),
(7104, 'he', 'common', 'Keywords', 'מילות מפתח', '2011-09-06 08:27:27'),
(7105, 'he', 'common', 'lang', 'שפה', '2011-09-06 08:27:27'),
(7106, 'he', 'common', 'My Account', 'החשבון שלי', '2011-09-06 08:27:27'),
(7107, 'he', 'common', 'Name', 'שם', '2011-09-06 08:27:27'),
(7108, 'he', 'common', 'No', 'לא', '2011-09-06 08:27:27'),
(7109, 'he', 'common', 'No Keywords Found', 'לא נמצאו מילות מפתח', '2011-09-06 08:27:27'),
(7110, 'he', 'common', 'No Records Found', 'לא נמצאו רשומות', '2011-09-06 08:27:27'),
(7111, 'he', 'common', 'noactivetools', 'לא נמצאו כליי קידום', '2011-09-06 08:27:27'),
(7112, 'he', 'common', 'nowebsites', 'לא נמצאו אתרים', '2011-09-06 08:27:27'),
(7113, 'he', 'common', 'password632', 'אורך הסיסמה חייב להיות בין 6 ל 32 תווים', '2011-09-06 08:27:27'),
(7114, 'he', 'common', 'passwordnotmatch', 'הסיסמה אינה תואמת', '2011-09-06 08:27:27'),
(7115, 'he', 'common', 'Period', 'תקופה', '2011-09-06 08:27:27'),
(7116, 'he', 'common', 'Priority', 'דחיפות', '2011-09-06 08:27:27'),
(7117, 'he', 'common', 'Profile', 'פרופיל', '2011-09-06 08:27:27'),
(7118, 'he', 'common', 'Rank', 'ניקוד', '2011-09-06 08:27:27'),
(7119, 'he', 'common', 'Reports', 'דיווחים', '2011-09-06 08:27:27'),
(7120, 'he', 'common', 'Results', 'תוצאות', '2011-09-06 08:27:27'),
(7121, 'he', 'common', 'Search Engine', 'מנוע חיפוש', '2011-09-06 08:27:27'),
(7122, 'he', 'common', 'Select', 'בחר', '2011-09-06 08:27:27'),
(7123, 'he', 'common', 'Seo Plugins', 'תוספיי קידום אתרים', '2011-09-06 08:27:27'),
(7124, 'he', 'common', 'Seo Tools', 'כליי קידום אתרים', '2011-09-06 08:27:27'),
(7125, 'he', 'common', 'Sign out', 'התנתק', '2011-09-06 08:27:27'),
(7126, 'he', 'common', 'Sign Up', 'הרשם', '2011-09-06 08:27:27'),
(7127, 'he', 'common', 'signin', 'התחבר', '2011-09-06 08:27:27'),
(7128, 'he', 'common', 'Status', 'מצב', '2011-09-06 08:27:27'),
(7129, 'he', 'common', 'Support', 'תמיכה', '2011-09-06 08:27:27'),
(7130, 'he', 'common', 'Total', 'סה\\"כ', '2011-09-06 08:27:27'),
(7131, 'he', 'common', 'Url', 'כתובת', '2011-09-06 08:27:27'),
(7132, 'he', 'common', 'User', 'משתמש', '2011-09-06 08:27:27'),
(7133, 'he', 'common', 'User Panel', 'פאנל משתמש', '2011-09-06 08:27:27'),
(7134, 'he', 'common', 'Website', 'אתר', '2011-09-06 08:27:27'),
(7135, 'he', 'common', 'Yes', 'כן', '2011-09-06 08:27:27'),
(7136, 'he', 'directory', 'Add back to directory list', 'הוסף חזרה לרשימת מדריכי אתרים', '2011-09-07 19:42:42'),
(7137, 'he', 'directory', 'Approved', 'מאושר', '2011-09-07 19:42:42'),
(7138, 'he', 'directory', 'Captcha', 'אתגר מענה', '2011-09-07 19:42:42'),
(7139, 'he', 'directory', 'categorynote', 'קטגוריות, הפרד אותם על ידי פסיק לפי עדיפות. התחל עם החשובים ביותר.', '2011-09-07 19:42:42'),
(7140, 'he', 'directory', 'Check Directory Status', 'בדוק מצב מדריכי אתרים', '2011-09-07 19:42:42'),
(7141, 'he', 'directory', 'Check Directory Submission Status', 'בדוק מצב מדריכי אתרים', '2011-09-07 19:42:42'),
(7142, 'he', 'directory', 'clicktoproceeddirsts', 'לחץ על <b>המשך</b> בכדי לבדוק את מצב מדריכי האתרים', '2011-09-07 19:42:42'),
(7143, 'he', 'directory', 'Confirmation', 'אישור', '2011-09-07 19:42:42'),
(7144, 'he', 'directory', 'desnote', 'ישנם מדריכי אתרים אשר דורשים מינימום של 150 אותיות בשור התיאור', '2011-09-07 19:42:42'),
(7145, 'he', 'directory', 'Directories with out captcha', 'מדריכי אתרים ללא אתגר מענה', '2011-09-07 19:42:42'),
(7146, 'he', 'directory', 'Directory Submission Reports', 'דוחות שליחה למדריכי אתרים', '2011-09-07 19:42:42'),
(7147, 'he', 'directory', 'Enter the code shown', 'הכנס את הקוד המוצג', '2011-09-07 19:42:42'),
(7148, 'he', 'directory', 'nocatnote', 'הקטגוריה המבוקשת לא נמצאה בדף השליחה. לחץ על <b>טען</b> או<b>דלג</b> ', '2011-09-07 19:42:42'),
(7149, 'he', 'directory', 'nodirnote', 'לא נמצאו אתרי מדריכים <b>פעילים</b>', '2011-09-07 19:42:42'),
(7150, 'he', 'directory', 'nosuccessnote', 'לא התקבלה הודעת אישור, יש לבדוק את האימייל כדי לאשר משלוח', '2011-09-07 19:42:42'),
(7151, 'he', 'directory', 'optionalnote', 'כותרות ותיאורים רנדומלים לשליחה למדריכי אתרים לשם קבלת תוצאות טובות יותר (רשות)', '2011-09-07 19:42:42'),
(7152, 'he', 'directory', 'Owner Email', 'דואר אלקטרוני של הבעלים', '2011-09-07 19:42:42'),
(7153, 'he', 'directory', 'Owner Name', 'שם הבעלים', '2011-09-07 19:42:42'),
(7154, 'he', 'directory', 'Pending', 'ממתין', '2011-09-07 19:42:42'),
(7155, 'he', 'directory', 'Please select a website to proceed', 'אנא בחר אתר בכדיי להמשיך', '2011-09-07 19:42:42'),
(7156, 'he', 'directory', 'Reciprocal Link', 'לינק הדדי', '2011-09-07 19:42:42'),
(7157, 'he', 'directory', 'selectwebsiteproceed', '', '2011-09-07 19:42:42'),
(7158, 'he', 'directory', 'selectwebsiteschecksub', 'בחר <b>אתר</b> כדיי<b>להמשיך</b> לבדוק . ', '2011-09-07 19:42:42'),
(7159, 'he', 'directory', 'Semi Automatic Directory Submission Tool', 'שליחה חצי-אוטומטית למדריכי אתרים', '2011-09-07 19:42:42'),
(7160, 'he', 'directory', 'spamemailnote', 'מספר מדריכי אתרים עלולים לשלוח דואר זבל, אנו ממליצים לא להשתמש בכתובת המייל העיקרית.', '2011-09-07 19:42:42'),
(7161, 'he', 'directory', 'Submission Details', 'פרטי משלוח', '2011-09-07 19:42:42'),
(7162, 'he', 'directory', 'Submit Description', 'שלח תיאור', '2011-09-07 19:42:42'),
(7163, 'he', 'directory', 'Submit Keywords', 'שלח מילות מפתח', '2011-09-07 19:42:42'),
(7164, 'he', 'directory', 'Submit Title', 'שלח כותרת', '2011-09-07 19:42:42'),
(7165, 'he', 'directory', 'Website Category', 'קטגורית אתר', '2011-09-07 19:42:42'),
(7166, 'he', 'directory', 'Website Url', 'כתובת האתר', '2011-09-07 19:42:42'),
(7167, 'he', 'home', 'Account Summary', 'סיכום חשבון', '2011-09-06 08:41:37'),
(7168, 'he', 'home', 'Backlinks', 'לינקים אחוריים', '2011-09-06 08:41:37'),
(7169, 'he', 'home', 'Directory Submission', '', '2011-09-06 08:41:37'),
(7170, 'he', 'home', 'home_cont1', '', '2011-09-06 08:41:37'),
(7171, 'he', 'home', 'home_cont2', '', '2011-09-06 08:41:37'),
(7172, 'he', 'home', 'home_cont3', '', '2011-09-06 08:41:37'),
(7173, 'he', 'home', 'Indexed', 'מאונדקסים', '2011-09-06 08:41:37'),
(7174, 'he', 'home', 'Pages Indexed', 'דפים מאונדקסים', '2011-09-06 08:41:37'),
(7175, 'he', 'home', 'Ranks', 'דירוג', '2011-09-06 08:41:37'),
(7176, 'he', 'home', 'SiteNameUrl', 'שם/כתובת האתר', '2011-09-06 08:41:37'),
(7177, 'he', 'home', 'Website Statistics', 'סטטיסטיקות אתר', '2011-09-06 08:41:37'),
(7178, 'he', 'proxy', 'Edit Proxy', 'ערוך פרוקסי', '2011-08-11 23:04:01'),
(7179, 'he', 'proxy', 'Proxy Password', 'פרוקסי - סיסמה', '2011-08-11 23:04:01'),
(7180, 'he', 'proxy', 'Proxy Username', 'פרוקסי - שם משתמש', '2011-08-11 23:04:01'),
(7181, 'he', 'proxy', 'Proxyalreadyexist', 'הפרוקסי כבר קיים', '2011-08-11 23:04:01'),
(7182, 'he', 'backlink', 'clickproceedbacklink', 'הכנס קישור <b>אחד לשורה</b>. לחץ על <b>המשך</b> בכדיי לבדוק את הקישורים', '2011-09-07 19:33:48'),
(7183, 'he', 'backlink', 'Saved backlink results of', 'תוצאות שמורות של לינקים', '2011-09-07 19:33:48'),
(7184, 'he', 'label', 'already exist', 'כבר קיים', '2011-09-06 08:47:21'),
(7185, 'he', 'label', 'Authentication', 'אימות', '2011-09-06 08:47:21'),
(7186, 'he', 'label', 'Author', 'יוצר', '2011-09-06 08:47:21'),
(7187, 'he', 'label', 'Brocken', 'שבור', '2011-09-06 08:47:21'),
(7188, 'he', 'label', 'Click Here', 'לחץ כאן', '2011-09-06 08:47:21'),
(7189, 'he', 'label', 'Comments', 'תגובות', '2011-09-06 08:47:21'),
(7190, 'he', 'label', 'Count', 'מונה', '2011-09-06 08:47:21'),
(7191, 'he', 'label', 'Cron', 'קרון', '2011-09-06 08:47:21'),
(7192, 'he', 'label', 'Description', 'תיאור', '2011-09-06 08:47:21'),
(7193, 'he', 'label', 'Developers', 'מפתחים', '2011-09-06 08:47:21'),
(7194, 'he', 'label', 'Download', 'הורדה', '2011-09-06 08:47:21'),
(7195, 'he', 'label', 'Exclude', 'מנע', '2011-09-06 08:47:21'),
(7196, 'he', 'label', 'Include', 'כלול', '2011-09-06 08:47:21'),
(7197, 'he', 'label', 'Installation', 'התקנה', '2011-09-06 08:47:21'),
(7198, 'he', 'label', 'Keywords', 'מילות מפתח', '2011-09-06 08:47:21'),
(7199, 'he', 'label', 'noactiveplugins', 'לא קיימים תוספים פעילים לקידום אתרים!', '2011-09-06 08:47:21'),
(7200, 'he', 'label', 'Plugin', 'תוספים', '2011-09-06 08:47:21'),
(7201, 'he', 'label', 'Port', 'פורט', '2011-09-06 08:47:21'),
(7202, 'he', 'label', 'Project', 'פרוייקט', '2011-09-06 08:47:21'),
(7203, 'he', 'label', 'Proxy', 'פרוקסי', '2011-09-06 08:47:21'),
(7204, 'he', 'label', 'Re-install', 'התקנה מחודשת', '2011-09-06 08:47:21'),
(7205, 'he', 'label', 'Report Type', 'סוג דיווח', '2011-09-06 08:47:21'),
(7206, 'he', 'label', 'Score', 'תוצאה', '2011-09-06 08:47:21'),
(7207, 'he', 'label', 'Sponsors', 'תומכים', '2011-09-06 08:47:21'),
(7208, 'he', 'label', 'Title', 'כותרת', '2011-09-06 08:47:21'),
(7209, 'he', 'label', 'Total Results', 'סה\\"כ תוצאות', '2011-09-06 08:47:21'),
(7210, 'he', 'label', 'translation by', 'תורגם ע\\"י', '2011-09-06 08:47:21'),
(7211, 'he', 'label', 'Translators', 'מתרגמים', '2011-09-06 08:47:21'),
(7212, 'he', 'label', 'Updated', 'עודכן', '2011-09-06 08:47:21'),
(7213, 'he', 'label', 'Upgrade', 'שודרג', '2011-09-06 08:47:21');
INSERT INTO `texts` (`id`, `lang_code`, `category`, `label`, `content`, `changed`) VALUES
(7214, 'he', 'label', 'Version', 'גרסה', '2011-09-06 08:47:21'),
(7215, 'he', 'label', 'View Reports', 'צפה בדיווחים', '2011-09-06 08:47:21'),
(7216, 'he', 'label', 'wantproceed', 'האם אתה בטוח כי ברצונך להמשיך?', '2011-09-06 08:47:21'),
(7217, 'he', 'siteauditor', 'Anchor', 'עוגן', '2011-09-06 08:53:27'),
(7218, 'he', 'siteauditor', 'anylinkcontainabovelinks', 'כל לינק אשר מכיל את הלינקים הנ\\"ל יוסננו מהדו\\"ח', '2011-09-06 08:53:27'),
(7219, 'he', 'siteauditor', 'anylinkcontainexcludesitemap', 'כל לינק אשר מכיל את הלינקים הנ\\"ל יוסננו ממפת האתר', '2011-09-06 08:53:27'),
(7220, 'he', 'siteauditor', 'Check backlinks of pages', '', '2011-09-06 08:53:27'),
(7221, 'he', 'siteauditor', 'Check broken links in a page', 'בדוק לינקים שבורים באתר', '2011-09-06 08:53:27'),
(7222, 'he', 'siteauditor', 'Check google pagerank of pages', 'בדוק דירוג אתר של גוגל לדפים', '2011-09-06 08:53:27'),
(7223, 'he', 'siteauditor', 'Check pages indexed or not', 'בדוק דפים מאונדקסים או לא', '2011-09-06 08:53:27'),
(7224, 'he', 'siteauditor', 'Check Score', 'בדוק ניקוד', '2011-09-06 08:53:27'),
(7225, 'he', 'siteauditor', 'checkborckenlinkwait', 'בדיק לינקים שבורים יגדיל את זמן הריצה של הפרוייקט', '2011-09-06 08:53:27'),
(7226, 'he', 'siteauditor', 'Completed project execution', 'ריצת הפרוייקט הסתיימה', '2011-09-06 08:53:27'),
(7227, 'he', 'siteauditor', 'Crawled', '', '2011-09-06 08:53:27'),
(7228, 'he', 'siteauditor', 'Crawled Pages', '', '2011-09-06 08:53:27'),
(7229, 'he', 'siteauditor', 'crawledsuccesssfullywaitfornext', '', '2011-09-06 08:53:27'),
(7230, 'he', 'siteauditor', 'Crawling Page', '', '2011-09-06 08:53:27'),
(7231, 'he', 'siteauditor', 'Duplicate Description', '', '2011-09-06 08:53:27'),
(7232, 'he', 'siteauditor', 'Duplicate Keywords', '', '2011-09-06 08:53:27'),
(7233, 'he', 'siteauditor', 'Duplicate Title', '', '2011-09-06 08:53:27'),
(7234, 'he', 'siteauditor', 'Exclude links', '', '2011-09-06 08:53:27'),
(7235, 'he', 'siteauditor', 'Execute with cron', '', '2011-09-06 08:53:27'),
(7236, 'he', 'siteauditor', 'External', 'חיצוני', '2011-09-06 08:53:27'),
(7237, 'he', 'siteauditor', 'External Links', 'קישורים חיצוניים', '2011-09-06 08:53:27'),
(7238, 'he', 'siteauditor', 'Import Project Links', 'ייבא קישורים לפרוייקט', '2011-09-06 08:53:27'),
(7239, 'he', 'siteauditor', 'Insert links separated with comma', 'ייבא קישורים מופרדים בפסיק', '2011-09-06 08:53:27'),
(7240, 'he', 'siteauditor', 'insertlinkssepcoma', '', '2011-09-06 08:53:27'),
(7241, 'he', 'siteauditor', 'Link Reports', 'דוח קישורים', '2011-09-06 08:53:27'),
(7242, 'he', 'siteauditor', 'Link Title', 'כותרת קישורים', '2011-09-06 08:53:27'),
(7243, 'he', 'siteauditor', 'Maximum number of pages to be checked', 'מספר מקסימלי של דפים לבדיקה', '2011-09-06 08:53:27'),
(7244, 'he', 'siteauditor', 'Maximum Pages', 'מקסימום דפים', '2011-09-06 08:53:27'),
(7245, 'he', 'siteauditor', 'No active projects found', 'לא נמצאו פרוייקטים עובדים', '2011-09-06 08:53:27'),
(7246, 'he', 'siteauditor', 'Nofollow', '', '2011-09-06 08:53:27'),
(7247, 'he', 'siteauditor', 'Number of pages is greater than', '', '2011-09-06 08:53:27'),
(7248, 'he', 'siteauditor', 'Number of pages should be greater than', '', '2011-09-06 08:53:27'),
(7249, 'he', 'siteauditor', 'Page Details', '', '2011-09-06 08:53:27'),
(7250, 'he', 'siteauditor', 'Page Link', '', '2011-09-06 08:53:27'),
(7251, 'he', 'siteauditor', 'Page Links', '', '2011-09-06 08:53:27'),
(7252, 'he', 'siteauditor', 'Pages Found', '', '2011-09-06 08:53:27'),
(7253, 'he', 'siteauditor', 'pressescapetostopexecution', '', '2011-09-06 08:53:27'),
(7254, 'he', 'siteauditor', 'Project Summary', '', '2011-09-06 08:53:27'),
(7255, 'he', 'siteauditor', 'Project Url', '', '2011-09-06 08:53:27'),
(7256, 'he', 'siteauditor', 'projectalreadyexist', '', '2011-09-06 08:53:27'),
(7257, 'he', 'siteauditor', 'Recheck Pages', '', '2011-09-06 08:53:27'),
(7258, 'he', 'siteauditor', 'Report Summary', '', '2011-09-06 08:53:27'),
(7259, 'he', 'siteauditor', 'Run Project', '', '2011-09-06 08:53:27'),
(7260, 'he', 'siteauditor', 'should start with', '', '2011-09-06 08:53:27'),
(7261, 'he', 'siteauditor', 'Site Auditor Settings', '', '2011-09-06 08:53:27'),
(7262, 'he', 'siteauditor', 'Store all links found in a page', '', '2011-09-06 08:53:27'),
(7263, 'he', 'siteauditor', 'The page description length is not between', '', '2011-09-06 08:53:27'),
(7264, 'he', 'siteauditor', 'The page is brocken', '', '2011-09-06 08:53:27'),
(7265, 'he', 'siteauditor', 'The page is having exellent number of backlinks in', '', '2011-09-06 08:53:27'),
(7266, 'he', 'siteauditor', 'The page is having exellent pagerank', '', '2011-09-06 08:53:27'),
(7267, 'he', 'siteauditor', 'The page is having good number of backlinks in', '', '2011-09-06 08:53:27'),
(7268, 'he', 'siteauditor', 'The page is having good pagerank', '', '2011-09-06 08:53:27'),
(7269, 'he', 'siteauditor', 'The page is having poor pagerank', '', '2011-09-06 08:53:27'),
(7270, 'he', 'siteauditor', 'The page is having very good pagerank', '', '2011-09-06 08:53:27'),
(7271, 'he', 'siteauditor', 'The page is not having backlinks in', '', '2011-09-06 08:53:27'),
(7272, 'he', 'siteauditor', 'The page is not indexed in', '', '2011-09-06 08:53:27'),
(7273, 'he', 'siteauditor', 'The page keywords length is not between', '', '2011-09-06 08:53:27'),
(7274, 'he', 'siteauditor', 'The page title length is not between', '', '2011-09-06 08:53:27'),
(7275, 'he', 'siteauditor', 'The total number of links in page is greater than', '', '2011-09-06 08:53:27'),
(7276, 'he', 'siteauditor', 'to run project again if you stopped execution', '', '2011-09-06 08:53:27'),
(7277, 'he', 'siteauditor', 'to view the reports', '', '2011-09-06 08:53:27'),
(7278, 'he', 'siteauditor', 'Total Links', '', '2011-09-06 08:53:27'),
(7279, 'he', 'siteauditor', 'totallinksgreaterallowed', '', '2011-09-06 08:53:27'),
(7280, 'vn', 'backlink', 'clickproceedbacklink', 'Hãy nhập đường dẫn để kiểm tra <b>mỗi dòng một đường dẫn</b>. Sau đó nhấp chuột vào <b>Thực hiện</b> để kiểm tra Backlinks', '2012-01-31 20:28:03'),
(7281, 'vn', 'backlink', 'Saved backlink results of', 'Lưu kết quả kiểm tra backlink của', '2012-01-31 20:28:03'),
(7282, 'vn', 'button', 'Cancel', 'Hủy bỏ', '2014-01-08 19:36:48'),
(7283, 'vn', 'button', 'Check Status', 'Kiểm tra trạng thái', '2014-01-08 19:36:48'),
(7284, 'vn', 'button', 'Proceed', 'Thực hiện', '2014-01-08 19:36:48'),
(7285, 'vn', 'button', 'Reload', 'Nạp lại', '2014-01-08 19:36:48'),
(7286, 'vn', 'button', 'Show Details', 'Hiển thị chi tiết', '2014-01-08 19:36:48'),
(7287, 'vn', 'button', 'Show Records', 'Hiển thị các bản ghi', '2014-01-08 19:36:48'),
(7288, 'vn', 'button', 'Skip', 'Bỏ qua', '2014-01-08 19:36:48'),
(7289, 'vn', 'button', 'Submit', 'Đồng ý', '2014-01-08 19:36:48'),
(7290, 'vn', 'common', 'Action', 'Thao tác', '2014-01-10 04:03:12'),
(7291, 'vn', 'common', 'Activate', 'Kích hoạt', '2014-01-10 04:03:12'),
(7292, 'vn', 'common', 'Active', 'Hoạt động', '2014-01-10 04:03:12'),
(7293, 'vn', 'common', 'Admin Panel', 'Bảng điều khiển Admin', '2014-01-10 04:03:12'),
(7294, 'vn', 'common', 'Alexa Rank', 'Thứ hạng trên Alexa', '2014-01-10 04:03:12'),
(7295, 'vn', 'common', 'All', 'Tất cả', '2014-01-10 04:03:12'),
(7296, 'vn', 'common', 'Category', 'Danh mục', '2014-01-10 04:03:12'),
(7297, 'vn', 'common', 'contact', 'Liên hệ', '2014-01-10 04:03:12'),
(7298, 'vn', 'common', 'copyright', 'Bản quyền thuộc © về www.seopanel.in', '2014-01-10 04:03:12'),
(7299, 'vn', 'common', 'Country', 'Quốc gia', '2014-01-10 04:03:12'),
(7300, 'vn', 'common', 'Crawl Meta Data', 'Thu thập thông tin dữ liệu thẻ Meta', '2014-01-10 04:03:12'),
(7301, 'vn', 'common', 'Date', 'Ngày', '2014-01-10 04:03:12'),
(7302, 'vn', 'common', 'Delete', 'Xóa', '2014-01-10 04:03:12'),
(7303, 'vn', 'common', 'Details', 'Thông tin chi tiết', '2014-01-10 04:03:12'),
(7304, 'vn', 'common', 'Directory', 'Danh bạ', '2014-01-10 04:03:12'),
(7305, 'vn', 'common', 'Donate', 'Quyên góp', '2014-01-10 04:03:12'),
(7306, 'vn', 'common', 'Edit', 'Sửa', '2014-01-10 04:03:12'),
(7307, 'vn', 'common', 'Entry cannot be blank', 'Mục nhập nội dung không thể để trống', '2014-01-10 04:03:12'),
(7308, 'vn', 'common', 'entrynotvalid', 'Các mục nhập vào dường như không có giá trị', '2014-01-10 04:03:12'),
(7309, 'vn', 'common', 'failed', 'sai', '2014-01-10 04:03:12'),
(7310, 'vn', 'common', 'forum', 'Diễn đàn', '2014-01-10 04:03:12'),
(7311, 'vn', 'common', 'Found', 'Tìm', '2014-01-10 04:03:12'),
(7312, 'vn', 'common', 'Google Pagerank', 'PR', '2014-01-10 04:03:12'),
(7313, 'vn', 'common', 'help', 'Trợ giúp', '2014-01-10 04:03:12'),
(7314, 'vn', 'common', 'hidenews', 'Ẩn tin tức tức Seo Panel', '2014-01-10 04:03:12'),
(7315, 'vn', 'common', 'Id', 'ID', '2014-01-10 04:03:12'),
(7316, 'vn', 'common', 'Inactivate', 'Hủy kích hoạt', '2014-01-10 04:03:12'),
(7317, 'vn', 'common', 'Inactive', 'Chưa kích hoạt', '2014-01-10 04:03:12'),
(7318, 'vn', 'common', 'Invalid characters', 'Các ký tự không hợp lệ', '2014-01-10 04:03:12'),
(7319, 'vn', 'common', 'Invalid code entered', 'Bạn đã nhập mã không hợp lệ', '2014-01-10 04:03:12'),
(7320, 'vn', 'common', 'Invalid email address entered', 'Bạn đã nhập địa chỉ E-mail không hợp lệ', '2014-01-10 04:03:12'),
(7321, 'vn', 'common', 'Invalid value', 'Giá trị không hợp lệ', '2014-01-10 04:03:12'),
(7322, 'vn', 'common', 'Keyword', 'Từ khóa', '2014-01-10 04:03:12'),
(7323, 'vn', 'common', 'Keywords', 'Từ khóa', '2014-01-10 04:03:12'),
(7324, 'vn', 'common', 'lang', 'Ngôn ngữ', '2014-01-10 04:03:12'),
(7325, 'vn', 'common', 'My Account', 'Tài khoản của tôi', '2014-01-10 04:03:12'),
(7326, 'vn', 'common', 'Name', 'Tên', '2014-01-10 04:03:12'),
(7327, 'vn', 'common', 'No', 'Không', '2014-01-10 04:03:12'),
(7328, 'vn', 'common', 'No Keywords Found', 'Không tìm thấy từ kóa nào', '2014-01-10 04:03:12'),
(7329, 'vn', 'common', 'No Records Found', 'Không tìm thấy mẫu tin nào', '2014-01-10 04:03:12'),
(7330, 'vn', 'common', 'noactivetools', 'Không tìm thấy công cụ seo nào hoạt động!', '2014-01-10 04:03:12'),
(7331, 'vn', 'common', 'nowebsites', 'Không tìm thấy website', '2014-01-10 04:03:12'),
(7332, 'vn', 'common', 'password632', 'Mật khẩu phải nằm trong khoản từ 6 đến 32 ký tự', '2014-01-10 04:03:12'),
(7333, 'vn', 'common', 'passwordnotmatch', 'Mật khẩu không giống nhau', '2014-01-10 04:03:12'),
(7334, 'vn', 'common', 'Period', 'Thời gian', '2014-01-10 04:03:12'),
(7335, 'vn', 'common', 'Priority', 'Ưu tiên', '2014-01-10 04:03:12'),
(7336, 'vn', 'common', 'Profile', 'Hồ Sơ', '2014-01-10 04:03:12'),
(7337, 'vn', 'common', 'Rank', 'Vị trí', '2014-01-10 04:03:12'),
(7338, 'vn', 'common', 'Reports', 'Báo cáo', '2014-01-10 04:03:12'),
(7339, 'vn', 'common', 'Results', 'Kết quả', '2014-01-10 04:03:12'),
(7340, 'vn', 'common', 'Search Engine', 'Công cụ tìm kiếm', '2014-01-10 04:03:12'),
(7341, 'vn', 'common', 'Select', 'Chọn', '2014-01-10 04:03:12'),
(7342, 'vn', 'common', 'Seo Plugins', 'Phần bổ trợ Seo', '2014-01-10 04:03:12'),
(7343, 'vn', 'common', 'Seo Tools', 'Công cụ Seo', '2014-01-10 04:03:12'),
(7344, 'vn', 'common', 'Sign out', 'Thoát', '2014-01-10 04:03:12'),
(7345, 'vn', 'common', 'Sign Up', 'Đăng ký', '2014-01-10 04:03:12'),
(7346, 'vn', 'common', 'signin', 'Đăng nập', '2014-01-10 04:03:12'),
(7347, 'vn', 'common', 'Status', 'Trạng thái', '2014-01-10 04:03:12'),
(7348, 'vn', 'common', 'Support', 'Hổ trợ', '2014-01-10 04:03:12'),
(7349, 'vn', 'common', 'Total', 'Tổng cộng', '2014-01-10 04:03:12'),
(7350, 'vn', 'common', 'Url', 'Đường dẫn (URL)', '2014-01-10 04:03:12'),
(7351, 'vn', 'common', 'User', 'Tên truy cập', '2014-01-10 04:03:12'),
(7352, 'vn', 'common', 'User Panel', 'Bảng điều khiển người dùng', '2014-01-10 04:03:12'),
(7353, 'vn', 'common', 'Website', 'Website', '2014-01-10 04:03:12'),
(7354, 'vn', 'common', 'Yes', 'Có', '2014-01-10 04:03:12'),
(7355, 'vn', 'directory', 'Add back to directory list', 'Trở lại danh sách danh bạ', '2014-01-10 04:05:11'),
(7356, 'vn', 'directory', 'Approved', 'Được chấp thuận', '2014-01-10 04:05:11'),
(7357, 'vn', 'directory', 'Captcha', 'Mã xác nhận', '2014-01-10 04:05:11'),
(7358, 'vn', 'directory', 'categorynote', 'Danh mục, tách chúng bằng dấu phẩy (,) theo mức độ ưu tiên. Bắt đầu với thể loại ưu tiên hàng đầu.', '2014-01-10 04:05:11'),
(7359, 'vn', 'directory', 'Check Directory Status', 'Kiểm tra trạng thái Danh bạ', '2014-01-10 04:05:11'),
(7360, 'vn', 'directory', 'Check Directory Submission Status', 'Kiểm tra trạng thái đăng ký vào danh bạ', '2014-01-10 04:05:11'),
(7361, 'vn', 'directory', 'clicktoproceeddirsts', 'Nhấp chuột vào <b> Thực hiện</b> để tiến hành kiểm tra trạng thái.', '2014-01-10 04:05:11'),
(7362, 'vn', 'directory', 'Confirmation', 'Xác nhận', '2014-01-10 04:05:11'),
(7363, 'vn', 'directory', 'desnote', 'Có một số danh bạ yêu cầu bạn phải nhập tối thiểu là 150 ký tự cho mục miêu tả', '2014-01-10 04:05:11'),
(7364, 'vn', 'directory', 'Directories with out captcha', 'Các danh bạ bắt phải nhập mã xác thực', '2014-01-10 04:05:11'),
(7365, 'vn', 'directory', 'Directory Submission Reports', 'Báo cáo việc đăng ký vào các danh bạ', '2014-01-10 04:05:11'),
(7366, 'vn', 'directory', 'Enter the code shown', 'Nhập mã được hiển thị', '2014-01-10 04:05:11'),
(7367, 'vn', 'directory', 'nocatnote', 'Danh mục gửi đăng ký khôn gđược tìm thấy trong trang đăng ký. Vui lòng nhấp chuột vào <b>Nạp lại</b> hoặc <b>Bỏ qua</b>', '2014-01-10 04:05:11'),
(7368, 'vn', 'directory', 'nodirnote', 'Không tìm thấy danh bạ <b>Hoạt động</b>', '2014-01-10 04:05:11'),
(7369, 'vn', 'directory', 'nosuccessnote', 'Nếu không nhận được thông báo thành công. Xin vui lòng kiểm tra trong hòm thư của ạn để tìm thư yêu cầu xác nhận', '2014-01-10 04:05:11'),
(7370, 'vn', 'directory', 'optionalnote', 'Tùy chọn Tiêu đề và mô tả để gửi với Tiêu đề ngẫu nhiên và mô tả cho danh bạ sẽ cho kết quả tốt hơn.', '2014-01-10 04:05:11'),
(7371, 'vn', 'directory', 'Owner Email', 'Email người gửi', '2014-01-10 04:05:11'),
(7372, 'vn', 'directory', 'Owner Name', 'Tên người gửi', '2014-01-10 04:05:11'),
(7373, 'vn', 'directory', 'Pending', 'Trong thời gian chờ', '2014-01-10 04:05:11'),
(7374, 'vn', 'directory', 'Please select a website to proceed', 'Vui lòng chọn một website để thực hiện', '2014-01-10 04:05:11'),
(7375, 'vn', 'directory', 'Reciprocal Link', 'Liên kết tương xứng', '2014-01-10 04:05:11'),
(7376, 'vn', 'directory', 'selectwebsiteproceed', 'Chọn một <b>Website</b> để <b>Thực hiện</b> đăng ký vào danh bạ website.<b>Kiểm tra</b> những danh bạ không yêu cầu nhập <b>mã xác nhận</b> để gửi.', '2014-01-10 04:05:11'),
(7377, 'vn', 'directory', 'selectwebsiteschecksub', 'Chọn <b>một Website</b> để <b> thực hiện</b> kiểm tra đã được gửi lên các danh bạ website hay chưa.', '2014-01-10 04:05:11'),
(7378, 'vn', 'directory', 'Semi Automatic Directory Submission Tool', 'Công cụ submit website lên danh bạ website bán tự động', '2014-01-10 04:05:11'),
(7379, 'vn', 'directory', 'spamemailnote', 'Có một số danh bạ website có thể sử dụng chức năng Spam, chúng tôi không khuyến khích bạn sử dụng địa chỉ email chính của mình', '2014-01-10 04:05:11'),
(7380, 'vn', 'directory', 'Submission Details', 'Thông tin chi tiết việc Submit', '2014-01-10 04:05:11'),
(7381, 'vn', 'directory', 'Submit Description', 'Môt tả việc gửi thông tin', '2014-01-10 04:05:11'),
(7382, 'vn', 'directory', 'Submit Keywords', 'Từ khóa gửi', '2014-01-10 04:05:11'),
(7383, 'vn', 'directory', 'Submit Title', 'Tiêu đề gửi', '2014-01-10 04:05:11'),
(7384, 'vn', 'directory', 'Website Category', 'Danh mục website', '2014-01-10 04:05:11'),
(7385, 'vn', 'directory', 'Website Url', 'Địa chỉ website', '2014-01-10 04:05:11'),
(7386, 'vn', 'home', 'Account Summary', 'Tóm tắt thông tin tài khoản', '2012-02-02 22:03:54'),
(7387, 'vn', 'home', 'Backlinks', 'Backlinks', '2012-02-02 22:03:54'),
(7388, 'vn', 'home', 'Directory Submission', 'Gửi lên danh bạ website', '2012-02-02 22:03:54'),
(7389, 'vn', 'home', 'home_cont1', '<h1 style=\\"text-align: center;margin-bottom: 30px;font-size: 19px;\\">Chào mừng bạn đến với Seo Panel - Bảng điều khiển seo cho nhiều trang web đầu tiên trên thế giới</h1> \r\n\r\n<p> \r\n            Một <b>mã nguồn mở quản lý tối ưu</b> cho việc quản lí <b>công việc tối ưu hóa trên công cụ tìm kiếm</b> cho các trang web của bạn.  \r\n            Seo Panel là <b>một bộ công cụ seo</b> bao gồm các công cụ seo mới nhất <b>làm tăng và theo dõi</b> <b>hiệu suất</b> hoạt động các trang web của bạn.\r\nĐây là một <b>phần mềm miễn phí</b> tuân theo giấy phép của <b>GNU GENERAL PUBLIC LICENSE</b>.\r\n\r\nChức năng đặc biệt chính của seo panel là sự <b>mở rộng chức năg</b> bằng cách sử dụng <a href=\\"<?=SP_PLUGINSITE?>\\"\r\ntarget=\\"_blank\\">seo plugins</a>. \r\nBất kỳ ai cũng có thể dễ dàng <b>cài đặt và phát triên</b> những plugin mới cho seo panel của họ.\r\nPhần mềm này chính thức phát hành vào <b>Tháng 1 năm 2010</b>.\r\nChỉ trong khoảng <b>thời gian ngắn hàng ngàn chủ web </b>đang sử dụng phần mềm này để <b>tối ưu hóa</b> trang web của họ.\r\nSử dụng chính seo panel ngày hôm nay và tận hưởng tất cả mọi thứ liên quan đến seo theo <b>một nền tảng đơn giản nhất</b>.\r\n        </p>', '2012-02-02 22:03:54'),
(7390, 'vn', 'home', 'home_cont2', '<fieldset>\r\n<legend> chính tính năng của Seo panel <?=SP_INSTALLED?> </legend>\r\n<ul class=\\"infobox\\">\r\n    <li>\r\n        <h1> tự động thư mục thông tin Công cụ </h1>\r\n        <p>\r\n            Dung bài viết công cụ tự động giúp chúng tôi <b> trình các trang web của chúng tôi </b> vào chính <b> miễn phí\r\nvà thư mục internet trả tiền </b>.\r\n            Chúng tôi cũng có thể <b> theo dõi tình trạng </b> của mỗi submit qua kiểm tra định kỳ <b> </b> sử dụng\r\ntình trạng <b> trình kiểm tra kịch bản </b>.\r\n            <b> quản lý thư mục </b> sẽ giúp chúng tôi để tìm hiểu xem <b> thư mục đang hoạt động </b> hay không.\r\n        </p>\r\n    </li>\r\n    <li>\r\n        <h1> Checker từ khoá Vị trí </h1>\r\n        <p>\r\n            Từ khoá kiểm tra vị trí sẽ tìm vị trí công cụ tìm kiếm <b> </b> <b> từ khoá được nhắm mục tiêu </b>\r\ntrang web của bạn và các cửa hàng <b> </b> trong hệ thống.\r\n            Trong phần báo cáo vị trí từ khoá, chúng ta có thể thấy các vị trí hàng ngày <b> </b> của từ khóa trong\r\ncông cụ tìm kiếm khác nhau bằng các đồ thị <b> đẹp </b> và <b> chi tiết báo cáo </b>.\r\n        </p>\r\n    </li>\r\n    <li>\r\n        <h1> Site Kiểm toán </h1>\r\n        <p>Kiểm toán Site <b> sẽ kiểm toán tất cả các yếu tố SEO </b> của mỗi trang của một trang web và sẽ cung cấp cho một\r\n<b> báo cáo chi tiết </b> về mỗi trang. Điều này sẽ giúp chúng tôi để tạo ra <b> XML, HTML, văn bản </b> sitemap\r\ncác tập tin của trang web của chúng tôi cho <b> trình </b> để công cụ tìm kiếm </p>\r\n    </li>\r\n    <li>\r\n        <h1> Google và Alexa Rank Checker </h1>\r\n        <p>\r\n            Google và alexa xếp hạng kiểm tra sẽ tìm thấy <b> google pagerank </b> và <b> alexa xếp hạng </b> của chúng tôi\r\ntrang web và các cửa hàng <b> </b> trong hệ thống.\r\n            Trong báo cáo xếp hạng <b> </b>, chúng ta có thể thấy <b> hàng ngày </b> google và xếp hạng alexa của mỗi trang web\r\nbởi <b> báo cáo chi tiết </b>.\r\n        </p>\r\n    </li>\r\n    <li>\r\n        <h1> Backlinks Checker </h1>\r\n        <p>\r\n            Backlinks kiểm tra sẽ tìm thấy số <b> backlinks </b> của trang web của chúng tôi trong tìm kiếm khác nhau\r\n<b> động cơ (google, yahoo, msn ...) </b> và <b> cửa hàng </b> nó trong hệ thống.\r\n            - Trong báo cáo backlink <b> </b>, chúng ta có thể nhìn thấy <b> hàng ngày backlinks tính </b> của mỗi\r\ntrang web bằng cách báo cáo <b> chi tiết </b>.\r\n        </p>\r\n    </li>\r\n    <li>\r\n        <h1> Search Engine Saturation Checker </h1>\r\n        <p>\r\n            Search Engine Saturation kiểm tra sẽ tìm thấy số <b> của các trang được lập chỉ mục </b> của trang web của chúng tôi\r\ncông cụ tìm kiếm khác nhau <b> (google, yahoo, msn ...) </b> và <b> cửa hàng </b> nó trong hệ thống.\r\n            <b> Tìm kiếm công cụ kiểm tra độ bão hòa báo cáo </b>, chúng ta có thể thấy trang <b> hàng ngày lập chỉ mục\r\ntính </b> của mỗi trang web bằng cách báo cáo chi tiết <b> </b>.\r\n        </p>\r\n    </li>\r\n    <li>\r\n        <h1> Seo Panel Plugins </h1>\r\n        <p>\r\n            Các tính năng chính <b> </b> của Seo bảng điều khiển <b> của nó extentability </b>.\r\n            Thêm <b> seo plugin </b> vào bảng seo của bạn để <b> mở rộng các tính năng </b> theo của bạn\r\nyêu cầu.\r\n            <A href =\\"<?=SP_PLUGINSITE?>\\" Target=\\"_blank \\"> Seo bảng điều khiển bổ sung </a> được cung cấp bởi cả hai bảng điều khiển seo\r\nvà các trang web của bên thứ ba.\r\n            Bạn cũng có thể dễ dàng <b> phát triển </b> seo plugin cho bảng điều khiển seo của bạn.\r\n            Bạn có thể <a href =\\"<?=SP_PLUGINSITE?>\\" Target=\\"_blank \\"> trình </a> Plugin seo seo bảng và\r\nchúng tôi <b> sẽ công bố </b> nó trong trang web của chúng tôi sau khi xem xét <b> của chúng tôi </b> quá trình.\r\n        </p>\r\n    </li>\r\n    <li>\r\n        <h1> Meta Tag Generator </h1>\r\n        <p>\r\n            Meta từ khóa máy phát điện là một <b> plugin seo bảng điều khiển </b> để tạo ra các thẻ meta <b> tùy chỉnh </b> cho\r\ntrang web.\r\n            Nó sẽ giúp chúng tôi để cung cấp thông tin <b> hơn </b> về trang web của chúng tôi để chương trình <b> công cụ tìm kiếm </b>\r\ntrong khi họ thu thập dữ liệu trang web của chúng tôi.\r\n        </p>\r\n    </li>\r\n</ul>\r\n</fieldset>', '2012-02-02 22:03:54'),
(7391, 'vn', 'home', 'home_cont3', '<fieldset>\r\n<legend>Hệ thống Seo Panel trực tuyến</legend>    \r\n<ul class=\\"infobox\\">\r\n\r\n    <li>\r\n        <h1>Bảng điều chỉnh Tài nguyên Seo trực tuyến dành cho vệc tham khảo</h1>                \r\n        \r\n        \r\n        <p>\r\n            <a href=\\"http://www.seopanel.in\\" target=\\"_blank\\">Địa chỉ chính thức của Seo Panel</a>\r\n        </p>\r\n        <p>\r\n            <a href=\\"<?=SP_DOWNLOAD_LINK?>\\" target=\\"_blank\\">Tải Seo Panel</a>\r\n        </p>\r\n        \r\n        <p>\r\n            <a href=\\"<?=SP_DEMO_LINK?>\\" target=\\"_blank\\">Seo Panel Demo</a>\r\n        </p>\r\n        \r\n        <p>\r\n            <a href=\\"<?=SP_CONTACT_LINK?>\\" target=\\"_blank\\">Liên hệ với tác giả Seo Panel</a>\r\n        </p>\r\n        \r\n        <p>\r\n            <a href=\\"<?=SP_HELP_LINK?>\\" target=\\"_blank\\">Hổ trợ sử dụng Seo Panel</a>\r\n        </p>\r\n        \r\n        <p>\r\n            <a href=\\"<?=SP_FORUM_LINK?>\\" target=\\"_blank\\">Diễn đàn Seo Panel</a>\r\n        </p>\r\n        \r\n        <p>\r\n            <a href=\\"<?=SP_SUPPORT_LINK?>\\" target=\\"_blank\\"> Hệ thống hổ trợ Seo Panel</a>\r\n        </p>\r\n        \r\n        <p>\r\n            <a href=\\"<?=SP_DONATE_LINK?>\\" target=\\"_blank\\">Quyên góp Seo Panel</a>\r\n        </p>\r\n    </li>\r\n    \r\n</ul>\r\n</fieldset>', '2012-02-02 22:03:54'),
(7392, 'vn', 'home', 'Indexed', 'Indexed', '2012-02-02 22:03:54'),
(7393, 'vn', 'home', 'Pages Indexed', 'Pages Indexed', '2012-02-02 22:03:54'),
(7394, 'vn', 'home', 'Ranks', 'Thứ hạng', '2012-02-02 22:03:54'),
(7395, 'vn', 'home', 'SiteNameUrl', 'Tên stie/ Đường dẫn', '2012-02-02 22:03:54'),
(7396, 'vn', 'home', 'Website Statistics', 'Thống kê website', '2012-02-02 22:03:54'),
(7397, 'es-ar', 'home', 'Account Summary', 'Resumen de la Cuenta', '2014-01-06 19:23:36'),
(7398, 'es-ar', 'home', 'Backlinks', 'Referencias', '2014-01-06 19:23:36'),
(7399, 'es-ar', 'home', 'Directory Submission', 'Envio de Directorio', '2014-01-06 19:23:36'),
(7400, 'es-ar', 'home', 'home_cont1', '<h1 style="text-align: center;margin-bottom: 30px;font-size: 19px;">Bienvenido a SEO PANEL - el primer\r\npanel de control SEO para multiples sitios</h1> \r\n        <p> \r\n            Un completo <b>panel de control SEP de codigo abierto</b> para administrar <b>la optimizacion de los buscadores</b> para sus sitios web.  \r\n            Seo Panel es un <b>recurso SEO</b> que incluye las ultimas herramientas seo para <b>incrementar y seguir</b> la\r\n<b>performace</b> de sus sitios web. \r\n            Es un <b>software libre</b> distribuido bajo <b>GNU GENERAL PUBLIC LICENSE</b>. \r\n            La caracteristica principal de SEO PANEL es su <b>escalabilidad</b> a traves de <a href="<?=SP_PLUGINSITE?>"\r\ntarget="_blank"> plugins SEO</a>. \r\n            Cualquiera puede facilmente <b>desarrollar e instalar</b> los plugins necesarios en su SEO PANEL.  \r\n        </p> \r\n        <p></p> \r\n        <p> \r\n            Este software abierto fue liberado <b>en Enero 2010</b>. \r\n            En este <b>corto periodo</b> de tiempo <b>miles</b> de <b>web masters</b> estan utilizando el software para <b>optimizar</b> sus websites. \r\n            Utilice seo panel hoy y <b>disfrute</b> de todo lo relacionado con SEO dentro de una <b>unica plataforma</b>. \r\n        </p>', '2014-01-06 19:23:36'),
(7401, 'es-ar', 'home', 'home_cont2', '<fieldset> \r\n<legend>Caracteristicas Pricipales de Seo Panel <?=SP_INSTALLED?></legend> \r\n<ul class="infobox"> \r\n    <li>         \r\n        <h1>Herramienta de Envio de Directorios Automatizada</h1> \r\n        <p> \r\n            La Herramienta Automatizada de Envio de Directorios nos auda a <b>enviar nuestros sitios web</b> a los principales <b> directorios de internet gratuitos y dolorosos</b>. \r\n            Podemos tambien <b>seguir el estado</b> de cada envio a traves de  <b>controles periodicos</b> usando <b>el script de control de estado</b>. \r\n            <b>El administrador de directorios</b> nos ayudara a encontrar si un <b>directorio esta activo</b> o no. \r\n        </p> \r\n    </li> \r\n    <li>         \r\n        <h1>Verificador de posicion de palabras clave</h1> \r\n        <p> \r\n            Keyword position checker will find the <b>search engine position</b> of <b>targetted keywords</b>\r\nof your website and <b>stores</b> it in the system. \r\n            In keyword position reports section, we can see the <b>daily positions</b> of keywords in\r\ndifferent search engines by <b>beautiful graphs</b> and <b>detailed reports</b>. \r\n        </p> \r\n    </li> \r\n    <li>         \r\n        <h1>Site Auditor</h1> \r\n        <p>Site Auditor will <b>audit all SEO factors</b> of each pages of a site and will give a\r\n<b>detailed report</b> about each page. This will help us to create <b>XML,HTML,TEXT</b> sitemap\r\nfiles of our website for <b>submit</b> to search engines.</p> \r\n    </li> \r\n    <li>         \r\n        <h1>Google and Alexa Rank Checker</h1> \r\n        <p> \r\n            Google and alexa rank checker will find <b>google pagerank</b> and <b>alexa rank</b> of our\r\nwebsites and <b>stores</b> it in the system. \r\n            In <b>rank reports</b> section, we can see the <b>daily</b> google and alexa rank of each website\r\nby <b>detailed reports</b>. \r\n        </p> \r\n    </li> \r\n    <li>         \r\n        <h1>Backlinks Checker</h1> \r\n        <p> \r\n            Backlinks checker will find <b>number of backlinks</b> of our websites in different search\r\nengines<b>(google,yahoo,msn etc)</b> and <b>stores</b> it in the system. \r\n            <br>In <b>backlink reports</b> section, we can see the <b>daily backlinks count</b> of each\r\nwebsite by <b>detailed reports</b>. \r\n        </p> \r\n    </li>     \r\n    <li>         \r\n        <h1>Search Engine Saturation Checker</h1> \r\n        <p> \r\n            Search Engine Saturation checker will find <b>number of indexed pages</b> of our websites in\r\ndifferent search engines<b>(google,yahoo,msn etc)</b> and <b>stores</b> it in the system. \r\n            In <b>search engine saturation checker reports</b> section, we can see the <b>daily indexed page\r\ncount</b> of each website by <b>detailed reports</b>. \r\n        </p> \r\n    </li> \r\n    <li>         \r\n        <h1>Seo Panel Plugins</h1> \r\n        <p> \r\n            The <b>major feature</b> of seo control panel is its <b>extentability</b>. \r\n            Add <b>seo plugins</b> to your seo panel to <b>extend the features</b> according to your\r\nrequirement. \r\n            <a href="<?=SP_PLUGINSITE?>" target="_blank">Seo panel plugins</a> are provided by both seo panel\r\nand third party sites. \r\n            You can also easily <b>develop</b> seo plugins for your seo panel. \r\n            You can <a href="<?=SP_PLUGINSITE?>" target="_blank">submit</a> your seo plugin to seo panel and\r\nwe will <b>publish</b> it in our website after our <b>review</b> process. \r\n        </p> \r\n    </li> \r\n    <li>         \r\n        <h1>Meta Tag Generator</h1> \r\n        <p> \r\n            Meta tag generator is a <b>seo panel plugin</b> for creating <b>custom meta tags</b> for our\r\nsite. \r\n            It will help us to give <b>more information</b> about our website to <b>search engine bots</b>\r\nwhile they crawl our website. \r\n        </p> \r\n    </li> \r\n</ul> \r\n</fieldset>', '2014-01-06 19:23:36'),
(7402, 'es-ar', 'home', 'home_cont3', '<fieldset> \r\n<legend>Recursos On Line de SEO PANEL</legend>     \r\n<ul class="infobox"> \r\n\r\n    <li> \r\n        <h1>Recursos On Line de SEO PANEL</h1>                 \r\n         \r\n         \r\n        <p> \r\n            <a href="http://www.seopanel.in" target="_blank">Sitio Oficial SEO PANEL</a> \r\n        </p> \r\n        <p> \r\n            <a href="<?=SP_DOWNLOAD_LINK?>" target="_blank">Descargar SEO PANEL</a> \r\n        </p> \r\n         \r\n        <p> \r\n            <a href="<?=SP_DEMO_LINK?>" target="_blank">Demo SEO PANLE</a> \r\n        </p> \r\n         \r\n        <p> \r\n            <a href="<?=SP_CONTACT_LINK?>" target="_blank">Conatctar a SEO PANEL</a> \r\n        </p> \r\n         \r\n        <p> \r\n            <a href="<?=SP_HELP_LINK?>" target="_blank">Guia de Ayuda SEO PANEL</a> \r\n        </p> \r\n         \r\n        <p> \r\n            <a href="<?=SP_FORUM_LINK?>" target="_blank">Foro SEO PANEL</a> \r\n        </p> \r\n         \r\n        <p> \r\n            <a href="<?=SP_SUPPORT_LINK?>" target="_blank">Sistema de Soporte de SEO PANEL</a> \r\n        </p> \r\n         \r\n        <p> \r\n            <a href="<?=SP_DONATE_LINK?>" target="_blank">Donar a SEO PANEL</a> \r\n        </p> \r\n    </li> \r\n     \r\n</ul> \r\n</fieldset>', '2014-01-06 19:23:36'),
(7403, 'es-ar', 'home', 'Indexed', 'Indexado', '2014-01-06 19:23:36'),
(7404, 'es-ar', 'home', 'Pages Indexed', 'Paginas IndexadasN', '2014-01-06 19:23:36'),
(7405, 'es-ar', 'home', 'Ranks', 'Rankings', '2014-01-06 19:23:36'),
(7406, 'es-ar', 'home', 'SiteNameUrl', 'Nombre del Sitio/URL', '2014-01-06 19:23:36'),
(7407, 'es-ar', 'home', 'Website Statistics', 'Estadisticas del Sitio', '2014-01-06 19:23:36'),
(7408, 'da', 'directory', 'Reciprocal Link', '(Gensidigt) Reciprocal Link', '2013-01-14 22:40:16'),
(7409, 'da', 'home', 'Indexed', 'Indekseret', '2014-01-20 08:56:43'),
(7410, 'sl', 'backlink', 'clickproceedbacklink', 'Vpišite URL-je <b>Vsakega v svojo vrstico</b>. Kliknite <b>Nadaljuj</b> za preverjanje povratnih povezav.', '2012-01-20 07:52:51'),
(7411, 'sl', 'backlink', 'Saved backlink results of', 'Shranjeni rezultati povratnih povezav od', '2012-01-20 07:52:51'),
(7412, 'sl', 'button', 'Cancel', 'Prekliči', '2014-01-08 19:33:56'),
(7413, 'sl', 'button', 'Check Status', 'Preveri status', '2014-01-08 19:33:56'),
(7414, 'sl', 'button', 'Proceed', 'Nadaljuj', '2014-01-08 19:33:56'),
(7415, 'sl', 'button', 'Reload', 'Osveži', '2014-01-08 19:33:56'),
(7416, 'sl', 'button', 'Show Details', 'Pokaži podrobnosti', '2014-01-08 19:33:56'),
(7417, 'sl', 'button', 'Show Records', 'Pokaži shranjene zapise', '2014-01-08 19:33:56'),
(7418, 'sl', 'button', 'Skip', 'Preskoči', '2014-01-08 19:33:56'),
(7419, 'sl', 'button', 'Submit', 'Pošlji', '2014-01-08 19:33:56'),
(7420, 'sl', 'common', 'Action', 'Akcija', '2012-05-12 17:56:08'),
(7421, 'sl', 'common', 'Activate', 'Vključi', '2012-05-12 17:56:08'),
(7422, 'sl', 'common', 'Active', 'Vključeno', '2012-05-12 17:56:08'),
(7423, 'sl', 'common', 'Admin Panel', 'Nadzorna plošča', '2012-05-12 17:56:08'),
(7424, 'sl', 'common', 'Alexa Rank', 'Rang v Alexi', '2012-05-12 17:56:08'),
(7425, 'sl', 'common', 'All', 'Vse', '2012-05-12 17:56:08'),
(7426, 'sl', 'common', 'Category', 'Kategorija', '2012-05-12 17:56:08'),
(7427, 'sl', 'common', 'contact', 'Kontakt', '2012-05-12 17:56:08'),
(7428, 'sl', 'common', 'copyright', 'Copyright © [year] www.seopanel.in Vse pravice pridržane', '2012-05-12 17:56:08'),
(7429, 'sl', 'common', 'Country', 'Država', '2012-05-12 17:56:08'),
(7430, 'sl', 'common', 'Crawl Meta Data', 'Pridobi metapodatke', '2012-05-12 17:56:08'),
(7431, 'sl', 'common', 'Date', 'Datum', '2012-05-12 17:56:08'),
(7432, 'sl', 'common', 'Delete', 'Izbriši', '2012-05-12 17:56:08'),
(7433, 'sl', 'common', 'Details', 'Podrobnosti', '2012-05-12 17:56:08'),
(7434, 'sl', 'common', 'Directory', 'Direktorij', '2012-05-12 17:56:08'),
(7435, 'sl', 'common', 'Donate', 'Donacije', '2012-05-12 17:56:08'),
(7436, 'sl', 'common', 'Edit', 'Uredi', '2012-05-12 17:56:08'),
(7437, 'sl', 'common', 'Entry cannot be blank', 'Vnos ne sme biti prazen', '2012-05-12 17:56:08'),
(7438, 'sl', 'common', 'entrynotvalid', 'Napaka pri vnosu', '2012-05-12 17:56:08'),
(7439, 'sl', 'common', 'failed', 'neuspešno', '2012-05-12 17:56:08'),
(7440, 'sl', 'common', 'forum', 'Forum', '2012-05-12 17:56:08'),
(7441, 'sl', 'common', 'Found', 'Najdeno', '2012-05-12 17:56:08'),
(7442, 'sl', 'common', 'Google Pagerank', 'Google Pagerank', '2012-05-12 17:56:08'),
(7443, 'sl', 'common', 'help', 'Pomoč', '2012-05-12 17:56:08'),
(7444, 'sl', 'common', 'hidenews', 'Skrij Seo Panel novice', '2012-05-12 17:56:08'),
(7445, 'sl', 'common', 'Id', 'ID', '2012-05-12 17:56:08'),
(7446, 'sl', 'common', 'Inactivate', 'Deaktiviraj', '2012-05-12 17:56:08'),
(7447, 'sl', 'common', 'Inactive', 'Neaktivno', '2012-05-12 17:56:08'),
(7448, 'sl', 'common', 'Invalid characters', 'Napačni znaki', '2012-05-12 17:56:08'),
(7449, 'sl', 'common', 'Invalid code entered', 'Vnešena napačna koda', '2012-05-12 17:56:08'),
(7450, 'sl', 'common', 'Invalid email address entered', 'Vnešen napačni E-naslov', '2012-05-12 17:56:08'),
(7451, 'sl', 'common', 'Invalid value', 'Napačna vrednost', '2012-05-12 17:56:08'),
(7452, 'sl', 'common', 'Keyword', 'Ključna beseda', '2012-05-12 17:56:08'),
(7453, 'sl', 'common', 'Keywords', 'Ključne besede', '2012-05-12 17:56:08'),
(7454, 'sl', 'common', 'lang', 'Jezik', '2012-05-12 17:56:08'),
(7455, 'sl', 'common', 'My Account', 'Moj Račun', '2012-05-12 17:56:08'),
(7456, 'sl', 'common', 'Name', 'Ime', '2012-05-12 17:56:08'),
(7457, 'sl', 'common', 'No', 'Ne', '2012-05-12 17:56:08'),
(7458, 'sl', 'common', 'No Keywords Found', 'Ne najdemo ključnih besed', '2012-05-12 17:56:08'),
(7459, 'sl', 'common', 'No Records Found', 'ne najdemo zapisov', '2012-05-12 17:56:08'),
(7460, 'sl', 'common', 'noactivetools', 'Ni nobenega vključenega SEO orodja', '2012-05-12 17:56:08'),
(7461, 'sl', 'common', 'nowebsites', 'Ni najdenih spletnih strani', '2012-05-12 17:56:08'),
(7462, 'sl', 'common', 'password632', 'Geslo mora biti dolgo med 6 in 32 znakov', '2012-05-12 17:56:08'),
(7463, 'sl', 'common', 'passwordnotmatch', 'Gesli se ne ujemata', '2012-05-12 17:56:08'),
(7464, 'sl', 'common', 'Period', 'Pika', '2012-05-12 17:56:08'),
(7465, 'sl', 'common', 'Priority', 'Prioriteta', '2012-05-12 17:56:08'),
(7466, 'sl', 'common', 'Profile', 'Profil', '2012-05-12 17:56:08'),
(7467, 'sl', 'common', 'Rank', 'Rang', '2012-05-12 17:56:08'),
(7468, 'sl', 'common', 'Reports', 'Poročila', '2012-05-12 17:56:08'),
(7469, 'sl', 'common', 'Results', 'Rezultati', '2012-05-12 17:56:08'),
(7470, 'sl', 'common', 'Search Engine', 'Iskalnik', '2012-05-12 17:56:08'),
(7471, 'sl', 'common', 'Select', 'Izberi', '2012-05-12 17:56:08'),
(7472, 'sl', 'common', 'Seo Plugins', 'Seo vtičniki', '2012-05-12 17:56:08'),
(7473, 'sl', 'common', 'Seo Tools', 'Seo orodja', '2012-05-12 17:56:08'),
(7474, 'sl', 'common', 'Sign out', 'Odjava', '2012-05-12 17:56:08'),
(7475, 'sl', 'common', 'Sign Up', 'Registracija', '2012-05-12 17:56:08'),
(7476, 'sl', 'common', 'signin', 'Prijava', '2012-05-12 17:56:08'),
(7477, 'sl', 'common', 'Status', 'Status', '2012-05-12 17:56:08'),
(7478, 'sl', 'common', 'Support', 'Podpora', '2012-05-12 17:56:08'),
(7479, 'sl', 'common', 'Total', 'Skupaj', '2012-05-12 17:56:08'),
(7480, 'sl', 'common', 'Url', 'Url', '2012-05-12 17:56:08'),
(7481, 'sl', 'common', 'User', 'Uporabnik', '2012-05-12 17:56:08'),
(7482, 'sl', 'common', 'User Panel', 'Uporabniški kotiček', '2012-05-12 17:56:08'),
(7483, 'sl', 'common', 'Website', 'Spletna stran', '2012-05-12 17:56:08'),
(7484, 'sl', 'common', 'Yes', 'Da', '2012-05-12 17:56:08'),
(7485, 'sl', 'directory', 'Add back to directory list', 'Dodaj nazaj na seznam direktorijev', '2012-05-12 17:57:22'),
(7486, 'sl', 'directory', 'Approved', 'Odobreno', '2012-05-12 17:57:22'),
(7487, 'sl', 'directory', 'Captcha', 'Captcha', '2012-05-12 17:57:22'),
(7488, 'sl', 'directory', 'categorynote', 'Kategorije, ločite jih z vejicami glede na prioriteto. Začnite z pomembnejšo kategorijo.', '2012-05-12 17:57:22'),
(7489, 'sl', 'directory', 'Check Directory Status', 'Preveri status direktorija', '2012-05-12 17:57:22'),
(7490, 'sl', 'directory', 'Check Directory Submission Status', 'Preveri status pošiljanja v direktorij', '2012-05-12 17:57:22'),
(7491, 'sl', 'directory', 'clicktoproceeddirsts', 'Kliknite <b>Nadaljuj</b> za preverjanje statusa direktorija', '2012-05-12 17:57:22'),
(7492, 'sl', 'directory', 'Confirmation', 'Potrditev', '2012-05-12 17:57:22'),
(7493, 'sl', 'directory', 'desnote', 'Nekateri direktoriji zahtevajo vnos vsaj 150 znakov v polje za opis.', '2012-05-12 17:57:22'),
(7494, 'sl', 'directory', 'Directories with out captcha', 'Direktoriji brez capcha preverjanja', '2012-05-12 17:57:22'),
(7495, 'sl', 'directory', 'Directory Submission Reports', 'Poročilo o uspešnosti pošiljanja v direktorije', '2012-05-12 17:57:22'),
(7496, 'sl', 'directory', 'Enter the code shown', 'Vnesite prikazano kodo', '2012-05-12 17:57:22'),
(7497, 'sl', 'directory', 'nocatnote', 'Kategorija vnosa ni najdena na spletni strani za vnos. Prosim kliknite <b>Osveži</b> ali <b>Preskoči</b>', '2012-05-12 17:57:22'),
(7498, 'sl', 'directory', 'nodirnote', 'Ne najdem <b>aktivnih</b> direktorijev', '2012-05-12 17:57:22'),
(7499, 'sl', 'directory', 'nosuccessnote', 'ni sporočila o uspešnosti, Prosim preverite vaš E-naslov za potrditveno sporočilo', '2012-05-12 17:57:22'),
(7500, 'sl', 'directory', 'optionalnote', 'Neobvezni naslovi in opisi za random pošiljanje v direktorije za boljše rezultate.', '2012-05-12 17:57:22'),
(7501, 'sl', 'directory', 'Owner Email', 'Drugi E-mail', '2012-05-12 17:57:22'),
(7502, 'sl', 'directory', 'Owner Name', 'Ime lastnika', '2012-05-12 17:57:22'),
(7503, 'sl', 'directory', 'Pending', 'Na čakanju', '2012-05-12 17:57:22'),
(7504, 'sl', 'directory', 'Please select a website to proceed', 'Prosim izberite spletno stran za nadaljevanje', '2012-05-12 17:57:22'),
(7505, 'sl', 'directory', 'Reciprocal Link', 'Recipročna povezava', '2012-05-12 17:57:22'),
(7506, 'sl', 'directory', 'selectwebsiteproceed', 'Izverite <b>spletno stran</b> za <b>nadaljevanje</b> vpisovanja v direktorije. <br>Preverite <b>Direktorije brez Capcha preverjanja</b> za pošiljanje v direktorije brez preverjanja ', '2012-05-12 17:57:22'),
(7507, 'sl', 'directory', 'selectwebsiteschecksub', 'Izberite <b>Spletno stran</b> za <b>Nadaljevanje</b> preverjanje vpisov v direktorije.', '2012-05-12 17:57:22'),
(7508, 'sl', 'directory', 'Semi Automatic Directory Submission Tool', 'Orodje za polavtomatsko vpisovanje v direktorije', '2012-05-12 17:57:22'),
(7509, 'sl', 'directory', 'spamemailnote', 'Nekateri direktoriji lahko pošiljajo SPAM, priporočamo da ne uporabite vašega glavnega E-poštnega naslova.', '2012-05-12 17:57:22'),
(7510, 'sl', 'directory', 'Submission Details', 'Podrobnosti vpisovanja', '2012-05-12 17:57:22'),
(7511, 'sl', 'directory', 'Submit Description', 'Vnesite opis', '2012-05-12 17:57:22'),
(7512, 'sl', 'directory', 'Submit Keywords', 'Vnesite ključne besede', '2012-05-12 17:57:22'),
(7513, 'sl', 'directory', 'Submit Title', 'Vnesite Naslov', '2012-05-12 17:57:22'),
(7514, 'sl', 'directory', 'Website Category', 'Kategorija spletne strani', '2012-05-12 17:57:22'),
(7515, 'sl', 'directory', 'Website Url', 'Naslov spletne strani', '2012-05-12 17:57:22'),
(7516, 'sl', 'home', 'Account Summary', 'Podrobnosti Računa', '2012-01-20 08:35:05'),
(7517, 'sl', 'home', 'Backlinks', 'Povratne povezave', '2012-01-20 08:35:05'),
(7518, 'sl', 'home', 'Directory Submission', 'Vpisi v direktorije', '2012-01-20 08:35:05'),
(7519, 'sl', 'home', 'home_cont1', '<h1 style=\\"text-align: center;margin-bottom: 30px;font-size: 19px;\\">Pozdravljeni v  Seo Panelu - Prvemu ki podpira več strani</h1> \r\n        <p> \r\n            Celovito <b>odprto kodno seo orodje</b> za upravljanje <b>spletne optimizacije</b> na vaših straneh.\r\n\r\n            Seo Panel je <b>seo orodje</b> ki vključuje številna orodjaza povečanjr in spremljane\r\n<b>uspešnosti</b> vaših strani. \r\n            Osnovna verzija <b>je brezplačna</b> licencirana pod <b>GNU GENERAL PUBLIC LICENSE</b>. \r\n            Dodatne <b>razširitve</b> lahko dobite <a href=\\"<?=SP_PLUGINSITE?>\\"\r\ntarget=\\"_blank\\"> tukaj</a>. \r\n            Vsak lahko <b>razvija in naloži</b> dodatne vtičnike za svoj seo panel.  \r\n        </p> \r\n        <p></p> \r\n        <p> \r\n            Ta odprto kodna rešitevs je <b>izšla Januarja 2010</b>. \r\n            V tako <b>kratkem obdobju</b> jo uporablja že <b>tisoče</b> <b>ljudi</b> za <b>optimizacijo</b> njihovih strani. \r\n            Začnite <b>uporabljati</b> vsa orodja <b>na eni platformi</b>. \r\n        </p>', '2012-01-20 08:35:05'),
(7520, 'sl', 'home', 'home_cont2', '<fieldset><legend>Major Features of Seo Panel <?=SP_INSTALLED?></legend> \r\n<ul class=\\"infobox\\"> \r\n    <li>         \r\n        <h1>Automatic Directory Submission Tool</h1> \r\n        <p> \r\n            Automatic directory submission tool help us to <b>submit our websites</b> into to major <b>free\r\nand paid internet directories</b>. \r\n            We can also <b>track the status</b> of each submision through <b>periodical check</b> using\r\nsubmission <b>status checker script</b>. \r\n            <b>Directory manager</b> will help us to find out whether <b>directory is active</b> or not. \r\n        </p> \r\n    </li> \r\n    <li>         \r\n        <h1>Keyword Position Checker</h1> \r\n        <p> \r\n            Keyword position checker will find the <b>search engine position</b> of <b>targetted keywords</b>\r\nof your website and <b>stores</b> it in the system. \r\n            In keyword position reports section, we can see the <b>daily positions</b> of keywords in\r\ndifferent search engines by <b>beautiful graphs</b> and <b>detailed reports</b>. \r\n        </p> \r\n    </li> \r\n    <li>         \r\n        <h1>Site Auditor</h1> \r\n        <p>Site Auditor will <b>audit all SEO factors</b> of each pages of a site and will give a\r\n<b>detailed report</b> about each page. This will help us to create <b>XML,HTML,TEXT</b> sitemap\r\nfiles of our website for <b>submit</b> to search engines.</p> \r\n    </li> \r\n    <li>         \r\n        <h1>Google and Alexa Rank Checker</h1> \r\n        <p> \r\n            Google and alexa rank checker will find <b>google pagerank</b> and <b>alexa rank</b> of our\r\nwebsites and <b>stores</b> it in the system. \r\n            In <b>rank reports</b> section, we can see the <b>daily</b> google and alexa rank of each website\r\nby <b>detailed reports</b>. \r\n        </p> \r\n    </li> \r\n    <li>         \r\n        <h1>Backlinks Checker</h1> \r\n        <p> \r\n            Backlinks checker will find <b>number of backlinks</b> of our websites in different search\r\nengines<b>(google,yahoo,msn etc)</b> and <b>stores</b> it in the system. \r\n            <br>In <b>backlink reports</b> section, we can see the <b>daily backlinks count</b> of each\r\nwebsite by <b>detailed reports</b>. \r\n        </p> \r\n    </li>     \r\n    <li>         \r\n        <h1>Search Engine Saturation Checker</h1> \r\n        <p> \r\n            Search Engine Saturation checker will find <b>number of indexed pages</b> of our websites in\r\ndifferent search engines<b>(google,yahoo,msn etc)</b> and <b>stores</b> it in the system. \r\n            In <b>search engine saturation checker reports</b> section, we can see the <b>daily indexed page\r\ncount</b> of each website by <b>detailed reports</b>. \r\n        </p> \r\n    </li> \r\n    <li>         \r\n        <h1>Seo Panel Plugins</h1> \r\n        <p> \r\n            The <b>major feature</b> of seo control panel is its <b>extentability</b>. \r\n            Add <b>seo plugins</b> to your seo panel to <b>extend the features</b> according to your\r\nrequirement. \r\n            <a href=\\"<?=SP_PLUGINSITE?>\\" target=\\"_blank\\">Seo panel plugins</a> are provided by both seo panel\r\nand third party sites. \r\n            You can also easily <b>develop</b> seo plugins for your seo panel. \r\n            You can <a href=\\"<?=SP_PLUGINSITE?>\\" target=\\"_blank\\">submit</a> your seo plugin to seo panel and\r\nwe will <b>publish</b> it in our website after our <b>review</b> process. \r\n        </p> \r\n    </li> \r\n    <li>         \r\n        <h1>Meta Tag Generator</h1> \r\n        <p> \r\n            Meta tag generator is a <b>seo panel plugin</b> for creating <b>custom meta tags</b> for our\r\nsite. \r\n            It will help us to give <b>more information</b> about our website to <b>search engine bots</b>\r\nwhile they crawl our website. \r\n        </p> \r\n    </li> \r\n</ul> \r\n</fieldset>', '2012-01-20 08:35:05'),
(7521, 'sl', 'home', 'home_cont3', '<fieldset> \r\n<legend>Seo Panel Online Resources</legend>     \r\n<ul class=\\"infobox\\"> \r\n\r\n    <li> \r\n        <h1>Seo Panel Online Resources for Reference</h1>                 \r\n         \r\n         \r\n        <p> \r\n            <a href=\\"http://www.seopanel.in\\" target=\\"_blank\\">Seo Panel Official Site</a> \r\n        </p> \r\n        <p> \r\n            <a href=\\"<?=SP_DOWNLOAD_LINK?>\\" target=\\"_blank\\">Download Seo Panel</a> \r\n        </p> \r\n         \r\n        <p> \r\n            <a href=\\"<?=SP_DEMO_LINK?>\\" target=\\"_blank\\">Seo Panel Demo</a> \r\n        </p> \r\n         \r\n        <p> \r\n            <a href=\\"<?=SP_CONTACT_LINK?>\\" target=\\"_blank\\">Conatct Seo Panel</a> \r\n        </p> \r\n         \r\n        <p> \r\n            <a href=\\"<?=SP_HELP_LINK?>\\" target=\\"_blank\\">Seo Panel Help Guide</a> \r\n        </p> \r\n         \r\n        <p> \r\n            <a href=\\"<?=SP_FORUM_LINK?>\\" target=\\"_blank\\">Seo Panel Forum</a> \r\n        </p> \r\n         \r\n        <p> \r\n            <a href=\\"<?=SP_SUPPORT_LINK?>\\" target=\\"_blank\\">Seo Panel Support System</a> \r\n        </p> \r\n         \r\n        <p> \r\n            <a href=\\"<?=SP_DONATE_LINK?>\\" target=\\"_blank\\">Donate to Seo Panel</a> \r\n        </p> \r\n    </li> \r\n     \r\n</ul> \r\n</fieldset>', '2012-01-20 08:35:05'),
(7522, 'sl', 'home', 'Indexed', 'Indeksirano', '2012-01-20 08:35:05'),
(7523, 'sl', 'home', 'Pages Indexed', 'Indeksirane strani', '2012-01-20 08:35:05'),
(7524, 'sl', 'home', 'Ranks', 'Rangiranje', '2012-01-20 08:35:05'),
(7525, 'sl', 'home', 'SiteNameUrl', 'Spletni naslovi/URLji', '2012-01-20 08:35:05'),
(7526, 'sl', 'home', 'Website Statistics', 'Statistika', '2012-01-20 08:35:05'),
(7527, 'sl', 'keyword', 'Crawling keyword', 'Ključna beseda', '2012-01-28 09:21:41'),
(7528, 'sl', 'keyword', 'Detailed Keyword Position Reports', 'Podrobna poročila o rangiranju ključnih besed', '2012-01-28 09:21:41'),
(7529, 'sl', 'keyword', 'Edit Keyword', 'Uredi ključno besedo', '2012-01-28 09:21:41'),
(7530, 'sl', 'keyword', 'Graphical Keyword Position Reports', 'Grafična poročila o uvrstitvah', '2012-01-28 09:21:41');
INSERT INTO `texts` (`id`, `lang_code`, `category`, `label`, `content`, `changed`) VALUES
(7531, 'sl', 'keyword', 'Import Keywords', 'Uvozi ključne besede', '2012-01-28 09:21:41'),
(7532, 'sl', 'keyword', 'Insert keywords separated with comma', 'Vpišite ključne besede, ločite jih z vejico', '2012-01-28 09:21:41'),
(7533, 'sl', 'keyword', 'Keyword already exist', 'Ključna beseda že obstaja', '2012-01-28 09:21:41'),
(7534, 'sl', 'keyword', 'Keyword Position Report', 'Poročilo o uvrstitvah', '2012-01-28 09:21:41'),
(7535, 'sl', 'keyword', 'New Keyword', 'Nova ključna beseda', '2012-01-28 09:21:41'),
(7536, 'sl', 'keyword', 'not assigned to required search engines', 'ni dodeljenih iskalnikov', '2012-01-28 09:21:41'),
(7537, 'sl', 'keyword', 'pleaseselecttool', 'Izberite vsaj eno SEO orodje', '2012-01-28 09:21:41'),
(7538, 'sl', 'keyword', 'Quick Keyword Position Checker', 'Hitro preverjanje uvrstitev', '2012-01-28 09:21:41'),
(7539, 'sl', 'keyword', 'results from ', 'rezultati iz', '2012-01-28 09:21:41'),
(7540, 'sl', 'keyword', 'Show All results', 'Prikaži vse rezultate', '2012-01-28 09:21:41'),
(7541, 'sl', 'keyword', 'Successfully crawled keyword', 'Uspešen pregled ključne besede', '2012-01-28 09:21:41'),
(7542, 'sl', 'keyword', 'to create new keywords', 'za ustvarjanje novih ključnih besed', '2012-01-28 09:21:41'),
(7543, 'sl', 'label', 'already exist', 'že obstaja', '2012-05-12 17:57:43'),
(7544, 'sl', 'label', 'Authentication', 'Avtentikacija', '2012-05-12 17:57:43'),
(7545, 'sl', 'label', 'Author', 'Avtor', '2012-05-12 17:57:43'),
(7546, 'sl', 'label', 'Brocken', 'nedelujoča', '2012-05-12 17:57:43'),
(7547, 'sl', 'label', 'Click Here', 'Kliknite sem', '2012-05-12 17:57:43'),
(7548, 'sl', 'label', 'Comments', 'Komentarji', '2012-05-12 17:57:43'),
(7549, 'sl', 'label', 'Count', 'Štetje', '2012-05-12 17:57:43'),
(7550, 'sl', 'label', 'Cron', 'Cron', '2012-05-12 17:57:43'),
(7551, 'sl', 'label', 'Description', 'Opis', '2012-05-12 17:57:43'),
(7552, 'sl', 'label', 'Developers', 'Razvijalci', '2012-05-12 17:57:43'),
(7553, 'sl', 'label', 'Download', 'Download', '2012-05-12 17:57:43'),
(7554, 'sl', 'label', 'Exclude', 'Izključi', '2012-05-12 17:57:43'),
(7555, 'sl', 'label', 'Include', 'Vključi', '2012-05-12 17:57:43'),
(7556, 'sl', 'label', 'Installation', 'Instalacija', '2012-05-12 17:57:43'),
(7557, 'sl', 'label', 'Keywords', 'Klučne besede', '2012-05-12 17:57:43'),
(7558, 'sl', 'label', 'noactiveplugins', 'Ne najdem aktivnih dodatkov!', '2012-05-12 17:57:43'),
(7559, 'sl', 'label', 'Plugin', 'Dodatek', '2012-05-12 17:57:43'),
(7560, 'sl', 'label', 'Port', 'vrata', '2012-05-12 17:57:43'),
(7561, 'sl', 'label', 'Project', 'Projekt', '2012-05-12 17:57:43'),
(7562, 'sl', 'label', 'Proxy', 'Proxy', '2012-05-12 17:57:43'),
(7563, 'sl', 'label', 'Re-install', 'Ponovna instalacija', '2012-05-12 17:57:43'),
(7564, 'sl', 'label', 'Report Type', 'Tip poročila', '2012-05-12 17:57:43'),
(7565, 'sl', 'label', 'Score', 'Točke', '2012-05-12 17:57:43'),
(7566, 'sl', 'label', 'Sponsors', 'Sponzorji', '2012-05-12 17:57:43'),
(7567, 'sl', 'label', 'Title', 'Naslov', '2012-05-12 17:57:43'),
(7568, 'sl', 'label', 'Total Results', 'Skupni rezultati', '2012-05-12 17:57:43'),
(7569, 'sl', 'label', 'translation by', 'prevedel:', '2012-05-12 17:57:43'),
(7570, 'sl', 'label', 'Translators', 'Prevajalci', '2012-05-12 17:57:43'),
(7571, 'sl', 'label', 'Updated', 'Posodobljeno', '2012-05-12 17:57:43'),
(7572, 'sl', 'label', 'Upgrade', 'Nadgradi', '2012-05-12 17:57:43'),
(7573, 'sl', 'label', 'Version', 'Verzija', '2012-05-12 17:57:43'),
(7574, 'sl', 'label', 'View Reports', 'Preglej poročila', '2012-05-12 17:57:43'),
(7575, 'sl', 'label', 'wantproceed', 'Resnično želite nadaljevati?', '2012-05-12 17:57:43'),
(7576, 'sl', 'login', 'Confirm Password', 'Potrdite geslo', '2012-01-28 09:29:09'),
(7577, 'sl', 'login', 'Create my account', 'Izdelajte si račun', '2012-01-28 09:29:09'),
(7578, 'sl', 'login', 'Create New Account', 'Izdelajte nov račun', '2012-01-28 09:29:09'),
(7579, 'sl', 'login', 'Email', 'E-poštni naslov', '2012-01-28 09:29:09'),
(7580, 'sl', 'login', 'emailexist', 'E-poštni naslov že obstaja', '2012-01-28 09:29:09'),
(7581, 'sl', 'login', 'Enter the code as it is shown', 'Vpišite kodo, kot je prikazana', '2012-01-28 09:29:09'),
(7582, 'sl', 'login', 'First Name', 'Ime', '2012-01-28 09:29:09'),
(7583, 'sl', 'login', 'Last Name', 'Priimek', '2012-01-28 09:29:09'),
(7584, 'sl', 'login', 'Login', 'Prijava', '2012-01-28 09:29:09'),
(7585, 'sl', 'login', 'Login incorrect', 'Prijava ni uspela', '2012-01-28 09:29:09'),
(7586, 'sl', 'login', 'newaccountsuccess', 'Uspešno ustvarjen nov račun', '2012-01-28 09:29:09'),
(7587, 'sl', 'login', 'Password', 'Geslo', '2012-01-28 09:29:09'),
(7588, 'sl', 'login', 'Password incorrect', 'Nepravilno geslo', '2012-01-28 09:29:09'),
(7589, 'sl', 'login', 'Register', 'Registracija', '2012-01-28 09:29:09'),
(7590, 'sl', 'login', 'Sign in to your account', 'Prijavite se v vaš račun', '2012-01-28 09:29:09'),
(7591, 'sl', 'login', 'User inactive', 'Uporabnik ni aktiven', '2012-01-28 09:29:09'),
(7592, 'sl', 'login', 'Username', 'Uporabniško ime', '2012-01-28 09:29:09'),
(7593, 'sl', 'login', 'usernameexist', 'Uporabniško ime že obstaja', '2012-01-28 09:29:09'),
(7594, 'sl', 'panel', 'About Us', 'O nas', '2012-05-12 17:58:34'),
(7595, 'sl', 'panel', 'Add following command to your cron tab', 'Dodajte naslednji cron ukaz', '2012-05-12 17:58:34'),
(7596, 'sl', 'panel', 'alsocheckfollowlink', 'Na tej povezavi lahko najdete več informacij.', '2012-05-12 17:58:34'),
(7597, 'sl', 'panel', 'Check Directory', 'Preverite mapo', '2012-05-12 17:58:34'),
(7598, 'sl', 'panel', 'Cron Command', 'Cron ukaz', '2012-05-12 17:58:34'),
(7599, 'sl', 'panel', 'Directory Manager', 'Upravljalec map', '2012-05-12 17:58:34'),
(7600, 'sl', 'panel', 'Edit My Profile', 'Uredi profil', '2012-05-12 17:58:34'),
(7601, 'sl', 'panel', 'Edit Project', 'Uredi projekt', '2012-05-12 17:58:34'),
(7602, 'sl', 'panel', 'My Profile', 'Moj profil', '2012-05-12 17:58:34'),
(7603, 'sl', 'panel', 'New Project', 'Nov projekt', '2012-05-12 17:58:34'),
(7604, 'sl', 'panel', 'New Proxy', 'Nov proxy', '2012-05-12 17:58:34'),
(7605, 'sl', 'panel', 'New User', 'novi uporabnik', '2012-05-12 17:58:34'),
(7606, 'sl', 'panel', 'New Website', 'Nova spletna stran', '2012-05-12 17:58:34'),
(7607, 'sl', 'panel', 'Proxy Manager', 'Upravitelj proxijev', '2012-05-12 17:58:34'),
(7608, 'sl', 'panel', 'Report Generation Manager', 'Upravljanje izdelave poročil', '2012-05-12 17:58:34'),
(7609, 'sl', 'panel', 'Reports Manager', 'Upravitelj poročil', '2012-05-12 17:58:34'),
(7610, 'sl', 'panel', 'Seo Plugins Manager', 'Upravitelj SEO dodatkov', '2012-05-12 17:58:34'),
(7611, 'sl', 'panel', 'Seo Tools Manager', 'Upravitelj SEO orodij', '2012-05-12 17:58:34'),
(7612, 'sl', 'panel', 'System Settings', 'Sistemske nastavitve', '2012-05-12 17:58:34'),
(7613, 'sl', 'panel', 'User Manager', 'Upravitelj uporabnikov', '2012-05-12 17:58:34'),
(7614, 'sl', 'panel', 'Website Manager', 'Upravitelj spletnih strani', '2012-05-12 17:58:34'),
(7615, 'sl', 'proxy', 'Edit Proxy', 'Uredi Proxy', '2012-01-28 09:32:57'),
(7616, 'sl', 'proxy', 'Proxy Password', 'Geslo za Proxy', '2012-01-28 09:32:57'),
(7617, 'sl', 'proxy', 'Proxy Username', 'Uporabniško ime za Proxy', '2012-01-28 09:32:57'),
(7618, 'sl', 'proxy', 'Proxyalreadyexist', 'Proxy že obstaja', '2012-01-28 09:32:57'),
(7619, 'sl', 'plugin', 'Edit Seo Plugin', 'Uredi SEO dodatek', '2012-05-12 17:59:13'),
(7620, 'sl', 'plugin', 'Plugin Name', 'Ime dodatka', '2012-05-12 17:59:13'),
(7621, 'sl', 'plugin', 'Seo Plugin Details', 'Podrobnosti dodatka', '2012-05-12 17:59:13'),
(7622, 'sl', 'rank', 'enterurlproceed', 'Vnesite URL naslove <b>vsakega v svojo vrstico</b>. Kliknite na <b>Nadaljuj</b> za preverjanje uvrstitev v Googlu in Alexi.', '2012-01-28 09:39:58'),
(7623, 'sl', 'rank', 'Google and Alexa Rank Reports', 'Poročila o uvrstitvah v Alexi in Googlu', '2012-01-28 09:39:58'),
(7624, 'sl', 'rank', 'Saved rank results of', 'Shranjeni rezultati za', '2012-01-28 09:39:58'),
(7625, 'sl', 'saturation', 'clickproceedsaturation', 'Vpišite URL naslove, <b>vsakega v svojo vrstico</b>. Kliknite na <b>Nadaljuj</b>za preverjanje nasičenosti', '2012-01-28 09:42:39'),
(7626, 'sl', 'saturation', 'GenerateSaturationReports', 'Izdelaj poročilo o zasičenosti', '2012-01-28 09:42:39'),
(7627, 'sl', 'saturation', 'Quick Search Engine Saturation Checker', 'Hiter pregled zasičenosti', '2012-01-28 09:42:39'),
(7628, 'sl', 'saturation', 'Saved Search Engine Saturation results of', 'Shranjeni rezultati o zasičenosti', '2012-01-28 09:42:39'),
(7629, 'sl', 'saturation', 'Search Engine Saturation Reports', 'Poročila o zasičenosti', '2012-01-28 09:42:39'),
(7630, 'sl', 'seotools', 'Auditor Projects', 'Projekti preverjanja', '2013-02-15 22:20:16'),
(7631, 'sl', 'seotools', 'Auditor Reports', 'Poročila preverjanja', '2013-02-15 22:20:16'),
(7632, 'sl', 'seotools', 'Auditor Settings', 'Nastavitve preverjanja', '2013-02-15 22:20:16'),
(7633, 'sl', 'seotools', 'Automatic Submission', 'Avtomatsko pošiljanje', '2013-02-15 22:20:16'),
(7634, 'sl', 'seotools', 'backlink-checker', 'Preverjanje povratnih povezav', '2013-02-15 22:20:16'),
(7635, 'sl', 'seotools', 'Backlinks Reports', 'Poročila o povratnih povezavah', '2013-02-15 22:20:16'),
(7636, 'sl', 'seotools', 'Check Submission Status', 'Preverjanje statusa pošiljanja', '2013-02-15 22:20:16'),
(7637, 'sl', 'seotools', 'clickgeneratereports', 'Kliknite na <b>Nadaljuj</b> za izdelavo poročil', '2013-02-15 22:20:16'),
(7638, 'sl', 'seotools', 'Detailed Position Reports', 'Podrobna poročila o uvrstitvah', '2013-02-15 22:20:16'),
(7639, 'sl', 'seotools', 'directory-submission', 'Pošiljanje v direktorije', '2013-02-15 22:20:16'),
(7640, 'sl', 'seotools', 'Featured Submission', 'Featured pošiljanje', '2013-02-15 22:20:16'),
(7641, 'sl', 'seotools', 'Generate Backlinks Reports', 'Izdelaj poročilo o povezavah', '2013-02-15 22:20:16'),
(7642, 'sl', 'seotools', 'Generate Keyword Reports', 'Izdelaj poročila o ključnih besedah', '2013-02-15 22:20:16'),
(7643, 'sl', 'seotools', 'Generate Rank Reports', 'Izdelaj poročila o uvrstitvah', '2013-02-15 22:20:16'),
(7644, 'sl', 'seotools', 'Generate Saturation Reports', 'Izdelaj poročila o preverjanju', '2013-02-15 22:20:16'),
(7645, 'sl', 'seotools', 'Google Sitemap Generator', 'Izdelaj sitemap', '2013-02-15 22:20:16'),
(7646, 'sl', 'seotools', 'Graphical Position Reports', 'Grafična poročila o uvrstitvah', '2013-02-15 22:20:16'),
(7647, 'sl', 'seotools', 'Import Project Links', 'Uvozi povezave projekta', '2013-02-15 22:20:16'),
(7648, 'sl', 'seotools', 'Keyword Position Summary', 'Izvleček poročila o ključnih besedah', '2013-02-15 22:20:16'),
(7649, 'sl', 'seotools', 'keyword-position-checker', 'Preverjanje uvrstitev', '2013-02-15 22:20:16'),
(7650, 'sl', 'seotools', 'Keywords Manager', 'Upravitelj ključnih besed', '2013-02-15 22:20:16'),
(7651, 'sl', 'seotools', 'Quick Backlinks Checker', 'Hitro preverjanje povratnih povezav', '2013-02-15 22:20:16'),
(7652, 'sl', 'seotools', 'Quick Position Checker', 'Hitro preverjanje uvrstitev', '2013-02-15 22:20:16'),
(7653, 'sl', 'seotools', 'Quick Rank Checker', 'Hitro preverjanje Rangiranja', '2013-02-15 22:20:16'),
(7654, 'sl', 'seotools', 'Quick Saturation Checker', 'Hitro preverjanje  (Saturation Checker)', '2013-02-15 22:20:16'),
(7655, 'sl', 'seotools', 'Rank Reports', 'Poročilo o rangiranju', '2013-02-15 22:20:16'),
(7656, 'sl', 'seotools', 'rank-checker', 'Rangiranje', '2013-02-15 22:20:16'),
(7657, 'sl', 'seotools', 'Saturation Reports', 'Saturation Reports', '2013-02-15 22:20:16'),
(7658, 'sl', 'seotools', 'saturation-checker', 'Search Engine Saturation', '2013-02-15 22:20:16'),
(7659, 'sl', 'seotools', 'site-auditor', 'Preverjanje strani', '2013-02-15 22:20:16'),
(7660, 'sl', 'seotools', 'sitemap-generator', 'Generator sitemapa', '2013-02-15 22:20:16'),
(7661, 'sl', 'seotools', 'Skipped Directories', 'Preskočeni direktoriji', '2013-02-15 22:20:16'),
(7662, 'sl', 'seotools', 'Submission Reports', 'Poročila o pošiljanju', '2013-02-15 22:20:16'),
(7663, 'sl', 'seotools', 'User Access', 'Uporabniški dostop', '2013-02-15 22:20:16'),
(7664, 'sl', 'website', 'Edit Website', 'Uredi spletno stran', '2012-01-28 09:59:05'),
(7665, 'sl', 'website', 'plscrtwebsite', 'Prosim ustvarite spletno stran pred začetkom dela z seo orodji in dodatki', '2012-01-28 09:59:05'),
(7666, 'sl', 'website', 'Website already exist', 'Stran že obstaja', '2012-01-28 09:59:05'),
(7667, 'sl', 'website', 'yourwebalreday', 'spletna stran, če ste jo že ustvarili.', '2012-01-28 09:59:05'),
(7668, 'sl', 'user', 'Edit User', 'Uredi uporabnika', '2012-01-28 09:59:29'),
(7669, 'sl', 'user', 'Saved My Profile Details', 'Shranjene podrobnosti profila', '2012-01-28 09:59:29'),
(7670, 'sl', 'sitemap', 'Change frequency', 'Spremeni pogostost', '2012-01-28 10:01:54'),
(7671, 'sl', 'sitemap', 'clickproceedsitemap', 'Kliknite na  <b>Nadaljuj</b> za izdelavo sitemap datoteke', '2012-01-28 10:01:54'),
(7672, 'sl', 'sitemap', 'Download sitemap file from', 'Povlecite datoteko', '2012-01-28 10:01:54'),
(7673, 'sl', 'sitemap', 'Exclude Url', 'Izključi URL', '2012-01-28 10:01:54'),
(7674, 'sl', 'sitemap', 'processtaketime', 'Ta proces lahko nekaj časa traja, odvisno od števila povezav na vaši spletni strani. Prosimo počakajte', '2012-01-28 10:01:54'),
(7675, 'sl', 'sitemap', 'Sitemap Type', 'Vrsta sitemap datoteke', '2012-01-28 10:01:54'),
(7676, 'vn', 'keyword', 'Crawling keyword', 'Đang kiểm tra thứ hạng từ khóa', '2012-01-30 22:33:14'),
(7677, 'vn', 'keyword', 'Detailed Keyword Position Reports', 'Báo cáo chi tiết vị trí Từ khóa', '2012-01-30 22:33:14'),
(7678, 'vn', 'keyword', 'Edit Keyword', 'Sửa Từ khóa', '2012-01-30 22:33:14'),
(7679, 'vn', 'keyword', 'Graphical Keyword Position Reports', 'Báo cáo chi tiết vị trí Từ khóa dạng Biểu đồ', '2012-01-30 22:33:14'),
(7680, 'vn', 'keyword', 'Import Keywords', 'Nhập nhiều Từ khóa', '2012-01-30 22:33:14'),
(7681, 'vn', 'keyword', 'Insert keywords separated with comma', 'Thêm Từ khóa cách nhau bằng dấu phẩy', '2012-01-30 22:33:14'),
(7682, 'vn', 'keyword', 'Keyword already exist', 'Từ khóa đã có', '2012-01-30 22:33:14'),
(7683, 'vn', 'keyword', 'Keyword Position Report', 'Báo cáo vị trí Từ khóa', '2012-01-30 22:33:14'),
(7684, 'vn', 'keyword', 'New Keyword', 'Từ khóa mới', '2012-01-30 22:33:14'),
(7685, 'vn', 'keyword', 'not assigned to required search engines', 'Không đúng với công cụ tìm kiếm được yêu cầu', '2012-01-30 22:33:14'),
(7686, 'vn', 'keyword', 'pleaseselecttool', 'Vui lòng chọn ít nhất một trong các Công cụ SEO', '2012-01-30 22:33:14'),
(7687, 'vn', 'keyword', 'Quick Keyword Position Checker', 'Kiểm tra nhanh vị trí Từ khóa', '2012-01-30 22:33:14'),
(7688, 'vn', 'keyword', 'results from ', 'khung kết quả', '2012-01-30 22:33:14'),
(7689, 'vn', 'keyword', 'Show All results', 'Hiển thị tất cả các kết quả', '2012-01-30 22:33:14'),
(7690, 'vn', 'keyword', 'Successfully crawled keyword', 'Đã thu thập thành công thông tin Từ khóa', '2012-01-30 22:33:14'),
(7691, 'vn', 'keyword', 'to create new keywords', 'dung để tạo các Từ khóa mới', '2012-01-30 22:33:14'),
(7692, 'vn', 'label', 'already exist', 'đã tồn tại', '2014-01-10 04:07:44'),
(7693, 'vn', 'label', 'Authentication', 'Xác thực', '2014-01-10 04:07:44'),
(7694, 'vn', 'label', 'Author', 'Tác giả', '2014-01-10 04:07:44'),
(7695, 'vn', 'label', 'Brocken', 'Bị hỏng', '2014-01-10 04:07:44'),
(7696, 'vn', 'label', 'Click Here', 'Click vào đây', '2014-01-10 04:07:44'),
(7697, 'vn', 'label', 'Comments', 'Các phản hồi', '2014-01-10 04:07:44'),
(7698, 'vn', 'label', 'Count', 'Đếm', '2014-01-10 04:07:44'),
(7699, 'vn', 'label', 'Cron', 'Định kỳ', '2014-01-10 04:07:44'),
(7700, 'vn', 'label', 'Description', 'Mô tả', '2014-01-10 04:07:44'),
(7701, 'vn', 'label', 'Developers', 'Nhà phát triển', '2014-01-10 04:07:44'),
(7702, 'vn', 'label', 'Download', 'Tải xuống', '2014-01-10 04:07:44'),
(7703, 'vn', 'label', 'Exclude', 'Loại trừ', '2014-01-10 04:07:44'),
(7704, 'vn', 'label', 'Include', 'Bao gồm', '2014-01-10 04:07:44'),
(7705, 'vn', 'label', 'Installation', 'Cài đặt', '2014-01-10 04:07:44'),
(7706, 'vn', 'label', 'Keywords', 'Các từ khóa', '2014-01-10 04:07:44'),
(7707, 'vn', 'label', 'noactiveplugins', 'Không tìm thấy phần mở rộng kích hoạt nào!', '2014-01-10 04:07:44'),
(7708, 'vn', 'label', 'Plugin', 'Phần mở rộng', '2014-01-10 04:07:44'),
(7709, 'vn', 'label', 'Port', 'Cổng', '2014-01-10 04:07:44'),
(7710, 'vn', 'label', 'Project', 'Dự án', '2014-01-10 04:07:44'),
(7711, 'vn', 'label', 'Proxy', 'Proxy', '2014-01-10 04:07:44'),
(7712, 'vn', 'label', 'Re-install', 'Cài đặt lại', '2014-01-10 04:07:44'),
(7713, 'vn', 'label', 'Report Type', 'Kiểu thông báo', '2014-01-10 04:07:44'),
(7714, 'vn', 'label', 'Score', 'Điểm', '2014-01-10 04:07:44'),
(7715, 'vn', 'label', 'Sponsors', 'Nhà tài trợ', '2014-01-10 04:07:44'),
(7716, 'vn', 'label', 'Title', 'Tiêu đề', '2014-01-10 04:07:44'),
(7717, 'vn', 'label', 'Total Results', 'Tổng hợp các kết quả', '2014-01-10 04:07:44'),
(7718, 'vn', 'label', 'translation by', 'dịch bởi', '2014-01-10 04:07:44'),
(7719, 'vn', 'label', 'Translators', 'Người dịch', '2014-01-10 04:07:44'),
(7720, 'vn', 'label', 'Updated', 'Đã cập nhập', '2014-01-10 04:07:44'),
(7721, 'vn', 'label', 'Upgrade', 'Nâng cấp', '2014-01-10 04:07:44'),
(7722, 'vn', 'label', 'Version', 'Phiên bản', '2014-01-10 04:07:44'),
(7723, 'vn', 'label', 'View Reports', 'Xem các Báo cáo', '2014-01-10 04:07:44'),
(7724, 'vn', 'label', 'wantproceed', 'Bạn thực sự muốn thực hiện?', '2014-01-10 04:07:44'),
(7725, 'vn', 'login', 'Confirm Password', 'Nhập lại Mật khẩu', '2014-01-10 04:02:16'),
(7726, 'vn', 'login', 'Create my account', 'Tạo tài khoản của tôi', '2014-01-10 04:02:16'),
(7727, 'vn', 'login', 'Create New Account', 'Tạo tài khoản mới', '2014-01-10 04:02:16'),
(7728, 'vn', 'login', 'Email', 'Thư điện tử', '2014-01-10 04:02:16'),
(7729, 'vn', 'login', 'emailexist', 'Địa chỉ thư điện tử này đã tồn tại', '2014-01-10 04:02:16'),
(7730, 'vn', 'login', 'Enter the code as it is shown', 'Nhập vào đoạn mã hiển thị', '2014-01-10 04:02:16'),
(7731, 'vn', 'login', 'First Name', 'Tên', '2014-01-10 04:02:16'),
(7732, 'vn', 'login', 'Last Name', 'Họ và Tên', '2014-01-10 04:02:16'),
(7733, 'vn', 'login', 'Login', 'Đăng nhập', '2014-01-10 04:02:16'),
(7734, 'vn', 'login', 'Login incorrect', 'Đăng nhập sai', '2014-01-10 04:02:16'),
(7735, 'vn', 'login', 'newaccountsuccess', 'Tài khoản mới đã được tạo thành công!', '2014-01-10 04:02:16'),
(7736, 'vn', 'login', 'Password', 'Mật khẩu', '2014-01-10 04:02:16'),
(7737, 'vn', 'login', 'Password incorrect', 'Mật khẩu sai', '2014-01-10 04:02:16'),
(7738, 'vn', 'login', 'Register', 'Đăng ký', '2014-01-10 04:02:16'),
(7739, 'vn', 'login', 'Sign in to your account', 'Đăng nhập vào tài khoản của bạn', '2014-01-10 04:02:16'),
(7740, 'vn', 'login', 'User inactive', 'Người sử dụng chưa kích hoạt', '2014-01-10 04:02:16'),
(7741, 'vn', 'login', 'Username', 'Tên đăng nhập', '2014-01-10 04:02:16'),
(7742, 'vn', 'login', 'usernameexist', 'Tên đăng nhập đã tồn tại', '2014-01-10 04:02:16'),
(7743, 'vn', 'panel', 'About Us', 'Giới thiệu', '2014-01-10 04:09:42'),
(7744, 'vn', 'panel', 'Add following command to your cron tab', 'Thêm lệnh sau đây vào bảng lệnh định kỳ của bạn', '2014-01-10 04:09:42'),
(7745, 'vn', 'panel', 'alsocheckfollowlink', 'Kiểm tra liên kết sau đây nếu cần biết thêm chi tiết.', '2014-01-10 04:09:42'),
(7746, 'vn', 'panel', 'Check Directory', 'Kiểm tra danh mục', '2014-01-10 04:09:42'),
(7747, 'vn', 'panel', 'Cron Command', 'Lệnh định kỳ', '2014-01-10 04:09:42'),
(7748, 'vn', 'panel', 'Directory Manager', 'Quản lý danh mục', '2014-01-10 04:09:42'),
(7749, 'vn', 'panel', 'Edit My Profile', 'Chỉnh sửa Hồ sơ của tôi', '2014-01-10 04:09:42'),
(7750, 'vn', 'panel', 'Edit Project', 'Sửa dự án', '2014-01-10 04:09:42'),
(7751, 'vn', 'panel', 'My Profile', 'Hồ sơ của tôi', '2014-01-10 04:09:42'),
(7752, 'vn', 'panel', 'New Project', 'Dự án mới', '2014-01-10 04:09:42'),
(7753, 'vn', 'panel', 'New Proxy', 'Proxy mới', '2014-01-10 04:09:42'),
(7754, 'vn', 'panel', 'New User', 'Người dùng mới', '2014-01-10 04:09:42'),
(7755, 'vn', 'panel', 'New Website', 'Website mới', '2014-01-10 04:09:42'),
(7756, 'vn', 'panel', 'Proxy Manager', 'Quản lý Proxy', '2014-01-10 04:09:42'),
(7757, 'vn', 'panel', 'Report Generation Manager', 'Quản lý Tạo báo cáo', '2014-01-10 04:09:42'),
(7758, 'vn', 'panel', 'Reports Manager', 'Quản lý Báo cáo', '2014-01-10 04:09:42'),
(7759, 'vn', 'panel', 'Seo Plugins Manager', 'Quản lý các Plugins Seo', '2014-01-10 04:09:42'),
(7760, 'vn', 'panel', 'Seo Tools Manager', 'Quản lý công cụ Seo', '2014-01-10 04:09:42'),
(7761, 'vn', 'panel', 'System Settings', 'Cấu hình hệ thống', '2014-01-10 04:09:42'),
(7762, 'vn', 'panel', 'User Manager', 'Quản lý Người sử dụng', '2014-01-10 04:09:42'),
(7763, 'vn', 'panel', 'Website Manager', 'Quản lý Website', '2014-01-10 04:09:42'),
(7764, 'vn', 'plugin', 'Edit Seo Plugin', 'Sửa Plugin Seo', '2014-01-10 04:10:14'),
(7765, 'vn', 'plugin', 'Plugin Name', 'Tên Plugin', '2014-01-10 04:10:14'),
(7766, 'vn', 'plugin', 'Seo Plugin Details', 'Chi tiết Plugin Seo', '2014-01-10 04:10:14'),
(7767, 'vn', 'proxy', 'Edit Proxy', 'Sửa Proxy', '2014-01-10 04:06:44'),
(7768, 'vn', 'proxy', 'Proxy Password', 'Mật khẩu Proxy', '2014-01-10 04:06:44'),
(7769, 'vn', 'proxy', 'Proxy Username', 'Tên đăng nhập Proxy', '2014-01-10 04:06:44'),
(7770, 'vn', 'proxy', 'Proxyalreadyexist', 'Proxy đã tồn tại!', '2014-01-10 04:06:44'),
(7771, 'vn', 'rank', 'enterurlproceed', 'Nhập Một URL <b>Trên mỗi dòng </ b>. Click vào <b> xử lý </ b> để kiểm tra thứ hạng Google và Alexa.', '2012-01-30 23:12:21'),
(7772, 'vn', 'rank', 'Google and Alexa Rank Reports', 'Báo cáo thứ hạng Google và Alexa', '2012-01-30 23:12:21'),
(7773, 'vn', 'rank', 'Saved rank results of', 'Đã lưu kết quả thứ hạng của', '2012-01-30 23:12:21'),
(7774, 'vn', 'saturation', 'clickproceedsaturation', 'Nhập Một URL <b>Trên mỗi dòng </ b>. Click vào <b>xử lý</ b> để kiểm tra kết quả chỉ số của máy tìm kiếm.', '2012-01-30 23:19:26'),
(7775, 'vn', 'saturation', 'GenerateSaturationReports', 'Tạo báo cáo kết quả chỉ số của máy tìm kiếm', '2012-01-30 23:19:26'),
(7776, 'vn', 'saturation', 'Quick Search Engine Saturation Checker', 'Kiểm tra nhanh chỉ số của máy tìm kiếm', '2012-01-30 23:19:26'),
(7777, 'vn', 'saturation', 'Saved Search Engine Saturation results of', 'Đã lưu kết quả chỉ số máy tìm kiếm của', '2012-01-30 23:19:26'),
(7778, 'vn', 'saturation', 'Search Engine Saturation Reports', 'Báo cáo chỉ số của máy tìm kiếm', '2012-01-30 23:19:26'),
(7779, 'vn', 'seotools', 'Auditor Projects', 'Kiểm tra dự án', '2012-01-31 17:45:48'),
(7780, 'vn', 'seotools', 'Auditor Reports', 'Kiểm tra báo cáo', '2012-01-31 17:45:48'),
(7781, 'vn', 'seotools', 'Auditor Settings', 'Kiểm tra Cài đặt', '2012-01-31 17:45:48'),
(7782, 'vn', 'seotools', 'Automatic Submission', 'Tự động gửi danh bạ', '2012-01-31 17:45:48'),
(7783, 'vn', 'seotools', 'backlink-checker', 'Kiểm tra Backlink', '2012-01-31 17:45:48'),
(7784, 'vn', 'seotools', 'Backlinks Reports', 'Báo cáo Backlink', '2012-01-31 17:45:48'),
(7785, 'vn', 'seotools', 'Check Submission Status', 'Kiểm tra trạng thái danh bạ', '2012-01-31 17:45:48'),
(7786, 'vn', 'seotools', 'clickgeneratereports', 'Ckick vào <b>xử lý</b> để tạo báo cáo', '2012-01-31 17:45:48'),
(7787, 'vn', 'seotools', 'Detailed Position Reports', 'Báo cáo chi tiết vị trí', '2012-01-31 17:45:48'),
(7788, 'vn', 'seotools', 'directory-submission', 'Gửi lên danh bạ', '2012-01-31 17:45:48'),
(7789, 'vn', 'seotools', 'Featured Submission', 'Các thông tin gửi', '2012-01-31 17:45:48'),
(7790, 'vn', 'seotools', 'Generate Backlinks Reports', 'Tạo báo cáo Backlink', '2012-01-31 17:45:48'),
(7791, 'vn', 'seotools', 'Generate Keyword Reports', 'Tạo báo cáo từ khóa', '2012-01-31 17:45:48'),
(7792, 'vn', 'seotools', 'Generate Rank Reports', 'Tạo báo cáo thứ hạng', '2012-01-31 17:45:48'),
(7793, 'vn', 'seotools', 'Generate Saturation Reports', 'Tạo báo cáo chỉ số', '2012-01-31 17:45:48'),
(7794, 'vn', 'seotools', 'Google Sitemap Generator', 'Tạo bản đồ website cho Google', '2012-01-31 17:45:48'),
(7795, 'vn', 'seotools', 'Graphical Position Reports', 'Báo cáo vị trí dạng biểu đồ', '2012-01-31 17:45:48'),
(7796, 'vn', 'seotools', 'Import Project Links', 'Thêm liên kết dự án', '2012-01-31 17:45:48'),
(7797, 'vn', 'seotools', 'Keyword Position Summary', 'Tóm tắt vị trí từ khóa', '2012-01-31 17:45:48'),
(7798, 'vn', 'seotools', 'keyword-position-checker', 'Kiểm tra vị trí từ khóa', '2012-01-31 17:45:48'),
(7799, 'vn', 'seotools', 'Keywords Manager', 'Quản lý từ khóa', '2012-01-31 17:45:48'),
(7800, 'vn', 'seotools', 'Quick Backlinks Checker', 'Kiểm tra nhanh back link', '2012-01-31 17:45:48'),
(7801, 'vn', 'seotools', 'Quick Position Checker', 'Kiểm tra nhanh vị trí từ khóa', '2012-01-31 17:45:48'),
(7802, 'vn', 'seotools', 'Quick Rank Checker', 'Kiểm tra nhanh thứ hạng', '2012-01-31 17:45:48'),
(7803, 'vn', 'seotools', 'Quick Saturation Checker', 'Kiểm tra nhanh chỉ số', '2012-01-31 17:45:48'),
(7804, 'vn', 'seotools', 'Rank Reports', 'Báo cáo thứ hạng', '2012-01-31 17:45:48'),
(7805, 'vn', 'seotools', 'rank-checker', 'Kiểm tra thứ hạng', '2012-01-31 17:45:48'),
(7806, 'vn', 'seotools', 'Saturation Reports', 'Báo cáo chỉ số', '2012-01-31 17:45:48'),
(7807, 'vn', 'seotools', 'saturation-checker', 'Chỉ số của máy tìm kiếm', '2012-01-31 17:45:48'),
(7808, 'vn', 'seotools', 'site-auditor', 'Kiểm toán trang web', '2012-01-31 17:45:48'),
(7809, 'vn', 'seotools', 'sitemap-generator', 'Tạo bản đồ website', '2012-01-31 17:45:48'),
(7810, 'vn', 'seotools', 'Skipped Directories', 'Bỏ qua thư mục', '2012-01-31 17:45:48'),
(7811, 'vn', 'seotools', 'Submission Reports', 'Gửi báo cáo', '2012-01-31 17:45:48'),
(7812, 'vn', 'seotools', 'User Access', 'Thành viên truy cập', '2012-01-31 17:45:48'),
(7813, 'vn', 'settings', 'Check for Updates', 'Kiểm tra bản nâng cấp', '2014-01-10 04:26:44'),
(7814, 'vn', 'settings', 'Click here to become a sponsor for Seo Panel', '<b>Ủng hộ $100</b> và trở thành <b>nhà tài trợ</b> của Seo Panel', '2014-01-10 04:26:44'),
(7815, 'vn', 'settings', 'SA_CRAWL_DELAY_TIME', 'Trang web kiểm toán viên thu thập dữ liệu chậm trễ giữa mỗi trang', '2014-01-10 04:26:44'),
(7816, 'vn', 'settings', 'SA_MAX_NO_PAGES', 'Giới hạn số trang lớn nhất đồng ý mỗi website', '2014-01-10 04:26:44'),
(7817, 'vn', 'settings', 'seopanel_description', 'Một bảng điều khiển hoàn toàn miễn phí quản lý tối ưu hóa công cụ tìm kiếm của các trang web của bạn.Nó chứa rất nhiều các công cụ seo nóng gia tăng và theo dõi các tiến trình trang web của bạn. Nó là một phần mềm nguồn mở và bạn cũng có thể phát triển các plugin seo riêng của bạn cho seo panel.', '2014-01-10 04:26:44'),
(7818, 'vn', 'settings', 'seopanel_title', 'Seo Panel: Bảng điều khiển seo mã nguồn mở đầu tiên trên thế giới hỗ trợ quản lý nhiều website', '2014-01-10 04:26:44'),
(7819, 'vn', 'settings', 'SP_API_KEY', 'Seo Panel API Key', '2014-01-10 04:26:44'),
(7820, 'vn', 'settings', 'SP_CRAWL_DELAY', 'Thời gian chậm mỗi khi nhện tìm kiếm thu thập thông tin (tính theo giây)', '2014-01-10 04:26:44'),
(7821, 'vn', 'settings', 'SP_DEFAULTLANG', 'Ngôn ngữ mặc định', '2014-01-10 04:26:44'),
(7822, 'vn', 'settings', 'SP_DESCRIPTION', 'Mô tả Seo Panel', '2014-01-10 04:26:44'),
(7823, 'vn', 'settings', 'SP_ENABLE_PROXY', 'Bật Proxy', '2014-01-10 04:26:44'),
(7824, 'vn', 'settings', 'SP_HOTLINKING', 'Kích hoạt bảo vệ hình ảnh hotlink', '2014-01-10 04:26:44'),
(7825, 'vn', 'settings', 'SP_KEYWORDS', 'Từ khóa Seo Panel ', '2014-01-10 04:26:44'),
(7826, 'vn', 'settings', 'SP_PAGINGNO', 'Số mục mỗi trang', '2014-01-10 04:26:44'),
(7827, 'vn', 'settings', 'SP_TITLE', 'Tiêu đề Seo Panel ', '2014-01-10 04:26:44'),
(7828, 'vn', 'settings', 'SP_USER_AGENT', 'Đại diện người sử dụng', '2014-01-10 04:26:44'),
(7829, 'vn', 'settings', 'SP_USER_GEN_REPORT', 'Đồng ý cho người sử dụng tạo báo cáo', '2014-01-10 04:26:44'),
(7830, 'vn', 'settings', 'SP_USER_REGISTRATION', 'Đăng ký giao diện người dùng', '2014-01-10 04:26:44'),
(7831, 'vn', 'settings', 'syssettingssaved', 'Cấu hình hệ thống đã được lưu thành công!', '2014-01-10 04:26:44'),
(7832, 'vn', 'settings', 'versionnotuptodatemsg', 'Bộ cài đặt Seo Panel của bạn chưa cập nhật. <br>Hãy tải về bản mới nhất', '2014-01-10 04:26:44'),
(7833, 'vn', 'settings', 'Your Seo Panel installation is up to date', 'Bộ cài đặt Seo Panel của bạn đang là bản mới nhất.', '2014-01-10 04:26:44'),
(7834, 'vn', 'user', 'Edit User', 'Sửa thành viên', '2012-01-31 21:01:18'),
(7835, 'vn', 'user', 'Saved My Profile Details', 'Lưu chi tiết hồ sơ của tôi', '2012-01-31 21:01:18'),
(7836, 'vn', 'website', 'Edit Website', 'Sửa website', '2012-01-31 21:02:54'),
(7837, 'vn', 'website', 'plscrtwebsite', 'Hãy tạo một website trước khi bắt đầu sử dụng các công cụ seo và các seo plugin.', '2012-01-31 21:02:54'),
(7838, 'vn', 'website', 'Website already exist', 'website đã có', '2012-01-31 21:02:54'),
(7839, 'vn', 'website', 'yourwebalreday', 'website của bạn nếu bạn đã tạo một cái', '2012-01-31 21:02:54'),
(7840, 'vn', 'sitemap', 'Change frequency', 'thay đổi tần xuất', '2012-01-31 21:20:45'),
(7841, 'vn', 'sitemap', 'clickproceedsitemap', 'Click vào <b>xử lý</b> để tạo file sitemap', '2012-01-31 21:20:45'),
(7842, 'vn', 'sitemap', 'Download sitemap file from', 'Tải file sitemap từ', '2012-01-31 21:20:45'),
(7843, 'vn', 'sitemap', 'Exclude Url', 'Loại trừ url', '2012-01-31 21:20:45'),
(7844, 'vn', 'sitemap', 'processtaketime', 'Quá trình này sẽ mất thời gian theo số lượng các liên kết trong trang web của bạn.Xin vui lòng chờ đợi để có được các tập tin sitemap', '2012-01-31 21:20:45'),
(7845, 'vn', 'sitemap', 'Sitemap Type', 'Kiểu sitemap', '2012-01-31 21:20:45'),
(7846, 'vn', 'siteauditor', 'Anchor', 'Anchor', '2012-02-02 21:04:10'),
(7847, 'vn', 'siteauditor', 'anylinkcontainabovelinks', 'Bất cứ liên kết nào chứa trên các liên kết sẽ được loại trừ từ các báo cáo', '2012-02-02 21:04:10'),
(7848, 'vn', 'siteauditor', 'anylinkcontainexcludesitemap', 'Bất cứ liên kết nào chứa trên các liên kết sẽ được loại trừ từ sitemap', '2012-02-02 21:04:10'),
(7849, 'vn', 'siteauditor', 'Check backlinks of pages', 'Kiểm tra các backlink của trang', '2012-02-02 21:04:10'),
(7850, 'vn', 'siteauditor', 'Check broken links in a page', 'Kiểm tra các liên kết hỏng của trang', '2012-02-02 21:04:10'),
(7851, 'vn', 'siteauditor', 'Check google pagerank of pages', 'Kiểm tra google pagerank của trang', '2012-02-02 21:04:10'),
(7852, 'vn', 'siteauditor', 'Check pages indexed or not', 'Kiểm tra trang đã được index hay chưa', '2012-02-02 21:04:10'),
(7853, 'vn', 'siteauditor', 'Check Score', 'Kiểm tra điểm', '2012-02-02 21:04:10'),
(7854, 'vn', 'siteauditor', 'checkborckenlinkwait', 'Kiểm tra các liên kết hoảng sẽ làm tăng thời gian tính toán của dự án', '2012-02-02 21:04:10'),
(7855, 'vn', 'siteauditor', 'Completed project execution', 'Hoàn thành thực hiện dự án', '2012-02-02 21:04:10'),
(7856, 'vn', 'siteauditor', 'Crawled', 'Đã crawl', '2012-02-02 21:04:10'),
(7857, 'vn', 'siteauditor', 'Crawled Pages', 'Các trang đã crawl', '2012-02-02 21:04:10'),
(7858, 'vn', 'siteauditor', 'crawledsuccesssfullywaitfornext', 'Thu thập thông tin (crawl) thành công! Đang chờ để thu thập dữ liệu trang tiếp theo', '2012-02-02 21:04:10'),
(7859, 'vn', 'siteauditor', 'Crawling Page', 'Đang crawl trang', '2012-02-02 21:04:10'),
(7860, 'vn', 'siteauditor', 'Duplicate Description', 'Trùng lặp mô tả', '2012-02-02 21:04:10'),
(7861, 'vn', 'siteauditor', 'Duplicate Keywords', 'Trùng lặp các từ khóa', '2012-02-02 21:04:10'),
(7862, 'vn', 'siteauditor', 'Duplicate Title', 'Trùng lặp tiêu đề', '2012-02-02 21:04:10'),
(7863, 'vn', 'siteauditor', 'Exclude links', 'Các liên kết loại trừ', '2012-02-02 21:04:10'),
(7864, 'vn', 'siteauditor', 'Execute with cron', 'Loại trừ với cron', '2012-02-02 21:04:10'),
(7865, 'vn', 'siteauditor', 'External', 'Bên ngoài', '2012-02-02 21:04:10'),
(7866, 'vn', 'siteauditor', 'External Links', 'Các liên kết ngoại', '2012-02-02 21:04:10'),
(7867, 'vn', 'siteauditor', 'Import Project Links', 'Thêm các liên kết dự án', '2012-02-02 21:04:10'),
(7868, 'vn', 'siteauditor', 'Insert links separated with comma', 'Thêm liên kết cách nhau bởi dấu phảy', '2012-02-02 21:04:10'),
(7869, 'vn', 'siteauditor', 'insertlinkssepcoma', 'Chèn liên kết cách nhau bằng dấu phẩy để loại trừ các liên kết vô hạn từ các báo cáo', '2012-02-02 21:04:10'),
(7870, 'vn', 'siteauditor', 'Link Reports', 'Báo cáo liên kết', '2012-02-02 21:04:10'),
(7871, 'vn', 'siteauditor', 'Link Title', 'Tiêu đề liên kết', '2012-02-02 21:04:10'),
(7872, 'vn', 'siteauditor', 'Maximum number of pages to be checked', 'Số trang lớn nhất sẽ được kiểm tra', '2012-02-02 21:04:10'),
(7873, 'vn', 'siteauditor', 'Maximum Pages', 'Số trang lớn nhất', '2012-02-02 21:04:10'),
(7874, 'vn', 'siteauditor', 'No active projects found', 'Không có dự án nào được bật', '2012-02-02 21:04:10'),
(7875, 'vn', 'siteauditor', 'Nofollow', 'Nofollow', '2012-02-02 21:04:10'),
(7876, 'vn', 'siteauditor', 'Number of pages is greater than', 'Số lượng trang lớn hơn', '2012-02-02 21:04:10'),
(7877, 'vn', 'siteauditor', 'Number of pages should be greater than', 'Số lượng trang nên lớn hơn', '2012-02-02 21:04:10'),
(7878, 'vn', 'siteauditor', 'Page Details', 'Chi tiết trang', '2012-02-02 21:04:10'),
(7879, 'vn', 'siteauditor', 'Page Link', 'Liên kết trang', '2012-02-02 21:04:10'),
(7880, 'vn', 'siteauditor', 'Page Links', 'Các Liên kết trang', '2012-02-02 21:04:10'),
(7881, 'vn', 'siteauditor', 'Pages Found', 'Các trang tìm thấy', '2012-02-02 21:04:10'),
(7882, 'vn', 'siteauditor', 'pressescapetostopexecution', 'Nhấn phím <b>escape</b> để dừng việc tính toán lại', '2012-02-02 21:04:10'),
(7883, 'vn', 'siteauditor', 'Project Summary', 'Tóm tắt dự án', '2012-02-02 21:04:10'),
(7884, 'vn', 'siteauditor', 'Project Url', 'Dự án url', '2012-02-02 21:04:10'),
(7885, 'vn', 'siteauditor', 'projectalreadyexist', 'Dự án cho website này đã tồn tại', '2012-02-02 21:04:10'),
(7886, 'vn', 'siteauditor', 'Recheck Pages', 'Kiểm tra lại các trang', '2012-02-02 21:04:10'),
(7887, 'vn', 'siteauditor', 'Report Summary', 'Tóm tắt báo cáo', '2012-02-02 21:04:10'),
(7888, 'vn', 'siteauditor', 'Run Project', 'Chạy dự án', '2012-02-02 21:04:10'),
(7889, 'vn', 'siteauditor', 'should start with', 'nên bắt đầu với', '2012-02-02 21:04:10'),
(7890, 'vn', 'siteauditor', 'Site Auditor Settings', 'Cấu hình phân tính website', '2012-02-02 21:04:10'),
(7891, 'vn', 'siteauditor', 'Store all links found in a page', 'Lưu toàn bộ liên kết tìm được trong một trang', '2012-02-02 21:04:10'),
(7892, 'vn', 'siteauditor', 'The page description length is not between', 'Chiều dài mô tả trang không phải là giữa', '2012-02-02 21:04:10'),
(7893, 'vn', 'siteauditor', 'The page is brocken', 'Trang web bị hỏng', '2012-02-02 21:04:10'),
(7894, 'vn', 'siteauditor', 'The page is having exellent number of backlinks in', 'Trang này có số backlink đến tuyệt vời', '2012-02-02 21:04:10'),
(7895, 'vn', 'siteauditor', 'The page is having exellent pagerank', 'Trang này có pagerank tuyệt vời', '2012-02-02 21:04:10'),
(7896, 'vn', 'siteauditor', 'The page is having good number of backlinks in', 'Trang này có số backlink đến tốt', '2012-02-02 21:04:10'