<?php
/*
 * psx
 * A object oriented and modular based PHP framework for developing
 * dynamic web applications. For the current version and informations
 * visit <http://phpsx.org>
 *
 * Copyright (c) 2010-2014 Christoph Kappestein <k42b3.x@gmail.com>
 *
 * This file is part of psx. psx is free software: you can
 * redistribute it and/or modify it under the terms of the
 * GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or any later version.
 *
 * psx is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with psx. If not, see <http://www.gnu.org/licenses/>.
 */

namespace PSX\Command;

use InvalidArgumentException;
use PSX\CommandInterface;
use PSX\Dispatch\CommandFactoryInterface;
use PSX\Loader\Location;

/**
 * Executor
 *
 * @author  Christoph Kappestein <k42b3.x@gmail.com>
 * @license http://www.gnu.org/licenses/gpl.html GPLv3
 * @link    http://phpsx.org
 */
class Executor
{
	protected $factory;
	protected $output;

	protected $aliases = array();

	public function __construct(CommandFactoryInterface $factory, OutputInterface $output)
	{
		$this->factory = $factory;
		$this->output  = $output;
	}

	public function addAlias($alias, $className)
	{
		$this->aliases[$alias] = $className;
	}

	public function getClassName($className)
	{
		return isset($this->aliases[$className]) ? $this->aliases[$className] : $className;
	}

	public function getAliases()
	{
		return $this->aliases;
	}

	public function run(ParameterParserInterface $parser, Location $location = null)
	{
		$location   = $location === null ? new Location() : $location;
		$className  = $this->getClassName($parser->getClassName());

		$command    = $this->factory->getCommand($className, $location);
		$parameters = $command->getParameters();

		$parser->fillParameters($parameters);

		try
		{
			$command->onExecute($parameters, $this->output);
		}
		catch(\Exception $e)
		{
			$class    = isset($this->config['psx_error_command']) ? $this->config['psx_error_command'] : 'PSX\Command\ErrorCommand';
			$location = new Location();
			$location->setParameter(Location::KEY_EXCEPTION, $e);

			$this->factory->getCommand($class, $location)->onExecute(new Parameters(), $this->output);
		}

		return $command;
	}
}
