<?php
/*
 * psx
 * A object oriented and modular based PHP framework for developing
 * dynamic web applications. For the current version and informations
 * visit <http://phpsx.org>
 *
 * Copyright (c) 2010-2014 Christoph Kappestein <k42b3.x@gmail.com>
 *
 * This file is part of psx. psx is free software: you can
 * redistribute it and/or modify it under the terms of the
 * GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or any later version.
 *
 * psx is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with psx. If not, see <http://www.gnu.org/licenses/>.
 */

namespace PSX\Data;

/**
 * RecordInfo
 *
 * @author  Christoph Kappestein <k42b3.x@gmail.com>
 * @license http://www.gnu.org/licenses/gpl.html GPLv3
 * @link    http://phpsx.org
 */
class RecordInfo
{
	protected $name;
	protected $fields;

	public function __construct($name, array $fields, RecordInfo $parent = null)
	{
		$this->name = $name;

		if($parent !== null)
		{
			$this->fields = array_merge($fields, $parent->getFields());
		}
		else
		{
			$this->fields = $fields;
		}
	}

	public function setName($name)
	{
		$this->name = $name;
	}

	public function getName()
	{
		return $this->name;
	}

	public function setFields($fields)
	{
		$this->fields = $fields;
	}

	public function getFields()
	{
		return $this->fields;
	}

	public function hasField($key)
	{
		return isset($this->fields[$key]);
	}

	public function hasFields(array $fields)
	{
		return count($this->getMissingFields($fields)) == 0;
	}

	public function getMissingFields(array $fields)
	{
		return array_diff(array_keys($this->fields), $fields);
	}

	/**
	 * Returns all fields wich are set
	 *
	 * @return array
	 */
	public function getData()
	{
		$data = array();

		foreach($this->fields as $key => $value)
		{
			if(isset($value))
			{
				$data[$key] = $value;
			}
		}

		return $data;
	}
}

