<?php
!defined('P_W') && exit('Forbidden');

/**
 * ƾڮwާ@
 * 
 * @package DB
 */
class BaseDB {
	/**
	 * ƾڮwsH
	 * 
	 * @var DB
	 */
	var $_db = null;
	/**
	 * @var primary ID
	 */
	var $_primaryKey = '';
	var $_tableName = '';
	
	/**
	 * cy
	 */
	function BaseDB() {
		if (!$GLOBALS['db']) PwNewDB();
		$this->_db = $GLOBALS['db'];
	}
	
	function _getConnection() {
		return $GLOBALS['db']; //global
	}
	
	/**
	 * cyssql
	 * 
	 * @see S::sqlSingle
	 * @access protected
	 * @param array $arr sƾڼƲ
	 * @return string
	 */
	function _getUpdateSqlString($arr) {
		return S::sqlSingle($arr);
	}
	
	/**
	 * dߵG
	 * 
	 * @access protected
	 * @param resource $query ƾڮwG귽
	 * @param string|null ƾڵGƲժkeyAnullhۼWkey
	 * @return array
	 */
	function _getAllResultFromQuery($query, $resultIndexKey = null) {
		$result = array();
		
		if ($resultIndexKey) {
			while ($rt = $this->_db->fetch_array($query)) {
				$result[$rt[$resultIndexKey]] = $rt;
			}
		} else {
			while ($rt = $this->_db->fetch_array($query)) {
				$result[] = $rt;
			}
		}
		return $result;
	}
	
	/**
	 * ˬdƲkeyO_Xkrq
	 * 
	 * @access protected
	 * @param array $fieldData ƾڼƲ
	 * @param array $allowFields \rq
	 * @return array Lo᪺ƾ
	 */
	function _checkAllowField($fieldData, $allowFields) {
		foreach ($fieldData as $key => $value) {
			if (!in_array($key, $allowFields)) {
				unset($fieldData[$key]);
			}
		}
		return $fieldData;
	}
	
	/**
	 * ϱקLo
	 * 
	 * @see S::sqlEscape
	 * @access protected
	 * @param mixed $var ƾ
	 * @return mixed Lo᪺ƾ
	 */
	function _addSlashes($var) {
		return S::sqlEscape($var);
	}
	
	/**
	 * implodeո˼Ʋլsql
	 * 
	 * @see S::sqlImplode
	 * @access protected
	 * @param $arr ƾڼƲ
	 * @param bool $strip O_gLstripslashesBz
	 */
	function _getImplodeString($arr, $strip = true) {
		return S::sqlImplode($arr, $strip);
	}
	
	/**
	 * ǦCƼƾ
	 * 
	 * @access protected
	 * @param mixed $value
	 * @return string
	 */
	function _serialize($value) {
		if (is_array($value)) {
			return serialize($value);
		}
		if (is_string($value) && is_array(unserialize($value))) {
			return $value;
		}
		return '';
	}
	
	/**
	 * ϧǦCƼƾ
	 * 
	 * @access protected
	 * @param string $value
	 * @return mixed
	 */
	function _unserialize($value) {
		if ($value && is_array($tmpValue = unserialize($value))) {
			$value = $tmpValue;
		}
		return $value;
	}
	/**
	 * ¦W[ƾڬd߻yy
	 * @param $fieldData
	 * @return unknown_type
	 */
	function _insert($fieldData) {
		if (!$this->_check() || !$fieldData) return false;
		//* $this->_db->update("INSERT INTO " . $this->_tableName . " SET " . $this->_getUpdateSqlString($fieldData));
		return pwQuery::insert($this->_tableName, $fieldData);
	}
	/**
	 * ¦sƾڬd߻yy
	 * @param $fieldData
	 * @param $id
	 * @return unknown_type
	 */
	function _update($fieldData, $id) {
		if (!$this->_check() || !$fieldData || $id < 1) return false;
		//* $this->_db->update("UPDATE " . $this->_tableName . " SET " . $this->_getUpdateSqlString($fieldData) . " WHERE " . $this->_primaryKey . "=" . $this->_addSlashes($id) . " LIMIT 1");
		return pwQuery::update($this->_tableName, "{$this->_primaryKey}=:{$this->_primaryKey}", array($id), $fieldData);
	}
	/**
	 * ¦R@ƾڬd߻yy
	 * @param $id
	 * @return unknown_type
	 */
	function _delete($id) {
		if (!$this->_check() || $id < 1) return false;
		//* $this->_db->update("DELETE FROM " . $this->_tableName . " WHERE " . $this->_primaryKey . "=" . $this->_addSlashes($id) . " LIMIT 1");
		return pwQuery::delete($this->_tableName, "{$this->_primaryKey}=:{$this->_primaryKey}", array($id));
	}
	/**
	 * ¦@ƾڬd߻yy
	 * @param $id
	 * @param $fields ^rqWAhӥ','j}A'*'
	 * @return unknown_type
	 */
	function _get($id, $fields = '*') {
		if (!$this->_check() || $id < 1) return false;
		return $this->_db->get_one("SELECT $fields FROM " . $this->_tableName . " WHERE " . $this->_primaryKey . "=" . $this->_addSlashes($id) . " LIMIT 1");
	}
	/**
	 * ¦έpƾڬd߻yy
	 * @return unknown_type
	 */
	function _count() {
		if (!$this->_check()) return false;
		$result = $this->_db->get_one("SELECT COUNT(*) as total FROM " . $this->_tableName);
		return $result['total'];
	}
	/**
	 * pˬdWٻPDO_wq
	 * @return unknown_type
	 */
	function _check() {
		return (!$this->_tableName || !$this->_primaryKey) ? false : true;
	}
	
	/**
	 * SQLdߤ,cyLIMITyy
	 *
	 * @param int $start }lOm
	 * @param int $num ŪOƥ
	 * @return string SQLyy
	 */
	function _Limit($start, $num = false){
		return S::sqlLimit($start, $num);
	}
}

