<?php
!defined('P_W') && exit('Forbidden');

/**
 * A
 *
 * @package Rate
 */
class PW_Rate {
	var $_cache = TRUE; //O_}Ҥws

	/**
	 * @ﶵ(tm)O
	 *
	 */
	function getRateConfig($typeId, $id) {
		$id = intval($id);
		if ($id < 1) {
			return null;
		}
		$rateConfigDb = $this->_getRateConfigDB();
		return ($this->_cache) ? $this->_get_RateConfigCache($typeId, $id) : $rateConfigDb->get($id);
	}
	/**
	 * W[@ﶵ(tm)O
	 *
	 */
	function addRateConfig($fieldData) {
		$fieldData = $this->_checkRateConfig($fieldData);
		if ($fieldData === FALSE) {
			return null;
		}
		$rateConfigDB = $this->_getRateConfigDB();
		$result = $rateConfigDB->add($fieldData);
		if ($this->_cache && $result) {
			$this->_set_RateConfigCache();
		}
		return $result;
	}
	function _checkRateConfig($fieldData) {
		$fieldData['title'] = trim($fieldData['title']);
		$fieldData['icon'] = trim($fieldData['icon']);
		$fieldData['isopen'] = intval($fieldData['isopen']); //O_}
		$fieldData['typeid'] = intval($fieldData['typeid']); //
		if ($fieldData['title'] == "" || $fieldData['icon'] == "" || !in_array($fieldData['typeid'], $this->_getRateType()) || !in_array($fieldData['isopen'], array(
			0,
			1
		))) {
			return FALSE;
		}
		$fieldData['creditset'] = intval($fieldData['creditset']); //o䪺
		$fieldData['voternum'] = intval($fieldData['voternum']); //̿n
		$fieldData['authornum'] = intval($fieldData['authornum']); //@̿n
		if ($fieldData['voternum'] > 10 || $fieldData['voternum'] < - 10 || $fieldData['authornum'] > 10 || $fieldData['authornum'] < - 10) {
			return FALSE;
		}
		$fieldData['creator'] = trim($fieldData['creator']);
		$fieldData['updater'] = trim($fieldData['updater']);
		$rateConfigDB = $this->_getRateConfigDB();
		if (!$this->_isAllowFields($fieldData, $rateConfigDB->getStruct())) {
			return FALSE;
		}
		$fieldData['created_at'] = $fieldData['update_at'] = time();
		return $fieldData;
	}
	function _isAllowFields($sourceFields, $allowFields) {
		foreach($sourceFields as $key => $value) {
			if (!in_array($key, $allowFields)) {
				return FALSE;
			}
		}
		return TRUE;
	}
	/**
	 * s@ﶵ(tm)O
	 *
	 */
	function updateRateConfig($fieldData, $id) {
		$id = intval($id);
		$rateConfigDB = $this->_getRateConfigDB();
		if ($id < 1 || !$this->_isAllowFields($fieldData, $rateConfigDB->getStruct())) {
			return null;
		}
		$result = $rateConfigDB->update($fieldData, $id);
		if ($this->_cache && $result) {
			$this->_set_RateConfigCache();
		}
		return $result;
	}
	/**
	 * R@ﶵ(tm)O
	 *
	 */
	function deleteRateConfig($id) {
		$id = intval($id);
		if ($id < 1) {
			return null;
		}
		$rateConfigDB = $this->_getRateConfigDB();
		$result = $rateConfigDB->delete($id);
		if ($this->_cache && $result) {
			$this->_set_RateConfigCache();
		}
		return $result;
	}
	/**
	 * (tm)ﶵO
	 *
	 */
	function getsRateConfigByTypeId($typeId) {
		$typeId = intval($typeId);
		if ($typeId < 1) {
			return null;
		}
		$rateConfigDB = $this->_getRateConfigDB();
		//@todo O_}Ҥws
		if (!$this->_cache || !$rateConfigs = $this->_get_RateConfigCache($typeId)) {
			$rateConfigs = $rateConfigDB->getsByTypeId($typeId);
		}
		if (!$rateConfigs) {
			return null;
		}
		$tmp = array();
		foreach($rateConfigs as $config) {
			$config['tips'] = $this->_buildTips($config);
			$tmp[] = $config;
		}
		return $tmp;
	}
	function _buildTips($config) {
		$creditNames = $this->getCreditDefaultMap();
		$creditName = $creditNames[$config['creditset']];
		$tips = array();
		$tips[] = "" . $creditName . $this->_setPrefix($config['voternum']);
		$tips[] = "@" . $creditName . $this->_setPrefix($config['authornum']);
		return implode("A", $tips);
	}
	function _setPrefix($value) {
		return ($value > 0) ? "+" . $value : $value;
	}
	/**
	 * W[@O
	 * [IAslog
	 *
	 */
	function addRate($userId, $objectId, $optionId, $typeId, $ip, $anonymity = FALSE) {
		//OO_wgsb ShsWA_hs
		//ˬdΤO_
		//@todo ˬdHĩ H@̪ID
		global $credit;
		if (!$authorId = $this->_checkObjectByTypeId($typeId, $objectId)) {
			return null;
		}
		//AˬdGOO_sb
		if (!$this->getRateResultByOptionId($optionId, $objectId)) {
			$fieldData = array(
				'objectid' => $objectId,
				'optionid' => $optionId,
				'typeid' => $typeId,
				'num' => 1
			);
			$this->addRateResult($fieldData);
		} else {
			$this->updateRateResultByOptionId($optionId, $objectId);
		}
		$fieldData = array(
			'objectid' => $objectId,
			'optionid' => $optionId,
			'typeid' => $typeId,
			'uid' => $userId,
			'created_at' => time(),
			'ip' => $ip
		);
		$fieldData = $this->_checkRate($fieldData, $anonymity);
		if ($fieldData === FALSE) {
			return null;
		}
		$rateDB = $this->_getRateDB();
		$rateDB->add($fieldData);
		// TODO W[οn
		//tmH O_Ūwsμƾڮw
		if (!$this->_cache || !$config = $this->_get_RateConfigCache($typeId, $optionId)) {
			$config = $this->getRateConfig($typeId, $optionId);
		}
		require_once S::escapePath(R_P . "require/credit.php");
		if ($config['creditset'] < 0) {
			$creditMap = array_flip($this->_getCreditMap());
			$cType = $creditMap[$config['creditset']];
		} else {
			$cType = $config['creditset'];
		}
		(!$anonymity) && $credit->set($userId, $cType, $config['voternum']);
		$credit->set($authorId, $cType, $config['authornum']);
		//]p@todo
		$this->_addRateForHot($objectId, $typeId, $optionId);
		return $this->_buildTips($config);
	}
	/*******************************\]*start*****************************************/
	/**
	 * YUﶵCApGwﶵIDhﶵaction
	 * ^lҡJarray("rateThread_1" => "̷P","rateThread_2" => "̰")
	 * ^ӹҡJarray("rateDiary_10" => "̷P","rateDiary_12" => "̰")
	 * ^ӤҡJarray("ratePicture_20" => "̷P","ratePicture_21" => "̰")
	 * 䤤KEY(pJrateThread_1)]appƾڪaction
	 * iո<select></select>
	 * @param int $typeId
	 * @param int $optionId
	 * @return array or string
	 */
	function _getRateTypesForHot($typeId, $optionId = FALSE) {
		$configs = $this->getsRateConfigByTypeId($typeId);
		$prefix = ($typeId == 1) ? "rateThread_" : (($typeId == 2) ? "rateDiary_" : "ratePicture_");
		$newConfigs = $actions = array();
		foreach($configs as $config) {
			$ratePrefix = $prefix . $config['id'];
			$actions[$config['id']] = $ratePrefix;
			$newConfigs[$ratePrefix] = $config['title'];
		}
		return ($optionId) ? $actions[$optionId] : $newConfigs;
	}
	function _addRateForHot($objectId, $typeId, $optionId) {
		$action = $this->_getRateTypesForHot($typeId, $optionId);
		require_once (R_P . 'require/functions.php');
		updateDatanalyse($objectId, $action, 1);
	}
	// l
	function getRateThreadHotTypes() {
		return $this->_getRateTypesForHot(1);
	}
	// 
	function getRateDiaryHotTypes() {
		return $this->_getRateTypesForHot(2);
	}
	// Ӥ
	function getRatePictureHotTypes() {
		return $this->_getRateTypesForHot(3);
	}
	/*******************************\]*end*****************************************/
	function _checkRate($fieldData, $anonymity) {
		$fieldData['objectid'] = intval($fieldData['objectid']);
		$fieldData['optionid'] = intval($fieldData['optionid']);
		$fieldData['typeid'] = intval($fieldData['typeid']);
		$fieldData['uid'] = intval($fieldData['uid']);
		if (!$anonymity && $fieldData['uid'] < 0) {
			return FALSE;
		}
		$rateDB = $this->_getRateDB();
		if ($fieldData['objectid'] < 0 || !in_array($fieldData['typeid'], $this->_getRateType()) || $fieldData['optionid'] < 0 || !$this->_isAllowFields($fieldData, $rateDB->getStruct())) {
			return FALSE;
		}
		$fieldData['created_at'] = time();
		return $fieldData;
	}
	/**
	 * ٹΤWO
	 *
	 */
	function getsRateByUserId($userId, $objectId, $typeId) {
		$userId = intval($userId);
		$objectId = intval($objectId);
		$typeId = intval($typeId);
		if ($typeId < 1 || $userId < 1 || $objectId < 1) {
			return null;
		}
		$rateDB = $this->_getRateDB();
		return $rateDB->getsByUserId($userId, $objectId, $typeId);
	}
	/**
	 * έpP
	 *
	 */
	function getRateByWeek($typeId) {
		$typeId = intval($typeId);
		if ($typeId < 1) {
			return null;
		}
		$rateDB = $this->_getRateDB();
		$RateResult = $rateDB->getFromTmpTableByWeek($typeId);
		//$RateResult = $this->_getRateDB ()->getByWeek ( $typeId );
		if (!$RateResult) {
			return null;
		}
		$tmp = array();
		foreach($RateResult as $result) {
			//ٹHIDHDM@
			$result['objectInfo'] = $this->_getObjectByTypeId($typeId, $result['objectid']);
			$tmp[$result['optionid']] = array_merge($result['objectInfo'], $result);
		}
		return $tmp;
	}
	/*************************ƾڳBzϰ start********************************/
	function _getObjectByTypeId($typeId, $objectId) {
		switch ($typeId) {
			case 1:
				return $this->_getThreadById($objectId);
				break;

			case 2:
				return $this->_getDiaryByById($objectId);
				break;

			case 3:
				return $this->_getPhotoById($objectId);
				break;

			default:
				return array();
		}
		return array();
	}
	function _getThreadById($tid) {
		$rateDB = $this->_getRateDB();
		$thread = $rateDB->_db->get_one("SELECT * FROM pw_threads WHERE tid={$tid}");
		if (!$thread) {
			return array();
		}
		$result = array();
		$result['title'] = $thread['subject'];
		$result['href'] = "/read.php?tid=" . $tid;
		$result['author'] = $thread['author'];
		$result['authorUrl'] = "/".USER_URL. $thread['authorid']; //authorid
		return $result;
	}
	function _getDiaryByById($did) {
		$rateDB = $this->_getRateDB();
		$diary = $rateDB->_db->get_one("SELECT * FROM pw_diary WHERE did={$did}");
		if (!$diary) {
			return array();
		}
		$result = array();
		$result['title'] = $diary['subject'];
		$result['href'] = "/apps.php?q=diary&u=" . $diary['uid'] . "&did=" . $did;
		$result['author'] = $diary['username'];
		$result['authorUrl'] = "/".USER_URL. $diary['uid']; //1
		return $result;
	}
	function _getPhotoById($pid) {
		$rateDB = $this->_getRateDB();
		$photo = $rateDB->_db->get_one("SELECT * FROM pw_cnphoto WHERE pid={$pid}");
		if (!$photo) {
			return array();
		}
		$album = $rateDB->_db->get_one("SELECT * FROM pw_cnalbum WHERE aid=" . $photo['aid']);
		$result = array();
		$result['title'] = (isset($photo['pintro']) && trim($photo['pintro']) != "") ? $photo['pintro'] : 'ȵLyz';
		//$result ['href'] = "/apps.php?q=photos&a=view&pid=" . $pid;
		$result['href'] = "/apps.php?q=photos&space=1&u=" . $album['ownerid'] . "&a=view&pid=" . $pid;
		$result['author'] = $photo['uploader'];
		$result['authorUrl'] = "/".USER_URL. $album['ownerid'];
		return $result;
	}
	function _checkObjectByTypeId($typeId, $objectId) {
		switch ($typeId) {
			case 1:
				return $this->_checkThreadById($objectId);
				break;

			case 2:
				return $this->_checkDiaryByById($objectId);
				break;

			case 3:
				return $this->_checkPhotoById($objectId);
				break;

			default:
				return FALSE;
		}
		return TRUE;
	}
	function _checkThreadById($tid) {
		$rateDB = $this->_getRateDB();
		$thread = $rateDB->_db->get_one("SELECT * FROM pw_threads WHERE tid={$tid}");
		if (!$thread || !isset($thread['authorid'])) {
			return FALSE;
		}
		return $thread['authorid'];
	}
	function _checkDiaryByById($did) {
		$rateDB = $this->_getRateDB();
		$diary = $rateDB->_db->get_one("SELECT * FROM pw_diary WHERE did={$did}");
		if (!$diary || !isset($diary['uid'])) {
			return FALSE;
		}
		return $diary['uid'];
	}
	function _checkPhotoById($pid) {
		$rateDB = $this->_getRateDB();
		$photo = $rateDB->_db->get_one("SELECT * FROM pw_cnphoto WHERE pid={$pid}");
		if (!$photo) {
			return FALSE;
		}
		$album = $rateDB->_db->get_one("SELECT * FROM pw_cnalbum WHERE aid=" . $photo['aid']);
		if (!$album || !isset($album['ownerid'])) {
			return FALSE;
		}
		return $album['ownerid'];
	}
	function addConfigPower($powerData, $groupData) {
		setConfig('db_ratepower', serialize($powerData));
		setConfig('db_rategroup', serialize($groupData));
		updatecache_c();
	}
	function getUserGroupLevel() {
		$rateDB = $this->_getRateDB();
		$query = $rateDB->_db->query("SELECT gid,gptype,grouptitle,groupimg,grouppost FROM pw_usergroups ORDER BY grouppost,gid");
		$userGroups = $rateDB->_getAllResultFromQuery($query);
		$tmp = array();
		foreach($userGroups as $group) {
			if ($group['gptype'] == 'default' && $group['gid'] != 2) {
				continue;
			}
			if ($group['gptype'] == 'system' && $group['gid'] == 3) {
				continue;
			}
			$group['defaultTimes'] = ($group['gptype'] == 'member' && $group['gid'] == 8) ? 5 : 20;
			$tmp[$group['gptype']][] = $group;
		}
		//Ƨ
		$groups = array();
		$groups['member'] = $tmp['member'];
		$groups['system'] = $tmp['system'];
		$groups['special'] = $tmp['special'];
		$groups['default'] = $tmp['default'];
		return $groups;
	}
	function _getBaseDB() {
		require_once S::escapePath(dirname(__FILE__) . "/base/basedb.php");
		return new BaseDB();
	}
	/*************************ƾڳBzϰ end********************************/
	/**
	 * W[@GO
	 *
	 */
	function addRateResult($fieldData) {
		$fieldData = $this->_checkRateResult($fieldData);
		if ($fieldData === FALSE) {
			return null;
		}
		$rateResultDB = $this->_getRateResultDB();
		return $rateResultDB->add($fieldData);
	}
	function _checkRateResult($fieldData) {
		$fieldData['objectid'] = intval($fieldData['objectid']);
		$fieldData['optionid'] = intval($fieldData['optionid']);
		$fieldData['typeid'] = intval($fieldData['typeid']);
		if ($fieldData['objectid'] < 1 || $fieldData['optionid'] < 1 || !in_array($fieldData['typeid'], $this->_getRateType())) {
			return FALSE;
		}
		$fieldData['num'] = 1;
		return $fieldData;
	}
	function _getRateType() {
		return array(
			1,
			2,
			3
		);
	}
	/**
	 * ٹHIDMﶵIDO
	 *
	 */
	function getRateResultByOptionId($optionId, $objectId) {
		$objectId = intval($objectId);
		$optionId = intval($optionId);
		if ($optionId < 1 || $objectId < 1) {
			return null;
		}
		$rateResultDB = $this->_getRateResultDB();
		return $rateResultDB->getByOptionId($optionId, $objectId);
	}
	/**
	 * ٹHIDMﶵIDsO
	 *
	 */
	function updateRateResultByOptionId($optionId, $objectId) {
		$objectId = intval($objectId);
		$optionId = intval($optionId);
		if ($optionId < 1 || $objectId < 1) {
			return null;
		}
		$rateResultDB = $this->_getRateResultDB();
		return $rateResultDB->updateByOptionId($optionId, $objectId);
	}
	/**
	 * ٹIDMﶵIDO
	 *
	 */
	function getRateResultByTypeId($typeId, $objectId) {
		$typeId = intval($typeId);
		$objectId = intval($objectId);
		if ($typeId < 1 || $objectId < 1) {
			return null;
		}
		$tmp = array();
		$total = 0; //H
		$rateResultDB = $this->_getRateResultDB();
		$rateResults = $rateResultDB->getByTypeId($typeId, $objectId);
		if (!$rateResults) {
			return array(
				$tmp,
				$total
			);
		}
		foreach($rateResults as $result) {
			$total += $result['num'];
			$tmp[$result['optionid']] = $result;
		}
		return array(
			$tmp,
			$total
		);
	}
	/**
	 * n]m
	 * DnOCӿnﶵ]m@Ӱߤ@keyAΤ_ƾڦsx
	 * tq{tơA۩wqߤ@D
	 * PɴYSwkeyW
	 * @return unknown
	 */
	function getCreditDefaultMap($creditKey = null) {
		$map = $this->_getCreditMap();
		$creditNames = pwCreditNames();
		$tmp = array();
		foreach($creditNames as $key => $value) {
			if (in_array($key, array_keys($map))) {
				$tmp[$map[$key]] = $value;
				continue;
			}
			$tmp[$key] = $value;
		}
		return (array_key_exists($creditKey, $tmp)) ? $tmp[$creditKey] : $tmp;
	}
	function _getCreditMap() {
		return array(
			"money" => "-1",
			"rvrc" => "-2",
			"credit" => "-3",
			"currency" => "-4"
		);
	}
	/************************************wsϰstart***********************************************/
	function _set_RateConfigCache() {
		$rateConfigDB = $this->_getRateConfigDB();
		$configs = $rateConfigDB->gets();
		if (!$configs) {
			return null;
		}
		$tmp = array();
		foreach($configs as $config) {
			$tmp[$config['typeid']][] = $config;
		}
		//gJws
		$result = serialize($tmp);
		pwCache::setData($this->_getReteConfigFilePath(), $result, false, 'w');
		return $result;
	}
	// pGwh^ƾ
	function _get_RateConfigCache($typeId = FALSE, $optionId = FALSE) {
		if (!file_exists($this->_getReteConfigFilePath()) || !$result = readover($this->_getReteConfigFilePath())) {
			$result = $this->_set_RateConfigCache();
		}
		$rateConfigs = unserialize($result);
		if (!$rateConfigs) {
			return FALSE;
		}
		//SwYӤUSwӰtm
		if ($optionId && $typeId && isset($rateConfigs[$typeId])) {
			foreach($rateConfigs[$typeId] as $config) {
				if ($config['id'] == $optionId) {
					return $config;
				}
			}
		}
		//uYtm
		if (isset($rateConfigs[$typeId]) && in_array($typeId, $this->_getRateType())) {
			return $rateConfigs[$typeId];
		}
		return $rateConfigs;
	}
	function _getReteConfigFilePath() {
		return D_P . 'data/bbscache/rate_config.php';
	}
	/***********************************************************************************/
	function countByUserId($userId) {
		if (intval($userId) < 1) {
			return -1;
		}
		$rateDB = $this->_getRateDB();
		return $rateDB->countByUserId($userId);
	}
	function countByIp($ip) {
		if ($ip == "") {
			return -1;
		}
		$rateDB = $this->_getRateDB();
		return $rateDB->countByIp($ip);
	}
	function getsByIp($ip, $objectId, $typeId) {
		$rateDB = $this->_getRateDB();
		return $rateDB->getsByIp($ip, $objectId, $typeId);
	}
	/**********************************************************/
	function getWeekData($typeId, $hotSource = true) {
		if ($hotSource) {
			return $this->getWeekResultHtmlFromHot($typeId);
		}
		return $this->getRateByWeek($typeId);
	}
	function getWeekResultHtmlFromHot($typeId) {
		$datanalyse = $this->_getDatanalyseService();
		$result = $datanalyse->getDatanalyseForRateByType($typeId);
		if (!$result) {
			return '';
		}
		$tmp = array();
		foreach($result as $objectId => $object) {
			$info = array();
			$info['title'] = $object['title'];
			$info['href'] = "/" . $object['url'];
			$info['author'] = $object['author'];
			$info['authorUrl'] = "/u.php?username=" . $object['author'];
			$optionId = substr($object['action'], strrpos($object['action'], "_") + 1);
			$info['objectid'] = $objectId;
			$info['optionid'] = $optionId;
			$info['typeid'] = $typeId;
			$tmp[$optionId]['objectInfo'] = $info;
		}
		return $tmp;
	}
	function _getDatanalyseService() {
		L::loadClass('datanalyse','datanalyse',false);
		return new Datanalyse();
	}
	/***********************************************************/
	function _getRateConfigDB() {
		return L::loadDB('RateConfig', 'rate');
	}
	function _getRateDB() {
		return L::loadDB('Rate', 'rate');
	}
	function _getRateResultDB() {
		return L::loadDB('RateResult', 'rate');
	}
}
?>
