<?php
!defined('P_W') && exit('Forbidden');
/**
 * @rqˬd
 * @author zuojie
 *
 */
class FieldCheck {
	/**
	 * @var mix ~ƾڭ
	 * @access protected
	 */
	var $errorValue;

	/**
	 * o~ƾڭ
	 * @return mix ~ƾڭ
	 * @access public
	 */
	function getErrorValue() {
		return $this->errorValue;
	}
	/**
	 * ]m~ƾڭ
	 * @param mix $value 
	 * @return FieldCheck this
	 * @access public
	 */
	function setErrorValue($value) {
		$this->errorValue = $value;
		return $this;
	}
	/**
	 * q{rq~H
	 * @param string $fieldType rq
	 * @param mix $data rq
	 * @param mix $rules Wh
	 */
	function getError($fieldType, $data, $rules = NULL) {
		$errorKey = false;
		switch ($fieldType) {
			case 'number' : 
				$errorKey = $this->getNumberError($data, $rules['minnum'], $rules['maxnum']);
				break;
			case 'text' :
			case 'textarea' :
				break;
			case 'radio' : //radioMselectϥΦP@Ҥk
			case 'select' :
				$errorKey = $this->getSelectionError($data);
				break;
			case 'checkbox' :
				$errorKey = $this->getCheckboxError($data);
				break;
			case 'calendar' :
				$errorKey = $this->getCalendarError($data);
				break;
			case 'email' : 
				$errorKey = $this->getEmailError($data);
				break;
			case 'url' : 
			case 'img' : 
				break;
			case 'upload' :
				break;
			case 'range' : 
				$errorKey = $this->getRangeError($data);
				break;
			default :
				break;
		}
		return $errorKey;
	}
	/**
	 * ˬdaȽd򪺼ƭȦrq
	 * @param float $value ƭ
	 * @param float $min \̤p
	 * @param float $max \̤j
	 * @return string|bool J^~keyA_h^false
	 */
	function getRangeError($value, $min = '', $max = '') {
		$errorKey = $this->getNumberError($value);
		if ($errorKey) {
			return $errorKey;
		} elseif (is_numeric($min) && is_numeric($max) && ($value < $min || $value > $max)) {
			$this->setErrorValue($value);
			return 'act_number_limit';
		} else {
			return false;
		}
	}
	/**
	 * ˬdƭȦrq
	 * @param float $value ƭ
	 * @return string|bool J^~keyA_h^false
	 */
	function getNumberError($value) {
		if (!is_numeric($value) && $value) {
			return 'act_number_error';
		} else {
			return false;
		}
	}
	/**
	 * ˬdemailrq
	 * @param string $email emaila}
	 * @return string|bool J^~keyA_h^false
	 */
	function getEmailError($email) {
		if (!preg_match('/^[-a-zA-Z0-9_\.]+@([0-9A-Za-z][0-9A-Za-z-]+\.)+[A-Za-z]{2,5}$/', $email)) {
			$this->setErrorValue($email);
			return 'illegal_email';
		} else {
			return false;
		}
	}
	/**
	 * ˬdﶵ]radio, checkbox, select^
	 * @param int $value 
	 * @return string|bool J^~keyA_h^false
	 */
	function getSelectionError($value) {
		if (!is_numeric($value) || $value != (int)$value) { //ƭ
			return 'selection_not_int';
			$this->setErrorValue($value);
		} else {
			return false;
		}
	}
	/**
	 * ˬdcheckboxҦ
	 * @param array $values checkbox
	 * @return string|bool J^~keyA_h^false
	 */
	function getCheckboxError($values) {
		if (!is_array($values)) {
			return 'checkbox_not_array';
		} else {
			foreach ($values as $value) {
				$errorKey = $this->getSelectionError($value);
				if ($errorKey) {
					return $errorKey;
				}
			}
			return false;
		}
	}
	/**
	 * ˬdɶrq
	 * @param string $string ɶršAp'2010-4-9 13:00:00'
	 * @return string|bool J^~keyA_h^false
	 */
	function getCalendarError ($string) {
		if ($string) {
			$time = strtotime($string);
			if (!$time || -1 == $time) { //strtotime()bPHP 5.1.0HeѮɪ^-1
				$this->setErrorValue($string);
				return 'calendar_wrong_format';
			} else {
				return false;
			}
		}
	}
	/**
	 * ͦrqOs_ƾڮw
	 * @param string $fieldType rq
	 * @param mix $data 
	 * @return string Os_ƾڮw
	 */
	function getValueForDb($fieldType, $data) {
		$returnValue = $data;
		switch ($fieldType) {
			case 'number' : 
			case 'range' : 
				break;
			case 'text' :
			case 'textarea' :
				break;
			case 'radio' : //radioMselectϥΦP@k
			case 'select' :
				$returnValue = (int)$data;
				break;
			case 'checkbox' :
				$returnValue = '';
				foreach ($data as $selection) {
					$returnValue .= (int)$selection.',';
				}
				break;
			case 'calendar' :
				$returnValue = PwStrtoTime($data);
				break;
			case 'email' : 
			case 'url' : 
			case 'img' : 
			case 'upload' :
			default :
				break;
		}
		return $returnValue;
	}
}