<?php
!defined('P_W') && exit('Forbidden');
L::loadClass('fieldcheck', '', false);
/**
 * ʬSrqˬd
 * @author zuojie
 *
 */
class PW_ActivityFieldCheck extends Fieldcheck {
	/**
	 * @var array ~HƲ
	 * @access protected
	 */
	var $errorMessage;
	var $feesArray;
	var $feesDetailArray;
	var $telephones;

	/**
	 * ھڿ~key~
	 * @param string $key ~HN١]^^
	 * @access public
	 * @return string human-readable~H]^
	 */
	function getErrorMessageByKey($key) {
		global $db_actname;
		$db_actname = $this->getErrorValue();
		$errorMessage = $this->getErrorMessage();
		if ($errorMessage[$key] && is_string($errorMessage[$key])) {
			$keyErrorMessage = str_replace('{value}', $db_actname, $errorMessage[$key]);
			return $keyErrorMessage;
		} elseif ($key) {
			return 'unknown error';
		} else {
			return '';
		}
	}
	/**
	 * Ҧ~
	 * @access public
	 * @return array ~
	 */
	function getErrorMessage() {
		if (!$this->errorMessage) {
			$this->_presetErrorMessage();
		}
		return $this->errorMessage;
	}
	/**
	 * ]m$errorMessagel
	 * @param array $errorMessage
	 * @access protected
	 * @return bool|FieldCheck J^false
	 */
	function _presetErrorMessage() {
		require_once S::escapePath(GetLang('fielderror'));
		$errorMessage = $lang['fielderror'];
		if ($errorMessage) {
			$this->_setErrorMessage($errorMessage);
			return $this;
		} else {
			return false;
		}
	}
	/**
	 * ]m$errorMessage
	 * @param array $errorMessage
	 * @access protected
	 * @return bool|FieldCheck J^false
	 */
	function _setErrorMessage($errorMessage) {
		if (!is_array($errorMessage)) {
			return false;
		} else {
			$this->errorMessage = $errorMessage;
			return $this;
		}
	}
	/**
	 * }lɶO__ɶ
	 * @param string $start }lɶAp'2010-04-09 11:00:00'
	 * @param string $end ɶAp'2010-04-09 12:00:00'
	 * @access protected
	 * @return bool ɶO_
	 */
	function _isValidStartAndEndTime ($start, $end) {
		if ($this->getCalendarError($start) || $this->getCalendarError($end)) {
			return false;
		} else {
			$startTimestamp = PwStrtoTime($start);
			$endTimestamp = PwStrtoTime($end);
			if ($startTimestamp > $endTimestamp) {
				return false;
			} else {
				return true;
			}
		}
	}
	/**
	 * ˬd}lMɶ
	 * @param string $start }lɶAp'2010-04-09 11:00:00'
	 * @param string $end ɶAp'2010-04-09 12:00:00'
	 * @return string|bool J^~keyA_h^false
	 */
	function getTimeRangeError($start, $end) {
		if (!$this->_isValidStartAndEndTime($start, $end)) {
			return 'start_time_later_than_end_time';
		} else {
			return false;
		}
	}
	/**
	 * ˬdWɶMʶ}lɶO_R
	 * @param string $signupEnd WɶA'2010-04-09 11:00:00'
	 * @param string $activityStart ʶ}lɶAp'2010-04-09 12:00:00'
	 * @return string|bool J^~keyA_h^false
	 */
	function getActivityAndSignupTimeConflictError($signupEnd, $activityStart) {
		if (!$this->_isValidStartAndEndTime($signupEnd, $activityStart)) {
			return 'signup_end_time_later_than_activity_start_time';
		} else {
			return false;
		}
	}
	/**
	 * O_Ī
	 * @param float ơAp1.53
	 * @access protected
	 * @return bool O_
	 */
	function _isValidMoney($money) {
		if (!is_numeric($money) || 0 >= $money) {
			return false;
		} else {
			return true;
		}
	}
	/**
	 * ˬd
	 * @param float $money
	 * @return string|bool J^~keyA_h^false
	 */
	function getMoneyError($money) {
		if (!$this->_isValidMoney($money) && $money) {
			return 'invalid_money';
		} else {
			return false;
		}
	}
	function getLocationError($locations) {
		
	}
	function getContactError($contacts) {
		
	}
	/**
	 * ^rŦΡA]rAuš^,]br^Ϋ᪺Ʋ
	 * @param string $string rŦ
	 * @access protected
	 * @return array Ʋ
	 */
	function _getExplodedArrayFromString($string) {
		if (strpos($string, 'A') !== false) {
			$delimiter = 'A';
		} else {
			$delimiter = ',';
		}
		$array = explode($delimiter, $string);
		foreach ($array as $key => $element) {
			$array[$key] = trim($element);
			if (!$array[$key]) {
				unset($array[$key]);
			}
		}
		return $array;
	}
	/**
	 * ^Ʋե,]br^Ϋ᪺rŦ
	 * @param array $array Ʋ
	 * @access protected
	 * @return string rŦ
	 */
	function _getImplodedStringFromArray($array) {
		return implode(',', $array);
	}
	/**
	 * ˬdO_ĪqܸX
	 * @param string $telephone qܸXA\榡13123456789, +8613123456789, 0571-12345678, (0571)12345678A0578-12345678p123]pᬰ^
	 * @access protected
	 * @return bool O_
	 */
	function _isValidTelephoneNumber($telephone) {
		if (preg_match('/^[0-9p\(\)\-\+]+$/i', $telephone)) {
			return true;
		} else {
			return false;
		}
	}
	/**
	 * ˬdptqܦrq
	 * @param string $telephones qܸXAhӸX',']r^ΡAp'0571-12345678,13123456789'
	 * @return string|bool J^~keyA_h^false
	 */
	function getTelephoneError($telephones) {
		$telephoneArray = $this->_getExplodedArrayFromString($telephones);
		foreach ($telephoneArray as $element) {
			if (!$this->_isValidTelephoneNumber($element)) {
				$this->setErrorValue($element);
				return 'invalid_telephone_format';
			}
		}
		$this->telephones = $this->_getImplodedStringFromArray($telephoneArray);
		return false;
	}
	function getTelephones () {
		return $this->telephones;
	}
	/**
	 * @param int $payMethod I覡
	 * @param int|string $min ̤pH
	 * @param int|string $max ̤jH
	 * @param int $peopleAlreadySignup wWH
	 */
	function getParticipantError($payMethod, $min = '', $max = '', $peopleAlreadySignup = 0) {
		//1=I_A2={
		$errorKey = $this->getPayMethodError($payMethod);
		if ($errorKey) {
			return $errorKey;
		}
		$payMethodIsAlipay = $payMethod == 1 ? true : false;
		foreach (array($min, $max) as $value) {
			if ($value && (!is_numeric($value) || $value != (int)$value || $value < 0)) { //ȥBOj_0
				return 'invalid_participant_number';
			}
		}
		if ($max && $min > $max) {
			return 'minimum_larger_than_maximum';
		} elseif ($peopleAlreadySignup && $max < $peopleAlreadySignup) {
			return 'max_less_than_people_already_signup';
		} else {
			return false;
		}
	}
	function getUserLimitError($onlyFriend, $specificLimit) {
		
	}
	function getGenderLimitError($gender) {
		
	}
	function getFeesError($fees) {
		$feesArray = array();
		if (!is_array($fees)) {
			return 'invalid_fees_format';
		} else {
			foreach ($fees['condition'] as $key => $value) {
				if ($value && $fees['money'][$key]) {
					$feesArray[$key]['condition'] = $value;
					$errorKey = $this->getMoneyError($fees['money'][$key]);
					if ($errorKey) {
						$this->setErrorValue($fees['money'][$key]);
						return $errorKey;
					} else {
						$feesArray[$key]['money'] = $fees['money'][$key];
					}
				}
			}
			
			$this->feesArray = $feesArray;
			return false;
		}
	}
	function getFeesArray () {
		return $this->feesArray;
	}
	function getFeesDetailError($feesDetail) {
		$feesDetailArray = array();
		if (!is_array($feesDetail)) {
			return 'invalid_fees_detail_format';
		} else {
			foreach ($feesDetail['item'] as $key => $value) {
				if ($feesDetail['money'][$key] && $value) {
					$feesDetailArray[$key]['item'] = $value;
					$errorKey = $this->getMoneyError($feesDetail['money'][$key]);
					if ($errorKey) {
						$this->setErrorValue($feesDetail['money'][$key]);
						return $errorKey;
					} else {
						$feesDetailArray[$key]['money'] = $feesDetail['money'][$key];
					}
				}
			}
			$this->feesDetailArray = $feesDetailArray;
			return false;
		}
	}
	function getFeesDetailArray() {
		return $this->feesDetailArray;
	}
	function getPayMethodError($payMethod) {
		if ($payMethod != 1 && $payMethod != 2) {
			return 'invalid_pay_method';
		} else {
			return false;
		}
	}
}
