<?php 
/**
#	Project: PHPDISK File Storage Solution
#	This is NOT a freeware, use is subject to license terms.
#
#	Site: http://www.phpdisk.com
#
#	$Id: topic.php 2 2011-05-27 02:59:23Z along $
#
#	Copyright (C) 2008-2011 PHPDisk Team. All Rights Reserved.
#
*/

include "includes/commons.inc.php";

$in_front = true;

lang('topic');
$arr = array('new_topic','edit_topic','choose_best','del_topic');
if(in_array($action,$arr)){
	phpdisk_core::user_login();
}
switch($action){
	case 'new_topic':
		include PHPDISK_ROOT.'includes/header.inc.php';
		if($task =='new_topic'){
			form_auth(gpc('formhash','P',''),formhash());

			$userid = (int)gpc('userid','P',0);
			$subject = trim(gpc('subject','P',''));
			$content = trim(gpc('content','P',''));
			$reward_credit = (int)gpc('reward_credit','P',0);

			$rs = $db->fetch_one_array("select credit from {$tpf}users where userid='$pd_uid' limit 1");
			if($rs['credit']<$reward_credit){
				$error = true;
				$sysmsg[] = $L['credit_error'];
			}
			unset($rs);

			if(checklength($subject,2,150)){
				$error = true;
				$sysmsg[] = $L['subject_error'];
			}else{
				$subject = $db->escape(replace_js($subject));
			}
			if(checklength($content,2,1000)){
				$error = true;
				$sysmsg[] = $L['content_error'];
			}else{
				$content = addslashes(replace_js(str_replace(LF,'<br>',$content)));
			}
			if(!$error){
				$ins = array(
				'userid' => $pd_uid,
				'subject' => $subject,
				'content' => $content,
				'credit' => $reward_credit,
				'in_time' => $timestamp,
				'ip' => $onlineip,
				);
				$db->query("insert into {$tpf}topics set ".$db->sql_array($ins).";");
				$db->query_unbuffered("update {$tpf}users set credit=credit-$reward_credit where userid='$pd_uid'");
				$sysmsg[] = $L['add_reward_success'];
				redirect(urr("topic",""),$sysmsg);
			}else{
				redirect('back',$sysmsg);
			}

		}else{
			$rs = $db->fetch_one_array("select credit from {$tpf}users where userid='$pd_uid' limit 1");
			$credit = $rs['credit'];
			unset($rs);
			require_once template_echo('pd_topic',$user_tpl_dir);
		}
		break;

	case 'edit_topic':
		include PHPDISK_ROOT."./includes/header.inc.php";
		$tid = (int)gpc('tid','GP',0);

		if($task =='edit_topic'){
			form_auth(gpc('formhash','P',''),formhash());

			$userid = (int)gpc('userid','P',0);
			$subject = trim(gpc('subject','P',''));
			$content = trim(gpc('content','P',''));
			$reward_credit = (int)gpc('reward_credit','P',0);

			$rs = $db->fetch_one_array("select credit from {$tpf}users where userid='$pd_uid' limit 1");
			if($rs['credit']<$reward_credit){
				$error = true;
				$sysmsg[] = $L['credit_error'];
			}
			unset($rs);

			if(checklength($subject,2,150)){
				$error = true;
				$sysmsg[] = $L['subject_error'];
			}else{
				$subject = $db->escape(replace_js($subject));
			}
			if(checklength($content,2,1000)){
				$error = true;
				$sysmsg[] = $L['content_error'];
			}else{
				$content = addslashes(replace_js(str_replace(LF,'<br>',$content)));
			}
			if(!$error){
				$ins = array(
				'userid' => $pd_uid,
				'subject' => $subject,
				'content' => $content,
				'credit' => $reward_credit,
				'ip' => $onlineip,
				);
				$db->query("update {$tpf}topics set ".$db->sql_array($ins)." where tid='$tid';");
				$sysmsg[] = $L['edit_reward_success'];
				redirect(urr("topic","action=view_topic&tid=$tid"),$sysmsg);
			}else{
				redirect('back',$sysmsg);
			}

		}else{
			$topic = $db->fetch_one_array("select t.*,u.credit as u_credit from {$tpf}topics t,{$tpf}users u where tid='$tid' and t.userid=u.userid");
			$credit = $topic['u_credit'];
			$topic['content'] = str_replace('<br>',LF,$topic['content']);
			require_once template_echo('pd_topic',$user_tpl_dir);
		}

		break;

	case 'choose_best':
		include PHPDISK_ROOT."./includes/header.inc.php";

		$id = (int)gpc('id','G',0);
		$db->query_unbuffered("update {$tpf}replys set is_best=1 where rpid='$id'");
		$db->query_unbuffered("update {$tpf}topics set is_closed=1 where tid=(select tid from {$tpf}replys where rpid='$id') and userid='$pd_uid'");
		$db->query_unbuffered("update {$tpf}users set credit=credit+(select credit from {$tpf}topics where tid=(select tid from {$tpf}replys where rpid='$id')) where userid='$pd_uid'");
		$rs = $db->fetch_one_array("select tid from {$tpf}replys where rpid='$id'");
		redirect(urr("topic","action=view_topic&tid={$rs['tid']}"),'',0);
		break;

	case 'view_topic':
		if($task =='reply'){
			include PHPDISK_ROOT."./includes/header.inc.php";
			form_auth(gpc('formhash','P',''),formhash());

			$tid = (int)gpc('tid','P',0);
			$content = trim(gpc('content','P',''));

			if(checklength($content,6,3000)){
				$error = true;
				$sysmsg[] = $L['reply_error'];
			}else{
				$content = str_replace(LF,'<br>',$content);
			}

			if(!$error){
				$ins = array(
				'tid' => $tid,
				'userid' => $pd_uid,
				'content' => addslashes(replace_js($content)),
				'in_time' => $timestamp,
				'ip' => $onlineip,
				);
				$db->query("insert into {$tpf}replys set ".$db->sql_array($ins).";");
				$sysmsg[] = $L['reply_success'];
				redirect(urr("topic","action=view_topic&tid=$tid"),$sysmsg);
			}else{
				redirect('back',$sysmsg);
			}

		}else{
			$tid = (int)gpc('tid','G',0);
			$topic = $db->fetch_one_array("select t.*,u.username from {$tpf}topics t,{$tpf}users u where tid='$tid' and t.userid=u.userid");
			$topic['credit'] = $topic['credit'] ? '<img src="images/credit_icon.gif" align="absmiddle" border="0" /><span class="txtred">'.$topic['credit'].'</span>' : '';
			$topic['status'] = $topic['is_closed'] ? '<span class="txtgray" style="font-size:12px;">'.$L['topic_close'].'</span>' : '';
			$topic['a_space'] = urr("space","username=".rawurlencode($topic['username']));
			$topic['a_edittopic'] = urr("topic","action=edit_topic&tid=$tid");
			$topic['a_deltopic'] = urr("topic","action=del_topic&tid=$tid");
			function list_reply($tid){
				global $db,$tpf;
				$q = $db->query("select r.*,u.username from {$tpf}replys r,{$tpf}users u where tid='$tid' and r.userid=u.userid order by is_best desc, rpid asc");
				$reply_arr = array();
				while($rs = $db->fetch_array($q)){
					$rs['a_space'] = urr("space","username=".rawurlencode($rs['username']));
					$rs['in_time'] = custom_time("Y-m-d H:i",$rs['in_time']);
					$rs['reply_class'] = $rs['is_best'] ? 'reply_item_ok' : 'reply_item';
					$rs['a_choose_best'] = urr("topic","action=choose_best&id={$rs['rpid']}");
					$reply_arr[] = $rs;
				}
				$db->free($q);
				unset($rs);
				return $reply_arr;
			}
			$reply_arr = super_cache('topic','list_reply|'.$tid,1,0,'topic|'.$tid,$settings['cache_time']);

			$title = $topic['subject'].' - '.$L[$action];

			include PHPDISK_ROOT."./includes/header.inc.php";
			require_once template_echo('pd_topic',$user_tpl_dir);
		}
		break;

	case 'del_topic':

		$tid = (int)gpc('tid','G',0);
		$db->query_unbuffered("delete from {$tpf}replys where tid='$tid'");
		$db->query_unbuffered("delete from {$tpf}topics where tid='$tid'");
		redirect(urr("topic",""),'',0);
		break;

	default:
		$title = $L['topic_default'];
		include PHPDISK_ROOT."./includes/header.inc.php";
		$perpage = 30;
		$sql_do = "{$tpf}topics t,{$tpf}users u where t.userid=u.userid ";
		$rs = $db->fetch_one_array("select count(*) as total_num from {$sql_do}");
		$total_num = $rs['total_num'];
		$start_num = ($pg-1) * $perpage;
		function list_topic(){
			global $db,$tpf,$sql_do,$start_num,$perpage;
			$q = $db->query("select t.*,u.username from {$sql_do} order by tid desc limit $start_num,$perpage");
			$topic_arr = array();
			while($rs = $db->fetch_array($q)){
				$rs2 = $db->fetch_one_array("select count(*) as total from {$tpf}replys where tid='{$rs['tid']}'");
				$rs['reply_num'] = $rs2['total'];
				$rs['a_space'] = urr("space","username=".rawurlencode($rs['username']));
				$rs['a_viewtopic'] = urr("topic","action=view_topic&tid={$rs['tid']}");
				$rs['topic_subject'] = cutstr($rs['subject'],45);
				$rs['topic_status'] = $rs['is_closed'] ? '<span class="txtgray">'.$L['topic_close'].'</span>' : '<span class="txtgreen">'.$L['topic_open'].'</span>';
				$rs['topic_time'] = custom_time("Y-m-d H:i",$rs['in_time']);
				$rs['credit'] = $rs['credit'] ? '<img src="images/credit_icon.gif" align="absmiddle" border="0" /><span class="txtred">'.$rs['credit'].'</span>' : '';
				$topic_arr[] = $rs;
			}
			$db->free($q);
			unset($rs,$rs2);
			return $topic_arr;
		}
		$topic_arr = super_cache('topic','list_topic_'.$pg.'<list_topic',1,0,0,$settings['cache_time']);
		$page_nav = multi($total_num, $perpage, $pg, urr("topic",""));

		require_once template_echo('pd_topic',$user_tpl_dir);
}

include PHPDISK_ROOT.'includes/footer.inc.php';

?>
