<?php 
/**
#	Project: PHPDISK File Storage Solution
#	This is NOT a freeware, use is subject to license terms.
#
#	Site: http://www.phpdisk.com
#
#	$Id: admin.inc.php 5 2011-05-28 07:13:31Z along $
#
#	Copyright (C) 2008-2011 PHPDisk Team. All Rights Reserved.
#
*/

if(!defined('IN_PHPDISK') || !defined('IN_ADMINCP')) {
	exit('[PHPDisk] Access Denied');
}
phpdisk_core::admin_login();

lang($app,$app);

switch($action){
	case 'add_client':

		if($task =='add_client'){
			form_auth(gpc('formhash','P',''),formhash());

			$server_name = trim(gpc('server_name','P',''));
			$server_key = trim(gpc('server_key','P',''));
			$server_store_path = trim(gpc('server_store_path','P',''));
			$ftp_host = trim(gpc('ftp_host','P',''));
			$ftp_port = (int)gpc('ftp_port','P','');
			$ftp_user = trim(gpc('ftp_user','P',''));
			$ftp_pass = trim(gpc('ftp_pass','P',''));
			$ftp_ssl = (int)gpc('ftp_ssl','P',0);
			$ftp_pasv = (int)gpc('ftp_pasv','P',0);

			if($settings['online_demo']){
				$error = true;
				$sysmsg[] = $L['online_demo_deny'];
			}
			if(checklength($server_name,2,100)){
				$error = true;
				$sysmsg[] = $L['server_name_error'];
			}
			if(!$server_key){
				$error = true;
				$sysmsg[] = $L['server_key_error'];
			}
			if(!$server_store_path){
				$error = true;
				$sysmsg[] = $L['server_store_path_error'];
			}
			if(!$ftp_host){
				$error = true;
				$sysmsg[] = $L['ftp_host_error'];
			}
			if(!is_numeric($ftp_port)){
				$error = true;
				$sysmsg[] = $L['ftp_port_error'];
			}
			if(!$ftp_user){
				$error = true;
				$sysmsg[] = $L['ftp_user_error'];
			}
			if(!$ftp_pass){
				$error = true;
				$sysmsg[] = $L['ftp_pass_error'];
			}

			if(!$error){
				$ins = array(
				'server_name' => $server_name,
				'server_key' => pd_encode($server_key),
				'server_store_path' => pd_encode($server_store_path),
				'ftp_host' => pd_encode($ftp_host),
				'ftp_port' => pd_encode(strval($ftp_port)),
				'ftp_user' => pd_encode($ftp_user),
				'ftp_pass' => pd_encode($ftp_pass),
				'ftp_ssl' => $ftp_ssl,
				'ftp_pasv' => $ftp_pasv,
				);
				$db->query_unbuffered("insert into {$tpf}client_set set client_info='".serialize($ins)."';");
				$sysmsg[] = $L['add_client_success'];

				redirect(urr("admincp","item=plugins&app=$app"),$sysmsg);
			}else{
				redirect('back',$sysmsg);
			}
		}else{
			$ftp_port = 21;
			$ftp_pasv = 1;
			$server_key = random(12);
			$server_store_path = 'filestores';
			require_once template_echo('admin','',$app);
		}
		break;

	case 'edit_client':
		$client_id = (int)gpc('client_id','GP',0);

		if($task =='edit_client'){
			form_auth(gpc('formhash','P',''),formhash());

			$server_name = trim(gpc('server_name','P',''));
			$server_key = trim(gpc('server_key','P',''));
			$server_store_path = trim(gpc('server_store_path','P',''));
			$ftp_host = trim(gpc('ftp_host','P',''));
			$ftp_port = (int)gpc('ftp_port','P','');
			$ftp_user = trim(gpc('ftp_user','P',''));
			$ftp_pass = trim(gpc('ftp_pass','P',''));
			$ftp_ssl = (int)gpc('ftp_ssl','P',0);
			$ftp_pasv = (int)gpc('ftp_pasv','P',0);

			if($settings['online_demo']){
				$error = true;
				$sysmsg[] = $L['online_demo_deny'];
			}
			$tmp = $db->result_first("select client_info from {$tpf}client_set where client_id='$client_id' limit 1");
			if($tmp){
				$tmp = unserialize($tmp);
				$ftp_pass_src = pd_encode($tmp['ftp_pass'],'DECODE');
			}
			if(checklength($server_name,2,100)){
				$error = true;
				$sysmsg[] = $L['server_name_error'];
			}
			if(!$ftp_host){
				$error = true;
				$sysmsg[] = $L['ftp_host_error'];
			}
			if(!$server_key){
				$error = true;
				$sysmsg[] = $L['server_key_error'];
			}
			if(!$server_store_path){
				$error = true;
				$sysmsg[] = $L['server_store_path_error'];
			}
			if(!is_numeric($ftp_port)){
				$error = true;
				$sysmsg[] = $L['ftp_port_error'];
			}
			if(!$ftp_user){
				$error = true;
				$sysmsg[] = $L['ftp_user_error'];
			}
			if(strpos($ftp_pass,'*') ===false){
				if(!$ftp_pass){
					$error = true;
					$sysmsg[] = $L['ftp_pass_error'];
				}
			}else{
				$ftp_pass = $ftp_pass_src;
			}

			if(!$error){
				$arr = array(
				'server_name' => $server_name,
				'server_key' => pd_encode($server_key),
				'server_store_path' => pd_encode($server_store_path),
				'ftp_host' => pd_encode($ftp_host),
				'ftp_port' => pd_encode(strval($ftp_port)),
				'ftp_user' => pd_encode($ftp_user),
				'ftp_pass' => pd_encode($ftp_pass),
				'ftp_ssl' => $ftp_ssl,
				'ftp_pasv' => $ftp_pasv,
				);
				$db->query_unbuffered("update {$tpf}client_set set client_info='".serialize($arr)."' where client_id='$client_id';");
				$sysmsg[] = $L['edit_client_success'];
				redirect(urr("admincp","item=plugins&app=$app"),$sysmsg);
			}else{
				redirect('back',$sysmsg);
			}

		}else{

			$rs = $db->fetch_one_array("select * from {$tpf}client_set where client_id='$client_id' limit 1");
			$rs = unserialize($rs['client_info']);
			if($rs){
				$server_name = $rs['server_name'];
				$server_store_path = pd_encode($rs['server_store_path'],'DECODE');
				$server_key = pd_encode($rs['server_key'],'DECODE');
				$ftp_host = pd_encode($rs['ftp_host'],'DECODE');
				$ftp_port = pd_encode($rs['ftp_port'],'DECODE');
				$ftp_user = pd_encode($rs['ftp_user'],'DECODE');
				$ftp_pass = encode_pwd(pd_encode($rs['ftp_pass'],'DECODE'));
				$ftp_ssl = $rs['ftp_ssl'];
				$ftp_pasv = $rs['ftp_pasv'];
			}
			unset($rs);
			require_once template_echo('admin','',$app);
		}
		break;

	case 'del_client':
		if($settings['online_demo']){
			$error = true;
			$sysmsg[] = $L['online_demo_deny'];
		}
		if(!$error){
			$client_id = (int)gpc('client_id','G',0);
			$db->query_unbuffered("delete from {$tpf}client_set where client_id='$client_id'");
			$sysmsg[] = $L['client_del_success'];
			redirect(urr("admincp","item=plugins&app=$app"),$sysmsg);
		}else{
			redirect('back',$sysmsg);
		}
		break;

	default:
		if($task =='update'){
			form_auth(gpc('formhash','P',''),formhash());

			$setting = array(
			'open_client' => 0,
			);
			$settings = gpc('setting','P',$setting);

			if(!$error){
				settings_cache($settings);
				$sysmsg[] = $L['client_update_success'];
				redirect(urr("admincp","item=plugins&app=$app"),$sysmsg);

			}else{
				redirect('back',$sysmsg);
			}
		}else{
			$q = $db->query("select * from {$tpf}client_set order by client_id asc");
			while ($rs = $db->fetch_array($q)) {
				$tmp = unserialize($rs['client_info']);
				$tmp['a_edit_client'] = urr("admincp","item=plugins&app=$app&action=edit_client&client_id={$rs['client_id']}");
				$tmp['a_del_client'] = urr("admincp","item=plugins&app=$app&action=del_client&client_id={$rs['client_id']}");
				$C['server_arr'][] = $tmp;
			}
			$db->free($q);
			unset($rs);

			require_once template_echo('admin','',$app);
		}
}
update_action_time($app);

?>