<?php 
##
#	Project: PHPDISK File Storage Solution
#	This is NOT a freeware, use is subject to license terms.
#
#	Site: http://www.phpdisk.com
#
#	$Id: global.func.php 11 2011-06-08 12:00:43Z along $
#
#	Copyright (C) 2008-2011 PHPDisk Team. All Rights Reserved.
#
##

if(!defined('IN_PHPDISK')) {
	exit('[PHPDisk] Access Denied');
}

function template_echo($tpl,$tpl_dir,$app='',$is_admin_tpl=0){
	if($app){
		$tpl_cache_dir = PHPDISK_ROOT."system/plugins/$app/";
		$tpl_src_dir = PHPDISK_ROOT."plugins/$app/";
	}else{
		$tpl_cache_dir = PHPDISK_ROOT.'system/'.$tpl_dir;
		$tpl_src_dir = PHPDISK_ROOT.$tpl_dir;
		$tpl_default_dir = PHPDISK_ROOT.'templates/default/';
		$admin_tpl_dir = PHPDISK_ROOT.'templates/admin/';
	}
	make_dir($tpl_cache_dir);
	$tpl_cache_file = $tpl_cache_dir.$tpl.'.tpl.php';
	$tpl_src_file = $tpl_src_dir.$tpl.'.tpl.html';
	if(!$app){
		if($is_admin_tpl && !file_exists($tpl_src_file)){
			$tpl_src_file = $admin_tpl_dir.$tpl.'.tpl.html';
		}elseif(!file_exists($tpl_src_file)){
			$tpl_src_file = $tpl_default_dir.$tpl.'.tpl.html';
		}
	}
	if(@filemtime($tpl_cache_file) < @filemtime($tpl_src_file)){
		write_file($tpl_cache_file,template_parse($tpl_src_file));
		template_echo($tpl,$tpl_dir);
	}
	return $tpl_cache_file;
}

function template_parse($tpl){
	if(!file_exists($tpl)){
		exit('Template ['.$tpl.'] not exists!');
	}
	$str = read_file($tpl);
	$str = preg_replace("/\<\!\-\-\#(.+?)\#\-\-\>/si","<?php \\1 ?>", $str);
	$str = preg_replace("/\{([A-Z_]+)\}/","<?=\\1?>",$str);
	$str = preg_replace("/\{(\\\$[a-z0-9_\'\"\[\]]+)\}/si", "<?=\\1?>", $str);
	$str = preg_replace("/\{\<\?\=(\\\$[a-z0-9_\'\"\[\]]+)\?\>\}/si","{\\1}",$str);
	$str = preg_replace("/\{\#(.+?)\#\}/si","<?=\\1?>", $str);
	$str = preg_replace("/\{sql\[(.+)\]\[(.+)\]\}/si","<? foreach(get_sql(\"\\1\") as \\2){ ?>",$str);
	$str = str_replace("{/sql}","<? } ?>",$str);
	$str = str_replace('@@','{$tpf}',$str); // fix sql tag!

	$prefix = "<?php ".LF;
	$prefix .= "// This is PHPDISK auto-generated file. Do NOT modify me.".LF.LF;
	$prefix .= "!defined('IN_PHPDISK') && exit('[PHPDisk] Access Denied');".LF.LF;
	$prefix .= "?>".LF;

	return $prefix.$str;
}

function form_auth($p_formhash,$formhash){
	global $L;
	if($p_formhash != $formhash){
		exit($L['system_error']);
	}
}
function convert_str($in,$out,$str){
	if(function_exists("iconv")){
		$str = iconv($in,$out,$str);
	}elseif(function_exists("mb_convert_encoding")){
		$str = mb_convert_encoding($str,$out,$in);
	}
	return $str;
}
function is_utf8(){
	global $charset;
	return (strtolower($charset) == 'utf-8') ? true : false;
}
function is_windows(){
	return (strtoupper(substr(PHP_OS, 0, 3)) === 'WIN') ? 1 : 0;
}

function lang($lang_name,$app = ''){
	global $C,$L,$settings;
	if($app){
		$file = PHPDISK_ROOT.'plugins/'.$app.'/'.$lang_name.'.lang.php';
	}else{
		$file = PHPDISK_ROOT.'languages/'.$C['lang_type'].'/'.$lang_name.'.lang.php';
	}
	if(!file_exists($file)){
		exit("Language pack [$file] does not exist!");
	}else{
		require($file);
		$L = !empty($L) ? array_merge($L,$lang) : $lang;
	}
}
function wipe_replace($str) {
	return str_replace(array( "\n", "\r", '..'), array('', '', ''), $str);
}

function word_style($i,$type ='font'){
	switch($i){
		case 500:
			$f_px = "25px";
			$c_col = '#ff6600';
			break;
		case 300:
			$f_px = "20px";
			$c_col = '#ff5500';
			break;
		case 100:
			$f_px = "18px";
			$c_col = '#003366';
			break;
		case 50:
			$f_px = "14px";
			$c_col = '#003366';
			break;
		default:
			$f_px = "12px";
			$c_col = '#666666';
	}
	return ($type =='font') ? $f_px : $c_col;
}
function page_end_time(){
	global $ps_time,$db,$C;
	return 'Processed in '.get_runtime('start','end').' second(s), '.$db->querycount.' queries, Gzip '.$C['gz']['status'];
}

function replace_inject_str($str){
	$bad_chars = array("\\","'",'"','/','*',',','<','>',"\r","\t","\n",'$','(',')','%','?',';','^','#',':','&');
	return str_replace($bad_chars,'',$str);
}
function redirect_top_page(){
	global $_SERVER;
	$tmp = strrchr($_SERVER['HTTP_REFERER'],'/');
	$arr = explode('.',$tmp);
	$php_ref = substr($arr[0],1);
	if($php_ref =='admincp' || $php_ref =='mydisk'){
		return true;
	}else{
		return false;
	}
}
function checklength($str,$min,$max){
	if(!$str || strlen($str) > $max || strlen($str) < $min){
		return true;
	}
}
function ifselected($int1,$int2,$type = 'int'){
	if($type == 'int'){
		if(intval($int1) == intval($int2)){
			return ' selected';
		}
	}elseif($type == 'str'){
		if(strval($int1) == strval($int2)){
			return ' selected';
		}
	}
}
function ifchecked($int1,$int2,$type = 'int'){
	if($type == 'int'){
		if(intval($int1) == intval($int2)){
			return ' checked';
		}
	}elseif($type == 'str'){
		if(strval($int1) == strval($int2)){
			return ' checked';
		}
	}
}
function multi_selected($id,$str){
	if(strpos($str,',')){
		$a2 = explode(',',$str);
		$rtn = in_array($id,$a2) ? ' selected' : '';
	}else{
		$rtn = $id==$str ? ' selected' : '';
	}
	return $rtn;
}

function replace_js($str){
	return preg_replace("'<script[^>]*?>(.*?)</script>'si","[script]\\1[/script]",$str);
}
function custom_time($format, $time){
	global $L,$timestamp;
	$s = $timestamp - $time;
	if($s < 0){
		return $L['custom_time_0'];
	}
	if($s < 60){
		return $s.$L['custom_time_1'];
	}
	$m = $s / 60;
	if($m < 60){
		return floor($m).$L['custom_time_2'];
	}
	$h = $m / 60;
	if($h < 24){
		return floor($h).$L['custom_time_3'];
	}
	$d = $h / 24;
	if($d < 2){
		return $L['custom_time_4'].date("H:i", $time);
	}
	if($d <3){
		return $L['custom_time_5'].date("H:i", $time);
	}
	if($d <= 30){
		return floor($d).$L['custom_time_6'];
	}
	return date($format, $time);
}
function get_byte_value($v){
	$v = trim($v);
	$l = strtolower($v[strlen($v) - 1]);
	switch($l){
		case 'g':
			$v *= 1024;

		case 'm':
			$v *= 1024;

		case 'k':
			$v *= 1024;
	}
	return $v;
}

function redirect($url,$str,$timeout = 2000,$target = ''){
	global $L,$user_tpl_dir;

	if($timeout ==0){
		header("Location:$url");
		exit;
	}else{
		$msg = '';
		if(is_array($str)){
			for($i=0;$i<count($str);$i++){
				$msg .= "<li>·".$str[$i]."</li>".LF;
			}
		}else{
			$msg = $str;
		}
		$go_url = $url=='back' ? $url = 'javascript:history.back();' : $url;
		require_once template_echo('information',$user_tpl_dir);
		$rtn = "<script>".LF;
		$rtn .= "<!--".LF;
		$rtn .= "function redirect() {".LF;
		if($target =='top'){
			$rtn .= "	self.parent.location.href = '$url';".LF;
		}else{
			$rtn .= "	document.location.href = '$go_url';".LF;
		}
		$rtn .= "}".LF;
		$rtn .= "setTimeout('redirect();', $timeout);".LF;
		$rtn .= "-->".LF;
		$rtn .= "</script>".LF;
		echo $rtn;
	}
}
function tb_redirect($url,$str,$timeout=2000){
	if(is_array($str)){
		for($i=0;$i<count($str);$i++){
			$msg .= "<li>·".$str[$i]."</li>".LF;
		}
	}else{
		$msg = $str;
	}
	$go_url = $url=='back' ? $url='javascript:history.back();' : $url;
	$rtn = '<div class="tb_box_msg"><img src="images/light.gif" border="0" align="absmiddle">&nbsp;<ul>'.$msg.'</ul></div>';
	$rtn .= "<script>".LF;
	$rtn .= "<!--".LF;
	$rtn .= "function redirect() {".LF;
	$rtn .= $url=='back' ? '' : "self.parent.hs.close();".LF;
	$rtn .= "	self.parent.document.location.href = '$go_url';".LF;
	$rtn .= "}".LF;
	$rtn .= "setTimeout('redirect();', $timeout);".LF;
	$rtn .= "-->".LF;
	$rtn .= "</script>".LF;
	echo $rtn;
}
function is_bad_chars($str){
	$bad_chars = array("\\",' ',"'",'"','/','*',',','<','>',"\r","\t","\n",'$','(',')','%','+','?',';','^','#',':','　','`','=','|','-');
	foreach($bad_chars as $value){
		if (strpos($str,$value) !== false){
			return true;
		}
	}
}
function get_extension($name){
	return strtolower(trim(strrchr($name, '.'), '.'));
}
function formhash(){
	global $pd_uid,$pd_pwd;
	return substr(md5(substr(time(), 0, -7).$pd_uid.$pd_pwd), 8, 8);
}
function encode_pwd($str){
	global $settings;
	$len = trim($str) ? strlen($str) : 6;
	if($settings['online_demo']){
		$rtn = str_repeat('*',$len);
	}else{
		if($len <=4){
			$rtn = str_repeat('*',$len);
		}elseif($len <=10){
			$rtn = str_repeat('*',$len-4);
			$rtn .= substr($str,-4);
		}else{
			$rtn = str_repeat('*',$len-6);
			$rtn .= substr($str,-6);
		}
	}
	return $rtn;
}
function random($length){
	$seed = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
	$str = "";
	while(strlen($str) < $length){
		$str .= substr($seed,(mt_rand() % strlen($seed)),1);
	}
	return $str;
}

function stripslashes_array(&$array) {
	if(is_array($array)){
		foreach($array as $k => $v) {
			$array[$k] = stripslashes_array($v);
		}
	}elseif(is_string($array)){
		$array = stripslashes($array);
	}
	return $array;
}

function get_size($s,$u='B',$p=1){
	$us = array('B'=>'K','K'=>'M','M'=>'G','G'=>'T');
	return (($u!=='B')&&(!isset($us[$u]))||($s<1024))?(number_format($s,$p)." $u"):(get_size($s/1024,$us[$u],$p));
}

function checkemail($email) {
	if((strlen($email) > 6) && preg_match("/^[\w\-\.]+@[\w\-\.]+(\.\w+)+$/", $email)){
		return true;
	}else{
		return false;
	}
}

function gpc($name,$w = 'GPC',$default = ''){
	$i = 0;
	for($i = 0; $i < strlen($w); $i++) {
		if($w[$i] == 'G' && isset($_GET[$name])) return $_GET[$name];
		if($w[$i] == 'P' && isset($_POST[$name])) return $_POST[$name];
		if($w[$i] == 'C' && isset($_COOKIE[$name])) return $_COOKIE[$name];
	}
	return $default;
}
function get_ip(){
	if(getenv('HTTP_CLIENT_IP') && strcasecmp(getenv('HTTP_CLIENT_IP'), 'unknown')) {
		$onlineip = getenv('HTTP_CLIENT_IP');
	} elseif(getenv('HTTP_X_FORWARDED_FOR') && strcasecmp(getenv('HTTP_X_FORWARDED_FOR'), 'unknown')) {
		$onlineip = getenv('HTTP_X_FORWARDED_FOR');
	} elseif(getenv('REMOTE_ADDR') && strcasecmp(getenv('REMOTE_ADDR'), 'unknown')) {
		$onlineip = getenv('REMOTE_ADDR');
	} elseif(isset($_SERVER['REMOTE_ADDR']) && $_SERVER['REMOTE_ADDR'] && strcasecmp($_SERVER['REMOTE_ADDR'], 'unknown')) {
		$onlineip = $_SERVER['REMOTE_ADDR'];
	}
	$onlineip = addslashes($onlineip);
	@preg_match("/[\d\.]{7,15}/", $onlineip, $onlineipmatches);
	$onlineip = $onlineipmatches[0] ? $onlineipmatches[0] : 'unknown';
	unset($onlineipmatches);
	return $onlineip;
}

function pd_setcookie($var, $value, $expires = 0,$cookiepath = '/', $cookiedomain = '') {
	global $timestamp;
	setcookie($var, $value,$expires ? ($timestamp + $expires) : 0,$cookiepath,$cookiedomain, $_SERVER['SERVER_PORT'] == 443 ? 1 : 0);
}

function pd_encode($txt, $operation = 'ENCODE',$key = 'PHPDisk=Rc9o'){
	global $settings;
	$key = $settings['encrypt_key'] ? $settings['encrypt_key'] : $key;
	if($operation == 'DECODE'){
		$txt = encrypt_key(base64_decode($txt), $key);
		$tmp = '';
		for ($i = 0; $i < strlen($txt); $i++) {
			$tmp .= $txt[$i] ^ $txt[++$i];
		}
		return $tmp;
	}else{
		srand((double)microtime() * 1000000);
		$encrypt_key = md5(rand(0, 32000));
		$ctr = 0;
		$tmp = '';
		for($i = 0; $i < strlen($txt); $i++) {
			$ctr = $ctr == strlen($encrypt_key) ? 0 : $ctr;
			$tmp .= $encrypt_key[$ctr].($txt[$i] ^ $encrypt_key[$ctr++]);
		}
		return base64_encode(encrypt_key($tmp, $key));
	}
}
function encrypt_key($txt, $key) {
	$md5_key = md5($key);
	$ctr = 0;
	$tmp = '';
	for($i = 0; $i < strlen($txt); $i++) {
		$ctr = $ctr == strlen($md5_key) ? 0 : $ctr;
		$tmp .= $txt[$i] ^ $md5_key[$ctr++];
	}
	return $tmp;
}

function cutstr($string, $length, $dot = '...',$charset='utf-8') {
	if(strlen($string) <= $length) {
		return $string;
	}
	$string = str_replace(array('&amp;', '&quot;', '&lt;', '&gt;'), array('&', '"', '<', '>'), $string);
	$strcut = '';
	if(strtolower($charset) == 'utf-8') {

		$n = $tn = $noc = 0;
		while($n < strlen($string)) {

			$t = ord($string[$n]);
			if($t == 9 || $t == 10 || (32 <= $t && $t <= 126)) {
				$tn = 1; $n++; $noc++;
			} elseif(194 <= $t && $t <= 223) {
				$tn = 2; $n += 2; $noc += 2;
			} elseif(224 <= $t && $t < 239) {
				$tn = 3; $n += 3; $noc += 2;
			} elseif(240 <= $t && $t <= 247) {
				$tn = 4; $n += 4; $noc += 2;
			} elseif(248 <= $t && $t <= 251) {
				$tn = 5; $n += 5; $noc += 2;
			} elseif($t == 252 || $t == 253) {
				$tn = 6; $n += 6; $noc += 2;
			} else {
				$n++;
			}

			if($noc >= $length) {
				break;
			}

		}
		if($noc > $length) {
			$n -= $tn;
		}

		$strcut = substr($string, 0, $n);

	} else {
		for($i = 0; $i < $length - strlen($dot) - 1; $i++) {
			$strcut .= ord($string[$i]) > 127 ? $string[$i].$string[++$i] : $string[$i];
		}
	}

	$strcut = str_replace(array('&', '"', '<', '>'), array('&amp;', '&quot;', '&lt;', '&gt;'), $strcut);

	return $strcut.$dot;
}

function multi($total, $perpage, $curpage, $mpurl) {
	$multipage = '';
	$mpurl .= strpos($mpurl, '?') ? '&amp;' : '?';
	if($total > $perpage) {
		$pg = 10;
		$offset = 5;
		$pgs = @ceil($total / $perpage);
		if($pg > $pgs) {
			$from = 1;
			$to = $pgs;
		} else {
			$from = $curpage - $offset;
			$to = $curpage + $pg - $offset - 1;
			if($from < 1) {
				$to = $curpage + 1 - $from;
				$from = 1;
				if(($to - $from) < $pg && ($to - $from) < $pgs) {
					$to = $pg;
				}
			} elseif($to > $pgs) {
				$from = $curpage - $pgs + $to;
				$to = $pgs;
				if(($to - $from) < $pg && ($to - $from) < $pgs) {
					$from = $pgs - $pg + 1;
				}
			}
		}

		$multipage = ($curpage - $offset > 1 && $pgs > $pg ? '<a href="'.$mpurl.'pg=1" class="p_redirect">&laquo;</a>' : '').($curpage > 1 ? '<a href="'.$mpurl.'pg='.($curpage - 1).'" class="p_redirect">&#8249;</a>' : '');
		for($i = $from; $i <= $to; $i++) {
			$multipage .= $i == $curpage ? '<span class="p_curpage">'.$i.'</span>' : '<a href="'.$mpurl.'pg='.$i.'" class="p_num">'.$i.'</a>';
		}
		$multipage .= ($curpage < $pgs ? '<a href="'.$mpurl.'pg='.($curpage + 1).'" class="p_redirect">&#8250;</a>' : '').($to < $pgs ? '<a href="'.$mpurl.'pg='.$pgs.'" class="p_redirect">&raquo;</a>' : '');
		$multipage = $multipage ? '<div class="p_bar"><span class="p_info">Total:&nbsp;<b>'.$total.'</b>&nbsp;</span>'.$multipage.'</div>' : '';
	}
	return $multipage;
}
function reload_leftframe($script,$op){
	echo '<script>top.document.getElementById(\'leftframe\').src = "'.urr($script,"item=menu&op=".$op).'";</script>';
}
function is_today($time){
	return (date('Ymd') == date('Ymd',$time)) ? 1 : 0;
}
function get_ids_arr($arr,$msg,$str_in_db=0){
	global $db;
	$error = 0;
	if(!count($arr)){
		$error = 1;
		$strs = $msg;
	}else{
		for($i=0;$i<count($arr);$i++){
			$strs .= $str_in_db ? $db->escape($arr[$i])."," : "'".$db->escape($arr[$i])."',";
		}
		$strs = substr($strs,0,-1);
	}
	return array($error,$strs);
}
function get_last_upload_server($pd_uid,$group_set){
	$arr_ids = strpos($group_set,',') ? explode(',',$group_set) : $group_set;
	if(is_array($arr_ids)){
		$server_oid = (int)$arr_ids[mt_rand(0,count($arr_ids))];
		$server_oid = $server_oid ? $server_oid : (int)$arr_ids[0];
	}else{
		$server_oid = $arr_ids;
	}
	return $server_oid;
}

function delete_phpdisk_file($sql,$rmdir=0){
	global $db,$tpf,$settings,$pd_uid,$pd_username;
	$q = $db->query($sql);
	while($rs = $db->fetch_array($q)){
		$file_ext = get_real_ext($rs['file_extension']);
		$rs2 = $db->fetch_one_array("select count(*) as total from {$tpf}files where file_real_name='{$rs['file_real_name']}' and file_store_path='{$rs['file_store_path']}'");
		if($rs2['total']==1){
			if(display_plugin('multi_server','open_multi_server_plugin',$settings['open_multi_server'],0) && $rs['server_oid']>1){
				$rs3 = $db->fetch_one_array("select * from {$tpf}servers where server_oid='{$rs['server_oid']}' limit 1");
				if($rs3){
					$ftp_res = pftp_connnect($rs3['ftp_host'],$rs3['ftp_user'],$rs3['ftp_pass'],$rs3['ftp_port'],'/',$rs3['ftp_ssl'],$rs3['ftp_pasv']);
					$arr = explode('/',$rs3['ftp_path']);
					if(count($arr)){
						for($i=0;$i<count($arr);$i++){
							if(trim($arr[$i])) pftp_chdir($ftp_res,$arr[$i]);
						}
					}
					pftp_delete($ftp_res,$rs['file_store_path'].'/'.$rs['file_real_name'].$file_ext);
					pftp_delete($ftp_res,$rs['file_store_path'].'/'.$rs['file_real_name'].'_thumb'.$file_ext);
					pftp_close($ftp_res);
				}
				unset($rs3);
			}else{
				$src_1 = PHPDISK_ROOT.$settings['file_path'].'/'.$pd_username.$rs['file_store_path'].$rs['file_real_name'].$file_ext;
				$src_1 = is_utf8() ? convert_str('utf-8','gbk',$src_1) : $src_1;
				@unlink($src_1);

				if($rs['is_image']){
					$src_2 = PHPDISK_ROOT.$settings['file_path'].'/'.$pd_username.$rs['file_store_path'].$rs['file_real_name'].'_thumb'.$file_ext;
					$src_2 = is_utf8() ? convert_str('utf-8','gbk',$src_2) : $src_2;
					@unlink($src_2);
				}
				if($rmdir){
					$dir = PHPDISK_ROOT.$settings['file_path'].'/'.$pd_username.$rs['file_store_path'];
					$dir = is_utf8() ? convert_str('utf-8','gbk',$dir) : $dir;
					@rmdir($dir);
				}
			}
		}
		unset($rs2);
		update_cache('file','',$pd_uid);
	}
	$db->free($q);
	unset($rs);
}
function syn_folder_size(){
	global $db,$tpf,$pd_uid;

	$q = $db->query("select * from {$tpf}folders where userid='$pd_uid' and in_recycle=0 order by folder_id asc");
	while($rs = $db->fetch_array($q)){
		if($rs['folder_id']){
			$total_size = @$db->result_first("select sum(file_size) from {$tpf}files where folder_id='{$rs['folder_id']}' and in_recycle=0 and userid='$pd_uid'");
			$db->query_unbuffered("update {$tpf}folders set folder_size='$total_size' where folder_id='{$rs['folder_id']}' and in_recycle=0 and  userid='$pd_uid'");
		}
	}
	$db->free($q);
	unset($rs);
	return true;
}
function get_file_thumb($rs){
	global $db,$tpf,$settings;
	if(display_plugin('multi_server','open_multi_server_plugin',$settings['open_multi_server'],0) && $rs['server_oid'] >1){
		$rs2 = $db->fetch_one_array("select * from {$tpf}servers where server_oid='{$rs['server_oid']}' limit 1");
		if($rs2){
			if($rs['is_image']){
				$file_thumb = $rs2['server_host'].$rs2['server_store_path'].'/'.$rs['file_store_path'].'/'.$rs['file_real_name'].'_thumb.'.$rs['file_extension'];
			}
		}
		unset($rs2);
	}else{
		$username = @$db->result_first("select username from {$tpf}users where userid='{$rs['userid']}'");
		$tmp_username = is_utf8() ? convert_str('utf-8','gbk',$username) : $username;
		$file_store_path = $rs['file_store_path'];
		$file_real_name = $rs['file_real_name'];
		if($rs['is_image']){
			$file_thumb = $settings['file_path'].'/'.$tmp_username.$file_store_path.$file_real_name.'_thumb.'.$rs['file_extension'];
		}
	}
	return $file_thumb;
}
function short_date($str){
	return date($str);
}
function create_store_dir($y='',$m='',$d=''){
	global $settings;
	$store_dir = PHPDISK_ROOT.$settings['file_path'].'/'.date('Y/m/d/');
	make_dir($store_dir);
	return true;
}
function get_real_ext($file_extension){
	global $settings;
	if($file_extension){
		$exts = explode(',',$settings['filter_extension']);
		if(in_array($file_extension,$exts)){
			$file_ext = '.'.$file_extension.'.txt';
		}else{
			$file_ext = '.'.$file_extension;
		}
	}else{
		$file_ext = '.txt';
	}
	return $file_ext;
}
function get_file_name($file_name,$file_ext){
	$tmp_ext = $file_ext ? '.'.$file_ext: '';
	return $file_name.$tmp_ext;
}

function can_true_link($file_extension){
	global $settings;
	$arr = explode(',',$settings['true_link_extension']);
	return ($settings['true_link'] && in_array($file_extension,$arr)) ? true : false;
}
function make_tags($tags,$tag_arr,$file_id){
	global $db,$tpf,$timestamp,$pd_uid;
	if($tags){
		$tags_str = '';
		for($i=0;$i<count($tag_arr);$i++){
			if($tag_arr[$i]){
				$tags_str .= "'{$tag_arr[$i]}',";
				$rs = $db->fetch_one_array("select count(*) as total from {$tpf}file2tag where tag_name='{$tag_arr[$i]}' and file_id='{$file_id}'");
				if(!$rs['total']){
					$ins = array(
					'tag_name' => $tag_arr[$i],
					'file_id' => $file_id,
					);
					$db->query_unbuffered("insert into {$tpf}file2tag set ".$db->sql_array($ins).";");
				}
				unset($rs);
			}
		}
		$tags_str = (substr($tags_str,-1) ==',') ? substr($tags_str,0,-1) : $tags_str;
		$db->query_unbuffered("update {$tpf}tags set tag_count=tag_count-1 where tag_name in (select tag_name from {$tpf}file2tag where file_id='$file_id')");
		$db->query_unbuffered("delete from {$tpf}file2tag where file_id='$file_id' and tag_name not in ($tags_str)");

		$tagdb = explode(',',$tags);
		for($i=0; $i<count($tagdb); $i++){
			$tagdb[$i] = trim($tagdb[$i]);
			if($tagdb[$i]){
				$rs = $db->fetch_one_array("select count(*) as total from {$tpf}tags where tag_name='{$tagdb[$i]}'");
				if(!$rs['total']){
					$ins = array(
					'tag_name' => $db->escape($tagdb[$i]),
					'tag_count' => 1,
					);
					$db->query_unbuffered("insert into {$tpf}tags set ".$db->sql_array($ins).";");
				}
				unset($rs);
				$db->query_unbuffered("update {$tpf}tags set tag_count=(select count(*) from {$tpf}file2tag where tag_name='{$tagdb[$i]}') where tag_name='{$tagdb[$i]}'");
			}
		}

	}else{
		$q = $db->query("select * from {$tpf}file2tag where file_id='$file_id'");
		while($rs = $db->fetch_array($q)){
			$tags_str .= "'{$rs['tag_name']}',";
		}
		$db->free($q);
		unset($rs);
		$tags_str = (substr($tags_str,-1) ==',') ? substr($tags_str,0,-1) : $tags_str;
		if($tags_str){
			$db->query_unbuffered("update {$tpf}tags set tag_count=tag_count-1 where tag_name in ($tags_str)");
			$db->query_unbuffered("delete from {$tpf}file2tag where file_id='$file_id'");
		}
	}
}
function flashget_encode($t_url,$uid){
	$prefix = "Flashget://";
	$FlashgetURL = $prefix.base64_encode("[FLASHGET]".$t_url."[FLASHGET]")."&".$uid;
	return $FlashgetURL;
}

function thunder_encode($url){
	$thunderPrefix = "AA";
	$thunderPosix = "ZZ";
	$thunderTitle = "thunder://";
	$thunderUrl = $thunderTitle.base64_encode($thunderPrefix.$url.$thunderPosix);
	return $thunderUrl;
}
function file_icon($ext,$fd = 'filetype',$align='absmiddle'){
	$icon = PHPDISK_ROOT."images/{$fd}/".$ext.".gif";
	if(file_exists($icon)){
		$img = "<img src='images/{$fd}/{$ext}.gif' align='{$align}' border='0' />";
	}else{
		$img = "<img src='images/{$fd}/file.gif' align='{$align}' border='0' />";
	}
	return $img;
}
function mime_type( $ext ){
	$mime = array(
	'avi'  => 'video/x-msvideo',
	'bmp'  => 'image/bmp',
	'css'  => 'text/css',
	'js'   => 'application/x-javascript js',
	'doc'  => 'application/msword',
	'gif'  => 'image/gif',
	'htm'  => 'text/html',
	'html' => 'text/html',
	'jpg'  => 'image/jpeg',
	'jpeg' => 'image/jpeg',
	'mov'  => 'video/quicktime',
	'mpeg' => 'video/mpeg',
	'mp3'  => 'audio/mpeg mpga mp2 mp3',
	'pdf'  => 'application/pdf',
	'php'  => 'text/html',
	'png'  => 'image/png',
	'qt'   => 'video/quicktime',
	'rar'  => 'application/x-rar',
	'swf'  => 'application/x-shockwave-flash swf',
	'txt'  => 'text/plain',
	'wmv'  => 'video/x-ms-wmv',
	'xml'  => 'text/xml',
	'xsl'  => 'text/xml',
	'xls'  => 'application/msexcel x-excel',
	'zip'  => 'application/zip x-zip',
	'torrent' => 'application/x-bittorrent',

	);
	return isset($mime[$ext]) ? $mime[$ext] : 'application/octet-stream';
}


function get_my_nav($nav_arr=array()){
	global $db,$tpf,$pd_uid,$pd_gid,$L,$group_settings,$timestamp;
	$space_pos = (int)$db->result_first("select space_pos from {$tpf}users where userid='$pd_uid' limit 1");
	if($space_pos){
		$arr['max_storage'] = @$db->result_first("select space from {$tpf}disks d,{$tpf}disk2user du where d.disk_id=du.disk_id and du.userid='$pd_uid' and endtime>$timestamp");
	}else{
		$rs = $db->fetch_one_array("select user_store_space from {$tpf}users where userid='$pd_uid'");
		if($rs['user_store_space'] ==0){
			$arr['max_storage'] = $group_settings[$pd_gid]['max_storage']==0 ? $L['no_limit'] : $group_settings[$pd_gid]['max_storage'];
		}else{
			$arr['max_storage'] = $rs['user_store_space'];
		}
		unset($rs);
	}

	$file_size_total = $db->result_first("select sum(file_size) from {$tpf}files where userid='$pd_uid' and space_pos='$space_pos'");
	$arr['now_space'] = get_size($file_size_total);
	$file_size_total = ($file_size_total > get_byte_value($arr['max_storage'])) ? get_byte_value($arr['max_storage']) : $file_size_total;
	$arr['disk_fill'] = $arr['max_storage'] ? @round($file_size_total/get_byte_value($arr['max_storage']),1)*120 : 0;
	$arr['disk_percent'] = $arr['max_storage'] ? @round($file_size_total/get_byte_value($arr['max_storage']),3)*100 : 0;
	$arr['disk_remain'] = 100-$arr['disk_percent'];
	$arr['disk_space'] = $arr['max_storage'] ? get_size(get_byte_value($arr['max_storage'])-$file_size_total) : $L['no_limit'];
	if(is_array($nav_arr)){
		$arr = array_merge($arr,$nav_arr);
	}
	return $arr;
}
function get_rank($rank){
	if($rank){
		$sun = floor($rank/16);
		$moon = floor(($rank-16*$sun)/4);
		$star = $rank-16*$sun-4*$moon;
		$rtn = str_repeat('<img src="images/lv_sun.gif" align="absmiddle" border="0">',$sun);
		$rtn .= str_repeat('<img src="images/lv_moon.gif" align="absmiddle" border="0">',$moon);
		$rtn .= str_repeat('<img src="images/lv_star.gif" align="absmiddle" border="0">',$star);
	}else{
		$rtn = '<span class="f10">N/A</span>';
	}
	return $rtn;
}
function update_rank(){
	global $pd_uid,$db,$tpf,$settings;
	$rs = $db->fetch_one_array("select rank,exp from {$tpf}users where userid='$pd_uid' limit 1");
	if($rs){
		if(($rs['rank']+1)*$settings['exp_const']<=$rs['exp']){
			$rank = $rs['rank']+1;
			$exp = $rs['exp']-($rs['rank']+1)*$settings['exp_const'];
			$db->query_unbuffered("update {$tpf}users set rank='$rank',exp='$exp' where userid='$pd_uid' limit 1");
		}
	}
	unset($rs);
}
function preview_file($file,$autostart = 0){
	global $settings,$L;
	$v_width = 500;
	$v_height = 310;
	$a_width = 500;
	$a_height = 50;
	if(is_array($file) && $settings['open_file_preview'] && $file['is_checked']){

		if($file['file_extension'] =='swf'){
			$rtn = '<script type="text/javascript" reload="1">document.write(AC_FL_RunContent(\'width\', \''.$v_width.'\', \'height\', \''.$v_height.'\', \'allowNetworking\', \'internal\', \'allowScriptAccess\', \'never\', \'src\', \''.$file['preview_link'].'\', \'quality\', \'high\', \'bgcolor\', \'#ffffff\', \'wmode\', \'transparent\', \'allowfullscreen\', \'true\'));</script>';

		}elseif($file['is_image']){
			$rtn = '<img src="'.$file['file_thumb'].'" id="file_thumb" onload="resize_img(\'file_thumb\',400,300);" border="0">';

		}elseif($file['file_extension'] =='mp3'){
			$rtn = '<script type="text/javascript" src="includes/js/audio-player.js"></script>';
			$rtn .= '<script type="text/javascript">  ';
			$rtn .= '	AudioPlayer.setup("includes/js/audio-player.swf", {   ';
			$rtn .= '		width: '.$a_width.',';
			$rtn .= '		transparentpagebg: "yes"      ';
			$rtn .= '	});   ';
			$rtn .= '</script>  ';
			$rtn .= '<p id="audioplayer_1">audioplayer online</p>  ';
			$rtn .= '<script type="text/javascript">  ';
			$rtn .= 'AudioPlayer.embed("audioplayer_1", {soundFile: "'.$file['preview_link'].'",titles: "'.$file['file_name'].'"});';
			$rtn .= '</script>';

		}elseif(in_array($file['file_extension'],array('wma','mid','wav'))){
			$rtn = '<object classid="clsid:6BF52A52-394A-11d3-B153-00C04F79FAA6" width="'.$a_width.'" height="64"><param name="invokeURLs" value="0"><param name="autostart" value="'.$autostart.'" /><param name="url" value="'.$file['preview_link'].'" /><embed src="'.$file['preview_link'].'" autostart="'.$autostart.'" type="application/x-mplayer2" width="'.$a_width.'" height="64"></embed></object>';

		}elseif(in_array($file['file_extension'],array('ra','rm','ram'))){
			$mediaid = 'media_'.random(3);
			$rtn = '<object classid="clsid:CFCDAA03-8BE4-11CF-B84B-0020AFBBCCFA" width="'.$a_width.'" height="32"><param name="autostart" value="'.$autostart.'" /><param name="src" value="'.$file['preview_link'].'" /><param name="controls" value="controlpanel" /><param name="console" value="'.$mediaid.'_" /><embed src="'.$file['preview_link'].'" type="audio/x-pn-realaudio-plugin" controls="ControlPanel" console="'.$mediaid.'_" width="'.$a_width.'" height="32"></embed></object>';
		}elseif(in_array($file['file_extension'],array('asf','asx','wmv','mms','avi','mpg','mpeg'))){
			$rtn = '<object classid="clsid:6BF52A52-394A-11d3-B153-00C04F79FAA6" width="'.$v_width.'" height="'.$v_height.'"><param name="invokeURLs" value="0"><param name="autostart" value="'.$autostart.'" /><param name="url" value="'.$file['preview_link'].'" /><embed src="'.$file['preview_link'].'" autostart="'.$autostart.'" type="application/x-mplayer2" width="'.$v_width.'" height="'.$v_height.'"></embed></object>';
		}elseif($file['file_extension'] =='mov'){
			$rtn = '<object classid="clsid:02BF25D5-8C17-4B23-BC80-D3488ABDDC6B" width="'.$v_width.'" height="'.$v_height.'"><param name="autostart" value="'.($autostart ? '' : 'false').'" /><param name="src" value="'.$file['preview_link'].'" /><embed src="'.$file['preview_link'].'" autostart="'.($autostart ? 'true' : 'false').'" type="video/quicktime" controller="true" width="'.$v_width.'" height="'.$v_height.'"></embed></object>';
		}elseif(in_array($file['file_extension'],array('rm','rmvb','rtsp'))){
			$mediaid = 'media_'.random(3);
			$rtn = '<object classid="clsid:CFCDAA03-8BE4-11cf-B84B-0020AFBBCCFA" width="'.$v_width.'" height="'.$v_height.'"><param name="autostart" value="'.$autostart.'" /><param name="src" value="'.$file['preview_link'].'" /><param name="controls" value="imagewindow" /><param name="console" value="'.$mediaid.'_" /><embed src="'.$file['preview_link'].'" type="audio/x-pn-realaudio-plugin" controls="imagewindow" console="'.$mediaid.'_" width="'.$v_width.'" height="'.$v_height.'"></embed></object><br /><object classid="clsid:CFCDAA03-8BE4-11CF-B84B-0020AFBBCCFA" width="'.$v_width.'" height="32"><param name="src" value="'.$file['preview_link'].'" /><param name="controls" value="controlpanel" /><param name="console" value="'.$mediaid.'_" /><embed src="'.$file['preview_link'].'" type="audio/x-pn-realaudio-plugin" controls="controlpanel" console="'.$mediaid.'_" width="'.$v_width.'" height="32"'.($autostart ? ' autostart="true"' : '').'></embed></object>';
		}
	}

	return 	$rtn ? '<div class="file_item">'.$L['file_preview'].':<br />'.$rtn.'</div><br />' : '';

}
function send_email($to,$subject,$body,$from='',$fromname='',$stmp = true, $sender='',$host='',$port='',$ssl='',$username='',$password=''){
	global $charset;
	$mail = new phpmailer;

	if (!$stmp) {
		$mail->IsMail();
	} else {
		$mail->IsSMTP();
		$mail->SMTPAuth   = true;
		$mail->Host       = $host;
		if ($ssl) {
			$mail->SMTPSecure = "ssl";
		}
		if ($port!='') {
			$mail->Port       = $port;
		}

		$mail->Username   = $username;
		$mail->Password   = $password;

	}

	$mail->IsHTML(true);
	$mail->Sender       = $sender;
	$mail->FromEmail  = $from;
	$mail->FromName   = $fromname;

	$mail->Subject    = $subject;
	$mail->Body       = $body;
	$mail->CharSet		= $charset;
	$mail->WordWrap   = 50;

	if (is_array($to)) {
		foreach($to as $email) {
			$mail->AddAddress($email,"");
		}
	} else {
		$mail->AddAddress($to,"");
	}
	if ($fromname!='') $mail->AddReplyTo($from,$fromname);
	$mail->IsHTML(true);

	if(!$mail->Send()) {
		return "Mailer Error: " . $mail->ErrorInfo;
	} else {
		return true;
	}
}
function get_sql($sql){
	global $db,$tpf;
	$q = $db->query($sql);
	$arr = array();
	while ($rs = $db->fetch_array($q)) {
		$arr[] = $rs;
	}
	$db->free($q);
	unset($rs);
	return $arr;
}
function get_datacall($key){
	global $db,$tpf;
	$rs = $db->fetch_one_array("select * from {$tpf}datacalls where c_key='$key'");
	if($rs){
		echo base64_decode($rs['c_value']);
	}
}
function urr($str,$vars){
	global $settings;
	if($settings['open_rewrite']){
		switch($str){
			case 'viewfile':
				parse_str($vars);
				return "file-{$file_id}.html";
				break;

			case 'downfile':
				$arr = explode('&',trim($vars));
				parse_str($vars);

				if(count($arr) ==2){
					return "downfile-{$file_id}-{$file_key}.html";
				}else{
					return "viewfile-{$file_id}-{$file_key}.html";
				}
				break;

			case 'space':
				parse_str($vars);
				return 'space-'.rawurlencode($username).'.html';
				break;

			default:
				return $vars ? $str.'.php?'.$vars : $str.'.php';
		}

	}else{
		return $vars ? $str.'.php?'.$vars : $str.'.php';
	}
}
function get_pay_status($str){
	global $L;
	if($str =='success'){
		$rtn = '<span class="txtgreen">'.$L['success'].'</span>';
	}elseif($str =='fail'){
		$rtn = '<span class="txtred">'.$L['fail'].'</span>';
	}elseif($str =='pendding'){
		$rtn = '<span class="txtblue">'.$L['pendding'].'</span>';
	}else{
		$rtn = 'Unknown';
	}
	return $rtn;
}
function make_dir($path,$write_file=1){
	if(!is_dir($path)){
		$str = dirname($path);
		if($str){
			make_dir($str.'/');
			@mkdir($path,0777);
			chmod($path,0777);
			if($write_file){
				write_file($path.'index.htm','PHPDisk');
			}
		}
	}
}


?>