<?php 
##
#	Project: PHPDISK File Storage Solution
#	This is NOT a freeware, use is subject to license terms.
#
#	Site: http://www.phpdisk.com
#
#	$Id: file.func.php 6 2011-05-28 09:17:59Z along $
#
#	Copyright (C) 2008-2011 PHPDisk Team. All Rights Reserved.
#
##

if(!defined('IN_PHPDISK')) {
	exit('[PHPDisk] Access Denied');
}

function read_file($f) { 
    if (file_exists($f)) { 
        if (PHP_VERSION >= "4.3.0") return file_get_contents($f); 
        $fp = fopen($f,"rb"); 
        $fsize = filesize($f); 
        $c = fread($fp, $fsize); 
        fclose($fp); 
        return $c; 
    } else{
		exit("<b>$f</b> does not exist!"); 
	}
} 

function write_file($f,$str,$mode = 'wb') { 
    $fp = fopen($f,$mode); 
    if (!$fp) { 
        exit("Can not open file <b>$f</b> .code:1");
    } 
	if(is_writable($f)){
		if(!fwrite($fp,$str)){
			exit("Can not write file <b>$f</b> .code:2");
		} 
	}else{
		exit("Can not write file <b>$f</b> .code:3");
	}
    fclose($fp); 
} 
function upload_file($source, $target) {
		if (function_exists('move_uploaded_file') && @move_uploaded_file($source, $target)) {
		@chmod($target, 0666);
		return $target;
	} elseif (@copy($source, $target)) {
		@chmod($target, 0666);
		return $target;
	} elseif (@is_readable($source)) {
		if ($fp = @fopen($source,'rb')) {
			@flock($fp,2);
			$filedata = @fread($fp,@filesize($source));
			@fclose($fp);
		}
		if ($fp = @fopen($target, 'wb')) {
			@flock($fp, 2);
			@fwrite($fp, $filedata);
			@fclose($fp);
			@chmod ($target, 0666);
			return $target;
		} else {
			return false;
		}
	}
}
function tree_path($folder_id){
	global $db,$tpf,$pd_uid;
	$rs = $db->fetch_one_array("select parent_id,folder_name from {$tpf}folders where folder_id='$folder_id' and userid='$pd_uid'");
	$str = '';
	if($rs['parent_id']!=0){
		$str .= tree_path($rs['parent_id']);
	}
	$str .= $rs['folder_name'].'/';
	unset($rs);
	return $str;
}
function pd_file_move($file_ids,$to_folder_id){
	global $db,$tpf,$pd_uid,$pd_username,$settings;

	$q = $db->query("select file_store_path,file_name,file_extension from {$tpf}files where file_id in ($file_ids) and userid='$pd_uid'");
	while($rs = $db->fetch_array($q)){
		$tmp_path = PHPDISK_ROOT.$settings['file_path'].'/'.$pd_username.'/'.$rs['file_store_path'];
		$tmp_path2 = PHPDISK_ROOT.$settings['file_path'].'/'.$pd_username.'/'.tree_path($to_folder_id);
		$tmp_ext = $rs['file_extension'] ? '.'.$rs['file_extension'] : '';
		$old_name = is_utf8() ? convert_str('utf-8','gbk',$tmp_path.$rs['file_name'].$tmp_ext) : $tmp_path.$rs['file_name'].$tmp_ext;
		$new_name = is_utf8() ? convert_str('utf-8','gbk',$tmp_path2.$rs['file_name'].$tmp_ext) : $tmp_path2.$rs['file_name'].$tmp_ext;
		if(!@rename($old_name,$new_name)){
			return 'error';
		}
	}
	$db->free($q);
	unset($rs);
}
function pd_folder_move($folder_ids,$to_folder_id){
	global $db,$tpf,$pd_uid,$pd_username,$settings;
	
	$q = $db->query("select folder_name,parent_id from {$tpf}folders where folder_id in ($folder_ids) and userid='$pd_uid'");
	while($rs = $db->fetch_array($q)){
		$tmp_path = PHPDISK_ROOT.$settings['file_path'].'/'.$pd_username.'/'.tree_path($rs['parent_id']);
		$tmp_path2 = PHPDISK_ROOT.$settings['file_path'].'/'.$pd_username.'/'.tree_path($to_folder_id);
		$old_name = is_utf8() ? convert_str('utf-8','gbk',$tmp_path.$rs['folder_name'].'/') : $tmp_path.$rs['folder_name'].'/';
		$new_name = is_utf8() ? convert_str('utf-8','gbk',$tmp_path2.$rs['folder_name'].'/') : $tmp_path2.$rs['folder_name'].'/';
		write_file('a.txt',$old_name.'||'.$new_name);
		if(!rename($old_name,$new_name)){
			return 'error';
		}
	}
	$db->free($q);
	unset($rs);
}
function pd_file_rename($file_id,$file_name){
	global $db,$tpf,$pd_uid,$pd_username,$settings;
	$rs = $db->fetch_one_array("select file_store_path,file_name,file_extension from {$tpf}files where file_id='$file_id' and userid='$pd_uid'");
	if($rs){
		$tmp_path = PHPDISK_ROOT.$settings['file_path'].'/'.$pd_username.'/'.$rs['file_store_path'];
		$tmp_ext = $rs['file_extension'] ? '.'.$rs['file_extension'] : '';
		$old_name = is_utf8() ? convert_str('utf-8','gbk',$tmp_path.$rs['file_name'].$tmp_ext) : $tmp_path.$rs['file_name'].$tmp_ext;
		$new_name = is_utf8() ? convert_str('utf-8','gbk',$tmp_path.$file_name.$tmp_ext) : $tmp_path.$file_name.$tmp_ext;
	}
	unset($rs);
	return @rename($old_name,$new_name);
}
function pd_folder_rename($folder_id,$folder_name){
	global $db,$tpf,$pd_uid,$pd_username,$settings;
	$rs = $db->fetch_one_array("select folder_name,parent_id from {$tpf}folders where folder_id='$folder_id' and userid='$pd_uid'");
	if($rs){
		$tmp_path = PHPDISK_ROOT.$settings['file_path'].'/'.$pd_username.'/'.tree_path($rs['parent_id']);
		$old_name = is_utf8() ? convert_str('utf-8','gbk',$tmp_path.$rs['folder_name'].'/') : $tmp_path.$rs['folder_name'].'/';
		$new_name = is_utf8() ? convert_str('utf-8','gbk',$tmp_path.$folder_name.'/') : $tmp_path.$folder_name.'/';
	}
	unset($rs);
	return @rename($old_name,$new_name);
}
function syn_file_data($dir,$folder_node=0,$folder_id=0){
	global $db,$tpf,$pd_uid,$timestamp,$onlineip,$settings;

	$folder_node = $folder_node+1;
	$reload = 0;
	$dir = is_utf8() ? convert_str('utf-8','gbk',$dir) : $dir;
	
	$fl_arr = glob($dir.'*');
	foreach($fl_arr as $k => $v){
		$v2 = trim(strrchr($v, '/'), '/');
		if(is_file($v)){
			$v2 = is_utf8() ? convert_str('gbk','utf-8',$v2) : $v2;
			$exts_arr = explode(',',$settings['filter_extension']);
			$file['name'] = $v2;
			$file_extension = $db->escape(get_extension($file['name']));
			if(!in_array($file_extension,$exts_arr)){
				$esp = strlen($file_extension)+1;
				if($file_extension){
					$file_name = $db->escape(substr($file['name'],0,strlen($file['name'])-$esp));
				}else{
					$file_name = $db->escape($file['name']);
				}
				$file['size'] = filesize($v);
				$dest_file = $v;
				$img_arr = getimagesize($dest_file);
				if($img_arr[2] && @in_array($file_extension,array('jpg','jpeg','png','gif','bmp'))){
					$is_image = 1;
				}else{
					$is_image = 0;
				}
				$num = $db->result_first("select count(*) from {$tpf}files where userid='$pd_uid' and file_name='$file_name' and  file_extension='$file_extension' and folder_id='$folder_id'");
				if(!$num){
					$ins = array(
						'file_name' => $file_name,
						'file_key' => random(8),
						'file_extension' => $file_extension,
						'is_image' => (int)$is_image,
						'file_mime' => 'application/octet-stream',
						'file_description' => '',
						'file_store_path' => tree_path($folder_id),
						'file_real_name' => $file_name,
						'file_md5' => '',
						'server_oid' => 0,
						'file_size' => $file['size'],
						'thumb_size' => 0,
						'file_time' => filemtime($v),
						'is_checked' => 1,
						'in_share' => 0,
						'is_public' => 0,
						'report_status' => 0,
						'userid' => $pd_uid,
						'folder_id' => $folder_id,
						'ip' => $onlineip,
					);
					$db->query_unbuffered("insert into {$tpf}files set ".$db->sql_array($ins).";");
				}
			}	
		}elseif(is_dir($v)){
			$v2 = is_utf8() ? convert_str('gbk','utf-8',$v2) : $v2;
			$folder_name = $db->escape($v2);
			$num = $db->result_first("select count(*) from {$tpf}folders where userid='$pd_uid' and folder_name='$folder_name' and parent_id='$folder_id' and folder_node='$folder_node'");
			if(!$num){
				$ins = array(
					'folder_name' => $folder_name,
					'folder_description' => '',
					'parent_id' => $folder_id,
					'folder_node' => $folder_node,
					'userid' => $pd_uid,
					'in_time' => $timestamp,
				);
				$db->query_unbuffered("insert into {$tpf}folders set ".$db->sql_array($ins).";");
			}
		}
	}
}

?>