<?php 
##
#	Project: PHPDISK File Storage Solution
#	This is NOT a freeware, use is subject to license terms.
#
#	Site: http://www.phpdisk.com
#
#	$Id: cache.func.php 11 2011-06-08 12:00:43Z along $
#
#	Copyright (C) 2008-2011 PHPDisk Team. All Rights Reserved.
#
##

if(!defined('IN_PHPDISK')) {
	exit('[PHPDisk] Access Denied');
}
function stats_cache($arr=0){
	global $db,$tpf;
	if(is_array($arr)){
		foreach($arr as $k => $v){
			$v = str_replace(array("'",'\\'),'',$v);
			$sqls .= "('$k','".$db->escape(trim($v))."'),";
		}
		$sqls = substr($sqls,0,-1);
		$db->query("replace into {$tpf}stats (vars,value) values $sqls;");
	}
	
	$q = $db->query("select * from {$tpf}stats order by vars ");
	while($rs = $db->fetch_array($q)){
		$str_c .= "\t'".$rs['vars']."' => '".$rs['value']."',".LF;
	}
	$db->free($q);
	unset($rs);
	
	$str = "<?php".LF.LF;
	$str .= "// This is PHPDISK auto-generated file. Do NOT modify me.".LF;
	$str .= "// Cache Time: ".date("Y-m-d H:i:s").LF.LF;
	$str .= "\$stats = array(".LF;
	$str .= $str_c;
	$str .= ");".LF.LF;
	$str .= "?>".LF;
	
	write_file(PHPDISK_ROOT."./system/stats.inc.php",$str);

}
function settings_cache($arr=0){
	global $db,$tpf,$configs,$settings;
	if(is_array($arr)){
		foreach($arr as $k => $v){
			$v = str_replace(array("'",'\\'),'',$v);
			$sqls .= "('$k','".$db->escape(trim($v))."'),";
		}
		$sqls = substr($sqls,0,-1);
		$db->query("replace into `{$configs['dbname']}`.{$tpf}settings (vars,value) values $sqls;");
	}
	$q = $db->query("select * from `{$configs['dbname']}`.{$tpf}settings order by vars ");
	while($rs = $db->fetch_array($q)){
		$str_c .= "\t'".$rs['vars']."' => '".$rs['value']."',".LF;
	}
	$db->free($q);
	unset($rs);
	
	$str = "<?php".LF.LF;
	$str .= "// This is PHPDISK auto-generated file. Do NOT modify me.".LF;
	$str .= "// Cache Time: ".date("Y-m-d H:i:s").LF.LF;
	$str .= "\$settings = array(".LF;
	$str .= $str_c;
	$str .= ");".LF.LF;
	$str .= "?>".LF;
	
	write_file(PHPDISK_ROOT."./system/settings.inc.php",$str);
	
	$q = $db->query("select server_host,server_key from {$tpf}servers where server_oid>1",'SILENT');
	while($q && $rs = $db->fetch_array($q)){
		echo '<script type="text/javascript" src="'.$rs['server_host'].'update_configs.php?code='.pd_encode($rs['server_key']).'"></script>';
	}
	$db->free($q);
	unset($rs);
}

function group_settings_cache(){
	global $db,$tpf;

	$q = $db->query("select * from {$tpf}groups order by gid");
	while($rs = $db->fetch_array($q)){
		$str_c .= "\t'".$rs['gid']."' => array(".LF;
		$str_c .= "\t\t'max_messages' => '".$rs['max_messages']."',".LF;
		$str_c .= "\t\t'max_flow_down' => '".$rs['max_flow_down']."',".LF;
		$str_c .= "\t\t'max_flow_view' => '".$rs['max_flow_view']."',".LF;
		$str_c .= "\t\t'max_storage' => '".$rs['max_storage']."',".LF;
		$str_c .= "\t\t'max_filesize' => '".$rs['max_filesize']."',".LF;
		$str_c .= "\t\t'group_file_types' => '".$rs['group_file_types']."',".LF;
		$str_c .= "\t\t'max_folders' => '".$rs['max_folders']."',".LF;
		$str_c .= "\t\t'max_files' => '".$rs['max_files']."',".LF;
		$str_c .= "\t\t'can_share' => '".$rs['can_share']."',".LF;
		$str_c .= "\t\t'secs_loading' => '".$rs['secs_loading']."',".LF;
		$str_c .= "\t\t'server_ids' => '".$rs['server_ids']."',".LF;
		$str_c .= "\t),".LF.LF;
		
	}
	$db->free($q);
	unset($rs);
	
	$str = "<?php".LF.LF;
	$str .= "// This is PHPDISK auto-generated file. Do NOT modify me.".LF;
	$str .= "// Cache Time: ".date("Y-m-d H:i:s").LF.LF;
	$str .= "\$group_settings = array(".LF;
	$str .= $str_c;
	$str .= ");".LF.LF;
	$str .= "?>".LF;
	
	write_file(PHPDISK_ROOT."./system/group_settings.inc.php",$str);
	
	$q = $db->query("select server_host,server_key from {$tpf}servers where server_oid>1",'SILENT');
	while($q && $rs = $db->fetch_array($q)){
		echo '<script type="text/javascript" src="'.$rs['server_host'].'update_configs.php?code='.pd_encode($rs['server_key']).'"></script>';
	}
	$db->free($q);
	unset($rs);
	
}
function update_remote_settings(){
	global $db,$tpf,$configs,$settings;
	$q = $db->query("select server_host,server_key from {$tpf}servers where server_oid>1",'SILENT');
	while($q && $rs = $db->fetch_array($q)){
		echo '<script type="text/javascript" src="'.$rs['server_host'].'update_configs.php?code='.pd_encode($rs['server_key']).'"></script>';
	}
	$db->free($q);
	unset($rs);
}

function update_remote_group_settings(){
	global $db,$tpf;
	$q = $db->query("select server_host,server_key from {$tpf}servers where server_oid>1",'SILENT');
	while($q && $rs = $db->fetch_array($q)){
		echo '<script type="text/javascript" src="'.$rs['server_host'].'update_configs.php?code='.pd_encode($rs['server_key']).'"></script>';
	}
	$db->free($q);
	unset($rs);
}

function get_option_folders($deep=4){
	global $db,$tpf,$L,$pd_uid;
	
	$cache_dir = PHPDISK_ROOT."system/cache/$pd_uid/";
	make_dir($cache_dir);
	
	$q = $db->query("select folder_node,folder_id,folder_name,folder_description,parent_id from {$tpf}folders where userid='$pd_uid' and in_recycle=0 order by folder_order asc,in_time asc");
	while($rs = $db->fetch_array($q)){
		$folders[] = $rs;
	}
	$db->free($q);
	unset($rs);

	$str_c = '<option value=\'0\' style=\'color:#0000FF\' id=\'fd_0\'>'.$L['root_folder'].'</option>'.LF;
	for($i = 0; $i < count($folders); $i++) {
		if($folders[$i]['folder_node'] == 1) {
			$str_c .= '<option value=\''.$folders[$i]['folder_id'].'\' id=\'fd_'.$folders[$i]['folder_id'].'\'>'.$folders[$i]['folder_name'].'</option>'.LF;
			for($j = 0; $j < count($folders); $j++) {
				if($folders[$j]['parent_id'] == $folders[$i]['folder_id'] && $folders[$j]['folder_node'] == 2) {
					$str_c .= '<option value=\''.$folders[$j]['folder_id'].'\' id=\'fd_'.$folders[$j]['folder_id'].'\'>'.str_repeat('&nbsp;',4).$folders[$j]['folder_name'].'</option>'.LF;
					for($k = 0; $k < count($folders); $k++) {
						if($folders[$k]['parent_id'] == $folders[$j]['folder_id'] && $folders[$k]['folder_node'] == 3) {
							$str_c .= '<option value=\''.$folders[$k]['folder_id'].'\' id=\'fd_'.$folders[$k]['folder_id'].'\'>'.str_repeat('&nbsp;',8).$folders[$k]['folder_name'].'</option>'.LF;
							if($deep ==4){
								for($l=0;$l<count($folders);$l++){
									if($folders[$l]['parent_id'] == $folders[$k]['folder_id'] && $folders[$l]['folder_node'] == 4) {
										$str_c .= '<option value=\''.$folders[$l]['folder_id'].'\' id=\'fd_'.$folders[$l]['folder_id'].'\'>'.str_repeat('&nbsp;',12).$folders[$l]['folder_name'].'</option>'.LF;
									}
								}
							}
						}
					}
				}
			}
		}
	}
	return $str_c;
}

function folders_menu_cache(){
	global $db,$tpf,$L,$pd_uid;
	
	$cache_dir = PHPDISK_ROOT."system/cache/$pd_uid/";
	make_dir($cache_dir);
	
	$num = (int)@$db->result_first("select count(*) from {$tpf}files where folder_id=-1 and in_recycle=0 and userid='$pd_uid'");
	$folder_size = @$db->result_first("select sum(file_size) from {$tpf}files where folder_id=-1 and in_recycle=0 and userid='$pd_uid'");
	$count = $num ? $L['all_file']."$num , ".$L['folder_size'].get_size($folder_size) : '';

	$str_c = "tr.add(0,-1,'{$L['mydisk_cp_manage']}','".urr("mydisk","item=files&action=index")."','{$count}','mainframe');".LF;

	$q = $db->query("select folder_id,parent_id,folder_name,folder_node,folder_size from {$tpf}folders where userid='$pd_uid' and in_recycle=0 order by folder_order asc,in_time asc");
	while($rs = $db->fetch_array($q)){
		$num = (int)@$db->result_first("select count(*) from {$tpf}files where folder_id='{$rs['folder_id']}' and userid='$pd_uid'");
		$count = $num ? $L['all_file']."$num , ".$L['folder_size'].get_size($rs['folder_size']) : '';
		$rs['parent_id'] = $rs['parent_id']==-1 ? 0 : (int)$rs['parent_id'];
		$str_c .= "tr.add({$rs['folder_id']},{$rs['parent_id']},'{$rs['folder_name']}','".urr("mydisk","item=files&action=index&folder_node={$rs['folder_node']}&folder_id={$rs['folder_id']}")."','{$count}','mainframe');".LF;
	}
	$db->free($q);
	unset($rs);
	return $str_c;
}
function public_menu_cache($front=0){
	global $db,$tpf,$L,$pd_uid;
	if($front){
		$str_c = "tr.add(0,-1,'{$L['public_file_list']}','".urr("public","")."');".LF;
	}else{
		$str_c = "tr.add(0,-1,'{$L['public_file_manage']}','###');".LF;
	}

	$q = $db->query("select * from {$tpf}categories where is_hidden=0 order by show_order asc,cate_id asc");
	while($rs = $db->fetch_array($q)){
		$num = @$db->result_first("select count(*) from {$tpf}files where cate_id='{$rs['cate_id']}' or subcate_id='{$rs['cate_id']}' and in_recycle=0 and is_public=1 and cate_id>0 and userid>0 ");
		if($front){
			$str_c .= "tr.add({$rs['cate_id']},{$rs['pid']},'{$rs['cate_name']}','".urr("public","pid={$rs['pid']}&cate_id={$rs['cate_id']}")."','".$num."','');".LF;
		}else{
			$str_c .= "tr.add({$rs['cate_id']},{$rs['pid']},'{$rs['cate_name']}','".urr("mydisk","item=public&action=index&pid={$rs['pid']}&id={$rs['cate_id']}")."','".$num."','mainframe');".LF;
		}
	}
	$db->free($q);
	unset($rs);

	return $str_c;

}
function get_option_public_folder(){
	global $db,$tpf;

	$q = $db->query("select * from {$tpf}categories where is_hidden=0 order by show_order asc,cate_id asc");
	while($rs = $db->fetch_array($q)){
		$folders[] = $rs;
	}
	$db->free($q);
	unset($rs);

	for($i = 0; $i < count($folders); $i++) {
		if($folders[$i]['pid'] == 0) {
			$str_c .= '<option value=\''.$folders[$i]['cate_id'].'\'>'.$folders[$i]['cate_name'].'</option>'.LF;
			for($j = 0; $j < count($folders); $j++) {
				if($folders[$j]['pid'] == $folders[$i]['cate_id'] && $folders[$j]['pid'] <> 0) {
					$str_c .= '<option value=\''.$folders[$j]['cate_id'].'\'>'.str_repeat('&nbsp;',4).$folders[$j]['cate_name'].'</option>'.LF;
				}
			}
		}
	}

	return $str_c;
}
function super_cache($cache_type,$func,$open=1,$echo=1,$uid=0,$expire=0){
	global $timestamp;

	$cache_dir = PHPDISK_ROOT.'system/cache/';
	if(strpos($uid,'|')===false){
		$file_dir = $uid ? $cache_dir.$uid.'/' : $cache_dir.'public/';
	}else{
		// $uid format : folder_name|time
		$arr = explode('|',$uid);
		$file_dir = $cache_dir.$arr[0].'/'.date('Ymd',$arr[1]).'/';
	}

	make_dir($file_dir);

	if(strpos($func,'<')===false){
		if(strpos($func,'|')===false){
			$id = $func;
			$param = '';
		}else{
			$t = explode('|',$func);
			$id = str_replace('|','-',$func);
			$func = $t[0];
			$param = $t[1];
		}
	}else{
		$tmp = explode('<',$func);
		if(strpos($tmp[1],'|')===false){
			$id = $tmp[0];
			$func = $tmp[1];
			$param = '';
		}else{
			$t = explode('|',$tmp[1]);
			$id = str_replace('|','-',$tmp[0]);
			$func = $t[0];
			$param = $t[1];
		}
	}
	$file = $file_dir.'__phpdisk_'.$cache_type.'_'.$id.'__cache.php';
	if($open){
		if($echo){
			if(file_exists($file) && $expire=='0'){
				@include_once($file);
			}else{
				if(!file_exists($file) || $timestamp-filemtime($file)>$expire){
					if($param){
						if(function_exists($func)){
							echo call_user_func($func,$param);
							make_cache($cache_type,$id,call_user_func($func,$param),$uid);
						}else{
							echo '['.$func.'] not exists:1';
						}
					}else{
						if(function_exists($func)){
							echo call_user_func($func);
							make_cache($cache_type,$id,call_user_func($func),$uid);
						}else{
							echo '['.$func.'] not exists:2';
						}
					}
				}else{
					@include_once($file);
				}
			}
		}else{
			if(file_exists($file) && $expire=='0'){
				return @include_once($file);
			}else{
				if(!file_exists($file) || $timestamp-filemtime($file)>$expire){
					if($param){
						if(function_exists($func)){
							make_cache($cache_type,$id,call_user_func($func,$param),$uid,0);
							return call_user_func($func,$param);
						}else{
							return '['.$func.'] not exists:3';
						}
					}else{
						if(function_exists($func)){
							make_cache($cache_type,$id,call_user_func($func),$uid,0);
							return call_user_func($func);
						}else{
							return '['.$func.'] not exists:4';
						}
					}
				}else{
					return @include_once($file);
				}
			}
		}
	}
}
function update_cache($cache_type,$ids='',$uid=0){
	$cache_dir = PHPDISK_ROOT.'system/cache/';

	if(strpos($uid,'|')===false){
		$file_dir = $uid ? $cache_dir.$uid.'/' : $cache_dir.'public/';
	}else{
		// $uid format : folder_name|time
		$arr = explode('|',$uid);
		$file_dir = $cache_dir.$arr[0].'/'.date('Ymd',$arr[1]).'/';
	}
	if($ids){
		$ids = str_replace('|','-',$ids);
		$arr = strpos($ids,'#')===false ? $ids : explode('#',$ids);
		if(is_array($arr)){
			for($i=0;$i<count($arr);$i++){
				$file = $file_dir.'__phpdisk_'.$cache_type.'_'.$arr[$i].'__cache.php';
				@unlink($file);
			}
		}else{
			@unlink($file_dir.'__phpdisk_'.$cache_type.'_'.$arr.'__cache.php');
		}
	}else{
		$arr = glob($file_dir.'__phpdisk_'.$cache_type.'_*__cache.php');
		foreach ($arr as $v){
			@unlink($v);
		}
	}
	return true;
}
function make_cache($cache_type,$id,$cache_str,$uid=0,$echo=1){

	$cache_dir = PHPDISK_ROOT.'system/cache/';

	if(strpos($uid,'|')===false){
		$file_dir = $uid ? $cache_dir.$uid.'/' : $cache_dir.'public/';
	}else{
		// $uid format : folder_name|time
		$arr = explode('|',$uid);
		$file_dir = $cache_dir.$arr[0].'/'.date('Ymd',$arr[1]).'/';
	}
	make_dir($file_dir);

	$file = $file_dir.'__phpdisk_'.$cache_type.'_'.$id.'__cache.php';
	if($cache_str){
		if($echo){
			$str = "<?php".LF.LF;
			$str .= "// This is PHPDISK auto-generated file. Do NOT modify me.".LF;
			$str .= "// Cache Time: ".date("Y-m-d H:i:s").LF.LF;
			$str .=	"if(!defined('IN_PHPDISK')){".LF;
			$str .= "\texit('[PHPDisk] Access Denied');".LF;
			$str .= "}".LF.LF;
			$str .= "print <<<SUPERCACHE".LF;
			$str .= $cache_str.LF;
			$str .= "SUPERCACHE;".LF;
			$str .= "?>".LF;
		}else{
			$str = "<?php".LF.LF;
			$str .= "// This is PHPDISK auto-generated file. Do NOT modify me.".LF;
			$str .= "// Cache Time: ".date("Y-m-d H:i:s").LF.LF;
			$str .=	"if(!defined('IN_PHPDISK')){".LF;
			$str .= "\texit('[PHPDisk] Access Denied');".LF;
			$str .= "}".LF.LF;
			$str .= "return ".var_export($cache_str,true).';'.LF;
			$str .= "?>".LF;
		}
		write_file($file,$str);
	}
}
?>