<?php 
/**
#	Project: PHPDISK File Storage Solution
#	This is NOT a freeware, use is subject to license terms.
#
#	Site: http://www.phpdisk.com
#
#	$Id: commons.inc.php 12 2011-06-14 01:54:33Z along $
#
#	Copyright (C) 2008-2011 PHPDisk Team. All Rights Reserved.
#
*/
function get_runtime($start,$end='') {
	static $_ps_time = array();
	if(!empty($end)) {
		if(!isset($_ps_time[$end])) {
			$mtime = explode(' ', microtime());
		}
		return number_format(($mtime[1] + $mtime[0] - $_ps_time[$start]), 6);
	}else{
		$mtime = explode(' ', microtime());
		$_ps_time[$start] = $mtime[1] + $mtime[0];
	}
}
get_runtime('start');
session_start();
$C = $L = $settings = $sysmsg = array();
if(strtoupper(substr(PHP_OS, 0, 3)) === 'WIN') {
	define('LF',"\r\n");
}else{
	define('LF',"\n");
}
define('NOW_YEAR','2011');
define('PHPDISK_ROOT', substr(dirname(__FILE__), 0, -8));
define('PD_PLUGINS_DIR',PHPDISK_ROOT.'plugins/');
define('IN_PHPDISK',TRUE);
define('SERVER_NAME',$_SERVER['SERVER_NAME']);

if(function_exists('date_default_timezone_set')){
	@date_default_timezone_set('Asia/Shanghai');
}
$timestamp = time();
@set_magic_quotes_runtime(0);

$installed_file = PHPDISK_ROOT.'system/install.lock';
if(!file_exists($installed_file)){
	header("Location: ./install/index.php");
	exit;
}

$config_file = PHPDISK_ROOT.'system/configs.inc.php';
if(!file_exists($config_file)){
	header("Location: ./install/index.php");
	exit;
}else{
	require($config_file);
}
$tpf = $configs['tpf'];
// for debug;
$C['set']['debug'] = $configs['debug'];
define('DEBUG',$C['set']['debug'] ? true : false);
if(DEBUG){
	error_reporting(E_ALL ^ E_NOTICE);
	@ini_set('display_errors', 'On');
}else{
	error_reporting(0);
	@ini_set('display_errors', 'Off');
}

$charset = $configs['charset'];
$charset_arr = array('gbk' => 'gbk','utf-8' => 'utf8');
$db_charset = $charset_arr[strtolower($configs['charset'])];
header("Content-Type: text/html; charset=$charset");

$arr = array('global','plugin','ftp','file','cache','image','extend');
for ($i=0;$i<count($arr);$i++){
	require(PHPDISK_ROOT.'includes/function/'.$arr[$i].'.func.php');
}
$arr = array('core','mysql','zip','phpmailer','smtp');
for ($i=0;$i<count($arr);$i++){
	require(PHPDISK_ROOT.'includes/class/'.$arr[$i].'.class.php');
}

if(file_exists(PHPDISK_ROOT.'includes/auth.inc.php')){
	require PHPDISK_ROOT.'includes/auth.inc.php';
}
require PHPDISK_ROOT.'includes/phpdisk_version.inc.php';

phpdisk_core::init_core();
$db = phpdisk_core::init_db_connect();

$setting_file = PHPDISK_ROOT.'system/settings.inc.php';
file_exists($setting_file) ? require_once $setting_file : settings_cache();

$C['gz']['open'] = $settings['gzipcompress'];
phpdisk_core::gzcompress_open();
$arr = phpdisk_core::init_lang_tpl();
$user_tpl_dir = $arr['user_tpl_dir'];
$admin_tpl_dir = $arr['admin_tpl_dir'];
$C['lang_type'] = $arr['lang_name'];

lang('common');

load_active_plugins();

if(@get_magic_quotes_gpc()){
	$_GET = stripslashes_array($_GET);
	$_POST = stripslashes_array($_POST);
	$_COOKIE = stripslashes_array($_COOKIE);
}

$group_settings_file = PHPDISK_ROOT.'system/group_settings.inc.php';
file_exists($group_settings_file) ? require_once $group_settings_file : group_settings_cache();
$stats_file = PHPDISK_ROOT.'system/stats.inc.php';
file_exists($stats_file) ? require_once $stats_file : stats_cache();

list($pd_uid,$pd_gid,$pd_username,$pd_pwd,$pd_email) = gpc('phpdisk_tcore_info','C','') ? explode("\t", pd_encode(gpc('phpdisk_tcore_info','C',''), 'DECODE')) : array('', '', '','','');
$pd_uid = (int)$pd_uid;
if(!$pd_uid || !$pd_pwd){
	$pd_uid = 0;
}else{
	$userinfo = $db->fetch_one_array("select userid,u.gid,username,password,email,group_name,is_activated from {$tpf}users u,{$tpf}groups g where username='".$db->escape($pd_username)."' and u.gid=g.gid limit 1");
	if($userinfo){
		$pd_username = $userinfo['username'];
		$pd_email = $userinfo['email'];
		$pd_gid = $userinfo['gid'];
		$pd_group_name = $userinfo['group_name'];
		$pd_is_activated = $userinfo['is_activated'];
	}else{
		$pd_uid = 0;
		$pd_pwd = '';
		pd_setcookie('phpdisk_tcore_info', '');
	}
}
unset($userinfo);

if(display_plugin('api','open_uc_plugin',$settings['connect_uc'],0)){
	define('P_W','admincp');
	$uc_conf = PD_PLUGINS_DIR.'api/uc_configs.inc.php';
	file_exists($uc_conf) ? require_once $uc_conf : exit($L['not_uc_conf'].$uc_conf);
	$uc_client = $settings['connect_uc_type']=='phpwind' ? PD_PLUGINS_DIR.'api/pw_client/uc_client.php' : PD_PLUGINS_DIR.'api/uc_client/client.php';
	file_exists($uc_client) ? require_once $uc_client : exit($L['not_uc_client'].$uc_client);
}

$news_url = $auth['com_news_url'] ? $auth['com_news_url'] : 'http://www.phpdisk.com/m_news/tcore_idx.php';
$upgrade_url = $auth['com_upgrade_url'] ? $auth['com_upgrade_url'] : 'http://www.phpdisk.com/autoupdate/tcore_last_version.php';

$onlineip = get_ip();

$pg = (int)gpc('pg','G',0);
!$pg &&	$pg = 1;
$perpage = $C['set']['perpage'] ? (int)$C['set']['perpage'] : 20;

$error = false;
$item = trim(gpc('item','GP',''));
$app = trim(gpc('app','GP',''));
$action = trim(gpc('action','GP',''));
$task = trim(gpc('task','GP',''));
$p_formhash = trim(gpc('formhash','P',''));

$pd_uid && update_rank();
$formhash = formhash();

$lang_page = array('index','extract','public','tag','space','mydisk','search','payment','viewfile','comment');
$tmp = explode('.',substr(strrchr($_SERVER['SCRIPT_NAME'],'/'),1));
$script = $tmp[0];
if(in_array($script,$lang_page)){
	$uri = $_SERVER['REQUEST_URI'];
	$t_arr = explode('?lang=',$uri);
	$uri_pre = strpos($uri,'?lang=')===false ? $uri : $t_arr[0];
	$tmp = explode('?',$uri_pre);
	$tmp = str_replace('/','_',$tmp[0]);

	$langs_sw = super_cache('lang','select_lang_'.$tmp.'<select_lang|'.$uri_pre,1,0);
}
function select_lang($script=''){
	global $db,$tpf;
	$q = $db->query("select * from {$tpf}langs order by actived desc");
	$langs_sw = array();
	while($rs = $db->fetch_array($q)){
		$rs['lang_href'] = $script.'?lang='.$rs['lang_name'];
		$langs_sw[] = $rs;
	}
	$db->free($q);
	unset($rs);
	return $langs_sw;
}
?>