<?php
/**
#	Project: PHPDISK File Storage Solution
#	This is NOT a freeware, use is subject to license terms.
#
#	Site: http://www.phpdisk.com
#
#	$Id: datacall.php 2 2011-05-27 02:59:23Z along $
#
#	Copyright (C) 2008-2011 PHPDisk Team. All Rights Reserved.
#
*/

include '../includes/commons.inc.php';

$type = trim(gpc('type','G',''));
$order = trim(gpc('order','G',''));
$by = trim(gpc('by','G',''));
$limit = (int)gpc('limit','G',0);

if(!$type || !$order || !$by || !$limit){
	echo 'Datacall Parameter is null or Error!';
	exit;
}
if($type=='user'){
	echo '<ul>'.LF;
	$q = $db->query("select username,userid from {$tpf}users order by $order $by limit $limit");
	while ($rs = $db->fetch_array($q)) {
		echo '<li><a href="'.$settings['phpdisk_url'].urr("space","username=".rawurlencode($rs['username'])).'" target="_blank">'.$rs['username'].'</a></li>'.LF;
	}
	echo '</ul>'.LF;
	$db->free($q);
	unset($rs);
	
}elseif($type =='file'){
	echo '<ul>'.LF;
	$q = $db->query("select file_name,file_id,file_extension from {$tpf}files order by $order $by limit $limit");
	while ($rs = $db->fetch_array($q)) {
		echo '<li>'.d_file_icon($rs['file_extension']).'<a href="'.$settings['phpdisk_url'].urr("viewfile","file_id=".($rs['file_id'])).'"  target="_blank">'.get_file_name($rs['file_name'],$rs['file_extension']).'</a></li>'.LF;
	}
	echo '</ul>'.LF;
	$db->free($q);
	unset($rs);
}
$db->close();

function d_file_icon($ext,$fd = 'filetype',$align='absmiddle'){
	$icon = PHPDISK_ROOT."images/{$fd}/".$ext.".gif";
	if(file_exists($icon)){
		$img = "<img src='../images/{$fd}/{$ext}.gif' align='{$align}' border='0' />";
	}else{
		$img = "<img src='../images/{$fd}/file.gif' align='{$align}' border='0' />";
	}
	return $img;
}

?>