<?php 
/**
#	Project: PHPDISK File Storage Solution
#	This is NOT a freeware, use is subject to license terms.
#
#	Site: http://www.phpdisk.com
#
#	$Id: sitemap.inc.php 2 2011-05-27 02:59:23Z along $
#
#	Copyright (C) 2008-2011 PHPDisk Team. All Rights Reserved.
#
*/

if(!defined('IN_PHPDISK') || !defined('IN_ADMINCP')) {
	exit('[PHPDisk] Access Denied');
}
lang('admin/sitemap');

switch($action){
	case 'add_shortcut':
		$title = rawurldecode(trim(gpc('title','G','')));
		$url = base64_decode(trim(gpc('url','G','')));

		$num = $db->result_first("select count(*) from {$tpf}cp_shortcut where url='".$db->escape($url)."'");
		if($num){
			$error = true;
			$sysmsg[] = $L['cp_shortcut_exists'];
		}
		if(!$error){
			$ins = array(
			'title' => $db->escape($title),
			'url' => $db->escape($url),
			);
			$db->query_unbuffered("insert into {$tpf}cp_shortcut set ".$db->sql_array($ins).";");
			$sysmsg[] = $L['add_sitemap_success'];
			redirect('back',$sysmsg);
		}else{
			redirect('back',$sysmsg);
		}

		break;
	case 'setting':
		if($task =='setting'){
			form_auth(gpc('formhash','P',''),formhash());

			$ids = gpc('ids','P',array());
			$ids_arr = get_ids_arr($ids,$L['please_select_operation_menus']);
			if($ids_arr[0]){
				$error = true;
				$sysmsg[] = $ids_arr[1];
			}else{
				$ids_str = $ids_arr[1];
			}		
			if(!$error){
				$db->query_unbuffered("delete from {$tpf}cp_shortcut where id in ($ids_str)");
				$num = $db->result_first("select count(*) from {$tpf}cp_shortcut");
				if(!$num){
					$db->query_unbuffered("truncate table {$tpf}cp_shortcut;");
				}
				reload_leftframe('admincp','');
				$sysmsg[] = $L['del_cp_shortcut_success'];
				redirect(urr("admincp","item=$item&action=$action"),$sysmsg);
			}else{
				redirect('back',$sysmsg);
			}
		}else{
			$q = $db->query("select * from {$tpf}cp_shortcut");
			$cs_menus = array();
			while($rs = $db->fetch_array($q)){
				$cs_menus[] = $rs;
			}
			$db->free($q);
			unset($rs);
			
			require_once template_echo($item,$admin_tpl_dir,'',1);
		}
		break;
	default:

		$cp_menus = array(

		'settings' => array(
		'title' => $L['menu_site_setting'],
		'sub_title' => $L['menu_site_setting'],
		'data' => array(
		array('menu'=>$L['menu_base_setting'],'url'=>urr("admincp","item=settings&action=base")),
		array('menu'=>$L['menu_advanced_setting'],'url'=>urr("admincp","item=settings&action=advanced")),
		array('menu'=>$L['menu_other_setting'],'url'=>urr("admincp","item=settings&action=other"))
		),
		),

		'users' => array(
		'title' => $L['menu_user_setting'],
		'sub_title' => $L['menu_user_setting'],
		'data' => array(
		array('menu'=>$L['menu_add_user'],'url'=>urr("admincp","item=users&action=add_user")),
		array('menu'=>$L['menu_user_group'],'url'=>urr("admincp","item=groups&action=index")),
		array('menu'=>$L['menu_user_manage'],'url'=>urr("admincp","item=users&action=index")),
		array('menu'=>$L['menu_user_active'],'url'=>urr("admincp","item=users&action=active"))
		),
		),
		'email' => array(
		'sub_title' => $L['menu_email'],
		'data' => array(
		array('menu'=>$L['menu_email_setting'],'url'=>urr("admincp","item=email&action=setting")),
		array('menu'=>$L['menu_email_test'],'url'=>urr("admincp","item=email&action=mail_test")),
		),
		),
		'verycode' => array(
		'sub_title' => $L['menu_other'],
		'data' => array(
		array('menu'=>$L['menu_verycode'],'url'=>urr("admincp","item=verycode")),
		),
		),

		'files' => array(
		'title' => $L['menu_files'],
		'sub_title' => $L['menu_files'],
		'data' => array(
		array('menu'=>$L['menu_files_list'],'url'=>urr("admincp","item=files&action=index")),
		array('menu'=>$L['menu_tag'],'url'=>urr("admincp","item=tag")),
		),
		),

		'public' => array(
		'sub_title' => $L['menu_public'],
		'data' => array(
		array('menu'=>$L['menu_public_setting'],'url'=>urr("admincp","item=public")),
		array('menu'=>$L['menu_public_category'],'url'=>urr("admincp","item=public&action=category")),
		array('menu'=>$L['menu_public_viewfile'],'url'=>urr("admincp","item=public&action=viewfile")),
		),
		),

		'report' => array(
		'sub_title' => $L['menu_report'],
		'data' => array(
		array('menu'=>$L['menu_report_setting'],'url'=>urr("admincp","item=report")),
		array('menu'=>$L['menu_report_user'],'url'=>urr("admincp","item=report&action=user")),
		array('menu'=>$L['menu_report_system'],'url'=>urr("admincp","item=report&action=system")),
		array('menu'=>$L['menu_report_file_unlocked'],'url'=>urr("admincp","item=report&action=file_unlocked")),
		),
		),

		'plugin' => array(
		'title' => $L['menu_plugins_manage'],
		'sub_title' => $L['menu_plugins_cp'],
		'data' => array(
		array('menu'=>$L['menu_plugins_index'],'url'=>urr("admincp","item=plugins")),
		array('menu'=>$L['menu_plugins_cp_setting'],'url'=>urr("admincp","item=plugins&action=shortcut")),
		),
		),

		'tpl' => array(
		'title' => $L['menu_template_language'],
		'sub_title' => $L['menu_template_language'],
		'data' => array(
		array('menu'=>$L['menu_lang_manage'],'url'=>urr("admincp","item=lang")),
		array('menu'=>$L['menu_template_manage'],'url'=>urr("admincp","item=templates")),
		),
		),

		'extend' => array(
		'title' => $L['menu_extend_tools'],
		'sub_title' => $L['menu_extend'],
		'data' => array(
		array('menu'=>$L['menu_adv_manage'],'url'=>urr("admincp","item=advertisement")),
		array('menu'=>$L['menu_link_manage'],'url'=>urr("admincp","item=link")),
		array('menu'=>$L['menu_announce_manage'],'url'=>urr("admincp","item=announce")),
		array('menu'=>$L['menu_navigation_manage'],'url'=>urr("admincp","item=navigation")),
		array('menu'=>$L['menu_credit_manage'],'url'=>urr("admincp","item=credit")),
		array('menu'=>$L['menu_comment_manage'],'url'=>urr("admincp","item=comment")),
		array('menu'=>$L['menu_seo_manage'],'url'=>urr("admincp","item=seo")),
		array('menu'=>$L['menu_union_manage'],'url'=>urr("admincp","item=union")),
		array('menu'=>$L['menu_gallery_manage'],'url'=>urr("admincp","item=gallery")),
		),
		),
		'datacall' => array(
		'sub_title' => $L['menu_datacall_manage'],
		'data' => array(
		array('menu'=>$L['menu_datacall_js'],'url'=>urr("admincp","item=datacall&action=js")),
		array('menu'=>$L['menu_datacall_sql'],'url'=>urr("admincp","item=datacall&action=sql")),
		array('menu'=>$L['menu_datacall_arr'],'url'=>urr("admincp","item=datacall&action=arr")),
		),
		),
		'database' => array(
		'title' => $L['menu_system_tools'],
		'sub_title' => $L['menu_database_manage'],
		'data' => array(
		array('menu'=>$L['menu_database_optimize'],'url'=>urr("admincp","item=database&action=optimize")),
		array('menu'=>$L['menu_database_backup'],'url'=>urr("admincp","item=database&action=backup")),
		array('menu'=>$L['menu_database_restore'],'url'=>urr("admincp","item=database&action=restore")),
		),
		),
		'tools' => array(
		'sub_title' => $L['menu_system_setting'],
		'data' => array(
		array('menu'=>$L['menu_search_index'],'url'=>urr("admincp","item=cache&action=search_index")),
		array('menu'=>$L['menu_cache_manage'],'url'=>urr("admincp","item=cache&action=update")),
		array('menu'=>$L['menu_version_check'],'url'=>urr("admincp","item=version")),
		),
		),
		);
		require_once template_echo($item,$admin_tpl_dir,'',1);
}
?>