<?php 
/**
#	Project: PHPDISK File Storage Solution
#	This is NOT a freeware, use is subject to license terms.
#
#	Site: http://www.phpdisk.com
#
#	$Id: core.class.php 2 2011-05-27 02:59:23Z along $
#
#	Copyright (C) 2008-2011 PHPDisk Team. All Rights Reserved.
#
*/
!defined('IN_PHPDISK') && exit('[PHPDisk] Access Denied');

class phpdisk_core{
	function init_core(){
		phpdisk_core::__init_env();
	}
	function init_db_connect(){
		global $C,$configs;
		if(empty($C['dbc'])){
			$C['dbc'] = new cls_mysql();
			$C['dbc']->connect($configs['dbhost'],$configs['dbuser'],$configs['dbpasswd'],$configs['dbname'],$configs['pconnect']);
			unset($configs['dbhost'],$configs['dbuser'],$configs['dbpasswd'],$configs['pconnect']);
		}
		return $C['dbc'];
	}
	function __init_env(){
		$env_arr = array('system/','system/logs/','system/cache/','system/cache/public/','system/plugins/','system/logs/admincp/','system/templates/');
		for ($i=0;$i<count($env_arr);$i++){
			make_dir(PHPDISK_ROOT.$env_arr[$i]);
		}
	}
	function gzcompress_open(){
		global $C;
		if ($C['gz']['open'] && function_exists('ob_gzhandler')) {
			ob_start('ob_gzhandler');
			$C['gz']['status'] = 'Enabled';
		} else {
			ob_start();
			$C['gz']['status'] = 'Disabled';
		}
	}
	function init_lang_tpl(){
		global $db,$tpf,$C,$settings;
		function curr_tpl_name($tpl_type){
			global $db,$tpf;
			$tpl_name = @$db->result_first("select tpl_name from {$tpf}templates where tpl_type='$tpl_type' and actived=1");
			return $tpl_name;
		}
		$tpl_name = super_cache('tpl','curr_tpl_name|user',1,0);
		$user_tpl_dir = $tpl_name ? "templates/$tpl_name/" : 'templates/default/';
		$tpl_name = super_cache('tpl','curr_tpl_name|admin',1,0);
		$admin_tpl_dir = $tpl_name ? "templates/$tpl_name/" : 'templates/admin/';

		if($settings['open_switch_langs']){
			$mylang = gpc('mylang','C','');
			function langs_str(){
				global $db,$tpf;
				$q = $db->query("select * from {$tpf}langs order by actived desc");
				while($rs = $db->fetch_array($q)){
					$langs_str .= $rs['lang_name'].',';
				}
				$db->free($q);
				unset($rs);
				return $langs_str;
			}
			$langs_str = super_cache('lang','langs_str',1,0);
			if($langs_str){
				$langs_arr = explode(',',substr($langs_str,0,-1));
			}
			$uri = $_SERVER['REQUEST_URI'];
			$t_arr = explode('?lang=',$uri);
			if(in_array($t_arr[1],$langs_arr)){
				pd_setcookie('mylang',$t_arr[1]);
				$mylang = $t_arr[1];
			}
			$lang_name = $mylang ? $mylang : 'zh-cn';
		}else{
			function get_lang_name(){
				global $db,$tpf;
				$lang_name = @$db->result_first("select lang_name from {$tpf}langs where actived=1");
				return $lang_name;
			}
			$lang_name = super_cache('lang','get_lang_name',1,0);
			$lang_name = $lang_name ? $lang_name : 'zh-cn';
		}
		unset($tpl_name);
		return array('user_tpl_dir'=>$user_tpl_dir,'admin_tpl_dir'=>$admin_tpl_dir,'lang_name'=>$lang_name);
	}
	function user_login(){
		global $pd_uid,$pd_pwd;
		if(!$pd_uid || !$pd_pwd){
			header("Location: ".urr("account","action=login&ref=".$_SERVER['REQUEST_URI']));
		}
	}
	function admin_login(){
		global $C,$db,$tpf,$pd_uid,$pd_pwd,$pd_gid;
		$admin_not_login =0;
		$rs = $db->fetch_one_array("select * from {$tpf}adminsession where userid='$pd_uid' limit 1");
		if(!$_SESSION['pd_sid'] || $rs['hashcode'] != $_SESSION['pd_sid']){
			$admin_not_login =1;
		}
		unset($rs);
		if(!$pd_uid || !$pd_pwd || $pd_gid !=1 || $admin_not_login){
			header("Location: ".urr("account","action=adminlogin&ref=".$_SERVER['REQUEST_URI']));
			exit;
		}
	}

}

?>