<?php 
/**
#	Project: PHPDISK File Storage Solution
#	This is NOT a freeware, use is subject to license terms.
#
#	Site: http://www.phpdisk.com
#
#	$Id: templates.inc.php 2 2011-05-27 02:59:23Z along $
#
#	Copyright (C) 2008-2011 PHPDisk Team. All Rights Reserved.
#
*/

if(!defined('IN_PHPDISK') || !defined('IN_ADMINCP')) {
	exit('[PHPDisk] Access Denied');
}

lang('admin/templates');

switch($action){

	case 'tpl_detail':

		$tpl_id = $db->escape(trim(gpc('tpl_id','G','')));
		$actived = 0;
		$rs = $db->fetch_one_array("select * from {$tpf}templates where tpl_name='$tpl_id'");
		if($rs){
			$actived = $rs['actived'];
			$style_dir = $rs['tpl_name'];
		}
		unset($rs);
		$can_modify = $actived ? 1 : 0;

		$tpl_dir = PHPDISK_ROOT.'templates/'.$style_dir;
		$tpl_arr_t = tpl_list($tpl_dir);
		sort($tpl_arr_t);
		reset($tpl_arr_t);
		for($i=0;$i<count($tpl_arr_t);$i++){
			$tpl_arr['name'][] = $tpl_arr_t[$i];
			$tpl_arr['size'][] = get_size(filesize($tpl_dir.'/'.$tpl_arr_t[$i].'.tpl.html'));
		}

		if($task == 'make_all'){
			if($settings['online_demo']){
				$error = true;
				$sysmsg[] = $L['online_demo_deny'];
			}

			if(!$error){
				for($i=0;$i<count($tpl_arr_t);$i++){
					template_echo($tpl_arr_t[$i],'templates/'.$style_dir.'/');
				}
				$sysmsg[] = $L['all_tpl_make_success'];

				redirect(urr("admincp","item=templates"),$sysmsg);
			}else{
				redirect('back',$sysmsg);
			}

		}elseif($task == 'make_one'){
			if($settings['online_demo']){
				$error = true;
				$sysmsg[] = $L['online_demo_deny'];
			}

			$tpl_name = trim(gpc('tpl_name','G',''));

			if(!$error){
				if($tpl_name){
					template_echo($tpl_name,'templates/'.$style_dir.'/');
					$sysmsg[] = "[{$tpl_name}] ...... {$L['tpl_each_success']}";
				}else{
					$sysmsg[] = $L['tpl_not_exists'];
				}
				redirect(urr("admincp","item=templates"),$sysmsg);
			}else{
				redirect('back',$sysmsg);
			}

		}else{
			require_once template_echo($item,$admin_tpl_dir,'',1);
		}
		break;

	case 'active':
		$tpl_id = $db->escape(trim(gpc('tpl_id','G','')));

		$tpl_type = $db->result_first("select tpl_type from {$tpf}templates where tpl_name='$tpl_id'");
		$db->query_unbuffered("update {$tpf}templates set actived=0 where tpl_type='$tpl_type'");
		$db->query_unbuffered("update {$tpf}templates set actived=1 where tpl_name='$tpl_id'");
		update_cache('tpl');
		$sysmsg[] = $L['tpl_active_success'];
		redirect(urr("admincp","item=templates"),$sysmsg);

		break;

	case 'edit':

		$tpl_name = trim(gpc('tpl_name','GP',''));
		$tpl_id = gpc('tpl_id','GP','');
		$file = "./templates/$tpl_id/$tpl_name.tpl.html";
		$tpl_src_file = PHPDISK_ROOT."templates/$tpl_id/$tpl_name.tpl.html";
		$tpl_cache_file = PHPDISK_ROOT."system/templates/$tpl_id/$tpl_name.tpl.php";
		$tpl_name_current = $tpl_name.'.tpl.html';

		if($task =='edit'){

			$content = trim(gpc('content','P',''));

			if($settings['online_demo']){
				$error = true;
				$sysmsg[] = $L['online_demo_deny'];
			}
			if(!is_writable($tpl_src_file)){
				$error = true;
				$sysmsg[] = $L['tpl_update_fail'];
			}
			if(!$error){
				write_file($tpl_src_file,$content);

				write_file($tpl_cache_file,template_parse($tpl_src_file));

				$sysmsg[] = $L['user_tpl'].'&nbsp;<b>'.$tpl_name.'.tpl.html</b>&nbsp;'.$L['tpl_update_success'];
				redirect(urr("admincp","item=templates"),$sysmsg);
			}else{
				redirect('back',$sysmsg);
			}
		}else{
			if(file_exists($tpl_src_file)){
				$content = htmlspecialchars(read_file($tpl_src_file));
				$disabled = '';
			}else{
				$content = $file.LF.LF.$L['tpl_not_exists'];
				$disabled = 'disabled';
			}
			require_once template_echo($item,$admin_tpl_dir,'',1);
		}
		break;

	default:
		syn_templates();

		$q = $db->query("select * from {$tpf}templates order by tpl_type desc,actived desc,tpl_name asc");
		while($rs = $db->fetch_array($q)){
			if(check_template($rs['tpl_name'])){
				$templates_arr[] = get_template_info($rs['tpl_name']);
			}
		}
		$db->free($q);
		unset($rs);
		require_once template_echo($item,$admin_tpl_dir,'',1);

}

function tpl_list($tpl_dir){
	$tpl_arr = array();
	if ($fp = opendir($tpl_dir)) {
		while(($file = readdir($fp)) !== false) {
			if(get_extension($file) == 'html'){
				if(substr($file,0,1) != '.' && $file != 'images'){
					$tpl_arr[] = str_replace('.tpl.html','',$file);
				}
			}
		}
		closedir($fp);
	}
	return $tpl_arr;
}
function syn_templates(){
	global $db,$tpf;
	$dirs = scandir(PHPDISK_ROOT.'templates');
	sort($dirs);
	for($i=0;$i<count($dirs);$i++){
		if(check_template($dirs[$i])){
			$arr[] = $dirs[$i];
		}
	}
	$q = $db->query("select * from {$tpf}templates where actived=1");
	while($rs = $db->fetch_array($q)){
		if(check_template($rs['tpl_name'])){
			$active_templates .= $rs['tpl_name'].',';
		}
	}
	$db->free($q);
	unset($rs);

	if(trim(substr($active_templates,0,-1))){
		$active_arr = explode(',',$active_templates);
	}
	for($i=0;$i<count($arr);$i++){
		$tmp = get_template_info($arr[$i]);
		if(@in_array($arr[$i],$active_arr)){
			$sql_do .= "('".$db->escape($arr[$i])."','1','".$db->escape(trim($tmp['tpl_type']))."'),";
		}else{
			$sql_do .= "('".$db->escape($arr[$i])."','0','".$db->escape(trim($tmp['tpl_type']))."'),";
		}
	}
	$sql_do = substr($sql_do,0,-1);
	$db->query_unbuffered("truncate table {$tpf}templates;");
	$db->query_unbuffered("replace into {$tpf}templates(tpl_name,actived,tpl_type) values $sql_do ;");

	$num = @$db->result_first("select count(*) from {$tpf}templates where tpl_type='admin' and actived=1");
	if(!$num){
		$db->query_unbuffered("update {$tpf}templates set actived=1 where tpl_name='admin'");
	}
	$num = @$db->result_first("select count(*) from {$tpf}templates where tpl_type='user' and actived=1");
	if(!$num){
		$db->query_unbuffered("update {$tpf}templates set actived=1 where tpl_name='default'");
	}
	return true;
}
function get_template_info($tpl_name){
	global $db,$tpf;
	$file = PHPDISK_ROOT."templates/$tpl_name/template_info.php";
	if(file_exists($file)){
		$_data = read_file($file);
		preg_match("/Template Name:(.*)/i",$_data,$tpl_title);
		preg_match("/Template URL:(.*)/i",$_data,$tpl_url);
		preg_match("/Description:(.*)/i",$_data,$tpl_desc);
		preg_match("/Author:(.*)/i",$_data,$tpl_author);
		preg_match("/Author Site:(.*)/i",$_data,$tpl_site);
		preg_match("/Version:(.*)/i",$_data,$tpl_version);
		preg_match("/Template Type:(.*)/i",$_data,$tpl_type);
		preg_match("/PHPDISK Core:(.*)/i",$_data,$phpdisk_core);
	}
	$actived = (int)@$db->result_first("select actived from {$tpf}templates where tpl_name='$tpl_name' limit 1");
	$arr = array(
	'tpl_title' => trim($tpl_title[1]),
	'tpl_url' => trim($tpl_url[1]),
	'tpl_desc' => htmlspecialchars(trim($tpl_desc[1])),
	'tpl_author' => trim($tpl_author[1]),
	'tpl_site' => trim($tpl_site[1]),
	'tpl_version' => trim($tpl_version[1]),
	'tpl_type' => trim(strtolower($tpl_type[1])),
	'tpl_dir' => trim($tpl_name),
	'phpdisk_core' => trim($phpdisk_core[1]),
	'actived' => $actived,
	);
	return $arr;
}
function check_template($tpl_name){
	$dir = PHPDISK_ROOT."templates/{$tpl_name}/";
	if(is_dir($dir) && file_exists($dir.'template_info.php') && $tpl_name !='.' && $tpl_name !='..'){
		$rtn = 1;
	}else{
		$rtn = 0;
	}
	return $rtn;
}

?>