<?php 
/**
#	Project: PHPDISK File Storage Solution
#	This is NOT a freeware, use is subject to license terms.
#
#	Site: http://www.phpdisk.com
#
#	$Id: main.inc.php 2 2011-05-27 02:59:23Z along $
#
#	Copyright (C) 2008-2011 PHPDisk Team. All Rights Reserved.
#
*/

if(!defined('IN_PHPDISK') || !defined('IN_ADMINCP')) {
	exit('[PHPDisk] Access Denied');
}
lang('admin/main');

switch($action){
	default:

		function main_stats(){
			global $db,$tpf,$timestamp;
			$stats['user_folders_count'] = (int)@$db->result_first("select count(*) from {$tpf}folders");

			$stats['user_files_count'] = (int)@$db->result_first("select count(*) from {$tpf}files where is_public=0");

			$stats['users_count'] = (int)@$db->result_first("select count(*) from {$tpf}users ");

			$stats['users_locked_count'] = (int)@$db->result_first("select count(*) from {$tpf}users where is_locked=1");

			$stats['extract_code_count'] = (int)@$db->result_first("select count(*) from {$tpf}extracts");

			$stats['all_files_count'] = (int)@$db->result_first("select count(*) from {$tpf}files");

			$storage_count_tmp = (float)@$db->result_first("select sum(file_size) from {$tpf}files where is_public=0");

			$public_storage_count_tmp = (float)@$db->result_first("select sum(file_size) from {$tpf}files where is_public=1");

			$stats['user_storage_count'] = get_size($storage_count_tmp);
			$stats['public_storage_count'] = get_size($public_storage_count_tmp);
			$stats['total_storage_count'] = get_size($storage_count_tmp+$public_storage_count_tmp);
			$stats['users_open_count'] = $stats['users_count']-$stats['users_locked_count'];
			$stats['stat_time'] = $timestamp;

			stats_cache($stats);
			return true;
		}
		super_cache('stat','main_stats',1,0,0,$settings['cache_time']);
		$tmp = super_cache('stat','stats_cache',1,0);
		foreach ($tmp as $v){
			$stats[$v['vars']] = $v['value'];
		}

		$zlib_support = function_exists('gzinflate') ? '<span class="txtblue">'.$L['yes'].'</span>' : '<span class="txtred">'.$L['no'].'</span>';
		$iconv_support = function_exists('iconv') ? '<span class="txtblue">'.$L['yes'].'</span>' : '<span class="txtred">'.$L['no'].'</span>';
		$mbstring_support = function_exists('mb_convert_encoding') ? '<span class="txtblue">'.$L['yes'].'</span>' : '<span class="txtred">'.$L['no'].'</span>';
		$post_max_size = ini_get('post_max_size');
		$file_max_size = ini_get('upload_max_filesize');
		$mysql_info = mysql_get_client_info();
		$gd_support = function_exists('gd_info') ? '<span class="txtblue">'.$L['yes'].'</span>' : '<span class="txtred">'.$L['no'].'</span>';
		$gd_info_arr = gd_info();
		$gd_info = $gd_info_arr['GD Version'];
		$charset_info = strtoupper($charset);

		$update_url = "<a href=".urr("admincp","item=version").">".$L['update_now']."</a>";
		$update_log = PHPDISK_ROOT.'system/update.log.php';

		if($settings['open_autoupdate']){
			if(file_exists($update_file) && ($timestamp - filemtime($update_file)) < 86400*7){
				$alert = 0;
			}else{
				$alert = 1;
				$str = "<?php".LF;
				$str .= "\texit;".LF;
				$str .= "// This is PHPDISK auto-generated file. Do NOT modify me.".LF;
				$str .= "// Cache Time: ".date("Y-m-d H:i:s").LF.LF;
				$str .= "?>".LF;
				$str .= PHPDISK_VERSION.'|'.PHPDISK_RELEASE.LF;
				write_file($update_log,$str);
			}
		}else{
			$alert = 0;
		}
		$newsdown = PHPDISK_ROOT.'system/newsdown.log.php';
		if(!file_exists($newsdown) || ($timestamp - filemtime($newsdown)) > 86400*3){
			$arr = get_web_link('http://www.phpdisk.com/');
		}else{
			$get_official_news = false;
			$show_news_frame = 'none';
		}
		if($arr['http_code'] == 200){
			$get_official_news = true;
			$show_news_frame = '';
			@unlink($newsdown);
		}elseif($arr['http_code'] ==0){
			$str = "<?php".LF;
			$str .= "\texit;".LF;
			$str .= "// This is PHPDISK auto-generated file. Do NOT modify me.".LF;
			$str .= "// Cache Time: ".date("Y-m-d H:i:s").LF.LF;
			$str .= "// phpdisk official site ...".LF;
			$str .= "?>".LF;
			write_file($newsdown,$str);
		}

		require_once template_echo('main',$admin_tpl_dir,'',1);
}
function get_web_link($url){
	if(function_exists('curl_init')){
		$options = array(
		CURLOPT_RETURNTRANSFER => true,
		CURLOPT_HEADER         => false,
		CURLOPT_ENCODING       => "",
		CURLOPT_USERAGENT      => "spider",
		CURLOPT_AUTOREFERER    => true,
		CURLOPT_CONNECTTIMEOUT => 120,
		CURLOPT_TIMEOUT        => 2,
		CURLOPT_MAXREDIRS      => 10,
		CURLOPT_NOBODY => 1,
		);
		$ch = curl_init($url);
		curl_setopt_array($ch, $options);
		$content = curl_exec($ch);
		$err = curl_errno($ch);
		$errmsg = curl_error($ch);
		$header = curl_getinfo($ch);
		curl_close($ch);

		$header['errno'] = $err;
		$header['errmsg'] = $errmsg;
		$header['content'] = $content;

		return $header;
	}
}
?>