<?php 
/**
#	Project: PHPDISK File Storage Solution
#	This is NOT a freeware, use is subject to license terms.
#
#	Site: http://www.phpdisk.com
#
#	$Id: files.inc.php 11 2011-06-08 12:00:43Z along $
#
#	Copyright (C) 2008-2011 PHPDisk Team. All Rights Reserved.
#
*/

if(!defined('IN_PHPDISK') || !defined('IN_ADMINCP')) {
	exit('[PHPDisk] Access Denied');
}

lang('admin/files');

switch($action){
	case 'index':

		$view = trim(gpc('view','GP',''));
		$uid = (int)gpc('uid','GP',0);

		if($task =='check_public'){
			form_auth(gpc('formhash','P',''),formhash());

			$file_ids = gpc('file_ids','P',array(''));

			if($settings['online_demo']){
				$error = true;
				$sysmsg[] = $L['online_demo_deny'];
			}
			$ids_arr = get_ids_arr($file_ids,$L['please_select_check_files']);
			if($ids_arr[0]){
				$error = true;
				$sysmsg[] = $ids_arr[1];
			}else{
				$file_str = $ids_arr[1];
			}
			if(!$error){
				$db->query_unbuffered("update {$tpf}files set is_checked=1 where file_id in ($file_str)");
				update_cache('file');
				$sysmsg[] = $L['check_public_success'];
				redirect(urr("admincp","item=files&action=index&view=checked_file"),$sysmsg);
			}else{
				redirect('back',$sysmsg);
			}

		}elseif($task =='file_to_locked'){
			form_auth(gpc('formhash','P',''),formhash());

			$file_ids = gpc('file_ids','P',array(''));

			if($settings['online_demo']){
				$error = true;
				$sysmsg[] = $L['online_demo_deny'];
			}
			$ids_arr = get_ids_arr($file_ids,$L['please_select_check_files']);
			if($ids_arr[0]){
				$error = true;
				$sysmsg[] = $ids_arr[1];
			}else{
				$file_str = $ids_arr[1];
			}
			if(!$error){
				$db->query_unbuffered("update {$tpf}files set is_locked=1 where file_id in ($file_str)");
				update_cache('file');
				$sysmsg[] = $L['file_to_locked_success'];
				redirect($_SERVER['HTTP_REFERER'],$sysmsg);
			}else{
				redirect('back',$sysmsg);
			}

		}elseif($task == 'file_to_unlocked'){
			form_auth(gpc('formhash','P',''),formhash());

			$file_ids = gpc('file_ids','P',array(''));

			if($settings['online_demo']){
				$error = true;
				$sysmsg[] = $L['online_demo_deny'];
			}
			$ids_arr = get_ids_arr($file_ids,$L['please_select_check_files']);
			if($ids_arr[0]){
				$error = true;
				$sysmsg[] = $ids_arr[1];
			}else{
				$file_str = $ids_arr[1];
			}
			if(!$error){
				$db->query_unbuffered("update {$tpf}files set is_locked=0 where file_id in ($file_str)");
				update_cache('file');
				$sysmsg[] = $L['file_to_unlocked_success'];
				redirect($_SERVER['HTTP_REFERER'],$sysmsg);
			}else{
				redirect('back',$sysmsg);
			}

		}elseif($task =='delete_file_complete'){
			form_auth(gpc('formhash','P',''),formhash());

			$file_ids = gpc('file_ids','P',array(''));

			if($settings['online_demo']){
				$error = true;
				$sysmsg[] = $L['online_demo_deny'];
			}
			$ids_arr = get_ids_arr($file_ids,$L['please_select_delete_files']);
			if($ids_arr[0]){
				$error = true;
				$sysmsg[] = $ids_arr[1];
			}else{
				$file_str = $ids_arr[1];
			}
			if(!$error){
				admin_delete_phpdisk_file("select * from {$tpf}files where file_id in($file_str)");
				$db->query_unbuffered("delete from {$tpf}files where file_id in ($file_str)");
				super_cache('folder','syn_folder_size',1,0,$pd_uid,$settings['cache_time']);
				update_cache('file');
				$sysmsg[] = $L['file_delete_success'];
				redirect($_SERVER['HTTP_REFERER'],$sysmsg);
			}else{
				redirect('back',$sysmsg);
			}

		}else{
			$sql_ext = '';
			switch($view){
				case 'mydisk_recycle':
					$sql_ext = " where in_recycle=1 and is_public=0";
					break;
				case 'user':
					$sql_ext = " where f.userid='$uid'";
					break;
				default:
					$sql_ext = " where is_public=0 and in_recycle=0 and is_public=0";
			}
			$rs = $db->fetch_one_array("select count(*) as total_num from {$tpf}files f {$sql_ext}");
			$total_num = $rs['total_num'];
			$start_num = ($pg-1) * $perpage;

			$q = $db->query("select f.*,u.username from {$tpf}files f,{$tpf}users u {$sql_ext} and f.userid=u.userid order by file_id desc limit $start_num,$perpage");
			$files_array = array();
			while($rs = $db->fetch_array($q)){
				$tmp_ext = $rs['file_extension'] ? '.'.$rs['file_extension'] : "";
				$rs['file_thumb'] = get_file_thumb($rs);
				$rs['file_name_all'] = $rs['file_name'].$tmp_ext;
				$rs['file_name'] = cutstr($rs['file_name'].$tmp_ext,35);
				$rs['a_user_view'] = urr("admincp","item=files&action=$action&view=user&uid=".$rs['userid']);
				$rs['file_size'] = get_size($rs['file_size']);
				$rs['file_time'] = custom_time("Y-m-d",$rs['file_time']);
				$rs['a_downfile'] = urr("downfile","file_id={$rs['file_id']}&file_key={$rs['file_key']}");
				$rs['a_viewfile'] = urr("viewfile","file_id={$rs['file_id']}");
				$rs['a_recycle_delete'] = urr("admincp","item=files&action=recycle_delete&file_id={$rs['file_id']}");
				$rs['status_txt'] = $rs['is_locked'] ? "<span class=\"txtred\">{$L['locked_status']}</span>" : "<span class=\"txtblue\">{$L['common_status']}</span>";
				$files_array[] = $rs;
			}
			$db->free($q);
			unset($rs);
			$page_nav = multi($total_num, $perpage, $pg, urr("admincp","item=$item&action=$action&view=$view&uid=$uid"));

			require_once template_echo($item,$admin_tpl_dir,'',1);
		}
		break;

	case 'search':
		if($task =='check_public'){
			form_auth(gpc('formhash','P',''),formhash());

			$file_ids = gpc('file_ids','P',array(''));

			if($settings['online_demo']){
				$error = true;
				$sysmsg[] = $L['online_demo_deny'];
			}
			$ids_arr = get_ids_arr($file_ids,$L['please_select_check_files']);
			if($ids_arr[0]){
				$error = true;
				$sysmsg[] = $ids_arr[1];
			}else{
				$file_str = $ids_arr[1];
			}
			if(!$error){
				$db->query_unbuffered("update {$tpf}files set is_checked=1 where file_id in ($file_str)");

				$sysmsg[] = $L['check_public_success'];
				redirect(urr("admincp","item=files&action=index&view=checked_file"),$sysmsg);
			}else{
				redirect('back',$sysmsg);
			}

		}elseif($task =='file_to_locked'){
			form_auth(gpc('formhash','P',''),formhash());

			$file_ids = gpc('file_ids','P',array(''));

			if($settings['online_demo']){
				$error = true;
				$sysmsg[] = $L['online_demo_deny'];
			}
			$ids_arr = get_ids_arr($file_ids,$L['please_select_check_files']);
			if($ids_arr[0]){
				$error = true;
				$sysmsg[] = $ids_arr[1];
			}else{
				$file_str = $ids_arr[1];
			}
			if(!$error){
				$db->query_unbuffered("update {$tpf}files set is_locked=1 where file_id in ($file_str)");
				update_cache('file');
				$sysmsg[] = $L['file_to_locked_success'];
				redirect($_SERVER['HTTP_REFERER'],$sysmsg);
			}else{
				redirect('back',$sysmsg);
			}

		}elseif($task == 'file_to_unlocked'){
			form_auth(gpc('formhash','P',''),formhash());

			$file_ids = gpc('file_ids','P',array(''));

			if($settings['online_demo']){
				$error = true;
				$sysmsg[] = $L['online_demo_deny'];
			}
			$ids_arr = get_ids_arr($file_ids,$L['please_select_check_files']);
			if($ids_arr[0]){
				$error = true;
				$sysmsg[] = $ids_arr[1];
			}else{
				$file_str = $ids_arr[1];
			}
			if(!$error){
				$db->query_unbuffered("update {$tpf}files set is_locked=0 where file_id in ($file_str)");
				update_cache('file');
				$sysmsg[] = $L['file_to_unlocked_success'];
				redirect($_SERVER['HTTP_REFERER'],$sysmsg);
			}else{
				redirect('back',$sysmsg);
			}

		}elseif($task =='delete_file_complete'){
			form_auth(gpc('formhash','P',''),formhash());

			$file_ids = gpc('file_ids','P',array(''));

			if($settings['online_demo']){
				$error = true;
				$sysmsg[] = $L['online_demo_deny'];
			}
			$ids_arr = get_ids_arr($file_ids,$L['please_select_delete_files']);
			if($ids_arr[0]){
				$error = true;
				$sysmsg[] = $ids_arr[1];
			}else{
				$file_str = $ids_arr[1];
			}
			if(!$error){
				admin_delete_phpdisk_file("select * from {$tpf}files where file_id in($file_str)");
				$db->query_unbuffered("delete from {$tpf}files where file_id in ($file_str)");
				super_cache('folder','syn_folder_size',1,0,$pd_uid,$settings['cache_time']);
				update_cache('file');
				$sysmsg[] = $L['file_delete_success'];
				redirect($_SERVER['HTTP_REFERER'],$sysmsg);
			}else{
				redirect('back',$sysmsg);
			}
		}else{
			$word = trim(gpc('word','G',''));
			$word_str = $db->escape(str_replace('',' ',replace_inject_str($word)));
			$arr = explode(' ',$word_str);
			if(count($arr)>1){
				for($i=0;$i<count($arr);$i++){
					if(trim($arr[$i]) <> ''){
						$str .= " (file_name like '%{$arr[$i]}%' or file_extension like '%{$arr[$i]}%') and";
					}
				}
				$str = substr($str,0,-3);
				$sql_keyword = " (".$str.")";

			}else{
				$sql_keyword = " (file_name like '%{$word_str}%' or file_extension like '%{$word_str}%')";
			}
			$sql_do = " {$tpf}files fl,{$tpf}users u where fl.userid=u.userid and {$sql_keyword}";

			$rs = $db->fetch_one_array("select count(*) as total_num from {$sql_do}");
			$total_num = $rs['total_num'];
			$start_num = ($pg-1) * $perpage;

			$q = $db->query("select fl.*,u.username from {$sql_do} order by file_id desc limit $start_num,$perpage");
			$files_array = array();
			while($rs = $db->fetch_array($q)){
				$tmp_ext = $rs['file_extension'] ? '.'.$rs['file_extension'] : "";
				$rs['file_name_all'] = $rs['file_name'].$tmp_ext;
				$rs['file_name'] = str_replace($word,'<span class="txtred">'.$word.'</span>',cutstr($rs['file_name'].$tmp_ext,35));
				$rs['a_user_view'] = urr("admincp","item=files&action=index&view=user&uid=".$rs['userid']);
				$rs['file_size'] = get_size($rs['file_size']);
				$rs['file_time'] = custom_time("Y-m-d",$rs['file_time']);
				$rs['a_downfile'] = urr("downfile","file_id={$rs['file_id']}&file_key={$rs['file_key']}");
				$rs['a_viewfile'] = urr("viewfile","file_id={$rs['file_id']}");
				$rs['a_recycle_delete'] = urr("admincp","item=files&action=recycle_delete&file_id={$rs['file_id']}");
				$rs['status_txt'] = $rs['is_locked'] ? "<span class=\"txtred\">{$L['locked_status']}</span>" : "<span class=\"txtblue\">{$L['common_status']}</span>";
				$files_array[] = $rs;
			}
			$db->free($q);
			unset($rs);
			$page_nav = multi($total_num, $perpage, $pg, urr("admincp","item=$item&action=search&word=".rawurlencode($word).""));

			require_once template_echo($item,$admin_tpl_dir,'',1);
		}
		break;

	case 'recycle_delete':
		if($settings['online_demo']){
			$error = true;
			$sysmsg[] = $L['online_demo_deny'];
		}
		if(!$error){
			$file_id = (int)gpc('file_id','G',0);
			admin_delete_phpdisk_file("select * from {$tpf}files where file_id='$file_id'");
			$db->query_unbuffered("delete from {$tpf}files where file_id='$file_id'");
			super_cache('folder','syn_folder_size',1,0,$pd_uid,$settings['cache_time']);
			update_cache('file');
			$sysmsg[] = $L['file_delete_success'];
			redirect(urr("admincp","item=files&action=index&view=public_recycle"),$sysmsg);
		}else{
			redirect('back',$sysmsg);
		}
		break;

}
function admin_delete_phpdisk_file($sql,$rmdir=0){
	global $db,$tpf,$settings;
	$q = $db->query($sql);
	while($rs = $db->fetch_array($q)){
		$file_ext = get_real_ext($rs['file_extension']);
		$rs2 = $db->fetch_one_array("select count(*) as total from {$tpf}files where file_real_name='{$rs['file_real_name']}' and file_store_path='{$rs['file_store_path']}'");
		if($rs2['total']==1){
			if(display_plugin('multi_server','open_multi_server_plugin',$settings['open_multi_server'],0) && $rs['server_oid']>1){
				$rs3 = $db->fetch_one_array("select * from {$tpf}servers where server_oid='{$rs['server_oid']}' limit 1");
				if($rs3){
					$ftp_res = pftp_connnect($rs3['ftp_host'],$rs3['ftp_user'],$rs3['ftp_pass'],$rs3['ftp_port'],'/',$rs3['ftp_ssl'],$rs3['ftp_pasv']);
					$arr = explode('/',$rs3['ftp_path']);
					if(count($arr)){
						for($i=0;$i<count($arr);$i++){
							if(trim($arr[$i])) pftp_chdir($ftp_res,$arr[$i]);
						}
					}
					pftp_delete($ftp_res,$rs['file_store_path'].'/'.$rs['file_real_name'].$file_ext);
					pftp_delete($ftp_res,$rs['file_store_path'].'/'.$rs['file_real_name'].'_thumb'.$file_ext);
					pftp_close($ftp_res);
				}
				unset($rs3);
			}else{
				$tmp_username = @$db->result_first("select username from {$tpf}users where userid='{$rs['userid']}'");
				$src_1 = PHPDISK_ROOT.$settings['file_path'].'/'.$tmp_username.$rs['file_store_path'].$rs['file_real_name'].$file_ext;
				$src_1 = is_utf8() ? convert_str('utf-8','gbk',$src_1) : $src_1;
				@unlink($src_1);

				if($rs['is_image']){
					$src_2 = PHPDISK_ROOT.$settings['file_path'].'/'.$tmp_username.$rs['file_store_path'].$rs['file_real_name'].'_thumb'.$file_ext;
					$src_2 = is_utf8() ? convert_str('utf-8','gbk',$src_2) : $src_2;
					@unlink($src_2);
				}
				if($rmdir){
					$dir = PHPDISK_ROOT.$settings['file_path'].'/'.$tmp_username.$rs['file_store_path'];
					$dir = is_utf8() ? convert_str('utf-8','gbk',$dir) : $dir;
					@rmdir($dir);
				}
			}
		}
		unset($rs2);
		update_cache('file','',$rs['userid']);
	}
	$db->free($q);
	unset($rs);
}
?>