<?php 
/**
#	Project: PHPDISK File Storage Solution
#	This is NOT a freeware, use is subject to license terms.
#
#	Site: http://www.phpdisk.com
#
#	$Id: datacall.inc.php 2 2011-05-27 02:59:23Z along $
#
#	Copyright (C) 2008-2011 PHPDisk Team. All Rights Reserved.
#
*/

if(!defined('IN_PHPDISK') || !defined('IN_ADMINCP')) {
	exit('[PHPDisk] Access Denied');
}
lang('admin/datacall');

switch($action){

	case 'js':
		require_once template_echo($item,$admin_tpl_dir,'',1);
		break;
	case 'sql':
		$sql_module = nl2br(htmlspecialchars($L['sql_module_tips2']));
		require_once template_echo($item,$admin_tpl_dir,'',1);
		break;
	case 'add_arr':
		if($task =='add_arr'){
			form_auth(gpc('formhash','P',''),formhash());
			$c_key = $db->escape(trim(gpc('c_key','P','')));
			$c_value = gpc('c_value','P','');

			if(checklength($c_key,1,200)){
				$error = true;
				$sysmsg[] = $L['key_error'];
			}elseif(preg_match('/[^a-z0-9_]/i',$c_key)){
				$error = true;
				$sysmsg[] = $L['key_format_error'];
			}else{
				$num = $db->result_first("select count(*) from {$tpf}datacalls where c_key='$c_key'");
				if($num){
					$error = true;
					$sysmsg[] = $L['key_exists'];
				}
			}
			if($c_value ==''){
				$error = true;
				$sysmsg[] = $L['value_error'];
			}else{
				$c_value = base64_encode($c_value);
			}
			if(!$error){
				$ins = array(
				'c_key' => $c_key,
				'c_value' => $c_value,
				);
				$db->query_unbuffered("insert into {$tpf}datacalls set ".$db->sql_array($ins)."");
				$sysmsg[] = $L['add_arr_success'];
				redirect(urr("admincp","item=$item&action=arr"),$sysmsg);
			}else{
				redirect('back',$sysmsg);
			}

		}else{
			require_once template_echo($item,$admin_tpl_dir,'',1);
		}
		break;
	case 'edit_arr':
		$dcid = (int)gpc('dcid','GP',0);
		if($task =='edit_arr'){
			form_auth(gpc('formhash','P',''),formhash());
			$c_key = $db->escape(trim(gpc('c_key','P','')));
			$c_value = gpc('c_value','P','');

			if(checklength($c_key,1,200)){
				$error = true;
				$sysmsg[] = $L['key_error'];
			}elseif(preg_match('/[^a-z0-9_]/i',$c_key)){
				$error = true;
				$sysmsg[] = $L['key_format_error'];
			}else{
				$num = $db->result_first("select count(*) from {$tpf}datacalls where c_key='$c_key' and dcid<>'$dcid'");
				if($num){
					$error = true;
					$sysmsg[] = $L['key_exists'];
				}
			}
			if($c_value ==''){
				$error = true;
				$sysmsg[] = $L['value_error'];
			}else{
				$c_value = base64_encode($c_value);
			}
			if(!$error){
				$ins = array(
				'c_key' => $c_key,
				'c_value' => $c_value,
				);
				$db->query_unbuffered("update {$tpf}datacalls set ".$db->sql_array($ins)." where dcid='$dcid'");
				$sysmsg[] = $L['edit_arr_success'];
				redirect(urr("admincp","item=$item&action=arr"),$sysmsg);
			}else{
				redirect('back',$sysmsg);
			}

		}else{
			$c_key = $db->result_first("select c_key from {$tpf}datacalls where dcid='$dcid'");
			require_once template_echo($item,$admin_tpl_dir,'',1);
		}
		break;
	case 'arr':
		if($task =='del_arr'){
			$dcid = (int)gpc('dcid','G',0);
			if($dcid){
				$db->query_unbuffered("delete from {$tpf}datacalls where dcid='$dcid' limit 1");
				$sysmsg[] = $L['del_dc_success'];
				redirect('back',$sysmsg);
			}
		}else{
			$rs = $db->fetch_one_array("select count(*) as total_num from {$tpf}datacalls");
			$total_num = $rs['total_num'];
			$start_num = ($pg-1) * $perpage;

			$q = $db->query("select * from {$tpf}datacalls order by dcid desc limit $start_num,$perpage");
			while($rs = $db->fetch_array($q)){
				$rs['dc_key'] = '{#get_datacall(\''.$rs['c_key'].'\')#}';
				$C['arr_datacall_list'][] = $rs;
			}
			$db->free($q);
			unset($rs);
			$page_nav = multi($total_num, $perpage, $pg, urr("admincp","item=$item&action=arr"));
			require_once template_echo($item,$admin_tpl_dir,'',1);
		}
		break;

}
?>