<?php 
/**
#	Project: PHPDISK File Storage Solution
#	This is NOT a freeware, use is subject to license terms.
#
#	Site: http://www.phpdisk.com
#
#	$Id: downfile.php 6 2011-05-28 09:17:59Z along $
#
#	Copyright (C) 2008-2011 PHPDisk Team. All Rights Reserved.
#
*/

include "includes/commons.inc.php";

lang('downfile');

$chunk = is_numeric($settings['down_chunk']) ? (int)$settings['down_chunk'] : 16384;
@set_time_limit(0);
@ignore_user_abort(true);
@set_magic_quotes_runtime(0);
$file_id = (int)gpc('file_id','G',0);
$file_key = $db->escape(gpc('file_key','G',''));

$rs = $db->fetch_one_array("select * from {$tpf}files where file_id='$file_id' and file_key='$file_key'");
if($rs){

	if($settings['login_down_file'] && !$pd_uid && $rs['userid']){
		alert($L['file_login_down'],urr("account","action=login"));
	}
	if(!$rs['is_checked'] && $pd_gid<>1){
		alert($L['file_checking'],$_SERVER['HTTP_REFERER']);
	}

	$file_id = $rs['file_id'];
	$userid = $rs['userid'];
	$file_real_name = $rs['file_real_name'];
	$file_name_short = $rs['file_name'];
	$tmp_ext = $rs['file_extension'] ? '.'.$rs['file_extension'] : "";
	$file_name = $rs['file_name'].$tmp_ext;
	$file_credit = (int)$rs['file_credit'];
	
	$file_extension = $rs['file_extension'];
	$file_ext = get_real_ext($file_extension);
	$file_mime = $rs['file_mime'];
	$file_size = $rs['file_size'];
	$thumb_size = $rs['thumb_size'];
	$file_store_path = $rs['file_store_path'];
	$is_locked = $rs['is_locked'];
	$file_real_name2 = $file_real_name;
	if(is_utf8()){
		$file_real_name = convert_str('utf-8','gbk',$file_real_name);
	}
	$username = @$db->result_first("select username from {$tpf}users where userid='$userid'");
	$tmp_username = is_utf8() ? convert_str('utf-8','gbk',$username) : $username;
	
	if(display_plugin('multi_server','open_multi_server_plugin',$settings['open_multi_server'],0) && $rs['server_oid']>1){
		$rs2 = $db->fetch_one_array("select * from {$tpf}servers where server_oid='{$rs['server_oid']}' limit 1");
		if($rs2){
			$file_location = $rs2['server_host'].$rs2['server_store_path'].'/'.$file_store_path.'/'.$file_real_name.$file_ext;
			$file_location2 = $rs2['server_host'].$rs2['server_store_path'].'/'.$file_store_path.'/'.$file_real_name2.$file_ext;
		}
		unset($rs2);
	}else{
		$file_location = $settings['file_path'].'/'.$tmp_username.$file_store_path.$file_real_name.$file_ext;
		$file_location2 = $settings['file_path'].'/'.$tmp_username.$file_store_path.$file_real_name2.$file_ext;
	}
}
$file_location = is_utf8() ? convert_str('utf-8','gbk',$file_location) : $file_location;
$file_location2 = is_utf8() ? convert_str('utf-8','gbk',$file_location2) : $file_location2;

if($is_locked){
	alert($L['file_locked'],$_SERVER['HTTP_REFERER']);
}
if($action !='by_tools'){
	$exp_down = (int)$settings['exp_down'];
	$db->query_unbuffered("update {$tpf}users set exp=exp+$exp_down where userid='$pd_uid'");
	
	$exp_down_my = (int)$settings['exp_down_my'];
	$db->query_unbuffered("update {$tpf}users set exp=exp+$exp_down_my where userid='$userid'");

	if($settings['credit_open'] && $settings['login_down_file'] && $pd_uid!=$userid){
		$credit = $settings['credit_open'] ? (int)$settings['credit_down'] : 0;
		$credit_my = $settings['credit_open'] ? (int)$settings['credit_down_my'] : 0;
		$pd_credit = $db->result_first("select credit from {$tpf}users where userid='$pd_uid' limit 1");
		if($pd_credit && $pd_credit>=$credit){
			$db->query_unbuffered("update {$tpf}users set credit=credit+{$credit_my} where userid='$userid'");
			$db->query_unbuffered("update {$tpf}users set credit=credit-{$credit} where userid='$pd_uid'");
		}else{
			alert($L['credit_fail'],$_SERVER['HTTP_REFERER']);
		}
		unset($rs);
	}

	$rs = $db->fetch_one_array("select down_flow_count from {$tpf}users where userid='$userid'");
	if($rs){
		$down_flow_byte = get_byte_value($rs['down_flow_count']);
		$down_flow_byte += $file_size;
		$down_flow_count = get_size($down_flow_byte);
	}
	unset($rs);
	$db->query_unbuffered("update {$tpf}users set down_flow_count='$down_flow_count' where userid='$userid'");
	if($host == $local_url){
		if(display_plugin('filelog','open_filelog_plugin',($settings['open_filelog'] && $settings['open_down_filelog']),0)){
			$username = @$db->result_first("select username from {$tpf}users where userid='$userid' limit 1");
			$down_username = @$db->result_first("select username from {$tpf}users where userid='$pd_uid' limit 1");
			$down_username = $down_username ? $down_username : '-';
			$log_format = $file_name.'|'.get_size($file_size).'|'.$L['download'].'|'.$username.'|'.$down_username.'|'.date("Y-m-d H:i:s").'|'.$onlineip;
			all_file_logs($log_format);
			my_file_down_logs($log_format,$userid);
		}
	}

}

$filter_arr = explode(',',$settings['filter_extension']);

if($action =='by_tools'){
	header("Location: ".$settings['phpdisk_url'].$file_location2);
	
/*}elseif($settings['store_true_filename'] && !in_array($file_extension,$filter_arr) && $file_extension !=''){
	echo '<script>document.location="'.$file_location2.'";</script>';*/
	
}else{
	if(is_utf8()){
		$file_name = convert_str('utf-8','gbk',$file_name);
	}

	ob_end_clean();
	header('Cache-Control: max-age=86400');
	header('Expires: '.gmdate('D, d M Y H:i:s \G\M\T',time()+86400));
	if($action == 'view'){
		header('Content-Disposition: inline;filename="'.$file_name.'"');
	}else{
		header('Content-Disposition: attachment;filename="'.$file_name.'"');
	}
	header('Content-Encoding: none');
	header('Content-Transfer-Encoding: binary');
	header('Content-Type: '.$file_mime);
	header('Content-Length: '.$file_size);
	
	$speed = get_byte_value($group_set['down_trans_rate']);
	$sleep = $speed ? floor(($chunk/($speed*1024))*1000000) : 0;
	$sent = 0;

	if(($fp = @fopen(PHPDISK_ROOT.$file_location2,'rb')) === false) exit('[PHPDisk Info] Can not open file!');
	do{
		$buf = fread($fp,$chunk);
		$sent += strlen($buf);
		echo $buf;
		ob_flush();
		flush();
		usleep($sleep);
		if(strlen($buf) ==0){
			break;
		}
	}while(true);
	@fclose($fp);
}
include PHPDISK_ROOT."./includes/footer.inc.php";

function alert($msg,$url){
	echo "<script>alert('$msg');document.location='$url';</script>";
	exit;
}
?>

