<?php 
/**
#	Project: PHPDISK File Storage Solution
#	This is NOT a freeware, use is subject to license terms.
#
#	Site: http://www.phpdisk.com
#
#	$Id: report.inc.php 2 2011-05-27 02:59:23Z along $
#
#	Copyright (C) 2008-2011 PHPDisk Team. All Rights Reserved.
#
*/

if(!defined('IN_PHPDISK') || !defined('IN_ADMINCP')) {
	exit('[PHPDisk] Access Denied');
}
lang('admin/report');

switch($action){
	case 'user':
		
		$title = $L['report_user_title'];
		$tips = $L['report_user_tips'];
		$op_action = $L['locked'];
		
		if($task){
			$file_ids = gpc('file_ids','P',array());
			
			$ids_arr = get_ids_arr($file_ids,$L['please_select_operation_files']);
			if($ids_arr[0]){
				$error = true;
				$sysmsg[] = $ids_arr[1];
			}else{
				$file_str = $ids_arr[1];
			}
		}
		
		if($task =='change_status'){
			if($p_formhash != formhash()){
				exit($L['system_error']);
			}
			if($settings['online_demo']){
				$error = true;
				$sysmsg[] = $L['online_demo_deny'];
			}
			if(!$error){
				$db->query_unbuffered("update {$tpf}files set report_status=0,is_locked=1 where file_id in ($file_str)");
				$sysmsg[] = $L['locked_file_success'];
				redirect($_SERVER['HTTP_REFERER'],$sysmsg);
			}else{
				redirect('back',$sysmsg);
			}
		}elseif($task =='delete'){
			if($p_formhash != formhash()){
				exit($L['system_error']);
			}
			if($settings['online_demo']){
				$error = true;
				$sysmsg[] = $L['online_demo_deny'];
			}
			if(!$error){
				delete_phpdisk_file("select * from {$tpf}files where file_id in ($file_str)");	
				$db->query_unbuffered("delete from {$tpf}files where file_id in ($file_str)");
				super_cache('file','syn_folder_size',1,0,$pd_uid,$settings['cache_time']);
				$sysmsg[] = $L['delete_file_success'];
				redirect($_SERVER['HTTP_REFERER'],$sysmsg);
			}else{
				redirect('back',$sysmsg);
			}
		}else{
			$sql_ext = "{$tpf}files fl,{$tpf}users u where fl.userid=u.userid and report_status=1 and fl.is_locked=0";
			$rs = $db->fetch_one_array("select count(*) as total_num from {$sql_ext}");
			$total_num = $rs['total_num'];
			$start_num = ($pg-1) * $perpage;
			
			$q = $db->query("select fl.*,u.username from {$sql_ext} order by file_id desc limit $start_num,$perpage");
			$files_array = array();
			while($rs = $db->fetch_array($q)){
				$tmp_ext = $rs['file_extension'] ? '.'.$rs['file_extension'] : "";
				$rs['file_thumb'] = get_file_thumb($rs);
				$rs['file_name_all'] = $rs['file_name'].$tmp_ext;
				$rs['file_name'] = cutstr($rs['file_name'].$tmp_ext,35);
				$rs['file_size'] = get_size($rs['file_size']);
				$rs['file_time'] = date("Y-m-d",$rs['file_time']);
				$rs['a_downfile'] = urr("downfile","file_id={$rs['file_id']}&file_key={$rs['file_key']}");
				$rs['a_viewfile'] = urr("viewfile","file_id={$rs['file_id']}");
				$rs['status_txt'] = '<span class="txtblue">'.$L['common_status'].'</span>';
				$rs['owner'] = '<a href="'.urr("space","username=".rawurlencode($rs['username'])).'" target="_blank">'.$rs['username'].'</a>';
				$rs2 = $db->fetch_one_array("select u.userid,username from {$tpf}reports r, {$tpf}users u where r.userid=u.userid and r.file_id='{$rs['file_id']}'");
				$rs['reporter'] = $rs2['username'] ? '<a href="'.urr("space","username=".rawurlencode($rs2['username'])).'" target="_blank">'.$rs2['username'].'</a>' : '--';
				$rs['reason'] = str_replace("\r\n",' ',preg_replace("/<.+?>/i","",$rs2['content']));
				$files_array[] = $rs;
			}
			$db->free($q);
			unset($rs);
			$page_nav = multi($total_num, $perpage, $pg, urr("admincp","item=$item&action=$action"));
			require_once template_echo($item,$admin_tpl_dir,'',1);
		}
		
	break;
	
	case 'system':
		
		$title = $L['report_system_title'];
		$tips = $L['report_system_tips'];
		$op_action = $L['locked'];
		
		if($task){
			$file_ids = gpc('file_ids','P',array());
			
			$ids_arr = get_ids_arr($file_ids,$L['please_select_operation_files']);
			if($ids_arr[0]){
				$error = true;
				$sysmsg[] = $ids_arr[1];
			}else{
				$file_str = $ids_arr[1];
			}
		}
		
		if($task =='change_status'){
			if($p_formhash != formhash()){
				exit($L['system_error']);
			}

			if($settings['online_demo']){
				$error = true;
				$sysmsg[] = $L['online_demo_deny'];
			}
			if(!$error){
				$db->query_unbuffered("update {$tpf}files set report_status=0,is_locked=1 where file_id in ($file_str)");
				$sysmsg[] = $L['locked_file_success'];
				redirect($_SERVER['HTTP_REFERER'],$sysmsg);
			}else{
				redirect('back',$sysmsg);
			}	
		}elseif($task =='delete'){
			if($p_formhash != formhash()){
				exit($L['system_error']);
			}
			if($settings['online_demo']){
				$error = true;
				$sysmsg[] = $L['online_demo_deny'];
			}
			if(!$error){
				delete_phpdisk_file("select * from {$tpf}files where file_id in ($file_str)");	
				$db->query_unbuffered("delete from {$tpf}files where file_id in ($file_str)");
				super_cache('file','syn_folder_size',1,0,$pd_uid,$settings['cache_time']);
				$sysmsg[] = $L['delete_file_success'];
				redirect($_SERVER['HTTP_REFERER'],$sysmsg);
			}else{
				redirect('back',$sysmsg);
			}
		}else{
			$sql_ext = "{$tpf}files fl,{$tpf}users u where fl.userid=u.userid and report_status=2 and fl.is_locked=0";
			$rs = $db->fetch_one_array("select count(*) as total_num from {$sql_ext}");
			$total_num = $rs['total_num'];
			$start_num = ($pg-1) * $perpage;
			
			$q = $db->query("select * from {$sql_ext} order by file_id desc limit $start_num,$perpage");
			$files_array = array();
			while($rs = $db->fetch_array($q)){
				$tmp_ext = $rs['file_extension'] ? '.'.$rs['file_extension'] : "";
				$rs['file_thumb'] = get_file_thumb($rs);
				$rs['file_name_all'] = $rs['file_name'].$tmp_ext;
				$rs['file_name'] = cutstr($rs['file_name'].$tmp_ext,35);
				$rs['file_size'] = get_size($rs['file_size']);
				$rs['file_time'] = date("Y-m-d",$rs['file_time']);
				$rs['a_downfile'] = urr("downfile","file_id={$rs['file_id']}&file_key={$rs['file_key']}");
				$rs['a_viewfile'] = urr("viewfile","file_id={$rs['file_id']}");
				$rs['status_txt'] = '<span class="txtblue">'.$L['common_status'].'</span>';
				$rs['owner'] = '<a href="'.urr("space","username=".rawurlencode($rs['username'])).'" target="_blank">'.$rs['username'].'</a>';
				$rs2 = $db->fetch_one_array("select u.userid,username,r.id,content from {$tpf}reports r, {$tpf}users u where r.userid=u.userid and r.file_id='{$rs['file_id']}'");
				$rs['reporter'] = $rs2['username'] ? '<a href="'.urr("space","username=".rawurlencode($rs2['username'])).'" target="_blank">'.$rs2['username'].'</a>' : '--';
				$rs['reason'] = str_replace("\r\n",' ',preg_replace("/<.+?>/i","",$rs2['content']));
				$rs['id'] = $rs2['id'];
				unset($rs2);
				$files_array[] = $rs;
			}
			$db->free($q);
			unset($rs);
			$page_nav = multi($total_num, $perpage, $pg, urr("admincp","item=$item&action=$action"));
			require_once template_echo($item,$admin_tpl_dir,'',1);
		}
		
	break;
	
	case 'file_unlocked':
		
		$title = $L['report_unlocked_title'];
		$tips = $L['report_unlocked_tips'];
		$op_action = $L['unlocked'];
		
		if($task){
			$file_ids = gpc('file_ids','P',array());
			
			$ids_arr = get_ids_arr($file_ids,$L['please_select_operation_files']);
			if($ids_arr[0]){
				$error = true;
				$sysmsg[] = $ids_arr[1];
			}else{
				$file_str = $ids_arr[1];
			}
		}
		
		if($task =='change_status'){
			if($p_formhash != formhash()){
				exit($L['system_error']);
			}
			if($settings['online_demo']){
				$error = true;
				$sysmsg[] = $L['online_demo_deny'];
			}
			if(!$error){
				$db->query_unbuffered("update {$tpf}files set is_locked=0 where file_id in ($file_str)");
				$sysmsg[] = $L['unlocked_file_success'];
				redirect($_SERVER['HTTP_REFERER'],$sysmsg);
			}else{
				redirect('back',$sysmsg);
			}	
		}elseif($task =='delete'){
			if($p_formhash != formhash()){
				exit($L['system_error']);
			}
			if($settings['online_demo']){
				$error = true;
				$sysmsg[] = $L['online_demo_deny'];
			}
			if(!$error){
				delete_phpdisk_file("select * from {$tpf}files where file_id in ($file_str)");	
				$db->query_unbuffered("delete from {$tpf}files where file_id in ($file_str)");
				super_cache('file','syn_folder_size',1,0,$pd_uid,$settings['cache_time']);
				$sysmsg[] = $L['delete_file_success'];
				redirect($_SERVER['HTTP_REFERER'],$sysmsg);
			}else{
				redirect('back',$sysmsg);
			}
		}else{
			$sql_ext = "{$tpf}files fl,{$tpf}users u where u.userid=fl.userid and fl.is_locked=1";
			$rs = $db->fetch_one_array("select count(*) as total_num from {$sql_ext}");
			$total_num = $rs['total_num'];
			$start_num = ($pg-1) * $perpage;
			
			$q = $db->query("select * from {$sql_ext} order by file_id desc limit $start_num,$perpage");
			$files_array = array();
			while($rs = $db->fetch_array($q)){
				$tmp_ext = $rs['file_extension'] ? '.'.$rs['file_extension'] : "";
				$rs['file_thumb'] = get_file_thumb($rs);
				$rs['file_name_all'] = $rs['file_name'].$tmp_ext;
				$rs['file_name'] = cutstr($rs['file_name'].$tmp_ext,35);
				$rs['file_size'] = get_size($rs['file_size']);
				$rs['file_time'] = date("Y-m-d",$rs['file_time']);
				$rs['a_downfile'] = urr("downfile","file_id={$rs['file_id']}&file_key={$rs['file_key']}");
				$rs['a_viewfile'] = urr("viewfile","file_id={$rs['file_id']}");
				$rs['status_txt'] = '<span class="txtred">'.$L['locked_status'].'</span>';
				$rs['owner'] = '<a href="'.urr("space","username=".rawurlencode($rs['username'])).'" target="_blank">'.$rs['username'].'</a>';
				$rs2 = $db->fetch_one_array("select username from {$tpf}reports r, {$tpf}users u where r.userid=u.userid and r.id='{$rs['id']}'");
				$rs['reporter'] = $rs2['username'] ? '<a href="'.urr("space","username=".rawurlencode($rs['username'])).'" target="_blank">'.$rs2['username'].'</a>' : '--';
				$files_array[] = $rs;
			}
			$db->free($q);
			unset($rs);
			$page_nav = multi($total_num, $perpage, $pg, urr("admincp","item=$item&action=$action"));
			require_once template_echo($item,$admin_tpl_dir,'',1);
		}
	break;
	
	default:
		
		if($task =='update'){
			if($p_formhash != formhash()){
				exit($L['system_error']);
			}
			
			$setting = array(
				'open_report' => 0,
				'report_word' => '',
			);
			$settings = gpc('setting','P',$setting);
			
			if($settings['report_word']){
				$report_word = str_replace('',',',$settings['report_word']);
				$arr = explode(',',$report_word);
				$str = '';
				for($i=0;$i<count($arr);$i++){
					if(trim($arr[$i])){
						$str .= trim($arr[$i]).',';
					}
				}
				$settings['report_word'] = substr($str,0,-1);
			}	

			if(!$error){
				
				settings_cache($settings);
				
				$sysmsg[] = $L['report_success'];
				redirect(urr("admincp","item=$item&action=$action"),$sysmsg);
				
			}else{
				redirect('back',$sysmsg);
			}
		}else{
			$setting = $settings;
			require_once template_echo($item,$admin_tpl_dir,'',1);
		}
}
?>