/*
Ext.extend继承
Ext.extend(要继承的Ext父类,子类自定义配置信息)
*/

loginWin = Ext.extend(Ext.Window,
{
	//子类的构造函数，参数为示例化子类时传入自定义配置信息
	constructor:function(config){
		var myConfig = Ext.apply(
			{
				//指定子类的默认属性
				draggable:true,              //允许拖动
				modal:false,                 //显示不对后面一切内容遮罩
				closable:true,               //允许关闭
				closeAction:'hide',           //关闭执行的操作
				width:100,
				height:100,
                                items:[login_form=new Ext.FormPanel({

            labelWidth: 75,
            frame:true,
            monitorValid: true,
            baseCls: 'x-plain',
            defaults: {width:150},
            defaultType: 'textfield',
            items: [{
                    xtype: 'fieldset',
                    autoHeight: true,
                    width: 370,
                    defaults: {width: 200},
                    defaultType: 'textfield',
                    items: [{
                        fieldLabel: '用户名',
                        name: 'username',
                        allowBlank: false,
                        blankText: '用户名不能为空'
                    }, {
                        fieldLabel: '密　码',
                        inputType:'password',
                        name: 'password',
                        allowBlank: false,
                        blankText: '密码不能为空'
                    }]
                }
            ],
            buttons: [{
                text: '登录',
                handler: function() {
                    if (login_form.getForm().isValid()) {
                        this.disabled = true;
                        login_form.getForm().doAction('submit', {
                            url: 'admin/user.php?cmd=login',
                            method: 'post',
                            success: function(login_form, action) {
                                Ext.MessageBox.alert('登录', "登录成功！");
                                //loginWin.hide();
                                window.location="index.php";
                                //$(".userpanal").html("<span class='red'>"+action.result.msg+"</span> , 欢迎您回来！");
                            },
                            failure: function() {
                                Ext.MessageBox.alert('错误', '登录失败！');
                                //loginWin.hide();
                                window.location="index.php";
                            }
                        })
                    }
                }
            }, {
                text: '重置',
                handler: function() {
                    login_form.getForm().reset();
                }
            }]
        })]
			},
			config          //为实例化My.Control.Window(...)时接收到得新配置项，将覆盖子类默认属性
		);


		//调用父类构造函数，用子类配置项去完成初始化
		loginWin.superclass.constructor.call(this,myConfig);
	},

	//子类自定义方法
	myAlert:function(config){
		alert("我是子类My.Control.Window，我派生于Ext.Window，这是我的方法");
	},

	//子类重写show()方法
	show:function(){
		//alert("子类重写show()方法");
		//this.show();       将无限递归调用^-^
		//调用父类中的show方法显示My.Control.Window
		loginWin.superclass.show.call(this);
	}
}
);




/*
实例化子类对象
var myW = new loginWin({
	title:'实例化子类My.Control.Window',         //此处将添加到子类的默认配置属性中
	modal:true        //此处配置属性将覆盖子类中定义的默认配置属性modal:false
});*/
