<?php
/**
* Lite Publisher
* Copyright (C) 2010 - 2013 Vladimir Yushko http://litepublisher.ru/ http://litepublisher.com/
* Dual licensed under the MIT (mit.txt)
* and GPL (gpl.txt) licenses.
**/

class tplugingenerator extends tsinglemenu {
  
  public static function i($id = 0) {
    return self::iteminstance(__class__, $id);
  }
  
  protected function create() {
    parent::create();
    $this->cache = false;
  }
  
  public function processform() {
    if (!isset($_POST['name'])) return '';
    $this->sendfile();
    return '';
  }
  
  public function sendfile() {
    $name = trim($_POST['name']);
    if ($name == '') $name = 'plugin';
    $path = "plugins/$name/";
    $args = new targs();
    $args->name = $name;
    if (isset($_POST['hasadmin'])) {
      $args->adminclass = "admin$name";
      $args->adminfile = "admin.$name.plugin.php";
    } else {
      $args->adminclass = '""';
      $args->adminfile = '""';
    }
    
    $dir = litepublisher::$paths->plugins . 'plugingenerator' .DIRECTORY_SEPARATOR . 'res' . DIRECTORY_SEPARATOR;
    $theme = ttheme::i();
    
    litepublisher::$classes->include_file(litepublisher::$paths->libinclude . 'zip.lib.php');
    $zip = new zipfile();
    $zip->addFile('Deny from all', $path . '.htaccess');
    $zip->addFile(' ', $path . 'index.htm');
    
    $s = tfilestorage::getfile($dir . 'about.ini');
    $s = $theme->parsearg($s, $args);
    $zip->addFile($s, $path . 'about.ini');
    
    $s = tfilestorage::getfile($dir . 'plugin.php');
    $s = $theme->parsearg($s, $args);
    $zip->addFile($s, $path . "$name.plugin.php");
    
    $s = tfilestorage::getfile($dir . 'plugin.install.php');
    $s = $theme->parsearg($s, $args);
    $zip->addFile($s, $path . "$name.plugin.install.php");
    
    if (isset($_POST['hasadmin'])) {
      $s = tfilestorage::getfile($dir . 'admin.plugin.php');
      $s = $theme->parsearg($s, $args);
      $zip->addFile($s, $path . "admin.$name.plugin.php");
    }
    
    $result = $zip->file();
    
    if (ob_get_level()) @ob_end_clean ();
    header('HTTP/1.1 200 OK', true, 200);
    header('Content-type: application/octet-stream');
    header('Content-Disposition: attachment; filename=' . $name . '.plugin.zip');
    header('Content-Length: ' .strlen($result));
    header('Last-Modified: ' . date('r'));
    Header( 'Cache-Control: no-cache, must-revalidate');
    Header( 'Pragma: no-cache');
    
    echo $result;
    exit();
  }
  
}//class