<?php
/**
	* 黄页类
	* @author muhongwei
	* @copyright			(C) 2009-2012 DirCMS
	* @lastmodify			2012-03-11 12:27
*/

class yp
{
	public $pagestring='';
	private $db;
	private $memobj;
	private $table;
	private $member_table;
	private $member_cache_table;
	private $company_table;
	private $comment_table;
	private $news_table;
	private $discount_table;
	private $product_table;
	private $producttype_table;

	function __construct()
	{
		global $db;
		$this->db=$db;
		$this->table=DB_PRE.'yp';
		$this->member_table=DB_PRE.'member';
		$this->member_cache_table=DB_PRE.'member_cache';
		$this->company_table=DB_PRE.'company';
		$this->comment_table=DB_PRE.'yp_comment';
		$this->news_table=DB_PRE.'yp_news';
		$this->product_table=DB_PRE.'yp_product';
		$this->producttype_table=DB_PRE.'yp_producttype';
		$this->discount_table=DB_PRE.'yp_discount';

		include_once DIRCMS_ROOT.'member/include/member.class.php';
		$this->memobj=new member();
	}

	function yp()
	{
		$this->__construct();
	}
	
	/*
		黄页配置
	*/
	function setting($config)
	{
		if(!is_array($config)) return false;
		$configfile = substr(dirname(__FILE__),0,-8).'/data/config.inc.php';
		if(!is_writable($configfile)) fatal_error('Please chmod ./data/config.inc.php to 0777 !');
		$pattern = $replacement = array();

		foreach($config as $k=>$v)
		{
			$pattern[$k] = "/define\(\s*['\"]".strtoupper($k)."['\"]\s*,\s*([']?)[^']*([']?)\s*\)/is";
			$replacement[$k] = "define('".strtoupper($k)."', \${1}".$v."\${2})";
		}
		$str = file_get_contents($configfile);
		$str = preg_replace($pattern, $replacement, $str);
		return file_put_contents($configfile, $str);
	}

	/*	
		黄页操作
	*/
	function yplist($k='',$typeid=0,$pagesize=15)
	{
		global $page;
		include DIRCMS_ROOT.'include/datalist.class.php';
		$datalist = new datalist();
		$where='siteid='.SITEID;
		$where.=$typeid?' AND typeid='.intval($typeid):'';
		$where.=$k?' AND name LIKE \'%'.strip_tags(trim($k)).'%\'':'';
		$orderby='id DESC';
		$page=max(isset($page)?intval($page):1,1);
		$result=$datalist->getlist($this->table,$where,$orderby,$page,intval($pagesize));
		$this->pagestring=$datalist->pagestring;
		return $result;
	}

	function add($info)
	{
		global $_userid,$_roleid,$_point;

		if(!$_userid && !$_roleid)
		{
			return false;
		}

		$about=$info['about'];
		$info['siteid']=SITEID;
		$info=array_map('htmlspecialchars',$info);
		$info['password']=PWD($info['password']);
		$info['about']=$about;
		$info['modelid']=2;
		$info['businesslicense']=0;
		$info['identitycard']=0;
		$info['visits']=0;
		$info['status']=$_roleid || !YP_CHECK?1:0;
		$info['template']=$info['template']?$info['template']:'default';
		$info['seo']=floatval($info['seo']);

		if($_roleid)
		{
			$memberid=$this->memobj->add($info);
			$info['score']=5;
		}
		else
		{
			$memberid=$_userid;
			$info['score']=$_point;
			$info['istop']=0;
			$info['seo']=min($_point,floatval($info['seo']));
		}

		/*
			扣除用户积分
		*/
		$this->db->update($this->member_table,array('point'=>max(0,intval($_point-$info['seo']))),'id='.intval($memberid));

		$info['memberid']=$memberid;
		$info['opentime']=TIME;		
		
		$info['domain']=is_url($info['domain']) && strtolower($info['domain'])!='http://'?$info['domain']:SITE_URL.'yp/web/';

		if(!$info['domain'] || $info['domain']==SITE_URL.'yp/web/')
		{
			$info['url']='yp/web/index.php?u='.$info['dir'].'&siteid='.SITEID;
		}
		else
		{
			$info['url']=$info['domain'];
		}
		return $insertid=$this->db->insert($this->table,$info);
	}

	function edit($info,$id,$userid)
	{
		global $_userid,$_roleid,$_point;

		if(!$_userid && !$_roleid)
		{
			return false;
		}
		
		$about=$info['about'];
		$info=array_map('htmlspecialchars',$info);
		$info['siteid']=SITEID;
		$info['about']=$about;
		$info['status']=($_roleid || !YP_CHECK)?1:0;

		$info['template']=$info['template']?$info['template']:'default';

		if($_roleid)
		{
			$memberid=intval($userid);
		}
		else
		{
			$memberid=$_userid;
			$info['seo']=min($_point,floatval($info['seo']));
		}

		/*
			扣除用户积分
		*/
		$ypinfo=$this->ypinfo($id);
		if($info['seo']!=$ypinfo['seo'])
		{
			$this->db->update($this->member_table,array('point'=>max(0,intval($_point-$info['seo']))),'id='.intval($memberid));
			$this->db->update($this->member_cache_table,array('point'=>max(0,intval($_point-$info['seo']))),'id='.intval($memberid));
		}

		$info['memberid']=$memberid;

		$info['domain']=is_url($info['domain']) && strtolower($info['domain'])!='http://'?$info['domain']:SITE_URL.'yp/web/';

		if(!$info['domain'] || $info['domain']==SITE_URL.'yp/web/')
		{
			$info['url']='yp/web/index.php?u='.$info['dir'].'&siteid='.SITEID;
		}
		else
		{
			$info['url']=$info['domain'];
		}
		unset($info['score'],$info['dir'],$info['businesslicense'],$info['identitycard'],$info['visits']);

		
		if($this->db->update($this->table,$info,'id='.$id))
		{
			$this->db->update($this->news_table,array('ypname'=>$info['name'],'ypurl'=>$info['url'],'ypdomain'=>$info['domain']),'ypid='.$id);
			$this->db->update($this->discount_table,array('ypname'=>$info['name'],'ypurl'=>$info['url'],'ypdomain'=>$info['domain']),'ypid='.$id);
			$this->db->update($this->product_table,array('ypname'=>$info['name'],'ypurl'=>$info['url'],'ypdomain'=>$info['domain']),'ypid='.$id);
			return true;
		}
		else
		{
			return false;
		}
	}

	function close($ids,$status)
	{
		$ids=is_array($ids)?array_map('intval',$ids):array(intval($ids));
		if(!$ids) return false;

		foreach($ids as $id)
		{
			$this->db->update($this->table,array('status'=>intval($status)),'id='.$id);
		}
		return true;
	}

	function settop($ids,$istop)
	{
		$ids=is_array($ids)?array_map('intval',$ids):array(intval($ids));
		if(!$ids) return false;

		foreach($ids as $id)
		{
			$this->db->update($this->table,array('istop'=>intval($istop)),'id='.$id);
		}
		return true;
	}

	function allinfo($ypid,$iscache=true)
	{
		$ypid=intval($ypid);
		return $this->ypinfo($ypid,'*',$iscache);
	}
	
	function ypinfobyu($u)
	{
		$u=preg_replace('/[^a-z0-9_]/i','',$u);
		return $this->db->fetch_one("SELECT * FROM `{$this->table}` WHERE `{$this->table}`.`dir`='{$u}'");
	}

	function ypinfo($id,$fields = '*',$iscache=true)
	{
		global $cache;
		$sql="SELECT {$fields} FROM `{$this->table}` WHERE `{$this->table}`.`id`=".intval($id);

		if($iscache)
		{
			$result=$cache->get($sql);
		}
		else
		{
			$result=false;
		}

		if(!$result)
		{
			$result=$this->db->fetch_one($sql);
			if(isset($result['menu']))$result['menu']=string2array($result['menu']);
			$cache->set($sql,$result);
		}
		return $result;
	}

	function setdomain($name,$url,$domain)
	{
		global $_userid;
		$info=$menu=array();
		foreach($name as $key => $n)
		{
			$menu[$n]=$url[$key];
		}
		$info['menu']=var_export($menu,true);
		$info['domain']=is_url($info['domain'])?$info['domain']:'';

		$r=$this->db->fetch_one("SELECT `id` FROM `$this->table` WHERE `$this->table`.`memberid`=".$_userid);
		$this->db->update($this->news_table,array('ypdomain'=>$info['domain']),'ypid='.$r['id']);
		$this->db->update($this->product_table,array('ypdomain'=>$info['domain']),'ypid='.$r['id']);
		$this->db->update($this->discount_table,array('ypdomain'=>$info['domain']),'ypid='.$r['id']);
		return $this->db->update($this->table,$info,'memberid='.$_userid);
	}

	function getyp($fieldvalue,$fieldname='id')
	{
		if($fieldname!='typeid')
		{
			return $this->db->fetch_all("SELECT * FROM `{$this->table}` WHERE `{$this->table}`.`$fieldname`='$fieldvalue' AND `{$this->table}`.`status`=1");
		}
		else
		{
			$ar=array(intval($fieldvalue));
			$r=cache_read('stepselect_enumyp_id.cache.php',DIRCMS_ROOT.'data/c/');
			if($r)foreach($r as $_r)
			{
				if($_r['parentid']==$fieldvalue)
				{
					$ar[]=intval($_r['id']);
				}
			}
			return $this->db->fetch_all("SELECT * FROM `{$this->table}` WHERE `{$this->table}`.`$fieldname` IN (".implode(',',$ar).") AND `{$this->table}`.`status`=1");
		}
	}

	function getoneyp($fieldvalue,$fieldname='id')
	{
		if($fieldname!='typeid')
		{
			return $this->db->fetch_one("SELECT * FROM `{$this->table}` WHERE `{$this->table}`.`$fieldname`='$fieldvalue'");
		}
		else
		{
			$ar=array(intval($fieldvalue));
			$r=cache_read('stepselect_enumyp_id.cache.php',DIRCMS_ROOT.'data/c/');
			if($r)foreach($r as $_r)
			{
				if($_r['parentid']==$fieldvalue)
				{
					$ar[]=intval($_r['id']);
				}
			}
			return $this->db->fetch_one("SELECT * FROM `{$this->table}` WHERE `{$this->table}`.`$fieldname` IN (".implode(',',$ar).")");
		}
	}

	function userypinfo($userid,$fields = '*')
	{
		global $cache;
		$sql="SELECT {$fields} FROM `{$this->table}` WHERE `{$this->table}`.`memberid`=".intval($userid);
		$result=$cache->get($sql);

		if(!$result)
		{
			$result=$this->db->fetch_one($sql);
			if(isset($result['menu']))$result['menu']=string2array($result['menu']);
			$cache->set($sql,$result);
		}
		return $result;
	}

	function set($ids,$data)
	{
		$ids=is_array($ids)?array_map('intval',$ids):array(intval($ids));
		if(!$ids) return false;

		foreach($ids as $id)
		{
			$this->db->update($this->table,$data,'id='.$id);
		}
		return true;
	}

	function checkdir($dir)
	{
		return preg_match('/[0-9a-z_]{1,32}/i',$dir) && !$this->getoneyp($dir,'dir');
	}

	function setyp($info)
	{
		global $_userid;
		$ypinfo=$this->getoneyp($_userid,'memberid');
		return $ypinfo?$this->edit($info,$ypinfo['id'],$_userid):$this->add($info);
	}

	/*
		企业新闻
	*/

	function newslist($ypid=0,$k='',$pagesize=15)
	{
		$ypid=intval($ypid);
		global $page;
		include DIRCMS_ROOT.'include/datalist.class.php';
		$datalist = new datalist();
		$where='siteid='.SITEID;
		$where.=$ypid?' AND ypid='.$ypid:'';

		$where.=$k?' AND title LIKE \'%'.strip_tags(trim($k)).'%\'':'';
		$orderby='id DESC';
		$page=max(isset($page)?intval($page):1,1);
		$result=$datalist->getlist($this->news_table,$where,$orderby,$page,intval($pagesize));
		$this->pagestring=$datalist->pagestring;
		return $result;
	}

	function newsinfo($id,$fields = '*')
	{
		global $cache;
		$sql="SELECT {$fields} FROM `{$this->news_table}` WHERE `{$this->news_table}`.`id`=".intval($id);
		$result=$cache->get($sql);

		if(!$result)
		{
			$result=$this->db->fetch_one($sql);
			$cache->set($sql,$result);
		}
		return $result;
	}

	function setnews($id,$data)
	{
		return $this->db->update($this->news_table,$data,'id='.$id);
	}

	function news_add($info)
	{
		global $_userid,$_roleid;
		$content=safehtml($info['content'],4);
		$info=array_map('htmlspecialchars',$info);
		$info['siteid']=SITEID;
		$info['content']=$content;

		if($_roleid)
		{
			$ypinfo=$this->ypinfo($info['ypid'],'*');
		}
		else
		{
			$ypinfo=$this->userypinfo($_userid,'*');
			$info['ypid']=$ypinfo['id'];
		}
		$info['areaid']=$ypinfo['areaid'];
		$info['inputtime']=TIME;
		$info['ypname']=$ypinfo['name'];
		$info['ypurl']=$ypinfo['url'];
		$info['ypdomain']=$ypinfo['domain'];
		$info['author']=$ypinfo['author']?$ypinfo['author']:$info['ypname'];
		return $this->db->insert($this->news_table,$info);
	}

	function news_edit($info,$id)
	{
		global $_userid,$_roleid,$cache;
		$id=intval($id);
		$newsinfo=$this->newsinfo($id);
		$ypinfo=$this->ypinfo($newsinfo['ypid']);
		$info['areaid']=$ypinfo['areaid'];
		$info['ypname']=$ypinfo['name'];
		$info['ypurl']=$ypinfo['url'];
		$info['ypdomain']=$ypinfo['domain'];
		if($_userid!=$ypinfo['memberid'] && !$_roleid)
		{	
			return false;
		}

		$content=safehtml($info['content'],4);
		$info=array_map('htmlspecialchars',$info);
		$info['content']=$content;
		$info['siteid']=SITEID;
		$cache->clear();
		return $this->db->update($this->news_table,$info,'id='.intval($id));
	}
	
	function news_delete($ids)
	{
		global $_userid ,$_roleid;
		$ids=is_array($ids)?array_map('intval',$ids):array(intval($ids));
		if(!$ids) return false;

		foreach($ids as $id)
		{
			$newsinfo=$this->newsinfo($id);
			$ypinfo=$this->ypinfo($newsinfo['ypid']);

			if($ypinfo['memberid']==$_userid || $_roleid==1)
			{
				$this->db->mysql_delete($this->news_table,$id);
			}
		}
		return true;
	}

	/*
		优惠信息
	*/
	function discounttype($ypid,$parentid=0)
	{
		return $this->db->fetch_all("SELECT * FROM `$this->discounttype_table` WHERE `$this->discounttype_table`.`ypid`=".intval($ypid)." AND `$this->discounttype_table`.`parentid`=".intval($parentid));
	}

	function discounttypeinfo($id)
	{
		$r=$this->db->fetch_one("SELECT * FROM `$this->discounttype_table` WHERE `$this->discounttype_table`.`id`=".intval($id));
		return $r?$r['name']:'Unkonwn';
	}

	function discountlist($ypid=0,$k='',$pagesize=15)
	{
		$ypid=intval($ypid);
		global $page;
		include DIRCMS_ROOT.'include/datalist.class.php';
		$datalist = new datalist();
		$where='siteid='.SITEID;
		$where.=$ypid?' AND ypid='.$ypid:'';

		$where.=$k?' AND title LIKE \'%'.strip_tags(trim($k)).'%\'':'';
		$orderby='id DESC';
		$page=max(isset($page)?intval($page):1,1);
		$result=$datalist->getlist($this->discount_table,$where,$orderby,$page,intval($pagesize));
		$this->pagestring=$datalist->pagestring;
		return $result;
	}

	function discountinfo($id,$fields = '*')
	{
		global $cache;
		$sql="SELECT {$fields} FROM `{$this->discount_table}` WHERE `{$this->discount_table}`.`id`=".intval($id);
		$result=$cache->get($sql);

		if(!$result)
		{
			$result=$this->db->fetch_one($sql);
			$cache->set($sql,$result);
		}
		return $result;
	}

	function setdiscount($id,$data)
	{
		return $this->db->update($this->discount_table,$data,'id='.$id);
	}

	function discount_add($info)
	{
		global $_userid,$_roleid;
		$content=safehtml($info['content'],4);
		$info=array_map('htmlspecialchars',$info);
		$info['siteid']=SITEID;
		$info['content']=$content;

		if($_roleid)
		{
			$ypinfo=$this->ypinfo($info['ypid'],'*');
		}
		else
		{
			$ypinfo=$this->userypinfo($_userid,'*');
			$info['ypid']=$ypinfo['id'];
		}
		$info['thumb']=is_image($info['thumb'])?$info['thumb']:'';
		$info['areaid']=$ypinfo['areaid'];
		$info['inputtime']=TIME;
		$info['start']=strtotime($info['start']);
		$info['end']=strtotime($info['end']);
		$info['ypname']=$ypinfo['name'];
		$info['ypurl']=$ypinfo['url'];
		$info['ypdomain']=$ypinfo['domain'];
		$info['author']=$ypinfo['author']?$ypinfo['author']:$info['ypname'];
		return $this->db->insert($this->discount_table,$info);
	}

	function discount_edit($info,$id)
	{
		global $_userid,$_roleid,$cache;
		$id=intval($id);
		$discountinfo=$this->discountinfo($id);
		$ypinfo=$this->ypinfo($discountinfo['ypid']);
		$info['areaid']=$ypinfo['areaid'];
		$info['ypname']=$ypinfo['name'];
		$info['ypurl']=$ypinfo['url'];
		$info['ypdomain']=$ypinfo['domain'];
		if($_userid!=$ypinfo['memberid'] && !$_roleid)
		{	
			return false;
		}

		$content=safehtml($info['content'],4);
		$info=array_map('htmlspecialchars',$info);
		$info['content']=$content;

		$info['thumb']=is_image($info['thumb'])?$info['thumb']:'';
		$info['areaid']=$ypinfo['areaid'];
		$info['start']=strtotime($info['start']);
		$info['end']=strtotime($info['end']);
		$info['siteid']=SITEID;
		$cache->clear();
		return $this->db->update($this->discount_table,$info,'id='.intval($id));
	}
	
	function discount_delete($ids)
	{
		global $_userid ,$_roleid;
		$ids=is_array($ids)?array_map('intval',$ids):array(intval($ids));
		if(!$ids) return false;

		foreach($ids as $id)
		{
			$discountinfo=$this->discountinfo($id);
			$ypinfo=$this->ypinfo($discountinfo['ypid']);

			if($ypinfo['memberid']==$_userid || $_roleid==1)
			{
				$this->db->mysql_delete($this->discount_table,$id);
			}
		}
		return true;
	}

	/*
		企业产品
	*/
	function setproducttype($name,$parentid,$newname)
	{
		global $_userid;
		foreach($name as $id => $n)
		{
			$n=trim(strip_tags($n));
			if($n)
			{
				$this->db->update($this->producttype_table,array('name'=>$n),'id='.intval($id));
			}
		}
		$parentid=intval($parentid);
		$newname=trim(strip_tags($newname));
		if($newname)
		{
			$ypinfo=$this->userypinfo($_userid);
			$info=array();
			$info['name']=$newname;
			$info['parentid']=$parentid;
			$info['siteid']=SITEID;
			$info['ypid']=$ypinfo['id'];
			$this->db->insert($this->producttype_table,$info);
		}
		return true;
	}

	function producttype($ypid,$parentid=0)
	{
		return $this->db->fetch_all("SELECT * FROM `$this->producttype_table` WHERE `$this->producttype_table`.`ypid`=".intval($ypid)." AND `$this->producttype_table`.`parentid`=".intval($parentid));
	}

	function producttypeinfo($id)
	{
		$r=$this->db->fetch_one("SELECT * FROM `$this->producttype_table` WHERE `$this->producttype_table`.`id`=".intval($id));
		return $r?$r['name']:'Unkonwn';
	}

	function productlist($ypid=0,$k='',$pagesize=15)
	{
		$ypid=intval($ypid);
		global $page;
		include DIRCMS_ROOT.'include/datalist.class.php';
		$datalist = new datalist();
		$where='siteid='.SITEID;
		$where.=$ypid?' AND ypid='.$ypid:'';

		$where.=$k?' AND title LIKE \'%'.strip_tags(trim($k)).'%\'':'';
		$orderby='id DESC';
		$page=max(isset($page)?intval($page):1,1);
		$result=$datalist->getlist($this->product_table,$where,$orderby,$page,intval($pagesize));

		if($result)foreach($result as $key => $_result)
		{
			$ypinfo=$this->ypinfo($_result['ypid']);
			$result[$key]['yp']=$ypinfo['name'];
		}
		$this->pagestring=$datalist->pagestring;
		return $result;
	}

	function productinfo($id,$fields = '*')
	{
		global $cache;
		$sql="SELECT {$fields} FROM `{$this->product_table}` WHERE `{$this->product_table}`.`id`=".intval($id);
		$result=$cache->get($sql);

		if(!$result)
		{
			$result=$this->db->fetch_one($sql);
			$cache->set($sql,$result);
		}
		return $result;
	}

	function setproduct($id,$data)
	{
		return $this->db->update($this->product_table,$data,'id='.$id);
	}

	function product_add($info)
	{
		global $_userid,$_roleid;
		$content=safehtml($info['content'],4);
		$info=array_map('htmlspecialchars',$info);
		$info['content']=$content;

		if($_roleid)
		{
			$ypinfo=$this->ypinfo($info['ypid'],'*');
		}
		else
		{
			$ypinfo=$this->userypinfo($_userid,'*');
			$info['ypid']=$ypinfo['id'];
		}
		$info['areaid']=$ypinfo['areaid'];
		$info['inputtime']=TIME;
		$info['ypname']=$ypinfo['name'];
		$info['ypurl']=$ypinfo['url'];
		$info['ypdomain']=$ypinfo['domain'];
		$info['siteid']=SITEID;
		return $this->db->insert($this->product_table,$info);
	}

	function product_edit($info,$id)
	{
		global $_userid,$_roleid,$cache;
		$id=intval($id);
		$productinfo=$this->productinfo($id);
		$ypinfo=$this->ypinfo($productinfo['ypid']);
		$info['areaid']=$ypinfo['areaid'];
		$info['ypname']=$ypinfo['name'];
		if($_userid!=$ypinfo['memberid'] && !$_roleid)
		{	
			return false;
		}
	
		$content=safehtml($info['content'],4);
		$info=array_map('htmlspecialchars',$info);
		$info['content']=$content;
		$info['siteid']=SITEID;
		$cache->clear();
		return $this->db->update($this->product_table,$info,'id='.intval($id));
	}
	
	function product_delete($ids)
	{
		global $_userid ,$_roleid;
		$ids=is_array($ids)?array_map('intval',$ids):array(intval($ids));
		if(!$ids) return false;

		foreach($ids as $id)
		{
			$productinfo=$this->productinfo($id);
			$ypinfo=$this->ypinfo($productinfo['ypid']);

			if($ypinfo['memberid']==$_userid || $_roleid==1)
			{
				$this->db->mysql_delete($this->product_table,$id);
			}
		}
		return true;
	}

	/*
		点评管理
	*/
	function commentlist($ypid=0,$k='',$pagesize=15)
	{
		$ypid=intval($ypid);
		global $page;
		include DIRCMS_ROOT.'include/datalist.class.php';
		$datalist = new datalist();
		$where='siteid='.SITEID;
		$where.=$ypid?' AND ypid='.$ypid:'';
		$where.=$k?' AND content LIKE \'%'.strip_tags(trim($k)).'%\'':'';
		$orderby='id DESC';
		$page=max(isset($page)?intval($page):1,1);
		$result=$datalist->getlist($this->comment_table,$where,$orderby,$page,intval($pagesize));

		if($result)foreach($result as $key => $_result)
		{
			$ypinfo=$this->ypinfo($_result['ypid']);
			$result[$key]['yp']=$ypinfo['name'];
		}
		$this->pagestring=$datalist->pagestring;
		return $result;
	}

	function comment_add($info)
	{
		/*
			计算平均口碑值
		*/
		$info['siteid']=SITEID;
		$ypinfo=$this->ypinfo(intval($info['ypid']));
		return $this->db->insert($this->comment_table,$info);
	}

	function commentinfo($id,$fields = '*')
	{
		global $cache;
		$sql="SELECT {$fields} FROM `{$this->comment_table}` WHERE `{$this->comment_table}`.`id`=".intval($id);
		$result=$cache->get($sql);

		if(!$result)
		{
			$result=$this->db->fetch_one($sql);
			$cache->set($sql,$result);
		}
		return $result;
	}
	
	function comment_delete($ids)
	{
		global $_userid ,$_roleid;
		$ids=is_array($ids)?array_map('intval',$ids):array(intval($ids));
		if(!$ids) return false;

		foreach($ids as $id)
		{
			$commentinfo=$this->commentinfo($id);
			$ypinfo=$this->ypinfo($commentinfo['ypid']);

			if($ypinfo['memberid']==$_userid || $_roleid==1)
			{
				$this->db->mysql_delete($this->comment_table,$id);
			}
		}
		return true;
	}

	function comment_pass($ids,$status=1)
	{
		global $_userid ,$_roleid;
		$ids=is_array($ids)?array_map('intval',$ids):array(intval($ids));
		if(!$ids) return false;

		foreach($ids as $id)
		{
			$commentinfo=$this->commentinfo($id);
			$ypinfo=$this->ypinfo($commentinfo['ypid']);

			if($ypinfo['memberid']==$_userid || $_roleid==1)
			{
				$this->db->update($this->comment_table,array('status'=>intval($status)),'id='.$id);
			}
		}
		return true;
	}

	/*
		黄页模板
	*/
	function settemplate($template='default')
	{
		global $_userid,$cache;
		
		$template=preg_replace('/[^a-z0-9_]/i','',$template);
		if(empty($template))return false;

		$file=TPL_ROOT.TPL_NAME.'/yp/'.$template.'/';
		if(file_exists($file) && is_dir($file) && is_readable($file))
		{
			$this->db->update($this->table,array('template'=>$template),'memberid='.$_userid);
			$cache->clear();
			return true;
		}
		else
		{
			return false;	
		}
	}

/*
	上一篇 下一篇
*/
	function getprecon($id,$type='news')
	{
		$id=intval($id);
		$type=preg_replace('/[^a-z]/i','',strtolower($type));

		if($type=='discount')
		{
			$table=$this->discount_table;
		}
		else if($type=='expert')
		{
			$table=$this->expert_table;
		}
		else if($type=='product')
		{
			$table=$this->product_table;
		}
		else
		{
			$table=$this->news_table;
		}

		$r=$this->db->fetch_one("SELECT * FROM `".$table."` WHERE `".$table."`.`id` < $id LIMIT 0, 1");
		return $r?$r['title']:'没有了';
	}

	function getnextcon($id,$table='news')
	{
		$id=intval($id);
		$type=preg_replace('/[^a-z]/i','',strtolower($type));

		if($type=='discount')
		{
			$table=$this->discount_table;
		}
		else if($type=='expert')
		{
			$table=$this->expert_table;
		}
		else if($type=='product')
		{
			$table=$this->product_table;
		}
		else
		{
			$table=$this->news_table;
		}

		$r=$this->db->fetch_one("SELECT * FROM `".$table."` WHERE `".$table."`.`id` > $id LIMIT 0, 1");
		return $r?$r['title']:'没有了';
	}
}
?>