<?php
/**
	* 在线升级类
	* @author muhongwei
	* @copyright			(C) 2009-2011 DirCMS
	* @lastmodify			2011-10-17 9:50
*/
set_time_limit(0);
ini_set('memory_limit', '256M');

class upgrade
{
	public $msg;

	/*
		检查更新
	*/
	function check($version,$release)
	{
		$patchfile=DIRCMS_DATA.'patch/'.$version.$release.'.zip';
		$patchfile=strtolower($patchfile);

		$msgfile=DIRCMS_DATA.'patch/'.$version.$release.'.txt';
		$msgfile=strtolower($msgfile);

		if(!file_exists_url($patchfile))
		{
			if(!file_exists_url(DIRCMS_DATA))
			{
				return -1;
			}
			else
			{
				if(file_exists($msgfile))
				{
					return -3;
				}
				else
				{
					return -2;
				}
			}
		}
		else
		{
			return true;
		}
	}
	
	/*
		返回文件夹下的所有文件列表
		返回列表数组
	*/
	function listfile($path)
	{
		$result=array();
		if(!$path || !is_dir($path))
		{
			return false;
		}
		else
		{
			$dirs=glob($path.'*');
			if($dirs)
			{
				foreach($dirs as $dir)
				{
					if(is_dir($dir) && $dir)
					{
						$result=array_merge($result,$this->listfile($dir.'/'));
					}
					else
					{
						$result[]=$dir;
					}
				}
			}
			else
			{
				return false;
			}
		}
		return array_unique($result);
	}
	
	/*
		获取补丁包
		返回补丁包路径
	*/
	function getpatch($file)
	{
		global $_userid;
		$content=false;
		if (function_exists('curl_init')) 
		{
			$uri=parse_url($file);
			$curl_handle = curl_init();
			curl_setopt($curl_handle, CURLOPT_URL, $file);
			curl_setopt($curl_handle, CURLOPT_CONNECTTIMEOUT,2);
			curl_setopt($curl_handle, CURLOPT_RETURNTRANSFER,1);
			curl_setopt($curl_handle, CURLOPT_FAILONERROR,1);
			curl_setopt($curl_handle, CURLOPT_REFERER,$uri['scheme'].'://'.$uri['host']);
	  		curl_setopt($curl_handle, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US) AppleWebKit/532.0 (KHTML, like Gecko) Chrome/3.0.195.38 Safari/532.0');
			$content = curl_exec($curl_handle);
			curl_close($curl_handle);
        }
		else if (ini_get('allow_url_fopen') && ($handle  = fopen($file, 'rb'))) 
		{
            if(function_exists('stream_get_contents')) 
			{
                $content= stream_get_contents($handle);
            }
			else 
			{
                while(!feof($handle) && connection_status() == 0) 
				{
                    $content.= fread($handle,8192);
                }
            }
            fclose($handle);
        }
		else 
		{
            $content = file_get_contents(urlencode($file));
        }

		if($content)
		{
			$zipdir=DIRCMS_ROOT.'data/tmp/'.md5($_userid).'/';
			mkdir($zipdir);
			$zipfile=$zipdir.basename($file);
			touch($zipfile);
			$handle=fopen($zipfile,'rb+');
			flock($handle,LOCK_EX);
			fwrite($handle,$content);
			ftruncate($handle,strlen($content));
			flock($fp, LOCK_UN);
			fclose($handle);
			@chmod($zipfile,0777);
			
			include DIRCMS_ROOT.'include/pclzip.lib.php';
			$archive = new PclZip($zipfile);

			if(!$archive->extract(PCLZIP_OPT_PATH,$zipdir,PCLZIP_OPT_ADD_TEMP_FILE_ON))
			{
				return false;
			}
			else
			{
				@unlink($zipfile);
				return $zipdir;
			}
		}
		else
		{
			return false;
		}
	}

	function initdb($config)
	{
		if(!$dlink=mysql_pconnect($config['ver_db_host'],$config['ver_db_user'],$config['ver_db_psw']))
		{
			$this->msg='无法连接数据库主机，请检查主机地址或者用户、密码是否正确!';
			return false;
		}

		if(!mysql_select_db($config['ver_db_name'],$dlink))
		{
			$this->msg='无法选择数据库，请重新检查数据库名称是否正确!';
			return false;
		}

		if(!is_array($config)) return false;
		$configfile = substr(dirname(__FILE__),0,-8).'/data/config.inc.php';
		if(!is_writable($configfile)) fatal_error('Please chmod ./data/config.inc.php to 0777 !');
		$pattern = $replacement = array();

		foreach($config as $k=>$v)
		{
			$pattern[$k] = "/define\(\s*['\"]".strtoupper($k)."['\"]\s*,\s*([']?)[^']*([']?)\s*\)/is";
			$replacement[$k] = "define('".strtoupper($k)."', \${1}".$v."\${2})";
		}
		$str = file_get_contents($configfile);
		$str = preg_replace($pattern, $replacement, $str);
		return file_put_contents($configfile, $str);
	}
}
?>